<?php

class master_model extends CI_Model {

    function get_companies() {
        $this->db->select("*");
        $this->db->where('cust_status', 1);
        $this->db->order_by("cust_name",'ASC');
        $query = $this->db->get(TBL_CUSTOMER);
        return $query->result_array();
    }
    function get_engineer($comp_id) {
        $this->db->select("*");
        $this->db->where('cust_id', $comp_id);
        $this->db->where('eng_status',1);
        $this->db->order_by("eng_fname",'ASC');
        $query = $this->db->get(TBL_ENGINEER);
        return $query->result_array();
    }
    function get_engineer_email($eng_id) {
        $this->db->select("*");
        $this->db->where('eng_id', $eng_id);
        $query = $this->db->get(TBL_ENGINEER);
        $result = $query->row_array();
        return $result['eng_email'].'|'.$result['eng_email2'];
    }
    function get_engineer_id($eng_id) {
        $this->db->select("*");
        $this->db->where('id', $eng_id);
        $query = $this->db->get('mst_p3report');
        return $query->row_array();
    }
    function get_ftp_engineer_id($eng_id) {
        $this->db->select("*");
        $this->db->where('id', $eng_id);
        $query = $this->db->get('mst_ftp');
        return $query->row_array();
    }
    function get_compliance_engineer_id($eng_id) {
        $this->db->select("*");
        $this->db->where('id', $eng_id);
        $query = $this->db->get('mst_compliance');
        return $query->row_array();
    }
    
    function get_p3reports() {
        $this->db->select('p.*,c.cust_name,e.eng_fname,eng_lname');
        $this->db->from('mst_p3report p');
        $this->db->join('tbl_customer c', 'c.cust_id = p.comp_id');
        $this->db->join('tbl_engineer e', 'e.eng_id = p.eng_id');
        $this->db->where('p.status',1);
        $this->db->order_by('p.id','desc');
        //print_r($this->db);exit;
        $query = $this->db->get();
        return $query->result_array();
    }
    function get_ftp() {
        $this->db->select('f.*,c.cust_name,e.eng_fname,eng_lname');
        $this->db->from('mst_ftp f');
        $this->db->join('tbl_customer c', 'c.cust_id = f.comp_id');
        $this->db->join('tbl_engineer e', 'e.eng_id = f.eng_id');
        $this->db->where('f.status',1);
        $query = $this->db->get();
        return $query->result_array();
    }
    function get_compliance() {
        $this->db->select('cm.*,c.cust_name,e.eng_fname,eng_lname');
        $this->db->from('mst_compliance cm');
        $this->db->join('tbl_customer c', 'c.cust_id = cm.comp_id');
        $this->db->join('tbl_engineer e', 'e.eng_id = cm.eng_id');
        $this->db->where('cm.status',1);
        $query = $this->db->get();
        return $query->result_array();
    }
    function insert_engineer($data) {
        $this->db->insert('mst_p3report', $data);
    }
    function update_engineer($data,$id) {
    	$this->db->where('id', $id);
	$this->db->update('mst_p3report', $data); 
    }
    function delete_engineer($id) {
        $this->db->where('id', $id);
        $this->db->delete('mst_p3report');  
    }
    function insert_ftp_engineer($data) {
        $this->db->insert('mst_ftp', $data);
    }
    function update_ftp_engineer($data,$id) {
        $this->db->where('id', $id);
    $this->db->update('mst_ftp', $data); 
    }
    function delete_ftp_engineer($id) {
        $this->db->where('id', $id);
        $this->db->delete('mst_ftp');
    }
    function insert_compliance_engineer($data) {
        $this->db->insert('mst_compliance', $data);
    }
    function update_compliance_engineer($data,$id) {
        $this->db->where('id', $id);
    $this->db->update('mst_compliance', $data); 
    }
    function delete_compliance_engineer($id) {
        $this->db->where('id', $id);
        $this->db->delete('mst_compliance');
    }
/****************************************************************************************************
*
*   This function retrieves email master details from database
*
****************************************************************************************************/
    function get_emailreminders() {
        $this->db->select('p.*,c.cust_name,e.eng_fname,eng_lname');
        $this->db->from('mst_emailreminder p');
        $this->db->join('tbl_customer c', 'c.cust_id = p.comp_id');
        $this->db->join('tbl_engineer e', 'e.eng_id = p.eng_id');
        $this->db->where('p.status',1);
        $this->db->order_by('p.id','desc');
        $query = $this->db->get();
        return $query->result_array();
    }
/****************************************************************************************************
*   
*this function insert new reminder into database
*
****************************************************************************************************/
    function insert_reminder_engineer($data) {
        $this->db->insert('mst_emailreminder', $data);
    }
/****************************************************************************************************
*   
*   This function used to retrieve the reminder from db
*
****************************************************************************************************/
    function get_reminder_engineer_id($eng_id) {
        $this->db->select("*");
        $this->db->where('id', $eng_id);
        $query = $this->db->get('mst_emailreminder');
        return $query->row_array();
    }
/****************************************************************************************************
*   
*   This function used to update the email reminder into database
*
****************************************************************************************************/
    function update_reminder_engineer($data,$id) {
        $this->db->where('id', $id);
        $this->db->update('mst_emailreminder', $data); 
    }
/****************************************************************************************************
*   
*   this function used to delete the email reminder from db
*
****************************************************************************************************/
    function delete_reminder_engineer($id) {
        $this->db->where('id', $id);
        $this->db->delete('mst_emailreminder');
    } 
    


// Tooling


/****************************************************************************************************
*
*   This function retrieves email master details from database
*
****************************************************************************************************/
    function get_tooling_emailreminders() {
        $this->db->select('p.*,c.cust_name,e.eng_fname,eng_lname');
        $this->db->from('mst_tooling_emailreminder p');
        $this->db->join('tbl_customer c', 'c.cust_id = p.comp_id');
        $this->db->join('tbl_engineer e', 'e.eng_id = p.eng_id');
        $this->db->where('p.status',1);
        $this->db->order_by('p.id','desc');
        $query = $this->db->get();
        return $query->result_array();
    }
/****************************************************************************************************
*   
*this function insert new reminder into database
*
****************************************************************************************************/
    function insert_tooling_reminder_engineer($data) {
        $this->db->insert('mst_tooling_emailreminder', $data);
    }
    
/****************************************************************************************************
*   
*   This function used to retrieve the reminder from db
*
****************************************************************************************************/
    function get_tooling_reminder_engineer_id($eng_id) {
        $this->db->select("*");
        $this->db->where('id', $eng_id);
        $query = $this->db->get('mst_tooling_emailreminder');
        return $query->row_array();
    }
/****************************************************************************************************
*   
*   This function used to update the email reminder into database
*
****************************************************************************************************/
    function update_tooling_reminder_engineer($data,$id) {
        $this->db->where('id', $id);
        $this->db->update('mst_tooling_emailreminder', $data); 
    }
    
/****************************************************************************************************
*   
*   this function used to delete the email reminder from db
*
****************************************************************************************************/
    function delete_tooling_reminder_engineer($id) {
        $this->db->where('id', $id);
        $this->db->delete('mst_tooling_emailreminder');
    } 
    
    
    
    
    
    
}
