<?php

class master extends CI_Controller {

    public function __construct() {
        parent::__construct();
    //    $this->load->library('upload');
        $this->load->helper('form');
        $this->load->model('user_model');
        $this->load->model('master_model');
        $this->load->library('ckeditor');
        $this->load->library('ckfinder');
        $this->ckeditor->basePath = base_url() . 'assets/ckeditor/';
        $this->ckeditor->config['toolbar'] = array(
            array('Source', '-', 'Bold', 'Italic', 'Underline', '-', 'Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo', '-', 'NumberedList', 'BulletedList')
            );
        $this->ckeditor->config['language'] = 'english';
        $this->ckeditor->config['width'] = '100%';
        $this->ckeditor->config['height'] = '300px';
        if (!$this->session->userdata('logged_adminin')) {
            redirect('welcome');
        }
        if (!(user_has_right(ADMIN))) {
            redirect('/');
        }
    }

    public function index() {
        $date = date("Y-m-d");
        $this->load->model('order_model');
        $data['engineers'] = $this->master_model->get_p3reports();
        //echo "<pre>";print_r($data);exit;
        $this->template->build("master/p3report_master", $data);
    }

    public function p3report_master() {
        $date = date("Y-m-d");
        $this->load->model('order_model');
        $data['engineers'] = $this->master_model->get_p3reports();
        //echo "<pre>";print_r($data);exit;
        $this->template->build("master/p3report_master", $data);
    }
    public function ftp_master() {
        $date = date("Y-m-d");
        $this->load->model('order_model');
        $data['engineers'] = $this->master_model->get_Ftp();
        //echo "<pre>";print_r($data);exit;
        $this->template->build("master/ftp_master", $data);
    }
    public function compliance_master() {
        $date = date("Y-m-d");
        $this->load->model('order_model');
        $data['engineers'] = $this->master_model->get_compliance();
        //echo "<pre>";print_r($data);exit;
        $this->template->build("master/compliance_master", $data);
    }
    public function add_engineer(){
        $data['companies'] = $this->master_model->get_companies();
        //echo "<pre>";print_r($data);exit;
        $this->load->view("master/addengineer",$data);
    }
    public function compliance_add_engineer(){
        $data['companies'] = $this->master_model->get_companies();
        //echo "<pre>";print_r($data);exit;
        $this->load->view("master/compliance_addengineer",$data);
    }
    public function ftp_add_engineer(){
        $data['companies'] = $this->master_model->get_companies();
        //echo "<pre>";print_r($data);exit;
        $this->load->view("master/ftp_addengineer",$data);
    }
    public function getengineer(){
        $comp_id=$this->input->get('comp_id');
        //print_r($comp_id);exit;
        $data['engineers'] = $this->master_model->get_engineer($comp_id);
        //echo "<pre>";print_r($data);exit;
        $option="<option value=''> Select Engineer </option>";
        foreach ($data['engineers'] as $key => $engineer) {
            //print_r($engineer);exit;
            $option .= "<option value='".$engineer['eng_id']."'>".$engineer['eng_fname']."</option>";

        }
        echo $option;
    }
    public function getengineer_email(){
        $eng_id=$this->input->get('eng_id');
        //print_r($comp_id);exit;
        $data['email'] = $this->master_model->get_engineer_email($eng_id);
        //echo "<pre>";print_r($data);exit;
        echo $data['email'];
    }
    public function insert_engineer(){
        //echo "<pre>";print_r($_POST);exit;
        $email=isset($_POST['mail']) ? 1 : 0 ;
        //print_r($email);exit;
        $comp_id=$_POST['comp_id'];
        $eng_ad_email=implode(',',$_POST['eng_ad_email']);
        $eng_email=$_POST['eng_email'];
        $eng_id=$_POST['eng_id'];
        $file_ext=$_POST['file_ext'];
        if($comp_id==""){
            $error["p3report_comp_id"] = "Please Select Company.";
        }
        if($eng_id==""){
            $error["p3report_eng_id"] = "Please Select Engineer.";
        }
        if(empty($eng_email)){
            $error["p3report_eng_email"] = "Please Enter Email Address.";
        }
        if(empty($file_ext)){
            $error["p3report_file_ext"] = "Please Enter File Extension.";
        }

        if (empty($error)) {
            $data['new_eng']=$_POST;
            $data['new_eng']['eng_ad_email']=implode(',',$data['new_eng']['eng_ad_email']);
            //$data['new_eng']['mail']=isset($_POST['mail']) ? 1 : 0 ; //email functionality based on user selection
            $data['new_eng']['mail']=1;//defaultly mail function enabled
            $data['new_eng']['status']=1;
            $this->master_model->insert_engineer($data['new_eng']);
            $success["status"] = "true";
            $success["message"] = "New Engineer inserted Successfully.";
            echo json_encode($success);
        }else {
            $error["status"] = "false";
            echo json_encode($error);
        }

        
        //echo "<pre>";print_r($data);exit;
    }
    public function update_engineer(){
        $comp_id=$_POST['comp_id'];
        $eng_ad_email=implode(',',$_POST['eng_ad_email']);
        $eng_email=$_POST['eng_email'];
        $eng_id=$_POST['eng_id'];
        $file_ext=$_POST['file_ext'];
        if($comp_id==""){
            $error["p3report_comp_id"] = "Please Select Company.";
        }
        if($eng_id==""){
            $error["p3report_eng_id"] = "Please Select Engineer.";
        }
        if(empty($eng_email)){
            $error["p3report_eng_email"] = "Please Enter Email Address.";
        }
        if(empty($file_ext)){
            $error["p3report_file_ext"] = "Please Enter File Extension.";
        }

        if (empty($error)) {
            //echo "<pre>";print_r($_POST);exit;
            $update_id=$this->input->post('edit_id');
            $data['update_eng']=$_POST;
            $data['update_eng']['eng_ad_email']=implode(',',$data['update_eng']['eng_ad_email']);
            //$data['update_eng']['mail']=isset($_POST['mail']) ? 1 : 0 ; //email functionality based on user selection
            $data['update_eng']['mail']=1;//defaultly mail function enabled
            $data['update_eng']['top_bot_file']=isset($_POST['top_bot_file']) ? 1 : 0 ;
            $data['update_eng']['status']=1;
            unset($data['update_eng']['edit_id']);
            $this->master_model->update_engineer($data['update_eng'],$update_id);
            //echo "<pre>";print_r($data);exit;
            $success["status"] = "true";
            $success["message"] = "New Engineer inserted Successfully.";
            echo json_encode($success);
        }else {
            $error["status"] = "false";
            echo json_encode($error);
        }
    }
    public function edit_engineer(){
    	$eng_id=$this->input->post('eng_id');
        $data['eng'] = $this->master_model->get_engineer_id($eng_id);
        $data['companies'] = $this->master_model->get_companies();
        $data['engineers'] = $this->master_model->get_engineer($data['eng']['comp_id']);
        //echo "<pre>";print_r($data);exit;
        $this->load->view("master/editengineer",$data);
    }
    public function delete_engineer(){
    	$eng_id=$this->uri->segment(3);
    	//print_r($eng_id);exit;
    	$this->master_model->delete_engineer($eng_id);
        //echo "<pre>";print_r($data);exit;
        redirect('master/p3report_master');
        
    }
    public function ftp_insert_engineer(){
        //echo "<pre>";print_r($_POST);exit;
        $comp_id=$_POST['comp_id'];
        $eng_id=$_POST['eng_id'];
        $file_ext=$_POST['file_ext'];
        if($comp_id==""){
            $error["p3report_comp_id"] = "Please Select Company.";
        }
        if($eng_id==""){
            $error["p3report_eng_id"] = "Please Select Engineer.";
        }
        if(empty($file_ext)){
            $error["p3report_file_ext"] = "Please Enter File Extension.";
        }

        if (empty($error)) {
            $data['new_eng']=$_POST;
            $data['new_eng']['mail']=isset($_POST['mail']) ? 1 : 0 ;
            $data['new_eng']['status']=1;
            $this->master_model->insert_ftp_engineer($data['new_eng']);
            $success["status"] = "true";
            $success["message"] = "New Engineer inserted Successfully.";
            echo json_encode($success);
        }else {
            $error["status"] = "false";
            echo json_encode($error);
        }

        
        //echo "<pre>";print_r($data);exit;
    }
    public function edit_ftp_engineer(){
        $eng_id=$this->input->post('eng_id');
        $data['eng'] = $this->master_model->get_ftp_engineer_id($eng_id);
        $data['companies'] = $this->master_model->get_companies();
        $data['engineers'] = $this->master_model->get_engineer($data['eng']['comp_id']);
        //echo "<pre>";print_r($data);exit;
        $this->load->view("master/ftp_editengineer",$data);
    }
    public function ftp_update_engineer(){
        $comp_id=$_POST['comp_id'];
        $eng_id=$_POST['eng_id'];
        $file_ext=$_POST['file_ext'];
        if($comp_id==""){
            $error["p3report_comp_id"] = "Please Select Company.";
        }
        if($eng_id==""){
            $error["p3report_eng_id"] = "Please Select Engineer.";
        }
        if(empty($file_ext)){
            $error["p3report_file_ext"] = "Please Enter File Extension.";
        }

        if (empty($error)) {
            //echo "<pre>";print_r($_POST);exit;
            $update_id=$this->input->post('edit_id');
            $data['update_eng']=$_POST;
            $data['update_eng']['mail']=isset($_POST['mail']) ? 1 : 0 ;
            $data['update_eng']['status']=1;
            unset($data['update_eng']['edit_id']);
            $this->master_model->update_ftp_engineer($data['update_eng'],$update_id);
            //echo "<pre>";print_r($data);exit;
            $success["status"] = "true";
            $success["message"] = "New Engineer inserted Successfully.";
            echo json_encode($success);
        }else {
            $error["status"] = "false";
            echo json_encode($error);
        }
    }
    public function ftp_delete_engineer(){
        $eng_id=$this->uri->segment(3);
        //print_r($eng_id);exit;
        $this->master_model->delete_ftp_engineer($eng_id);
        //echo "<pre>";print_r($data);exit;
        redirect('master/ftp_master');
        
    }
    public function compliance_insert_engineer(){
        //echo "<pre>";print_r($_POST);exit;
        $comp_id=$_POST['comp_id'];
        $eng_id=$_POST['eng_id'];
        $file_ext=$_POST['file_ext'];
        if($comp_id==""){
            $error["p3report_comp_id"] = "Please Select Company.";
        }
        if($eng_id==""){
            $error["p3report_eng_id"] = "Please Select Engineer.";
        }
        if(empty($file_ext)){
            $error["p3report_file_ext"] = "Please Enter File Extension.";
        }

        if (empty($error)) {
            $data['new_eng']=$_POST;
            $data['new_eng']['status']=1;
            $data['new_eng']['mail']=isset($_POST['mail']) ? 1 : 0 ;
            $this->master_model->insert_compliance_engineer($data['new_eng']);
            $success["status"] = "true";
            $success["message"] = "New Engineer inserted Successfully.";
            echo json_encode($success);
        }else {
            $error["status"] = "false";
            echo json_encode($error);
        }

        
        //echo "<pre>";print_r($data);exit;
    }
    public function edit_compliance_engineer(){
        $eng_id=$this->input->post('eng_id');
        $data['eng'] = $this->master_model->get_compliance_engineer_id($eng_id);
        $data['companies'] = $this->master_model->get_companies();
        $data['engineers'] = $this->master_model->get_engineer($data['eng']['comp_id']);
        //echo "<pre>";print_r($data);exit;
        $this->load->view("master/compliance_editengineer",$data);
    }
    public function compliance_update_engineer(){
        $comp_id=$_POST['comp_id'];
        $eng_id=$_POST['eng_id'];
        $file_ext=$_POST['file_ext'];
        if($comp_id==""){
            $error["p3report_comp_id"] = "Please Select Company.";
        }
        if($eng_id==""){
            $error["p3report_eng_id"] = "Please Select Engineer.";
        }
        if(empty($file_ext)){
            $error["p3report_file_ext"] = "Please Enter File Extension.";
        }

        if (empty($error)) {
            //echo "<pre>";print_r($_POST);exit;
            $update_id=$this->input->post('edit_id');
            $data['update_eng']=$_POST;
            $data['update_eng']['mail']=isset($_POST['mail']) ? 1 : 0 ;
            $data['update_eng']['status']=1;
            unset($data['update_eng']['edit_id']);
            $this->master_model->update_compliance_engineer($data['update_eng'],$update_id);
            //echo "<pre>";print_r($data);exit;
            $success["status"] = "true";
            $success["message"] = "Engineer Edited Successfully.";
            echo json_encode($success);
        }else {
            $error["status"] = "false";
            echo json_encode($error);
        }
    }
    public function compliance_delete_engineer(){
        $eng_id=$this->uri->segment(3);
        //print_r($eng_id);exit;
        $this->master_model->delete_compliance_engineer($eng_id);
        //echo "<pre>";print_r($data);exit;
        redirect('master/compliance_master');
        
    }
/****************************************************************************************************
*
*   This function loads when email master is clicked
*   this function loads data from the table and displays in view
*
****************************************************************************************************/
    public function email_reminder() {
        $date = date("Y-m-d");
        $this->load->model('order_model');
        $data['engineers'] = $this->master_model->get_emailreminders();
        //echo "<pre>";print_r($data);exit;
        $this->template->build("master/reminder_master", $data);
    }
/****************************************************************************************************
* 
*   This function used to insert new engineer calls the add enginer page
*
****************************************************************************************************/
    public function reminder_add_engineer(){
        $data['companies'] = $this->master_model->get_companies();
        //echo "<pre>";print_r($data);exit;
        $this->load->view("master/reminder_addengineer",$data);
    }
/****************************************************************************************************
* 
*   This function used to validate and insert new enginner into table
*
****************************************************************************************************/
    public function reminder_insert_engineer(){
        $comp_id=$_POST['comp_id'];
        $eng_id=$_POST['eng_id'];
        $eng_ad_email=implode(',',$_POST['eng_ad_email']);
        $eng_email=$_POST['eng_email'];
        $time=$_POST['time'];
        $file_ext=$_POST['file_ext'];
        $reminder=$_POST['reminder'];
        if($comp_id==""){
            $error["reminder_comp_id"] = "Please Select Company.";
        }
        if($eng_id==""){
            $error["reminder_eng_id"] = "Please Select Engineer.";
        }
        if(empty($eng_email)){
            $error["reminder_eng_email"] = "Please Enter Email Address.";
        }
        if(empty($file_ext)){
            $error["reminder_file_ext"] = "Please Enter File Extension.";
        }
        if (isset($_POST['mail'])) {
            if($time=="" || $time==0){
                $error["reminder_time"] = "Please Enter Time Interval.";
            }
            if($reminder=="" || $reminder==0){
                $error["reminder_reminder"] = "Please Enter Reminder Times.";
            }
        }
        if (empty($error)) {
            $data['new_eng']=$_POST;
            unset($data['new_eng']['eng_ad_email']);
            $data['new_eng']['eng_ad_email']=$eng_ad_email;
            $data['new_eng']['mail']=isset($_POST['mail']) ? 1 : 0 ;
            $data['new_eng']['status']=1;
            //print_r($data['new_eng']);exit;
            $this->master_model->insert_reminder_engineer($data['new_eng']);
            $success["status"] = "true";
            $success["message"] = "New Engineer inserted Successfully.";
            echo json_encode($success);
        }else {
            $error["status"] = "false";
            echo json_encode($error);
        }
    }
/****************************************************************************************************
* 
*   This function retrieve the details from db and sent to edit reminder page
*
****************************************************************************************************/
    public function edit_reminder_engineer(){
        $eng_id=$this->input->post('eng_id');
        $data['eng'] = $this->master_model->get_reminder_engineer_id($eng_id);
        $data['companies'] = $this->master_model->get_companies();
        $data['engineers'] = $this->master_model->get_engineer($data['eng']['comp_id']);
        //echo "<pre>";print_r($data);exit;
        $this->load->view("master/reminder_editengineer",$data);
    }
/****************************************************************************************************
* 
*   the below function is used to update the email reminders 
*   function runs validation before updating the values into database
*   if validation is fails return error to update page else update values into database
*
****************************************************************************************************/
    public function reminder_update_engineer(){
        $comp_id=$_POST['comp_id'];
        $eng_id=$_POST['eng_id'];
        $eng_ad_email=implode(',',$_POST['eng_ad_email']);
        $eng_email=$_POST['eng_email'];
        $time=$_POST['time'];
        $file_ext=$_POST['file_ext'];
        $reminder=$_POST['reminder'];
        if($comp_id==""){
            $error["reminder_comp_id"] = "Please Select Company.";
        }
        if($eng_id==""){
            $error["reminder_eng_id"] = "Please Select Engineer.";
        }
        if(empty($eng_email)){
            $error["reminder_eng_email"] = "Please Enter Email Address.";
        }
        if(empty($file_ext)){
            $error["reminder_file_ext"] = "Please Enter File Extension.";
        }
        if (isset($_POST['mail'])) {
            if($time=="" || $time==0){
                $error["reminder_time"] = "Please Enter Time Interval.";
            }
            if($reminder=="" || $reminder==0){
                $error["reminder_reminder"] = "Please Enter Reminder Times.";
            }
        }
        if (empty($error)) {
            $update_id=$this->input->post('edit_id');
            $data['update_eng']=$_POST;
            unset($data['update_eng']['eng_ad_email']);
            $data['update_eng']['eng_ad_email']=$eng_ad_email;
            $data['update_eng']['mail']=isset($_POST['mail']) ? 1 : 0 ;
            $data['update_eng']['status']=1;
            unset($data['update_eng']['edit_id']);
            //echo "<pre>";print_r($data['update_eng']);exit;
            $this->master_model->update_reminder_engineer($data['update_eng'],$update_id);
            //echo "<pre>";print_r($data);exit;
            $success["status"] = "true";
            $success["message"] = "Update Successfully.";
            echo json_encode($success);
        }else {
            $error["status"] = "false";
            echo json_encode($error);
        }
    }
/****************************************************************************************************
*
* function for delete email reminder from database
* once email reminder is removed can't recover
*
****************************************************************************************************/
    public function reminder_delete_engineer(){
        $eng_id=$this->uri->segment(3);
        //print_r($eng_id);exit;
        $this->master_model->delete_reminder_engineer($eng_id);
        //echo "<pre>";print_r($data);exit;
        redirect('master/email_reminder');
        
    }
    
// Tooling reminder starts here

/****************************************************************************************************
* 
*   This function loads when email master is clicked
*   this function loads data from the table and displays in view
*
****************************************************************************************************/
    public function tooling_email_reminder() {
        $date = date("Y-m-d");
        $this->load->model('order_model');
        $data['engineers'] = $this->master_model->get_tooling_emailreminders();
        //echo "<pre>";print_r($data);exit;
        $this->template->build("master/reminder_tooling_master", $data);
    }


/****************************************************************************************************
* 
*   This function used to insert new engineer calls the add enginer page
*
****************************************************************************************************/
    public function tooling_reminder_add_engineer(){
        $data['companies'] = $this->master_model->get_companies();
        //echo "<pre>";print_r($data);exit;
        $this->load->view("master/reminder_tooling_addengineer",$data);
    }
/****************************************************************************************************
* 
*   This function used to validate and insert new enginner into table
*
****************************************************************************************************/
    public function tooling_reminder_insert_engineer(){
        $comp_id=$_POST['comp_id'];
        $eng_id=$_POST['eng_id'];
        $eng_ad_email=implode(',',$_POST['eng_ad_email']);
        $eng_email=$_POST['eng_email'];
        $time=$_POST['time'];
        $file_ext=$_POST['file_ext'];
        $reminder=$_POST['reminder'];
        if($comp_id==""){
            $error["reminder_comp_id"] = "Please Select Company.";
        }
        if($eng_id==""){
            $error["reminder_eng_id"] = "Please Select Engineer.";
        }
        if(empty($eng_email)){
            $error["reminder_eng_email"] = "Please Enter Email Address.";
        }
        //if(empty($file_ext)){
        //   $error["reminder_file_ext"] = "Please Enter File Extension.";
        //}
        if (isset($_POST['mail'])) {
            if($time=="" || $time==0){
                $error["reminder_time"] = "Please Enter Time Interval.";
            }
            if($reminder=="" || $reminder==0){
                $error["reminder_reminder"] = "Please Enter Reminder Times.";
            }
        }
        if (empty($error)) {
            $data['new_eng']=$_POST;
            unset($data['new_eng']['eng_ad_email']);
            $data['new_eng']['eng_ad_email']=$eng_ad_email;
            $data['new_eng']['mail']=isset($_POST['mail']) ? 1 : 0 ;
            $data['new_eng']['status']=1;
            //print_r($data['new_eng']);exit;
            $this->master_model->insert_tooling_reminder_engineer($data['new_eng']);
            $success["status"] = "true";
            $success["message"] = "New Engineer inserted Successfully.";
            echo json_encode($success);
        }else {
            $error["status"] = "false";
            echo json_encode($error);
        }
    }

/****************************************************************************************************
* 
*   This function retrieve the details from db and sent to edit reminder page
*
****************************************************************************************************/
    public function tooling_edit_reminder_engineer(){
        $eng_id=$this->input->post('eng_id');
        $data['eng'] = $this->master_model->get_tooling_reminder_engineer_id($eng_id);
        $data['companies'] = $this->master_model->get_companies();
        $data['engineers'] = $this->master_model->get_engineer($data['eng']['comp_id']);
        //echo "<pre>";print_r($data);exit;
        $this->load->view("master/reminder_tooling_editengineer",$data);
    }

/****************************************************************************************************
* 
*   the below function is used to update the email reminders 
*   function runs validation before updating the values into database
*   if validation is fails return error to update page else update values into database
*
****************************************************************************************************/
    public function tooling_reminder_update_engineer(){
        $comp_id=$_POST['comp_id'];
        $eng_id=$_POST['eng_id'];
        $eng_ad_email=implode(',',$_POST['eng_ad_email']);
        $eng_email=$_POST['eng_email'];
        $time=$_POST['time'];
        $file_ext=$_POST['file_ext'];
        $reminder=$_POST['reminder'];
        if($comp_id==""){
            $error["reminder_comp_id"] = "Please Select Company.";
        }
        if($eng_id==""){
            $error["reminder_eng_id"] = "Please Select Engineer.";
        }
        if(empty($eng_email)){
            $error["reminder_eng_email"] = "Please Enter Email Address.";
        }
        //if(empty($file_ext)){
        //    $error["reminder_file_ext"] = "Please Enter File Extension.";
        //}
        if (isset($_POST['mail'])) {
            if($time=="" || $time==0){
                $error["reminder_time"] = "Please Enter Time Interval.";
            }
            if($reminder=="" || $reminder==0){
                $error["reminder_reminder"] = "Please Enter Reminder Times.";
            }
        }
        if (empty($error)) {
            $update_id=$this->input->post('edit_id');
            $data['update_eng']=$_POST;
            unset($data['update_eng']['eng_ad_email']);
            $data['update_eng']['eng_ad_email']=$eng_ad_email;
            $data['update_eng']['mail']=isset($_POST['mail']) ? 1 : 0 ;
            $data['update_eng']['status']=1;
            unset($data['update_eng']['edit_id']);
            //echo "<pre>";print_r($data['update_eng']);exit;
            $this->master_model->update_tooling_reminder_engineer($data['update_eng'],$update_id);
            //echo "<pre>";print_r($data);exit;
            $success["status"] = "true";
            $success["message"] = "Update Successfully.";
            echo json_encode($success);
        }else {
            $error["status"] = "false";
            echo json_encode($error);
        }
    }
/****************************************************************************************************
*
* function for delete email reminder from database
* once email reminder is removed can't recover
*
****************************************************************************************************/
    public function tooling_reminder_delete_engineer(){
        $eng_id=$this->uri->segment(3);
        //print_r($eng_id);exit;
        $this->master_model->delete_tooling_reminder_engineer($eng_id);
        //echo "<pre>";print_r($data);exit;
        redirect('master/tooling_email_reminder');
        
    }
    



}