<?php
class Cad extends CI_Controller {

    public function __construct() {
        parent::__construct();
        //print_r($this->session->userdata());exit;
        if (!$this->input->is_ajax_request()) {
            if (!$this->session->userdata('user_id')) {
                redirect('welcome');
            }
        }else{
            if (!$this->session->userdata('user_id')) {
                echo json_encode(array('status'=>'sessionexpired'));exit;
            }
        }
        $this->load->model('user_model');
        $this->load->model('cad_model1');
        $this->load->model('customer_model');
        $this->load->library('email');
        $this->load->library('upload');
        $this->load->model('beamon_model');
        $this->load->model('order_model');
        $this->load->helper('date');
        $this->load->library('clickatell');
        $this->load->library('ckeditor');
        $this->load->library('ckfinder');
        $this->ckeditor->basePath = base_url() . 'assets/ckeditor/';
        $this->ckeditor->config['toolbar'] = 'full';
        $this->ckeditor->config['language'] = 'english';
        $this->ckeditor->config['width'] = '100%';
        $this->ckeditor->config['height'] = '300px';

//Add Ckfinder to Ckeditor
        $this->ckfinder->SetupCKEditor($this->ckeditor, '../../asset/ckfinder/');
    }

    public function index() {

        $date = date('Y-m-d');
        $data['high'] = $this->cad_model1->get_cad_status('2', '1', $date);
        $data['normal'] = $this->cad_model1->get_cad_status('1', '1', $date);
        $data['low'] = $this->cad_model1->get_cad_status('0', '1', $date);
		
       // echo "<pre>";print_r($new);exit;
        $this->template->build("cad/cad_orders", $data);
    }

    public function cad_new_job() {
        header('Access-Control-Allow-Origin: *');
        $data["order_id"] = $_GET['ord_id'];
        $data["engg_id"] = $_GET['engg_id'];
        $data["job_id"] = $_GET['job_id'];

        $data['ord_ref_id'] = $_GET['ord_ref_id'];
        $data["order_details"] = $this->cad_model1->get_order_detail($data["order_id"]);
        //echo "<pre>";print_r($data["order_details"]);exit;
        $data["order_status"] = $this->cad_model1->get_order_status($data["order_id"],$data["job_id"]);
        $data["custom_foil"] = $this->cad_model1->get_custom_foil_status($data["order_id"]);
        $data['user'] = $this->user_model->get_job_update_join($data["order_status"]["id"]);
        $data["send_laser"] = $this->cad_model1->get_send_laser_status($data["order_id"],$data["job_id"]);
        $data["job_status"] = $this->cad_model1->get_job_status_job_id($data["job_id"]);
        $data['reminder'] = $this->cad_model1->check_reminder($data["order_id"],$data["job_id"]);
        $data["job_id"] = $data["job_status"]["job_id"];
        $data["checklist_status"] = get_checklist_status($data["order_status"]["id"]);
        //echo "<pre>";print_r($data["checklist"]);exit;
        $this->load->view('cad/cad_popup', $data);
    }

    public function cad_mail_to_customer() {
        header('Access-Control-Allow-Origin: *');
        if ($this->input->post()) {
            //echo "<pre>";print_r($_POST);exit;
            $data=$_POST;
            $bottom_order=$data['bottom_order'];
            if($bottom_order !=""){
                $bottom_order_attach="-".substr($bottom_order, -2);
            }else{
                $bottom_order_attach="";
            }
            $no_attach=isset($_POST["no_attach"]) ? 1 : 0 ;
            $mail_cc=$_POST["cc_email"];
            //$mail_cc=$_POST["cc_email"].",krishna.ixly@gmailcom";
            $this->load->helper('directory');
            $this->load->library('zip');
            if($no_attach==0){
                $path = EMAIL_ATTACHMENT_PATH.$this->input->post('order_reference_id');
                $email_attachment=$this->input->post('upload_files');
                $uploaded_files=array_filter(explode(',',$email_attachment));
                foreach ($uploaded_files as $key => $file) {
                   $this->zip->read_file($path.'/'.str_replace(" ","_",$file));
                }
                $this->zip->archive($path.$bottom_order_attach.'.zip');
            }
                $this->email->set_mailtype("html");
                $this->email->set_newline("\r\n");
                $this->email->from('info@beamon.com', 'Beamon');
                $this->email->to($_POST["email"]);
                $cc_email = str_replace(';', ',', $mail_cc);
                $this->email->cc($cc_email);
                if($_POST["bcc_email"]!=""){
                    $this->email->bcc($_POST["bcc_email"]);
                }
                if($no_attach==0){
                        $file=EMAIL_ATTACHMENT_PATH.$this->input->post('order_reference_id').$bottom_order_attach.'.zip';
                        if (!empty($file)){
                            $this->email->attach($file);
                        }
                }
                $message = $_POST["mail_message"];
                $message.=$this->load->view("cad/email_signature", array(), true);
                $emailreminder=isset($_POST["reminder_mail"]) ? 1 : 0 ;
                /* storing email reminder */
                    $reminder['ord_id']=$_POST['ord_id'];
                    $reminder['job_id']=$_POST['job_id'];
                    $reminder['job_code']=$_POST['order_reference_id'];
                    $reminder['bottom_order']=$_POST['bottom_order'];
                    $reminder['eng_id']=$_POST['eng_id'];
                    $reminder['email']=$_POST['email'];
                    $reminder['email_cc']=$mail_cc;
                    $reminder['email_bcc']=$_POST["bcc_email"];
                    $reminder['subject']=$_POST["subject"];
                    $reminder['message']=$_POST["mail_message"];
                    $reminder['reminder']=isset($_POST["reminder_mail"]) ? 1 : 0 ;
                    $reminder['time_interval']=$_POST["reminder_interval"];
                    $reminder['no_times']=$_POST["reminder_times"];
                    $reminder['attach_file']=$_POST["upload_files"];
                    if($no_attach==0){
                        $reminder['attachment']=1;
                        $reminder['attachment_name']=$this->input->post('order_reference_id').$bottom_order_attach.'.zip';
                    }else{
                        $reminder['attachment']=0;
                        $reminder['attachment_name']="";
                    }
                    $reminder['status']=1;
                    $data['reminder_id']=$this->cad_model1->insert_mail_reminder($reminder);
                if($emailreminder==1){
                    $message.=$this->load->view("cad/email_unsubscribe",$data, true);
                }
                $this->email->subject($_POST["subject"]);
                $this->email->message($message);
                if ($this->email->send()) {
                    // $data['is_hold'] = WORK_IN_HOLD;
                    // $data['ord_id'] = $_POST['ord_id'];
                    // change_working_status('is_hold', WORK_IN_HOLD, $data['ord_id']);
                    if($no_attach==0){
                        //unlink($file);
                        recursiveRemoveDirectory($path);        
                    }
                    /* update customer mail update into order_status */
                    $cust_mail['cust_mail']=1;
                    $cust_mail['cust_mail_time']=date("Y-m-d H:i:s");
                    $cust_mail_status=$this->cad_model1->cust_mail_update($cust_mail,$_POST['ord_id'],$_POST['job_id']);
                    /* Moving job to HOLD status */
                    $cad_update['job_status']=0;
                    $cust_job_status=$this->cad_model1->cad_update($cad_update,$_POST['ord_id'],$_POST['job_id']);
                     /* Moving Bottom job to HOLD status if Available */
                     
                    //$bottom_order=$this->cad_model1->check_bottom_order($_POST['ord_id']);
                    if ($bottom_order!="") {
                        $cad_update['job_status']=0;
                        $cust_job_status=$this->cad_model1->cad_update($cad_update,get_order_id($bottom_order),get_job_id($bottom_order));
                        $job_updates['update_date']=date("Y-m-d");
                        $job_updates['update_time']=date("Y-m-d H:i:s");
                        $job_updates['update_to']="HOLD";
                        $job_updates['update_for']=1;
                        $job_updates['update_status']=1;
                        $job_updates['show_customer']=1;
                        $job_updates['update_remarks']=$data['reg']." Wims 2";
                        $job_updates['update_by']=$this->session->userdata('user_id');
                        $cust_job_update_status=$this->cad_model1->update_job_status($job_updates,get_order_id($bottom_order));
                    }
                    /* Update job status in tbl_jobs_update for wims */
                    $job_updates['update_date']=date("Y-m-d");
                    $job_updates['update_time']=date("Y-m-d H:i:s");
                    $job_updates['update_to']="HOLD";
                    $job_updates['update_for']=1;
                    $job_updates['update_status']=1;
                    $job_updates['show_customer']=1;
                    $job_updates['update_remarks']=$data['reg']." Wims 2";
                    $job_updates['update_by']=$this->session->userdata('user_id');
                    $cust_job_update_status=$this->cad_model1->update_job_status($job_updates,$_POST['job_id']);
                    working_status_updates(QUERY_SENT_TO_CUSTOMER, $_POST['subject'],$_POST['ord_id']);
                    echo json_encode(array("status" => true, "message" => "Email sent successfully"));
                } else {
                    $cust_mail['cust_mail']=1;
                    $cust_mail['cust_mail_time']=date("Y-m-d H:i:s");
                    $cust_mail_status=$this->cad_model1->cust_mail_update($cust_mail,$_POST['ord_id'],$_POST['job_id']);
                    echo json_encode(array("status" => false, "message" => "Email not sent successfully"));
                }
        } else {
            //echo "<pre>";print_r($_GET['engg_id']);exit;
            $data['ord_id'] = $_GET['ord_id'];
            $data['job_id'] = $_GET['job_id'];
            $data['order_reference_id'] = $_GET['order_reference_id'];
            $customer_id = $_GET['engg_id']; //$this->uri->segment(3);
            $data["customer"] = $this->customer_model->get_engineer_details($customer_id);
            $data['email_reminder']=$this->customer_model->get_reminder_details($customer_id);
            $data['bottom_order']=$this->cad_model1->check_bottom_order($data['ord_id']);
            $data['default_uploads']['file_ext']=$this->cad_model1->customer_mail_default();
            //echo "<pre>";print_r($data['email_reminder']);exit;
            $this->load->view('cad/mail_to_customer', $data);
        }
    }

    public function upload_attachment() {
        $path = APPPATH . '../upload/' . $_POST["ord_reference_id"] . '/cad_mailed_docs';
        (!is_dir($path)) ? mkdir($path, 0777, true) : "";
        $config['upload_path'] = $path;
        $config['allowed_types'] = 'gif|jpg|png|pdf|zip|rar';
        $this->upload->initialize($config);
        if (!$this->upload->do_upload('file_1')) {
            $error = array('error' => $this->upload->display_errors());
            echo json_encode(array("status" => "failure", "message" => "File upload error."));
        } else {
            $uploaded = $this->upload->data();
            $data["attachment"] = $uploaded["file_name"];
            echo json_encode(array("status" => "success", "savedfilename" => $uploaded["file_name"], "filename" => $_FILES["file_1"]["name"]));
        }
     }

    public function send_to_laser() {
        $data['ord_id'] = $_POST['ord_id'];
        $data['cad_remarks'] = $_POST['update_remarks'];
        change_working_status('cad_status', WORK_COMPLETED, $data['ord_id']);
        change_working_status('cad_remarks', $data['cad_remarks'], $data['ord_id']);
        working_status_updates(CAD_COMPLETED, $_POST['update_remarks'], $data['ord_id']);
        echo json_encode(array("status" => true, "message" => "Cad Work Completed."));
    }

    public function checklist() {
        $data['ord_id'] = $_POST['ord_id'];
        $data['ord_sts_id'] = $_POST['ord_sts_id'];
        $data['job_id'] = $_POST['job_id'];
        $data['job_code'] = $_POST['job_code'];
        $data['order_details'] = $this->order_model->get_order_details($data['ord_id']);
        $data['order_details']['order_code']= $_POST['job_code'];
        //print_r($data['order_details']['cust_ref']);exit;
        $data['cust_name'] = $this->customer_model->get_customer_name($data['order_details']['cust_ref']);
        //echo "<pre>";print_r($data);exit;
        $this->load->view('cad/checklist', $data);
    }

    public function fixit_checklist() {
        $data['order_id'] = $this->input->post('order_id');
        $data['job_id'] = $this->input->post('job_id');
        $data['job_code'] = $this->input->post('job_code');
        $data['order_status_id'] = $this->input->post('order_status_id');
        $data['fixit']= $this->cad_model1->get_checklist_data($data['order_status_id']);
        $this->load->view('cad/fixit_checklist', $data);
    }

    public function template_checklist() {
        $data['order_id'] = $this->input->post('order_id');
        $data['job_id'] = $this->input->post('job_id');
        $data['job_code'] = $this->input->post('job_code');
        $data['order_status_id'] = $this->input->post('order_status_id');
        $data['template']= $this->cad_model1->get_checklist_data($data['order_status_id']);
        //print_r($data['template']);exit;
        $this->load->view('cad/template_checklist', $data);
    }
    
    // Function written by KRISHNAMK

    

   /* public function get_double_epoxy($ord_id) {
        $epoxy=get_epoxy($ord_id); 
        $frm_size = $this->cad_model1->get_frame_size($ord_id); 
        $foil_only_other=get_foil_only_other($ord_id); 
        $type_of_frame=get_type_of_frame($frm_size); 
        $ship_method=get_ship_method($ord_id); 
        $stencil_side=get_stencil_side($ord_id); 
        $epoxy_req = get_epoxy_req($ord_id); 
        $aper_content = get_aper_content($ord_id);
        if (($type_of_frame != 2 || $type_of_frame != 3 || $foil_only_other != 1 ) && ($stencil_side == 3 || $aper_content > 10000 || $ship_method != 1 || $epoxy_req == 1) ) { 
            $double_epoxy = 1;
        } else {
            $double_epoxy = 0;
        }
        return $double_epoxy;

    }*/
    public function get_double_epoxy($ord_id) {
        $epoxy = get_epoxy($ord_id); 
        
        if ($epoxy == 1) { 
            $double_epoxy = 1;
        } else {
            $double_epoxy = 0;
        }
        return $double_epoxy;

    }

    public function ckeck_double_epoxy() {
		//print_r($_POST);
        $aperture = $this->input->post('aperture_count');
        $ord_id = $this->input->post('order_id');
        if( $aperture > 10000){
           $data['double_epoxy'] = 1;
           echo '<input type="checkbox" name="sc_double_epoxy" id="double_epoxy" checked class="cad_ajax_chkboxes" value="1" data-id="double_epoxy"><label for="double_epoxy" class="col-lg-5 control-label">Double Epoxy</label>';
       }else{
           if($this->get_double_epoxy($ord_id)== 1 ){
            echo '<input type="checkbox" name="sc_double_epoxy" id="double_epoxy" checked class="cad_ajax_chkboxes" value="1" data-id="double_epoxy"><label for="double_epoxy" class="col-lg-5 control-label">Double Epoxy</label>';
        }else{
            echo '<input type="checkbox" name="sc_double_epoxy" id="double_epoxy" class="cad_ajax_chkboxes" value="1" data-id="double_epoxy"><label for="double_epoxy" class="col-lg-5 control-label">Double Epoxy</label>';
        }
    }
}

    //function written by krishna

public function stencil_checklist() {
	
    $this->session->set_userdata('stencil_upload', 0);
    $data['order_id'] = $this->input->post('order_id');
    $data['job_id'] = $this->input->post('job_id');
    $data['job_code'] = $this->input->post('job_code');
	$data['stencil_side'] = $this->cad_model1->get_stencil_side2($data['job_code']);
    $data['order_status_id'] = $this->input->post('order_status_id');
    $data['double_epoxy']=  $this->get_double_epoxy($data['order_id']);
    $data['syn_premium']= $this->cad_model1->syn_premium_wims($data['order_id'],$data['order_status_id']);
    $data['stencil']= $this->cad_model1->get_checklist_data($data['order_status_id']);
    $data['stencil_foil']= $this->cad_model1->get_checklist_foil($data['stencil']['cad_checklist_id']);
    $data['stencil_decode']= $this->cad_model1->get_checklist_decode($data['stencil']['cad_checklist_id']);
    $data['stencil_quantity']= $this->cad_model1->get_checklist_quantity($data['stencil']['cad_checklist_id']);
     //echo "<pre>";print_r($datas);exit; 
    $this->load->view('cad/stencil_checklist', $data);
}

public function spinplate_checklist() {
    $data['order_id'] = $this->input->post('order_id');
    $data['job_code'] = $this->input->post('job_code');
    $data['job_id'] = $this->input->post('job_id');
    $data['order_status_id'] = $this->input->post('order_status_id');
    $data['spinplate']= $this->cad_model1->get_checklist_data($data['order_status_id']);
    $this->load->view('cad/spinplate_checklist', $data);
}

public function checklist_submit() {
    $data['checklist_stats'] = $this->cad_model1->get_checklist_stats($_POST['order_status_id']);
	
	//print_r($_POST); exit;
	
    foreach ($_POST as $key => $value) {
        if ($_POST[$key] == 'on')
            $_POST[$key] = 1;
    }
    $check = '';
    if (!$data['checklist_stats']) {
        $check = $this->cad_model1->checklist_data($_POST);
        echo json_encode(array('status' => 'success', 'message' => 'Details saved successfully', 'cad_checklist_id' => $check));
    } else {
        $check = $this->cad_model1->update_checklist($_POST);
        $check = $data['checklist_stats'];
        echo json_encode(array('status' => 'success', 'message' => 'Details saved successfully', 'cad_checklist_id' => $data['checklist_stats']));
    }
    $checklist_complete = $this->cad_model1->checklist_status($check);
    if(!empty($checklist_complete)) {
        $cad['cad_checklist_completed'] = 1;
//                $cad['cad_remarks'] = $data['sc_notes'];
        $cad['id'] = $data["order_status_id"];
        $cad['ord_id'] = $_POST['ord_id'];
        $this->cad_model1->notes_to_laser($cad);
    }
}

public function print_checklist(){
    $data['id'] = $_GET['id'];
    $data['print_data'] = $this->cad_model1->print_data($data);
    $data['print_data'] = $data['print_data'][0];
    $html = $this->load->view("cad/print_checklist", $data, true);
    $pdfFilePSath = "checklist.pdf";

    $this->load->library('pdf');

    $pdf = $this->pdf->load();
    $stylesheet = file_get_contents(base_url() . 'assets/css/mpdfstyletables.css');
    $pdf->WriteHTML($stylesheet, 1);
        $pdf->WriteHTML($html, 2); // write the HTML into the PDF
        $pdf->Output("$pdfFilePSath", 'I'); // save to file because we can
        exit;
    }

    public function rework_checklist() {
        $data['order_id'] = $this->input->post('order_id');
        $data['job_id'] = $this->input->post('job_id');
        $data['job_code'] = $this->input->post('job_code');
        $data['order_status_id'] = $this->input->post('order_status_id');
        $data['rework']= $this->cad_model1->get_checklist_data($data['order_status_id']);
        //echo "<pre>";print_r($data);exit;
        $this->load->view('cad/rework_checklist', $data);
    }

    public function upload_to_archive() {
        $ord_reference_id = $_POST["ord_reference_id"];         //getting reference number from upload 
        $data["order_status_id"] = $_POST["order_status_id"];   //getting reference status id from upload
        $file_exist = $this->cad_model1->uploaded_files_details($data["order_status_id"], $_POST['type_of_upload']);
        $name=$_FILES['file1']['name'];                         // assigning file name to $name variable
         if (stripos($name, $ord_reference_id) !== false) {     // checking reference number match with upload or not
            $path = '/home/beamon9/public_html/testing/boots2_new/output/oldjobs';// old job file upload location.
            (!is_dir($path)) ? mkdir($path, 0755, true) : "";   // if upload directory not exist means to create
            $config['upload_path'] = $path;                     // assigning path to upload
            $config['allowed_types'] = 'zip|rar';               // only two types are allowed zip and rar.
            $this->upload->initialize($config);                 // initialize file upload
            if (!$this->upload->do_upload('file1')) {           // checking file uploaded or not
                $error = array('error' => $this->upload->display_errors());
                echo json_encode(array("status" => "failure", "message" => "File not uploaded."));
            } else {
                $uploaded = $this->upload->data();
                $data["file_name"] = $uploaded["file_name"];
                $data["order_status_id"] = $_POST["order_status_id"];
                $data['file_type'] = $_POST['type_of_upload'];
                if (!empty($file_exist)) {
                    $this->cad_model1->update_archive($data);
                } else {
                    $this->cad_model1->upload_archive($data);
                }
                echo json_encode(array("status" => "success", "message" => "File Uploaded successfully.", "savedfilename" => $uploaded["file_name"], "filename" => $_FILES["file1"]["name"]));
            }
        } else {
            echo json_encode(array("status" => "failure","filename" => $_FILES["file1"]["name"],"savedfilename" => $_FILES["file1"]["name"],"message" => "Reference Code Not Match Pleae Check File"));

        }
    }

    public function upload_to_checklist() {

        $ord_reference_id = $_POST["ord_reference_id"];
        $data["order_status_id"] = $_POST["order_status_id"];
        $file_exist = $this->cad_model1->uploaded_files_details($data["order_status_id"], $_POST['type_of_upload']);
        $path = APPPATH . '../upload/' . $ord_reference_id;
        (!is_dir($path)) ? mkdir($path, 0755, true) : "";
        $config['upload_path'] = $path;
        $config['allowed_types'] = 'gif|jpg|png|pdf|zip|rar';
//  $config['file_name'] = date("YmdHis") . $_FILES["file"]["tmp_name"];
        $this->upload->initialize($config);
        if (!$this->upload->do_upload('file1')) {
            $error = array('error' => $this->upload->display_errors());
            echo json_encode(array("status" => "failure", "message" => "File not uploaded."));
//$this->template->build('admin/add_user', $error);
        } else {
            $uploaded = $this->upload->data();
            $data["file_name"] = $uploaded["file_name"];
            $data["order_status_id"] = $_POST["order_status_id"];
            $data['file_type'] = $_POST['type_of_upload'];
            if (!empty($file_exist)) {
                $this->cad_model1->update_archive($data);
            } else {
                $this->cad_model1->upload_archive($data);
            }
            echo json_encode(array("status" => "success", "message" => "File Uploaded successfully.", "savedfilename" => $uploaded["file_name"], "filename" => $_FILES["file1"]["name"]));
        }
    }

    public function change_cad_status() {
        $data=$_POST;
         $data["job_status"] = $this->cad_model1->get_job_status_job_code($data["job_code"]);
        //echo "<pre>";print_r($data);exit;
        if ($data["job_status"]['job_cad_status'] == 0) {
            $this->cad_model1->change_cad_working($data["job_code"]);
            $order['update_remarks'] = "Cad Work started by" . $this->session->userdata('user_name');
            $order['update_status'] = 1;
            $order['job_code'] = $data['job_code'];
            $this->cad_model1->change_cad_working_history($order);
            $cad_update_status['update_by']=$_SESSION['user_id'];
            $cad_update_status['update_to']="CAD - Working";
            $cad_update_status['update_for']=1;
            $cad_update_status['update_status']=1;
            $cad_update_status['update_time']=date("Y-m-d h:i:s");
            $data['job_update_status'] = $this->cad_model1->update_job_status($cad_update_status,get_job_id($data['job_code']));

            $encode = array("status" => true, "message" => "Cad Status Changed to Working.");
        } elseif ($data["job_status"]['job_cad_status'] == 1 && $data["job_status"]['job_status'] == 1) {
            $encode = array("status" => false, "message" => "Cad status is already in working");
        } elseif ($data["job_status"]['job_cad_status'] == 2) {
            $encode = array("status" => false, "message" => "The Cad is already Completed");
        } elseif ($data["job_status"]['job_status'] == 0) {
            $encode = array("status" => false, "message" => "Sorry ! The Cad design is in hold sent for clarification to the Client.");
        }
        echo json_encode($encode);
    }

    public function change_cad_working_status() {
        $data['ord_id'] = $this->input->post('ord_id');
        $order["order_status"] = $this->cad_model1->get_order_status($data['ord_id']);
        $this->cad_model1->change_cad_working($order["order_status"]['id']);
        $data['update_status'] = 4;
        $data['update_remarks'] = "Cad Work restarted by" . $this->session->userdata('user_name');
        $this->cad_model1->change_cad_working_history($data);
        $encode = array("status" => true, "message" => "Cad Status Changed");
        echo json_encode($encode);
    }

    public function mail_templates() {
        if ($this->input->post()) {
            $this->cad_model1->mail_templates($this->input->post());
            redirect('cad/view_mail_templates');
        }
        $this->template->build('cad/mail_templates');
    }

    public function view_mail_templates() {
        $data['templates'] = $this->cad_model1->get_templates();
        $this->template->build('cad/view_mail_templates', $data);
    }

    public function edit_mail_templates() {
        $id = $this->uri->segment(3);
        if ($this->input->post()) {
            $data['mail_id'] = $id;
            $data = $this->input->post();
            $this->cad_model1->edit_templates($data);
            redirect('cad/view_mail_templates');
        }
        $data['templates'] = $this->cad_model1->get_templates($id);
        $this->template->build('cad/edit_mail_templates', $data);
    }

    public function delete_mail_templates() {
        $id = $this->uri->segment(3);
        $data['templates'] = $this->cad_model1->delete_templates($id);
        redirect('cad/view_mail_templates');
    }

    public function get_mail_subject() {
        $data['eng_id'] = $_POST['eng_id'];
        $data['mail_id'] = $_POST['mail_id'];
        $data['ord_id'] = $_POST['ord_id'];
        $data['job_id'] = $_POST['job_id'];
        $data['job_code'] = $_POST['job_code'];
        $data['bottom_order'] = $_POST['bottom_order'];
        $data['customer'] = $this->customer_model->get_engineer_details($data['eng_id']);
        $data['message'] = get_cad_mail_subject($data['mail_id']);
        $data['order_details'] = $this->order_model->get_order_details($data['ord_id']);
        $data['customer_name'] = $this->customer_model->get_customer_name($data['order_details']['cust_ref']);
        if ($data['order_details']['stencil_side']==1 || $data['order_details']['stencil_side']==3) {
            $data['cust_name'] = $data['order_details']['dt_top_name'];
        }else{
            $data['cust_name'] = $data['order_details']['dt_bot_name'];
        }
        //$data['bottom_order']=$this->cad_model1->check_bottom_order($data['ord_id']);
        if($data['bottom_order']!=""){
            $data['bottom_ord']="-".substr($data['bottom_order'], -2);
        }else{
            $data['bottom_ord']="";
        }
        $names = array(
            "{{first_name}}" => $data['customer']['eng_fname'],
            "{{last_name}}" => $data['customer']['eng_lname'],
            "{{bottom}}"=>$data['bottom_ord'],
            "{{customer_name}}" => $data['cust_name'],
            "{{company_name}}" => $data['customer_name']['cust_name'],
            "{{assembly_no}}" => $data['order_details']['dt_top_assembly'] . $data['order_details']['dt_bot_assembly'],
            "{{fab_number}}" => $data['order_details']['dt_top_fab'] . $data['order_details']['dt_bot_fab'],
            "{{ref#}}" => "Ref#" . $data['job_code']
            );
        $mail_sub = strtr($data['message'][0]['mail_subject'], $names);
        $mail_body = strtr($data['message'][0]['mail_body'], $names);
        echo json_encode(array(
            "subject" => $mail_sub,
            "message" => $mail_body
            ));
    }

    public function compare_check_list() {
       // echo "<pre>"; print_r($_POST);
        $ord_id = $_POST["ord_id"];
        $order_status_id = $_POST["order_status_id"];
        $aperture_count = $_POST["sc_aperture_count"];
        $frame_used = $_POST["sc_frame_used"];
        $custom_frame_used = $_POST["sc_frame_used_custom"]; 
        $bot_ref = $_POST["sc_bot_ref_des"];
        $foil_thickness = $_POST["sc_foil_thik"];
        $fiducial_qty = $_POST["sc_fiducial_qty"];
        $fiducial_dcode = $_POST["sc_fiducial_dcode"];
        $total_ct = $_POST["total_ct"];
         
        $border_used = isset($_POST["sc_border_used"]) ? $_POST["sc_border_used"] : "" ;
        $material_used = isset($_POST["sc_material"]) ? 1 : 0 ;
        $error = array();
//Check aperture
        if (empty($aperture_count)) {
            $error["sc_aperture_content_em"] = "Please Enter the Aperture value.";
           $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Aperture Count Entered Wrongly');
        }
		else
		{
			if(isset($_POST["step_checkbox"])) 
			{  
		      if($aperture_count!=$_POST['total_ct'])
			   {
				$error["sc_aperture_content_em"] ="aperture_count and total ct don't match";
			   }
		   }
		}
		
        if ($material_used==0) {
            $error["sc_material_em"] = "Please Select Material.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Material Not Selected');
        } 
        if (empty($frame_used)) {
                if($frame_used == 'Custom Foil'){
                    $error["sc_frame_used_em"] = "Please Enter the Foil value.";
                }else{
                    $error["sc_frame_used_em"] = "Please Enter the Frame value.";
                }
            
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Frame Not Entered');
        } else {
            $result = $this->cad_model1->get_frame_size($ord_id);
            if(($result == '-2') && ($frame_used == 'Custom Foil') ){
               //$custom_frame_used ='Cust. Foil-'.$custom_frame_used;
            }
            if(($result == '-2') && ($frame_used == 'Custom Frame') ){
               $custom_frame_used ='Cust. Frame-'.$custom_frame_used;
            } 
            if((($result == "-1") OR ($result == "-2"))){ 
                $result = $this->cad_model1->compare_custom_frame_size($custom_frame_used, $ord_id);
            }else{
                $result = $this->cad_model1->compare_frame_size($frame_used, $ord_id);
            } 
            if (!$result) {
                
                if($frame_used == 'Custom Foil'){
                    $error["sc_frame_used_em"] = "Please Check the Foil value with the order.";
                }else{
                    $error["sc_frame_used_em"] = "Please Check the Frame value with the order.";
                }
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Frame Entered Wrongly'); //Log error of the User
            }
        } 
        if(($frame_used != "Custom Foil") AND ($frame_used != "Custom Frame")){
            if (($border_used=="")OR($border_used=="Select Border")) {
                $error["sc_border_used_em"] = "Please Enter the Border Used.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Border not Entered');
            }
        } 
        if (empty($bot_ref)) {
            $error["bot_ref_des_em"] = "Please Enter the BOT Value.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Frame Entered Wrongly'); //Log error of the User
        } 
        $stencil_side = $this->cad_model1->get_stencil_side($ord_id);
        if ($stencil_side['stencil_side'] == 1 || $stencil_side['stencil_side'] == 3)
            $compartwith = array(
                "top_foil_thik", "top_multilevel", "top_multilevel_2"
                );
        else {
            $compartwith = array(
                "bot_foil_thik", "bot_multilevel", "bot_multilevel_2"
                );
        }
        foreach ($foil_thickness as $key => $foil) {
            if (($key==0)AND(empty($foil))) {
                $error["sc_foil_thik_em"] = "Please Enter the Foil thickness Value.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Frame Entered Wrongly');
            } else {
                $result = $this->cad_model1->compare_foil_thickness($foil, $ord_id, $compartwith[$key]);
//                print_r($compartwith);exit;
                if (!$result) {
                    $error["sc_foil_thik_em"] = "Please Check the Foil thickness with the order.";
                    $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Foil thickness Entered Wrongly');
                }
            }
        } 
        foreach ($fiducial_qty as $key => $fiducial) {
            if (($key==0)AND(empty($fiducial))) {
                $error["sc_fiducial_qty_em"] = "Please Enter the Fiducial Quantity.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Fiducial Quantity not Entered'); //Log error of the User
            }
        } 
        foreach ($fiducial_dcode as $key => $fiducial) {
            if (($key==0)AND(empty($fiducial))) {
                $error["sc_fiducial_dcode_em"] = "Please Enter the Fiducial Dcode Value.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Fiducial Dcode not Entered');
            }
        } 
        $result = $this->cad_model1->compare_order_datas($ord_id, "lead_free_mark", isset($_POST["sc_lead_free"]) ? 1 : 0 );
        if (empty($result)) {
            $error["lead_free_mark_em"] = "Please Check the Lead Free with the order.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Lead Free Entered Wrongly');
        }
        $result = $this->cad_model1->compare_order_datas($ord_id, "fixture_smt", isset($_POST["sc_ship_tooling"]) ? 1 : 0 );
        if (empty($result)) {
            $error["fixture_smt_em"] = "Please Check the Ship Tooling with the order.";
        } 
        //$_POST["sc_fg_material"];
        //$result = $this->cad_model1->compare_order_datas($ord_id, "fg_material", isset($_POST["sc_datum_fg"]) ? 1 : 0 );
        //if (empty($result)) {
        //    $error["fg_material_em"] = "Please Check the Datum FG with the order.";
        //    $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Datum FG Entered Wrongly');
        //}
        //$result = $this->cad_model1->compare_order_datas($ord_id, "tension", isset($_POST["sc_tension_material"]) ? 1 : 0 );
        //if (empty($result)) {
        //    $error["tension_em"] = "Please Check the Tension with the order.";
        //    $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Tension Entered Wrongly');
        //}
        $result = $this->cad_model1->compare_order_datas($ord_id, "film_plots", isset($_POST["sc_ship_plot"]) ? 1 : 0 );
        if (empty($result)) {
            $error["film_plots_em"] = "Please Check the Ship W/ Plots with the order.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Ship W/ Plots Entered Wrongly');
        }
        $result = $this->cad_model1->compare_order_datas($ord_id, "inspect_template", isset($_POST["sc_ship_template"]) ? 1 : 0 );
        if (empty($result)) {
            $error["inspect_template_em"] = "Please Check the Ship W / Template with the order.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Ship W / Template Entered Wrongly');
        }
        $result = $this->cad_model1->compare_order_datas($ord_id, "epo_coat", isset($_POST["sc_epo_coat"]) ? 1 : 0 );
        if (empty($result)) {
            $error["epo_coat_em"] = "Please Check the Epo Coat with the order.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Epo Coat Entered Wrongly');
        }
        $result = $this->cad_model1->compare_order_datas($ord_id, "ep_status", isset($_POST["sc_ep_status"]) ? 1 : 0 );
        if (empty($result)) {
            $error["ep_status_em"] = "Please Check the EP with the order.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'EP Entered Wrongly');
        }
        $result = $this->cad_model1->compare_order_datas($ord_id, "nano_coat", isset($_POST["sc_nano_coat"]) ? 1 : 0 );
        if (empty($result)) {
            $error["nano_coat_em"] = "Please Check the Coat with the order.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Nano Coat Entered Wrongly');
        }
        $result = $this->cad_model1->compare_order_datas($ord_id, "ultra_nano", isset($_POST["sc_ultra_nano"]) ? 1 : 0 );
        if (empty($result)) {
            $error["ultra_nano_em"] = "Please Check the Blue Nano with the order.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Blue Nano Entered Wrongly');
        }
        //$result = $this->cad_model1->compare_order_datas($ord_id, "premium_status", isset($_POST["sc_premium"]) ? 1 : 0 );
       // if (empty($result)) {
       //     $error["premium_status_em"] = "Please Check the Premium with the order.";
       //     $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Premium Entered Wrongly');
       // }
        /*if (!isset($_POST['sc_back_etch'])) {
            $error["back_etch_em"] = "Please Check back etch with the order.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Back Etch Entered Wrongly');
        }*/
        if (!isset($_POST['sc_cp_1'])) {
            $error["cust_instr_em"] = "Please review customer instructions.";
        }
        if (!isset($_POST['sc_cp_2'])) {
            $error["check_drawing_em"] = "Please check all the files.";
        } 
        if (!isset($_POST['sc_cp_3'])) {
            $error["silkscr_check_em"] = "Please check all the screens.";
        } else
        if (!isset($_POST['sc_cp_4'])) {
            $error["spl_instr_em"] = "Please verify special instructions.";
        }

        $data['checklist_stats'] = $this->cad_model1->get_checklist_stats($_POST['order_status_id']);
        if (!$data['checklist_stats']){
            if($_POST["sc_file_reference"]==""){
                $error["file_upload_em"] = "Please Upload Files.";
            }
        }
        //Save Data
        if (empty($error)) {
            $url_value = $this->uri->segment(3);
            if (!empty($url_value)) {
                $data = $_POST; 
                $cad_update['aper_content']=$data['sc_aperture_count']; 
                $cad_update['bord']=isset($_POST["sc_border_used"]) ? $_POST["sc_border_used"] : "" ;
                $cad_update_status = $this->cad_model1->cad_update($cad_update,$data['ord_id'],$data['job_id']);

                $data["sc_lead_free"]=isset($data["sc_lead_free"]) ? 1 : 0 ;
                $data["sc_epo_coat"]=isset($data["sc_epo_coat"]) ? 1 : 0 ;
                $data["sc_tension_material"]=isset($data["sc_tension_material"]) ? 1 : 0 ;
                $data["sc_datum_fg"]=isset($data["sc_datum_fg"]) ? 1 : 0 ;
                $data["sc_nano_coat"]=isset($data["sc_nano_coat"]) ? 1 : 0 ;
                $data["sc_aculon_nano"]=isset($data["sc_aculon_nano"]) ? 1 : 0 ;
                $data["sc_double_epoxy"]=isset($data["sc_double_epoxy"]) ? 1 : 0 ;
                $data["sc_ship_tooling"]=isset($data["sc_ship_tooling"]) ? 1 : 0 ;
                $data["sc_ship_plot"]=isset($data["sc_ship_plot"]) ? 1 : 0 ;
                $data["sc_ship_template"]=isset($data["sc_ship_template"]) ? 1 : 0 ;
                $data["sc_premium"]=isset($data["sc_premium"]) ? 1 : 0 ;
                $data["sc_s_sample"]=isset($data["sc_s_sample"]) ? 1 : 0 ;
                $data["sc_scaling"]=isset($data["sc_scaling"]) ? 1 : 0 ;
                $data["sc_back_etch"]=isset($data["sc_back_etch"]) ? 1 : 0 ;
                $data["sc_premount_status"]=isset($data["sc_premount_status"]) ? 1 : 0 ;
                $data["sc_ep_status"]=isset($data["sc_ep_status"]) ? 1 : 0 ;
                $data["sc_ultra_nano"]=isset($data["sc_ultra_nano"]) ? 1 : 0 ;
               
               
	

                //print_r($data);exit;
                $job_id=$data['job_id'];
                unset($data['job_id']);
                $data['sc_completed']=1; // this line is used to identify stencil check list completed
                $data['checklist_stats'] = $this->cad_model1->get_checklist_stats($data['order_status_id']);
                 if(isset($data['step_checkbox']))
				 { 
				  $data['step_status']=$data['step_checkbox'];
				  unset($data['step_checkbox']);
				 }
				 else
				 {
					$data['step_status']=0;
				 }
				
				
				
                if (!$data['checklist_stats']){
                    $data["user_id"]= $this->session->userdata('user_id');
                    $cad_checklist_id = $this->cad_model1->checklist_data($data);
                }else{
                    $this->cad_model1->update_checklist($data);
                    $cad_checklist_id = $data['checklist_stats'];
                }
                
                if($data["sc_file_reference"]!=""){
                    $checklist_upload['order_status_id']=$data['order_status_id'];
                    $checklist_upload['cad_checklist_id']=$cad_checklist_id;
                    $checklist_upload['files']=$data['sc_file_reference'];
                    $checklist_upload['update_by']=$this->session->userdata('user_id');
                    $checklist_upload['user_type']=$this->session->userdata('user_type');
                    $checklist_upload['checklist_type']=5;
                    $checklist_upload['created_on']=date('Y-m-d H:i:s');
                                      
                    $checklist_upload['status']=1;
                    $checklist_upload_status = $this->cad_model1->checklist_insert_upload($checklist_upload);
                }
                if($data["sc_file_reference"]==""){
                    unset($data["sc_file_reference"]);
                }
                $this->cad_model1->delete_fiducials($cad_checklist_id);
                foreach ($fiducial_qty as $key => $fiducial) {
                    $fiducial_save_array = array(
                        "cad_checklist_id" => $cad_checklist_id,
                        "fiducial_quantity" => $fiducial
                        );
                    $this->cad_model1->fiducial_qty($fiducial_save_array);
                }
                foreach ($fiducial_dcode as $key => $fiducial) {
                    $fiducial_save_array = array(
                        "cad_checklist_id" => $cad_checklist_id,
                        "fiducial_dcode" => $fiducial
                        );
                    $this->cad_model1->fiducial_dcode($fiducial_save_array);
                }
                foreach ($foil_thickness as $key => $foil) {
                    $foil_thickness_save = array(
                        "cad_checklist_id" => $cad_checklist_id,
                        "thickness" => $foil
                        );
                    $this->cad_model1->foil_thickness($foil_thickness_save);
                }

                // update apeature count in order table

                 $orderapeature = $this->cad_model1->update_order_apeature($data['ord_id'],$data['sc_aperture_count']);
                 $orderpremium= $this->cad_model1->update_premium($data['ord_id'],$data["sc_premium"]);
                 $orderbacketch = $this->cad_model1->update_backetch($data['ord_id'],$data["sc_back_etch"]);

                $order_code=get_order_code($data['ord_id']); //get order_code from order id using common helper
                //print_r($order_code['order_code']);
                $chklst=get_checklist($order_code['order_code']); //getting check list compare list from common function
                $checklist_complete = $this->cad_model1->checklist_status($chklst); //checking the check list completed or not using check list conditions
                if(!empty($checklist_complete)) { //if check list completed the insert the following $cad values to laser department
                    $cad['cad_checklist_completed'] = 1;
                    $cad['cad_remarks'] = $data['sc_notes'];
                    $cad['id'] = $data["order_status_id"];
                    $cad['ord_id'] = $data['ord_id'];
                    $cad['job_id'] = $job_id;

               $this->cad_model1->notes_to_laser($cad);//inserting the $cad values to the laser department
               $update['cad_remarks']= $data['sc_notes'];
               $update['cad_completed_time']= date('Y-m-d H:i:s');
               $update['cad_checklist_completed']=1;
               $this->cad_model1->staus_change_order_status($data["order_status_id"],$update);//update checklist complete status to tbl_order_status
           }
       }
       $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Checklist Completed');
       $success["status"] = "true";
       $success["message"] = "Checklist values matched the Order.";
       $success["cad_checklist_id"] = $cad_checklist_id;
       echo json_encode($success);
   } else {
    $error["status"] = "false";
    echo json_encode($error);
}
exit;
}
public function print_stncil_checklist() {        
    $data['id'] = $_GET['id'];
    $data['print_data'] = $this->cad_model1->print_data($data);
    $data['print_data'] = $data['print_data'][0];
    $data['stencil_foil_thik']= $this->cad_model1->get_checklist_foil($data['id']);

    if($data['stencil_foil_thik'][0]->thickness){ $data['stencil_foil'][] = $data['stencil_foil_thik'][0]->thickness; }
    if($data['stencil_foil_thik'][0]->thickness){ $data['stencil_foil'][] = $data['stencil_foil_thik'][1]->thickness; }
    if($data['stencil_foil_thik'][0]->thickness){ $data['stencil_foil'][] = $data['stencil_foil_thik'][2]->thickness; }
    $data['foil_thikness'] = implode('/',array_filter($data['stencil_foil']));

    $data['stencil_decode']= $this->cad_model1->get_checklist_decode($data['id']);
    $data['stencil_quantity']= $this->cad_model1->get_checklist_quantity($data['id']);
    $uploaded_files=array_filter(explode(',',$data['print_data']['sc_file_reference']));
    $html=$this->load->view('print/print/stencilchecklist_print',$data, true);
    $path=STENCIL_PDF_STORE_PATH.'/'.$data['print_data']['job_code'];
    (!is_dir($path)) ? mkdir($path, 0755, true) : ""; 
    $pdfFilePath = $path.'/'.$data['print_data']['job_code']."_checklist.pdf";
    $this->load->library('m_pdf');
    /*if(!empty($uploaded_files)){
        $this->m_pdf->pdf->SetImportUse(); 
        foreach( $uploaded_files as $key => $uploaded_file){
            $file=STENCIL_CHECKLIST_UPLOAD_PATH.'/'.$data['print_data']['job_code'].'/'.$uploaded_file;
            if(file_exists($file)){
                $pagecount = $this->m_pdf->pdf->SetSourceFile($file);
                for ($i=1; $i<=$pagecount; $i++) {
                    $this->m_pdf->pdf->AddPage('P','', '', '', '',30,30,30,30,18,12);
                    $import_page = $this->m_pdf->pdf->ImportPage($i);
                    $size = $this->m_pdf->pdf->getTemplateSize($import_page);
                    if($size['w'] > 300){
                        $import_page = $this->m_pdf->pdf->ImportPage($i, 0,0,3500,4000);
                        $this->m_pdf->pdf->UseTemplate($import_page,0,0,1200,1200);
                    }else{
                        $this->m_pdf->pdf->UseTemplate($import_page,null, null, 0, 0, true);
                    }
                }
            }
        }
    }*/
    $this->m_pdf->pdf->WriteHTML($html);
    $this->m_pdf->pdf->Output($pdfFilePath, "F"); 
    if (file_exists($pdfFilePath)) {
        $success["status"] = "true";
        $success["message"] = "Checklist File generated";
        $success["checklist"] = 1;
        echo json_encode($success);
    }else{
        $failure["status"] = "false";
        $failure["message"] = "Checklist File generation failed";
        $failure["checklist"] = 0;
        echo json_encode($failure);
    }

}
public function print_pdf_checklist() {   
    $this->load->library('m_pdf');

    $this->m_pdf->pdf->WriteHTML('Your Introduction');
    $this->m_pdf->pdf->AddPage('L','','','','',50,50,50,50,10,10);
    $this->m_pdf->pdf->WriteHTML('Your Book text');
    $this->m_pdf->pdf->AddPage('P','','','','',50,50,50,50,10,10);
    $this->m_pdf->pdf->Output($pdfFilePath, "I"); 
}
public function print_rework_checklist_type1() {        
    $data['id'] = $_GET['id'];
    $data['print_data'] = $this->cad_model1->print_data($data);
    //print_r($data['print_data']);exit;
    $data['print_data'] = $data['print_data'][0];
    $data['stencil_foil']= $this->cad_model1->get_checklist_foil($data['id']);
    $data['stencil_decode']= $this->cad_model1->get_checklist_decode($data['id']);
    $data['stencil_quantity']= $this->cad_model1->get_checklist_quantity($data['id']);
    $uploaded_files=array_filter(explode(',',$data['print_data']['rc_rb_file']));
    //echo "<pre>";print_r($data);exit;
    if(($data['print_data']['rc_rb_full_kit']==1)||($data['print_data']['rc_rb_print_frame']==1)||($data['print_data']['rc_rb_print_foil']==1)||($data['print_data']['rc_rb_reball_frame']==1)||($data['print_data']['rc_rb_reball_foil']==1)||($data['print_data']['rc_rb_window_foil']==1)||($data['print_data']['rc_rb_insert']==1)||($data['print_data']['rc_rb_reball_base']==1)){
        $html=$this->load->view('print/print/reball',$data, true);
    }elseif(($data['print_data']['rc_rb_replace_kit']==1)||($data['print_data']['rc_rb_replace_print_foil']==1)||($data['print_data']['rc_rb_replace_reball_foil']==1)||($data['print_data']['rc_rb_replace_window_foil']==1)||($data['print_data']['rc_rb_replace_insert']==1)){
        $html=$this->load->view('print/print/reballreplacement',$data, true);
    }else{
         $html=$this->load->view('print/print/reballcustom',$data, true);
    }
    $path=REWORK_PDF_STORE_PATH.'/'.$data['print_data']['job_code'];
    (!is_dir($path)) ? mkdir($path, 0755, true) : ""; 
    $pdfFilePath= $path.'/'.$data['print_data']['job_code']."_checklist.pdf";
    $this->load->library('m_pdf');
    /*if(!empty($uploaded_files)){
        $this->m_pdf->pdf->SetImportUse(); 
        foreach( $uploaded_files as $key => $uploaded_file){
            $file=REWORK_CHECKLIST_UPLOAD1_PATH.'/'.$data['print_data']['job_code'].'/'.$uploaded_file; 
            //print_r($file);exit;
            if(file_exists($file)){ 
                $pagecount = $this->m_pdf->pdf->SetSourceFile($file); 
                for ($i=1; $i<=$pagecount; $i++) {
                    $import_page = $this->m_pdf->pdf->ImportPage($i);
                    $this->m_pdf->pdf->UseTemplate($import_page);
                    if ($i <= $pagecount){
                        $this->m_pdf->pdf->AddPage();
                    }
                }
            }
        }
    }*/
    $this->m_pdf->pdf->WriteHTML($html);
    $this->m_pdf->pdf->Output($pdfFilePath, "F"); 

    if (file_exists($pdfFilePath)) {
        $success["status"] = "true";
        $success["message"] = "Checklist File generated";
        $success["checklist"] = 1;
        echo json_encode($success);
    }else{
        $failure["status"] = "false";
        $failure["message"] = "Checklist File generation failed";
        $failure["checklist"] = 0;
        echo json_encode($failure);
    }


}
public function print_rework_checklist_type2() {        
    $data['id'] = $_GET['id'];
    $data['print_data'] = $this->cad_model1->print_data($data);
//print_r($data['print_data']);exit;
    $data['print_data'] = $data['print_data'][0];
    $data['stencil_foil']= $this->cad_model1->get_checklist_foil($data['id']);
    $data['stencil_decode']= $this->cad_model1->get_checklist_decode($data['id']);
    $data['stencil_quantity']= $this->cad_model1->get_checklist_quantity($data['id']);
//echo "<pre>";print_r($data);exit;
    $uploaded_files=array_filter(explode(',',$data['print_data']['rc_pp_file']));
    if(($data['print_data']['rc_pp_full_kit']==1)||($data['print_data']['rc_pp_spring_cover']==1)||($data['print_data']['rc_pp_nest_foil']==1)||($data['print_data']['rc_pp_print_foil']==1)||($data['print_data']['rc_pp_base_frame']==1)){
        $html=$this->load->view('print/print/print',$data, true);
    }elseif(($data['print_data']['rc_pp_replace_kit']==1)||($data['print_data']['rc_pp_replace_nest_foil']==1)||($data['print_data']['rc_pp_replace_print_foil']==1)){
        $html=$this->load->view('print/print/printreplacement',$data, true);
    }else{
         $html=$this->load->view('print/print/printcustom',$data, true);
    }
    $path=REWORK_PDF_STORE_PATH.'/'.$data['print_data']['job_code'];
    (!is_dir($path)) ? mkdir($path, 0755, true) : ""; 
    $pdfFilePath= $path.'/'.$data['print_data']['job_code']."_checklist.pdf";
    $this->load->library('m_pdf');
    /*if(!empty($uploaded_files)){
        $this->m_pdf->pdf->SetImportUse(); 
        foreach( $uploaded_files as $key => $uploaded_file){
            $file=REWORK_CHECKLIST_UPLOAD2_PATH.'/'.$data['print_data']['job_code'].'/'.$uploaded_file; 
            //print_r($file);exit;
            if(file_exists($file)){ 
                $pagecount = $this->m_pdf->pdf->SetSourceFile($file); 
                for ($i=1; $i<=$pagecount; $i++) {
                    $import_page = $this->m_pdf->pdf->ImportPage($i);
                    $this->m_pdf->pdf->UseTemplate($import_page);
                    if ($i <= $pagecount){
                        $this->m_pdf->pdf->AddPage();
                    }
                }
            }
        }
    }*/
    $this->m_pdf->pdf->WriteHTML($html);
    $this->m_pdf->pdf->Output($pdfFilePath, "F"); 

    if (file_exists($pdfFilePath)) {
        $success["status"] = "true";
        $success["message"] = "Checklist File generated";
        $success["checklist"] = 1;
        echo json_encode($success);
    }else{
        $failure["status"] = "false";
        $failure["message"] = "Checklist File generation failed";
        echo json_encode($failure);
    }


}
public function print_rework_checklist_type3() {        
    $data['id'] = $_GET['id'];
    $data['print_data'] = $this->cad_model1->print_data($data);
    //print_r($data['print_data']);exit;
    $data['print_data'] = $data['print_data'][0];
    $data['stencil_foil']= $this->cad_model1->get_checklist_foil($data['id']);
    $data['stencil_decode']= $this->cad_model1->get_checklist_decode($data['id']);
    $data['stencil_quantity']= $this->cad_model1->get_checklist_quantity($data['id']);
    //echo "<pre>";print_r($data);exit;
    $uploaded_files=array_filter(explode(',',$data['print_data']['rc_ms_file']));
    if($data['print_data']['rc_ms_type']=='Type 1'){
        $html=$this->load->view('print/print/Ministencil_type1',$data, true);
    }elseif($data['print_data']['rc_ms_type']=='Type 2'){
        $html=$this->load->view('print/print/Ministencil_type2',$data, true);
    }else{
        $html=$this->load->view('print/print/Ministencil_type3',$data, true);
    }
    $path=REWORK_PDF_STORE_PATH.'/'.$data['print_data']['job_code'];
    (!is_dir($path)) ? mkdir($path, 0755, true) : ""; 
    $pdfFilePath= $path.'/'.$data['print_data']['job_code']."_checklist.pdf";
    $this->load->library('m_pdf');
    /*if(!empty($uploaded_files)){
        $this->m_pdf->pdf->SetImportUse(); 
        foreach( $uploaded_files as $key => $uploaded_file){
            $file=REWORK_CHECKLIST_UPLOAD3_PATH.'/'.$data['print_data']['job_code'].'/'.$uploaded_file; 
            //print_r($file);exit;
            if(file_exists($file)){ 
                $pagecount = $this->m_pdf->pdf->SetSourceFile($file); 
                for ($i=1; $i<=$pagecount; $i++) {
                    $import_page = $this->m_pdf->pdf->ImportPage($i);
                    $this->m_pdf->pdf->UseTemplate($import_page);
                    if ($i <= $pagecount){
                        $this->m_pdf->pdf->AddPage();
                    }
                }
            }
        }
    }*/
    $this->m_pdf->pdf->WriteHTML($html);
    $this->m_pdf->pdf->Output($pdfFilePath, "F"); 

    if (file_exists($pdfFilePath)) {
        $success["status"] = "true";
        $success["message"] = "Checklist File generated";
        $success["checklist"] = 1;
        echo json_encode($success);
    }else{
        $failure["status"] = "false";
        $failure["message"] = "Checklist File generation failed";
        echo json_encode($failure);
    }
}
public function print_template_checklist() {        
    $data['id'] = $_GET['id'];
    $data['print_data'] = $this->cad_model1->print_data($data);
    $data['print_data'] = $data['print_data'][0];
    $uploaded_files=array_filter(explode(',',$data['print_data']['tc_file']));
    $html=$this->load->view('print/print/templates',$data, true);
    $path=TEMPLATE_PDF_STORE_PATH;
    (!is_dir($path)) ? mkdir($path, 0755, true) : ""; 
    $pdfFilePath= $path.'/'.$data['print_data']['job_code'].".pdf";
    $this->load->library('m_pdf');
    if(!empty($uploaded_files)){
        $this->m_pdf->pdf->SetImportUse(); 
        foreach( $uploaded_files as $key => $uploaded_file){
            $file=TEMPLATE_CHECKLIST_UPLOAD_PATH.'/'.$data['print_data']['job_code'].'/'.$uploaded_file; 
            //print_r($file);exit;
            if(file_exists($file)){ 
                $pagecount = $this->m_pdf->pdf->SetSourceFile($file); 
                for ($i=1; $i<=$pagecount; $i++) {
                    $import_page = $this->m_pdf->pdf->ImportPage($i);
                    $this->m_pdf->pdf->UseTemplate($import_page);
                    if ($i <= $pagecount){
                        $this->m_pdf->pdf->AddPage();
                    }
                }
            }
        }
    }
    $this->m_pdf->pdf->WriteHTML($html);
    $this->m_pdf->pdf->Output($pdfFilePath, "F"); 

    if (file_exists($pdfFilePath)) {
        $success["status"] = "true";
        $success["message"] = "Checklist File generated";
        echo json_encode($success);
    }else{
        $failure["status"] = "false";
        $failure["message"] = "Checklist File generation failed";
        echo json_encode($failure);
    }

}
public function print_spinplate_checklist() {        
    $data['id'] = $_GET['id'];
    $data['print_data'] = $this->cad_model1->print_data($data);
    $data['print_data'] = $data['print_data'][0];
    $uploaded_files=array_filter(explode(',',$data['print_data']['spc_file']));
    $html=$this->load->view('print/print/spinplate',$data, true);
    $path=SPINPLATE_PDF_STORE_PATH;
    (!is_dir($path)) ? mkdir($path, 0755, true) : ""; 
    $pdfFilePath= $path.'/'.$data['print_data']['job_code'].".pdf";
    $this->load->library('m_pdf');
    if(!empty($uploaded_files)){
        $this->m_pdf->pdf->SetImportUse(); 
        foreach( $uploaded_files as $key => $uploaded_file){
            $file=SPINPLATE_CHECKLIST_UPLOAD_PATH.'/'.$data['print_data']['job_code'].'/'.$uploaded_file;
            if(file_exists($file)){ 
                $pagecount = $this->m_pdf->pdf->SetSourceFile($file); 
                for ($i=1; $i<=$pagecount; $i++) {
                    $import_page = $this->m_pdf->pdf->ImportPage($i);
                    $this->m_pdf->pdf->UseTemplate($import_page);
                    if ($i <= $pagecount){
                        $this->m_pdf->pdf->AddPage();
                    }
                }
            }
        }
    }
    $this->m_pdf->pdf->WriteHTML($html);
    $this->m_pdf->pdf->Output($pdfFilePath, "F"); 

    if (file_exists($pdfFilePath)) {
        $success["status"] = "true";
        $success["message"] = "Checklist File generated";
        echo json_encode($success);
    }else{
        $failure["status"] = "false";
        $failure["message"] = "Checklist File generation failed";
        echo json_encode($failure);
    }
}
public function print_fixit_checklist() {        
    $data['id'] = $_GET['id'];
    $data['print_data'] = $this->cad_model1->print_data($data);
    $data['print_data'] = $data['print_data'][0];
    $uploaded_files=array_filter(explode(',',$data['print_data']['fc_file']));
    $html=$this->load->view('print/print/fixit',$data, true);
    $path=FIXIT_PDF_STORE_PATH;
    (!is_dir($path)) ? mkdir($path, 0755, true) : ""; 
    $pdfFilePath= $path.'/'.$data['print_data']['job_code'].".pdf";
    $this->load->library('m_pdf');
    if(!empty($uploaded_files)){
        $this->m_pdf->pdf->SetImportUse(); 
        foreach( $uploaded_files as $key => $uploaded_file){
            $file=FIXIT_CHECKLIST_UPLOAD_PATH.'/'.$data['print_data']['job_code'].'/'.$uploaded_file; 
            //print_r($file);exit;
            if(file_exists($file)){ 
                $pagecount = $this->m_pdf->pdf->SetSourceFile($file); 
                for ($i=1; $i<=$pagecount; $i++) {
                    $import_page = $this->m_pdf->pdf->ImportPage($i);
                    $this->m_pdf->pdf->UseTemplate($import_page);
                    if ($i <= $pagecount){
                        $this->m_pdf->pdf->AddPage();
                    }
                }
            }
        }
    }
    $this->m_pdf->pdf->WriteHTML($html);
    $this->m_pdf->pdf->Output($pdfFilePath, "F"); 

    if (file_exists($pdfFilePath)) {
        $success["status"] = "true";
        $success["message"] = "Checklist File generated";
        echo json_encode($success);
    }else{
        $failure["status"] = "false";
        $failure["message"] = "Checklist File generation failed";
        echo json_encode($failure);
    }
}

    protected function checklist_error_log($order_status_id, $update_status, $update_remarks) {
        $data['order_status_id'] = $order_status_id;
        $data['update_status'] = $update_status;
        $data['update_remarks'] = $update_remarks;
        $this->cad_model1->error_log($data);
    }

    public function compare_check_multi_list() {
        //print_r($_POST);exit;
        $result = $this->cad_model1->compare_order_datas($_POST["order_id"], $_POST["to_check"], ($_POST["value"] == 'true') ? 1 : 0 );
//print_r($result);exit;
        if (empty($result)) {
            $error[$_POST["to_check"] . "_em"] = "Please Check the " . $_POST["label_disp"] . " with the order.";
            echo json_encode($error);
        } else {
            $success[$_POST["to_check"] . "_em"] = "";
            echo json_encode($success);
        }
        exit;
    }

    public function get_borders() {
        //echo $_POST['value'];
        if(($_POST["value"] != 'Custom Foil')&&($_POST["value"] != 'Custom Frame')){
            $result = $this->cad_model1->get_frame_size($_POST["order_id"]);
            if((($result == "-1") OR ($result == "-2"))){
                echo'<input class="form-control" type="text" name="sc_border_used" id="sc_border_used" data-id="sc_border_used" STYLE="padding:0;">';
            }else{
                $results = $this->cad_model1->get_borders($_POST["value"]);
                echo'<select class="form-control" name="sc_border_used" id="sc_border_used" data-id="sc_border_used" STYLE="padding:0;">';
                echo "<option>Select Border</option>";
                if (!empty($results)) {
                    foreach ($results as $result) {
                        echo "<option value='".$result["border_size"] ."'>".$result["border_size"]."</option>";
                    }
                }
                echo '</select>';
            }
        }else{
           echo'<input class="form-control" type="text" name="sc_border_used" id="sc_border_used" data-id="sc_border_used" STYLE="padding:0;">';
        }
        exit;
    }
    
    //below code written By KRISHNAMK
    
    

    public function compare_fixit_checklist(){
       // print_r($_POST);exit;

        $review=isset($_POST['fc_cp_1']) ? 1 : 0 ;
        $rename=isset($_POST['fc_cp_2']) ? 1 : 0 ;
        $save=isset($_POST['fc_cp_3']) ? 1 : 0 ;
        $print=isset($_POST['fc_cp_4']) ? 1 : 0 ;
        $ensure=isset($_POST['fc_cp_5']) ? 1 : 0 ;
        $pad_count=$_POST['fc_pad_count'];
        $ord_id = $_POST["order_id"];
        $order_status_id=$_POST['order_status_id'];

        if(empty($review)){
            $error["fc_review_order_em"] = "Please Check the Order Review.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Order Review Not Entered');
        }

        if(empty($rename)){
            $error["fc_rename_files_em"] = "Please Check the Rename Files.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Rename Files Not Entered');
        }

        if(empty($save)){
            $error["fc_save_layer_em"] = "Please Check the Save Layer.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Save Layer Not Entered');
        }

        if(empty($print)){
            $error["fc_print_high_em"] = "Please Check the Print High.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Print High Not Entered');
        }

        if(empty($ensure)){
            $error["fc_target_layer_em"] = "Please Check the Target Layer.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Target Layer Not Entered');
        }

        if(empty($pad_count)){
            $error["fc_pad_count_em"] = "Please Enter the Pad Count.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Pad Count Not Entered');
        }

        $data['checklist_stats'] = $this->cad_model1->get_checklist_stats($_POST['order_status_id']);
        if (!$data['checklist_stats']){
            if($_POST["fc_file"]==""){
                $error["file_upload_em"] = "Please Upload Files.";
            }
        }

        if (empty($error)) {
            $url_value = $this->uri->segment(3);
            if (!empty($url_value)) {
                $data = $_POST;
                if($data["fc_file"]==""){
                    unset($data["fc_file"]);
                }

                $order_id=$data['order_id'];
                unset($data['order_id']);
                $job_id=$data['job_id'];
                unset($data['job_id']);
                $data["user_id"]= $this->session->userdata('user_id');
                $data['fc_completed']=1; // this line is used to identify stencil check list completed
                $data['checklist_stats'] = $this->cad_model1->get_checklist_stats($data['order_status_id']);
                if (!$data['checklist_stats']){
                    unset($data['job_code']);
                    $cad_checklist_id = $this->cad_model1->checklist_data($data);
                }else{
                    unset($data['job_code']);
                    $this->cad_model1->update_checklist($data);
                    $cad_checklist_id = $data['checklist_stats'];
                }
                $data['ord_id']=$order_id;
                $order_code=get_order_code($data['ord_id']); //get order_code from order id using common helper
                //print_r($order_code['order_code']);
                $chklst=get_checklist($order_code['order_code']);
                
                $checklist_complete = $this->cad_model1->checklist_status($chklst); //checking the check list completed or not using check list conditions
                if(!empty($checklist_complete)) { //if check list completed the insert the following $cad values to laser department
                    $cad['cad_checklist_completed'] = 1;
                    $cad['cad_remarks'] = $data['fc_notes'];
                    $cad['id'] = $data["order_status_id"];
                    $cad['ord_id'] = $order_id;
                    $cad['job_id']= $job_id;
                   $this->cad_model1->notes_to_laser($cad);//inserting the $cad values to the laser department
                   $update['cad_remarks']= $data['fc_notes'];
                   $update['cad_completed_time']= date('Y-m-d H:i:s');
                   $update['cad_checklist_completed']=1;
                   $this->cad_model1->staus_change_order_status($data["order_status_id"],$update);//update checklist complete status to tbl_order_status
               }
           }
           $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Checklist Completed');
           $success["status"] = "true";
           $success["cad_checklist_id"]=$cad_checklist_id;
           $success["message"] = "Checklist values matched the Order.";
           echo json_encode($success);

       }else {
        $error["status"] = "false";
        echo json_encode($error);
    }
    exit;
}

public function compare_spinplate_checklist(){
       // print_r($_POST);exit;

    $spc_cp_1=isset($_POST['spc_cp_1']) ? 1 : 0 ;
    $spc_cp_2=isset($_POST['spc_cp_2']) ? 1 : 0 ;
    $spc_cp_3=isset($_POST['spc_cp_3']) ? 1 : 0 ;
    $spc_cp_4=isset($_POST['spc_cp_4']) ? 1 : 0 ;
    $spc_cp_5=isset($_POST['spc_cp_5']) ? 1 : 0 ;
    $spc_cp_6=isset($_POST['spc_cp_6']) ? 1 : 0 ;
    $spc_cp_7=isset($_POST['spc_cp_7']) ? 1 : 0 ;
    $order_id = $_POST["order_id"];
    $order_status_id=$_POST['order_status_id'];

    if(empty($spc_cp_1)){
        $error["spc_cp_1_em"] = "Please Check the Combine Bottom.";
        $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Combine Bottom Not Entered');
    }

    if(empty($spc_cp_2)){
        $error["spc_cp_2_em"] = "Please Check the Mirror The File.";
        $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Mirror The File Not Entered');
    }

    if(empty($spc_cp_3)){
        $error["spc_cp_3_em"] = "Please Check the Create a New Layer.";
        $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Create a New Layer Not Entered');
    }

    if(empty($spc_cp_4)){
        $error["spc_cp_4_em"] = "Please Check the Add Text To Composite.";
        $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Order Review Not Entered');
    }

    if(empty($spc_cp_5)){
        $error["spc_cp_5_em"] = "Please Check the Add BEAM ON Logo.";
        $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Add BEAM ON Logo Not Entered');
    }

    if(empty($spc_cp_6)){
        $error["spc_cp_6_em"] = "Please Check the Save Outline File.";
        $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Save Outline File Not Entered');
    }

    if(empty($spc_cp_7)){
        $error["spc_cp_7_em"] = "Please Check the Save Composite File.";
        $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Save Composite File Not Entered');
    }
    if (empty($error)) {
     $url_value = $this->uri->segment(3);
     if (!empty($url_value)) {
        $data = $_POST;
        if($data["spc_file"]==""){
            unset($data["spc_file"]);
        }
        $order_id=$data['order_id'];
        unset($data['order_id']);
        $job_id=$data['job_id'];
        unset($data['job_id']);
        unset($data['job_code']);
        	$data["user_id"]= $this->session->userdata('user_id');
                $data['spc_completed']=1; // this line is used to identify stencil check list completed
                $data['checklist_stats'] = $this->cad_model1->get_checklist_stats($data['order_status_id']);
                if (!$data['checklist_stats']){
                    $cad_checklist_id = $this->cad_model1->checklist_data($data);
                }else{
                    unset($data['job_code']);
                    $this->cad_model1->update_checklist($data);
                    $cad_checklist_id = $data['checklist_stats'];
                }
                $data['ord_id']=$order_id;
                $order_code=get_order_code($data['ord_id']); //get order_code from order id using common helper
                //print_r($order_code['order_code']);
                $chklst=get_checklist($order_code['order_code']);
                
                $checklist_complete = $this->cad_model1->checklist_status($chklst); //checking the check list completed or not using check list conditions
                if(!empty($checklist_complete)) { //if check list completed the insert the following $cad values to laser department
                    $cad['cad_checklist_completed'] = 1;
                    $cad['cad_remarks'] = $data['spc_spl_instr'];
                    //$cad['id'] = $data["order_status_id"];
                    $cad['ord_id'] = $order_id;
                    $cad['job_id'] = $job_id;
                   $this->cad_model1->notes_to_laser($cad);//inserting the $cad values to the laser department
                   $update['cad_remarks']= $data['spc_spl_instr'];
                   $update['cad_completed_time']= date('Y-m-d H:i:s');
                   $update['cad_checklist_completed']=1;
                   $this->cad_model1->staus_change_order_status($data["order_status_id"],$update);//update checklist complete status to tbl_order_status
               }
           }
           $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Checklist Completed');
           $success["status"] = "true";
           $success["message"] = "Checklist values matched the Order.";
           $success["cad_checklist_id"]=$cad_checklist_id;
           echo json_encode($success);

       }else {
        $error["status"] = "false";
        echo json_encode($error);
    }
    exit;
}

public function compare_template_checklist(){
    // print_r($_POST);exit;
    $tc_template_type=isset($_POST['tc_template_type']) ? 1 : 0 ;
    $tc_template_type_3_text= isset($_POST["tc_template_type_3_text"]) ? $_POST["tc_template_type_3_text"]: "" ;
    $tc_cp_1=isset($_POST['tc_cp_1']) ? 1 : 0 ;
    $tc_cp_2=isset($_POST['tc_cp_2']) ? 1 : 0 ;
    $tc_temp_size=isset($_POST['tc_temp_size']) ? 1 : 0 ;
    $tc_temp_size1=$_POST['tc_temp_size1'];
    $tc_temp_size2=$_POST['tc_temp_size2'];
    $tc_temp_qty=$_POST['tc_temp_qty'];
    $order_id = $_POST["order_id"];
    $order_status_id=$_POST['order_status_id'];

    if($tc_template_type==0){
        $error["tc_template_type_em"] = "Please Check the Template type.";
        $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Template type Not Entered');
    }elseif(!(empty($tc_template_type_3))){
        if($tc_template_type_3_text==""){
            $error["tc_template_type_em"] = "Please Check the Template type.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Template type Not Entered');
        }
    }

    if(empty($tc_cp_1)){
        $error["tc_cp_1_em"] = "Please Check the Mini.opening size.";
        $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Mini.opening size Not Entered');
    }

    if(empty($tc_cp_2)){
        $error["tc_cp_2_em"] = "Please Check the Polarity Dcode.";
        $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Polarity Dcode Not Entered');
    }

    if(empty($tc_temp_size)){

        if((($tc_temp_size1=="") OR ($tc_temp_size1=""))){
            $error["tc_temp_size_em"] = "Please Check the Template Size.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Template size Not Entered');
        }
    }

    if(empty($tc_temp_qty)){
        $error["tc_temp_qty_em"] = "Please Check the template quantity.";
        $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'template quantity Not Entered');
    }

    if (empty($error)) {
        $url_value = $this->uri->segment(3);
        if (!empty($url_value)) {
            $data = $_POST;
            if($data["tc_file"]==""){
                unset($data["tc_file"]);
        }
                $order_id=$data['order_id'];
                unset($data['order_id']);
                $job_id=$data['job_id'];
                unset($data['job_id']);
                 unset($data['job_code']);
                $data["user_id"]= $this->session->userdata('user_id');
                $data['tc_completed']=1; // this line is used to identify stencil check list completed
                $data['checklist_stats'] = $this->cad_model1->get_checklist_stats($data['order_status_id']);
                if (!$data['checklist_stats']){
                    $cad_checklist_id = $this->cad_model1->checklist_data($data);
                }else{
                    $this->cad_model1->update_checklist($data);
                    $cad_checklist_id = $data['checklist_stats'];
                }
                $data['ord_id']=$order_id;
                $order_code=get_order_code($data['ord_id']); //get order_code from order id using common helper
                //print_r($order_code['order_code']);
                $chklst=get_checklist($order_code['order_code']);
                
                $checklist_complete = $this->cad_model1->checklist_status($chklst); //checking the check list completed or not using check list conditions
                if(!empty($checklist_complete)) { //if check list completed the insert the following $cad values to laser department
                    $cad['cad_checklist_completed'] = 1;
                   // $cad['cad_remarks'] = $data['spc_spl_instr'];
                    //$cad['id'] = $data["order_status_id"];
                    $cad['ord_id'] = $order_id;
                    $cad['job_id'] = $job_id;
                   $this->cad_model1->notes_to_laser($cad);//inserting the $cad values to the laser department
                   //$update['cad_remarks']= $data['spc_spl_instr'];
                   $update['cad_completed_time']= date('Y-m-d H:i:s');
                   $update['cad_checklist_completed']=1;
                   $this->cad_model1->staus_change_order_status($data["order_status_id"],$update);//update checklist complete status to tbl_order_status
                }
            }
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Checklist Completed');
            $success["status"] = "true";
            $success["cad_checklist_id"] = $cad_checklist_id;
            $success["message"] = "Checklist values matched the Order.";
            echo json_encode($success);

        }else {
            $error["status"] = "false";
            echo json_encode($error);
    }
    exit;
}
    public function compare_rework_checklist(){
       // print_r($_POST);exit;
        $order_status_id=$_POST['order_status_id'];
        $rc_completed=$_POST['rc_completed'];

        if($rc_completed==1){

            //form 1
            $cad_checklist_id=$_POST['cad_checklist_id'];
            $rc_rb_foil_thik=$_POST['rc_rb_foil_thik'];
            $rc_rb_ball_thik=$_POST['rc_rb_ball_thik'];
            $rc_rb_window_thik=$_POST['rc_rb_window_thik'];
            $rc_rb_custom_kit=isset($_POST['rc_rb_custom_kit']) ? 1 : 0 ;
      
            $rc_rb_qty=$_POST['rc_rb_qty'];
            $rc_rb_notes=$_POST['rc_rb_notes'];
            $rc_rb_file=$_POST['rc_rb_file'];   
            $rc_rb_type=$_POST['rc_rb_type'];
            $rc_rb_other=$_POST['rc_rb_other'];
            $rc_rb_comp_view=$_POST['rc_rb_comp_view'];
            $rc_rb_window_foil_size=isset($_POST['rc_rb_window_foil_size']) ? 1 : 0 ;
            $rc_rb_wrong_read=isset($_POST['rc_rb_wrong_read']) ? 1 : 0 ;
            $rc_rb_double_ver=isset($_POST['rc_rb_double_ver']) ? 1 : 0 ;

            if($rc_rb_custom_kit!=1){
                if(empty($rc_rb_foil_thik)){
                    $error["rc_rb_foil_thik_em"] = "Please Check the Print Foil Thik.";
                    $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Foil thickness type Not Entered');
                }
                if(empty($rc_rb_ball_thik)){
                    $error["rc_rb_ball_thik_em"] = "Please Check the Ball Foil Thik.";
                    $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Ball thickness type Not Entered');
                }
                if(empty($rc_rb_window_thik)){
                    $error["rc_rb_window_thik_em"] = "Please Check the Window Foil Thik.";
                    $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Window thickness type Not Entered');
                }
            }
            if(empty($rc_rb_qty)){
                $error["rc_rb_qty_em"] = "Please Check the Quantity.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Quantity Not Entered');
            }
            if($rc_rb_type == ""){
                $error["rc_rb_type_em"] = "Please Select Reball Type.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Foil thickness type Not Entered');
            }
            if($rc_rb_type == "OTHER"){
            	if($rc_rb_other == ""){
	                $error["rc_rb_other_em"] = "Please Specify";
                	$this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'reball specify Not Entered');
                }
            }
            if(empty($cad_checklist_id)){
                if(empty($rc_rb_file)){
                    $error["rc_rb_file_em"] = "Please Upload file.";
                    $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'File not uploaded');
                }
           }
            if(empty($rc_rb_comp_view)){
                $error["rc_rb_comp_view_em"] = "Please Check the Component View.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Component View Not Entered');
            }
            if(empty($rc_rb_qty)){
                $error["tc_temp_qty_em"] = "Please Check the template quantity.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'template quantity Not Entered');
            }
            if($rc_rb_window_foil_size==0){
                $error["rc_rb_window_foil_size_em"] = "Please Check the window foil Size .";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'window foil Size Not Checked');
            }
            if($rc_rb_wrong_read==0){
                $error["rc_rb_wrong_read_em"] = "Please Check the wrong reading.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Wrong Reading Not Checked');
            }
            if($rc_rb_double_ver==0){
                $error["rc_rb_double_ver_em"] = "Please Check the Double Verify.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Double Verify Not Checked');
            }
        }elseif($rc_completed==2){
            //form 2
            //$rc_pp_type=isset($_POST['rc_pp_type']) ? 1 : 0 ;
            $cad_checklist_id=$_POST['cad_checklist_id'];
            $rc_pp_foil_thik=$_POST['rc_pp_foil_thik'];
            $rc_pp_foil_thik_nest=$_POST['rc_pp_foil_thik_nest'];
            $rc_pp_qty=$_POST['rc_pp_qty'];
            $rc_pp_comp_view=$_POST['rc_pp_comp_view'];
            $rc_pp_window_foil=isset($_POST['rc_pp_window_foil']) ? 1 : 0 ;
            $rc_pp_wrong_read=isset($_POST['rc_pp_wrong_read']) ? 1 : 0 ;
            $rc_pp_double_ver=isset($_POST['rc_pp_double_ver']) ? 1 : 0 ;
            $rc_pp_notes=$_POST['rc_pp_notes'];
            $rc_pp_file=$_POST['rc_pp_file'];

            if(empty($rc_pp_foil_thik)){
                $error["rc_pp_foil_thik_em"] = "Please Check the Foil Thik.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Foil thickness type Not Entered');
            }
            if(empty($rc_pp_foil_thik_nest)){
                $error["rc_pp_foil_thik_nest_em"] = "Please Check the Foil Thik.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Foil thickness Nest type Not Entered');
            }
            if(empty($rc_pp_qty)){
                $error["rc_pp_qty_em"] = "Please Check the Quantity.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Quantity Not Entered');
            }
            //if($rc_pp_type == 0){
            //   $error["rc_pp_type_em"] = "Please Select Reball Type.";
            //    $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Foil thickness type Not Entered');
            //}
            if(empty($rc_pp_comp_view)){
                $error["rc_pp_comp_view_em"] = "Please Check the Component View.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Component View Not Entered');
            }
            if(empty($rc_pp_qty)){
                $error["tc_temp_qty_em"] = "Please Check the template quantity.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'template quantity Not Entered');
            }
            if(empty($cad_checklist_id)){
                if(empty($rc_pp_file)){
                    $error["rc_pp_file_em"] = "Please Upload file.";
                    $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'File not uploaded');
                }
           }
            if($rc_pp_window_foil==0){
                $error["rc_pp_window_foil_em"] = "Please Check the window foil Size .";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'window foil Size Not Checked');
            }
            if($rc_pp_wrong_read==0){
                $error["rc_pp_wrong_read_em"] = "Please Check the wrong reading.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Wrong Reading Not Checked');
            }
            if($rc_pp_double_ver==0){
                $error["rc_pp_double_ver_em"] = "Please Check the Double Verify.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Double Verify Not Checked');
            }
        }elseif($rc_completed==3){
            //form 3
            $cad_checklist_id=$_POST['cad_checklist_id'];
            $rc_ms_type=isset($_POST['rc_ms_type']) ? 1 : 0 ;
            $rc_ms_foil_thik=$_POST['rc_ms_foil_thik'];
            $rc_ms_qty=$_POST['rc_ms_qty'];
            $rc_ms_comp_view=$_POST['rc_ms_comp_view'];
            $rc_ms_designator=isset($_POST['rc_ms_designator']) ? 1 : 0 ;
            $rc_ms_wrong_read=isset($_POST['rc_ms_wrong_read']) ? 1 : 0 ;
            $rc_ms_double_ver=isset($_POST['rc_ms_double_ver']) ? 1 : 0 ;
            $rc_ms_notes=$_POST['rc_ms_notes'];
            $rc_ms_file=$_POST['rc_ms_file'];
            if(empty($cad_checklist_id)){
                if(empty($rc_ms_file)){
                    $error["rc_ms_file_em"] = "Please Upload file.";
                    $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'File not uploaded');
                }
           } 
            if(empty($rc_ms_foil_thik)){
                $error["rc_ms_foil_thik_em"] = "Please Check the Foil Thik.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Foil thickness type Not Entered');
            }
            if(empty($rc_ms_qty)){
                $error["rc_ms_qty_em"] = "Please Check the Quantity.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Quantity Not Entered');
            }
            if($rc_ms_type == 0){
                $error["rc_ms_type_em"] = "Please Select Reball Type.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Foil thickness type Not Entered');
            }
            if(empty($rc_ms_comp_view)){
                $error["rc_ms_comp_view_em"] = "Please Check the Component View.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Component View Not Entered');
            }
            if(empty($rc_ms_qty)){
                $error["tc_temp_qty_em"] = "Please Check the template quantity.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'template quantity Not Entered');
            }
            if($rc_ms_designator==0){
                $error["rc_ms_designator_em"] = "Please Check the designer ref .";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'window foil Size Not Checked');
            }
            if($rc_ms_wrong_read==0){
                $error["rc_ms_wrong_read_em"] = "Please Check the wrong reading.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Wrong Reading Not Checked');
            }
            if($rc_ms_double_ver==0){
                $error["rc_ms_double_ver_em"] = "Please Check the Double Verify.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Double Verify Not Checked');
            }
        }

        if (empty($error)) {

            $url_value = $this->uri->segment(3);
            if (!empty($url_value)) {
                $data = $_POST;
                $order_id=$data['order_id'];
                $job_id=$data['job_id'];
                $job_code=$data['job_code'];

            if($rc_completed==1){
                $data["rc_rb_full_kit"]=isset($data["rc_rb_full_kit"]) ? 1 : 0 ;
                    $data["rc_rb_print_frame"]=isset($data["rc_rb_print_frame"]) ? 1 : 0 ;
                    $data["rc_rb_print_foil"]=isset($data["rc_rb_print_foil"]) ? 1 : 0 ;
                    $data["rc_rb_reball_frame"]=isset($data["rc_rb_reball_frame"]) ? 1 : 0 ;
                    $data["rc_rb_reball_foil"]=isset($data["rc_rb_reball_foil"]) ? 1 : 0 ;
                    $data["rc_rb_window_foil"]=isset($data["rc_rb_window_foil"]) ? 1 : 0 ;
                    $data["rc_rb_insert"]=isset($data["rc_rb_insert"]) ? 1 : 0 ;
                    $data["rc_rb_reball_base"]=isset($data["rc_rb_reball_base"]) ? 1 : 0 ;
                $data["rc_rb_replace_kit"]=isset($data["rc_rb_replace_kit"]) ? 1 : 0 ;
                    $data["rc_rb_replace_print_foil"]=isset($data["rc_rb_replace_print_foil"]) ? 1 : 0 ;
                    $data["rc_rb_replace_reball_foil"]=isset($data["rc_rb_replace_reball_foil"]) ? 1 : 0 ;
                    $data["rc_rb_replace_window_foil"]=isset($data["rc_rb_replace_window_foil"]) ? 1 : 0 ;
                    $data["rc_rb_replace_insert"]=isset($data["rc_rb_replace_insert"]) ? 1 : 0 ;
                $data["rc_rb_custom_kit"]=isset($data["rc_rb_custom_kit"]) ? 1 : 0 ;
                    $data["rc_rb_custom_print_frame"]=isset($data["rc_rb_custom_print_frame"]) ? 1 : 0 ;
                    $data["rc_rb_custom_print_foil"]=isset($data["rc_rb_custom_print_foil"]) ? 1 : 0 ;
                    $data["rc_rb_custom_reball_frame"]=isset($data["rc_rb_custom_reball_frame"]) ? 1 : 0 ;
                    $data["rc_rb_custom_reball_foil"]=isset($data["rc_rb_custom_reball_foil"]) ? 1 : 0 ;
                    $data["rc_rb_custom_window_foil"]=isset($data["rc_rb_custom_window_foil"]) ? 1 : 0 ;
                    $data["rc_rb_custom_insert"]=isset($data["rc_rb_custom_insert"]) ? 1 : 0 ;
                    $data["rc_rb_custom_reball_base"]=isset($data["rc_rb_custom_reball_base"]) ? 1 : 0 ;
                if($data["rc_rb_file"]==""){
                    unset($data["rc_rb_file"]);
                } 
                
           }
           if($rc_completed==2){
                $data["rc_pp_full_kit"]=isset($data["rc_pp_full_kit"]) ? 1 : 0 ;
                    $data["rc_pp_spring_cover"]=isset($data["rc_pp_spring_cover"]) ? 1 : 0 ;
                    $data["rc_pp_nest_foil"]=isset($data["rc_pp_nest_foil"]) ? 1 : 0 ;
                    $data["rc_pp_print_foil"]=isset($data["rc_pp_print_foil"]) ? 1 : 0 ;
                    $data["rc_pp_base_frame"]=isset($data["rc_pp_base_frame"]) ? 1 : 0 ;
                $data["rc_pp_replace_kit"]=isset($data["rc_pp_replace_kit"]) ? 1 : 0 ;
                    $data["rc_pp_replace_nest_foil"]=isset($data["rc_pp_replace_nest_foil"]) ? 1 : 0 ;
                    $data["rc_pp_replace_print_foil"]=isset($data["rc_pp_replace_print_foil"]) ? 1 : 0 ;
                $data["rc_pp_custom_kit"]=isset($data["rc_pp_custom_kit"]) ? 1 : 0 ;
                if($data["rc_pp_file"]==""){
                    unset($data["rc_pp_file"]);
                }
                
           }
           if($rc_completed==3){
               if($data["rc_ms_file"]==""){
                    unset($data["rc_ms_file"]);
                }
           }
                unset($data['order_id']);
                unset($data['job_code']);
                unset($data['job_id']);
                $data['rc_completed']=1; // this line is used to identify stencil check list completed
                $data["user_id"]= $this->session->userdata('user_id');
                $data['checklist_stats'] = $this->cad_model1->get_checklist_stats($data['order_status_id']);
                if (!$data['checklist_stats']){
                    $cad_checklist_id = $this->cad_model1->checklist_data($data);
                }else{
                    $this->cad_model1->update_checklist($data);
                    $cad_checklist_id = $data['checklist_stats'];
                }

                // rework checklist file upload update
                if(isset($data["rc_rb_file"])){
                    if($data["rc_rb_file"]!=""){
                        $checklist_upload['order_status_id']=$data['order_status_id'];
                        $checklist_upload['cad_checklist_id']=$cad_checklist_id;
                        $checklist_upload['files']=$data['rc_rb_file'];
                        $checklist_upload['update_by']=$this->session->userdata('user_id');
                        $checklist_upload['user_type']=$this->session->userdata('user_type');
                        $checklist_upload['checklist_type']=1;
                        $checklist_upload['created_on']=date('Y-m-d H:i:s');
                        $checklist_upload['status']=1;
                        $checklist_upload_status = $this->cad_model1->checklist_insert_upload($checklist_upload);
                    }
                }
                if(isset($data["rc_pp_file"])){
                    if($data["rc_pp_file"]!=""){
                        $checklist_upload['order_status_id']=$data['order_status_id'];
                        $checklist_upload['cad_checklist_id']=$cad_checklist_id;
                        $checklist_upload['files']=$data['rc_pp_file'];
                        $checklist_upload['update_by']=$this->session->userdata('user_id');
                        $checklist_upload['user_type']=$this->session->userdata('user_type');
                        $checklist_upload['checklist_type']=1;
                        $checklist_upload['created_on']=date('Y-m-d H:i:s');
                        $checklist_upload['status']=1;
                        $checklist_upload_status = $this->cad_model1->checklist_insert_upload($checklist_upload);
                    }
                }
                if(isset($data["rc_ms_file"])){
                    if($data["rc_ms_file"]!=""){
                        $checklist_upload['order_status_id']=$data['order_status_id'];
                        $checklist_upload['cad_checklist_id']=$cad_checklist_id;
                        $checklist_upload['files']=$data['rc_ms_file'];
                        $checklist_upload['update_by']=$this->session->userdata('user_id');
                        $checklist_upload['user_type']=$this->session->userdata('user_type');
                        $checklist_upload['checklist_type']=1;
                        $checklist_upload['created_on']=date('Y-m-d H:i:s');
                        $checklist_upload['status']=1;
                        $checklist_upload_status = $this->cad_model1->checklist_insert_upload($checklist_upload);
                    }
                }
                                

                $data['ord_id']=$order_id;
                $order_code=get_order_code($data['ord_id']); //get order_code from order id using common helper
                //print_r($order_code['order_code']);
                
                $chklst=get_checklist($order_code['order_code']);
                
                $checklist_complete = $this->cad_model1->checklist_status($chklst); //checking the check list completed or not using check list conditions
                if(!empty($checklist_complete)) { //if check list completed the insert the following $cad values to laser department
                    $cad['cad_checklist_completed'] = 1;
                    $cad['id'] = $data["order_status_id"];
                    $cad['job_id'] = $job_id;
                    $cad['ord_id'] = $data['ord_id'];
                   $this->cad_model1->notes_to_laser($cad);//inserting the $cad values to the laser department
                   $update['cad_completed_time']= date('Y-m-d H:i:s');
                   $update['cad_checklist_completed']=1;
                   $this->cad_model1->staus_change_order_status($data["order_status_id"],$update);//update checklist complete status to tbl_order_status
               }
           }
           $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Checklist Completed');
           $success["status"] = "true";
           $success["cad_checklist_id"]=$cad_checklist_id;
           $success["message"] = "Checklist values matched the Order.";
           echo json_encode($success);


       }else {
        $error["status"] = "false";
        echo json_encode($error);
    }
    exit;
}
public function upload() {
    $data['ord_id'] = $_POST['ord_id'];
    $data['job_id'] = $_POST['job_id'];
    $data['ord_ref_id'] = $_POST['job_code'];
    $data['ord_sts_id'] = $_POST['ord_sts_id'];
    $data['order_details']= $this->cad_model1->get_order_detail($data['ord_id']);
    if(($data['order_details']['order_mode']!="FI") && (strpos($data['ord_ref_id'],"S")===false)){
        $data['p3_format'] = $this->cad_model1->get_p3report_format($data["ord_id"]);
        $data['ftp_format'] = $this->cad_model1->get_ftp_format($data["ord_id"]);
        $data['compliance_format'] = $this->cad_model1->get_compliance_format($data["ord_id"]);
        $stencil_side=$this->cad_model1->get_stencil_side($data['ord_id']);
        $check_tss_bss=$this->cad_model1->check_tss_bss($data['ord_id']);
        if ($check_tss_bss==1) {
           $formats=$data['p3_format'];
           if($stencil_side['stencil_side']==1){
               $data['p3_format']=$formats."|tss";
           }elseif ($stencil_side['stencil_side']==2) {
               $data['p3_format']=$formats."|bss";
           }elseif ($stencil_side['stencil_side']==3) {
               $data['p3_format']=$formats."|tss|bss";
           }
       }
       $data['laser_format'] =$this->cad_model1->get_laser_format($data["ord_id"]);
       $data['plot_format'] =$this->cad_model1->get_plot_format($data["ord_id"]);
       $data['lmd_format'] =$this->cad_model1->get_lmd_format($data["ord_id"]);
    }elseif(strpos($data['ord_ref_id'],"S")){
        $data['plot_format'] ="CUT|PLT";
       // echo "<pre>";print_r($data);exit;

    }else{
        $data['lmd_format'] =$this->cad_model1->get_lmd_format($data["ord_id"]);
    }
    $data['upload_count'] = 0;
    if(!empty($data['p3_format'])){
        $data['upload_count'] =$data['upload_count']+count(explode('|',$data['p3_format']));
    }
    if(!empty($data['ftp_format'])){
        $data['upload_count'] =$data['upload_count']+count(explode('|',$data['ftp_format']));
    }
    if(!empty($data['compliance_format'])){
        $data['upload_count'] =$data['upload_count']+count(explode('|',$data['compliance_format']));
    }
    if(!empty($data['laser_format'])){
        $data['upload_count'] =$data['upload_count']+count(explode('|',$data['laser_format']));
    }
    if(!empty($data['plot_format'])){
        $data['upload_count'] =$data['upload_count']+count(explode('|',$data['plot_format']));
    }
    if(!empty($data['lmd_format'])){
        $data['upload_count'] =$data['upload_count']+count(explode('|',$data['lmd_format']));
    }
    //echo "<pre>";print_r($data);exit;
   $this->load->view('cad/upload', $data);
}
public function multifile_upload(){
    $result="denied";
    $other="false";
    $ord_reference_id = $_POST["ord_reference_id"];
    $data["order_status_id"] = $_POST["order_status_id"];
    $data["ord_id"] = $_POST["ord_id"];
        // $file_exist = $this->cad_model1->uploaded_files_details($data["order_status_id"], $_POST['type_of_upload']);
        // $_FILES['file'];

    $name=$_FILES['file']['name'];
    $file_ref=explode('.', $name);
        // print_r($ord_reference_id);exit;
    if ((strcasecmp(substr($file_ref[0], 0,strlen($ord_reference_id)),$ord_reference_id)==0) || ((strcasecmp($file_ref[0],$ord_reference_id."_Compliance")==0) || (stripos($file_ref[0],$ord_reference_id."_plotprint_") !== false) || (stripos($file_ref[0],$ord_reference_id."_5by4") !== false))) {
        $format=substr($_FILES['file']['name'], strpos($_FILES['file']['name'], ".") + 1);
           //print_r($format);exit;
            //$path = APPPATH . '../upload/' . $ord_reference_id.'/'.$format;
            //print_r($path);exit;
        $data['order_details']= $this->cad_model1->get_order_detail($data["ord_id"]);
        
            $data['p3_format'] = $this->cad_model1->get_p3report_format($data["ord_id"]);
            $data['ftp_format'] = $this->cad_model1->get_ftp_format($data["ord_id"]);
            $data['compliance_format'] = $this->cad_model1->get_compliance_format($data["ord_id"]);
            $data['laser_format'] =$this->cad_model1->get_laser_format($data["ord_id"]);
            $data['plot_format'] =$this->cad_model1->get_plot_format($data["ord_id"]);
        
        $data['lmd_format'] =$this->cad_model1->get_lmd_format($data["ord_id"]);
        $stencil_side=$this->cad_model1->get_stencil_side($data['ord_id']);
        $check_tss_bss=$this->cad_model1->check_tss_bss($data['ord_id']);
        if ($check_tss_bss==1) {
           $formats=$data['p3_format'];
           if($stencil_side['stencil_side']==1){
               $data['p3_format']=$formats."|tss";
           }elseif ($stencil_side['stencil_side']==2) {
               $data['p3_format']=$formats."|bss";
           }elseif ($stencil_side['stencil_side']==3) {
               $data['p3_format']=$formats."|tss|bss";
           }
       }
       $data['order_details']= $this->cad_model1->get_order_detail($data["ord_id"]);
        if(($data['order_details']['order_mode']!="FI") && (strpos($ord_reference_id,"S")===false)){
            $files_alloweded=$data['p3_format'].'|'.$data['compliance_format'].'|'.$data['ftp_format'].'|'.$data['lmd_format'].'|'.$data['laser_format'].'|'.$data['plot_format'];
        }elseif(strpos($ord_reference_id,"S")){
            $data['plot_format'] ="CUT|PLT";
            $files_alloweded=$data['plot_format'];
        }else{
            $files_alloweded=$data['lmd_format'];
        }
       $file_formats=explode('|', $files_alloweded);
       $allowed_types=array_unique(array_filter($file_formats));
            //print_r($allowed_types);
            //print_r($_FILES['file']['name']);
       $format = substr($_FILES['file']['name'], strpos($_FILES['file']['name'], ".") + 1);
            //print_r($format);
       foreach ($allowed_types as $key => $allowed_type) {
        if(strcasecmp($format,$allowed_type)==0){
            $result="accepted";
                    /*$plot_formats=explode('|', $data['plot_format']);
                    foreach ($plot_formats as $key => $plot_format) {
                        if(strcasecmp($format,$plot_format)==0){
                            if((stripos($_FILES['file']['name'], "_5by4") !== false)||(stripos($_FILES['file']['name'], "plotprint") !== false)){
                                $result="accepted";
                            }else{
                                $result="denied";
                            }
                        }
                    }*/
                }
            }
            
            $data['ftp'] = $this->cad_model1->get_ftp_mailaddress($data["ord_id"]);
            $data['compliance'] = $this->cad_model1->get_compliance_mailaddress($data["ord_id"]);
            if(!empty($data['ftp_format'])){
                $ftp_file_formats=explode('|', $data['ftp_format']);
                $ftp_allowed_types=array_unique(array_filter($ftp_file_formats));
                foreach ($ftp_allowed_types as $key => $ftp_allowed_type) {
                    if(strcasecmp($format,$ftp_allowed_type)==0){
                        $other="true";
                        $path ='/home/beamon9/customers_ftp/test/test1/'. $data['ftp']['path'];
                        if(is_file($path.'/'.$_FILES['file']['name'])){
                            unlink($path.'/'.$_FILES['file']['name']);
                        }
                        (!is_dir($path)) ? mkdir($path, 0755, true) : "";
                        $config['upload_path'] = $path;
                        $config['allowed_types'] = '*';
                        $this->upload->initialize($config);
                        $this->upload->do_upload('file');
                    }
                }
            }
            if(!empty($data['p3_format'])){
                $p3_file_formats=explode('|', $data['p3_format']);
                $p3_allowed_types=array_unique(array_filter($p3_file_formats));
                foreach ($p3_allowed_types as $key => $p3_allowed_type) {
                    if(strcasecmp($format,$p3_allowed_type)==0){
                        if(stripos($name, "compliance") !== false){
                        }else{
                            $other="true";
                        }
                    }
                }
            }
            $compliance="false";
            if(!empty($data['compliance_format'])){
                $compliance_file_formats=explode('|', $data['compliance_format']);
                $compliance_allowed_types=array_unique(array_filter($compliance_file_formats));
                foreach ($compliance_allowed_types as $key => $compliance_allowed_type) {
                    if(strcasecmp($format,$compliance_allowed_type)==0){
                        $path = '/home/beamon9/public_html/testing/boots2_new/output/compliance/'. $data['compliance']['path'];
                        if(is_file($path.'/'.$_FILES['file']['name'])){
                            unlink($path.'/'.$_FILES['file']['name']);
                        }
                    //if ((strcasecmp($format,'xls')==0)||(strcasecmp($format,'xlsx')==0)) {
                        if(stripos($_FILES['file']['name'], "compliance") !== false){
                           (!is_dir($path)) ? mkdir($path, 0755, true) : "";
                           $config['upload_path'] = $path;
                           $config['allowed_types'] = '*';
                           $this->upload->initialize($config);
                           $this->upload->do_upload('file');
                           $compliance="true";
                       }
                    //}else{
                //        (!is_dir($path)) ? mkdir($path, 0755, true) : "";
                //        $config['upload_path'] = $path;
                //        $config['allowed_types'] = '*';
               //         $this->upload->initialize($config);
               //         $this->upload->do_upload('file');
               //         $compliance="true";
                   //}
                   }
               }
           }
           if(!empty($data['laser_format'])){
            $laser_file_formats=explode('|', $data['laser_format']);
            $laser_allowed_types=array_unique(array_filter($laser_file_formats));
            foreach ($laser_allowed_types as $key => $laser_allowed_type) {
                if((strcasecmp($format,$laser_allowed_type)==0)&&((stripos($_FILES['file']['name'], "compliance") === false))){
                   if (strcasecmp($format,'pdf')==0) {
                       if((stripos( $name, "fire9000") !== false)||(stripos( $name, "plotprint") !== false)||(stripos($name, "plt") !== false)){
                       }else{
                           $path = '/home/beamon9/public_html/testing/boots2_new/output/laser';
                           if(is_file($path.'/'.$_FILES['file']['name'])){
                               unlink($path.'/'.$_FILES['file']['name']);
                           }
                           (!is_dir($path)) ? mkdir($path, 0755, true) : "";
                           $config['upload_path'] = $path;
                           $config['allowed_types'] = '*';
                           $this->upload->initialize($config);
                           $this->upload->do_upload('file');
                       }
                   }else{
                        $path = '/home/beamon9/public_html/testing/boots2_new/output/laser';
                        if(is_file($path.'/'.$_FILES['file']['name'])){
                            unlink($path.'/'.$_FILES['file']['name']);
                        }
                        (!is_dir($path)) ? mkdir($path, 0755, true) : "";
                        $config['upload_path'] = $path;
                        $config['allowed_types'] = '*';
                        $this->upload->initialize($config);
                        $this->upload->do_upload('file');

                    }
                }
            }
        }
    if(!empty($data['lmd_format'])){
        $lmd_file_formats=explode('|', $data['lmd_format']);
        $lmd_allowed_types=array_unique(array_filter($lmd_file_formats));
        foreach ($lmd_allowed_types as $key => $lmd_allowed_type) {
            if(strcasecmp($format,$lmd_allowed_type)==0){
                $path = '/home/beamon9/public_html/testing/boots2_new/output/lmd';
                if(is_file($path.'/'.$_FILES['file']['name'])){
                    unlink($path.'/'.$_FILES['file']['name']);
                }
                (!is_dir($path)) ? mkdir($path, 0755, true) : "";
                $config['upload_path'] = $path;
                $config['allowed_types'] = '*';
                $this->upload->initialize($config);
                $this->upload->do_upload('file');
            }
        }
    }
    $plot="false";
    $plot_stepdown="false";
    if(!empty($data['plot_format'])){
        $plot_file_formats=explode('|', $data['plot_format']);
        $plot_allowed_types=array_unique(array_filter($plot_file_formats));
        foreach ($plot_allowed_types as $key => $plot_allowed_type) {
            if(strcasecmp($format,$plot_allowed_type)==0){
                $path = '/home/beamon9/public_html/testing/boots2_new/output/plot';
                if(is_file($path.'/'.$_FILES['file']['name'])){
                    unlink($path.'/'.$_FILES['file']['name']);
                }
                if ((strcasecmp($format,'pdf')==0)||(strcasecmp($format,'plt')==0)||(strcasecmp($format,'cut')==0)) {
                    if((stripos($_FILES['file']['name'], "plotprint") !== false)||(stripos($_FILES['file']['name'], "plt") !== false)||((strcasecmp($format,'plt')==0)&&(count(explode('_',$_FILES['file']['name']))==2))){
                        $plot="true";
                        if(stripos($_FILES['file']['name'], "plotprint") !== false){
                            $plot_stepdown="true";
                        }
                        (!is_dir($path)) ? mkdir($path, 0755, true) : "";
                        $config['upload_path'] = $path;
                        $config['allowed_types'] = '*';
                        $this->upload->initialize($config);
                        $this->upload->do_upload('file');
                    }

                }
            }
        }
    }
            //print_r($path);exit;
    if($result == "accepted"){

        $path = APPPATH . '../upload/' . $ord_reference_id.'/'.$format;
        if(is_file($path.'/'.$_FILES['file']['name'])){
            unlink($path.'/'.$_FILES['file']['name']);
        }
        (!is_dir($path)) ? mkdir($path, 0755, true) : "";
        $config['upload_path'] = $path;
        $config['allowed_types'] = '*';
        $this->upload->initialize($config);
        if (!$this->upload->do_upload('file')) {
            $error = $this->upload->display_errors();
                    //print_r($error);exit;
            echo json_encode(array("status" => "failure", "message" => $error));
        } else {
            $allfiles="no";
            $uploaded = $this->upload->data();
                    //print_r($uploaded);exit;
            $data["file_name"] = $uploaded["file_name"];
            $data["order_status_id"] = $_POST["order_status_id"];
                   // $data['file_type'] = $_POST['type_of_upload'];
            if (!empty($file_exist)) {
                        //$this->cad_model1->update_archive($data);
            } else {
                        //$this->cad_model1->upload_archive($data);
            }
            echo json_encode(array("status" => "success", "message" => "File Uploaded successfully.", "savedfilename" => $uploaded["file_name"], "filename" => $_FILES["file"]["name"],"format" => $format,"all" => $allfiles,"compliance" => $compliance,"other" => $other,"plot" => $plot,"plot_stepdown" => $plot_stepdown));
        }
    }else{
        echo json_encode(array("status" => "failure", "message" => "File not uploaded.please check Engineers file format"));

    }

}else{
    echo json_encode(array("status" => "failure","filename" => $_FILES["file"]["name"],"savedfilename" => $_FILES["file"]["name"],"message" => "Reference Code Not Match Pleae Check File"));
}


}
public function multifile_remove(){
    $other="false";
        //$file_name = $this->input->post('filename');
    $file_name = str_replace(" ","_",$this->input->post('filename'));
    $format=substr($file_name, strpos($file_name, ".") + 1);
    $ord_reference_id=$this->input->post('ord_reference_id');
    $data['order_details']= $this->cad_model1->get_order_detail($this->input->post('ord_id'));
    if(($data['order_details']['order_mode']!="FI") && (strpos($ord_reference_id,"S")===false)){
        $data['p3_format'] = $this->cad_model1->get_p3report_format($this->input->post('ord_id'));
        $data['ftp_format'] = $this->cad_model1->get_ftp_format($this->input->post('ord_id'));
        $stencil_side=$this->cad_model1->get_stencil_side($this->input->post('ord_id'));
        $data['laser_format'] =$this->cad_model1->get_laser_format($this->input->post('ord_id'));
        $data['plot_format'] =$this->cad_model1->get_plot_format($this->input->post('ord_id'));
        $data['compliance_format'] = $this->cad_model1->get_compliance_format($this->input->post('ord_id'));
        $data['lmd_format'] =$this->cad_model1->get_lmd_format($this->input->post('ord_id'));
    }elseif(strpos($ord_reference_id,"S")){
        $data['plot_format'] ="CUT|PLT";
       // echo "<pre>";print_r($data);exit;

    }else{
        $data['lmd_format'] =$this->cad_model1->get_lmd_format($data["ord_id"]);
    }
    $data['ftp'] = $this->cad_model1->get_ftp_mailaddress($this->input->post('ord_id'));
    $data['compliance'] = $this->cad_model1->get_compliance_mailaddress($this->input->post('ord_id'));
    $path = APPPATH . '../upload/' . $ord_reference_id.'/'.$format.'/'.$file_name;
    if(is_file($path)){
       $compliance="false";
       if(stripos($file_name, "compliance") !== false){
        $compliance="true";
    }
    unlink($path);
    if(!empty($data['p3_format'])){
        $p3_file_formats=explode('|', $data['p3_format']);
        $p3_allowed_types=array_unique(array_filter($p3_file_formats));
        foreach ($p3_allowed_types as $key => $p3_allowed_type) {
            if(strcasecmp($format,$p3_allowed_type)==0){
                if(stripos($file_name, "compliance") !== false){
                }else{
                    $other="true";
                }
            }
        }
    }
    if(!empty($data['ftp_format'])){
        $ftp_file_formats=explode('|', $data['ftp_format']);
        $ftp_allowed_types=array_unique(array_filter($ftp_file_formats));
        foreach ($ftp_allowed_types as $key => $ftp_allowed_type) {
            if(strcasecmp($format,$ftp_allowed_type)==0){
                $other="true";
                $path = '/home/beamon9/customers_ftp/test/test1/'. $data['ftp']['path'].'/'.$file_name;
                if(is_file($path)){
                    unlink($path);
                }
            }
        }
    }
    if(!empty($data['compliance_format'])){
        $compliance_file_formats=explode('|', $data['compliance_format']);
        $compliance_allowed_types=array_unique(array_filter($compliance_file_formats));
        foreach ($compliance_allowed_types as $key => $compliance_allowed_type) {
            if(strcasecmp($format,$compliance_allowed_type)==0){
                $path = '/home/beamon9/public_html/testing/boots2_new/output/compliance/'. $data['compliance']['path'].'/'.$file_name;
                if(is_file($path)){
                    unlink($path);
                }
            }
        }
    }
    if(!empty($data['laser_format'])){
        $laser_file_formats=explode('|', $data['laser_format']);
        $laser_allowed_types=array_unique(array_filter($laser_file_formats));
        foreach ($laser_allowed_types as $key => $laser_allowed_type) {
            if(strcasecmp($format,$laser_allowed_type)==0){
                $path = '/home/beamon9/public_html/testing/boots2_new/output/laser'.'/'.$file_name;
                if(is_file($path)){
                    unlink($path);
                }
            }
        }
    }
    if(!empty($data['lmd_format'])){
        $lmd_file_formats=explode('|', $data['lmd_format']);
        $lmd_allowed_types=array_unique(array_filter($lmd_file_formats));
        foreach ($lmd_allowed_types as $key => $lmd_allowed_type) {
            if(strcasecmp($format,$lmd_allowed_type)==0){
                $path = '/home/beamon9/public_html/testing/boots2_new/output/lmd'.'/'.$file_name;
                if(is_file($path)){
                    unlink($path);
                }
            }
        }
    }
    $plot="false";
    $plot_stepdown="false";
    if(!empty($data['plot_format'])){
        $plot_file_formats=explode('|', $data['plot_format']);
        $plot_allowed_types=array_unique(array_filter($plot_file_formats));
        foreach ($plot_allowed_types as $key => $plot_allowed_type) {
            if(strcasecmp($format,$plot_allowed_type)==0){
                $path = '/home/beamon9/public_html/testing/boots2_new/output/plot'.'/'.$file_name;
                if(is_file($path)){
                    unlink($path);
                    if(stripos($file_name, "plotprint") !== false){
                        $plot_stepdown="true";
                    }
                    $plot="true";
                }
            }
        }
    }
    echo json_encode(array("status" => "success", "message" => "File Removed successfully.", "removedfilename" => $file_name, "filename" => $file_name,"format" => $format,"compliance" => $compliance,"other" => $other,"plot" => $plot,"plot_stepdown" => $plot_stepdown));

}else{
    echo json_encode(array("status" => "failure", "message" => "File Not Exists","removedfilename" => $file_name, "filename" => $file_name,"format" => $format));

}
}
public function multifile_upload_mail(){
    $this->load->library('email');
    $this->email->clear();
    $data = $_POST;
    $ord_id=$this->input->post('ord_id');
    $job_id=$this->input->post('job_id');
    $ord_reference_id=$this->input->post('ord_ref_id');
    $ref_no=$ord_reference_id;
    $data['p3'] = $this->cad_model1->get_p3report_mailaddress($ord_id);
    $data['ftp'] = $this->cad_model1->get_ftp_mailaddress($ord_id);
    $data['compliance'] = $this->cad_model1->get_compliance_mailaddress($ord_id);
    $stencil_side=$this->cad_model1->get_stencil_side($ord_id);
    $check_tss_bss=$this->cad_model1->check_tss_bss($data['ord_id']);
    if ($check_tss_bss==1) {
       $formats=$data['p3']['file_ext'];
       if($stencil_side['stencil_side']==1){
           $data['p3']['file_ext']=$formats."|tss";
       }elseif ($stencil_side['stencil_side']==2) {
           $data['p3']['file_ext']=$formats."|bss";
       }elseif ($stencil_side['stencil_side']==3) {
           $data['p3']['file_ext']=$formats."|tss|bss";
       }
   }
   $data['laser_format'] =$this->cad_model1->get_laser_format($this->input->post('ord_id'));
   $data['lmd_format'] =$this->cad_model1->get_lmd_format($this->input->post('ord_id'));
   $data['plot_format'] =$this->cad_model1->get_plot_format($this->input->post('ord_id'));
   $data['order_details']= $this->cad_model1->get_order_detail($ord_id);
    if(($data['order_details']['order_mode']!="FI") && (strpos($ord_reference_id,"S")===false)){
        $files_alloweded=$data['p3']['file_ext'].'|'.$data['ftp']['file_ext'].'|'.$data['compliance']['file_ext'].'|'.$data['laser_format'].'|'.$data['lmd_format'].'|'.$data['plot_format'];
       $file_formats=explode('|', $files_alloweded);
       $allowed_types=array_unique(array_filter($file_formats));
       $uploaded_formats=array_filter(explode(',',$data['upload_formats']));
       $balance_format=array_udiff($allowed_types,$uploaded_formats,'strcasecmp');

       $compliance_format=$data['compliance']['file_ext'];
       $file_compliance_formats=explode('|', $compliance_format);
       $Compliance_allowed_types=array_unique(array_filter($file_compliance_formats));
       $comp_upload_files=array_filter(explode(',',$data['comp_upload_files']));
       $comp_balance_format=array_udiff($Compliance_allowed_types,$comp_upload_files,'strcasecmp');

       $plot_format=$data['plot_format'];
       $file_plot_formats=explode('|', $plot_format);
       $plot_allowed_types=array_unique(array_filter($file_plot_formats));
       $plot_upload_files=array_filter(explode(',',$data['plot_upload_files']));
       $plot_balance_format=array_udiff($plot_allowed_types,$plot_upload_files,'strcasecmp');
       if (empty($balance_format) && empty($comp_balance_format) && empty($plot_balance_format)) {
            $balance="allowed";
       }else{
            $balance="denied";
       }
    }elseif(strpos($ord_reference_id,"S")){
        $files_alloweded="CUT|PLT";

       $file_formats=explode('|', $files_alloweded);
       $allowed_types=array_unique(array_filter($file_formats));
       $uploaded_formats=array_filter(explode(',',$data['upload_formats']));
       $balance_format=array_udiff($allowed_types,$uploaded_formats,'strcasecmp');
       if (empty($balance_format)) {
            $balance="allowed";
       }else{
            $balance="denied";
       }
    }else{
        $files_alloweded=$data['lmd_format'];

       $file_formats=explode('|', $files_alloweded);
       $allowed_types=array_unique(array_filter($file_formats));
       $uploaded_formats=array_filter(explode(',',$data['upload_formats']));
       $balance_format=array_udiff($allowed_types,$uploaded_formats,'strcasecmp');
       if (empty($balance_format)) {
            $balance="allowed";
       }else{
            $balance="denied";
       }
    }
   $missing_reason=$this->input->post('missing_reason');
   $missing_reason_value=$this->input->post('missing_reason_value');

   if ($balance=="allowed") {
    $file_upload['ord_id']=$data['ord_id'];
    $file_upload['job_id']=$data['job_id'];
    $file_upload['upload_files']=1;
    $file_upload_status=$this->cad_model1->notes_to_laser($file_upload);
    if(!empty($data['p3']['file_ext'])){
        $this->email->clear(TRUE);
        $mail="denied";
        $p3_file_formats=explode('|',$data['p3']['file_ext']);
                //print_r($p3_file_formats);exit;
        $upload_files=array_filter(explode(',',$data['upload_files']));
        for ($i=0; $i < count($upload_files) ; $i++) { 
            for ($j=0; $j < count($p3_file_formats) ; $j++) { 
                if (strtolower($p3_file_formats[$j]) == strtolower(substr($upload_files[$i], strpos($upload_files[$i], ".") + 1))) {
                            //echo " p3 ".$upload_files[$i];
                    $format = substr($upload_files[$i], strpos($upload_files[$i], ".") + 1);
                    $file_path=APPPATH . '../upload/' . $ord_reference_id.'/'.$format.'/'.$upload_files[$i];
                            //echo $file_path;
                    if(is_file($file_path)){
                                //echo " file available ";
                        if (stripos($upload_files[$i], "compliance") !== false) {
                        }else{
                               // echo "file".$i."  path ".$file_path."<br>";
                            $this->email->attach($file_path);
                            $mail="allowed";
                        }
                    }
                }
            } 
        }
        if($mail == "allowed"){
            $data['order_details'] = $this->cad_model1->get_oder_status($ord_id);
            $data['customer_details'] = $this->cad_model1->get_customer_details($data['order_details']['cust_id']);
            if(($data['order_details']['stencil_side']==1) || ($data['order_details']['stencil_side']==3)){
                $customer_name=$data['order_details']['dt_top_name'];
                $assy_no=$data['order_details']['dt_top_assembly'];
                $fab_no=$data['order_details']['dt_top_fab'];
            }else{
                $customer_name=$data['order_details']['dt_bot_name'];
                $assy_no=$data['order_details']['dt_bot_assembly'];
                $fab_no=$data['order_details']['dt_bot_fab'];
            }
            $company_name=$data['customer_details']['cust_name'];
            $ref_no=$ord_reference_id;
            $subject="Stencil Gerber and Area Ratio report for ".$company_name." ".$customer_name." ".$assy_no." ".$fab_no." Ref# ".$ref_no;
            $this->email->set_mailtype("html");
            $this->email->from('techsupport@beamon.com', 'Tech Support');
            $this->email->to($data['p3']['eng_email']);
            $this->email->cc($data['p3']['eng_ad_email']);
            $this->email->bcc('p3gerber@beamon2.com');
            $this->email->subject($subject);
            $body = $this->load->view('cad/p3report_mail_template.php',$data,TRUE);
            $this->email->message($body);
                    //print_r($this->email);exit;
            $reason['uploaded_files']=$data['upload_files'];
            $reason['reason']=$missing_reason;
            $reason['ord_id']=$ord_id;
            $reason['user']=$this->session->userdata('user_name');
            $data['missing_reason'] = $this->cad_model1->insert_missing_file($reason);
            if ($this->email->send()) {
                $data["send_laser"] = $this->cad_model1->get_send_laser_status($ord_id,$data['job_id']);
                $result=array("status" => "success", "message" => "P3report mail send successfully.","send_laser"=>$data["send_laser"]);
                $p3report_mail="mail send to p3report";
            } else {
                $result=array("status" => "failure", "message" => "P3report mail sending failed.");
                $p3report_mail="mail sending failed to p3report";
            }
            $this->email->clear(TRUE);
        }else{
           $reason['uploaded_files']=$data['upload_files'];
           $reason['reason']=$missing_reason;
           $reason['ord_id']=$ord_id;$reason['job_id']=$job_id;
           $reason['user']=$this->session->userdata('user_name');
           $data['missing_reason'] = $this->cad_model1->insert_missing_file($reason);
           $data["send_laser"] = $this->cad_model1->get_send_laser_status($ord_id,$data['job_id']);
           $result=array("status" => "failure", "message" => "P3report file Missing.","missing"=>"true","send_laser"=>$data["send_laser"]);
       }
   }else{
       $reason['uploaded_files']=$data['upload_files'];
       $reason['reason']=$missing_reason;
       $reason['ord_id']=$ord_id;$reason['job_id']=$job_id;
       $reason['user']=$this->session->userdata('user_name');
       $data['missing_reason'] = $this->cad_model1->insert_missing_file($reason);
       $data["send_laser"] = $this->cad_model1->get_send_laser_status($ord_id,$data['job_id']);
       $result=array("status" => "failure", "message" => "P3report Engineer Mail Disabled.","missing"=>"true","send_laser"=>$data["send_laser"]);
   }
   if(!empty($data['plot_format'])){
        $this->email->clear(TRUE);
        $mail="denied";
        $plot_file_formats=explode('|',$data['plot_format']);
                    //print_r($plot_file_formats);exit;
        $upload_files=array_filter(explode(',',$data['upload_files']));
        for ($i=0; $i < count($upload_files) ; $i++) { 
            for ($j=0; $j < count($plot_file_formats) ; $j++) { 
                if (strtolower($plot_file_formats[$j]) == strtolower(substr($upload_files[$i], strpos($upload_files[$i], ".") + 1))) {
                                //echo " p3 ".$upload_files[$i];
                    $format = substr($upload_files[$i], strpos($upload_files[$i], ".") + 1);
                    $file_path='/home/beamon9/public_html/testing/boots2_new/output/plot/'.$upload_files[$i];
                                //echo $file_path;
                    if(is_file($file_path)){
                        $this->email->attach($file_path);
                        $mail="allowed";
                    }
                }
            } 
        }
        if($mail == "allowed"){
            $data['order_details'] = $this->cad_model1->get_oder_status($ord_id);
            $data['customer_details'] = $this->cad_model1->get_customer_details($data['order_details']['cust_id']);
            if(($data['order_details']['stencil_side']==1) || ($data['order_details']['stencil_side']==3)){
                $customer_name=$data['order_details']['dt_top_name'];
                $assy_no=$data['order_details']['dt_top_assembly'];
                $fab_no=$data['order_details']['dt_top_fab'];
            }else{
                $customer_name=$data['order_details']['dt_bot_name'];
                $assy_no=$data['order_details']['dt_bot_assembly'];
                $fab_no=$data['order_details']['dt_bot_fab'];
            }
            $plot_sub="";$proceed_italic="";
                if($data['order_details']['premium_status']==1) {
                    $plot_sub.="Priority ";
                }
                if(($data['order_details']['tension']==1 && $data['order_details']['premium_status']==1) OR ($data['order_details']['premium_status']==1 && $data['order_details']['fg_material']==1)){
                    $plot_sub.=" - ";
                }
                if ($data['order_details']['tension']==1) {
                    $plot_sub.=" Tension Material ";
                }
                if (($data['order_details']['stencil_side']==1) OR ($data['order_details']['stencil_side']==3)) {
                    if ($data['order_details']['top_multilevel']!="" && $data['order_details']['fg_material']==1) {
                            $plot_sub.=" FG Material ";
                    }
                }
                if ($data['order_details']['stencil_side']==2) {
                    if ($data['order_details']['bot_multilevel']!="" && $data['order_details']['fg_material']==1) {
                        $plot_sub.=" FG Material ";
                    }
                }
                if (($data['order_details']['stencil_side']==1) OR ($data['order_details']['stencil_side']==3)) {
                    if ($data['order_details']['top_multilevel']!="") {
                            $proceed_italic.=" pls proceed to Italix ";
                    }
                }
                if ($data['order_details']['stencil_side']==2) {
                    if ($data['order_details']['bot_multilevel']!="" ) {
                        $proceed_italic.=" pls proceed to Italix ";
                    }
                }
                if($plot_sub!=""){
                    $plot_sub.="....";
                }
                // stepdown label
                $step_down_sub="";
                if (($data['order_details']['stencil_side']==1) OR ($data['order_details']['stencil_side']==3)) {
                    if ($data['order_details']['top_multilevel']!="") {
                        $step_down_sub="stepdown";
                    }
                }
                if ($data['order_details']['stencil_side']==2) {
                    if ($data['order_details']['bot_multilevel']!="") {
                        $step_down_sub="stepdown";
                    }
                }
                if($step_down_sub!="" && ($_POST['plt_exist'] =="1" || $_POST['step_down_exist'] == "1")){
                    $message="Ref# ".$ref_no." ".$step_down_sub." plot files copied.pls proceed to Italix";
                    $to=PLOT_SMS_TO;
                    $this->clickatell->send_message($to, $message);
                    
                    $to=PLOT_SMS_TO1;
                    $this->clickatell->send_message($to, $message);
                    /*
                    $to=PLOT_SMS_TO2;
                    $this->clickatell->send_message($to, $message); */
                } 
                  if ($data['order_details']['film_plots']==1 && $_POST['pdf_exist'] == "1") {
                    $company_name=$data['customer_details']['cust_name'];
                    $ref_no=$ord_reference_id;
                    $subject=$plot_sub."Ref# ".$ref_no." Plot files copied.".$proceed_italic;
                    $this->email->set_mailtype("html");
                    $this->email->from('techsupport@beamon.com', 'Tech Support');
                    //$this->email->to('ca_stencil@beamonstencils.com');
                    $this->email->to('manoj@beamon2.com');
                    $this->email->cc('muthu183sd@gmail.com');
                    $this->email->subject($subject);
                    //$body = $this->load->view('cad/p3report_mail_template.php',$data,TRUE);
                    $body="";
                    $this->email->message($body);
                    //print_r($this->email);exit;
                    if ($this->email->send()) {
                        $data["send_laser"] = $this->cad_model1->get_send_laser_status($ord_id,$data['job_id']);
                        $result=array("status" => "success", "message" => "Plot mail send successfully.","send_laser"=>$data["send_laser"]);
                        $p3report_mail="mail send to Plot Files";
                    } else {
                        $result=array("status" => "failure", "message" => "Plot mail sending failed.");
                        $p3report_mail="mail sending failed to Plot Files";
                    }
                    $this->email->clear(TRUE);
                }  
                if ($step_down_sub!="" && ($_POST['plt_exist'] =="1" || $_POST['step_down_exist'] == "1")) {
                    $company_name=$data['customer_details']['cust_name'];
                    $ref_no=$ord_reference_id;
                    $subject=$plot_sub."Ref# ".$ref_no." ".$step_down_sub." Plot files copied.".$proceed_italic;
                    $this->email->set_mailtype("html");
                    $this->email->from('techsupport@beamon.com', 'Tech Support');
                    //$this->email->to('ca_stencil@beamonstencils.com');
                    $this->email->to('manoj@beamon2.com');
                    $this->email->cc('muthu183sd@gmail.com');
                    //$this->email->cc('india_stencil@beamonstencils.com');
                    $this->email->subject($subject);
                    //$body = $this->load->view('cad/p3report_mail_template.php',$data,TRUE);
                    $body="";
                    $this->email->message($body);
                    //print_r($this->email);exit;
                    if ($this->email->send()) {
                        $data["send_laser"] = $this->cad_model1->get_send_laser_status($ord_id,$data['job_id']);
                        $result=array("status" => "success", "message" => "Plot mail send successfully.","send_laser"=>$data["send_laser"]);
                        $p3report_mail="mail send to Plot Files";
                    } else {
                        $result=array("status" => "failure", "message" => "Plot mail sending failed.");
                        $p3report_mail="mail sending failed to Plot Files";
                    }
                    $this->email->clear(TRUE);
                } 
            }else{
                $result=array("status" => "failure", "message" => "Plot file are not uploaded.");
            }
        }else{
            $data["send_laser"] = $this->cad_model1->get_send_laser_status($ord_id,$data['job_id']);
            $result=array("status" => "failure", "message" => "","missing"=>"true","send_laser"=>$data["send_laser"]);
        }
    }else{

        if($missing_reason_value==0){
            $result=array("status" => "failure", "message" => $ord_id );
        }else{
           $ref_no=$ord_reference_id;
           $reason['uploaded_files']=$data['upload_files'];
           $reason['reason']=$missing_reason;
           $reason['ord_id']=$ord_id;$reason['job_id']=$job_id;
           $reason['user']=$this->session->userdata('user_name');
           $data['missing_reason'] = $this->cad_model1->insert_missing_file($reason);
           // update file upload to order status
           $file_upload['ord_id']=$data['ord_id'];
           $file_upload['job_id']=$data['job_id'];
           $file_upload['upload_files']=1;
           $file_upload_status=$this->cad_model1->notes_to_laser($file_upload);
           if(!empty($data['p3']['file_ext'])){
            $this->email->clear(TRUE);
            $mail="denied";
            $p3_file_formats=explode('|',$data['p3']['file_ext']);
                        //print_r($p3_file_formats);exit;
            $upload_files=array_filter(explode(',',$data['upload_files']));
            for ($i=0; $i < count($upload_files) ; $i++) { 
                for ($j=0; $j < count($p3_file_formats) ; $j++) { 
                    if (strtolower($p3_file_formats[$j]) == strtolower(substr($upload_files[$i], strpos($upload_files[$i], ".") + 1))) {
                                    //echo " p3 ".$upload_files[$i];
                        $format = substr($upload_files[$i], strpos($upload_files[$i], ".") + 1);
                        $file_path=APPPATH . '../upload/' . $ord_reference_id.'/'.$format.'/'.$upload_files[$i];
                                    //echo $file_path;
                        if(is_file($file_path)){
                                        //echo " file available ";
                            if (stripos($upload_files[$i], "compliance") !== false) {
                            }else{
                                       // echo "file".$i."  path ".$file_path."<br>";
                                $this->email->attach($file_path);
                                $mail="allowed";
                            }
                        }
                    }
                } 
            }
            if($mail == "allowed"){
                $data['order_details'] = $this->cad_model1->get_oder_status($ord_id);
                $data['customer_details'] = $this->cad_model1->get_customer_details($data['order_details']['cust_id']);
                if(($data['order_details']['stencil_side']==1) || ($data['order_details']['stencil_side']==3)){
                    $customer_name=$data['order_details']['dt_top_name'];
                    $assy_no=$data['order_details']['dt_top_assembly'];
                    $fab_no=$data['order_details']['dt_top_fab'];
                }else{
                    $customer_name=$data['order_details']['dt_bot_name'];
                    $assy_no=$data['order_details']['dt_bot_assembly'];
                    $fab_no=$data['order_details']['dt_bot_fab'];
                }
                $company_name=$data['customer_details']['cust_name'];
                $ref_no=$ord_reference_id;
                $subject="Stencil Gerber and Area Ratio report for ".$company_name." ".$customer_name." ".$assy_no." ".$fab_no." Ref# ".$ref_no;
                $this->email->set_mailtype("html");
                $this->email->from('techsupport@beamon.com', 'Tech Support');
                $this->email->to($data['p3']['eng_email']);
                $this->email->cc($data['p3']['eng_ad_email']);
                $this->email->bcc('p3gerber@beamon2.com');
                $this->email->subject($subject);
                $body = $this->load->view('cad/p3report_mail_template.php',$data,TRUE);
                $this->email->message($body);
                            //print_r($this->email);exit;
                if ($this->email->send()) {
                    $data["send_laser"] = $this->cad_model1->get_send_laser_status($ord_id,$data['job_id']);
                    $result=array("status" => "success", "message" => "P3report mail send successfully.","send_laser"=>$data["send_laser"]);
                    $p3report_mail="mail send to p3report";
                } else {
                    $result=array("status" => "failure", "message" => "P3report mail sending failed.");
                    $p3report_mail="mail sending failed to p3report";
                }
                $this->email->clear(TRUE);
            }else{
                if($missing_reason_value==0){
                    $data["send_laser"] = $this->cad_model1->get_send_laser_status($ord_id,$data['job_id']);
                    $result=array("status" => "failure", "message" => "P3report file Missing.","missing"=>"false","send_laser"=>$data["send_laser"]);
                }else{
                    $data["send_laser"] = $this->cad_model1->get_send_laser_status($ord_id,$data['job_id']);
                    $result=array("status" => "failure", "message" => "P3report file Missing.","missing"=>"true","send_laser"=>$data["send_laser"]);
                }
            }
        }else{
            $data["send_laser"] = $this->cad_model1->get_send_laser_status($ord_id,$data['job_id']);
            $result=array("status" => "failure", "message" => "P3report Engineer mail Disabled.","missing"=>"true","send_laser"=>$data["send_laser"]);
        }
        if(!empty($data['plot_format'])){
            $this->email->clear(TRUE);
            $mail="denied";
            $plot_file_formats=explode('|',$data['plot_format']);
                    //print_r($plot_file_formats);exit;
            $upload_files=array_filter(explode(',',$data['upload_files']));
            for ($i=0; $i < count($upload_files) ; $i++) { 
                for ($j=0; $j < count($plot_file_formats) ; $j++) { 
                    if (strtolower($plot_file_formats[$j]) == strtolower(substr($upload_files[$i], strpos($upload_files[$i], ".") + 1))) {
                                //echo " p3 ".$upload_files[$i];
                        $format = substr($upload_files[$i], strpos($upload_files[$i], ".") + 1);
                        $file_path='/home/beamon9/public_html/testing/boots2_new/output/plot/'.$upload_files[$i];
                                //echo $file_path;
                        if(is_file($file_path)){
                            $this->email->attach($file_path);
                            $mail="allowed";
                        }
                    }
                } 
            }
            if($mail == "allowed"){
                $data['order_details'] = $this->cad_model1->get_oder_status($ord_id);
                $data['customer_details'] = $this->cad_model1->get_customer_details($data['order_details']['cust_id']);
                if(($data['order_details']['stencil_side']==1) || ($data['order_details']['stencil_side']==3)){
                    $customer_name=$data['order_details']['dt_top_name'];
                    $assy_no=$data['order_details']['dt_top_assembly'];
                    $fab_no=$data['order_details']['dt_top_fab'];
                }else{
                    $customer_name=$data['order_details']['dt_bot_name'];
                    $assy_no=$data['order_details']['dt_bot_assembly'];
                    $fab_no=$data['order_details']['dt_bot_fab'];
                }
                $plot_sub="";$proceed_italic="";
                    if($data['order_details']['premium_status']==1) {
                        $plot_sub.="Priority ";
                    }
                    if(($data['order_details']['tension']==1 && $data['order_details']['premium_status']==1) OR ($data['order_details']['premium_status']==1 && $data['order_details']['fg_material']==1)){
                        $plot_sub.=" - ";
                    }
                    if ($data['order_details']['tension']==1) {
                        $plot_sub.=" Tension Material ";
                    }
                    if (($data['order_details']['stencil_side']==1) OR ($data['order_details']['stencil_side']==3)) {
                        if ($data['order_details']['top_multilevel']!="" && $data['order_details']['fg_material']==1) {
                                $plot_sub.=" FG Material ";
                        }
                    }
                    if ($data['order_details']['stencil_side']==2) {
                        if ($data['order_details']['bot_multilevel']!="" && $data['order_details']['fg_material']==1) {
                            $plot_sub.=" FG Material ";
                        }
                    }
                    if (($data['order_details']['stencil_side']==1) OR ($data['order_details']['stencil_side']==3)) {
                        if ($data['order_details']['top_multilevel']!="") {
                                $proceed_italic.=" pls proceed to Italix ";
                        }
                    }
                    if ($data['order_details']['stencil_side']==2) {
                        if ($data['order_details']['bot_multilevel']!="" ) {
                            $proceed_italic.=" pls proceed to Italix ";
                        }
                    }
                    if($plot_sub!=""){
                        $plot_sub.="....";
                    }
                    // stepdown label
                    $step_down_sub="";
                    if (($data['order_details']['stencil_side']==1) OR ($data['order_details']['stencil_side']==3)) {
                        if ($data['order_details']['top_multilevel']!="") {
                            $step_down_sub="stepdown";
                        }
                    }
                    if ($data['order_details']['stencil_side']==2) {
                        if ($data['order_details']['bot_multilevel']!="") {
                            $step_down_sub="stepdown";
                        }
                    }
                 
                   if($step_down_sub!="" && ($_POST['plt_exist'] =="1" || $_POST['step_down_exist'] == "1")){
                        $message="Ref# ".$ref_no." ".$step_down_sub." plot files copied.pls proceed to Italix";
                        $to=PLOT_SMS_TO;
                        $this->clickatell->send_message($to, $message);
                        
                        $to=PLOT_SMS_TO1;
                        $this->clickatell->send_message($to, $message);
                        
                        /*$to=PLOT_SMS_TO2;
                        $this->clickatell->send_message($to, $message); */
                    } 
                     if ($data['order_details']['film_plots']==1 && $_POST['pdf_exist'] == "1") {
                        $company_name=$data['customer_details']['cust_name'];
                        $ref_no=$ord_reference_id;
                        $subject=$plot_sub."Ref# ".$ref_no." Plot files copied.".$proceed_italic;
                        $this->email->set_mailtype("html");
                        $this->email->from('techsupport@beamon.com', 'Tech Support');
                        //$this->email->to('ca_stencil@beamonstencils.com');
                        $this->email->to('manoj@beamon2.com');
                        $this->email->cc('muthu183sd@gmail.com');
                        $this->email->subject($subject);
                        //$body = $this->load->view('cad/p3report_mail_template.php',$data,TRUE);
                        $body="";
                        $this->email->message($body);
                        //print_r($this->email);exit;
                        if ($this->email->send()) {
                            $data["send_laser"] = $this->cad_model1->get_send_laser_status($ord_id,$data['job_id']);
                            $result=array("status" => "success", "message" => "Plot mail send successfully.","missing"=>"true","send_laser"=>$data["send_laser"]);
                            $p3report_mail="mail send to Plot Files";
                        } else {
                            $data["send_laser"] = $this->cad_model1->get_send_laser_status($ord_id,$data['job_id']);
                            $result=array("status" => "failure", "message" => "Plot mail sending failed.","missing"=>"true","send_laser"=>$data["send_laser"]);
                            $p3report_mail="mail sending failed to Plot Files";
                        }
                        $this->email->clear(TRUE);
                    } 
                    if ($step_down_sub!="" && ($_POST['plt_exist'] =="1" || $_POST['step_down_exist'] == "1")) {
                        $company_name=$data['customer_details']['cust_name'];
                        $ref_no=$ord_reference_id;
                        $subject=$plot_sub."Ref# ".$ref_no." ".$step_down_sub." Plot files copied.".$proceed_italic;
                        $this->email->set_mailtype("html");
                        $this->email->from('techsupport@beamon.com', 'Tech Support');
                        //$this->email->to('ca_stencil@beamonstencils.com');
                        $this->email->to('manoj@beamon2.com');
                        $this->email->cc('muthu183sd@gmail.com');
                        //$this->email->cc('india_stencil@beamonstencils.com');
                        $this->email->subject($subject);
                        //$body = $this->load->view('cad/p3report_mail_template.php',$data,TRUE);
                        $body="";
                        $this->email->message($body);
                        //print_r($this->email);exit;
                        if ($this->email->send()) {
                            $data["send_laser"] = $this->cad_model1->get_send_laser_status($ord_id,$data['job_id']);
                            $result=array("status" => "success", "message" => "Plot mail send successfully.","missing"=>"true","send_laser"=>$data["send_laser"]);
                            $p3report_mail="mail send to Plot Files";
                        } else {
                            $data["send_laser"] = $this->cad_model1->get_send_laser_status($ord_id,$data['job_id']);
                            $result=array("status" => "failure", "message" => "Plot mail sending failed.","missing"=>"true","send_laser"=>$data["send_laser"]);
                            $p3report_mail="mail sending failed to Plot Files";
                        }
                        $this->email->clear(TRUE);
                    }
            }else{
                $data["send_laser"] = $this->cad_model1->get_send_laser_status($ord_id,$data['job_id']);
                $result=array("status" => "failure", "message" => "Plot file are not uploaded.","missing"=>"true","send_laser"=>$data["send_laser"]);
            }
        }else{
            $data["send_laser"] = $this->cad_model1->get_send_laser_status($ord_id,$data['job_id']);
            $result=array("status" => "failure", "message" => "Plot format not available","missing"=>"true","send_laser"=>$data["send_laser"]);
        }
    }

                //$this->load->view('cad/filesmissing', $data);
}
        //print_r($result);exit;
        /*if(!empty($data['ftp']['file_ext'])){
            //print_r($data['ftp']['eng_email']);exit;
            $this->email->clear(TRUE);
             
             $mail="denied";
            $ftp_file_formats=explode('|',$data['ftp']['file_ext']);
            $upload_files=array_filter(explode(',',$data['upload_files']));
            for ($i=0; $i < count($upload_files) ; $i++) { 
                for ($j=0; $j < count($ftp_file_formats) ; $j++) { 
                    if ($ftp_file_formats[$j] == substr($upload_files[$i], strpos($upload_files[$i], ".") + 1)) {
                        //echo " ftp ".$upload_files[$i];
                        $format = substr($upload_files[$i], strpos($upload_files[$i], ".") + 1);
                        $file_path=APPPATH . '../upload/' . $ord_reference_id.'/'.$format.'/'.$upload_files[$i];
                        //print_r(is_file($file_path));
                        if(is_file($file_path)){
                            //echo " file available ";
                            $this->email->attach($file_path);
                            $mail="allowed";
                        }   
                    }
                } 
            }
            if($mail == "allowed"){
                $this->email->from('bot@beamon.com', 'beam on tecnology');
        $this->email->to($data['ftp']['eng_email']);
        $this->email->cc($data['ftp']['eng_ad_email']);
                $this->email->subject('ftp files');
                $this->email->message('testing mail');
                if ($this->email->send()) {
                    $ftp_mail="mail send to ftp";
                    $result[1]=array("status" => "success", "message" => "Ftp mail send successfully.");
                } else {
                    $result[1]=array("status" => "failure", "message" => "Ftp mail sending failed.");
                    $ftp_mail="mail sending failed to ftp";
                }
                $this->email->clear(TRUE);
            }else{
                $result[1]=array("status" => "failure", "message" => "Ftp file Missing.");
            }
        }else{
            $result[1]=array("status" => "failure", "message" => "Ftp Engineer file format not available");
        }
        if(!empty($data['compliance']['file_ext'])){
             $this->email->clear(TRUE);
             $mail="denied";
            $compliance_file_formats=explode('|',$data['compliance']['file_ext']);
            //print_r($compliance_file_formats);exit;
            $upload_files=array_filter(explode(',',$data['upload_files']));
            for ($i=0; $i < count($upload_files) ; $i++) { 
                for ($j=0; $j < count($compliance_file_formats) ; $j++) { 
                    if ($compliance_file_formats[$j] == substr($upload_files[$i], strpos($upload_files[$i], ".") + 1)) {
                        //echo " compliance ".$upload_files[$i];
                        $format = substr($upload_files[$i], strpos($upload_files[$i], ".") + 1);
                        $file_path=APPPATH . '../upload/' . $ord_reference_id.'/'.$format.'/'.$upload_files[$i];
                        if(is_file($file_path)){
                            //print_r(is_file($file_path));
                            //echo " file available ";
                            $this->email->attach($file_path);
                            $mail="allowed";
                        }
                    }
                } 
            }
            if($mail == "allowed"){
                $this->email->from('bot@beamon.com', 'beam on tecnology');
        $this->email->to($data['ftp']['eng_email']);
        $this->email->cc($data['ftp']['eng_ad_email']);
            $this->email->subject('compliance files');
            $this->email->message('testing mail');
                if ($this->email->send()) {
                    $compliance_mail="mail send to compliance";
                    $result[2]=array("status" => "success", "message" => "Compliance mail send successfully.");
                } else {
                    $result[2]=array("status" => "failure", "message" => "Compliance mail sending failed.");
                    $compliance_mail="mail sending failed to compliance";
                }
                $this->email->clear(TRUE);
            }else{
                $result[2]=array("status" => "failure", "message" => "Compliance file Missing.");
            }
            
        }else{
            $result[2]=array("status" => "failure", "message" => "Compliance Engineer file format not available");
        }*/
        echo json_encode($result);
    }
    public function history() {
        $data['ord_id'] = $_POST['ord_id'];
        $data['job_id'] = $_POST['job_id'];
        $data['ord_ref_id'] = $_POST['job_code'];
        $data['ord_sts_id'] = $_POST['ord_sts_id'];
        $data['order_details'] = $this->order_model->get_order_details($data['ord_id']);
        $data['cust_name'] = $this->customer_model->get_customer_name($data['order_details']['cust_ref']);
        $data['eng_name'] = $this->cad_model1->get_engineer_name($data['ord_id']);
        $data['history']=$this->cad_model1->get_uploaded_files($data['ord_id'],$data['job_id']);
        //echo "<pre>";print_r( $data['cust_name']);exit;
        //echo "<pre>";print_r($data);exit;
        $this->load->view('cad/history', $data);
    }
    public function oldjob_upload() {
        $data['ord_id'] = $_POST['ord_id'];
        $data['job_id'] = $_POST['job_id'];
        $data['ord_ref_id'] = $_POST['job_code'];
        $data['ord_sts_id'] = $_POST['ord_sts_id'];
        $data['top_order'] =$this->cad_model1->check_top_order($data['ord_id']);
        $data['bottom_order'] =$this->cad_model1->check_bottom_order($data['ord_id']);
        $data['uploaded_files'] = $this->cad_model1->get_oldjob_uploaded_files($data['ord_id'],$data['job_id']);
        //echo "<pre>";print_r($data);exit;
        $this->load->view('cad/oldjob_upload', $data);
    }
    public function multifile_oldjob_upload(){
        $result="denied";
        $ord_reference_id = $_POST["ord_reference_id"];
        $data["order_status_id"] = $_POST["order_status_id"];
        $data["top_order"] = $_POST["top_order"];
        $data['bottom_order'] = $_POST["bottom_order"];
        $data["ord_id"] = $_POST["ord_id"];
        $name=$_FILES['file']['name'];
        $file_ref=explode('.', $name);
        if ((stripos($file_ref[0],$ord_reference_id) !== false) || (strcasecmp($file_ref[0],$ord_reference_id."_Compliance")==0)) {
            $files_alloweded="zip|rar";
            $file_formats=explode('|', $files_alloweded);
            $allowed_types=array_unique(array_filter($file_formats));
            $format = substr($_FILES['file']['name'], strpos($_FILES['file']['name'], ".") + 1);
            foreach ($allowed_types as $key => $allowed_type) {
                if(strcasecmp($format,$allowed_type)==0){
                    $result="accepted";      
                }
            }
            if($result=="accepted"){
               $path = '/home/beamon9/public_html/testing/boots2_new/output/oldjobs';
               if(is_file($path.'/'.$_FILES['file']['name'])){
                unlink($path.'/'.$_FILES['file']['name']);
            }
            (!is_dir($path)) ? mkdir($path, 0755, true) : "";
            $config['upload_path'] = $path;
            $config['allowed_types'] = '*';
            $this->upload->initialize($config);
            if (!$this->upload->do_upload('file')) {
                $error = $this->upload->display_errors();
                echo json_encode(array("status" => "failure", "message" => $error));
            } else {
                echo json_encode(array("status" => "success", "message" => "File Uploaded successfully.", "savedfilename" => $_FILES["file"]["name"], "filename" => $_FILES["file"]["name"]));
            }
        }else{
            echo json_encode(array("status" => "failed", "message" => "File Format Mismatch.", "savedfilename" => $_FILES["file"]["name"], "filename" => $_FILES["file"]["name"]));
        }
    }elseif(($data["top_order"]!="")||($data["bottom_order"]!="")){
    	    $top_bot = ($data["top_order"]!="") ? $data["top_order"] : $data["bottom_order"] ;
	    if ((stripos($file_ref[0],$top_bot) !== false) || (strcasecmp($file_ref[0],$top_bot."_Compliance")==0)) {
	            $files_alloweded="zip|rar";
	            $file_formats=explode('|', $files_alloweded);
	            $allowed_types=array_unique(array_filter($file_formats));
	            $format = substr($_FILES['file']['name'], strpos($_FILES['file']['name'], ".") + 1);
	            foreach ($allowed_types as $key => $allowed_type) {
	                if(strcasecmp($format,$allowed_type)==0){
	                    $result="accepted";      
	                }
	            }
	            if($result=="accepted"){
	               $path = '/home/beamon9/public_html/testing/boots2_new/output/oldjobs';
	               if(is_file($path.'/'.$_FILES['file']['name'])){
	                unlink($path.'/'.$_FILES['file']['name']);
	            }
	            (!is_dir($path)) ? mkdir($path, 0755, true) : "";
	            $config['upload_path'] = $path;
	            $config['allowed_types'] = '*';
	            $this->upload->initialize($config);
	            if (!$this->upload->do_upload('file')) {
	                $error = $this->upload->display_errors();
	                echo json_encode(array("status" => "failure", "message" => $error));
	            } else {
	                echo json_encode(array("status" => "success", "message" => "File Uploaded successfully.", "savedfilename" => $_FILES["file"]["name"], "filename" => $_FILES["file"]["name"]));
	            }
	        }else{
	            echo json_encode(array("status" => "failed", "message" => "File Format Mismatch.", "savedfilename" => $_FILES["file"]["name"], "filename" => $_FILES["file"]["name"]));
	        }
	    }else{
	        echo json_encode(array("status" => "failed", "message" => "Wrong File Uploaded.", "savedfilename" => $_FILES["file"]["name"], "filename" => $_FILES["file"]["name"]));
	    }
    }else{
        echo json_encode(array("status" => "failed", "message" => "Wrong File Uploaded.", "savedfilename" => $_FILES["file"]["name"], "filename" => $_FILES["file"]["name"]));
    }
}
public function multifile_oldjob_remove(){
    $file_name = str_replace(" ","_",$this->input->post('filename'));
    $path = '/home/beamon9/public_html/testing/boots2_new/output/oldjobs';
    if(is_file($path.'/'.$file_name)){
        unlink($path.'/'.$file_name);
        echo json_encode(array("status" => "success", "message" => "Removed.", "removedfilename" => $file_name, "filename" => $file_name));
    }else{
        echo json_encode(array("status" => "failed", "message" => "Missing.", "removedfilename" => $file_name, "filename" => $file_name));
    }

}
public function multifile_oldjob_done(){
        //print_r($_POST);
    $data=$_POST;
        //print_r($data);exit;
    if ($data['oldjob_upload_count'] > 0) {
        $oldjob['ord_id']=$data['ord_id'];$oldjob['job_id']=$data['job_id'];
        $oldjob['file']=$data['oldjob_upload_files'];
        $oldjob['user']=$this->session->userdata('user_name');
        $oldjob['bottom_order']=$this->cad_model1->check_bottom_order($data['ord_id']);
        $top_order=$this->cad_model1->check_top_order($data['ord_id']);
        $oldjob['bottom_order'] = ($top_order!="") ? $data["top_order"] : $data["bottom_order"] ;
        $data['oldjob'] = $this->cad_model1->insert_oldjob_file($oldjob);
        $oldjob_upload['ord_id']=$data['ord_id'];
            $oldjob_upload['job_id']=$data['job_id'];
            $oldjob_upload['oldjob_files']=1;
            $order_status_status=$this->cad_model1->notes_to_laser($oldjob_upload);
            if($oldjob['bottom_order']!=""){
            	$bottom_order['ord_id']=get_order_id($oldjob['bottom_order']);
            	$bottom_order['job_id']=get_job_id($oldjob['bottom_order']);
            	$bottom_order['oldjob_files']=1;
            	$bottom_order_status=$this->cad_model1->notes_to_laser($bottom_order);
            }
            $data["send_laser"] = $this->cad_model1->get_send_laser_status($data['ord_id'],$data['job_id']);
        echo json_encode(array("status" => "success", "message" => "Old Files Successfully Uploaded.","send_laser"=>$data["send_laser"]));
    }else{
       echo json_encode(array("status" => "failure", "message" => "Old Files Upload Failed."));
   }
}
public function search() {
    $data['search_string']=$this->input->post('search_string');
            //print_r($search_string);exit;
    $date = date('Y-m-d');
    $data['high'] = $this->cad_model1->get_cad_status('2', '1',$date, $data['search_string']);
    $data['normal'] = $this->cad_model1->get_cad_status('1', '1',$date, $data['search_string']);
    $data['low'] = $this->cad_model1->get_cad_status('0', '1',$date, $data['search_string']);
    $this->template->build("cad/cad_orders", $data);
}
public function rework_upload() {
    $data['ord_id'] = $_POST['ord_id'];
    $data['ord_ref_id'] = $_POST['job_code'];
    $data['job_id'] = $_POST['job_id'];
    $data['ord_sts_id'] = $_POST['ord_sts_id'];
    $data['ftp_format'] = $this->cad_model1->get_ftp_format($data["ord_id"]);
    $data['lmd_format'] =$this->cad_model1->get_lmd_format($data["ord_id"]);
        //$data['uploaded_files'] = $this->cad_model1->get_rework_uploaded_files($data['ord_id']);
        //echo "<pre>";print_r($data);exit;
    $this->load->view('cad/rework_upload', $data);
}
public function multifile_rework_upload(){
    $result="denied";
    $ord_reference_id = $_POST["ord_reference_id"];
    $data["order_status_id"] = $_POST["order_status_id"];
    $data["ord_id"] = $_POST["ord_id"];
    $name=$_FILES['file']['name'];
    $file_ref=explode('.', $name);
    $count=count($file_ref);
    if ((stripos($file_ref[0],$ord_reference_id) !== false) && ($count==3)) {
        $data['ftp_format'] = $this->cad_model1->get_ftp_format($data["ord_id"]);
        $data['lmd_format'] =$this->cad_model1->get_lmd_format($data["ord_id"]);
        $files_alloweded=$data['ftp_format'].'|'.$data['lmd_format'];
        $file_formats=explode('|', $files_alloweded);
        $allowed_types=array_unique(array_filter($file_formats));
        $format =$file_ref[2];
        foreach ($allowed_types as $key => $allowed_type) {
            if(strcasecmp($format,$allowed_type)==0){
                $result="accepted";      
            }
        }
        if(!empty($data['lmd_format'])){
            $lmd_file_formats=explode('|', $data['lmd_format']);
            $lmd_allowed_types=array_unique(array_filter($lmd_file_formats));
            foreach ($lmd_allowed_types as $key => $lmd_allowed_type) {
                if(strcasecmp($format,$lmd_allowed_type)==0){
                    $path = '/home/beamon9/public_html/testing/boots2_new/output/lmd';
                    if(is_file($path.'/'.$_FILES['file']['name'])){
                        unlink($path.'/'.$_FILES['file']['name']);
                    }
                    (!is_dir($path)) ? mkdir($path, 0755, true) : "";
                    $config['upload_path'] = $path;
                    $config['allowed_types'] = '*';
                    $this->upload->initialize($config);
                    $this->upload->do_upload('file');
                }
            }
        }
        $data['ftp'] = $this->cad_model1->get_ftp_mailaddress($data["ord_id"]);
        if(!empty($data['ftp_format'])){
            $ftp_file_formats=explode('|', $data['ftp_format']);
            $ftp_allowed_types=array_unique(array_filter($ftp_file_formats));
            foreach ($ftp_allowed_types as $key => $ftp_allowed_type) {
                if(strcasecmp($format,$ftp_allowed_type)==0){
                    $other="true";
                    $path ='/home/beamon9/customers_ftp/test/test1/'. $data['ftp']['path'];
                    if(is_file($path.'/'.$_FILES['file']['name'])){
                        unlink($path.'/'.$_FILES['file']['name']);
                    }
                    (!is_dir($path)) ? mkdir($path, 0755, true) : "";
                    $config['upload_path'] = $path;
                    $config['allowed_types'] = '*';
                    $this->upload->initialize($config);
                    $this->upload->do_upload('file');
                }
            }
        }
        if($result=="accepted"){
            $path = APPPATH . '../upload/' . $ord_reference_id.'/'.$format;
            if(is_file($path.'/'.$_FILES['file']['name'])){
                unlink($path.'/'.$_FILES['file']['name']);
            }
            (!is_dir($path)) ? mkdir($path, 0755, true) : "";
            $config['upload_path'] = $path;
            $config['allowed_types'] = '*';
            $this->upload->initialize($config);
            if (!$this->upload->do_upload('file')) {
                $error = $this->upload->display_errors();
                echo json_encode(array("status" => "failure","format"=>$format, "message" => $error));
            } else {
                echo json_encode(array("status" => "success", "message" => "File Uploaded successfully.", "savedfilename" => $_FILES["file"]["name"],"format"=>$format,"filename" => $_FILES["file"]["name"]));
            }
        }else{
            echo json_encode(array("status" => "failed", "message" => "File Format Mismatch.", "savedfilename" => $_FILES["file"]["name"],"format"=>$format,"filename" => $_FILES["file"]["name"]));
        }
    }else{
        echo json_encode(array("status" => "failed", "message" => "Wrong File Uploaded.", "savedfilename" => $_FILES["file"]["name"], "filename" => $_FILES["file"]["name"]));
    }
}
public function multifile_rework_remove(){
    $file_name = str_replace(" ","_",$this->input->post('filename'));
    $file_ref=explode('.', $file_name);
        //print_r($file_ref);
    if(isset($file_ref[2])){
        $format=$file_ref[2];
        $ord_reference_id=$this->input->post('ord_reference_id');
        $data['ftp_format'] = $this->cad_model1->get_ftp_format($this->input->post('ord_id'));
        $data['lmd_format'] =$this->cad_model1->get_lmd_format($this->input->post('ord_id'));

        $path = APPPATH . '../upload/' . $ord_reference_id.'/'.$format.'/'.$file_name;
        if(is_file($path)){
            unlink($path);
            $data['ftp'] = $this->cad_model1->get_ftp_mailaddress($this->input->post('ord_id'));
            if(!empty($data['ftp_format'])){
                $ftp_file_formats=explode('|', $data['ftp_format']);
                $ftp_allowed_types=array_unique(array_filter($ftp_file_formats));
                foreach ($ftp_allowed_types as $key => $ftp_allowed_type) {
                    if(strcasecmp($format,$ftp_allowed_type)==0){
                        $other="true";
                        $path ='/home/beamon9/customers_ftp/test/test1/'. $data['ftp']['path'].'/'.$file_name;
                            //$path = APPPATH.'../upload/'. $data['ftp']['path'].'/'.$file_name;
                        if(is_file($path)){
                            unlink($path);
                        }
                    }
                }
            }
            if(!empty($data['lmd_format'])){
                $lmd_file_formats=explode('|', $data['lmd_format']);
                $lmd_allowed_types=array_unique(array_filter($lmd_file_formats));
                foreach ($lmd_allowed_types as $key => $lmd_allowed_type) {
                    if(strcasecmp($format,$lmd_allowed_type)==0){
                        $path = '/home/beamon9/public_html/testing/boots2_new/output/lmd/'.$file_name;
                        if(is_file($path)){
                            unlink($path);

                        }
                    }
                }
            }
            echo json_encode(array("status" => "success", "message" => "File Removed successfully.", "removedfilename" => $file_name, "filename" => $file_name,"format" => $format));

        }else{
            echo json_encode(array("status" => "failure", "message" => "File Not Exists","removedfilename" => $file_name, "filename" => $file_name,"format" => $format));

        }
    }else{
        echo json_encode(array("status" => "failure", "message" => "File Not Exists","removedfilename" => $file_name, "filename" => $file_name,"format" => $file_ref[1]));
    }
}
public function multifile_rework_done(){
    $data = $_POST;             
    $ord_id=$this->input->post('ord_id');
    $job_id=$this->input->post('job_id');
    $ord_reference_id=$this->input->post('ord_ref_id');
    $data['ftp'] = $this->cad_model1->get_ftp_mailaddress($ord_id);
    $data['laser_format'] =$this->cad_model1->get_laser_format($this->input->post('ord_id'));
    $data['lmd_format'] =$this->cad_model1->get_lmd_format($this->input->post('ord_id'));
    $files_alloweded=$data['ftp']['file_ext'].'|'.$data['lmd_format'];
    $file_formats=explode('|', $files_alloweded);
    $allowed_types=array_unique(array_filter($file_formats));
    $uploaded_formats=array_filter(explode(',',$data['upload_formats']));
    $balance_format=array_udiff($allowed_types,$uploaded_formats,'strcasecmp');
    $missing_reason=$this->input->post('rework_missing_reason');
    $missing_reason_value=$this->input->post('rework_missing_reason_value');
        //print_r($balance_format);
    if (empty($balance_format) ) {
            //insert uploaded files details
        $reason['uploaded_files']=$data['rework_upload_files'];
        $reason['reason']=$missing_reason;
        $reason['ord_id']=$ord_id;
        $reason['user']=$this->session->userdata('userlogname');
        $data['missing_reason'] = $this->cad_model1->insert_rework_file($reason);
            // update order status
        $rework_upload['ord_id']=$data['ord_id'];
        $rework_upload['job_id']=$data['job_id'];
        $rework_upload['id']=$data['ord_sts_id'];
        $rework_upload['rework_files']=1;
        $rework_upload_status=$this->cad_model1->notes_to_laser($rework_upload);
        $data["send_laser"] = $this->cad_model1->get_send_laser_status($ord_id,$job_id);
        echo json_encode(array("status" => "success", "message" => "Rework Files Successfully Uploaded.","send_laser"=>$data["send_laser"]));
    }else{

        if($missing_reason_value==0){
            echo json_encode(array("status" => "failure", "message" => $ord_id ));
        }else{  
            $reason['uploaded_files']=$data['rework_upload_files'];
            $reason['reason']=$missing_reason;
            $reason['ord_id']=$ord_id;
            $reason['user']=$this->session->userdata('userlogname');
            $data['missing_reason'] = $this->cad_model1->insert_rework_file($reason);

            $rework_upload['ord_id']=$data['ord_id'];
            $rework_upload['id']=$data['ord_sts_id'];
            $rework_upload['rework_files']=1;
            $rework_upload_status=$this->cad_model1->notes_to_laser($rework_upload);
            $data["send_laser"] = $this->cad_model1->get_send_laser_status($ord_id,$data['job_id']);
            echo json_encode(array("status" => "success", "message" => "Rework file Uploaded successfully.","missing"=>"true","send_laser"=>$data["send_laser"]));
        }
    }
}
    public function send_to_laser_popup(){
        $data=$_POST; 
        //print_r($data);exit; 
        if(get_epoxy($data['ord_id'])==1){
            $data['double_epoxy']=  $this->get_double_epoxy($data['ord_id']);
        }else{
            $data['double_epoxy']= 0 ;
        }
        $data['order_details'] = $this->cad_model1->get_order_detail($data['ord_id']);
        $data['job_details'] = $this->cad_model1->get_border_details($data['ord_id'],$data['job_id'],$data['ord_sts_id']);
        $data['stencil_foil_thik'] = $this->cad_model1->get_checklist_foil($data['job_details']['cad_checklist_id']);
	if(!empty($data['stencil_foil_thik'])){
	        if($data['stencil_foil_thik'][0]->thickness){ $data['stencil_foil'][] = $data['stencil_foil_thik'][0]->thickness; }
	        if($data['stencil_foil_thik'][0]->thickness){ $data['stencil_foil'][] = $data['stencil_foil_thik'][1]->thickness; }
	        if($data['stencil_foil_thik'][0]->thickness){ $data['stencil_foil'][] = $data['stencil_foil_thik'][2]->thickness; }
	        $data['foil_thikness'] = implode('/',array_filter($data['stencil_foil']));
	     
	        if(($data['job_details']['sc_material']=='FGM')&&(count(array_filter($data['stencil_foil']))==1)){
	            $data['foil_thikness'] = $data['foil_thikness'].$data['job_details']['sc_material'];
	        }
	        
	        if( $this->cad_model1->get_checklist_premount($data['job_details']['cad_checklist_id']) ){
	        	$data['foil_thikness'] = $data['foil_thikness']." (Premount)";
	        }
	}

        if($data['order_details']['ac']==''){
            $data['ac'][]="";
           if(isset($data['job_details']['sc_aperture_count'])){
               if(($data['job_details']['sc_aperture_count']!="")&&($data['job_details']['sc_aperture_count'] >= 10000)){
                   $data['ac'][]="HC-".$data['job_details']['sc_aperture_count'];
               }
           }
           if ($data['order_details']['fg_material']==1) {
               $data['ac'][]="FG";
           }
           if ($data['order_details']['epo_coat']==1) {
              $data['ac'][]="EPO";
           }
           if (($data['order_details']['stencil_side']==1) OR ($data['order_details']['stencil_side']==3)) {
               if (($data['order_details']['top_multilevel']!="") AND ($data['order_details']['top_multilevel_2']!="") ) {
                    $data['ac'][]="DSD";
               }
               if ($data['order_details']['top_multilevel']!="") {
                   $data['ac'][]="SD";
               }
          }
          if ($data['order_details']['stencil_side']==2) {
              if (($data['order_details']['bot_multilevel']!="") AND ($data['order_details']['bot_multilevel_2']!="") ) {
                  $data['ac'][]="DSD";
              }
              if ($data['order_details']['bot_multilevel']!="") {
                  $data['ac'][]="SD";
              }
         }
         if ($data['order_details']['film_plots']==1) {
             $data['ac'][]="PLOT";
         }
         if ($data['order_details']['nano_coat']==1) {
            $data['ac'][]="Nano";
         }
         if ($data['order_details']['ultra_nano']==1) {
            $data['ac'][]="BlueNano";
         }
     }else{
          $data['ac']=explode(',',$data['order_details']['ac']);
     }
         $this->load->view('cad/send_to_laser', $data);
    }
   public function send_to_laser_done(){

    $data=$_POST;
	//print_r($data);exit;
    if($data['aperture_content']==""){
        $error['aperture_content_em']="Please Enter aperture content";
    }
    if($data['foil_thickness']==""){
        $error['foil_thickness_em']="Please Enter foil thickness";
    }
    if( ($data['border']=="") && (strpos($data['job_code'], 'F') == false)){
        $error['border_em']="Please Select Border";
    }
    if(($data['border']=="Custom Border")&&($data['custom_border']=="")){
        $error['border_em']="Please Enter Border";
    }
    if(empty($error)){
    	$ord_sts_id = $data['ord_sts_id'];
        $data['cad_update']=date('Y-m-d H:i:s');
        if(get_epoxy($data['ord_id'])==2){
            if ($data['aperture_content'] > 10000) {
                //$data['double_epoxy']=1;
            }
        }
        $cad_update['aper_content']=$data['aperture_content'];
        $cad_update['foil_thick']=$data['foil_thickness'];
        if($data['border']=="Custom Border"){
            $cad_update['bord']=$data['custom_border'];
        }else{
            $cad_update['bord']=$data['border'];
        }
        $cad_update['double_epoxy']=$data['double_epoxy'];
        $cad_update['job_cad_instructions']=$data['instruction'];
        $cad_update['job_cad_lupdate']=$data['cad_update'];
        $cad_update['job_cad_status']=2;
        $data['cad_update_status'] = $this->cad_model1->cad_update($cad_update,$data['ord_id'],$data['job_id']);
        $cad_update_status['update_by']=$_SESSION['user_id'];
        $cad_update_status['update_to']="CAD - Completed";
        $cad_update_status['update_for']=2;
        $cad_update_status['update_status']=2;
        $cad_update_status['update_time']=date("Y-m-d H:i:s");
        $cad_update_status['update_remarks']=$data['instruction'];
        $data['job_update_status'] = $this->cad_model1->update_job_status($cad_update_status,$data['ord_id']);
        //update apeature to order table 
        $data['update_apeature'] = $this->cad_model1->update_order_apeature($data['ord_id'],$data['aperture_content']);
        $ac_update['ac']=$data['ac'];
        $data['cad_update_status'] = $this->cad_model1->ac_update($ac_update,$data['ord_id']);
        
        //update apeature content in checklist table
        $data['update_apeature'] = $this->cad_model1->update_checklist_apeature($ord_sts_id,$data['aperture_content']);
        
        echo json_encode(array('result' =>'success','message'=>'Cad Completed'));
    }else{
        $error["result"] = 'failed';
        $error["message"] = 'Some data Mising';
        echo json_encode($error);
    }
   }
   
   public function all_order_search() {
        $date = date("Y-m-d");
        $this->load->model('order_model');
        $order = $this->uri->segment(3);
        $data['search_all_string'] = $this->input->post('search_all_string');
        $data['high'] = $this->order_model->get_order_search($date,'2',$data['search_all_string']);
        $data['medium'] = $this->order_model->get_order_search($date,'1',$data['search_all_string']);
        $data['low'] = $this->order_model->get_order_search($date, '0',$data['search_all_string']);
        $this->template->build("order/new_order", $data);
    }
    public function email_attachment_upload(){
        $result="denied";
        $ord_reference_id = $_POST["ord_reference_id"];
        $data["ord_id"] = $_POST["ord_id"];
        $eng_id = $_POST["eng_id"];
        $name=$_FILES['file']['name'];
        $data['email_reminder']=$this->customer_model->get_reminder_details($eng_id);
        //print_r($data['email_reminder']);exit;
        $file_ref=explode('.', $name);
        $data['bottom_order'] = $_POST["bottom_order"];
        //$data['bottom_order']=$this->cad_model1->check_bottom_order($data['ord_id']);
        if (((substr($file_ref[0], 0, strlen($ord_reference_id)) === $ord_reference_id)||((substr($file_ref[0], 0, strlen("book1")) === "book1")||(substr($file_ref[0], 0, strlen("Book1")) === "Book1"))) && (count($file_ref)==2)) {
            $default_attachment=$this->cad_model1->customer_mail_default();
            $files_alloweded=$data['email_reminder']['file_ext']."|".$default_attachment;
            //print_r($files_alloweded);exit;
            $file_formats=explode('|', $files_alloweded);
            $allowed_types=array_unique(array_filter($file_formats));
            $format = substr($_FILES['file']['name'], strpos($_FILES['file']['name'], ".") + 1);
            foreach ($allowed_types as $key => $allowed_type) {
                if(strcasecmp($format,$allowed_type)==0){
                    $result="accepted";      
                }
            }
            if($result=="accepted"){
                $path = EMAIL_ATTACHMENT_PATH.$this->input->post('ord_reference_id');
                if(is_file($path.'/'.$_FILES['file']['name'])){
                    unlink($path.'/'.$_FILES['file']['name']);
                }
                (!is_dir($path)) ? mkdir($path, 0755, true) : "";
                $config['upload_path'] = $path;
                $config['allowed_types'] = '*';
                $this->upload->initialize($config);
                if (!$this->upload->do_upload('file')) {
                    $error = $this->upload->display_errors();
                    echo json_encode(array("status" => "failure", "message" => $error));
                } else {
                    if((substr($file_ref[0], 0, strlen("book1")) === "book1")||(substr($file_ref[0], 0, strlen("Book1")) === "Book1")){$file_ref[1]="d_".$file_ref[1];}
                    echo json_encode(array("status" => "success", "message" => "File Uploaded successfully.", "savedfilename" => $_FILES["file"]["name"], "filename" => $_FILES["file"]["name"],"format"=>$file_ref[1]));
                }
            }else{
                echo json_encode(array("status" => "failed", "message" => "File Format Mismatch.", "savedfilename" => $_FILES["file"]["name"], "filename" => $_FILES["file"]["name"]));
            }
        }elseif($data['bottom_order']!=""){
            if (((substr($file_ref[0], 0, strlen($data['bottom_order'])) === $data['bottom_order'])||((substr($file_ref[0], 0, strlen("book1")) === "book1")||(substr($file_ref[0], 0, strlen("Book1")) === "Book1"))) && (count($file_ref)==2)) {

                $default_attachment=$this->cad_model1->customer_mail_default();
                $files_alloweded=$data['email_reminder']['file_ext']."|".$default_attachment;
                //print_r($files_alloweded);exit;
                $file_formats=explode('|', $files_alloweded);
                $allowed_types=array_unique(array_filter($file_formats));
                $format = substr($_FILES['file']['name'], strpos($_FILES['file']['name'], ".") + 1);
                foreach ($allowed_types as $key => $allowed_type) {
                    if(strcasecmp($format,$allowed_type)==0){
                        $result="accepted";      
                    }
                }
                if($result=="accepted"){
                    $path = EMAIL_ATTACHMENT_PATH.$this->input->post('ord_reference_id');
                    if(is_file($path.'/'.$_FILES['file']['name'])){
                        unlink($path.'/'.$_FILES['file']['name']);
                    }
                    (!is_dir($path)) ? mkdir($path, 0755, true) : "";
                    $config['upload_path'] = $path;
                    $config['allowed_types'] = '*';
                    $this->upload->initialize($config);
                    if (!$this->upload->do_upload('file')) {
                        $error = $this->upload->display_errors();
                        echo json_encode(array("status" => "failure", "message" => $error));
                    } else {
                        if((substr($file_ref[0], 0, strlen("book1")) === "book1")||(substr($file_ref[0], 0, strlen("Book1")) === "Book1")){$file_ref[1]="d_".$file_ref[1];}
                        echo json_encode(array("status" => "success", "message" => "File Uploaded successfully.", "savedfilename" => $_FILES["file"]["name"], "filename" => $_FILES["file"]["name"],"format"=>"b_".$file_ref[1]));
                    }
                }else{
                    echo json_encode(array("status" => "failed", "message" => "File Format Mismatch.", "savedfilename" => $_FILES["file"]["name"], "filename" => $_FILES["file"]["name"]));
                }

            }else{
                echo json_encode(array("status" => "failed", "message" => "Wrong File Uploaded.", "savedfilename" => $_FILES["file"]["name"], "filename" => $_FILES["file"]["name"]));
            }
        }else{
            echo json_encode(array("status" => "failed", "message" => "Wrong File Uploaded.", "savedfilename" => $_FILES["file"]["name"], "filename" => $_FILES["file"]["name"]));
        }
    }
    public function email_attachment_remove(){
        $file_name = str_replace(" ","_",$this->input->post('filename'));
        $file_ref=explode('.', $file_name);
        $path = EMAIL_ATTACHMENT_PATH.$this->input->post('ord_reference_id');
        $data["ord_id"] = $_POST["ord_id"];
        $data['bottom_order'] = $_POST["bottom_order"];
        //$data['bottom_order']=$this->cad_model1->check_bottom_order($data['ord_id']);
        $ord_reference_id=$this->input->post('ord_reference_id');
        if(is_file($path.'/'.$file_name)){
            if (((substr($file_ref[0], 0, strlen($ord_reference_id)) === $ord_reference_id)||((substr($file_ref[0], 0, strlen("book1")) === "book1")||(substr($file_ref[0], 0, strlen("Book1")) === "Book1"))) && (count($file_ref)==2)) {
                unlink($path.'/'.$file_name);
                if((substr($file_ref[0], 0, strlen("book1")) === "book1")||(substr($file_ref[0], 0, strlen("Book1")) === "Book1")){$file_ref[1]="d_".$file_ref[1];}
                echo json_encode(array("status" => "success", "message" => "Removed.", "removedfilename" => $file_name, "filename" => $file_name,"format"=>$file_ref[1]));
            }elseif (((substr($file_ref[0], 0, strlen($data['bottom_order'])) === $data['bottom_order'])||((substr($file_ref[0], 0, strlen("book1")) === "book1")||(substr($file_ref[0], 0, strlen("Book1")) === "Book1"))) && (count($file_ref)==2)) {

                unlink($path.'/'.$file_name);
                if((substr($file_ref[0], 0, strlen("book1")) === "book1")||(substr($file_ref[0], 0, strlen("Book1")) === "Book1")){$file_ref[1]="d_".$file_ref[1];}
                echo json_encode(array("status" => "success", "message" => "Removed.", "removedfilename" => $file_name, "filename" => $file_name,"format"=>"b_".$file_ref[1]));

            }

        }else{
            echo json_encode(array("status" => "failed", "message" => "Missing.", "removedfilename" => $file_name, "filename" => $file_name));
        }
        
    }
    public function change_reminder_status(){
        //print_r($this->input->post('order_id'));exit;
                $job_updates['update_date']=date("Y-m-d");
                $job_updates['update_time']=date("Y-m-d h:i:s");
                $job_updates['update_to']="UN-HOLD";
                $job_updates['update_for']=1;
                $job_updates['update_status']=1;
                $job_updates['show_customer']=1;
                $job_updates['update_remarks']="UN-Hold by Wims 2";
                $job_updates['update_by']=$this->session->userdata('user_id');
                $cust_job_update_status=$this->cad_model1->update_job_status($job_updates,$this->input->post('job_id'));
                $job_updates['update_date']=date("Y-m-d");
                $job_updates['update_time']=date("Y-m-d h:i:s");
                $job_updates['update_to']="REMINDER DEACTIVATED";
                $job_updates['update_for']=1;
                $job_updates['update_status']=1;
                $job_updates['show_customer']=1;
                $job_updates['update_remarks']="REMINDER DEACTIVATED by Wims 2";
                $job_updates['update_by']=$this->session->userdata('user_id');
                $cust_job_update_status=$this->cad_model1->update_job_status($job_updates,$this->input->post('job_id'));
        $status=$this->cad_model1->change_reminder_status($this->input->post('order_id'),$this->input->post('job_id'));
        $bottom_order=$this->cad_model1->check_mail_bottom_order($this->input->post('order_id'),$this->input->post('job_id'));
            if ($bottom_order!="") {
                $job_updates['update_date']=date("Y-m-d");
                $job_updates['update_time']=date("Y-m-d h:i:s");
                $job_updates['update_to']="UN-HOLD";
                $job_updates['update_for']=1;
                $job_updates['update_status']=1;
                $job_updates['show_customer']=1;
                $job_updates['update_remarks']="UN-Hold by Wims 2";
                $job_updates['update_by']=$this->session->userdata('user_id');
                $cust_job_update_status=$this->cad_model1->update_job_status($job_updates,get_job_id( $bottom_order));
                $job_updates['update_date']=date("Y-m-d");
                $job_updates['update_time']=date("Y-m-d h:i:s");
                $job_updates['update_to']="REMINDER DEACTIVATED";
                $job_updates['update_for']=1;
                $job_updates['update_status']=1;
                $job_updates['show_customer']=1;
                $job_updates['update_remarks']="REMINDER DEACTIVATED by Wims 2";
                $job_updates['update_by']=$this->session->userdata('user_id');
                $cust_job_update_status=$this->cad_model1->update_job_status($job_updates,get_job_id( $bottom_order));
                $status1=$this->cad_model1->change_reminder_status(get_order_id( $bottom_order),get_job_id( $bottom_order));
            }
        if($status>0){
            echo json_encode(array("status" => "success", "message" => "Email Reminder Disabled"));
        }else{
            echo json_encode(array("status" => "failed", "message" => "Email Reminder Disable Failed"));
        }
    }
    
    public function change_hold_status(){
        //print_r($this->input->post('order_id'));exit;
                $job_updates['update_date']=date("Y-m-d");
                $job_updates['update_time']=date("Y-m-d h:i:s");
                $job_updates['update_to']="UN-HOLD";
                $job_updates['update_for']=1;
                $job_updates['update_status']=1;
                $job_updates['show_customer']=1;
                $job_updates['update_remarks']="UN-Hold by Wims 2";
                $job_updates['update_by']=$this->session->userdata('user_id');
                $cust_job_update_status=$this->cad_model1->update_job_status($job_updates,$this->input->post('order_id'));
                $job_updates['update_date']=date("Y-m-d");
                $job_updates['update_time']=date("Y-m-d h:i:s");
                $job_updates['update_to']="REMINDER DEACTIVATED";
                $job_updates['update_for']=1;
                $job_updates['update_status']=1;
                $job_updates['show_customer']=1;
                $job_updates['update_remarks']="REMINDER DEACTIVATED by Wims 2";
                $job_updates['update_by']=$this->session->userdata('user_id');
                $cust_job_update_status=$this->cad_model1->update_job_status($job_updates,$this->input->post('job_id'));
                $bottom_order=$this->cad_model1->check_mail_bottom_order($this->input->post('order_id'),$this->input->post('job_id'));
                //print_r($bottom_order);exit;
            if ($bottom_order!="") {
                $job_updates['update_date']=date("Y-m-d");
                $job_updates['update_time']=date("Y-m-d h:i:s");
                $job_updates['update_to']="UN-HOLD";
                $job_updates['update_for']=1;
                $job_updates['update_status']=1;
                $job_updates['show_customer']=1;
                $job_updates['update_remarks']="UN-Hold by Wims 2";
                $job_updates['update_by']=$this->session->userdata('user_id');
                $cust_job_update_status=$this->cad_model1->update_job_status($job_updates,get_order_id($bottom_order));
                $job_updates['update_date']=date("Y-m-d");
                $job_updates['update_time']=date("Y-m-d h:i:s");
                $job_updates['update_to']="REMINDER DEACTIVATED";
                $job_updates['update_for']=1;
                $job_updates['update_status']=1;
                $job_updates['show_customer']=1;
                $job_updates['update_remarks']="REMINDER DEACTIVATED by Wims 2";
                $job_updates['update_by']=$this->session->userdata('user_id');
                $cust_job_update_status=$this->cad_model1->update_job_status($job_updates,get_order_id($bottom_order));
                $status1=$this->cad_model1->change_reminder_status(get_order_id($bottom_order),get_job_id($bottom_order));
            }
        $status=$this->cad_model1->change_reminder_status($this->input->post('order_id'),$this->input->post('job_id'));
        if($status>0){
            echo json_encode(array("status" => "success", "message" => "Job UN-HOLD Successfully"));
        }else{
            echo json_encode(array("status" => "failed", "message" => "Job UN-HOLD Failed"));
        }
    }
    
    public function top_order(){
    	
    	$top_order=$this->cad_model1->check_top_order($this->uri->segment(3));
    	print_r($top_order);exit;
    }
    public function proceed_without_oldjob(){
        $data=$_POST;
        $oldjob['ord_id']=$data['ord_id'];
        $oldjob['job_id']=$data['job_id'];
        $oldjob['oldjob_files']=1;
        $oldjob=$this->cad_model1->proceed_without_oldjob($oldjob);
        $send_to_laser_status =$this->cad_model1->get_send_laser_status($data['ord_id'],$data['job_id']);
        if($oldjob){
            echo json_encode(array("result" => "success", "message" => "old job successfully updated","send_laser"=>$send_to_laser_status));
        }else{
            echo json_encode(array("result" => "failure", "message" => "old job update failed","send_laser"=>$send_to_laser_status));
        }
    }
    public function checklist_upload_file(){
        $data = $_POST;
        $uploads = $this->cad_model1->get_checklist_uploads($data['order_status_id'],$data['check_type']);
        //echo "<pre>";print_r($uploads);exit;
        
        if($uploads){
            foreach($uploads as $key => $upload){
            	$files_array = explode(',',$upload['files']);
            	$uploads[$key]['files'] = implode('<br/>',$files_array);
            }
            $result = array('result'=>'success','message'=>'successfully retrieved','files'=>$uploads);
        }else{
            $result = array('result'=>'failure','message'=>'no files Uploaded');
        }
        echo json_encode($result);
    }

    public function dashboard() {

        $date = date('Y-m-d');
        $data['high'] = $this->cad_model1->get_cad_status('2', '1', $date);
        $data['normal'] = $this->cad_model1->get_cad_status('1', '1', $date);
        $data['low'] = $this->cad_model1->get_cad_status('0', '1', $date); 
        
        $cad_orders = "";
        $cad_orders .='<tr class="high"><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr>';
        foreach($data['high'] as $key => $high){
			
			$ref_no_color=get_setp_down_order_details($high['job_code']);
          if ($high['job_cad_status'] == '1') {
               $cad_status = "Working";
            } else if ($high['job_cad_status'] == '2') {
                $cad_status = 'Completed';
            } else {
                $cad_status = 'Not yet Started';
            }
			
			
			if($ref_no_color=="0") {
				$cad_orders .='<tr><td>'.date("m-d-Y", strtotime($high['due_date'])).'</td><td><a data-priority="high1" data-reference-id="'.$high['job_code'].'" data-item-id="'.$high['ord_id'].'" data-job-id="'.$high['job_id'].'" data-engg-id="'.$high['eng_id'].'" href="#" class="cad_popup button">'.$high['job_code'].'</a></td><td>'.$high['cust_name'].'</td><td>'.$high['contact_name'].$high['contact_no'].'</td><td></td><td>'.$cad_status.'</td></td><td></td></tr>';
				
			}else{
				$cad_orders .='<tr><td>'.date("m-d-Y", strtotime($high['due_date'])).'</td><td><a data-priority="high1" data-reference-id="'.$high['job_code'].'" data-item-id="'.$high['ord_id'].'" data-job-id="'.$high['job_id'].'" data-engg-id="'.$high['eng_id'].'" href="#" class="cad_popup button" style="color: #1b00ff;">'.$high['job_code'].'</a></td><td>'.$high['cust_name'].'</td><td>'.$high['contact_name'].$high['contact_no'].'</td><td></td><td>'.$cad_status.'</td></td><td></td></tr>';
			}
        }
        $cad_orders .='<tr class="medium"><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr>';
        foreach($data['normal'] as $key => $normal){
			$ref_no_color=get_setp_down_order_details($normal['job_code']);
          if ($normal['job_cad_status'] == '1') {
               $cad_status = "Working";
            } else if ($normal['job_cad_status'] == '2') {
                $cad_status = 'Completed';
            } else {
                $cad_status = 'Not yet Started';
            }
			
			if($ref_no_color=="0") 
			{
				 $cad_orders .='<tr><td>'.date("m-d-Y", strtotime($normal['due_date'])).'</td><td><a data-priority="medium1" data-reference-id="'.$normal['job_code'].'" data-item-id="'.$normal['ord_id'].'" data-job-id="'.$normal['job_id'].'" data-engg-id="'.$normal['eng_id'].'" href="#" class="cad_popup button">'.$normal['job_code'].'</a></td><td>'.$normal['cust_name'].'</td><td>'.$normal['contact_name'].$normal['contact_no'].'</td><td></td><td>'.$cad_status.'</td></td><td></td></tr>';
			}
			else
			{
				 $cad_orders .='<tr><td>'.date("m-d-Y", strtotime($normal['due_date'])).'</td><td><a data-priority="medium1" data-reference-id="'.$normal['job_code'].'" data-item-id="'.$normal['ord_id'].'" data-job-id="'.$normal['job_id'].'" data-engg-id="'.$normal['eng_id'].'" href="#" class="cad_popup button" style="color: #1b00ff;">'.$normal['job_code'].'</a></td><td>'.$normal['cust_name'].'</td><td>'.$normal['contact_name'].$normal['contact_no'].'</td><td></td><td>'.$cad_status.'</td></td><td></td></tr>';
			}
         
        }
        $cad_orders .='<tr class="low"><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr>';
        foreach($data['low'] as $key => $low){
			$ref_no_color=get_setp_down_order_details($low['job_code']);
          if ($low['job_cad_status'] == '1') {
               $cad_status = "Working";
            } else if ($low['job_cad_status'] == '2') {
                $cad_status = 'Completed';
            } else {
                $cad_status = 'Not yet Started';
            }
			if($ref_no_color=="0") 
			{
				$cad_orders .='<tr><td>'.date("m-d-Y", strtotime($low['due_date'])).'</td><td><a data-priority="low1" data-reference-id="'.$low['job_code'].'" data-item-id="'.$low['ord_id'].'" data-job-id="'.$low['job_id'].'" data-engg-id="'.$low['eng_id'].'" href="#" class="cad_popup button">'.$low['job_code'].'</a></td><td>'.$low['cust_name'].'</td><td>'.$low['contact_name'].$low['contact_no'].'</td><td></td><td>'.$cad_status.'</td></td><td></td></tr>';
			}
			else
			{
				$cad_orders .='<tr><td>'.date("m-d-Y", strtotime($low['due_date'])).'</td><td><a data-priority="low1" data-reference-id="'.$low['job_code'].'" data-item-id="'.$low['ord_id'].'" data-job-id="'.$low['job_id'].'" data-engg-id="'.$low['eng_id'].'" href="#" class="cad_popup button" style="color: #1b00ff;">'.$low['job_code'].'</a></td><td>'.$low['cust_name'].'</td><td>'.$low['contact_name'].$low['contact_no'].'</td><td></td><td>'.$cad_status.'</td></td><td></td></tr>';
			}
			
          
        }
        echo json_encode(array('status' => 'success','data' => $cad_orders));
    }

public function get_mailzip_size(){
           $data=$_POST;
           //echo "<pre>";print_r($data);exit;
           $bottom_order=$data['bottom_order'];
           if($bottom_order !=""){
               $bottom_order_attach="-".substr($bottom_order, -2);
           }else{
              $bottom_order_attach="";
           }
           $no_attach=isset($_POST["no_attach"]) ? 1 : 0 ;
           $this->load->helper('directory');
           $this->load->library('zip');
           if($no_attach==0){
               $path = EMAIL_ATTACHMENT_PATH.$this->input->post('order_reference_id');
               $email_attachment=$this->input->post('upload_files');
               $uploaded_files=array_filter(explode(',',$email_attachment));
               foreach ($uploaded_files as $key => $file) {
                   $this->zip->read_file($path.'/'.str_replace(" ","_",$file));
               }
               $this->zip->archive($path.$bottom_order_attach.'.zip');

               $file_size_zip = formatSizeUnits(filesize($path.$bottom_order_attach.'.zip'));
               if(($file_size_zip['type'] != 'KB')&&($file_size_zip['type'] != 'bytes')&&($file_size_zip['type'] != 'byte')&&($file_size_zip['type'] != 'bytes')){
                   if($file_size_zip['value'] >= 25){
                        $result = array('status'=>'failure','message'=>'File size Greater than 25 MB.','size'=>$file_size_zip['value'].' '.$file_size_zip['type']);
                   }else{
                        $result = array('status'=>'success','message'=>'File size less than 25 MB.','size'=>$file_size_zip['value'].' '.$file_size_zip['type']);
                   }
               }else{
                   $result = array('status'=>'success','message'=>'File size less than 25 MB.','size'=>$file_size_zip['value'].' '.$file_size_zip['type']);
               }
        }else{
             $result = array('status'=>'success','message'=>'No file attachment','size'=>'0 KB');
        }
       
       echo json_encode($result);
}
public function check_premount(){
    $data['frame'] = $this->input->post('frames');
    $data['border'] = $this->input->post('border');
    if(($data['frame']=="29x29x1.5" && $data['border']=="Z2" )||($data['frame']=="29x29x0.5" && $data['border']=="Z2" )||($data['frame']=="20x20" && $data['border']=="18X18" )||($data['frame']=="20x20 CAST" && $data['border']=="18X18" )||($data['frame']=="20x20 Tubular" && $data['border']=="18X18" )){
        echo json_encode(array("result"=>"success","message"=>"premount should be allowed","check"=>1));
    }else{
        echo json_encode(array("result"=>"failed","message"=>"premount should not be allowed","check"=>0));
    }
}

public function checkattachment(){
    if($this->input->post()){
        $data=$_POST;
        //$available = strpos(strtolower($data['mail_message']),"attach");
        
        if((strpos(strtolower($data['mail_message']),"attach"))||(strpos(strtolower($data['mail_message']),"refer"))){
            if($data['mail_attach_overwrite'] == 0 ){
            	$no_attach = isset($data["no_attach"]) ? 1 : 0 ;
	            if( ($no_attach == 1) || ($data['upload_count'] == 0)){
	                echo json_encode(array('result' => 'failure', 'message' => 'You may have forgotten to attach a file.' ));
	            }else{
	                echo json_encode(array('result' => 'success', 'message' => 'Attachment Word and attachment found in mail' ));
	            }
            }else{
            	echo json_encode(array('result' => 'success', 'message' => 'No Attachment overwritten success' ));
            }
            
        }else{
           /* $available = strpos($data['mail_message'] ,"Attach");
            if($available){
                $no_attach = isset($data["no_attach"]) ? 1 : 0 ;
                if( ($no_attach == 1) || ($data['upload_count'] == 0)){
                    echo json_encode(array('result' => 'failure', 'message' => 'You may have forgotten to attach a file.' ));
                }else{
                    echo json_encode(array('result' => 'success', 'message' => 'Attachment Word and attachment found in mail' ));
                }
            }else{*/
                echo json_encode(array('result' => 'success', 'message' => 'Attachment Word not found' ));
            /* } */
        }
    }
}
    
//Above Code Written By KRISHNAMK
}