<?php

class tooling_model extends CI_Model {

/**
*
* Getting Tooling Status
*
**/
	function get_tooling_status($priority, $cad_status, $date,$search='') {
        $this->db->select('toj.*,to.ord_id,to.ad_dt,to.eng_id,tc.cust_name,tc.contact_name,tc.contact_no');
        $this->db->from(TBL_TOOLING_JOBS . " toj");
        $this->db->join(TBL_ORDER . " to", 'to.ord_id = toj.ord_id','left');
        $this->db->join(TBL_CUSTOMER . " tc", 'tc.cust_id = toj.cust_id');
        //$this->db->join(TBL_ORDER_STATUS . " tos",'tos.ord_id = toj.ord_id','right');
        //$this->db->join(TBL_ENGINEER . " te", 'te.eng_id = to.eng_id');
        $this->db->where('toj.tjob_status', 1);
        $this->db->where('toj.tjob_priority', $priority);
        if(!empty($search)){
             $this->db->like('toj.tjob_code', $search);
        }
        $this->db->order_by("toj.tjob_priority","desc");
        $this->db->order_by("toj.due_date","asc");
        $this->db->order_by("toj.due_time","asc");
        $this->db->where_in('toj.tjob_cad_status', array(WORK_NOT_STARTED, WORK_STARTED));
        $this->db->where('toj.tjob_complet_status',0);
        $query = $this->db->get();
        return $query->result_array();
    }
/**
*
* Getting Order Status Using Order Id
*
**/
    function get_order_status($id) {
        $this->db->where('ord_id', $id);
        return $this->db->get(TBL_TOOLING_JOBS)->row_array();
    }
/**
*
* Getting Custom Foil Status Using Order Id
*
**/
	function get_custom_foil_status($id) {
        $this->db->where('ord_id', $id);
        $result=$this->db->get(TBL_ORDER)->row_array();
        //return $result['frm_size'];
        if($result['frm_size'] > 0){
            //if frame is not custom frame then normal upload
            return 0;
            //return 1 to enable upload files
        }else{
            if($result['other_frame_size']==1){
                //return 1 to enable upload files
                return 0;
            }else{
                //return 1 to enable rework upload
                return 1;
            }
        }
    }
/**
*
* Getting Job Status Using Order Id
*
**/
    function get_job_status($id) {
        $this->db->where('tjob_id', $id);
        return $this->db->get(TBL_TOOLING_JOBS)->row_array();
    }
/**
*
* Checking Reminder For order Id
*
**/
    function check_reminder($ord_id,$job_id){
        $this->db->where('ord_id',$ord_id);
        $this->db->where('job_id',$job_id);
        $this->db->where('reminder',1);
        $query=$this->db->get(TBL_TOOLING_MAIL)->result_array();
        return count($query);
    }
/**
*
* Send To Laser status status
*
**/
    function get_send_tooling_status($ord_id,$job_id){
        $this->db->where('ord_id', $ord_id);
        $result=$this->db->get(TBL_ORDER)->row_array();
        //return $result['frm_size'];
        $this->db->where('ord_id', $ord_id);
        $this->db->where('job_id', $job_id);
        $result1=$this->db->get(TBL_TOOLING_STATUS)->row_array();
        //print_r($result1);exit;
        if($result['frm_size'] > 0){
            //if frame is not custom frame then normal upload
            //return 0;
            if($result1['upload_files']==1 && $result1['oldjob_files']==1){
                return 1;
            }else{
                return 0;
            }
            //return 1 to enable upload files
        }else{
            if($result['other_frame_size']==1){
                //return 0 to enable upload files
                //return 0;
                if($result1['upload_files']==1 && $result1['oldjob_files']==1){
                    return 1;
                }else{
                    return 0;
                }
            }else{
                //return 1 to enable rework upload
                //return 1;
                if($result1['rework_files']==1 && $result1['oldjob_files']==1){
                    return 1;
                }else{
                    return 0;
                }
            }
        }
    }
    function change_cad_working($job_code) {
        $this->db->where('tjob_code', $job_code);
        $update['tjob_cad_status'] = 1;
        $this->db->update(TBL_TOOLING_JOBS, $update);
    }


    function get_job_status_job_code($job_code) {
        $this->db->where('tjob_code', $job_code);
        return $this->db->get(TBL_TOOLING_JOBS)->row_array();
    }

    function change_cad_working_history($data) {
        $data['tjob_id']=get_tjob_id($data['job_code']);
        unset($data['job_code']);
        $data['update_by'] = $this->session->userdata('user_id');
        $data['update_time'] = date("Y-m-d H:i:s");
        $this->db->insert(TBL_ORDER_STATUS_UPDATE, $data);
    }

    function customer_mail_default(){
        $default="png|pdf";
        return $default;
    }

    function insert_mail_reminder($data){
        $this->db->insert(TBL_TOOLING_MAIL,$data);
        $insid=$this->db->insert_id();

        $status['status']=0;
        $status['reminder']=0;
        $this->db->where('ord_id',$data['ord_id']);
        $this->db->where('job_id',$data['job_id']);
        $this->db->where('mail_id !=',$insid);
        $this->db->update(TBL_TOOLING_MAIL,$status);

        return $insid;
        
    }

    function cust_mail_update($data,$ord_id,$job_id) {
        $this->db->where('ord_id', $ord_id);
        $this->db->where('job_id', $job_id);
        $this->db->update(TBL_TOOLING_STATUS, $data);
    }

    function cad_update($data,$ord_id,$job_id) {
        //echo "<pre>";print_r($ord_id);print_r($data);exit;
        $this->db->where('ord_id', $ord_id);
        $this->db->where('tjob_id', $job_id);
        $this->db->update(TBL_TOOLING_JOBS, $data);
    }

    function update_job_status($data,$job_id) {
        $data['tjob_id']=$job_id;
        $this->db->insert(TBL_TOOLING_UPDATES, $data);
    }
    
    function change_reminder_status($ord_id,$job_id){
        $data['reminder']=0;
        $this->db->where('ord_id', $ord_id);
        $this->db->where('job_id', $job_id);
        $result=$this->db->update(TBL_TOOLING_MAIL, $data);
        $job['tjob_status']=1;
        $this->db->where('ord_id', $ord_id);
        $this->db->where('tjob_id', $job_id);
        $result1=$this->db->update(TBL_TOOLING_JOBS, $job);

        if($result > 0){
            return 1;
        }else{
            return 0;
        }
    }
    function check_bottom_order($ord_id) {
        $this->db->select('order_code');
        $this->db->where('ord_id', $ord_id);
        $query=$this->db->get(TBL_ORDER)->row_array();

        $this->db->select('order_code,old_data_ref');
        $this->db->where('order_code >', $query['order_code']);
        $this->db->order_by('order_code','asc');
        $this->db->limit(1);
        $query1=$this->db->get(TBL_ORDER)->row_array();
        if($query1['old_data_ref']==$query['order_code']){
            $this->db->select('tjob_code');
            $this->db->where('tjob_code', $query1['order_code']);
            $this->db->where('tjob_status !=', '-1');
            $query2=$this->db->get(TBL_TOOLING_JOBS);
            if($query2->num_rows()>0){
                $result2 = $query2->row_array();
                return $result2['tjob_code'];
            }else{
                return false;
            }
        }else{
            return false;
        }
    }
    
    function check_mail_bottom_order($ord_id,$job_id){
        $this->db->select('bottom_order');
        $this->db->where('ord_id',$ord_id);
        $this->db->where('job_id',$job_id);
        $this->db->where('status', 1);
        $this->db->order_by('mail_id', 'desc');
        $this->db->limit(1);
        $query=$this->db->get(TBL_TOOLING_MAIL);
        if($query->num_rows()>0){
                $result = $query->row_array();
                return $result['bottom_order'];
            }else{
                return false;
            }
    }
    
    function get_templates($id = "") {
        $this->db->select('*');
        if (!empty($id)) {
            $this->db->where('mail_id', $id);
        }
        $query = $this->db->get(TBL_TOOLING_MAIL_TEMPLATES);
        return $query->result();
    }
    
    function mail_templates($data) {
        $this->db->insert(TBL_TOOLING_MAIL_TEMPLATES, $data);
    }
    
    function edit_templates($data) {
        $this->db->where('mail_id', $data['mail_id']);
        $this->db->update(TBL_TOOLING_MAIL_TEMPLATES, $data);
    }
    
     function delete_templates($id) {
        $this->db->where('mail_id', $id);
        $this->db->delete(TBL_TOOLING_MAIL_TEMPLATES);
    }
    
    function get_fixture_smt_status($id) {
        $this->db->where('ord_id', $id);
        $result = $this->db->get(TBL_ORDER)->row_array();
        return $result['fixture_smt'];
    }

    function check_for_tooling_file($job_code,$ord_id){
        if($ord_id != 0){
            $JOB_KEY_ARRAY = array('X','P','C','R','I','U','W','D','F');
            if((strpos($job_code, 'X') !== false)||(strpos($job_code, 'C') !== false)){
                return 1;
            }elseif(!preg_match("/[a-z]/i",$job_code)){
                return 1;
            }else{
                return 0;
            }
        }else{
            return 0;
        }
    }

    
}
?>