<?php

class cad_model1 extends CI_Model {
/*
    function get_cad_status($priority, $cad_status, $date) {
//            $CI = &get_instance();
//        //setting the second parameter to TRUE (Boolean) the function will return the database object.
//        $this->db = $CI->load->database('wims1db', TRUE);
        $this->db->select('to.ord_id,to.ad_dt,tc.cust_name,tc.contact_name,tc.contact_no,te.eng_email,to.order_code,tos.cad_status,to.ad_by,to.ship_by_date');
        $this->db->join(TBL_ORDER . " to", 'tos.ord_id = to.ord_id');
        $this->db->join(TBL_CUSTOMER . " tc", 'to.cust_id = tc.cust_id');
        $this->db->join(TBL_ENGINEER . " te", 'to.ad_by = te.eng_id');
        $this->db->join(TBL_JOBS . " toj", 'tos.ord_id = toj.ord_id');
        $this->db->where_in('cad_status', array(WORK_NOT_STARTED, WORK_STARTED));
        $this->db->where('tos.is_hold', WORK_NOT_IN_HOLD);
        $this->db->where('toj.job_priority', $priority);
//        $this->db->where('to.ord_dt', $date);
        $query = $this->db->get(TBL_ORDER_STATUS . " tos");
        return $query->result_array();
    }
/* */
    //below code written by KRISHNAMK
   function get_cad_status($priority, $cad_status, $date,$search='') {
        $this->db->select('toj.*,to.ord_id,to.ad_dt,to.eng_id,tc.cust_name,tc.contact_name,tc.contact_no');
        $this->db->from(TBL_JOBS . " toj");
        $this->db->join(TBL_ORDER . " to", 'toj.ord_id = to.ord_id','left');
        $this->db->join(TBL_CUSTOMER . " tc", 'tc.cust_id = toj.cust_id');
        //$this->db->join(TBL_ORDER_STATUS . " tos",'tos.ord_id = toj.ord_id','right');
        //$this->db->join(TBL_ENGINEER . " te", 'te.eng_id = to.eng_id');
        $this->db->where_in('toj.job_status', 1);
        $this->db->where('toj.job_priority', $priority);
        if(!empty($search)){
             $this->db->like('toj.job_code', $search);
        }
        $this->db->order_by("toj.job_priority","desc");
        $this->db->order_by("toj.due_date","asc");
        $this->db->order_by("toj.due_time","asc");
        $this->db->where_in('toj.job_cad_status', array(WORK_NOT_STARTED, WORK_STARTED));
        $this->db->where('toj.job_complet_status',0);
        $query = $this->db->get();
        return $query->result_array();
    }
    //above code written by KRISHNAMK

    function cad_status($data) {
//            $CI = &get_instance();
//        //setting the second parameter to TRUE (Boolean) the function will return the database object.
//        $this->wims1db = $CI->load->database('wims1db', TRUE);
        $this->db->where('job_id', $data['job_id']);
        $this->db->update('tbl_jobs', $data);
    }

    function update_job($data) {
//    $CI = &get_instance();
//        //setting the second parameter to TRUE (Boolean) the function will return the database object.
//        $this->wims1db = $CI->load->database('wims1db', TRUE);
        unset($data['job_cad_status']);
        $this->db->insert(TBL_JOBS_UPDATES, $data);
    }

    function upload_archive($data) {
        $this->db->insert(TBL_ORDER_STATUS_FILES, $data);
    }

    function update_archive($data) {
        $this->db->where('order_status_id', $data['order_status_id']);
        $this->db->where('file_type', $data['file_type']);
        $this->db->update(TBL_ORDER_STATUS_FILES, $data);
    }

    function uploaded_files_details($order_status_id, $file_type) {
        $this->db->select('*');
        $this->db->where('order_status_id', $order_status_id);
        $this->db->where('file_type', $file_type);
        $query = $this->db->get(TBL_ORDER_STATUS_FILES);
//        print_r($query->row_array());exit;
        return $query->row_array();
    }

    function staus_change_order_status($ord_id,$data){//update checklist complete status to tbl_order_status
        $this->db->where('ord_id', $ord_id);
        $this->db->update(TBL_ORDER_STATUS, $data);
    }

    function get_order_status($ord_id,$job_id) {
        $this->db->where('ord_id', $ord_id);
        $this->db->where('job_id', $job_id);
        return $this->db->get(TBL_ORDER_STATUS)->row_array();
    }


    function change_cad_working($job_code) {
        $this->db->where('job_code', $job_code);
        $update['job_cad_status'] = 1;
        $this->db->update(TBL_JOBS, $update);
    }

    function change_cad_working_history($data) {
        $data['job_id']=get_job_id($data['job_code']);
        unset($data['job_code']);
        $data['update_by'] = $this->session->userdata('user_id');
        $data['update_time'] = date("Y-m-d H:i:s");
        $this->db->insert(TBL_ORDER_STATUS_UPDATE, $data);
    }

    function compare_check_list($data) {
        $this->db->select($data['cl_data']);
        $this->db->where($data['cl_data'], $data['cl_value']);
        return $this->db->get(TBL_CAD_CHECKLIST)->row_array();
    }

    function compare_order_datas($order_id, $field_name, $field_value) {

        $this->db->select($field_name);
        $this->db->where('ord_id', $order_id);
        $this->db->where($field_name, $field_value);
        return count($this->db->get(TBL_ORDER)->result_array());
    }

    function get_borders($frame_name) {
        $this->db->select("frame_id");
        $this->db->where("frame", $frame_name);
        $frame_id = $this->db->get(TBL_FRAME_USED)->row_array();
//        return ($frame_id);
        $this->db->select("*");
        $this->db->where("frame_used_id", $frame_id["frame_id"]);
        return $this->db->get(TBL_FRAME_BORDERS)->result_array();

    }

    function compare_frame_size($frame_used, $order_id) {
        $this->db->select('to.frm_size');
        $this->db->where('to.ord_id', $order_id);
        $frame = $this->db->get(TBL_ORDER . " to")->row_array();

        $this->db->select('sf_name');
        $this->db->where('sf_id', $frame["frm_size"]);
        $this->db->where('sf_name', $frame_used);
        $frame_result = $this->db->get(MST_STENCIL_FORMAT)->row_array();
        return (!empty($frame_result)) ? true : false;
    }
    
    function compare_custom_frame_size($frame_used, $order_id) {
        $this->db->select('to.custom_size');
        $this->db->where('to.ord_id', $order_id);
        $this->db->where('to.custom_size', $frame_used);
        $frame = $this->db->get(TBL_ORDER . " to")->row_array();

        return (!empty($frame)) ? true : false;
    }

//    function get_order_engineer($order_id) {
//        $this->db->select('te.eng_fname,te.eng_lname');
//        $this->db->join(TBL_ORDER . " to", 'to.eng_id = te.eng_id');
//        $this->db->where('to.ord_id', $order_id);
//        $query = $this->db->get(TBL_ENGINEER . " te");
//        return $query->row_array();
//    }

     function get_frame_size($ord_id) {
        $this->db->select('frm_size');
        $this->db->where('ord_id', $ord_id);
        $stats = $this->db->get(TBL_ORDER)->row_array();

        return (!empty($stats)) ? $stats['frm_size'] : false;
    }

    function compare_foil_thickness($foil_thickness, $order_id, $key) {
        $this->db->select('to.' . $key);
        $this->db->where('to.ord_id', $order_id);
        $this->db->where('to.' . $key, $foil_thickness);
        $foil_thick = $this->db->get(TBL_ORDER . " to")->row_array();
        return (!empty($foil_thick)) ? true : false;
    }

    function compare_border_used($border_used, $order_id) {
//        $this->db->select('to.' . "_foil_thik");
//        $this->db->where('to.ord_id', $order_id);
//        $this->db->where('to.' . $key . "_foil_thik", $border_used);
//        $border = $this->db->get(TBL_ORDER . " to")->row_array();
//        return (!empty($foil_thick)) ? true : false;
    }

    function checklist_data($data) {
        unset($data['checklist_stats']);
        unset($data['sc_foil_thik']);
        unset($data['sc_fiducial_qty']);
        unset($data['sc_fiducial_dcode']);
        unset($data['ord_id']);
        $this->db->insert(TBL_CAD_CHECKLIST, $data);
        return $this->db->insert_id();
    }

    function get_checklist_stats($order_status_id) {
        $this->db->select('cad_checklist_id');
        $this->db->where('order_status_id', $order_status_id);
        $stats = $this->db->get(TBL_CAD_CHECKLIST)->row_array();

        return (!empty($stats)) ? $stats['cad_checklist_id'] : false;
    }


    function checklist_status($chklst) { //function to check the check list status completed or not based on the order code
        $this->db->select('*');
        if($chklst['rc_completed']==1){
            $this->db->where('rc_completed', 3);
        }
        if($chklst['spc_completed']==1){
            $this->db->where('spc_completed', 1);
        }
        if($chklst['fc_completed']==1){
            $this->db->where('fc_completed', 1);
        }
        if($chklst['tc_completed']==1){
            $this->db->where('tc_completed', 1);
        }
        if($chklst['sc_completed']==1){
            $this->db->where('sc_completed', 1);
        }
            $stats = $this->db->get(TBL_CAD_CHECKLIST)->row_array();
        return (!empty($stats)) ? $stats['cad_checklist_id'] : false;

    }

    function update_checklist($data) {
        unset($data['sc_foil_thik']);
        unset($data['sc_fiducial_qty']);
        unset($data['sc_fiducial_dcode']);
        unset($data['ord_id']);
        unset($data['job_id']);
        unset($data['checklist_stats']);
        $this->db->where('order_status_id', $data['order_status_id']);
        $this->db->update(TBL_CAD_CHECKLIST, $data);
    }

    function fiducial_qty($data) {
        $this->db->insert(TBL_FIDUCIAL_QUANTITY, $data);
    }

    function fiducial_dcode($data) {
        $this->db->insert(TBL_FIDUCIAL_DCODE, $data);
    }

    function get_stencil_side($ord_id) {   //Using  ord_id
        $this->db->select('stencil_side');
        $this->db->where('ord_id', $ord_id);
        return $this->db->get(TBL_ORDER)->row_array();
    }
	function get_stencil_side2($order_code) { //Using  order_code
	
        $this->db->select('stencil_side');
        $this->db->where('order_code', $order_code);
        return $this->db->get(TBL_ORDER)->row_array();
    }

    function foil_thickness($foil) {
        $data['cad_checklist_id'] = $foil['cad_checklist_id'];
        $data['thickness'] = $foil['thickness'];
        $this->db->insert(TBL_CAD_FOIL_THICKNESS, $data);
    }

    function print_data($data) {
        $this->db->select('tos.*,to.*,tj.*,tc.*,tu.usr_name,tcc.*');
        $this->db->where('tcc.cad_checklist_id', $data['id']);
        $this->db->join(TBL_ORDER_STATUS . " tos", ' tos.id = tcc.order_status_id');
        $this->db->join(TBL_ORDER . " to", 'to.ord_id = tos.ord_id');
        $this->db->join(TBL_JOBS . " tj", 'tj.job_id = tos.job_id');
        $this->db->join(TBL_CUSTOMER . " tc", 'tc.cust_id = to.cust_id');
        $this->db->join(TBL_USERS. " tu", 'tu.usr_id = tcc.user_id');
        $query = $this->db->get(TBL_CAD_CHECKLIST . " tcc");
        return $query->result_array();
    }

    function delete_fiducials($id) {
        $this->db->where('cad_checklist_id', $id);
        $this->db->delete(TBL_FIDUCIAL_DCODE);
        $this->db->where('cad_checklist_id', $id);
        $this->db->delete(TBL_FIDUCIAL_QUANTITY);
        $this->db->where('cad_checklist_id', $id);
        $this->db->delete(TBL_CAD_FOIL_THICKNESS);
    }

    function notes_to_laser($data) {
        $this->db->where('ord_id', $data['ord_id']);
        $this->db->where('job_id', $data['job_id']);
        $this->db->update(TBL_ORDER_STATUS, $data);
    }

    function error_log($data) {
        $data['update_by'] = $this->session->userdata('user_id');
        $data['update_time'] = date("Y-m-d H:i:s");
        $this->db->insert(TBL_ORDER_STATUS_UPDATE, $data);
    }

    function mail_templates($data) {
        $this->db->insert(TBL_MAIL_TEMPLATES, $data);
    }

    function edit_templates($data) {
        $this->db->where('mail_id', $data['mail_id']);
        $this->db->update(TBL_MAIL_TEMPLATES, $data);
    }

    function get_templates($id = "") {
        $this->db->select('*');
        if (!empty($id)) {
            $this->db->where('mail_id', $id);
        }
        $query = $this->db->get(TBL_MAIL_TEMPLATES);
        return $query->result();
    }

    function delete_templates($id) {
        $this->db->where('mail_id', $id);
        $this->db->delete(TBL_MAIL_TEMPLATES);
    }
    //KRISHNA MK CODE
    function get_ftp_format($ord_id){
        $this->db->select('eng_id');
        $this->db->where('ord_id', $ord_id);
        $query=$this->db->get(TBL_ORDER)->row_array();
        //print_r($query);exit;
        $this->db->select('file_ext');
        $this->db->where('eng_id',$query['eng_id']);
        $this->db->where('status',1);
        $this->db->where('mail',1);
        $query=$this->db->get('mst_ftp')->row_array();
        return $query['file_ext'];
        //print_r($query);exit;
    }
    function get_p3report_format($ord_id){
        $this->db->select('eng_id');
        $this->db->where('ord_id', $ord_id);
        $query=$this->db->get(TBL_ORDER)->row_array();
        //print_r($query['eng_id']);exit;
        $this->db->select('file_ext');
        $this->db->where('eng_id',$query['eng_id']);
        $this->db->where('status',1);
        $query=$this->db->get('mst_p3report')->row_array();
        return $query['file_ext'];
        //print_r($query);exit;
    }
    function get_compliance_format($ord_id){
        $this->db->select('eng_id');
        $this->db->where('ord_id', $ord_id);
        $query=$this->db->get(TBL_ORDER)->row_array();
        //print_r($query);exit;
        $this->db->select('file_ext');
        $this->db->where('eng_id',$query['eng_id']);
        $this->db->where('status',1);
        $this->db->where('mail',1);
        $query=$this->db->get('mst_compliance')->row_array();
        return $query['file_ext'];
        //print_r($query);exit;
    }
    function get_laser_format($ord_id){
        $query['file_ext']="pdf";
        return $query['file_ext'];
    }
    function get_lmd_format($ord_id){
        $query['file_ext']="lmd";
        return $query['file_ext'];
    }
    function get_rework_format($ord_id){
        $query['file_ext']="zip";
        return $query['file_ext'];
    }
    function get_plot_format($ord_id){
        $this->db->select('*');
        $this->db->where('ord_id', $ord_id);
        $query=$this->db->get(TBL_ORDER)->row_array();
        //echo "<pre>";print_r($query);exit;
        if(($query['stencil_side']==1)||($query['stencil_side']==3)){
            if(($query['top_multilevel']=="")&&($query['top_multilevel_2']=="")){
                $step_down="false";
            }else{
                $step_down="true";
            }

        }else{
            if(($query['bot_multilevel']=="")&&($query['bot_multilevel_2']=="")){
                  $step_down="false";
            }else{
                $step_down="true";
            }
        }

        if(($query['film_plots']==1)&&($step_down=="true") ){ 
            $formats['file_ext']="pdf";
            return $formats['file_ext'];
        }elseif(($query['film_plots']==1)&&($step_down=="false")){
            $formats['file_ext']="pdf";
            return $formats['file_ext'];
        }elseif (($query['film_plots']==0)&&($step_down=="true")) { 
            $formats['file_ext']="";
            return $formats['file_ext'];
        }
        
    }
    function get_ftp_mailaddress($ord_id){
        $this->db->select('eng_id');
        $this->db->where('ord_id', $ord_id);
        $query=$this->db->get(TBL_ORDER)->row_array();
        //print_r($query);exit;
        $this->db->select('*');
        $this->db->where('eng_id',$query['eng_id']);
        $this->db->where('status',1);
        $this->db->where('mail',1);
        $query=$this->db->get('mst_ftp')->row_array();
        return $query;
        //print_r($query);exit;
    }
    function get_p3report_mailaddress($ord_id){
        $this->db->select('eng_id');
        $this->db->where('ord_id', $ord_id);
        $query=$this->db->get(TBL_ORDER)->row_array();
        //print_r($query);exit;
        $this->db->select('*');
        $this->db->where('eng_id',$query['eng_id']);
        $this->db->where('status',1);
        $this->db->where('mail',1);
        $query=$this->db->get('mst_p3report')->row_array();
        return $query;
        //print_r($query);exit;
    }
    function get_compliance_mailaddress($ord_id){
        $this->db->select('eng_id');
        $this->db->where('ord_id', $ord_id);
        $query=$this->db->get(TBL_ORDER)->row_array();
        //print_r($query);exit;
        $this->db->select('*');
        $this->db->where('eng_id',$query['eng_id']);
        $this->db->where('status',1);
        $this->db->where('mail',1);
        $query=$this->db->get('mst_compliance')->row_array();
        return $query;
        //print_r($query);exit;
    }
    function get_oder_status($order_id) {
        $this->db->select('*');
        $this->db->where('ord_id', $order_id);
        $query=$this->db->get(TBL_ORDER)->row_array();
        return $query;
    }
    function get_customer_details($cus_id) {

        $this->db->select('*');
        $this->db->where('cust_id', $cus_id);
        $query=$this->db->get(TBL_CUSTOMER)->row_array();
        return $query;
    }
    function insert_missing_file($data) {
        $this->db->insert('tbl_missing_file', $data); 
    }
    function insert_rework_file($data) {
        $this->db->insert('tbl_rework_file', $data); 
    }
    function check_tss_bss($ord_id){
        $this->db->select('eng_id');
        $this->db->where('ord_id', $ord_id);
        $query=$this->db->get(TBL_ORDER)->row_array();
        $this->db->select('top_bot_file');
        $this->db->where('eng_id',$query['eng_id']);
        $this->db->where('status',1);
        $query1=$this->db->get('mst_p3report')->row_array();
        return $query1['top_bot_file'];
    }
    function get_uploaded_files($ord_id,$job_id){
        $this->db->where('ord_id', $ord_id);
        $result=$this->db->get(TBL_ORDER)->row_array();
        //return $result['frm_size'];
        if($result['frm_size'] > 0){
            $this->db->select('*');
            $this->db->where('ord_id',$ord_id);
            $this->db->where('job_id',$job_id);
            $this->db->order_by('mis_id', 'DESC');
            $query=$this->db->get('tbl_missing_file')->result_array();
            //return 0;
        }else{
            $this->db->select('*');
            $this->db->where('ord_id',$ord_id);
            $this->db->where('job_id',$job_id);
            $this->db->order_by('rejob_id', 'DESC');
            $query=$this->db->get('tbl_rework_file')->result_array();
            //return 1;
        }
        return $query;
    }
    function get_engineer_name($ord_id){
        $this->db->select('eng_id');
        $this->db->where('ord_id', $ord_id);
        $query=$this->db->get(TBL_ORDER)->row_array();
        $this->db->select('eng_fname,eng_lname');
        $this->db->where('eng_id',$query['eng_id']);
        $query1=$this->db->get('tbl_engineer')->row_array();
        return $query1['eng_fname']." ".$query1['eng_lname'];
    }
    function insert_oldjob_file($data) {
        $this->db->insert('tbl_oldjob_file', $data); 
    }
    function get_oldjob_uploaded_files($ord_id,$job_id){
        $this->db->select('*');
        $this->db->where('ord_id',$ord_id);
        $this->db->where('job_id',$job_id);
        $this->db->order_by('oldjob_id', 'DESC');
        $query=$this->db->get('tbl_oldjob_file')->result_array();
        return $query;
    }
    function get_cad_search($search_string) {
        $this->db->select('*');
        $this->db->from(TBL_JOBS . " toj");
        $this->db->join(TBL_ORDER . " to", 'to.ord_id = toj.ord_id');
        $this->db->join(TBL_CUSTOMER . " tc", 'tc.cust_id = toj.cust_id');
        $this->db->join(TBL_ORDER_STATUS . " tos",'tos.ord_id = toj.ord_id','left');
        $this->db->join(TBL_ENGINEER . " te", 'te.eng_id = to.ad_by');
        $this->db->where_in('toj.job_status', 1);
        $this->db->like('toj.job_code', $search_string);
        $this->db->order_by("toj.job_priority","desc");
        $this->db->order_by("toj.due_date","asc");
        $this->db->order_by("toj.due_time","asc");
        $this->db->where('toj.job_complet_status',0);
        $query = $this->db->get();
        return $query->result_array();
    }
    function get_custom_foil_status($id) {
        $this->db->where('ord_id', $id);
        $result=$this->db->get(TBL_ORDER)->row_array();
        //return $result['frm_size'];
        if($result['frm_size'] > 0){
            //if frame is not custom frame then normal upload
            return 0;
            //return 1 to enable upload files
        }else{
            if($result['other_frame_size']==1){
                //return 1 to enable upload files
                return 0;
            }else{
                //return 1 to enable rework upload
                return 1;
            }
        }
    }
    function get_send_laser_status($ord_id,$job_id){
        $this->db->where('ord_id', $ord_id);
        $result=$this->db->get(TBL_ORDER)->row_array();
        //return $result['frm_size'];
        $this->db->where('ord_id', $ord_id);
        $this->db->where('job_id', $job_id);
        $result1=$this->db->get(TBL_ORDER_STATUS)->row_array();

        if($result['frm_size'] > 0){
            if($result1['upload_files']==1 && $result1['oldjob_files']==1){
                return 1;
            }else{
                return 0;
            }
        }else{
            if($result['other_frame_size']==1){

                if($result1['upload_files']==1 && $result1['oldjob_files']==1){
                    return 1;
                }else{
                    return 0;
                }
            }else{
                if($result1['rework_files']==1 && $result1['oldjob_files']==1){
                    return 1;
                }else{
                    return 0;
                }
            }
        }
    }

    function get_order_detail($id) {
        $this->db->where('ord_id', $id);
        return $this->db->get(TBL_ORDER)->row_array();
    }

    function cad_update($data,$ord_id,$job_id) {
        //echo "<pre>";print_r($ord_id);print_r($data);exit;
        $this->db->where('ord_id', $ord_id);
        $this->db->where('job_id', $job_id);
        $this->db->update('tbl_jobs', $data);
    }
    function ac_update($data,$ord_id) {
        //echo "<pre>";print_r($ord_id);print_r($data);exit;
        $this->db->where('ord_id', $ord_id);
        $this->db->update(TBL_ORDER, $data);
    }
    function update_job_status($data,$job_id) {
        $data['job_id']=$job_id;
        $this->db->insert('tbl_jobs_updates', $data);
    }

    function cust_mail_update($data,$ord_id,$job_id) {
        $this->db->where('ord_id', $ord_id);
        $this->db->where('job_id', $job_id);
        $this->db->update(TBL_ORDER_STATUS, $data);
    }

    function check_bottom_order($ord_id) {
        $this->db->select('order_code');
        $this->db->where('ord_id', $ord_id);
        $query=$this->db->get(TBL_ORDER)->row_array();

        $this->db->select('order_code,old_data_ref');
        $this->db->where('order_code >', $query['order_code']);
        $this->db->order_by('order_code','asc');
        $this->db->limit(1);
        $query1=$this->db->get(TBL_ORDER)->row_array();
        if($query1['old_data_ref']==$query['order_code']){
            $this->db->select('job_code');
            $this->db->where('job_code', $query1['order_code']);
            $this->db->where('job_status !=', '-1');
            $query2=$this->db->get(TBL_JOBS);
            if($query2->num_rows()>0){
                $result2 = $query2->row_array();
                return $result2['job_code'];
            }else{
                return false;
            }
        }else{
            return false;
        }
    }
    
    function check_top_order($ord_id) {
        $this->db->select('old_data_ref');
        $this->db->where('ord_id', $ord_id);
        $query=$this->db->get(TBL_ORDER)->row_array();
	
        $this->db->select('order_code');
        $this->db->where('order_code', $query['old_data_ref']);
        $this->db->limit(1);
        $query1=$this->db->get(TBL_ORDER)->row_array();
        if($query1['order_code']==$query['old_data_ref']){
            $this->db->select('job_code');
            $this->db->where('job_code', $query1['order_code']);
            $this->db->where('job_status !=', '-1');
            $query2=$this->db->get(TBL_JOBS);
            if($query2->num_rows()>0){
                $result2 = $query2->row_array();
                return $result2['job_code'];
            }else{
                return false;
            }
        }else{
            return false;
        }
    }
         
    function check_mail_bottom_order($ord_id,$job_id){
        $this->db->select('bottom_order');
        $this->db->where('ord_id',$ord_id);
        $this->db->where('job_id',$job_id);
        $this->db->where('status', 1);
        $this->db->order_by('mail_id', 'desc');
        $this->db->limit(1);
        $query=$this->db->get(TBL_CUSTOMER_MAIL);
        if($query->num_rows()>0){
                $result = $query->row_array();
                return $result['bottom_order'];
            }else{
                return false;
            }
    }
    function insert_mail_reminder($data){
        $this->db->insert(TBL_CUSTOMER_MAIL,$data);
        $insid=$this->db->insert_id();
        $status['status']=0;
        $status['reminder']=0;
        $this->db->where('ord_id',$data['ord_id']);
        $this->db->where('job_id',$data['job_id']);
        $this->db->where('mail_id !=',$insid);
        $this->db->update(TBL_CUSTOMER_MAIL,$status);
        return $insid;
    }
    function check_reminder($ord_id,$job_id){
        $this->db->where('ord_id',$ord_id);
        $this->db->where('job_id',$job_id);
        $this->db->where('reminder',1);
        $query=$this->db->get(TBL_CUSTOMER_MAIL)->result_array();
        return count($query);
    }
    function change_reminder_status($ord_id,$job_id){
        $data['reminder']=0;
        $this->db->where('ord_id', $ord_id);
        $this->db->where('job_id', $job_id);
        $result=$this->db->update(TBL_CUSTOMER_MAIL, $data);
        $job['job_status']=1;
        $this->db->where('ord_id', $ord_id);
        $this->db->where('job_id', $job_id);
        $result1=$this->db->update(TBL_JOBS, $job);

        if($result > 0){
            return 1;
        }else{
            return 0;
        }
    }

    function get_job_status($id) {
        $this->db->where('ord_id', $id);
        return $this->db->get(TBL_JOBS)->row_array();
    }

    function get_job_status_job_id($id) {
        $this->db->where('job_id', $id);
        return $this->db->get(TBL_JOBS)->row_array();
    }

    function get_job_status_job_code($job_code) {
        $this->db->where('job_code', $job_code);
        return $this->db->get(TBL_JOBS)->row_array();
    }

    function customer_mail_default(){
        $default="png|pdf";
        return $default;
    }
    function get_checklist_data($status_id){
    	$this->db->where('order_status_id', $status_id);
        $query =$this->db->get(TBL_CAD_CHECKLIST);
        return $query->row_array();
    }
    function get_checklist_foil($checklist_id){
        $this->db->select('thickness');
    	$this->db->where('cad_checklist_id', $checklist_id);
    	$this->db->order_by('thickness_id', 'asc');
        $query =$this->db->get(TBL_CAD_FOIL_THICKNESS);
        return $query->result();
    }
    function get_checklist_decode($checklist_id){
    	$this->db->select('fiducial_dcode');
    	$this->db->where('cad_checklist_id', $checklist_id);
    	$this->db->order_by('fiducial_dcode_id', 'asc');
        $query =$this->db->get(TBL_FIDUCIAL_DCODE);
        return $query->result();
    }
    function get_checklist_quantity($checklist_id){
        $this->db->select('fiducial_quantity');
    	$this->db->where('cad_checklist_id', $checklist_id);
    	$this->db->order_by('fiducial_quantity_id', 'asc');
        $query =$this->db->get(TBL_FIDUCIAL_QUANTITY);
        return $query->result();
    }
    
    function proceed_without_oldjob($data) {
        $ord_id = $data['ord_id'];
        $job_id = $data['job_id'];
        unset($data['ord_id']);
        unset($data['job_id']);
        $this->db->where('ord_id',$ord_id);
        $this->db->where('job_id',$job_id);
        $this->db->update(TBL_ORDER_STATUS, $data);
        if($this->db->affected_rows() >= 0){
          return true; 
        }else{
          return false; 
        }
    }
    
    /*function get_stencil_uploads($order_status_id,$check_type){
    	$this->db->where('order_status_id',$order_status_id);
        $query=$this->db->get(TBL_CAD_CHECKLIST_UPLOAD);
        if($query->num_rows() > 0){
            $results = $query->result_array();
            foreach( $results as $key =>$result ){ 
               if($result['user_type']!= 1){
        	     $results[$key]['update_by'] = GetSingleReconrd("tbl_engineer", "CONCAT(eng_fname,' ',eng_lname)", "eng_id", $result['update_by']);
        	}else{
        	     $results[$key]['update_by'] = GetSingleReconrd("tbl_user", "usr_name", "usr_id", $result['update_by']);
        	}
        	
            }
            return $results;
        }else{
            return false;
        }
    }*/
    function get_checklist_uploads($order_status_id,$check_type){
    	$this->db->select('ts.usr_name,tccu.*');
        $this->db->from(TBL_CAD_CHECKLIST_UPLOAD. " tccu");
        $this->db->join(TBL_USERS . " ts", 'tccu.update_by = ts.usr_id','left');
        $this->db->where('tccu.order_status_id',$order_status_id);
        $this->db->where('tccu.checklist_type',$check_type);
        $query = $this->db->get();
        if($query->num_rows() > 0){
            $results = $query->result_array();
            foreach( $results as $key =>$result ){ 
               
        	     $results[$key]['update_by'] = $result['usr_name'];
            }
            return $results;
        }else{
            return false;
        }
        
    }
    function checklist_insert_upload($data){
    	$this->db->insert(TBL_CAD_CHECKLIST_UPLOAD, $data);
        return $this->db->insert_id();
    }
    
    function get_border_details($ord_id,$job_id,$ord_sts_id){
        $this->db->select('cad_checklist_id,sc_frame_used,sc_frame_used_custom,sc_border_used,sc_border_used_custom,sc_aperture_count,sc_material,rc_ms_type');
        $this->db->where('order_status_id',$ord_sts_id);
        return $this->db->get(TBL_CAD_CHECKLIST)->row_array();
    }

    function update_order_apeature($order_id,$apeature_count){
        $order_details = $this->db->where('ord_id',$order_id)->get(TBL_ORDER)->row_array();

        $eng_details = $this->db->where('eng_id',$order_details['eng_id'])->get(MST_EMAILREMINDER)->row_array();

        if($eng_details['apeature_count']==1){
            $order_details = $this->get_order_detail($order_id);
			
            if($order_details['top_side']==1){
            	$update['dt_top_new2'] = "Apt Count:".$apeature_count;  
            }
            if($order_details['bottom_side']==2){
                $update['dt_bot_new2'] = "Apt Count:".$apeature_count;
            } 
			if(isset($update)){
            $this->db->where('ord_id',$order_id);
            $this->db->update(TBL_ORDER, $update);  
			}			
        } 
        if($apeature_count > 10000){
            $this->db->select('ac');
            $this->db->where('ord_id',$order_id);
            $result = $this->db->get(TBL_ORDER)->row_array();
            $result_array = explode(',',$result['ac']);
            if (is_array($result_array)){
                foreach ($result_array as $key => $value) {
                    if( strpos( $value,'HC-' ) !== false ) {
                        unset($result_array[$key]);
                    }
                }
                $update['ac'] = implode(',', $result_array);
            }else{
                $update['ac'] = $result['ac'];
            }
            
            $update['ac'] = $update['ac'].',HC-'.$apeature_count; 
            $this->db->where('ord_id',$order_id);
            $this->db->update(TBL_ORDER, $update);
        }
    }
    function update_premium($ord_id,$status){
        
    	$order_details = $this->get_order_detail($ord_id);
    	if($status == 1){
	    	if($order_details['ac'] == ""){
	    	    $order_details['ac'] = 'Premium';
	    	}else{
	    		$exist=0;
	    		$acs= explode(',',$order_details['ac']);
    			foreach ($acs as $key => $ac){
    				if($ac=='Premium'){
    					$exist=1;
    				}
    			}
    			if($exist==0){
    				$order_details['ac'] = $order_details['ac'].',Premium';
    			}else{
    				$order_details['ac'] = $order_details['ac'];
    			}
		    	
	    	}
    		$data['ac'] = $order_details['ac'];
    	}else{
    		if($order_details['ac'] != ""){
    			$acs= explode(',',$order_details['ac']);
    			foreach ($acs as $key => $ac){
    				if($ac=='Premium'){
    					unset($acs[$key]);
    				}
    			}
    			$data['ac'] = implode(',',$acs);
    			
    		}else{
    			$data['ac'] = '';
    		}
    	}
    	
    	$this->ac_update($data,$ord_id);
    }
    function get_stepdown($ord_id){
        $this->db->select('*');
        $this->db->where('ord_id', $ord_id);
        $query=$this->db->get(TBL_ORDER)->row_array();
        
        if(($query['stencil_side']==1)||($query['stencil_side']==3)){
            if(($query['top_multilevel']=="")&&($query['top_multilevel_2']=="")){
                $step_down="false";
            }else{
                $step_down="true";
            }

        }else{
            if(($query['bot_multilevel']=="")&&($query['bot_multilevel_2']=="")){
                  $step_down="false";
            }else{
                $step_down="true";
            }
        }

       return $step_down;
        
    }
    
    function update_checklist_apeature($order_status_id,$sc_aperture_count){
        $data['sc_aperture_count'] =$sc_aperture_count;
        $this->db->where('order_status_id', $order_status_id);
        $this->db->update(TBL_CAD_CHECKLIST, $data);
    }
    
    //test
    
    function get_checklist_premount($checklist_id){
        $this->db->select('sc_premount_status');
    	$this->db->where('cad_checklist_id', $checklist_id);
        $query =$this->db->get(TBL_CAD_CHECKLIST);
        $result = $query->row_array();
        
        if($result['sc_premount_status'] == 1 ){
            return TRUE;
        }else{
            return FALSE;
        }
    } 
    
    function update_backetch($ord_id,$status){
        
    	$order_details = $this->get_order_detail($ord_id);
    	if($status == 1){
	    	if($order_details['ac'] == ""){
	    	    $order_details['ac'] = 'BE';
	    	}else{
	    		$exist=0;
	    		$acs= explode(',',$order_details['ac']);
    			foreach ($acs as $key => $ac){
    				if($ac=='BE'){
    					$exist=1;
    				}
    			}
    			if($exist==0){
    				$order_details['ac'] = $order_details['ac'].',BE';
    			}else{
    				$order_details['ac'] = $order_details['ac'];
    			}
		    	
	    	}
    		$data['ac'] = $order_details['ac'];
    	}else{
    		if($order_details['ac'] != ""){
    			$acs= explode(',',$order_details['ac']);
    			foreach ($acs as $key => $ac){
    				if($ac=='BE'){
    					unset($acs[$key]);
    				}
    			}
    			$data['ac'] = implode(',',$acs);
    			
    		}else{
    			$data['ac'] = '';
    		}
    	}
    	
    	$this->ac_update($data,$ord_id);
    }
    
    public function syn_premium_wims($order_id,$order_sts_id) {
    	$this->db->select('ac');
        $this->db->where('ord_id', $order_id); 
        $query = $this->db->get(TBL_ORDER);
        if( $query->num_rows() > 0 ){
        	$result = $query->row_array();
        	$ac_array = explode(',',$result['ac']);
        	if (in_array("Premium", $ac_array)){
        		$update['sc_premium'] = 1;
        	}elseif (in_array("premium", $ac_array)){
        		$update['sc_premium'] = 1;
        	}else{
        		$update['sc_premium'] = 0;
        	}
        	$this->db->where('order_status_id', $order_sts_id); 
	        $checklist_query = $this->db->get(TBL_CAD_CHECKLIST);
	        if( $checklist_query->num_rows() > 0 ){
	        	$this->db->where('order_status_id', $order_sts_id);
	        	$this->db->update(TBL_CAD_CHECKLIST, $update);
	        }
	        return $update;
        }
    }
	//MUTHU
	public function get_job_id($ref_no){
		$this->db->select('job_id');
	    $query = $this->db->get_where(TBL_JOBS, array('job_code' =>$ref_no));
        return $query->row_array();
	}
	public function get_order_status_id($order_status_id){
		//print_r($order_status_id); exit;
		$this->db->select('id');
	    $query = $this->db->get_where(TBL_ORDER_STATUS, array('job_id' =>$order_status_id));
        return $query->row_array();
	}
   public function get_checklist_upload($order_status_id){
		//echo $order_status_id; exit;
		$this->db->select('files');
	    $query = $this->db->get_where(TBL_CAD_CHECKLIST_UPLOAD, array('order_status_id' =>$order_status_id));
        return $query->result_array();
	}	
  	
  public function quote_button_status($ord_id){
	    $this->db->select('*');
        $this->db->where('ord_id', $ord_id);
        $query=$this->db->get('tbl_order')->result_array();
		return $query;
  }
	
}
