<?php
class Tooling extends CI_Controller {
	public function __construct() {
        parent::__construct();
        if (!$this->session->userdata('logged_in')) {
            redirect('welcome');
        }
        $this->load->model('tooling_model');
        $this->load->model('customer_model');
        $this->load->model('user_model');
        $this->load->library('email');
        $this->load->library('upload');
        $this->load->model('order_model');
        $this->load->library('ckeditor');
        $this->load->library('ckfinder');
        $this->ckeditor->basePath = base_url() . 'assets/ckeditor/';
        $this->ckeditor->config['toolbar'] = array(
            array('Source', '-', 'Bold', 'Italic', 'Underline', '-', 'Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo', '-', 'NumberedList', 'BulletedList')
            );
        $this->ckeditor->config['language'] = 'english';
        $this->ckeditor->config['width'] = '100%';
        $this->ckeditor->config['height'] = '300px';
        //Add Ckfinder to Ckeditor
        $this->ckfinder->SetupCKEditor($this->ckeditor, '../../asset/ckfinder/');
    }
/**
*
* Default Tooling Display
*
**/
    public function index() {
        $date = date('Y-m-d');
        $data['high'] = $this->tooling_model->get_tooling_status('2', '1', $date);
        $data['normal'] = $this->tooling_model->get_tooling_status('1', '1', $date);
        $data['low'] = $this->tooling_model->get_tooling_status('0', '1', $date);
        //echo "<pre>";print_r($data);exit;
        $this->template->build("tooling/cad_orders", $data);
    }
/**
*
* Tooling order Search
*
**/
    public function search() {
        $data['search_string']=$this->input->post('search_string');
        $date = date('Y-m-d');
        $data['high'] = $this->tooling_model->get_tooling_status('2', '1',$date, $data['search_string']);
        $data['normal'] = $this->tooling_model->get_tooling_status('1', '1',$date, $data['search_string']);
        $data['low'] = $this->tooling_model->get_tooling_status('0', '1',$date, $data['search_string']);
        $this->template->build("tooling/cad_orders", $data);
    }
/**
*
* Tooling popup
*
**/
    public function cad_new_job() {
        header('Access-Control-Allow-Origin: *'); 
        $data["order_id"] = $_GET['ord_id'];
        $data["engg_id"] = $_GET['engg_id'];
        $data["job_id"] = $_GET['job_id'];
        $data['ord_ref_id'] = $_GET['ord_ref_id'];
        $data["order_status"] = $this->tooling_model->get_job_status($data["job_id"]);
        $data["custom_foil"] = $this->tooling_model->get_custom_foil_status($data["order_id"]);
        $data["send_laser"] = $this->tooling_model->get_send_tooling_status($data["order_id"],$data["job_id"]);
        //echo "<pre>";print_r($data["order_status"]);exit;
        $data["job_status"] = $this->tooling_model->get_job_status($data["job_id"]);
        $data['user'] = $this->user_model->get_tooling_update_join($data["order_status"]["tjob_id"]);
        $data['reminder'] = $this->tooling_model->check_reminder($data["order_id"],$data["job_id"]);
        //echo "<pre>";print_r($data);exit;
        $this->load->view('tooling/cad_popup', $data);
    }
/**
*
* Tooling upload
*
**/
	public function upload() {
	    $data['ord_id'] = $_POST['ord_id'];
	    $data['ord_ref_id'] = $_POST['job_code'];
	    $data['ord_sts_id'] = $_POST['ord_sts_id'];
	    $data['p3_format'] = $this->tooling_model->get_p3report_format($data["ord_id"]);
	    $data['ftp_format'] = $this->tooling_model->get_ftp_format($data["ord_id"]);
	    $data['compliance_format'] = $this->tooling_model->get_compliance_format($data["ord_id"]);
	    $stencil_side=$this->tooling_model->get_stencil_side($data['ord_id']);
	    $formats=$data['p3_format'];
	    if($stencil_side['stencil_side']==1){
	        $data['p3_format']=$formats."|tss";
	    }elseif ($stencil_side['stencil_side']==2) {
	        $data['p3_format']=$formats."|bss";
	    }elseif ($stencil_side['stencil_side']==3) {
	        $data['p3_format']=$formats."|tss|bss";
	    }
	    $data['laser_format'] =$this->tooling_model->get_laser_format($data["ord_id"]);
	    $data['lmd_format'] =$this->tooling_model->get_lmd_format($data["ord_id"]);
	    $data['plot_format'] =$this->tooling_model->get_plot_format($data["ord_id"]);
	        //echo "<pre>";print_r($data);exit;
	    $this->load->view('tooling/upload', $data);
	}
/**
*
* Change Cad status
*
**/
	public function change_cad_status() {
        $data=$_POST;
         $data["job_status"] = $this->tooling_model->get_job_status($data["job_id"]);
        //echo "<pre>";print_r($data);exit;
        if ($data["job_status"]['tjob_cad_status'] == 0) {
            $this->tooling_model->change_cad_working($data["job_code"]);
            $order['update_remarks'] = "Cad Work started by" . $this->session->userdata('user_name');
            $order['update_status'] = 1;
            $order['job_code'] = $data['job_code']; 
            $cad_update_status['update_by']=$_SESSION['user_id'];
            $cad_update_status['update_to']="CAD - Working";
            $cad_update_status['update_for']=1;
            $cad_update_status['update_status']=1;
            $cad_update_status['update_time']=date("Y-m-d h:i:s");
            $data['job_update_status'] = $this->tooling_model->update_job_status($cad_update_status,$data['job_id']);

            $encode = array("status" => true, "message" => "Cad Status Changed to Working.");
        } elseif ($data["job_status"]['tjob_cad_status'] == 1 && $data["job_status"]['tjob_status'] == 1) {
            $encode = array("status" => false, "message" => "Cad status is already in working");
        } elseif ($data["job_status"]['tjob_cad_status'] == 2) {
            $encode = array("status" => false, "message" => "The Cad is already Completed");
        } elseif ($data["job_status"]['tjob_status'] == 0) {
            $encode = array("status" => false, "message" => "Sorry ! The Cad design is in hold sent for clarification to the Client.");
        }
        echo json_encode($encode);
    }
    public function cad_mail_to_customer() {
       
        header('Access-Control-Allow-Origin: *');
        if ($this->input->post()) { 
            $data=$_POST; 
            //echo "<pre>";print_r($data);exit;
            $bottom_order=$data['bottom_order'];
            if($bottom_order !=""){
                $bottom_order_attach="-".substr($bottom_order, -2);
            }else{
                $bottom_order_attach="";
            }
            $no_attach=isset($_POST["no_attach"]) ? 1 : 0 ;
            $mail_cc=$_POST["cc_email"];
            //$mail_cc=$_POST["cc_email"].",".TOOLING_DEFAULT_MAIL;
            $this->load->helper('directory');
            $this->load->library('zip');
            if($no_attach==0){
               $path = EMAIL_ATTACHMENT_PATH.$this->input->post('order_reference_id');
               $email_attachment=$this->input->post('upload_files');
               $uploaded_files=array_filter(explode(',',$email_attachment));
               foreach ($uploaded_files as $key => $file) {
                   $this->zip->read_file($path.'/'.str_replace(" ","_",$file));
               }
               $this->zip->archive($path.$bottom_order_attach.'.zip');
           }
                $config['protocol'] = 'smtp';
                $config['smtp_host'] = 'smtp.office365.com';
                $config['smtp_port'] = '25';
                $config['smtp_port'] = '587';
                $config['smtp_timeout'] = '7';
                $config['smtp_crypto'] = 'tls';
                $config['smtp_user'] = 'bot@beamon.com';
                $config['smtp_pass'] = 'Lsr&2*3%1$8CSuse';
                $config['charset'] = "utf-8";
                $config['wordwrap'] = TRUE;
                $config['newline'] = "\r\n";
                $config['validation'] = TRUE;
                $config['mailtype'] = 'html';
                $this->email->initialize($config);
                $this->email->set_mailtype("html");
                $this->email->set_crlf( "\r\n" );
                $this->email->from('bot@beamon.com', 'BOT Customer Service');
                $this->email->to($_POST["email"]);
                $cc_email = str_replace(';', ',', $mail_cc);
                $this->email->cc($cc_email);
                if($_POST["bcc_email"]!=""){
                    $this->email->bcc($_POST["bcc_email"]);
                }
                if($no_attach==0){
                     $file=EMAIL_ATTACHMENT_PATH.$this->input->post('order_reference_id').'.zip';
                     if (!empty($file)){
                         $this->email->attach($file);
                     }
                }
                $message = $_POST["mail_message"];
               // $message.=$this->load->view("tooling/email_signature", array(), true);
                $emailreminder=isset($_POST["reminder_mail"]) ? 1 : 0 ;
                 /* storing email reminder */
                    $reminder['ord_id']=$_POST['ord_id'];
                    $reminder['job_id']=$_POST['job_id'];
                    $reminder['job_code']=$_POST['order_reference_id'];
                    $reminder['eng_id']=$_POST['eng_id'];
                    $reminder['email']=$_POST['email'];
                    $reminder['email_cc']=$mail_cc;
                    $reminder['email_bcc']=$_POST["bcc_email"];
                    $reminder['subject']=$_POST["subject"];
                    $reminder['message']=$_POST["mail_message"];
                    $reminder['reminder']=isset($_POST["reminder_mail"]) ? 1 : 0 ;
                    $reminder['time_interval']=$_POST["reminder_interval"];
                    $reminder['no_times']=$_POST["reminder_times"];
                    $reminder['attach_file']=$_POST["upload_files"];
                    if($no_attach==0){
                        $reminder['attachment']=1;
                        $reminder['attachment_name']=$this->input->post('order_reference_id').$bottom_order_attach.'.zip';
                    }else{
                        $reminder['attachment']=0;
                        $reminder['attachment_name']="";
                    }
                    $reminder['status']=1;
                    $data['reminder_id']=$this->tooling_model->insert_mail_reminder($reminder);
                    //print_r($data['reminder_id']);exit;
                if($emailreminder==1){
                    $message.=$this->load->view("tooling/email_unsubscribe", $data, true);
                }
                //print_r($message);exit;
                $this->email->subject($_POST["subject"]);
                $this->email->message($message);
                if ($this->email->send()) {
                    // $data['is_hold'] = WORK_IN_HOLD;
                    // $data['ord_id'] = $_POST['ord_id'];
                    // change_working_status('is_hold', WORK_IN_HOLD, $data['ord_id']);
                    if($no_attach==0){
                        //unlink($file);
                        recursiveRemoveDirectory($path);        
                    }
                    /* update customer mail update into order_status */
                    $cust_mail['cust_mail']=1;
                    $cust_mail['cust_mail_time']=date("Y-m-d H:i:s");
                    $cust_mail_status=$this->tooling_model->cust_mail_update($cust_mail,$_POST['ord_id'],$_POST['job_id']);
                    /* Moving job to HOLD status */
                    if($data['hold_status']=="hold"){
                         $cad_update['tjob_status']=0;
                    }else{
                         $cad_update['tjob_status']=1;
                    }
                    $cust_job_status=$this->tooling_model->cad_update($cad_update,$_POST['ord_id'],$_POST['job_id']);
                    /* Moving Bottom job to HOLD status if Available */
                    // $bottom_order=$this->tooling_model->check_bottom_order($_POST['ord_id']);
                    // if ($bottom_order!="") {
                    //     $cust_job_status=$this->tooling_model->cad_update($cad_update,get_order_id($bottom_order));
                    //     $job_updates['update_date']=date("Y-m-d");
                    //     $job_updates['update_time']=date("Y-m-d H:i:s");
                    //     $job_updates['update_to']="HOLD";
                    //     $job_updates['update_for']=1;
                    //     $job_updates['update_status']=1;
                    //     $job_updates['show_customer']=1;
                    //     $job_updates['update_remarks']="Hold by Customer Mail in Wims 2";
                    //     $job_updates['update_by']=$this->session->userdata('user_id');
                    //     $cust_job_update_status=$this->tooling_model->update_job_status($job_updates,get_order_id($bottom_order));
                    // }
                    /* Update job status in tbl_jobs_update for wims */
                    $job_updates['update_date']=date("Y-m-d");
                    $job_updates['update_time']=date("Y-m-d H:i:s");
                    $job_updates['update_to']="HOLD";
                    $job_updates['update_for']=1;
                    $job_updates['update_status']=1;
                    $job_updates['regard']=$_POST['reg'];
                    //$job_updates['show_customer']=1;
                   // $job_updates['update_remarks']="Hold by Customer Mail in Wims 2";
                    $job_updates['update_by']=$this->session->userdata('user_id');
                    $cust_job_update_status=$this->tooling_model->update_job_status($job_updates,$_POST['job_id']);
                    //working_status_updates(QUERY_SENT_TO_CUSTOMER, $_POST['subject'],$_POST['ord_id']);
                    echo json_encode(array("status" => true, "message" => "Email sent successfully"));
                } else {
                    $cust_mail['cust_mail']=0;
                    $cust_mail['cust_mail_time']=date("Y-m-d H:i:s");
                    $cust_mail_status=$this->tooling_model->cust_mail_update($cust_mail,$_POST['ord_id'],$_POST['job_id']); 
                    echo json_encode(array("status" => false, "message" => "Email not sent successfully"));
                }
        } else {
            //echo "<pre>";print_r($this->session->userdata('user_id'));exit;
            $data['ord_id'] = $_GET['ord_id'];
            $data['job_id'] = $_GET['job_id'];
            $data['order_reference_id'] = $_GET['order_reference_id'];
            $customer_id = $_GET['engg_id']; //$this->uri->segment(3);
            $data["customer"] = $this->customer_model->get_engineer_details($customer_id);
            $data['email_reminder']=$this->customer_model->get_tooling_reminder_details($customer_id);
            //$data['bottom_order']=$this->tooling_model->check_bottom_order($data['ord_id']);
            if($data['ord_id']!=0){
                $data['bottom_order']=$this->tooling_model->check_bottom_order($data['ord_id']);
            }else{
            	$data['bottom_order']="";
            }
            
           // $data['default_uploads']['file_ext']=$this->tooling_model->customer_mail_default();
           // $data['email_reminder']['file_ext']=$data['email_reminder']['file_ext']; 
           $data['fixture_smt'] = $this->tooling_model->check_for_tooling_file($data['order_reference_id'],$data['ord_id']);
           //echo "<pre>";print_r($data);exit;
           $this->load->view('tooling/mail_to_customer', $data);
        }
    }
    public function get_mail_subject() {
         $data['eng_id'] = $_POST['eng_id'];
        $data['mail_id'] = $_POST['mail_id'];
        $data['ord_id'] = $_POST['ord_id'];
        $data['job_id'] = $_POST['job_id'];
        $data['job_code'] = $_POST['job_code'];
        $data['bottom_order'] = $_POST['bottom_order'];
        $data['customer'] = $this->customer_model->get_engineer_details($data['eng_id']);
        $data['message'] = get_tooling_mail_subject($data['mail_id']);
        $data['order_details'] = $this->order_model->get_order_details($data['ord_id']);
        $data['customer_name'] = $this->customer_model->get_customer_name($data['order_details']['cust_ref']);
        if ($data['order_details']['stencil_side']==1 || $data['order_details']['stencil_side']==3) {
            $data['cust_name'] = $data['order_details']['dt_top_name'];
        }else{
            $data['cust_name'] = $data['order_details']['dt_bot_name'];
        }
        //$data['bottom_order']=$this->cad_model1->check_bottom_order($data['ord_id']);
        if($data['bottom_order']!=""){
            $data['bottom_ord']="-".substr($data['bottom_order'], -2);
        }else{
            $data['bottom_ord']="";
        }
        //echo "<pre>";print_r($data);exit;
        $names = array(
            "{{first_name}}" => $data['customer']['eng_fname'],
            "{{last_name}}" => $data['customer']['eng_lname'],
            "{{bottom}}"=>$data['bottom_ord'],
            "{{customer_name}}" => $data['cust_name'],
            "{{company_name}}" => $data['customer_name']['cust_name'],
            "{{assembly_no}}" => $data['order_details']['dt_top_assembly'] . $data['order_details']['dt_bot_assembly'],
            "{{fab_number}}" => $data['order_details']['dt_top_fab'] . $data['order_details']['dt_bot_fab'],
            "{{ref#}}" => "Ref#" . $data['job_code']
            );
        $mail_sub = strtr($data['message'][0]['mail_subject'], $names);
        $mail_body = strtr($data['message'][0]['mail_body'], $names);
        $mail_body .= $this->load->view("tooling/email_signature", array(), true);
        echo json_encode(array(
            "subject" => $mail_sub,
            "message" => $mail_body
            ));
    }
    public function email_attachment_upload(){
        $result="denied";
        $ord_reference_id = $_POST["ord_reference_id"];
        $data["ord_id"] = $_POST["ord_id"];
        $eng_id = $_POST["eng_id"];
        $name=$_FILES['file']['name'];
        $data['email_reminder']=$this->customer_model->get_reminder_details($eng_id);
        //print_r($data['email_reminder']);exit;
        $file_ref=explode('.', $name); 
                $path = EMAIL_ATTACHMENT_PATH.$this->input->post('ord_reference_id');
                if(is_file($path.'/'.$_FILES['file']['name'])){
                    unlink($path.'/'.$_FILES['file']['name']);
                }
                (!is_dir($path)) ? mkdir($path, 0755, true) : "";
                $config['upload_path'] = $path;
                $config['allowed_types'] = '*';
                $this->upload->initialize($config);
                if (!$this->upload->do_upload('file')) {
                    $error = $this->upload->display_errors();
                    echo json_encode(array("status" => "failure", "message" => $error));
                } else {
                    //echo "<pre>";print_r($this->upload->data());exit;
                    $upload_details = $this->upload->data();
                    if((substr($file_ref[0], 0, strlen("book1")) === "book1")||(substr($file_ref[0], 0, strlen("Book1")) === "Book1")){$file_ref[1]="d_".$file_ref[1];}
                    echo json_encode(array("status" => "success", "message" => "File Uploaded successfully.", "savedfilename" => $_FILES["file"]["name"], "filename" => $_FILES["file"]["name"],"format"=>$file_ref[1],"size"=>round($upload_details['file_size'])));
                }
    }
    public function email_attachment_remove(){
        $file_name = str_replace(" ","_",$this->input->post('filename'));
        $file_ref=explode('.', $file_name);
        $path = EMAIL_ATTACHMENT_PATH.$this->input->post('ord_reference_id');
        $data["ord_id"] = $_POST["ord_id"];
        //$data['bottom_order'] = $_POST["bottom_order"];
        //$data['bottom_order']=$this->cad_model1->check_bottom_order($data['ord_id']);
        $ord_reference_id=$this->input->post('ord_reference_id');
        if(is_file($path.'/'.$file_name)){

                unlink($path.'/'.$file_name);
                if((substr($file_ref[0], 0, strlen("book1")) === "book1")||(substr($file_ref[0], 0, strlen("Book1")) === "Book1")){$file_ref[1]="d_".$file_ref[1];}
                echo json_encode(array("status" => "success", "message" => "Removed.", "removedfilename" => $file_name, "filename" => $file_name,"format"=>"b_".$file_ref[1]));

            

        }else{
            echo json_encode(array("status" => "failed", "message" => "Missing.", "removedfilename" => $file_name, "filename" => $file_name));
        }
        
    }
    public function change_hold_status(){
        //print_r($this->input->post('order_id'));exit;
                $job_updates['update_date']=date("Y-m-d");
                $job_updates['update_time']=date("Y-m-d h:i:s");
                $job_updates['update_to']="UN-HOLD";
                $job_updates['update_for']=1;
                $job_updates['update_status']=1;
                //$job_updates['show_customer']=1;
                $job_updates['update_remarks']="UN-Hold by Wims 2";
                $job_updates['update_by']=$this->session->userdata('user_id');
                $cust_job_update_status=$this->tooling_model->update_job_status($job_updates,$this->input->post('job_id'));
                $job_updates['update_date']=date("Y-m-d");
                $job_updates['update_time']=date("Y-m-d h:i:s");
                $job_updates['update_to']="REMINDER DEACTIVATED";
                $job_updates['update_for']=1;
                $job_updates['update_status']=1;
                //$job_updates['show_customer']=1;
                $job_updates['update_remarks']="REMINDER DEACTIVATED by Wims 2";
                $job_updates['update_by']=$this->session->userdata('user_id');
                $cust_job_update_status=$this->tooling_model->update_job_status($job_updates,$this->input->post('job_id'));
            //     $bottom_order=$this->cad_model1->check_bottom_order($this->input->post('order_id'));
            // if ($bottom_order!="") {
            //     $job_updates['update_date']=date("Y-m-d");
            //     $job_updates['update_time']=date("Y-m-d h:i:s");
            //     $job_updates['update_to']="UN-HOLD";
            //     $job_updates['update_for']=1;
            //     $job_updates['update_status']=1;
            //     $job_updates['show_customer']=1;
            //     $job_updates['update_remarks']="UN-Hold by Wims 2";
            //     $job_updates['update_by']=$this->session->userdata('user_id');
            //     $cust_job_update_status=$this->cad_model1->update_job_status($job_updates,get_order_id( $bottom_order));
            //     $job_updates['update_date']=date("Y-m-d");
            //     $job_updates['update_time']=date("Y-m-d h:i:s");
            //     $job_updates['update_to']="REMINDER DEACTIVATED";
            //     $job_updates['update_for']=1;
            //     $job_updates['update_status']=1;
            //     $job_updates['show_customer']=1;
            //     $job_updates['update_remarks']="REMINDER DEACTIVATED by Wims 2";
            //     $job_updates['update_by']=$this->session->userdata('user_id');
            //     $cust_job_update_status=$this->cad_model1->update_job_status($job_updates,get_order_id( $bottom_order));
            //     $status1=$this->cad_model1->change_reminder_status(get_order_id( $bottom_order));
            // }
        $status=$this->tooling_model->change_reminder_status($this->input->post('order_id'),$this->input->post('job_id'));
        if($status>0){
            echo json_encode(array("status" => "success", "message" => "Job UN-HOLD Successfully"));
        }else{
            echo json_encode(array("status" => "failed", "message" => "Job UN-HOLD Failed"));
        }
    }
    
    public function change_reminder_status(){
        //print_r($this->input->post('order_id'));exit;
                $job_updates['update_date']=date("Y-m-d");
                $job_updates['update_time']=date("Y-m-d h:i:s");
                $job_updates['update_to']="UN-HOLD";
                $job_updates['update_for']=1;
                $job_updates['update_status']=1;
                //$job_updates['show_customer']=1;
                $job_updates['update_remarks']="UN-Hold by Wims 2";
                $job_updates['update_by']=$this->session->userdata('user_id');
                $cust_job_update_status=$this->tooling_model->update_job_status($job_updates,$this->input->post('job_id'));
                $job_updates['update_date']=date("Y-m-d");
                $job_updates['update_time']=date("Y-m-d h:i:s");
                $job_updates['update_to']="REMINDER DEACTIVATED";
                $job_updates['update_for']=1;
                $job_updates['update_status']=1;
                //$job_updates['show_customer']=1;
                $job_updates['update_remarks']="REMINDER DEACTIVATED by Wims 2";
                $job_updates['update_by']=$this->session->userdata('user_id');
                $cust_job_update_status=$this->tooling_model->update_job_status($job_updates,$this->input->post('job_id'));
                $status=$this->tooling_model->change_reminder_status($this->input->post('order_id'),$this->input->post('job_id'));
                $bottom_order=$this->tooling_model->check_mail_bottom_order($this->input->post('order_id'),$this->input->post('job_id'));
            if ($bottom_order!="") {
                $job_updates['update_date']=date("Y-m-d");
                $job_updates['update_time']=date("Y-m-d h:i:s");
                $job_updates['update_to']="UN-HOLD";
                $job_updates['update_for']=1;
                $job_updates['update_status']=1;
                //$job_updates['show_customer']=1;
                $job_updates['update_remarks']="UN-Hold by Wims 2";
                $job_updates['update_by']=$this->session->userdata('user_id');
                $cust_job_update_status=$this->tooling_model->update_job_status($job_updates,get_job_id( $bottom_order));
                $job_updates['update_date']=date("Y-m-d");
                $job_updates['update_time']=date("Y-m-d h:i:s");
                $job_updates['update_to']="REMINDER DEACTIVATED";
                $job_updates['update_for']=1;
                $job_updates['update_status']=1;
                //$job_updates['show_customer']=1;
                $job_updates['update_remarks']="REMINDER DEACTIVATED by Wims 2";
                $job_updates['update_by']=$this->session->userdata('user_id');
                $cust_job_update_status=$this->tooling_model->update_job_status($job_updates,get_job_id( $bottom_order));
                $status1=$this->tooling_model->change_reminder_status(get_order_id( $bottom_order),get_job_id( $bottom_order));
            }
        if($status>0){
            echo json_encode(array("status" => "success", "message" => "Email Reminder Disabled"));
        }else{
            echo json_encode(array("status" => "failed", "message" => "Email Reminder Disable Failed"));
        }
    }
    
    public function mail_templates() {
        if ($this->input->post()) {
            $this->tooling_model->mail_templates($this->input->post());
            redirect('tooling/view_mail_templates');
        }
        $this->template->build('tooling/mail_templates');
    }
    
    public function view_mail_templates() {
        $data['templates'] = $this->tooling_model->get_templates();
        $this->template->build('tooling/view_mail_templates', $data);
    }
    
    public function edit_mail_templates() {
        $id = $this->uri->segment(3);
        if ($this->input->post()) {
            $data['mail_id'] = $id;
            $data = $this->input->post();
            //echo "<pre>";print_r($data);exit;
            $this->tooling_model->edit_templates($data);
            redirect('tooling/view_mail_templates');
        }
        $data['templates'] = $this->tooling_model->get_templates($id);
        $this->template->build('tooling/edit_mail_templates', $data);
    }

    public function delete_mail_templates() {
        $id = $this->uri->segment(3);
        $data['templates'] = $this->tooling_model->delete_templates($id);
        redirect('tooling/view_mail_templates');
    }
   
    public function get_mailzip_size(){
           $data=$_POST;
           //echo "<pre>";print_r($data);exit;
           $bottom_order=$data['bottom_order'];
           if($bottom_order !=""){
               $bottom_order_attach="-".substr($bottom_order, -2);
           }else{
              $bottom_order_attach="";
           }
           $no_attach=isset($_POST["no_attach"]) ? 1 : 0 ;
           $this->load->helper('directory');
           $this->load->library('zip');
           if($no_attach==0){
               $path = EMAIL_ATTACHMENT_PATH.$this->input->post('order_reference_id');
               $email_attachment=$this->input->post('upload_files');
               $uploaded_files=array_filter(explode(',',$email_attachment));
               foreach ($uploaded_files as $key => $file) {
                   $this->zip->read_file($path.'/'.str_replace(" ","_",$file));
               }
               $this->zip->archive($path.$bottom_order_attach.'.zip');
               
               $file_size_zip = formatSizeUnits(filesize($path.$bottom_order_attach.'.zip'));
               
		if(($file_size_zip['type'] != 'KB')&&($file_size_zip['type'] != 'bytes')&&($file_size_zip['type'] != 'byte')&&($file_size_zip['type'] != 'bytes')){
		   if($file_size_zip['value'] >= 25){
		        $result = array('status'=>'failure','message'=>'File size Greater than 25 MB.','size'=>$file_size_zip['value'].' '.$file_size_zip['type']);
		   }else{
		        $result = array('status'=>'success','message'=>'File size less than 25 MB.','size'=>$file_size_zip['value'].' '.$file_size_zip['type']);
		   }
		}else{
		   $result = array('status'=>'success','message'=>'File size less than 25 MB.','size'=>$file_size_zip['value'].' '.$file_size_zip['type']);
		}
               
          }else{
               $result = array('status'=>'success','message'=>'No file attachment','size'=>'0 KB');
	  }
       
       echo json_encode($result);
   }

    
	public function checkattachment(){
	    if($this->input->post()){
	        $data=$_POST;
	        $available = strpos(strtolower($data['mail_message']),"attach");
	        if($available){
	            if($data['mail_attach_overwrite'] == 0 ){
	            	$no_attach = isset($data["no_attach"]) ? 1 : 0 ;
		            if( ($no_attach == 1) || ($data['upload_count'] == 0)){
		                echo json_encode(array('result' => 'failure', 'message' => 'You may have forgotten to attach a file.' ));
		            }else{
		                echo json_encode(array('result' => 'success', 'message' => 'Attachment Word and attachment found in mail' ));
		            }
	            }else{
	            	echo json_encode(array('result' => 'success', 'message' => 'No Attachment overwritten success' ));
	            }
	            
	        }else{
	           /* $available = strpos($data['mail_message'] ,"Attach");
	            if($available){
	                $no_attach = isset($data["no_attach"]) ? 1 : 0 ;
	                if( ($no_attach == 1) || ($data['upload_count'] == 0)){
	                    echo json_encode(array('result' => 'failure', 'message' => 'You may have forgotten to attach a file.' ));
	                }else{
	                    echo json_encode(array('result' => 'success', 'message' => 'Attachment Word and attachment found in mail' ));
	                }
	            }else{*/
	                echo json_encode(array('result' => 'success', 'message' => 'Attachment Word not found' ));
	            /* } */
	        }
	    }
	}

}
?>