<?php

class Cad extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if (!$this->session->userdata('logged_in')) {
            redirect('welcome');
        }
        $this->load->model('user_model');
        $this->load->model('cad_model1');
        $this->load->model('customer_model');
        $this->load->library('email');
        $this->load->library('upload');
        $this->load->model('beamon_model');
        $this->load->model('order_model');
        $this->load->helper('date');
        $this->load->library('ckeditor');
        $this->load->library('ckfinder');
        $this->ckeditor->basePath = base_url() . 'assets/ckeditor/';
        $this->ckeditor->config['toolbar'] = array(
            array('Source', '-', 'Bold', 'Italic', 'Underline', '-', 'Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo', '-', 'NumberedList', 'BulletedList')
        );
        $this->ckeditor->config['language'] = 'english';
        $this->ckeditor->config['width'] = '100%';
        $this->ckeditor->config['height'] = '300px';

//Add Ckfinder to Ckeditor
        $this->ckfinder->SetupCKEditor($this->ckeditor, '../../asset/ckfinder/');
    }

    public function index() {

        $date = date('Y-m-d');
        $data['high'] = $this->cad_model1->get_cad_status('2', '1', $date);
        $data['normal'] = $this->cad_model1->get_cad_status('1', '1', $date);
        $data['low'] = $this->cad_model1->get_cad_status('0', '1', $date);
        $this->template->build("cad/cad_orders", $data);
    }

    public function cad_new_job() {
        header('Access-Control-Allow-Origin: *');
        $data["order_id"] = $_GET['ord_id'];
        $data["engg_id"] = $_GET['engg_id'];
        $data['ord_ref_id'] = $_GET['ord_ref_id'];
        $data["order_status"] = $this->cad_model1->get_order_status($data["order_id"]);
        $data['user'] = $this->user_model->get_job_update_join($data["order_status"]["id"]);
        //echo "<pre>";print_r($data);exit;
        $this->load->view('cad/cad_popup', $data);
    }

    public function cad_mail_to_customer() {
        header('Access-Control-Allow-Origin: *');
        if ($this->input->post()) {
            $config['protocol'] = 'smtp';
            $config['smtp_host'] = 'ssl://smtp.gmail.com';
            $config['smtp_port'] = '25';
            $config['smtp_port'] = '465';
            $config['smtp_timeout'] = '7';
            $config['smtp_user'] = 'karthiixly@gmail.com';
            $config['smtp_pass'] = 'karthiylxi';
            $config['charset'] = 'utf-8';
            $config['newline'] = "\r\n";
            $config['validation'] = TRUE; // bool whether to validate email or not    
            $config['mailtype'] = 'html';
            $this->email->initialize($config);
            $this->email->set_newline("\r\n");
            $this->email->from('karthiixly@gmail.com', 'ixly');
            $this->email->to($_POST["email"]);
            $cc_email = str_replace(';', ',', $_POST["cc_email"]);
            $this->email->cc($cc_email);
            $filnames = $_POST["file_names"];
            $filenames = explode(",", $filnames);
            if (!empty($filenames)) {
                foreach ($filenames as $filename) {
                    if (!empty($filename))
                        $this->email->attach(base_url() . '/upload/' .$_POST['order_reference_id'] . '/cad_mailed_docs/' . $filename);
                }
            }
            $message = $_POST["message"];
            $message.=$this->load->view("cad/email_signature", array(), true);
            $this->email->subject($_POST["subject"]);
            $this->email->message($message);
//            $email_sent = ;
            if ($this->email->send()) {
                $data['is_hold'] = WORK_IN_HOLD;
                $data['ord_id'] = $_POST['ord_id'];
                change_working_status('is_hold', WORK_IN_HOLD, $data['ord_id']);
                working_status_updates(QUERY_SENT_TO_CUSTOMER, $_POST['subject'], $data['ord_id']);
                echo json_encode(array("status" => true, "message" => "Email sent successfully"));
            } else {
                echo json_encode(array("status" => false, "message" => "Email not sent successfully"));
            }
        } else {
            $data['ord_id'] = $_GET['ord_id'];
            $data['order_reference_id'] = $_GET['order_reference_id'];
            $customer_id = $_GET['engg_id']; //$this->uri->segment(3);
            $data["customer"] = $this->customer_model->get_engineer_details($customer_id);
            $this->load->view('cad/mail_to_customer', $data);
        }
    }

    public function upload_attachment() {
        $path = APPPATH . '../upload/' . $_POST["ord_reference_id"] . '/cad_mailed_docs';
        (!is_dir($path)) ? mkdir($path, 0777, true) : "";
        $config['upload_path'] = $path;
        $config['allowed_types'] = 'gif|jpg|png|pdf|zip|rar';
        $this->upload->initialize($config);
        if (!$this->upload->do_upload('file_1')) {
            $error = array('error' => $this->upload->display_errors());
            echo json_encode(array("status" => "failure", "message" => "File upload error."));
        } else {
            $uploaded = $this->upload->data();
            $data["attachment"] = $uploaded["file_name"];
            echo json_encode(array("status" => "success", "savedfilename" => $uploaded["file_name"], "filename" => $_FILES["file_1"]["name"]));
        }
    }

    public function send_to_laser() {

        $data['ord_id'] = $_POST['ord_id'];
        $data['cad_remarks'] = $_POST['update_remarks'];
        change_working_status('cad_status', WORK_COMPLETED, $data['ord_id']);
        change_working_status('cad_remarks', $data['cad_remarks'], $data['ord_id']);
        working_status_updates(CAD_COMPLETED, $_POST['update_remarks'], $data['ord_id']);
        echo json_encode(array("status" => true, "message" => "Cad Work Completed."));
    }

    public function checklist() {
        $data['ord_id'] = $_POST['ord_id'];
        $data['ord_sts_id'] = $_POST['ord_sts_id'];
        $data['order_details'] = $this->order_model->get_order_details($data['ord_id']);
        $data['order_details']['order_code']= $_POST['job_code'];
        $data['cust_name'] = $this->customer_model->get_customer_name($data['order_details']['cust_ref']);
        $this->load->view('cad/checklist', $data);
    }

    public function fixit_checklist() {
        $data['order_id'] = $this->input->post('order_id');
        $data['order_status_id'] = $this->input->post('order_status_id');
        $this->load->view('cad/fixit_checklist', $data);
    }

    public function template_checklist() {
        $data['order_id'] = $this->input->post('order_id');
        $data['order_status_id'] = $this->input->post('order_status_id');
        $this->load->view('cad/template_checklist', $data);
    }
    
        //function written by krishna
    public function get_double_epoxy($ord_id) {

        $epoxy=get_epoxy($ord_id);
        $frm_size = $this->cad_model1->get_frame_size($ord_id);
        $foil_only_other=get_foil_only_other($ord_id);
        $type_of_frame=get_type_of_frame($frm_size);
        $ship_method=get_ship_method($ord_id);
        $stencil_side=get_stencil_side($ord_id);
        $epoxy_req = get_epoxy_req($ord_id);
        if ($type_of_frame != "2" || $type_of_frame != "3" || $foil_only_other != "1" && ($stencil_side == "3" || $ship_method != 1 || $epoxy_req == 1  ) ) {
            $double_epoxy = 1;
        } else {
            $double_epoxy = 0;
        }
        return $double_epoxy;

    }
    public function ckeck_double_epoxy() {
        $aperture = $this->input->post('aperture_count');
        $ord_id = $this->input->post('order_id');
         if( $aperture > 10000){
             $data['double_epoxy'] = 1;
             echo '<input type="checkbox" name="sc_double_epoxy" id="double_epoxy" checked class="cad_ajax_chkboxes" value="1" data-id="double_epoxy"><label for="double_epoxy" class="col-lg-5 control-label">Double Epoxy</label>';
         }else{
             if($this->get_double_epoxy($ord_id)== 1 ){
                echo '<input type="checkbox" name="sc_double_epoxy" id="double_epoxy" checked class="cad_ajax_chkboxes" value="1" data-id="double_epoxy"><label for="double_epoxy" class="col-lg-5 control-label">Double Epoxy</label>';
             }else{
                echo '<input type="checkbox" name="sc_double_epoxy" id="double_epoxy" class="cad_ajax_chkboxes" value="1" data-id="double_epoxy"><label for="double_epoxy" class="col-lg-5 control-label">Double Epoxy</label>';
             }
         }
    }

    //function written by krishna

    public function stencil_checklist() {
        $data['order_id'] = $this->input->post('order_id');
        $data['order_status_id'] = $this->input->post('order_status_id');
        $data['double_epoxy']=  $this->get_double_epoxy($data['order_id']);
        $this->load->view('cad/stencil_checklist', $data);
    }

    public function spinplate_checklist() {
        $data['order_id'] = $this->input->post('order_id');
        $data['order_status_id'] = $this->input->post('order_status_id');
        $this->load->view('cad/spinplate_checklist', $data);
    }

    public function checklist_submit() {
        $data['checklist_stats'] = $this->cad_model1->get_checklist_stats($_POST['order_status_id']);
        foreach ($_POST as $key => $value) {
            if ($_POST[$key] == 'on')
                $_POST[$key] = 1;
        }
        $check = '';
        if (!$data['checklist_stats']) {
            $check = $this->cad_model1->checklist_data($_POST);
            echo json_encode(array('status' => 'success', 'message' => 'Details saved successfully', 'cad_checklist_id' => $check));
        } else {
            $check = $this->cad_model1->update_checklist($_POST);
            $check = $data['checklist_stats'];
            echo json_encode(array('status' => 'success', 'message' => 'Details saved successfully', 'cad_checklist_id' => $data['checklist_stats']));
        }
       $checklist_complete = $this->cad_model1->checklist_status($check);
                if(!empty($checklist_complete)) {
                $cad['cad_checklist_completed'] = 1;
//                $cad['cad_remarks'] = $data['sc_notes'];
                $cad['id'] = $data["order_status_id"];
                $cad['ord_id'] = $_POST['ord_id'];
               $this->cad_model1->notes_to_laser($cad);
                }
    }
    
    public function print_checklist(){
        $data['id'] = $_GET['id'];
        $data['print_data'] = $this->cad_model1->print_data($data);
        $data['print_data'] = $data['print_data'][0];
        $html = $this->load->view("cad/print_checklist", $data, true);
        $pdfFilePSath = "checklist.pdf";

        $this->load->library('pdf');

        $pdf = $this->pdf->load();
        $stylesheet = file_get_contents(base_url() . 'assets/css/mpdfstyletables.css');
        $pdf->WriteHTML($stylesheet, 1);
        $pdf->WriteHTML($html, 2); // write the HTML into the PDF
        $pdf->Output("$pdfFilePSath", 'I'); // save to file because we can
        exit;
    }

    public function rework_checklist() {
        $data['order_id'] = $this->input->post('order_id');
        $data['order_status_id'] = $this->input->post('order_status_id');
        $this->load->view('cad/rework_checklist', $data);
    }

    public function upload_to_archive() {
//        print_r($_FILES);exit;
        $ord_reference_id = $_POST["ord_reference_id"];
        $data["order_status_id"] = $_POST["order_status_id"];
        $file_exist = $this->cad_model1->uploaded_files_details($data["order_status_id"], $_POST['type_of_upload']);
        $path = APPPATH . '../upload/' . $ord_reference_id;
        (!is_dir($path)) ? mkdir($path, 0755, true) : "";
        $config['upload_path'] = $path;
        $config['allowed_types'] = 'gif|jpg|png|pdf|zip|rar';
//  $config['file_name'] = date("YmdHis") . $_FILES["file"]["tmp_name"];
        $this->upload->initialize($config);
        if (!$this->upload->do_upload('file1')) {
            $error = array('error' => $this->upload->display_errors());
            echo json_encode(array("status" => "failure", "message" => "File not uploaded."));
//$this->template->build('admin/add_user', $error);
        } else {
            $uploaded = $this->upload->data();
            $data["file_name"] = $uploaded["file_name"];
            $data["order_status_id"] = $_POST["order_status_id"];
            $data['file_type'] = $_POST['type_of_upload'];
            if (!empty($file_exist)) {
                $this->cad_model1->update_archive($data);
            } else {
                $this->cad_model1->upload_archive($data);
            }
            echo json_encode(array("status" => "success", "message" => "File Uploaded successfully.", "savedfilename" => $uploaded["file_name"], "filename" => $_FILES["file1"]["name"]));
        }
    }

    public function upload_to_checklist() {

        $ord_reference_id = $_POST["ord_reference_id"];
        $data["order_status_id"] = $_POST["order_status_id"];
        $file_exist = $this->cad_model1->uploaded_files_details($data["order_status_id"], $_POST['type_of_upload']);
        $path = APPPATH . '../upload/' . $ord_reference_id;
        (!is_dir($path)) ? mkdir($path, 0755, true) : "";
        $config['upload_path'] = $path;
        $config['allowed_types'] = 'gif|jpg|png|pdf|zip|rar';
//  $config['file_name'] = date("YmdHis") . $_FILES["file"]["tmp_name"];
        $this->upload->initialize($config);
        if (!$this->upload->do_upload('file1')) {
            $error = array('error' => $this->upload->display_errors());
            echo json_encode(array("status" => "failure", "message" => "File not uploaded."));
//$this->template->build('admin/add_user', $error);
        } else {
            $uploaded = $this->upload->data();
            $data["file_name"] = $uploaded["file_name"];
            $data["order_status_id"] = $_POST["order_status_id"];
            $data['file_type'] = $_POST['type_of_upload'];
            if (!empty($file_exist)) {
                $this->cad_model1->update_archive($data);
            } else {
                $this->cad_model1->upload_archive($data);
            }
            echo json_encode(array("status" => "success", "message" => "File Uploaded successfully.", "savedfilename" => $uploaded["file_name"], "filename" => $_FILES["file1"]["name"]));
        }
    }

    public function change_cad_status() {
        $order['ord_id'] = $this->uri->segment(3);
        $data["order_status"] = $this->cad_model1->get_order_status($order['ord_id']);
        if ($data["order_status"]['cad_status'] == 0) {

            $this->cad_model1->change_cad_working($data["order_status"]['id']);
            $order['update_remarks'] = "Cad Work started by" . $this->session->userdata('user_name');
            $order['update_status'] = 1;
            $this->cad_model1->change_cad_working_history($order);
            $encode = array("status" => true, "message" => "Cad Status Changed to Working.");
        } elseif ($data["order_status"]['cad_status'] == 1 && $data["order_status"]['is_hold'] == 0) {
            $encode = array("status" => false, "message" => "Cad status is already in working");
        } elseif ($data["order_status"]['cad_status'] == 2) {
            $encode = array("status" => false, "message" => "The Cad is already Completed");
        } elseif ($data["order_status"]['is_hold'] == 0) {
            $encode = array("status" => false, "message" => "Sorry ! The Cad design is in hold sent for clarification to the Client.");
        }
        echo json_encode($encode);
    }

    public function change_cad_working_status() {
        $data['ord_id'] = $this->input->post('ord_id');
        $order["order_status"] = $this->cad_model1->get_order_status($data['ord_id']);
        $this->cad_model1->change_cad_working($order["order_status"]['id']);
        $data['update_status'] = 4;
        $data['update_remarks'] = "Cad Work restarted by" . $this->session->userdata('user_name');
        $this->cad_model1->change_cad_working_history($data);
        $encode = array("status" => true, "message" => "Cad Status Changed");
        echo json_encode($encode);
    }

    public function mail_templates() {
        if ($this->input->post()) {
            $this->cad_model1->mail_templates($this->input->post());
            redirect('cad/view_mail_templates');
        }
        $this->template->build('cad/mail_templates');
    }

    public function view_mail_templates() {
        $data['templates'] = $this->cad_model1->get_templates();
        $this->template->build('cad/view_mail_templates', $data);
    }

    public function edit_mail_templates() {
        $id = $this->uri->segment(3);
        if ($this->input->post()) {
            $data['mail_id'] = $id;
            $data = $this->input->post();
            $this->cad_model1->edit_templates($data);
            redirect('cad/view_mail_templates');
        }
        $data['templates'] = $this->cad_model1->get_templates($id);
        $this->template->build('cad/edit_mail_templates', $data);
    }

    public function delete_mail_templates() {
        $id = $this->uri->segment(3);
        $data['templates'] = $this->cad_model1->delete_templates($id);
        redirect('cad/view_mail_templates');
    }

    public function get_mail_subject() {
        $data['eng_id'] = $_POST['eng_id'];
        $data['mail_id'] = $_POST['mail_id'];
        $data['ord_id'] = $_POST['ord_id'];
        $data['customer'] = $this->customer_model->get_engineer_details($data['eng_id']);
        $data['message'] = get_cad_mail_subject($data['mail_id']);
        $data['order_details'] = $this->order_model->get_order_details($data['ord_id']);
        $data['customer_name'] = $this->customer_model->get_customer_name($data['order_details']['cust_ref']);
        $names = array(
            "{{first_name}}" => $data['customer']['eng_fname'],
            "{{customer_name}}" => $data['customer_name']['cust_name'],
            "{{assembly_no}}" => $data['order_details']['dt_top_assembly'] . $data['order_details']['dt_bot_assembly'],
            "{{fab_number}}" => $data['order_details']['dt_top_fab'] . $data['order_details']['dt_bot_fab'],
            "{{ref#}}" => "Ref.#" . $data['order_details']['order_code']
        );
        $mail_sub = strtr($data['message'][0]['mail_subject'], $names);
        $mail_body = strtr($data['message'][0]['mail_body'], $names);
        echo json_encode(array(
            "subject" => $mail_sub,
            "message" => $mail_body
        ));
    }

    public function compare_check_list() {
        $ord_id = $_POST["ord_id"];
        $order_status_id = $_POST["order_status_id"];
        $aperture_count = $_POST["sc_aperture_count"];
        $frame_used = $_POST["sc_frame_used"];
        $bot_ref = $_POST["sc_bot_ref_des"];
        $foil_thickness = $_POST["sc_foil_thik"];
        $fiducial_qty = $_POST["sc_fiducial_qty"];
        $fiducial_dcode = $_POST["sc_fiducial_dcode"];
        $border_used = $_POST["sc_border_used"];
        $error = array();
//Check aperture
        if (empty($aperture_count)) {
            $error["sc_aperture_content_em"] = "Please Enter the Aperture value.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Aperture Count Entered Wrongly');
        }
        /**
         * Check Frame used value for empty and compare with the order
         */
        if (empty($frame_used)) {
        	$error["sc_frame_used_em"] = "Please Enter the Frame value.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Frame Not Entered');
        } else {
        	$result = $this->cad_model1->get_frame_size($ord_id);
            if((($result == "-1") OR($result == "-2"))){
                $result = $this->cad_model1->compare_custom_frame_size($frame_used, $ord_id);
            }else{
                $result = $this->cad_model1->compare_frame_size($frame_used, $ord_id);
            }
            //$result = $this->cad_model1->compare_frame_size($frame_used, $ord_id);
            if (!$result) {
                $error["sc_frame_used_em"] = "Please Check the Frame value with the order.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Frame Entered Wrongly'); //Log error of the User
            }
        }
        /**
         * Check BOT Ref Value and compare with order
         */
        if (empty($bot_ref)) {
            $error["bot_ref_des_em"] = "Please Enter the BOT Value.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Frame Entered Wrongly'); //Log error of the User
        }
        /**
         * Check Foil thickness and compare with order
         */
        $stencil_side = $this->cad_model1->get_stencil_side($ord_id);
        if ($stencil_side['stencil_side'] == 1 || $stencil_side['stencil_side'] == 3)
            $compartwith = array(
                "top_foil_thik", "top_multilevel", "top_multilevel_2"
            );
        else {
            $compartwith = array(
                "bot_foil_thik", "bot_multilevel", "bot_multilevel_2"
            );
        }
        foreach ($foil_thickness as $key => $foil) {
            if (($key==0)AND(empty($foil))) {
                $error["sc_foil_thik_em"] = "Please Enter the Foil thickness Value.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Frame Entered Wrongly');
            } else {
                $result = $this->cad_model1->compare_foil_thickness($foil, $ord_id, $compartwith[$key]);
//                print_r($compartwith);exit;
                if (!$result) {
                    $error["sc_foil_thik_em"] = "Please Check the Foil thickness with the order.";
                    $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Foil thickness Entered Wrongly');
                }
            }
        }
        /**
         * Check for Fiducial Quantity empty
         */
        foreach ($fiducial_qty as $key => $fiducial) {
            if (($key==0)AND(empty($fiducial))) {
                $error["sc_fiducial_qty_em"] = "Please Enter the Fiducial Quantity.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Fiducial Quantity not Entered'); //Log error of the User
            }
        }
        /**
         * Check for Fiducial Dcode empty
         */
        foreach ($fiducial_dcode as $key => $fiducial) {
            if (($key==0)AND(empty($fiducial))) {
                $error["sc_fiducial_dcode_em"] = "Please Enter the Fiducial Dcode Value.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Fiducial Dcode not Entered');
            }
        }
        /**
         * Check for Border Used empty
         */
        if ((($border_used=="") OR ($border_used=="Select Border")) ) {
            $error["sc_border_used_em"] = "Please Enter the Border Used.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Fiducial Quantity not Entered');
        } 

        $result = $this->cad_model1->compare_order_datas($ord_id, "lead_free_mark", isset($_POST["sc_lead_free"]) ? 1 : 0 );
        if (empty($result)) {
            $error["lead_free_mark_em"] = "Please Check the Lead Free with the order.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Lead Free Entered Wrongly');
        }
//        $result = $this->cad_model1->compare_order_datas($ord_id, "ship_tooling", isset($_POST["ship_tooling"]) ? 1 : 0 );
//        if (empty($result)) {
//            $error["ship_tooling_em"] = "Please Check the Ship Tooling with the order.";
//        } 
        //$_POST["sc_fg_material"];
        $result = $this->cad_model1->compare_order_datas($ord_id, "fg_material", isset($_POST["sc_datum_fg"]) ? 1 : 0 );
        if (empty($result)) {
            $error["fg_material_em"] = "Please Check the Datum FG with the order.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Datum FG Entered Wrongly');
        }
        $result = $this->cad_model1->compare_order_datas($ord_id, "film_plots", isset($_POST["sc_ship_plot"]) ? 1 : 0 );
        if (empty($result)) {
            $error["film_plots_em"] = "Please Check the Ship W/ Plots with the order.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Ship W/ Plots Entered Wrongly');
        }
        $result = $this->cad_model1->compare_order_datas($ord_id, "inspect_template", isset($_POST["sc_ship_template"]) ? 1 : 0 );
        if (empty($result)) {
            $error["inspect_template_em"] = "Please Check the Ship W / Template with the order.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Ship W / Template Entered Wrongly');
        }
        $result = $this->cad_model1->compare_order_datas($ord_id, "epo_coat", isset($_POST["sc_epo_coat"]) ? 1 : 0 );
        if (empty($result)) {
            $error["epo_coat_em"] = "Please Check the Epo Coat with the order.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Epo Coat Entered Wrongly');
        }
        $result = $this->cad_model1->compare_order_datas($ord_id, "epo_coat", isset($_POST["sc_nano_coat"]) ? 1 : 0 );
        if (empty($result)) {
            $error["nano_coat_em"] = "Please Check the Coat with the order.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Nano Coat Entered Wrongly');
        }
        if (!isset($_POST['sc_back_etch'])) {
            $error["back_etch_em"] = "Please Check back etch with the order.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Back Etch Entered Wrongly');
        }
        if (!isset($_POST['sc_cp_1'])) {
            $error["cust_instr_em"] = "Please review customer instructions.";
        }
        if (!isset($_POST['sc_cp_2'])) {
            $error["check_drawing_em"] = "Please check all the files.";
        } 
        if (!isset($_POST['sc_cp_3'])) {
            $error["silkscr_check_em"] = "Please check all the screens.";
        } else
        if (!isset($_POST['sc_cp_4'])) {
            $error["spl_instr_em"] = "Please verify special instructions.";
        }
//Save Data
        if (empty($error)) {
            $url_value = $this->uri->segment(3);
            if (!empty($url_value)) {
                $data = $_POST;
                $data['sc_completed']=1; // this line is used to identify stencil check list completed
                $data['checklist_stats'] = $this->cad_model1->get_checklist_stats($data['order_status_id']);
                if (!$data['checklist_stats']){
                    $cad_checklist_id = $this->cad_model1->checklist_data($data);
                }else{
                    $this->cad_model1->update_checklist($data);
                    $cad_checklist_id = $data['checklist_stats'];
                }
                $this->cad_model1->delete_fiducials($cad_checklist_id);
                foreach ($fiducial_qty as $key => $fiducial) {
                    $fiducial_save_array = array(
                        "cad_checklist_id" => $cad_checklist_id,
                        "fiducial_quantity" => $fiducial
                    );
                    $this->cad_model1->fiducial_qty($fiducial_save_array);
                }
                foreach ($fiducial_dcode as $key => $fiducial) {
                    $fiducial_save_array = array(
                        "cad_checklist_id" => $cad_checklist_id,
                        "fiducial_dcode" => $fiducial
                    );
                    $this->cad_model1->fiducial_dcode($fiducial_save_array);
                }
                foreach ($foil_thickness as $key => $foil) {
                    $foil_thickness_save = array(
                        "cad_checklist_id" => $cad_checklist_id,
                        "thickness" => $foil
                    );
                    $this->cad_model1->foil_thickness($foil_thickness_save);
                }
                $order_code=get_order_code($data['ord_id']); //get order_code from order id using common helper
                //print_r($order_code['order_code']);
                $chklst=get_checklist($order_code['order_code']); //getting check list compare list from common function
                $checklist_complete = $this->cad_model1->checklist_status($chklst); //checking the check list completed or not using check list conditions
                if(!empty($checklist_complete)) { //if check list completed the insert the following $cad values to laser department
                $cad['cad_checklist_completed'] = 1;
                $cad['cad_remarks'] = $data['sc_notes'];
                $cad['id'] = $data["order_status_id"];
                $cad['ord_id'] = $data['ord_id'];
               $this->cad_model1->notes_to_laser($cad);//inserting the $cad values to the laser department
               $update['cad_remarks']= $data['sc_notes'];
               $update['cad_completed_time']= date('Y-m-d H:i:s');
               $update['cad_checklist_completed']=1;
               $this->cad_model1->staus_change_order_status($data["order_status_id"],$update);//update checklist complete status to tbl_order_status
                }
            }
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Checklist Completed');
            $success["status"] = "true";
            $success["message"] = "Checklist values matched the Order.";
            $success["cad_checklist_id"] = $cad_checklist_id;
            echo json_encode($success);
        } else {
            $error["status"] = "false";
            echo json_encode($error);
        }
        exit;
    }

    public function print_stncil_checklist() {        
        $data['id'] = $_GET['id'];
        $data['print_data'] = $this->cad_model1->print_data($data);
        $data['print_data'] = $data['print_data'][0];
        $html = $this->load->view("cad/print_stencil_checklist", $data, true);
        $pdfFilePSath = "checklist.pdf";

        $this->load->library('pdf');

        $pdf = $this->pdf->load();
        $stylesheet = file_get_contents(base_url() . 'assets/css/mpdfstyletables.css');
        $pdf->WriteHTML($stylesheet, 1);
        $pdf->WriteHTML($html, 2); // write the HTML into the PDF
        $pdf->Output("$pdfFilePSath", 'I'); // save to file because we can
        exit;
    }

    public function print_stencil_checklist() {
//        print_r($_GET);exit;
        $this->load->view('cad/print_stencil_checklist');
    }

    protected function checklist_error_log($order_status_id, $update_status, $update_remarks) {
        $data['order_status_id'] = $order_status_id;
        $data['update_status'] = $update_status;
        $data['update_remarks'] = $update_remarks;
        $this->cad_model1->error_log($data);
    }

    public function compare_check_multi_list() {

        $result = $this->cad_model1->compare_order_datas($_POST["order_id"], $_POST["to_check"], ($_POST["value"] == 'true') ? 1 : 0 );
        if (empty($result)) {
            $error[$_POST["to_check"] . "_em"] = "Please Check the " . $_POST["label_disp"] . " with the order.";
            echo json_encode($error);
        } else {
            $success[$_POST["to_check"] . "_em"] = "";
            echo json_encode($success);
        }
        exit;
    }

     public function get_borders() {
        $result = $this->cad_model1->get_frame_size($_POST["order_id"]);
            if((($result == "-1") OR ($result == "-2"))){
                echo'<input class="form-control" type="text" name="sc_border_used" id="sc_border_used" data-id="sc_border_used" STYLE="padding:0;">';
            }else{
                $results = $this->cad_model1->get_borders($_POST["value"]);
                echo'<select class="form-control" name="sc_border_used" id="sc_border_used" data-id="sc_border_used" STYLE="padding:0;">';
                echo'<option>Select Border</option>';
                if (!empty($results)) {
                    foreach ($results as $result) {
                        echo '<option value="' . $result["border_id"] . '">' . $result["border_size"] . '</option>';
                    }
                }
                echo '</select>';
            }
            exit;
    }
    
    //below code written By KRISHNAMK

    public function compare_fixit_checklist(){
       // print_r($_POST);exit;

        $review=isset($_POST['fc_cp_1']) ? 1 : 0 ;
        $rename=isset($_POST['fc_cp_2']) ? 1 : 0 ;
        $save=isset($_POST['fc_cp_3']) ? 1 : 0 ;
        $print=isset($_POST['fc_cp_4']) ? 1 : 0 ;
        $ensure=isset($_POST['fc_cp_5']) ? 1 : 0 ;
        $pad_count=$_POST['fc_pad_count'];
        $ord_id = $_POST["order_id"];
        $order_status_id=$_POST['order_status_id'];

        if(empty($review)){
            $error["fc_review_order_em"] = "Please Check the Order Review.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Order Review Not Entered');
        }

        if(empty($rename)){
            $error["fc_rename_files_em"] = "Please Check the Rename Files.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Rename Files Not Entered');
        }

        if(empty($save)){
            $error["fc_save_layer_em"] = "Please Check the Save Layer.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Save Layer Not Entered');
        }

        if(empty($print)){
            $error["fc_print_high_em"] = "Please Check the Print High.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Print High Not Entered');
        }

        if(empty($ensure)){
            $error["fc_target_layer_em"] = "Please Check the Target Layer.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Target Layer Not Entered');
        }

        if(empty($pad_count)){
            $error["fc_pad_count_em"] = "Please Enter the Pad Count.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Pad Count Not Entered');
        }
        if (empty($error)) {
            $url_value = $this->uri->segment(3);
            if (!empty($url_value)) {
                $data = $_POST;
                $order_id=$data['order_id'];
                unset($data['order_id']);
                $data['fc_completed']=1; // this line is used to identify stencil check list completed
                $data['checklist_stats'] = $this->cad_model1->get_checklist_stats($data['order_status_id']);
                if (!$data['checklist_stats']){
                    $cad_checklist_id = $this->cad_model1->checklist_data($data);
                }else{
                    $this->cad_model1->update_checklist($data);
                    $cad_checklist_id = $data['checklist_stats'];
                }
                $data['ord_id']=$order_id;
                $order_code=get_order_code($data['ord_id']); //get order_code from order id using common helper
                //print_r($order_code['order_code']);
                $chklst=get_checklist($order_code['order_code']);
                
                $checklist_complete = $this->cad_model1->checklist_status($chklst); //checking the check list completed or not using check list conditions
                if(!empty($checklist_complete)) { //if check list completed the insert the following $cad values to laser department
                    $cad['cad_checklist_completed'] = 1;
                    $cad['cad_remarks'] = $data['fc_notes'];
                    $cad['id'] = $data["order_status_id"];
                    $cad['ord_id'] = $data['ord_id'];
                    $cad['ord_id'];
                   $this->cad_model1->notes_to_laser($cad);//inserting the $cad values to the laser department
                   $update['cad_remarks']= $data['fc_notes'];
                   $update['cad_completed_time']= date('Y-m-d H:i:s');
                   $update['cad_checklist_completed']=1;
                   $this->cad_model1->staus_change_order_status($data["order_status_id"],$update);//update checklist complete status to tbl_order_status
                }
            }
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Checklist Completed');
            $success["status"] = "true";
            $success["message"] = "Checklist values matched the Order.";
            echo json_encode($success);

        }else {
            $error["status"] = "false";
            echo json_encode($error);
        }
        exit;
    }
    
    public function compare_spinplate_checklist(){
       // print_r($_POST);exit;

        $spc_cp_1=isset($_POST['spc_cp_1']) ? 1 : 0 ;
        $spc_cp_2=isset($_POST['spc_cp_2']) ? 1 : 0 ;
        $spc_cp_3=isset($_POST['spc_cp_3']) ? 1 : 0 ;
        $spc_cp_4=isset($_POST['spc_cp_4']) ? 1 : 0 ;
        $spc_cp_5=isset($_POST['spc_cp_5']) ? 1 : 0 ;
        $spc_cp_6=isset($_POST['spc_cp_6']) ? 1 : 0 ;
        $spc_cp_7=isset($_POST['spc_cp_7']) ? 1 : 0 ;
        $order_id = $_POST["order_id"];
        $order_status_id=$_POST['order_status_id'];

        if(empty($spc_cp_1)){
            $error["spc_cp_1_em"] = "Please Check the Combine Bottom.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Combine Bottom Not Entered');
        }

        if(empty($spc_cp_2)){
            $error["spc_cp_2_em"] = "Please Check the Mirror The File.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Mirror The File Not Entered');
        }

        if(empty($spc_cp_3)){
            $error["spc_cp_3_em"] = "Please Check the Create a New Layer.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Create a New Layer Not Entered');
        }

        if(empty($spc_cp_4)){
            $error["spc_cp_4_em"] = "Please Check the Add Text To Composite.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Order Review Not Entered');
        }

        if(empty($spc_cp_5)){
            $error["spc_cp_5_em"] = "Please Check the Add BEAM ON Logo.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Add BEAM ON Logo Not Entered');
        }

        if(empty($spc_cp_6)){
            $error["spc_cp_6_em"] = "Please Check the Save Outline File.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Save Outline File Not Entered');
        }

        if(empty($spc_cp_7)){
            $error["spc_cp_7_em"] = "Please Check the Save Composite File.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Save Composite File Not Entered');
        }
        if (empty($error)) {
           $url_value = $this->uri->segment(3);
            if (!empty($url_value)) {
                $data = $_POST;
                $order_id=$data['order_id'];
                unset($data['order_id']);
                $data['spc_completed']=1; // this line is used to identify stencil check list completed
                $data['checklist_stats'] = $this->cad_model1->get_checklist_stats($data['order_status_id']);
                if (!$data['checklist_stats']){
                    $cad_checklist_id = $this->cad_model1->checklist_data($data);
                }else{
                    $this->cad_model1->update_checklist($data);
                    $cad_checklist_id = $data['checklist_stats'];
                }
                $data['ord_id']=$order_id;
                $order_code=get_order_code($data['ord_id']); //get order_code from order id using common helper
                //print_r($order_code['order_code']);
                $chklst=get_checklist($order_code['order_code']);
                
                $checklist_complete = $this->cad_model1->checklist_status($chklst); //checking the check list completed or not using check list conditions
                if(!empty($checklist_complete)) { //if check list completed the insert the following $cad values to laser department
                    $cad['cad_checklist_completed'] = 1;
                    $cad['cad_remarks'] = $data['spc_spl_instr'];
                    $cad['id'] = $data["order_status_id"];
                    $cad['ord_id'] = $data['ord_id'];
                   $this->cad_model1->notes_to_laser($cad);//inserting the $cad values to the laser department
                   $update['cad_remarks']= $data['spc_spl_instr'];
                   $update['cad_completed_time']= date('Y-m-d H:i:s');
                   $update['cad_checklist_completed']=1;
                   $this->cad_model1->staus_change_order_status($data["order_status_id"],$update);//update checklist complete status to tbl_order_status
                }
            }
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Checklist Completed');
            $success["status"] = "true";
            $success["message"] = "Checklist values matched the Order.";
            echo json_encode($success);
        
        }else {
            $error["status"] = "false";
            echo json_encode($error);
        }
        exit;
    }

    public function compare_template_checklist(){
       // print_r($_POST);exit;

        $tc_template_type_1=isset($_POST['tc_template_type_1']) ? 1 : 0 ;
        $tc_template_type_2=isset($_POST['tc_template_type_2']) ? 1 : 0 ;
        $tc_template_type_3=isset($_POST['tc_template_type_3']) ? 1 : 0 ;
        $tc_template_type_3_text= $_POST["tc_template_type_3_text"];
        $tc_cp_1=isset($_POST['tc_cp_1']) ? 1 : 0 ;
        $tc_cp_2=isset($_POST['tc_cp_2']) ? 1 : 0 ;
        $tc_temp_size=isset($_POST['tc_temp_size']) ? 1 : 0 ;
        $tc_temp_size1=$_POST['tc_temp_size1'];
        $tc_temp_size2=$_POST['tc_temp_size2'];
        $tc_temp_qty=$_POST['tc_temp_qty'];
        $order_id = $_POST["order_id"];
        $order_status_id=$_POST['order_status_id'];

        if((empty($tc_template_type_1))AND(empty($tc_template_type_2))AND(empty($tc_template_type_3))){
            $error["tc_template_type_em"] = "Please Check the Template type.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Template type Not Entered');
        }elseif(!(empty($tc_template_type_3))){
            if($tc_template_type_3_text==""){
                $error["tc_template_type_em"] = "Please Check the Template type.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Template type Not Entered');
            }
        }

        if(empty($tc_cp_1)){
            $error["tc_cp_1_em"] = "Please Check the Mini.opening size.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Mini.opening size Not Entered');
        }

        if(empty($tc_cp_2)){
            $error["tc_cp_2_em"] = "Please Check the Polarity Dcode.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Polarity Dcode Not Entered');
        }

        if(empty($tc_temp_size)){

            if((($tc_temp_size1=="") OR ($tc_temp_size1=""))){
                $error["tc_temp_size_em"] = "Please Check the Template Size.";
                $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Template size Not Entered');
            }
        }

        if(empty($tc_temp_qty)){
            $error["tc_temp_qty_em"] = "Please Check the template quantity.";
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'template quantity Not Entered');
        }

        if (empty($error)) {
           /*$url_value = $this->uri->segment(3);
            if (!empty($url_value)) {
                $data = $_POST;
                $order_id=$data['order_id'];
                unset($data['order_id']);
                $data['spc_completed']=1; // this line is used to identify stencil check list completed
                $data['checklist_stats'] = $this->cad_model1->get_checklist_stats($data['order_status_id']);
                if (!$data['checklist_stats']){
                    $cad_checklist_id = $this->cad_model1->checklist_data($data);
                }else{
                    $this->cad_model1->update_checklist($data);
                    $cad_checklist_id = $data['checklist_stats'];
                }
                $data['ord_id']=$order_id;
                $order_code=get_order_code($data['ord_id']); //get order_code from order id using common helper
                //print_r($order_code['order_code']);
                $chklst=get_checklist($order_code['order_code']);
                
                $checklist_complete = $this->cad_model1->checklist_status($chklst); //checking the check list completed or not using check list conditions
                if(!empty($checklist_complete)) { //if check list completed the insert the following $cad values to laser department
                    $cad['cad_checklist_completed'] = 1;
                    $cad['cad_remarks'] = $data['spc_spl_instr'];
                    $cad['id'] = $data["order_status_id"];
                    $cad['ord_id'] = $data['ord_id'];
                   $this->cad_model1->notes_to_laser($cad);//inserting the $cad values to the laser department
                   $update['cad_remarks']= $data['spc_spl_instr'];
                   $update['cad_completed_time']= date('Y-m-d H:i:s');
                   $update['cad_checklist_completed']=1;
                   $this->cad_model1->staus_change_order_status($data["order_status_id"],$update);//update checklist complete status to tbl_order_status
                }
            }
            $this->checklist_error_log($order_status_id, CAD_CHECKLIST_ERROR_LOGS, 'Checklist Completed');*/
            $success["status"] = "true";
            $success["message"] = "Checklist values matched the Order.";
            echo json_encode($success);
        
        }else {
            $error["status"] = "false";
            echo json_encode($error);
        }
        exit;
    }


//Above Code Written By KRISHNAMK
}
