<script type="text/javascript">
$(document).ready(function() {
	$('#ProductAttributeValueReferenceProductAttributeId').change(function(){
         $(this).closest('form').trigger('submit');         
    });
});
</script>

<h2>Product</h2>
<hr>

<div class="row">
	<div class="span6">
        <table class="table-striped table-bordered table-condensed table-hover">            
            <tr>
                <td>Name</td>
                <td><?php echo h($product['Product']['name']); ?></td>
            </tr>
            <tr>
                <td>Slug</td>
                <td><?php echo h($product['Product']['slug']); ?></td>
            </tr>
            <tr>
                <td>Description</td>
                <td><?php echo h($product['Product']['description']); ?></td>
            </tr>
            <tr>
                <td>Image</td>
                <td>
                    <?php echo $this->Html->Image('/images/small/' . $product['Product']['image'], array('alt' => $product['Product']['name'], 'class' => 'image')); ?>
                    <br />
                    <?php echo h($product['Product']['image']); ?>                     
					<?php echo $this->Form->create('Product', array('type' => 'file')); ?>
                    <?php echo $this->Form->input('id', array('value' => $product['Product']['id'])); ?>
                    <?php echo $this->Form->input('slug', array('type' => 'hidden', 'value' => $product['Product']['slug'])); ?>                
                    <?php echo $this->Form->input('image', array('type' => 'file')); ?>        
                    <?php echo $this->Form->button('Submit', array('class' => 'btn btn-primary')); ?>
                    <?php echo $this->Form->end(); ?>                   
                    <?php //echo $this->Html->Image('/images/large/' . $product['Product']['image'], array('alt' => $product['Product']['name'], 'class' => 'image')); ?>
                </td>
            </tr>            
            <tr>
                <td>Price</td>
                <td><?php echo h($product['Product']['price']); ?></td>
            </tr>
            <tr>
                <td>Active</td>
                <td><?php echo $this->Html->link($this->Html->image('icon_' . $product['Product']['active'] . '.png'), array('controller' => 'products', 'action' => 'switch', 'active', $product['Product']['id']), array('class' => 'status', 'escape' => false)); ?></td>
            </tr>
            <tr>
                <td>Created</td>
                <td><?php echo h($product['Product']['created']); ?></td>
            </tr>
            <tr>
                <td>Modified</td>
                <td><?php echo h($product['Product']['modified']); ?></td>
            </tr>            
        </table>	                        
	</div>
    <div class="span6">
        <h5>Product Attributes</h5>
        <?php //pr($product_attributes);?>
        <table class="table-striped table-bordered table-condensed table-hover">
            <tr>
                <th><?php echo $this->Paginator->sort('product_attribute_name'); ?></th>
                <th><?php echo $this->Paginator->sort('product_attribute_value'); ?></th>				
                <th class="actions">Actions</th>
            </tr>
            <?php foreach ($product_attributes as $data): ?>
            <tr>
                <td><?php echo h($data['ProductAttribute']['product_attribute_name']); ?></td>
                <td><?php echo h($data['ProductAttributeValue']['product_attribute_value']); ?></td>						
                <td class="actions">			
                	<?php echo $this->Form->postLink('Delete', array('action' => 'deleteproductattributevaluereference', $data['ProductAttributeValueReference']['id'], $product['Product']['id']), array('class' => 'btn btn-mini btn-danger'), __('Are you sure you want to delete # %s?', $data['ProductAttributeValueReference']['id'])); ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>        
        <?php echo $this->element('pagination-counter'); ?>
        <?php echo $this->element('pagination'); ?>        
        <h5>Add Attributes</h5>
        <?php echo $this->Form->create('ProductAttributeValueReference'); ?>
        <?php echo $this->Form->input('product_attribute_id', array('options' => $productattributes) ); ?>                
		<?php echo ($productattributevalues)?$this->Form->input('product_attribute_value_id', array('options' => $productattributevalues)):'';?>        
        <?php echo $this->Form->input('product_id', array('type' => 'hidden','value'=>$product['Product']['id'])); ?>
        <?php echo $this->Form->submit('Add Attribute', array('name'=> 'add_attribute', 'class' => 'btn btn-primary')); ?>
        <?php echo $this->Form->end(); ?>
	</div>
    
</div>


<br />
<br />
<h3>Actions</h3>
<?php echo $this->Html->link('Edit Product', array('action' => 'edit', $product['Product']['id']), array('class' => 'btn')); ?>
<br />
<br />
<?php echo $this->Form->postLink('Delete Product', array('action' => 'delete', $product['Product']['id']), array('class' => 'btn btn-danger'), __('Are you sure you want to delete # %s?', $product['Product']['id'])); ?>

<br />
<br />