<?php echo $this->Html->css(array('bootstrap-editable.css'), 'stylesheet', array('inline' => false)); ?>
<?php echo $this->Html->script(array('bootstrap-editable.js'), array('inline' => false)); ?>

<script>
$(document).ready(function() {

	$('.category').editable({
		type: 'select',
		name: 'category_id',
		url: '<?php echo $this->webroot; ?>admin/products/editable',
		title: 'Category',
		source: <?php echo json_encode($categorieseditable); ?>,
		placement: 'right',
	});

	$('.manufacturer').editable({
		type: 'select',
		name: 'manufacturer_id',
		url: '<?php echo $this->webroot; ?>admin/products/editable',
		title: 'Manufacturer',
		source: <?php echo json_encode($manufacturerseditable); ?>,
		placement: 'right',
	});

	$('.name').editable({
		type: 'text',
		name: 'name',
		url: '<?php echo $this->webroot; ?>admin/products/editable',
		title: 'Name',
		placement: 'right',
	});

	$('.description').editable({
		type: 'textarea',
		name: 'description',
		url: '<?php echo $this->webroot; ?>admin/products/editable',
		title: 'Description',
		placement: 'right',
	});

	$('.price').editable({
		type: 'text',
		name: 'price',
		url: '<?php echo $this->webroot; ?>admin/products/editable',
		title: 'Price',
		placement: 'left',
	});

	$('.weight').editable({
		type: 'text',
		name: 'weight',
		url: '<?php echo $this->webroot; ?>admin/products/editable',
		title: 'Weight',
		placement: 'left',
	});

});
</script>
<h2>Products</h2>
<hr />
<?php echo $this->element('pagination-counter'); ?>
<?php echo $this->element('pagination'); ?>
<table class="table-striped table-bordered table-condensed table-hover">
	<tr>
		<th><?php echo $this->Paginator->sort('image'); ?></th>
		<th><?php echo $this->Paginator->sort('category_id'); ?></th>
		<th><?php echo $this->Paginator->sort('manufacturer_id'); ?></th>
		<th><?php echo $this->Paginator->sort('name'); ?></th>
		<th><?php echo $this->Paginator->sort('slug'); ?></th>
		<th><?php echo $this->Paginator->sort('description'); ?></th>				
		<th><?php echo $this->Paginator->sort('active'); ?></th>
		<th><?php echo $this->Paginator->sort('created'); ?></th>
		<th><?php echo $this->Paginator->sort('modified'); ?></th>
		<th class="actions">Actions</th>
	</tr>
	<?php foreach ($products as $product): ?>
	<tr>
		<td>
		<?php echo $this->Html->Image('/images/small/' . $product['Product']['image'], array('width' => 100, 'height' => 100, 'alt' => $product['Product']['image'], 'class' => 'image')); ?>
        <?php echo h($product['Product']['image']); ?>
        </td>
		<td><span class="category" data-value="<?php echo $product['Category']['id']; ?>" data-pk="<?php echo $product['Product']['id']; ?>"><?php echo $product['Category']['name']; ?></span></td>
		<td><span class="manufacturer" data-value="<?php echo $product['Manufacturer']['id']; ?>" data-pk="<?php echo $product['Product']['id']; ?>"><?php echo $product['Manufacturer']['name']; ?></span></td>
		<td><span class="name" data-value="<?php echo $product['Product']['name']; ?>" data-pk="<?php echo $product['Product']['id']; ?>"><?php echo $product['Product']['name']; ?></span></td>
		<td><?php echo h($product['Product']['slug']); ?></td>
		<td><span class="description" data-value="<?php echo $product['Product']['description']; ?>" data-pk="<?php echo $product['Product']['id']; ?>"><?php echo $product['Product']['description']; ?></span></td>		
		<td><?php echo $this->Html->link($this->Html->image('icon_' . $product['Product']['active'] . '.png'), array('controller' => 'products', 'action' => 'switch', 'active', $product['Product']['id']), array('class' => 'status', 'escape' => false)); ?></td>
		<td><?php echo h($product['Product']['created']); ?></td>
		<td><?php echo h($product['Product']['modified']); ?></td>
		<td class="actions">
			<?php echo $this->Form->postLink('Delete', array('action' => 'delete', $product['Product']['id']), array('class' => 'btn btn-mini btn-danger'), __('Are you sure you want to delete # %s?', $product['Product']['id'])); ?>
			<?php echo $this->Html->link('View', array('action' => 'view', $product['Product']['id']), array('class' => 'btn btn-mini')); ?>
			<?php echo $this->Html->link('Edit', array('action' => 'edit', $product['Product']['id']), array('class' => 'btn btn-mini')); ?>            
		</td>
	</tr>
	<?php endforeach; ?>
</table>
<?php echo $this->element('pagination-counter'); ?>
<?php echo $this->element('pagination'); ?>
<br />
<br />

<h3>Actions</h3>
<?php echo $this->Html->link('New Product', array('action' => 'add'), array('class' => 'btn btn-mini')); ?>
<br />
<br />