<?php echo $this->Html->script(array('jquery.jeditable.js'), array('inline' => false)); ?>
<h2>Product Attribute</h2>
<table class="table-striped table-bordered table-condensed table-hover">
<tr>
<td><?php echo __('Attribute Name'); ?></td>
<td><?php echo h($productattributeinfo['ProductAttribute']['product_attribute_name']); ?></td>
</tr>
<tr>
<td><?php echo __('Attribute Type'); ?></td>
<td>
	<?php $type = Configure::read('product_attribute_type');?>
	<?php echo h($type[$productattributeinfo['ProductAttribute']['product_attribute_type']]); ?>
</td>
</tr>
<tr>
<td><?php echo __('Created'); ?></td>
<td><?php echo h($productattributeinfo['ProductAttribute']['created']); ?></td>
</tr>
<tr>
<td><?php echo __('Modified'); ?></td>
<td><?php echo h($productattributeinfo['ProductAttribute']['modified']); ?></td>
</tr>
</table>
<br />
<br />
<h4>Product Attribute values</h4>
<table class="table-striped table-bordered table-condensed table-hover">
	<tr>		
		<th><?php echo $this->Paginator->sort('product_attribute_value'); ?></th>	
		<th><?php echo $this->Paginator->sort('attribute_order_sequence'); ?></th>
		<th><?php echo $this->Paginator->sort('created'); ?></th>
		<th><?php echo $this->Paginator->sort('modified'); ?></th>
		<th class="actions">Actions</th>
	</tr>
	<?php foreach ($ProductAttributeValues as $Data): ?>
	<tr>		
		<td><?php echo h($Data['ProductAttributeValue']['product_attribute_value']); ?></td>				
		<td><?php echo $this->inPlaceEditing->input('ProductAttributeValue', 'attribute_order_sequence', $Data['ProductAttributeValue']['id'],
			        	array('value' => $Data['ProductAttributeValue']['attribute_order_sequence'],
				              'actionName' => 'edit_in_place',
				              'type' => 'text',
				              'cancelText' => 'Cancel',
				              'submitText' => 'Save',
				              'toolTip' => 'Click to edit',
				              'containerType' => 'dd'
			            )
        			);
        	?>
		</td>
		<td><?php echo h($Data['ProductAttributeValue']['created']); ?></td>
		<td><?php echo h($Data['ProductAttributeValue']['modified']); ?></td>
		<td class="actions">			
			<?php echo $this->Form->postLink('Delete', array('action' => 'deleteattributevalue', $Data['ProductAttributeValue']['id'], $productattributeinfo['ProductAttribute']['id']), array('class' => 'btn btn-mini btn-danger'), __('Are you sure you want to delete # %s?', $Data['ProductAttributeValue']['id'])); ?>
		</td>
	</tr>
	<?php endforeach; ?>
</table>
<br />
<?php echo $this->element('pagination-counter'); ?>
<?php echo $this->element('pagination'); ?>
<br />
<br />

<h4>Add more</h4>
<?php echo $this->Form->create('ProductAttributeValue'); ?>
<table class="table-striped table-bordered table-condensed table-hover">
	<tr>		
		<td>
			<?php echo $this->Form->input('product_attribute_value'); ?>
        </td>
        <td>
			<?php echo $this->Form->input('attribute_order_sequence'); ?> 
		</td>
        <td>
        	<?php echo $this->Form->input('product_attribute_id', array('type' => 'hidden','value'=>$product_attribute_id)); ?>
			<?php echo $this->Form->button('Submit', array('class' => 'btn')); ?>
        </td>
	</tr>	
</table>
<?php echo $this->Form->end(); ?>
