<?php
App::uses('AppModel', 'Model');
class ProductAttributeValueReference extends AppModel {

/**
 * Table name
 *
 * @var string
 */	

	var $useTable = 'product_attribute_value_reference';		
	
////////////////////////////////////////////////////////////
	
	//check for unique value for combination of two column 
	function uniqueUserCombination($check) {
	  $count = $this->find('count', array(
            'conditions' => array(
                'product_id' => $this->data['ProductAttributeValueReference']['product_id'],
                'product_attribute_value_id' => $this->data['ProductAttributeValueReference']['product_attribute_value_id'],
            )
       ));
       return $count==0;
    }
		
	
	public $validate = array(
		'product_id' => array(
			'rule1' => array(
				'rule' => array('notempty'),
				'message' => 'product id is invalid',
				//'allowEmpty' => false,
				//'required' => true,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),			
		),
		'product_attribute_value_id' => array(
			'rule1' => array(
				'rule' => array('notempty'),
				'message' => 'product attribute value is invalid',
				//'allowEmpty' => false,
				//'required' => true,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
			'rule2' => array(
				'rule' => 'uniqueUserCombination',
				'message' => 'product attribute & value is already added',
				//'allowEmpty' => false,
				//'required' => true,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),			
		),
		
	);
	
////////////////////////////////////////////////////////////

	//get product attributes and their values 
	function getProductAttributes($id = null) {		
		$productattributes = $this->find('all', array(						
			'joins' => array(
				array(
					'table' => 'product_attribute_value',
					'alias' => 'ProductAttributeValue',
					'type' => 'INNER',
					'conditions' => array(
						'ProductAttributeValue.id = ProductAttributeValueReference.product_attribute_value_id'
					)
				),
				array(
					'table' => 'product_attribute',
					'alias' => 'ProductAttribute',
					'type' => 'INNER',
					'conditions' => array(
						'ProductAttribute.id = ProductAttributeValue.product_attribute_id'
					)
				)				
			),
			'conditions' => array(
				'ProductAttributeValueReference.product_id' => $id   
			),
			'fields' => array('ProductAttribute.*','ProductAttributeValue.*'),
			'order' => array("FIELD(ProductAttribute.product_attribute_name, 'Side') DESC","ProductAttributeValue.attribute_order_sequence"=>"ASC")
		));		
		//pr($productattributes);exit;
		$arrProductAttributes = array();
		for($i=0;$i<count($productattributes);$i++){
			for($j=0;$j<count($arrProductAttributes);$j++){
				if($productattributes[$i]['ProductAttribute']['id'] == $arrProductAttributes[$j]['ProductAttribute']['id']){
					break;
				}
			}
			$arrProductAttributes[$j]['ProductAttribute'] = $productattributes[$i]['ProductAttribute'];
			$arrProductAttributes[$j]['ProductAttributeValue'][] = $productattributes[$i]['ProductAttributeValue'];
		}
		//pr($arrProductAttributes);exit;		
		
	   return $arrProductAttributes;
	}
			

////////////////////////////////////////////////////////////

}
