<?php
App::uses('AppModel', 'Model');
class OrderProductAttributeReference extends AppModel {

/**
 * Table name
 *
 * @var string
 */	

	var $useTable = 'order_product_attribute_reference';		
	
////////////////////////////////////////////////////////////
	
	//Insert data after save in order item entry 
	function addOrderProductAttributeReference($data) {   				
		App::uses('CakeSession', 'Model/Datasource');
        $shop = CakeSession::read('Shop');
								
		if( isset($shop['ProductAttribute'][$data['OrderItem']['product_id']]) ){
			foreach($shop['ProductAttribute'][$data['OrderItem']['product_id']] as $k => $v){
				foreach($v as $key => $val){
					$this->create();
					$val = (is_array($val))? implode(',',$val) : $val;
					$this->save(
						array(
							'order_item_id' => $data['OrderItem']['id'],
							'order_series' => $k,
							'product_attribute' => $key,
							'product_attribute_value' => $val,					
						)
					);
				}
			}
		}
		
    }

////////////////////////////////////////////////////////////	
					
	public $validate = array(
		'order_item_id' => array(
			'rule1' => array(
				'rule' => array('notempty'),
				'message' => 'order item id is invalid',
				//'allowEmpty' => false,
				//'required' => true,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),			
		),
		'product_attribute_value_id' => array(
			'rule1' => array(
				'rule' => array('notempty'),
				'message' => 'product attribute value id is invalid',
				//'allowEmpty' => false,
				//'required' => true,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),			
		),		
		
	);
	
	
////////////////////////////////////////////////////////////
	
	public $belongsTo = array(
		'OrderItem' => array(
			'className' => 'OrderItem',
			'foreignKey' => 'order_item_id',
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'counterCache' => true,
			'counterScope' => array(),
		)
	);			

////////////////////////////////////////////////////////////

}
