<?php
App::uses('AppModel', 'Model');
class OrderItem extends AppModel {


//////////////////////////////////////////////////
	
	//aftersave calback method
	function afterSave($created) {
   		if($created){			
			$lastOrderItem = $this->findById( $this->getLastInsertID() );
						
			App::import('model','OrderProductAttributeReference');
			$orderProductAttributeReference = new OrderProductAttributeReference();			
			$orderProductAttributeReference->addOrderProductAttributeReference($lastOrderItem);			
		}
    }

//////////////////////////////////////////////////	
	
	public $validate = array(
		'order_id' => array(
			'numeric' => array(
				'rule' => array('numeric'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'name' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'quantity' => array(
			'numeric' => array(
				'rule' => array('numeric'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
	);

//////////////////////////////////////////////////
	
	public $hasMany = array(
		'OrderProductAttributeReference' => array(
			'className' => 'OrderProductAttributeReference',
			'foreignKey' => 'order_item_id',
			'dependent' => true,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => '',
		),		
	);
	
	public $belongsTo = array(
		'Order' => array(
			'className' => 'Order',
			'foreignKey' => 'order_id',
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'counterCache' => true,
			'counterScope' => array(),
		)
	);	

//////////////////////////////////////////////////

}
