<?php
App::uses('AppController', 'Controller');
class ShopController extends AppController {

//////////////////////////////////////////////////

	public $components = array(
		'Cart',
		'Paypal',
		'AuthorizeNet'
	);

//////////////////////////////////////////////////

	public $uses = array('Product','Order','OrderItem','OrderProductAttributeReference','Coupons','OrderUploadedDoc');

//////////////////////////////////////////////////

	public function beforeFilter() {
		parent::beforeFilter();
		$this->disableCache();
		//$this->Security->validatePost = false;
	}

//////////////////////////////////////////////////

	public function clear() {
		$this->Cart->clear();
		$this->Session->setFlash('All item(s) removed from your shopping cart', 'flash_error');
		$this->redirect('/');
	}

//////////////////////////////////////////////////

	public function add() {
		if ($this->request->is('post')) {
			//pr($this->request->data);exit;
			$productattributes = array();
			if( isset($this->request->data['ProductAttribute']) && $this->request->data['ProductAttribute']!='' ){
				$productattributes = $this->request->data['ProductAttribute'];	
			}
			
			$id = $this->request->data['Product']['id'];
			$product = $this->Cart->add($id, 1, $productattributes);
		}
		if(!empty($product)) {
			$this->Session->setFlash($product['Product']['name'] . ' was added to your shopping cart.', 'flash_success');
		}
		$this->redirect(array('controller' => 'shop', 'action' => 'cart'));				
		//$this->redirect($this->referer());
	}

//////////////////////////////////////////////////

	public function update() {
		$this->Cart->update($this->request->data['Product']['id'], 1);
	}

//////////////////////////////////////////////////

	public function remove($id = null) {
		$product = $this->Cart->remove($id);
		if(!empty($product)) {
			$this->Session->setFlash($product['Product']['name'] . ' was removed from your shopping cart', 'flash_error');
		}
		$this->redirect(array('action' => 'cart'));
	}

//////////////////////////////////////////////////

	public function cartupdate() {
		if ($this->request->is('post')) {
			foreach($this->request->data['Product'] as $key => $value) {												
				$product_id = str_replace('quantity-', '', $key);								
				$this->Cart->add($product_id, $value);
			}
			
			$coupon_code = $this->request->data['Coupon']['coupon_code'];
			if(isset($coupon_code) && $coupon_code != ''){
				$arrCoupon = $this->Coupons->findByCode($coupon_code);
				if(!empty($arrCoupon)){
					$couponCount = $this->Order->find('count', array('conditions' => array('Order.coupon_code' => $arrCoupon['Coupons']['code'])) );
					if($arrCoupon['Coupons']['max_usage'] > $couponCount){
						$this->Cart->calc_coupon_discount($coupon_code);
						$this->Session->write('Shop.Order.coupon_code', $coupon_code);						
					}else{
						$this->Session->setFlash('Coupon Usage Exceeded', 'flash_error');
						$this->Session->write('Shop.Order.coupon_code', '');
						$this->Session->write('Shop.Order.coupon_discount', '0.00');
						$this->redirect($this->referer());
					}			
				}else{ 
					$this->Session->setFlash('Coupon Not Found!!', 'flash_error');
					$this->Session->write('Shop.Order.coupon_code', '');
					$this->Session->write('Shop.Order.coupon_discount', '0.00');
					$this->redirect($this->referer());
				}
			}else{
				$this->Session->write('Shop.Order.coupon_code', '');
				$this->Session->write('Shop.Order.coupon_discount', '0.00');
			}						
			$this->Session->setFlash('Shopping Cart is updated.', 'flash_success');
		}
		$this->redirect(array('action' => 'cart'));
	}

//////////////////////////////////////////////////

	public function cart() {		
		$shop = $this->Session->read('Shop');
		//pr($shop);exit;
		$this->set(compact('shop'));
	}

//////////////////////////////////////////////////

	public function googlecheckout() {
		$this->helpers[] = 'Google';
		$shop = $this->Session->read('Shop');
		$this->set(compact('shop'));
	}

//////////////////////////////////////////////////

	public function address() {

		$shop = $this->Session->read('Shop');
		if(!$shop['Order']['total']) {
			$this->redirect('/');
		}

		if ($this->request->is('post')) {
			$this->loadModel('Order');
			$this->Order->set($this->request->data);
			if($this->Order->validates()) {
				$order = $this->request->data['Order'];
				$order['order_type'] = 'creditcard';
				$this->Session->write('Shop.Order', $order + $shop['Order']);
				$this->redirect(array('action' => 'shipping'));
			} else {
				$this->Session->setFlash('The form could not be saved. Please, try again.', 'flash_error');
			}
		}
		
		if(!empty($shop['Order'])) {
			$this->request->data['Order'] = $shop['Order'];
		}

	}
	
//////////////////////////////////////////////////

	public function shipping() {

		$shop = $this->Session->read('Shop');
		if(!$shop['Order']['total']) {
			$this->redirect('/');
		}

		if ($this->request->is('post')) {
			$this->loadModel('Order');
			$this->Order->set($this->request->data);
			if($this->Order->validates()) {																				
				if( $this->request->data['Order']['shipping_option'] == '1' ){
					$this->Session->write('Shop.Order.shipping_charges', '60.00');			
				} else {
					$this->Session->write('Shop.Order.shipping_charges', '00.00');
				}
				$this->Session->write('Shop.Order.shipping_option', $this->request->data['Order']['shipping_option']);
				$this->redirect(array('action' => 'review'));
			} else {
				$this->Session->setFlash('The form could not be saved. Please, try again.', 'flash_error');
			}
		}
				
		if( isset($shop['Order']['shipping_option']) ) {
			$this->request->data['Order']['shipping_option'] = $shop['Order']['shipping_option'];
		}
	}	

//////////////////////////////////////////////////

	public function step1() {
		$paymentAmount = $this->Session->read('Shop.Order.total');
		if(!$paymentAmount) {
			$this->redirect('/');
		}
		$this->Session->write('Shop.Order.order_type', 'paypal');
		$this->Paypal->step1($paymentAmount);
	}

//////////////////////////////////////////////////

	public function step2() {

		$token = $this->request->query['token'];
		$paypal = $this->Paypal->GetShippingDetails($token);

		$ack = strtoupper($paypal["ACK"]);
		if($ack == "SUCCESS" || $ack == "SUCESSWITHWARNING") {
			$this->Session->write('Shop.Paypal.Details', $paypal);
			$this->redirect(array('action' => 'confirmed'));
		} else {
			$ErrorCode = urldecode($paypal["L_ERRORCODE0"]);
			$ErrorShortMsg = urldecode($paypal["L_SHORTMESSAGE0"]);
			$ErrorLongMsg = urldecode($paypal["L_LONGMESSAGE0"]);
			$ErrorSeverityCode = urldecode($paypal["L_SEVERITYCODE0"]);
			echo "GetExpressCheckoutDetails API call failed. ";
			echo "Detailed Error Message: " . $ErrorLongMsg;
			echo "Short Error Message: " . $ErrorShortMsg;
			echo "Error Code: " . $ErrorCode;
			echo "Error Severity Code: " . $ErrorSeverityCode;
			die();
		}

	}

//////////////////////////////////////////////////

	public function review() {
		$shop = $this->Session->read('Shop');		
		if(empty($shop)) {
			$this->redirect('/');
		}		
		
		if ($this->request->is('post')) {						
			$this->loadModel('Order');
			$this->Order->set($this->request->data);
			$this->redirect('/shop/step1');
		 
			/*Below Line Commented By Ashwin*/
			/*
			if($this->Order->validates()) {
				$order = $shop;
				$order['Order']['status'] = 1;
			*/
			/*End Commented*/	
		}

		$this->set(compact('shop'));
		
	}

//////////////////////////////////////////////////

	public function confirmed() {
		$shop = $this->Session->read('Shop');
		
		if ($this->request->is('post')) {
			
			$order = $shop;
			//$order['Order']['status'] = ORDER_STATUS_PENDING;
			$order['Order']['status'] = 2;
			
			if($shop['Order']['order_type'] == 'paypal') {															
				$paypal = $this->Paypal->ConfirmPayment($order['Order']['total']);					
				$ack = strtoupper($paypal['ACK']);
				if($ack == 'SUCCESS' || $ack == 'SUCCESSWITHWARNING') {
					$order['Order']['status'] = 1;
				}
				$order['Order']['authorization'] = $paypal['ACK'];
				if(isset($paypal['PAYMENTINFO_0_TRANSACTIONID']))
					$order['Order']['transaction'] = $paypal['PAYMENTINFO_0_TRANSACTIONID'];
			}
			
			foreach ($order['ProductAttribute'] as $k=>$v) {
				foreach ($v as $key=>$value) {
					$order['ProductAttribute'][$k][$key]['order_series']=$key;
				}
			}
			//$save = $this->Order->saveAll($order);
			$save = $this->Order->saveAll($order, array('validate' => 'first'));
			if($save) {
				$this->Session->write('Order.order_id', $this->Order->id);
				$this->set(compact('shop'));
				
				App::uses('CakeEmail', 'Network/Email');
				/*
				$email = new CakeEmail();
				$email->from(Configure::read('Settings.ADMIN_EMAIL'))
						->cc(Configure::read('Settings.ADMIN_EMAIL'))
						->to($shop['Order']['email'])
						->subject('Shop Order')
						->template('order')
						->emailFormat('text')
						->viewVars(array('shop' => $shop))
						->send();
				*/		
				
				//clear the cart as the payment is successfull
				$this->Cart->clear();
				
				$this->redirect(array('action' => 'success'));
			} else {
				$errors = $this->Order->invalidFields();
				$this->set(compact('errors'));
			}
		}
		
		$this->set(compact('shop'));
	}	

//////////////////////////////////////////////////

	public function success() {
		$shop = $this->Session->read('Shop');
		$this->Cart->clear();
		if(empty($shop)) {
			$this->redirect(array('action' => 'thankyou'));
		}
		$this->set(compact('shop'));
	}
//////////////////////////////////////////////////


	public function thankyou() {
		$order = $this->Session->read('Order');
		$this->loadModel('OrderUploadedDoc');
		if (($this->request->is('post') || $this->request->is('put')) && !empty($this->request->data['OrderUploadedDoc']['image']['tmp_name']) && is_uploaded_file($this->request->data['OrderUploadedDoc']['image']['tmp_name'])) {

			$extension = pathinfo($this->request->data['OrderUploadedDoc']['image']['name'], PATHINFO_EXTENSION);
			$newfileName='order-'.$this->request->data['OrderUploadedDoc']['order_id'].'.'.$extension;
			$targetdir = WWW_ROOT . 'order_images/';

			if(move_uploaded_file($this->data['OrderUploadedDoc']['image']['tmp_name'], $targetdir.$newfileName)) {
				$this->request->data['OrderUploadedDoc']['upload_doc'] = $newfileName;
				if ($this->OrderUploadedDoc->save($this->request->data)) {
					$this->Session->delete('Order');
					$this->request->data['OrderUploadedDoc']['image'] = '';
					$this->Session->setFlash(__('File upload successfully.'));
				} else {
					$this->Session->setFlash(__('There is a problem in upload. Please, try again.'));
				}
			}else{
				$this->Session->setFlash(__('There is a problem in upload.'));
			}
			
		}
		
		$this->set('order_id',$order['order_id']);
	}

}
