<?php
App::uses('AppController', 'Controller');
class ProductAttributeController extends AppController {

public $uses = array('ProductAttribute','ProductAttributeValue');
public $helpers = array('InPlaceEditing.InPlaceEditing');
public $components = array('Session', 'RequestHandler');

	 public function beforeRender() {
        if($this->RequestHandler->isAjax() || $this->RequestHandler->isXml()) {  
  			Configure::write('debug', 0);
		}
    }

////////////////////////////////////////////////////////////	

	public function admin_index() {
		$this->ProductAttribute->recursive = -1;
		$this->set('ProductAttributes', $this->paginate());
	}

////////////////////////////////////////////////////////////

	public function admin_add() {
		if ($this->request->is('post')) {
			$this->ProductAttribute->create();
			if ($this->ProductAttribute->save($this->request->data)) {
				$this->Session->setFlash(__('The ProductAttribute has been saved'));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The ProductAttribute could not be saved. Please, try again.'));
			}
		}
	}

////////////////////////////////////////////////////////////

	public function admin_edit($id = null) {
		if (!$this->ProductAttribute->exists($id)) {
			throw new NotFoundException(__('Invalid ProductAttribute'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->ProductAttribute->id = $id;
			if ($this->ProductAttribute->save($this->request->data)) {
				$this->Session->setFlash(__('The ProductAttribute has been saved'));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The ProductAttribute could not be saved. Please, try again.'));
			}
		} else {
			$options = array('conditions' => array('ProductAttribute.' . $this->ProductAttribute->primaryKey => $id));
			$this->request->data = $this->ProductAttribute->find('first', $options);
		}
	}

////////////////////////////////////////////////////////////

	public function admin_delete($id = null) {
		$this->ProductAttribute->id = $id;
		if (!$this->ProductAttribute->exists()) {
			throw new NotFoundException(__('Invalid ProductAttribute'));
		}
		$this->request->onlyAllow('post', 'delete');
		if ($this->ProductAttribute->delete()) {			
			$this->ProductAttributeValue->deleteAll(array('ProductAttributeValue.product_attribute_id' => $id), false);						
			$this->Session->setFlash(__('ProductAttribute deleted'));
			$this->redirect(array('action' => 'index'));
		}
		$this->Session->setFlash(__('ProductAttribute was not deleted'));
		$this->redirect(array('action' => 'index'));
	}

////////////////////////////////////////////////////////////

	public function admin_indexattributevalue($id = null) {
		$this->ProductAttribute->id = $id;
		if (!$this->ProductAttribute->exists()) {
			throw new NotFoundException(__('Product Attribute not found!'));
		}												
		if ($this->request->is('post')) {
			$this->ProductAttributeValue->create();
			//pr($this->request->data);exit;
			if ($this->ProductAttributeValue->save($this->request->data)) {
				$this->Session->setFlash(__('The ProductAttributeValue has been saved'));
				$this->redirect(array('action' => 'indexattributevalue',$id));
			} else {
				$this->Session->setFlash(__('The ProductAttributeValue could not be saved. Please, try again.'));
			}
		}
		
		//get attribute-info of attribute 		
		$this->set('productattributeinfo', $this->ProductAttribute->findById($id) );
		//get attribute-values of specific attribute 
		$this->paginate = array(			
			'recursive' => -1,
			'limit' => 10,
			'conditions' => array('ProductAttributeValue.product_attribute_id' => $id),						
		);
		$this->set('ProductAttributeValues', $this->paginate('ProductAttributeValue'));								
		$this->set('product_attribute_id', $id);
	}
	
////////////////////////////////////////////////////////////

	public function admin_deleteattributevalue($id = null, $attribute_id = null) {
		$this->ProductAttributeValue->id = $id;
		if (!$this->ProductAttributeValue->exists()) {
			throw new NotFoundException(__('Invalid ProductAttributeValue'));
		}
		$this->request->onlyAllow('post', 'delete');
		if ($this->ProductAttributeValue->delete()) {
			$this->Session->setFlash(__('ProductAttributeValue deleted'));
			$this->redirect(array('action' => 'indexattributevalue',$attribute_id));
		}
		$this->Session->setFlash(__('ProductAttributeValue was not deleted'));
		$this->redirect(array('action' => 'indexattributevalue',$attribute_id));
	}	


////////////////////////////////////////////////////////////

	public function admin_edit_in_place($id = null) {

    	if (!$id) return;
		if ($this->request->data) {
		    # get all the fields with its values (there should be only one, but anyway ...)
		    foreach($this->data['ProductAttributeValue'] as $field => $value)
		    {
		      $this->ProductAttributeValue->id = $id;
		      $this->ProductAttributeValue->saveField($field, $value);
		
		      $this->set('updated_value', $value);
		      $this->beforeRender(); 
		      $this->layout = 'ajax';
		    }
		  }
	}

}