<?php
App::uses('AppController', 'Controller');
class OrdersController extends AppController {

////////////////////////////////////////////////////////////	
	
	public $uses = array('Order', 'OrderProductAttributeReference', 'ProductAttributeValue', 'ProductAttribute','OrderUploadedDoc');

////////////////////////////////////////////////////////////

	public function admin_index() {
		$this->Order->recursive = 0;
		$this->set('orders', $this->paginate());
	}

////////////////////////////////////////////////////////////	
	
	public function admin_view($id = null) {
		$this->Order->id = $id;
		if (!$this->Order->exists()) {
			throw new NotFoundException(__('Invalid order'));
		}
		
		$order = $this->Order->find('first', array(
			'recursive' => 2,
			'conditions' => array(
				'Order.id' => $id
			)
		));				
				
		$this->set(compact('order'));
	}

////////////////////////////////////////////////////////////
	
	/*public function admin_delete($id = null) {
		if (!$this->request->is('post')) {
			throw new MethodNotAllowedException();
		}
		$this->Order->id = $id;
		if (!$this->Order->exists()) {
			throw new NotFoundException(__('Invalid order'));
		}
		if ($this->Order->delete()) {
			$this->Session->setFlash(__('Order deleted'));
			$this->redirect(array('action'=>'index'));
		}
		$this->Session->setFlash(__('Order was not deleted'));
		$this->redirect(array('action' => 'index'));
	}*/
	
////////////////////////////////////////////////////////////	

	public function admin_downloadfile($filename) {
		$this->autoRender = false; // tell CakePHP that we don't need any view rendering in this case
	    $this->response->file(WWW_ROOT. DS . '/order_images/' . $filename, array('download' => true));
	}

/////////////////////////////////////////////////////////////

}
