<?php
App::uses('AppController', 'Controller');
class CouponsController extends AppController {

/**
 * Controller name
 *
 * @var string
 */
	public $name = 'Coupons';

/**
 * This controller does not use a model
 *
 * @var array
 */
	public $uses = array('Coupons','Order');
	
	
////////////////////////////////////////////////////////////

	public function beforeFilter() {
		parent::beforeFilter();				
		$couponcounters = $this->Order->find('list' ,array('fields' => array('Order.coupon_code')) );		
		$this->set(compact('couponcounters'));
	}

////////////////////////////////////////////////////////////

	public function admin_index() {		
		$this->Coupons->recursive = -1;
		$this->set('coupons', $this->paginate());
	}
	
////////////////////////////////////////////////////////////

	public function admin_add() {
		if ($this->request->is('post')) {
			$this->Coupons->create();
			if ($this->Coupons->save($this->request->data)) {
				$this->Session->setFlash(__('The Coupon has been saved'));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The Coupon could not be saved. Please, try again.'));
			}
		}				
	}
	
////////////////////////////////////////////////////////////

	public function admin_edit($id = null) {
		if (!$this->Coupons->exists($id)) {
			throw new NotFoundException(__('Invalid Coupon'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->Coupons->id = $id;
			if ($this->Coupons->save($this->request->data)) {
				$this->Session->setFlash(__('The Coupon has been saved'));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The Coupon could not be saved. Please, try again.'));
			}
		} else {
			$options = array('conditions' => array('Coupons.' . $this->Coupons->primaryKey => $id));
			$this->request->data = $this->Coupons->find('first', $options);
		}
	}	

////////////////////////////////////////////////////////////

	public function admin_delete($id = null) {
		if (!$this->request->is('post')) {
			throw new MethodNotAllowedException();
		}
		$this->Coupons->id = $id;
		if (!$this->Coupons->exists()) {
			throw new NotFoundException(__('Invalid Coupon'));
		}
		if ($this->Coupons->delete()) {
			$this->Session->setFlash(__('Coupon deleted'));
			$this->redirect(array('action'=>'index'));
		}
		$this->Session->setFlash(__('Coupon was not deleted'));
		$this->redirect(array('action' => 'index'));
	}

////////////////////////////////////////////////////////////

}
