<?php
class CartComponent extends Component {

//////////////////////////////////////////////////

	public $components = array('Session');

//////////////////////////////////////////////////

	public $controller;

//////////////////////////////////////////////////

	public function __construct(ComponentCollection $collection, $settings = array()) {
		$this->controller = $collection->getController();
		parent::__construct($collection, array_merge($this->settings, (array)$settings));
	}

//////////////////////////////////////////////////

	public function startup(Controller $controller) {
		//$this->controller = $controller;
	}

//////////////////////////////////////////////////

	public $maxQuantity = 99;

//////////////////////////////////////////////////

	public function add($id, $quantity = 1, $productattributes = array()) {
				
		if(!is_numeric($quantity)) {
			$quantity = 1;
		}

		$quantity = abs($quantity);

		if($quantity > $this->maxQuantity) {
			$quantity = $this->maxQuantity;
		}

		if($quantity == 0) {
			$this->remove($id);
			return;
		}

		$product = $this->controller->Product->find('first', array(
			'recursive' => -1,
			'conditions' => array(
				'Product.id' => $id
			)
		));
		if(empty($product)) {
			return false;
		}

		$data['product_id'] = $product['Product']['id'];								
		$data['name'] = $product['Product']['name'];
		$data['price'] = $product['Product']['price'];
		$data['quantity'] = $quantity;
		$data['subtotal'] = sprintf('%01.2f', $product['Product']['price'] * $quantity);
		$data['Product'] = $product['Product'];
		$this->Session->write('Shop.OrderItem.' . $id, $data);						
		$this->Session->write('Shop.Order.shop', 1);				
		foreach($productattributes as $key => $productArrData){
			foreach($productArrData as $attribute => $attributevalue){
				$this->Session->write('Shop.ProductAttribute.'.$product['Product']['id'].'.'.$key.'.'.$attribute, $attributevalue);
			}
		}		
		$this->Cart = ClassRegistry::init('Cart');

		$cartdata['Cart']['sessionid'] = $this->Session->id();
		$cartdata['Cart']['quantity'] = $quantity;
		$cartdata['Cart']['product_id'] = $product['Product']['id'];										
		$cartdata['Cart']['name'] = $product['Product']['name'];				
		$cartdata['Cart']['price'] = $product['Product']['price'];
		$cartdata['Cart']['subtotal'] = sprintf('%01.2f', $product['Product']['price'] * $quantity);

		$existing = $this->Cart->find('first', array(
			'recursive' => -1,
			'conditions' => array(
				'Cart.sessionid' => $this->Session->id(),
				'Cart.product_id' => $product['Product']['id'],
			)
		));
		if($existing) {
			$cartdata['Cart']['id'] = $existing['Cart']['id'];
		} else {
			$this->Cart->create();
		}
		$this->Cart->save($cartdata, false);

		$this->cart();

		return $product;
	}

//////////////////////////////////////////////////

	public function remove($id) {
		if($this->Session->check('Shop.OrderItem.' . $id)) {
			$product = $this->Session->read('Shop.OrderItem.' . $id);
			$this->Session->delete('Shop.OrderItem.' . $id);

			ClassRegistry::init('Cart')->deleteAll(
				array(
					'Cart.sessionid' => $this->Session->id(),
					'Cart.product_id' => $id,
				),
				false
			);

			$this->cart();
			return $product;
		}
		return false;
	}

//////////////////////////////////////////////////

	public function cart() {
		$shop = $this->Session->read('Shop');
		$quantity = 0;		
		$subtotal = 0;
		$total = 0;
		$order_item_count = 0;

		if (count($shop['OrderItem']) > 0) {
			foreach ($shop['OrderItem'] as $item) {
				$quantity += $item['quantity'];				
				$subtotal += $item['subtotal'];
				$total += $item['subtotal'];
				$order_item_count++;
			}
			$d['order_item_count'] = $order_item_count;
			$d['quantity'] = $quantity;			
			$d['subtotal'] = sprintf('%01.2f', $subtotal);
			$d['total'] = sprintf('%01.2f', $total);
			$this->Session->write('Shop.Order', $d + $shop['Order']);
			return true;
		}
		else {
			$d['quantity'] = 0;			
			$d['subtotal'] = 0;
			$d['total'] = 0;
			$this->Session->write('Shop.Order', $d + $shop['Order']);
			return false;
		}
	}

//////////////////////////////////////////////////

	public function clear() {
		ClassRegistry::init('Cart')->deleteAll(array('Cart.sessionid' => $this->Session->id()), false);
		$this->Session->delete('Shop');
	}
		
//////////////////////////////////////////////////
	
	public function calc_coupon_discount($coupon_code = null) {		
		$flag = 0;
		$discount = 0;
		if( isset($coupon_code) ){
			$arrCoupon = $this->controller->Coupons->findByCode($coupon_code);
			$shop = $this->Session->read('Shop.Order');
			//pr($arrCoupon);pr($shop);exit;	
			if( !empty($arrCoupon) ){
				// Convert to timestamp
				$startDate = strtotime($arrCoupon['Coupons']['valid_from']);
				$endDate = strtotime($arrCoupon['Coupons']['valid_to']);
				$currDate = strtotime(date('Y-m-d'));					
				// Check that date is between start & end
				if ( ($currDate >= $startDate) && ($currDate <= $endDate) ){
					//check for total usage of coupon 
					$couponCount = $this->controller->Order->find('count', array('conditions' => array('Order.coupon_code' => $coupon_code)) );	
					if($couponCount <= $arrCoupon['Coupons']['max_usage']){
						//check for discount type												
						if( $arrCoupon['Coupons']['discount_type'] == '$' ){
							$discount = $arrCoupon['Coupons']['discount'];		
						} else if( $arrCoupon['Coupons']['discount_type'] == '%' ){							
							$discount = number_format(($shop['subtotal'] * $arrCoupon['Coupons']['discount'])/100, 2, '.', '');
						}												
					} else {
						$flag = 1;	
					}
				} else {
					$flag = 1;	
				}
																		
			} else {
				$flag = 1;
			}
		} else {
			$flag = 1;	
		}
		
		if( $flag == 0 ){
			$this->Session->write('Shop.Order.coupon_discount', sprintf('%01.2f' ,$discount) );
			$this->Session->write('Shop.Order.total', sprintf('%01.2f' ,$shop['subtotal'] - $discount) );	
		} else {
			$this->Session->write('Shop.Order.coupon_discount', sprintf('%01.2f' , 0.00) );
			$this->Session->write('Shop.Order.total', sprintf('%01.2f' ,$shop['subtotal']) );	
		}
					
	}

//////////////////////////////////////////////////

}
