<?php

class master_model extends CI_Model {

    function get_companies() {
        $this->db->select("*");
        $this->db->where('cust_status', 1);
        $this->db->order_by("cust_name",'ASC');
        $query = $this->db->get(TBL_CUSTOMER);
        return $query->result_array();
    }
    function get_engineer($comp_id) {
        $this->db->select("*");
        $this->db->where('cust_id', $comp_id);
        $this->db->order_by("eng_fname",'ASC');
        $query = $this->db->get(TBL_ENGINEER);
        return $query->result_array();
    }
    function get_engineer_email($eng_id) {
        $this->db->select("*");
        $this->db->where('eng_id', $eng_id);
        $query = $this->db->get(TBL_ENGINEER);
        $result = $query->row_array();
        return $result['eng_email'];
    }
    function get_p3reports() {
        $this->db->select('p.*,c.cust_name,e.eng_fname,eng_lname');
        $this->db->from('mst_p3report p');
        $this->db->join('tbl_customer c', 'c.cust_id = p.comp_id');
        $this->db->join('tbl_engineer e', 'e.eng_id = p.eng_id');
        // $this->db->where('o.line_item_no',$lineItemNo);
        $query = $this->db->get();
        return $query->result_array();
    }
    function insert_engineer($data) {
        $this->db->insert('mst_p3report', $data);
    }
    
    
}
