DROP TABLE IF EXISTS mst_application;

CREATE TABLE `mst_application` (
  `app_name` varchar(100) NOT NULL DEFAULT '',
  `app_client_id` double NOT NULL AUTO_INCREMENT,
  `app_client_name` varchar(100) DEFAULT NULL,
  `app_client_logo` varchar(50) DEFAULT NULL,
  `app_client_address` varchar(255) DEFAULT NULL,
  `app_client_phone` varchar(50) DEFAULT NULL,
  `app_client_email` varchar(50) DEFAULT NULL,
  `app_client_web` varchar(50) DEFAULT NULL,
  `app_client_validity` date DEFAULT NULL,
  `app_client_status` int(1) DEFAULT NULL,
  `app_page_title` varchar(50) DEFAULT NULL,
  `app_page_copyright` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`app_client_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO mst_application VALUES("WIMS - Beam On Order Tracking System","1","Beam On Technology","boots_logo2.png","2318 Calle De Luna\r\nSanta Clara, CA 95054.","4089820161","rajeshk@beamon.com","www.beamon.com","2013-12-31","1","WIMS - Beam On Order Tracking System","Beam On Technology");



DROP TABLE IF EXISTS mst_city;

CREATE TABLE `mst_city` (
  `city_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `state_id` int(11) unsigned DEFAULT NULL,
  `city_name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`city_id`),
  UNIQUE KEY `id` (`city_id`),
  KEY `id_2` (`city_id`),
  KEY `city` (`city_name`)
) ENGINE=MyISAM AUTO_INCREMENT=222 DEFAULT CHARSET=latin1;

INSERT INTO mst_city VALUES("1","1","Anantapur");
INSERT INTO mst_city VALUES("2","1","Guntakal");
INSERT INTO mst_city VALUES("3","1","Guntur");
INSERT INTO mst_city VALUES("4","1","Hyderabad");
INSERT INTO mst_city VALUES("5","1","Secunderabad");
INSERT INTO mst_city VALUES("6","1","Kakinada");
INSERT INTO mst_city VALUES("7","1","Kurnool");
INSERT INTO mst_city VALUES("8","1","Nellore");
INSERT INTO mst_city VALUES("9","1","Nizamabad");
INSERT INTO mst_city VALUES("10","1","Rajahmundry");
INSERT INTO mst_city VALUES("11","1","Tirupati");
INSERT INTO mst_city VALUES("12","1","Vijayawada");
INSERT INTO mst_city VALUES("13","1","Visakhapatnam");
INSERT INTO mst_city VALUES("14","1","Warangal");
INSERT INTO mst_city VALUES("15","1","Itanagar");
INSERT INTO mst_city VALUES("16","3","Cuwahati");
INSERT INTO mst_city VALUES("17","3","Silchar");
INSERT INTO mst_city VALUES("18","4","Bahgalpur");
INSERT INTO mst_city VALUES("19","4","Patna");
INSERT INTO mst_city VALUES("20","5","Bhillai");
INSERT INTO mst_city VALUES("21","6","Bilaspur");
INSERT INTO mst_city VALUES("22","6","Raipur");
INSERT INTO mst_city VALUES("23","7","Amli");
INSERT INTO mst_city VALUES("24","7","Naroli");
INSERT INTO mst_city VALUES("25","7","Silvassa");
INSERT INTO mst_city VALUES("26","8","Daman");
INSERT INTO mst_city VALUES("27","8","Diu");
INSERT INTO mst_city VALUES("28","8","Moti");
INSERT INTO mst_city VALUES("29","8","Daman");
INSERT INTO mst_city VALUES("30","10","Vasco Da Gama");
INSERT INTO mst_city VALUES("31","10","Panaji");
INSERT INTO mst_city VALUES("32","11","Ahmedabad");
INSERT INTO mst_city VALUES("34","11","Anand");
INSERT INTO mst_city VALUES("35","11","Ankleshwar");
INSERT INTO mst_city VALUES("36","11","Bharuch");
INSERT INTO mst_city VALUES("38","11","Bhavnagar");
INSERT INTO mst_city VALUES("39","11","Bhuj");
INSERT INTO mst_city VALUES("40","11","Gandhinagar");
INSERT INTO mst_city VALUES("41","11","Gir");
INSERT INTO mst_city VALUES("42","11","Jamnagar");
INSERT INTO mst_city VALUES("43","11","Kandla");
INSERT INTO mst_city VALUES("44","11","Porbandar");
INSERT INTO mst_city VALUES("45","11","Rajkot");
INSERT INTO mst_city VALUES("46","11","Surat");
INSERT INTO mst_city VALUES("47","11","Vadodara/Baroda");
INSERT INTO mst_city VALUES("48","11","Valsad");
INSERT INTO mst_city VALUES("49","11","Vapi");
INSERT INTO mst_city VALUES("50","13","Dalhousie");
INSERT INTO mst_city VALUES("51","13","Dharmasala");
INSERT INTO mst_city VALUES("52","13","Kulu/Manali");
INSERT INTO mst_city VALUES("53","13","Shimla");
INSERT INTO mst_city VALUES("54","14","Jammu");
INSERT INTO mst_city VALUES("55","14","Srinagar");
INSERT INTO mst_city VALUES("56","15","Bokaro");
INSERT INTO mst_city VALUES("57","15","Dhanbad");
INSERT INTO mst_city VALUES("58","15","Jamshedpur");
INSERT INTO mst_city VALUES("59","15","Ranchi");
INSERT INTO mst_city VALUES("60","16","Bengalore");
INSERT INTO mst_city VALUES("61","16","Belgaum");
INSERT INTO mst_city VALUES("62","16","Bellary");
INSERT INTO mst_city VALUES("63","16","Bidar");
INSERT INTO mst_city VALUES("64","16","Dharwad");
INSERT INTO mst_city VALUES("65","16","Gulbarga");
INSERT INTO mst_city VALUES("66","16","Hubi");
INSERT INTO mst_city VALUES("67","16","Kolar");
INSERT INTO mst_city VALUES("68","16","Mangalore");
INSERT INTO mst_city VALUES("69","16","Mysore");
INSERT INTO mst_city VALUES("70","17","Alappuzha");
INSERT INTO mst_city VALUES("71","17","Calicut");
INSERT INTO mst_city VALUES("72","17","Cochin");
INSERT INTO mst_city VALUES("73","17","Ernakulam");
INSERT INTO mst_city VALUES("74","17","Kannur");
INSERT INTO mst_city VALUES("75","17","Kochi");
INSERT INTO mst_city VALUES("76","17","Kollam");
INSERT INTO mst_city VALUES("77","17","Kozhikode");
INSERT INTO mst_city VALUES("78","17","Kottayam");
INSERT INTO mst_city VALUES("79","17","Malappuram");
INSERT INTO mst_city VALUES("80","17","Palakkad");
INSERT INTO mst_city VALUES("81","17","Palghat");
INSERT INTO mst_city VALUES("82","17","Thrissur");
INSERT INTO mst_city VALUES("83","17","Thalassery");
INSERT INTO mst_city VALUES("84","17","Thruvananthapuram");
INSERT INTO mst_city VALUES("85","17","LakshadweepIsland");
INSERT INTO mst_city VALUES("86","17","Amini");
INSERT INTO mst_city VALUES("87","17","Kavaratti");
INSERT INTO mst_city VALUES("88","17","Minicoy");
INSERT INTO mst_city VALUES("89","19","Bhopal");
INSERT INTO mst_city VALUES("90","19","Gwalior");
INSERT INTO mst_city VALUES("91","19","Indore");
INSERT INTO mst_city VALUES("92","19","Jabalpur");
INSERT INTO mst_city VALUES("93","19","Ujjain");
INSERT INTO mst_city VALUES("94","20","Ahmednagar");
INSERT INTO mst_city VALUES("95","20","Aurangabad");
INSERT INTO mst_city VALUES("96","20","Jalgaon");
INSERT INTO mst_city VALUES("97","20","Kolhapur");
INSERT INTO mst_city VALUES("98","20","Mumbai");
INSERT INTO mst_city VALUES("101","20","Mumbai Sububs");
INSERT INTO mst_city VALUES("102","20","Nagpur");
INSERT INTO mst_city VALUES("103","20","Nasik");
INSERT INTO mst_city VALUES("104","20","Navi Mumbai");
INSERT INTO mst_city VALUES("105","20","Pune");
INSERT INTO mst_city VALUES("106","20","Solapur");
INSERT INTO mst_city VALUES("107","21","Imphal");
INSERT INTO mst_city VALUES("108","22","Shillong");
INSERT INTO mst_city VALUES("109","23","Aizawal");
INSERT INTO mst_city VALUES("110","24","Dimapur");
INSERT INTO mst_city VALUES("111","25","Bhubaneshwar");
INSERT INTO mst_city VALUES("112","25","Cuttack");
INSERT INTO mst_city VALUES("113","25","Paradeep");
INSERT INTO mst_city VALUES("114","25","Puri");
INSERT INTO mst_city VALUES("115","25","Rourkela");
INSERT INTO mst_city VALUES("116","27","Amristsar");
INSERT INTO mst_city VALUES("117","27","Bathinda");
INSERT INTO mst_city VALUES("118","27","Chandigarh");
INSERT INTO mst_city VALUES("119","27","Jalandhar");
INSERT INTO mst_city VALUES("120","27","Ludhiana");
INSERT INTO mst_city VALUES("121","27","Mohali");
INSERT INTO mst_city VALUES("122","27","Pathankot");
INSERT INTO mst_city VALUES("123","27","Patiala");
INSERT INTO mst_city VALUES("124","28","Ajmer");
INSERT INTO mst_city VALUES("125","28","Jaipur");
INSERT INTO mst_city VALUES("126","28","Jaisalmer");
INSERT INTO mst_city VALUES("127","28","Jodhpur");
INSERT INTO mst_city VALUES("128","28","Kota");
INSERT INTO mst_city VALUES("129","28","Udaipur");
INSERT INTO mst_city VALUES("130","29","Gangtok");
INSERT INTO mst_city VALUES("131","30","Chennai");
INSERT INTO mst_city VALUES("132","30","Coimbatore");
INSERT INTO mst_city VALUES("133","30","Chengalpattu");
INSERT INTO mst_city VALUES("134","30","Chidamparam");
INSERT INTO mst_city VALUES("135","30","Cuddalore");
INSERT INTO mst_city VALUES("136","30","Dharmapuri");
INSERT INTO mst_city VALUES("137","30","Dindigul");
INSERT INTO mst_city VALUES("138","30","Erode");
INSERT INTO mst_city VALUES("139","30","Gopichettipalayam");
INSERT INTO mst_city VALUES("140","30","Hosur");
INSERT INTO mst_city VALUES("141","30","Karur");
INSERT INTO mst_city VALUES("142","30","Kancheepuram");
INSERT INTO mst_city VALUES("143","30","Kanniakumari");
INSERT INTO mst_city VALUES("144","30","Karaikkudi");
INSERT INTO mst_city VALUES("145","30","Kodaikanal");
INSERT INTO mst_city VALUES("146","30","Kovilpatti");
INSERT INTO mst_city VALUES("147","30","Krishnagiri");
INSERT INTO mst_city VALUES("148","30","Madurai");
INSERT INTO mst_city VALUES("149","30","Manapparai");
INSERT INTO mst_city VALUES("150","30","Nagarcovil");
INSERT INTO mst_city VALUES("151","30","Namakkal");
INSERT INTO mst_city VALUES("152","30","Neyveli");
INSERT INTO mst_city VALUES("153","30","Ooty");
INSERT INTO mst_city VALUES("154","30","Palani");
INSERT INTO mst_city VALUES("155","30","Parambalur");
INSERT INTO mst_city VALUES("156","30","Periyakulam");
INSERT INTO mst_city VALUES("157","30","Pollachi");
INSERT INTO mst_city VALUES("158","30","Pudukkottai");
INSERT INTO mst_city VALUES("159","30","Rajapalayam");
INSERT INTO mst_city VALUES("160","30","Salem");
INSERT INTO mst_city VALUES("161","30","Sathyamangalam");
INSERT INTO mst_city VALUES("162","30","Sivagangai");
INSERT INTO mst_city VALUES("163","30","Sivakasi");
INSERT INTO mst_city VALUES("164","30","Tambaram");
INSERT INTO mst_city VALUES("165","30","Thanjavur");
INSERT INTO mst_city VALUES("166","30","Theni");
INSERT INTO mst_city VALUES("167","30","Thiruvallur");
INSERT INTO mst_city VALUES("168","30","Thoothukkudi");
INSERT INTO mst_city VALUES("169","30","Trichy");
INSERT INTO mst_city VALUES("170","30","Tirunelveli");
INSERT INTO mst_city VALUES("171","30","Tiruppur");
INSERT INTO mst_city VALUES("172","30","Tiruvannamalai");
INSERT INTO mst_city VALUES("173","30","Udhagamandalam");
INSERT INTO mst_city VALUES("174","30","Udumalaipettai");
INSERT INTO mst_city VALUES("175","30","Vellore");
INSERT INTO mst_city VALUES("176","30","Virudhunagar");
INSERT INTO mst_city VALUES("177","31","Agartala");
INSERT INTO mst_city VALUES("178","32","Agra");
INSERT INTO mst_city VALUES("179","32","Aligarh");
INSERT INTO mst_city VALUES("180","32","Allahabad");
INSERT INTO mst_city VALUES("181","32","Bareilly");
INSERT INTO mst_city VALUES("182","32","Faizabad");
INSERT INTO mst_city VALUES("183","32","Ghaziabad");
INSERT INTO mst_city VALUES("184","32","Gorakhpur");
INSERT INTO mst_city VALUES("185","32","Kanpur");
INSERT INTO mst_city VALUES("186","32","Lucknow");
INSERT INTO mst_city VALUES("187","32","Mathura");
INSERT INTO mst_city VALUES("188","32","Meerut");
INSERT INTO mst_city VALUES("189","32","Moradabad");
INSERT INTO mst_city VALUES("190","32","Noida");
INSERT INTO mst_city VALUES("191","32","Varanasi");
INSERT INTO mst_city VALUES("192","32","Banaras");
INSERT INTO mst_city VALUES("193","33","Dehradun");
INSERT INTO mst_city VALUES("194","33","Roorkee");
INSERT INTO mst_city VALUES("195","34","Asansol");
INSERT INTO mst_city VALUES("196","34","Durgapur");
INSERT INTO mst_city VALUES("197","34","Haldia");
INSERT INTO mst_city VALUES("198","34","Kharagpur");
INSERT INTO mst_city VALUES("199","34","Kolkata");
INSERT INTO mst_city VALUES("200","34","Siliguri");
INSERT INTO mst_city VALUES("201","35","Bombooflat");
INSERT INTO mst_city VALUES("202","35","Car Nicobar");
INSERT INTO mst_city VALUES("203","35","Garacharma");
INSERT INTO mst_city VALUES("204","35","Port Blair");
INSERT INTO mst_city VALUES("205","5","Chandigarh");
INSERT INTO mst_city VALUES("206","9","Delhi");
INSERT INTO mst_city VALUES("207","30","Bhavani");
INSERT INTO mst_city VALUES("208","30","Villupuram");
INSERT INTO mst_city VALUES("209","30","Thiruvarur");
INSERT INTO mst_city VALUES("210","30","Mayiladuthurai");
INSERT INTO mst_city VALUES("211","30","Thiruvizhanthur");
INSERT INTO mst_city VALUES("212","30","Jeyangkondam");
INSERT INTO mst_city VALUES("213","30","Ariyalur");
INSERT INTO mst_city VALUES("214","30","Keelapperumpallam");
INSERT INTO mst_city VALUES("215","30","Thenpathi");
INSERT INTO mst_city VALUES("216","30","Sirkazhi");
INSERT INTO mst_city VALUES("217","30","Kumbakonam");
INSERT INTO mst_city VALUES("218","30","Nagapattinam");
INSERT INTO mst_city VALUES("219","1","Chinoutpalli");
INSERT INTO mst_city VALUES("220","16","bellur");
INSERT INTO mst_city VALUES("221","16","Davangere");



DROP TABLE IF EXISTS mst_country;

CREATE TABLE `mst_country` (
  `country_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `country_name` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`country_id`),
  UNIQUE KEY `id` (`country_id`),
  KEY `id_2` (`country_id`),
  KEY `country` (`country_name`)
) ENGINE=MyISAM AUTO_INCREMENT=241 DEFAULT CHARSET=latin1;

INSERT INTO mst_country VALUES("5","Argentina");
INSERT INTO mst_country VALUES("6","Australia");
INSERT INTO mst_country VALUES("7","Austria");
INSERT INTO mst_country VALUES("8","Belgium");
INSERT INTO mst_country VALUES("9","Brazil");
INSERT INTO mst_country VALUES("2","Canada");
INSERT INTO mst_country VALUES("10","China");
INSERT INTO mst_country VALUES("11","France");
INSERT INTO mst_country VALUES("12","Germany");
INSERT INTO mst_country VALUES("13","Hong Kong");
INSERT INTO mst_country VALUES("1","India");
INSERT INTO mst_country VALUES("14","Ireland");
INSERT INTO mst_country VALUES("15","Korea");
INSERT INTO mst_country VALUES("16","Malaysia");
INSERT INTO mst_country VALUES("17","Mexico");
INSERT INTO mst_country VALUES("18","Netherland");
INSERT INTO mst_country VALUES("19","New Zealand");
INSERT INTO mst_country VALUES("20","Philippines");
INSERT INTO mst_country VALUES("21","Poland");
INSERT INTO mst_country VALUES("30","Republic of Macedonia");
INSERT INTO mst_country VALUES("22","Singapore");
INSERT INTO mst_country VALUES("23","Spain");
INSERT INTO mst_country VALUES("24","Swedon");
INSERT INTO mst_country VALUES("25","Switzerland");
INSERT INTO mst_country VALUES("26","Taiwan");
INSERT INTO mst_country VALUES("27","Thailand");
INSERT INTO mst_country VALUES("28","Turkey");
INSERT INTO mst_country VALUES("29","United Arab Emirates (UAE)");
INSERT INTO mst_country VALUES("3","United Kingdom");
INSERT INTO mst_country VALUES("4","United States");
INSERT INTO mst_country VALUES("31","Afghanistan");
INSERT INTO mst_country VALUES("32","Albania");
INSERT INTO mst_country VALUES("33","Algeria");
INSERT INTO mst_country VALUES("34","American Samoa");
INSERT INTO mst_country VALUES("35","Andorra");
INSERT INTO mst_country VALUES("36","Angola");
INSERT INTO mst_country VALUES("37","Anguilla");
INSERT INTO mst_country VALUES("38","Antarctica");
INSERT INTO mst_country VALUES("39","Antigua and Barbuda");
INSERT INTO mst_country VALUES("40","Armenia");
INSERT INTO mst_country VALUES("41","Aruba");
INSERT INTO mst_country VALUES("42","Azerbaijan");
INSERT INTO mst_country VALUES("43","Bahamas");
INSERT INTO mst_country VALUES("44","Bahrain");
INSERT INTO mst_country VALUES("45","Bangladesh");
INSERT INTO mst_country VALUES("46","Barbados");
INSERT INTO mst_country VALUES("47","Belarus");
INSERT INTO mst_country VALUES("48","Belize");
INSERT INTO mst_country VALUES("49","Benin");
INSERT INTO mst_country VALUES("50","Bermuda");
INSERT INTO mst_country VALUES("51","Bhutan");
INSERT INTO mst_country VALUES("52","Bolivia");
INSERT INTO mst_country VALUES("53","Bosnia and Herzegowina");
INSERT INTO mst_country VALUES("54","Botswana");
INSERT INTO mst_country VALUES("55","Bouvet Island");
INSERT INTO mst_country VALUES("56","British Indian Ocean Territory");
INSERT INTO mst_country VALUES("57","Brunei Darussalam");
INSERT INTO mst_country VALUES("58","Bulgaria");
INSERT INTO mst_country VALUES("59","Burkina Faso");
INSERT INTO mst_country VALUES("60","Burundi");
INSERT INTO mst_country VALUES("61","Cambodia");
INSERT INTO mst_country VALUES("62","Cameroon");
INSERT INTO mst_country VALUES("63","Cape Verde");
INSERT INTO mst_country VALUES("64","Cayman Islands");
INSERT INTO mst_country VALUES("65","Central African Republic");
INSERT INTO mst_country VALUES("66","Chad");
INSERT INTO mst_country VALUES("67","Chile");
INSERT INTO mst_country VALUES("68","Christmas Island");
INSERT INTO mst_country VALUES("69","Cocos (Keeling) Islands");
INSERT INTO mst_country VALUES("70","Colombia");
INSERT INTO mst_country VALUES("71","Comoros");
INSERT INTO mst_country VALUES("72","Congo");
INSERT INTO mst_country VALUES("73","Cook Islands");
INSERT INTO mst_country VALUES("74","Costa Rica");
INSERT INTO mst_country VALUES("75","Cote D&rsquo;Ivoire");
INSERT INTO mst_country VALUES("76","Croatia");
INSERT INTO mst_country VALUES("77","Cuba");
INSERT INTO mst_country VALUES("78","Cyprus");
INSERT INTO mst_country VALUES("79","Czech Republic");
INSERT INTO mst_country VALUES("80","Denmark");
INSERT INTO mst_country VALUES("81","Djibouti");
INSERT INTO mst_country VALUES("82","Dominica");
INSERT INTO mst_country VALUES("83","Dominican Republic");
INSERT INTO mst_country VALUES("84","East Timor");
INSERT INTO mst_country VALUES("85","Ecuador");
INSERT INTO mst_country VALUES("86","Egypt");
INSERT INTO mst_country VALUES("87","El Salvador");
INSERT INTO mst_country VALUES("88","Equatorial Guinea");
INSERT INTO mst_country VALUES("89","Eritrea");
INSERT INTO mst_country VALUES("90","Estonia");
INSERT INTO mst_country VALUES("91","Ethiopia");
INSERT INTO mst_country VALUES("92","Falkland Islands (Malvinas)");
INSERT INTO mst_country VALUES("93","Faroe Islands");
INSERT INTO mst_country VALUES("94","Fiji");
INSERT INTO mst_country VALUES("95","Finland");
INSERT INTO mst_country VALUES("96","French Guiana");
INSERT INTO mst_country VALUES("97","French Polynesia");
INSERT INTO mst_country VALUES("98","French Southern Territories");
INSERT INTO mst_country VALUES("99","Gabon");
INSERT INTO mst_country VALUES("100","Gambia");
INSERT INTO mst_country VALUES("101","Georgia");
INSERT INTO mst_country VALUES("102","Ghana");
INSERT INTO mst_country VALUES("103","Gibraltar");
INSERT INTO mst_country VALUES("104","Greece");
INSERT INTO mst_country VALUES("105","Greenland");
INSERT INTO mst_country VALUES("106","Grenada");
INSERT INTO mst_country VALUES("107","Guadeloupe");
INSERT INTO mst_country VALUES("108","Guam");
INSERT INTO mst_country VALUES("109","Guatemala");
INSERT INTO mst_country VALUES("110","Guinea");
INSERT INTO mst_country VALUES("111","Guinea-bissau");
INSERT INTO mst_country VALUES("112","Guyana");
INSERT INTO mst_country VALUES("113","Haiti");
INSERT INTO mst_country VALUES("114","Heard and Mc Donald Islands");
INSERT INTO mst_country VALUES("115","Honduras");
INSERT INTO mst_country VALUES("116","Hungary");
INSERT INTO mst_country VALUES("117","Iceland");
INSERT INTO mst_country VALUES("118","Indonesia");
INSERT INTO mst_country VALUES("119","Iran");
INSERT INTO mst_country VALUES("120","Iraq");
INSERT INTO mst_country VALUES("121","Israel");
INSERT INTO mst_country VALUES("122","Italy");
INSERT INTO mst_country VALUES("123","Jamaica");
INSERT INTO mst_country VALUES("124","Japan");
INSERT INTO mst_country VALUES("125","Jordan");
INSERT INTO mst_country VALUES("126","Kazakhstan");
INSERT INTO mst_country VALUES("127","Kenya");
INSERT INTO mst_country VALUES("128","Kiribati");
INSERT INTO mst_country VALUES("129","Kuwait");
INSERT INTO mst_country VALUES("130","Kyrgyzstan");
INSERT INTO mst_country VALUES("131","Latvia");
INSERT INTO mst_country VALUES("132","Lebanon");
INSERT INTO mst_country VALUES("133","Lesotho");
INSERT INTO mst_country VALUES("134","Liberia");
INSERT INTO mst_country VALUES("135","Libyan Arab Jamahiriya");
INSERT INTO mst_country VALUES("136","Liechtenstein");
INSERT INTO mst_country VALUES("137","Lithuania");
INSERT INTO mst_country VALUES("138","Luxembourg");
INSERT INTO mst_country VALUES("139","Macau");
INSERT INTO mst_country VALUES("140","Macedonia");
INSERT INTO mst_country VALUES("141","Madagascar");
INSERT INTO mst_country VALUES("142","Malawi");
INSERT INTO mst_country VALUES("143","Maldives");
INSERT INTO mst_country VALUES("144","Mali");
INSERT INTO mst_country VALUES("145","Malta");
INSERT INTO mst_country VALUES("146","Marshall Islands");
INSERT INTO mst_country VALUES("147","Martinique");
INSERT INTO mst_country VALUES("148","Mauritania");
INSERT INTO mst_country VALUES("149","Mauritius");
INSERT INTO mst_country VALUES("150","Mayotte");
INSERT INTO mst_country VALUES("151","Micronesia");
INSERT INTO mst_country VALUES("152","Moldova");
INSERT INTO mst_country VALUES("153","Monaco");
INSERT INTO mst_country VALUES("154","Mongolia");
INSERT INTO mst_country VALUES("155","Montserrat");
INSERT INTO mst_country VALUES("156","Morocco");
INSERT INTO mst_country VALUES("157","Mozambique");
INSERT INTO mst_country VALUES("158","Myanmar");
INSERT INTO mst_country VALUES("159","Namibia");
INSERT INTO mst_country VALUES("160","Nauru");
INSERT INTO mst_country VALUES("161","Nepal");
INSERT INTO mst_country VALUES("162","Netherlands Antilles");
INSERT INTO mst_country VALUES("163","New Caledonia");
INSERT INTO mst_country VALUES("164","Nicaragua");
INSERT INTO mst_country VALUES("165","Niger");
INSERT INTO mst_country VALUES("166","Nigeria");
INSERT INTO mst_country VALUES("167","Niue");
INSERT INTO mst_country VALUES("168","Norfolk Island");
INSERT INTO mst_country VALUES("169","Northern Mariana Islands");
INSERT INTO mst_country VALUES("170","Norway");
INSERT INTO mst_country VALUES("171","Oman");
INSERT INTO mst_country VALUES("172","Pakistan");
INSERT INTO mst_country VALUES("173","Palau");
INSERT INTO mst_country VALUES("174","Panama");
INSERT INTO mst_country VALUES("175","Papua New Guinea");
INSERT INTO mst_country VALUES("176","Paraguay");
INSERT INTO mst_country VALUES("177","Peru");
INSERT INTO mst_country VALUES("178","Pitcairn");
INSERT INTO mst_country VALUES("179","Portugal");
INSERT INTO mst_country VALUES("180","Puerto Rico");
INSERT INTO mst_country VALUES("181","Qatar");
INSERT INTO mst_country VALUES("182","Reunion");
INSERT INTO mst_country VALUES("183","Romania");
INSERT INTO mst_country VALUES("184","Russian Federation");
INSERT INTO mst_country VALUES("185","Rwanda");
INSERT INTO mst_country VALUES("186","Saint Kitts and Nevis");
INSERT INTO mst_country VALUES("187","Saint Lucia");
INSERT INTO mst_country VALUES("188","Saint Vincent and the Grenadin");
INSERT INTO mst_country VALUES("189","Samoa");
INSERT INTO mst_country VALUES("190","San Marino");
INSERT INTO mst_country VALUES("191","Sao Tome and Principe");
INSERT INTO mst_country VALUES("192","Saudi Arabia");
INSERT INTO mst_country VALUES("193","Senegal");
INSERT INTO mst_country VALUES("194","Seychelles");
INSERT INTO mst_country VALUES("195","Sierra Leone");
INSERT INTO mst_country VALUES("196","Slovakia (Slovak Republic)");
INSERT INTO mst_country VALUES("197","Slovenia");
INSERT INTO mst_country VALUES("198","Solomon Islands");
INSERT INTO mst_country VALUES("199","Somalia");
INSERT INTO mst_country VALUES("200","South Africa");
INSERT INTO mst_country VALUES("201","South Georgia");
INSERT INTO mst_country VALUES("202","South Sandwich Islands");
INSERT INTO mst_country VALUES("203","Sri Lanka");
INSERT INTO mst_country VALUES("204","St. Helena");
INSERT INTO mst_country VALUES("205","St. Pierre and Miquelon");
INSERT INTO mst_country VALUES("206","Sudan");
INSERT INTO mst_country VALUES("207","Suriname");
INSERT INTO mst_country VALUES("208","Svalbard and Jan Mayen Islands");
INSERT INTO mst_country VALUES("209","Swaziland");
INSERT INTO mst_country VALUES("210","Sweden");
INSERT INTO mst_country VALUES("211","Syrian Arab Republic");
INSERT INTO mst_country VALUES("212","Tajikistan");
INSERT INTO mst_country VALUES("213","Tanzania");
INSERT INTO mst_country VALUES("214","Togo");
INSERT INTO mst_country VALUES("215","Tokelau");
INSERT INTO mst_country VALUES("216","Tonga");
INSERT INTO mst_country VALUES("217","Trinidad and Tobago");
INSERT INTO mst_country VALUES("218","Tunisia");
INSERT INTO mst_country VALUES("219","Turkmenistan");
INSERT INTO mst_country VALUES("220","Turks and Caicos Islands");
INSERT INTO mst_country VALUES("221","Tuvalu");
INSERT INTO mst_country VALUES("222","Uganda");
INSERT INTO mst_country VALUES("223","Ukraine");
INSERT INTO mst_country VALUES("224","United Arab Emirates");
INSERT INTO mst_country VALUES("225","Minor Outlying Islands");
INSERT INTO mst_country VALUES("226","Uruguay");
INSERT INTO mst_country VALUES("227","Uzbekistan");
INSERT INTO mst_country VALUES("228","Vanuatu");
INSERT INTO mst_country VALUES("229","Vatican City State (Holy See)");
INSERT INTO mst_country VALUES("230","Venezuela");
INSERT INTO mst_country VALUES("231","Viet Nam");
INSERT INTO mst_country VALUES("232","Virgin Islands (British)");
INSERT INTO mst_country VALUES("233","Virgin Islands (U.S.)");
INSERT INTO mst_country VALUES("234","Wallis and Futuna Islands");
INSERT INTO mst_country VALUES("235","Western Sahara");
INSERT INTO mst_country VALUES("236","Yemen");
INSERT INTO mst_country VALUES("237","Yugoslavia");
INSERT INTO mst_country VALUES("238","Zaire");
INSERT INTO mst_country VALUES("239","Zambia");
INSERT INTO mst_country VALUES("240","Zimbabwe");



DROP TABLE IF EXISTS mst_divisions;

CREATE TABLE `mst_divisions` (
  `div_id` double NOT NULL AUTO_INCREMENT,
  `div_name` varchar(20) NOT NULL,
  `div_css_id` varchar(15) NOT NULL,
  PRIMARY KEY (`div_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO mst_divisions VALUES("1","Training Division","acc-training");
INSERT INTO mst_divisions VALUES("2","Engineering Division","acc-print");



DROP TABLE IF EXISTS mst_dropdowns;

CREATE TABLE `mst_dropdowns` (
  `dropdown_id` double NOT NULL AUTO_INCREMENT,
  `dropdown_name` varchar(50) DEFAULT NULL,
  `dropdown_for` int(11) DEFAULT NULL,
  PRIMARY KEY (`dropdown_id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=latin1;

INSERT INTO mst_dropdowns VALUES("1","Lead Source","1");
INSERT INTO mst_dropdowns VALUES("2","Drawing Types","2");
INSERT INTO mst_dropdowns VALUES("3","Drawing Software","2");
INSERT INTO mst_dropdowns VALUES("4","Plotting Types","2");
INSERT INTO mst_dropdowns VALUES("5","Paper Quality","2");
INSERT INTO mst_dropdowns VALUES("6","Paper Size","2");
INSERT INTO mst_dropdowns VALUES("7","Tracing Type","2");
INSERT INTO mst_dropdowns VALUES("8","Color Mode","2");
INSERT INTO mst_dropdowns VALUES("9","CD / DVD","2");
INSERT INTO mst_dropdowns VALUES("10","Campaign Type","1");
INSERT INTO mst_dropdowns VALUES("11","Type of Candidate","1");
INSERT INTO mst_dropdowns VALUES("12","Scanning Type","2");
INSERT INTO mst_dropdowns VALUES("13","Fees Types","1");
INSERT INTO mst_dropdowns VALUES("14","Ammonia Print","2");
INSERT INTO mst_dropdowns VALUES("15","Certificate","1");
INSERT INTO mst_dropdowns VALUES("16","Course Short Code","1");
INSERT INTO mst_dropdowns VALUES("17","Class Days","1");



DROP TABLE IF EXISTS mst_main;

CREATE TABLE `mst_main` (
  `mst_main_id` double NOT NULL AUTO_INCREMENT,
  `dropdown_id` double NOT NULL,
  `mst_main_value` varchar(50) NOT NULL,
  `mst_main_status` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`mst_main_id`)
) ENGINE=MyISAM AUTO_INCREMENT=85 DEFAULT CHARSET=latin1;

INSERT INTO mst_main VALUES("1","1","Campaigns","1");
INSERT INTO mst_main VALUES("2","1","News Paper","1");
INSERT INTO mst_main VALUES("3","1","Through Friends","1");
INSERT INTO mst_main VALUES("4","2","2D","1");
INSERT INTO mst_main VALUES("5","2","3D","1");
INSERT INTO mst_main VALUES("6","3","AutoCAD","1");
INSERT INTO mst_main VALUES("7","3","Pro-E","1");
INSERT INTO mst_main VALUES("8","8","Color Printing","1");
INSERT INTO mst_main VALUES("9","8","Mono Printing","1");
INSERT INTO mst_main VALUES("10","9","CD Writing","1");
INSERT INTO mst_main VALUES("11","9","DVD Writing","1");
INSERT INTO mst_main VALUES("12","6","A0","1");
INSERT INTO mst_main VALUES("13","6","A1","1");
INSERT INTO mst_main VALUES("14","6","A4","1");
INSERT INTO mst_main VALUES("15","4","CAD Plotting","1");
INSERT INTO mst_main VALUES("16","4","Post / Image Plotting","1");
INSERT INTO mst_main VALUES("17","7","Single Mode Tracing","1");
INSERT INTO mst_main VALUES("18","10","News Paper Ads","1");
INSERT INTO mst_main VALUES("19","1","Other Executives (Dept)","1");
INSERT INTO mst_main VALUES("20","1","Through Marketing","1");
INSERT INTO mst_main VALUES("21","1","Existing student","1");
INSERT INTO mst_main VALUES("22","1","Internet","1");
INSERT INTO mst_main VALUES("23","1","Plotting / Drg. Conv","1");
INSERT INTO mst_main VALUES("24","10","College ref.","1");
INSERT INTO mst_main VALUES("26","11","College Students","1");
INSERT INTO mst_main VALUES("27","5","Photoglassy","1");
INSERT INTO mst_main VALUES("28","5","Coated Paper","1");
INSERT INTO mst_main VALUES("29","5","Regular Paper","1");
INSERT INTO mst_main VALUES("30","12","CAD Scanning","1");
INSERT INTO mst_main VALUES("31","12","Image Scanning","1");
INSERT INTO mst_main VALUES("32","13","Course Fees","1");
INSERT INTO mst_main VALUES("34","13","Book Fees","1");
INSERT INTO mst_main VALUES("35","13","On Line Certification","1");
INSERT INTO mst_main VALUES("36","1","ARS","1");
INSERT INTO mst_main VALUES("38","11","School Student (10th  / +2)","1");
INSERT INTO mst_main VALUES("39","11","Civil Student","1");
INSERT INTO mst_main VALUES("40","11","Mechanical Student","1");
INSERT INTO mst_main VALUES("41","11","EEE Student","1");
INSERT INTO mst_main VALUES("42","11","Architect Student","1");
INSERT INTO mst_main VALUES("43","11","Employed - Private co.,","1");
INSERT INTO mst_main VALUES("44","11","Self Employed","1");
INSERT INTO mst_main VALUES("45","11","Un-employed","1");
INSERT INTO mst_main VALUES("46","11","Other catagories","1");
INSERT INTO mst_main VALUES("47","11","Employed - Govt., Department","1");
INSERT INTO mst_main VALUES("48","1","Thro&prime; Just Dial","1");
INSERT INTO mst_main VALUES("49","16","ACAD 2D","1");
INSERT INTO mst_main VALUES("50","16","INV","1");
INSERT INTO mst_main VALUES("51","16","SWX","1");
INSERT INTO mst_main VALUES("52","17","MWF","1");
INSERT INTO mst_main VALUES("53","17","TTS","1");
INSERT INTO mst_main VALUES("54","17","ALL","1");
INSERT INTO mst_main VALUES("56","16","ELEC","1");
INSERT INTO mst_main VALUES("57","16","PRO|E","1");
INSERT INTO mst_main VALUES("58","16","CCG","1");
INSERT INTO mst_main VALUES("59","16","REVIT","1");
INSERT INTO mst_main VALUES("60","16","STAAD","1");
INSERT INTO mst_main VALUES("61","16","ECO","1");
INSERT INTO mst_main VALUES("62","16","ON LINE","1");
INSERT INTO mst_main VALUES("63","17","SAT","1");
INSERT INTO mst_main VALUES("64","17","SUN","1");
INSERT INTO mst_main VALUES("65","16","REV.STR","1");
INSERT INTO mst_main VALUES("66","16","REV.MEP","1");
INSERT INTO mst_main VALUES("67","15","AUTOCAD- 2D","1");
INSERT INTO mst_main VALUES("68","15","AUTOCAD 3D","1");
INSERT INTO mst_main VALUES("69","16","ACAD REFRESH","1");
INSERT INTO mst_main VALUES("70","17","MW","1");
INSERT INTO mst_main VALUES("71","17","TT","1");
INSERT INTO mst_main VALUES("72","15","3DS MAX Design","1");
INSERT INTO mst_main VALUES("73","15","PHOTOSHOP","1");
INSERT INTO mst_main VALUES("74","15","SOLIDWORKS - 2 Level","1");
INSERT INTO mst_main VALUES("75","15","SOLIDWORKS - 4 Level","1");
INSERT INTO mst_main VALUES("76","15","PRO|E","1");
INSERT INTO mst_main VALUES("77","15","REVIT ARCHITECTURE","1");
INSERT INTO mst_main VALUES("78","15","REVIT MEP","1");
INSERT INTO mst_main VALUES("79","15","REVIT STRUCTURE","1");
INSERT INTO mst_main VALUES("80","15","STADPRO","1");
INSERT INTO mst_main VALUES("81","15","ONLINE CERTIFICATION","1");
INSERT INTO mst_main VALUES("82","15","INVENTOR","1");
INSERT INTO mst_main VALUES("83","15","ELECTRICAL CAD","1");
INSERT INTO mst_main VALUES("84","16","AUTOCAD- 3D","1");



DROP TABLE IF EXISTS mst_main_menu;

CREATE TABLE `mst_main_menu` (
  `mm_id` double NOT NULL AUTO_INCREMENT,
  `div_id` int(11) NOT NULL,
  `mm_name` varchar(50) DEFAULT NULL,
  `mm_url` varchar(100) DEFAULT NULL,
  `mm_show` int(11) DEFAULT NULL,
  `mm_default` int(11) DEFAULT NULL,
  `mm_index` int(11) NOT NULL,
  PRIMARY KEY (`mm_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO mst_main_menu VALUES("1","1","MASTERS","javascript:;","1","1","1");



DROP TABLE IF EXISTS mst_shipment;

CREATE TABLE `mst_shipment` (
  `shipment_id` double NOT NULL AUTO_INCREMENT,
  `shipment_index` int(11) NOT NULL,
  `company_name` varchar(50) NOT NULL,
  `shipment_status` int(11) NOT NULL,
  PRIMARY KEY (`shipment_id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

INSERT INTO mst_shipment VALUES("1","1","BeamOn Local Delivery","1");
INSERT INTO mst_shipment VALUES("2","2","Will Call","1");
INSERT INTO mst_shipment VALUES("3","3","FedEx First Overnight","1");
INSERT INTO mst_shipment VALUES("4","4","FedEx Priority Overnight","1");
INSERT INTO mst_shipment VALUES("5","5","FedEx Standard Overnight","1");
INSERT INTO mst_shipment VALUES("6","6","FedEx 2 Day A.M.","1");
INSERT INTO mst_shipment VALUES("7","7","FedEx 2 Day","1");
INSERT INTO mst_shipment VALUES("8","8","FedEx Ground","1");
INSERT INTO mst_shipment VALUES("9","9","UPS Next Day Air 8A.M.","1");
INSERT INTO mst_shipment VALUES("10","10","UPS Next Day Air","1");
INSERT INTO mst_shipment VALUES("11","11","UPS Next Day Air Saver","1");
INSERT INTO mst_shipment VALUES("12","12","UPS 2nd Day Air A.M.","1");
INSERT INTO mst_shipment VALUES("13","13","UPS 2nd Day Air","1");
INSERT INTO mst_shipment VALUES("14","14","UPS 3 Day Orange","1");
INSERT INTO mst_shipment VALUES("15","15","UPS Ground","1");
INSERT INTO mst_shipment VALUES("16","16","USPS","1");



DROP TABLE IF EXISTS mst_state;

CREATE TABLE `mst_state` (
  `state_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `country_id` int(11) unsigned DEFAULT NULL,
  `state_name` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`state_id`),
  UNIQUE KEY `id` (`state_id`),
  KEY `id_2` (`state_id`),
  KEY `state` (`state_name`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=latin1;

INSERT INTO mst_state VALUES("1","1","Andhra Pradesh");
INSERT INTO mst_state VALUES("2","1","Arunachal Pradesh");
INSERT INTO mst_state VALUES("3","1","Assam");
INSERT INTO mst_state VALUES("4","1","Bihar");
INSERT INTO mst_state VALUES("5","1","Chandigarh");
INSERT INTO mst_state VALUES("6","1","Chhattisgarh");
INSERT INTO mst_state VALUES("7","1","Dadra and Nagar");
INSERT INTO mst_state VALUES("8","1","Daman and Diu");
INSERT INTO mst_state VALUES("9","1","Delhi");
INSERT INTO mst_state VALUES("10","1","Goa");
INSERT INTO mst_state VALUES("11","1","Gujarat");
INSERT INTO mst_state VALUES("12","1","Haryana");
INSERT INTO mst_state VALUES("13","1","Himachal Pradesh");
INSERT INTO mst_state VALUES("14","1","Jammu & Kashmir");
INSERT INTO mst_state VALUES("15","1","Jharkhand");
INSERT INTO mst_state VALUES("16","1","Karnataka");
INSERT INTO mst_state VALUES("17","1","Kerala");
INSERT INTO mst_state VALUES("18","1","LakshadweepIsland");
INSERT INTO mst_state VALUES("19","1","Madhya Pradesh");
INSERT INTO mst_state VALUES("20","1","Maharashtra");
INSERT INTO mst_state VALUES("21","1","Manipur");
INSERT INTO mst_state VALUES("22","1","Meghalaya");
INSERT INTO mst_state VALUES("23","1","Mizoram");
INSERT INTO mst_state VALUES("24","1","Nagaland");
INSERT INTO mst_state VALUES("25","1","Orissa");
INSERT INTO mst_state VALUES("26","1","Pondicherry");
INSERT INTO mst_state VALUES("27","1","Punjab");
INSERT INTO mst_state VALUES("28","1","Rajashthan");
INSERT INTO mst_state VALUES("29","1","Sikkim");
INSERT INTO mst_state VALUES("30","1","Tamil Nadu");
INSERT INTO mst_state VALUES("31","1","Tripura");
INSERT INTO mst_state VALUES("32","1","Uttar Pradesh");
INSERT INTO mst_state VALUES("33","1","Uttaranchal");
INSERT INTO mst_state VALUES("34","1","West Bengal");
INSERT INTO mst_state VALUES("35","1","Andaman & Nicobar");



DROP TABLE IF EXISTS mst_status;

CREATE TABLE `mst_status` (
  `mst_status_id` double NOT NULL AUTO_INCREMENT,
  `dropdown_id` double NOT NULL,
  `mst_status_value` varchar(50) NOT NULL,
  PRIMARY KEY (`mst_status_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO mst_status VALUES("1","26","Follow..");
INSERT INTO mst_status VALUES("2","26","Closed");



DROP TABLE IF EXISTS mst_sub_menu;

CREATE TABLE `mst_sub_menu` (
  `sm_id` double NOT NULL AUTO_INCREMENT,
  `mm_id` double DEFAULT NULL,
  `sm_index` int(11) DEFAULT NULL,
  `sm_name` varchar(50) DEFAULT NULL,
  `sm_url` varchar(100) DEFAULT NULL,
  `sm_query` varchar(250) DEFAULT NULL,
  `sm_show` int(11) DEFAULT NULL,
  `sm_default` int(11) DEFAULT NULL,
  PRIMARY KEY (`sm_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

INSERT INTO mst_sub_menu VALUES("1","1","1","CAD","javascript:;","","1","");
INSERT INTO mst_sub_menu VALUES("2","1","2","LASER","javascript:;","","1","");
INSERT INTO mst_sub_menu VALUES("3","1","3","PRODUCTION","javascript:;","","1","");
INSERT INTO mst_sub_menu VALUES("4","1","4","SHIPMENT","javascript:;","","1","");
INSERT INTO mst_sub_menu VALUES("5","1","5","INVOICE","javascript:;","","1","");
INSERT INTO mst_sub_menu VALUES("6","1","6","PACKING","javascript:;","","1","");
INSERT INTO mst_sub_menu VALUES("7","1","7","HOLD","javascript:;","","1","");
INSERT INTO mst_sub_menu VALUES("8","1","8","COMPLETED","javascript:;","","1","");
INSERT INTO mst_sub_menu VALUES("9","1","9","PRIORITY & TOOLING","javascript:;","","1","");
INSERT INTO mst_sub_menu VALUES("10","1","10","REMARKS UPDATE","javascript:;","","1","");



DROP TABLE IF EXISTS mst_tulips_admin;

CREATE TABLE `mst_tulips_admin` (
  `tulips_user_id` varchar(15) DEFAULT NULL,
  `tulips_user_name` varchar(15) DEFAULT NULL,
  `tulips_user_pw` varchar(15) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO mst_tulips_admin VALUES("admin","Tulips Media","admin");



DROP TABLE IF EXISTS tbl_customer;

CREATE TABLE `tbl_customer` (
  `cust_id` double NOT NULL AUTO_INCREMENT,
  `cust_name` varchar(50) NOT NULL,
  `cust_ref` double NOT NULL,
  `contact_name` varchar(50) NOT NULL,
  `contact_no` varchar(20) NOT NULL,
  `cust_email` varchar(50) NOT NULL,
  `cust_city` text NOT NULL,
  `cust_status` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`cust_id`)
) ENGINE=MyISAM AUTO_INCREMENT=132 DEFAULT CHARSET=latin1;

INSERT INTO tbl_customer VALUES("1","Foxconn iDSBG","829","","","","1705 Junction Ct. Suite 200\r\nSan Jose  CA  95112","1");
INSERT INTO tbl_customer VALUES("2","Sanmina QT","534","","","","60 E. Plumeria Drive Bldg. 2\r\nSan Jose  CA  95134","1");
INSERT INTO tbl_customer VALUES("3","Intel Corporation","563","","","","5200 NE Elam Young Parkway\r\nHillsboro  OR  97124","1");
INSERT INTO tbl_customer VALUES("4","Flextronics","321","","","","1077 Gibraltar Drive \r\nMilpitas  CA  95035","1");
INSERT INTO tbl_customer VALUES("5","Oncore","489","","","","2243 Lundy Avenue\r\nSan Jose  CA  95131","1");
INSERT INTO tbl_customer VALUES("6","Apple Computer","739","","","","6 Infinite Loop\r\nCupertino  CA  95014","1");
INSERT INTO tbl_customer VALUES("7","SEM Harbor Electronics","999","","","","595 Yosemite Drive\r\nMilpitas  CA  95035","1");
INSERT INTO tbl_customer VALUES("8","Jabil","575","","","","30 Great Oaks Blvd\r\nSan Jose  CA  95119","1");
INSERT INTO tbl_customer VALUES("9","Sanmina Production","281","","","","2700 N. First Street\r\nSan Jose  CA  95134","1");
INSERT INTO tbl_customer VALUES("10","ASteelFlash","239","","","","4211 Starboard Drive\r\nFremont  CA  94538","1");
INSERT INTO tbl_customer VALUES("11","Zollner Electronics","102","","","","575 Cottonwood Drive\r\nMilpitas  CA  95035","1");
INSERT INTO tbl_customer VALUES("12","A & A Electronics Assy Inc","942","","","","","1");
INSERT INTO tbl_customer VALUES("13","Absolute Turnkey","669","","","","555 Aldo Avenue\r\nSanta Clara  CA  95054","1");
INSERT INTO tbl_customer VALUES("14","ABX","617","","","","880 Hinckley Road\r\nBurlingame  CA  94010-1503","1");
INSERT INTO tbl_customer VALUES("15","Active Wire","896","","","","1799 Silacci Drive\r\nCampbell  CA  95008","1");
INSERT INTO tbl_customer VALUES("16","Advanced Assemblies","693","","","","990 Richard Avenue  Ste.\r\nSanta Clara  CA  95050","1");
INSERT INTO tbl_customer VALUES("17","Keysight Technologies","637","","","","5301 Stevens Creek Blvd\r\nSanta Clara  CA  95051","1");
INSERT INTO tbl_customer VALUES("18","Allied Telesis","893","","","","3200 North First Street\r\nSan Jose  CA  95134","1");
INSERT INTO tbl_customer VALUES("19","Applied Technologies","835","","","","3025 Buena Vista Dr.\r\nPasoRobles  CA  93446","1");
INSERT INTO tbl_customer VALUES("20","Ascentron","938","","","","994 Antelope Road\r\nWhite City  OR  97503","1");
INSERT INTO tbl_customer VALUES("21","Atlan Dyess","864","","","","","1");
INSERT INTO tbl_customer VALUES("22","Axiom Electronics Inc.","347","","","","19545 NW Von Neumann Drive M/S 200\r\nBeaverton  OR  97006","1");
INSERT INTO tbl_customer VALUES("23","Benchmark","384","","","","5550 Hellyer Avenue\r\nSan Jose  CA  95138","1");
INSERT INTO tbl_customer VALUES("24","Benchmark AL","822","","","","","1");
INSERT INTO tbl_customer VALUES("25","Benchmark MN","966","","","","4155 Theurer Blvd\r\nWinona  MN  55987","1");
INSERT INTO tbl_customer VALUES("26","Blue Moon","103","","","","845 Christy Court\r\nTracy  CA  95376","1");
INSERT INTO tbl_customer VALUES("27","Cal Tech","872","","","","40491 Encyclopedia Cir\r\nFremont  CA  94538","1");
INSERT INTO tbl_customer VALUES("28","CB Ram","772","","","","9665 SW Allen Blvd, Suite 117\r\nBeaverton  OR  97005","1");
INSERT INTO tbl_customer VALUES("29","CBA Electronics Corp","919","","","","897 Independence Ave Suite 5E\r\nMountain View  CA  94043","1");
INSERT INTO tbl_customer VALUES("30","Celestica","453","","","","5325 Hellyer Avenue\r\nSan Jose  CA  95138","1");
INSERT INTO tbl_customer VALUES("31","Controltek","758","","","","3905 NE 112th Avenue\r\nVancouver  OR  98682","1");
INSERT INTO tbl_customer VALUES("32","Cooper Bussmann NC","157","","","","210 Dixie Trail\r\nGoldsboro  NC  27530","1");
INSERT INTO tbl_customer VALUES("33","Crane Electronics","703","","","","990 Richard Avenue  Ste.\r\nSanta Clara  CA  95050","1");
INSERT INTO tbl_customer VALUES("34","Creation Tech. SNC","799","","","","2801 Northwestern Parkway\r\nSanta Clara  CA  95051","1");
INSERT INTO tbl_customer VALUES("35","Creation Tech. SNJ","800","","","","1873 Barber Lane\r\nMilpitas  CA  95035","1");
INSERT INTO tbl_customer VALUES("36","Foxconn","691","","","","1705 Junction Ct., STE 200\r\nSan Jose  CA  95112","1");
INSERT INTO tbl_customer VALUES("37","Genom Corporation","667","","","","2040 Genom Boulevard\r\nTinsel City  CA  95054","1");
INSERT INTO tbl_customer VALUES("38","Green Circuits","916","","","","1130 Ringwood Court\r\nSan Jose  CA  95131","1");
INSERT INTO tbl_customer VALUES("39","Halliburton","972","","","","14804 Morales\r\nGate 3 - Dock 108\r\nHouston  TX  77032","1");
INSERT INTO tbl_customer VALUES("40","Harris Corporation","807","","","","1000 Charles J Herbert Dr\r\nPalm Bay  FL  32905","1");
INSERT INTO tbl_customer VALUES("41","Hilltron Corporation","832","","","","2528 Qume Drive, Suite 4\r\nSan Jose  CA  95131","1");
INSERT INTO tbl_customer VALUES("42","Hunter Technology","660","","","","1940 Milmont Drive\r\nSanta Clara  CA  95035","1");
INSERT INTO tbl_customer VALUES("43","Infiniti Solutions","541","","","","3910 N. 1st Street\r\nSan Jose  CA  95134","1");
INSERT INTO tbl_customer VALUES("44","Intel Corp - Folsom","954","","","","1900 Prairie City Road\r\nFolsom  CA  95630","1");
INSERT INTO tbl_customer VALUES("45","International Rectifier","724","","","","2520 Junction Avenue\r\nSan Jose  CA  95134","1");
INSERT INTO tbl_customer VALUES("46","ISSPRO","151","","","","2515 NE Riverside Way\r\nPortland  OR  97211","1");
INSERT INTO tbl_customer VALUES("47","Italix Company","827","","","","","1");
INSERT INTO tbl_customer VALUES("48","iTronix Systems","174","","","","321 E. Brokaw Rd\r\nSan Jose  CA  95112","1");
INSERT INTO tbl_customer VALUES("49","Jabil AZ","971","","","","615 S. River Drive\r\nTempe  AZ  85281","1");
INSERT INTO tbl_customer VALUES("50","Jabil FLA","630","","","","30 Great Oaks Blvd\r\nSan Jose  CA  95119","1");
INSERT INTO tbl_customer VALUES("51","Javad","993","","","","900 Rock Avenue\r\nSan Jose  CA  95131","1");
INSERT INTO tbl_customer VALUES("52","Leemah","571","","","","","1");
INSERT INTO tbl_customer VALUES("53","Manutronics","653","","","","48501 Warm Springs Blvd\r\nSuite 112 \r\nFremont  CA  94539","1");
INSERT INTO tbl_customer VALUES("54","Marvell Semiconductor","914","","","","5488 Marvell Lane\r\nMS 5202\r\nSanta Clara  CA  95054","1");
INSERT INTO tbl_customer VALUES("55","MC Test Products","983","","","","1762 Technology Drive, Ste 201\r\nSan Jose  CA  95110","1");
INSERT INTO tbl_customer VALUES("56","MEC Midwest","820","","","","5855 N. Glen Park Road\r\nMilwaukee  WI  53209","1");
INSERT INTO tbl_customer VALUES("57","MEC Northwest","767","","","","1140 NW 3rd Ave\r\nCanby  OR  97013","1");
INSERT INTO tbl_customer VALUES("58","Memory Bay","725","","","","3370 Victor Court\r\nSanta Clara  CA  95054","1");
INSERT INTO tbl_customer VALUES("59","Meritronics","343","","","","3020 Kenneth Street\r\nSanta Clara  CA  95054","1");
INSERT INTO tbl_customer VALUES("60","Michael Yee Audio","890","","","","101 E. Alma Street #301\r\nMount Shasta  CA  96067","1");
INSERT INTO tbl_customer VALUES("61","Micro Replay","144","","","","6A Dunham Road\r\nBillerica  MA  01821","1");
INSERT INTO tbl_customer VALUES("62","Micro Systems Engineering","538","","","","6024 SW Jean Road\r\nLake Oswego  OR  97035","1");
INSERT INTO tbl_customer VALUES("63","Mosaic Industries Inc","169","","","","5437 Central Avenue\r\nNewark  CA  94560","1");
INSERT INTO tbl_customer VALUES("64","Naprotek","475","","","","2945 San Ysidro Way\r\nSanta Clara  CA  95057","1");
INSERT INTO tbl_customer VALUES("65","NBS Corporation","815","","","","1940 Milmont Drive\r\nSanta Clara  CA  95035","1");
INSERT INTO tbl_customer VALUES("66","Nextek Corporation","596","","","","201 Next Technology Drive\r\nMadison  AL  35758","1");
INSERT INTO tbl_customer VALUES("67","NRC Manufacturing","981","","","","454 Kato Terrace\r\nFremont  CA  94539","1");
INSERT INTO tbl_customer VALUES("68","OECO","793","","","","4607 S.E. International\r\nMilwaukie  OR  97222","1");
INSERT INTO tbl_customer VALUES("69","OK International","749","","","","12151 Monarch Street\r\nGarden Grove  CA  92841","1");
INSERT INTO tbl_customer VALUES("70","Oncore Fremont","110","","","","6600 Stevenson Blvd.\r\nFremont  CA  94538","1");
INSERT INTO tbl_customer VALUES("71","Pacific Scientific - MSI","859","","","","3601 Union Road\r\nHollister  CA  95023","1");
INSERT INTO tbl_customer VALUES("72","Pactron","126","","","","3000 Patrick Henry Drive\r\nSanta Clara  CA  95054","1");
INSERT INTO tbl_customer VALUES("73","Paine Electronics","166","","","","5545 Nelpar Drive\r\nEast Wenatchee  WA  98802","1");
INSERT INTO tbl_customer VALUES("74","Paramit Corporation","152","","","","18735 Madrone Parkway\r\nMorgan Hill  CA  95037","1");
INSERT INTO tbl_customer VALUES("75","PELCO","170","","","","3500 Pelco Way\r\nClovis  CA  93612-5699","1");
INSERT INTO tbl_customer VALUES("76","Piranha EMS Inc","173","","","","2528 Qume Drive\r\nSan Jose  CA  95131","1");
INSERT INTO tbl_customer VALUES("77","Plexus Fremont","728","","","","431 Kato Terrace\r\nFremont  CA  94539","1");
INSERT INTO tbl_customer VALUES("78","Precision PCB Services","311","","","","1750 Mitchell Street\r\nOroville  CA  95966","1");
INSERT INTO tbl_customer VALUES("79","Proto Services","600","","","","2021 N. Capitol Ave., Suite B\r\nSan Jose  CA  95132","1");
INSERT INTO tbl_customer VALUES("80","QCA","259","","","","1709 JUNCTION CT. UNIT 380\r\nSAN JOSE  CA  95112","1");
INSERT INTO tbl_customer VALUES("81","QoSTronics","735","","","","2044 Corporate Court\r\nSan Jose  CA  95131","1");
INSERT INTO tbl_customer VALUES("82","QPL","897","","","","21420 G NW Nicholas Court\r\nHillsboro  OR  97127","1");
INSERT INTO tbl_customer VALUES("83","Radio Design Group Inc.","613","","","","8925 Rogue River Hwy\r\nGrants Pass  OR  97527","1");
INSERT INTO tbl_customer VALUES("84","Rocket EMS Incorporated","222","","","","2950 Patrick Henry Dr.\r\nSanta Clara  CA  95054","1");
INSERT INTO tbl_customer VALUES("85","Rockwell Collins - IA","941","","","","400 Collins Road \r\nM/S 106-176 \r\nCedar Rapids  IA 52498","1");
INSERT INTO tbl_customer VALUES("86","Rodgers Instruments Group","482","","","","1300 N.E. 25th Avenue\r\nHillsboro  OR  97124","1");
INSERT INTO tbl_customer VALUES("87","Sanmina NH","361","","","","","1");
INSERT INTO tbl_customer VALUES("88","Sanmina Utah","609","","","","2417 South 3850 West \r\nWest Valley City  UT  84120","1");
INSERT INTO tbl_customer VALUES("89","SEM Incorporated","973","","","","595 Yosemite Drive\r\nMilpitas  CA  95035","1");
INSERT INTO tbl_customer VALUES("90","Silicon Light Machine","834","","","","","1");
INSERT INTO tbl_customer VALUES("91","Silicon Mountain","986","","","","1400 Shilo Drive\r\nNampo  ID  83687-3064","1");
INSERT INTO tbl_customer VALUES("92","SMS Memory","107","","","","","1");
INSERT INTO tbl_customer VALUES("93","SMTC","253","","","","2302 Trade Zone Blvd\r\nSan Jose  CA  95131","1");
INSERT INTO tbl_customer VALUES("94","Spec Tek","845","","","","8000 S Federal Way\r\nBoise  ID  83716-9632","1");
INSERT INTO tbl_customer VALUES("95","Stanford Research Systems","252","","","","845 Christy Court\r\nTracy  CA  95376","1");
INSERT INTO tbl_customer VALUES("96","STI Electronics","905","","","","2610 Palmer Road\r\nMadison  AL  35758","1");
INSERT INTO tbl_customer VALUES("97","Surface Art","479","","","","81 Bonaventura Drive\r\nSan Jose  CA  95134","1");
INSERT INTO tbl_customer VALUES("98","Surface Mount Solutions","167","","","","2115 De La Cruz Blvd\r\nSanta Clara  CA  95050","1");
INSERT INTO tbl_customer VALUES("99","SV Probe","148","","","","4251 Burton Drive\r\nSanta Clara  CA  95054","1");
INSERT INTO tbl_customer VALUES("100","Synergetics","140","","","","8 Harris Court, Suite E2\r\nMonterey  CA  93940","1");
INSERT INTO tbl_customer VALUES("101","TE Connectivity","471","","","","","1");
INSERT INTO tbl_customer VALUES("102","Tektronix China","994","","","","1227 Chuan Qiao Rd\r\nPudong New District\r\nPudong, Shanghai\r\nChina  201206","1");
INSERT INTO tbl_customer VALUES("103","Tektronix Incorporated","504","","","","Tektronix, Inc., Bldg.19\r\nBeaverton  OR  97077","1");
INSERT INTO tbl_customer VALUES("104","Tektronix Maxtek","559","","","","2905 SW Hocken Avenue\r\nBeaverton  OR  97005","1");
INSERT INTO tbl_customer VALUES("105","Tesla Motors","176","","","","45500 Fremont Blvd\r\nFremont  CA  94538","1");
INSERT INTO tbl_customer VALUES("106","Test","333","","","","","1");
INSERT INTO tbl_customer VALUES("107","Texas Instruments","614","","","","3875 Kifer Road\r\nSanta Clara  CA  95051","1");
INSERT INTO tbl_customer VALUES("108","UC Berkeley","160","","","","266 Sutardja Dai Hall\r\nBerkeley  CA  94720","1");
INSERT INTO tbl_customer VALUES("109","Unigen Corporation","255","","","","45388 Warm Springs Blvd.\r\nFremont  CA  94539","1");
INSERT INTO tbl_customer VALUES("110","Unitron","952","","","","8535 Elder Creek Road, Ste. 200\r\nSacramento  CA  95828","1");
INSERT INTO tbl_customer VALUES("111","Veris","782","","","","12345 SW Leveton Drive\r\nTualatin  OR  97062","1");
INSERT INTO tbl_customer VALUES("112","Vivid Medical Inc","171","","","","1023 Corporation Way\r\nPalo Alto  CA  94303","1");
INSERT INTO tbl_customer VALUES("113","Walk In Customer","111","","","","2444 Schultz Drive\r\nNeenah  WI  54957","1");
INSERT INTO tbl_customer VALUES("114","Wearotek Inc","175","","","","290 Chestnut Avenue\r\nPalo Alto  CA  94306","1");
INSERT INTO tbl_customer VALUES("115","Westcor","810","","","","","1");
INSERT INTO tbl_customer VALUES("116","Wiser America Inc","150","","","","2455 Autumnvale Drvie, Suite G\r\nSan Jose  CA  95131","1");
INSERT INTO tbl_customer VALUES("117","Brocade","797","","","","110 Holger Way\r\nSan Jose  CA  95134","1");
INSERT INTO tbl_customer VALUES("118","Medtronic","969","","","","","1");
INSERT INTO tbl_customer VALUES("119","Silicon Turnkey Solutions","101","","","","801 Buckeye Court\r\nMilpitas  CA  95035","1");
INSERT INTO tbl_customer VALUES("120","Castle Creations","164","","","","540 N. Rogers Road\r\nOlathe  KS  66062","1");
INSERT INTO tbl_customer VALUES("121","Plexus WI","949","","","","","1");
INSERT INTO tbl_customer VALUES("122","Sonic","4526","","","","","1");
INSERT INTO tbl_customer VALUES("123","Sonic Mfg","452","","","","47931 Westinghouse Drive    Fremont, CA 94539  US","1");
INSERT INTO tbl_customer VALUES("124","Lenthor","177","","","","","1");
INSERT INTO tbl_customer VALUES("125","Smart Modular","688","Ganesh Pandiarajan","","","","1");
INSERT INTO tbl_customer VALUES("126","Wellex","149","","","","","1");
INSERT INTO tbl_customer VALUES("127","Zytek-EMS","180","Mario Baltier","","mario.baltier@zytek-ems.com","","1");
INSERT INTO tbl_customer VALUES("128","Bema Electronics","885","","","","","1");
INSERT INTO tbl_customer VALUES("129","Innerstep","992","Caleb Hunt","","","","1");
INSERT INTO tbl_customer VALUES("130","Test","0","Rajesh","4089403280","rajeshk@beamon.com","India","1");
INSERT INTO tbl_customer VALUES("131","KeyTronicEMS","588","","","","","1");



DROP TABLE IF EXISTS tbl_jobs;

CREATE TABLE `tbl_jobs` (
  `job_id` double NOT NULL AUTO_INCREMENT,
  `cust_id` double NOT NULL,
  `job_no` int(11) NOT NULL,
  `job_code` varchar(255) NOT NULL,
  `job_date` date NOT NULL,
  `job_priority` int(11) NOT NULL,
  `job_tooling` int(11) NOT NULL,
  `due_date` date NOT NULL,
  `due_time` double NOT NULL,
  `due_ampm` varchar(2) NOT NULL,
  `shipment_id` double NOT NULL,
  `ship_address` text NOT NULL,
  `job_remarks` varchar(500) NOT NULL,
  `job_cad_status` int(11) NOT NULL,
  `job_cad_lupdate` datetime NOT NULL,
  `aper_content` varchar(255) NOT NULL,
  `foil_thick` varchar(255) NOT NULL,
  `bord` varchar(255) NOT NULL,
  `job_laser_status` int(11) NOT NULL,
  `job_laser_lupdate` datetime NOT NULL,
  `job_production_status` int(11) NOT NULL,
  `job_production_lupdate` datetime NOT NULL,
  `job_shipped_status` int(11) NOT NULL,
  `job_shipped_lupdate` datetime NOT NULL,
  `job_invoice_status` int(11) NOT NULL,
  `job_invoice_no` varchar(15) NOT NULL,
  `job_packing_status` int(11) NOT NULL,
  `job_packing_pslipid` int(11) NOT NULL,
  `job_packing_lupdate` datetime NOT NULL,
  `job_complet_status` int(11) NOT NULL,
  `job_status` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`job_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11266 DEFAULT CHARSET=latin1;

INSERT INTO tbl_jobs VALUES("1","4","1234","3211234","2013-12-31","1","0","2014-01-01","2","","0","","","1","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","1","123","1","0","0000-00-00 00:00:00","1","1");
INSERT INTO tbl_jobs VALUES("2","3","1122","5631123","2013-12-31","1","0","2014-01-02","1","","0","","testing.","1","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","1","55667788","1","0","0000-00-00 00:00:00","1","1");
INSERT INTO tbl_jobs VALUES("3","4","0","3214567","2014-01-07","0","1","2014-01-13","0","","0","","testing..","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("4","1","0","82900112","2014-01-07","0","0","2014-01-15","7","","0","","testing..","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("5","3","0","5637897","2014-01-07","1","0","2014-01-13","10.3","","0","","","1","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","1","","1","0","0000-00-00 00:00:00","1","1");
INSERT INTO tbl_jobs VALUES("6","3","0","5632156","2014-01-08","0","0","2014-04-16","19.3","","5","","","1","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","1","12345","1","0","0000-00-00 00:00:00","1","1");
INSERT INTO tbl_jobs VALUES("7","8","0","575209","2014-01-08","0","0","2014-01-09","17.3","","0","","","1","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("8","8","0","575210","2014-01-08","0","1","2014-01-09","17","","0","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("9","11","0","102020","2014-01-08","1","1","2014-01-09","17","","0","","","1","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","1","456546","1","0","0000-00-00 00:00:00","1","1");
INSERT INTO tbl_jobs VALUES("10","11","0","102021","2014-01-08","1","1","2014-01-09","17","","0","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("11","1","0","8292426","2014-01-08","1","0","2014-01-08","17","","0","","","1","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("12","7","0","9991567","2014-01-08","1","0","2014-01-09","16.3","","0","","","1","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("13","7","0","9991568","2014-01-08","1","0","2014-01-08","17","","0","","","1","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("14","7","0","9991569","2014-01-08","0","0","2014-01-09","16.3","","0","","","1","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","NA","1","0","0000-00-00 00:00:00","1","1");
INSERT INTO tbl_jobs VALUES("15","3","0","5632102","2014-01-08","0","0","2014-01-09","18","","0","","","1","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("16","10","0","2392894","2014-01-08","0","0","2014-01-08","13","","0","","","1","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","1","0000-00-00 00:00:00","1","123456","1","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("17","10","0","2392893","2014-01-08","1","0","2014-01-09","15.3","","0","","","1","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","1","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("18","3","0","5632106","2014-01-10","1","0","2014-01-10","6","","0","","Samsung bga assembly\r\nrev1.0","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("19","2","0","5346256","2014-01-08","1","0","2014-01-08","10","","0","","Sonic Mfg \r\nM41 \r\n200634-01 & 200634-02","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("20","57","0","76712345","2014-01-24","1","0","2014-01-16","10.3","","0","","Sonic Mfg \r\nM41 \r\n200634-01 & 200634-02","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","1","1");
INSERT INTO tbl_jobs VALUES("21","2","0","5342156","2014-01-24","0","0","2014-01-08","13.3","","0","","Sonic Mfg \r\nM41 \r\n200634-01 & 200634-02","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","waiting","1","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("22","8","0","575123","2014-01-24","0","1","2014-01-25","11.3","","0","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("23","4","0","321456","2014-01-25","1","1","2014-01-24","8.3","","0","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("24","3","0","5632145","2014-01-25","1","0","2014-03-21","19.3","","5","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141392","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("25","3","0","5632146","2014-01-25","0","0","2014-04-11","19.3","","0","","","2","2014-04-10 17:06:04","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("26","93","0","2536412","2014-01-25","0","0","2014-01-25","21.3","","0","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("27","41","0","8321234","2014-01-25","1","0","2014-01-25","20.3","","0","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("28","34","0","7991234","2014-01-27","1","0","2014-01-25","14","","0","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("29","3","0","5631234","2014-01-27","1","0","2014-01-27","18","","0","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("30","3","0","5631235","2014-01-27","1","0","2014-01-27","18","","0","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("31","3","0","5631236","2014-01-27","1","0","2014-01-27","18","","0","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("32","34","0","7991235","2014-01-27","0","0","2014-01-27","19","","0","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("33","41","0","8325623","2014-01-27","0","0","2014-01-27","15","","0","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("34","7","0","9993214","2014-01-27","0","0","2014-01-28","10.3","","0","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("35","4","0","321721","2014-01-30","0","0","2014-01-31","12","","0","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("36","9","0","2813972","2014-01-30","0","0","2014-01-31","12","","0","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("37","99","0","148070","2014-01-30","0","0","2014-01-31","14","","0","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("38","1","0","8292465","2014-01-30","0","0","2014-01-31","14","","0","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("39","6","0","739348","2014-01-30","1","0","2014-01-31","8","","0","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("40","42","0","660010","2014-01-30","0","0","2014-02-03","1","","0","","","2","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("41","42","0","660011","2014-01-30","0","0","2014-02-03","13","","0","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("42","88","0","6092033","2014-01-30","0","0","2014-01-31","20","","0","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("43","70","0","1105104","2014-01-30","0","0","2014-01-31","15","","0","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","po required","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("44","84","0","222080","2014-01-30","1","0","2014-01-31","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("45","84","0","222079","2014-01-30","0","0","2014-02-03","15","","0","","Let Trey see the design first.","1","2014-01-31 01:45:23","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("46","2","0","5346757","2014-01-30","0","1","2014-01-31","15","","0","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("47","82","0","897573","2014-01-30","0","0","2014-01-31","20","","8","","","2","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("48","100","0","140190","2014-01-30","0","0","2014-01-31","20","","0","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("49","109","0","255709","2014-01-30","0","0","2014-01-31","10","","0","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("50","109","0","255706","2014-01-30","1","0","2014-01-31","17","","0","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("51","72","0","1262635","2014-01-30","0","0","2014-01-31","17","","0","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("52","72","0","1262636","2014-01-31","1","0","2014-01-31","18","","0","","Pactron Incorporated \r\nPAC2887_31January2014_ \r\nWO24314_T&B, \r\nWO24341_T&B(LeadFree)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("53","72","0","1262637","2014-01-31","1","0","2014-01-31","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("54","31","0","7582201","2014-01-31","0","0","2014-02-03","20","","8","","Fed Ex Gnd","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("55","51","0","9931320","2014-01-31","0","0","2014-02-03","11","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("56","51","0","9931321","2014-01-31","0","0","2014-02-03","11","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("57","8","0","575240","2014-01-31","0","1","2014-02-03","21","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("58","8","0","575241","2014-01-31","0","1","2014-02-03","21","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("59","8","0","575","2014-01-31","0","0","2014-02-03","21","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("60","8","0","575242","2014-01-31","0","0","2014-02-04","13","","1","","with template","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("61","8","0","575243","2014-01-31","0","0","2014-02-04","13","","1","","with template","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("62","5","0","4894483","2014-01-31","0","0","2014-02-03","13","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("63","5","0","4894484","2014-01-31","0","0","2014-02-03","13","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("64","5","0","4894485","2014-01-31","0","0","2014-02-03","13","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("65","5","0","4894486","2014-01-31","0","0","2014-02-03","13","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("66","8","0","575244","2014-01-31","0","0","2014-02-05","20","","1","","Templates","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("67","8","0","575245","2014-01-31","0","0","2014-02-05","20","","1","","Templates","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("68","51","0","9931332","2014-01-31","0","0","2014-02-10","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("69","51","0","9931323","2014-01-31","0","0","2014-02-03","16","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("70","51","0","9931322","2014-02-03","0","0","2014-02-03","16","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("71","2","0","5346677","2014-02-03","1","0","2014-02-03","13","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("72","3","0","5632122","2014-02-03","0","0","2014-02-04","20","","5","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("73","3","0","5632121","2014-02-03","0","0","2014-02-04","20","","5","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("74","1","0","8292467","2014-02-03","0","0","2014-02-04","10","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("75","57","0","767092","2014-02-03","0","0","2014-02-04","20","","8","","","2","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("76","111","0","782662","2014-02-03","1","0","2014-02-03","20","","4","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("77","111","0","782663","2014-02-03","1","0","2014-02-03","20","","4","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("78","10","0","2392910","2014-02-03","0","0","2014-02-04","9","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("79","34","0","7994712","2014-02-03","0","0","2014-02-04","10","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("80","34","0","7994713","2014-02-03","0","0","2014-02-04","10","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("81","57","0","767093","2014-02-03","1","0","2014-02-03","20","","4","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("82","57","0","767094","2014-02-03","1","0","2014-02-03","20","","4","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("83","7","0","9991623","2014-02-03","0","0","2014-02-03","10","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("84","7","0","9991624","2014-02-03","0","0","2014-02-03","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("85","7","0","9991621","2014-02-03","0","0","2014-02-03","10","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("86","7","0","9991622","2014-02-03","0","0","2014-02-03","10","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("87","7","0","9991617","2014-02-03","0","0","2014-02-03","10","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("88","7","0","9991618","2014-02-03","0","0","2014-02-03","10","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("89","7","0","9991609","2014-02-03","0","0","2014-02-03","8","","1","","","1","2014-02-03 17:18:35","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("90","7","0","9991610","2014-02-03","0","0","2014-02-03","8","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("91","7","0","9991611","2014-02-03","0","0","2014-02-03","8","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("92","7","0","9991612","2014-02-03","0","0","2014-02-03","8","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("93","7","0","9991607","2014-02-03","0","0","2014-02-03","8","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("94","7","0","9991608","2014-02-03","0","0","2014-02-03","8","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("95","7","0","9991613","2014-02-03","0","0","2014-02-03","8","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("96","7","0","9991614","2014-02-03","0","0","2014-02-03","8","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("97","7","0","9991615","2014-02-03","0","0","2014-02-03","8","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("98","7","0","9991616","2014-02-03","0","0","2014-02-03","8","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("99","10","0","2392913","2014-02-03","0","0","2014-02-04","11","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("100","10","0","2392914","2014-02-03","0","0","2014-02-04","11","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("101","31","0","7582202","2014-02-03","0","0","2014-02-04","20","","8","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("102","97","0","4792187","2014-02-03","0","0","2014-02-04","10","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("103","93","0","2532074","2014-02-03","0","0","2014-02-07","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("104","1","0","8292466","2014-02-03","0","0","2014-02-04","11","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("105","10","0","2392911","2014-02-03","0","0","2014-02-04","11","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("106","10","0","2392912","2014-02-03","0","0","2014-02-04","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("107","54","0","914592","2014-02-03","0","0","2014-02-04","10","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("122","51","0","9931325","2014-02-03","1","0","2014-02-03","21","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("131","45","0","724053","2014-02-03","0","0","2014-02-05","8","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("108","3","0","5632123","2014-02-03","0","0","2014-02-06","20","","5","","","2","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("109","1","0","8292468","2014-02-03","0","0","2014-02-04","14","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("110","3","0","5632124","2014-02-03","0","0","2014-02-06","20","","1","","","2","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("111","97","0","4792188","2014-02-03","0","0","2014-02-04","14","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("112","3","0","5632125","2014-02-03","0","0","2014-02-06","20","","5","","","2","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("113","7","0","9991592","2014-02-03","1","0","2014-02-03","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("114","9","0","2813973","2014-02-03","1","0","2014-02-03","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("115","88","0","6092034","2014-02-03","0","0","2014-02-04","20","","11","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("116","4","0","321722","2014-02-03","0","0","2014-02-04","15","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("117","4","0","321723","2014-02-03","0","0","2014-02-04","15","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("118","4","0","321724","2014-02-03","0","0","2014-02-04","15","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("119","4","0","321725","2014-02-03","0","0","2014-02-04","15","","1","","On hold","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("120","4","0","321726","2014-02-03","0","0","2014-02-04","15","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("121","4","0","321727","2014-02-03","0","0","2014-02-04","15","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("123","54","0","914593","2014-02-03","0","0","2014-02-04","17","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("124","51","0","9931326","2014-02-03","0","0","2014-02-04","17","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("125","9","0","2813974","2014-02-03","0","0","2014-02-04","17","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("126","9","0","2813975","2014-02-03","0","0","2014-02-04","17","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("127","9","0","2813976","2014-02-03","0","0","2014-02-04","17","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("128","9","0","2813977","2014-02-03","0","0","2014-02-04","17","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("129","62","0","538110","2014-02-03","1","0","2014-02-11","20","","4","","backetch","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("130","1","0","8292469","2014-02-03","0","0","2014-02-05","8","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("132","45","0","724052","2014-02-04","0","0","2014-02-05","9","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("133","5","0","4894487","2014-02-04","0","0","2014-02-05","8","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("134","5","0","4894488","2014-02-04","0","0","2014-02-05","9","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("142","41","0","832729","2014-02-04","0","0","2014-02-05","8","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("135","97","0","4792189","2014-02-04","0","0","2014-02-06","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("136","51","0","9931327","2014-02-04","0","0","2014-02-05","10","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("137","51","0","9931328","2014-02-04","0","0","2014-02-05","10","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("138","97","0","4792190","2014-02-04","1","0","2014-02-04","14","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("139","88","0","6092035","2014-02-04","0","0","2014-02-05","20","","11","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("140","4","0","321715","2014-02-04","1","0","2014-02-10","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("141","97","0","4792191","2014-02-04","0","0","2014-02-05","12","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("143","10","0","2392915","2014-02-04","0","0","2014-02-07","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("144","88","0","6092036","2014-02-04","0","0","2014-02-05","20","","11","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("145","31","0","7582203","2014-02-04","0","0","2014-02-05","20","","8","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("146","59","0","343260","2014-02-04","1","0","2014-02-05","9","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("147","59","0","343261","2014-02-04","1","0","2014-02-05","9","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("148","59","0","343262","2014-02-04","1","0","2014-02-05","9","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("149","59","0","343263","2014-02-04","1","0","2014-02-05","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("150","59","0","343264","2014-02-04","1","0","2014-02-05","9","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("151","54","0","914594","2014-02-04","0","0","2014-02-05","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("152","42","0","660012","2014-02-04","0","0","2014-02-05","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("153","42","0","660013","2014-02-04","0","0","2014-02-05","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("154","22","0","3474214","2014-02-04","0","0","2014-02-05","20","","8","","","2","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("155","22","0","3474215","2014-02-04","0","0","2014-02-05","20","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("156","97","0","4792192","2014-02-04","0","0","2014-02-05","11","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("157","11","0","102033","2014-02-04","0","1","2014-02-05","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("158","22","0","3474216","2014-02-04","0","0","2014-02-05","20","","8","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("169","9","0","2813978","2014-02-04","0","0","2014-02-06","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("159","50","0","630325","2014-02-04","0","0","2014-02-05","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("160","10","0","2392916","2014-02-04","0","0","2014-02-14","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140770","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("161","10","0","2392917","2014-02-04","0","0","2014-02-14","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140770","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("162","113","0","111241","2014-02-04","0","0","2014-02-06","18","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("163","62","0","538002","2014-02-04","0","0","2014-02-05","19.3","","5","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("164","84","0","222081","2014-02-04","1","0","2014-02-10","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("165","7","0","9991628","2014-02-04","1","0","2014-02-07","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("167","8","0","575246","2014-02-04","0","0","2014-02-05","16","","1","","Jabil Circuit \r\nHP \r\nST-D3L08-60002-B-T \r\nD3L08-80101-B","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("166","72","0","1262638","2014-02-04","1","0","2014-02-05","18","","1","","Pactron Incorporated \r\nPAC2888_04February2014_ \r\nWO23968_T(Leaded)","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("168","8","0","575247","2014-02-04","0","0","2014-02-05","16","","1","","Jabil Circuit \r\nHP \r\nST-D3L08-60002-B-B \r\nD3L08-80101-B","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("170","20","0","938643","2014-02-05","0","0","2014-02-06","20","","15","","","2","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("171","20","0","938644","2014-02-05","0","0","2014-02-06","20","","15","","","2","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("172","54","0","914595","2014-02-05","0","0","2014-02-07","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("173","2","0","5346759","2014-02-05","0","1","2014-02-06","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("174","109","0","255701","2014-02-05","0","0","2013-07-26","11","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("175","109","0","255700","2014-02-05","0","0","2013-07-26","11","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("176","5","0","4894439","2014-02-05","1","0","2013-10-16","12","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("177","5","0","4894438","2014-02-05","0","0","2013-10-16","12","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("178","5","0","4894446","2014-02-05","0","0","2013-10-29","11","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("179","5","0","4894447","2014-02-05","0","0","2013-10-29","11","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("180","5","0","4894449","2014-02-05","0","0","2013-10-31","11","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("181","5","0","4894450","2014-02-05","0","0","2013-10-31","11","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("182","7","0","9991421","2014-02-05","0","0","2013-11-05","14","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("183","7","0","9991422","2014-02-05","0","0","2013-11-05","14","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("184","7","0","9991445","2014-02-05","0","0","2013-11-13","11","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("185","7","0","9991446","2014-02-05","0","0","2013-11-13","11","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("186","4","0","321647","2014-02-05","0","0","2013-11-20","16","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("187","4","0","321648","2014-02-05","0","0","2013-11-20","16","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("188","7","0","9991479","2014-02-05","0","0","2013-11-21","11","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("189","7","0","9991478","2014-02-05","0","0","2013-11-21","11","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("190","4","0","321657","2014-02-05","0","0","2013-11-21","14","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("191","4","0","321656","2014-02-05","0","0","2013-11-21","14","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("192","4","0","321664","2014-02-05","0","0","2013-11-22","17","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("193","4","0","321663","2014-02-05","0","0","2013-11-21","17","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("194","4","0","321661","2014-02-05","0","0","2013-11-22","17","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("195","4","0","321662","2014-02-05","0","0","2013-11-22","17","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("196","65","0","8152201","2014-02-05","0","0","2013-11-26","15","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("197","7","0","9991493","2014-02-05","0","0","2013-11-27","13","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("198","65","0","8152200","2014-02-05","0","0","2013-11-27","15","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("199","7","0","9991502","2014-02-05","0","0","2013-12-03","10","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("200","7","0","9991520","2014-02-05","0","0","2013-12-10","12","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("201","7","0","9991531","2014-02-05","0","0","2013-12-12","10","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("202","7","0","9991530","2014-02-05","0","0","2013-12-12","10","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("203","51","0","9931265","2014-02-05","0","0","2013-12-12","10","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("204","7","0","9991539","2014-02-05","0","0","2013-12-16","8","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("205","7","0","9991538","2014-02-05","0","0","2013-12-16","8","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("206","7","0","9991536","2014-02-05","0","0","2013-12-16","8","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("207","9","0","2813952","2014-02-05","0","0","2013-12-10","13","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("208","9","0","2813953","2014-02-05","0","0","2014-05-27","15","","1","","Sanmina Mentor Graphics AVB2 247152","2","2014-05-23 17:53:40","6819","5","Z3","2","2014-05-23 19:07:08","2","2014-05-23 21:30:54","2","2014-05-27 08:07:11","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("209","70","0","1105085","2014-02-05","0","0","2014-02-19","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("210","7","0","9991601","2014-02-05","1","0","2014-02-05","16","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("211","2","0","5346760","2014-02-05","0","0","2014-02-06","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("212","2","0","5346761","2014-02-05","0","0","2014-02-06","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("213","10","0","2392891","2014-02-05","0","0","2014-02-13","18","","1","","ASteelFlash E-BAND COMMUNICATION 200-0331-002 Rev: B 200-0332-002 Rev: B","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("214","10","0","2392892","2014-02-05","0","0","2014-02-13","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("215","5","0","4894472","2014-02-05","0","0","2014-01-08","17","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("216","5","0","4894473","2014-02-05","0","0","2014-01-08","17","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("217","4","0","321685","2014-02-05","0","0","2014-01-09","17","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("218","48","0","174016","2014-02-05","0","0","2014-01-10","9","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("219","48","0","174026","2014-02-05","0","0","2014-01-13","12","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("220","2","0","5346676","2014-02-05","0","0","2014-01-17","14","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("221","40","0","807070","2014-02-05","0","0","2014-01-17","18","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("222","107","0","614132","2014-02-05","0","0","2014-01-20","16","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("223","113","0","111240","2014-02-05","0","0","2014-01-22","20","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("224","70","0","1105102","2014-02-05","0","0","2014-01-23","12","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("225","36","0","6911895","2014-02-05","0","0","2014-01-27","10","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("226","8","0","575235","2014-02-05","0","0","2014-01-29","10","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("227","8","0","575238","2014-02-05","0","0","2014-02-12","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("228","62","0","538107","2014-02-05","0","0","2014-01-29","20","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("229","62","0","538108","2014-02-05","0","0","2014-01-29","20","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("230","5","0","4894482","2014-02-05","0","0","2014-01-30","11","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("231","60","0","890040","2014-02-05","1","0","2014-02-05","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("232","50","0","630322","2014-02-05","0","0","2014-01-27","15","","1","","Waiting for approval.","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("233","8","0","575248","2014-02-05","0","0","2014-02-07","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("234","8","0","575249","2014-02-05","0","0","2014-02-07","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("235","22","0","3474200","2014-02-05","0","0","2014-01-14","20","","8","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("236","22","0","3474194","2014-02-05","0","0","2013-01-02","20","","8","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("237","7","0","9991537","2014-02-05","0","0","2013-12-16","8","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("238","88","0","6092037","2014-02-05","0","0","2014-02-06","18.3","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("239","100","0","140191","2014-02-05","0","0","2014-02-06","20","","15","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("240","1","0","8292470","2014-02-05","0","0","2014-02-06","14","","1","","","2","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("241","93","0","2532075","2014-02-05","0","0","2014-02-06","15","","1","","","2","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("242","100","0","140192","2014-02-05","0","0","2014-02-06","20","","15","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("243","9","0","2813979","2014-02-05","1","0","2014-02-06","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("244","76","0","173008","2014-02-05","0","0","2014-02-06","16","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("245","2","0","5346762","2014-02-05","0","0","2014-02-07","17","","1","","Stepdown","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("246","3","0","5632126","2014-02-05","0","0","2014-02-06","20","","4","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("247","19","0","835248","2014-02-05","0","0","2014-02-06","17","","15","","","2","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("249","97","0","4792193","2014-02-05","0","0","2014-02-06","18","","1","","Surface Art \r\nMonsoon \r\nBIA35A J# 34376","2","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("248","2","0","5346763","2014-02-05","0","1","2014-02-07","8","","1","","Sanmina \r\nVishay \r\nWCSP16","2","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("250","97","0","4792194","2014-02-05","0","0","2014-02-06","18","","1","","Surface Art \r\nMonsoon \r\nLTD98B J# 34553","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("251","34","0","7994717","2014-02-05","0","0","2014-02-07","8","","1","","Creation Tech. \r\nDitech \r\nDIT011-0297-20 Rev 4.01","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("252","34","0","7994718","2014-02-05","0","0","2014-02-07","8","","1","","Creation Tech. \r\nDitech \r\nDIT011-0297-20 Rev. 4.01","2","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("253","72","0","1262639","2014-02-06","1","0","2014-02-06","18","","1","","Pactron Incorporated \r\nPAC2889_06February2014_ \r\nWO24362_T&B, \r\nWO24302_T&B(LeadFree)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("254","7","0","9991634","2014-02-06","0","0","2014-02-07","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("255","7","0","9991635","2014-02-06","0","0","2014-02-07","8","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("256","7","0","9991633","2014-02-06","0","0","2014-02-07","8","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("257","7","0","9991632","2014-02-06","0","0","2014-02-07","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("258","7","0","9991631","2014-02-06","0","0","2014-02-07","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("259","7","0","9991630","2014-02-06","0","0","2014-02-07","8","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("260","10","0","2392918","2014-02-06","0","1","2014-02-19","11","","1","","Design and put on hold until we get P.O.","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("261","10","0","2392919","2014-02-06","0","0","2014-02-19","11","","1","","Design and put on hold until we get P.O.","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("262","10","0","2392920","2014-02-06","0","0","2014-02-06","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("263","19","0","835249","2014-02-06","0","0","2014-02-07","17","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("264","19","0","835250","2014-02-06","0","0","2014-02-07","17","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("265","8","0","575251","2014-02-06","0","0","2014-02-10","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("266","8","0","575252","2014-02-06","0","0","2014-02-10","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("267","97","0","4792195","2014-02-06","0","0","2014-02-07","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("268","7","0","9991636","2014-02-06","0","0","2014-02-07","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("269","7","0","9991637","2014-02-06","0","0","2014-02-07","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("270","88","0","6092038","2014-02-06","0","1","2014-02-11","17","","11","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("271","88","0","6092039","2014-02-06","0","1","2014-02-11","17","","11","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("272","7","0","9991638","2014-02-06","0","0","2014-02-07","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("273","7","0","9991639","2014-02-06","0","0","2014-02-07","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("274","2","0","5346764","2014-02-06","1","0","2014-02-06","18","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("275","97","0","4792196","2014-02-06","1","0","2014-02-06","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("276","2","0","5346765","2014-02-06","0","0","2014-02-07","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("277","110","0","952379","2014-02-06","0","0","2014-02-11","17","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("278","4","0","321729","2014-02-06","0","0","2014-02-07","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("279","51","0","9931329","2014-02-06","0","0","2014-02-07","14.3","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("280","51","0","9931330","2014-02-06","1","0","2014-02-07","8","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("281","59","0","343265","2014-02-13","1","0","2014-02-13","13","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("282","59","0","343266","2014-02-06","1","0","2014-02-07","9","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("283","59","0","343267","2014-02-06","1","0","2014-02-07","9","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("284","4","0","321730","2014-02-06","0","0","2014-02-07","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("289","51","0","9931331","2014-02-06","0","0","2014-02-10","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("285","2","0","5346766","2014-02-06","0","0","2014-02-11","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("286","4","0","321504","2014-02-06","0","0","2014-02-07","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("287","1","0","8292471","2014-02-06","1","0","2014-02-07","10","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("288","1","0","8292472","2014-02-06","1","0","2014-02-07","11","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("290","93","0","2532078","2014-02-07","1","0","2014-02-07","19","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("291","93","0","2532076","2014-02-07","1","0","2014-02-07","19","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("292","93","0","2532077","2014-02-07","1","0","2014-02-07","19","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("293","97","0","4792197","2014-02-07","0","0","2014-02-10","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("294","62","0","538990","2014-02-07","0","0","2014-02-11","19","","5","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("295","62","0","538991","2014-02-07","0","0","2014-02-11","19","","5","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("296","3","0","5632127","2014-02-07","0","0","2014-02-10","20","","3","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("297","7","0","9991640","2014-02-07","1","0","2014-02-07","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","1","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("298","8","0","575254","2014-02-07","0","0","2014-02-10","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("299","8","0","575255","2014-02-07","0","0","2014-02-10","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("300","8","0","575256","2014-02-07","0","0","2014-02-10","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("301","8","0","575257","2014-02-07","1","0","2014-02-13","9","","1","","with templates","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("302","8","0","575258","2014-02-07","1","0","2014-02-12","18","","1","","with templates","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("303","93","0","2532079","2014-02-07","0","0","2014-02-10","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("304","93","0","2532080","2014-02-07","0","0","2014-02-10","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("305","95","0","252618","2014-02-07","0","0","2014-02-10","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("306","95","0","252619","2014-02-07","0","0","2014-02-10","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("307","95","0","252620","2014-02-07","0","0","2014-02-10","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("308","95","0","252621","2014-02-07","0","0","2014-02-10","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("309","1","0","8292473","2014-02-07","1","0","2014-02-07","20","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("310","7","0","999253","2014-02-07","1","0","2014-02-07","18","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("311","6","0","739349","2014-02-07","1","0","2014-02-11","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("312","2","0","5346767","2014-02-07","1","0","2014-02-07","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("313","7","0","9991641","2014-02-07","1","0","2014-02-07","19","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("314","43","0","5413918","2014-02-07","0","0","2014-02-10","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("315","4","0","321732","2014-02-07","0","1","2014-02-26","12","","1","","Please check with Rajesh for Questions","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("316","4","0","321733","2014-02-07","0","1","2014-02-26","12","","1","","Please check with Rajesh for questions.","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("317","2","0","5346768","2014-02-07","0","0","2014-02-10","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("318","2","0","5346769","2014-02-07","0","0","2014-02-10","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("319","59","0","343268","2014-02-07","1","0","2014-02-10","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("320","1","0","8292474","2014-02-07","0","0","2014-02-11","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("321","1","0","8292475","2014-02-07","0","0","2014-02-10","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("322","8","0","575259","2014-02-07","0","0","2014-02-11","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("323","8","0","575260","2014-02-07","0","0","2014-02-11","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("324","10","0","2392921","2014-02-07","1","1","2014-02-11","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("325","2","0","5346770","2014-02-07","0","0","2014-02-11","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("326","2","0","5346771","2014-02-07","0","0","2014-02-10","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("327","11","0","102034","2014-02-07","1","0","2014-02-11","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("328","2","0","5346772","2014-02-07","0","0","2014-02-11","15","","1","","Sanmina Alcatel 82-0563-02 Rev 1 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("329","2","0","5346773","2014-02-07","0","0","2014-02-11","17","","1","","Sanmina Alcatel 82-0563-02 Rev 1 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("330","34","0","7994719","2014-02-07","0","0","2014-02-11","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("331","97","0","4792198","2014-02-07","0","0","2014-02-10","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("332","72","0","1262640","2014-02-10","1","0","2014-02-10","17","","1","","Pactron Incorporated \r\nPAC2892_10February2014_ \r\nWO24017_T(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("333","72","0","1262641","2014-02-10","1","0","2014-02-10","17","","1","","Pactron Incorporated \r\nPAC2893_10February2014_ \r\nWO24017_B(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("334","72","0","1262642","2014-02-10","1","0","2014-02-10","17","","1","","Pactron Incorporated \r\nPAC2894_10February2014_ \r\nWO24018_T(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("335","72","0","1262643","2014-02-10","1","0","2014-02-10","17","","1","","Pactron Incorporated \r\nPAC2895_10February2014_ \r\nWO24018_B(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("336","7","0","9991642","2014-02-10","0","0","2014-02-11","10","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("337","20","0","938645","2014-02-10","0","0","2014-02-11","20","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("338","97","0","4792199","2014-02-10","0","0","2014-02-10","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("339","7","0","9991644","2014-02-10","0","0","2014-02-11","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("340","7","0","9991645","2014-02-10","0","0","2014-02-11","10","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("341","54","0","914596","2014-02-10","0","0","2014-02-11","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("342","7","0","9991646","2014-02-10","0","0","2014-02-11","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("343","7","0","9991647","2014-02-10","0","0","2014-02-11","11","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("344","43","0","5413920","2014-02-10","0","0","2014-02-11","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("345","43","0","5413919","2014-02-10","0","0","2014-02-11","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("346","2","0","5346774","2014-02-10","0","0","2014-02-11","11","","1","","Sanmina \r\nSynopsys  \r\nSH100000057 Rev-2  \r\nSH100000202 rev-1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("347","97","0","4792200","2014-02-10","0","0","2014-02-11","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("348","97","0","4792201","2014-02-10","0","0","2014-02-11","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("349","56","0","8201203","2014-02-10","0","0","2014-02-11","18","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("350","93","0","2532081","2014-02-10","0","0","2014-02-11","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("358","97","0","4792202","2014-02-10","0","0","2014-02-11","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("351","62","0","53811002","2014-02-10","1","0","2014-02-11","19","","4","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("352","8","0","575261","2014-02-10","0","1","2014-02-12","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("353","8","0","575262","2014-02-10","0","1","2014-02-12","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("354","42","0","660016","2014-02-10","0","0","2014-02-12","13","","1","","stepdown","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("355","42","0","660017","2014-02-10","0","0","2014-02-11","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("356","7","0","9991643","2014-02-10","0","0","2014-02-11","11","","1","","SEM HE \r\nFeinmetall GmbH \r\n8VBTJ750-350 C13570:A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140739","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("357","22","0","3474217","2014-02-10","1","0","2014-02-14","19.3","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("359","1","0","8292476","2014-02-10","0","0","2014-02-11","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("360","2","0","5346775","2014-02-10","0","0","2014-02-11","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("361","64","0","4751105","2014-02-10","0","0","2014-02-11","20","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("362","57","0","767095","2014-02-10","0","0","2014-02-11","20","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("363","93","0","2532082","2014-02-10","0","0","2014-02-11","16","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("364","8","0","575263","2014-02-10","0","0","2014-02-12","21","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("365","41","0","832730","2014-02-10","0","0","2014-02-11","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("366","9","0","2813980","2014-02-10","0","0","2014-02-11","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("367","9","0","2813981","2014-02-10","0","0","2014-02-11","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("368","59","0","343269","2014-02-10","1","0","2014-02-11","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("369","8","0","575239","2014-02-10","0","0","2014-02-12","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("370","72","0","1262644","2014-02-11","1","0","2014-02-11","18","","1","","Pactron Incorporated \r\nPAC2899_11February2014 \r\nWO23595_T,WO24000_T \r\n(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("371","72","0","1262645","2014-02-11","1","0","2014-02-11","18","","1","","Pactron Incorporated \r\nPAC2901_11February2014 \r\nWO23595_B,WO24000_B \r\n(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("372","31","0","7582204","2014-02-11","0","0","2014-02-12","20","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("373","31","0","7582205","2014-02-11","0","0","2014-02-12","20","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("374","31","0","7582206","2014-02-11","1","0","2014-02-11","17","","10","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("375","10","0","2392922","2014-02-11","1","0","2014-02-12","9","","1","","ASteelFlash \r\nAnritsu \r\n3-80228-3P1 rev 1","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("376","111","0","782664","2014-02-11","0","0","2014-02-12","20","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("377","8","0","575265","2014-02-11","0","0","2014-02-14","9","","1","","Jabil Circuit Grass Valley ST-GD771063500 rev R07GD399063500 rev R01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("378","8","0","575266","2014-02-11","0","0","2014-02-14","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("379","97","0","4792203","2014-02-11","1","0","2014-02-11","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("380","9","0","2813982","2014-02-11","0","0","2014-02-12","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("381","51","0","9931334","2014-02-11","0","0","2014-02-12","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("382","51","0","9931335","2014-02-11","0","0","2014-02-12","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("383","93","0","2532083","2014-02-11","0","0","2014-02-12","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("384","54","0","914597","2014-02-11","1","0","2014-02-12","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("385","11","0","102035","2014-02-11","0","0","2014-02-12","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("386","11","0","102036","2014-02-11","0","0","2014-02-12","14","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("387","10","0","2392923","2014-02-11","1","0","2014-02-28","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140897","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("388","2","0","5346584","2014-02-11","1","0","2014-02-11","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("389","1","0","8292477","2014-02-11","0","0","2014-02-12","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("390","95","0","252622","2014-02-11","0","0","2014-02-12","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("391","8","0","575269","2014-02-11","0","0","2014-02-12","12","","1","","uses same data as 575270","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("392","8","0","575270","2014-02-11","0","0","2014-02-12","12","","1","","uses the same data as 575269","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("396","72","0","1262646","2014-02-12","1","0","2014-02-13","10","","1","","Pactron Incorporated \r\nPAC2905_12February2014_ \r\nWO23837_T, \r\nWO24353_B(LeadFree)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("393","36","0","6911905","2014-02-11","1","0","2014-02-12","18","","1","","FOXCONN \r\nCisco \r\nU615_00 \r\nfab# 28-11475-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("394","36","0","6911906","2014-02-11","1","0","2014-02-12","0","","1","","FOXCONN \r\nCisco \r\nU615_00 \r\nfab# 28-11475-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("395","97","0","4792204","2014-02-11","1","0","2014-02-12","18","","1","","Surface Art \r\nMonsoon \r\nQE&B49A J# 34542","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("397","72","0","1262647","2014-02-12","1","0","2014-02-12","18","","1","","Pactron Incorporated \r\nPAC2906_12February2014_ \r\nWO24353_T, \r\nWO23837_B(LeadFree)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("398","7","0","9991656","2014-02-12","0","0","2014-02-13","8","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("399","7","0","9991657","2014-02-12","0","0","2014-02-13","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("400","72","0","1262648","2014-02-12","1","0","2014-02-12","18","","1","","Pactron Incorporated \r\nPAC2907_12February2014_ \r\nWO24319_T, \r\nWO24385_T(LeadFree)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("401","20","0","938648","2014-02-12","0","0","2014-02-13","20","","15","","Ascentron \r\nMet One \r\n10420-1 \r\np/n 790-2482","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("402","20","0","938649","2014-02-12","0","0","2014-02-13","20","","15","","Ascentron \r\nMet One \r\n10420-1 \r\np/n 790-2483","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("403","72","0","1262649","2014-02-12","1","0","2014-02-12","18","","1","","Pactron Incorporated \r\nPAC2908_12February2014_ \r\nWO24319_B, \r\nWO24385_B(LeadFree)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("404","20","0","938646","2014-02-12","0","0","2014-02-13","20","","15","","Ascentron \r\nMet One \r\n10410-2 \r\np/n 790-2480","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("405","20","0","938647","2014-02-12","0","0","2014-02-13","20","","15","","Ascentron \r\nMet One \r\n10410-2 \r\np/n 790-2481","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("406","7","0","9991654","2014-02-12","0","0","2014-02-13","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("407","7","0","9991655","2014-02-12","0","0","2014-02-13","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("408","7","0","9991652","2014-02-12","0","0","2014-02-13","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("409","7","0","9991653","2014-02-12","0","0","2014-02-13","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("410","7","0","9991658","2014-02-12","0","0","2014-02-13","8","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("411","7","0","9991659","2014-02-12","0","0","2014-02-13","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("412","7","0","9991650","2014-02-12","0","0","2014-02-13","8","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("413","7","0","9991651","2014-02-12","0","0","2014-02-13","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("414","7","0","9991648","2014-02-12","0","0","2014-02-13","8","","1","","SEM HE Feinmetall GmbH 8VBJ750-039 C13573:A Apt count =","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("415","7","0","9991649","2014-02-12","0","0","2014-02-13","8","","1","","SEM HE Feinmetall GmbH 8VBJ750-039 C13573:A Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("416","46","0","151044","2014-02-12","0","0","2014-02-13","20","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("417","97","0","4792205","2014-02-12","1","0","2014-02-12","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("418","31","0","7582207","2014-02-12","0","0","2014-02-13","20","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("419","8","0","575271","2014-02-12","0","0","2014-02-14","12","","1","","with temp","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("420","8","0","575272","2014-02-12","0","0","2014-02-14","12","","1","","with temp","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("421","93","0","2532084","2014-02-12","0","0","2014-02-14","11","","1","","SMTC Anritsu 3-72848-3 Rev. A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("430","1","0","8292479","2014-02-12","0","0","2014-02-13","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("422","76","0","173009","2014-02-12","0","0","2014-03-10","11","","1","","Piranha EMS, Inc Phase Matrix 2020714-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141061","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("428","50","0","630326","2014-02-12","0","0","2014-02-13","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("424","59","0","343270","2014-02-12","1","0","2014-02-13","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("423","8","0","575268","2014-02-12","0","1","2014-02-14","18","","1","","Nozzle","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("429","97","0","4792206","2014-02-12","0","0","2014-02-13","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("425","4","0","321734","2014-02-12","1","1","2014-02-13","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("426","4","0","321735","2014-02-12","0","1","2014-02-13","14","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("427","1","0","8292478","2014-02-12","0","0","2014-02-13","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("431","8","0","575273","2014-02-12","0","0","2014-02-17","14","","1","","w/template","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("432","8","0","575274","2014-02-12","0","0","2014-02-17","14","","1","","with template","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("433","97","0","4792207","2014-02-12","0","0","2014-02-13","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("434","10","0","2392924","2014-02-12","0","1","2014-02-14","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("435","10","0","2392925","2014-02-12","0","1","2014-02-14","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("436","10","0","2392926","2014-02-12","0","1","2014-02-13","17","","1","","ASteelFlash Tesla 1034827-01-ATES-R  Revision: 01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("437","10","0","2392927","2014-02-12","0","1","2014-02-13","17","","1","","ASteelFlash Tesla 1034827-01-ATES-R  Revision: 01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("438","35","0","800197","2014-02-13","0","0","2014-02-14","8","","1","","Creation Tech. SNJ \r\nIntel NGFF 4UP \r\nFab#25363-201 Rev A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("439","72","0","1262650","2014-02-13","0","0","2014-02-17","0","","0","","Pactron Incorporated PAC2905_12February2014 WO23837_T,WO24353_B LeadFree","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("440","72","0","1262651","2014-02-13","0","0","2014-02-13","18","","1","","Pactron Incorporated \r\nPAC2909_13February2014 \r\nWO24410_T,WO24363_T&B, \r\nWO24348_T(LeadFree)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("441","11","0","102037","2014-02-13","0","0","2014-02-14","10","","1","","Zollner Electronics LUMENIR 1791093-00_54-39-90111 Re 5091069-00","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("442","11","0","102038","2014-02-13","0","0","2014-02-14","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("443","11","0","102039","2014-02-13","0","0","2014-02-17","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("444","11","0","102040","2014-02-13","0","0","2014-02-17","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("445","59","0","343265001","2014-02-13","1","0","2014-02-13","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("446","9","0","2813983","2014-02-13","0","0","2014-02-14","11","","1","","Sanmina NPI lite point 8000-0169-000 rev C1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("447","8","0","575275","2014-02-13","1","0","2014-02-13","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("448","3","0","5632128","2014-02-13","0","0","2014-02-13","18","","4","","Ministencils","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("449","43","0","5413921","2014-02-13","0","0","2014-02-14","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("450","43","0","5413922","2014-02-13","0","0","2014-02-14","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("451","14","0","6171839","2014-02-13","0","0","2014-02-14","12","","1","","ABX Engineering, Inc. Imagize 210-0030 rev 01 / 211-003 U1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("452","36","0","6911907","2014-02-13","0","0","2014-02-18","8","","1","","FOXCONN Arista Fab-00233-02 Top Paste","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("453","36","0","6911908","2014-02-13","0","0","2014-02-18","8","","1","","FOXCONN Arista Fab-00233-02 BOTTOM PASTE","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("454","2","0","5346777","2014-02-13","0","0","2014-02-14","10","","1","","Sanmina MRV 5000682-102R Rev A2","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("455","2","0","5346778","2014-02-13","0","0","2014-02-14","10","","1","","Sanmina MRV 5000682-102R Rev A2","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("456","43","0","5413923","2014-02-13","0","0","2014-02-14","14","","1","","Infiniti Solutions L.S.Research GPC01 Rev A Job","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("457","34","0","7994720","2014-02-13","0","0","2014-02-14","15","","1","","Creation Tech. Alcatel ALC76-0490-04 Rev. 01 TALCS221_LF","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("458","1","0","8292480","2014-02-13","0","0","2014-02-14","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("459","36","0","6911909","2014-02-13","0","0","2014-02-18","8","","1","","FOXCONN Arista Fab-00265-01 Top Paste","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("460","36","0","6911910","2014-02-13","0","0","2014-02-18","8","","1","","FOXCONN Arista Fab-00265-01 Bottom Paste","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("461","70","0","1105106","2014-02-13","0","0","2014-02-14","16","","1","","Oncore TSNA GEP2015@2 TOP SIDE","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("462","70","0","1105107","2014-02-13","0","0","2014-02-14","16","","1","","Oncore TSNA GEP2015@2 BOTTOM SIDE","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("463","8","0","575276","2014-02-13","0","0","2014-02-17","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("464","36","0","6911911","2014-02-13","0","0","2014-02-14","17","","1","","FOXCONN ION 40000330-01 Loc: U1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("465","10","0","2392928","2014-02-13","0","1","2014-02-14","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140727","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("466","10","0","2392929","2014-02-13","0","1","2014-02-14","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140727","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("467","72","0","1262652","2014-02-14","0","0","2014-02-14","18","","1","","Pactron Incorporated \r\nPAC2913_14February2014 \r\nWO24256_T&B(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("468","7","0","9991661","2014-02-14","0","0","2014-02-17","8","","1","","SEM HE \r\nInfineon, Munich(MT GmbH) \r\nM4297 TQFP216 C13318:C","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140750","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("469","7","0","9991662","2014-02-14","0","0","2014-02-17","8","","1","","SEM HE \r\nBAE Systems \r\n1J97AF2C23319:A","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("470","7","0","9991663","2014-02-14","0","0","2014-02-17","8","","1","","SEM HE \r\nBAE Systems \r\n1J97AF2C23319:A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140747","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("471","7","0","9991664","2014-02-14","0","0","2014-02-19","18","","1","","SEM HE \r\nForm Factor Inc. \r\n200-40025(350-40025):1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140719","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("472","7","0","9991665","2014-02-14","0","0","2014-02-17","8","","1","","SEM HE \r\nForm Factor Inc. \r\n200-40025(350-40025):1","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("473","93","0","2532085","2014-02-14","1","0","2014-02-17","17","","1","","SMTC Anr 3-80425-3","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("474","93","0","2532086","2014-02-14","1","0","2014-02-14","17","","1","","SMTC Anr 3-80425-3","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("475","7","0","9991666","2014-02-14","0","0","2014-02-17","8","","1","","SEM HE Form Factor Inc. 200-11070(350-11070):1","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("476","7","0","9991667","2014-02-14","0","0","2014-02-17","8","","1","","SEM HE Form Factor Inc. 200-11070(350-11070):1","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140718","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("477","97","0","47922070001","2014-02-14","1","0","2014-02-14","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("478","31","0","7582208","2014-02-14","0","0","2014-02-17","20","","8","","Controltek  890-1526-0 rev 2 180-1107-2 TOP","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("479","31","0","7582209","2014-02-14","0","0","2014-02-17","20","","1","","Controltek  890-1023-0 REV 5 180-0911-5A TOP BOT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("480","97","0","4792209","2014-02-14","1","0","2014-02-14","15","","1","","Surface Art INTEL(CANADA)  XBT2SB FAB1 / SA J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("481","31","0","7582210","2014-02-14","0","0","2014-02-17","20","","8","","Controltek  890-1023-0 REV 5 180-0911-5A TOP BOT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("482","1","0","8292481","2014-02-14","0","0","2014-02-18","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("483","31","0","7582211","2014-02-14","0","0","2014-02-17","20","","8","","Controltek  890-1438-0 REV D 180-2039-D TOP","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("484","1","0","8292482","2014-02-14","0","0","2014-02-18","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("485","1","0","8292483","2014-02-14","0","0","2014-02-18","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("486","97","0","47921810001","2014-02-14","1","0","2014-02-14","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("487","19","0","835251","2014-02-14","1","0","2014-02-14","17","","15","","CUSTOMER DATAETCHED ON STENCIL","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("488","19","0","835252","2014-02-14","1","0","2014-02-14","17","","15","","Applied Technologies HAL GMWD MODULE 072-212107-001C 212107-1C","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("489","3","0","5632129","2014-02-14","1","0","2014-02-26","18.3","","5","","Mewdowlake ETB rev 1. H11880-001","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("490","8","0","575279","2014-02-14","0","0","2014-02-17","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("491","113","0","111242","2014-02-14","0","0","2014-02-17","18","","1","","Plexus","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("492","76","0","173010","2014-02-14","1","1","2014-02-14","16","","1","","Full reballing set","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("493","4","0","321737","2014-02-14","0","0","2014-02-21","12","","1","","Flextronics Motorola MOT1-575621-001-00 MOT1-575624-001-00 Rev. D","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("494","54","0","914598","2014-02-14","0","0","2014-02-17","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140661","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("495","10","0","2392930","2014-02-14","0","0","2014-02-18","9","","1","","AsteelFlash ANRITSU 3-76596-3P2 3-76596-1-2 rev 2","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("496","42","0","660018","2014-02-14","0","0","2014-02-17","13.3","","1","","nozzle","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("497","43","0","5413924","2014-02-14","0","0","2014-02-17","16","","1","","Infiniti Solutions LATTICE JOB","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("498","43","0","5413925","2014-02-14","0","0","2014-02-17","16","","1","","Infiniti Solutions LATTICE JOB","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("499","2","0","5346779","2014-02-14","1","0","2014-02-18","18","","1","","APERTURE COUNT ALTERA NF5_1932C_HSSI_PLL REV.A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("500","2","0","5346780","2014-02-14","1","0","2014-02-18","18","","1","","APERTURE COUNT ALTERA NF5_1932C_HSSI_PLL REV.A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("501","62","0","538112","2014-02-14","1","0","2014-02-18","19.3","","5","","Micro Systems Eng. MSEI Secondary_Updated DN740","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("502","62","0","538113","2014-02-14","0","0","2014-02-18","19.3","","5","","Micro Systems Eng. MSEI Primary_Updated U1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("503","63","0","169006","2014-02-14","0","0","2014-02-17","17","","1","","Mosaic Industries, Inc  W-DA24/7-V05","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("504","63","0","169005","2014-02-14","0","0","2014-02-17","17","","1","","Mosaic Industries, Inc  W-USB-V03","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("505","34","0","7994721","2014-02-14","0","0","2014-02-17","17","","1","","Creation Tech. Alcatel ALC76-0663-01 Rev. 01 TALCS223_LF","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("506","34","0","7994722","2014-02-14","0","0","2014-02-17","17","","1","","Creation Tech. Alcatel ALC76-0663-01 Rev. 01 TALCS223_LF","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("507","7","0","9991668","2014-02-14","1","0","2014-02-18","14.3","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("508","51","0","9931336","2014-02-14","0","0","2014-02-17","17","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("509","34","0","7994723","2014-02-14","0","0","2014-02-17","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("510","8","0","575280","2014-02-14","0","0","2014-02-17","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("511","72","0","1262653","2014-02-17","1","0","2014-02-18","8","","1","","Pactron Incorporated \r\nPAC2916_17February2014 \r\nWO24478_T,WO24393_T \r\nWO24443_T&B(LeadFree)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("512","57","0","767096","2014-02-17","0","0","2014-02-18","20","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("513","72","0","1262654","2014-02-17","1","0","2014-02-18","8","","1","","Pactron Incorporated \r\nPAC2917_17February2014 \r\nWO23838_T,WO23839_T \r\nWO23831_T,WO23832_TLeaded","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("514","7","0","9991669","2014-02-17","0","0","2014-02-18","8","","1","","SEM HE SV Probe PCU-000478-5A:A Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("515","7","0","9991670","2014-02-17","0","0","2014-02-18","8","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("516","100","0","1401932","2014-02-17","0","0","2014-02-17","20","","15","","Synergetics Elecraft E850578 / E100472 1.6","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("517","11","0","102041","2014-02-17","0","0","2014-02-18","10","","1","","Skyera  1786145-00 (A13024_A2)  1786145-00 5090465-00","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("518","11","0","102042","2014-02-17","0","0","2014-02-18","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("519","11","0","102043","2014-02-17","1","0","2014-02-17","18","","1","","Zollner Electronics Aehr 1791095-00 5091115-00","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("520","19","0","835253","2014-02-17","0","0","2014-02-18","17","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("521","19","0","835254","2014-02-17","0","0","2014-02-18","17","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("522","19","0","835255","2014-02-17","0","0","2014-02-18","17","","15","","MSB EM TX/RX 212422-1C","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("523","19","0","835256","2014-02-17","0","0","2014-02-18","17","","15","","MSB EM TX/RX 212422-1C","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("524","19","0","835257","2014-02-17","0","0","2014-02-18","17","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("525","19","0","835258","2014-02-17","0","0","2014-02-18","17","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("526","34","0","7994724","2014-02-17","0","0","2014-02-18","11","","1","","Creation Tech. Alcatel ALC76-0501-04 Rev. 01 TALCS222_LF","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("527","34","0","7994725","2014-02-17","0","0","2014-02-18","11","","1","","Creation Tech. Alcatel ALC76-0501-04 Rev. 01 TALCS222_LF","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("528","11","0","102044","2014-02-17","1","0","2014-02-17","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("529","19","0","835261","2014-02-17","0","0","2014-03-03","17","","15","","Applied Technologies  070-209695-002 B","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140944","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("530","19","0","835262","2014-02-17","0","0","2014-03-03","17","","15","","Applied Technologies  070-209695-002 B","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140944","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("538","31","0","7582212","2014-02-17","0","0","2014-02-18","20","","8","","Controltek  890-1554-0 180-2103-A TOP","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("531","2","0","5346781","2014-02-17","0","0","2014-02-18","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("532","76","0","173011","2014-02-17","0","0","2014-02-17","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("533","70","0","1105108","2014-02-17","0","0","2014-02-19","19","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140730","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("534","70","0","1105109","2014-02-17","0","0","2014-02-19","19","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140730","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("535","78","0","311053","2014-02-17","0","0","2014-02-18","17","","10","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("536","59","0","343272","2014-02-17","1","0","2014-02-18","9","","1","","Meritronics Seebright 0045.00000002 KWJ ULPM-3SP-CO-1000F-TD","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("537","59","0","343273","2014-02-17","1","0","2014-02-18","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("539","31","0","7582213","2014-02-17","0","0","2014-02-18","20","","8","","Controltek  890-1555-0 180-2104-A TOP","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("540","31","0","7582214","2014-02-17","0","0","2014-02-18","17","","8","","Controltek  890-0724-0 180-0713-A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("541","5","0","4894489","2014-02-17","0","0","2014-02-18","18","","1","","OnCore Manufacturing \r\nOrbotech \r\n1014700 REV A01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("542","10","0","2392931","2014-02-18","0","0","2014-02-19","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("543","97","0","47921950002","2014-02-18","0","0","2014-02-18","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("544","31","0","7582215","2014-02-18","0","0","2014-02-19","17","","8","","Controltek  890-1549-0 180-2099-B TOP","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("545","20","0","938650","2014-02-18","0","0","2014-02-19","17","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140690","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("546","42","0","660019","2014-02-18","0","0","2014-02-19","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("554","2","0","5346783","2014-02-18","0","0","2014-02-19","14","","1","","Sanmina Ruckus 120-11267-001 Rev-1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140717","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("547","51","0","9931337","2014-02-18","0","0","2014-02-19","11","","1","","Javad Javad 05-630101-01 Rev 3.1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("548","51","0","9931338","2014-02-18","0","0","2014-02-19","11","","1","","Javad Javad 05-630101-01 Rev 3.1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("549","76","0","173012","2014-02-18","0","0","2014-02-19","12","","1","","Piranha EMS, Inc Gucci Digital 181-00818-001","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140738","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("550","2","0","5346782","2014-02-18","0","0","2014-02-19","12","","1","","Sanmina Ruckus 120-11266 Rev-1.1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140716","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("551","51","0","9931339","2014-02-18","0","0","2014-02-19","13","","1","","Javad,Schilling Robotics 101-4714-1 Rev F","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("552","11","0","102045","2014-02-18","0","0","2014-02-24","9","","1","","Zollner Electronics HANSEN MEDICAL ASSY: 1761892-00_11759 5091185-00","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140806","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("553","11","0","102046","2014-02-18","0","0","2014-02-19","13","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("555","51","0","9931340","2014-02-18","0","0","2014-02-19","15","","1","","Javad Javad 05-570010-01 Rev 2.1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("556","59","0","3432730002","2014-02-18","1","0","2014-02-19","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("557","93","0","2532087","2014-02-18","0","0","2014-02-19","15","","1","","SMTC LeCroy 923802","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140734","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("558","93","0","2532088","2014-02-18","0","0","2014-02-19","15","","1","","SMTC LeCroy 923802","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140734","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("559","17","0","637613","2014-02-18","0","0","2014-02-19","15","","1","","Agilent Technologies Rick Workman LT3476 V1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140723","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("560","1","0","8292484","2014-02-18","0","0","2014-02-19","15","","1","","Foxconn iDSBG IDSBG 820-3686-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140720","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("561","43","0","5413926","2014-02-18","0","0","2014-02-19","15","","1","","Infiniti Solutions SILICON LABS JOB","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140724","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("562","43","0","5413927","2014-02-18","0","0","2014-02-19","15","","1","","Infiniti Solutions SILICON LABS JOB","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140724","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("563","75","0","170029","2014-02-18","0","0","2014-02-26","17","","1","","Pelco Pelco PA01-0071-00D0","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140896","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("564","8","0","5752800002","2014-02-18","1","0","2014-02-18","19","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("565","51","0","9931341","2014-02-18","0","0","2014-02-19","16","","1","","Javad Javad 05-640070-01 Rev 1.1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("566","89","0","973453","2014-02-18","0","0","2014-02-19","15","","1","","SEM REWORK BGA 0A8667","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140725","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("567","107","0","614135","2014-02-18","0","0","2014-03-13","18","","1","","Texas Instruments  CSP-YZF-8","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141178","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("568","107","0","614136","2014-02-18","0","0","2014-03-13","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141178","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("569","107","0","614133","2014-02-18","0","0","2014-03-14","14","","1","","Texas Instruments  KGOD2","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("570","107","0","614134","2014-02-18","0","0","2014-03-04","15","","1","","Texas Instruments  3638-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140968","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("571","2","0","5346784","2014-02-18","0","0","2014-02-21","8","","1","","Sanmina Newisys PCA-00571-01-B Rev-1A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140760","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("572","2","0","5346785","2014-02-18","0","0","2014-02-20","8","","1","","Sanmina Newisys PCA-00571-01-B Rev-1A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140726","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("605","57","0","767097","2014-02-19","0","0","2014-02-20","17","","8","","MEC Northwest Co ADEC 300027 Rev 11.","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140748","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("573","72","0","1262656","2014-02-19","1","0","2014-02-19","18","","1","","Pactron Incorporated \r\nPAC2920_19February2014_ \r\nWO23842_T(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140729","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("574","72","0","1262657","2014-02-19","1","0","2014-02-19","18","","1","","Pactron Incorporated \r\nPAC2921_19February2014_ \r\nWO24255_T(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140731","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("575","72","0","1262658","2014-02-19","1","0","2014-02-19","18","","1","","Pactron Incorporated \r\nPAC2922_19February2014_ \r\nWO24255_B(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140731","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("576","72","0","1262659","2014-02-19","1","0","2014-02-19","18","","1","","Pactron Incorporated \r\nPAC2923_19February2014_ \r\nWO18663_T(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140732","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("577","72","0","1262660","2014-02-19","1","0","2014-02-19","18","","1","","Pactron Incorporated \r\nPAC2924_19February2014_ \r\nWO18663_B(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140731","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("578","72","0","1262661","2014-02-19","1","0","2014-02-19","18","","1","","Pactron Incorporated \r\nPAC2925_19February2014_ \r\nWO24455_T&B(LeadFree)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140715","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("579","7","0","9991673","2014-02-19","0","0","2014-02-25","9","","1","","SEM HE BAE Systems 1J97AF2C23319:A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140814","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("580","7","0","9991674","2014-02-19","0","0","2014-02-20","8","","1","","SEM HE BAE Systems 1J97AF2C23319:A","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("581","7","0","9991671","2014-02-19","0","0","2014-02-20","8","","1","","SEM HE Intel Corp. TTF0830A:A","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("582","7","0","9991672","2014-02-19","0","0","2014-02-20","8","","1","","SEM HE Intel Corp. TTF0830A:A","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("583","62","0","5381120002","2014-02-19","0","0","2014-02-20","19.3","","5","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("584","36","0","6911912","2014-02-19","0","0","2014-02-20","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140722","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("585","7","0","9991677","2014-02-19","0","0","2014-02-27","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140898","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("586","7","0","9991678","2014-02-19","0","0","2014-02-20","10","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("587","7","0","9991675","2014-02-19","0","0","2014-02-20","10","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("588","7","0","9991676","2014-02-19","1","0","2014-02-20","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140791","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("589","72","0","1262662","2014-02-19","0","0","2014-02-20","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140721","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("590","97","0","4792213","2014-02-19","0","0","2014-02-21","8","","1","","Surface Art GENER8(LUMENIS)  LUM-2SCAN8-A / SA J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140753","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("591","97","0","4792214","2014-02-19","0","0","2014-02-20","10","","1","","Surface Art Neato Robotics 915-0058 R-10 J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140733","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("592","62","0","538962","2014-02-19","0","0","2014-02-20","19.3","","5","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140758","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("593","11","0","102047","2014-02-19","0","0","2014-02-26","15","","1","","Zollner Electronics Google 1790170-01 Top, 5 mil","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140849","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("594","11","0","102048","2014-02-19","0","0","2014-02-26","15","","1","","Zollner Electronics Google 1790170-01 Bot, 4 mil","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140849","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("595","8","0","575282","2014-02-19","0","0","2014-02-20","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140746","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("596","51","0","9931342","2014-02-19","0","0","2014-02-20","11","","1","","Javad Javad 05-570109-01 Rev 2.1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("597","51","0","9931343","2014-02-19","0","0","2014-02-20","11","","1","","Javad Javad 05-570109-01 Rev 2.1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("598","4","0","321738","2014-02-19","0","1","2014-02-20","11","","1","","Flextronics AEG Miniaturized asy revB 01005 M1 Qual run Rev B","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("599","8","0","5752660002","2014-02-19","0","0","2014-02-21","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140786","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("600","7","0","9991679","2014-02-19","1","0","2014-02-27","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140892","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("601","7","0","9991680","2014-02-19","0","0","2014-02-20","11","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("602","1","0","8292485","2014-02-19","1","0","2014-02-20","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140740","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("603","7","0","9991681","2014-02-19","0","0","2014-02-25","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140838","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("604","7","0","9991682","2014-02-19","0","0","2014-02-25","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140838","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("606","57","0","767098","2014-02-19","0","0","2014-02-20","17","","8","","MEC Northwest Co ADEC 300027 Rev 11.","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140748","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("607","62","0","5381130002","2014-02-19","0","0","2014-02-20","19.3","","5","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("608","7","0","9991683","2014-02-19","1","0","2014-02-19","19","","1","","Reorder of REF#9991546R\r\n\r\n8 mils thick\r\nEP\r\nNano\r\n29 diet\r\n\r\nconnectors will be\r\nOblong shape\r\nPad size 35.4 mils x 15.95 mils","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140737","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("609","8","0","575267","2014-02-19","0","0","2014-02-26","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140870","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("610","34","0","7994726","2014-02-19","0","0","2014-02-20","14","","1","","Creation Tech. ZNYX 600-0109-005 Rev A TZNYS034","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140759","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("611","9","0","2813984","2014-02-19","0","0","2014-02-20","14","","1","","Sanmina Mentor Graphics SXB2 Fab 236524 Rev B3","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("612","2","0","5346786","2014-02-19","0","0","2014-02-20","14","","1","","Sanmina Alcatel 82-0679-02 Rev 1 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140754","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("613","2","0","5346787","2014-02-19","0","0","2014-02-20","14","","1","","Sanmina Alcatel 82-0679-02 Rev 1 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140754","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("614","59","0","343275","2014-02-19","1","0","2014-02-20","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140735","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("615","1","0","8292486","2014-02-19","0","0","2014-02-21","15","","1","","Foxconn-iDSBG iDSBG 920-5042-02","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140776","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("616","1","0","8292487","2014-02-19","0","0","2014-02-20","15","","1","","Foxconn-iDSBG iDSBG 920-5042-02","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140744","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("617","2","0","5346788","2014-02-19","0","0","2014-02-20","15","","1","","Sanmina Alcatel  82-0521-05 Rev 1 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140751","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("618","93","0","2532090","2014-02-19","1","0","2014-04-17","18","","1","","SMTC Anritsu 76415-3","2","2014-04-17 17:12:00","1651","5","Z2","2","2014-04-17 17:49:30","2","2014-04-17 19:02:27","0","0000-00-00 00:00:00","2","141996","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("619","93","0","2531974","2014-02-19","0","0","2014-02-21","15","","1","","SMTC Lecroy 921406-00 REV.B","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("620","22","0","3474218","2014-02-19","0","0","2014-02-20","16","","1","","Axiom Electronics Pentek 901767022 STB000738","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140757","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("621","23","0","3842132","2014-02-19","1","0","2014-02-20","16","","1","","Benchmark EPIC EP42000377-03 Rev 2.2","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("622","4","0","321741","2014-02-19","0","0","2014-02-20","17","","1","","Flextronics Basis Science BSI-830-00006-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("623","4","0","321740","2014-02-19","0","0","2014-02-21","11","","1","","Flextronics Basis Science BSI-830-00004-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("624","4","0","321739","2014-02-19","0","0","2014-02-21","11","","1","","Flextronics Basis Science BSI-830-00004-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("625","9","0","2813985","2014-02-19","0","0","2014-02-20","16","","1","","Sanmina - SCI, Corp. RDC Assy 131-0722 PCB 132-0722 rev 1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("626","9","0","2813986","2014-02-19","0","0","2014-02-20","16","","1","","Sanmina - SCI, Corp. RDC Assy 131-0722 PCB 132-0722 rev 1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("627","4","0","321742","2014-02-19","0","0","2014-02-20","17","","1","","Flextronics Basis Science BSI-830-00007-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("628","93","0","2532091","2014-02-19","0","0","2014-02-21","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140755","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("629","2","0","5346789","2014-02-19","0","1","2014-02-20","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("630","2","0","5346790","2014-02-19","0","1","2014-02-20","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("631","3","0","5632130","2014-02-19","0","0","2014-02-26","18.3","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140861","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("632","62","0","538806","2014-02-19","0","0","2014-02-21","19.3","","5","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("633","62","0","538769","2014-02-19","0","0","2014-02-21","19.3","","5","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("634","62","0","538772","2014-02-19","0","0","2014-02-21","19.3","","5","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("635","97","0","4792215","2014-02-20","0","0","2014-02-20","10","","1","","Surface Art \r\nLaser Devices \r\n7331-PCBA Rev A J#34535","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140743","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("636","22","0","3474219","2014-02-20","0","0","2014-02-21","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140752","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("637","9","0","2813987","2014-02-20","1","0","2014-02-20","17","","1","","Sanmina - SCI, Corp. \r\nRDC  \r\nAssy 131-0729 \r\nPCB 132-0729 rev 1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("638","9","0","2813988","2014-02-20","0","0","2014-02-21","9","","1","","Sanmina - SCI, Corp. RDC Assy 131-0733 PCB 132-0733 rev 1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("639","9","0","2813989","2014-02-20","0","0","2014-02-21","9","","1","","Sanmina - SCI, Corp. RDC Assy 131-0733 PCB 132-0733 rev 1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("640","9","0","2813990","2014-02-20","0","0","2014-02-21","9","","1","","Sanmina - SCI, Corp. RDC Assy 131-0734 PCB 132-0734 rev 1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("641","31","0","7582216","2014-02-20","0","0","2014-02-21","16","","8","","Controltek  890-1452-1 180-2051-4","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140766","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("642","31","0","7582217","2014-02-20","0","0","2014-02-21","16","","8","","Controltek  890-1452-1 180-2051-4","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140766","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("643","43","0","5413928","2014-02-20","0","0","2014-02-21","11","","1","","Infiniti Solutions NXP LPC824M_XPRE_V2 Rev A Job","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140764","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("644","1","0","8292488","2014-02-20","0","0","2014-02-21","10","","1","","Foxconn iDSBGIDSBG 920-4659-02","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140761","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("645","1","0","8292489","2014-02-20","0","0","2014-02-21","11","","1","","Foxconn iDSBGIDSBG 920-4176-04  q q","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140765","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("646","111","0","782665","2014-02-20","1","0","2014-02-26","17","","8","","Veris  ZT00180-0B","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140867","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("647","111","0","782666","2014-02-20","0","0","2014-02-21","16","","8","","Veris ZT00388-0A  Z206703-0B","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140787","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("648","111","0","782667","2014-02-20","0","0","2014-02-21","16","","8","","Veris ZT00388-0A  Z206703-0B","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("649","22","0","3474220","2014-02-20","0","0","2014-02-21","16","","8","","Axiom Electronics L3 901767005 STB000855","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140783","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("650","2","0","5346792","2014-02-20","0","0","2014-02-21","13","","1","","Sanmina Newisys PCA-00617-03-B Rev-A2","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140772","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("651","2","0","5346791","2014-02-20","0","0","2014-02-21","13","","1","","Sanmina Newisys PCA-00617-03-B Rev-A2","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140772","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("652","97","0","4792216","2014-02-20","1","0","2014-02-21","8","","1","","Surface Art Phase Matrix J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140767","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("653","97","0","4792217","2014-02-20","0","0","2014-02-21","8","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("654","54","0","914599","2014-02-20","0","0","2014-02-21","15","","1","","Marvell Semiconductor Project Gibson3 148DRQFN 200646","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140771","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("655","1","0","8292490","2014-02-20","0","0","2014-02-21","15","","1","","Foxconn-iDSBG iDSBG 920-00030-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140785","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("656","1","0","8292491","2014-02-20","0","0","2014-02-21","15","","1","","Foxconn-iDSBG iDSBG 920-00030-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140773","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("657","51","0","9931344","2014-02-20","0","0","2014-02-21","16","","1","","Javad Javad 05-597703-01 Rev 3.1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("658","51","0","9931345","2014-02-20","0","0","2014-02-21","16","","1","","Javad Javad 05-597703-01 Rev 3.1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("659","1","0","8292492","2014-02-20","1","0","2014-02-21","21","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140778","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("660","97","0","4792218","2014-02-20","1","0","2014-02-24","9","","1","","Surface Art Monsoon LTD98C J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140775","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("661","4","0","321743","2014-02-20","0","0","2014-02-21","16","","1","","Ministencil","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140768","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("662","97","0","4792219","2014-02-21","1","0","2014-02-21","11","","1","","Surface Art Phase Matrix J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140769","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("663","31","0","7582218","2014-02-21","0","0","2014-02-24","16","","8","","Controltek940-0041-0 REV G 180-2021-F TOP","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140777","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("664","7","0","9991684","2014-02-21","0","0","2014-02-24","9","","1","","SEM HE Intel Corp. ITTO-630-0037:2 Apt count =","1","2014-02-21 20:31:30","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("665","7","0","9991686","2014-02-21","0","0","2014-02-24","9","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("666","7","0","9991688","2014-02-21","0","0","2014-02-24","9","","1","","SEM HE NXP Semiconductors USA,  PTN5001 BENCH C26343:A Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140797","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("667","7","0","9991689","2014-02-21","0","0","2014-02-24","9","","1","","SEM HE NXP Semiconductors USA, PTN5001 BENCH C26343:A Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140797","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("668","57","0","767099","2014-02-21","0","0","2014-02-24","20","","1","","Innerspec Tech. 045218-1-1 (205F0213-A)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140800","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("669","57","0","767100","2014-02-21","0","0","2014-02-24","20","","1","","Innerspec Tech. 045218-1-1 (205F0213-A)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140800","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("670","31","0","7582219","2014-02-21","0","0","2014-02-24","20","","8","","Controltek  890-1558-0 180-0807-D TOP","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("671","57","0","767101","2014-02-21","1","0","2014-02-21","16.3","","4","","Charge customer: UPS Red.Microsoft/PPI 045285-1-1 (X866062)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140788","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("672","57","0","767102","2014-02-21","1","0","2014-02-21","16.3","","4","","Charger customer. UPS Red Microsoft/PPI 045285-1-1 (X866062)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140788","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("673","31","0","7582220","2014-02-21","0","0","2014-02-24","20","","8","","Controltek 885-1321-0 980-220888-A TOP BOT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140805","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("674","31","0","7582221","2014-02-21","0","0","2014-02-24","20","","8","","Controltek  885-1321-0 980-220888-A TOP BOT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140810","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("675","5","0","48944890001","2014-02-21","0","0","2014-02-21","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("676","34","0","79946980002","2014-02-21","1","0","2014-02-21","17","","1","","Creation Tech. Alcatel ALC76-0678-01 Rev. 01 TALC215_LF","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140779","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("677","7","0","9991690","2014-02-21","0","0","2014-02-24","11","","1","","SEM HE IBM NewYork 22-14979 LEAK FIX C26360A Apt count =","1","2014-02-21 22:33:49","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("678","7","0","9991691","2014-02-21","0","0","2014-02-24","11","","1","","SEM HE IBM NewYork 22-14979 LEAK FIX C26360A Apt count =","1","2014-02-21 22:34:07","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("679","7","0","9991692","2014-02-21","0","0","2014-02-24","11","","1","","SEM HE NXP SEMICOND. GERMANYGMBH L3114 PCMFA-12X-DA-FPCL: Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140795","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("680","7","0","9991693","2014-02-21","0","0","2014-02-24","11","","1","","SEM HE NXP SEMICOND. GERMANYGMBH L3114 PCMFA-12X-DA-FPCL: Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140795","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("681","107","0","614137","2014-02-21","0","0","2014-03-14","14","","1","","Texas Instruments  5x5","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141214","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("682","59","0","343276","2014-02-21","1","0","2014-02-24","9","","1","","Meritronics Inception 3D Perseus_DB Perseus_DB2 Perseus_Interface","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140784","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("683","5","0","4894491","2014-02-21","0","0","2014-02-25","15","","1","","OnCore Manufacturing Christie Digital Systems  CHR-001-112121-03 REV 002 RoHS","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("684","5","0","4894492","2014-02-21","1","0","2014-02-25","15","","1","","OnCore Manufacturing Christie Digital Systems  CHR-001-112121-03 REV 002 RoHS","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140832","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("685","75","0","170030","2014-02-21","0","0","2014-02-26","17","","1","","Pelco PELCO PA01-0037-00B0","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140896","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("686","4","0","321744","2014-02-21","0","1","2014-02-24","15","","1","","Flextronics 4XSimba cable FPC","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("687","1","0","8292493","2014-02-21","1","0","2014-02-24","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140801","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("688","97","0","4792221","2014-02-21","0","0","2014-02-24","11","","1","","Surface Art Linear 700-0187-0002  Rev 00A / SA J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140796","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("689","23","0","3842133","2014-02-21","0","0","2014-02-25","11","","1","","Benchmark AUR20-10115-3 REV D PCA AUR21-10115 REV D PCB BOT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("690","7","0","9991685","2014-02-21","0","0","2014-02-24","9","","1","","SEM HE \r\nIntel Corp. \r\nITTO-630-0037:2","1","2014-02-21 20:31:45","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("692","72","0","1262665","2014-02-24","1","0","2014-02-24","9","","1","","Pactron Incorporated \r\nPAC2932_24February2014_ \r\nWO24503_B, \r\nWO24393_T(LeadFree)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140789","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("691","7","0","9991687","2014-02-22","0","0","2014-02-24","9","","1","","SEM HE \r\nInfineon (MT GmbH) \r\nM4817_X4 C13544:A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140798","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("693","72","0","1262666","2014-02-24","1","0","2014-02-24","18","","1","","Pactron Incorporated \r\nPAC2933_24February2014_ \r\nWO24445_T&B(LeadFree)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140790","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("694","4","0","3217370002","2014-02-24","1","0","2014-02-24","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("695","51","0","9931340001","2014-02-24","0","0","2014-02-24","16","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("696","95","0","252623","2014-02-24","1","0","2014-02-24","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140803","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("697","22","0","34742080001","2014-02-24","1","0","2014-02-24","19.3","","4","","Axiom Electronics \r\nL3 ALST \r\n901767047 \r\nSTB000841","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140802","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("698","9","0","2813991","2014-02-24","1","0","2014-02-24","16","","1","","Sanmina LitePoint 8000-0279-000 rev E1 Fab 1700-0279-000 rev E1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("699","9","0","2813992","2014-02-24","1","0","2014-02-24","16","","1","","Sanmina LitePoint 8000-0279-000 rev E1 Fab 1700-0279-000 rev E1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("700","51","0","9931347","2014-02-24","0","0","2014-02-25","11","","1","","Javad Net Optics 650-1356-001 Rev D","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("701","51","0","9931348","2014-02-24","0","0","2014-02-25","11","","1","","Javad Net Optics 650-1356-001 Rev D","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("702","93","0","2532092","2014-02-24","1","0","2014-02-24","19","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140809","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("703","93","0","2532093","2014-02-24","1","0","2014-02-24","19","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140809","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("704","22","0","3474222","2014-02-24","1","0","2014-02-24","19.3","","4","","Axiom Electronics 905000371 BMS STB000853","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140812","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("705","54","0","914601","2014-02-24","0","0","2014-02-25","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140819","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("706","100","0","140194","2014-02-24","0","0","2014-02-25","17","","15","","Synergetics Elecraft E850580 / E100475","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140831","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("707","54","0","914600","2014-02-24","0","0","2014-02-25","11","","1","","mARVELL Marvell Semiconductor 02_Raptor2_2156_F1_A1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140815","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("708","55","0","983088","2014-02-24","0","0","2014-02-25","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140817","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("709","97","0","4792220","2014-02-24","1","0","2014-02-24","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140804","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("710","97","0","4792223","2014-02-24","0","0","2014-02-25","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140823","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("711","93","0","2532094","2014-02-24","1","0","2014-02-25","13","","1","","SMTC Anr 72204-3","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140827","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("712","59","0","343277","2014-02-24","1","0","2014-02-25","9","","1","","Meritronics EFI 45124602 Rev.U1 EFI 45123981 Rev.U1 Accutrace ASSY","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140813","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("713","8","0","5752440002","2014-02-24","1","0","2014-02-25","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("714","97","0","4792224","2014-02-24","1","0","2014-02-25","15","","1","","Surface Art Aptina Imaging AR0230 NT SER REV 0.1 J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140837","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("715","93","0","2532095","2014-02-24","0","0","2014-02-25","16","","1","","SMTC Anr 3-80169-3","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140828","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("716","93","0","2532096","2014-02-24","0","0","2014-02-25","16","","1","","SMTC Anr 3-80167-3","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140840","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("717","41","0","832731","2014-02-24","0","0","2014-02-25","11","","1","","AOSENSE_TRF_SWITCH-3GHZ.2 ALERTUS_1501S/ BIAS_SUPPL","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140821","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("718","97","0","4792225","2014-02-24","0","0","2014-02-25","17","","1","","Surface Art INTEL(CANADA)  XBT2B FAB 201 / J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140830","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("719","4","0","3217370003","2014-02-24","0","0","2014-02-27","9","","1","","Flextronics Motorola MOT1-575621-001-00 MOT1-575624-001-00 Rev. D","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("720","1","0","8292494","2014-02-24","0","0","2014-02-25","11","","1","","Foxconn-iDSBG 820-3500-03 U5000","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140818","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("721","51","0","9931349","2014-02-24","0","0","2014-02-25","17","","1","","Javad SpaceX 00089226-501 Rev A2","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("722","51","0","9931350","2014-02-24","0","0","2014-02-25","17","","1","","Javad SpaceX 00089226-501 Rev A2","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("723","97","0","4792226","2014-02-24","0","0","2014-02-25","17","","1","","Surface Art Neato Robotics 915-0070 R-A J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140833","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("724","2","0","5346793","2014-02-24","0","0","2014-02-25","11","","1","","Sanmina Moog 8040-2039-01 Rev-2","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140816","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("725","97","0","4792222","2014-02-24","0","0","2014-02-25","11","","1","","Surface Art \r\nOculus \r\nDK2 Rev 3.2 J#34651","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140835","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("726","10","0","2392932","2014-02-25","1","0","2014-02-25","15","","1","","AsteelFlash \r\nE-Band  \r\n200-0740-001 \r\nLOC:U7","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140826","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("727","10","0","2392933","2014-02-25","1","0","2014-02-25","15","","1","","AsteelFlash \r\nE-Band  \r\n200-0740-001 \r\nLOC-U20","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140826","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("728","72","0","1262667","2014-02-25","0","0","2014-02-27","18","","1","","Pactron Incorporated \r\nPAC2934_25February2014 \r\nWO24516_T,WO24493_B \r\n(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140848","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("729","20","0","938651","2014-02-25","1","0","2014-02-25","17","","10","","Ascentron Cipher  12252 p/n 790-2490","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140834","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("730","20","0","938652","2014-02-25","1","0","2014-02-25","17","","10","","Ascentron Cipher 12724 p/n 790-2491","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140829","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("731","31","0","7582222","2014-02-25","1","0","2014-02-25","17","","10","","Controltek  890-1088-0 180-0965-0","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140836","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("732","31","0","7582223","2014-02-25","1","0","2014-02-25","17","","10","","Controltek  890-1088-0 180-0965-0","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140836","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("733","34","0","7994616","2014-02-25","0","0","2014-02-26","10","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("734","34","0","79946800002","2014-02-25","0","0","2014-02-26","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140844","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("735","34","0","79946160002","2014-02-25","0","0","2014-02-26","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("736","10","0","2392934","2014-02-25","1","0","2014-02-25","15","","1","","AsteelFlash E-Band  200-0740-001 U7","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("737","10","0","2392935","2014-02-25","1","0","2014-02-25","15","","1","","AsteelFlash E-Band 200-0740-001 U20","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("738","22","0","3474223","2014-02-25","1","0","2014-02-25","19.3","","4","","Axiom Electronics Boeing 901767029 STB000856","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140847","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("739","3","0","5632131","2014-02-25","0","0","2014-02-26","19.3","","5","","Intel Corporation Sunnyslope SJR 093/125 PB","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("740","3","0","5632132","2014-02-25","0","0","2014-02-26","19.3","","5","","Intel Corporation Stone Peak JEDEC PB","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("741","70","0","1105110","2014-02-25","0","0","2014-02-26","10","","1","","Oncore TTHF 4-0702-089@B TOP SIDE","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("742","34","0","7994730","2014-02-25","1","0","2014-02-25","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140839","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("743","51","0","9931351","2014-02-25","0","0","2014-02-26","10","","1","","Javad Tempsys CP-310B Rev 300","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("744","51","0","9931352","2014-02-25","0","0","2014-02-26","10","","1","","Javad Tempsys CP-310B Rev 300","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("745","7","0","9991694","2014-02-25","0","0","2014-02-26","11","","1","","SEM HE STM Catania (MT GmbH) STLED110/2 PC C13568:A Apt count =","1","2014-02-25 16:22:15","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("746","7","0","9991695","2014-02-25","0","0","2014-02-26","11","","1","","SEM HE STM Catania (MT GmbH) STLED110/2 PC C13568:A Apt count =","1","2014-02-25 16:21:57","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("747","76","0","173013","2014-02-25","1","1","2014-02-25","17","","1","","Piranha EMS, Inc Purewave Networks PA 580-00819-001","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140845","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("748","8","0","575289","2014-02-25","0","0","2014-02-27","17","","1","","Minifoils,  12mil","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("749","7","0","9991696","2014-02-25","0","0","2014-03-04","10","","1","","SEM HE Form Factor Inc. 200-4269(350-4269):1 Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140951","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("750","7","0","9991697","2014-02-25","0","0","2014-02-26","11","","1","","SEM HE Form Factor Inc. 200-4269(350-4269):1 Apt count =","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("751","45","0","724055","2014-02-25","0","0","2014-02-26","11","","1","","International Rectifier International Rectifier","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140850","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("752","7","0","9991700","2014-02-25","0","0","2014-02-28","17","","1","","SEM HE Wentworth Laboratories 4-914-0398:A_54651A1 Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140910","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("753","7","0","9991701","2014-02-25","0","0","2014-02-26","11","","1","","SEM HE Wentworth Laboratories 4-914-0398:A_54651A1 Apt count =","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("754","7","0","9991698","2014-02-25","0","0","2014-02-26","11","","1","","SEM HE Feinmetall GmbH 8VBTJ750-102 C13105:A Apt count =","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("755","7","0","9991699","2014-02-25","0","0","2014-02-28","17","","1","","SEM HE Feinmetall GmbH 8VBTJ750-102 C13105:A Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140908","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("756","7","0","9991702","2014-02-25","0","0","2014-02-28","17","","1","","SEM HE NXP SEMICOND.GERMANY GmbH WISPAX1 PROBECARD C13563A Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140911","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("757","7","0","9991703","2014-02-25","1","0","2014-02-28","17","","1","","SEM HE NXP SEMICOND.GERMANY GmbH WISPAX1 PROBECARD C13563A Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140911","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("758","31","0","7582224","2014-02-25","0","0","2014-02-26","16","","8","","Controltek  997-7783-0 997-7783-0 TOP","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140854","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("759","101","0","471620","2014-02-25","0","0","2014-02-27","19.3","","5","","Stencil with Tooling needs to ship together","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("760","31","0","7582225","2014-02-25","0","0","2014-02-26","16","","8","","Controltek  890-1483-0 180-2065-000","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140860","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("761","97","0","4792227","2014-02-25","1","0","2014-02-26","9","","1","","Surface Art Monsoon BIA40A J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140841","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("762","103","0","504352","2014-02-25","0","0","2014-03-04","17","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("763","8","0","575292","2014-02-25","0","0","2014-02-26","10","","1","","12 mil foil for nozzle","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("764","59","0","343278","2014-02-25","1","0","2014-02-26","9","","1","","Meritronics Inception 3D Preseus-Y Inception 3D Preseus-Z","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140842","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("765","51","0","9931353","2014-02-25","0","0","2014-02-26","15","","1","","Schilling Robotics 005-9612 Rev","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("766","111","0","782668","2014-02-25","0","0","2014-02-26","17","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140858","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("767","111","0","782669","2014-02-25","0","0","2014-02-26","17","","8","","Invoice","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140787","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("768","9","0","2813993","2014-02-25","0","0","2014-02-26","16","","1","","Sanmina Lite Point 802-11-P7AL-C1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("769","9","0","2813994","2014-02-25","0","0","2014-02-26","16","","1","","Sanmina Lite Point 800-0082-000 rev  1700-0082-0A1 rev A1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("770","9","0","2813995","2014-02-25","0","0","2014-02-26","16","","1","","Sanmina Lite Point 800-0082-000 rev 1700-0082-0A1 rev A1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("771","117","0","797030","2014-02-25","0","0","2014-02-26","16","","1","","Brocade Communications Cobra 2 BGA BGA2577 51x51 1mm","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140869","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("772","93","0","25320720002","2014-02-25","0","0","2014-02-26","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140852","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("773","97","0","4792228","2014-02-25","0","0","2014-02-26","16","","1","","Surface Art PELCO PA02-0117-00A0 J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140853","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("774","97","0","4792229","2014-02-25","0","0","2014-02-26","16","","1","","Surface Art Pelco PA05-0133-00A0 J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140851","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("775","9","0","2813996","2014-02-25","0","0","2014-02-26","17","","1","","Sanmina - SCI, Corp. \r\nRDC \r\nAssy 131-0728 \r\nPCB 132-0728 rev 1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("776","9","0","2813997","2014-02-25","0","0","2014-02-26","17","","1","","Sanmina - SCI, Corp. \r\nRDC \r\nAssy 131-0728 \r\nPCB 132-0728 rev 1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("777","4","0","321747","2014-02-26","0","0","2014-02-27","18","","1","","Flextronics Agilent AGI-G4585-61010","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("778","4","0","321748","2014-02-26","0","0","2014-02-27","18","","1","","Flextronics Agilent  AGI-G4592-61010","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("779","4","0","321749","2014-02-26","0","0","2014-02-27","18","","1","","Flextronics Agilent  AGI-G4585-61020","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("780","72","0","1262668","2014-02-26","0","0","2014-02-26","18","","1","","Pactron Incorporated PAC2936_25February2014 WO24069_B(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140859","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("781","72","0","1262669","2014-02-26","1","0","2014-02-26","17","","1","","Pactron Incorporated \r\nPAC2937_26February2014_ \r\nWO24389_T&B(LeadFree)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140857","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("782","43","0","5413929","2014-02-26","0","0","2014-02-27","8","","1","","Infiniti Solutions Job","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("783","51","0","9931354","2014-02-26","0","0","2014-02-27","9","","1","","Javad Synopsys SNPS015 Rev 1.4","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("784","20","0","938653","2014-02-26","1","0","2014-02-26","17","","4","","Ascentron Met One 10650-3 p/n 790-2469","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140866","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("785","20","0","938654","2014-02-26","1","0","2014-02-26","17","","4","","Ascentron Met One 10650-3 p/n 790-2470","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140866","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("786","4","0","321750","2014-02-26","0","0","2014-02-27","10","","1","","Flextronics GE Medical GEC-2072594-001","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("863","2","0","5346796","2014-02-28","0","0","2014-03-03","14","","1","","Sanmina Newisys PCA-00573-01-B Rev-1A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140930","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("787","93","0","2532098","2014-02-26","0","0","2014-02-27","10","","1","","","1","2014-02-26 12:05:43","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("788","23","0","3842134","2014-02-26","0","1","2014-02-27","10","","1","","Benchmark PB001-363-861 TESTED PB001-279-519 UNTESTED","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("789","22","0","34742140002","2014-02-26","1","0","2014-02-26","19.3","","4","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140862","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("790","23","0","3842135","2014-02-26","0","0","2014-02-27","11","","1","","Benchmark 001-271-410","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("791","23","0","3842136","2014-02-26","1","0","2014-02-27","9","","1","","Benchmark PB000-279-805 PCA PB000-280-068 PCB","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("792","31","0","7582226","2014-02-26","0","0","2014-02-27","16","","8","","Controltek  890-1479-0 180-1098-2","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140877","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("793","23","0","3842137","2014-02-26","0","0","2014-02-27","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("794","3","0","5632133","2014-02-26","0","0","2014-02-28","19.3","","5","","ntel Trace Via DOE-Primary PB","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140909","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("795","20","0","938655","2014-02-26","0","0","2014-02-27","17","","15","","Ascentron Diamond Traffic 788-TOTALIZER P/N 790-2492","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140878","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("796","8","0","575293","2014-02-26","0","0","2014-02-27","15","","1","","Jabil Circuit Sable SB203102 BU14","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140883","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("797","22","0","3474225","2014-02-26","0","0","2014-03-03","17","","8","","Axiom Electronics AMAT 901767059 STB000855","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140935","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("808","11","0","102049","2014-02-26","0","0","2014-02-27","16","","1","","Zollner Electronics Bruker 1723340-02_394066301 RevC 5091314-00","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("798","59","0","343279","2014-02-26","1","0","2014-02-27","9","","1","","Meritronics Accutrace 20by12BOM1-14V1 EFI 45125806 LED Rev.U1 Ferroct 0620-6862-0 Rev.1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140865","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("799","34","0","79947300002","2014-02-26","0","0","2014-02-27","14","","1","","","2","2014-02-26 14:30:10","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("800","8","0","575294","2014-02-26","1","0","2014-02-26","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("801","4","0","321751","2014-02-26","0","0","2014-02-27","15","","1","","Flextronics Abbott  THR-90000075-102","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("802","1","0","8292495","2014-02-26","0","0","2014-02-27","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140876","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("803","54","0","9145950002","2014-02-26","1","0","2014-02-27","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("804","31","0","7582227","2014-02-26","0","0","2014-02-27","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140877","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("805","4","0","321752","2014-02-26","0","0","2014-02-27","15","","1","","Flextronics Abbott THR-90000125-102","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("806","8","0","575290","2014-02-26","0","0","2014-03-03","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("807","97","0","4792230","2014-02-26","0","0","2014-02-27","16","","1","","Surface Art Oculus Rotate-001 J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140880","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("809","51","0","9931355","2014-02-26","0","0","2014-02-27","16","","1","","Javad Javad 05-631100-02 Rev 2.2","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("810","9","0","2813998","2014-02-26","0","1","2014-02-27","17","","1","","Sanmina - SCI, Corp. RDC Assy 131-0721 PCB 132-0721 rev 1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("811","68","0","793106","2014-02-26","0","0","2014-03-03","17","","10","","Shipping will be arranged later,Oeco  Flexible Power Board P/N: 96771-1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140945","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("812","68","0","793107","2014-02-26","0","0","2014-03-06","17","","10","","Shipping will be arranged laterOeco  95056","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141038","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("813","4","0","321753","2014-02-26","0","0","2014-02-27","17","","1","","Flextronics GE Medical GEC-2057401-001","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("814","97","0","4792231","2014-02-26","0","0","2014-02-27","17","","1","","Surface Art Monsoon MPA01A J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140881","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("815","34","0","7994733","2014-02-26","0","0","2014-02-27","17","","1","","Creation Tech. Alcatel ALC76-0676-01 Rev. 01 TALCS226_LF","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140882","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("816","34","0","7994734","2014-02-26","0","0","2014-02-27","17","","1","","Creation Tech. Alcatel ALC76-0676-01 Rev. 01 TALCS226_LF","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140882","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("817","11","0","102050","2014-02-26","0","0","2014-02-28","18","","1","","Zollner Electronics \r\nHansen Medical \r\n1786344-00_20869 \r\nPCB-E01059-03R","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140948","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("818","68","0","793105","2014-02-26","0","0","2014-03-03","17","","10","","Shipping will be arranged later,Oeco Flexible Power Board P/N: 96771-1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140945","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("822","34","0","7994735","2014-02-27","0","0","2014-02-28","9","","1","","Creation Tech. Alcatel ALC76-0676-01 Rev. 01 TALCS227_LF","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140888","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("819","72","0","1262670","2014-02-27","1","0","2014-02-27","18","","1","","Pactron Incorporated PAC2938_27February2014 WO24394_T","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140891","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("820","72","0","1262671","2014-02-27","0","0","2014-02-27","18","","1","","Pactron Incorporated PAC2939_27February2014 WO24494_B(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140890","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("821","72","0","1262672","2014-02-27","0","0","2014-02-27","18","","1","","Pactron Incorporated PAC2940_27February2014 WO23855_T(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140889","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("823","34","0","7994736","2014-02-27","0","0","2014-02-28","9","","1","","Creation Tech. Alcatel ALC76-0676-01 Rev. 01 TALCS227_LF","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140888","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("824","54","0","914603","2014-02-27","0","0","2014-02-28","10","","1","","Marvell Semiconductor Project HeliosH 316TFBGA","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140893","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("825","8","0","5752490001","2014-02-27","0","0","2014-02-28","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("826","8","0","5752490002","2014-02-27","0","0","2014-02-28","15","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("827","1","0","8292496","2014-02-27","0","0","2014-02-28","11","","1","","IDSBG 920-4436-02","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140900","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("828","72","0","1262673","2014-02-27","0","0","2014-02-27","18","","1","","Pactron Incorporated \r\nPAC2941_27February2014_ \r\nWO23855_B(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140889","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("829","1","0","8292497","2014-02-27","0","0","2014-02-28","11","","1","","IDSBG 920-3769-02","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140887","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("830","76","0","173014","2014-02-27","0","0","2014-02-28","11","","1","","Piranha EMS, Inc Moog 7200-1081-01 Rev A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140915","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("831","51","0","9931356","2014-02-27","0","0","2014-02-28","11","","1","","Javad Javad 05-572911-01 Rev 2.1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("832","1","0","8292498","2014-02-27","0","0","2014-02-28","12","","1","","IDSBG 920-4484-03","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140899","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("833","10","0","23929150004","2014-02-27","1","0","2014-02-27","17","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("834","22","0","3474226","2014-02-27","0","0","2014-03-03","17","","8","","Axiom Electronics Xerox 905000372 STB000858","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140940","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("835","10","0","2392937","2014-02-27","0","0","2014-03-03","9","","1","","AsteelFlash ANRITSU 3-80317-3P1 / 3-80318-3P1 3-80317-1-2 / 3-80318-1-2","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140922","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("841","8","0","575297","2014-02-27","0","1","2014-03-03","15","","1","","Jabil Circuit Ericsson ST-1-ROA1285145-2-R1B-T TVA1280398/2 revR1A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("836","34","0","7994737","2014-02-27","0","0","2014-02-28","15","","1","","Creation Tech. RGB AB","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140902","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("837","7","0","9991706","2014-02-27","0","0","2014-02-28","11","","1","","SEM HE FEINMETALL C24843 Apt Count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140901","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("838","97","0","4792232","2014-02-27","0","0","2014-02-28","15","","1","","Surface Art Pelco PA02-0515-00B0 J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140921","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("839","93","0","2532099","2014-02-27","0","0","2014-03-04","14","","1","","SMTC ANR 3-80384-3P1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140961","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("840","93","0","2532100","2014-02-27","0","0","2014-03-04","14","","1","","SMTC ANR 3-80384-3P1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140961","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("842","8","0","575298","2014-02-27","0","0","2014-03-03","15","","1","","Jabil Circuit Ericsson 1/ROA1285145/2 rev R1B-B TVA1280398/2 revR1A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("843","6","0","739350","2014-02-27","0","0","2014-02-28","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140905","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("845","31","0","7582228","2014-02-28","0","0","2014-03-03","16","","8","","Controltek  890-1561-0 180-2107-1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140939","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("844","72","0","1262674","2014-02-28","0","0","2014-02-28","18","","1","","Pactron Incorporated PAC2942_28February2014 WO24542_T,WO24442_T","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140903","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("846","31","0","7582229","2014-02-28","0","0","2014-03-03","16","","8","","Controltek  890-1561-0 180-2107-1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140939","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("847","31","0","7582230","2014-02-28","0","0","2014-03-03","16","","8","","Controltek  997-0109-0 REV 102 997-0109-102 TOP","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140927","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("848","2","0","5346794","2014-02-28","1","0","2014-02-28","16","","1","","APERTURE COUNT VIRIDENT 22000-00098 REV.C1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140918","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("849","51","0","9931357","2014-02-28","0","0","2014-03-03","10","","1","","Javad Javad 05-572912-01 Rev 2.1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("850","2","0","5346794001","2014-02-28","1","0","2014-02-28","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("851","88","0","6092040","2014-02-28","0","0","2014-03-03","17","","15","","Sanmina MOOG CB65456-001 PRIMARY","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140937","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("852","57","0","767103","2014-02-28","1","0","2014-02-28","17","","10","","Sandia Labs 045409-1-1 ( FFO-10)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140917","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("853","57","0","767104","2014-02-28","0","0","2014-03-03","17","","8","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("854","35","0","800198","2014-02-28","0","0","2014-03-03","11","","1","","Creation Technologies JUMPGEN Fab","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140926","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("855","22","0","3474227","2014-02-28","1","0","2014-02-28","19.3","","5","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140912","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("856","57","0","767105","2014-02-28","0","0","2014-03-03","17","","8","","Leaf Healthcare, Inc. 045252-1-1 (1116AJ)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140936","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("857","17","0","637614","2014-02-28","0","0","2014-03-04","15","","1","","Agilent Technologies Shahrzad Mazlouman Blipper","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140943","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("858","7","0","9991707","2014-02-28","0","0","2014-03-03","12","","1","","SEM HE Form Factor Inc. 200-4066(TTF0739A):A Apt count =","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("859","7","0","9991710","2014-02-28","0","0","2014-03-10","17","","1","","SEM HE Agilent Technologies 1H78AF2C25123:B Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141093","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("860","7","0","9991711","2014-02-28","0","0","2014-03-10","17","","1","","SEM HE Agilent Technologies 1H78AF2C25123:B Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141093","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("861","7","0","9991712","2014-02-28","0","0","2014-03-03","17","","1","","SEM HE STM - Catania (MT GmbH) STBCFG01 X4 C13589:A Apt count =","1","2014-03-03 03:48:04","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("862","7","0","9991713","2014-02-28","0","0","2014-03-03","17","","1","","SEM HE STM - Catania (MT GmbH) STBCFG01 X4 C13589:A Apt count =","1","2014-03-03 03:48:17","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("864","34","0","7994738","2014-02-28","0","0","2014-03-03","14","","1","","Creation Tech. Alcatel ALC76-0577-02 Rev. 01 TALCS228_LF","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140933","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("865","34","0","7994739","2014-02-28","0","0","2014-03-03","14","","1","","Creation Tech. Alcatel ALC76-0577-02 Rev. 01 TALCS228_LF","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140933","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("866","2","0","5346797","2014-02-28","0","0","2014-03-03","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140931","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("867","7","0","9991708","2014-02-28","0","0","2014-03-04","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140957","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("868","7","0","9991709","2014-02-28","0","0","2014-03-03","12","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("869","59","0","343280","2014-02-28","1","0","2014-03-03","9","","1","","Meritronics Inception 3D Perseus_X-","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140916","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("870","59","0","343281","2014-02-28","1","0","2014-03-03","9","","1","","Meritronics Inception 3D Perseus_X  Inception 3D Perseus_Z","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140916","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("878","70","0","1105114","2014-02-28","0","0","2014-03-03","16","","1","","Oncore TTHF 110927-00@C BOTTOM SIDE","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("873","43","0","5413930","2014-02-28","0","1","2014-03-03","16","","1","","Infiniti Solutions Prime Image 89020-1 Rev D_Top Job","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140946","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("871","19","0","835263","2014-02-28","0","0","2014-03-03","17","","15","","Applied Technologies  210542-1B","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140938","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("872","19","0","835264","2014-02-28","0","0","2014-03-03","17","","15","","Applied Technologies  210542-1B","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140938","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("874","43","0","5413931","2014-02-28","0","0","2014-03-03","16","","1","","Infiniti Solutions Prime Image 89020-1 Rev D_Bottom Job","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140946","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("875","1","0","8292499","2014-02-28","0","0","2014-03-04","16","","1","","IDSBG 920-00081-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("876","1","0","8292500","2014-02-28","0","0","2014-03-03","16","","1","","IDSBG 920-00081-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140941","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("877","70","0","1105113","2014-02-28","0","0","2014-03-03","16","","1","","Oncore TTHF 110927-00@C TOP SIDE","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("879","10","0","2392938","2014-02-28","0","0","2014-03-03","16","","1","","AsteelFlash ANRITSU 3-80319-3P1 3-80319-1-2 rev 1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140925","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("880","62","0","5388060002","2014-02-28","0","0","2014-03-04","19.3","","5","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("881","1","0","8292501","2014-03-03","0","0","2014-03-03","12","","1","","Foxconn-iDSBG iDSBG 820-00002-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140932","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("882","11","0","102051","2014-03-03","0","0","2014-03-04","8","","1","","Zollner Electronics \r\nSkyera \r\n1794113-00  \r\n500-00035-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("883","11","0","102052","2014-03-03","0","0","2014-03-04","8","","1","","Zollner Electronics \r\nSkyera \r\n1794113-00  \r\n500-00035-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("884","40","0","807073","2014-03-03","0","0","2014-03-04","18","","4","","Harris Corporation  mt41k256m16 rev 2013","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140982","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("885","93","0","2532101","2014-03-03","1","0","2014-03-03","16","","1","","SMTC Anritsu 3-72606-3 rev DA","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140934","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("886","7","0","99917140002","2014-03-03","1","0","2014-03-03","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140942","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("887","70","0","1105115","2014-03-03","0","0","2014-03-04","10","","1","","Oncore TTHF 113455-00@B01 TOP SIDE","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140983","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("902","4","0","321755","2014-03-03","0","0","2014-03-04","17","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("888","19","0","8352640002","2014-03-03","0","0","2014-03-04","17","","15","","spin plate","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140938","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("889","2","0","5346798","2014-03-03","0","0","2014-03-04","14","","1","","Sanmina Symmetricom 089-00751-000 Rev 3 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140955","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("890","1","0","8292503","2014-03-03","0","0","2014-03-04","14","","1","","iDSBG 820-00007-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140954","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("891","31","0","7582231","2014-03-03","0","0","2014-03-04","19.3","","8","","Controltek  997-1751-0","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140984","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("892","2","0","5346799","2014-03-03","0","1","2014-03-04","14","","1","","Sanmina Intel  GE441Rev AV3","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140956","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("893","2","0","5346800","2014-03-03","0","1","2014-03-04","14","","1","","Sanmina Intel GE441Rev AV3","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140956","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("894","6","0","739351","2014-03-03","1","0","2014-03-04","15","","1","","Apple  361 FBGA","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140978","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("895","20","0","938656","2014-03-03","1","0","2014-03-04","17","","15","","Ascentron Light Beam Ind. Flex 24V 20 Inch","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140962","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("896","54","0","914604","2014-03-03","0","0","2014-03-04","15","","1","","Marvell Marvell Semiconductor 01_MS1_7017_F1_A1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140949","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("897","54","0","914605","2014-03-03","0","0","2014-03-04","15","","1","","Marvell Marvell Semiconductor 01_MS_7011_F1_A1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140950","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("898","9","0","2813999","2014-03-03","0","0","2014-03-04","15","","1","","Sanmina - SCI, Corp. RDC 131-0722 LOC U9","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("899","9","0","2814000","2014-03-03","0","1","2014-03-04","15","","1","","Sanmina - SCI, Corp. RDC 131-0722 LOC U9","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("900","2","0","5346801","2014-03-03","0","0","2014-03-04","17","","1","","Sanmina Alcatel 82-0740-01 Rev 1 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140959","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("901","2","0","5346802","2014-03-03","0","0","2014-03-04","17","","1","","Sanmina Alcatel 82-0740-01 Rev 1 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140959","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("903","72","0","1262675","2014-03-04","0","0","2014-03-04","18","","1","","Pactron Incorporated \r\nPAC2943_04March2014_ \r\nWO24520_T, \r\nWO23593_T(LeadFree)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140958","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("904","72","0","1262676","2014-03-04","0","0","2014-03-04","18","","1","","Pactron Incorporated \r\nPAC2944_04March2014_ \r\nWO23593_B,WO24566_T \r\n(LeadFree)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140966","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("905","57","0","767106","2014-03-04","1","0","2014-03-04","17","","10","","Milwaukee Electronics 045414-1-1 (An-108467-02)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140960","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("906","57","0","767107","2014-03-04","1","0","2014-03-04","17","","10","","Milwaukee Electronics 045414-1-1 (An-108467-02)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140960","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("907","57","0","767108","2014-03-04","1","0","2014-03-04","17","","10","","Milwaukee Electronics 045415-1-1 (Dg 108467-01)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140967","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("908","57","0","767109","2014-03-04","1","0","2014-03-04","17","","10","","Milwaukee Electronics 045415-1-1 (Dg 108467-01)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140967","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("909","20","0","938657","2014-03-04","1","0","2014-03-04","17","","15","","Ascentron Perpetua 1401001B00xA P/N 790-2494","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140970","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("910","19","0","835265","2014-03-04","0","0","2014-03-05","16","","15","","Applied Technologies  210757-1A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140989","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("911","4","0","321754","2014-03-04","1","0","2014-03-04","14","","1","","Flextronics Agilent AGI-G4594-61020","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("912","97","0","4792233","2014-03-04","1","0","2014-03-04","14","","1","","Surface Art Aptina Imaging AP21086 Rev 0 J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140965","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("913","93","0","2532102","2014-03-04","0","1","2014-03-07","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141069","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("914","93","0","2532103","2014-03-04","0","1","2014-03-07","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141069","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("915","22","0","3474228","2014-03-04","0","0","2014-03-05","16","","8","","Axiom Electronics Intel SDIO BRD SLB000007","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140987","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("916","41","0","832732","2014-03-04","0","0","2014-03-05","8","","1","","PROACTIVE MC_KEYPAD_REV.2 KEYPAD_2/ AOSENSE_65129R1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140971","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("917","9","0","2814001","2014-03-04","1","0","2014-03-05","9","","1","","Sanmina HP C8S83-6054 rev 69 fab C8S83-60504-25 rev 6","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("918","77","0","7281724","2014-03-04","0","0","2014-03-04","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("919","51","0","9931359","2014-03-04","0","0","2014-03-05","11","","1","","Harmonic 099-0676-001 Rev A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("920","1","0","8292504","2014-03-04","1","0","2014-03-04","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140969","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("921","2","0","5346803","2014-03-04","0","0","2014-03-06","12","","1","","Sanmina Alcatel 82-0693/0697-02 Rev 1 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141002","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("922","2","0","5346804","2014-03-04","0","0","2014-03-06","12","","1","","Sanmina Alcatel 82-0693/0697-02 Rev 1 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141001","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("923","76","0","173015","2014-03-04","0","0","2014-03-05","13","","1","","Piranha EMS, Inc Cephasonic USRM32","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("924","9","0","28139710002","2014-03-04","0","0","2014-03-05","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("925","9","0","2814003","2014-03-04","0","0","2014-03-05","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("926","68","0","793108","2014-03-04","0","0","2014-03-06","17","","10","","Oeco  95061","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140980","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("927","31","0","7582232","2014-03-04","0","0","2014-03-05","16","","8","","Controltek  890-1564-0 180-2108-A TOP","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140988","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("928","2","0","5346805","2014-03-04","0","0","2014-03-05","15","","1","","Sanmina Alcatel 82-0617-02 Rev 1 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("929","2","0","5346806","2014-03-04","0","0","2014-03-05","15","","1","","Sanmina Alcatel 82-0617-02 Rev 1 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","1409992","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("930","59","0","343282","2014-03-04","1","0","2014-03-05","9","","1","","Meritronics Lauritzen CX2P4 Avertek DMX 30056 Rev.1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140976","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("931","59","0","343283","2014-03-04","1","0","2014-03-05","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140977","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("932","62","0","5388590003","2014-03-04","0","0","2014-03-05","19.3","","5","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("933","10","0","2392939","2014-03-04","1","0","2014-03-06","9","","1","","AsteelFlash ANRITSU 3-80088-3P1 3-80088-1-2 rev 1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140979","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("934","43","0","5413932","2014-03-04","0","0","2014-03-05","17","","1","","Infiniti Solutions L.S.Research DAR03 Rev A Job","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("935","93","0","2532104","2014-03-04","0","1","2014-03-05","17","","1","","SMTC Anritsu 3-75473-3P3","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140986","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("936","93","0","2532105","2014-03-04","0","1","2014-03-05","17","","1","","SMTC Anritsu 3-75473-3P3","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("937","97","0","4792234","2014-03-04","0","0","2014-03-05","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140991","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("938","93","0","2532106","2014-03-04","0","0","2014-03-06","12","","1","","SMTC Anr 3-80126-3 REV.A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141000","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("939","93","0","2532107","2014-03-04","0","0","2014-03-06","12","","1","","SMTC Anr 3-80126-3 REV.A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141000","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("940","84","0","222082","2014-03-04","0","1","2014-03-06","8","","1","","Rocket EMS Incorporated Xlinx BGA Re-ball  U35 - U36","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140996","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("941","1","0","8292505","2014-03-04","1","0","2014-03-05","8.3","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140981","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("942","4","0","321756","2014-03-04","0","0","2014-03-06","8","","1","","Flextronics \r\nF5 Networks \r\nPCA-0334-00","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("943","4","0","321757","2014-03-04","0","0","2014-03-06","8","","1","","Flextronics \r\nF5 Networks \r\nPCA-0334-00","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("944","84","0","222083","2014-03-04","1","1","2014-03-06","13","","1","","Rocket EMS Incorporated \r\nFoundation \r\nQFN-40","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141008","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("945","72","0","1262677","2014-03-05","0","0","2014-03-05","18","","1","","Pactron Incorporated \r\nPAC2945_05March2014_ \r\nWO24382_T&B(LeadFree)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("946","34","0","7994740","2014-03-05","0","0","2014-03-05","8","","1","","Creation Tech. \r\nDitech \r\nDIT011-0297-20 Rev.4.01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140985","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("947","34","0","7994741","2014-03-05","0","0","2014-03-06","8","","1","","Creation Tech. \r\nDitech \r\nDIT011-0297-20 Rev.4.01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("948","1","0","8292506","2014-03-05","0","0","2014-03-06","8","","1","","Foxconn-iDSBG iDSBG 820-5509-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141010","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("949","1","0","8292507","2014-03-05","1","0","2014-03-07","9","","1","","Foxconn-iDSBG iDSBG 820-5509-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141027","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("950","1","0","8292508","2014-03-05","1","0","2014-03-07","9","","1","","Foxconn-iDSBG iDSBG 820-509-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141026","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("951","97","0","4792235","2014-03-05","0","0","2014-03-06","9","","1","","Surface Art INTEL(CANADA) MB AIC 001 / J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141002","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("952","97","0","4792236","2014-03-05","0","0","2014-03-06","9","","1","","Surface Art INTEL(CANADA) MB AIC 001 / J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141009","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("953","99","0","148072","2014-03-05","0","0","2014-03-06","15","","1","","SV Probe SR5580AAA10,X8,MSTMB,TI 771-008969-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("954","99","0","148073","2014-03-05","0","0","2014-03-06","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("955","57","0","767110","2014-03-05","1","0","2014-03-05","17","","10","","Edwards Bradenton 045290-1-1 (RF SMOKE)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","140990","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("956","88","0","6092041","2014-03-05","0","0","2014-03-06","17","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("957","9","0","2814004","2014-03-05","1","0","2014-03-10","15","","1","","Sanmina 3PAR  C8S83-60501 rev 64","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("958","9","0","2814005","2014-03-05","0","0","2014-03-07","18","","1","","Sanmina 3PAR C8S83-60501 rev 64","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("959","7","0","9991717","2014-03-05","0","0","2014-03-10","15","","1","","SEM HE Form Factror Inc 200-2489(350-2489):1 Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("960","7","0","9991718","2014-03-05","0","0","2014-03-06","17","","1","","SEM HE Form Factror Inc 200-2489(350-2489):1 Apt count =No SMD at bottom side","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1008","4","0","321764","2014-03-05","0","0","2014-03-10","11","","1","","Flextronics CAVIUM CVN-EBB7800G-01 REV A04","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("961","7","0","9991719","2014-03-05","0","0","2014-03-06","17","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("962","7","0","9991720","2014-03-05","1","0","2014-03-17","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141232","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("963","4","0","321758","2014-03-05","0","0","2014-03-06","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141005","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("983","11","0","102055","2014-03-05","0","0","2014-03-06","14","","1","","Zollner Electronics Sandisk 1790891-00 5091385-00 ( Top side )","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("964","36","0","6911913","2014-03-05","1","0","2014-03-06","12","","1","","FOXCONN ION 40000278-04","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141007","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("965","36","0","6911914","2014-03-05","1","0","2014-03-06","12","","1","","FOXCONN ION 40000278-04","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141007","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("966","7","0","9991721","2014-03-05","0","0","2014-03-06","17","","1","","SEM HE MT Asia 20-032015:C","1","2014-03-06 12:16:39","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("967","7","0","9991722","2014-03-05","0","0","2014-03-06","17","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("968","2","0","5346807","2014-03-05","0","1","2014-03-06","12","","1","","Sanmina Alcatel 82-0709-01 Rev 2  APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("969","2","0","5346808","2014-03-05","0","1","2014-03-06","12","","1","","Sanmina Alcatel 82-0709-01 Rev 2 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141006","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("970","6","0","739353","2014-03-05","0","1","2014-03-17","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141292","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("971","93","0","2532108","2014-03-05","0","1","2014-03-07","17","","1","","SMTC Anr 3-80398-3p1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("972","93","0","2532109","2014-03-05","0","1","2014-03-07","17","","1","","SMTC Anr 3-80398-3p1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("973","51","0","9931360","2014-03-05","0","0","2014-03-06","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("974","8","0","575300","2014-03-05","1","0","2014-03-07","19","","1","","Jabil Circuit Arista ST-ASPCA-00529-01-09-T ASFAB-00260-01with template","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141036","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("975","8","0","575301","2014-03-05","1","0","2014-03-07","19","","1","","Jabil Circuit Arista ST-ASPCA-00529-01-09 ASFAB-00260-01 with template","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("976","89","0","973454","2014-03-05","0","0","2014-03-06","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("977","6","0","739352","2014-03-05","0","0","2014-03-17","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141292","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("978","51","0","9931361","2014-03-05","0","0","2014-03-06","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("979","11","0","102053","2014-03-05","0","0","2014-03-17","9","","1","","Zollner Electronics Sandisk 1790880-00 5091383-00 ( Top side )","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("980","11","0","102054","2014-03-05","0","0","2014-03-17","9","","1","","Zollner Electronics Sandisk 1790880-00 5091384-00 (Bottom side)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("990","89","0","973455","2014-03-05","0","0","2014-03-06","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("981","68","0","793109","2014-03-05","0","0","2014-03-06","17","","10","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141038","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("982","68","0","793110","2014-03-05","0","0","2014-03-06","17","","10","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("984","11","0","102056","2014-03-05","0","0","2014-03-06","14","","1","","Zollner Electronics Sandisk 1790891-00 5091386-00 ( Bottom side)","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("985","23","0","3842138","2014-03-05","1","0","2014-03-06","11","","1","","Benchmark AU20-10477 REV 6 PCA AU21-10477 REV 2 PCB TOP","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("986","2","0","5346809","2014-03-05","0","0","2014-03-06","14","","1","","Sanmina Ciena 154-0008-410 Rev 1 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("987","43","0","5413933","2014-03-05","0","0","2014-03-06","14","","1","","Infiniti Solutions Luxim 41-03925-03 Rev 1 Job","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("988","97","0","4792237","2014-03-05","0","0","2014-03-06","15","","1","","Surface Art Phase Matrix 2020515-04 Rev A J","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("989","1","0","8292509","2014-03-05","0","0","2014-03-06","14","","1","","IDSBG 820-3633-04","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("991","2","0","5346811","2014-03-05","0","0","2014-03-06","15","","1","","Sanmina Ciena 154-0028-430 Rev 1 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("992","2","0","53467740002","2014-03-05","0","0","2014-03-06","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("993","2","0","53467660002","2014-03-05","0","0","2014-03-06","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("994","76","0","173016","2014-03-05","1","0","2014-03-06","15","","1","","let Trey take a look at the cam file before sending this for approval","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("995","59","0","343284","2014-03-05","1","0","2014-03-06","9","","1","","Meritronics Canary CAN-0181 Rev.B","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","140999","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("996","59","0","343285","2014-03-05","1","0","2014-03-06","9","","1","","Meritronics Seebright QFN Rework","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141004","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("997","59","0","343286","2014-03-05","1","0","2014-03-06","9","","1","","Meritronics  POW-Mini stencil","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141003","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("998","2","0","5346813","2014-03-05","0","1","2014-03-06","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("999","7","0","9991723","2014-03-05","1","0","2014-03-06","17","","1","","SEM HE MULTITEST GMBH C13239C Apt Count = 1028","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1000","4","0","321761","2014-03-05","0","0","2014-03-06","16","","1","","Flextronics RECON RITC-830-00033 REV.11 FAB","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1001","4","0","321759","2014-03-05","1","1","2014-03-06","16","","1","","Flextronics RECON RITC-830-00046 REV.1 FAB.","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1002","4","0","321760","2014-03-05","1","1","2014-03-06","16","","1","","Flextronics RECON RITC-830-00046 REV.1 FAB.","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1003","22","0","3474229","2014-03-05","0","0","2014-03-07","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1004","22","0","3474230","2014-03-05","0","0","2014-03-06","17","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141033","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1005","4","0","321762","2014-03-05","1","1","2014-03-10","19","","1","","Flextronics Philo SPH-H21828-003","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1006","4","0","321763","2014-03-05","1","1","2014-03-10","19","","1","","Flextronics Philo SPH-H21828-003","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1007","1","0","8292510","2014-03-05","1","0","2014-03-05","21.3","","1","","Deliver Tonight","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1009","4","0","321765","2014-03-05","0","0","2014-03-10","11","","1","","Flextronics CAVIUM CVN-EBB7800G-01 REV A04","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1010","3","0","5632134","2014-03-05","0","0","2014-03-06","15","","4","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1011","8","0","575302","2014-03-05","0","0","2014-03-10","18","","1","","Jabil Circuit \r\nGrass Valley \r\nST-GD771063300-R03-T \r\nGD399063300 rev R01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141118","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1012","8","0","575303","2014-03-05","0","0","2014-03-10","18","","1","","Jabil Circuit \r\nGrass Valley \r\nST-GD771063300-R03\r\nGD399063300 rev R01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141118","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1013","8","0","575304","2014-03-05","0","0","2014-03-10","18","","1","","Jabil Circuit \r\nGrass Valley \r\nST-GD771064200-R05\r\nGD399064200 rev R01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141117","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1014","8","0","575305","2014-03-05","0","0","2014-03-10","18","","1","","Jabil Circuit \r\nGrass Valley \r\nST-GD771064200-R05\r\nGD399064200 rev R01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141117","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1015","118","0","969010","2014-03-05","0","1","2014-03-10","18","","15","","Medtronic \r\nLFBGA 5.85x15.346 \r\nM951699A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1016","118","0","969011","2014-03-05","0","1","2014-03-10","18","","15","","Medtronic \r\n107L STK LFBGA \r\nM950537A_SCSP","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1017","10","0","2392940","2014-03-05","0","0","2014-03-07","10","","1","","AsteelFlash \r\nU27 \r\n10-63462-50","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1018","10","0","2392941","2014-03-05","0","0","2014-03-07","10","","1","","AsteelFlash \r\nU12 \r\n10-63462-50","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1019","72","0","1262678","2014-03-06","0","0","2014-03-10","8","","1","","Pactron Incorporated \r\nPAC2947_06March2014_ \r\nWO24197_T,WO24606_T, \r\nWO24537_T&B(LeadFree)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141070","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1042","1","0","8292511","2014-03-06","0","0","2014-03-07","16","","1","","IDSBG 920-00076-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1020","31","0","7582233","2014-03-06","0","0","2014-03-07","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141034","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1021","97","0","4792238","2014-03-06","1","0","2014-03-06","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1022","97","0","4792239","2014-03-06","1","0","2014-03-06","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1023","70","0","1105117","2014-03-06","0","0","2014-03-10","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141079","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1024","70","0","1105118","2014-03-06","0","0","2014-03-10","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141079","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1025","43","0","5413934","2014-03-06","1","1","2014-03-07","10","","1","","Infiniti Solutions Advanced Assembly B42775_MC-001_V2 Rev C Job","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141028","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1026","43","0","5413935","2014-03-06","1","1","2014-03-07","10","","1","","Infiniti Solutions Advanced Assembly B42776_HVSEC-002 Rev C Job","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1027","3","0","5632135","2014-03-06","1","0","2014-03-10","19.3","","4","","Intel Corporation Canyon Village YTB PB H23832-001 MID 63676-10","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141086","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1029","40","0","807074","2014-03-06","0","1","2014-04-01","17","","7","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141605","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1028","22","0","3474231","2014-03-06","0","0","2014-03-07","16","","8","","Axiom Electronics LeCroy TF-USB-B-SQU 901766217 STP000523R02","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1030","10","0","2392889005","2014-03-06","1","0","2014-03-06","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1031","10","0","2392890006","2014-03-06","1","0","2014-03-06","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1032","97","0","4792241","2014-03-06","0","0","2014-03-07","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141044","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1033","97","0","4792240","2014-03-06","0","0","2014-03-07","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141040","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1034","97","0","4792242","2014-03-06","0","0","2014-03-07","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141041","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1035","22","0","3474232","2014-03-06","0","0","2014-03-07","16","","8","","Axiom Electronics LeCroy Shallbe Amplifier 905000171 STP000702R03","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1036","8","0","575309","2014-03-06","0","0","2014-03-10","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1037","8","0","575307","2014-03-06","0","0","2014-03-10","9","","1","","Jabil Agilent N1000-63055-003 ST-N1000-63055-003-T","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1038","8","0","575308","2014-03-06","0","0","2014-03-10","9","","1","","Jabil Agilent N1000-63055-003 ST-N1000-63055-003-B","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1039","5","0","4894493","2014-03-06","0","0","2014-03-07","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141063","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1040","5","0","4894494","2014-03-06","0","0","2014-03-07","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141063","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1041","8","0","575310","2014-03-06","0","0","2014-03-10","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1043","1","0","8292512","2014-03-06","0","0","2014-03-07","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141042","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1044","8","0","575311","2014-03-06","1","1","2014-03-10","15","","1","","Jabil Circuit Arista  ASPCA-00537-02-04 ST-ASPCA-00537-02-04-T","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1045","8","0","575312","2014-03-06","0","1","2014-03-07","21","","1","","Jabil Circuit Arista ASPCA-00537-02-04 ST-ASPCA-00537-02-04-B","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141064","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1046","7","0","9991724","2014-03-06","1","0","2014-03-07","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141031","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1047","1","0","8292513","2014-03-06","0","0","2014-03-07","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141045","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1048","7","0","9991725","2014-03-06","1","0","2014-03-07","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141031","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1049","10","0","23928850002","2014-03-06","0","0","2014-03-07","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1050","110","0","952380","2014-03-06","0","0","2014-03-07","17","","15","","Unitron Q2124E 400-100-075 rev. A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141055","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1051","34","0","7994742","2014-03-06","0","0","2014-03-07","17","","1","","Creation Tech. Alcatel ALC76-0677-01 Rev. 01 TALCS229_LF","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1052","34","0","7994743","2014-03-06","0","0","2014-03-07","17","","1","","Creation Tech. Alcatel ALC76-0677-01 Rev. 01 TALCS229_LF","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141051","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1053","40","0","807076","2014-03-06","1","1","2014-03-07","19.3","","5","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1054","9","0","2814006","2014-03-06","0","0","2014-03-07","12","","1","","Sanmina  3PAREXP3PR-60001 rev 39","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1055","34","0","7994744","2014-03-06","0","0","2014-03-07","17","","1","","Creation Tech. Alcatel ALC76-0677-01 Rev. 01 TALCS229_LF","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1056","97","0","4792243","2014-03-06","0","0","2014-03-07","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141049","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1057","97","0","4792244","2014-03-06","0","0","2014-03-07","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141048","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1058","34","0","7994745","2014-03-06","1","0","2014-03-07","10","","1","","Creation Tech. DITECH DIT011-0297-20 Rev.4.01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141032","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1059","34","0","7994746","2014-03-06","1","0","2014-03-07","10","","1","","Creation Tech. DITECH DIT011-0297-20 Rev.4.01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141032","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1060","1","0","8292514","2014-03-06","1","0","2014-03-07","10","","1","","Foxconn-iDSBG \r\niDSBG \r\n820-00002-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141037","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1061","1","0","8292515","2014-03-06","1","0","2014-03-07","12","","1","","Foxconn-iDSBG \r\niDSBG \r\n829-00007-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141043","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1062","72","0","1262679","2014-03-07","0","0","2014-03-07","18","","1","","Pactron Incorporated \r\nPAC2949_07March2014_ \r\nWO24547_T&B(LeadFree)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1063","3","0","5632136","2014-03-07","1","0","2014-03-10","19.3","","4","","Intel Corporation \r\nCanyon Village YTB  \r\nPB H23832-001  \r\nMID 63676-11","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141086","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1064","3","0","5632137","2014-03-07","1","0","2014-03-10","19.3","","4","","Intel Corporation \r\nCanyon Village YTB  \r\nPB H23832-001  \r\nMID 63676-12","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141086","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1065","72","0","1262680","2014-03-07","0","0","2014-03-07","18","","1","","Pactron Incorporated \r\nPAC2950_07March2014_ \r\nWO23929_T&B(LeadFree)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","1262680","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1066","20","0","938658","2014-03-07","0","0","2014-03-10","16","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1067","59","0","3432580002","2014-03-07","0","0","2014-03-07","17","","1","","","1","2014-03-07 13:08:49","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1068","3","0","5632138","2014-03-07","0","0","2014-03-10","19.3","","10","","G90979-001 rev 01 63582-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1069","22","0","3474233","2014-03-07","1","0","2014-03-07","18.3","","5","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1070","1","0","8292516","2014-03-07","0","0","2014-03-10","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141062","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1071","77","0","7281725","2014-03-07","1","0","2014-03-07","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1072","97","0","4792245","2014-03-07","0","0","2014-03-10","11","","1","","","1","2014-03-07 15:24:21","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1073","77","0","7281726","2014-03-07","1","0","2014-03-07","16","","1","","Plexus Sonosite P19216-01 LOC: J4","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1077","43","0","5413936","2014-03-07","1","0","2014-03-10","8","","1","","Infiniti Solutions InvenSense GEN9A/B Rev 0 Job","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141060","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1074","72","0","1262681","2014-03-07","1","0","2014-03-07","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1075","9","0","2814007","2014-03-07","0","0","2014-03-11","21","","1","","Sanmina - SCI, Corp. RDC Assy 131-0731 PCB 132-0731 rev 1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1076","9","0","2814008","2014-03-07","0","0","2014-03-11","9","","1","","Sanmina - SCI, Corp. RDC Assy 131-0731 PCB 132-0731 rev 1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1078","59","0","343288","2014-03-07","1","0","2014-03-10","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141059","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1079","4","0","321766","2014-03-07","1","0","2014-03-10","19","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1080","9","0","2814009","2014-03-07","1","0","2014-03-10","14","","1","","Sanmina - SCI, Corp. RDC Assy 131-0740 PCB 132-0740 rev 1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1081","10","0","2392945","2014-03-07","0","0","2014-03-10","14","","1","","AsteelFlash ANRITSU 3-80239-3 rev A 3-80239-1-2 rev A1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141084","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1082","10","0","2392946","2014-03-07","0","0","2014-03-10","15","","1","","AsteelFlash ANRITSU 3-80239-3 rev A 3-80239-1-2 rev A1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141084","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1083","20","0","938660","2014-03-07","0","0","2014-03-10","16","","15","","Ascentron IDD AEROSPACE 143-810-0093-100 P/N 790-2499","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141067","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1084","20","0","938661","2014-03-07","0","0","2014-03-10","16","","15","","Ascentron IDD AEROSPACE 143-810-0093-100 P/N 790-2500","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141067","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1085","20","0","938662","2014-03-07","0","0","2014-03-10","16","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1086","9","0","2814010","2014-03-07","0","0","2014-03-10","16","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1087","36","0","69119130002","2014-03-07","1","0","2014-03-07","17.3","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1088","97","0","4792246","2014-03-09","0","0","2014-03-10","18","","1","","Surface Art Monsoon MPA01B J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141081","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1089","97","0","4792247","2014-03-09","0","0","2014-03-10","18","","1","","Surface Art Monsoon FQA87A J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1100","3","0","5632139","2014-03-10","0","0","2014-03-11","17","","4","","Intel Corporation Baytrail-T MID","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1090","8","0","575314","2014-03-09","0","1","2014-03-11","18","","1","","Jabil Circuit Grass Valley ST-GD771064300-R04-T GD399064300 rev R01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141116","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1091","8","0","575315","2014-03-09","0","0","2014-03-11","18","","1","","Jabil Circuit Grass Valley ST-GD771064300-R04-B GD399064300 rev R01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141116","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1092","20","0","938659","2014-03-10","0","0","2014-03-10","16","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1093","8","0","575316","2014-03-10","0","0","2014-03-18","8","","1","","Jabil Circuit Grass Valley ST-GD771064000-R01-T GD399064000 rev R01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141325","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1094","8","0","575317","2014-03-10","0","1","2014-03-18","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141325","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1095","8","0","575318","2014-03-10","0","0","2014-03-18","8","","1","","Jabil Circuit Grass Valley ST-GD771063800-R01-T GD399063800 rev R01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141385","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1096","8","0","575319","2014-03-10","0","1","2014-03-12","8","","1","","Jabil Circuit Grass Valley ST-GD771063800-R01-B GD399063800 rev R01","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1097","8","0","575320","2014-03-10","0","0","2014-03-24","17","","1","","Jabil Circuit Grass Valley ST-GD771063900-R01-T GD399063900 rev R01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141576","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1098","8","0","575321","2014-03-10","0","1","2014-03-24","17","","1","","Jabil Circuit Grass Valley ST-GD771063900-R01-B GD399063900 rev R01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141576","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1099","72","0","1262682","2014-03-10","1","0","2014-03-10","14","","1","","Pactron Incorporated PAC2951_10March2014 WO24623_T,WO23713_T","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141071","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1101","43","0","5413937","2014-03-10","0","0","2014-03-11","8","","1","","Infiniti Solutions Job","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1102","76","0","173017","2014-03-10","1","0","2014-03-10","15","","1","","Piranha EMS, Inc Kontron Mini Stencil for U49","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1103","43","0","5413938","2014-03-10","0","0","2014-03-11","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1104","7","0","99917250003","2014-03-10","1","0","2014-03-10","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1105","97","0","4792248","2014-03-10","1","0","2014-03-10","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1106","7","0","9991727","2014-03-10","1","0","2014-03-11","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141094","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1107","54","0","914606","2014-03-10","0","0","2014-03-11","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141083","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1108","8","0","575322","2014-03-10","1","0","2014-03-10","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1109","97","0","4792249","2014-03-10","1","0","2014-03-10","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1110","64","0","4751106","2014-03-10","0","0","2014-03-11","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141097","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1111","29","0","919100","2014-03-10","1","0","2014-03-10","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141082","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1112","43","0","54139360002","2014-03-10","1","0","2014-03-10","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1113","2","0","5346814","2014-03-10","1","0","2014-03-10","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1114","7","0","9991728","2014-03-10","0","0","2014-03-11","17","","1","","SEM HE IBM - NEW YORK FHQ3537 FLANKERCR C26362A Apt count =","1","2014-03-10 18:10:48","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1115","7","0","9991729","2014-03-10","0","0","2014-03-11","17","","1","","SEM HE IBM - NEW YORK FHQ3537 FLANKERCR C26362A Apt count =","1","2014-03-10 18:12:10","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1116","3","0","5632140","2014-03-10","0","1","2014-03-11","16","","4","","Intel Corporation Cherryview SOC Reball Tooling","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141133","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1117","57","0","767111","2014-03-10","0","0","2014-03-11","16","","8","","MEC Northwest Co ADEC 300023","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141098","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1118","57","0","767112","2014-03-10","0","0","2014-03-11","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141098","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1119","59","0","343289","2014-03-10","1","0","2014-03-11","9","","1","","Meritronics Pal-Pilot I0427.001a Rev1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141080","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1120","59","0","343290","2014-03-10","1","0","2014-03-11","9","","1","","Meritronics Trash Amps Saratoga Rev.C Trash Amps Concord Rev.B","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141092","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1121","2","0","5346815","2014-03-10","0","0","2014-03-11","15","","1","","Sanmina Newisys PCA-00668-01-A Rev-A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141102","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1122","8","0","575323","2014-03-10","0","0","2014-03-12","13","","1","","Jabil Circuit Ericsson ST-1-ROA1284189-3-R1B-T TVA1280420/1-R2A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141120","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1123","8","0","575324","2014-03-10","0","0","2014-03-12","13","","1","","Jabil Circuit Ericsson ST-1-ROA1284189-3-R1B TVA1280420/1-R2A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141120","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1124","22","0","3474234","2014-03-10","1","0","2014-03-10","19.3","","5","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141089","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1125","51","0","9931362","2014-03-10","0","0","2014-03-11","17","","1","","JavadSchilling Robotics 005-6857 Rev 7","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1126","97","0","4792250","2014-03-10","0","1","2014-03-13","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141136","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1127","97","0","4792251","2014-03-10","0","0","2014-03-13","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141136","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1128","22","0","3474235","2014-03-10","0","0","2014-03-12","19.3","","8","","Axiom Electronics Rastergraf Topaz 901767066 STP000860","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1129","43","0","5413940","2014-03-11","0","0","2014-03-12","8","","1","","Infiniti Solutions Job","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141109","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1130","7","0","9991406004","2014-03-11","0","0","2014-03-12","10","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1131","4","0","321767","2014-03-11","1","1","2014-03-11","16","","1","","Flextronics Philo PLO-970-0071-01 Rev-2C11 PLO-180-10100-00 Rev-00","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1132","20","0","938663","2014-03-11","0","0","2014-03-12","16","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141113","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1133","43","0","5413941","2014-03-11","0","0","2014-03-12","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141137","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1134","35","0","800200","2014-03-11","1","0","2014-03-12","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1135","35","0","800199","2014-03-11","1","0","2014-03-13","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141135","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1136","23","0","3842139","2014-03-11","0","0","2014-03-12","11","","1","","Benchmark Fastback Networks FB830-00019 Rev 2 PCB 370-00046 Rev 3","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1137","97","0","4792252","2014-03-11","0","0","2014-03-12","13","","1","","Surface Art Elevate Technologies PCB0001-0004-0020 REV A1 J","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1138","10","0","2392947","2014-03-11","0","0","2014-03-17","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141263","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1139","10","0","2392948","2014-03-11","0","0","2014-03-17","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141263","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1140","97","0","4792247005","2014-03-11","1","0","2014-03-11","16","","1","","Surface Art Monsoon FQA87A J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141107","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1141","97","0","4792254","2014-03-11","0","0","2014-03-12","14","","1","","Surface Art SignalScape Badin Rev 1.1.1 /J","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1142","8","0","5752670002","2014-03-11","0","0","2014-03-12","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141179","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1143","22","0","3474236","2014-03-11","0","0","2014-03-12","19.3","","8","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1144","2","0","53466570002","2014-03-11","1","0","2014-03-11","18","","1","","Sanmina Intel 640-0001 Rev 1 Aperture count=2299","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141108","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1145","2","0","5346782007","2014-03-11","0","0","2014-03-12","16","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1146","110","0","952381","2014-03-11","0","0","2014-03-12","17","","15","","Unitron  17000150 C","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1147","97","0","4792255","2014-03-11","0","0","2014-03-13","18","","1","","Surface Art Monsoon FQ&#8203;A62A&#8203; J","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1148","35","0","800201","2014-03-11","0","0","2014-03-14","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1149","57","0","767115","2014-03-13","0","0","2014-03-13","20","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141142","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1150","57","0","767116","2014-03-13","0","0","2014-03-13","20","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141142","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1151","111","0","782670","2014-03-13","0","0","2014-03-13","20","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141141","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1152","41","0","832733","2014-03-13","0","0","2014-03-13","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141131","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1153","55","0","983089","2014-03-13","0","0","2014-03-12","11","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1154","11","0","102058","2014-03-13","0","0","2014-03-13","15","","1","","Zollner Electronics Hansen Medical 20922 Rev A 5091135-00","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141211","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1155","11","0","102059","2014-03-13","0","0","2014-03-13","16","","1","","Zollner Electronics Hansen Medical 21020 RevA 5091131-00","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141212","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1156","9","0","2814006001","2014-03-13","1","0","2014-03-13","13","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1157","2","0","5346819","2014-03-13","0","0","2014-03-13","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141152","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1158","11","0","102060","2014-03-13","0","0","2014-03-13","16","","1","","Zollner Electronics Hansen Medical 21021 RevA 5091131-00","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141213","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1159","43","0","5413942","2014-03-13","0","0","2014-03-13","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141128","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1160","22","0","3474237","2014-03-13","0","0","2014-03-13","20","","8","","Axiom Electronics Boeing MSL GuidTelemetry1 901767030 STP000850","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141165","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1161","22","0","3474238","2014-03-13","0","0","2014-03-13","20","","8","","Axiom Electronics Boeing MSL GuidTelemetry1 901767030 STS000679","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141165","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1162","43","0","5413943","2014-03-13","0","1","2014-03-13","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141177","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1163","97","0","4792257","2014-03-13","0","0","2014-03-13","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141159","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1164","2","0","5346818","2014-03-13","0","0","2014-03-13","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141140","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1165","51","0","9931366","2014-03-13","0","0","2014-03-13","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1166","77","0","7281727","2014-03-13","0","1","2014-03-13","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141170","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1167","77","0","7281728","2014-03-13","0","1","2014-03-13","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141170","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1168","8","0","575327","2014-03-13","1","1","2014-03-13","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141145","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1169","10","0","2392949","2014-03-13","0","0","2014-03-12","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141139","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1170","10","0","2392950","2014-03-13","0","0","2014-03-12","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141139","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1171","29","0","919101","2014-03-13","0","0","2014-03-13","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141151","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1172","97","0","4792256","2014-03-13","1","0","2014-03-13","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141138","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1173","22","0","3474239","2014-03-13","0","0","2014-03-13","20","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141162","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1174","22","0","3474240","2014-03-13","0","0","2014-03-13","20","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141162","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1175","7","0","9991731","2014-03-13","1","1","2014-03-14","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141209","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1176","7","0","9991732","2014-03-13","0","0","2014-03-13","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141160","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1177","76","0","173019","2014-03-13","0","1","2014-03-13","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141134","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1178","72","0","1262687","2014-03-13","1","0","2014-03-13","16","","1","","Pactron Incorporated PAC2955_13March2014 WO24675_T","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141148","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1179","1","0","8292517","2014-03-13","0","0","2014-03-14","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141169","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1180","1","0","8292518","2014-03-13","1","0","2014-03-14","17","","1","","Foxconn-iDSBG iDSBG 920-00067-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141206","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1181","1","0","8292519","2014-03-13","0","0","2014-03-13","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141181","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1182","1","0","8292520","2014-03-13","0","0","2014-03-14","8","","1","","Foxconn-iDSBG iDSBG 920-00067-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1183","22","0","3474241","2014-03-13","0","0","2014-03-14","20","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1184","66","0","596100","2014-03-13","0","0","2014-03-17","12","","5","","Nextek  300-0127 rev F","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141168","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1185","100","0","140195","2014-03-13","0","0","2014-03-13","20","","1","","Synergetics Elecraft","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141144","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1186","51","0","9931365","2014-03-13","0","0","2014-03-13","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1187","97","0","4792258","2014-03-13","0","0","2014-03-14","8","","1","","Surface Art SignalScape VANDERBILT REV 1.2 J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141183","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1188","2","0","5346820","2014-03-13","0","0","2014-03-13","17","","1","","Sanmina Alcatel 82-0617-03 Rev 1 APERTURE COUN","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141184","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1189","43","0","5413945","2014-03-13","0","0","2014-03-14","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141164","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1190","43","0","5413944","2014-03-13","0","0","2014-03-14","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1191","31","0","7582234","2014-03-13","1","0","2014-03-13","17","","9","","Controltek  825-2292-0 180-2081-2","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141161","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1192","93","0","2532110","2014-03-13","0","0","2014-03-14","9","","1","","SMTC LECROY 923225-00","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141174","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1193","93","0","2532111","2014-03-13","0","0","2014-03-14","9","","1","","SMTC LECROY 923225-00","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141174","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1194","72","0","1262684","2014-03-13","1","0","2014-03-13","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141166","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1195","2","0","5346821","2014-03-13","0","0","2014-03-14","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1196","7","0","9991733","2014-03-13","0","0","2014-03-14","17","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1197","7","0","9991734","2014-03-13","0","0","2014-03-14","17","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1198","3","0","5632141","2014-03-13","1","0","2014-03-14","18","","4","","Intel Corporation P-LFBGA176-13x13-0.80 LFBGA176 13mm 0.80 Pitch","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1199","7","0","9991735","2014-03-13","1","0","2014-03-20","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141337","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1200","7","0","9991736","2014-03-13","0","0","2014-03-14","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141324","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1201","97","0","4792259","2014-03-13","1","0","2014-03-13","18","","1","","Surface Art Monsoon  LTE14A J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141171","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1202","9","0","2814012","2014-03-13","0","0","2014-03-17","9","","1","","Sanmina 3PAR C8S83-60501 rev 64","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1203","9","0","2814013","2014-03-13","0","0","2014-03-17","9","","1","","Sanmina 3PAR C8S83-60501 rev 64","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1204","29","0","919102","2014-03-13","0","0","2014-03-19","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1205","2","0","5346822","2014-03-13","0","0","2014-03-14","12","","1","","Sanmina HGST BeeHive Rev-C","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1206","2","0","5346823","2014-03-13","0","0","2014-03-14","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1207","22","0","3474242","2014-03-13","0","0","2014-03-14","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141207","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1208","7","0","9991739","2014-03-13","0","0","2014-03-18","9","","1","","SEM HE Feinmetall GmbH 8812M23D002-092 C13590:A Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1209","7","0","9991740","2014-03-13","0","0","2014-03-14","17","","1","","SEM HE Feinmetall GmbH 8812M23D002-092 C13590:A Apt count =","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1210","7","0","9991737","2014-03-13","0","0","2014-03-14","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1211","7","0","9991738","2014-03-13","0","0","2014-03-14","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1212","74","0","152002","2014-03-13","0","0","2014-03-14","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141188","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1213","22","0","3474243","2014-03-13","0","0","2014-03-17","17","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141255","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1214","7","0","9991741","2014-03-13","0","0","2014-03-14","17","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1215","7","0","9991742","2014-03-13","0","0","2014-03-18","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141238","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1216","59","0","343291","2014-03-13","1","0","2014-03-14","9","","1","","Meritronics HMICRO REACH-1D Patch BD OptiScan 2002043 Rev.B OptiScan 2002045 Rev.B","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141175","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1217","3","0","5632142","2014-03-13","0","0","2014-03-14","16","","4","","Intel Corporation Kool Corner TMTV PB","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1218","86","0","482272","2014-03-13","0","0","2014-03-17","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141239","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1219","1","0","8292521","2014-03-13","0","0","2014-03-14","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141192","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1220","54","0","914607","2014-03-13","1","0","2014-03-13","21","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141173","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1221","1","0","8292522","2014-03-13","0","0","2014-03-14","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1222","1","0","8292523","2014-03-13","0","0","2014-03-14","13","","1","","Foxconn-iDSBG iDSBG 820-5509-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141202","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1223","3","0","5632143","2014-03-13","0","0","2014-03-14","16","","4","","Intel Corporation Stone Peak JEDEC 5 Mils H36277-001 MID","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1224","1","0","8292524","2014-03-13","0","0","2014-03-17","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1225","97","0","4792260","2014-03-13","1","0","2014-03-14","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1226","84","0","222084","2014-03-13","0","1","2014-03-14","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141210","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1227","97","0","4792261","2014-03-13","1","0","2014-03-14","9","","1","","Surface Art Apple Lucifer J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141180","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1228","11","0","102061","2014-03-13","0","0","2014-03-17","9","","1","","Zollner Electronics VytronUS 620-05785-02 Rev01 5091431-00 (top)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1229","11","0","102062","2014-03-13","0","0","2014-03-17","9","","1","","Zollner Electronics VytronUS 620-05785-02 Rev01 5091430-00 (bot)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1230","10","0","2392953","2014-03-13","0","0","2014-03-14","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1231","34","0","7994747","2014-03-13","0","0","2014-03-17","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141205","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1232","34","0","7994748","2014-03-13","0","0","2014-03-14","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1233","2","0","5346824","2014-03-13","0","0","2014-03-17","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1234","10","0","2392951","2014-03-14","0","0","2014-03-14","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141199","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1235","10","0","2392952","2014-03-14","0","0","2014-03-14","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141199","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1236","72","0","1262688","2014-03-14","1","0","2014-03-18","8","","1","","Pactron Incorporated PAC2957_14March2014 WO23836_T","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1237","22","0","3474246","2014-03-14","0","0","2014-03-21","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141382","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1238","22","0","3474247","2014-03-14","0","0","2014-03-21","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141382","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1239","22","0","3474244","2014-03-14","0","0","2014-03-21","16","","8","","Axiom Electronics Boeing MSL Sys Telemetry1 901767032 STP000852","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141381","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1240","22","0","3474245","2014-03-14","0","0","2014-03-21","16","","8","","Axiom Electronics Boeing MSL Sys Telemetry1 901767032 STS000681","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141381","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1241","57","0","767117","2014-03-14","0","0","2014-03-17","16","","8","","Milwaukee Electronics Co A-DEC 300057","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1242","57","0","767118","2014-03-14","0","0","2014-03-17","16","","8","","Milwaukee Electronics Co A-DEC 300057","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1243","36","0","6911917","2014-03-14","0","0","2014-03-17","10","","1","","FOXCONN Brocade 40000330-02 Top Paste","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1244","36","0","6911918","2014-03-14","0","0","2014-03-17","10","","1","","FOXCONN Brocade 40000330-02 Bottom Paste","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1245","34","0","7994749","2014-03-14","0","0","2014-03-17","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141240","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1246","34","0","7994750","2014-03-14","0","0","2014-03-17","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141240","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1247","11","0","102063","2014-03-14","1","0","2014-03-17","11","","1","","Zollner Electronics Google 1731501-02 Rade4 RF 1.4.1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141230","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1248","11","0","102064","2014-03-14","1","0","2014-03-17","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141230","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1249","8","0","575328","2014-03-14","1","0","2014-03-17","10","","1","","Jabil Agilent ST-G5239-61812-T G5239-31812_003","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1257","46","0","151045","2014-03-14","0","0","2014-03-17","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141272","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1250","11","0","102067","2014-03-14","1","0","2014-03-17","11","","1","","Zollner Electronics Google 1765662-02 Rade 4 IF 1.4.2","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141229","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1251","11","0","102068","2014-03-14","1","0","2014-03-17","11","","1","","Zollner Electronics Google 1765662-02 Rade 4 IF 1.4.2","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141229","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1252","110","0","952382","2014-03-14","1","0","2014-03-18","17","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141290","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1253","93","0","2532112","2014-03-14","0","0","2014-03-17","12","","1","","SMTC LECROY 210-0187-00 REV.D","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141237","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1254","4","0","321769","2014-03-14","0","0","2014-03-20","10","","1","","with special templates","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1255","4","0","321770","2014-03-14","0","0","2014-03-20","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1256","7","0","9991743","2014-03-14","1","0","2014-03-17","13","","1","","SEM HE FORM FACTOR 200-11048 Apt Count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141233","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1258","4","0","321768","2014-03-14","1","0","2014-03-17","10","","1","","Flextronics Philo PLO-970-0071-01 Rev-2C11 PLO-180-10100-00 Rev-00","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1259","51","0","9931368","2014-03-14","0","0","2014-03-17","14","","1","","Javad  Assy","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1260","35","0","800202","2014-03-14","1","0","2014-03-17","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141215","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1261","6","0","739354","2014-03-14","0","0","2014-03-20","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1262","7","0","9991744","2014-03-14","1","0","2014-03-17","15","","1","","SEM HE INTEL 17x43 oblong 630-0037 Apt Count = 4331","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141234","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1263","57","0","767119","2014-03-14","1","0","2014-03-17","16","","10","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141251","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1264","51","0","9931369","2014-03-14","1","1","2014-03-20","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1265","76","0","173020","2014-03-14","1","0","2014-03-17","8","","1","","Piranha EMS, Inc \r\nPiranhaEMS \r\nGF 1 GERB","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141221","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1266","64","0","4751107","2014-03-14","1","0","2014-03-17","13","","1","","D3 BGA U1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141235","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1267","97","0","47922450002","2014-03-14","1","0","2014-03-14","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1268","11","0","102069","2014-03-16","0","0","2014-03-17","13","","1","","Zollner Electronics \r\nBruker \r\n1791091-00 & 1790893-00","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141264","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1269","72","0","1262689","2014-03-17","1","0","2014-03-17","9","","1","","Pactron Incorporated \r\nPAC2958_16March2014_ \r\nWO24477_T&B(LeadFree)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141228","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1270","51","0","9931367","2014-03-17","0","0","2014-03-17","11","","1","","Javad \r\n05-570113-01 \r\nRev 2.1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1271","57","0","767120","2014-03-17","1","0","2014-03-17","17","","10","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141236","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1272","20","0","938664","2014-03-17","0","0","2014-03-17","17","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141269","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1273","7","0","9991745","2014-03-17","0","0","2014-03-18","12","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1274","7","0","9991746","2014-03-17","1","0","2014-03-26","9","","1","","SEM HE Form Factor Inc. 207-11361(357-11361):1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141479","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1275","7","0","9991747","2014-03-17","0","0","2014-03-18","12","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1276","7","0","9991748","2014-03-17","0","0","2014-03-18","12","","1","","SEM HE Form Factor Inc. 200-11048:1 (PILOT)","1","2014-03-18 03:35:42","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1277","93","0","2532113","2014-03-17","0","0","2014-03-18","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1282","43","0","5413946","2014-03-17","0","0","2014-03-18","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141279","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1278","83","0","613386","2014-03-17","0","0","2014-03-18","19.3","","5","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141262","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1279","93","0","2532114","2014-03-17","0","0","2014-03-18","12","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1280","1","0","8292525","2014-03-17","1","0","2014-03-19","13","","1","","Foxconn iDSBG  820-00019-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141316","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1281","1","0","8292526","2014-03-17","1","0","2014-03-19","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141315","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1283","43","0","5413947","2014-03-17","0","0","2014-03-18","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141279","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1284","9","0","2814014","2014-03-17","0","0","2014-03-18","13","","1","","Wait for S/S before proceeding to laser","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1285","57","0","767121","2014-03-17","0","0","2014-03-18","17","","8","","Ship 3/18","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141270","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1286","9","0","2814015","2014-03-17","0","0","2014-03-28","10","","1","","Wait for S/S before proceeding to laser","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1287","57","0","767122","2014-03-17","0","0","2014-03-18","17","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141270","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1288","43","0","5413948","2014-03-17","0","0","2014-03-18","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141273","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1289","43","0","5413949","2014-03-17","0","0","2014-03-18","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141273","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1290","2","0","5346825","2014-03-17","0","1","2014-03-20","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141344","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1292","33","0","703153","2014-03-17","0","1","2014-03-18","19.3","","5","","Crane Electronics, Inc  30051-101","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1291","41","0","832734","2014-03-17","1","0","2014-03-18","8","","1","","LDI_6007_A/ LDI_AE4398 OoMA_030_0143_100_REV.001","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141274","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1293","2","0","5346826","2014-03-17","0","0","2014-03-18","14","","1","","Sanmina Newisys PCA-00561-02-A Rev-1A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141275","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1294","97","0","4792264","2014-03-17","1","0","2014-03-18","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1300","2","0","5346828","2014-03-17","0","0","2014-03-18","15","","1","","Sanmina Newisys PCA-00665-01-A Rev-1A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141280","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1295","1","0","8292527","2014-03-17","0","0","2014-03-18","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1296","1","0","8292528","2014-03-17","0","0","2014-03-18","15","","1","","Foxconn iDSBG IDSBG 920-00153-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141276","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1297","72","0","1262690","2014-03-17","1","0","2014-03-17","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1298","2","0","5346827","2014-03-17","0","0","2014-03-18","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141271","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1299","1","0","8292529","2014-03-17","0","0","2014-03-18","15","","1","","Foxconn iDSBG IDSBG 920-00051-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141282","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1301","1","0","8292530","2014-03-17","0","0","2014-03-18","16","","1","","Foxconn-iDSBG iDSBG 920-00107-02","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141277","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1302","113","0","111246","2014-03-17","0","0","2014-03-20","15.3","","1","","Ministencil for Paul","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141540","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1303","2","0","53468000002","2014-03-17","0","0","2014-03-18","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141285","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1304","97","0","4792266","2014-03-17","1","0","2014-03-18","13","","1","","Surface Art Linear 700-0176 (CANADIAN) REV.4","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141268","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1305","97","0","4792265","2014-03-17","1","0","2014-03-18","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141267","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1306","7","0","9991749","2014-03-18","0","0","2014-03-26","17","","1","","SEM HE \r\nForm Factor Inc. \r\n202-11072(351-11072):1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141472","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1307","7","0","9991750","2014-03-18","0","0","2014-03-26","17","","1","","SEM HE \r\nForm Factor Inc. \r\n202-11072(351-11072):1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141472","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1308","7","0","9991751","2014-03-18","1","0","2014-03-20","17","","1","","SEM HE \r\nForm Factor Inc. \r\n200-40069(350-40069):1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141384","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1309","7","0","9991752","2014-03-18","0","0","2014-03-19","8","","1","","SEM HE \r\nForm Factor Inc. \r\n200-40069(350-40069):1","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1310","72","0","1262691","2014-03-18","0","0","2014-03-18","18","","1","","Pactron Incorporated PAC2961_18March2014_ WO24045_T(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141278","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1311","72","0","1262692","2014-03-18","0","0","2014-03-18","18","","1","","Pactron Incorporated PAC2962_18March2014_ WO24045_B(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141278","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1312","9","0","2814016","2014-03-18","1","0","2014-03-18","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1313","4","0","321771","2014-03-18","0","0","2014-03-19","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1314","111","0","782671","2014-03-18","0","0","2014-03-19","16","","8","","Veris ZT00312-0D Z206509-0D","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1315","7","0","9991759","2014-03-18","0","0","2014-03-19","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141390","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1316","7","0","9991760","2014-03-18","0","0","2014-03-19","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141390","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1317","4","0","321772","2014-03-18","0","0","2014-03-19","11","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1318","7","0","9991757","2014-03-18","0","0","2014-03-19","17","","1","","SEM HE SCI LLC (ON SEMICONDUCTOR CUSTOM J750 PROBE C26351A Apt count =","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1319","7","0","9991758","2014-03-18","0","0","2014-03-19","17","","1","","SEM HE SCI LLC (ON SEMICONDUCTOR CUSTOM J750 PROBE C26351A Apt count =","1","2014-03-19 06:21:26","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1320","8","0","575329","2014-03-18","0","1","2014-03-19","10","","1","","Jabil LTX ST-974-1616-00-AG-T 948-1616-00-AA","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141310","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1321","8","0","575330","2014-03-18","0","1","2014-03-19","10","","1","","Jabil LTX ST-974-1616-00-AG-T 948-1616-00-AA","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141310","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1322","7","0","9991753","2014-03-18","0","0","2014-03-20","17","","1","","SEM HE NPX SEMICON GmbH L3113_TOKEN 4XFT C13587:A Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141343","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1323","7","0","9991754","2014-03-18","0","0","2014-03-20","17","","1","","SEM HE NPX SEMICON GmbH L3113_TOKEN 4XFT C13587:A Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141343","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1324","93","0","2532115","2014-03-18","0","0","2014-03-19","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141365","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1325","51","0","9931371","2014-03-18","0","0","2014-03-19","11","","1","","JavadSchilling 005-10022 Rev 0","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1326","2","0","5346830","2014-03-18","0","0","2014-03-19","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141305","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1327","93","0","2532116","2014-03-18","0","0","2014-03-19","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1328","93","0","2532117","2014-03-18","0","0","2014-03-19","11","","1","","SMTC Anr 3-75770-3 REV.B1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1329","51","0","9931370","2014-03-18","0","0","2014-03-19","11","","1","","JavadSchilling 005-10020 Rev0","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1330","110","0","952383","2014-03-18","0","0","2014-03-19","17","","15","","Unitron  E3413A(400-100-068 Rev A)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141306","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1331","110","0","952384","2014-03-18","0","0","2014-03-19","17","","15","","Unitron  E3597A(400-100-071 Rev B)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141306","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1336","22","0","3474248","2014-03-18","0","0","2014-03-25","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141484","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1332","57","0","7671160002","2014-03-18","1","0","2014-03-18","17","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1333","2","0","5346832","2014-03-18","0","0","2014-03-19","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141301","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1334","57","0","767124","2014-03-18","1","0","2014-03-19","17","","10","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141281","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1335","57","0","767125","2014-03-18","1","0","2014-03-19","17","","10","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141281","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1337","2","0","5346833","2014-03-18","0","0","2014-03-19","14","","1","","Sanmina Ruckus 120-11231-002 Rev-A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141302","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1338","2","0","5346831","2014-03-18","0","0","2014-03-19","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1339","4","0","321773","2014-03-18","1","0","2014-03-19","14","","1","","Flextronics Cavium  CVN-EBB7800G-01 REV A04","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1340","97","0","4792267","2014-03-18","0","0","2014-03-19","14","","1","","Surface Art Aptina Imaging AR2520HS REV 1 J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141298","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1341","2","0","5346835","2014-03-18","0","0","2014-03-19","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141304","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1342","2","0","5346834","2014-03-18","0","0","2014-03-19","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141303","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1343","113","0","111248","2014-03-18","0","0","2014-03-19","17","","5","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141308","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1344","22","0","3474249","2014-03-18","0","0","2014-03-20","16","","8","","Axiom Electronics L3 ESW130-1020 SLP000012","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141338","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1345","22","0","3474250","2014-03-18","0","0","2014-03-20","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1346","43","0","5413950","2014-03-18","1","0","2014-03-19","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141289","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1347","59","0","343292","2014-03-18","1","0","2014-03-19","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141286","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1348","59","0","343293","2014-03-18","1","0","2014-03-19","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141287","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1349","59","0","343294","2014-03-18","1","0","2014-03-19","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141288","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1350","7","0","99914100002","2014-03-18","0","0","2014-03-19","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141295","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1351","34","0","7994751","2014-03-18","0","0","2014-03-19","16","","1","","Creation Tech. Alcatel ALC76-0554-02 Rev. 01 TALCS231_LF","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141313","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1352","11","0","102070","2014-03-18","1","0","2014-03-21","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141389","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1353","11","0","102071","2014-03-18","1","0","2014-03-21","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141389","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1354","97","0","47922580002","2014-03-18","1","0","2014-03-19","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1355","97","0","4792269","2014-03-18","1","0","2014-03-19","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1356","8","0","575331","2014-03-18","0","1","2014-03-20","16","","1","","Jabil Circuit Arista ST-ASPCA-00516-02-01-T ASFAB-00256-02","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1357","8","0","575332","2014-03-19","0","1","2014-03-20","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1358","8","0","575333","2014-03-19","0","0","2014-03-20","8","","1","","Jabil Circuit Gigamon GS132-0089-400-C5","1","2014-03-19 02:32:14","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1359","7","0","9991755","2014-03-19","0","0","2014-03-27","17","","1","","SEM HE Microprobe INc. TTF0823A:A Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141537","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1360","7","0","9991756","2014-03-19","0","0","2014-03-19","9","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1361","2","0","5346836","2014-03-19","0","0","2014-03-19","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1362","97","0","4792270","2014-03-19","0","0","2014-03-20","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141314","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1363","72","0","1262694","2014-03-19","0","0","2014-03-19","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141311","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1364","8","0","575334","2014-03-19","0","0","2014-03-20","8","","1","","","1","2014-03-19 08:23:09","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1365","76","0","173022","2014-03-19","0","0","2014-03-20","8","","1","","Piranha EMS, Inc Universal Audio 50-03330_Rev1 FAB","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141400","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1366","7","0","9991762","2014-03-19","0","1","2014-04-02","16","","1","","SEM HE  SMT Comp Test Bd. rev 3 Apt Count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141640","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1367","3","0","5632144","2014-03-19","1","0","2014-03-20","19.3","","4","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1368","7","0","99917440002","2014-03-19","1","0","2014-03-19","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141307","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1369","2","0","5346837","2014-03-19","0","0","2014-03-20","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1370","93","0","2532118","2014-03-19","0","0","2014-03-20","10","","1","","SMTC Anr 3-72214-3 REV.C","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141364","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1371","8","0","575335","2014-03-19","1","0","2014-03-19","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1372","22","0","3474252","2014-03-19","0","0","2014-03-20","16","","8","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1373","2","0","5346838","2014-03-19","0","0","2014-03-20","10","","1","","Sanmina Coca Cola 0002118 Rev 0-00 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141340","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1374","2","0","5346839","2014-03-19","1","0","2014-03-24","15.3","","1","","Sanmina Coca Cola 0002421 Rev 0-00 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141416","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1375","2","0","5346840","2014-03-19","0","0","2014-03-20","11","","1","","APERTURE COUNT COCA-COLA 0002480 REV0-00","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141336","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1376","82","0","897574","2014-03-19","0","0","2014-03-20","17","","10","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141336","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1377","2","0","5346841","2014-03-19","0","0","2014-03-20","11","","1","","Sanmina Coca Cola 0002415 Rev 0-00 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141335","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1378","97","0","4792271","2014-03-19","0","1","2014-03-21","9","","1","","Surface Art INTEL J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141346","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1379","97","0","4792272","2014-03-19","0","1","2014-03-21","9","","1","","Surface Art INTEL J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141345","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1380","93","0","25319590008","2014-03-19","0","0","2014-03-20","12","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1381","93","0","2531959003","2014-03-19","1","0","2014-03-20","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141322","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1382","2","0","5346842","2014-03-19","1","1","2014-03-20","12","","1","","Sanmina Coca Cola 0002415 Rev 0-00 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141391","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1383","8","0","575336","2014-03-19","1","0","2014-03-19","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1384","36","0","6911919","2014-03-19","0","0","2014-03-25","18","","1","","FOXCONN Brocade 30-1001012-02","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141485","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1385","36","0","6911920","2014-03-19","0","0","2014-03-25","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141485","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1386","22","0","3474251","2014-03-19","0","0","2014-03-20","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1387","2","0","5346843","2014-03-19","0","0","2014-03-20","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141333","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1388","70","0","1105119","2014-03-19","0","0","2014-03-20","14","","1","","Oncore TFRE 190427@C","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141411","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1389","20","0","938666","2014-03-19","0","0","2014-03-20","16","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141347","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1390","20","0","938665","2014-03-19","0","0","2014-03-20","16","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141346","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1391","22","0","3474253","2014-03-19","0","0","2014-03-26","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141357","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1392","59","0","343295","2014-03-19","1","0","2014-03-20","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141320","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1393","111","0","782672","2014-03-19","0","0","2014-03-20","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141342","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1394","97","0","4792273","2014-03-19","1","1","2014-03-20","12","","1","","Surface Art INTEL SA J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141323","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1395","2","0","5346844","2014-03-19","0","0","2014-03-20","15","","1","","Sanmina Newisys PCA-00663-01-A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141334","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1396","51","0","9931372","2014-03-19","0","0","2014-03-20","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1397","89","0","973456","2014-03-19","1","0","2014-03-20","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141375","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1398","2","0","5346845","2014-03-19","0","0","2014-03-20","17","","1","","Sanmina Newisys PCA-00663-01-A","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141348","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1399","97","0","4792275","2014-03-19","1","0","2014-03-19","18.3","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141326","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1400","97","0","4792266004","2014-03-19","1","0","2014-03-19","18.3","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141327","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1401","7","0","99914060003","2014-03-19","0","0","2014-03-20","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141376","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1402","8","0","575337","2014-03-19","0","0","2014-03-21","8","","1","","Jabil LTX 974-1553-00-DA-T 948-1553-00-AA","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141386","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1403","8","0","575338","2014-03-19","0","0","2014-03-21","8","","1","","Jabil LTX 974-1553-00-DA-T 948-1553-00-AA","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141386","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1404","8","0","575339","2014-03-20","0","0","2014-03-21","8","","1","","Jabil Agilent Assy ST-N9613-68006-PB-B N9613-20006-A140307","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141387","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1405","8","0","575340","2014-03-20","0","0","2014-03-21","8","","1","","Jabil Agilent Assy ST-N9613-68006-PB-B N9613-20006-A140307","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141387","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1406","8","0","575341","2014-03-20","0","0","2014-03-21","8","","1","","Jabil Agilent Assy ST-N9613-68004-PB-T N9613-20004-A140223","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141388","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1407","8","0","575342","2014-03-20","0","0","2014-03-21","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141388","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1408","20","0","938667","2014-03-20","0","0","2014-03-21","16","","15","","Ascentron IDD AEROSPACE 520-000018 p/n 790-2510","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141341","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1409","2","0","5346846","2014-03-20","0","0","2014-03-21","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141366","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1410","4","0","321718004","2014-03-20","0","0","2014-03-21","11","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1411","93","0","2532120","2014-03-20","0","0","2014-03-24","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1412","93","0","2532121","2014-03-20","0","0","2014-03-24","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1413","78","0","311054","2014-03-20","1","0","2014-03-21","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141393","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1414","36","0","6911925","2014-03-20","1","0","2014-03-24","9","","1","","FOXCONN Brocade 30-1001014-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141401","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1415","36","0","6911926","2014-03-20","1","0","2014-03-24","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141401","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1416","36","0","6911927","2014-03-20","0","0","2014-03-24","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1417","36","0","6911928","2014-03-20","0","0","2014-03-24","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1438","97","0","4792277","2014-03-20","0","0","2014-03-21","14","","1","","Surface Art Signal Scape J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141372","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1418","88","0","6092042","2014-03-20","0","0","2014-03-21","16","","11","","Sanmina CONTROL4 040-00242 R1 Primary","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141374","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1419","88","0","6092044","2014-03-20","0","0","2014-03-24","16","","11","","Sanmina MOOG CB59849-003 Secondary","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141396","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1420","88","0","6092043","2014-03-20","0","0","2014-03-24","16","","11","","Sanmina MOOG CB59849-003  Primary","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141396","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1421","20","0","938668","2014-03-20","0","0","2014-03-21","16","","15","","Ascentron Micro Interconnects 16715-66402 P/N 790-2511","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141380","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1422","1","0","8292531","2014-03-20","1","0","2014-03-24","10","","15","","Foxconn iDSBGIDSBG 820-00008-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1423","42","0","660020","2014-03-20","0","0","2014-03-24","17","","1","","Hunter Technology DSSD 000564-04 Rev 1 Brainiac Assembly","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141449","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1424","42","0","660021","2014-03-20","0","0","2014-03-21","15","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1425","97","0","47922700002","2014-03-20","0","0","2014-03-21","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141394","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1426","36","0","6911929","2014-03-20","0","0","2014-03-25","15","","1","","FOXCONN Brocade 30-1001015-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141473","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1427","36","0","6911930","2014-03-20","0","0","2014-03-25","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141473","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1428","1","0","8292533","2014-03-20","0","0","2014-03-21","15","","1","","Foxconn iDSBG IDSBG 920-00145-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141377","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1429","1","0","8292532","2014-03-20","0","0","2014-03-21","15","","1","","Foxconn iDSBG IDSBG 920-00175-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141378","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1430","59","0","343296","2014-03-20","1","0","2014-03-21","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141351","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1431","59","0","343297","2014-03-20","1","0","2014-03-21","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141351","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1432","2","0","5346848","2014-03-20","0","1","2014-03-21","16","","1","","Sanmina Cupe  939-00067 Rev-NA","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141379","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1433","36","0","6911931","2014-03-20","0","0","2014-03-21","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141446","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1434","2","0","5346849","2014-03-20","1","1","2014-03-21","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141368","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1435","1","0","8292534","2014-03-20","0","0","2014-03-21","11","","1","","Foxconn-iDSBG iDSBG 920-00107-02","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141373","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1436","35","0","8002010002","2014-03-20","0","0","2014-03-25","12","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1437","2","0","5346850","2014-03-20","0","1","2014-03-21","17","","1","","Sanmina  MRV 5000802-006R rev.A1 LOC : U1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141383","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1439","76","0","173021","2014-03-20","0","1","2014-03-24","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141432","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1440","1","0","82925250002","2014-03-20","1","0","2014-03-20","19","","1","","hot fixit.  Deliver to receiving","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1441","4","0","321775","2014-03-20","0","0","2014-03-21","17","","1","","Flextronics Motorola MOT1-591400-001-00 MOT1-591401-001-00 C","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1442","72","0","1262695","2014-03-20","1","0","2014-03-21","11","","1","","Pactron Incorporated PAC2966_20March2014_ WO24254_T(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141371","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1443","72","0","1262696","2014-03-20","1","0","2014-03-21","11","","1","","Pactron Incorporated PAC2967_20March2014_ WO24254_B(Leaded)","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141371","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1444","8","0","575344","2014-03-20","1","0","2014-03-21","19","","1","","Jabil LTX ST-974-1166-03-BB-T 948-1166-04-BA","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1445","8","0","575345","2014-03-20","1","0","2014-03-21","19","","1","","Jabil LTX ST-974-1166-03-BB-B 948-1166-04-BA","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1446","11","0","102072","2014-03-21","0","0","2014-03-24","8","","1","","Zollner Electronics Rheem 1766102-02","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141482","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1447","3","0","5632147","2014-03-21","0","0","2014-03-24","16","","4","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141454","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1451","9","0","2814017","2014-03-21","0","0","2014-03-24","9","","1","","Sanmina - SCI, Corp. RDC Assy 151-0033 PCB 152-0033 rev 1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1448","3","0","5632148","2014-03-21","0","0","2014-03-24","16","","4","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141453","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1449","7","0","9991765","2014-03-21","1","0","2014-03-24","17","","1","","SEM HE Intel 610-0271","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141419","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1450","7","0","9991766","2014-03-21","1","0","2014-03-24","17","","1","","SEM HE MT ASIA TEF7000 PROBECARD C13175B","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141420","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1452","9","0","2814018","2014-03-21","0","0","2014-03-24","9","","1","","Sanmina - SCI, Corp. RDC Assy 151-0033 PCB 152-0033 rev 1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1453","43","0","5413951","2014-03-21","0","0","2014-03-24","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141395","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1454","43","0","5413952","2014-03-21","0","0","2014-03-24","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141395","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1455","84","0","222085","2014-03-21","0","0","2014-03-25","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141496","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1456","84","0","222086","2014-03-21","0","0","2014-03-24","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1457","83","0","613387","2014-03-21","0","0","2014-03-24","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141428","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1458","89","0","973457","2014-03-21","0","0","2014-03-24","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141528","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1459","89","0","973458","2014-03-21","0","0","2014-03-24","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141528","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1460","8","0","575346","2014-03-21","0","0","2014-03-25","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141451","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1461","8","0","575347","2014-03-21","0","0","2014-03-25","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141451","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1462","97","0","4792278","2014-03-21","0","0","2014-03-24","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141399","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1463","34","0","7994752","2014-03-21","0","0","2014-03-25","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141423","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1464","43","0","5413953","2014-03-21","0","0","2014-03-24","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1465","22","0","3474254","2014-03-21","0","0","2014-03-25","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141462","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1466","22","0","3474255","2014-03-21","0","0","2014-03-25","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141459","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1467","22","0","3474256","2014-03-21","0","0","2014-04-15","17","","8","","Axiom Electronics MaxViz Tamarisk Interface 901767054 STB000863","2","2014-04-15 10:43:08","614","5","Foil Only","2","2014-04-15 16:25:42","2","2014-04-15 16:30:05","0","0000-00-00 00:00:00","2","141915","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1468","59","0","343298","2014-03-21","1","1","2014-03-25","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141444","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1469","4","0","321776","2014-03-21","0","0","2014-03-25","12","","1","","","2","2014-03-24 08:55:34","","","","2","2014-03-24 18:32:13","2","2014-03-25 09:51:43","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1470","2","0","5346851","2014-03-21","0","0","2014-03-24","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141413","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1471","22","0","3474258","2014-03-21","0","0","2014-03-25","16","","8","","Axiom Electronics Boeing Post-Reg/Filter 901767078 STB000865","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141475","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1472","22","0","3474257","2014-03-21","0","0","2014-03-24","16","","8","","Axiom Electronics MaxViz Tamarisk Power 901767053 STB000862","2","2014-04-15 16:32:27","","","","2","2014-04-15 16:32:38","2","2014-04-15 16:35:13","0","0000-00-00 00:00:00","2","141936","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1473","34","0","7994753","2014-03-21","0","0","2014-03-25","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141424","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1474","50","0","630329","2014-03-21","0","0","2014-03-26","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141513","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1475","50","0","630330","2014-03-21","0","0","2014-03-26","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141513","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1476","15","0","896021","2014-03-21","1","0","2014-03-21","18","","2","","Also will borrow 1 flexframe unit and hose attachment","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141398","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1477","76","0","173023","2014-03-21","0","0","2014-03-24","16","","1","","Piranha EMS, Inc Universal Audio 50-03320 Rev1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141494","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1478","42","0","660022","2014-03-21","0","1","2014-03-24","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141452","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1479","72","0","1262697","2014-03-21","1","0","2014-03-24","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1480","4","0","321777","2014-03-21","0","0","2014-03-24","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1481","97","0","4792279","2014-03-21","0","0","2014-03-24","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1482","1","0","8292536","2014-03-21","1","0","2014-03-24","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141425","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1483","22","0","3474259","2014-03-21","0","0","2014-03-25","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141468","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1484","22","0","3474260","2014-03-21","0","0","2014-03-25","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141468","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1485","22","0","3474261","2014-03-21","0","0","2014-03-25","16","","8","","Axiom Electronics Boeing MP Interface Mod 1 901767034 STP000854","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141464","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1486","22","0","3474262","2014-03-21","0","0","2014-03-25","16","","8","","Axiom Electronics Boeing MP Interface Mod 1 901767034 STS000683","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141464","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1487","9","0","2814019","2014-03-21","1","0","2014-03-25","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1488","89","0","973459","2014-03-21","0","0","2014-03-24","17","","1","","","1","2014-03-24 03:25:22","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1489","89","0","973460","2014-03-21","0","0","2014-03-24","17","","1","","","1","2014-03-24 03:30:14","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1509","113","0","1112480002","2014-03-24","1","0","2014-03-24","19.3","","5","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1490","7","0","9991767","2014-03-24","1","0","2014-04-07","14","","1","","","2","2014-04-07 08:59:39","718","10","Z1","2","2014-04-07 10:55:22","2","2014-04-07 11:35:31","2","2014-04-07 13:31:33","2","141731","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1491","7","0","9991768","2014-03-24","0","0","2014-03-25","8","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1506","20","0","938670","2014-03-24","0","0","2014-03-25","16","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141458","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1492","7","0","9991769","2014-03-24","0","0","2014-03-25","8","","1","","SEM HE Joy Signal Technology 691865_1 54728A1 Apt count =","2","2014-04-04 13:36:45","","","","2","2014-04-04 15:53:27","2","2014-04-04 16:30:05","2","2014-04-07 08:13:59","2","141718","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1493","7","0","9991770","2014-03-24","0","0","2014-04-04","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1494","7","0","9991771","2014-03-24","0","0","2014-03-25","8","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1495","7","0","9991772","2014-03-24","1","0","2014-04-02","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141647","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1496","7","0","9991773","2014-03-24","0","0","2014-03-25","8","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1497","7","0","9991774","2014-03-24","0","0","2014-04-01","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141617","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1498","31","0","7582235","2014-03-24","0","0","2014-03-24","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1499","31","0","7582236","2014-03-24","0","0","2014-03-24","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1500","31","0","7582237","2014-03-24","0","0","2014-03-24","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1501","31","0","7582238","2014-03-24","0","0","2014-03-24","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1502","2","0","5346852","2014-03-24","1","0","2014-03-24","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141409","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1503","72","0","1262698","2014-03-24","0","0","2014-03-24","20","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1504","72","0","1262699","2014-03-24","1","0","2014-03-26","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141430","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1505","72","0","1262700","2014-03-24","1","0","2014-03-24","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141405","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1507","20","0","938671","2014-03-24","0","0","2014-03-25","16","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141458","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1508","20","0","938669","2014-03-24","0","0","2014-03-25","16","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141465","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1510","4","0","321778","2014-03-24","0","0","2014-03-24","17","","1","","Flextronics \r\nF5 Networks \r\nPCA-0335-00","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1511","10","0","2392956","2014-03-24","1","1","2014-04-10","18","","1","","","2","2014-04-10 13:41:30","1552","4","Z2","2","2014-04-10 15:04:37","2","2014-04-10 18:25:45","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1512","10","0","2392957","2014-03-24","1","1","2014-04-10","18","","1","","","2","2014-04-10 13:41:46","193","5","Z2","2","2014-04-10 14:57:48","2","2014-04-10 18:25:54","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1542","51","0","9931375","2014-03-24","0","0","2014-03-25","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1513","1","0","82925130002","2014-03-24","1","0","2014-03-24","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1514","1","0","82925310002","2014-03-24","1","0","2014-03-24","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1515","22","0","3474263","2014-03-24","0","0","2014-03-25","16","","8","","","1","2014-03-25 02:41:46","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1516","10","0","2392954","2014-03-24","0","0","2014-03-25","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141450","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1517","10","0","2392955","2014-03-24","0","0","2014-03-25","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141450","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1518","97","0","4792280","2014-03-24","1","0","2014-03-25","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141436","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1519","97","0","4792281","2014-03-24","1","0","2014-03-25","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141438","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1520","31","0","7582239","2014-03-24","0","0","2014-03-25","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141477","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1521","51","0","9931374","2014-03-24","0","0","2014-03-25","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1522","11","0","102074","2014-03-24","0","0","2014-03-25","11","","1","","Zollner Electronics Tarana Wireless 1795162-01_31-0028-301","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141489","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1523","11","0","102073","2014-03-24","0","0","2014-03-25","11","","1","","Zollner Electronics Tarana Wireless 1795162-01_31-0028-301","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141489","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1524","72","0","1262701","2014-03-24","1","0","2014-03-24","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141440","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1525","54","0","914609","2014-03-24","0","0","2014-03-25","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141486","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1526","54","0","914608","2014-03-24","0","0","2014-03-25","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141495","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1527","31","0","7582240","2014-03-24","0","0","2014-03-25","17.3","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141476","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1528","31","0","7582241","2014-03-24","0","0","2014-03-25","17.3","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141476","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1529","1","0","8292539","2014-03-24","0","0","2014-03-25","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141469","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1530","31","0","7582244","2014-03-24","0","0","2014-03-25","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141463","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1531","31","0","7582245","2014-03-24","0","0","2014-03-25","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141463","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1532","31","0","7582242","2014-03-24","0","0","2014-03-25","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141466","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1533","31","0","7582243","2014-03-24","0","0","2014-03-25","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141466","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1534","93","0","2532122","2014-03-24","0","0","2014-03-25","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141498","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1535","93","0","2532123","2014-03-24","0","0","2014-03-25","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141498","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1536","11","0","102075","2014-03-24","1","0","2014-03-25","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141483","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1537","44","0","954033","2014-03-24","0","0","2014-03-25","6","","4","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141460","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1538","97","0","4792282","2014-03-24","0","0","2014-03-25","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141470","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1539","76","0","173024","2014-03-24","1","0","2014-03-25","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1540","35","0","8001590002","2014-03-24","1","0","2014-03-25","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1541","59","0","343299","2014-03-24","1","0","2014-03-25","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141442","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1543","41","0","832735","2014-03-24","0","0","2014-03-25","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141474","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1544","51","0","9931376","2014-03-24","0","0","2014-03-25","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1545","8","0","575349","2014-03-24","0","0","2014-03-26","16","","1","","","1","2014-03-24 20:34:56","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1546","8","0","575350","2014-03-24","0","0","2014-03-26","16","","1","","","1","2014-03-24 20:37:37","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1555","51","0","9931253004","2014-03-25","1","0","2014-03-25","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1554","51","0","9931252003","2014-03-25","1","0","2014-03-25","11","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1547","72","0","1262702","2014-03-25","1","0","2014-03-25","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1548","41","0","832736","2014-03-25","0","0","2014-03-25","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141467","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1549","2","0","5346853","2014-03-25","0","0","2014-03-26","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141478","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1550","2","0","5346854","2014-03-25","0","0","2014-03-26","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141478","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1551","72","0","1262703","2014-03-25","1","0","2014-03-25","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141456","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1552","72","0","1262704","2014-03-25","1","0","2014-03-25","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1553","72","0","1262705","2014-03-25","0","0","2014-03-25","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141488","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1556","1","0","8292541","2014-03-25","0","0","2014-03-26","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141487","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1557","1","0","8292540","2014-03-25","0","0","2014-03-26","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141471","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1558","2","0","5346855","2014-03-25","1","0","2014-03-25","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141461","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1559","10","0","2392958","2014-03-25","0","0","2014-03-25","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141677","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1560","10","0","2392959","2014-03-25","0","0","2014-03-25","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141677","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1561","10","0","2392960","2014-03-25","0","0","2014-03-25","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141561","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1562","10","0","2392961","2014-03-25","0","0","2014-03-25","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141677","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1563","1","0","8292542","2014-03-25","0","0","2014-03-26","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1564","22","0","3474264","2014-03-25","1","0","2014-03-26","16","","4","","Axiom Electronics Intel  905000378 STB000338","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141529","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1565","107","0","614138","2014-03-25","0","0","2014-03-27","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141527","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1566","11","0","102076","2014-03-25","1","0","2014-03-27","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141536","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1567","11","0","102077","2014-03-25","1","0","2014-03-27","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141536","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1568","7","0","99917460002","2014-03-25","1","0","2014-03-26","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141480","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1569","54","0","914610","2014-03-25","0","0","2014-03-26","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141499","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1570","22","0","3474267","2014-03-25","0","0","2014-03-27","19.3","","8","","Axiom Electronics Boeing MSL SYS Tele C","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141518","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1571","22","0","3474268","2014-03-25","0","0","2014-03-27","19.3","","8","","Axiom Electronics Boeing MSL SYS Tele C","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141518","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1572","22","0","3474265","2014-03-25","0","0","2014-03-27","19.3","","8","","Axiom Electronics Boeing MSL Guide Tele C","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141519","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1573","22","0","3474266","2014-03-25","0","0","2014-03-27","19.3","","8","","Axiom Electronics Boeing MSL Guide Tele C","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141518","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1574","7","0","9991735001","2014-03-25","1","0","2014-03-25","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141490","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1575","89","0","973461","2014-03-25","1","0","2014-03-26","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141491","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1576","1","0","8292543","2014-03-25","0","0","2014-03-26","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141506","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1577","76","0","1730210002","2014-03-25","1","0","2014-03-25","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1578","72","0","1262706","2014-03-25","0","0","2014-03-26","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141515","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1579","97","0","4792283","2014-03-25","1","0","2014-03-26","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141497","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1580","51","0","9931379","2014-03-25","0","0","2014-03-26","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1581","51","0","9931380","2014-03-25","0","0","2014-03-26","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1582","89","0","973462","2014-03-25","0","0","2014-03-27","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141523","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1583","8","0","575351","2014-03-25","0","0","2014-03-27","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141517","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1584","8","0","575352","2014-03-25","0","0","2014-03-27","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141517","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1601","35","0","800193002","2014-03-26","0","0","2014-03-28","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141538","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1585","72","0","12626707","2014-03-26","0","0","2014-03-26","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141508","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1586","72","0","12626708","2014-03-26","0","0","2014-03-26","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141508","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1587","7","0","9991777","2014-03-26","1","0","2014-04-03","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141659","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1588","7","0","9991778","2014-03-26","1","0","2014-04-03","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141659","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1589","7","0","9991779","2014-03-26","0","0","2014-04-01","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141616","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1590","7","0","9991780","2014-03-26","0","0","2014-03-27","8","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1591","7","0","9991781","2014-03-26","0","0","2014-03-27","8","","1","","","1","2014-03-26 06:26:46","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1592","7","0","9991782","2014-03-26","0","0","2014-03-27","8","","1","","","1","2014-03-26 06:27:26","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1593","7","0","9991783","2014-03-26","0","0","2014-04-07","17","","1","","","2","2014-04-07 10:05:21","308","6","Z1","2","2014-04-07 11:08:05","1","2014-04-07 11:29:50","2","2014-04-07 13:32:22","2","141733","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1594","7","0","9991784","2014-03-26","0","0","2014-04-07","17","","1","","","2","2014-04-07 10:05:44","1842","6","Z1","2","2014-04-07 11:43:23","2","2014-04-07 11:57:17","2","2014-04-07 13:32:06","2","141733","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1605","8","0","575353","2014-03-26","0","0","2014-03-27","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141553","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1595","57","0","767126","2014-03-26","1","0","2014-03-26","16","","10","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141507","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1596","57","0","767127","2014-03-26","1","0","2014-03-26","16","","10","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141507","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1597","9","0","2814020","2014-03-26","0","0","2014-03-27","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1598","57","0","767128","2014-03-26","0","0","2014-03-27","16","","10","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141525","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1599","57","0","767129","2014-03-26","0","0","2014-03-27","16","","10","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141525","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1600","10","0","2392962","2014-03-26","1","0","2014-03-26","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1602","51","0","9931381","2014-03-26","0","0","2014-03-27","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1603","110","0","952385","2014-03-26","0","0","2014-03-27","17","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141542","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1604","97","0","4792284","2014-03-26","0","0","2014-03-27","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141509","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1606","3","0","5632149","2014-03-26","0","0","2014-03-27","17","","4","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1607","7","0","9991743005","2014-03-26","0","0","2014-03-27","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141516","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1608","8","0","575354","2014-03-26","0","0","2014-03-27","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141561","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1609","83","0","6133870002","2014-03-26","1","0","2014-03-26","6","","4","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1610","8","0","575355","2014-03-26","0","0","2014-03-28","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141560","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1611","8","0","575356","2014-03-26","0","0","2014-03-28","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141592","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1612","8","0","575357","2014-03-26","0","0","2014-03-28","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141592","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1613","3","0","5632150","2014-03-26","1","0","2014-03-27","17","","4","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141531","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1614","1","0","8292542006","2014-03-26","0","0","2014-03-27","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141522","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1739","1","0","8292549","2014-04-01","0","0","2014-04-02","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141627","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1737","97","0","4792291","2014-04-01","1","0","2014-04-01","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141618","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1615","43","0","5413954","2014-03-26","1","0","2014-03-28","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141559","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1616","2","0","5346856","2014-03-26","0","0","2014-03-28","16","","1","","Sanmina Alcatel 82-0591-02 Rev 2 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141551","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1617","2","0","5346857","2014-03-26","0","0","2014-03-27","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141521","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1618","51","0","9931382","2014-03-26","0","0","2014-03-27","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1619","51","0","9931383","2014-03-26","0","0","2014-03-27","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1620","97","0","4792285","2014-03-26","0","0","2014-03-27","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141520","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1621","4","0","321779","2014-03-26","0","0","2014-04-02","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1622","4","0","321780","2014-03-26","0","0","2014-04-02","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1623","4","0","321781","2014-03-26","0","0","2014-04-02","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1624","4","0","321782","2014-03-26","0","0","2014-04-02","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1625","4","0","321783","2014-03-26","0","0","2014-04-02","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1626","4","0","321784","2014-03-26","0","0","2014-04-02","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1627","4","0","321785","2014-03-26","0","0","2014-04-02","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1628","4","0","321786","2014-03-26","0","0","2014-04-02","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1629","5","0","4894495","2014-03-26","0","0","2014-03-28","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141526","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1630","5","0","4894496","2014-03-26","0","0","2014-03-28","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141526","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1639","29","0","919103","2014-03-27","0","0","2014-03-28","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141562","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1631","8","0","575358","2014-03-26","0","0","2014-03-28","21","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1632","8","0","575359","2014-03-26","1","0","2014-03-28","21","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1633","8","0","575360","2014-03-26","0","0","2014-03-28","21","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1634","8","0","575361","2014-03-26","1","0","2014-03-28","21","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1635","8","0","575362","2014-03-26","0","0","2014-03-28","21","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141552","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1636","8","0","575363","2014-03-26","0","0","2014-03-28","21","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141552","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1646","43","0","5413955","2014-03-27","0","0","2014-03-28","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141556","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1637","42","0","660023","2014-03-27","0","0","2014-03-31","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141608","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1638","42","0","660024","2014-03-27","0","0","2014-03-28","0","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141608","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1640","55","0","983090","2014-03-27","1","0","2014-03-28","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141543","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1641","59","0","343300","2014-03-27","1","0","2014-03-28","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141532","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1642","19","0","835266","2014-03-27","0","0","2014-03-28","16","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141551","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1643","19","0","835267","2014-03-27","0","0","2014-03-28","16","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141550","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1644","59","0","343301","2014-03-27","1","0","2014-03-28","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141534","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1645","59","0","343302","2014-03-27","1","0","2014-03-28","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141534","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1647","22","0","3474269","2014-03-27","0","0","2014-03-28","19.3","","8","","Axiom Electronics Intel  905000377 STB000339","1","2014-03-27 20:43:42","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1648","6","0","739355","2014-03-27","0","0","2014-04-01","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141594","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1649","22","0","3474270","2014-03-27","1","0","2014-04-01","16","","4","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141610","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1650","22","0","3474271","2014-03-27","1","0","2014-03-31","16","","4","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141597","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1651","11","0","102078","2014-03-27","1","0","2014-03-28","15","","1","","Zollner Electronics Credence 1796820-00_CR1V2","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141549","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1652","11","0","102079","2014-03-27","1","0","2014-03-28","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141549","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1653","17","0","637615","2014-03-27","0","0","2014-03-28","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141558","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1654","17","0","637616","2014-03-27","0","0","2014-03-28","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141558","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1655","84","0","2220780002","2014-03-27","0","0","2014-03-31","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141544","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1656","1","0","8292545","2014-03-27","0","0","2014-03-28","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141557","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1668","7","0","9991790","2014-03-28","1","0","2014-03-28","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141547","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1657","10","0","239296200000","2014-03-27","1","0","2014-03-28","10","","1","","Fixit stencil","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1664","3","0","5632151","2014-03-28","1","0","2014-03-28","17","","4","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141565","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1658","76","0","173026","2014-03-28","0","0","2014-03-28","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141541","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1659","8","0","5750170002","2014-03-28","0","0","2014-03-28","18","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1660","42","0","660025","2014-03-28","0","0","2014-04-01","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141608","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1661","42","0","660026","2014-03-28","0","0","2014-04-01","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141608","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1662","8","0","5751070002","2014-03-28","0","0","2014-03-28","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141554","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1663","72","0","1262710","2014-03-28","0","0","2014-03-28","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141560","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1665","42","0","660020003","2014-03-28","1","0","2014-03-28","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141545","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1666","4","0","321787","2014-03-28","0","0","2014-03-31","10","","1","","Flextronics Cavium CVN-EBA-KR-QSFPG-22MM-01 CVN-EBA-KR-QSFPG-40MM-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1667","4","0","321788","2014-03-28","0","0","2014-03-31","10","","1","","Flextronics Cavium CVN-EBA-KR-QSFPG-22MM-01 CVN-EBA-KR-QSFPG-40MM-01","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1669","7","0","99917900002","2014-03-28","1","0","2014-03-28","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141546","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1670","7","0","9991788","2014-03-28","0","0","2014-03-31","17","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1671","7","0","9991789","2014-03-28","0","0","2014-04-03","17","","1","","SEM HE Feinmetal GmbH 8VBTJ750-359 C13592:A Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141676","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1672","7","0","9991786","2014-03-28","0","0","2014-03-31","17","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1673","7","0","9991787","2014-03-28","0","0","2014-04-10","17","","1","","SEM HE NXP SEMICOND GERMANY GMBH L3030_LITHIOPD4XF C13581A Apt count =","2","2014-04-10 15:53:16","1436","8","Z1","2","2014-04-10 18:40:39","2","2014-04-10 19:39:32","2","2014-04-11 07:39:40","2","141849","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1674","9","0","2814021","2014-03-28","0","0","2014-03-31","9","","1","","Sanmina  8000-0162-000 rev A1 17000-0162-0A1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1675","83","0","613389","2014-03-28","1","0","2014-03-28","16","","4","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141548","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1676","7","0","9991792","2014-03-28","0","0","2014-03-31","10","","1","","SEM HE Feinmetall GmbH 8VBUFLEX-073 C13125:A Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141604","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1677","7","0","9991793","2014-03-28","0","0","2014-04-01","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141604","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1678","7","0","9991794","2014-03-28","0","0","2014-04-01","17","","1","","SEM HE Intel Corporation ITTO-580-0023:2 Apt count =","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141615","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1679","7","0","9991795","2014-03-28","0","0","2014-04-01","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141615","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1680","11","0","102080","2014-03-28","1","0","2014-03-28","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1681","99","0","148074","2014-03-28","1","0","2014-03-28","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141564","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1682","51","0","9931384","2014-03-28","0","0","2014-03-31","13","","1","","Javad Google GO-90-4001 Rev 1.0.0","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1683","93","0","2532124","2014-03-28","0","0","2014-03-31","14","","1","","SMTC ANR 3-76287-3P3","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141598","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1684","93","0","2532125","2014-03-28","0","0","2014-03-31","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141598","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1685","31","0","7582246","2014-03-28","0","0","2014-03-31","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141574","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1686","72","0","1262711","2014-03-28","1","0","2014-03-28","20.3","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1687","110","0","952386","2014-03-28","0","0","2014-03-31","16","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141575","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1688","59","0","343303","2014-03-28","1","0","2014-03-31","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141566","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1689","59","0","343304","2014-03-28","1","0","2014-03-31","9","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1690","97","0","4792286","2014-03-28","0","0","2014-03-31","15","","1","","Surface Art Murdoc 75007100-PS3 REV 4R2 J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141571","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1691","8","0","575364","2014-03-28","0","0","2014-03-31","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1692","97","0","4792287","2014-03-28","0","0","2014-03-31","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141590","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1693","97","0","4792288","2014-03-28","0","0","2014-03-31","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141590","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1694","76","0","173027","2014-03-28","0","0","2014-03-31","11","","1","","","2","2014-03-28 18:28:54","","","","2","2014-03-31 11:08:17","2","2014-04-02 16:41:44","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1695","8","0","575367","2014-03-28","0","0","2014-04-08","17","","1","","Jabil Circuit Virtual Instruments  ST-VT106-102143-01-T VT107-102144-01","2","2014-04-08 13:03:58","7937","5","Z2","2","2014-04-08 19:28:37","2","2014-04-08 21:25:16","2","2014-04-09 07:40:45","2","141788","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1696","8","0","575368","2014-03-28","0","0","2014-04-08","17","","1","","Jabil Circuit Virtual Instruments ST-VT106-102143-01-B VT107-102144-01","2","2014-04-08 13:04:20","4551","5","Z2","2","2014-04-08 20:06:12","2","2014-04-08 21:25:08","2","2014-04-09 07:40:38","2","141788","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1697","7","0","9991796","2014-03-30","0","0","2014-03-31","17","","1","","SEM HE Microprobe Inc. TTF0823A:A Apt count =","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1698","7","0","9991797","2014-03-30","0","0","2014-03-31","17","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1699","72","0","1262712","2014-03-30","0","0","2014-03-31","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141579","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1705","7","0","9991798","2014-03-31","0","0","2014-04-03","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141665","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1700","109","0","255710","2014-03-30","0","0","2014-04-02","8","","1","","","1","2014-03-31 04:45:27","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1701","72","0","1262713","2014-03-31","1","0","2014-03-31","9","","1","","Pactron Incorporated PAC2983_31March2014_ WO24477_T","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141573","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1702","72","0","1262714","2014-03-31","0","0","2014-03-31","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141572","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1703","72","0","1262716","2014-03-31","0","0","2014-03-31","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141577","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1704","72","0","1262715","2014-03-31","0","0","2014-03-31","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141572","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1706","7","0","9991799","2014-03-31","0","0","2014-04-01","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141665","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1707","11","0","102082","2014-03-31","0","0","2014-04-01","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141593","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1708","11","0","102081","2014-03-31","0","0","2014-04-01","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141593","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1709","97","0","4792289","2014-03-31","1","0","2014-03-31","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141589","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1710","1","0","8292546","2014-03-31","0","0","2014-04-01","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141596","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1711","7","0","9991800","2014-03-31","0","0","2014-04-02","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141649","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1712","7","0","9991801","2014-03-31","0","0","2014-04-02","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141648","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1713","4","0","321791","2014-03-31","0","0","2014-04-01","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1714","4","0","321792","2014-03-31","0","0","2014-04-01","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1715","23","0","38421390002","2014-03-31","0","0","2014-04-01","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1716","6","0","739356","2014-03-31","0","0","2014-04-01","16","","1","","","2","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1717","3","0","5632152","2014-03-31","0","0","2014-04-01","16","","4","","Intel Corporation Canyon Village STB PB H11812-001 MID","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141614","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1718","93","0","2532126","2014-03-31","0","0","2014-04-01","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141623","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1719","93","0","2532127","2014-03-31","0","0","2014-04-01","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141623","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1720","1","0","8292547","2014-03-31","1","0","2014-04-01","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141600","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1721","59","0","343305","2014-03-31","1","0","2014-04-01","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141591","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1722","59","0","343306","2014-03-31","1","0","2014-04-01","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141591","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1723","31","0","7582247","2014-03-31","0","0","2014-04-14","16","","8","","Controltek 180-1928-E STRECH 890-1241-0 STRECH 890-1243-0 STRECH","2","2014-04-14 10:06:22","2192","4","18X18","2","2014-04-14 14:01:18","2","2014-04-14 15:28:53","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1724","31","0","7582248","2014-03-31","0","0","2014-04-14","16","","8","","Controltek 180-1928-E STRECH 890-1243-0 STRECH 890-1243-0 STRECH","2","2014-04-14 10:07:10","379","4","18X18","2","2014-04-14 16:35:38","2","2014-04-14 18:33:41","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1725","70","0","1105121","2014-03-31","0","0","2014-04-01","15","","1","","Oncore THUM 2660021146152@B TOP SIDE","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141628","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1726","70","0","1105122","2014-03-31","0","0","2014-04-01","15","","1","","Oncore THUM 2660021146152@B BOTTOM SIDE","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141628","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1727","1","0","8292548","2014-03-31","1","0","2014-04-01","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141599","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1728","97","0","4792290","2014-03-31","0","0","2014-04-01","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141603","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1729","25","0","966266","2014-03-31","0","0","2014-04-01","18","","10","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141607","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1730","41","0","832737","2014-03-31","0","0","2014-04-01","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1731","88","0","6092045","2014-04-01","0","0","2014-04-02","16","","11","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141621","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1732","99","0","1480740002","2014-04-01","0","0","2014-04-01","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141564","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1733","107","0","6141360002","2014-04-01","0","0","2014-04-29","16","","1","","","2","2014-04-25 06:53:47","","","","2","2014-04-29 09:38:38","2","2014-04-29 09:38:47","2","2014-04-29 10:56:52","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1734","107","0","6141350002","2014-04-01","0","0","2014-04-29","16","","1","","","2","2014-04-25 06:53:18","","","","2","2014-04-29 09:31:42","2","2014-04-29 09:31:56","2","2014-04-29 10:57:12","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1756","10","0","2392964","2014-04-01","0","0","2014-04-02","14","","1","","ASteelFlash Tesla 1024392-01","2","2014-04-02 11:28:40","","","","2","2014-04-02 12:50:17","2","2014-04-02 15:11:36","2","2014-04-07 09:38:06","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1735","107","0","614141","2014-04-01","0","0","2014-04-29","16","","1","","","2","2014-04-25 06:52:43","","","","2","2014-04-29 09:37:07","2","2014-04-29 09:37:16","2","2014-04-29 10:57:44","2","142209","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1736","107","0","614142","2014-04-01","0","0","2014-04-29","16","","1","","","2","2014-04-24 16:29:44","","","","2","2014-04-24 20:54:51","2","2014-04-29 09:35:44","2","2014-04-29 10:57:30","2","142209","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1738","97","0","4792292","2014-04-01","1","0","2014-04-01","18","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141618","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1740","93","0","2532128","2014-04-01","0","0","2014-04-02","10","","1","","SMTC ANR 3-80435-3P1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141651","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1741","93","0","2532129","2014-04-01","0","0","2014-04-02","10","","1","","SMTC ANR 3-80435-3P1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141651","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1742","34","0","7994754","2014-04-01","0","0","2014-04-02","10","","1","","Creation Tech. Alcatel ALC76-0678-02 Rev. 01 TALCS233_LF","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141633","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1743","34","0","7994755","2014-04-01","0","0","2014-04-02","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141645","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1744","97","0","4792293","2014-04-01","1","0","2014-04-01","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141622","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1757","119","0","101015","2014-04-01","0","1","2014-04-02","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141654","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1745","57","0","767130","2014-04-01","0","0","2014-04-02","16","","8","","Leaf Healthcare, Inc. 045699-1-1 (1116AK/1113AI","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141637","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1746","57","0","767131","2014-04-01","0","0","2014-04-02","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141637","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1747","97","0","4792294","2014-04-01","1","0","2014-04-02","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141626","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1748","76","0","173029","2014-04-01","0","0","2014-04-09","12","","1","","Piranha EMS, Inc Moog 7200-1077-01 rev a 6330-1077-01","2","2014-04-09 06:43:36","4898","5","Z1","2","2014-04-09 10:34:58","2","2014-04-09 11:10:35","2","2014-04-09 11:29:30","2","141789","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1749","97","0","4792295","2014-04-01","0","0","2014-04-02","12","","1","","Surface Art INTEL(CANADA) FMI_FEM FAB1 / SA J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1750","2","0","5346858","2014-04-01","0","0","2014-04-02","12","","1","","Sanmina Alcatel 82-0679-03 Rev 1 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141636","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1751","2","0","5346859","2014-04-01","0","1","2014-04-02","12","","1","","Sanmina synopsys SH10038-01 Rev-0.0","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141642","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1752","6","0","739357","2014-04-01","1","1","2014-04-02","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141641","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1753","35","0","800206","2014-04-01","0","0","2014-04-02","12","","1","","Creation Tech. SNJ Exalt Fab","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141635","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1754","1","0","8292550","2014-04-01","0","0","2014-04-02","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141631","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1755","97","0","4792296","2014-04-01","0","0","2014-04-02","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141634","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1758","2","0","5346856002","2014-04-01","0","0","2014-04-02","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141632","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1759","2","0","5346857003","2014-04-01","0","0","2014-04-02","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141632","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1760","97","0","4792297","2014-04-01","1","0","2014-04-02","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141625","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1761","72","0","1262717","2014-04-01","0","1","2014-04-02","15","","2","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141713","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1762","59","0","343307","2014-04-01","1","0","2014-04-02","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141620","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1763","51","0","9931385","2014-04-01","0","0","2014-04-02","15","","1","","Javad 05-587303-01 Rev 1.1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1764","50","0","630332","2014-04-01","0","0","2014-04-02","15","","1","","Cisco ETS-1401005 45mm Coreless 5 Mils Thick","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1765","4","0","321793","2014-04-01","0","0","2014-04-02","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1766","22","0","3474272","2014-04-01","0","0","2014-04-02","17","","8","","Axiom Electronics Boeing Sys Test Control 901767036 STP000856","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141644","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1767","22","0","3474273","2014-04-01","0","0","2014-04-02","17","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141644","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1768","9","0","2814022","2014-04-01","1","1","2014-04-09","14","","1","","","2","2014-04-09 12:07:05","167","4","Z2","2","2014-04-09 12:39:01","2","2014-04-09 14:38:30","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1769","22","0","3474274","2014-04-01","0","0","2014-04-02","17","","8","","Axiom Electronics Boeing HP Interface C","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141646","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1770","22","0","3474275","2014-04-01","0","0","2014-04-02","17","","8","","Axiom Electronics Boeing HP Interface C","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141646","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1771","2","0","5346862","2014-04-01","0","0","2014-04-02","17","","1","","Sanmina Alcatel 82-0594-02 Rev 1 APERTURE COUNT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141652","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1772","97","0","4792298","2014-04-01","0","0","2014-04-02","15","","1","","Surface Art Oculus VR J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141629","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1773","9","0","2814023","2014-04-01","0","0","2014-04-02","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1774","1","0","8292551","2014-04-01","1","0","2014-04-04","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141675","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1775","1","0","8292552","2014-04-01","0","0","2014-04-02","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141639","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1777","72","0","1262718","2014-04-01","1","0","2014-04-02","11","","1","","Pactron Incorporated PAC2988_01April2014_ WO24741_T","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141630","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1776","97","0","4792299","2014-04-01","0","0","2014-04-02","18","","1","","Surface Art Fusion Software BHEH DEV REV2 J","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141638","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1778","72","0","1262719","2014-04-02","0","0","2014-04-04","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141653","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1779","31","0","7582250","2014-04-02","0","0","2014-04-03","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141683","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1780","31","0","7582251","2014-04-02","0","0","2014-04-03","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141683","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1781","31","0","7582249","2014-04-02","0","0","2014-04-03","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141643","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1782","31","0","7582252","2014-04-02","0","0","2014-04-03","16","","8","","Controltek  890-1566-0 180-2112-A TOP","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141672","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1785","89","0","973463","2014-04-02","0","0","2014-04-03","10","","1","","","1","2014-04-02 17:06:23","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1783","31","0","7582253","2014-04-02","0","0","2014-04-03","16","","8","","Controltek  890-1123-1 REV B1 180-1850-B1 TOP BOT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141674","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1784","31","0","7582254","2014-04-02","0","0","2014-04-03","16","","1","","Controltek  890-1123-1 REV B1 180-1850-B1 TOP BOT","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141674","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1786","3","0","5632153","2014-04-02","1","0","2014-04-02","19.3","","5","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141650","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1787","6","0","739358","2014-04-02","0","0","2014-04-03","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141655","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1788","5","0","4894497","2014-04-02","0","0","2014-04-03","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141670","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1789","5","0","4894498","2014-04-02","0","0","2014-04-03","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141670","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1790","29","0","919104","2014-04-02","0","0","2014-04-03","11","","1","","CBA Electronics Corp Perceptimed  Charger / Detector V3.0 Combo-ECB 140305","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1791","54","0","914611","2014-04-02","0","0","2014-04-03","12","","1","","Marvell Marvell Semiconductor 01_MV6_6042_F1_A1","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1792","34","0","7994756","2014-04-02","0","0","2014-04-04","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1793","34","0","7994757","2014-04-02","0","0","2014-04-03","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141673","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1794","70","0","1105123","2014-04-02","0","0","2014-04-03","13","","1","","","2","2014-04-03 09:48:18","","","","2","2014-04-03 13:34:53","2","2014-04-03 16:10:00","2","2014-04-08 08:05:37","2","141755","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1795","2","0","5346863","2014-04-02","0","0","2014-04-03","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141657","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1796","2","0","5346864","2014-04-02","0","0","2014-04-03","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141658","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1797","93","0","2532130","2014-04-02","0","0","2014-04-03","14","","1","","SMTC Anr 3-76230-4 REV.B","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1798","93","0","2532131","2014-04-02","0","0","2014-04-03","14","","1","","SMTC Anr 3-76230-4 REV.B","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1799","20","0","938672","2014-04-02","0","0","2014-04-03","16","","15","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1800","9","0","2814024","2014-04-02","0","0","2014-04-03","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1801","20","0","938673","2014-04-02","0","0","2014-04-03","16","","15","","Ascentron Perpetua 1401001B00xA P/N 790-2518","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141669","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1802","10","0","2392965","2014-04-02","0","0","2014-04-04","15","","1","","","2","2014-04-03 12:53:31","","","","2","2014-04-04 15:48:05","2","2014-04-04 22:16:44","2","2014-04-07 09:38:12","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1803","20","0","938674","2014-04-02","0","0","2014-04-03","16","","15","","Ascentron Rosen 102103 P/N 790-2519","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141671","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1804","4","0","321794","2014-04-02","0","0","2014-04-03","15","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1805","72","0","1262720","2014-04-02","0","0","2014-04-03","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141667","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1806","72","0","1262721","2014-04-02","0","0","2014-04-03","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141667","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1807","97","0","4792300","2014-04-02","1","0","2014-04-08","17","","1","","","2","2014-04-08 14:08:32","2128","4","Z2","2","2014-04-08 15:55:11","2","2014-04-08 17:32:45","0","0000-00-00 00:00:00","2","141777","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1808","5","0","4894499","2014-04-02","0","0","2014-04-03","17","","1","","OnCore Manufacturing Christie Digital Systems  CHR-001-112125-02 REV 002 RoHS","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141670","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1809","5","0","4894500","2014-04-02","0","0","2014-04-03","17","","1","","OnCore Manufacturing Christie Digital Systems CHR-001-112125-02 REV 002 RoHS","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141668","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1810","4","0","321795","2014-04-02","0","0","2014-04-03","17","","1","","","2","2014-04-03 08:00:11","","","","2","2014-04-03 16:07:50","2","2014-04-03 16:37:31","2","2014-04-07 08:14:29","2","141722","2","0","2014-04-03 16:40:03","2","1");
INSERT INTO tbl_jobs VALUES("1811","22","0","34742490002","2014-04-02","0","0","2014-04-04","9","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141666","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1812","22","0","34742500002","2014-04-02","0","0","2014-04-04","9","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141666","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1813","41","0","832738","2014-04-02","0","0","2014-04-04","8","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141682","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1814","51","0","9931386","2014-04-03","0","0","2014-04-04","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1815","42","0","660028","2014-04-03","0","1","2014-04-04","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1816","19","0","835269","2014-04-03","0","0","2014-04-04","17","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1817","19","0","835270","2014-04-03","0","0","2014-04-04","17","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1818","19","0","835268","2014-04-03","0","0","2014-04-04","17","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1819","34","0","7994759","2014-04-03","0","0","2014-04-04","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141702","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1820","34","0","7994758","2014-04-03","0","0","2014-04-04","9","","1","","Creation Tech. Alcatel ALC76-0675-01 Rev. 01 TALCS234_LF","2","2014-04-04 08:59:49","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1821","9","0","2814025","2014-04-03","0","0","2014-04-04","11","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","2","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1822","7","0","9991802","2014-04-03","1","0","2014-04-03","17","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1823","7","0","9991803","2014-04-03","1","0","2014-04-03","17","","1","","","1","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1824","7","0","9991806","2014-04-03","0","0","2014-04-09","17","","1","","SEM HE Intel Corp.  ITTO-580-0055:0","2","2014-04-08 10:28:58","1648","8","Foil Only","2","2014-04-09 10:47:28","2","2014-04-09 11:05:44","2","2014-04-09 12:47:15","2","141774","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1825","7","0","9991807","2014-04-03","0","0","2014-04-09","17","","1","","","2","2014-04-08 10:29:53","3460","8","Foil Only","2","2014-04-09 12:15:37","2","2014-04-09 12:21:29","2","2014-04-09 12:47:21","2","141774","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1826","7","0","9991804","2014-04-03","0","0","2014-04-07","17","","1","","","2","2014-04-07 10:06:06","487","6","Z1","2","2014-04-07 11:00:32","2","2014-04-07 11:35:44","2","2014-04-07 13:31:43","2","141732","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1827","7","0","9991805","2014-04-03","0","0","2014-04-07","17","","1","","","2","2014-04-07 10:06:24","1750","6","Z1","2","2014-04-07 11:25:01","2","2014-04-07 11:38:48","2","2014-04-07 13:31:52","2","141732","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1828","34","0","7994760","2014-04-03","0","0","2014-04-04","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141701","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1829","84","0","2220780003","2014-04-03","0","0","2014-04-04","10","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1830","100","0","140196","2014-04-03","0","0","2014-04-04","16","","15","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1831","7","0","9991808","2014-04-03","0","0","2014-04-08","17","","1","","","2","2014-04-08 10:31:27","2073","6","Foil Only","2","2014-04-08 13:48:33","2","2014-04-08 13:55:31","0","0000-00-00 00:00:00","2","141772","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1832","7","0","9991809","2014-04-03","0","0","2014-04-04","17","","1","","","1","2014-04-04 18:28:29","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1833","31","0","7582255","2014-04-03","0","0","2014-04-04","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141693","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1834","31","0","7582256","2014-04-03","0","0","2014-04-04","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141693","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1835","93","0","2532132","2014-04-03","0","0","2014-04-04","14","","1","","","2","2014-04-04 15:41:59","","","","2","2014-04-04 16:23:53","2","2014-04-04 22:02:54","2","2014-04-07 08:13:17","2","141719","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1842","62","0","538806002","2014-04-03","0","0","2014-04-04","6","","4","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1836","59","0","343308","2014-04-03","1","0","2014-04-04","9","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141685","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1837","31","0","7582257","2014-04-03","0","0","2014-04-04","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141706","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1838","31","0","7582258","2014-04-03","0","0","2014-04-04","16","","8","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","141704","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1839","2","0","5346865","2014-04-03","0","1","2014-04-07","15","","1","","","2","2014-04-04 09:36:44","","","","2","2014-04-04 17:43:35","2","2014-04-04 22:23:07","2","2014-04-07 08:14:10","2","141721","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1840","2","0","5346866","2014-04-03","0","0","2014-04-04","15","","1","","","2","2014-04-04 09:34:28","","","","2","2014-04-04 11:18:33","2","2014-04-04 13:46:46","2","2014-04-07 08:13:00","2","141700","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1841","97","0","4792301","2014-04-03","0","0","2014-04-21","16","","1","","Do not cut!  Just design and send for approval","2","2014-04-21 12:47:29","2018","5","18X18","2","2014-04-21 15:24:37","2","2014-04-21 18:45:51","0","0000-00-00 00:00:00","2","142040","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1843","2","0","5346867","2014-04-03","0","1","2014-04-04","17","","1","","","2","2014-04-04 09:01:07","","","","2","2014-04-04 17:07:18","2","2014-04-04 22:01:22","2","2014-04-07 08:14:20","2","141720","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1844","11","0","102083","2014-04-03","0","0","2014-04-04","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1845","11","0","102084","2014-04-03","0","0","2014-04-04","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1846","11","0","102085","2014-04-03","1","0","2014-04-04","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1847","11","0","102086","2014-04-03","1","0","2014-04-04","14","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1848","119","0","1010150002","2014-04-03","0","0","2014-04-04","14","","1","","","2","2014-04-03 18:43:39","","","","2","2014-04-04 10:22:35","2","2014-04-04 18:32:07","2","2014-04-07 08:12:07","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1849","1","0","8292553","2014-04-03","0","0","2014-04-04","17","","1","","","2","2014-04-04 08:58:10","","","","2","2014-04-04 16:36:01","2","2014-04-04 18:14:30","0","0000-00-00 00:00:00","2","141703","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1850","4","0","321796","2014-04-03","1","0","2014-04-04","16","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1851","8","0","575372","2014-04-03","0","1","2014-04-07","8","","1","","","2","2014-04-07 14:10:28","1782","5","Z2","2","2014-04-07 18:40:50","2","2014-04-07 20:12:36","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1852","8","0","575373","2014-04-03","0","0","2014-04-07","8","","1","","","2","2014-04-07 14:10:44","1018","5","Z2","2","2014-04-07 18:50:24","2","2014-04-07 20:45:18","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1853","2","0","5346868","2014-04-03","0","0","2014-04-07","8","","1","","","2","2014-04-04 09:38:07","","","","2","2014-04-04 17:50:12","2","2014-04-04 22:04:01","2","2014-04-07 08:12:36","2","141704","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1854","2","0","5346869","2014-04-03","0","0","2014-04-07","8","","1","","","2","2014-04-04 09:37:22","","","","2","2014-04-04 16:28:01","2","2014-04-04 22:05:48","2","2014-04-07 08:12:45","2","141704","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1855","6","0","739359","2014-04-03","0","0","2014-04-07","8","","1","","","2","2014-04-07 14:33:39","","","","2","2014-04-07 18:19:11","2","2014-04-08 10:02:46","2","2014-04-08 11:32:57","2","141764","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1856","72","0","1262723","2014-04-04","1","0","2014-04-04","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141694","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1857","72","0","1262724","2014-04-04","1","0","2014-04-04","12","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","141695","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1858","43","0","5413957","2014-04-04","0","0","2014-04-07","8","","1","","","2","2014-04-04 12:50:55","","","","2","2014-04-04 15:42:55","2","2014-04-04 21:02:39","2","2014-04-07 08:12:15","2","141709","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1859","43","0","5413956","2014-04-04","0","0","2014-04-07","8","","1","","","2","2014-04-04 12:50:16","","","","2","2014-04-04 16:42:25","2","2014-04-04 21:13:02","2","2014-04-07 08:12:25","2","141708","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1860","22","0","3474278","2014-04-04","1","0","2014-04-21","16","","4","","Axiom Electronics Cloud Cap 905000382 STB000336","2","2014-04-21 11:28:45","3988","4","Foil Only","2","2014-04-21 16:23:42","2","2014-04-21 16:47:18","0","0000-00-00 00:00:00","2","142035","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1861","93","0","2532121005","2014-04-04","1","0","2014-04-04","13","","1","","","2","0000-00-00 00:00:00","","","","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","2","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1862","11","0","102087","2014-04-04","0","0","2014-04-07","11","","1","","","2","2014-04-10 19:11:46","349","5","Z2","2","2014-04-10 21:04:14","2","2014-04-10 22:29:08","2","2014-04-11 07:38:57","2","141844","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1863","11","0","102088","2014-04-04","0","0","2014-04-07","11","","1","","","2","2014-04-10 19:12:01","481","5","Z2","2","2014-04-10 21:22:48","2","2014-04-10 22:29:15","2","2014-04-11 07:39:04","2","141844","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1864","25","0","966267","2014-04-04","0","0","2014-04-07","18","","15","","","2","2014-04-07 08:30:53","","","","2","2014-04-07 18:19:25","2","2014-04-08 11:52:44","0","0000-00-00 00:00:00","2","141724","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1865","70","0","1105124","2014-04-04","0","0","2014-04-07","12","","1","","","2","2014-04-07 10:10:13","861","5","Z2","2","2014-04-07 11:53:11","2","2014-04-07 13:52:11","2","2014-04-08 08:05:45","2","141756","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1866","34","0","7994761","2014-04-04","0","0","2014-04-07","12","","1","","","2","2014-04-07 08:06:40","354","5","Z2","2","2014-04-07 13:54:01","2","2014-04-07 19:51:52","0","0000-00-00 00:00:00","2","141745","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1867","57","0","767132","2014-04-04","0","0","2014-04-07","16","","8","","","2","2014-04-07 08:30:32","1509","4","Foil Only","2","2014-04-07 10:12:06","2","2014-04-07 11:57:40","0","0000-00-00 00:00:00","2","141730","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1868","11","0","102089","2014-04-04","0","0","2014-04-07","13","","1","","Zollner Electronics Sandisk Vogon III","2","2014-04-07 11:40:21","630","5","Z2","2","2014-04-07 12:50:22","2","2014-04-07 15:22:30","0","0000-00-00 00:00:00","2","141711","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1869","8","0","575376","2014-04-04","0","0","2014-04-07","18","","1","","","2","2014-04-07 10:09:36","2166","5","Z2","2","2014-04-07 15:54:55","2","2014-04-07 19:17:15","0","0000-00-00 00:00:00","0","","2","1","2014-04-07 21:01:02","2","1");
INSERT INTO tbl_jobs VALUES("1870","120","0","164001","2014-04-04","0","0","2014-04-07","18","","15","","","2","2014-04-07 15:31:27","8449","5","Z2","2","2014-04-07 21:03:18","2","2014-04-07 22:01:31","0","0000-00-00 00:00:00","2","141760","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1871","120","0","164002","2014-04-04","0","0","2014-04-07","18","","15","","","2","2014-04-07 15:31:43","3241","5","Z2","2","2014-04-07 20:21:51","2","2014-04-07 22:01:43","0","0000-00-00 00:00:00","2","141760","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1872","10","0","2392967","2014-04-04","1","1","2014-04-11","10.3","","1","","","2","2014-04-11 09:39:10","1943","5","Z3","2","2014-04-11 10:22:46","2","2014-04-11 13:00:13","2","2014-04-11 13:10:20","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1873","10","0","2392968","2014-04-04","1","1","2014-04-11","12","","1","","","2","2014-04-11 09:39:24","841","5","Z3","2","2014-04-11 10:14:19","2","2014-04-11 13:00:19","2","2014-04-11 13:10:31","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1874","59","0","343309","2014-04-04","1","0","2014-04-07","9","","1","","","2","2014-04-04 16:20:42","","","","2","2014-04-04 18:44:13","2","2014-04-04 21:47:14","2","2014-04-07 07:38:40","2","141714","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1875","5","0","4894501","2014-04-04","0","0","2014-04-07","15","","1","","","2","2014-04-07 12:37:01","858","5","Z2","2","2014-04-07 14:04:34","2","2014-04-07 16:04:30","0","0000-00-00 00:00:00","2","141750","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1876","5","0","4894502","2014-04-04","0","0","2014-04-07","15","","1","","","2","2014-04-07 12:37:26","330","7","Z2","2","2014-04-07 14:16:41","2","2014-04-07 16:04:48","0","0000-00-00 00:00:00","2","141750","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1877","5","0","4894503","2014-04-04","0","0","2014-04-07","15","","1","","","2","2014-04-07 14:58:07","1937","5","Z2","2","2014-04-07 17:02:48","2","2014-04-07 19:26:58","0","0000-00-00 00:00:00","2","141751","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1878","5","0","4894504","2014-04-04","0","0","2014-04-07","15","","1","","","2","2014-04-07 14:58:25","911","7","Z2","2","2014-04-07 17:05:16","2","2014-04-07 19:27:06","0","0000-00-00 00:00:00","2","141751","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1879","93","0","2532134","2014-04-04","0","0","2014-04-10","17","","1","","","2","2014-04-10 14:38:13","1282","5","Z2","2","2014-04-10 16:20:10","2","2014-04-10 18:26:39","0","0000-00-00 00:00:00","2","141841","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1880","93","0","2532135","2014-04-04","0","0","2014-04-10","17","","1","","","2","2014-04-10 14:38:29","789","5","Z2","2","2014-04-10 16:23:57","2","2014-04-10 18:26:50","0","0000-00-00 00:00:00","2","141841","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1881","89","0","973464","2014-04-04","1","1","2014-04-07","16","","1","","","2","2014-04-07 10:30:07","1344","8","Z1","2","2014-04-07 11:20:06","2","2014-04-07 11:31:19","0","0000-00-00 00:00:00","2","141734","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1882","8","0","575377","2014-04-06","0","1","2014-04-09","18","","1","","","2","2014-04-09 12:23:58","13345","5","Z2","2","2014-04-09 19:43:02","2","2014-04-09 21:19:09","2","2014-04-10 10:45:25","0","","2","5","2014-04-10 10:37:36","2","1");
INSERT INTO tbl_jobs VALUES("1883","8","0","575378","2014-04-06","0","1","2014-04-09","18","","1","","","2","2014-04-09 12:24:17","7879","4","Z2","2","2014-04-09 19:13:34","2","2014-04-09 21:18:38","2","2014-04-10 10:45:36","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1884","34","0","7994762","2014-04-06","0","0","2014-04-07","17","","1","","","2","2014-04-07 11:39:42","3294","5","Z2","2","2014-04-07 13:34:58","2","2014-04-07 19:52:02","0","0000-00-00 00:00:00","2","141738","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1885","34","0","7994763","2014-04-06","0","0","2014-04-07","17","","1","","","2","2014-04-07 11:39:25","1513","5","Z2","2","2014-04-07 12:55:57","2","2014-04-07 19:52:10","0","0000-00-00 00:00:00","2","141738","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1886","50","0","630333","2014-04-06","0","0","2014-04-07","17","","1","","","2","2014-04-07 14:57:42","905","4","Z2","2","2014-04-07 17:19:02","2","2014-04-07 20:20:04","2","2014-04-08 08:04:53","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1887","72","0","1262725","2014-04-06","1","0","2014-04-07","10","","1","","","2","2014-04-07 04:41:29","2558","4","Z2","2","2014-04-07 09:55:44","2","2014-04-07 11:43:35","2","2014-04-07 11:43:45","2","141727","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1888","95","0","252624","2014-04-06","0","0","2014-04-07","18","","1","","","2","2014-04-07 10:31:08","3326","6","18X19","2","2014-04-07 14:22:22","2","2014-04-07 19:47:08","2","2014-04-08 08:06:04","2","141737","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1889","110","0","952387","2014-04-07","0","0","2014-04-08","17","","15","","","2","2014-04-07 12:38:35","320","6","18X18","2","2014-04-07 14:38:56","2","2014-04-07 16:05:08","0","0000-00-00 00:00:00","2","141749","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1890","97","0","4792302","2014-04-07","0","0","2014-04-07","18","","1","","","2","2014-04-07 13:33:02","940","5","Z2","2","2014-04-07 16:02:01","2","2014-04-07 17:11:57","0","0000-00-00 00:00:00","2","141746","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1891","72","0","1262726","2014-04-07","0","0","2014-04-07","18","","1","","","2","2014-04-07 07:59:11","871","4","Z2","2","2014-04-07 09:48:48","2","2014-04-07 11:47:42","2","2014-04-07 11:54:08","2","141729","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1892","72","0","1262727","2014-04-07","0","0","2014-04-07","18","","1","","","2","2014-04-07 08:00:08","2025","4","Z2","2","2014-04-07 09:42:41","2","2014-04-07 11:53:52","2","2014-04-07 11:54:02","2","141729","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1893","72","0","1262728","2014-04-07","0","0","2014-04-07","18","","1","","","2","2014-04-07 08:01:12","1751","4","Z2","2","2014-04-07 10:22:32","2","2014-04-07 11:50:50","2","2014-04-07 11:54:15","2","141728","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1894","7","0","9991816","2014-04-07","0","0","2014-04-17","10","","1","","SEM HE Form Factor Inc. 200-1991(TTF0582A):1","2","2014-04-16 13:16:03","273","8","Z1","2","2014-04-16 20:05:02","2","2014-04-16 20:08:55","2","2014-04-17 07:51:26","2","141973","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1895","7","0","9991817","2014-04-07","0","0","2014-04-08","17","","1","","","1","2014-04-08 12:11:02","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1896","7","0","9991810","2014-04-07","0","0","2014-04-08","17","","1","","SEM HE Feinmetall GmbH 8VBJ750B-041 C13578:A","1","2014-04-08 09:30:40","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1897","7","0","9991811","2014-04-07","0","0","2014-04-08","17","","1","","","1","2014-04-08 09:30:47","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1898","7","0","9991812","2014-04-07","0","0","2014-04-16","17","","1","","SEM HE Form Factor Inc. 200-1131(TTF0490A):2","2","2014-04-16 14:23:14","330","8","Z1","2","2014-04-16 18:39:56","2","2014-04-16 19:39:41","2","2014-04-17 07:49:35","2","141971","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1899","7","0","9991813","2014-04-07","0","0","2014-04-08","17","","1","","","1","2014-04-08 10:23:11","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1900","7","0","9991814","2014-04-07","0","0","2014-04-17","10","","1","","SEM HE Form Factor Inc. 200-1335(TTF0516A):1 Apt count =","2","2014-04-16 13:16:32","142","8","Z1","2","2014-04-16 20:24:53","2","2014-04-16 20:42:18","2","2014-04-17 07:51:16","2","141972","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1901","7","0","9991815","2014-04-07","0","0","2014-04-08","17","","1","","","1","2014-04-08 11:55:12","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1902","22","0","3474279","2014-04-07","1","0","2014-04-10","16","","4","","","2","2014-04-10 09:37:35","391","6","Foil Only","2","2014-04-10 14:50:46","2","2014-04-10 16:19:53","0","0000-00-00 00:00:00","2","141834","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1903","7","0","99917390001","2014-04-07","1","0","2014-04-07","12","","1","","","2","2014-04-07 09:40:18","3","8","Foil Only","2","2014-04-07 10:38:26","2","2014-04-07 10:44:02","2","2014-04-07 10:49:19","2","141726","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1904","31","0","7582259","2014-04-07","0","0","2014-04-08","16","","8","","Controltek  825-2282-0 180-2066-A","2","2014-04-07 21:25:47","80","4","18X18","2","2014-04-08 08:11:02","2","2014-04-08 08:37:59","0","0000-00-00 00:00:00","2","141761","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1905","97","0","4792303","2014-04-07","1","0","2014-04-08","10","","1","","","2","2014-04-08 08:29:05","837 EP","5","18X18","2","2014-04-08 10:22:26","2","2014-04-08 12:56:44","2","2014-04-08 12:57:07","2","141765","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1906","54","0","914612","2014-04-07","1","0","2014-04-07","16","","1","","","2","2014-04-07 11:38:25","1408","5","Foil Only","2","2014-04-07 12:08:46","2","2014-04-07 12:16:46","0","0000-00-00 00:00:00","2","141736","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1907","54","0","914613","2014-04-07","0","0","2014-04-08","11","","1","","AltaPlus 200654","2","2014-04-07 17:56:12","592","4","Foil Only","2","2014-04-07 19:54:55","2","2014-04-07 20:00:59","2","2014-04-08 08:05:10","2","141754","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1908","54","0","914614","2014-04-07","0","0","2014-04-08","11","","1","","Dean 200652","2","2014-04-07 17:56:29","3271","4","Foil Only","2","2014-04-07 19:34:58","2","2014-04-07 19:57:29","2","2014-04-08 08:05:02","2","141753","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1909","97","0","4792304","2014-04-07","0","0","2014-04-08","11","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1910","97","0","4792305","2014-04-07","0","0","2014-04-08","11","","1","","","2","2014-04-08 08:20:51","2190","4","18X18","2","2014-04-08 10:33:07","2","2014-04-08 12:56:51","2","2014-04-08 12:57:14","2","141766","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1911","1","0","8292554","2014-04-07","0","0","2014-04-08","11","","1","","","2","2014-04-07 17:54:21","864","4","Z2","2","2014-04-07 19:03:12","2","2014-04-07 20:19:35","2","2014-04-08 08:05:25","2","141752","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1912","8","0","5753720003","2014-04-07","0","0","2014-04-08","11","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1913","70","0","1105125","2014-04-07","0","0","2014-04-08","17","","1","","","2","2014-04-08 13:40:48","1984","4","Z2","2","2014-04-08 16:26:05","2","2014-04-08 17:55:49","0","0000-00-00 00:00:00","2","141778","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1914","70","0","1105126","2014-04-07","0","0","2014-04-08","17","","1","","","2","2014-04-08 13:41:41","694","4","Z2","2","2014-04-08 15:29:20","2","2014-04-08 17:55:58","0","0000-00-00 00:00:00","2","141778","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1915","7","0","99918000002","2014-04-07","0","0","2014-04-08","17","","1","","","2","2014-04-08 10:25:20","3239","6","Z2","2","2014-04-08 13:17:52","2","2014-04-08 14:47:32","0","0000-00-00 00:00:00","2","141771","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1916","7","0","99918010002","2014-04-07","0","0","2014-04-08","17","","1","","","2","2014-04-08 10:26:24","7415","8","Z2","2","2014-04-08 15:57:28","2","2014-04-08 17:14:06","0","0000-00-00 00:00:00","2","141773","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1917","31","0","7582260","2014-04-07","0","0","2014-04-09","16","","8","","","2","2014-04-09 10:56:36","1262","4","18X18","2","2014-04-09 13:55:33","2","2014-04-09 16:45:27","0","0000-00-00 00:00:00","2","141807","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1918","31","0","7582261","2014-04-07","0","0","2014-04-09","16","","8","","","2","2014-04-09 10:56:53","1742","4","18X18","2","2014-04-09 14:43:40","2","2014-04-09 16:45:41","0","0000-00-00 00:00:00","2","141807","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1919","97","0","4792306","2014-04-07","1","0","2014-04-08","17","","1","","","2","2014-04-08 12:50:33","3145","5","18X18","2","2014-04-08 14:14:56","2","2014-04-08 14:46:50","0","0000-00-00 00:00:00","2","141779","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1920","8","0","575379","2014-04-07","0","0","2014-04-08","14","","1","","","2","2014-04-08 08:28:07","","5","","2","2014-04-08 09:16:15","2","2014-04-08 12:50:26","0","0000-00-00 00:00:00","2","141784","2","2","2014-04-08 12:51:51","2","1");
INSERT INTO tbl_jobs VALUES("1921","8","0","575380","2014-04-07","0","0","2014-04-09","13","","1","","","2","2014-04-08 09:18:26","1594","5","Z3","2","2014-04-08 12:38:53","2","2014-04-08 14:11:39","2","2014-04-09 12:45:50","2","141800","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1922","34","0","7994764","2014-04-07","0","0","2014-04-08","15","","1","","","2","2014-04-08 08:30:08","4819 LF EP","5","Z2","2","2014-04-08 10:53:11","2","2014-04-08 12:42:39","2","2014-04-08 15:48:05","2","141768","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1923","11","0","102090","2014-04-07","1","0","2014-04-09","12","","1","","","2","2014-04-08 09:15:07","","","","2","2014-04-08 09:16:05","2","2014-04-09 10:22:47","2","2014-04-09 10:33:54","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1924","43","0","5413958","2014-04-07","0","1","2014-04-08","16","","1","","Infiniti Solutions Xepto XEPTO-TC Rev C_Top Job","2","2014-04-08 15:52:24","3633","4","Z2","2","2014-04-08 18:09:20","2","2014-04-08 19:49:06","2","2014-04-09 07:39:47","2","141787","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1925","43","0","5413959","2014-04-07","0","1","2014-04-08","16","","1","","","2","2014-04-08 15:51:56","1761","4","Z2","2","2014-04-08 17:24:34","2","2014-04-08 19:49:13","2","2014-04-09 07:39:58","2","141787","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1926","4","0","321799","2014-04-07","0","0","2014-04-08","17","","1","","","2","2014-04-08 08:31:42","604 LF","5","Z2","2","2014-04-08 10:17:30","2","2014-04-08 12:43:23","2","2014-04-08 12:48:17","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1927","4","0","321798","2014-04-07","0","0","2014-04-08","17","","1","","","2","2014-04-08 08:31:02","560 LF","5","Z2","2","2014-04-08 10:27:16","2","2014-04-08 12:25:05","2","2014-04-08 12:48:11","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1928","4","0","321797","2014-04-07","0","0","2014-04-08","17","","1","","","2","2014-04-07 21:34:00","488 LF","5","Z2","2","2014-04-08 10:17:36","2","2014-04-08 12:42:52","2","2014-04-08 12:48:05","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1929","8","0","575381","2014-04-07","1","0","2014-04-08","13","","1","","","2","2014-04-08 09:19:11","6394","5","Z2","2","2014-04-08 13:06:22","2","2014-04-08 13:53:19","2","2014-04-09 12:45:56","2","141799","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1930","8","0","575382","2014-04-07","1","0","2014-04-08","13","","1","","","2","2014-04-08 09:19:33","2406","5","Z2","2","2014-04-08 12:55:36","2","2014-04-08 13:53:30","2","2014-04-09 12:46:01","2","141799","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1931","4","0","321800","2014-04-07","0","1","2014-04-09","18","","1","","","2","2014-04-08 13:00:24","2162","5","Z2","2","2014-04-08 19:51:34","2","2014-04-08 20:42:02","2","2014-04-09 07:40:28","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1932","42","0","660029","2014-04-07","1","1","2014-04-08","18","","1","","","2","2014-04-08 08:03:05","","","","2","2014-04-08 09:15:47","2","2014-04-08 12:22:36","0","0000-00-00 00:00:00","2","141911","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1933","8","0","575383","2014-04-08","0","0","2014-04-09","13","","1","","","2","2014-04-08 19:15:46","1489","5","Z2","2","2014-04-09 11:03:29","2","2014-04-09 12:05:28","2","2014-04-09 12:46:12","2","141798","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1934","8","0","575384","2014-04-08","0","0","2014-04-09","13","","1","","","2","2014-04-08 19:16:35","1965","5","Z2","2","2014-04-09 10:41:23","2","2014-04-09 12:05:36","2","2014-04-09 12:46:18","2","141798","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1935","7","0","999","2014-04-08","0","0","2014-04-08","6","","2","","TEST","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1936","72","0","1262729","2014-04-08","0","0","2014-04-08","18","","1","","","2","2014-04-08 07:19:22","2548","4","Z2","2","2014-04-08 13:26:04","2","2014-04-08 14:34:20","2","2014-04-08 15:51:37","2","141775","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1937","1","0","8292555","2014-04-08","0","0","2014-04-09","9","","1","","","2","2014-04-08 11:42:40","107","4","Z2","2","2014-04-09 10:29:22","2","2014-04-09 10:29:32","0","0000-00-00 00:00:00","2","141770","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1938","22","0","3474280","2014-04-08","1","0","2014-04-09","16","","4","","Axiom Electronics BMS BMTII Schiebel 905000306 STB000785R02","2","2014-04-09 15:33:40","1712","5","Foil Only","2","2014-04-09 18:14:45","2","2014-04-09 18:14:52","0","0000-00-00 00:00:00","2","141819","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1939","100","0","140197","2014-04-08","0","0","2014-04-09","16","","15","","","2","2014-04-09 08:25:02","66","6","18X18","2","2014-04-09 14:05:00","2","2014-04-09 16:46:48","0","0000-00-00 00:00:00","2","141805","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1940","31","0","7582262","2014-04-08","0","0","2014-04-09","16","","8","","","2","2014-04-09 05:19:38","502","4","18X18","2","2014-04-09 13:21:15","2","2014-04-09 16:45:53","0","0000-00-00 00:00:00","2","141816","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1941","7","0","99917600002","2014-04-08","1","0","2014-04-08","15","","1","","","2","2014-04-08 11:16:47","138","8","Foil Only","2","2014-04-08 12:40:43","2","2014-04-08 12:47:26","2","2014-04-08 12:48:31","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1942","100","0","140198","2014-04-08","0","0","2014-04-09","16","","15","","","2","2014-04-09 11:12:36","672","6","18X18","2","2014-04-09 15:09:58","2","2014-04-09 16:46:03","0","0000-00-00 00:00:00","2","141804","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1943","7","0","99917670002","2014-04-08","1","0","2014-04-08","13","","1","","","2","2014-04-08 11:16:19","1239","10","Z1","2","2014-04-08 12:09:04","2","2014-04-08 12:24:46","2","2014-04-08 12:48:25","2","141769","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1944","54","0","914615","2014-04-08","0","0","2014-04-14","15","","1","","Marvell Semiconductor Project AltaPlus 200641-01 Rev 1","2","2014-04-14 09:24:25","9656","4","18X18","2","2014-04-14 13:32:51","2","2014-04-14 14:45:07","2","2014-04-14 15:52:42","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1945","76","0","173030","2014-04-08","0","0","2014-04-09","12","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1946","88","0","6092046","2014-04-08","0","1","2014-04-11","16","","11","","","2","2014-04-10 14:37:26","6264","4","Z2","2","2014-04-10 20:16:04","2","2014-04-10 21:09:19","0","0000-00-00 00:00:00","2","141860","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1947","27","0","872207","2014-04-08","0","0","2014-04-10","15","","1","","","2","2014-04-10 12:15:55","265","6","Foil Only","2","2014-04-10 14:18:51","2","2014-04-10 14:21:34","0","0000-00-00 00:00:00","2","141832","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1948","104","0","559705","2014-04-08","0","0","2014-04-09","16","","8","","","2","2014-04-09 06:45:30","167","5","","2","2014-04-09 14:15:30","2","2014-04-09 15:19:13","0","0000-00-00 00:00:00","2","141814","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1949","29","0","919105","2014-04-08","0","0","2014-04-09","14","","1","","","2","2014-04-09 05:39:44","1134","5","Foil Only","2","2014-04-09 11:37:57","2","2014-04-09 11:50:44","2","2014-04-09 13:28:22","2","141803","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1950","97","0","4792307","2014-04-08","1","0","2014-04-08","18","","1","","Surface Art Pelco J","2","2014-04-08 17:31:06","3046","4","18X18","2","2014-04-08 18:41:07","2","2014-04-08 20:08:31","2","2014-04-09 07:40:17","2","141785","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1951","2","0","5346870","2014-04-08","0","0","2014-04-09","15","","1","","Sanmina Invensense Spider Combo box Rev 2","2","2014-04-09 05:17:39","8370","5","Z2","2","2014-04-09 12:46:27","2","2014-04-09 14:37:53","0","0000-00-00 00:00:00","2","141802","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1952","2","0","5346871","2014-04-08","0","0","2014-04-09","15","","1","","Sanmina Invensense Spider Combo box Rev 2","2","2014-04-09 05:18:27","2652","5","Z2","2","2014-04-09 11:42:53","2","2014-04-09 13:23:44","0","0000-00-00 00:00:00","2","141802","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1953","31","0","7582263","2014-04-08","0","0","2014-04-09","16","","8","","","2","2014-04-09 05:20:24","1796","4","18X18","2","2014-04-09 13:34:25","2","2014-04-09 16:46:23","0","0000-00-00 00:00:00","2","141812","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1954","31","0","7582264","2014-04-08","0","0","2014-04-09","16","","8","","","2","2014-04-09 05:21:15","1160","4","18X18","2","2014-04-09 13:44:20","2","2014-04-09 16:46:13","0","0000-00-00 00:00:00","2","141812","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1955","97","0","4792308","2014-04-08","0","0","2014-04-09","15","","1","","","2","2014-04-09 05:11:59","","","","2","2014-04-09 15:27:26","2","2014-04-09 15:27:34","0","0000-00-00 00:00:00","2","141806","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1956","9","0","2814026","2014-04-08","0","0","2014-04-09","15","","1","","","2","2014-04-09 11:40:35","919","5","Z2","2","2014-04-09 15:36:48","2","2014-04-09 18:13:12","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1957","9","0","2814027","2014-04-08","0","0","2014-04-09","15","","1","","","2","2014-04-09 11:40:53","833","5","Z2","2","2014-04-09 15:29:32","2","2014-04-09 18:13:05","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1958","59","0","343310","2014-04-08","1","0","2014-04-09","9","","1","","","2","2014-04-08 18:51:37","1450","4","18X18","2","2014-04-08 19:45:58","2","2014-04-08 21:18:39","2","2014-04-09 09:20:57","2","141786","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1959","59","0","343311","2014-04-08","1","0","2014-04-09","9","","1","","","2","2014-04-08 17:43:06","883","5","Foil Only","2","2014-04-08 19:00:12","2","2014-04-08 19:17:54","2","2014-04-09 09:20:49","2","141786","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1960","8","0","575385","2014-04-08","0","0","2014-04-11","11","","1","","","2","2014-04-10 17:35:57","3976","5","Z2","2","2014-04-10 21:53:18","2","2014-04-10 22:28:31","2","2014-04-11 11:59:22","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1961","8","0","575386","2014-04-08","0","0","2014-04-11","11","","1","","","2","2014-04-10 17:36:10","728","5","Z2","2","2014-04-10 20:18:00","2","2014-04-10 22:28:41","2","2014-04-11 11:59:31","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1962","89","0","973465","2014-04-08","0","0","2014-04-11","16","","1","","","2","2014-04-11 10:28:23","955","6","Z1","2","2014-04-11 13:20:15","2","2014-04-11 13:27:14","0","0000-00-00 00:00:00","2","141866","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1963","10","0","2392969","2014-04-08","0","0","2014-04-09","17","","1","","","2","2014-04-09 05:10:02","1004 lf ep","5","Z2","2","2014-04-09 18:11:33","2","2014-04-09 18:12:48","0","0000-00-00 00:00:00","2","141790","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1964","10","0","2392970","2014-04-08","0","0","2014-04-10","8","","1","","","2","2014-04-09 05:10:37","582 lf ep","4","Z2","2","2014-04-09 18:11:52","2","2014-04-09 18:12:08","0","0000-00-00 00:00:00","2","141791","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1965","17","0","637617","2014-04-08","0","0","2014-04-11","17","","1","","","2","2014-04-09 03:54:11","1546","5","Foil Only","2","2014-04-09 20:06:42","2","2014-04-09 20:29:43","0","0000-00-00 00:00:00","2","141810","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1966","17","0","637618","2014-04-08","0","0","2014-04-11","17","","1","","","2","2014-04-09 03:53:45","45","5","Foil Only","2","2014-04-09 20:30:34","2","2014-04-09 20:54:29","0","0000-00-00 00:00:00","2","141810","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1967","97","0","4792309","2014-04-08","0","0","2014-04-09","18","","1","","","2","2014-04-09 05:11:36","910 lf ep","5","18X18","2","2014-04-09 15:21:09","2","2014-04-09 16:46:34","0","0000-00-00 00:00:00","2","141813","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1968","88","0","6092047","2014-04-08","0","1","2014-04-11","16","","11","","","2","2014-04-10 14:37:42","1850","4","Z2","2","2014-04-10 20:22:38","2","2014-04-10 22:28:20","0","0000-00-00 00:00:00","2","141860","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1969","34","0","79947470002","2014-04-09","0","0","2014-04-11","9","","1","","","2","2014-04-09 08:41:22","14061","6/5/4","Z2","2","2014-04-09 20:23:20","2","2014-04-09 21:34:58","2","2014-04-10 07:45:17","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1970","72","0","1262730","2014-04-09","0","0","2014-04-09","18","","1","","","2","2014-04-09 05:46:21","321","4","Z2","2","2014-04-09 18:21:04","2","2014-04-09 18:42:54","0","0000-00-00 00:00:00","2","141811","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1971","4","0","321595R","2014-04-09","0","0","2014-04-09","16","","1","","Flextronics \r\nIntel IVI Carrier BRD \r\nFAB#G74395-103","2","2014-04-09 06:15:49","1902 lf ep","4","Z2","2","2014-04-09 15:56:15","2","2014-04-09 18:00:42","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1972","31","0","7582265","2014-04-09","0","0","2014-04-10","16","","8","","","2","2014-04-10 08:23:36","1293","4","18X18","2","2014-04-10 11:21:15","2","2014-04-10 12:49:35","0","0000-00-00 00:00:00","2","141827","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1973","31","0","7582266","2014-04-09","0","0","2014-04-10","16","","8","","","2","2014-04-10 08:24:00","745","4","18X18","2","2014-04-10 11:17:06","2","2014-04-10 12:42:24","0","0000-00-00 00:00:00","2","141827","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1974","46","0","151046","2014-04-09","0","0","2014-04-10","16","","8","","","2","2014-04-10 11:06:40","1624","6","","2","2014-04-10 14:31:37","2","2014-04-10 19:25:25","0","0000-00-00 00:00:00","2","141836","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1975","20","0","938675","2014-04-09","0","0","2014-04-10","16","","15","","Ascentron Diode Laser 0042-0002 P/N 790-2522","2","2014-04-09 10:55:09","1757","5","18X18","2","2014-04-09 14:54:17","2","2014-04-09 16:47:36","0","0000-00-00 00:00:00","2","141809","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1976","20","0","938676","2014-04-09","0","0","2014-04-10","16","","15","","","2","2014-04-09 10:55:25","1007","5","18X18","2","2014-04-09 14:32:21","2","2014-04-09 16:47:44","0","0000-00-00 00:00:00","2","141809","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1977","31","0","7582267","2014-04-09","0","0","2014-04-10","16","","8","","","2","2014-04-10 08:24:33","701","4","18X18","2","2014-04-10 11:16:58","2","2014-04-10 12:42:34","0","0000-00-00 00:00:00","2","141826","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1978","31","0","7582268","2014-04-09","0","0","2014-04-10","16","","8","","","2","2014-04-10 08:25:15","874","4","18X18","2","2014-04-10 11:09:46","2","2014-04-10 12:58:15","0","0000-00-00 00:00:00","2","141826","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1979","11","0","102091","2014-04-09","1","0","2014-04-16","16","","1","","","2","2014-04-16 12:16:04","2071","5","Z2","2","2014-04-16 13:43:36","2","2014-04-16 16:56:16","0","0000-00-00 00:00:00","0","","2","8","2014-04-16 13:26:34","2","1");
INSERT INTO tbl_jobs VALUES("1980","31","0","7582269","2014-04-09","0","0","2014-04-10","16","","8","","","2","2014-04-10 08:21:21","972","4","18X18","2","2014-04-10 11:09:53","2","2014-04-10 12:49:26","0","0000-00-00 00:00:00","2","141825","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1981","7","0","9991823","2014-04-09","1","0","2014-04-16","15.3","","1","","","2","2014-04-16 10:34:52","39","8","Z1","2","2014-04-16 13:27:51","2","2014-04-16 13:39:17","2","2014-04-16 15:25:31","2","141960","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1982","7","0","9991824","2014-04-09","1","0","2014-04-16","15.3","","1","","","2","2014-04-16 10:35:06","1019","6","Z1","2","2014-04-16 13:56:51","2","2014-04-16 15:24:57","2","2014-04-16 15:25:20","2","141960","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1983","7","0","9991825","2014-04-09","0","0","2014-04-18","13","","1","","","2","2014-04-17 18:16:52","353","6","Z1","2","2014-04-18 13:17:31","2","2014-04-18 13:31:28","0","0000-00-00 00:00:00","2","142013","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1984","7","0","9991826","2014-04-09","0","0","2014-04-18","13","","1","","","2","2014-04-17 18:16:28","581","8","Z1","2","2014-04-18 10:23:45","2","2014-04-18 10:28:16","2","2014-04-18 11:49:03","2","142001","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1985","34","0","7994766","2014-04-09","0","0","2014-04-10","10","","1","","","2","2014-04-09 13:20:48","1932","6","Z2","2","2014-04-09 18:20:30","2","2014-04-09 21:32:05","2","2014-04-10 07:45:09","2","141817","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1986","7","0","9991827","2014-04-09","0","0","2014-04-21","17","","1","","","2","2014-04-21 09:38:25","2823","6","Z1","2","2014-04-21 12:04:22","2","2014-04-21 12:26:44","0","0000-00-00 00:00:00","2","142031","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1987","7","0","9991828","2014-04-09","0","0","2014-04-21","17","","1","","","2","2014-04-21 09:38:49","2896","6","Z1","2","2014-04-21 11:57:20","2","2014-04-21 12:05:28","0","0000-00-00 00:00:00","2","142031","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1988","7","0","9991829","2014-04-09","0","0","2014-04-17","10","","1","","","2","2014-04-16 13:15:36","215","8","Z1","2","2014-04-16 20:20:43","2","2014-04-16 20:42:10","2","2014-04-17 07:51:04","2","141974","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1989","7","0","9991830","2014-04-09","0","0","2014-04-10","17","","1","","","1","2014-04-10 04:11:59","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("1990","89","0","973466","2014-04-09","0","0","2014-04-11","16","","1","","","2","2014-04-10 19:12:23","2524","8","Fuji4000","2","2014-04-11 09:28:09","2","2014-04-11 12:03:18","2","2014-04-11 13:10:08","2","141851","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1991","43","0","5413960","2014-04-09","0","0","2014-04-10","12","","1","","","2","2014-04-09 15:55:52","600","4","Z2","2","2014-04-09 19:04:50","2","2014-04-09 21:15:52","2","2014-04-10 07:45:29","2","141820","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1992","43","0","5413961","2014-04-09","0","0","2014-04-10","12","","1","","","2","2014-04-09 17:47:54","3670","4","Z2","2","2014-04-09 19:00:43","2","2014-04-09 21:16:05","2","2014-04-10 07:45:39","2","141821","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1993","70","0","1105127","2014-04-09","0","0","2014-04-10","13","","1","","","2","2014-04-10 10:23:46","2141","4","Z2","2","2014-04-10 14:40:14","2","2014-04-10 17:29:41","0","0000-00-00 00:00:00","2","141837","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1994","70","0","1105128","2014-04-09","0","0","2014-04-10","13","","1","","","2","2014-04-10 10:24:01","844","4","Z2","2","2014-04-10 13:13:34","2","2014-04-10 17:29:49","0","0000-00-00 00:00:00","2","141837","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1995","9","0","2814028","2014-04-09","1","0","2014-04-18","16","","1","","","2","2014-04-18 08:37:48","783","4","Z2","2","2014-04-18 11:25:43","2","2014-04-18 15:02:35","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1996","9","0","2814029","2014-04-09","1","0","2014-04-21","14","","1","","","2","2014-04-21 09:03:28","3565","4","Z2","2","2014-04-21 13:25:49","2","2014-04-21 15:54:17","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1997","9","0","2814030","2014-04-09","1","0","2014-04-21","14","","1","","","2","2014-04-21 09:02:44","6001","4","Z2","2","2014-04-21 12:40:54","2","2014-04-21 15:54:07","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1998","9","0","2814031","2014-04-09","0","0","2014-05-28","18","","1","","","2","2014-05-27 12:08:17","115","5","Z2","2","2014-05-27 14:38:46","2","2014-05-27 17:02:35","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("1999","9","0","2814032","2014-04-09","0","0","2014-05-28","18","","1","","","2","2014-05-27 12:07:35","347","4","Z2","2","2014-05-27 16:02:03","2","2014-05-27 18:04:56","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2000","7","0","9991831","2014-04-09","0","0","2014-04-10","17","","1","","","1","2014-04-10 06:15:55","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2001","7","0","9991832","2014-04-09","0","0","2014-04-10","17","","1","","","1","2014-04-10 06:16:04","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2002","9","0","2814033","2014-04-09","0","0","2014-04-28","11","","1","","","2","2014-04-25 16:37:55","48","5","Z2","2","2014-04-25 19:16:55","2","2014-04-25 21:14:32","2","2014-04-28 07:52:24","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2003","4","0","321802","2014-04-09","0","0","2014-04-10","15","","1","","","2","2014-04-10 10:23:26","1219","5","Z2","2","2014-04-10 15:41:35","2","2014-04-10 18:33:50","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2004","97","0","4792310","2014-04-09","1","0","2014-04-18","18","","1","","Surface Art Phase Matrix 2020584-02 REV H J","2","2014-04-18 18:06:41","586","6","Foil Only","2","2014-04-18 17:36:49","2","2014-04-18 17:54:01","0","0000-00-00 00:00:00","2","142020","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2005","11","0","102092","2014-04-09","0","0","2014-04-10","15","","1","","","2","2014-04-10 07:42:13","","","","2","2014-04-10 09:13:46","2","2014-04-10 10:46:12","2","2014-04-10 10:46:27","2","141822","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2006","97","0","4792311","2014-04-09","0","0","2014-04-10","15","","1","","","2","2014-04-10 05:51:09","203","6","Foil Only","2","2014-04-10 13:03:14","2","2014-04-10 13:58:42","0","0000-00-00 00:00:00","2","141839","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2007","93","0","2532136","2014-04-09","0","0","2014-04-10","15","","1","","","1","2014-04-10 03:51:08","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2008","2","0","5346872","2014-04-09","0","0","2014-04-10","15","","1","","","2","2014-04-10 05:53:42","3910","4","Z2","2","2014-04-10 11:24:30","2","2014-04-10 13:46:04","0","0000-00-00 00:00:00","2","141830","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2009","97","0","4792312","2014-04-09","0","0","2014-04-10","16","","1","","","2","2014-04-10 05:51:49","4572","6","Foil Only","2","2014-04-10 15:25:04","2","2014-04-10 16:18:48","0","0000-00-00 00:00:00","2","141838","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2010","97","0","4792313","2014-04-09","0","0","2014-04-10","16","","1","","","2","2014-04-10 05:52:13","3662","6","Foil Only","2","2014-04-10 13:25:15","2","2014-04-10 13:58:58","0","0000-00-00 00:00:00","2","141838","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2011","8","0","575387","2014-04-09","1","0","2014-04-11","15","","1","","","2","2014-04-10 19:12:45","7587","5","Z2","2","2014-04-11 14:27:17","2","2014-04-11 16:03:24","0","0000-00-00 00:00:00","2","141872","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2012","8","0","575388","2014-04-09","1","0","2014-04-11","15","","1","","","2","2014-04-10 19:13:01","2223","5","Z2","2","2014-04-11 14:51:25","2","2014-04-11 16:03:31","0","0000-00-00 00:00:00","2","141872","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2013","97","0","4792314","2014-04-09","0","0","2014-04-11","8","","1","","","2","2014-04-10 05:52:45","147","6","Foil Only","2","2014-04-10 13:34:56","2","2014-04-10 13:59:06","0","0000-00-00 00:00:00","2","141835","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2014","50","0","630335","2014-04-09","0","0","2014-04-11","15","","1","","","2","2014-04-10 12:14:44","5278","5","Z3","2","2014-04-11 16:54:19","2","2014-04-11 21:46:25","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2015","72","0","1262421","2014-04-09","0","0","2014-04-10","6","","1","","test order for wims pack slip","2","2014-04-10 00:02:41","","","","2","2014-04-10 00:02:52","2","2014-04-10 00:03:01","0","0000-00-00 00:00:00","2","dghgfhgf","2","3","2014-04-10 10:58:26","0","-1");
INSERT INTO tbl_jobs VALUES("2016","72","0","1262421R","2014-04-10","0","0","2014-04-10","7","","1","","test order","2","2014-04-10 00:55:54","","","","2","2014-04-10 00:56:03","2","2014-04-10 00:56:12","0","0000-00-00 00:00:00","2","ghujghj","2","4","2014-04-10 00:56:28","0","-1");
INSERT INTO tbl_jobs VALUES("2017","72","0","1262732","2014-04-10","0","0","2014-04-10","18","","1","","","2","2014-04-10 07:11:22","1250","4","Z2","2","2014-04-10 11:02:10","2","2014-04-10 13:17:39","0","0000-00-00 00:00:00","2","141823","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2018","72","0","1262733","2014-04-10","0","0","2014-04-10","18","","1","","","2","2014-04-10 07:12:00","3088","4","Z2","2","2014-04-10 11:02:04","2","2014-04-10 13:40:16","0","0000-00-00 00:00:00","2","141824","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2019","43","0","5413962","2014-04-10","0","0","2014-04-11","8","","1","","","2","2014-04-10 12:28:18","5424","8","Fuji4000","2","2014-04-10 21:29:27","2","2014-04-10 22:28:57","2","2014-04-11 07:39:14","2","141833","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2020","57","0","767133","2014-04-10","1","0","2014-04-10","16","","10","","Stonestreet One 045866-1-1 (BR-SS-S2)","2","2014-04-10 10:31:18","342","4","Foil Only","2","2014-04-10 13:55:49","2","2014-04-10 14:07:29","0","0000-00-00 00:00:00","2","141831","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2021","8","0","575379R","2014-04-10","1","0","2014-04-10","17","","1","","","2","2014-04-10 11:05:46","","","","2","2014-04-10 13:01:59","2","2014-04-10 13:14:49","0","0000-00-00 00:00:00","0","","2","6","2014-04-10 13:15:13","2","1");
INSERT INTO tbl_jobs VALUES("2022","77","0","7281729","2014-04-10","1","1","2014-04-11","11","","1","","","2","2014-04-11 08:41:16","","","","2","2014-04-11 12:53:42","2","2014-04-11 14:10:46","2","2014-04-14 11:42:37","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2023","93","0","2532137","2014-04-10","0","0","2014-04-11","18","","1","","SMTC Spider Cloud 01854-07","2","2014-04-11 13:13:45","3184","4","Z2","2","2014-04-11 17:27:54","2","2014-04-11 21:45:30","2","2014-04-16 15:30:46","2","141885","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2024","93","0","2532138","2014-04-10","0","0","2014-04-11","18","","1","","SMTC Spider Cloud 01854-07","2","2014-04-11 13:15:30","2684","4","Z2","2","2014-04-11 17:21:53","2","2014-04-11 20:30:26","2","2014-04-16 15:30:38","2","141885","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2025","100","0","140199","2014-04-10","0","0","2014-04-11","16","","15","","Synergetics ARBITER RB0049500/UB0049500C","2","2014-04-11 10:29:25","1243","5","18X18","2","2014-04-11 15:21:27","2","2014-04-11 15:27:23","0","0000-00-00 00:00:00","2","141869","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2026","7","0","9991833","2014-04-10","1","1","2014-04-11","10","","1","","","2","2014-04-10 16:25:26","3353","8","Z1","2","2014-04-10 19:26:07","2","2014-04-10 19:33:27","2","2014-04-11 10:58:20","2","141852","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2027","1","0","8292556","2014-04-10","0","0","2014-04-11","11","","1","","Foxconn iDSBG IDSBG 920-00226-01","2","2014-04-10 19:10:09","421","3","Z2","2","2014-04-10 22:00:21","2","2014-04-10 22:27:47","2","2014-04-11 07:39:32","2","141848","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2028","29","0","919106","2014-04-10","0","0","2014-04-11","11","","1","","","2","2014-04-11 09:46:12","3879","4","Foil Only","2","2014-04-11 12:30:04","2","2014-04-11 12:37:58","2","2014-04-11 13:36:02","2","141859","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2029","43","0","5413963","2014-04-10","0","0","2014-04-11","11","","1","","Infiniti Solutions Logic Mark LGM03 Rev D Job","2","2014-04-11 08:50:24","1189","4","Z2","2","2014-04-11 10:40:35","2","2014-04-11 12:21:25","2","2014-04-11 12:42:43","2","141853","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2030","4","0","321803","2014-04-10","0","0","2014-04-11","12","","1","","","2","2014-04-11 08:40:48","","","","2","2014-04-11 12:37:03","2","2014-04-11 12:42:43","2","2014-04-11 13:10:53","2","141856","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2031","8","0","575T384","2014-04-10","0","0","2014-04-10","17","","1","","","2","2014-04-10 12:42:17","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2032","8","0","575T383","2014-04-10","0","0","2014-04-10","17","","1","","","2","2014-04-10 12:42:09","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2033","8","0","575T387","2014-04-10","1","0","2014-04-11","15","","1","","","2","2014-04-10 12:48:05","","","","2","2014-04-10 13:26:34","2","2014-04-10 13:29:06","0","0000-00-00 00:00:00","2","141872","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2034","11","0","102093","2014-04-10","0","0","2014-04-17","17","","1","","Zollner Electronics AEHR 1801093-00/5092050-00","2","2014-04-14 09:24:37","6664","4","Z3","2","2014-04-14 12:08:31","2","2014-04-14 13:53:52","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2035","8","0","575T388","2014-04-10","1","0","2014-04-11","15","","1","","","2","2014-04-10 12:48:21","","","","2","2014-04-10 13:26:43","2","2014-04-10 13:28:53","0","0000-00-00 00:00:00","2","141872","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2036","1","0","8292557","2014-04-10","0","0","2014-04-11","12","","1","","Foxconn iDSBG IDSBG 920-00183-01","2","2014-04-11 08:49:25","706","3","Z2","2","2014-04-11 14:43:56","2","2014-04-11 15:54:12","0","0000-00-00 00:00:00","2","141868","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2037","7","0","9991834","2014-04-10","0","0","2014-04-17","10","","1","","SEM HE Intel Corp VTD16090-001:1 Apt count =","2","2014-04-16 13:15:05","6126","6","Foil Only","2","2014-04-17 17:16:36","2","2014-04-17 17:21:51","2","2014-04-18 07:48:33","2","141988","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2038","7","0","9991835","2014-04-10","0","0","2014-04-17","10","","1","","SEM HE Intel Corp VTD16090-001:1 Apt count =","2","2014-04-16 13:14:15","1723","6","Foil Only","2","2014-04-17 17:45:13","2","2014-04-17 18:24:00","2","2014-04-18 07:49:05","2","141988","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2039","8","0","575390","2014-04-10","0","1","2014-04-11","13","","1","","","2","2014-04-11 09:45:44","2126","5","Z2","2","2014-04-11 18:57:49","2","2014-04-11 20:38:51","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2040","8","0","575391","2014-04-10","0","1","2014-04-11","13","","1","","","2","2014-04-11 09:45:26","5454","5","Z2","2","2014-04-11 19:18:04","2","2014-04-11 21:18:33","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2041","42","0","660030","2014-04-10","1","0","2014-04-14","17","","1","","","2","2014-04-14 08:48:19","3090","6/4","Z3","2","2014-04-14 16:45:03","2","2014-04-14 17:48:25","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2042","51","0","9931387","2014-04-10","0","0","2014-04-11","14","","1","","","2","2014-04-11 17:18:27","2386","5","18X18","2","2014-04-11 19:43:19","2","2014-04-11 21:40:07","2","2014-04-14 07:47:38","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2043","51","0","9931388","2014-04-10","0","0","2014-04-11","14","","1","","","2","2014-04-11 17:18:50","1426","5","18X18","2","2014-04-11 19:38:14","2","2014-04-11 21:40:01","2","2014-04-14 07:47:47","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2044","35","0","800207","2014-04-10","0","0","2014-04-15","17","","1","","","2","2014-04-11 08:43:49","899","8/5","Z2","2","2014-04-16 10:31:40","2","2014-04-16 13:11:22","2","2014-04-16 13:12:45","2","141875","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2045","35","0","800208","2014-04-10","0","0","2014-04-15","17","","1","","","2","2014-04-11 08:44:30","2331","5","Z2","2","2014-04-11 18:02:57","2","2014-04-11 21:46:33","2","2014-04-14 07:47:07","2","141871","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2046","2","0","5346873","2014-04-10","0","0","2014-04-11","15","","1","","Sanmina Ciena 154-0004-430 Rev 001 APERTURE COUNT","2","2014-04-11 08:47:33","2107","5","Z2","2","2014-04-11 13:55:47","2","2014-04-11 16:01:19","0","0000-00-00 00:00:00","2","141864","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2047","7","0","9991836","2014-04-10","0","0","2014-04-11","15","","1","","SEM HE BGA Re-Work 38c9357A LOC U47","2","2014-04-11 10:01:02","","","","2","2014-04-11 12:53:54","2","2014-04-11 12:57:41","0","0000-00-00 00:00:00","2","141861","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2048","76","0","173031","2014-04-10","0","0","2014-04-11","15","","1","","Piranha EMS, Inc Cephasonic  10400602 Rev 2","1","2014-04-11 03:42:57","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2049","22","0","3474281","2014-04-10","0","0","2014-04-11","16","","8","","Axiom Electronics Boeing Backplane 901767088 STP000864","2","2014-04-11 10:00:46","276","6","Foil Only","2","2014-04-11 13:49:35","2","2014-04-11 14:49:53","0","0000-00-00 00:00:00","2","141865","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2050","9","0","2814034","2014-04-10","1","0","2014-04-29","17","","1","","","2","2014-04-11 07:33:07","397","5","Z2","2","2014-04-29 15:54:28","2","2014-04-29 17:34:10","2","2014-04-29 17:34:53","2","S/P837640","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2051","9","0","2814035","2014-04-10","0","0","2014-04-11","15","","1","","","1","2014-04-11 04:17:10","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2052","1","0","8292558","2014-04-10","1","0","2014-04-11","18","","1","","iDSBG 820-3686-03","2","2014-04-14 12:08:34","35478","3","Z3","2","2014-04-14 17:21:09","2","2014-04-14 18:41:46","0","0000-00-00 00:00:00","2","141877","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2053","1","0","8292559","2014-04-10","1","0","2014-04-11","8","","1","","","2","2014-04-10 16:10:32","600","3","Z2","2","2014-04-10 21:34:29","2","2014-04-10 22:27:33","2","2014-04-11 07:39:24","2","141842","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2054","1","0","8292560","2014-04-10","0","0","2014-04-11","15","","1","","iDSBG 920-4594-02","2","2014-04-11 08:48:26","572","3","Z2","2","2014-04-11 14:59:10","2","2014-04-11 15:53:59","0","0000-00-00 00:00:00","2","141867","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2055","101","0","471621","2014-04-10","0","1","2014-04-18","16","","8","","","2","2014-04-16 14:47:40","1638","5","18X18","2","2014-04-18 11:07:53","2","2014-04-18 13:04:53","0","0000-00-00 00:00:00","2","142048","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2056","41","0","832739","2014-04-10","0","0","2014-04-11","11","","1","","","2","2014-04-11 08:42:30","240","4","Foil Only","2","2014-04-11 12:03:27","2","2014-04-11 12:13:09","2","2014-04-11 13:10:40","2","141858","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2057","97","0","4792315","2014-04-10","0","0","2014-04-14","8","","1","","Surface Art Phase Matrix 2020461-04 REV C J","2","2014-04-11 07:33:49","237","6","Foil Only","2","2014-04-11 10:47:18","2","2014-04-11 11:22:18","0","0000-00-00 00:00:00","2","141854","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2058","35","0","800209","2014-04-10","0","0","2014-04-14","8","","1","","","2","2014-04-14 17:06:37","4231","5","Z2","2","2014-04-14 19:28:01","2","2014-04-14 21:09:55","2","2014-04-15 07:54:44","2","141897","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2059","35","0","800210","2014-04-10","0","0","2014-04-14","8","","1","","","2","2014-04-14 17:07:36","4213","5","Z2","2","2014-04-14 18:16:32","2","2014-04-14 20:42:45","2","2014-04-15 07:54:52","2","141897","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2060","6","0","739360","2014-04-10","0","0","2014-04-11","18","","1","","","2","2014-04-11 08:41:35","","","","2","2014-04-11 12:37:17","2","2014-04-11 12:43:17","2","2014-04-11 13:36:35","2","141857","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2061","72","0","1262734","2014-04-11","0","0","2014-04-11","18","","1","","","2","2014-04-11 07:32:19","523","4","Z2","2","2014-04-11 12:34:47","2","2014-04-11 13:36:23","2","2014-04-11 13:36:51","2","141862","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2062","72","0","1262735","2014-04-11","0","0","2014-04-11","18","","1","","Pactron Incorporated PAC3006_11April2014 WO24887_B(LeadFree)","2","2014-04-11 08:46:16","1431","4","Z2","2","2014-04-11 12:42:17","2","2014-04-11 13:36:16","2","2014-04-11 13:36:44","2","141862","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2063","72","0","1262736","2014-04-11","0","0","2014-04-14","18","","1","","","2","2014-04-11 07:39:21","2301","7-5","Z2","2","2014-04-14 19:55:32","2","2014-04-14 20:58:39","2","2014-04-15 07:54:25","2","141874","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2064","43","0","5413964","2014-04-11","0","0","2014-04-14","8","","1","","Infiniti Solutions Job","2","2014-04-11 11:30:37","3056","8","Fuji4000","2","2014-04-11 15:49:07","2","2014-04-11 19:37:15","2","2014-04-14 07:47:17","2","141870","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2065","43","0","5413965","2014-04-11","0","0","2014-04-14","8","","1","","","2","2014-04-11 11:30:53","3968","8","Fuji4000","2","2014-04-11 14:37:02","2","2014-04-11 16:03:11","2","2014-04-14 07:47:26","2","141870","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2066","9","0","2814036","2014-04-11","0","0","2014-04-28","11","","1","","2814033(top) 2814036(bottom)Sanmina - SCI, Corp. RDC Assy 131-0745 PCB 132-0745 rev 1","2","2014-04-25 16:38:21","84","4","Z2","2","2014-04-25 19:13:14","2","2014-04-25 21:14:41","2","2014-04-28 07:52:31","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2067","83","0","613390","2014-04-11","1","0","2014-04-11","17","","10","","Radio Design Group WIS 1G Belt RX V4 Stencil P/N:2J-0391","2","2014-04-11 12:32:28","5516","4","18X18","2","2014-04-11 13:34:16","2","2014-04-11 15:27:03","0","0000-00-00 00:00:00","2","141863","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2068","22","0","3474282","2014-04-11","0","0","2014-04-16","17","","8","","Axiom Electronics Boeing HP Interface C","2","2014-04-15 19:04:11","1609","5","Foil Only","2","2014-04-16 11:01:49","2","2014-04-16 13:11:38","0","0000-00-00 00:00:00","2","141945","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2069","54","0","914617","2014-04-11","0","0","2014-04-14","11","","1","","","2","2014-04-11 13:57:26","3148","4","Foil Only","2","2014-04-11 18:38:37","2","2014-04-11 19:57:46","2","2014-04-14 08:44:59","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2070","2","0","5346875","2014-04-11","0","0","2014-04-14","12","","1","","Sanmina Ruckus 120-11269-001 Rev-1.2","2","2014-04-14 04:52:37","31","5","Z2","2","2014-04-14 12:47:24","2","2014-04-14 15:20:06","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2071","7","0","9991837","2014-04-11","0","0","2014-04-14","11","","1","","Duplicate order of 9991839","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2072","7","0","9991838","2014-04-11","0","0","2014-04-14","11","","1","","Duplicate order of 9991839","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2073","2","0","5346874","2014-04-11","0","0","2014-04-14","10","","1","","Sanmina Ruckus 120-11283-001 Rev 2.0","2","2014-04-11 19:09:17","238","5","Z2","2","2014-04-11 20:05:07","2","2014-04-11 21:46:03","2","2014-04-14 08:44:42","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2074","54","0","914616","2014-04-11","0","0","2014-04-14","10","","1","","","2","2014-04-11 13:12:51","116","5","Foil Only","2","2014-04-11 17:42:32","2","2014-04-11 17:49:56","2","2014-04-14 08:44:51","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2075","7","0","9991839","2014-04-11","1","1","2014-04-14","16","","1","","","2","2014-04-11 20:03:27","31126","4","Z1","2","2014-04-14 09:55:37","2","2014-04-14 11:01:45","2","2014-04-14 13:23:43","2","141890","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2076","2","0","5346876","2014-04-11","0","0","2014-04-14","12","","1","","Sanmina PMC PCA-00373-01-B Rev 1B","2","2014-04-14 07:20:12","712","5","Z2","2","2014-04-14 12:51:33","2","2014-04-14 15:20:13","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2077","1","0","8292561","2014-04-11","0","0","2014-04-15","14","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2078","1","0","8292562","2014-04-11","0","0","2014-04-15","14","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2079","1","0","8292563","2014-04-11","0","0","2014-04-15","14","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2080","22","0","3474283","2014-04-11","0","0","2014-04-15","17","","8","","Axiom Electronics Boeing Actuator Power 901767083 STB000867","2","2014-04-14 18:41:27","2517","4","Foil Only","2","2014-04-14 20:26:08","2","2014-04-14 20:45:39","0","0000-00-00 00:00:00","2","141899","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2081","120","0","164005","2014-04-11","0","0","2014-04-14","18","","1","","","1","2014-04-14 02:36:31","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2082","120","0","164004","2014-04-11","0","0","2014-04-14","18","","1","","","1","2014-04-14 02:26:37","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2083","1","0","8292564","2014-04-11","1","0","2014-04-14","9","","1","","","2","2014-04-14 10:40:50","4648","3","Z2","2","2014-04-14 11:56:07","2","2014-04-14 13:09:51","2","2014-04-14 13:10:01","0","","2","7","2014-04-14 13:39:25","2","1");
INSERT INTO tbl_jobs VALUES("2084","62","0","538112r","2014-04-11","1","0","2014-04-14","6","","4","","BackEtch","2","2014-04-11 16:36:48","1662","4/2","18X19","2","2014-04-14 18:48:47","2","2014-04-14 19:42:52","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2085","62","0","538113r","2014-04-11","1","0","2014-04-14","6","","4","","BackEtch","2","2014-04-11 16:37:08","666","4/2","18X19","2","2014-04-14 19:27:45","2","2014-04-14 19:42:44","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2086","97","0","4792316","2014-04-11","1","0","2014-04-14","7.3","","1","","Attn to Justina Lee","2","2014-04-11 19:39:39","5095","3","18X18","2","2014-04-11 20:46:14","2","2014-04-11 21:46:39","2","2014-04-14 08:44:34","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2087","51","0","9931389","2014-04-13","0","0","2014-04-15","8","","1","","","2","2014-04-14 04:32:32","674","5","18X18","2","2014-04-14 20:00:12","2","2014-04-14 21:20:44","2","2014-04-15 07:54:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2088","4","0","321804","2014-04-13","0","0","2014-04-16","8","","1","","","2","2014-04-15 08:58:17","10446","5/4","Z2","2","2014-04-15 20:50:18","2","2014-04-16 07:12:07","2","2014-04-16 07:51:33","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2089","4","0","321805","2014-04-13","0","0","2014-04-15","8","","1","","","2","2014-04-15 09:19:33","1866","4","Z2","2","2014-04-15 10:02:48","2","2014-04-15 14:50:19","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2090","77","0","7281730","2014-04-13","0","1","2014-04-15","8","","1","","Plexus Altera EP4S100G5F45I2N","2","2014-04-14 07:21:18","","","","2","2014-04-14 15:49:28","2","2014-04-17 09:00:24","2","2014-04-17 10:24:40","2","141970","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2091","77","0","7281731","2014-04-13","0","0","2014-04-15","8","","1","","","2","2014-04-14 20:05:18","","","","2","2014-04-14 21:58:20","2","2014-04-15 10:07:41","2","2014-04-17 10:24:47","2","141970","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2092","77","0","7281732","2014-04-13","0","1","2014-04-15","8","","1","","Plexus Altera EPM2210F256C3N","2","2014-04-14 07:20:56","","","","2","2014-04-14 15:49:38","2","2014-04-17 09:00:19","2","2014-04-17 10:24:57","2","141969","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2093","77","0","7281733","2014-04-13","0","0","2014-04-15","8","","1","","","2","2014-04-14 07:21:50","","","","2","2014-04-14 21:12:46","2","2014-04-15 10:07:49","2","2014-04-17 10:25:05","2","141969","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2094","11","0","102094","2014-04-14","0","0","2014-04-15","14","","1","","Zollner Electronics Cadence 1745291-00_2500000009299  Rev 1, 5092069-00","1","2014-04-14 20:20:08","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","2014-04-21 15:16:25","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2095","7","0","9991842","2014-04-14","0","0","2014-04-15","17","","1","","Duplicate order of 9991840-41","1","2014-04-15 05:27:29","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2096","7","0","9991843","2014-04-14","0","0","2014-04-15","17","","1","","Duplicate order of 9991840-41","1","2014-04-15 05:27:50","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2097","83","0","613391","2014-04-14","1","0","2014-04-14","16","","10","","CUSTOMER DATAETCHED ON STENCILRadio Design Group WIS 1G Belt Dig 5 V3 Stencil P/N:2J-0390","2","2014-04-14 13:10:27","2786","4","18X18","2","2014-04-14 14:10:32","2","2014-04-14 15:52:01","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2098","7","0","9991840","2014-04-14","0","0","2014-04-15","17","","1","","SEM HE Form Factor Inc. 202-11081_11082 STANDARD","1","2014-04-15 06:15:21","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2099","7","0","9991841","2014-04-14","0","0","2014-04-15","17","","1","","SEM HE Form Factor Inc. 202-11081_11082 STANDARD","1","2014-04-15 06:15:49","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2100","111","0","782673","2014-04-14","0","0","2014-04-15","18.3","","8","","Veris Z206836-0A ZT00393-0A","2","2014-04-14 18:55:42","2371","5","18X18","2","2014-04-15 09:23:00","2","2014-04-15 09:23:11","0","0000-00-00 00:00:00","2","141900","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2101","97","0","4792317","2014-04-14","0","0","2014-04-15","10","","1","","","2","2014-04-14 14:52:47","2297","4","Z2","2","2014-04-14 16:59:18","2","2014-04-14 20:42:58","2","2014-04-15 07:54:13","2","141896","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2102","4","0","321806","2014-04-14","0","0","2014-04-15","11","","1","","Flextronics PHILO PLO-970-00071-02 Rev-2C19 PLO-651-00039-02 Rev-X1","2","2014-04-15 11:12:29","5661","4","Z2","2","2014-04-15 12:48:38","2","2014-04-15 15:11:02","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2103","22","0","3474284","2014-04-14","0","0","2014-04-15","16","","8","","Axiom Electronics AiTech 901767070 STB000861","2","2014-04-15 10:23:32","10614","4","Foil Only","2","2014-04-15 14:28:45","2","2014-04-15 15:30:51","0","0000-00-00 00:00:00","2","141916","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2104","42","0","660031","2014-04-14","0","1","2014-04-15","11","","1","","","2","2014-04-15 08:32:45","","","","2","2014-04-15 09:35:20","2","2014-04-15 09:48:31","2","2014-04-18 10:12:34","2","141998","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2105","11","0","102095","2014-04-14","0","0","2014-04-15","11","","1","","Zollner Electronics Cadence  1746765-00 location: J5","2","2014-04-15 06:59:02","","","","2","2014-04-15 08:22:55","2","2014-04-15 09:36:06","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2106","7","0","9991844","2014-04-14","0","0","2014-04-15","17","","1","","","1","2014-04-15 06:15:31","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2107","7","0","9991845","2014-04-14","0","0","2014-04-15","17","","1","","","1","2014-04-15 06:15:45","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2108","42","0","660032","2014-04-14","0","1","2014-04-15","11","","1","","","2","2014-04-15 08:32:11","","","","2","2014-04-15 09:35:14","2","2014-04-15 13:37:08","2","2014-04-16 11:17:51","2","141940","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2109","76","0","173032","2014-04-14","1","0","2014-04-14","17","","1","","","2","2014-04-14 13:10:07","","","","2","2014-04-14 14:11:22","2","2014-04-14 14:50:07","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2110","7","0","9991846","2014-04-14","1","0","2014-04-15","17","","1","","","2","2014-04-22 12:56:10","952","8","Z1","2","2014-04-22 14:04:17","2","2014-04-22 14:11:17","0","0000-00-00 00:00:00","2","142075","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2111","7","0","9991847","2014-04-14","1","0","2014-04-15","17","","1","","","2","2014-04-22 12:56:42","136","8","Z1","2","2014-04-22 13:58:04","2","2014-04-22 14:11:24","0","0000-00-00 00:00:00","2","142075","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2112","4","0","321807","2014-04-14","0","0","2014-04-15","12","","1","","Flextronics F5 Networks PCA-0370-M0","2","2014-04-14 18:54:34","2132","5","Z2","2","2014-04-14 20:17:41","2","2014-04-15 07:55:10","2","2014-04-15 07:55:20","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2113","78","0","311055","2014-04-14","0","0","2014-04-15","19","","15","","Precision PCB Services RFQ 148DRQFN","2","2014-04-15 10:23:43","","","","2","2014-04-15 15:48:22","2","2014-04-15 15:52:30","0","0000-00-00 00:00:00","2","141920","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2114","120","0","164007","2014-04-14","0","0","2014-04-16","17","","10","","Castle Creations S0T-0142-01 S0B-0142-01","2","2014-04-16 09:00:16","3422","4","Z2","2","2014-04-16 16:33:40","2","2014-04-16 18:44:16","0","0000-00-00 00:00:00","2","141953","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2115","97","0","4792318","2014-04-14","0","0","2014-04-15","13","","1","","Surface Art INTEL(CANADA) J","2","2014-04-15 08:35:03","2970","5","18X18","2","2014-04-15 11:12:39","2","2014-04-15 13:28:01","2","2014-04-15 14:01:32","2","141910","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2116","88","0","6092048","2014-04-14","0","1","2014-04-15","16","","15","","Sanmina PROFIRE 104365 PRIMARY","2","2014-04-15 10:44:00","2082","6","Z2","2","2014-04-15 16:05:45","2","2014-04-15 17:42:32","0","0000-00-00 00:00:00","2","141942","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2117","93","0","2532139","2014-04-14","0","0","2014-04-15","9","","1","","SMTC ANR 3-80488-3 rev.a","2","2014-04-15 09:39:37","1580","5","Z2","2","2014-04-15 11:34:50","2","2014-04-15 15:01:07","0","0000-00-00 00:00:00","2","141907","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2118","40","0","807077","2014-04-14","1","1","2014-04-15","19","","5","","","2","2014-04-14 18:39:16","","","","2","2014-04-15 17:05:03","2","2014-04-15 17:30:12","0","0000-00-00 00:00:00","2","141935","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2119","40","0","807078","2014-04-14","1","1","2014-04-15","18","","5","","","2","2014-04-14 18:39:05","","","","2","2014-04-14 21:58:28","2","2014-04-15 16:59:26","0","0000-00-00 00:00:00","2","141937","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2120","72","0","1262737","2014-04-14","1","0","2014-04-14","17","","1","","Pactron HYNIX","2","2014-04-14 17:04:07","","","","2","2014-04-14 17:37:48","2","2014-04-14 18:33:27","2","2014-04-15 07:54:32","2","141898","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2121","88","0","6092049","2014-04-14","0","1","2014-04-15","17","","15","","Sanmina VARIAN 93284 A PRIMARY","2","2014-04-15 15:42:32","3394","5","Z2","2","2014-04-15 15:50:28","2","2014-04-15 17:48:35","0","0000-00-00 00:00:00","2","141941","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2122","88","0","6092050","2014-04-14","0","1","2014-04-15","17","","15","","","2","2014-04-15 15:42:48","62","6","Z2","2","2014-04-15 15:50:22","2","2014-04-15 17:00:17","0","0000-00-00 00:00:00","2","141941","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2123","42","0","660033","2014-04-14","0","0","2014-04-15","15","","1","","Hunter Technology DSSD Inc 002092-03 Rev 1 001040-04 Rev 2","2","2014-04-15 09:39:19","1487","4","Z2","2","2014-04-15 12:53:11","2","2014-04-15 15:26:41","0","0000-00-00 00:00:00","2","141913","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2124","2","0","5346877","2014-04-14","0","0","2014-04-15","16","","1","","Sanmina Saratoga Speed SSR-ASSY-000111-02 REV2.9 APERTURE COUNT","2","2014-04-15 09:39:54","5468","4","Z2","2","2014-04-15 13:01:14","2","2014-04-15 15:24:25","0","0000-00-00 00:00:00","2","141912","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2125","100","0","140200","2014-04-14","0","0","2014-04-15","16","","15","","Synergetics ARBITER LB0050200/ UB0050200A","2","2014-04-15 09:22:04","1277","6","18X18","2","2014-04-15 15:02:01","2","2014-04-15 15:31:04","0","0000-00-00 00:00:00","2","141901","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2126","6","0","739361","2014-04-14","0","1","2014-04-15","17","","1","","","2","2014-04-15 08:41:15","","","","2","2014-04-15 18:09:12","2","2014-04-15 18:13:30","2","2014-04-16 09:42:03","2","141939","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2127","6","0","739362","2014-04-14","0","0","2014-04-15","17","","1","","","2","2014-04-15 08:40:40","","","","2","2014-04-15 18:16:21","2","2014-04-16 09:41:53","2","2014-04-16 09:42:11","2","141939","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2128","2","0","5346879","2014-04-14","0","0","2014-04-15","17","","1","","Sanmina Alcatel 82-0587-02 Rev 02 APERTURE COUNT","2","2014-04-15 07:59:57","4290","4","Z2","2","2014-04-15 18:01:41","2","2014-04-15 19:14:03","0","0000-00-00 00:00:00","2","141917","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2129","2","0","5346878","2014-04-14","0","0","2014-04-15","17","","1","","Sanmina Alcatel 82-0587-02 Rev 02 APERTURE COUNT","2","2014-04-15 07:59:32","7234","5\\\\4","Z2","2","2014-04-16 13:13:23","2","2014-04-16 17:59:20","2","2014-04-17 07:48:48","2","141934","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2130","97","0","4792319","2014-04-14","1","0","2014-04-15","13","","1","","Surface Art Aptina Imaging AP34008 REV 0.1 J","2","2014-04-15 09:40:16","1210","5","18X19","2","2014-04-15 11:26:48","2","2014-04-15 13:27:25","2","2014-04-15 14:02:44","2","141908","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2131","1","0","8292565","2014-04-14","0","0","2014-04-15","17","","1","","iDSBG 920-3163-03","2","2014-04-14 22:15:03","3429","3","Z2","2","2014-04-15 15:17:31","2","2014-04-15 15:31:17","0","0000-00-00 00:00:00","2","141918","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2132","4","0","321808","2014-04-14","0","0","2014-04-16","14","","1","","Flextronics Cyan 800-0141-01-03 aperture count","2","2014-04-15 07:24:36","3689","5\\\\7","Z2","2","2014-04-16 11:32:45","2","2014-04-16 13:10:17","2","2014-04-16 15:28:11","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2133","4","0","321809","2014-04-14","0","0","2014-04-15","17","","1","","Flextronics Cyan 800-0141-01-03 aperture count","2","2014-04-15 07:57:44","3192","5","Z2","2","2014-04-15 12:38:15","2","2014-04-15 15:02:01","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2134","4","0","321810","2014-04-14","0","0","2014-04-16","8","","1","","Flextronics VIO-620-0184-00 VIO-610-0099-00 REV.01","2","2014-04-15 11:04:46","4902","7","Z3","2","2014-04-16 07:14:35","2","2014-04-16 07:15:30","2","2014-04-16 07:51:22","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2135","8","0","575393","2014-04-14","0","0","2014-04-16","8","","1","","Jabil Agilent Assy ST-N9020-63272-001-T N9020-20272_001","2","2014-04-15 08:42:07","8546","5","Z2","2","2014-04-16 11:39:53","2","2014-04-16 13:11:05","2","2014-04-16 13:12:17","2","141947","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2136","8","0","575394","2014-04-14","0","0","2014-04-16","8","","1","","Jabil Agilent Assy ST-N9020-63272-001-B  N9020-20272_001","2","2014-04-15 08:42:31","2906","5","Z2","2","2014-04-15 19:43:32","2","2014-04-15 19:51:26","2","2014-04-16 09:41:27","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2137","97","0","4792321","2014-04-15","1","0","2014-04-15","18","","1","","Surface Art Monsoon MPA01D J","2","2014-04-15 08:39:42","559","4","18X18","2","2014-04-15 09:30:36","2","2014-04-15 13:05:23","2","2014-04-15 13:59:33","2","141902","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2138","97","0","4792320","2014-04-15","0","0","2014-04-15","17","","1","","Surface Art Aptina Imaging AR2520 iBGA DEMO 3 REV 0. J","2","2014-04-15 08:35:53","455","5","18X18","2","2014-04-15 11:12:59","2","2014-04-15 13:28:25","2","2014-04-15 14:01:55","2","141909","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2139","72","0","1262738","2014-04-15","0","0","2014-04-15","18","","1","","Pactron Incorporated PAC3007_15April2014_ WO24899_B(Leaded)","2","2014-04-15 06:21:51","851","4","Z2","2","2014-04-15 17:57:08","2","2014-04-15 19:08:11","0","0000-00-00 00:00:00","2","141919","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2140","50","0","630335R","2014-04-15","0","0","2014-04-16","11","","1","","GOS-ME-1305003 \r\nCisco Simple Impact Board \r\nGOS-ME-1305003","2","2014-04-15 18:33:30","","","","2","2014-04-16 10:23:53","2","2014-04-16 11:34:52","2","2014-04-16 13:12:37","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2141","20","0","938677","2014-04-15","0","0","2014-04-16","16","","15","","Ascentron IDD AEROSPACE 520-000019-300 P/N 790-2526","2","2014-04-15 21:24:05","572","5","18X18","2","2014-04-16 14:34:57","2","2014-04-16 16:06:05","0","0000-00-00 00:00:00","2","141951","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2142","20","0","938678","2014-04-15","0","0","2014-04-16","16","","15","","Ascentron IDD AEROSPACE 520-000019-300 P/N 790-2527","2","2014-04-15 21:24:49","572","5","18X18","2","2014-04-16 14:16:25","2","2014-04-16 16:06:13","0","0000-00-00 00:00:00","2","141951","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2143","70","0","1105129","2014-04-15","0","0","2014-04-16","8","","1","","Oncore TTHF 112156-00@A01 TOP SIDE","2","2014-04-15 18:46:26","1276","4","Z2","2","2014-04-15 19:51:08","2","2014-04-15 21:59:12","2","2014-04-25 10:10:46","2","142157","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2144","4","0","321811","2014-04-15","1","0","2014-04-16","16","","1","","Flextronics INTEL CR DOLLAR LAKE  TI PMIC AOB FAB B FAB: H31320-002","2","2014-04-15 16:00:26","1824","6/3","Z2","2","2014-04-16 16:59:04","2","2014-04-16 18:59:52","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2145","4","0","321812","2014-04-15","1","0","2014-04-16","16","","1","","Flextronics INTEL CR DOLLAR LAKE TI PMIC AOB FAB B FAB: H31320-002","2","2014-04-15 15:59:57","1536","6/3","Z2","2","2014-04-16 16:54:52","2","2014-04-16 19:00:02","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2146","97","0","4792322","2014-04-15","1","0","2014-04-15","14","","1","","","2","2014-04-15 11:35:01","","","","2","2014-04-15 13:58:31","2","2014-04-15 17:50:14","0","0000-00-00 00:00:00","2","141914","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2147","43","0","5413966","2014-04-15","0","0","2014-04-16","11","","1","","Infiniti Solutions L.S.Research SUT01 Rev B Job","2","2014-04-15 21:50:56","1105","4","Z2","2","2014-04-16 10:47:50","2","2014-04-16 12:28:07","2","2014-04-16 13:12:31","2","141946","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2148","43","0","5413967","2014-04-15","0","0","2014-04-16","11","","1","","Infiniti Solutions Xepto POWER BD Rev C Job","2","2014-04-15 21:44:46","1258","4","Z2","2","2014-04-16 10:38:14","2","2014-04-16 13:09:10","2","2014-04-16 13:12:25","2","141949","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2149","10","0","2392885R","2014-04-15","0","0","2014-04-21","17","","1","","ASteelFlash E-BAND COMMUNICATION 200-0130-002 Rev: F","2","2014-04-21 10:52:35","1235","6/5","Z2","2","2014-04-21 17:04:09","2","2014-04-21 18:29:53","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2150","8","0","575382R","2014-04-15","1","0","2014-04-15","14.3","","1","","","2","2014-04-15 13:18:02","2406","5","Z2","2","2014-04-15 14:02:33","2","2014-04-15 15:01:20","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2151","8","0","575381R","2014-04-15","1","0","2014-04-15","15","","1","","","2","2014-04-15 13:18:23","6394","5","Z2","2","2014-04-15 14:27:10","2","2014-04-15 15:01:33","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2152","10","0","2392972","2014-04-15","1","1","2014-04-16","14","","1","","","1","2014-04-15 14:03:22","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2153","10","0","2392973","2014-04-15","1","1","2014-04-16","14","","1","","","1","2014-04-15 14:03:11","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2154","3","0","5632156.","2014-04-15","0","0","2014-04-16","19.3","","5","","Intel Corporation Kool Corner TMTV PB","2","2014-04-16 09:16:56","6152","5","","2","2014-04-16 17:43:56","2","2014-04-16 18:49:13","0","0000-00-00 00:00:00","2","141954","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2155","3","0","5632149f","2014-04-15","1","0","2014-04-15","19.3","","4","","","2","2014-04-15 14:00:11","","","","2","2014-04-15 19:44:57","2","2014-04-15 19:45:28","0","0000-00-00 00:00:00","2","141923/24/25","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2156","110","0","952388","2014-04-15","0","0","2014-04-16","17","","15","","Unitron IRI 12022-020 Rev_B","2","2014-04-16 12:16:22","1418","5","18X18","2","2014-04-16 14:01:17","2","2014-04-16 16:09:19","0","0000-00-00 00:00:00","2","141957","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2157","1","0","8292566","2014-04-15","1","0","2014-04-16","9","","1","","Foxconn-iDSBG iDSBG 920-4436-03","2","2014-04-15 15:29:23","2535","3","Z2","2","2014-04-15 19:12:32","2","2014-04-15 20:31:19","2","2014-04-16 07:51:09","2","141933","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2158","110","0","952389","2014-04-15","0","0","2014-04-16","17","","15","","Unitron IRI PN 10392-010 Rev_N","2","2014-05-02 08:05:46","1513","5","18X18","2","2014-05-02 10:02:44","2","2014-05-02 14:23:15","0","0000-00-00 00:00:00","2","142290","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2159","93","0","2532140","2014-04-15","0","0","2014-04-16","14","","1","","SMTC LeCroy 923802-00 RevB Fab","2","2014-04-16 05:41:33","3854","4","Z2","2","2014-04-16 05:39:57","2","2014-04-16 17:49:16","0","0000-00-00 00:00:00","2","141963","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2160","93","0","2532141","2014-04-15","0","0","2014-04-16","14","","1","","SMTC LeCroy 923802-00 RevB Fab","2","2014-04-16 05:41:04","3041","4","Z2","2","2014-04-16 13:53:45","2","2014-04-16 17:49:23","0","0000-00-00 00:00:00","2","141963","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2161","29","0","919107","2014-04-15","0","0","2014-04-16","15","","1","","CBA Electronics Corp Adamant Tech.","2","2014-04-16 06:30:23","1170","5","Foil Only","2","2014-04-16 11:46:12","2","2014-04-16 12:11:56","0","0000-00-00 00:00:00","2","141948","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2162","10","0","2392974","2014-04-15","0","1","2014-04-16","14","","1","","ASteelFlash Anritu 3-80518-3P1ANR","1","2014-04-15 15:35:56","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2163","10","0","2392975","2014-04-15","0","1","2014-04-16","14","","1","","","1","2014-04-15 15:34:32","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2164","51","0","9931390","2014-04-15","1","0","2014-04-16","10","","1","","Javad Javad 05-610201-01 Rev 8.1","2","2014-04-15 19:14:52","163","5","18X18","2","2014-04-15 20:44:05","2","2014-04-15 21:59:34","2","2014-04-16 07:52:01","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2165","51","0","9931391","2014-04-15","1","0","2014-04-16","10","","1","","Javad Javad 05-610201-01 Rev 8.1","2","2014-04-15 19:15:13","1035","5","18X18","2","2014-04-15 20:23:15","2","2014-04-15 21:59:24","2","2014-04-16 07:52:10","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2166","59","0","343312","2014-04-15","1","0","2014-04-16","9","","1","","","2","2014-04-15 19:03:09","1898","4","18X19","2","2014-04-15 21:45:26","2","2014-04-16 07:42:18","2","2014-04-16 07:51:44","2","141938","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2167","59","0","343313","2014-04-15","1","0","2014-04-16","9","","1","","","2","2014-04-15 19:03:29","806","4","18X18","2","2014-04-15 20:37:40","2","2014-04-15 21:59:49","2","2014-04-16 07:51:50","2","141938","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2168","34","0","7994767","2014-04-15","0","0","2014-04-16","17","","1","","Creation Tech. Alcatel ALC76-0692-02 Rev 02 TALCS238_LF","2","2014-04-16 06:30:59","42279","5","Z2","2","2014-04-16 21:14:02","2","2014-04-16 22:00:55","2","2014-04-17 07:49:46","2","141959","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2169","34","0","7994768","2014-04-15","0","0","2014-04-16","17","","1","","Creation Tech. Alcatel ALC76-0692-02 Rev 02 TALCS238_LF","2","2014-04-16 06:31:28","31186","5","Z2","2","2014-04-16 14:57:28","2","2014-04-16 17:37:10","2","2014-04-17 12:32:58","2","141958","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2170","97","0","4792323","2014-04-15","0","0","2014-04-16","17","","1","","Surface Art Monsoon J","2","2014-04-16 06:16:44","2113","4","18X18","2","2014-04-16 14:24:55","2","2014-04-16 17:30:38","2","2014-04-17 07:49:16","2","141952","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2171","4","0","321813","2014-04-16","0","0","2014-04-17","8","","1","","Flextronics F5 Networks  PCA-0375-M0","2","2014-04-16 06:17:16","2762","5","Z2","2","2014-04-16 16:29:33","2","2014-04-16 19:04:59","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2172","63","0","169007","2014-04-16","0","0","2014-04-17","8","","1","","Mosaic Industries, Inc QED4 board qed4rev3","2","2014-04-16 05:42:36","597","6","18X18","2","2014-04-16 15:28:17","2","2014-04-16 17:24:55","2","2014-04-17 10:24:33","2","141961","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2173","72","0","1262740","2014-04-16","0","0","2014-04-16","18","","1","","Pactron Incorporated PAC3010_16April2014_ WO24831_B(Leaded)","2","2014-04-16 06:17:58","1510","4","Fuji5000","2","2014-04-16 15:48:56","2","2014-04-16 18:28:18","0","0000-00-00 00:00:00","2","141962","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2174","72","0","1262741","2014-04-16","0","0","2014-04-16","18","","1","","Pactron Incorporated PAC3012_16April2014_ WO24814_T","2","2014-04-16 07:30:41","651","4","Z2","2","2014-04-16 15:38:16","2","2014-04-16 18:15:29","0","0000-00-00 00:00:00","2","141956","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2175","43","0","5413968","2014-04-16","0","0","2014-04-17","8","","1","","Infiniti Solutions Job","2","2014-04-16 09:35:02","235","5","Z2","2","2014-04-16 18:20:32","2","2014-04-16 20:19:04","2","2014-04-17 07:49:54","2","141955","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2176","88","0","6092051","2014-04-16","0","0","2014-04-17","16","","11","","","2","2014-04-16 14:23:50","2792","5","Z2","2","2014-04-17 08:09:46","2","2014-04-17 12:15:18","0","0000-00-00 00:00:00","2","141977","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2177","9","0","2814037","2014-04-16","1","0","2014-04-16","18","","1","","","2","2014-04-16 10:33:57","811","5","Z2","2","2014-04-16 14:05:06","2","2014-04-16 19:12:40","2","2014-04-17 07:50:25","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2178","97","0","4792324","2014-04-16","0","0","2014-04-17","9","","1","","Surface Art Apple Lucifer 2","2","2014-04-18 13:27:18","1274","4","18X18","2","2014-04-18 15:06:42","2","2014-04-18 16:19:26","0","0000-00-00 00:00:00","2","142017","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2179","4","0","321814","2014-04-16","0","0","2014-04-17","10","","1","","","2","2014-04-16 12:16:38","663","5","Z2","2","2014-04-16 19:00:18","2","2014-04-16 20:47:00","2","2014-04-17 07:50:36","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2180","51","0","9931354F","2014-04-16","0","0","2014-04-16","18","","1","","","2","2014-04-16 12:54:08","","","","2","2014-04-16 18:15:47","2","2014-04-16 19:19:10","2","2014-04-17 07:50:13","0","","2","9","2014-04-16 16:59:23","2","1");
INSERT INTO tbl_jobs VALUES("2181","70","0","1105130","2014-04-16","0","0","2014-04-17","18","","1","","","2","2014-04-16 14:07:38","1372","5","Z2","2","2014-04-17 09:54:01","2","2014-04-17 12:58:23","2","2014-04-18 07:51:10","2","141997","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2182","22","0","3474279R","2014-04-16","1","0","2014-04-16","19.3","","3","","","2","2014-04-16 13:58:44","403","6","Foil Only","2","2014-04-16 16:24:38","2","2014-04-16 16:45:07","0","0000-00-00 00:00:00","2","141950","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2183","7","0","9991848","2014-04-16","0","0","2014-04-17","13","","1","","SEM HE MICROPROBE TTF-0762D","2","2014-04-17 13:09:02","2436","8","Foil Only","2","2014-04-17 15:00:21","2","2014-04-17 16:44:47","2","2014-04-18 07:46:32","2","141991","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2184","1","0","8292567","2014-04-16","0","0","2014-04-17","13","","1","","IDSBG 920-00236-01","2","2014-04-16 15:09:28","179","3","Z2","2","2014-04-16 20:14:01","2","2014-04-16 21:00:54","2","2014-04-17 07:51:35","2","141975","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2185","3","0","5632155","2014-04-16","1","0","2014-04-16","19.3","","4","","","2","2014-04-16 13:50:34","","","","2","2014-04-16 17:44:11","2","2014-04-16 18:50:28","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2186","31","0","7582270","2014-04-16","0","0","2014-04-17","16","","8","","","2","2014-04-16 15:10:22","1534","5","18X18","2","2014-04-17 08:18:03","2","2014-04-17 12:10:52","0","0000-00-00 00:00:00","2","141979","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2187","97","0","4792325","2014-04-16","0","0","2014-04-17","15","","1","","","2","2014-04-17 13:48:07","1122","5","18X18","2","2014-04-17 15:54:38","2","2014-04-17 16:44:28","2","2014-04-18 07:47:11","2","141994","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2188","97","0","4792326","2014-04-16","0","0","2014-04-17","15","","1","","","2","2014-04-17 13:48:44","378","4","18X18","2","2014-04-17 15:46:53","2","2014-04-17 16:44:39","2","2014-04-18 07:46:51","2","141994","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2189","4","0","321815","2014-04-16","0","0","2014-04-17","15","","1","","","2","2014-04-16 15:53:47","484","5","Z2","2","2014-04-16 19:50:04","2","2014-04-16 21:04:07","2","2014-04-17 07:50:51","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2190","41","0","832740","2014-04-16","0","0","2014-04-17","10","","1","","LDI_7479_R2_LED_BRD","2","2014-04-17 03:52:34","6","4","Foil Only","2","2014-04-17 08:24:10","2","2014-04-17 09:05:30","2","2014-04-17 09:32:29","2","141978","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2191","38","0","916111","2014-04-16","1","0","2014-04-17","14","","1","","","2","2014-04-17 03:53:10","4241","5","Fuji4000","2","2014-04-17 10:01:04","2","2014-04-17 12:26:42","2","2014-04-17 12:33:14","2","141982","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2192","38","0","916112","2014-04-16","1","0","2014-04-17","14","","1","","","2","2014-04-17 03:53:35","8577","5","Fuji4000","2","2014-04-17 10:46:23","2","2014-04-17 12:26:49","2","2014-04-17 12:33:22","2","141982","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2193","4","0","321816","2014-04-16","0","0","2014-04-17","17","","1","","","2","2014-04-17 18:21:59","","","","2","2014-04-17 18:22:07","2","2014-04-17 19:02:56","2","2014-04-18 07:48:14","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2194","1","0","8292568","2014-04-16","1","0","2014-04-17","9","","1","","Foxconn-iDSBG iDSBG 920-4436-03","2","2014-04-16 22:12:23","1584","3","Z2","2","2014-04-17 10:56:21","2","2014-04-17 12:04:50","2","2014-04-17 12:33:04","2","141984","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2195","70","0","1105131","2014-04-16","0","0","2014-04-18","8","","1","","Oncore TTHF 97055-61012@F TOP SIDE","2","2014-04-17 11:08:41","4436","5","Z2","2","2014-04-17 14:04:25","2","2014-04-17 18:23:25","2","2014-04-23 08:06:22","2","142089","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2196","70","0","1105132","2014-04-16","0","0","2014-04-18","8","","1","","Oncore TTHF 97055-61012@F BOTTOM SIDE","2","2014-04-17 11:09:00","1518","5","Z2","2","2014-04-17 14:13:43","2","2014-04-17 18:23:34","2","2014-04-25 10:10:56","2","142158","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2197","4","0","321817","2014-04-16","0","0","2014-04-18","12","","1","","Flextronics Cavium EBA-RXAUI-RJ45-22MM-01 EBA-RXAUI-RJ45-40MM-01","2","2014-04-17 12:49:53","1296","5","Z2","2","2014-04-18 18:36:08","2","2014-04-18 19:22:41","2","2014-04-21 08:20:43","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2198","4","0","321818","2014-04-16","0","0","2014-04-18","12","","1","","Flextronics Cavium EBA-RXAUI-RJ45-22MM-01 EBA-RXAUI-RJ45-40MM-01","2","2014-04-17 12:50:11","568","5","Z2","2","2014-04-18 18:00:29","2","2014-04-18 19:04:54","2","2014-04-21 08:20:36","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2199","38","0","916113","2014-04-16","0","0","2014-04-18","8","","1","","Green Circuits ICE 3433 SMT","2","2014-04-17 04:03:07","313","5","Z2","2","2014-04-17 11:26:58","2","2014-04-17 16:44:12","2","2014-04-18 07:47:56","2","141983","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2200","38","0","916114","2014-04-16","0","0","2014-04-18","8","","1","","Green Circuits ICE 3433 SMT","2","2014-04-17 04:03:28","7203","5","Z2","2","2014-04-17 11:17:34","2","2014-04-17 16:36:31","2","2014-04-18 07:47:29","2","141983","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2201","11","0","102096","2014-04-16","0","0","2014-04-18","8","","1","","Zollner Electronics Advantest 1699139-03/1710796-02 G8001-26513","2","2014-04-17 11:06:24","1031","5","Z2","2","2014-04-17 16:13:29","2","2014-04-17 19:03:12","2","2014-04-21 15:14:57","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2202","11","0","102097","2014-04-16","0","0","2014-04-18","8","","1","","Zollner Electronics Advantest 1699139-03/1710796-02 G8001-26513","2","2014-04-17 11:06:48","1161","5","Z2","2","2014-04-17 14:51:59","2","2014-04-17 19:03:06","2","2014-04-21 15:17:12","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2203","70","0","1105133","2014-04-17","0","0","2014-04-18","8","","1","","OnCore Fremont TICS150691@H 130036 Rev B","2","2014-04-18 09:57:09","2059","5","Z2","2","2014-04-18 11:38:01","2","2014-04-18 14:55:21","0","0000-00-00 00:00:00","2","141987","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2204","70","0","1105134","2014-04-17","0","0","2014-04-18","8","","1","","OnCore Fremont TICS150691@H 130036 Rev B","2","2014-04-18 09:57:29","2160","5","Z2","2","2014-04-18 11:33:07","2","2014-04-18 14:55:40","0","0000-00-00 00:00:00","2","141987","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2205","11","0","102098","2014-04-17","0","0","2014-04-18","8","","1","","Zollner Electronics Advantest 1699138-05 G8001-26511","2","2014-04-17 11:07:27","5605","5","Z2","2","2014-04-17 16:27:21","2","2014-04-17 19:03:01","2","2014-04-21 15:13:06","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2206","11","0","102099","2014-04-17","0","0","2014-04-18","8","","1","","Zollner Electronics Advantest 1699138-05 G8001-26511","2","2014-04-17 11:07:45","1431","5","Z2","2","2014-04-17 13:36:07","2","2014-04-17 14:40:21","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2207","72","0","1262742","2014-04-17","1","0","2014-04-17","13","","1","","Pactron Incorporated PAC3013_17April2014_ WO24825_T","2","2014-04-17 06:07:24","17616","4","Z2","2","2014-04-17 13:10:47","2","2014-04-17 14:49:06","0","0000-00-00 00:00:00","2","141990","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2208","72","0","1262743","2014-04-17","1","0","2014-04-17","13","","1","","Pactron Incorporated PAC3014_17April2014_ WO24958_T","2","2014-04-17 06:33:22","1757","4","Z2","2","2014-04-17 11:06:26","2","2014-04-17 12:47:41","2","2014-04-17 13:05:49","2","141981","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2209","72","0","1262744","2014-04-17","0","0","2014-04-17","18","","1","","Pactron Incorporated PAC3015_17April2014_ WO24868_T","2","2014-04-17 06:34:01","2856","4","Z2","2","2014-04-17 10:41:46","2","2014-04-17 12:55:53","2","2014-04-17 13:06:05","2","141985","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2210","11","0","102100","2014-04-17","1","0","2014-04-17","13","","1","","","2","2014-04-17 12:19:16","2335","5","Z2","2","2014-04-17 13:11:24","2","2014-04-17 14:40:10","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2211","40","0","807077R","2014-04-17","1","0","2014-04-18","18","","5","","","2","2014-04-17 10:24:29","","","","2","2014-04-17 17:42:25","2","2014-04-17 17:42:29","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2212","57","0","767134","2014-04-17","1","0","2014-04-18","16","","10","","","2","2014-04-18 09:56:13","17928","4","Foil Only","2","2014-04-18 16:56:05","2","2014-04-18 19:01:25","0","0000-00-00 00:00:00","2","142007","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2213","11","0","102101","2014-04-17","0","0","2014-04-18","10","","1","","Zollner Electronics SANDISK 1790880-00","2","2014-04-17 14:48:30","","","","2","2014-04-17 18:28:59","2","2014-04-17 18:34:34","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2214","7","0","9991849","2014-04-17","1","0","2014-04-17","16","","1","","","2","2014-04-17 12:31:55","322","6","Z1","2","2014-04-17 13:56:01","2","2014-04-17 14:33:59","2","2014-04-18 11:48:49","2","141989","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2215","7","0","9991850","2014-04-17","1","0","2014-04-17","16","","1","","","2","2014-04-17 12:32:11","1928","6","Z1","2","2014-04-17 13:48:57","2","2014-04-17 14:34:06","2","2014-04-18 11:48:56","2","141989","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2216","8","0","575358R","2014-04-17","0","0","2014-04-18","12","","1","","","2","2014-04-18 10:07:23","18570","5","Z2","2","2014-04-18 14:33:19","2","2014-04-18 16:49:05","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2217","97","0","4792327","2014-04-17","1","0","2014-04-18","13","","1","","Surface Art Aptina Imaging AP40009 REV 0 J","2","2014-04-18 12:49:11","4123","4","18X19","2","2014-04-18 14:59:21","2","2014-04-18 16:24:13","0","0000-00-00 00:00:00","2","142018","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2218","97","0","4792328","2014-04-17","1","0","2014-04-18","13","","1","","Surface Art Aptina Imaging AP40011 REV 0 J","2","2014-04-18 12:49:29","3283","4","18X19","2","2014-04-18 14:34:25","2","2014-04-18 14:55:50","0","0000-00-00 00:00:00","2","142015","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2219","8","0","575400","2014-04-17","0","0","2014-04-22","17","","1","","Jabil Circuit Grass Valley ST-GD771065700-R01-T GD399065700 rev R01","2","2014-04-22 13:50:30","2373","5","Z2","2","2014-04-22 15:13:14","2","2014-04-22 17:32:36","2","2014-04-23 10:44:07","2","142093","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2220","8","0","575401","2014-04-17","0","0","2014-04-22","17","","1","","Jabil Circuit Grass Valley ST-GD771065700-R01-B GD399065700 rev R01","2","2014-04-22 13:51:11","1470","5","Z2","2","2014-04-22 15:32:17","2","2014-04-22 17:31:48","2","2014-04-23 10:44:17","2","142093","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2221","9","0","2814026F","2014-04-17","0","0","2014-04-18","16","","1","","","2","2014-04-18 09:08:45","","","","2","2014-04-18 18:17:41","2","2014-04-18 19:22:14","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2222","9","0","2814039","2014-04-17","1","0","2014-04-18","9","","1","","","2","2014-04-17 17:11:34","","","","2","2014-04-17 18:28:54","2","2014-04-17 18:34:24","2","2014-04-18 07:50:36","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2223","54","0","914618","2014-04-17","0","0","2014-04-18","15","","1","","Marvell Semiconductor Project Dean 200652","2","2014-04-18 07:59:34","1112","5","Foil Only","2","2014-04-18 12:29:21","2","2014-04-18 12:35:33","0","0000-00-00 00:00:00","2","142004","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2224","34","0","7994769","2014-04-17","0","0","2014-04-18","15","","1","","Creation Tech. GATAN Fab","2","2014-04-18 09:14:20","3006","5","Z2","2","2014-04-18 12:20:04","2","2014-04-18 14:56:14","2","2014-04-21 07:56:54","2","142005","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2225","70","0","1105135","2014-04-17","0","0","2014-04-21","15","","1","","Oncore TTHF 97355-61060Rev G","2","2014-04-21 09:01:58","3625","5","Z2","2","2014-04-21 11:12:19","2","2014-04-21 13:38:56","2","2014-04-23 08:06:29","2","142087","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2226","70","0","1105136","2014-04-17","0","0","2014-04-21","15","","1","","Oncore TTHF 97355-61060Rev G","2","2014-04-21 09:00:36","1694","6","Z2","2","2014-04-21 11:50:11","2","2014-04-21 13:38:43","2","2014-04-23 08:06:35","2","142087","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2227","97","0","4792329","2014-04-17","0","0","2014-04-18","15","","1","","Surface Art Pelco PA07-0151-00 REV X0 J","2","2014-04-18 09:13:27","2964","5","18X19","2","2014-04-18 12:36:36","2","2014-04-18 14:54:47","0","0000-00-00 00:00:00","2","142003","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2228","1","0","8292569","2014-04-17","0","0","2014-04-18","15","","1","","","2","2014-04-18 08:31:06","34170","3","Z2","2","2014-04-18 18:17:24","2","2014-04-18 18:57:53","0","0000-00-00 00:00:00","2","142008","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2229","7","0","9991849R","2014-04-17","1","0","2014-04-18","10","","1","","","1","2014-04-17 16:04:51","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2230","7","0","9991850R","2014-04-17","1","0","2014-04-18","10","","1","","","1","2014-04-17 16:04:41","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2231","51","0","9931393","2014-04-17","0","0","2014-04-18","16","","1","","Javad 05-610074-01 Rev 2.1","2","2014-04-18 09:15:08","840","4","18X18","2","2014-04-18 17:57:31","2","2014-04-18 19:20:05","2","2014-04-21 08:20:13","0","","2","10","2014-04-18 14:06:52","2","1");
INSERT INTO tbl_jobs VALUES("2232","2","0","5346880","2014-04-17","0","0","2014-04-18","16","","1","","","2","2014-04-18 08:59:41","2656","5","Z2","2","2014-04-18 13:31:16","2","2014-04-18 14:50:23","0","0000-00-00 00:00:00","2","142011","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2233","3","0","5632158","2014-04-17","0","0","2014-04-18","19.3","","5","","Intel Corporation Trace Openings Sample A","2","2014-04-18 11:41:36","","","","2","2014-04-18 18:17:30","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","142014","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2234","1","0","8292570","2014-04-17","0","0","2014-04-21","16","","1","","Foxconn-iDSBG iDSBG 920-00248-01","2","2014-04-18 08:39:40","1367","5\\\\3","Z2","2","2014-04-21 17:06:38","2","2014-04-21 18:22:35","0","0000-00-00 00:00:00","2","142037","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2235","51","0","9931394","2014-04-17","1","0","2014-04-18","8","","1","","Javad Javad 05-610214-01 Rev 3.1","2","2014-04-17 17:31:21","","","","2","2014-04-17 18:29:08","2","2014-04-17 19:02:32","2","2014-04-18 07:50:08","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2236","84","0","222089","2014-04-17","0","0","2014-04-22","15","","1","","Rocket EMS Incorporated Cadence Logic Board ML-5020F","2","2014-04-21 13:08:27","36964","4/3","Z3","2","2014-04-22 20:54:28","2","2014-04-22 21:29:31","2","2014-04-23 07:45:47","2","142044","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2237","84","0","222090","2014-04-17","0","0","2014-04-22","15","","1","","Rocket EMS Incorporated Cadence Logic Board ML-5020F","2","2014-04-21 13:09:01","17560","4/3","Z3","2","2014-04-23 15:38:07","2","2014-04-23 16:21:56","0","0000-00-00 00:00:00","2","142043","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2238","8","0","575402","2014-04-17","0","0","2014-04-23","10","","1","","Jabil Circuit Grass Valley ST-GD771062600-R04-T GD399062601 rev R01","2","2014-04-22 16:40:11","31634","5","Z2","2","2014-04-23 10:56:29","2","2014-04-23 14:17:49","2","2014-04-25 12:11:59","2","142160","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2239","8","0","575T402","2014-04-17","0","0","2014-04-22","14","","1","","","2","2014-04-18 08:18:50","","","","2","2014-04-21 15:13:28","2","2014-04-22 07:17:52","2","2014-04-25 12:11:51","2","142160","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2240","8","0","575403","2014-04-17","0","0","2014-04-22","17","","1","","Jabil Circuit Grass Valley ST-GD771062500-R07-T GD399062501 rev R01","2","2014-04-22 14:03:45","13498","5","Z2","2","2014-04-22 17:30:15","2","2014-04-23 07:30:37","2","2014-04-23 10:45:11","2","142092","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2241","8","0","575T403","2014-04-17","0","0","2014-04-22","14","","1","","","2","2014-04-18 08:19:00","","","","2","2014-04-21 15:13:16","2","2014-04-22 07:17:43","2","2014-04-23 10:45:38","2","142092","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2242","8","0","575404","2014-04-17","0","0","2014-04-22","17","","1","","","2","2014-04-22 14:05:31","3741","4","Z2","2","2014-04-22 15:23:29","2","2014-04-22 17:32:49","2","2014-04-23 10:44:59","2","142092","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2243","8","0","575T404","2014-04-17","0","0","2014-04-22","14","","1","","","2","2014-04-18 08:19:11","","","","2","2014-04-21 15:13:21","2","2014-04-22 07:17:48","2","2014-04-23 10:45:24","2","142092","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2244","70","0","1105137","2014-04-18","0","0","2014-04-21","11","","1","","Oncore TTHF 97355-61030@B TOP SIDE","2","2014-04-18 13:28:10","3402","5","Z2","2","2014-04-21 09:20:44","2","2014-04-21 12:33:25","2","2014-04-23 08:06:42","2","142088","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2245","41","0","832741","2014-04-18","0","0","2014-04-18","13","","1","","AMI_49BO50304G/49BO50307E JET_700184_01/LDI6020-A LDI_7050_A2_PANEL 50","2","2014-04-18 09:17:36","783","6","Foil Only","2","2014-04-18 13:48:44","2","2014-04-18 14:54:59","0","0000-00-00 00:00:00","2","142012","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2246","8","0","575T400","2014-04-18","0","0","2014-04-22","14","","1","","","2","2014-04-18 09:07:33","","","","2","2014-04-21 15:13:11","2","2014-04-22 07:17:34","2","2014-04-23 10:44:30","2","142093","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2247","8","0","575T401","2014-04-18","0","0","2014-04-22","14","","1","","","2","2014-04-18 09:07:17","","","","2","2014-04-21 15:13:03","2","2014-04-22 07:17:39","2","2014-04-23 10:44:23","2","142093","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2248","41","0","832742","2014-04-18","0","0","2014-04-18","13","","1","","LDI_7050_A2_PANEL 50  LDI_7989-2 LDI_7990-2","2","2014-04-18 09:16:53","2603","6","Foil Only","2","2014-04-18 19:14:21","2","2014-04-18 19:22:33","2","2014-04-21 08:20:22","2","142009","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2249","104","0","559706","2014-04-18","0","0","2014-04-22","20","","8","","Tektronix  802-2721-09","2","2014-04-21 15:11:58","116","8/5","Z2","2","2014-04-22 15:41:41","2","2014-04-22 16:44:53","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2250","72","0","1262745","2014-04-18","1","0","2014-04-18","13","","1","","Pactron Incorporated PAC3017_17April2014_ WO24873_T","2","2014-04-18 07:50:35","1921","4","Z2","2","2014-04-18 10:52:10","2","2014-04-18 12:56:33","2","2014-04-18 13:27:02","2","142000","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2251","72","0","1262746","2014-04-18","0","0","2014-04-18","18","","1","","Pactron Incorporated PAC3018_18April2014_ WO24976_T","2","2014-04-18 07:53:44","902","4","Z2","2","2014-04-18 17:10:53","2","2014-04-18 19:21:16","0","0000-00-00 00:00:00","2","142010","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2252","72","0","1262747","2014-04-18","0","0","2014-04-18","18","","1","","Pactron Incorporated PAC3019_18April2014_ WO24764_T","2","2014-04-18 07:54:50","2160","4","Z2","2","2014-04-18 17:32:28","2","2014-04-18 19:21:27","0","0000-00-00 00:00:00","2","142006","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2253","67","0","981113","2014-04-18","0","1","2014-04-21","8","","1","","","2","2014-04-21 04:12:01","589","4","Z2","2","2014-04-21 09:29:31","2","2014-04-21 10:36:24","2","2014-04-22 07:43:05","2","142053","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2254","20","0","938679","2014-04-18","0","0","2014-04-21","16","","15","","","2","2014-04-18 14:12:33","758","6","18X18","2","2014-04-21 09:49:08","2","2014-04-21 14:29:39","0","0000-00-00 00:00:00","2","142023","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2255","20","0","938680","2014-04-18","0","0","2014-04-21","16","","15","","","2","2014-04-18 14:12:17","1268","6","18X18","2","2014-04-21 09:59:01","2","2014-04-21 14:29:50","0","0000-00-00 00:00:00","2","142023","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2256","8","0","575405","2014-04-18","0","0","2014-04-21","18","","1","","","2","2014-04-21 04:16:12","","","","2","2014-04-21 16:46:55","2","2014-04-21 20:08:02","0","0000-00-00 00:00:00","2","142027","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2257","7","0","9991853","2014-04-18","0","0","2014-04-21","10","","1","","SEM HE MT GMBH SEAGULLUP4x2 Apt Count =","2","2014-04-21 08:51:35","1465","8","Z1","2","2014-04-21 11:01:54","2","2014-04-21 11:25:27","2","2014-04-21 11:25:50","2","142028","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2258","6","0","739363","2014-04-18","0","1","2014-04-21","9","","1","","","2","2014-04-18 14:10:41","","","","2","2014-04-21 09:01:51","2","2014-04-21 11:44:45","2","2014-04-21 12:42:16","2","142029","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2259","8","0","575406","2014-04-18","0","0","2014-04-22","15","","1","","Jabil Mcafee MC500-1129-01-1","2","2014-04-22 08:30:57","3828","5","Z2","2","2014-04-22 11:36:17","2","2014-04-22 13:51:36","2","2014-04-22 13:54:27","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2260","8","0","575407","2014-04-18","0","0","2014-04-22","15","","1","","","2","2014-04-22 08:31:18","1966","5","Z2","2","2014-04-22 10:48:10","2","2014-04-22 13:51:52","2","2014-04-22 13:54:36","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2261","8","0","575408","2014-04-18","0","0","2014-04-21","15","","1","","","2","2014-04-21 09:47:46","790","4","Z2","2","2014-04-21 16:12:50","2","2014-04-21 17:47:03","2","2014-04-22 10:56:10","2","142061","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2262","76","0","173033","2014-04-18","0","0","2014-04-21","12","","1","","Piranha EMS, Inc Purewave 181-00819-002","2","2014-04-21 08:59:33","708","4","Z2","2","2014-04-21 11:32:08","2","2014-04-21 11:44:23","0","0000-00-00 00:00:00","2","142024","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2263","8","0","575409","2014-04-18","0","0","2014-04-22","12","","1","","Jabil Circuit Virtual Instruments  ST-VT106-102143-01-05-T","2","2014-04-21 12:16:53","7925","5","Z2","2","2014-04-21 18:41:15","2","2014-04-21 21:27:06","2","2014-04-23 10:44:42","2","142091","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2264","70","0","1105138","2014-04-18","0","0","2014-04-21","14","","1","","OnCore Fremont TCLN 1463325FM","2","2014-04-21 09:37:54","2171","5","Z2","2","2014-04-21 11:20:38","2","2014-04-21 13:45:34","0","0000-00-00 00:00:00","2","142030","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2265","51","0","9931395","2014-04-18","0","0","2014-04-21","14","","1","","Javad Javad 05-610073-01 Rev 2.1","2","2014-04-21 12:15:57","1472","4","18X18","2","2014-04-21 14:55:18","2","2014-04-21 19:40:08","0","0000-00-00 00:00:00","0","","2","11","2014-04-21 13:35:15","2","1");
INSERT INTO tbl_jobs VALUES("2266","22","0","3474286","2014-04-18","1","0","2014-04-21","16","","4","","Axiom Electronics Spectralux Connector Card 901767048 STP000847","2","2014-04-21 08:50:40","15","6","Foil Only","2","2014-04-21 14:03:43","2","2014-04-21 14:27:37","0","0000-00-00 00:00:00","2","142034","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2267","70","0","1105139","2014-04-18","0","0","2014-04-21","16","","1","","Oncore TTHF 97355-61040","2","2014-04-21 15:29:23","1236","5","Z2","2","2014-04-21 17:15:44","2","2014-04-21 21:25:35","2","2014-04-25 10:10:22","2","142155","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2268","70","0","1105140","2014-04-18","0","0","2014-04-21","16","","1","","Oncore TTHF 97355-61040","2","2014-04-21 15:29:51","592","5","Z2","2","2014-04-21 17:18:03","2","2014-04-21 21:02:17","2","2014-04-25 10:10:29","2","142155","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2269","97","0","4792330","2014-04-18","1","0","2014-04-21","12","","1","","Surface Art Oculus J","2","2014-04-21 08:30:09","4966","4","Z3","2","2014-04-21 09:38:36","2","2014-04-21 11:25:00","2","2014-04-21 11:25:43","2","142022","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2270","99","0","148078","2014-04-18","0","0","2014-04-21","14","","1","","","2","2014-04-21 04:17:49","","","","2","2014-04-21 14:22:25","2","2014-04-21 16:48:16","0","0000-00-00 00:00:00","2","142036","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2271","99","0","148079","2014-04-18","0","0","2014-04-21","14","","1","","","2","2014-04-21 04:18:01","","","","2","2014-04-21 14:22:32","2","2014-04-21 16:47:53","0","0000-00-00 00:00:00","2","142036","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2272","99","0","148051","2014-04-18","0","0","2014-04-21","14","","1","","","2","2014-04-21 04:16:50","","","","2","2014-04-21 14:22:10","2","2014-04-21 16:48:00","0","0000-00-00 00:00:00","2","142036","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2273","99","0","148058R","2014-04-18","0","0","2014-04-21","14","","1","","","2","2014-04-21 04:17:02","","","","2","2014-04-21 15:06:58","2","2014-04-21 16:48:08","0","0000-00-00 00:00:00","2","142036","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2274","1","0","8292571","2014-04-18","0","0","2014-04-21","17","","1","","IDSBG 920-00208-01","2","2014-04-21 03:45:16","1690","3","Z2","2","2014-04-21 09:44:23","2","2014-04-21 10:12:09","2","2014-04-21 11:25:57","2","142021","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2275","51","0","9931396","2014-04-18","0","0","2014-04-21","17","","1","","Javad Javad 05-597620-01 Rev 2.1","2","2014-04-21 10:16:59","1115","5","18X18","2","2014-04-21 14:45:13","2","2014-04-21 16:49:17","0","0000-00-00 00:00:00","0","","2","12","2014-04-21 13:42:03","2","1");
INSERT INTO tbl_jobs VALUES("2276","38","0","916115","2014-04-20","1","0","2014-04-21","18","","1","","Green Circuits Lightwave 402827","2","2014-04-21 09:31:07","1361","5","Fuji5000","2","2014-04-21 10:48:22","2","2014-04-21 14:30:08","0","0000-00-00 00:00:00","2","142025","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2277","4","0","321819","2014-04-20","0","0","2014-04-22","8","","1","","F5 Networks  CON-0727-00","2","2014-04-21 04:16:29","","","","2","2014-04-21 16:47:04","2","2014-04-22 10:06:20","2","2014-04-22 10:06:29","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2278","51","0","9931397","2014-04-20","1","0","2014-04-21","11","","1","","","2","2014-04-21 05:20:08","","","","2","2014-04-21 08:03:15","2","2014-04-21 08:49:19","2","2014-04-21 09:19:22","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2279","97","0","4792331","2014-04-20","1","0","2014-04-21","12","","1","","Duplicate","1","2014-04-20 22:15:34","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2280","72","0","1262748","2014-04-21","0","0","2014-04-21","18","","1","","","2","2014-04-21 08:33:31","660","4","Fuji4000","2","2014-04-21 13:03:59","2","2014-04-21 15:29:49","0","0000-00-00 00:00:00","2","142041","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2281","72","0","1262749","2014-04-21","0","0","2014-04-21","18","","1","","","2","2014-04-21 08:33:53","2310","4","Fuji4000","2","2014-04-21 12:17:21","2","2014-04-21 13:27:52","0","0000-00-00 00:00:00","2","142032","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2282","72","0","1262750","2014-04-21","0","0","2014-04-21","18","","1","","Pactron Incorporated PAC3022_21April2014 WO24731_T(Leaded)","2","2014-04-21 08:46:26","660","4","Fuji4000","2","2014-04-21 12:36:32","2","2014-04-21 15:29:59","0","0000-00-00 00:00:00","2","142033","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2283","72","0","1262751","2014-04-21","0","0","2014-04-21","18","","1","","Pactron Incorporated PAC3022_21April2014 WO24731_B(Leaded)","2","2014-04-21 08:45:43","2390","4","Fuji4000","2","2014-04-21 13:15:02","2","2014-04-21 15:30:06","0","0000-00-00 00:00:00","2","142033","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2284","43","0","5413970","2014-04-21","0","0","2014-04-22","8","","1","","Infiniti Solutions Job","2","2014-04-21 12:34:45","108","5","Fuji4000","2","2014-04-21 21:35:55","2","2014-04-21 21:47:55","2","2014-04-22 07:43:16","2","142039","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2285","43","0","5413969","2014-04-21","0","0","2014-04-22","8","","1","","Infiniti Solutions Job","2","2014-04-21 12:37:06","5066","5","Fuji4000","2","2014-04-22 09:18:43","2","2014-04-22 10:35:28","2","2014-04-22 10:40:15","2","142038","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2286","7","0","9991870","2014-04-21","0","0","2014-04-25","17","","1","","SEM HE Form Factor Inc. 200-1014(TTF0432B):1 Apt count =","2","2014-04-25 11:01:56","301","8","Z1","2","2014-04-25 13:51:38","2","2014-04-25 13:58:43","0","0000-00-00 00:00:00","2","142178","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2287","7","0","9991871","2014-04-21","0","0","2014-04-22","17","","1","","SEM HE Form Factor Inc. 200-1014(TTF0432B):1 Apt count =","1","2014-04-22 04:45:02","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2288","7","0","9991868","2014-04-21","0","0","2014-04-22","17","","1","","","2","2014-04-29 16:36:37","869","8","Z1","2","2014-04-29 20:08:03","2","2014-04-29 20:38:12","2","2014-04-30 08:16:40","2","142232","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2289","7","0","9991869","2014-04-21","0","0","2014-04-22","17","","1","","","1","2014-04-22 08:30:18","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2290","7","0","9991864","2014-04-21","0","0","2014-04-22","17","","1","","SEM HE Form Factor Inc. 200-30084(350-30084):1 Apt count =","2","2014-04-22 11:08:07","2952","6","Z1","2","2014-04-22 17:21:01","2","2014-04-22 18:20:00","0","0000-00-00 00:00:00","2","142071","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2291","97","0","4792332","2014-04-21","0","0","2014-04-22","10","","1","","Surface Art Summit Tech PS4500 DIGITAL REV 8.20 J","2","2014-04-21 16:50:56","939","5","Foil Only","2","2014-04-21 19:51:22","2","2014-04-21 20:27:03","2","2014-04-22 07:44:03","2","142056","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2292","1","0","8292572","2014-04-21","0","0","2014-04-22","10","","1","","IDSBG 820-4550-03","2","2014-04-21 17:20:02","24761","3","Z2","2","2014-04-21 21:27:29","2","2014-04-21 21:47:46","2","2014-04-22 07:43:40","2","142045","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2293","7","0","9991865","2014-04-21","0","0","2014-04-22","17","","1","","SEM HE Form Factor Inc. 200-30084(350-30084):1 Apt count =","2","2014-04-22 11:08:38","512","8","Z1","2","2014-04-22 15:55:24","2","2014-04-22 16:46:50","0","0000-00-00 00:00:00","2","142071","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2294","7","0","9991862","2014-04-21","0","0","2014-05-05","17","","1","","SEM HE Multitest Sys. SantaClara CONSOLIDATED LIB. BOARD:6","2","2014-05-01 16:58:10","8832","6","Foil Only","2","2014-05-05 13:35:40","2","2014-05-05 13:35:47","2","2014-05-05 15:04:37","2","142299","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2295","7","0","9991863","2014-04-21","0","0","2014-05-05","17","","1","","","2","2014-05-01 16:58:33","1070","6","Foil Only","2","2014-05-05 15:04:58","2","2014-05-05 15:05:23","2","2014-05-05 15:05:12","2","142299","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2296","7","0","9991860","2014-04-21","0","0","2014-04-22","17","","1","","SEM HE Microchip (MT Asia) D10-IMAX3 PROBE C C26363A","1","2014-04-21 22:44:39","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2297","7","0","9991861","2014-04-21","0","0","2014-04-22","17","","1","","","2","2014-04-22 11:36:01","1477","8","Z1","2","2014-04-22 18:56:34","2","2014-04-22 19:26:56","2","2014-04-23 08:05:56","2","142076","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2298","7","0","9991858","2014-04-21","0","0","2014-04-22","17","","1","","SEM HE STM Tours (MT GmbH) Balun ASL3K PC C13595:A","1","2014-04-21 22:43:35","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2299","7","0","9991859","2014-04-21","0","0","2014-04-22","17","","1","","","1","2014-04-21 22:43:23","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2300","7","0","9991866","2014-04-21","0","0","2014-04-22","17","","1","","SEM HE Form Factor Inc. 200-30085(350-30085):1","2","2014-04-22 11:06:49","3076","8","Z1","2","2014-04-22 16:23:37","2","2014-04-22 16:47:10","0","0000-00-00 00:00:00","2","142072","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2301","7","0","9991867","2014-04-21","0","0","2014-04-22","17","","1","","","2","2014-04-22 11:07:28","584","8","Z1","2","2014-04-22 14:32:30","2","2014-04-22 14:53:34","0","0000-00-00 00:00:00","2","142072","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2302","7","0","9991856","2014-04-21","0","0","2014-04-22","17","","1","","SEM HE Feinmetall GmbH 8VDUFLEX-153-4 C13606:A","1","2014-04-21 22:44:10","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2303","7","0","9991857","2014-04-21","0","0","2014-04-22","17","","1","","","1","2014-04-21 22:43:48","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2304","7","0","9991854","2014-04-21","0","0","2014-04-22","17","","1","","SEM HE Wentworth Laboratories 4-914-0675:A","2","2014-04-22 11:09:44","312","8","Z1","2","2014-04-22 14:46:32","2","2014-04-22 14:53:44","0","0000-00-00 00:00:00","2","142073","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2305","7","0","9991855","2014-04-21","0","0","2014-04-22","17","","1","","","1","2014-04-21 20:41:29","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2306","97","0","4792334","2014-04-21","0","0","2014-04-22","10","","1","","Surface Art Imagize 211-0006-20 Rev 2.0 J","2","2014-04-22 08:47:48","2000","5","18X18","2","2014-04-22 10:35:10","2","2014-04-22 12:20:26","2","2014-04-22 13:27:55","2","142063","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2307","99","0","148080","2014-04-21","0","0","2014-04-22","14","","1","","","2","2014-04-22 07:41:44","","","","2","2014-04-22 12:00:39","2","2014-04-22 12:50:33","2","2014-04-22 12:50:43","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2308","42","0","660035","2014-04-21","0","0","2014-04-22","12","","1","","Hunter Technology Intel BD82C604 Seamicro 700-0036-xx U6","2","2014-04-21 16:49:58","","","","2","2014-04-21 20:38:12","2","2014-04-22 16:45:19","0","0000-00-00 00:00:00","2","142064","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2309","7","0","9991872","2014-04-21","0","0","2014-04-22","17","","1","","SEM HE LTX - Credence Corporatio 14-A6821 ATHENS C26354:A Apt count =","1","2014-04-22 03:52:48","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2310","7","0","9991873","2014-04-21","0","0","2014-04-25","17","","1","","SEM HE LTX - Credence Corporatio 14-A6821 ATHENS C26354:A Apt count =","2","2014-04-25 08:56:52","4665","4","Z2","2","2014-04-25 11:04:45","2","2014-04-25 13:03:37","2","2014-04-25 15:30:34","2","142165","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2311","7","0","9991874","2014-04-21","0","0","2014-04-30","14","","1","","SEM HE Feinmetall GmbH 8VBJ750B-037 C13472:B Apt count =","2","2014-04-30 08:56:28","5375","6","Foil Only","2","2014-04-30 10:01:45","2","2014-04-30 11:29:11","2","2014-04-30 12:44:43","2","142241","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2312","7","0","9991875","2014-04-21","0","0","2014-04-30","14","","1","","SEM HE Feinmetall GmbH 8VBJ750B-037 C13472:B Apt count =","2","2014-04-30 08:56:45","8526","6","Foil Only","2","2014-04-30 10:52:45","2","2014-04-30 11:29:21","2","2014-04-30 12:44:37","2","142246","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2313","51","0","9931398","2014-04-21","1","0","2014-04-21","16","","1","","Javad Javad 05-610214-01 Rev 3.1","2","2014-04-21 15:04:41","4700","3","18X18","2","2014-04-21 16:02:35","2","2014-04-21 16:47:30","0","0000-00-00 00:00:00","0","","2","13","2014-04-21 15:55:05","2","1");
INSERT INTO tbl_jobs VALUES("2314","1","0","8292573","2014-04-21","0","0","2014-04-22","13","","1","","Foxconn iDSBG IDSBG 921-1455-02","2","2014-04-21 18:53:06","488","3","Z2","2","2014-04-21 20:18:33","2","2014-04-21 21:27:15","2","2014-04-22 07:43:53","2","142055","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2315","1","0","8292574","2014-04-21","0","0","2014-04-22","14","","1","","IDSBG 920-3895-03","2","2014-04-22 08:33:35","2665","3","Z2","2","2014-04-22 13:18:30","2","2014-04-22 13:37:59","2","2014-04-22 13:53:57","2","142074","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2316","59","0","343314","2014-04-21","1","0","2014-04-22","9","","1","","Meritronics Petasense, Inc. Vib Mole","2","2014-04-21 16:54:18","219","5","Foil Only","2","2014-04-21 19:30:12","2","2014-04-21 20:19:22","2","2014-04-22 07:43:26","2","142050","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2317","93","0","2532142","2014-04-21","0","0","2014-04-22","15","","1","","SMTC Anritsu 3-76230-3","2","2014-04-22 16:56:51","4031","5","Z2","2","2014-04-22 18:04:16","2","2014-04-22 20:17:23","2","2014-04-23 08:06:03","2","142086","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2318","93","0","2532143","2014-04-21","0","0","2014-04-22","15","","1","","SMTC Anritsu 3-76230-3","2","2014-04-22 16:57:13","3355","5","Z2","2","2014-04-22 17:58:31","2","2014-04-22 20:17:36","2","2014-04-23 08:06:09","2","142086","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2319","11","0","102102","2014-04-21","0","0","2014-04-22","14","","1","","","2","2014-04-22 09:15:15","1547","5","Z2","2","2014-04-22 11:19:52","2","2014-04-22 13:37:48","2","2014-04-22 13:53:47","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2320","97","0","4792335","2014-04-21","0","0","2014-04-22","17","","1","","Surface Art Monsoon BIA42A J","2","2014-04-22 08:46:21","15302","4","Z3","2","2014-04-22 11:14:43","2","2014-04-22 13:03:42","0","0000-00-00 00:00:00","2","142068","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2321","22","0","3474287","2014-04-21","0","0","2014-04-22","16","","8","","Axiom Electronics Biketrak Inc 901767072, 73, 74 STB000868","2","2014-04-22 09:16:51","1782","4","Foil Only","2","2014-04-22 12:32:08","2","2014-04-22 12:47:00","0","0000-00-00 00:00:00","2","142069","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2322","2","0","5346881","2014-04-21","0","1","2014-04-22","16","","1","","Sanmina Alcatel 82-0620-01 Rev 01 APERTURE COUNT","2","2014-04-22 07:54:40","2932","5","Z2","2","2014-04-22 09:28:12","2","2014-04-22 12:24:09","2","2014-04-22 13:27:42","2","142058","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2323","2","0","5346882","2014-04-21","0","1","2014-04-22","16","","1","","Sanmina Alcatel 82-0620-01 Rev 01 APERTURE COUNT","2","2014-04-22 07:56:40","1612","5","Z2","2","2014-04-22 09:30:10","2","2014-04-22 12:38:20","2","2014-04-22 13:27:35","2","142058","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2324","2","0","5346883","2014-04-21","0","1","2014-04-22","16","","1","","","2","2014-04-22 07:57:14","","","","2","2014-04-22 12:00:51","2","2014-04-22 13:54:07","2","2014-04-22 13:54:15","2","142079","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2325","97","0","4792336","2014-04-21","0","0","2014-04-23","8","","1","","","2","2014-04-22 07:40:48","4416","4","18X19","2","2014-04-22 09:35:56","2","2014-04-22 12:20:13","2","2014-04-22 13:28:04","2","142059","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2326","97","0","4792337","2014-04-21","0","0","2014-04-23","8","","1","","","2","2014-04-22 07:41:19","208","5","Foil Only","2","2014-04-22 09:47:29","2","2014-04-22 09:53:41","2","2014-04-22 13:28:12","2","142060","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2327","72","0","1262752","2014-04-22","1","0","2014-04-22","18","","1","","Pactron Incorporated PAC3027_22April2014 WO24896_T,WO24860_T LeadFree","2","2014-04-22 07:04:35","1570","4","Z2","2","2014-04-22 10:30:00","2","2014-04-22 12:42:45","2","2014-04-22 12:49:31","2","142062","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2328","31","0","7582271","2014-04-22","0","0","2014-04-23","16","","8","","","2","2014-04-22 11:36:58","762","4","18X18","2","2014-04-22 20:47:30","2","2014-04-22 21:29:07","0","0000-00-00 00:00:00","2","142070","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2329","31","0","7582272","2014-04-22","0","0","2014-04-23","16","","8","","","2","2014-04-22 11:37:47","1428","4","18X18","2","2014-04-22 18:22:52","2","2014-04-22 19:53:45","0","0000-00-00 00:00:00","2","142070","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2330","88","0","6092052","2014-04-22","0","0","2014-04-23","16","","15","","Sanmina CONTROL4 040-00253 R1 PRIMARY","2","2014-04-23 08:38:30","241","6","Z2","2","2014-04-23 13:37:41","2","2014-04-23 14:28:07","0","0000-00-00 00:00:00","2","142109","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2331","88","0","6092053","2014-04-22","0","0","2014-04-23","16","","15","","Sanmina CONTROL4 040-00253 R1 SECONDARY","2","2014-04-23 08:39:26","853","6","Z2","2","2014-04-23 13:10:22","2","2014-04-23 14:19:48","0","0000-00-00 00:00:00","2","142109","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2332","31","0","7582273","2014-04-22","0","0","2014-04-23","16","","8","","","2","2014-04-22 13:13:11","504","5","18X18","2","2014-04-22 19:17:32","2","2014-04-22 20:44:38","0","0000-00-00 00:00:00","2","142077","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2333","31","0","7582274","2014-04-22","0","0","2014-04-23","16","","8","","","2","2014-04-22 13:12:45","104","4","18X18","2","2014-04-22 18:36:06","2","2014-04-22 19:50:04","0","0000-00-00 00:00:00","2","142077","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2334","4","0","321820","2014-04-22","0","0","2014-04-23","10","","1","","Flextronics F5 Networks  PCA-0327-00","2","2014-04-22 16:24:25","5862","5","Z2","2","2014-04-22 20:27:59","2","2014-04-22 21:29:18","2","2014-04-23 09:38:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2335","4","0","321821","2014-04-22","0","0","2014-04-23","10","","1","","","2","2014-04-22 16:24:58","4225","5","Z2","2","2014-04-22 21:41:03","2","2014-04-23 09:14:16","2","2014-04-23 09:37:38","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2336","42","0","660034","2014-04-22","0","0","2014-04-22","18.3","","1","","","2","2014-04-22 11:06:38","","","","2","2014-04-22 17:11:19","2","2014-04-24 16:40:18","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2337","29","0","919108","2014-04-22","1","0","2014-04-23","11","","1","","CBA Electronics Corp PantryChicMain  Rev. 1.0","2","2014-04-23 10:34:20","1850","5","Foil Only","2","2014-04-23 11:16:31","2","2014-04-23 11:34:44","2","2014-04-23 11:40:56","2","142101","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2338","97","0","4792338","2014-04-22","1","0","2014-04-23","9","","1","","Surface Art SignalScape LOWLANDS REV 1.1.0 J","2","2014-04-22 13:23:39","666","5","18X18","2","2014-04-22 14:10:48","2","2014-04-22 16:15:13","0","0000-00-00 00:00:00","2","142081","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2339","4","0","321822","2014-04-22","1","0","2014-04-23","16","","1","","Flextronics F5 Networks PCA-0334-00","2","2014-04-22 15:14:21","17771","5\\\\4","Z3","2","2014-04-23 21:18:12","2","2014-04-24 07:44:22","2","2014-04-24 07:44:55","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2340","70","0","1105141","2014-04-22","0","0","2014-04-23","13","","1","","Oncore THUM 2660021150762@A TOP SIDE","2","2014-04-24 10:48:27","972","5","Z2","2","2014-04-24 11:45:49","2","2014-04-24 15:10:01","2","2014-04-25 10:09:54","2","142156","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2341","70","0","1105142","2014-04-22","0","0","2014-04-23","14","","1","","Oncore THUM 2660021150311@B TOP SIDE","2","2014-04-23 11:03:43","173","5","Z2","2","2014-04-23 12:13:59","2","2014-04-23 15:58:56","2","2014-04-25 10:10:01","2","142156","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2342","70","0","1105143","2014-04-22","0","0","2014-04-23","14","","1","","Oncore THUM 2660021150311@B BOTTOM SIDE","2","2014-04-23 11:04:05","87","5","Z2","2","2014-04-23 12:16:12","2","2014-04-23 15:18:14","2","2014-04-25 10:10:10","2","142156","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2343","97","0","4792339","2014-04-22","0","0","2014-04-23","15","","1","","Surface Art Pelco PA05-0133-00 REV B0 J","2","2014-04-23 05:31:40","1718","5","Z2","2","2014-04-23 09:08:04","2","2014-04-23 14:18:01","0","0000-00-00 00:00:00","2","142096","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2344","97","0","4792340","2014-04-22","0","0","2014-04-23","15","","1","","Surface Art Pelco PA05-0135-00 REV B0 J","2","2014-04-23 06:13:14","1727","5","Z2","2","2014-04-23 09:41:11","2","2014-04-23 14:18:09","0","0000-00-00 00:00:00","2","142095","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2345","1","0","8292575","2014-04-22","0","0","2014-04-23","15","","1","","Foxconn-iDSBG iDSBG 820-4887-01","2","2014-04-23 05:30:34","35442","3","Z3","2","2014-04-23 18:06:21","2","2014-04-23 19:03:01","0","0000-00-00 00:00:00","2","142108","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2346","11","0","102103","2014-04-22","0","0","2014-04-23","15","","1","","Zollner Electronics Sandisk 1801985-00 1.5k Proto","2","2014-04-25 18:15:27","2141","3","Z2","2","2014-04-25 19:09:56","2","2014-04-25 20:40:55","2","2014-04-28 11:46:56","2","142188","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2347","70","0","1105144","2014-04-22","0","0","2014-04-23","16","","1","","Oncore THUM 2660021151093","2","2014-04-23 11:02:37","967","4","Z2","2","2014-04-23 12:31:29","2","2014-04-23 15:27:26","2","2014-04-25 10:11:12","2","142159","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2348","70","0","1105145","2014-04-22","0","0","2014-04-23","16","","1","","","2","2014-04-23 11:03:42","70","4","Z2","2","2014-04-23 12:23:33","2","2014-04-23 15:18:27","2","2014-04-25 10:11:20","2","142159","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2349","2","0","5346884","2014-04-22","0","0","2014-04-23","16","","1","","Sanmina Ruckus 120-11297-001 Rev-2.1","2","2014-04-22 20:45:13","230","5","Z2","2","2014-04-23 11:06:36","2","2014-04-23 14:03:36","0","0000-00-00 00:00:00","2","142100","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2350","8","0","575411","2014-04-22","0","0","2014-04-25","10","","1","","Jabil Agilent M9710-63101-001-T M9710-20101_001","2","2014-04-28 10:21:54","2746","5","Z2","2","2014-04-28 11:56:02","2","2014-04-28 13:26:13","2","2014-04-28 13:28:03","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2351","8","0","575412","2014-04-22","0","0","2014-04-25","10","","1","","Jabil Agilent M9710-63101-001-B M9710-20101_001","2","2014-04-28 10:22:20","2134","5","Z2","2","2014-04-28 11:47:13","2","2014-04-28 13:26:22","2","2014-04-28 13:27:56","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2352","70","0","1105146","2014-04-22","0","0","2014-04-23","16","","1","","Oncore THUM 2660021150754@B TOP SIDE","2","2014-04-23 08:37:41","533","5","Z2","2","2014-04-23 12:05:24","2","2014-04-23 16:08:11","2","2014-04-25 10:11:29","2","142159","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2353","33","0","703154","2014-04-22","0","0","2014-04-24","16","","10","","","2","2014-04-23 05:39:46","4528","5/4","","2","2014-04-24 11:59:01","2","2014-04-24 14:05:33","0","0000-00-00 00:00:00","2","142112","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2354","70","0","1105147","2014-04-22","0","0","2014-04-23","17","","1","","","2","2014-04-24 10:26:15","701","5","Z2","2","2014-04-24 11:24:05","2","2014-04-24 15:14:13","2","2014-04-25 10:11:39","2","142159","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2355","2","0","5346885","2014-04-22","0","1","2014-04-24","17","","1","","","2","2014-04-23 05:32:01","3098","6/5","Z2","2","2014-04-23 19:56:03","2","2014-04-23 21:17:40","2","2014-04-24 07:46:16","2","142123","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2356","2","0","5346886","2014-04-22","0","1","2014-04-24","8","","1","","","2","2014-04-23 05:32:17","1675","5","Z2","2","2014-04-23 12:20:46","2","2014-04-23 14:22:37","0","0000-00-00 00:00:00","2","142107","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2357","2","0","5346887","2014-04-22","0","0","2014-04-23","17","","1","","Sanmina Saratoga Speed SSR-ASSY-000010-002 REV A APERTURE COUNT","2","2014-04-22 21:40:23","131","5","Z2","2","2014-04-23 12:10:36","2","2014-04-23 14:26:51","0","0000-00-00 00:00:00","2","142106","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2358","119","0","101017","2014-04-22","0","0","2014-04-30","18.3","","1","","","2","2014-04-22 19:43:04","","","","2","2014-04-22 20:48:44","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2359","10","0","2392976","2014-04-23","1","0","2014-04-23","16","","1","","","2","2014-04-23 05:31:42","","","","2","2014-04-23 08:25:11","2","2014-04-23 15:49:04","0","0000-00-00 00:00:00","2","142114","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2360","10","0","2392977","2014-04-23","1","0","2014-04-23","16","","1","","","2","2014-04-23 12:10:32","","","","2","2014-04-23 13:18:48","2","2014-04-23 15:49:11","0","0000-00-00 00:00:00","2","142114","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2361","72","0","1262754","2014-04-23","1","0","2014-04-23","15","","1","","Pactron Incorporated PAC3028_23April2014 WO24825_T,WO24936_T LeadFree","2","2014-04-23 06:14:00","10781","4","Z2","2","2014-04-23 10:07:15","2","2014-04-23 12:06:14","2","2014-04-23 13:17:02","2","142090","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2362","45","0","724056","2014-04-23","0","0","2014-04-24","8","","1","","","2","2014-04-23 15:45:43","554","8","Z1","2","2014-04-23 19:06:12","2","2014-04-23 19:11:58","2","2014-04-24 07:44:40","2","142110","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2363","31","0","7582275","2014-04-23","0","0","2014-04-24","16","","8","","Controltek  LTM4628V","2","2014-04-23 12:10:48","","","","2","2014-04-23 13:18:30","2","2014-04-23 15:10:49","0","0000-00-00 00:00:00","2","142113","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2364","100","0","140201","2014-04-23","0","0","2014-04-24","16","","15","","","2","2014-04-23 15:46:04","1494","5","18X19","2","2014-04-23 19:21:37","2","2014-04-23 20:55:53","0","0000-00-00 00:00:00","2","142125","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2365","97","0","4792341","2014-04-23","0","0","2014-04-24","10","","1","","Surface Art Go Pro Debug Rev Na J","2","2014-04-23 18:43:25","293","5","18X18","2","2014-04-23 19:45:40","2","2014-04-23 20:50:39","2","2014-04-24 07:45:58","2","142122","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2366","11","0","102104","2014-04-23","0","0","2014-04-24","10","","1","","","2","2014-04-23 17:55:49","792","5","Z2","2","2014-04-24 12:18:53","2","2014-04-24 15:13:48","2","2014-04-25 15:31:03","2","142175","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2367","11","0","102105","2014-04-23","0","0","2014-04-24","10","","1","","","2","2014-04-23 17:56:32","256","6","Z2","2","2014-04-24 13:34:51","2","2014-04-24 15:51:46","2","2014-04-25 15:31:33","2","142175","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2368","67","0","981114","2014-04-23","0","0","2014-04-24","11","","1","","","2","2014-04-24 17:47:43","","","","2","2014-04-25 15:23:44","2","2014-04-25 16:36:42","2","2014-04-28 07:52:39","2","142183","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2369","93","0","2532144","2014-04-23","0","0","2014-04-24","11","","1","","SMTC Anritsu 3-74928-3p3","2","2014-04-24 15:54:58","806","5","Z2","2","2014-04-24 20:12:54","2","2014-04-24 21:00:20","2","2014-04-25 10:09:23","2","142111","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2370","2","0","5346888","2014-04-23","0","0","2014-04-24","11","","1","","","2","2014-04-24 06:42:58","4161","4","Z2","2","2014-04-24 09:36:58","2","2014-04-24 11:14:28","2","2014-04-24 11:14:36","2","142129","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2371","27","0","872208","2014-04-23","0","0","2014-04-24","11","","1","","CAL TECH Kinestral 700211 Rev 1","2","2014-04-23 16:21:16","896","6","Foil Only","2","2014-04-23 20:52:02","2","2014-04-23 21:03:42","2","2014-04-24 07:46:41","2","142124","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2372","43","0","5413971","2014-04-23","0","0","2014-04-24","11","","1","","Infiniti Solutions L.S.Research HUB02 Wifi","2","2014-04-23 16:07:43","1859","4","Z2","2","2014-04-23 19:14:29","2","2014-04-23 21:10:47","2","2014-04-24 07:45:47","2","142121","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2373","10","0","2392978","2014-04-23","0","1","2014-05-02","12","","1","","ASteelFlash Tesla 1007531-00 Rev: E","2","2014-05-01 16:57:28","3943","5","Z2","2","2014-05-01 19:06:42","2","2014-05-01 20:48:27","2","2014-05-02 08:53:14","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2374","10","0","2392979","2014-04-23","0","1","2014-05-02","12","","1","","ASteelFlash Tesla 1007531-00 Rev: E","2","2014-05-01 16:57:46","1933","5","Z2","2","2014-05-01 20:17:09","2","2014-05-01 21:28:50","2","2014-05-02 08:53:06","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2375","4","0","321823","2014-04-23","0","0","2014-04-24","12","","1","","","2","2014-04-24 08:46:53","3132","5","Z2","2","2014-04-24 09:48:08","2","2014-04-24 11:45:28","2","2014-04-24 11:51:40","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2376","17","0","637619","2014-04-23","0","0","2014-04-24","14","","1","","Agilent Technologies Enhanced Control G1996-61033 Tom Knotts","1","2014-04-23 14:45:43","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2377","17","0","637620","2014-04-23","0","0","2014-04-24","14","","1","","Agilent Technologies Enhanced Control G1996-61033 Tom Knotts","1","2014-04-23 14:45:32","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2378","22","0","3474288","2014-04-23","0","0","2014-04-28","16","","8","","Axiom Electronics Voxtel 905000388 STB000869","2","2014-04-25 14:49:48","792","5","Foil Only","2","2014-04-25 16:38:58","2","2014-04-25 16:49:50","0","0000-00-00 00:00:00","2","142182","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2379","17","0","637621","2014-04-23","0","0","2014-04-24","14","","1","","Agilent Technologies Funnel GE430-61152 Shahrzad Mazlouman","2","2014-04-24 08:07:41","298","5","Foil Only","2","2014-04-24 13:00:49","2","2014-04-24 13:13:33","2","2014-04-24 13:13:47","2","142141","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2380","17","0","637622","2014-04-23","0","0","2014-04-24","14","","1","","Agilent Technologies Funnel GE430-61152 Shahrzad Mazlouman","2","2014-04-24 08:08:16","146","5","Foil Only","2","2014-04-24 12:48:06","2","2014-04-24 13:13:19","2","2014-04-24 13:13:53","2","142141","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2381","2","0","5346889","2014-04-23","1","0","2014-04-23","18","","1","","","2","2014-04-23 15:44:03","","","","2","2014-04-23 16:47:49","2","2014-04-23 16:53:15","0","0000-00-00 00:00:00","2","142118","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2382","97","0","4792301F","2014-04-23","0","0","2014-04-24","10","","1","","","2","2014-04-24 08:54:07","40","5","","2","2014-04-24 09:40:28","2","2014-04-24 10:05:24","2","2014-04-24 10:28:57","2","142128","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2383","22","0","3474289","2014-04-23","1","0","2014-04-23","6","","4","","MINI","2","2014-04-23 15:36:59","","5","","2","2014-04-23 17:09:02","2","2014-04-23 17:21:10","0","0000-00-00 00:00:00","2","142120","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2384","35","0","800211","2014-04-23","1","1","2014-04-24","11","","1","","Creation Technologies ARN Micro M2","2","2014-04-24 06:41:40","604","4","Z2","2","2014-04-24 08:17:37","2","2014-04-24 10:15:08","2","2014-04-24 12:39:45","2","142127","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2385","35","0","800212","2014-04-23","1","1","2014-04-24","11","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2386","62","0","538117","2014-04-23","0","0","2014-04-24","16","","4","","","2","2014-04-23 18:00:03","478","4\\\\2","18X19","2","2014-04-24 17:12:00","2","2014-04-24 18:48:16","0","0000-00-00 00:00:00","2","142142","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2387","62","0","538118","2014-04-23","0","0","2014-04-24","16","","4","","","2","2014-04-23 17:59:47","480","4/2","18X19","2","2014-04-24 17:24:29","2","2014-04-24 18:48:06","0","0000-00-00 00:00:00","2","142147","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2388","97","0","4792165f","2014-04-23","0","0","2014-04-24","9","","1","","","2","2014-04-23 16:19:06","624 fixit","4","","2","2014-04-23 17:27:53","2","2014-04-24 07:45:17","2","2014-04-24 07:45:32","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2389","7","0","99931399","2014-04-23","0","0","2014-04-24","16","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2390","51","0","9931400","2014-04-23","0","0","2014-04-24","16","","1","","","2","2014-04-24 14:05:56","1813","4","18X18","2","2014-04-24 16:08:34","2","2014-04-24 16:40:10","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2391","20","0","938681","2014-04-23","0","1","2014-04-24","16","","15","","","2","2014-04-24 12:59:16","","","","2","2014-04-24 14:56:55","2","2014-04-24 16:39:48","0","0000-00-00 00:00:00","2","142143","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2392","3","0","5632159","2014-04-23","0","0","2014-04-24","6","","4","","","2","2014-04-23 17:05:14","","","","2","2014-04-23 20:25:54","2","2014-04-24 11:17:16","0","0000-00-00 00:00:00","2","142133","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2393","4","0","321824","2014-04-23","0","0","2014-04-24","17","","1","","","2","2014-04-24 06:42:18","9755","7/5","Z2","2","2014-04-24 20:39:39","2","2014-04-25 13:28:40","2","2014-04-25 13:28:56","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2394","4","0","321825","2014-04-23","0","0","2014-04-24","17","","1","","","2","2014-04-24 06:42:01","3574","5","Z2","2","2014-04-24 11:39:03","2","2014-04-24 14:00:50","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2395","22","0","3474290","2014-04-23","0","0","2014-04-25","16","","4","","Axiom Electronics LeCroy Condor Acquisition 901766922 SSP000011R02","2","2014-04-24 13:21:44","26949","8/5","Z3","2","2014-04-25 17:39:40","2","2014-04-25 19:22:25","0","0000-00-00 00:00:00","2","142173","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2396","1","0","8292576","2014-04-23","0","0","2014-04-24","17","","1","","Foxconn iDSBG IDSBG 920-00217-01","2","2014-04-24 08:09:17","2387","3","Z2","2","2014-04-24 12:22:13","2","2014-04-24 12:29:59","2","2014-04-24 13:13:07","2","142139","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2397","8","0","575414","2014-04-23","0","1","2014-04-25","8","","1","","Jabil Circuit Grass Valley GD771065300 rev R09-T GD399065300 rev R01","2","2014-04-24 11:37:39","16973","5","Z2","2","2014-04-25 10:54:13","2","2014-04-25 12:45:33","2","2014-04-28 09:22:40","2","142184","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2398","8","0","575415","2014-04-23","0","1","2014-04-25","8","","1","","Jabil Circuit Grass Valley GD771065300 rev R09-B GD399065300 rev R01","2","2014-04-24 11:38:14","10110","4","Z2","2","2014-04-25 10:54:02","2","2014-04-25 12:45:44","2","2014-04-28 09:22:51","2","142184","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2399","34","0","7994770","2014-04-23","1","0","2014-04-24","10","","1","","","2","2014-04-24 07:18:29","","","","2","2014-04-24 08:20:40","2","2014-04-24 08:53:53","2","2014-04-24 09:15:20","2","142126","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2400","4","0","321826","2014-04-23","0","0","2014-04-30","8","","1","","","2","2014-04-29 16:38:51","2157","5","Z2","2","2014-04-29 20:29:05","2","2014-04-30 08:16:17","2","2014-04-30 09:42:51","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2401","4","0","321827","2014-04-23","0","0","2014-04-30","8","","1","","","2","2014-04-29 16:39:21","515","5","Z2","2","2014-04-29 19:41:28","2","2014-04-30 08:16:23","2","2014-04-30 09:42:57","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2402","97","0","4792344","2014-04-23","0","0","2014-04-24","18","","1","","Surface Art Oculus VR &#8203;LDE REV1&#8203; J","2","2014-04-24 08:10:21","","","","2","2014-04-24 10:01:03","2","2014-04-24 10:24:02","2","2014-04-24 10:29:06","2","142131","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2403","4","0","321828","2014-04-24","0","0","2014-04-25","8","","1","","","2","2014-04-24 07:18:59","","","","2","2014-04-24 08:31:17","2","2014-04-24 09:24:05","2","2014-04-24 11:51:48","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2404","4","0","321T824","2014-04-24","0","0","2014-04-24","17","","1","","","2","2014-04-24 06:43:11","","","","2","2014-04-24 17:28:42","2","2014-04-24 18:48:28","2","2014-04-25 10:09:41","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2405","67","0","981115","2014-04-24","0","0","2014-04-24","11","","1","","","2","2014-04-24 17:47:31","","","","2","2014-04-25 15:23:37","2","2014-04-25 16:36:48","2","2014-04-28 07:52:46","2","142183","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2406","51","0","9931399","2014-04-24","0","0","2014-04-24","16","","1","","","2","2014-04-24 14:05:30","1478","4","18X18","2","2014-04-24 15:45:43","2","2014-04-24 16:40:03","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2407","8","0","575275R","2014-04-24","0","0","2014-04-25","10","","1","","","2","2014-04-24 14:06:14","","5","","2","2014-04-24 17:01:16","2","2014-04-25 12:12:39","2","2014-04-25 12:12:56","2","142154","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2408","43","0","5413972","2014-04-24","0","1","2014-04-25","10","","1","","","2","2014-04-24 15:56:00","3316","4","Z2","2","2014-04-24 20:26:32","2","2014-04-24 21:53:02","2","2014-04-25 10:09:07","2","142153","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2409","84","0","222092","2014-04-24","0","0","2014-04-28","10","","1","","Rocket EMS Incorporated Cadence Logic Board ML-5020F","2","2014-04-25 05:54:39","36900","4/3","Z3","2","2014-04-28 16:05:46","2","2014-04-28 18:01:41","0","0000-00-00 00:00:00","2","142197","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2410","9","0","2814040","2014-04-24","1","0","2014-04-24","13","","1","","","2","2014-04-24 11:34:20","","","","2","2014-04-24 12:24:15","2","2014-04-24 13:08:42","2","2014-04-24 13:13:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2411","51","0","9931401","2014-04-24","0","0","2014-04-25","11","","1","","","2","2014-04-24 14:17:10","261","5","18X18","2","2014-04-24 16:15:46","2","2014-04-24 18:48:42","2","2014-04-25 09:28:06","0","","2","14","2014-04-25 09:37:24","2","1");
INSERT INTO tbl_jobs VALUES("2412","8","0","575T414","2014-04-24","0","0","2014-04-25","8","","1","","","2","2014-04-24 12:16:26","","","","2","2014-04-25 10:40:54","2","2014-04-25 16:36:23","2","2014-04-28 09:23:01","2","142184","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2413","8","0","575T415","2014-04-24","0","0","2014-04-25","8","","1","","","2","2014-04-24 12:16:12","","","","2","2014-04-25 15:23:20","2","2014-04-25 16:36:32","2","2014-04-28 09:23:09","2","142184","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2414","7","0","9991876","2014-04-24","0","0","2014-04-25","17","","1","","SEM HE Microprobe Inc. 13235-70:A_54810A1 Apt count =","2","2014-04-25 10:52:51","17958","6","Z3","2","2014-04-25 20:13:36","2","2014-04-25 21:34:40","2","2014-04-28 07:52:08","2","142171","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2415","7","0","9991877","2014-04-24","0","0","2014-04-25","17","","1","","SEM HE Microprobe Inc. 13235-70:A_54810A1 Apt count =","1","2014-04-25 03:40:44","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2416","3","0","5632160","2014-04-24","0","0","2014-04-28","19.3","","4","","ntel Corporation GEBO -HPCC DC Fab C PB","2","2014-04-25 15:00:07","12275","5/4","Z2","2","2014-04-28 19:12:17","2","2014-04-28 19:48:16","0","0000-00-00 00:00:00","2","142198","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2417","3","0","5632161","2014-04-24","0","0","2014-04-28","19.3","","4","","","2","2014-04-25 15:01:09","4887","4","","2","2014-04-28 16:09:44","2","2014-04-28 17:11:23","0","0000-00-00 00:00:00","2","142195","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2418","72","0","1262755","2014-04-24","0","0","2014-04-25","12","","1","","Cancelled as per Ranga","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2419","3","0","5632162","2014-04-24","1","0","2014-04-24","19.3","","4","","mini","2","2014-04-24 12:46:59","","4 and 5","Foil Only","2","2014-04-24 18:25:56","2","2014-04-24 18:47:57","0","0000-00-00 00:00:00","2","142146","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2420","36","0","6911933","2014-04-24","1","0","2014-04-25","10","","1","","","2","2014-04-24 17:33:02","1738","4","Z2","2","2014-04-24 19:13:26","2","2014-04-24 21:14:07","2","2014-04-25 09:27:18","2","142151","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2421","36","0","6911932","2014-04-24","1","0","2014-04-25","10","","1","","","2","2014-04-24 17:32:05","4132","4","Z2","2","2014-04-24 19:49:04","2","2014-04-24 20:18:54","2","2014-04-25 09:27:40","2","142151","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2422","1","0","8292577","2014-04-24","0","0","2014-04-25","13","","1","","","2","2014-04-24 18:44:09","490","3","Z2","2","2014-04-24 20:35:50","2","2014-04-24 22:04:51","2","2014-04-25 09:28:15","2","142152","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2423","31","0","7582276","2014-04-24","0","0","2014-04-25","16","","10","","Controltek  885-1200-1 980-220145 Rev A","2","2014-04-25 08:12:35","4597","4","Z2","2","2014-04-25 13:38:37","2","2014-04-25 14:42:35","0","0000-00-00 00:00:00","2","142168","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2424","7","0","9991878","2014-04-24","0","0","2014-04-25","17","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2425","7","0","9991879","2014-04-24","0","0","2014-04-25","17","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2426","4","0","321829","2014-04-24","0","0","2014-04-25","14","","1","","Flextronics Motorola Mot1-594707-001-00 Fab 594717-001-00 Rev. A","2","2014-04-25 10:31:54","19735","5","Z2","2","2014-04-25 17:05:19","2","2014-04-25 18:31:47","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2427","4","0","321830","2014-04-24","0","0","2014-04-25","14","","1","","Flextronics Motorola Mot1-594707-001-00 Fab 594717-001-00 Rev. A","2","2014-04-25 10:32:44","10521","5","Z2","2","2014-04-25 14:38:40","2","2014-04-25 15:28:06","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2428","51","0","9931402","2014-04-24","0","0","2014-04-25","15","","1","","","2","2014-04-24 18:37:16","256","5","18X18","2","2014-04-24 20:21:21","2","2014-04-24 21:26:15","2","2014-04-25 09:28:25","0","","2","15","2014-04-25 09:38:02","2","1");
INSERT INTO tbl_jobs VALUES("2429","93","0","2532145","2014-04-24","0","0","2014-04-25","15","","1","","","2","2014-04-25 09:33:39","1210","5","Z2","2","2014-04-25 13:56:13","2","2014-04-25 16:07:20","0","0000-00-00 00:00:00","2","142170","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2430","93","0","2532146","2014-04-24","0","0","2014-04-25","15","","1","","","2","2014-04-25 11:12:02","1099","5","Z2","2","2014-04-25 14:04:05","2","2014-04-25 16:07:29","0","0000-00-00 00:00:00","2","142167","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2431","4","0","321831","2014-04-24","0","0","2014-04-25","15","","1","","Flextronics F5 Networks PCA-0272-02","2","2014-04-25 06:51:53","2408","5","Z2","2","2014-04-25 11:36:28","2","2014-04-25 13:09:17","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2432","59","0","343315","2014-04-24","1","0","2014-04-25","9","","1","","","2","2014-04-24 17:55:02","136","5","18X18","2","2014-04-24 19:18:58","2","2014-04-24 20:01:18","2","2014-04-25 09:27:06","2","142150","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2433","1","0","8292578","2014-04-24","0","0","2014-04-25","15","","1","","IDSBG 920-00185-01","2","2014-04-25 08:13:31","1701","4","Z2","2","2014-04-25 09:57:01","2","2014-04-25 11:23:59","2","2014-04-25 15:32:42","2","142162","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2434","1","0","8292579","2014-04-24","0","0","2014-04-25","17","","1","","IDSBG 820-00002-02","2","2014-04-25 08:20:06","12054","3","Z2","2","2014-04-25 13:59:11","2","2014-04-25 15:33:46","0","0000-00-00 00:00:00","2","142169","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2435","51","0","9931403","2014-04-24","1","0","2014-04-25","17","","1","","Javad 05-587401-02 Rev 2.3","2","2014-04-25 05:55:38","1436","5","18X18","2","2014-04-25 11:44:00","2","2014-04-25 14:27:49","0","0000-00-00 00:00:00","0","","2","17","2014-04-25 13:48:12","2","1");
INSERT INTO tbl_jobs VALUES("2436","4","0","321832","2014-04-24","1","0","2014-04-25","14","","1","","Flextronics VIO-620-0189-00 VIO-610-0100-01 REV.01","2","2014-04-25 09:54:41","2206","5","Z2","2","2014-04-25 12:00:21","2","2014-04-25 14:16:34","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2437","4","0","321833","2014-04-24","1","0","2014-04-25","14","","1","","Flextronics VIO-620-0189-00 VIO-610-0100-01 REV.01","2","2014-04-25 09:55:23","1636","6","Z2","2","2014-04-25 11:41:24","2","2014-04-25 14:16:41","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2438","17","0","637623","2014-04-24","0","0","2014-04-25","17","","1","","Agilent Technologies Time Base Miao Zhu","2","2014-04-25 08:08:41","339","5","Foil Only","2","2014-04-25 13:46:57","2","2014-04-25 13:54:50","2","2014-04-25 15:30:07","2","142172","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2439","107","0","614143","2014-04-25","0","0","2014-04-30","12","","1","","","2","2014-04-29 21:24:03","","","","2","2014-04-30 08:49:31","2","2014-04-30 09:38:54","2","2014-04-30 11:02:32","2","142237","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2440","72","0","1262756","2014-04-25","0","0","2014-04-25","18","","1","","","2","2014-04-25 06:28:34","2572","4","Z2","2","2014-04-25 11:38:44","2","2014-04-25 16:14:48","0","0000-00-00 00:00:00","2","142166","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2441","72","0","1262757","2014-04-25","1","0","2014-04-25","18","","1","","","2","2014-04-25 06:51:30","286","4","Z2","2","2014-04-25 10:21:46","2","2014-04-25 12:51:18","0","0000-00-00 00:00:00","2","142164","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2442","43","0","5413973","2014-04-25","0","0","2014-04-28","8","","1","","","2","2014-04-25 09:56:14","320","5","Fuji4000","2","2014-04-25 19:39:36","2","2014-04-25 21:23:04","2","2014-04-28 07:52:16","2","142174","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2443","51","0","9931404","2014-04-25","0","0","2014-04-28","9","","1","","WestCom Nurse Call 20118222 Rev A","2","2014-04-25 12:27:55","1922","5","18X18","2","2014-04-25 13:48:38","2","2014-04-25 14:55:53","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2444","29","0","919109","2014-04-25","0","0","2014-04-28","11","","1","","","2","2014-04-28 15:28:16","","","","2","2014-04-28 15:28:21","2","2014-04-28 15:47:55","2","2014-04-29 09:13:57","2","142192","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2445","51","0","9931406","2014-04-25","1","0","2014-04-25","13.3","","1","","","2","2014-04-25 11:42:03","140","5","18X18","2","2014-04-25 12:10:52","2","2014-04-25 14:27:55","0","0000-00-00 00:00:00","0","","2","16","2014-04-25 12:44:06","2","1");
INSERT INTO tbl_jobs VALUES("2446","9","0","2814041","2014-04-25","0","0","2014-04-30","12","","1","","","2","2014-04-30 08:34:30","702","4","Z2","2","2014-04-30 09:38:12","2","2014-04-30 12:05:20","2","2014-04-30 12:44:20","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2447","9","0","2814042","2014-04-25","0","0","2014-04-30","12","","1","","","2","2014-04-30 08:07:50","542","5","Z2","2","2014-04-30 11:02:32","2","2014-04-30 12:40:28","2","2014-04-30 12:44:15","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2448","20","0","938682","2014-04-25","0","0","2014-04-28","16","","15","","Ascentron IDD AEROSPACE 520-000096-200 P/N 790-2530","2","2014-04-25 13:08:31","168","5","18X18","2","2014-04-25 20:19:45","2","2014-04-25 21:34:30","0","0000-00-00 00:00:00","2","142177","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2449","99","0","148081","2014-04-25","0","0","2014-04-28","10","","1","","","2","2014-04-25 15:14:54","","","","2","2014-04-25 21:15:44","2","2014-04-28 12:04:59","2","2014-04-28 12:46:51","2","142180","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2450","8","0","575413","2014-04-25","0","1","2014-04-30","13","","1","","Jabil Circuit Grass Valley  GD771065400-R04-B GD399065400 rev R01","2","2014-04-28 12:34:44","1595","5","Z2","2","2014-04-28 19:23:59","2","2014-04-28 21:31:54","0","0000-00-00 00:00:00","2","142203","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2451","84","0","222081R","2014-04-25","0","0","2014-04-28","10","","1","","","2","2014-04-25 17:11:22","7786","5","","2","2014-04-25 20:47:19","2","2014-04-25 21:34:48","2","2014-04-28 07:52:00","2","142179","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2452","43","0","5413974","2014-04-25","1","0","2014-04-28","17","","1","","","2","2014-04-28 16:37:15","","","","2","2014-04-28 16:37:23","2","2014-04-28 18:17:50","0","0000-00-00 00:00:00","2","142201","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2453","70","0","1105148","2014-04-25","0","0","2014-04-28","14","","1","","Oncore TLTC 05-130300-01LF@2.3 TOP SIDE","2","2014-04-28 14:40:37","2005","4","Z2","2","2014-04-28 19:39:47","2","2014-04-28 21:14:11","2","2014-04-29 07:42:51","2","142202","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2454","70","0","1105149","2014-04-25","0","0","2014-04-28","14","","1","","","2","2014-04-28 14:40:57","1484","4","Z2","2","2014-04-28 18:38:05","2","2014-04-28 21:14:05","2","2014-04-29 07:42:39","2","142202","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2455","9","0","2814043","2014-04-25","1","0","2014-05-14","11","","1","","","2","2014-05-14 08:27:59","3015","4","Z2","2","2014-05-14 09:39:51","2","2014-05-14 13:31:27","2","2014-05-14 13:39:48","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2456","9","0","2814044","2014-04-25","1","0","2014-05-15","16","","1","","Sanmina - SCI, Corp. RDC Assy 131-0754 PCB 132-0754 rev 1","2","2014-05-15 13:45:13","171","5","Z2","2","2014-05-15 15:09:51","2","2014-05-15 19:40:26","2","2014-05-15 19:41:48","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2457","9","0","2814045","2014-04-25","1","0","2014-05-15","16","","1","","Sanmina - SCI, Corp. RDC Assy 131-0754 PCB 132-0754 rev 1","2","2014-05-15 13:45:27","267","5","Z2","2","2014-05-15 15:03:16","2","2014-05-15 19:40:34","2","2014-05-15 19:41:57","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2458","9","0","2814046","2014-04-25","0","0","2014-05-06","17","","1","","Sanmina - SCI, Corp. RDC  Assy 131-0746 PCB 132-0746 rev 1","2","2014-05-06 15:05:13","111","5","Z2","2","2014-05-06 15:52:46","2","2014-05-06 18:55:07","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2459","9","0","2814047","2014-04-25","0","0","2014-05-06","17","","1","","Sanmina - SCI, Corp. RDC  Assy 131-0746 PCB 132-0746 rev 1","2","2014-05-06 15:06:12","363","5","Z2","2","2014-05-06 17:21:45","2","2014-05-06 19:58:29","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2460","41","0","832743","2014-04-25","0","0","2014-04-28","8","","1","","COVIDEIN_ACM_X04 NDBC_SM14/ EDK-2","2","2014-04-28 04:59:53","1517","6","Foil Only","2","2014-04-28 10:18:38","2","2014-04-28 10:46:55","2","2014-04-28 11:18:50","2","142185","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2461","109","0","255711","2014-04-27","0","1","2014-04-30","16","","1","","","2","2014-04-30 14:22:20","","","","2","2014-04-30 15:12:04","2","2014-04-30 15:12:11","0","0000-00-00 00:00:00","2","142260","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2462","72","0","1262758","2014-04-28","0","0","2014-04-28","18","","1","","Pactron Incorporated PAC3031_28April2014_ WO24920_T","2","2014-04-28 05:52:24","1492","4","Z2","2","2014-04-28 10:06:48","2","2014-04-28 12:48:57","2","2014-04-28 13:27:35","2","142186","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2463","72","0","1262759","2014-04-28","0","0","2014-04-28","18","","1","","","2","2014-04-28 06:01:50","867","4","Z2","2","2014-04-28 10:46:00","2","2014-04-28 12:49:06","2","2014-04-28 13:27:29","2","142187","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2464","72","0","1262760","2014-04-28","0","0","2014-04-28","18","","1","","Pactron Incorporated PAC3032_28April2014_ WO24969_T(LeadFree)","2","2014-04-28 06:03:47","787","4","Z2","2","2014-04-28 12:23:02","2","2014-04-28 13:27:15","2","2014-04-28 13:27:23","2","142191","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2465","7","0","9991880","2014-04-28","0","0","2014-04-29","8","","1","","SEM HE COMPRO BUSINESS SERVICES FHQ3552ENZOADV512 C26371A","1","2014-04-28 06:16:03","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2466","7","0","9991881","2014-04-28","0","0","2014-04-29","8","","1","","SEM HE COMPRO BUSINESS SERVICES FHQ3552ENZOADV512 C26371A","1","2014-04-28 06:16:19","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2467","11","0","102106","2014-04-28","0","0","2014-04-29","8","","1","","Zollner Electronics Google 1801479-00","2","2014-04-28 12:08:10","207","5","Z2","2","2014-04-28 15:15:43","2","2014-04-28 16:37:24","0","0000-00-00 00:00:00","2","142194","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2468","11","0","102107","2014-04-28","0","0","2014-04-29","8","","1","","Zollner Electronics Google 1801479-00","2","2014-04-28 12:08:48","207","5","Z2","2","2014-04-28 15:18:15","2","2014-04-28 16:37:36","0","0000-00-00 00:00:00","2","142194","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2469","22","0","3474291","2014-04-28","0","0","2014-04-29","16","","8","","Axiom Electronics Intel Chwilhl Interposer SLB00009","2","2014-04-28 12:27:50","5012","4","Foil Only","2","2014-04-28 17:21:08","2","2014-04-28 17:52:58","0","0000-00-00 00:00:00","2","142193","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2470","95","0","252625","2014-04-28","0","0","2014-04-29","11","","1","","Stanford Research Systems  7-02361-701 Rev. D","2","2014-04-29 07:44:44","239","5","","2","2014-04-29 10:18:31","2","2014-04-29 12:03:36","2","2014-04-29 13:37:35","2","142205","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2471","22","0","3474292","2014-04-28","1","0","2014-04-28","20","","4","","","2","2014-04-28 15:57:37","667","4","Foil Only","2","2014-04-28 17:26:21","2","2014-04-28 17:52:41","0","0000-00-00 00:00:00","0","","2","19","2014-04-28 16:16:15","2","1");
INSERT INTO tbl_jobs VALUES("2472","22","0","3474293","2014-04-28","1","0","2014-04-29","20","","4","","","2","2014-04-28 13:22:36","3528","7/5","Z2","2","2014-04-29 15:03:10","2","2014-04-29 16:28:40","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2473","95","0","252626","2014-04-28","0","0","2014-04-29","11","","1","","Stanford Research Systems  7-02139-701 Rev. J","2","2014-04-29 08:21:08","1226","6","18X19","2","2014-04-29 12:03:14","2","2014-04-29 12:58:27","2","2014-04-29 13:37:25","2","142207","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2474","76","0","173034","2014-04-28","1","0","2014-04-29","8","","1","","Piranha EMS, Inc PureWave Networks 181-xx818-003 580-00818-003","2","2014-04-28 22:12:38","6194","4","Z1","2","2014-04-29 10:13:45","2","2014-04-29 10:18:14","2","2014-04-29 10:18:25","2","142204","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2475","29","0","919110","2014-04-28","0","0","2014-04-29","12","","1","","","2","2014-04-29 08:10:06","305","5","Foil Only","2","2014-04-29 09:49:45","2","2014-04-29 10:10:57","2","2014-04-29 10:56:08","2","142206","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2476","3","0","5632165","2014-04-28","0","0","2014-04-29","19.3","","5","","","2","2014-04-29 10:38:44","","","","2","2014-04-29 12:10:08","2","2014-04-29 12:18:24","0","0000-00-00 00:00:00","2","142215","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2477","3","0","5632166","2014-04-28","0","0","2014-04-29","19.3","","5","","","2","2014-04-29 10:39:04","","","","2","2014-04-29 12:24:32","2","2014-04-29 12:18:16","0","0000-00-00 00:00:00","2","142215","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2478","8","0","575050","2014-04-28","0","0","2014-04-29","13","","1","","","2","2014-04-29 08:10:42","","","","2","2014-04-29 10:45:03","2","2014-04-29 11:17:28","2","2014-04-29 12:33:53","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2479","51","0","9931407","2014-04-28","1","0","2014-04-28","14.3","","1","","","2","2014-04-28 16:01:48","","","","2","2014-04-28 17:08:05","2","2014-04-28 18:24:42","2","2014-04-29 07:42:26","0","","2","18","2014-04-28 16:09:49","2","1");
INSERT INTO tbl_jobs VALUES("2480","99","0","148082","2014-04-28","1","0","2014-04-29","13","","1","","SV Probe 78138 STN-000021-01","2","2014-04-28 18:18:49","","","","2","2014-04-28 20:39:01","2","2014-04-29 10:37:27","2","2014-04-29 10:56:16","2","142210","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2481","8","0","575T413","2014-04-28","0","0","2014-04-30","13","","1","","","2","2014-04-28 13:29:01","","","","2","2014-04-28 21:14:56","2","2014-04-28 21:15:01","0","0000-00-00 00:00:00","2","142203","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2482","97","0","4792345","2014-04-28","1","0","2014-04-28","15","","1","","","2","2014-04-28 14:12:23","2058","4","18X18","2","2014-04-28 15:47:02","2","2014-04-28 16:37:14","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2483","59","0","343316","2014-04-28","1","0","2014-04-29","9","","1","","Meritronics JuicedLink JL-09-0032-02 Microsoft X896370-001","2","2014-04-28 16:44:57","5044","3","Z2","2","2014-04-28 19:51:50","2","2014-04-28 21:14:36","2","2014-04-29 07:42:10","2","142199","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2484","44","0","954034","2014-04-28","1","0","2014-04-28","18","","4","","Mini w/ep","2","2014-04-28 14:22:09","",".003 ep","Foil Only","2","2014-04-28 18:34:44","2","2014-04-28 19:04:14","0","0000-00-00 00:00:00","2","142201","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2485","88","0","6092054","2014-04-28","0","1","2014-05-02","17","","15","","Sanmina LM / PROCERUS 2911 PRI","2","2014-04-30 14:28:08","9998","4","Z2","2","2014-04-30 20:35:43","2","2014-04-30 21:29:48","0","0000-00-00 00:00:00","2","142266","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2486","73","0","166016","2014-04-28","0","0","2014-04-29","19","","15","","Paine Electronics 51101-867-01 Rev C 51101-957-01 Rev A","2","2014-04-29 08:20:36","1170","6","Foil Only","2","2014-04-29 11:19:31","2","2014-04-29 11:52:53","0","0000-00-00 00:00:00","2","142213","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2487","4","0","321828R","2014-04-28","0","0","2014-05-05","16","","1","1077 Gibraltar Drive,\r\nMilpitas  CA  95035-","Flextronics Motorola MOT1-594607-001-00 Fab 594606-001-00 Rev. A","2","2014-05-05 15:04:41","","","","2","2014-05-05 21:54:19","2","2014-05-06 08:40:31","2","2014-05-06 10:17:01","0","","2","28","2014-05-05 15:42:06","2","1");
INSERT INTO tbl_jobs VALUES("2488","31","0","7582275R","2014-04-28","1","0","2014-04-29","19","","5","","","2","2014-04-29 08:10:53","","","","2","2014-04-29 11:54:11","2","2014-04-29 12:02:32","0","0000-00-00 00:00:00","0","","2","21","2014-04-29 12:03:54","2","1");
INSERT INTO tbl_jobs VALUES("2489","51","0","9931408","2014-04-28","0","0","2014-04-29","17","","1","","Javad 05-588200-08 Rev 1.1","2","2014-04-29 10:01:36","264","5","18X18","2","2014-04-29 13:22:01","2","2014-04-29 14:30:15","2","2014-04-29 14:30:52","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2490","121","0","949020","2014-04-28","0","0","2014-04-29","18","","5","","","2","2014-04-28 16:45:59","","","","2","2014-04-28 18:50:08","2","2014-04-29 10:43:52","0","0000-00-00 00:00:00","2","142196","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2491","121","0","949021","2014-04-28","0","0","2014-04-29","18","","5","","","2","2014-04-28 16:46:43","","","","2","2014-04-29 10:43:17","2","2014-04-29 10:43:47","0","0000-00-00 00:00:00","2","142196","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2492","11","0","102108","2014-04-28","0","0","2014-04-30","12","","1","","","2","2014-04-29 18:15:13","1139","4","Z2","2","2014-04-29 19:21:08","2","2014-04-30 14:24:06","0","0000-00-00 00:00:00","2","142256","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2493","11","0","102109","2014-04-28","0","0","2014-04-30","12","","1","","","2","2014-04-29 18:15:36","2395","4","Z2","2","2014-04-29 19:24:39","2","2014-04-30 14:24:15","0","0000-00-00 00:00:00","2","142256","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2494","5","0","4894505","2014-04-28","0","0","2014-04-30","8","","1","","OnCore Manufacturing Zeltiq 200192 APPLICATOR REV A RoHS","2","2014-04-29 14:08:33","735","5","Z2","2","2014-04-29 19:58:06","2","2014-04-30 08:05:50","2","2014-04-30 08:17:00","2","142226","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2495","5","0","4894506","2014-04-28","0","0","2014-04-30","8","","1","","OnCore Manufacturing Zeltiq 200192 APPLICATOR REV A RoHS","2","2014-04-29 14:08:46","436","5","Z2","2","2014-04-29 19:53:28","2","2014-04-30 08:06:00","2","2014-04-30 08:16:52","2","142226","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2496","9","0","2814048","2014-04-28","1","0","2014-04-29","12","","1","","Sanmina Lite Point LPT802-11-A74 ASM Rev D1","2","2014-04-29 09:30:58","887","5","Z2","2","2014-04-29 11:08:55","2","2014-04-29 12:26:21","2","2014-04-29 12:33:41","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2497","4","0","321835","2014-04-29","1","0","2014-04-30","17","","1","","INTEL MGD RVP BBOARD - SKT FAB: H28340-001 LEAD FREE","2","2014-04-29 09:58:14","4234","6\\\\3","Z2","2","2014-04-30 18:49:41","2","2014-04-30 19:44:14","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2498","8","0","575T419","2014-04-29","0","0","2014-05-01","12","","1","","","2","2014-04-30 13:17:41","","","","2","2014-05-01 11:34:45","2","2014-05-01 12:10:51","0","0000-00-00 00:00:00","2","142253","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2499","8","0","575T420","2014-04-29","0","0","2014-05-01","12","","1","","","2","2014-04-30 13:17:50","","","","2","2014-05-01 11:35:12","2","2014-05-01 12:11:04","0","0000-00-00 00:00:00","2","142253","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2500","8","0","575T421","2014-04-29","0","0","2014-05-01","12","","1","","Jabil Circuit Gigamon GS132-0017-400-J1","2","2014-04-30 13:18:20","","","","2","2014-05-01 11:34:55","2","2014-05-01 12:11:14","0","0000-00-00 00:00:00","2","142253","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2501","8","0","575T422","2014-04-29","0","0","2014-05-01","12","","1","","","2","2014-04-30 13:18:30","","","","2","2014-05-01 11:34:22","2","2014-05-01 12:11:24","0","0000-00-00 00:00:00","2","142253","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2502","8","0","575T423","2014-04-29","0","0","2014-05-01","12","","1","","","2","2014-04-30 13:18:45","","","","2","2014-05-01 11:35:03","2","2014-05-01 12:11:36","0","0000-00-00 00:00:00","2","142253","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2503","72","0","1262761","2014-04-29","0","0","2014-04-29","18","","1","","Pactron Incorporated PAC3034_29April2014_ WO24952_T(LeadFree)","2","2014-04-29 07:45:40","8159","4","Z2","2","2014-04-29 10:43:16","2","2014-04-29 12:43:04","2","2014-04-29 13:38:21","2","142212","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2504","72","0","1262762","2014-04-29","0","0","2014-04-29","18","","1","","Pactron Incorporated PAC3035_29April2014_ WO24952_B(LeadFree)","2","2014-04-29 07:51:40","5731","4","Z2","2","2014-04-29 10:34:40","2","2014-04-29 12:43:13","2","2014-04-29 13:38:30","2","142211","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2505","72","0","1262763","2014-04-29","0","0","2014-04-29","18","","1","","Pactron Incorporated PAC3036_29April2014_ WO25055_T(LeadFree)","2","2014-04-29 07:52:41","","6","","2","2014-04-29 11:30:40","2","2014-04-29 11:55:15","2","2014-04-29 13:38:44","2","142214","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2506","57","0","767135","2014-04-29","1","0","2014-04-29","16","","10","","NextGen RF Design 046138-1-1 (ASSY-1014)","2","2014-04-29 11:35:29","263","3","Foil Only","2","2014-04-29 13:36:31","2","2014-04-29 13:46:27","0","0000-00-00 00:00:00","2","142220","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2507","1","0","8292580","2014-04-29","0","0","2014-04-30","9","","1","","IDSBG 920-00301","2","2014-04-29 10:46:43","430","4","Z2","2","2014-04-29 12:07:22","2","2014-04-29 13:10:04","2","2014-04-29 14:58:38","2","142216","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2508","3","0","5632167","2014-04-29","0","0","2014-04-30","16","","4","","Intel Corporation Sonora Xilinx Bridge PB","2","2014-04-29 18:24:40","220","5","","2","2014-04-30 17:57:16","2","2014-04-30 18:13:22","0","0000-00-00 00:00:00","2","142248","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2509","3","0","5632168","2014-04-29","0","0","2014-04-30","16","","4","","","2","2014-04-29 18:25:01","808","6","","2","2014-04-30 17:30:06","2","2014-04-30 17:46:12","0","0000-00-00 00:00:00","2","142248","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2510","8","0","575424","2014-04-29","0","0","2014-04-30","18","","1","","Jabil Circuit Arista ST-ASPCA-00461-04-01-T ASFAB-00245-04","2","2014-04-30 10:25:11","7598","5","Z2","2","2014-04-30 13:13:49","2","2014-04-30 14:12:24","0","0000-00-00 00:00:00","2","142245","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2511","8","0","575425","2014-04-29","0","0","2014-04-30","18","","1","","Jabil Circuit Arista ST-ASPCA-00461-04-01-B ASFAB-00245-04","2","2014-04-30 10:25:48","2223","5","Z2","2","2014-04-30 12:07:11","2","2014-04-30 14:12:11","0","0000-00-00 00:00:00","2","142245","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2512","8","0","575T424","2014-04-29","0","0","2014-04-30","18","","1","","","2","2014-04-29 17:01:20","","","","2","2014-04-30 20:26:42","2","2014-04-30 20:26:59","0","0000-00-00 00:00:00","2","142245","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2513","8","0","575T425","2014-04-29","0","0","2014-04-30","18","","1","","","2","2014-04-29 17:01:12","","","","2","2014-04-30 20:27:36","2","2014-04-30 20:28:06","0","0000-00-00 00:00:00","2","142245","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2514","2","0","5346890","2014-04-29","0","0","2014-04-30","12","","1","","","2","2014-04-29 12:29:24","448","5","Z2","2","2014-04-29 15:31:28","2","2014-04-29 16:58:52","2","2014-04-30 08:17:12","2","142217","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2515","90","0","834100","2014-04-29","0","0","2014-05-02","15","","1","","","2","2014-04-29 12:06:42","","","","2","2014-04-30 08:52:46","2","2014-04-30 10:27:11","2","2014-04-30 11:33:22","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2516","2","0","5346891","2014-04-29","0","0","2014-04-30","12","","1","","","2","2014-04-29 13:26:51","248","5","Z2","2","2014-04-29 15:06:24","2","2014-04-29 16:59:04","2","2014-04-30 08:17:06","2","142229","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2517","2","0","5346892","2014-04-29","0","0","2014-04-30","13","","1","","Sanmina Ruckus 120-11271-001 Rev-2","2","2014-04-29 16:40:00","1416","5","Z2","2","2014-04-30 09:13:41","2","2014-04-30 12:25:32","2","2014-04-30 12:44:26","2","142233","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2518","1","0","8292577F","2014-04-29","1","0","2014-04-29","15","","1","","Foxconn iDSBG IDSBG 920-1181-03","2","2014-04-29 13:52:04","10","","","2","2014-04-29 14:40:42","2","2014-04-29 14:45:16","2","2014-04-29 14:58:26","2","142227","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2519","2","0","5346893","2014-04-29","0","0","2014-04-30","14","","1","","Sanmina Ruckus 120-11272-001 Rev-2","2","2014-04-29 16:40:46","348","5","Z2","2","2014-04-30 10:11:07","2","2014-04-30 12:28:10","2","2014-04-30 12:44:32","2","142240","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2520","67","0","981116","2014-04-29","0","1","2014-05-01","14","","1","","KEYNOTE FAKE USB CHARGER 2.0","2","2014-04-30 08:57:18","438","5","Z2","2","2014-04-30 12:58:53","2","2014-04-30 14:24:35","0","0000-00-00 00:00:00","2","142254","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2521","29","0","919111","2014-04-29","0","0","2014-04-30","14","","1","","CBA Electronics Corp SiTune","2","2014-04-30 06:22:44","1230","4","Foil Only","2","2014-04-30 09:26:50","2","2014-04-30 11:02:52","2","2014-04-30 11:02:59","2","142236","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2522","3","0","5632162A","2014-04-29","1","0","2014-04-29","18.3","","4","","","2","2014-04-29 15:01:25","","5 AND 4","Foil Only","2","2014-04-29 16:52:52","2","2014-04-29 17:52:44","0","0000-00-00 00:00:00","2","142225","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2523","59","0","343317","2014-04-29","1","0","2014-04-30","9","","1","","Meritronics BAE System RH45 TestChip3 Muse ADM Rear Panel","2","2014-04-29 18:37:24","2607","5","Z3","2","2014-04-29 20:23:53","2","2014-04-30 07:55:28","2","2014-04-30 07:55:36","2","142228","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2524","6","0","739364","2014-04-29","0","0","2014-04-30","15","","1","","","2","2014-04-30 06:56:27","","","","2","2014-04-30 08:50:28","2","2014-04-30 09:44:24","2","2014-04-30 11:02:41","2","142238","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2525","10","0","2392980","2014-04-29","0","0","2014-04-30","16","","1","","AsteelFlash THALES FSSY4458 1203A195 rev 1","2","2014-05-02 09:06:27","1281","5","Z2","2","2014-05-02 11:06:11","2","2014-05-02 13:55:51","0","0000-00-00 00:00:00","2","142294","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2526","10","0","2392981","2014-04-29","0","0","2014-04-30","15","","1","","AsteelFlash THALES FSSY4460 1203X196 rev 1","2","2014-04-30 10:05:13","6311","4","Z2","2","2014-04-30 11:40:33","2","2014-04-30 14:06:26","0","0000-00-00 00:00:00","2","142248","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2527","51","0","9931409","2014-04-29","0","0","2014-04-30","17","","1","","Javad 05-610221-31 Rev 1.1","2","2014-04-30 06:47:15","207","5","18X18","2","2014-04-30 12:29:55","2","2014-04-30 14:10:39","0","0000-00-00 00:00:00","0","","2","22","2014-04-30 13:45:20","2","1");
INSERT INTO tbl_jobs VALUES("2528","57","0","767136","2014-04-29","1","0","2014-04-30","17","","10","","","2","2014-04-30 11:51:51","232","6","Foil Only","2","2014-04-30 14:25:35","2","2014-04-30 14:54:42","0","0000-00-00 00:00:00","2","142251","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2529","51","0","9931410","2014-04-29","0","0","2014-05-01","8","","1","","Javad 05-610221-32 Rev 1.1","2","2014-04-30 06:47:41","47","5","18X18","2","2014-04-30 12:26:38","2","2014-04-30 14:10:50","0","0000-00-00 00:00:00","0","","2","23","2014-04-30 13:45:54","2","1");
INSERT INTO tbl_jobs VALUES("2530","70","0","1105151","2014-04-29","0","0","2014-05-01","8","","1","","","2","2014-04-30 09:32:47","3254","5","Z2","2","2014-04-30 12:39:09","2","2014-04-30 14:06:48","0","0000-00-00 00:00:00","2","142252","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2531","97","0","4792346","2014-04-29","0","1","2014-05-01","17","","1","","Surface Art IN-JARVIS MAIN REV C AVRB3110-01C","2","2014-05-01 12:42:59","","","","2","2014-05-01 14:44:19","2","2014-05-01 14:55:55","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2532","97","0","4792347","2014-04-29","0","1","2014-05-01","17","","1","","Surface Art IN-JARVIS MAIN REV C AVRB3110-01C","2","2014-05-01 12:42:47","","","","2","2014-05-01 14:44:12","2","2014-05-01 14:56:30","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2533","72","0","1262764","2014-04-30","0","0","2014-04-30","17","","1","","Pactron Incorporated PAC3038_30April2014_ WO25061_T, WO25088_T(LeadFree)","2","2014-04-30 07:15:47","773","4","Z2","2","2014-04-30 12:03:10","2","2014-04-30 14:19:04","0","0000-00-00 00:00:00","2","142247","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2534","34","0","7994771","2014-04-30","1","0","2014-04-30","19","","1","","Creation Technologies Redwood Systems 81-00043-02_Zion TREDS068_LF","2","2014-04-30 13:00:52","5687","5","Z2","2","2014-04-30 16:01:18","2","2014-04-30 17:52:18","2","2014-05-01 07:36:19","2","142258","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2535","88","0","6092055","2014-04-30","0","0","2014-05-01","15.3","","15","","","2","2014-04-30 13:38:35","3050","5","Z2","2","2014-04-30 15:51:37","2","2014-04-30 17:52:40","0","0000-00-00 00:00:00","2","142261","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2536","110","0","952390","2014-04-30","0","0","2014-05-01","10","","1","","Unitron  LS-163m1","2","2014-05-08 10:45:13","1454","5","18X18","2","2014-05-08 13:41:40","2","2014-05-08 16:01:24","0","0000-00-00 00:00:00","2","142388","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2537","2","0","5346894","2014-04-30","0","0","2014-05-02","10","","1","","APERTURE COUNT ALTERA NF5_1932C_HSSI_PLL REV.B","2","2014-05-01 06:49:50","4880","6/5 step","Z3","2","2014-05-01 21:02:48","2","2014-05-01 21:52:13","2","2014-05-02 08:52:43","2","142283","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2538","2","0","5346895","2014-04-30","1","0","2014-05-02","10","","1","","","2","2014-05-01 06:50:42","2096","6/5 Step","Z3","2","2014-05-02 10:13:19","2","2014-05-02 14:12:43","0","0000-00-00 00:00:00","2","142295","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2539","50","0","630337","2014-04-30","0","0","2014-05-01","10","","1","","Jabil ETS Jabil San Jose GoPro Hawaii Interposer","2","2014-04-30 18:10:52","2860","4","Z2","2","2014-04-30 19:44:03","2","2014-04-30 20:25:01","2","2014-05-01 07:37:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2540","50","0","630338","2014-04-30","0","0","2014-05-01","11","","1","","","2","2014-04-30 18:12:21","2428","4","Z2","2","2014-04-30 19:29:52","2","2014-04-30 20:42:38","2","2014-05-01 07:37:11","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2541","104","0","559707","2014-04-30","0","1","2014-05-01","19.3","","8","","","2","2014-05-01 12:47:52","","","","2","2014-05-01 14:44:25","2","2014-05-02 12:30:59","0","0000-00-00 00:00:00","2","142273","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2542","1","0","8292582","2014-04-30","0","0","2014-05-01","11","","1","","IDSBG 920-00141-01","2","2014-04-30 14:28:25","402","3","Z2","2","2014-04-30 19:40:23","2","2014-04-30 20:18:56","2","2014-05-01 07:37:21","2","142257","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2543","43","0","5413975","2014-04-30","0","0","2014-05-01","12","","1","","Infiniti Solutions PNI SENTRALDEVKIT Rev B Job","2","2014-05-01 19:18:53","930","4","Z2","2","2014-05-01 19:57:34","2","2014-05-01 20:14:26","2","2014-05-02 08:52:32","2","142272","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2544","34","0","7994772","2014-04-30","0","0","2014-05-01","12","","1","","Creation Tech. GATAN FAB","2","2014-05-01 07:43:01","1637","5","Z2","2","2014-05-01 09:39:08","2","2014-05-01 12:08:50","2","2014-05-01 12:16:19","2","142262","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2545","34","0","7994773","2014-04-30","0","0","2014-05-01","12","","1","","Creation Tech. GATAN FAB","2","2014-05-01 07:43:51","333","5","Z2","2","2014-05-01 09:58:52","2","2014-05-01 12:00:34","2","2014-05-01 12:16:30","2","142262","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2546","9","0","2814049","2014-04-30","0","0","2014-05-12","10","","1","","Sanmina Cooledge Cooledge Light Sheet 20-0267 R04","2","2014-05-09 17:44:32","1756","5","Z3","2","2014-05-09 19:55:17","2","2014-05-09 21:22:54","2","2014-05-12 07:53:49","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2547","7","0","9991882","2014-04-30","1","0","2014-05-01","15","","1","","","2","2014-05-01 07:54:15","284","8","Z1","2","2014-05-01 09:20:57","2","2014-05-01 10:09:37","2","2014-05-01 10:31:55","2","142264","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2548","59","0","343318","2014-04-30","1","0","2014-05-01","9","","1","","Meritronics BAE RH45TC3 TypeC PalPilot 199-00148-01 R1","2","2014-04-30 17:34:54","2373","5","Z2","2","2014-04-30 20:12:03","2","2014-04-30 21:29:22","2","2014-05-01 07:36:31","2","142259","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2549","59","0","343319","2014-04-30","1","0","2014-05-01","9","","1","","Meritronics BAE RH45TC3 Type C PalPilot 199-00148-01 R1","2","2014-04-30 17:35:14","2432","5","Z2","2","2014-04-30 19:58:02","2","2014-04-30 20:37:20","2","2014-05-01 07:36:41","2","142259","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2550","59","0","343320","2014-04-30","1","0","2014-05-01","9","","1","","PalPilot 199-00151-01 R1","2","2014-04-30 15:58:30","918","5","Foil Only","2","2014-04-30 20:44:15","2","2014-04-30 21:29:29","2","2014-05-01 07:36:50","2","142259","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2551","5","0","4894507","2014-04-30","0","0","2014-05-01","16","","1","","OnCore Manufacturing Zeltiq 200198 TEC CONTROL REV A RoHS","2","2014-05-01 10:42:33","649","5","Z2","2","2014-05-01 12:38:54","2","2014-05-01 16:35:20","0","0000-00-00 00:00:00","2","142271","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2552","5","0","4894508","2014-04-30","1","0","2014-05-01","16","","1","","OnCore Manufacturing Zeltiq 200198 TEC CONTROL REV A RoHS","2","2014-05-01 10:42:57","295","7","Z2","2","2014-05-01 12:41:58","2","2014-05-01 15:23:37","0","0000-00-00 00:00:00","2","142271","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2553","5","0","4894512","2014-04-30","1","0","2014-05-01","16","","1","","OnCore Manufacturing Zeltiq 200203 FLEX CIRCUI REV A RoHS","2","2014-05-01 10:44:20","12","6","Z2","2","2014-05-01 12:45:03","2","2014-05-01 15:04:52","0","0000-00-00 00:00:00","2","142270","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2554","5","0","4894510","2014-04-30","0","0","2014-05-01","16","","1","","OnCore Manufacturing Zeltiq 200201 FLEX CIRCUI REV A  RoHS","2","2014-05-01 10:43:40","12","6","Z2","2","2014-05-01 13:34:35","2","2014-05-01 16:01:24","0","0000-00-00 00:00:00","2","142275","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2555","5","0","4894511","2014-04-30","0","0","2014-05-01","16","","1","","OnCore Manufacturing Zeltiq 200202 FLEX CIRCUI REV A  RoHS","2","2014-05-01 10:44:01","12","6","Z2","2","2014-05-01 13:01:29","2","2014-05-01 15:24:09","0","0000-00-00 00:00:00","2","142267","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2556","5","0","4894509","2014-04-30","0","0","2014-05-01","16","","1","","OnCore Manufacturing Zeltiq 200204 FLEX CIRCU REV A  RoHS","2","2014-05-01 10:43:17","16","6","Z2","2","2014-05-01 13:37:21","2","2014-05-01 16:01:52","0","0000-00-00 00:00:00","2","142277","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2557","51","0","9931412","2014-04-30","0","0","2014-05-01","16","","1","","Javad Ixia 650-1389-001 Rev 1","2","2014-04-30 22:56:19","2851","5","18X18","2","2014-05-01 10:43:22","2","2014-05-01 12:15:42","0","0000-00-00 00:00:00","0","","2","24","2014-05-01 13:38:06","2","1");
INSERT INTO tbl_jobs VALUES("2558","5","0","4894514","2014-04-30","1","0","2014-05-01","17","","1","","OnCore Manufacturing Zeltiq 200200 UPPER AC REV B RoHS","2","2014-05-01 10:45:45","131","7","Z2","2","2014-05-01 13:32:33","2","2014-05-01 15:05:09","0","0000-00-00 00:00:00","2","142277","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2559","5","0","4894513","2014-04-30","0","0","2014-05-01","17","","1","","OnCore Manufacturing Zeltiq 200193 LOWER AC REV A  RoHS","2","2014-05-01 10:45:09","23","8","Z2","2","2014-05-01 13:40:56","2","2014-05-01 16:06:38","0","0000-00-00 00:00:00","2","142274","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2560","11","0","102110","2014-04-30","1","0","2014-05-02","15","","1","","Zollner Electronics Credence  1799411-00_Trident Rev E7 5092350-00 ( Top side )","2","2014-05-01 19:07:26","1892","4","Z2","2","2014-05-02 10:07:30","2","2014-05-02 13:59:21","0","0000-00-00 00:00:00","2","142289","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2561","11","0","102111","2014-04-30","1","0","2014-05-02","15","","1","","Zollner Electronics Credence 1799411-00_Trident Rev E7 5092351-00 ( Bottom side)","2","2014-05-01 19:07:09","760","4","Z2","2","2014-05-02 10:54:36","2","2014-05-02 14:06:47","0","0000-00-00 00:00:00","2","142289","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2562","5","0","4894515","2014-04-30","0","0","2014-05-01","17","","1","","OnCore Manufacturing Zeltiq 200189 COMPUTER REV A  RoHS","2","2014-05-01 10:46:29","699","5","Z2","2","2014-05-01 12:47:35","2","2014-05-01 15:14:47","0","0000-00-00 00:00:00","2","142269","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2563","5","0","4894516","2014-04-30","0","0","2014-05-01","17","","1","","OnCore Manufacturing Zeltiq 200189 COMPUTER REV A RoHS","2","2014-05-01 10:47:13","101","5","Z2","2","2014-05-01 12:35:07","2","2014-05-01 16:36:23","0","0000-00-00 00:00:00","2","142269","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2564","5","0","4894517","2014-04-30","0","0","2014-05-01","17","","1","","OnCore Manufacturing Zeltiq 200191 CIB REV A RoHS","2","2014-05-01 10:47:39","1839","5","Z2","2","2014-05-01 13:06:45","2","2014-05-01 16:17:52","0","0000-00-00 00:00:00","2","142276","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2565","5","0","4894518","2014-04-30","0","0","2014-05-01","17","","1","","OnCore Manufacturing Zeltiq 200191 CIB REV A RoHS","2","2014-05-01 10:48:06","282","7","Z2","2","2014-05-01 13:30:02","2","2014-05-01 15:05:32","0","0000-00-00 00:00:00","2","142276","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2566","35","0","800213","2014-04-30","1","0","2014-05-02","16","","1","","Creation Technologies Arnouse Fab","2","2014-05-01 08:54:22","8632","5/4","Z2","2","2014-05-05 13:42:44","2","2014-05-05 13:58:35","2","2014-05-05 15:04:01","2","142311","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2567","35","0","800214","2014-04-30","1","0","2014-05-02","16","","1","","Creation Technologies Arnouse Fab","2","2014-05-01 08:55:02","6708","4/3","Z2","2","2014-05-05 10:29:49","2","2014-05-05 13:40:34","2","2014-05-05 15:03:55","2","142312","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2568","6","0","739365","2014-04-30","0","0","2014-05-02","8","","1","","","2","2014-05-01 08:37:58","","","","2","2014-05-01 14:43:06","2","2014-05-01 14:43:21","2","2014-05-02 07:49:06","2","142278","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2569","2","0","5346896","2014-04-30","0","1","2014-05-01","16","","1","","Sanmina Alcatel 82-0715-01 Rev 04 APERTURE COUNT","2","2014-04-30 23:45:26","2630","5","Z2","2","2014-05-01 09:31:01","2","2014-05-01 12:09:54","0","0000-00-00 00:00:00","2","142263","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2570","2","0","5346897","2014-04-30","0","1","2014-05-01","16","","1","","Sanmina Alcatel 82-0715-01 Rev 04 APERTURE COUNT","2","2014-04-30 23:46:15","3944","5","Z2","2","2014-05-01 09:49:50","2","2014-05-01 12:10:05","0","0000-00-00 00:00:00","2","142263","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2571","2","0","5346898","2014-04-30","0","1","2014-05-05","8","","1","","Sanmina Intel  HC100_BOB","1","2014-05-01 03:24:48","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2572","2","0","5346899","2014-04-30","0","1","2014-05-02","8","","1","","Sanmina Intel  HC100_BOB","2","2014-05-01 08:14:29","2630","6","Z3","2","2014-05-01 12:53:46","2","2014-05-01 15:59:05","0","0000-00-00 00:00:00","2","142268","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2573","35","0","800215","2014-04-30","1","0","2014-05-02","17","","1","","Creation Technologies Arnouse Fab","2","2014-05-05 00:26:52","10724","5/4","Z2","2","2014-05-05 13:42:48","2","2014-05-05 15:24:32","0","0000-00-00 00:00:00","2","142304","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2574","35","0","800216","2014-04-30","1","0","2014-05-02","17","","1","","","2","2014-05-01 15:11:17","7128","4/3","Z2","2","2014-05-05 14:39:32","2","2014-05-05 15:55:34","0","0000-00-00 00:00:00","2","142304","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2575","70","0","1105152","2014-04-30","0","0","2014-05-01","17","","1","","Oncore TCLN 25-1290@AJ, 25-1312@AF TOP SIDE","2","2014-05-01 08:54:35","2420","4","Z2","2","2014-05-01 12:57:44","2","2014-05-01 16:07:17","2","2014-05-08 10:10:33","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2576","35","0","800217","2014-04-30","1","0","2014-05-02","16","","1","","Creation Tech. SNJ Intel_Braswell Fab","2","2014-05-02 13:26:47","8675","6/4","Z2","2","2014-05-02 18:01:26","2","2014-05-02 18:23:07","2","2014-05-05 07:47:44","2","142305","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2577","35","0","800218","2014-04-30","1","0","2014-05-02","16","","1","","Creation Tech. SNJ Intel_Braswell Fab","2","2014-05-02 07:48:48","3099","5\\\\4","Z2","2","2014-05-02 14:55:53","2","2014-05-02 16:19:19","0","0000-00-00 00:00:00","2","142308","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2578","2","0","5346900","2014-05-01","0","0","2014-05-02","10","","1","","Sanmina synopsys SH100000446 Rev-0.0","2","2014-05-01 19:07:46","2669","5","Z2","2","2014-05-02 10:18:09","2","2014-05-02 13:43:46","0","0000-00-00 00:00:00","2","142288","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2579","51","0","9931413","2014-05-01","0","0","2014-05-02","11","","1","","","2","2014-05-01 12:37:32","232","6","18X18","2","2014-05-01 18:21:35","2","2014-05-01 20:06:02","2","2014-05-02 08:52:54","0","","2","25","2014-05-02 07:52:32","2","1");
INSERT INTO tbl_jobs VALUES("2580","99","0","148080R","2014-05-01","1","0","2014-05-01","13","","1","","","2","2014-05-01 12:03:15","","","","2","2014-05-01 12:35:23","2","2014-05-01 15:55:32","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2581","95","0","252627","2014-05-01","0","0","2014-05-02","12","","1","","Stanford Research Systems  7-02481-701 Rev.A 5/1/14","2","2014-05-01 19:09:11","422","5","","2","2014-05-02 11:15:07","2","2014-05-02 13:32:40","0","0000-00-00 00:00:00","2","142293","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2582","35","0","800219","2014-05-01","1","0","2014-05-05","8","","1","1873 Barber Lane\r\nMilpitas  ca","Creation Tech. SNJ JUMPGEN Fab","2","2014-05-02 07:33:54","13561","6/5","Z3","2","2014-05-02 20:49:04","2","2014-05-02 21:20:00","2","2014-05-05 07:47:25","2","142315","2","26","2014-05-02 22:39:18","2","1");
INSERT INTO tbl_jobs VALUES("2583","35","0","800220","2014-05-01","1","0","2014-05-02","17","","1","","","2","2014-05-02 07:33:19","5520","5","Z3","2","2014-05-02 15:22:26","2","2014-05-02 16:25:36","0","0000-00-00 00:00:00","2","142310","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2584","97","0","4792349","2014-05-01","0","0","2014-05-02","13","","1","","","2","2014-05-01 17:19:19","2741","5","18X18","2","2014-05-01 21:53:43","2","2014-05-02 08:58:03","2","2014-05-02 10:14:27","2","142284","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2585","34","0","7994772F","2014-05-01","1","0","2014-05-01","18","","1","","","2","2014-05-01 13:48:45","","","","2","2014-05-01 15:11:41","2","2014-05-01 15:30:49","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2586","22","0","3474294","2014-05-01","0","0","2014-05-02","16","","8","","Axiom Electronics Cloud Cap 905000389 STB000335","2","2014-05-02 10:33:19","1790","5","Foil Only","2","2014-05-02 15:02:34","2","2014-05-02 15:11:47","0","0000-00-00 00:00:00","2","142298","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2587","59","0","343321","2014-05-01","1","0","2014-05-02","9","","1","","Meritronics EFI 45125853 Bonito_U1.1","2","2014-05-01 19:06:06","5958","5","Z2","2","2014-05-01 21:18:12","2","2014-05-01 21:51:50","2","2014-05-02 07:48:47","2","142279","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2588","59","0","343322","2014-05-01","1","0","2014-05-02","9","","1","","Meritronics EFI 45126214 Rev.U1 LocoLabs 91-00256-00","2","2014-05-01 19:05:29","2170","5","Z2","2","2014-05-01 21:09:23","2","2014-05-01 21:51:55","2","2014-05-02 07:48:55","2","142279","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2589","8","0","575426","2014-05-01","0","1","2014-05-05","14","","1","","Jabil LTX 974-1562-00-BA-T 948-1562-00-BA","2","2014-05-02 08:25:35","10711","5","Z3","2","2014-05-05 20:42:08","2","2014-05-05 20:53:22","2","2014-05-06 08:09:50","2","142326","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2590","8","0","575427","2014-05-01","0","1","2014-05-05","14","","1","","Jabil LTX 974-1562-00-BA-B 948-1562-00-BA","2","2014-05-02 08:25:52","10818","5","Z3","2","2014-05-05 19:50:17","2","2014-05-05 20:09:02","2","2014-05-06 08:09:58","2","142326","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2591","29","0","919112","2014-05-01","0","0","2014-05-02","15","","1","","","2","2014-05-02 07:32:16","505","5","Foil Only","2","2014-05-02 14:04:42","2","2014-05-02 14:16:12","0","0000-00-00 00:00:00","2","142303","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2592","22","0","3474295","2014-05-01","0","0","2014-05-02","16","","8","","Axiom Electronics Cloud Cap 905000390 STB000334","2","2014-05-02 10:33:36","2186","5","Foil Only","2","2014-05-02 14:33:12","2","2014-05-02 14:35:39","0","0000-00-00 00:00:00","2","142298","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2593","22","0","3474296","2014-05-01","0","0","2014-05-02","17","","8","","Axiom Electronics Cloud Cap 905000391 STP000867","2","2014-05-02 10:33:53","943","4","Foil Only","2","2014-05-02 14:56:08","2","2014-05-02 15:12:08","0","0000-00-00 00:00:00","2","142313","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2594","2","0","5346901","2014-05-01","0","0","2014-05-02","16","","1","","Sanmina synopsys SH100000359 Rev-1.0","2","2014-05-02 05:57:07","1856","5","Z2","2","2014-05-02 11:51:38","2","2014-05-02 14:34:10","0","0000-00-00 00:00:00","2","142297","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2595","2","0","5346902","2014-05-01","0","0","2014-05-02","17","","1","","Sanmina Newisys PCA-00668-01-B","2","2014-05-02 05:57:55","681","5","Z2","2","2014-05-02 14:47:38","2","2014-05-02 16:39:00","0","0000-00-00 00:00:00","2","142314","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2596","70","0","1105153","2014-05-01","0","0","2014-05-05","8","","1","","Oncore TORA 0500-0301@03 TOP SIDE","2","2014-05-02 09:05:50","34","5","Z2","2","2014-05-02 15:52:17","2","2014-05-02 18:07:58","2","2014-05-09 08:08:03","2","142405","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2597","70","0","1105154","2014-05-01","0","0","2014-05-05","8","","1","","Oncore TORA 0500-0201@06 TOP SIDE","2","2014-05-02 09:06:14","76","5","Z2","2","2014-05-02 16:05:21","2","2014-05-02 18:08:12","2","2014-05-09 08:08:12","2","142406","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2598","97","0","4792350","2014-05-01","0","0","2014-05-05","8","","1","","","2","2014-05-02 07:32:44","3654","5","Z2","2","2014-05-02 12:05:06","2","2014-05-02 14:34:35","0","0000-00-00 00:00:00","2","142296","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2599","7","0","9991885","2014-05-02","0","0","2014-05-06","14","","1","","","2","2014-05-06 10:49:34","1816","6","Z1","2","2014-05-06 12:05:58","2","2014-05-06 12:27:58","2","2014-05-06 13:33:03","2","142301","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2600","7","0","9991886","2014-05-02","0","0","2014-05-05","8","","1","","","1","2014-05-02 05:40:06","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2601","7","0","9991887","2014-05-02","0","0","2014-05-05","8","","1","","SEM HE Wentworth Laboratories 4-914-0094:B_54887A1 Apt count =","2","2014-05-02 12:06:00","336","8","Z1","2","2014-05-02 18:15:05","2","2014-05-02 18:21:25","2","2014-05-05 07:47:10","2","142302","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2602","7","0","9991888","2014-05-02","0","0","2014-05-05","8","","1","","","1","2014-05-02 05:40:30","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2603","7","0","9991889","2014-05-02","0","0","2014-05-05","8","","1","","","2","2014-05-02 12:06:25","505","8","Z1","2","2014-05-02 17:27:25","2","2014-05-02 17:38:40","2","2014-05-05 07:46:58","2","142300","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2604","7","0","9991890","2014-05-02","0","0","2014-05-05","8","","1","","","1","2014-05-02 06:23:16","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2605","74","0","152005","2014-05-02","1","0","2014-05-02","12.3","","1","","Hot.  Nanocoat","2","2014-05-02 11:06:38","1410","3","Z2","2","2014-05-02 12:22:24","2","2014-05-02 13:42:21","2","2014-05-02 13:42:48","2","142292","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2606","19","0","835271","2014-05-02","0","0","2014-05-05","17","","15","","Applied Technologies  072-506992-001 Rev. A","2","2014-05-02 14:33:26","1928","6","Z2","2","2014-05-05 08:15:16","2","2014-05-05 13:35:28","0","0000-00-00 00:00:00","2","142319","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2607","7","0","9991883","2014-05-02","0","0","2014-05-05","17","","1","","SEM HE Form Factor Inc. 200-40086 (350-40086):1","2","2014-05-05 13:32:52","4428","6","Foil Only","2","2014-05-05 21:47:08","2","2014-05-05 21:51:24","2","2014-05-06 08:10:09","2","142336","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2608","7","0","9991884","2014-05-02","0","0","2014-05-05","8","","1","","","1","2014-05-02 12:46:52","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2609","10","0","2392982","2014-05-02","1","0","2014-05-05","17","","1","","ASteelFlash E-BAND COMMUNICATION 200-0150-002 Rev: B","2","2014-05-02 16:46:02","1453","6/5","Z2","2","2014-05-06 11:38:51","2","2014-05-06 13:31:15","2","2014-05-06 13:32:13","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2610","97","0","4792351","2014-05-02","1","0","2014-05-05","8","","1","","Surface Art Monsoon J","2","2014-05-02 14:32:35","6443","4","18X18","2","2014-05-02 17:06:39","2","2014-05-02 18:22:52","2","2014-05-05 07:48:36","2","142309","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2611","54","0","914619","2014-05-02","0","0","2014-05-05","12","","1","","Marvell Semiconductor AltaPlus 200649","2","2014-05-02 16:22:35","3353","4","Foil Only","2","2014-05-05 10:43:27","2","2014-05-05 13:03:37","2","2014-05-05 13:03:52","2","142324","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2612","8","0","575428","2014-05-02","0","1","2014-05-06","10","","1","","","2","2014-05-02 17:15:18","4131","5","Z2","2","2014-05-06 10:40:17","2","2014-05-06 13:15:46","0","0000-00-00 00:00:00","2","142349","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2613","8","0","575429","2014-05-02","0","1","2014-05-06","10","","1","","","2","2014-05-02 17:14:52","1047","5","Z2","2","2014-05-06 10:47:39","2","2014-05-06 13:15:58","0","0000-00-00 00:00:00","2","142349","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2614","36","0","6911934","2014-05-02","1","0","2014-05-05","14","","1","","","2","2014-05-05 12:16:34","18224","5","Special","2","2014-05-05 16:44:29","2","2014-05-05 17:00:43","0","0000-00-00 00:00:00","2","142320","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2615","36","0","6911935","2014-05-02","1","0","2014-05-05","14","","1","","","2","2014-05-05 12:16:21","11142","5","Special","2","2014-05-05 15:21:46","2","2014-05-05 15:34:12","0","0000-00-00 00:00:00","2","142320","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2616","97","0","4791967R","2014-05-02","1","0","2014-05-05","15","","1","","Surface Art Zephyr Technologies 9607-0211-V (BH3M1) REV 1","2","2014-05-02 16:21:42","6612","4","18X18","2","2014-05-02 20:57:59","2","2014-05-02 21:20:12","2","2014-05-05 07:48:48","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2617","2","0","5346903","2014-05-02","0","0","2014-05-05","15","","1","","Sanmina JoeScan Flat Interface Rev E2","2","2014-05-02 16:29:11","2158","5","Z2","2","2014-05-05 20:52:38","2","2014-05-05 21:51:10","2","2014-05-06 08:09:35","2","142329","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2618","57","0","767137","2014-05-02","0","0","2014-05-05","17","","10","","Intel 046192-1-1 (CPFS)","2","2014-05-05 13:33:31","8949","4","Foil Only","2","2014-05-05 17:16:55","2","2014-05-05 18:48:43","0","0000-00-00 00:00:00","2","142337","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2619","57","0","767138","2014-05-02","0","0","2014-05-05","17","","10","","Intel 046192-1-1 (CPFS)","2","2014-05-05 13:34:01","2651","4","Foil Only","2","2014-05-05 17:01:58","2","2014-05-05 17:07:20","0","0000-00-00 00:00:00","2","142337","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2620","54","0","914620","2014-05-02","0","0","2014-05-05","16","","1","","Marvell Semiconductor 02_MV6S_MB_F1_A1","2","2014-05-05 03:12:53","4504","4","Foil Only","2","2014-05-05 20:59:05","2","2014-05-05 21:28:21","2","2014-05-06 08:09:00","2","142327","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2621","72","0","1262729F","2014-05-02","0","0","2014-05-05","8","","1","","","2","2014-05-02 16:33:07","","","","2","2014-05-02 16:33:15","2","2014-05-02 18:21:03","2","2014-05-05 11:33:17","2","142322","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2622","74","0","152006","2014-05-02","1","0","2014-05-05","10","","1","","","2","2014-05-02 21:25:26","1000","5","Z2","2","2014-05-02 22:13:44","2","2014-05-05 09:28:17","2","2014-05-05 09:37:02","2","142316","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2623","34","0","7994775","2014-05-04","1","0","2014-05-05","13","","1","","Creation Technologies REDWOOD SYSTEMS 81-00044-05 Rev.2_Taft","2","2014-05-05 03:13:22","5618","5","Z2","2","2014-05-05 11:41:32","2","2014-05-05 13:20:14","2","2014-05-05 13:39:19","2","142325","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2624","41","0","832745","2014-05-04","1","0","2014-05-05","9","","1","","GRID_INSIGHT_LED_BETTER SPRING_ACM_X04","2","2014-05-05 03:49:08","436","6","Foil Only","2","2014-05-05 08:48:13","2","2014-05-05 09:12:13","2","2014-05-05 09:36:51","2","142321","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2625","72","0","1262767","2014-05-05","0","0","2014-05-05","18","","1","","Pactron Incorporated PAC3040_04May2014 WO24980_T,WO24962_T LeadFree","2","2014-05-05 03:15:16","3955","4","Z2","2","2014-05-05 21:22:51","2","2014-05-05 21:51:17","2","2014-05-06 08:09:09","2","142330","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2626","72","0","1262768","2014-05-05","0","0","2014-05-05","18","","1","","Pactron Incorporated PAC3041_04May2014 WO24980_B,WO24962_B LeadFree","2","2014-05-05 03:15:38","3461","4","Z2","2","2014-05-05 20:27:27","2","2014-05-05 21:14:09","2","2014-05-06 08:09:19","2","142330","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2627","72","0","1262769","2014-05-05","0","0","2014-05-05","18","","1","","Pactron Incorporated PAC3042_05May2014 WO25013_T","2","2014-05-05 06:17:53","6014","4","Z2","2","2014-05-06 11:07:12","2","2014-05-06 13:26:02","0","0000-00-00 00:00:00","2","142332","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2628","11","0","102093F","2014-05-05","1","0","2014-05-05","11","","1","","Zollner Electronics AEHR 1801093-00/5092050-00","2","2014-05-05 10:15:03","32","4","","2","2014-05-05 10:52:15","2","2014-05-05 11:33:27","2","2014-05-05 11:33:41","0","","2","27","2014-05-05 12:28:25","2","1");
INSERT INTO tbl_jobs VALUES("2629","104","0","559708","2014-05-05","0","0","2014-05-06","16","","8","","Tektronix  165-3278-00","2","2014-05-05 11:59:51","","","","2","2014-05-06 13:56:15","2","2014-05-06 13:56:23","0","0000-00-00 00:00:00","2","142346","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2630","20","0","938683","2014-05-05","0","0","2014-05-06","16","","15","","Ascentron Korvis 23321-802-02 P/N 790-2534","2","2014-05-05 12:00:47","4191","5","18X19","2","2014-05-06 14:18:08","2","2014-05-06 15:19:57","0","0000-00-00 00:00:00","2","142328","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2631","16","0","693302","2014-05-05","1","0","2014-05-05","15","","1","","Advanced Assemblies Power Integrations 20140318","2","2014-05-05 12:13:58","2676","6","Fuji5000","2","2014-05-05 18:14:05","2","2014-05-05 19:22:48","2","2014-05-06 08:09:28","2","142331","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2632","3","0","5632170","2014-05-05","0","1","2014-05-06","19.3","","4","","","2","2014-05-05 18:02:13","","","","2","2014-05-06 14:41:21","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2633","35","0","800217R","2014-05-05","0","0","2014-05-07","11","","1","","","1","2014-05-05 11:40:48","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2634","111","0","782674","2014-05-05","0","0","2014-05-06","17","","8","","Veris DIN RAIL METER ZT00137-0K Z204969-0K","2","2014-05-05 13:53:05","1995","5","18X18","2","2014-05-06 13:37:55","2","2014-05-06 15:04:24","0","0000-00-00 00:00:00","2","142343","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2635","111","0","782675","2014-05-05","0","0","2014-05-06","17","","8","","Veris DIN RAIL METER ZT00138-0K Z204969-0K","2","2014-05-05 13:53:44","1419","5","18X18","2","2014-05-06 13:18:38","2","2014-05-06 16:03:46","0","0000-00-00 00:00:00","2","142343","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2636","4","0","321836","2014-05-05","0","0","2014-05-06","12","","1","","Flextronics F5 Networks  PCA-0326-00","2","2014-05-06 04:46:02","20250","5","Z3","2","2014-05-06 13:00:09","2","2014-05-06 15:14:44","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2637","4","0","321837","2014-05-05","0","0","2014-05-06","12","","1","","Flextronics F5 Networks  PCA-0326-00","2","2014-05-06 04:46:39","4796","5","Z3","2","2014-05-06 13:07:24","2","2014-05-06 15:14:52","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2638","100","0","140202","2014-05-05","0","0","2014-05-06","16","","15","","Synergetics Elecraft E850638 / E100499 XC","2","2014-05-06 08:57:56","594","5","18X18","2","2014-05-06 12:01:25","2","2014-05-06 13:16:17","0","0000-00-00 00:00:00","2","142342","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2639","4","0","321838","2014-05-05","0","0","2014-05-06","14","","1","","Flextronics RGB spectrum 620-0645-01 FAB","2","2014-05-05 15:51:16","679","5","Z2","2","2014-05-06 13:49:36","2","2014-05-06 15:25:43","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2640","1","0","8292583","2014-05-05","0","0","2014-05-06","14","","1","","Foxconn-iDSBG iDSBG 920-4131-02","2","2014-05-05 15:03:24","254","4","Z2","2","2014-05-06 13:29:02","2","2014-05-06 15:01:56","0","0000-00-00 00:00:00","2","142345","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2641","97","0","4792353","2014-05-05","0","0","2014-05-06","14","","1","","Surface Art Phase Matrix 2020409-05 REV B J","2","2014-05-05 17:30:50","","5","Mini stencil","2","2014-05-05 21:54:08","2","2014-05-06 08:33:03","2","2014-05-06 10:17:11","2","142339","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2642","9","0","2814050","2014-05-05","0","0","2014-05-06","17","","1","","CUSTOMER DATAETCHED ON STENCILSanmina - SCI, Corp. RDC Assy 131-0714 PCB 132-0714 rev 3","2","2014-05-06 15:06:46","247","5","Z2","2","2014-05-06 15:42:15","2","2014-05-06 21:52:11","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2643","9","0","2814051","2014-05-05","0","0","2014-05-06","17","","1","","CUSTOMER DATAETCHED ON STENCILSanmina - SCI, Corp. RDC Assy 131-0714 PCB 132-0714 rev 3","2","2014-05-06 15:07:24","385","4","Z2","2","2014-05-06 15:37:34","2","2014-05-06 18:55:17","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2644","7","0","9991863.","2014-05-05","0","0","2014-05-05","18","","1","","","2","2014-05-05 17:09:01","1070","6","Special","2","2014-05-05 21:46:48","2","2014-05-06 10:17:26","2","2014-05-06 10:18:10","2","142299","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2645","9","0","2814052","2014-05-05","0","0","2014-05-06","16","","1","","Sanmina Lite Point 8000-077D-000 rev C1 1700-077D-0C1 REV C1 FAB","2","2014-05-06 04:55:15","4074","4","Z2","2","2014-05-06 13:45:23","2","2014-05-06 15:23:13","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2646","51","0","9931414","2014-05-05","0","0","2014-05-06","17","","1","","Javad Google GO-90-4001 Rev 1.1.0","2","2014-05-06 09:42:08","1325","4","18X18","2","2014-05-06 15:32:59","2","2014-05-06 16:03:37","0","0000-00-00 00:00:00","0","","2","29","2014-05-06 13:17:52","2","1");
INSERT INTO tbl_jobs VALUES("2647","72","0","1262770","2014-05-06","1","0","2014-05-07","8","","1","","Pactron Incorporated PAC3046_05May2014 WO25084_T,WO25120_T LeadFree","2","2014-05-06 04:47:47","4048","6/4","Z3","2","2014-05-07 13:46:00","2","2014-05-07 14:32:38","2","2014-05-07 15:07:15","2","142344","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2648","72","0","1262771","2014-05-06","1","0","2014-05-06","15","","1","","Pactron Incorporated PAC3047_05May2014 WO25084_B,WO25120_B LeadFree","2","2014-05-06 04:47:08","1764","4","Z2","2","2014-05-06 09:50:00","2","2014-05-06 16:04:22","0","0000-00-00 00:00:00","2","142340","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2649","34","0","7994776","2014-05-06","1","0","2014-05-06","17","","1","","Creation Tech. Triple Ring- ICU ICU07541-170 Rev.04","2","2014-05-06 15:42:53","3856","5","Z2","2","2014-05-06 17:12:59","2","2014-05-06 19:59:47","0","0000-00-00 00:00:00","2","142348","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2650","72","0","1262772","2014-05-06","1","0","2014-05-06","13","","1","","Pactron Incorporated PAC3048_06May2014_ WO25038_T,WO24507_T (LeadFree)","2","2014-05-06 06:33:04","6235","4","Z2","2","2014-05-06 10:44:07","2","2014-05-06 13:21:19","0","0000-00-00 00:00:00","2","142341","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2651","46","0","151048","2014-05-06","0","0","2014-05-07","16","","8","","ISSPRO ISSPRO, INC. 9CB608692_A","2","2014-05-06 12:54:29","476","8","Z3","2","2014-05-06 15:21:41","2","2014-05-06 19:58:49","0","0000-00-00 00:00:00","2","142357","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2652","46","0","151047","2014-05-06","0","0","2014-05-07","16","","8","","ISSPRO ISSPRO, INC. 9CB608691_A","2","2014-05-06 10:18:08","434","8","Z3","2","2014-05-06 14:51:19","2","2014-05-06 19:58:43","0","0000-00-00 00:00:00","2","142357","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2653","7","0","9991891","2014-05-06","1","0","2014-05-14","10","","1","","SEM HE Form Factor INc. 200-40098(350-40098):1","2","2014-05-14 10:19:01","15096","6","Z2","2","2014-05-14 11:28:38","2","2014-05-14 14:52:15","2","2014-05-14 14:58:35","2","142493","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2654","7","0","9991892","2014-05-06","0","0","2014-05-07","17","","1","","SEM HE Form Factor INc. 200-40098(350-40098):1","1","2014-05-06 09:59:01","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2655","72","0","1262773","2014-05-06","1","0","2014-05-06","13","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2656","7","0","9991895","2014-05-06","0","0","2014-05-07","17","","1","","SEM HE Intel Corp. ITTO-610-0186:2 Apt count =","2","2014-05-19 09:56:42","403","8","Foil Only","2","2014-05-19 11:38:39","2","2014-05-19 12:12:34","2","2014-05-19 14:43:11","2","142583","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2657","7","0","9991896","2014-05-06","0","0","2014-05-07","17","","1","","SEM HE Intel Corp. ITTO-610-0186:2 Apt count =","2","2014-05-19 09:56:06","2755","8","Z2","2","2014-05-19 11:03:36","2","2014-05-19 13:05:09","2","2014-05-19 14:43:18","2","142583","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2658","7","0","9991893","2014-05-06","0","0","2014-05-07","17","","1","","SEM HE NXP SEMICOND GERMANY GMBH L3116-P60D080170DA-FPCL:B Apt count =","1","2014-05-06 11:04:33","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2659","7","0","9991894","2014-05-06","0","0","2014-05-07","17","","1","","SEM HE NXP SEMICOND GERMANY GMBH L3116-P60D080170DA-FPCL:B Apt count =","1","2014-05-06 11:04:42","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2660","22","0","3474297","2014-05-06","0","0","2014-05-15","16","","8","","Axiom Electronics Planetary Resources 901767097 STB000870","2","2014-05-16 16:21:38","2042","4","Foil Only","2","2014-05-16 18:31:40","2","2014-05-16 18:45:20","0","0000-00-00 00:00:00","2","142575","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2661","7","0","9991897","2014-05-06","0","0","2014-05-07","17","","1","","SEM HE Cirrus Logic Inc. 33TH04208-706 Apt count =","2","2014-05-07 10:45:11","224","8","Foil Only","2","2014-05-07 13:20:57","2","2014-05-07 13:43:49","2","2014-05-07 15:14:57","2","142363","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2662","7","0","9991898","2014-05-06","0","0","2014-05-07","17","","1","","","2","2014-05-07 10:45:34","5457","6","Foil Only","2","2014-05-07 13:18:00","2","2014-05-07 13:43:58","2","2014-05-07 15:15:27","2","142363","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2663","7","0","9991899","2014-05-06","0","0","2014-05-07","17","","1","","SEM HE International Rectifier  D2108A FAMILY BD.(FULL):A Apt count =","2","2014-05-07 10:45:59","499","8","Foil Only","2","2014-05-07 13:24:01","2","2014-05-07 13:44:05","2","2014-05-07 15:14:27","2","142366","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2664","7","0","9991900","2014-05-06","0","0","2014-05-07","17","","1","","SEM HE International Rectifier D2108A FAMILY BD.(FULL):A Apt count =","1","2014-05-07 01:52:45","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2665","51","0","9931416","2014-05-06","0","0","2014-05-07","11","","1","","Javad Tempsys - Mesa CP-310-F Rev 400","2","2014-05-06 15:43:34","1661","5","18X18","2","2014-05-06 17:17:56","2","2014-05-06 20:56:03","2","2014-05-07 07:44:19","0","","2","30","2014-05-07 07:38:48","2","1");
INSERT INTO tbl_jobs VALUES("2666","51","0","9931417","2014-05-06","0","0","2014-05-07","11","","1","","Javad Tempsys - Mesa CP-310-F Rev 400","2","2014-05-06 15:44:04","141","7","18X18","2","2014-05-06 18:12:27","2","2014-05-06 20:56:09","2","2014-05-07 07:44:27","0","","2","31","2014-05-07 07:39:00","2","1");
INSERT INTO tbl_jobs VALUES("2667","51","0","9931418","2014-05-06","0","0","2014-05-07","11","","1","","Javad Tehama TW-221 Rev 101","2","2014-05-14 16:17:19","882","5","18X18","2","2014-05-14 18:45:42","2","2014-05-14 20:46:20","2","2014-05-15 07:55:13","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2668","99","0","148084","2014-05-06","0","0","2014-05-07","8","","1","","SV Probe 2-304 N50M,K20-512R,OHT P/N: 771-009006-01","2","2014-05-07 07:17:45","","","Mini stencil","2","2014-05-07 10:34:41","2","2014-05-07 10:38:58","2","2014-05-08 11:15:59","2","142372","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2669","57","0","767139","2014-05-06","1","0","2014-05-06","17","","10","","Milwaukee Electroncis Co.Cambridge Mobile Tele 046230-1-1 (vehicletag)","2","2014-05-06 15:57:33","136","4","Foil Only","2","2014-05-06 17:06:45","2","2014-05-06 17:10:45","0","0000-00-00 00:00:00","2","142347","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2670","3","0","5632171","2014-05-06","1","0","2014-05-06","18","","4","","Intel Corporation QFN-64 Package IPN G70934-001","2","2014-05-06 17:25:40","","","Print part","2","2014-05-06 17:47:18","2","2014-05-06 17:47:22","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2671","110","0","952391","2014-05-06","0","0","2014-05-07","16","","15","","Unitron  LS-331zERO-2 2014.04.08","2","2014-05-07 11:26:26","2600","5","18X18","2","2014-05-07 13:29:19","2","2014-05-07 14:48:04","0","0000-00-00 00:00:00","2","142371","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2672","11","0","102113","2014-05-06","0","0","2014-05-07","14","","1","","Zollner Electronics STEM 1799066-01/5092436-00","2","2014-05-08 15:02:54","1845","5","Z2","2","2014-05-08 17:14:37","2","2014-05-08 22:19:41","2","2014-05-09 08:05:07","2","142399","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2673","11","0","102114","2014-05-06","0","0","2014-05-07","14","","1","","Zollner Electronics STEM 1799066-01/5092437-00","2","2014-05-08 15:03:44","1912","5","Z2","2","2014-05-08 17:14:55","2","2014-05-08 22:19:47","2","2014-05-09 08:05:16","2","142399","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2674","3","0","5632172","2014-05-06","0","0","2014-05-20","19.3","","5","","","2","2014-05-07 06:36:46","","5","Mini stencil","2","2014-05-07 10:29:22","2","2014-05-07 10:29:28","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2675","1","0","8292584","2014-05-06","0","0","2014-05-07","15","","1","","","2","2014-05-07 07:18:20","8609","3","Z2","2","2014-05-07 14:03:37","2","2014-05-07 14:58:09","0","0000-00-00 00:00:00","2","142365","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2676","1","0","8292585","2014-05-06","0","0","2014-05-07","15","","1","","","2","2014-05-07 07:18:35","520","3","Z2","2","2014-05-07 14:22:42","2","2014-05-07 15:00:37","0","0000-00-00 00:00:00","2","142365","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2677","10","0","2392983","2014-05-06","1","1","2014-05-09","8","","1","","AsteelFlash ANRITSU 3-80611-3P1 3-80611-1-2 rev 1","2","2014-05-08 16:40:52","2851","4","Z2","2","2014-05-08 19:10:08","2","2014-05-08 22:19:23","2","2014-05-09 08:04:43","2","142350","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2678","10","0","2392984","2014-05-06","1","1","2014-05-09","8","","1","","AsteelFlash ANRITSU 3-80611-3P1 3-80611-1-2 rev 1","2","2014-05-08 16:40:32","4633","4","Z2","2","2014-05-08 18:59:41","2","2014-05-08 22:19:29","2","2014-05-09 08:04:50","2","142350","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2679","2","0","5346904","2014-05-06","0","0","2014-05-07","15","","1","","Sanmina Ciena 154-0008-420 Rev 001 APERTURE COUNT","2","2014-05-07 06:32:23","1000","5","Z2","2","2014-05-07 09:36:30","2","2014-05-07 12:31:58","2","2014-05-07 15:17:26","2","142356","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2680","34","0","7994777","2014-05-06","0","0","2014-05-07","15","","1","","Creation","2","2014-05-07 07:18:01","6040","5","Z2","2","2014-05-07 11:36:42","2","2014-05-07 13:53:15","2","2014-05-07 15:06:49","2","142360","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2681","2","0","5346905","2014-05-06","0","0","2014-05-07","15","","1","","Sanmina Ciena 154-0041-420 Rev 001 APERTURE COUNT","2","2014-05-07 06:33:06","2524","5","Z2","2","2014-05-07 09:45:08","2","2014-05-07 12:58:58","2","2014-05-07 15:17:50","2","142359","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2682","2","0","5346906","2014-05-06","0","0","2014-05-07","15","","1","","Sanmina Ciena 154-0028-440 Rev 001 APERTURE COUNT","2","2014-05-07 06:34:02","2143","5","Z2","2","2014-05-07 10:06:01","2","2014-05-07 12:46:54","2","2014-05-07 15:18:11","2","142358","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2683","1","0","8292586","2014-05-06","0","0","2014-05-07","16","","1","","IDSBG 820-5499-05","2","2014-05-07 06:31:31","2336","3","Z2","2","2014-05-07 14:42:38","2","2014-05-07 14:53:39","0","0000-00-00 00:00:00","2","142368","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2684","4","0","321839","2014-05-06","0","0","2014-05-07","16","","1","","Flextronics DHR-T001-0029 DHR-1007-0057 REV.2","2","2014-05-08 14:19:39","752","6","Z2","2","2014-05-08 19:37:36","2","2014-05-08 22:20:58","2","2014-05-09 08:05:56","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2685","43","0","5413976","2014-05-06","0","0","2014-05-07","16","","1","","Infiniti Solutions L.S.Research MDC02 Rev A Job","2","2014-05-06 17:53:45","487","4","Z2","2","2014-05-06 18:40:41","2","2014-05-06 20:33:09","2","2014-05-07 07:44:37","2","142351","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2686","4","0","321840","2014-05-06","0","0","2014-05-07","16","","1","","DHR-T002-0004 DHR-A013-4008 DHR-1007-0013 REV.4","2","2014-05-08 14:37:00","2111","5","Z2","2","2014-05-08 19:46:09","2","2014-05-08 22:21:05","2","2014-05-09 08:05:29","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2687","43","0","5413977","2014-05-06","0","0","2014-05-07","17","","1","","Infiniti Solutions L.S.Research MDC01 Rev A Job","2","2014-05-07 06:34:52","433","4","Z2","2","2014-05-07 11:13:13","2","2014-05-07 12:37:06","2","2014-05-07 15:18:38","2","142361","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2688","72","0","1262774","2014-05-07","0","0","2014-05-09","8","","1","","Pactron Incorporated PAC3051_07May2014 WO24765_B(LeadFree)","2","2014-05-07 07:40:27","1955","6/4","Z2 step","2","2014-05-07 19:23:41","2","2014-05-07 20:44:41","2","2014-05-08 07:58:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2689","72","0","1262775","2014-05-07","0","0","2014-05-07","18","","1","","","2","2014-05-07 07:06:51","2406","4","Z2","2","2014-05-07 11:30:17","2","2014-05-07 13:47:09","2","2014-05-07 15:07:45","2","142362","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2690","43","0","5413981","2014-05-07","0","0","2014-05-08","8","","1","","Infiniti Solutions Job","2","2014-05-07 11:24:28","2472","7","Fuji4000","2","2014-05-07 15:48:41","2","2014-05-07 16:43:43","2","2014-05-08 07:56:18","2","142364","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2691","43","0","5413979","2014-05-07","0","0","2014-05-08","8","","1","","Infiniti Solutions Job","2","2014-05-07 11:40:36","128","7","Fuji4000","2","2014-05-07 16:07:37","2","2014-05-07 17:05:43","2","2014-05-08 07:56:25","2","142367","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2692","43","0","5413980","2014-05-07","0","0","2014-05-08","8","","1","","Infiniti Solutions Job","2","2014-05-07 11:40:59","2728","7","Fuji4000","2","2014-05-07 15:23:43","2","2014-05-07 16:51:02","2","2014-05-08 07:56:32","2","142367","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2693","43","0","5413978","2014-05-07","0","0","2014-05-08","8","","1","","Infiniti Solutions Job","2","2014-05-07 11:25:13","5858","8","Fuji4000","2","2014-05-07 19:48:41","2","2014-05-07 20:43:18","2","2014-05-08 07:56:41","2","142369","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2694","7","0","9991901","2014-05-07","0","0","2014-05-08","17","","1","","SEM HE","2","2014-05-07 14:47:03","868","6","Foil Only","2","2014-05-07 19:06:43","2","2014-05-07 19:23:47","2","2014-05-08 07:56:59","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2695","42","0","660036","2014-05-07","0","1","2014-05-08","11","","1","","Hunter Technology Clariphy CL4010C0","2","2014-05-07 14:11:58","","","Reball","2","2014-05-07 20:53:53","2","2014-05-08 08:25:44","2","2014-05-08 10:10:24","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2696","8","0","575430","2014-05-07","0","0","2014-05-08","11","","1","","Jabil Agilent Assy. ST-N1055-63011-005-T FAB_N1055-20011_005","2","2014-05-07 17:26:10","5718","5","Z2","2","2014-05-08 10:57:41","2","2014-05-08 12:39:13","2","2014-05-08 12:48:46","2","142380","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2697","8","0","575431","2014-05-07","0","0","2014-05-08","11","","1","","Jabil Agilent Assy. ST-N1055-63011-005-B FAB_N1055-20011_005","2","2014-05-07 17:26:34","4584","5","Z2","2","2014-05-08 10:46:05","2","2014-05-08 12:39:21","2","2014-05-08 12:48:52","2","142380","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2698","51","0","9931416F","2014-05-07","0","0","2014-05-07","15","","1","","","2","2014-05-07 12:43:56","","5","","2","2014-05-07 15:38:10","2","2014-05-07 15:43:45","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2699","97","0","4792354","2014-05-07","1","0","2014-05-07","16","","1","","Surface Art Relia 200-0065 Rev 2 J","1","2014-05-07 11:42:15","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2700","3","0","5632173","2014-05-07","0","0","2014-05-08","20","","8","","Intel Corporation  H30158-001","2","2014-05-07 15:20:18","","6","Mini stencil","2","2014-05-07 20:21:13","2","2014-05-08 08:25:31","0","0000-00-00 00:00:00","2","142381","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2701","4","0","321841","2014-05-07","0","1","2014-05-08","14","","1","","Flextronics  PLO1-SEN-NOD-000001Rev-X2 PLO1-NOD-PCB-000001Rev-X1","2","2014-05-08 16:52:22","1313","4","Z2","2","2014-05-08 19:33:30","2","2014-05-08 22:21:17","2","2014-05-09 08:06:55","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2702","4","0","321842","2014-05-07","0","1","2014-05-08","14","","1","","Flextronics  PLO1-SEN-BPK-000001Rev-X1 PLO1-BPK-PCB-000001Rev-X1","2","2014-05-08 16:42:39","712","4","Z2","2","2014-05-08 21:10:54","2","2014-05-09 07:28:59","2","2014-05-09 08:06:41","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2703","4","0","321843","2014-05-07","0","1","2014-05-08","14","","1","","Flextronics  PLO1-650-00046-01 Rev-X1 PLO1-APX-PCB-000001 Rev-X","2","2014-05-08 14:17:02","3082","4","Z2","2","2014-05-08 15:54:38","2","2014-05-08 17:22:16","2","2014-05-09 08:06:28","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2704","93","0","2532137F","2014-05-07","0","0","2014-05-08","9","","1","","","2","2014-05-07 15:01:48","","4","","2","2014-05-07 20:18:42","2","2014-05-07 20:23:35","2","2014-05-08 07:56:09","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2705","4","0","321844","2014-05-07","0","0","2014-05-08","14","","1","","Flextronics Cyan 800-0143-01-01 aperture count","2","2014-05-08 04:11:35","6878","7/5","Z2 step","2","2014-05-09 12:25:55","2","2014-05-09 12:45:04","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2706","4","0","321845","2014-05-07","0","0","2014-05-08","14","","1","","Flextronics Cyan 800-0143-01-01 aperture count","2","2014-05-08 04:11:03","3214","5","Z2","2","2014-05-08 13:00:42","2","2014-05-08 14:27:38","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2707","22","0","3474298","2014-05-07","0","0","2014-05-09","16","","4","","Axiom Electronics LeCroy LSA2000 Toto Dig it 905000226 STP000760 Rev 02","2","2014-05-08 08:57:22","3528","8/5","Z2 step","2","2014-05-09 14:51:33","2","2014-05-09 16:31:05","0","0000-00-00 00:00:00","2","142417","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2708","1","0","8292587","2014-05-07","0","0","2014-05-08","14","","1","","Foxconn-iDSBG iDSBG 920-00265-01","2","2014-05-07 18:40:16","906","3","Z2","2","2014-05-07 19:53:49","2","2014-05-07 20:44:52","2","2014-05-08 07:57:09","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2709","1","0","8292588","2014-05-07","0","0","2014-05-08","15","","1","","IDSBG 920-00286-01","2","2014-05-07 20:47:21","804","5","Z2","2","2014-05-07 21:04:26","2","2014-05-07 21:09:57","2","2014-05-08 07:57:20","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2710","43","0","5413982","2014-05-07","0","0","2014-05-08","16","","1","","Infiniti Solutions Qualcomm Atheros Job","2","2014-05-08 02:58:12","3110","5","Z2","2","2014-05-08 12:50:38","2","2014-05-08 14:22:05","0","0000-00-00 00:00:00","2","142386","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2711","35","0","800222","2014-05-07","0","0","2014-05-08","15","","1","","Creation Tech. SNJ NEXTEST Fab","2","2014-05-08 11:48:12","9324","5","Z2","2","2014-05-08 14:39:04","2","2014-05-08 16:17:55","0","0000-00-00 00:00:00","2","142390","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2712","35","0","800223","2014-05-07","0","0","2014-05-08","15","","1","","Creation Tech. SNJ NEXTEST Fab","2","2014-05-08 11:47:50","4230","5","Z2","2","2014-05-08 14:01:48","2","2014-05-08 16:18:04","0","0000-00-00 00:00:00","2","142390","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2713","97","0","4792356","2014-05-07","1","0","2014-05-08","16","","1","","Surface Art TriQuint TQP9108 TQP9321 REV P00 SA J","2","2014-05-08 04:09:45","952","5","Z2","2","2014-05-08 10:14:30","2","2014-05-08 12:45:14","2","2014-05-08 12:49:11","2","142384","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2714","99","0","148085","2014-05-07","1","0","2014-05-08","17","","1","","","2","2014-05-08 04:47:20","3136","5","Print part","2","2014-05-08 10:16:49","2","2014-05-08 10:26:11","2","2014-05-08 11:15:51","2","142383","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2715","4","0","321T844","2014-05-08","1","0","2014-05-08","17","","1","","","2","2014-05-08 17:12:12","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","2014-05-08 17:13:05","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2716","72","0","1262776","2014-05-08","0","0","2014-05-08","18","","1","","Pactron Incorporated PAC3054_08May2014_ WO25023_T","2","2014-05-08 08:19:55","2874","4","Z2","2","2014-05-08 11:43:32","2","2014-05-08 13:34:18","0","0000-00-00 00:00:00","2","142385","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2717","72","0","1262777","2014-05-08","0","0","2014-05-08","18","","1","","Pactron Incorporated PAC3055_08May2014_ WO25091_T,WO25100_T (LeadFree)","2","2014-05-08 08:39:06","2222","4","Z2","2","2014-05-08 13:28:25","2","2014-05-08 14:14:31","0","0000-00-00 00:00:00","2","142387","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2718","72","0","1262778","2014-05-08","0","0","2014-05-08","18","","1","","Pactron Incorporated PAC3056_08May2014_ WO25091_B,WO25100_B (LeadFree)","2","2014-05-08 08:44:52","786","4","Z2","2","2014-05-08 15:12:58","2","2014-05-08 16:13:09","0","0000-00-00 00:00:00","2","142387","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2719","31","0","7582278","2014-05-08","0","0","2014-05-09","16","","8","","Controltek  890-1478-0 REV B 180-2063-B","2","2014-05-08 10:45:36","287","4","18X18","2","2014-05-08 15:06:43","2","2014-05-08 15:57:09","0","0000-00-00 00:00:00","2","142407","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2720","31","0","7582279","2014-05-08","0","0","2014-05-09","16","","8","","Controltek  890-1478-0 REV B 180-2063-B","2","2014-05-08 10:45:59","489","4","18X18","2","2014-05-08 21:17:44","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","142407","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2721","11","0","102115","2014-05-08","0","0","2014-05-12","12","","1","","Zollner Electronics Sandisk 1804501-00","2","2014-05-08 14:01:16","632","5","Z2","2","2014-05-08 17:15:17","2","2014-05-08 22:20:01","2","2014-05-16 10:35:10","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2722","51","0","9931421","2014-05-08","0","0","2014-05-09","10","","1","","","2","2014-05-08 14:00:20","1148","5","18X18","2","2014-05-08 20:00:53","2","2014-05-08 21:13:58","2","2014-05-09 08:04:33","0","","2","32","2014-05-08 15:29:03","2","1");
INSERT INTO tbl_jobs VALUES("2723","7","0","9991902","2014-05-08","0","0","2014-05-09","17","","1","","SEM HE Amkor (MTS Asia) CGHV27200 TB2 C26387:A Apt count =","1","2014-05-09 00:37:32","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2724","7","0","9991903","2014-05-08","0","0","2014-05-09","17","","1","","SEM HE Amkor (MTS Asia) CGHV27200 TB2 C26387:A Apt count =","1","2014-05-09 00:37:40","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2725","7","0","9991904","2014-05-08","0","0","2014-05-09","17","","1","","SEM HE RFMD RF1118 C26347:A Apt count =","1","2014-05-09 01:05:22","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2726","7","0","9991905","2014-05-08","0","0","2014-05-09","17","","1","","SEM HE RFMD RF1118 C26347:A Apt count =","1","2014-05-09 01:05:30","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2727","7","0","9991906","2014-05-08","0","0","2014-05-09","17","","1","","SEM HE Feinmetal GmbH 8VBTJ750-370 C13614:A Apt count =","1","2014-05-09 01:16:08","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2728","7","0","9991907","2014-05-08","0","0","2014-05-09","17","","1","","SEM HE Feinmetal GmbH 8VBTJ750-370 C13614:A Apt count =","2","2014-05-09 08:30:26","1612","8","Z1","2","2014-05-09 10:07:38","2","2014-05-09 10:17:04","2","2014-05-09 11:08:46","2","142409","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2729","43","0","5413983","2014-05-08","0","0","2014-05-09","11","","1","","Infiniti Solutions NXP HVQFN","2","2014-05-08 17:05:22","55","4","Z2","2","2014-05-08 20:04:51","2","2014-05-08 21:23:08","2","2014-05-09 08:07:41","2","142401","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2730","123","0","4526051","2014-05-08","1","0","2014-05-09","19","","1","","","2","2014-05-08 18:51:35","836","5/3","Z2 step","2","2014-05-09 15:09:53","2","2014-05-09 16:22:36","0","0000-00-00 00:00:00","2","142422","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2731","3","0","5632162b","2014-05-08","1","0","2014-05-08","19","","4","","","2","2014-05-08 12:30:02","","4","Special","2","2014-05-08 18:15:10","2","2014-05-08 19:31:54","0","0000-00-00 00:00:00","2","142389","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2732","43","0","5413984","2014-05-08","0","1","2014-05-09","12","","1","","Infiniti Solutions L.S.Research MEM01 Rev B Job","2","2014-05-08 18:42:23","256","4","Z2","2","2014-05-08 20:40:02","2","2014-05-08 22:20:45","2","2014-05-09 12:43:10","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2733","8","0","575433","2014-05-08","0","1","2014-05-12","13","","1","","","2","2014-05-09 09:46:00","9140","5","Z3","2","2014-05-12 12:47:01","2","2014-05-12 16:16:40","2","2014-05-13 08:45:43","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2734","8","0","575434","2014-05-08","0","1","2014-05-12","13","","1","","","2","2014-05-09 09:46:21","7922","5","Z3","2","2014-05-12 12:39:35","2","2014-05-12 16:16:49","2","2014-05-13 08:45:50","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2735","59","0","343323","2014-05-08","1","0","2014-05-09","9","","1","","Meritronics Muse ADM FrontPanel V02 Muse ADM Audio DB","2","2014-05-08 16:50:44","404","5","Foil Only","2","2014-05-08 20:47:26","2","2014-05-08 21:19:01","2","2014-05-09 08:08:22","2","142393","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2736","59","0","343324","2014-05-08","1","0","2014-05-09","9","","1","","","2","2014-05-08 17:26:35","","","Mini stencil","2","2014-05-08 21:05:29","2","2014-05-09 08:02:10","2","2014-05-09 08:08:30","2","142393","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2737","51","0","9931422","2014-05-08","0","0","2014-05-09","13","","1","","Javad Google GO-90-2003 Rev 1.1.0","2","2014-05-09 09:33:30","4066","5","18X18","2","2014-05-09 12:10:20","2","2014-05-09 13:50:21","2","2014-05-09 15:55:39","0","","2","33","2014-05-09 12:41:11","2","1");
INSERT INTO tbl_jobs VALUES("2738","111","0","782676","2014-05-08","0","0","2014-05-09","16","","8","","Veris  ZT00372-0C Z206808-0C","2","2014-05-09 02:17:27","4940","5","18X18","2","2014-05-09 10:26:43","2","2014-05-09 14:41:24","0","0000-00-00 00:00:00","2","142416","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2739","111","0","782677","2014-05-08","0","0","2014-05-09","16","","8","","Veris  ZT00372-0C Z206808-0C","1","2014-05-08 20:17:26","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2740","70","0","1105152R","2014-05-08","1","0","2014-05-08","17","","1","","","2","2014-05-08 14:56:40","2420","4","Z2","2","2014-05-08 15:39:30","2","2014-05-08 16:10:56","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2741","1","0","8292589","2014-05-08","0","0","2014-05-09","11","","1","","Foxconn iDSBG IDSBG  920-00337-01","2","2014-05-08 20:56:55","75","4","Z2","2","2014-05-08 21:38:30","2","2014-05-08 22:22:23","2","2014-05-09 08:07:52","2","142402","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2742","97","0","4792357","2014-05-08","0","0","2014-05-12","15","","1","","","2","2014-05-09 16:51:17","1494","4","18X18","2","2014-05-12 12:58:31","2","2014-05-12 15:38:51","0","0000-00-00 00:00:00","2","142442","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2743","95","0","252628","2014-05-08","0","0","2014-05-09","16","","1","","Stanford Research Systems  7-02392-701 Rev.B 5/8/14","2","2014-05-09 09:22:50","1037","6","","2","2014-05-09 11:21:41","2","2014-05-09 14:14:20","2","2014-05-09 15:29:41","2","142418","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2744","95","0","252629","2014-05-08","0","0","2014-05-09","16","","1","","Stanford Research Systems  7-02282-701 Rev.C 5/8/14","2","2014-05-09 09:24:17","796","5","18X19","2","2014-05-09 11:22:02","2","2014-05-09 14:35:23","2","2014-05-09 15:29:20","2","142419","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2745","2","0","5346907","2014-05-08","0","0","2014-05-09","16","","1","","Sanmina xilinx FF1925","2","2014-05-08 21:33:25","15854","5","Z2","2","2014-05-09 16:46:02","2","2014-05-09 18:43:10","2","2014-05-12 07:53:35","2","142420","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2746","97","0","4792360","2014-05-08","0","0","2014-05-09","17","","1","","Surface Art Graphite Systems","2","2014-05-09 04:47:28","149","4","Foil Only","2","2014-05-09 11:12:58","2","2014-05-09 12:10:32","2","2014-05-09 12:32:06","2","142413","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2747","97","0","4792358","2014-05-08","0","0","2014-05-09","17","","1","","Surface Art Graphite Systems J","2","2014-05-09 02:18:18","3297","4","18X18","2","2014-05-09 11:13:21","2","2014-05-09 14:00:36","2","2014-05-09 15:56:10","2","142415","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2748","97","0","4792359","2014-05-08","0","0","2014-05-09","17","","1","","Surface Art Graphite Systems J","2","2014-05-09 02:19:21","957","4","18X18","2","2014-05-09 10:29:40","2","2014-05-09 14:00:49","2","2014-05-09 15:56:18","2","142415","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2749","54","0","914621","2014-05-08","0","0","2014-05-09","17","","1","","Marvell Semiconductor MF1_2034_F2-U25","2","2014-05-09 02:06:21","40","5","Mini stencil","2","2014-05-09 09:49:11","2","2014-05-09 10:05:08","2","2014-05-09 12:32:22","2","142408","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2750","65","0","815225","2014-05-08","0","0","2014-05-12","8","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2751","5","0","4894519","2014-05-08","0","0","2014-05-12","8","","1","","","2","2014-05-09 00:07:00","2","5","Special","2","2014-05-09 12:39:27","2","2014-05-09 19:12:04","2","2014-05-12 09:01:01","2","142430","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2752","42","0","660037","2014-05-09","0","0","2014-05-12","8","","1","","","2","2014-05-09 17:29:33","9463","4","Z2","2","2014-05-09 20:29:34","2","2014-05-09 21:30:33","2","2014-05-12 07:54:11","2","142428","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2753","72","0","1262780","2014-05-09","0","0","2014-05-09","18","","1","","Pactron Incorporated PAC3057_09May2014 WO24987_T,WO25151_T LeadFree","2","2014-05-09 06:02:24","3146","4","Z2","2","2014-05-09 10:59:13","2","2014-05-09 14:04:16","2","2014-05-09 15:28:55","2","142414","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2754","72","0","1262781","2014-05-09","0","0","2014-05-09","18","","1","","","2","2014-05-09 06:03:03","794","4","Z2","2","2014-05-09 10:59:28","2","2014-05-09 14:04:28","2","2014-05-09 15:28:31","2","142411","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2755","9","0","2814053","2014-05-09","1","0","2014-05-09","10","","1","","","2","2014-05-09 09:15:58","","5","Mini stencil","2","2014-05-09 09:48:57","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2756","42","0","660038","2014-05-09","0","0","2014-05-12","9","","1","","Hunter Technology Microsoft - MGD GO X897417-001_Rev_A","2","2014-05-09 14:12:45","7192","4","Z2","2","2014-05-09 19:13:56","2","2014-05-09 20:35:01","2","2014-05-12 10:13:11","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2757","93","0","2532148","2014-05-09","0","0","2014-05-12","12","","1","","SMTC Anritsu 3-76236-3 rev.c","2","2014-05-12 09:56:10","1664","5","Z2","2","2014-05-12 11:35:12","2","2014-05-12 14:43:37","0","0000-00-00 00:00:00","2","142423","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2758","93","0","2532149","2014-05-09","0","0","2014-05-12","12","","1","","SMTC Anritsu 3-76236-3 rev.c","2","2014-05-12 09:56:28","1664","4","Z2","2","2014-05-12 11:31:21","2","2014-05-12 14:46:05","0","0000-00-00 00:00:00","2","142423","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2759","70","0","1105156","2014-05-09","0","0","2014-05-12","11","","1","","Oncore TLTC 05-060601-02LF@6.9 BTM SIDE","2","2014-05-12 08:49:50","2826","4","Z2","2","2014-05-12 10:56:21","2","2014-05-12 13:41:20","2","2014-05-15 07:55:00","2","142521","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2760","42","0","660039","2014-05-09","0","1","2014-05-12","11","","1","","Hunter Technology Avago 2JE1-0000-01","2","2014-05-12 08:08:46","","","Reball","2","2014-05-12 14:16:59","2","2014-05-12 14:54:28","2","2014-05-13 10:32:40","2","142458","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2761","97","0","4792361","2014-05-09","1","0","2014-05-12","9","","1","","Surface Art Monsoon  LTE35A J","2","2014-05-09 15:09:19","1934","4","Z3","2","2014-05-09 16:48:46","2","2014-05-09 18:42:05","2","2014-05-12 07:53:23","2","142421","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2762","93","0","2532150","2014-05-09","0","0","2014-05-12","11","","1","","SMTC Anritsu  ANR 3-71057-3","2","2014-05-09 17:12:29","201","4","Z2","2","2014-05-09 19:41:37","2","2014-05-09 21:30:48","2","2014-05-12 09:00:51","2","142432","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2763","57","0","767140","2014-05-09","0","0","2014-05-12","16","","10","","Milwaukee Electroncis Co.Logitech, Inc. 046307-1-1 (Eval TAP)","2","2014-05-09 15:56:26","406","4","Foil Only","2","2014-05-12 10:48:11","2","2014-05-12 11:19:49","0","0000-00-00 00:00:00","2","142434","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2764","51","0","9931423","2014-05-09","0","0","2014-05-12","13","","1","","Javad Net Optics 650-1348-004 Rev B","2","2014-05-09 15:23:59","12370","5","Z2","2","2014-05-12 15:06:24","2","2014-05-12 16:16:59","0","0000-00-00 00:00:00","0","","2","34","2014-05-12 13:48:29","2","1");
INSERT INTO tbl_jobs VALUES("2765","57","0","767141","2014-05-09","0","0","2014-05-12","16","","10","","","2","2014-05-12 08:08:59","9236","4","Foil Only","2","2014-05-12 15:39:25","2","2014-05-12 15:47:40","0","0000-00-00 00:00:00","2","142444","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2766","57","0","767142","2014-05-09","0","0","2014-05-12","16","","10","","","2","2014-05-12 08:09:28","3066","4","Foil Only","2","2014-05-12 15:12:24","2","2014-05-12 15:47:47","0","0000-00-00 00:00:00","2","142444","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2767","9","0","2814055","2014-05-09","0","0","2014-05-13","8","","1","","","2","2014-05-12 05:24:43","153","5","Z2","2","2014-05-12 12:21:14","2","2014-05-12 14:53:17","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2768","97","0","4792355","2014-05-09","0","0","2014-05-08","15","","1","","Surface Art INTEL(CANADA) MB-EVDO FAB 1 J","2","2014-05-14 18:49:00","484","4","18X18","2","2014-05-14 19:22:42","2","2014-05-14 20:46:12","2","2014-05-15 07:52:18","2","142427","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2769","2","0","5346908","2014-05-09","0","0","2014-05-12","15","","1","","Sanmina Ruckus 120-11267-001 Rev-3","2","2014-05-12 09:30:09","4237","4","Z2","2","2014-05-12 10:44:43","2","2014-05-12 15:01:21","0","0000-00-00 00:00:00","2","142433","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2770","97","0","4792362","2014-05-09","0","0","2014-05-12","14","","1","","Surface Art Monsoon QEB36A J","2","2014-05-09 17:57:27","3043","4","18X18","2","2014-05-12 13:10:26","2","2014-05-12 15:38:42","0","0000-00-00 00:00:00","2","142441","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2771","4","0","321846","2014-05-09","0","0","2014-05-12","16","","1","","Flextronics F5 Networks  PCA-0351-01","2","2014-05-12 08:05:42","11666","5","Z2","2","2014-05-12 18:13:43","2","2014-05-12 21:43:32","2","2014-05-13 08:44:02","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2772","50","0","630339","2014-05-09","0","0","2014-05-12","15","","1","","Cisco GOS-ME-1310004 5Mils Thick, 10% Reduce","2","2014-05-12 10:05:49","13315","5","Z2","2","2014-05-12 21:15:02","2","2014-05-13 08:13:44","2","2014-05-13 08:44:12","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2773","2","0","5346909","2014-05-09","0","0","2014-05-12","16","","1","","Sanmina Ruckus 120-11262-001 Rev-3","2","2014-05-12 05:26:01","227","5","Z2","2","2014-05-12 12:04:09","2","2014-05-12 14:39:42","0","0000-00-00 00:00:00","2","142440","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2774","2","0","5346910","2014-05-09","0","0","2014-05-12","16","","1","","Sanmina Ruckus 120-11268-001 Rev-2","2","2014-05-12 09:15:45","127","5","Z2","2","2014-05-12 12:14:28","2","2014-05-12 14:39:28","0","0000-00-00 00:00:00","2","142439","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2775","2","0","5346911","2014-05-09","0","0","2014-05-12","16","","1","","Sanmina Ruckus 120-11271-001 Rev-2","2","2014-05-12 05:26:44","1414","5","Z2","2","2014-05-12 11:51:42","2","2014-05-12 14:44:35","0","0000-00-00 00:00:00","2","142436","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2776","10","0","2392985","2014-05-09","1","0","2014-05-12","10","","1","","AsteelFlash ANRITSU 3-80387-3P2 3-80387-1-2 rev 2","2","2014-05-12 09:26:29","1126","4","Z2","2","2014-05-12 10:38:02","2","2014-05-12 13:40:55","2","2014-05-12 13:41:02","2","142429","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2777","1","0","8292590","2014-05-09","0","0","2014-05-12","16","","1","","Foxconn iDSBGIDSBG 920-00152-01","2","2014-05-12 08:06:37","2468","3","Z2","2","2014-05-12 13:17:17","2","2014-05-12 15:12:44","0","0000-00-00 00:00:00","2","142446","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2778","2","0","5346912","2014-05-09","0","0","2014-05-12","16","","1","","Sanmina Ruckus 120-11272-001 Rev-2","2","2014-05-12 05:27:30","177","5","Z2","2","2014-05-12 11:41:10","2","2014-05-12 14:27:12","0","0000-00-00 00:00:00","2","142435","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2779","8","0","575435","2014-05-09","0","0","2014-05-12","17","","1","","Jabil Ericsson ROA1295664/1 location DM80SP0","2","2014-05-12 08:09:29","","5","Mini stencil","2","2014-05-13 10:56:37","2","2014-05-13 11:11:34","0","0000-00-00 00:00:00","0","","2","36","2014-05-13 13:45:08","2","1");
INSERT INTO tbl_jobs VALUES("2780","9","0","2814054","2014-05-09","1","0","2014-05-09","19","","1","","","2","2014-05-09 17:00:49","2519","5","Z2","2","2014-05-09 18:49:14","2","2014-05-09 21:30:55","2","2014-05-12 07:53:57","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2781","1","0","8292591","2014-05-09","0","0","2014-05-12","17","","1","","Foxconn iDSBGAPPLE 920-4109-01","2","2014-05-12 08:07:18","413","3","Z2","2","2014-05-12 12:52:19","2","2014-05-12 15:59:18","0","0000-00-00 00:00:00","2","142443","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2782","4","0","321847","2014-05-09","0","0","2014-05-12","17","","1","","FlextronicsCisco P/N 15-14645 Intel G37722","2","2014-05-12 08:12:21","","6","Mini stencil","2","2014-05-12 17:21:51","2","2014-05-12 17:22:02","2","2014-05-13 08:43:30","2","142447","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2783","9","0","2814056","2014-05-09","0","0","2014-05-12","17","","1","","Sanmina - SCI, Corp. RDC 131-0091 location U14","2","2014-05-12 05:25:20","","6","Mini stencil","2","2014-05-12 17:22:25","2","2014-05-12 17:22:34","0","0000-00-00 00:00:00","0","","2","35","2014-05-12 17:26:27","2","1");
INSERT INTO tbl_jobs VALUES("2784","1","0","8292592","2014-05-09","0","0","2014-05-12","17","","1","","Foxconn iDSBGIDSBG 920-00275-01","2","2014-05-12 08:08:02","1154","3","Z2","2","2014-05-12 13:22:38","2","2014-05-12 15:59:28","0","0000-00-00 00:00:00","2","142449","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2785","76","0","173038","2014-05-09","0","0","2014-05-12","17","","1","","Piranha EMS, Inc Purewave Networks 580-00491-371-rev B","2","2014-05-12 18:23:18","786","5","Z1","2","2014-05-12 21:25:05","2","2014-05-12 22:22:29","2","2014-05-13 08:45:33","2","142463","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2787","34","0","7994778","2014-05-11","0","0","2014-05-12","17","","1","","Creation Tech. Triple Ring- ICU ICU07537-170_PCB-03 Rev1","2","2014-05-12 05:24:09","2075","5","Z2","2","2014-05-12 13:25:59","2","2014-05-12 16:53:38","2","2014-05-13 07:44:41","2","142450","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2786","76","0","173037","2014-05-09","1","0","2014-05-12","11","","1","","","2","2014-05-09 20:17:08","","8","Special","2","2014-05-12 12:31:57","2","2014-05-12 12:32:06","0","0000-00-00 00:00:00","2","142455","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2788","72","0","1262782","2014-05-12","0","0","2014-05-12","18","","1","","Pactron Incorporated PAC3061_12May2014_ WO24947_T","2","2014-05-12 06:17:26","2337","4","Z2","2","2014-05-12 15:30:00","2","2014-05-12 19:37:23","0","0000-00-00 00:00:00","2","142451","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2789","72","0","1262783","2014-05-12","0","0","2014-05-12","18","","1","","Pactron Incorporated PAC3062_12May2014_ WO24970_T","2","2014-05-12 06:16:42","7317","4","Z3","2","2014-05-12 18:57:16","2","2014-05-12 21:37:16","2","2014-05-13 07:44:55","2","142448","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2790","72","0","1262784","2014-05-12","0","0","2014-05-12","18","","1","","Pactron Incorporated PAC3063_12May2014_ WO24971_B, WO25078_B(Leaded)","2","2014-05-12 06:47:35","4064","4","Fuji5000","2","2014-05-12 19:46:48","2","2014-05-12 21:31:32","2","2014-05-13 07:45:19","2","142445","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2791","84","0","222093","2014-05-12","0","0","2014-05-13","9","","1","","Rocket EMS Incorporated Foundation Andromeda 21e6 Milkyway 3 4508-F Rev 2,TTM fabonly","2","2014-05-12 11:04:54","7786","5","","2","2014-05-13 08:21:06","2","2014-05-13 11:23:12","2","2014-05-13 11:26:11","2","142452","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2792","5","0","4894520","2014-05-12","0","0","2014-05-13","10","","1","","OnCore Manufacturing Christie Digital Systems  CHR-001-112331-01 REV 001 RoHS","2","2014-05-12 18:58:15","2870","4","Z2","2","2014-05-12 20:57:50","2","2014-05-13 09:54:24","2","2014-05-13 10:32:20","2","142462","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2793","5","0","4894521","2014-05-12","0","0","2014-05-13","10","","1","","OnCore Manufacturing Christie Digital Systems CHR-001-112331-01 REV 001 RoHS","2","2014-05-12 18:58:32","1334","4","Z2","2","2014-05-12 20:13:19","2","2014-05-12 22:22:41","2","2014-05-13 10:32:26","2","142462","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2794","11","0","102116","2014-05-12","0","0","2014-05-13","11","","1","","Zollner Electronics Sandisk 1803819-00 54-50-90111 Rev 02","2","2014-05-13 09:45:28","339","5","Z2","2","2014-05-13 11:50:54","2","2014-05-13 14:02:26","0","0000-00-00 00:00:00","2","142479","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2795","11","0","102117","2014-05-12","0","0","2014-05-13","11","","1","","Zollner Electronics Sandisk 1803819-00 54-50-90111 Rev 02","2","2014-05-13 09:45:50","395","5","Z2","2","2014-05-13 11:58:48","2","2014-05-13 14:02:33","0","0000-00-00 00:00:00","2","142479","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2796","93","0","2532151","2014-05-12","0","0","2014-05-13","10","","1","","SMTC Anritsu 3-80120-3","2","2014-05-14 11:51:33","1803","5","Z2","2","2014-05-14 12:40:31","2","2014-05-14 15:22:33","2","2014-05-14 15:54:49","2","142504","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2797","93","0","2532152","2014-05-12","0","0","2014-05-13","10","","1","","SMTC Anritsu 3-80120-3","2","2014-05-14 11:53:23","171","5","Z2","2","2014-05-14 12:10:34","2","2014-05-14 15:22:39","2","2014-05-14 15:54:59","2","142504","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2798","7","0","9991909","2014-05-12","1","0","2014-05-12","17","","1","","SEM HE INTEL 620-0090 Apt Count =","2","2014-05-12 15:44:12","","8","Special","2","2014-05-12 16:31:00","2","2014-05-12 16:43:14","2","2014-05-13 08:43:43","2","142460","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2799","7","0","9991908","2014-05-12","1","0","2014-05-12","16","","1","","SEM HE INTEL 620-0090 Apt Count =","1","2014-05-12 12:20:32","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2800","1","0","8292593","2014-05-12","0","0","2014-05-13","11","","1","","IDSBG 820-5499-05","2","2014-05-12 14:02:39","4664","3","Z2","2","2014-05-13 08:09:33","2","2014-05-13 08:09:45","2","2014-05-13 08:44:29","2","142466","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2801","1","0","8292594","2014-05-12","0","0","2014-05-13","12","","1","","","2","2014-05-12 14:51:17","116","3","Z2","2","2014-05-12 19:18:06","2","2014-05-12 22:22:54","2","2014-05-13 08:45:21","2","142464","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2802","9","0","2814057","2014-05-12","0","0","2014-05-14","16","","1","","","2","2014-05-14 12:57:21","1350","4","Z2","2","2014-05-14 16:33:55","2","2014-05-14 18:54:55","2","2014-05-14 19:08:24","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2803","9","0","2814058","2014-05-12","0","0","2014-05-14","16","","1","","","2","2014-05-14 12:57:48","1462","5","Z2","2","2014-05-14 14:35:14","2","2014-05-14 18:55:08","2","2014-05-14 19:08:30","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2804","77","0","7281735","2014-05-12","1","0","2014-05-12","15.3","","1","","fixit","2","2014-05-12 13:31:41","22","5","","2","2014-05-12 14:16:49","2","2014-05-12 14:53:51","0","0000-00-00 00:00:00","2","142457","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2805","38","0","916117","2014-05-12","0","0","2014-05-13","12","","1","","Green Circuits ICE  3425","2","2014-05-13 02:53:18","206","5","Fuji4000","2","2014-05-13 08:31:03","2","2014-05-13 12:13:33","0","0000-00-00 00:00:00","2","142467","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2806","38","0","916118","2014-05-12","0","0","2014-05-13","12","","1","","Green Circuits ICE 3425","2","2014-05-13 02:53:46","2519","5","Fuji4000","2","2014-05-13 09:15:55","2","2014-05-13 12:13:39","0","0000-00-00 00:00:00","2","142467","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2807","25","0","966268","2014-05-12","1","0","2014-05-12","18","","10","","","2","2014-05-12 15:07:32","","4","Mini stencil","2","2014-05-12 16:11:12","2","2014-05-12 16:19:12","0","0000-00-00 00:00:00","2","142454","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2808","59","0","343325","2014-05-12","1","0","2014-05-13","9","","1","","","2","2014-05-12 15:07:45","","4","Mini stencil","2","2014-05-12 16:11:24","2","2014-05-12 16:19:03","2","2014-05-13 07:46:01","2","142456","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2809","1","0","8292595","2014-05-12","0","0","2014-05-13","15","","1","","IDSBG 920-00254-01","2","2014-05-12 19:33:01","251","4","Z2","2","2014-05-12 20:54:22","2","2014-05-12 21:03:27","2","2014-05-13 08:44:44","2","142465","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2810","93","0","2532153","2014-05-12","0","1","2014-05-13","15","","1","","SMTC LeCroy 210-0357-00","2","2014-05-13 09:24:38","64","4","Z2","2","2014-05-13 10:16:55","2","2014-05-13 13:54:08","2","2014-05-14 12:10:31","2","142488","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2811","93","0","2532154","2014-05-12","0","0","2014-05-13","15","","1","","SMTC LeCroy 210-0357-00","2","2014-05-13 09:35:08","174","4","Z2","2","2014-05-13 10:30:59","2","2014-05-13 14:15:36","2","2014-05-14 12:10:38","2","142488","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2812","97","0","4792363","2014-05-12","1","0","2014-05-13","9","","1","","Surface Art Oculus J","2","2014-05-12 19:32:23","1444","4","18X18","2","2014-05-12 19:55:18","2","2014-05-12 22:17:04","2","2014-05-13 08:43:52","2","142461","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2813","1","0","8292596","2014-05-12","0","0","2014-05-13","15","","1","","Foxconn iDSBGIDSBG 920-00352-01","2","2014-05-13 02:48:04","807","3","Z2","2","2014-05-13 12:08:32","2","2014-05-13 12:17:58","2","2014-05-13 13:41:37","2","142480","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2814","100","0","140203","2014-05-12","0","0","2014-05-13","16","","15","","","2","2014-05-13 09:24:39","597","6","18X18","2","2014-05-13 11:09:22","2","2014-05-13 14:24:48","0","0000-00-00 00:00:00","2","142476","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2815","100","0","140204","2014-05-12","0","0","2014-05-13","16","","15","","","2","2014-05-13 09:24:59","421","6","18X18","2","2014-05-13 10:56:58","2","2014-05-13 14:18:49","0","0000-00-00 00:00:00","2","142475","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2816","20","0","938684","2014-05-12","0","0","2014-05-13","17","","15","","Ascentron GLENDINNING 12724 P/N 790-2535","2","2014-05-13 03:15:52","5023","5","18X18","2","2014-05-13 10:06:59","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","142470","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2817","22","0","3474299","2014-05-12","0","0","2014-05-13","17","","8","","Axiom Electronics Boeing Compact Current Se 901767087 STP000870","2","2014-05-14 09:48:02","24","6","Foil Only","2","2014-05-14 10:42:59","2","2014-05-14 11:10:06","0","0000-00-00 00:00:00","2","142501","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2818","7","0","9991887F","2014-05-12","1","0","2014-05-13","10","","1","","","2","2014-05-12 17:39:19","620","8","Z1","2","2014-05-13 08:39:35","2","2014-05-13 09:08:08","2","2014-05-13 10:32:11","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2819","58","0","725609","2014-05-12","1","0","2014-05-13","16","","1","","Memory Bay  B83VRRCM-130-8T","2","2014-05-13 05:00:50","9598","4","","2","2014-05-13 10:43:22","2","2014-05-13 14:07:58","0","0000-00-00 00:00:00","2","142474","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2820","58","0","725610","2014-05-12","1","0","2014-05-13","16","","1","","Memory Bay  B83VRRCM-130-8T","2","2014-05-13 05:01:47","8574","4","","2","2014-05-13 10:43:27","2","2014-05-13 14:08:06","0","0000-00-00 00:00:00","2","142474","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2821","72","0","1262785","2014-05-13","1","0","2014-05-13","15","","1","","Pactron Incorporated PAC3066_13May2014_ WO25059_B, WO25173_T(LeadFree)","2","2014-05-13 05:12:33","635","4","Z2","2","2014-05-13 09:38:41","2","2014-05-13 12:13:23","2","2014-05-13 13:25:16","2","142469","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2822","72","0","1262786","2014-05-13","0","0","2014-05-13","18","","1","","Pactron Incorporated PAC3068_13May2014_ WO24736_B(Leaded)","2","2014-05-13 05:16:26","2727","4","Z2","2","2014-05-13 11:33:03","2","2014-05-13 13:46:16","0","0000-00-00 00:00:00","2","142481","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2823","72","0","1262787","2014-05-13","0","0","2014-05-13","18","","1","","","2","2014-05-13 05:31:39","1022","4","Fuji4000","2","2014-05-13 09:42:42","2","2014-05-13 13:46:26","0","0000-00-00 00:00:00","2","142468","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2824","72","0","1262788","2014-05-13","0","0","2014-05-13","18","","1","","Pactron Incorporated PAC3067_13May2014_ WO24927_T","2","2014-05-13 06:04:25","5582","4","Z2","2","2014-05-13 11:24:21","2","2014-05-13 14:31:20","0","0000-00-00 00:00:00","2","142482","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2825","7","0","9991915","2014-05-13","0","0","2014-05-14","17","","1","","SEM HE International Rectifier C D2110A SKT BOARD:1 Apt count =","1","2014-05-13 08:13:48","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2826","7","0","9991916","2014-05-13","0","0","2014-05-14","17","","1","","SEM HE International Rectifier C D2110A SKT BOARD:1 Apt count =","1","2014-05-13 08:13:55","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2827","7","0","9991913","2014-05-13","0","0","2014-05-14","17","","1","","SEM HE International Rectifier D2109A HIB:1 Apt count =","1","2014-05-13 08:44:16","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2828","7","0","9991914","2014-05-13","0","0","2014-05-14","17","","1","","SEM HE International Rectifier D2109A HIB:1 Apt count =","1","2014-05-13 08:44:06","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2829","7","0","9991911","2014-05-13","0","0","2014-05-14","17","","1","","SEM HE NXP SEMICOND. GERMANY GMB 2956_SAF360X_FT C13400:A Apt count =","1","2014-05-13 08:43:21","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2830","7","0","9991912","2014-05-13","0","0","2014-05-14","17","","1","","SEM HE NXP SEMICOND. GERMANY GMB 2956_SAF360X_FT C13400:A Apt count =","2","2014-05-14 09:22:22","1761","8","Z1","2","2014-05-14 09:51:50","2","2014-05-14 12:09:08","2","2014-05-14 12:09:18","2","142500","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2831","110","0","952392","2014-05-13","0","0","2014-05-14","16","","15","","Unitron  400-100-103","2","2014-05-13 15:17:22","2874","6","18X18","2","2014-05-14 12:31:55","2","2014-05-14 15:01:22","0","0000-00-00 00:00:00","2","142505","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2832","57","0","767143","2014-05-13","0","0","2014-05-14","16","","8","","","1","2014-05-13 10:09:44","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2833","57","0","767144","2014-05-13","0","0","2014-05-14","16","","8","","","1","2014-05-13 10:10:47","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2834","11","0","102118","2014-05-13","0","0","2014-05-14","9","","1","","Zollner Electronics Sandisk - EMS 1803820-00","2","2014-05-13 18:06:46","7934","5","Z3","2","2014-05-13 20:57:31","2","2014-05-14 15:55:24","2","2014-05-14 15:55:44","2","142512","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2835","11","0","102119","2014-05-13","0","0","2014-05-14","9","","1","","Zollner Electronics Sandisk - EMS 1803820-00","2","2014-05-13 18:08:26","1463","5","Z3","2","2014-05-13 21:15:27","2","2014-05-14 15:55:30","2","2014-05-14 15:55:54","2","142512","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2836","34","0","7994779","2014-05-13","0","0","2014-05-14","10","","1","","Creation Tech. ALCATEL ALC76-0554-03 Rev. 01 TALCS239_LF","2","2014-05-13 14:32:25","11867","5","Z2","2","2014-05-13 16:41:32","2","2014-05-13 19:02:16","2","2014-05-14 08:13:58","2","142486","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2837","34","0","7994780","2014-05-13","0","0","2014-05-14","10","","1","","Creation Tech. ALCATEL ALC76-0554-03 Rev. 01 TALCS239_LF","2","2014-05-13 14:32:45","5859","5","Z2","2","2014-05-13 15:59:59","2","2014-05-13 19:02:24","2","2014-05-14 08:14:10","2","142486","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2838","93","0","2532145F","2014-05-13","0","0","2014-05-14","10","","1","","","2","2014-05-14 11:54:57","","","Z2","2","2014-05-14 11:55:14","2","2014-05-14 12:09:30","2","2014-05-14 12:10:00","2","142503","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2839","93","0","2532146F","2014-05-13","0","0","2014-05-14","10","","1","","","2","2014-05-14 11:55:05","","","Z2","2","2014-05-14 11:55:20","2","2014-05-14 12:09:41","2","2014-05-14 12:10:09","2","142502","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2840","41","0","832746","2014-05-13","0","0","2014-05-14","8","","1","","CORDOVA_XCL_VIT_CUTTER VORTRAN_AVM_SCHEMATIC_REV SEMICONDUCTOR_ONSEC-14-08","2","2014-05-13 14:31:15","380","6","Foil Only","2","2014-05-13 16:53:46","2","2014-05-13 17:04:40","2","2014-05-14 08:14:46","2","142485","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2841","20","0","938685","2014-05-13","0","0","2014-05-14","16","","15","","","2","2014-05-13 12:58:05","1772","5","18X19","2","2014-05-13 15:03:13","2","2014-05-13 17:35:03","0","0000-00-00 00:00:00","2","142491","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2842","74","0","152007","2014-05-13","1","0","2014-05-13","17","","1","","","2","2014-05-13 11:24:12","640","6","Z2","2","2014-05-13 12:21:57","2","2014-05-13 14:31:09","0","0000-00-00 00:00:00","2","142483","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2843","34","0","7994781","2014-05-13","0","0","2014-05-14","12","","1","","Creation Tech. ALCATEL ALC76-0600-03 Rev. 01 TALCS240_LF","2","2014-05-13 18:51:14","6072","5","Z2","2","2014-05-13 21:21:58","2","2014-05-14 15:53:28","2","2014-05-14 15:53:04","2","142494","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2844","34","0","7994782","2014-05-13","0","0","2014-05-14","12","","1","","Creation Tech. ALCATEL ALC76-0600-03 Rev. 01 TALCS240_LF","2","2014-05-13 18:51:29","4602","5","Z2","2","2014-05-14 10:52:38","2","2014-05-14 14:44:46","2","2014-05-14 15:52:47","2","142494","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2845","4","0","321849","2014-05-13","0","0","2014-05-13","18","","1","","","2","2014-05-13 12:11:59","","8","","2","2014-05-13 13:00:27","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","142484","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2846","42","0","660040","2014-05-13","0","1","2014-05-14","12","","1","","","2","2014-05-13 12:57:31","1020","","Reball","2","2014-05-13 14:39:17","2","2014-05-14 11:36:10","2","2014-05-19 09:19:25","2","142516","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2847","6","0","739366","2014-05-13","0","0","2014-05-14","12","","1","","","2","2014-05-13 15:18:32","","5","Mini stencil","2","2014-05-13 17:54:51","2","2014-05-14 09:43:03","2","2014-05-14 10:57:59","2","142498","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2848","11","0","102120","2014-05-13","0","0","2014-05-15","9","","1","","Zollner Electronics VytronUS 1804344-00/5092548-00","2","2014-05-14 15:00:04","1026","5","Z2","2","2014-05-14 16:26:59","2","2014-05-14 20:16:57","2","2014-05-16 07:52:26","2","142545","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2849","11","0","102121","2014-05-13","0","0","2014-05-15","9","","1","","Zollner Electronics VytronUS 1804344-00/5092549-00","2","2014-05-14 15:00:21","1030","5","Z2","2","2014-05-14 16:14:54","2","2014-05-14 20:17:06","2","2014-05-16 07:52:35","2","142545","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2850","11","0","102122","2014-05-13","0","0","2014-05-15","9","","1","","Zollner Electronics VytronUS 1804345-00/5092550-00","2","2014-05-14 15:00:39","1074","5","Z2","2","2014-05-14 16:17:51","2","2014-05-14 20:41:21","2","2014-05-16 07:53:52","2","142548","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2851","11","0","102123","2014-05-13","0","0","2014-05-15","9","","1","","Zollner Electronics VytronUS 1804345-00/5092551-00","2","2014-05-14 15:00:57","982","5","Z2","2","2014-05-14 16:24:19","2","2014-05-14 20:41:28","2","2014-05-16 07:53:59","2","142548","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2852","11","0","102124","2014-05-13","0","0","2014-05-15","9","","1","","Zollner Electronics VytronUS 1803907-00/5092552-00","2","2014-05-14 15:01:24","181","5","Z2","2","2014-05-14 16:29:21","2","2014-05-14 20:57:03","2","2014-05-16 07:54:59","2","142547","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2853","11","0","102125","2014-05-13","0","0","2014-05-15","9","","1","","Zollner Electronics VytronUS 1803907-00/5092553-00","2","2014-05-14 15:01:42","616","5","Z2","2","2014-05-14 16:51:03","2","2014-05-14 20:57:09","2","2014-05-16 07:55:07","2","142547","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2854","51","0","9931424","2014-05-13","0","0","2014-05-14","15","","1","","Javad Javad 05-610202-01 Rev 3.1","2","2014-05-14 07:18:59","231","5","18X18","2","2014-05-14 10:34:05","2","2014-05-14 13:55:04","0","0000-00-00 00:00:00","0","","2","39","2014-05-14 10:56:48","2","1");
INSERT INTO tbl_jobs VALUES("2855","51","0","9931425","2014-05-13","0","0","2014-05-14","15","","1","","Javad Javad 05-610202-01 Rev 3.1","2","2014-05-14 10:12:05","883","4","18X18","2","2014-05-14 12:02:23","2","2014-05-14 14:51:25","0","0000-00-00 00:00:00","0","","2","40","2014-05-14 10:57:03","2","1");
INSERT INTO tbl_jobs VALUES("2856","11","0","102126","2014-05-13","0","0","2014-05-15","9","","1","","Zollner Electronics VytronUS 1803908-00/502554-00","2","2014-05-14 15:02:08","286","5","Z2","2","2014-05-14 16:47:49","2","2014-05-14 20:01:59","2","2014-05-16 07:55:55","2","142546","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2857","11","0","102127","2014-05-13","0","0","2014-05-15","9","","1","","Zollner Electronics VytronUS 1803908-00/5092555-00","2","2014-05-14 15:02:32","655","4","Z2","2","2014-05-14 17:06:04","2","2014-05-14 20:02:05","2","2014-05-16 07:56:02","2","142546","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2858","8","0","575436","2014-05-13","0","0","2014-05-14","15","","1","","Jabil Agilent ST-U9320-68013-PA-T U9320-20013 Rev A140305","2","2014-05-14 08:31:19","1316","5","Z2","2","2014-05-14 13:20:32","2","2014-05-14 15:37:01","2","2014-05-14 19:08:37","2","142514","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2859","7","0","9991862F","2014-05-13","1","0","2014-05-14","8","","1","","","2","2014-05-13 17:11:50","672","6","Foil Only","2","2014-05-13 20:33:03","2","2014-05-13 20:41:47","2","2014-05-14 08:14:30","2","142489","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2860","62","0","538120","2014-05-13","0","0","2014-05-15","16","","4","","Micro Systems Eng.  2200-03_Secondary","2","2014-05-14 07:35:04","5863","5/2.5","18X19","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2861","62","0","538119","2014-05-13","0","0","2014-05-15","16","","4","","Micro Systems Eng.  2200-00_Secondary","2","2014-05-14 07:34:02","5883","5/2.5","18X19","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2862","77","0","7281736","2014-05-13","1","0","2014-05-14","15","","1","","KT0386916-000-868","2","2014-05-13 19:17:20","","5","Mini stencil","2","2014-05-13 21:01:06","2","2014-05-14 09:42:37","2","2014-05-14 12:08:28","2","142499","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2863","77","0","7281737","2014-05-13","1","0","2014-05-14","15","","1","","","2","2014-05-13 18:50:53","","","Mini stencil","2","2014-05-13 21:01:00","2","2014-05-14 09:42:46","2","2014-05-14 12:08:35","2","142499","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2864","3","0","5632176","2014-05-13","0","0","2014-05-15","18","","4","","","2","2014-05-13 17:45:10","","Reball foils","","2","2014-05-14 20:18:14","2","2014-05-19 09:19:14","0","0000-00-00 00:00:00","2","142525","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2865","77","0","7281738","2014-05-13","1","0","2014-05-14","15","","1","","KT0386916-000-868  LOC:U78","2","2014-05-13 19:17:43","","5","Mini stencil","2","2014-05-13 21:01:10","2","2014-05-14 09:42:53","2","2014-05-14 12:08:42","2","142499","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2866","97","0","4792363F","2014-05-13","1","0","2014-05-13","19.3","","1","","","2","2014-05-13 18:33:22","FIXIT 6","4","18X18","2","2014-05-13 19:18:26","2","2014-05-14 08:28:17","2","2014-05-14 08:28:11","2","142495","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2867","11","0","102004R","2014-05-13","1","0","2014-05-14","10","","1","","Zollner Electronics RHEEM 1766103-00 RCBM-0012042418-00, Rev A 5092566-00","2","2014-05-13 21:10:05","3765","5","Z2","2","2014-05-14 08:34:35","2","2014-05-14 12:07:52","2","2014-05-14 12:08:08","0","","2","37","2014-05-14 08:23:53","2","1");
INSERT INTO tbl_jobs VALUES("2868","11","0","102005R","2014-05-13","1","0","2014-05-14","10","","1","","Zollner Electronics RHEEM 1766103-00 RCBM-0012042418-00, Rev A 5092567-00","2","2014-05-13 21:10:32","869","5","Z2","2","2014-05-14 08:30:47","2","2014-05-14 12:08:00","2","2014-05-14 12:08:15","0","","2","38","2014-05-14 08:24:07","2","1");
INSERT INTO tbl_jobs VALUES("2869","4","0","321850","2014-05-13","0","0","2014-05-15","8","","1","","Flextronics Philips 453561662542","2","2014-05-14 06:50:09","2152","4","Z2","2","2014-05-14 12:27:36","2","2014-05-14 15:21:42","2","2014-05-14 15:54:40","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2870","3","0","5632177","2014-05-13","0","0","2014-05-14","20","","8","","","2","2014-05-14 09:55:11","274","4","","2","2014-05-14 14:43:47","2","2014-05-14 16:06:29","0","0000-00-00 00:00:00","2","142507","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2871","8","0","575437","2014-05-13","0","0","2014-05-15","8","","1","","Jabil Circuit Gigamon GS132-00AF-400-D0 location U1 19 IO","2","2014-05-14 06:51:26","","5","Mini stencil","2","2014-05-14 12:17:18","2","2014-05-14 12:36:08","2","2014-05-14 19:08:43","2","142517","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2872","7","0","9991919","2014-05-14","0","0","2014-05-15","8","","1","","SEM HE Microprobe Inc 13115-70:A_54898A1 Apt count =","2","2014-05-15 13:08:32","4962","6","Z1","2","2014-05-15 15:32:51","2","2014-05-15 15:40:44","2","2014-05-15 15:44:22","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2873","7","0","9991920","2014-05-14","0","0","2014-05-15","8","","1","","Other:STENCIL INFORMATION: LASER ETCH STENCILFrame Size: select  Foil Thickness: Fiducials:Half Etch Bottom Image Alignment: Center PCB/Image CUSTOMER DATAETCHED ON STENCILSEM HE Microprobe Inc 13115-70:A_54898A1 Apt count =","2","2014-05-15 13:08:47","946","8","Z1","2","2014-05-15 15:25:08","2","2014-05-15 15:29:12","2","2014-05-15 15:44:36","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2874","7","0","9991921","2014-05-14","0","0","2014-05-15","8","","1","","SEM HE Microprobe Inc. TTF0735B:B Apt count =","1","2014-05-14 03:22:15","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2875","7","0","9991922","2014-05-14","0","0","2014-05-15","8","","1","","SEM HE Microprobe Inc. TTF0735B:B Apt count =","1","2014-05-14 03:22:30","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2876","7","0","9991923","2014-05-14","0","0","2014-05-15","8","","1","","SEM HE Freescale Semicon. Inc 51F00053-001A HEATWAVE X4 Apt count =","2","2014-05-14 12:04:02","2045","6","Z1","2","2014-05-14 14:05:48","2","2014-05-14 14:56:29","2","2014-05-14 14:59:02","2","142510","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2877","7","0","9991924","2014-05-14","0","0","2014-05-15","8","","1","","SEM HE Freescale Semicon. Inc 51F00053-001A HEATWAVE X4 Apt count =","1","2014-05-14 02:46:47","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2878","7","0","9991925","2014-05-14","0","0","2014-05-15","8","","1","","SEM HE Intel Corp. ITTO-630-0047:0 Apt count =","2","2014-05-14 10:17:53","1766","4","Foil Only","2","2014-05-14 14:18:38","2","2014-05-14 15:41:00","2","2014-05-15 07:52:40","2","142508","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2879","7","0","9991926","2014-05-14","0","0","2014-05-15","8","","1","","SEM HE Intel Corp. ITTO-630-0047:0 Apt count =","2","2014-05-14 10:18:11","2645","8","Foil Only","2","2014-05-14 16:21:29","2","2014-05-14 18:24:57","2","2014-05-15 07:53:04","2","142508","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2880","7","0","9991927","2014-05-14","0","0","2014-05-15","8","","1","","SEM HE Form Factor Inc. 200-40107(350-40107):1 Apt count =","2","2014-05-14 12:03:44","999","8","Z1","2","2014-05-14 16:01:11","2","2014-05-14 16:11:23","2","2014-05-15 07:53:16","2","142509","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2881","7","0","9991928","2014-05-14","0","0","2014-05-15","8","","1","","SEM HE Form Factor Inc. 200-40107(350-40107):1 Apt count =","1","2014-05-14 04:37:24","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2882","72","0","1262789","2014-05-14","0","0","2014-05-14","18","","1","","Pactron Incorporated PAC3071_14May2014_ WO25037_T","2","2014-05-14 07:18:13","2680","4","Fuji4000","2","2014-05-14 12:57:55","2","2014-05-14 15:11:59","2","2014-05-14 19:08:49","2","142506","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2883","3","0","5632178","2014-05-14","0","0","2014-05-15","16","","4","","Intel Geo Extreem ETB Merged H29723-001 MID","2","2014-05-15 12:34:53","274","4","","2","2014-05-15 16:59:30","2","2014-05-15 19:53:25","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2884","62","0","538772.","2014-05-14","0","0","2014-05-15","19.3","","5","","","2","2014-05-14 09:58:17","5863","5 / 2.5","18x19 step","2","2014-05-15 17:21:00","2","2014-05-15 19:32:05","0","0000-00-00 00:00:00","2","142535","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2885","62","0","538769.","2014-05-14","0","0","2014-05-15","19.3","","5","","","2","2014-05-14 09:58:44","5883","5 / 2.5","18x19 step","2","2014-05-15 17:21:08","2","2014-05-15 19:32:27","0","0000-00-00 00:00:00","2","142535","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2886","4","0","321851","2014-05-14","1","0","2014-05-14","14","","1","","","2","2014-05-14 11:14:29","6910","5","Z2","2","2014-05-14 13:57:17","2","2014-05-14 15:29:17","2","2014-05-14 15:54:27","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2887","51","0","9931426","2014-05-14","0","0","2014-05-15","10","","1","","","2","2014-05-14 11:37:02","713","4","18X18","2","2014-05-14 17:12:52","2","2014-05-14 19:00:58","2","2014-05-15 07:55:46","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2888","40","0","807080","2014-05-14","0","1","2014-05-15","19.3","","5","","","2","2014-05-15 05:27:06","","","Reball","2","2014-05-15 14:50:09","2","2014-05-15 15:48:30","0","0000-00-00 00:00:00","2","142536","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2889","70","0","1105157","2014-05-14","1","0","2014-05-15","18","","1","","","2","2014-05-15 17:17:04","483","5","Z2","2","2014-05-15 17:56:26","2","2014-05-15 20:25:24","2","2014-05-15 20:41:57","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2890","120","0","164008","2014-05-14","0","0","2014-05-15","17","","15","","Castle Creations S0T-0143-00 009-0143-00","2","2014-05-15 11:50:27","6287","5","Z2","2","2014-05-15 14:54:20","2","2014-05-15 19:51:47","0","0000-00-00 00:00:00","2","142533","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2891","120","0","164009","2014-05-14","0","0","2014-05-15","17","","15","","Castle Creations S0B-0143-00 009-0143-00","2","2014-05-15 11:51:02","6431","5","Z2","2","2014-05-15 14:48:55","2","2014-05-15 19:51:54","0","0000-00-00 00:00:00","2","142533","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2892","4","0","321852","2014-05-14","0","0","2014-05-15","11","","1","","","2","2014-05-20 14:59:07","7341","4","Z2","2","2014-05-20 18:30:54","2","2014-05-20 20:38:37","2","2014-05-21 07:40:19","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2893","4","0","321853","2014-05-14","0","0","2014-05-20","17","","1","","","2","2014-05-20 10:56:55","7385","4","Z2","2","2014-05-20 16:44:00","2","2014-05-20 18:50:10","2","2014-05-21 07:40:31","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2894","6","0","739366R","2014-05-14","1","0","2014-05-14","16","","1","","","2","2014-05-14 12:42:52","","","Mini stencil","2","2014-05-14 12:57:33","2","2014-05-14 14:31:01","2","2014-05-14 14:31:09","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2895","70","0","1105158","2014-05-14","0","0","2014-05-15","12","","1","","","2","2014-05-14 16:13:45","174","5","Z2","2","2014-05-14 18:51:32","2","2014-05-14 21:05:46","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2896","34","0","7994779F","2014-05-14","0","0","2014-05-14","16","","1","","","2","2014-05-14 14:50:39","","","Z2","2","2014-05-14 15:47:34","2","2014-05-14 15:53:48","2","2014-05-14 15:53:59","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2897","41","0","832747","2014-05-14","1","1","2014-05-16","9.3","","1","","FIRE-EYE_PRODUCTION_PCBV4","2","2014-05-15 14:40:22","65","3","Foil Only","2","2014-05-15 18:50:42","2","2014-05-15 20:11:38","2","2014-05-16 10:34:44","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2898","22","0","3474300","2014-05-14","0","0","2014-05-15","17","","8","","","2","2014-05-16 19:06:02","2956","5","Foil Only","2","2014-05-16 20:21:54","2","2014-05-16 20:33:30","0","0000-00-00 00:00:00","2","142576","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2899","62","0","538121","2014-05-14","0","0","2014-05-15","16","","4","","Micro Systems Eng. MSEI 4150_Secondary_Side","2","2014-05-15 07:35:02","383","4/2","Special","2","2014-05-15 17:47:15","2","2014-05-15 19:32:17","0","0000-00-00 00:00:00","2","142534","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2900","7","0","9991929","2014-05-14","1","0","2014-05-15","12","","1","","","2","2014-05-15 09:37:06","124","6","Z1","2","2014-05-15 10:06:28","2","2014-05-15 11:01:35","2","2014-05-15 11:01:53","2","142524","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2901","7","0","9991930","2014-05-14","1","0","2014-05-15","12","","1","","","2","2014-05-15 09:37:28","218","8","Z1","2","2014-05-15 10:11:36","2","2014-05-15 11:01:46","2","2014-05-15 11:02:00","2","142524","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2902","9","0","2814059","2014-05-14","0","0","2014-05-15","16","","1","","","2","2014-05-15 07:26:19","171","5","Z2","2","2014-05-15 09:46:25","2","2014-05-15 13:11:04","2","2014-05-15 13:13:12","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2903","51","0","9931429","2014-05-14","0","0","2014-05-15","16","","1","","Javad Google GO-90-1013 Rev 1.0.0","2","2014-05-16 07:47:04","5452","5","18X18","2","2014-05-16 12:44:34","2","2014-05-16 13:48:09","2","2014-05-16 14:09:28","0","","2","41","2014-05-16 13:36:55","2","1");
INSERT INTO tbl_jobs VALUES("2904","51","0","9931430","2014-05-14","0","0","2014-05-15","16","","1","","Javad Google GO-90-1013 Rev 1.0.0","2","2014-05-16 07:47:59","3943","5","18X18","2","2014-05-16 11:42:09","2","2014-05-16 13:48:16","2","2014-05-16 15:41:55","0","","2","42","2014-05-16 13:37:12","2","1");
INSERT INTO tbl_jobs VALUES("2905","51","0","9931427","2014-05-14","0","0","2014-05-15","16","","1","","Schilling Robotics 005-8881 Rev 3","2","2014-05-15 08:02:31","467","4","18X18","2","2014-05-15 11:13:05","2","2014-05-15 13:33:47","2","2014-05-15 13:49:17","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2906","51","0","9931428","2014-05-14","0","0","2014-05-15","16","","1","","Schilling Robotics 005-8881 Rev 3","2","2014-05-15 08:03:37","462","5","18X18","2","2014-05-15 11:56:48","2","2014-05-15 13:34:02","2","2014-05-15 13:49:28","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2907","1","0","8292597","2014-05-14","0","0","2014-05-15","16","","1","","IDSBG 920-00293-01","2","2014-05-15 07:29:29","107","3","Z2","2","2014-05-15 12:13:28","2","2014-05-15 12:23:14","2","2014-05-15 13:14:34","2","142528","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2908","59","0","343326","2014-05-14","1","0","2014-05-15","9","","1","","","2","2014-05-14 17:40:50","420","5","Foil Only","2","2014-05-14 18:38:59","2","2014-05-14 19:20:38","2","2014-05-15 07:50:12","2","142519","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2909","97","0","4792365","2014-05-14","1","0","2014-05-15","11","","1","","Surface Art Oculus  VR CBL002-005 J","2","2014-05-14 21:22:54","100","4","Foil Only","2","2014-05-14 21:44:13","2","2014-05-14 22:08:02","2","2014-05-15 07:50:52","2","142520","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2910","9","0","2814060","2014-05-14","1","0","2014-05-15","10","","1","","","2","2014-05-14 19:43:28","7215","5","Z2","2","2014-05-14 20:56:52","2","2014-05-14 22:08:34","2","2014-05-15 07:50:30","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2911","9","0","2814061","2014-05-14","1","0","2014-05-15","10","","1","","Sanmina NEWISYS PCA-00612-01-A","2","2014-05-14 22:23:48","3169","5","Z2","2","2014-05-15 08:54:38","2","2014-05-15 12:39:40","2","2014-05-15 13:13:23","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2912","9","0","2814062","2014-05-14","1","0","2014-05-15","10","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2913","9","0","2814063","2014-05-14","1","0","2014-05-15","10","","1","","Sanmina NEWISYS PCA-00614-01-A","2","2014-05-14 23:47:55","792","5","Z2","2","2014-05-15 09:34:01","2","2014-05-15 13:11:24","2","2014-05-15 13:13:32","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2914","2","0","5346914","2014-05-14","0","0","2014-05-15","16","","1","","Sanmina Saratoga Speed SSR-ASSY-000010-0001-A APERTURE COUNT","2","2014-05-15 05:24:49","7028","5","Z3","2","2014-05-15 11:32:13","2","2014-05-15 14:33:10","2","2014-05-15 14:42:42","2","142531","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2915","97","0","4792366","2014-05-14","0","0","2014-05-15","16","","1","","Surface Art LINEAR(DUST)  700-0187-0003 REV 00A  SA J","2","2014-05-15 07:28:43","456","4","18X18","2","2014-05-15 10:35:36","2","2014-05-15 13:14:10","2","2014-05-15 13:14:23","2","142526","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2916","41","0","832748","2014-05-14","0","0","2014-05-15","11","","1","","SSI_BARCELONO NDBC_SCOOP_INT","2","2014-05-15 07:27:12","445","6","Foil Only","2","2014-05-15 09:59:39","2","2014-05-15 11:02:15","2","2014-05-15 11:02:27","2","142523","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2917","9","0","2814064","2014-05-14","1","0","2014-05-15","10","","1","","Sanmina NEWISYS  PCA-00612-01-A","2","2014-05-14 22:24:11","3542","5","Z2","2","2014-05-15 10:50:06","2","2014-05-15 13:13:39","2","2014-05-15 13:13:45","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2918","72","0","1262790","2014-05-15","0","0","2014-05-15","18","","1","","Pactron Incorporated PAC3073_15May2014_ WO25025_T","2","2014-05-15 07:28:02","1996","4","Z2","2","2014-05-15 11:39:21","2","2014-05-15 13:49:43","2","2014-05-15 13:49:53","2","142532","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2919","72","0","1262791","2014-05-15","0","0","2014-05-15","18","","1","","Pactron Incorporated PAC3074_15May2014_ WO25158_T, WO25112_B(LeadFree)","2","2014-05-15 06:20:00","4356","4","Z2","2","2014-05-15 11:45:59","2","2014-05-15 13:10:40","2","2014-05-15 13:50:03","2","142530","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2920","72","0","1262792","2014-05-15","0","0","2014-05-15","18","","1","","Pactron Incorporated PAC3075_15May2014_ WO25169_T","2","2014-05-15 06:19:36","1437","4","Z2","2","2014-05-15 11:51:39","2","2014-05-15 13:10:30","2","2014-05-15 13:50:13","2","142529","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2921","8","0","575438","2014-05-15","0","0","2014-05-19","9","","1","","Jabil LTX 956-1472-01-AC-B 948-1472-01-AA","2","2014-05-16 18:38:12","1197","5","Special","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2922","104","0","559709","2014-05-15","1","0","2014-05-16","17","","10","","Tektronix Reorder","2","2014-05-19 14:26:36","109","5","Special","2","2014-05-19 15:24:28","2","2014-05-19 16:36:48","0","0000-00-00 00:00:00","2","142599","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2923","1","0","8292598","2014-05-15","0","0","2014-05-16","9","","1","","IDSBG 920-4445-03","2","2014-05-15 14:41:15","4844","3","Z2","2","2014-05-15 19:13:58","2","2014-05-15 19:14:05","2","2014-05-16 07:56:39","2","142540","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2924","110","0","952393","2014-05-15","0","0","2014-05-19","17","","15","","","2","2014-05-19 16:23:12","768","6","Z2","2","2014-05-19 19:39:34","2","2014-05-19 21:28:13","0","0000-00-00 00:00:00","2","142600","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2925","7","0","9991931","2014-05-15","1","0","2014-05-16","13","","1","","SEM HE MULTITEST CONSUL LIB BOARD REV 6. Apt Count =","2","2014-05-16 10:10:07","686","6","Foil Only","2","2014-05-16 11:23:08","2","2014-05-16 11:45:47","2","2014-05-16 12:51:49","2","142558","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2926","1","0","8292599","2014-05-15","0","0","2014-05-16","11","","1","","IDSBG 920-00173-01","2","2014-05-15 14:40:56","736","3","Z2","2","2014-05-15 18:40:31","2","2014-05-15 21:15:59","2","2014-05-16 07:57:09","2","142549","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2927","20","0","938686","2014-05-15","0","1","2014-05-16","16","","15","","","2","2014-05-16 06:12:47","","","Reball","2","2014-05-16 14:56:59","2","2014-05-16 15:45:33","0","0000-00-00 00:00:00","2","142566","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2928","97","0","4792367","2014-05-15","1","0","2014-05-15","14","","1","","","2","2014-05-15 12:53:00","2002","4","18X18","2","2014-05-15 13:48:36","2","2014-05-15 14:39:05","2","2014-05-15 14:42:19","2","142537","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2929","6","0","739366R.","2014-05-15","1","0","2014-05-15","15","","1","","","2","2014-05-15 12:22:35","","","Mini stencil","2","2014-05-15 13:16:56","2","2014-05-15 13:17:07","2","2014-05-15 13:17:14","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2930","22","0","3474301","2014-05-15","1","0","2014-05-16","16","","4","","","2","2014-05-16 08:35:21","","5","Mini stencil","2","2014-05-16 11:20:12","2","2014-05-16 11:23:47","0","0000-00-00 00:00:00","2","142557","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2931","76","0","173039","2014-05-15","1","0","2014-05-16","12","","1","","Piranha EMS, Inc Universal Audio  80-40509 REV3","2","2014-05-16 09:59:15","86","6","Z1","2","2014-05-16 11:02:21","2","2014-05-16 11:14:19","2","2014-05-16 12:51:26","2","142555","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2932","94","0","845053","2014-05-15","0","1","2014-05-19","17","","7","","","2","2014-05-15 17:41:46","","","Reball","2","2014-05-15 19:50:56","2","2014-05-16 17:01:33","0","0000-00-00 00:00:00","2","142577","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2933","94","0","845054","2014-05-15","0","1","2014-05-19","17","","7","","","2","2014-05-15 17:41:57","","","Reball","2","2014-05-15 19:50:44","2","2014-05-16 17:01:27","0","0000-00-00 00:00:00","2","142577","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2934","94","0","845055","2014-05-15","0","1","2014-05-19","17","","7","","","2","2014-05-15 17:42:09","","","Reball","2","2014-05-15 19:50:06","2","2014-05-16 17:01:21","0","0000-00-00 00:00:00","2","142577","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2935","94","0","845056","2014-05-15","0","1","2014-05-19","17","","7","","","2","2014-05-15 17:42:20","","","Reball","2","2014-05-15 19:50:20","2","2014-05-16 17:01:14","0","0000-00-00 00:00:00","2","142577","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2936","54","0","914622","2014-05-15","0","0","2014-05-16","14","","1","","Marvell Semiconductor  200659","2","2014-05-16 10:14:14","126","5","Foil Only","2","2014-05-16 12:56:40","2","2014-05-16 13:03:31","2","2014-05-16 13:36:54","2","142561","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2937","4","0","321855","2014-05-15","0","0","2014-05-16","14","","1","","Flextronics RGB Spectrum 620-0628-02","2","2014-05-16 08:11:21","7798","5","Z2","2","2014-05-16 10:34:32","2","2014-05-16 13:12:53","2","2014-05-16 16:24:19","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2938","4","0","321854","2014-05-15","1","1","2014-05-16","14","","1","","Flextronics Intel Fab H28340-001  Mini stencil U4VR2","2","2014-05-16 12:11:51","","4","Mini stencil","2","2014-05-16 12:22:55","2","2014-05-16 14:08:50","2","2014-05-16 14:08:58","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2939","95","0","252630","2014-05-15","0","0","2014-05-16","14","","1","","Stanford Research Systems  7-02460-701 Rev.A 5/15/14","2","2014-05-15 22:23:48","689","4","","2","2014-05-16 12:38:36","2","2014-05-16 13:59:08","2","2014-05-16 14:21:31","2","142564","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2940","34","0","7994784","2014-05-15","0","0","2014-05-16","14","","1","","","2","2014-05-16 06:11:33","42269","5","Z2","2","2014-05-16 11:40:31","2","2014-05-16 13:31:32","2","2014-05-16 13:35:30","2","142560","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2941","34","0","7994785","2014-05-15","0","0","2014-05-16","14","","1","","","2","2014-05-16 10:11:07","31084","5","Z2","2","2014-05-16 14:32:46","2","2014-05-16 16:08:36","2","2014-05-16 16:31:24","2","142565","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2942","29","0","919113","2014-05-15","0","0","2014-05-16","15","","1","","","2","2014-05-16 07:10:33","886","5","Foil Only","2","2014-05-16 13:17:30","2","2014-05-16 13:28:18","2","2014-05-16 13:36:28","2","142568","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2943","113","0","111254","2014-05-15","1","0","2014-05-15","17","","1","","","2","2014-05-15 15:24:42","mini","12","","2","2014-05-15 16:45:58","2","2014-05-15 19:17:57","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2944","9","0","2814065","2014-05-15","1","0","2014-05-15","18","","1","","Sanmina NEWISYS PCA-00611-01-A","2","2014-05-15 16:28:07","2624","5","Z2","2","2014-05-15 17:14:06","2","2014-05-15 19:25:02","2","2014-05-15 19:42:07","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2945","9","0","2814066","2014-05-15","1","0","2014-05-15","18","","1","","Sanmina NEWISYS PCA-00611-01-A","2","2014-05-15 16:28:25","2918","5","Z2","2","2014-05-15 17:14:22","2","2014-05-15 19:25:08","2","2014-05-15 19:42:13","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2946","97","0","4792368","2014-05-15","0","0","2014-05-16","10","","1","","","2","2014-05-15 16:24:32","reball","5 and 8","","2","2014-05-15 20:28:07","2","2014-05-16 15:49:37","2","2014-05-16 15:49:47","2","142559","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2947","19","0","835272","2014-05-15","0","0","2014-05-16","17","","15","","","2","2014-05-16 08:10:17","1603","6","Z2","2","2014-05-16 15:14:30","2","2014-05-16 15:15:40","0","0000-00-00 00:00:00","2","142563","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2948","2","0","5346915","2014-05-15","0","0","2014-05-16","17","","1","","Sanmina Saratoga Speed  SSR-ASSY-000101-01 Rev A Location U1","2","2014-05-16 06:17:04","","4","Mini stencil","2","2014-05-16 10:40:17","2","2014-05-16 11:03:35","2","2014-05-16 12:50:24","2","142556","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2949","2","0","5346916","2014-05-15","0","0","2014-05-16","17","","1","","Sanmina Saratoga Speed SSR-ASSY-000101-01 Rev A Location U17","2","2014-05-16 06:17:34","","4","Mini stencil","2","2014-05-16 10:40:32","2","2014-05-16 11:03:46","2","2014-05-16 12:50:30","2","142556","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2950","4","0","321856","2014-05-15","0","0","2014-05-16","17","","1","","","2","2014-05-16 08:33:35","","","Print part","2","2014-05-16 14:57:06","2","2014-05-16 15:46:03","2","2014-05-16 17:15:25","2","142570","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2951","4","0","321857","2014-05-15","0","0","2014-05-16","17","","1","","","2","2014-05-16 06:12:20","1009","4","Z2","2","2014-05-16 14:37:36","2","2014-05-16 16:21:15","2","2014-05-16 17:15:36","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2952","97","0","4792369","2014-05-15","0","0","2014-05-16","18","","1","","Surface Art Oculus VR J","2","2014-05-16 07:30:12","2610","4","18X18","2","2014-05-16 13:46:41","2","2014-05-16 15:02:31","2","2014-05-16 16:25:40","2","142562","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2953","72","0","1262793","2014-05-15","0","0","2014-05-16","10","","1","","","2","2014-05-16 08:09:31","","7","Mini stencil","2","2014-05-16 08:21:58","2","2014-05-16 08:42:23","2","2014-05-16 08:59:45","2","142551","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2954","4","0","321858","2014-05-15","0","0","2014-05-16","16","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2955","103","0","504353","2014-05-15","0","0","2014-05-19","17","","8","","Tektronix, Inc. REF","2","2014-05-16 08:34:11","","","Print part","2","2014-05-16 14:57:12","2","2014-05-16 16:17:48","0","0000-00-00 00:00:00","2","142569","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2956","72","0","1262794","2014-05-16","0","0","2014-05-19","18","","1","","Pactron Incorporated PAC3077_16May2014_ WO24601_T","2","2014-05-16 08:54:04","6169","6/4","Z2 step","2","2014-05-19 19:25:02","2","2014-05-19 21:19:12","2","2014-05-20 07:52:58","2","142593","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2957","72","0","1262795","2014-05-16","0","0","2014-05-16","18","","1","","","2","2014-05-16 08:10:29","1960","4","Z2","2","2014-05-16 14:52:07","2","2014-05-16 16:12:59","2","2014-05-16 16:31:33","2","142567","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2958","7","0","9991932","2014-05-16","0","0","2014-05-19","17","","1","","SEM HE Microprobe Inc. 13553-70:A_54929A1 Apt count =","2","2014-05-19 10:07:14","5275","6","Foil Only","2","2014-05-20 08:45:58","2","2014-05-20 09:05:33","2","2014-05-20 10:06:41","2","142595","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2959","7","0","9991933","2014-05-16","0","0","2014-05-19","17","","1","","SEM HE Microprobe Inc. 13553-70:A_54929A1 Apt count =","1","2014-05-16 07:57:28","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2960","7","0","9991934","2014-05-16","0","0","2014-05-19","17","","1","","SEM HE Microprobe Inc. TTF0833B:B Apt count =","1","2014-05-16 08:20:47","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2961","7","0","9991935","2014-05-16","0","0","2014-05-19","17","","1","","SEM HE Microprobe Inc. TTF0833B:B Apt count =","1","2014-05-16 08:21:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2962","7","0","9991936","2014-05-16","0","0","2014-05-19","17","","1","","SEM HE Form Factor Inc. 200-30097(350-30097):1 Apt count =","2","2014-05-19 10:07:52","3268","6","Foil Only","2","2014-05-19 16:25:26","2","2014-05-19 17:13:18","2","2014-05-20 07:52:28","2","142591","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2963","7","0","9991937","2014-05-16","0","0","2014-05-19","17","","1","","SEM HE Form Factor Inc. 200-30097(350-30097):1 Apt count =","2","2014-05-19 10:08:18","584","8","Foil Only","2","2014-05-19 13:55:09","2","2014-05-19 14:00:56","2","2014-05-20 07:52:37","2","142591","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2964","7","0","9991938","2014-05-16","0","0","2014-05-19","17","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2965","7","0","9991939","2014-05-16","0","0","2014-05-28","17","","1","","SEM HE N-Trig (MTS GmbH) D-Lite BGA LB C13609:A Apt count =","2","2014-05-28 14:09:47","936","8","Z1","2","2014-05-28 15:51:33","2","2014-05-28 15:54:43","2","2014-05-28 15:55:43","2","142742","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2966","7","0","9991940","2014-05-16","0","0","2014-05-19","17","","1","","SEM HE Nuvoton Te (MTS) \\\\uRider LQFP64 Chromax4 A Apt count =","1","2014-05-19 06:34:57","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2967","7","0","9991941","2014-05-16","0","0","2014-05-19","17","","1","","SEM HE Nuvoton Te (MTS) \\\\uRider LQFP64 Chromax4 A Apt count =","1","2014-05-19 06:35:09","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2968","51","0","9931431","2014-05-16","0","0","2014-05-19","8","","1","","Javad Tehama TW-110 Rev 3.0","2","2014-05-16 13:43:20","4052","5","18X18","2","2014-05-16 14:46:03","2","2014-05-16 16:13:51","2","2014-05-19 07:55:39","0","","2","44","2014-05-16 15:46:36","2","1");
INSERT INTO tbl_jobs VALUES("2969","97","0","4792370","2014-05-16","0","0","2014-05-19","10","","1","","Surface Art Pelco PA30-0209-00 REV X0 J","2","2014-05-16 13:43:38","2477","6","18X18","2","2014-05-16 15:29:01","2","2014-05-16 16:27:47","2","2014-05-19 07:55:23","2","142571","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2970","43","0","5413985","2014-05-16","0","0","2014-05-19","10","","1","","Infiniti Solutions Job","2","2014-05-16 16:22:11","1709","7","Fuji4000","2","2014-05-16 18:21:18","2","2014-05-16 19:30:23","2","2014-05-19 07:56:31","2","142572","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2971","43","0","5413988","2014-05-16","0","0","2014-05-19","10","","1","","Infiniti Solutions Job","2","2014-05-16 18:11:48","1996","8","Z2","2","2014-05-16 19:57:00","2","2014-05-16 20:46:24","2","2014-05-19 07:57:00","2","142574","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2972","43","0","5413989","2014-05-16","0","0","2014-05-19","10","","1","","Infiniti Solutions Job","2","2014-05-16 18:12:17","2168","7","Fuji4000","2","2014-05-16 19:50:47","2","2014-05-16 21:18:32","2","2014-05-19 07:57:08","2","142574","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2973","43","0","5413986","2014-05-16","0","0","2014-05-19","10","","1","","Infiniti Solutions Job","2","2014-05-16 18:12:49","1832","8","Z2","2","2014-05-16 19:45:08","2","2014-05-16 20:40:20","2","2014-05-19 07:56:39","2","142573","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2974","43","0","5413987","2014-05-16","0","0","2014-05-19","10","","1","","Infiniti Solutions Job","2","2014-05-16 18:13:18","1604","7","Fuji4000","2","2014-05-16 20:41:55","2","2014-05-19 07:40:03","2","2014-05-19 07:56:51","2","142573","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2975","4","0","321859","2014-05-16","1","0","2014-05-19","10","","1","","","2","2014-05-16 17:39:12","","6","Mini stencil","2","2014-05-16 21:06:49","2","2014-05-19 11:21:49","2","2014-05-19 14:59:04","0","","2","45","2014-05-19 13:13:08","2","1");
INSERT INTO tbl_jobs VALUES("2976","24","0","822061","2014-05-16","0","1","2014-05-19","17","","11","","Benchmark TI GJZ (S-PBGA-N160","2","2014-05-19 08:15:05","","","Reball","2","2014-05-19 09:49:00","2","2014-05-19 12:20:52","0","0000-00-00 00:00:00","2","142590","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2977","7","0","9991942","2014-05-16","0","0","2014-05-19","11","","1","","SEM HE COMPRO BUSINESS SERVICES  FHQ3558 GRI.UFLEX C26375A Apt count =","1","2014-05-19 05:41:30","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2978","7","0","9991943","2014-05-16","0","0","2014-05-19","11","","1","","SEM HE COMPRO BUSINESS SERVICES  FHQ3558 GRI.UFLEX C26375A Apt count =","1","2014-05-19 05:41:39","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2979","97","0","4792371","2014-05-16","0","0","2014-05-19","11","","1","","Surface Art Tensilica KC705-DB REV C J","2","2014-05-19 07:57:20","1832","5","Z2","2","2014-05-19 11:34:40","2","2014-05-19 13:14:39","2","2014-05-19 14:59:21","2","142586","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2980","97","0","4792372","2014-05-16","0","0","2014-05-19","11","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2981","51","0","9931432","2014-05-16","0","0","2014-05-20","13","","1","","Schilling Robotics 005-8879 Rev 3","2","2014-05-19 08:08:41","1434","4","18X18","2","2014-05-19 11:26:57","2","2014-05-19 13:21:41","2","2014-05-19 14:44:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2982","97","0","4792373","2014-05-16","0","0","2014-05-19","13","","1","","Surface Art Tensilica ML605-DB-A-15 Rev C J","2","2014-05-19 07:58:43","1905","5","18X18","2","2014-05-19 11:31:21","2","2014-05-19 12:46:25","2","2014-05-19 14:42:27","2","142588","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2983","9","0","2814067","2014-05-16","0","0","2014-05-19","14.3","","1","","Sanmina - SCI, Corp. RDC Assy 131-723 PCB 132-0723 rev 1","2","2014-05-19 10:37:47","2868","5","Z2","2","2014-05-19 13:14:56","2","2014-05-19 16:03:44","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2984","9","0","2814068","2014-05-16","1","0","2014-05-16","17","","1","","Sanmina Symmetricom 4395B-10","2","2014-05-16 14:51:45","456","5","Z2","2","2014-05-16 15:23:52","2","2014-05-16 17:14:41","2","2014-05-16 17:15:07","0","","2","43","2014-05-16 15:00:19","2","1");
INSERT INTO tbl_jobs VALUES("2985","100","0","140205","2014-05-16","0","0","2014-05-20","17","","15","","Synergetics Monome Monome","2","2014-05-20 14:28:03","787","6","18X18","2","2014-05-20 21:06:45","2","2014-05-20 22:26:39","0","0000-00-00 00:00:00","2","142629","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2986","33","0","703155","2014-05-16","0","0","2014-05-19","15","","8","","Crane Electronics, Inc  30051-101 Rev 2","2","2014-05-19 16:04:52","2352","4","18X18","2","2014-05-19 19:46:38","2","2014-05-19 20:40:05","0","0000-00-00 00:00:00","2","142609","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2987","8","0","575T439","2014-05-16","0","0","2014-05-19","15","","1","","","2","2014-05-19 03:07:41","","","Special","2","2014-05-20 07:16:49","2","2014-05-20 07:16:57","2","2014-05-20 10:06:58","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2988","8","0","575T440","2014-05-16","0","0","2014-05-19","15","","1","","","2","2014-05-19 03:07:59","","","Special","2","2014-05-20 07:17:06","2","2014-05-20 07:17:11","2","2014-05-20 10:07:05","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2989","5","0","4894523","2014-05-16","0","0","2014-05-19","15","","1","","","2","2014-05-19 10:09:00","1942","5","Z2","2","2014-05-19 13:11:22","2","2014-05-19 15:39:17","2","2014-05-20 10:06:20","2","142610","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2990","5","0","4894524","2014-05-16","0","0","2014-05-19","15","","1","","","2","2014-05-19 10:09:37","916","7","Z2","2","2014-05-19 13:43:46","2","2014-05-19 15:39:28","2","2014-05-20 10:06:27","2","142610","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2991","7","0","9991688F","2014-05-16","0","0","2014-05-19","17","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("2992","97","0","4792374","2014-05-16","0","0","2014-05-19","16","","1","","","2","2014-05-19 07:59:46","","","Mini stencil","2","2014-05-19 09:48:50","2","2014-05-19 11:31:55","2","2014-05-19 14:42:35","2","142587","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2993","7","0","9991946","2014-05-16","1","0","2014-05-19","17","","1","","SEM HE","2","2014-05-19 10:10:22","1490","8","Foil Only","2","2014-05-19 14:06:07","2","2014-05-19 14:13:55","0","0000-00-00 00:00:00","2","142594","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2994","97","0","4792375","2014-05-16","0","0","2014-05-20","10","","1","","Surface Art LINEAR(DUST)  700-0232-0001(TC3 TB BEAR ABLE) REV01A/SAJ","2","2014-05-19 19:21:17","231","4","18X18","2","2014-05-19 21:58:22","2","2014-05-19 21:58:28","2","2014-05-20 07:54:23","2","142607","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2995","97","0","4792376","2014-05-16","0","0","2014-05-20","10","","1","","Surface Art LINEAR(DUST) 700-0232-0002(TC3 TB BEAR ABLE) REV 01A/SA J","2","2014-05-19 08:00:41","278","4","18X18","2","2014-05-19 11:04:04","2","2014-05-19 12:46:42","2","2014-05-19 14:42:47","2","142582","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2996","2","0","5346917","2014-05-16","0","1","2014-05-19","17","","1","","Sanmina Saratoga Speed SSR-ASSY-000108-02 REV2.3 APERTURE COUNT","2","2014-05-19 08:15:27","934","5","Z2","2","2014-05-19 11:18:56","2","2014-05-19 14:29:34","0","0000-00-00 00:00:00","2","142598","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2997","51","0","9931433","2014-05-16","0","0","2014-05-19","17","","1","","Javad Javad 05-577001-01 Rev. 4.1","2","2014-05-19 07:44:41","4214","4","18X19","2","2014-05-19 11:23:20","2","2014-05-19 12:49:38","2","2014-05-19 14:43:46","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2998","97","0","4792377","2014-05-18","0","0","2014-05-19","18","","1","","Surface Art Laser Devices 7479 REV1 CREE XPGBWT-L1-R250-00H51 J","2","2014-05-19 08:01:09","","","Mini stencil","2","2014-05-19 09:48:26","2","2014-05-19 11:32:07","2","2014-05-19 14:44:25","2","142589","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("2999","97","0","4792378","2014-05-18","0","0","2014-05-19","18","","1","","Surface Art Laser Devices/J","2","2014-05-19 08:01:40","","","Mini stencil","2","2014-05-19 09:48:33","2","2014-05-19 11:32:18","2","2014-05-19 14:44:41","2","142585","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3000","31","0","7582280","2014-05-18","0","0","2014-05-19","20","","8","","Controltek  970-ITAR-0026-0 TOP 180-ITAR-0028-B TOP","2","2014-05-19 08:15:46","585","4","18X18","2","2014-05-19 16:25:37","2","2014-05-19 18:13:35","0","0000-00-00 00:00:00","2","142592","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3001","72","0","1262796","2014-05-19","0","0","2014-05-19","18","","1","","Pactron Incorporated PAC3079_19May2014 WO24905_B Leaded","2","2014-05-19 06:36:09","2282","4","Z2","2","2014-05-19 11:09:10","2","2014-05-19 13:09:21","0","0000-00-00 00:00:00","2","142580","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3002","72","0","1262797","2014-05-19","0","0","2014-05-19","18","","1","","Pactron Incorporated PAC3080_19May2014 WO25218_T","2","2014-05-19 06:37:06","1030","4","Z2","2","2014-05-19 11:13:20","2","2014-05-19 14:19:33","0","0000-00-00 00:00:00","2","142581","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3003","7","0","9991947","2014-05-19","1","1","2014-05-19","14","","1","","","2","2014-05-19 12:25:13","","6","Mini stencil","2","2014-05-19 13:18:32","2","2014-05-19 15:45:36","0","0000-00-00 00:00:00","2","142604","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3004","10","0","2392986","2014-05-19","1","0","2014-05-19","17","","1","","","2","2014-05-19 15:16:33","3685","4","Z2","2","2014-05-19 16:19:28","2","2014-05-19 20:31:49","2","2014-05-20 07:53:53","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3005","10","0","2392987","2014-05-19","1","0","2014-05-19","17","","1","","","2","2014-05-19 15:16:59","341","6","Z2","2","2014-05-19 16:15:28","2","2014-05-19 20:31:54","2","2014-05-20 07:53:46","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3006","43","0","5413990","2014-05-19","0","0","2014-05-20","8","","1","","Infiniti Solutions Job","2","2014-05-19 12:45:23","5438","8","Fuji4000","2","2014-05-19 21:04:51","2","2014-05-19 21:58:00","2","2014-05-20 07:55:25","2","142605","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3007","51","0","9931434","2014-05-19","0","0","2014-05-20","9","","1","","WestCom Nurse Call 20118214 Rev A","2","2014-05-19 12:45:54","172","5","18X18","2","2014-05-19 16:25:32","2","2014-05-19 19:27:42","2","2014-05-20 07:54:48","0","","2","46","2014-05-20 07:50:52","2","1");
INSERT INTO tbl_jobs VALUES("3008","7","0","9991948","2014-05-19","1","0","2014-05-20","8.3","","1","","","2","2014-05-19 17:19:01","774","8","Foil Only","2","2014-05-19 19:20:21","2","2014-05-19 19:30:45","2","2014-05-20 07:54:12","2","142606","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3009","7","0","9991949","2014-05-19","1","0","2014-05-20","8.3","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3010","22","0","3474302","2014-05-19","1","0","2014-05-20","17","","4","","Axiom Electronics SLM000004 Location U5E","2","2014-05-20 13:08:11","","5","Mini stencil","2","2014-05-20 14:32:34","2","2014-05-20 15:04:24","0","0000-00-00 00:00:00","2","142622","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3011","97","0","4792379","2014-05-19","0","0","2014-05-20","11","","1","","Surface Art Intel Santa Clara JARVIS AVT REV B J","2","2014-05-19 16:06:27","","4","Special","2","2014-05-19 21:14:30","2","2014-05-20 08:50:56","2","2014-05-20 10:06:50","2","142611","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3012","51","0","9931435","2014-05-19","0","0","2014-05-20","11","","1","","Javad Google GO-90-1015 Rev 1.0.0","2","2014-05-19 21:58:32","509","5","18X18","2","2014-05-20 12:12:15","2","2014-05-20 13:51:00","2","2014-05-20 13:51:06","0","","2","47","2014-05-20 13:12:12","2","1");
INSERT INTO tbl_jobs VALUES("3013","59","0","343327","2014-05-19","1","0","2014-05-20","9","","1","","","2","2014-05-19 17:48:04","1885","5","Z2","2","2014-05-19 18:44:46","2","2014-05-19 21:02:29","2","2014-05-20 07:53:15","2","142596","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3014","59","0","343328","2014-05-19","1","0","2014-05-20","9","","1","","","2","2014-05-19 18:02:38","355","5","Z3","2","2014-05-19 19:01:40","2","2014-05-19 21:02:33","2","2014-05-20 07:53:24","2","142597","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3015","120","0","164010","2014-05-19","0","0","2014-05-20","18","","12","","Castle Creations S0B-0144-00 009-0144-00","2","2014-05-20 14:27:33","7575","5","Z2","2","2014-05-20 20:47:31","2","2014-05-21 08:47:33","0","0000-00-00 00:00:00","2","142631","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3016","120","0","164011","2014-05-19","0","0","2014-05-20","18","","12","","Castle Creations S0T-0144-00 009-0144-00","2","2014-05-20 14:27:10","4359","5","Z2","2","2014-05-20 21:17:26","2","2014-05-21 08:47:42","0","0000-00-00 00:00:00","2","142631","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3017","74","0","152008","2014-05-19","0","0","2014-05-20","18","","1","","Paramit Corporation PLL-PL0B8 REV A VO1 PLL-PL0B9 REV A Pad Ct:","2","2014-05-20 12:52:22","1472","5","Z2","2","2014-05-21 10:08:24","2","2014-05-21 11:50:23","2","2014-05-21 12:11:30","2","142620","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3018","74","0","152009","2014-05-19","0","0","2014-05-20","18","","1","","Paramit Corporation PLL-PL0B8 REV A VO1 PLL-PL0B9 REV A Pad Ct:","2","2014-05-20 12:53:01","1336","5","Z2","2","2014-05-20 19:05:09","2","2014-05-20 22:36:28","2","2014-05-21 12:11:52","2","142620","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3019","97","0","4792381","2014-05-19","0","0","2014-05-20","15","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3020","54","0","914623","2014-05-19","0","0","2014-05-20","14","","1","","Marvell Marvell Semiconductor 01_RAPTOR2_2125_F8_A1","2","2014-05-19 21:43:06","516","5","Foil Only","2","2014-05-20 12:01:21","2","2014-05-20 12:05:52","2","2014-05-20 13:44:31","2","142616","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3021","3","0","5632179","2014-05-19","0","0","2014-05-20","19.3","","5","","Intel Kool Corner TNTV G90126-001","2","2014-05-20 09:56:44","6152","5","Special","2","2014-05-20 18:42:23","2","2014-05-20 19:24:17","0","0000-00-00 00:00:00","2","142619","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3022","2","0","5346918","2014-05-19","1","1","2014-05-20","14","","1","","APERTURE COUNT VIRIDENT 22000-00123 REV.A2","2","2014-05-20 09:41:21","22468","4","Z2","2","2014-05-20 13:43:47","2","2014-05-20 14:56:32","0","0000-00-00 00:00:00","2","142625","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3023","41","0","832749","2014-05-19","0","0","2014-05-20","10","","1","","","2","2014-05-20 04:09:54","660","6","Foil Only","2","2014-05-20 12:08:00","2","2014-05-20 12:30:25","2","2014-05-20 12:54:41","2","142615","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3024","40","0","807081","2014-05-19","0","1","2014-05-21","17","","8","","","2","2014-05-20 06:04:18","","","Reball","2","2014-05-21 11:04:20","2","2014-05-21 11:15:26","0","0000-00-00 00:00:00","2","142655","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3025","34","0","7994786","2014-05-19","0","0","2014-05-20","17","","1","","Creation Tech. ALCATEL ALC76-0742-01 Rev. 01 TALCS242_LF","2","2014-05-20 04:29:59","2334","4","Z2","2","2014-05-21 09:59:31","2","2014-05-21 11:54:44","2","2014-05-21 12:01:17","2","142623","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3026","43","0","5413991","2014-05-19","1","1","2014-05-20","10","","1","","Infiniti Solutions Job","2","2014-05-19 20:45:34","312","4","Z2","2","2014-05-19 21:14:46","2","2014-05-19 21:58:13","2","2014-05-20 07:54:38","2","142608","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3027","5","0","4894525","2014-05-19","0","0","2014-05-20","17","","1","","OnCore Manufacturing Christie Digital Systems CHR-001-112351-01 REV 001 RoHS","2","2014-05-20 14:57:55","4267","4","Z2","2","2014-05-20 21:33:12","2","2014-05-20 22:24:32","2","2014-05-21 10:52:34","2","142630","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3028","5","0","4894526","2014-05-19","0","0","2014-05-20","17","","1","","OnCore Manufacturing Christie Digital Systems CHR-001-112351-01 REV 001 RoHS","2","2014-05-20 14:58:25","1340","4","Z2","2","2014-05-21 09:05:26","2","2014-05-21 10:52:26","2","2014-05-21 10:52:42","2","142630","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3029","72","0","1262798","2014-05-20","1","0","2014-05-20","18","","1","","Pactron Incorporated PAC3082_20May2014 WO24264_T","2","2014-05-20 07:51:20","3572","4","Z2","2","2014-05-20 10:50:18","2","2014-05-20 13:51:43","2","2014-05-20 13:52:12","2","142618","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3030","72","0","1262799","2014-05-20","0","0","2014-05-20","18","","1","","Pactron Incorporated PAC3083_20May2014 WO25108_T","2","2014-05-20 07:51:49","1636","4","Z2","2","2014-05-20 10:53:57","2","2014-05-20 13:51:53","2","2014-05-20 13:52:04","2","142617","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3031","76","0","173040","2014-05-20","1","0","2014-05-20","12","","1","","Piranha EMS, Inc Cephasoncis RX64_10200203_Rev 3 Loc U17","2","2014-05-20 10:32:55","","5","Mini stencil","2","2014-05-20 11:23:29","2","2014-05-20 11:26:30","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3032","76","0","173041","2014-05-20","0","1","2014-05-21","12","","1","","Piranha EMS, Inc Cephasoncis RX64_10200203_Rev 3 Loc U17","2","2014-05-20 13:59:23","","","Reball","2","2014-05-20 14:32:42","2","2014-05-21 10:52:29","2","2014-05-21 12:01:04","2","142621","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3033","100","0","140206","2014-05-20","1","0","2014-05-20","17","","15","","Synergetics Bogart B-400","2","2014-05-20 12:13:54","1080","6","18X18","2","2014-05-20 14:22:19","2","2014-05-20 15:15:37","0","0000-00-00 00:00:00","2","142612","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3034","3","0","5632180","2014-05-20","0","0","2014-05-21","19.3","","5","","Intel Corporation Wilson Beach PB","2","2014-05-21 10:27:13","7304","4","Special","2","2014-05-21 19:52:28","2","2014-05-21 19:58:58","0","0000-00-00 00:00:00","2","142648","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3035","11","0","102130","2014-05-20","0","0","2014-05-21","11","","1","","","2","2014-05-20 16:19:42","799","4","Z2","2","2014-05-21 10:51:44","2","2014-05-21 13:06:49","2","2014-05-27 10:12:44","2","142701","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3036","11","0","102131","2014-05-20","0","0","2014-05-21","11","","1","","","1","2014-05-20 12:35:29","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3037","76","0","173040.","2014-05-20","1","0","2014-05-20","14","","1","","","2","2014-05-20 19:19:16","5412","4","Z1","2","2014-05-20 20:41:09","2","2014-05-20 21:15:19","2","2014-05-21 12:00:51","2","142621","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3038","97","0","4792382","2014-05-20","0","0","2014-05-21","15","","1","","","2","2014-05-21 11:16:31","1962","4","Z3","2","2014-05-21 12:47:27","2","2014-05-21 14:23:47","2","2014-05-21 14:45:11","2","142642","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3039","22","0","3474303","2014-05-20","0","0","2014-05-21","17","","8","","Axiom Electronics Cloud Cap Technology 905000392 STB000333","2","2014-05-21 08:59:02","1694","5","Foil Only","2","2014-05-21 15:52:13","2","2014-05-21 16:33:28","0","0000-00-00 00:00:00","2","142644","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3040","75","0","170031","2014-05-20","1","0","2014-05-21","17","","10","","Pelco Luis Guerrero 01-1000-911","2","2014-05-20 17:41:24","2016","5","Z2","2","2014-05-21 12:18:26","2","2014-05-21 15:13:38","0","0000-00-00 00:00:00","2","142633","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3041","8","0","575444","2014-05-20","0","0","2014-05-21","12","","1","","","2","2014-05-21 07:58:44","","","Mini stencil","2","2014-05-21 09:50:55","2","2014-05-21 16:01:57","2","2014-05-30 12:06:31","2","142775","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3042","8","0","575443","2014-05-20","0","0","2014-05-21","12","","1","","","2","2014-05-21 07:58:56","","","Mini stencil","2","2014-05-21 09:51:00","2","2014-05-21 16:01:51","2","2014-05-30 12:06:22","2","142775","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3043","8","0","575442","2014-05-20","0","0","2014-05-21","12","","1","","","2","2014-05-21 07:59:09","","","Mini stencil","2","2014-05-21 09:51:08","2","2014-05-21 16:01:47","2","2014-05-30 12:06:16","2","142775","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3044","8","0","575441","2014-05-20","0","0","2014-05-21","12","","1","","","2","2014-05-21 13:00:20","","","Print part","2","2014-05-21 15:56:40","2","2014-05-21 16:01:40","2","2014-05-30 12:05:59","2","142775","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3045","2","0","5346918.","2014-05-20","1","0","2014-05-20","17","","1","","","2","2014-05-20 14:04:16","22468","4","Z2","2","2014-05-20 18:01:19","2","2014-05-20 18:50:16","0","0000-00-00 00:00:00","2","142627","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3046","59","0","343331","2014-05-20","1","0","2014-05-21","9","","1","","","2","2014-05-20 16:40:59","3693","5","Z2","2","2014-05-20 19:35:06","2","2014-05-20 22:24:19","2","2014-05-21 07:40:55","2","142628","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3047","59","0","343332","2014-05-20","1","0","2014-05-21","9","","1","","","2","2014-05-20 16:41:27","3733","5","Z2","2","2014-05-20 19:03:05","2","2014-05-20 20:15:38","2","2014-05-21 07:41:07","2","142628","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3048","59","0","343329","2014-05-20","1","0","2014-05-21","9","","1","","Meritronics Xilinx AFX-FFVD1924 Rev.B","2","2014-05-20 16:08:13","3693","5","Z2","2","2014-05-20 19:59:39","2","2014-05-21 07:26:31","2","2014-05-21 07:40:41","2","142628","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3049","59","0","343330","2014-05-20","1","0","2014-05-21","9","","1","","Meritronics Xilinx AFX-FFVD1924 Rev.B","2","2014-05-20 16:08:36","3631","5","Z2","2","2014-05-20 18:57:15","2","2014-05-20 20:14:27","2","2014-05-21 07:40:48","2","142268","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3050","7","0","9991950","2014-05-20","0","0","2014-05-21","14","","1","","SEM HE Feinmetall GmbH 8VBMT256-015 C13511:B Apt count =","1","2014-05-21 03:46:58","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3051","7","0","9991951","2014-05-20","0","0","2014-05-21","14","","1","","SEM HE Feinmetall GmbH 8VBMT256-015 C13511:B Apt count =","1","2014-05-21 03:47:25","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3052","19","0","835273","2014-05-20","0","0","2014-05-21","17","","15","","","2","2014-05-21 08:53:17","4850","6","Z2","2","2014-05-21 13:49:19","2","2014-05-21 16:02:04","0","0000-00-00 00:00:00","2","142654","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3053","19","0","835274","2014-05-20","0","0","2014-05-21","17","","15","","","2","2014-05-21 08:53:37","2869","6","Z2","2","2014-05-21 14:19:19","2","2014-05-21 16:23:13","0","0000-00-00 00:00:00","2","142654","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3054","19","0","835275","2014-05-20","0","0","2014-05-21","17","","15","","","2","2014-05-21 08:53:58","1773","6","Z2","2","2014-05-21 14:57:49","2","2014-05-21 16:29:44","0","0000-00-00 00:00:00","2","142652","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3055","19","0","835276","2014-05-20","0","0","2014-05-21","17","","15","","","2","2014-05-21 08:54:24","703","6","Z2","2","2014-05-21 13:50:09","2","2014-05-21 15:40:54","0","0000-00-00 00:00:00","2","142652","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3056","19","0","835277","2014-05-20","0","0","2014-05-21","17","","15","","","2","2014-05-21 08:54:50","3063","5","Z2","2","2014-05-21 15:25:07","2","2014-05-21 16:29:37","0","0000-00-00 00:00:00","2","142652","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3057","19","0","835278","2014-05-20","0","0","2014-05-21","17","","15","","","2","2014-05-21 08:55:14","793","6","Z2","2","2014-05-21 11:32:51","2","2014-05-21 13:30:19","0","0000-00-00 00:00:00","2","142652","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3058","22","0","3474304","2014-05-20","0","0","2014-05-21","17","","8","","Axiom Electronics Samtec Connector SLM000005","2","2014-05-21 03:59:24","","","Mini stencil","2","2014-05-21 15:34:48","2","2014-05-21 16:37:55","0","0000-00-00 00:00:00","2","142647","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3059","43","0","5413992","2014-05-20","0","0","2014-05-21","15","","1","","","2","2014-05-20 17:33:36","1028","5","Fuji4000","2","2014-05-21 17:47:58","2","2014-05-21 18:56:09","2","2014-05-22 07:44:21","2","142641","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3060","43","0","5413993","2014-05-20","0","0","2014-05-21","15","","1","","","2","2014-05-20 17:34:03","2403","8","Fuji4000","2","2014-05-21 11:25:21","2","2014-05-21 12:59:59","2","2014-05-22 07:44:29","2","142641","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3061","7","0","9991952","2014-05-20","0","0","2014-05-21","14","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3062","7","0","9991953","2014-05-20","0","0","2014-05-21","14","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3063","7","0","9991954","2014-05-20","1","0","2014-05-28","17","","1","","","2","2014-05-28 14:10:21","271","8","Z1","2","2014-05-28 16:15:24","2","2014-05-28 16:17:33","0","0000-00-00 00:00:00","2","142743","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3064","7","0","9991955","2014-05-20","1","0","2014-05-28","17","","1","","","2","2014-05-28 14:10:54","1309","8","Z1","2","2014-05-28 17:28:24","2","2014-05-28 17:37:13","0","0000-00-00 00:00:00","2","142743","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3065","7","0","9991956","2014-05-20","0","0","2014-05-21","15","","1","","SEM HE Microprobe Inc. TTF0834A:A Apt count =","2","2014-05-21 10:20:57","1585","8","Foil Only","2","2014-05-21 17:27:57","2","2014-05-21 17:44:07","0","0000-00-00 00:00:00","2","142643","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3066","7","0","9991957","2014-05-20","0","0","2014-05-21","15","","1","","","1","2014-05-21 04:48:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3067","2","0","5346920","2014-05-20","0","1","2014-05-21","15","","1","","APERTURE COUNT VIRIDENT 22000-00122 REV.A2","2","2014-05-21 04:00:18","24996","4","Z3","2","2014-05-21 13:36:15","2","2014-05-21 15:21:54","0","0000-00-00 00:00:00","2","142645","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3068","2","0","5346920.","2014-05-20","0","0","2014-05-21","15","","1","","APERTURE COUNT VIRIDENT 22000-00122 REV.A2","2","2014-05-21 04:00:48","24996","4","Z3","2","2014-05-21 19:00:27","2","2014-05-21 19:54:24","2","2014-05-22 07:44:39","2","142646","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3069","54","0","914624","2014-05-20","1","0","2014-05-23","15","","1","","","2","2014-05-23 11:03:51","7960","4","Special","2","2014-05-23 12:57:58","2","2014-05-23 14:07:08","0","0000-00-00 00:00:00","2","142689","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3070","7","0","9991958","2014-05-20","0","0","2014-05-21","15","","1","","","1","2014-05-21 07:23:19","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3071","7","0","9991959","2014-05-20","0","0","2014-05-21","15","","1","","SEM HE COMPRO BUSINESS SERVICES FHQ3558 GRINGOTTS UFLEX M Apt count =","1","2014-05-21 07:24:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3072","100","0","140207","2014-05-20","0","0","2014-05-21","17","","15","","Synergetics Merkle MK43-6-201-5-2","2","2014-05-21 09:52:21","448","6","18X18","2","2014-05-21 15:37:27","2","2014-05-21 15:56:17","0","0000-00-00 00:00:00","2","142635","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3073","4","0","321860","2014-05-20","1","0","2014-05-21","12","","1","","Flextronics Cavium CVNC-CN70XX-SFF-EVB-02 Location : U1014","2","2014-05-21 10:01:04","","7","Mini stencil","2","2014-05-21 10:25:22","2","2014-05-21 10:51:55","2","2014-05-21 10:52:06","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3074","1","0","8292600","2014-05-20","0","0","2014-05-22","8","","1","","Foxconn-iDSBG iDSBG 820-3633-06","2","2014-05-21 10:12:39","34824","3","Z2","2","2014-05-22 09:31:07","2","2014-05-22 13:06:54","2","2014-05-22 14:57:51","2","142649","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3075","8","0","575445","2014-05-20","0","0","2014-05-23","21","","1","","Jabil Circuit Zebra ST-P102-2032-003-B-T P102-2032-000-B","2","2014-05-23 11:16:11","3748","4","Z2","2","2014-05-23 13:07:30","2","2014-05-23 15:25:24","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3076","57","0","767145","2014-05-20","1","0","2014-05-22","16","","10","","Hewlett Packard 046439-1-1 (SensorPack)","2","2014-05-21 08:57:44","394","4","Foil Only","2","2014-05-21 10:18:36","2","2014-05-21 10:30:12","0","0000-00-00 00:00:00","2","142639","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3077","4","0","321861","2014-05-20","0","0","2014-05-22","8","","1","","Flextronics VIO-620-0119-00 VIO-610-0061-03 REV.02","2","2014-05-21 12:36:44","7097","5","Z3","2","2014-05-21 20:38:47","2","2014-05-21 21:25:02","2","2014-05-22 07:45:02","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3078","35","0","800224","2014-05-20","1","0","2014-05-21","14","","1","","Creation Tech. SNJ Exalt location U1 203556 rev 1","2","2014-05-21 03:58:55","","","Mini stencil","2","2014-05-21 09:47:09","2","2014-05-21 09:47:16","2","2014-05-21 10:50:39","2","142636","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3079","35","0","800225","2014-05-20","1","0","2014-05-21","17","","1","","Creation Tech. SNJ Intel  Trabuco canyon  location U2G1","2","2014-05-21 03:58:24","","","Mini stencil","2","2014-05-21 09:47:21","2","2014-05-21 09:47:28","2","2014-05-21 10:51:26","2","142637","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3080","72","0","1262800","2014-05-21","1","0","2014-05-21","16","","1","","","2","2014-05-21 07:46:22","519","4","Z2","2","2014-05-21 09:34:23","2","2014-05-21 12:30:44","2","2014-05-21 13:16:23","2","142638","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3081","9","0","2814064R","2014-05-21","1","0","2014-05-21","14","","1","","","2","2014-05-21 10:58:58","3542","5","Z2","2","2014-05-21 12:06:08","2","2014-05-21 13:33:21","2","2014-05-21 13:34:25","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3082","77","0","7281740","2014-05-21","0","0","2014-05-22","10","","1","","","2","2014-05-21 13:15:19","","5","Mini stencil","2","2014-05-21 19:57:54","2","2014-05-22 10:08:52","2","2014-05-22 10:22:39","2","142651","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3083","51","0","9931436","2014-05-21","0","0","2014-05-22","10","","1","","Javad JAVAD 05-610075-01 Rev 1.1","2","2014-05-21 17:14:38","5465","4","18X18","2","2014-05-21 19:44:33","2","2014-05-21 20:39:04","2","2014-05-22 07:45:12","0","","2","49","2014-05-22 08:18:44","2","1");
INSERT INTO tbl_jobs VALUES("3084","51","0","9931437","2014-05-21","0","0","2014-05-22","10","","1","","Javad JAVAD 05-610075-01 Rev 1.1","2","2014-05-21 17:15:32","1295","5","18X18","2","2014-05-21 19:38:17","2","2014-05-21 20:41:58","2","2014-05-22 07:45:18","0","","2","50","2014-05-22 08:19:08","2","1");
INSERT INTO tbl_jobs VALUES("3085","3","0","5632181","2014-05-21","0","0","2014-05-22","19.3","","5","","","2","2014-05-22 08:34:19","","6","Mini stencil","2","2014-05-22 10:04:03","2","2014-05-22 10:22:49","0","0000-00-00 00:00:00","2","142662","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3086","51","0","9931438","2014-05-21","0","0","2014-05-22","10","","1","","JAVAD 05-620074-01 Rev 2.1","2","2014-05-22 05:21:35","1955","4","18X18","2","2014-05-22 09:19:34","2","2014-05-22 10:52:03","2","2014-05-22 11:16:59","0","","2","51","2014-05-22 10:17:48","2","1");
INSERT INTO tbl_jobs VALUES("3087","51","0","9931439","2014-05-21","0","0","2014-05-22","10","","1","","JAVAD 05-620074-01 Rev 2.1","2","2014-05-22 05:22:01","261","5","18X18","2","2014-05-22 09:00:04","2","2014-05-22 10:52:11","2","2014-05-22 11:17:08","0","","2","52","2014-05-22 10:18:03","2","1");
INSERT INTO tbl_jobs VALUES("3088","43","0","5413994","2014-05-21","0","0","2014-05-22","11","","1","","Infiniti Solutions Exar 410-20051 Rev 1D Job","2","2014-05-21 18:56:32","12016","4","Z2","2","2014-05-22 08:54:25","2","2014-05-22 11:06:19","2","2014-05-22 11:16:53","2","142659","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3089","7","0","9991960","2014-05-21","0","1","2014-05-22","17","","1","","SEM HE Orion Tech. 910-OT-011-B230-100 Apt Count =","2","2014-05-22 10:34:32","554","6","Foil Only","2","2014-05-22 12:18:56","2","2014-05-22 12:32:46","2","2014-05-22 13:14:21","2","142665","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3090","7","0","9991961","2014-05-21","0","0","2014-05-22","17","","1","","SEM HE Orion Tech. 910-OT-011-B230-100 Apt Count =","2","2014-05-22 10:35:07","347","8","Foil Only","2","2014-05-22 12:41:47","2","2014-05-22 13:01:18","2","2014-05-22 13:14:28","2","142665","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3091","67","0","981117","2014-05-21","0","0","2014-05-22","11","","1","","TROPOS NETWORKS 300303-01","2","2014-05-22 06:43:41","","","Mini stencil","2","2014-05-22 10:42:48","2","2014-05-22 10:42:55","2","2014-05-22 11:17:39","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3092","2","0","5346922","2014-05-21","0","1","2014-05-22","11","","1","","","2","2014-05-22 05:23:00","1735","5","Z2","2","2014-05-22 09:08:00","2","2014-05-22 11:15:40","2","2014-05-22 11:17:46","2","142658","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3093","2","0","5346923","2014-05-21","0","1","2014-05-22","11","","1","","","2","2014-05-22 05:23:47","994","5","Z2","2","2014-05-22 09:12:49","2","2014-05-22 11:15:46","2","2014-05-22 11:17:52","2","142658","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3094","8","0","575446","2014-05-21","1","1","2014-05-21","17","","1","","Jabil THEA P2 eMMC Interposer Fab 0061 rev A","2","2014-05-21 12:15:53","","4 AND 10","Reball","2","2014-05-21 12:51:35","2","2014-05-21 18:12:05","0","0000-00-00 00:00:00","0","","2","48","2014-05-21 15:23:06","2","1");
INSERT INTO tbl_jobs VALUES("3095","27","0","872209","2014-05-21","0","0","2014-05-22","12","","1","","CAL TECH ISI 116720 Rev A","2","2014-05-22 14:52:14","3576","5","Foil Only","2","2014-05-22 16:59:25","2","2014-05-22 17:22:03","2","2014-05-23 07:59:29","2","142679","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3096","19","0","835279","2014-05-21","0","0","2014-05-22","16","","15","","","2","2014-05-22 08:25:02","2162","6","Z2","2","2014-05-22 09:43:07","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3097","59","0","343333","2014-05-21","1","0","2014-05-22","9","","1","","Meritronics Proteus G130227-1NT Rev.B","2","2014-05-21 15:24:11","3874","5","Z2","2","2014-05-21 16:42:23","2","2014-05-21 18:45:00","2","2014-05-22 07:44:48","2","142653","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3098","10","0","2392976R","2014-05-21","1","0","2014-05-21","15.3","","1","","","2","2014-05-21 14:52:28","","4","Mini stencil","2","2014-05-21 15:24:44","2","2014-05-21 15:24:50","2","2014-05-22 07:45:59","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3099","97","0","4792383","2014-05-21","0","0","2014-05-22","15","","1","","Surface Art Pelco PA30-0330-00 REV A0 J","2","2014-05-22 05:18:23","318","5","Foil Only","2","2014-05-22 09:59:01","2","2014-05-22 10:27:34","2","2014-05-22 11:17:22","2","142660","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3100","84","0","222093R","2014-05-21","1","0","2014-05-22","8","","1","","","2","2014-05-21 19:06:49","7786","5","Special","2","2014-05-21 20:24:22","2","2014-05-21 21:24:40","2","2014-05-22 07:45:39","2","142656","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3101","3","0","5632172.","2014-05-21","0","0","2014-05-22","19.3","","5","","Intel 1380-4_fxtr_prt1_rev3 Invar","2","2014-05-22 05:45:14","","","Mini stencil","2","2014-05-22 10:11:20","2","2014-05-22 10:13:51","0","0000-00-00 00:00:00","2","142661","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3102","1","0","8292601","2014-05-21","0","0","2014-05-22","17","","1","","Foxconn iDSBG IDSBG 921-00117-01","2","2014-05-22 05:46:15","1020","3","Z2","2","2014-05-22 12:25:08","2","2014-05-22 13:26:50","2","2014-05-22 14:58:18","2","142667","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3103","1","0","8292602","2014-05-21","0","0","2014-05-22","17","","1","","IDSBG 920-00271-02","2","2014-05-21 22:24:12","1708","3","Z2","2","2014-05-22 11:39:34","2","2014-05-22 13:33:23","2","2014-05-22 14:58:47","2","142670","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3104","34","0","7994787","2014-05-21","0","0","2014-05-22","17","","1","","Creation Tech. Alcatel ALC76-0528-07 Rev. 01 TALCS243_LF","2","2014-05-22 06:45:19","23026","5","Z2","2","2014-05-22 19:00:51","2","2014-05-22 20:17:32","2","2014-05-23 07:59:46","2","142674","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3105","34","0","7994788","2014-05-21","0","0","2014-05-22","17","","1","","Creation Tech. Alcatel ALC76-0528-07 Rev. 01 TALCS243_LF","2","2014-05-22 06:46:01","19858","5","Z2","2","2014-05-22 16:13:02","2","2014-05-22 18:29:05","0","0000-00-00 00:00:00","2","142673","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3106","97","0","4792384","2014-05-21","0","0","2014-05-23","8","","1","","Surface Art Flip Tech  Sonotab L10 A Rev X01 J","2","2014-05-22 05:20:07","3342","5","18X18","2","2014-05-22 11:21:17","2","2014-05-22 13:10:55","2","2014-05-22 14:57:26","2","142671","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3107","97","0","4792385","2014-05-21","0","0","2014-05-23","8","","1","","Surface Art Flip Tech  Sonotab L10 B Rev X01 J","2","2014-05-22 05:45:48","3325","5","18X18","2","2014-05-22 11:21:22","2","2014-05-22 13:17:35","2","2014-05-22 14:57:05","2","142669","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3108","54","0","914625","2014-05-21","0","0","2014-05-23","20","","1","","","2","2014-05-22 15:02:56","","4","Mini stencil","2","2014-05-22 19:38:11","2","2014-05-23 10:16:51","2","2014-05-23 11:18:49","2","142686","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3109","76","0","173042","2014-05-21","1","0","2014-05-22","15","","1","","","2","2014-05-22 13:46:31","2912","5","Z1","2","2014-05-22 15:31:13","2","2014-05-22 15:47:44","0","0000-00-00 00:00:00","2","142675","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3110","76","0","173043","2014-05-21","1","0","2014-05-22","15","","1","","","1","2014-05-22 00:25:08","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3111","67","0","981118","2014-05-21","0","0","2014-05-22","11","","1","","TROPOS NETWORKS 300303-01","2","2014-05-22 06:44:09","","","Mini stencil","2","2014-05-22 10:00:14","2","2014-05-22 13:45:06","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3112","72","0","1262801","2014-05-22","0","0","2014-05-22","18","","1","","","2","2014-05-22 05:20:59","716","4","Z2","2","2014-05-22 17:04:06","2","2014-05-22 18:20:43","2","2014-05-23 07:57:48","2","142672","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3113","3","0","5632182","2014-05-22","0","0","2014-05-23","16","","4","","Intel Corporation Neverfail Point DUT PB","2","2014-05-22 15:20:24","12131","3","Special","2","2014-05-23 13:18:07","2","2014-05-23 16:08:02","0","0000-00-00 00:00:00","2","142692","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3114","51","0","9931440","2014-05-22","0","0","2014-05-23","9","","1","","Javad Tehama CP-100-FAB-5.2","2","2014-05-22 14:47:27","4608","5","18X18","2","2014-05-22 19:13:28","2","2014-05-22 20:11:13","2","2014-05-23 07:59:57","0","","2","54","2014-05-23 08:41:26","2","1");
INSERT INTO tbl_jobs VALUES("3115","19","0","835280","2014-05-22","0","0","2014-05-22","16","","15","","","2","2014-05-22 11:12:52","509","6","Z2","2","2014-05-22 12:38:16","2","2014-05-22 13:41:03","0","0000-00-00 00:00:00","2","142666","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3116","4","0","321862","2014-05-22","0","0","2014-05-23","10","","1","","","2","2014-05-27 16:34:21","9649","5","Z2","2","2014-05-27 18:48:32","2","2014-05-27 21:10:27","2","2014-05-28 07:49:23","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3117","4","0","321863","2014-05-22","0","0","2014-05-23","10","","1","","","2","2014-05-27 16:34:38","3860","5","Z2","2","2014-05-27 18:18:06","2","2014-05-27 21:02:25","2","2014-05-28 07:49:30","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3118","51","0","9931441","2014-05-22","0","0","2014-05-23","10","","1","","Javad JAVAD 05-620101-01 Rev 4.1","2","2014-05-28 11:33:03","2287","3","18X18","2","2014-05-28 12:44:13","2","2014-05-28 15:02:01","0","0000-00-00 00:00:00","0","","2","61","2014-05-28 14:54:19","2","1");
INSERT INTO tbl_jobs VALUES("3119","51","0","9931442","2014-05-22","0","0","2014-05-23","10","","1","","Javad JAVAD 05-620101-01 Rev 4.1","2","2014-05-28 11:34:29","1685","4","18X18","2","2014-05-28 12:43:57","2","2014-05-28 15:01:48","0","0000-00-00 00:00:00","0","","2","62","2014-05-28 14:54:37","2","1");
INSERT INTO tbl_jobs VALUES("3120","88","0","6092056","2014-05-22","0","0","2014-05-23","16","","15","","Sanmina MOOG CB14993-003 A Primary","2","2014-05-23 08:33:19","1517","6","Z2","2","2014-05-23 10:22:31","2","2014-05-23 12:56:56","0","0000-00-00 00:00:00","2","142687","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3121","54","0","914626","2014-05-22","0","0","2014-05-23","11","","1","","Marvell Semiconductor 01_MF1_2036_F1_A1","2","2014-05-22 15:03:28","2718","4","Foil Only","2","2014-05-22 20:23:07","2","2014-05-22 20:30:22","2","2014-05-23 07:57:34","2","142682","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3122","19","0","835279.","2014-05-22","0","0","2014-05-22","16","","15","","","2","2014-05-22 11:13:24","1653","6","Z2","2","2014-05-22 14:58:13","2","2014-05-22 16:37:57","0","0000-00-00 00:00:00","2","142666","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3123","1","0","8292603","2014-05-22","0","0","2014-05-23","11","","1","","","2","2014-05-22 17:12:21","6243","4","Z2","2","2014-05-22 20:30:26","2","2014-05-22 21:28:59","2","2014-05-23 08:00:20","2","142681","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3124","74","0","152010","2014-05-22","1","0","2014-05-22","15","","1","","","2","2014-05-22 11:08:02","220","5","Z2","2","2014-05-22 11:44:24","2","2014-05-22 13:44:48","2","2014-05-22 13:45:40","2","142668","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3125","8","0","575446R","2014-05-22","0","0","2014-05-23","11","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3126","51","0","9931443","2014-05-22","0","0","2014-05-23","11","","1","","Schilling Robotics 005-9067 Rev 2","2","2014-05-22 15:34:57","3002","4","18X18","2","2014-05-22 19:36:18","2","2014-05-22 20:38:54","2","2014-05-23 08:00:09","0","","2","53","2014-05-23 08:40:56","2","1");
INSERT INTO tbl_jobs VALUES("3127","51","0","9931444","2014-05-22","0","0","2014-05-23","11","","1","","Schilling Robotics 005-8883 Rev 1","2","2014-05-23 06:49:17","1190","4","18X18","2","2014-05-23 09:42:04","2","2014-05-23 11:27:14","2","2014-05-23 11:27:22","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3128","3","0","5632183","2014-05-22","0","0","2014-05-22","6","","4","","","2","2014-05-22 12:33:20","3338","4","Mini stencil","2","2014-05-22 19:20:40","2","2014-05-22 19:20:48","0","0000-00-00 00:00:00","2","142664","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3129","9","0","2814065F","2014-05-22","0","0","2014-05-23","13","","1","","Sanmina NEWISYS PCA-00611-01-A","2","2014-05-22 15:19:51","","5","","2","2014-05-22 20:50:34","2","2014-05-22 21:01:05","2","2014-05-23 08:00:33","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3130","4","0","321864","2014-05-22","0","0","2014-05-23","13","","1","","Flextronics PHILO  PLO-970-00071-02_Rev-2C21 PLO-651-00039-03_X1","2","2014-05-23 12:19:48","5814","4","Z2","2","2014-05-23 13:55:30","2","2014-05-23 17:58:36","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3131","7","0","9991962","2014-05-22","0","0","2014-05-28","17","","1","","","2","2014-05-27 11:02:55","865","5","Fuji4000","2","2014-05-28 12:59:35","2","2014-05-28 15:00:35","0","0000-00-00 00:00:00","2","142712","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3132","1","0","8292604","2014-05-22","0","0","2014-05-23","15","","1","","IDSBG 920-3808-03","2","2014-05-23 06:27:36","6961","3","Z2","2","2014-05-23 10:35:38","2","2014-05-23 13:22:41","0","0000-00-00 00:00:00","2","142682","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3133","1","0","8292605","2014-05-22","0","0","2014-05-23","15","","1","","IDSBG 920-3808-03","2","2014-05-23 06:27:54","857","3","Z2","2","2014-05-23 09:22:28","2","2014-05-23 14:03:18","0","0000-00-00 00:00:00","2","142682","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3134","7","0","9991963","2014-05-22","0","0","2014-05-23","15","","1","","SEM HE Multitest A4 DC C13523A Apt Count = SEM HE Multitest A4 DC C13523A Apt Count =","1","2014-05-23 07:17:22","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3135","7","0","9991964","2014-05-22","0","0","2014-05-23","15","","1","","SEM HE Multitest A4 DC C13523A Apt Count =","2","2014-05-27 16:54:59","524","","","2","2014-05-27 16:55:13","2","2014-05-27 21:11:11","2","2014-05-28 07:50:02","2","142721","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3136","1","0","8292606","2014-05-22","0","0","2014-05-23","15","","1","","IDSBG 920-00355-01","2","2014-05-22 21:09:36","1094","3","Z2","2","2014-05-23 09:34:04","2","2014-05-23 13:29:15","0","0000-00-00 00:00:00","2","142683","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3137","1","0","8292607","2014-05-22","0","0","2014-05-23","16","","1","","IDSBG 920-00292-01","2","2014-05-22 21:44:40","682","4","Z2","2","2014-05-23 11:28:22","2","2014-05-23 13:16:22","0","0000-00-00 00:00:00","2","142691","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3138","70","0","1105159","2014-05-22","0","0","2014-05-23","16","","1","","","2","2014-05-23 13:27:43","871","6","Z2","2","2014-05-23 14:39:45","2","2014-05-28 13:55:40","2","2014-05-28 13:55:55","2","142697","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3139","9","0","2814061F","2014-05-22","1","0","2014-05-22","18","","1","","","2","2014-05-22 16:50:08","","5","","2","2014-05-22 19:09:10","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3140","76","0","173044","2014-05-22","0","0","2014-05-23","17","","1","","","2","2014-05-27 11:07:13","6529","4","Z1","2","2014-05-27 13:04:06","2","2014-05-27 13:15:02","2","2014-05-27 14:58:26","2","142708","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3141","4","0","321868","2014-05-22","0","0","2014-05-23","17","","1","","Flextronics Philo PLO-970-00071-02_Rev-2C21 Fab","2","2014-05-23 12:20:31","5430","4","Z2","2","2014-05-23 14:04:18","2","2014-05-23 16:38:44","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3142","9","0","2814074","2014-05-22","0","0","2014-05-23","17","","1","","Sanmina  PC052 (B-52 Kit)","2","2014-05-23 09:37:16","1300","5","Z3","2","2014-05-23 12:03:51","2","2014-05-23 14:20:31","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3143","41","0","832751","2014-05-22","1","0","2014-05-23","10","","1","","","2","2014-05-23 10:17:19","","3","","2","2014-05-23 10:38:06","2","2014-05-23 10:38:14","2","2014-05-23 10:41:12","2","142688","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3144","11","0","102132","2014-05-22","0","0","2014-06-02","10","","1","","Zollner Electronics VytronUS 1805077-00/5092707-00","2","2014-05-29 06:59:29","871","4","Z2","2","2014-05-29 08:44:24","2","2014-05-29 12:18:19","2","2014-06-03 11:49:58","0","","2","65","2014-06-03 10:04:08","2","1");
INSERT INTO tbl_jobs VALUES("3145","11","0","102133","2014-05-22","0","0","2014-06-02","10","","1","","Zollner Electronics VytronUS 1805077-00/5092708-00","2","2014-05-29 06:59:55","209","5","Z2","2","2014-05-29 08:53:13","2","2014-05-29 12:18:46","2","2014-06-03 11:50:04","0","","2","67","2014-06-03 10:05:12","2","1");
INSERT INTO tbl_jobs VALUES("3146","22","0","3474305","2014-05-22","0","0","2014-05-27","17","","8","","","2","2014-05-27 10:53:50","37","6","Foil Only","2","2014-05-27 11:21:44","2","2014-05-27 11:31:02","0","0000-00-00 00:00:00","2","142707","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3147","2","0","5346924","2014-05-22","0","0","2014-05-23","17","","1","","Sanmina Ruckus 120-11266-001 Rev-03","2","2014-05-23 07:18:59","4010","4","Z2","2","2014-05-23 10:44:41","2","2014-05-23 13:58:55","0","0000-00-00 00:00:00","0","","2","55","2014-05-23 14:52:20","2","1");
INSERT INTO tbl_jobs VALUES("3148","9","0","2814072","2014-05-22","0","0","2014-05-23","17","","1","","Sanmina - SCI, Corp. RDC  Assy 131-0725 PCB 132-0725 rev 1","2","2014-05-23 14:32:07","7093","4","Z2","2","2014-05-23 16:03:17","2","2014-05-23 18:05:34","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3149","9","0","2814073","2014-05-22","0","0","2014-05-23","17","","1","","Sanmina - SCI, Corp. RDC Assy 131-0725 PCB 132-0725 rev 1","2","2014-05-23 14:32:32","3659","4","Z2","2","2014-05-23 15:16:50","2","2014-05-23 18:05:43","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3150","4","0","321869","2014-05-22","0","0","2014-05-27","16","","1","","Flextronics Intel Fab H32014-002","2","2014-05-27 12:09:20","4252","3","Z2","2","2014-05-27 16:11:53","2","2014-05-27 18:38:48","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3151","4","0","321865","2014-05-22","0","0","2014-06-02","17","","1","","","2","2014-05-22 18:58:10","","3","Mini stencil","2","2014-05-23 09:33:28","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3152","36","0","6911936","2014-05-22","0","0","2014-05-23","18","","1","","FOXCONN Brocade 30-1000963-01 Top and Bottom","2","2014-05-23 09:36:49","384","5","Z2","2","2014-05-23 11:07:43","2","2014-05-23 14:08:27","0","0000-00-00 00:00:00","2","142690","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3153","97","0","4792386","2014-05-22","0","0","2014-05-27","8","","1","","Surface Art PARC DTRA3_Debug Board V.1Rev3 J","2","2014-05-23 06:48:29","430","5","18X18","2","2014-05-23 10:06:37","2","2014-05-23 13:34:45","0","0000-00-00 00:00:00","2","142685","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3154","97","0","4792387","2014-05-22","0","0","2014-05-26","8","","1","","Surface Art PARC DTRA3_Digital Board Rev 1 J","2","2014-05-23 12:48:24","5167","4","18X18","2","2014-05-23 14:50:21","2","2014-05-23 16:03:55","2","2014-05-27 08:06:41","2","142693","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3155","97","0","4792388","2014-05-22","0","0","2014-05-26","8","","1","","Surface Art PARC DTRA3_Digital Board Rev 1 J","2","2014-05-23 12:48:56","1256","4","18X18","2","2014-05-23 14:21:51","2","2014-05-23 15:55:29","2","2014-05-27 08:06:55","2","142693","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3156","7","0","9991965","2014-05-23","0","0","2014-05-27","17","","1","","SEM HE Feinmetall GmbH 8VBMT256-016 C13577:B","1","2014-05-23 08:24:51","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3157","7","0","9991966","2014-05-23","0","0","2014-05-27","17","","1","","SEM HE Feinmetall GmbH 8VBMT256-016 C13577:B","1","2014-05-23 08:25:03","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3158","7","0","9991967","2014-05-23","0","0","2014-05-27","17","","1","","SEM HE Feinmetall GmbH 8VBUFLEX-188 C13588:A Apt count =","1","2014-05-23 09:38:55","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3159","7","0","9991968","2014-05-23","0","0","2014-05-27","17","","1","","SEM HE Feinmetall GmbH 8VBUFLEX-188 C13588:A Apt count =","2","2014-05-27 10:21:08","659","8","Foil Only","2","2014-05-27 11:41:43","2","2014-05-27 11:52:37","2","2014-05-27 12:35:14","2","142706","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3160","7","0","9991969","2014-05-23","1","0","2014-06-02","17","","1","","","2","2014-06-02 13:12:49","841","8","Z1","2","2014-06-02 14:34:27","2","2014-06-02 15:01:43","0","0000-00-00 00:00:00","2","142825","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3161","7","0","9991970","2014-05-23","1","0","2014-06-02","17","","1","","","2","2014-06-02 13:14:39","1069","8","Z1","2","2014-06-02 14:21:37","2","2014-06-02 15:01:50","0","0000-00-00 00:00:00","2","142825","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3162","7","0","9991971","2014-05-23","0","0","2014-05-28","17","","1","","","2","2014-05-28 14:11:36","1051","8","Z1","2","2014-05-28 17:45:30","2","2014-05-28 17:46:30","0","0000-00-00 00:00:00","2","142744","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3163","7","0","9991972","2014-05-23","0","0","2014-05-28","17","","1","","","2","2014-05-28 14:12:12","121","8","Z1","2","2014-05-28 15:47:51","2","2014-05-28 15:54:51","2","2014-05-28 15:55:51","2","142744","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3164","7","0","9991973","2014-05-23","0","0","2014-05-27","17","","1","","SEM HE Microprobe Inc. TTF0839A:A Apt count =","2","2014-05-30 14:31:45","3075","8","Z1","2","2014-05-30 17:55:42","2","2014-05-30 18:37:07","0","0000-00-00 00:00:00","2","142796","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3165","7","0","9991974","2014-05-23","0","0","2014-05-27","17","","1","","SEM HE Microprobe Inc. TTF0839A:A Apt count =","1","2014-05-26 20:46:20","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3166","7","0","9991975","2014-05-23","0","0","2014-05-27","17","","1","","SEM HE Feinmetall GmbH 8VBUFLEX-199 C13617:A Apt count =","1","2014-05-26 22:26:04","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3167","7","0","9991976","2014-05-23","0","0","2014-05-27","17","","1","","SEM HE Feinmetall GmbH 8VBUFLEX-199 C13617:A Apt count =","2","2014-05-27 12:40:23","331","8","Z1","2","2014-05-27 16:26:32","2","2014-05-27 16:53:01","0","0000-00-00 00:00:00","2","142711","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3168","7","0","9991977","2014-05-23","0","0","2014-05-27","17","","1","","SEM HE STM Catania (MTS GmbH) STIFPM01 x2 PC C13574:A Apt count =","2","2014-05-27 12:41:21","997","8","Z1","2","2014-05-27 16:43:52","2","2014-05-27 16:46:01","0","0000-00-00 00:00:00","2","142709","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3169","7","0","9991978","2014-05-23","0","0","2014-05-27","17","","1","","SEM HE STM Catania (MTS GmbH) STIFPM01 x2 PC C13574:A Apt count =","2","2014-05-27 12:44:27","163","8","Z1","2","2014-05-27 16:35:32","2","2014-05-27 16:45:10","0","0000-00-00 00:00:00","2","142709","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3170","7","0","9991979","2014-05-23","0","0","2014-05-27","17","","1","","SEM HE Intel Corp. VTD16093-001:1 Apt count =","2","2014-06-02 17:25:17","229","8","Z1","2","2014-06-02 21:28:52","2","2014-06-02 22:48:53","2","2014-06-03 07:53:40","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3171","7","0","9991980","2014-05-23","0","0","2014-05-27","17","","1","","SEM HE Intel Corp. VTD16093-001:1 Apt count =","2","2014-06-02 17:26:43","4142","6","Z1","2","2014-06-02 20:36:14","2","2014-06-02 21:15:00","2","2014-06-03 07:53:49","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3172","2","0","5346925","2014-05-23","1","0","2014-05-27","9","","1","","Sanmina Cupe  939-00226 and 939-00086","2","2014-05-27 07:05:08","313","4","Z2","2","2014-05-27 08:16:56","2","2014-05-27 10:04:54","2","2014-05-27 10:13:02","0","","2","56","2014-05-23 15:54:55","2","1");
INSERT INTO tbl_jobs VALUES("3173","9","0","2814075","2014-05-23","0","0","2014-05-27","10","","1","","Sanmina - SCI, Corp. RDC Assy 131-0728 PCB 132-0728 rev 2","2","2014-05-27 16:04:02","411","5","Z2","2","2014-05-27 18:22:06","2","2014-05-27 21:10:39","2","2014-05-28 07:49:01","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3174","9","0","2814076","2014-05-23","0","0","2014-05-27","10","","1","","","2","2014-05-27 16:04:42","713","4","Z2","2","2014-05-27 17:29:06","2","2014-05-27 20:46:57","2","2014-05-28 07:49:06","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3175","43","0","5413995","2014-05-23","0","0","2014-05-27","11","","1","","Infiniti Solutions InvenSense MSBB E","2","2014-05-23 18:04:28","1023","4","Z2","2","2014-05-23 19:13:08","2","2014-05-23 20:53:36","2","2014-05-27 08:07:45","2","142699","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3176","43","0","5413996","2014-05-23","0","0","2014-05-27","11","","1","","Infiniti Solutions InvenSense LPS331AP Rev A Job","2","2014-05-23 18:44:23","343","4","Z2","2","2014-05-23 18:56:28","2","2014-05-23 20:53:56","2","2014-05-27 08:07:57","2","142700","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3177","36","0","6911938","2014-05-23","1","0","2014-05-27","13","","1","","FOXCONN Brocade 30-1000953-01 Top and Bottom","2","2014-05-27 10:56:38","578","5","Z2","2","2014-05-27 12:48:32","2","2014-05-27 13:57:51","2","2014-05-27 15:02:57","2","142705","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3178","4","0","321T865","2014-05-23","0","0","2014-05-23","16","","1","","","2","2014-05-23 12:55:36","44","8","Mini stencil","2","2014-05-23 13:36:33","2","2014-05-23 14:33:40","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3179","97","0","4792389","2014-05-23","0","0","2014-05-27","9","","1","","","2","2014-05-27 15:02:07",".","","","2","2014-05-27 15:02:38","2","2014-05-27 16:49:24","0","0000-00-00 00:00:00","2","142719","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3180","11","0","102134","2014-05-23","1","0","2014-05-23","17","","1","","Zollner Electronics Tarana Wireless 1765179-01/5092719-00","2","2014-05-23 17:33:56","4953","4","Z2","2","2014-05-23 18:36:22","2","2014-05-23 19:23:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3181","11","0","102135","2014-05-23","1","0","2014-05-23","17","","1","","Zollner Electronics Tarana Wireless 1765179-01/5092720-00","2","2014-05-23 17:35:15","4499","5","Z2","2","2014-05-23 18:32:50","2","2014-05-23 19:23:10","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3182","93","0","2532157","2014-05-23","1","0","2014-05-27","9","","1","","SMTC Traxon TEC01H10060200","2","2014-05-23 15:57:18","328","6","Z2","2","2014-05-23 16:35:57","2","2014-05-23 21:31:03","2","2014-05-30 11:10:00","2","142727","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3183","4","0","321855F","2014-05-23","0","0","2014-05-27","14","","1","","","2","2014-05-28 10:00:04",".","","","2","2014-05-28 10:00:13","2","2014-05-28 10:14:14","2","2014-05-28 10:14:25","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3184","8","0","575448","2014-05-23","0","0","2014-05-27","15","","1","","Jabil Agilent ST-U9320-668124-PB-T U9320-20124 Rev A140513","2","2014-05-29 11:28:10","1902","5","Z2","2","2014-05-29 15:50:18","2","2014-05-29 17:47:51","2","2014-05-30 07:43:47","2","142769","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3185","8","0","575449","2014-05-23","0","0","2014-05-27","15","","1","","Jabil Agilent ST-U9320-668124-PB-B U9320-20124 Rev A140513","2","2014-05-29 11:27:41","986","5","Z2","2","2014-05-29 15:37:30","2","2014-05-29 17:47:57","2","2014-05-30 07:43:53","2","142769","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3186","8","0","575450","2014-05-23","0","0","2014-05-27","15","","1","","Jabil Agilent ST-U9320-68126-PA-T U9320-201126 Rev A140304","2","2014-05-29 09:25:50","4869","5","Z2","2","2014-05-29 12:47:46","2","2014-05-29 14:52:24","0","0000-00-00 00:00:00","2","142762","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3187","8","0","575451","2014-05-23","0","0","2014-05-27","15","","1","","Jabil Agilent ST-U9320-68126-PA-B U9320-201126 Rev A140304","2","2014-05-29 09:24:56","3234","5","Z2","2","2014-05-29 12:04:59","2","2014-05-29 14:36:08","0","0000-00-00 00:00:00","2","142762","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3188","36","0","6911939","2014-05-23","0","0","2014-05-27","16","","1","","FOXCONN Brocade 30-1000996-01 Top Paste","2","2014-05-28 17:39:14","2883","5","Z2","2","2014-05-28 20:47:44","2","2014-05-28 21:43:21","2","2014-05-29 08:03:28","2","142748","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3189","36","0","6911940","2014-05-23","0","0","2014-05-27","16","","1","","FOXCONN Brocade 30-1000996-01 Bottom Paste","2","2014-05-28 17:39:37","3945","5","Z2","2","2014-05-28 20:26:26","2","2014-05-28 21:43:31","2","2014-05-29 08:03:39","2","142748","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3190","97","0","4792391","2014-05-23","0","0","2014-05-27","16","","1","","","2","2014-05-27 10:20:27","2730","6","Foil Only","2","2014-05-27 16:13:19","2","2014-05-27 16:20:48","0","0000-00-00 00:00:00","2","142710","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3191","5","0","4894527","2014-05-23","0","0","2014-05-27","15","","1","","OnCore Manufacturing Mynosys 69601-10000-12 REV A RoHS","2","2014-05-27 14:50:11","1513","5","Z2","2","2014-05-27 18:00:26","2","2014-05-27 20:53:52","2","2014-05-28 07:48:53","2","142720","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3192","20","0","938687","2014-05-23","0","0","2014-05-27","17","","15","","Ascentron Micro Interconnects 679-6276-02 P/N 790-2537","2","2014-05-27 07:11:17","428","4","18X18","2","2014-05-27 09:01:23","2","2014-05-27 11:43:25","0","0000-00-00 00:00:00","2","142703","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3193","93","0","2532137F.","2014-05-23","0","0","2014-05-27","15","","1","","","2","2014-05-27 11:47:11","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","2","2014-05-27 14:59:42","0","","2","59","2014-05-27 11:58:15","2","1");
INSERT INTO tbl_jobs VALUES("3194","51","0","9931445","2014-05-23","0","0","2014-05-27","17","","1","","Javad Google GO-90-1014 Rev 1.0.0","2","2014-05-27 09:01:09","2760","5","18X19","2","2014-05-27 12:10:40","2","2014-05-27 13:55:27","2","2014-05-27 15:00:27","0","","2","57","2014-05-27 10:19:28","2","1");
INSERT INTO tbl_jobs VALUES("3195","51","0","9931446","2014-05-23","0","0","2014-05-27","17","","1","","Javad Google GO-90-1014 Rev 1.0.0","2","2014-05-27 09:01:46","1933","5","18X19","2","2014-05-27 12:05:12","2","2014-05-27 13:55:41","2","2014-05-27 15:01:41","0","","2","58","2014-05-27 10:19:44","2","1");
INSERT INTO tbl_jobs VALUES("3196","74","0","152011","2014-05-23","0","0","2014-05-27","9","","1","","","2","2014-05-23 18:14:47","1566","5","Z2","2","2014-05-23 20:07:04","2","2014-05-23 21:27:24","2","2014-05-27 08:07:23","2","142698","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3197","74","0","152012","2014-05-23","0","0","2014-05-27","9","","1","","","2","2014-05-23 18:15:10","503","5","Z2","2","2014-05-23 19:42:54","2","2014-05-23 21:27:32","2","2014-05-27 08:07:33","2","142698","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3198","36","0","6911941","2014-05-26","0","0","2014-05-27","8","","1","","FOXCONN Brocade 30-1001068-01 Top and Bottom","2","2014-05-28 17:40:06","4080","5","Z2","2","2014-05-28 20:17:42","2","2014-05-28 21:43:42","2","2014-05-29 08:03:46","2","142749","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3199","36","0","6911942","2014-05-26","0","0","2014-05-27","18","","1","","FOXCONN Brocade 30-1000997-01 Top Paste","2","2014-05-28 11:15:12","9277","5/4","Z2 step","2","2014-05-28 19:57:52","2","2014-05-28 21:43:48","2","2014-05-29 08:03:56","2","142737","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3200","36","0","6911943","2014-05-26","0","0","2014-05-28","16","","1","","FOXCONN Brocade 30-1000997-01 Bottom Paste","2","2014-05-28 11:14:00","4707","5","Z2","2","2014-05-28 13:17:50","2","2014-05-28 15:09:34","0","0000-00-00 00:00:00","2","142736","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3201","70","0","1105160","2014-05-26","0","0","2014-05-27","15","","1","","Oncore TLTC 1002749-01LF@6 TOP SIDE","2","2014-05-27 11:05:52","1909","4","Z2","2","2014-05-27 15:36:23","2","2014-05-27 18:24:49","2","2014-05-28 13:56:01","2","142738","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3202","70","0","1105161","2014-05-26","0","0","2014-05-27","15","","1","","Oncore TLTC 1002749-01LF@6 BOTTOM SIDE","2","2014-05-27 11:05:04","3899","4","Z2","2","2014-05-27 13:05:35","2","2014-05-27 18:18:43","2","2014-05-28 13:56:12","2","142738","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3203","70","0","1105162","2014-05-26","0","0","2014-05-27","15","","1","","Oncore TLTC 1002752-01@6 TOP SIDE","2","2014-05-27 11:04:20","2269","5","Z2","2","2014-05-27 15:09:04","2","2014-05-27 18:18:37","2","2014-05-29 08:06:29","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3204","70","0","1105163","2014-05-26","0","0","2014-05-27","15","","1","","Oncore TLTC 1002752-01@6 BOTTOM SIDE","2","2014-05-27 11:03:50","1294","5","Z2","2","2014-05-27 16:01:29","2","2014-05-27 20:49:32","2","2014-05-29 08:06:36","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3205","4","0","321871","2014-05-26","0","0","2014-05-28","8","","1","","Flextronics Agilent  AGI-G4595-61810","2","2014-05-27 07:05:58","776","5","Z2","2","2014-05-27 09:36:38","2","2014-05-27 12:12:16","2","2014-05-27 12:35:57","0","","2","60","2014-05-27 13:23:36","2","1");
INSERT INTO tbl_jobs VALUES("3206","72","0","1262802","2014-05-26","0","0","2014-05-27","18","","1","","Pactron Incorporated PAC3086_26May2014_ WO24925_T","2","2014-05-27 07:10:52","3692","4","Z2","2","2014-05-27 09:48:37","2","2014-05-27 12:07:02","2","2014-05-27 12:35:35","2","142702","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3207","35","0","800226","2014-05-27","1","0","2014-05-27","16","","1","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3208","43","0","5413997","2014-05-27","0","0","2014-05-28","8","","1","","Infiniti Solutions Job","2","2014-05-27 16:50:33","1888","8","Fuji4000","2","2014-05-27 18:58:55","2","2014-05-27 20:38:36","2","2014-05-28 07:48:42","2","142715","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3209","11","0","102136","2014-05-27","0","0","2014-05-28","10","","1","","Zollner Electronics Sandisk 1803113-00 5092270-00 - Top","2","2014-05-28 09:01:56","2163","4","Z2","2","2014-05-28 09:54:08","2","2014-05-28 12:38:02","0","0000-00-00 00:00:00","2","142745","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3210","19","0","835281","2014-05-27","0","0","2014-05-28","17","","15","","Applied Technologies 070-509880-001 B0","2","2014-05-28 08:02:57","2717","6","Z2","2","2014-05-28 11:30:36","2","2014-05-28 12:53:23","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3211","19","0","835282","2014-05-27","0","0","2014-05-28","17","","15","","Applied Technologies  070-509880-001 B0","2","2014-05-28 08:03:31","611","6","Z2","2","2014-05-28 10:14:54","2","2014-05-28 12:53:58","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3212","1","0","8292608","2014-05-27","0","0","2014-05-28","11","","1","","Foxconn iDSBG IDSBG 920-00289-01","2","2014-05-27 20:39:45","1064","4","Z2","2","2014-05-28 09:41:29","2","2014-05-28 11:03:00","2","2014-05-28 11:48:23","2","142725","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3213","51","0","9931433F","2014-05-27","0","0","2014-05-28","11","","1","","Javad Javad 05-577001-01 Rev. 4.1","2","2014-05-27 22:21:42","","4","","2","2014-05-28 08:49:10","2","2014-05-28 08:52:15","2","2014-05-28 10:14:48","0","","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3214","99","0","148086","2014-05-27","0","0","2014-05-28","11","","1","","SV Probe  STN-000030-01","2","2014-05-27 22:43:12","","","Reball","2","2014-05-28 08:50:02","2","2014-05-28 11:39:05","2","2014-05-28 12:51:36","2","142723","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3215","7","0","9991981","2014-05-27","0","0","2014-06-02","17","","1","","SEM HE NXP SEMICOND. GERMANY GMB L3117_IP_MODULE1 C13603:A","2","2014-06-02 09:59:43","1808","8","Z1","2","2014-06-02 18:32:24","2","2014-06-02 19:32:22","2","2014-06-03 07:52:50","2","142821","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3216","7","0","9991982","2014-05-27","0","0","2014-05-28","17","","1","","SEM HE NXP SEMICOND. GERMANY GMB L3117_IP_MODULE1 C13603:A","1","2014-05-27 22:09:49","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3217","40","0","807082","2014-05-27","0","0","2014-05-28","16","","7","","","0","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3218","7","0","9991985","2014-05-27","0","0","2014-06-02","17","","1","","SEM HE NXP SEMICOND. GERMANY GMB L3119_OP_MODULE1 C13604:A","2","2014-06-02 10:00:41","2168","8","Z1","2","2014-06-02 11:44:42","2","2014-06-02 12:02:08","2","2014-06-02 13:46:14","2","142808","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3219","7","0","9991986","2014-05-27","0","0","2014-05-28","17","","1","","SEM HE NXP SEMICOND. GERMANY GMB L3119_OP_MODULE1 C13604:A","1","2014-05-28 00:29:13","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3220","7","0","9991983","2014-05-27","0","0","2014-06-02","17","","1","","SEM HE NXP SEMICOND. GERMANY GMB L3118_IP_MODULE2 C13602:A","2","2014-06-02 10:01:03","3968","8","Z1","2","2014-06-02 21:50:49","2","2014-06-02 22:49:19","2","2014-06-03 07:53:05","2","142819","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3221","7","0","9991984","2014-05-27","0","0","2014-05-28","17","","1","","SEM HE NXP SEMICOND. GERMANY GMB L3118_IP_MODULE2 C13602:A","1","2014-05-28 00:17:59","","","","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","0000-00-00 00:00:00","0","","0","0","0000-00-00 00:00:00","0","-1");
INSERT INTO tbl_jobs VALUES("3222","7","0","9991987","2014-05-27","0","0","2014-05-28","17","","1","","SEM HE NXP SEMICOND. GERMANY GMB L3108_LITHIOPD8XFTC13605A","2","2014-05-28 08:58:40","423","8","Foil Only","2","2014-05-28 13:26:35","2","2014-05-28 13:51:03","2","2014-05-28 13:51:33","2","142732","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3223","7","0","9991988","2014-05-27","0","0","2014-05-28","17","","1","","SEM HE NXP SEMICOND. GERMANY GMB L3108_LITHIOPD8XFTC13605A","2","2014-05-28 08:59:26","2143","8","Foil Only","2","2014-05-28 11:49:04","2","2014-05-28 12:10:02","2","2014-05-28 13:52:14","2","142732","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3224","7","0","9991989","2014-05-27","0","0","2014-05-28","17","","1","","SEM HE Microprobe Inc. TTF0821A:A","2","2014-05-30 09:30:29","3831","8","Z1","2","2014-05-30 10:47:48","2","2014-05-30 11:09:07","2","2014-05-30 11:54:26","2","142779","0","0","0000-00-00 00:00:00","2","1");
INSERT INTO tbl_jobs VALUES("3225","7","0","9991990","2014-05-27","0","0","201