<html>
<head>
    <title>Beamon</title>
    <style type="text/css">
        @import "http://fonts.googleapis.com/css?family=Open+Sans+Condensed:300,700|Open+Sans:400,300,600";
        * {
            box-sizing: border-box;
        }
        body {
            background: #fff none repeat scroll 0 0;
            font-family: arial;
            font-size: 14px;
            margin: 0;
            padding: 0;
        }
        .log-form {
            background: #eeeeee none repeat scroll 0 0;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.25);
            left: 50%;
            max-width: 360px;
            min-width: 320px;
            position: absolute;
            top: 50%;
            transform: translate(-50%, -50%);
            width: 40%;
        }
        @media (max-width: 40em) {
            .log-form {
                left: 0;
                margin: 2.5% auto 0;
                position: relative;
                transform: translate(0%, 0%);
                width: 95%;
            }
        }
        .log-form form {
            display: block;
            margin: 0;
            padding: 0;
            width: 100%;
        }
        .log-form h2 {
            color: #2dcc70;
            display: block;
            font-family: arial;
            font-size: 35px;
            font-weight: bold;
            margin: 0;
            padding: 10px 13px;
            text-align: center;
            text-transform: uppercase;
            width: 100%;
        }
.log-form input {
    border: 1px solid #c0c0c0;
    color: #757575;
    display: block;
    font-size: 14px;
    font-weight: bold;
    margin: auto auto 1em;
    padding: 15px 0;
    text-align: center;
    width: 100%;
}
.log-form input.error {
  
        margin-bottom: 10px;
}
label.error {
    display: block;
    margin-bottom: 10px;
}
        .log-form input:focus {
            outline: medium none;
        }
        .log-form .btn {
            background: #2dcc70 none repeat scroll 0 0;
            border: 1px solid #2dcc70;
            box-shadow: 0 1px 0 rgba(255, 255, 255, 0.2) inset;
            color: white;
            display: inline-block;
            margin-right: 0.5em;
            font-size: 18px;
            cursor: pointer;
            padding: 15px 0;
            width: 100%;
        }
        .log-form .btn:hover {
            background: #55f096 none repeat scroll 0 0;
        }
        .log-form .btn:active {
            background: #1fb5bf none repeat scroll 0 0;
            box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1) inset;
        }
        .log-form .btn:focus {
            outline: medium none;
        }
        header h1 {
            color: #5d5757;
            font-weight: bold;
            padding: 8px 0;
            text-align: center;
                margin: 15px 0;
        }
        .log-form .forgot {
            color: #33d3de;
            float: right;
            font-size: 0.75em;
            line-height: 0.5em;
            margin: 0;
            padding: 0;
            position: relative;
            text-decoration: none;
            top: 2.5em;
        }
        .log-form .forgot:hover {
            color: #1ba0a9;
        }
        .input_types{  padding: 0 40px;}
        .error{
            color: red;
            font-size: 14px;
            font-weight: 600;
            
        }
        .login_message {
    font-size: 14px;
    text-align: center;
    padding: 0;
    font-weight: 700;
    margin: 0 0 10px 0;
}

    </style>
</head>
<body>
    <header>
        <div class="container">
            <h1>Beam On Shop Floor Control System</h1>
        </div>
    </header>
    <section>
        <div class="log-form">
            <h2>SFCS Login</h2>
            <?php if(isset($message)){ ?><h6 class="login_message" style="color:red; text-transform: capitalize;"><?php echo $message; ?></h6><?php } ?>
            <form name="login" id="login" method="post" action="<?php echo site_url('welcome/login'); ?>">
                <div class="input_types">
                    <input type="text" name="login_username" id="login_username" placeholder="Username" />
                    <input type="password" name="login_password" id="login_passwoord" placeholder="Password" />
                </div>
                <button type="submit" class="btn">Submit</button>
                <!--<a class="forgot" href="#">Forgot Username?</a> -->
            </form>
        </div><!--end log form -->
    </section>
    <footer>
    </footer>
</body>
    <script type="text/javascript" src="<?php echo base_url("assets/js/jquery.js");?>"></script>
    <script type="text/javascript" src="<?php echo base_url("assets/js/jquery.validate.js");?>"></script>
    <script type="text/javascript">
        $(document).ready(function(){
            $("#login").validate({
                rules: {
                  login_username: "required",
                  login_password: "required"
                },
                messages: {
                  login_username: "Please Enter Username",
                  login_password: "Please Enter Password"
                }  
            });
        });
    </script>
</html>