<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Dashboard extends CI_Controller {
    public $data = array();
    public function __construct() {
            parent::__construct();
            //date_default_timezone_set('Asia/Kolkata');
            
            date_default_timezone_set('Asia/Kolkata');
            //date_default_timezone_set('America/Los_Angeles');
            $this->load->model('dashboard_model');
            $this->load->model('mobile_model','mobile');
            $this->load->helper('common_helper');
            $this->load->library('session');
    }
    public function index(){
            if(! $this->session->userdata('user_id')){
                redirect('welcome');
            }else{
                header('Access-Control-Allow-Origin: *');
		$this->load->view('dashboard');
            }
    }
    /**
    **************************** WARNING ****************************
    *   This function controlls over all dashboard timeline
    *   Don't try to change it
    *   Untill u know how it works
    *   Written By KRISHNAMK
    **************************** WARNING ****************************
    **/
    public function dashboard(){
     
        header('Access-Control-Allow-Origin: *');
        // date based dashboard jobs display start
        $todaydate = date('Y-m-d',strtotime($this->input->post('date')));
        $previousday = date('Y-m-d',strtotime($todaydate.' -1 day'));
        $nextday = date('Y-m-d',strtotime($todaydate.' +1 day'));
        $data['days']= array(array('day'=>$todaydate));
        // date based dashboard jobs display ends
        // three days based dashboard jobs display starts
            /*$todaydate=date('Y-m-d');
            $tomorrowdate=date('Y-m-d', strtotime(' +1 day'));
            $dayaftertomorrow=date('Y-m-d', strtotime(' +2 day'));
            $data['days']= array(array('day'=>$todaydate),array('day'=>$tomorrowdate),array('day'=>$dayaftertomorrow));*/
        // three days based dashboard jobs display starts
        // Maximum available shifts starts
            //$data['shifts']= array(array('shift'=>1,'timing'=>"test"),array('shift'=>2,'timing'=>"test"),array('shift'=>3,'timing'=>"test"));
            //echo "<pre>";print_r($data['shifts']);exit;
        // Maximum available shifts ends
        foreach ($data['days'] as $daykey => $day) {
            // if you want to process day based of shift then use below line
            $data['shifts'] = $this->shift_and_timings($day['day']);
                //$data['shifts']= $this->dashboard_model->get_shifts($day['day']);
            foreach ($data['shifts'] as $shiftkey => $shift) {

                if( ($shift['shift_end'] <= DEFAULT_SHIFT_START_TIME ) ){
                    $shift['shift_end'] = date('Y-m-d', strtotime($day['day'].' +1 day')).' '.$shift['shift_end'];
                }else{
                    $shift['shift_end'] = $day['day'].' '.$shift['shift_end'];
                }
                
                if(($shift['shift_start'] < DEFAULT_SHIFT_START_TIME )){
                    $shift['shift_start'] = date('Y-m-d', strtotime($day['day'].' +1 day')).' '.$shift['shift_start'];
                }else{
                    $shift['shift_start'] = $day['day'].' '.$shift['shift_start'];
                }
                $dashboard['shifts'][$shiftkey]['shift_start'] = $shift['shift_start'];
                $dashboard['shifts'][$shiftkey]['shift_end'] = $shift['shift_end'];
 
                // echo "<pre>";print_r($shift['shift_start'].'<br/>'.$shift['shift_end']);exit;
                // getting all machines from database
                $dashboard['machine'] = $this->dashboard_model->get_machine();
                // if you want to test single machine or two machines use below
                //$dashboard['machine'] =array(array('machine' =>'CNC-4','id'=>15 ));
                // machine based job retrieve starts
            
                foreach ($dashboard['machine'] as $id => $machine) {
                    // getting jobs based on date and shift and machine
                    $data['jobs'] = $this->dashboard_model->get_downtime($day['day'],$machine['id'],$shift['shift']);
                    // checking job exist on this day or not , if job available calculations starts else idle inserted on that day
                    if(count($data['jobs']) > 0){
                        foreach ($data['jobs'] as $jobkey => $job) {
                             $wims_tot_hrs = $this->dashboard_model->get_wims_hrs($job['job_code']);
                             
                             if($wims_tot_hrs){
                                $setup_time_hr = ($wims_tot_hrs['setup_time_hr'] * 60);
                                $setup_time_min = $wims_tot_hrs['setup_time_min'];
                                $setup_interval = $setup_time_hr + $setup_time_min;

                             }else{
                                 $setup_interval = 0;
                             }
                                
                            if($day['day']==$job['date_from']){
                                // Check from date amd job day same time calculations
                                $datetime1 = new DateTime($job['date_from'].' '.$job['time_from']);
                                $datetime2 = new DateTime($job['date_to'].' '.$job['time_to']);
                                $interval = $datetime1->diff($datetime2);
                                //print_r($interval);exit;
                                $to_time = $job['date_to'].' '.$job['time_to'];
                                //$job_end = $job['date_from'].' 20:00:00'; //old
                                $job_end = $shift['shift_end'];
                                if( $to_time > $job_end){
                                    $to_time = $job_end;
                                }
                                $to_time = strtotime($to_time);
                                $from_time = strtotime($job['date_from'].' '.$job['time_from']);
                                $interval=round(abs($to_time - $from_time) / 60,2);
                                $data['jobs'][$jobkey]['setup_interval'] = (0.1*$setup_interval);
                                $data['jobs'][$jobkey]['time_taken']=$interval;
                                $data['jobs'][$jobkey]['percent']=(0.1*$data['jobs'][$jobkey]['time_taken']);
                                 $data['jobs'][$jobkey]['sin_percent']=(0.1*$data['jobs'][$jobkey]['time_taken']);
                                ///if($setup_interval>0){
                                    //$data['jobs'][$jobkey]['percent']=($data['jobs'][$jobkey]['percent']+$data['jobs'][$jobkey]['setup_interval']);
                                //}else{
                                    $data['jobs'][$jobkey]['percent']=(0.1*$data['jobs'][$jobkey]['time_taken']);                                    
                                //}
                                $data['jobs'][$jobkey]['total_percent']=($data['jobs'][$jobkey]['percent']);
                                $data['jobs'][$jobkey]['time_from'] = $job['time_from'];
                                $data['jobs'][$jobkey]['time_to'] = $job['time_to'];
                                // Check to date and time greater than job day 08:00 PM then change time to job day 08:00 PM
                                if($job['date_to'].' '.$job['time_from'] > $shift['shift_end'] ){
                                    $data['jobs'][$jobkey]['date_to'] = $day['day'];
                                    $data['jobs'][$jobkey]['time_to'] = $shift['shift_end'];
                                }
                            }else{
                                // Check from date and time less than job day 08:00 AM then change time to job day 08:00 AM for time calculations
                                if($job['date_from'].' '.$job['time_from'] < $shift['shift_start'] ){
                                    $datetime1 = new DateTime($shift['shift_start']);
                                    $from_time = strtotime($shift['shift_start']);
                                }else{
                                    $datetime1 = new DateTime($job['date_to'].' '.$job['time_from']);
                                    $from_time = strtotime($job['date_from'].' '.$job['time_from']);
                                }
                                $datetime2 = new DateTime($job['date_to'].' '.$job['time_to']);
                                $interval = $datetime1->diff($datetime2);
                                $to_time = $job['date_to'].' '.$job['time_to'];
                                $job_end = $shift['shift_end'];
                                if( $to_time > $job_end){
                                    $to_time = $job_end;
                                }
                                $to_time = strtotime($to_time);
                                $interval=round(abs($to_time - $from_time) / 60,2);
                                $data['jobs'][$jobkey]['setup_interval'] = (0.1*$setup_interval);
                                $data['jobs'][$jobkey]['time_taken']=$interval;
                                $data['jobs'][$jobkey]['percent']=(0.1*$data['jobs'][$jobkey]['time_taken']); 
                                $data['jobs'][$jobkey]['sin_percent']=(0.1*$data['jobs'][$jobkey]['time_taken']);   
                                 //if($setup_interval>0){
                                 //   $data['jobs'][$jobkey]['percent']=($data['jobs'][$jobkey]['percent']+$data['jobs'][$jobkey]['setup_interval']);
                                //}else{
                                    $data['jobs'][$jobkey]['percent']=(0.1*$data['jobs'][$jobkey]['time_taken']);                                    
                                //}                               
                                $data['jobs'][$jobkey]['total_percent']=($data['jobs'][$jobkey]['percent']);
                                
                                $data['jobs'][$jobkey]['time_from'] = $job['time_from'];
                                $data['jobs'][$jobkey]['time_to'] = $job['time_to'];
                                // Check from date and time less than job day 08:00 AM then change time to job day 08:00 AM
                                if($job['date_from'].' '.$job['time_from'] < $shift['shift_start'] ){
                                    $data['jobs'][$jobkey]['date_from'] = $day['day'];
                                    $data['jobs'][$jobkey]['time_from'] = $shift['shift_start'];
                                }
                            }
                        }
                        // sort all jobs based on starting time start
                        // sortBytime_from function written in common_helper
                        usort($data['jobs'], 'sortBytime_from');
                       
                        // sort all jobs based on starting time ends
                        $job_count=count($data['jobs']); // getting job count
                        foreach ($data['jobs'] as $jobkey => $job) {
                            // idle time generation based on job position
                            if($jobkey==0){
                                // if job is first job on that day
                                if($job['date_from']==$day['day']){
                                    if($job['time_from'] != $shift['shift_start']){
                                        $keyval=count($data['jobs'])+1;
                                        $to_time = strtotime($job['date_from'].' '.$job['time_from']);
                                        $from_time = strtotime($shift['shift_start']);
                                        $interval=round(abs($to_time - $from_time) / 60,2);
                                        $data['jobs'][$keyval]['id']= 0;
                                        $data['jobs'][$keyval]['time_from']=$shift['shift_start'];
                                        $data['jobs'][$keyval]['time_to']=$job['time_from'];
                                        $data['jobs'][$keyval]['class']="darkyellow disabled ";
                                        $data['jobs'][$keyval]['time_taken']=$interval;
                                        $data['jobs'][$keyval]['percent']=(0.1*$data['jobs'][$keyval]['time_taken']);
                                        $data['jobs'][$keyval]['job_code']='idle1';
                                    }
                                }
                            }if($jobkey == $job_count-1){
                                // if job is last job of the day then this will run
                                if(($shift['shift_end']) > ($job['date_to'].' '.$job['time_to'])){
                                //if(($day['day'].' '.$job['time_to'] < date('Y-m-d H:i:s'))&&(date('Y-m-d H:i:s') <= $day['day'].' 20:00:00')){
                                    if(($job['date_to'].' '.$job['time_to'] < date('Y-m-d H:i:s'))&&($job['date_to'].' '.$job['time_to'] < $shift['shift_end'])){
                                        $keyval=count($data['jobs'])+1;
                                        if($day['day'] < date('Y-m-d')){ 
                                            $to_time = strtotime($shift['shift_end']); 
                                            //echo "<pre>";print_r($shift['shift_end']);exit;
                                        }else{ 
                                        	if(date('Y-m-d H:i:s') > date('Y-m-d H:i:s',strtotime($shift['shift_end']))){	 
                                        		$to_time = strtotime($shift['shift_end']);
                                       		}else{
                                       			if(date('Y-m-d H:i:s') < date('Y-m-d H:i:s',strtotime($shift['shift_end']))){
                                       				$to_time = strtotime($job['date_to'].' '.date('H:i:s'));
                                       			}else{
                                       				$to_time = strtotime($shift['shift_end']);
                                       			}
                                        		
                                        	}
                                        }
		                            /*if(date('Y-m-d H:i:s') > $shift['shift_end']){
		                                $from_time = strtotime($shift['shift_end']); 
		                            }else{
		                                $from_time = strtotime(date('Y-m-d H:i:s')); 
		                            }*/
		                            
                                        //$to_time = strtotime($job['date_to'].' '.$shift['shift_end']);
                                        //$from_time = strtotime($job['date_from'].' '.$job['time_to']);
                                        $from_time = strtotime($job['date_to'].' '.$job['time_to']);
                                        $interval=round(abs($to_time - $from_time) / 60,2);
                                        $data['jobs'][$keyval]['id']= 0;
                                        $data['jobs'][$keyval]['time_from']=$job['time_to'];
                                        $data['jobs'][$keyval]['time_to']=$shift['shift_end'];
                                        $data['jobs'][$keyval]['class']="darkyellow disabled ";
                                        $data['jobs'][$keyval]['time_taken']=$interval;
                                        $data['jobs'][$keyval]['percent']=(0.1*$data['jobs'][$keyval]['time_taken']);
                                        $data['jobs'][$keyval]['job_code']='idle2';
                                        
                                    }
                                }
                            }
                            if(((count($data['jobs'])-1) != $jobkey) && ($jobkey != 0) ){
                                                                 
                                // if job is not a first job on that day or last day of the job this will run
                                $keyval=count($data['jobs'])+1;
                                $oldjob=$jobkey-1;
                                $to_time = strtotime($job['date_from'].' '.$data['jobs'][$jobkey]['time_from']);
                                $from_time = strtotime($job['date_to'].' '.$data['jobs'][$oldjob]['time_to']);
                                $interval=round(abs($to_time - $from_time ) / 60,2);
                                $data['jobs'][$keyval]['id']= 0;
                                $data['jobs'][$keyval]['time_from']=$data['jobs'][$jobkey-1]['time_to'];
                                $data['jobs'][$keyval]['time_to']=$data['jobs'][$jobkey]['time_from'];
                                $data['jobs'][$keyval]['class']="darkyellow disabled ";
                                $data['jobs'][$keyval]['time_taken']=$interval;
                                $data['jobs'][$keyval]['percent']=(0.1*$data['jobs'][$keyval]['time_taken']);
                                $data['jobs'][$keyval]['job_code']='idle3';
                            }
                            // for job after mcdown 31/01/2018
                            if(((count($data['jobs'])-1) == $jobkey) && ($jobkey != 0) ){
                                $keyval=count($data['jobs'])+1;
                                $oldjob=$jobkey-1;
                                $to_time = strtotime($job['date_from'].' '.$data['jobs'][$jobkey]['time_from']);
                                $from_time = strtotime($job['date_to'].' '.$data['jobs'][$oldjob]['time_to']);
                                $interval=round(abs($to_time - $from_time ) / 60,2);
                                $data['jobs'][$keyval]['id']= 0;
                                $data['jobs'][$keyval]['time_from']=$data['jobs'][$jobkey-1]['time_to'];
                                $data['jobs'][$keyval]['time_to']=$data['jobs'][$jobkey]['time_from'];
                                $data['jobs'][$keyval]['class']="darkyellow disabled ";
                                $data['jobs'][$keyval]['time_taken']=$interval;
                                $data['jobs'][$keyval]['percent']=(0.1*$data['jobs'][$keyval]['time_taken']);
                                $data['jobs'][$keyval]['job_code']='idle4';
                           }

                        }
                        // sort all jobs based on starting time start
                        // sortBytime_from function written in common_helper
                        usort($data['jobs'], 'sortBytime_from');
                        // sort all jobs based on starting time ends
                    }else{
                        if($day['day'] == date('Y-m-d')){
                            
                            if(date('Y-m-d H:i:s') < $shift['shift_start']){ 
                                $from_time = strtotime($shift['shift_start']);
                                $to_time = strtotime($shift['shift_start']);
                            }else{
                                if(date('Y-m-d H:i:s') < $shift['shift_end']){
                                    $from_time = strtotime(date('Y-m-d H:i:s'));
                                }else{
                                    $from_time = strtotime($shift['shift_end']);
                                }
                                $to_time = strtotime($shift['shift_start']);
                            }
                            $interval=round(abs($to_time - $from_time) / 60,2);
                            $data['jobs'][0]['id']= 0;
                            $data['jobs'][0]['time_taken']=$interval;
                            $data['jobs'][0]['percent']=(0.1*$interval);
                            $data['jobs'][0]['time_from'] = date('Y-m-d H:i:s',$from_time);
                            $data['jobs'][0]['time_to'] = date('Y-m-d H:i:s',$to_time );
                            $data['jobs'][0]['job_code'] = 'idle5';
                            $data['jobs'][0]['class'] = 'darkyellow disabled ';
                            
                        }elseif ($day['day'] < date('Y-m-d')) {
                            $to_time = strtotime($shift['shift_start']);
                            if(date('Y-m-d H:i:s') > $shift['shift_end']){
                                $from_time = strtotime($shift['shift_end']); 
                            }else{
                                $from_time = strtotime(date('Y-m-d H:i:s')); 
                            }
                            $interval=round(abs($to_time - $from_time) / 60,2);
                            $data['jobs'][0]['id']= 0;
                            $data['jobs'][0]['time_taken']=$interval;
                            $data['jobs'][0]['percent']=(0.1*$interval);
                            $data['jobs'][0]['time_from'] = $shift['shift_start'];
                            $data['jobs'][0]['time_to'] = $shift['shift_end'];
                            $data['jobs'][0]['job_code'] = 'idle6';
                            $data['jobs'][0]['class'] = 'darkyellow disabled ';
                        }
                    }
                    $dashboard['machine'][$id]['jobs'] = $data['jobs'];
                }
                $dashboard['shifts'][$shiftkey]['machine']=$dashboard['machine'];
                                $dashboard['shifts'][$shiftkey]['timings']=$shift['timings'];
            }
            $dashboard['days'][$daykey]['shifts']=$dashboard['shifts'];
        }
        
        // Return everything in json 
        echo json_encode(array('days' => $dashboard['days'],'todayday'=>date('M-d-Y',strtotime($todaydate)),'nextday'=>$nextday,'previousday'=>$previousday,'nextdayjob'=>find_next_day_jobs($nextday)));
    }
    public function get_shifts(){
        header('Access-Control-Allow-Origin: *');
        $todaydate =date('Y-m-d',strtotime($this->input->post('date')));
        //$data['shifts']= $this->dashboard_model->get_shifts($todaydate);
        $data['shifts'] = $this->shift_and_timings($todaydate);
        $active_shift = 1;
        if($todaydate == date('Y-m-d')){
            foreach($data['shifts'] as $shift_id => $shift){
                if( ($shift['shift_end'] < DEFAULT_SHIFT_START_TIME ) ){
                    $shift['shift_end'] = date('Y-m-d', strtotime($todaydate.' +1 day')).' '.$shift['shift_end'];
                }else{
                    $shift['shift_end'] = $todaydate.' '.$shift['shift_end'];
                }
                if(($shift['shift_start'] < DEFAULT_SHIFT_START_TIME )){
                    $shift['shift_start'] = date('Y-m-d', strtotime($todaydate.' +1 day')).' '.$shift['shift_start'];
                }else{
                    $shift['shift_start'] = $todaydate.' '.$shift['shift_start'];
                }
            
                if((new DateTime() <= new DateTime($shift['shift_end']))&&(new DateTime() >= new DateTime($shift['shift_start']))){
                    $active_shift = $shift['shift'];
                } 
            }
        } 
        
        
        //echo "<pre>";print_r($active_shift);exit;
        $todaydate=date('M-d-Y');
        $tomorrowdate=date('M-d-Y', strtotime(' +1 day'));
        $dayaftertomorrow=date('M-d-Y', strtotime(' +2 day')); 
        $data['days']= array(array('day'=>$todaydate),array('day'=>$tomorrowdate),array('day'=>$dayaftertomorrow));
        echo json_encode(array('shifts'=>count($data['shifts']),'date'=>$data['days'],'active'=>$active_shift));
    }
    public function addmachine(){
        header('Access-Control-Allow-Origin: *');
        $addmachine_id=$this->input->post('addmachine_id');
        if($addmachine_id==0){
            $data['machine']=$this->input->post('addmachine_machine');
            $data['trave_x']=$this->input->post('addmachine_travearea_x');
            $data['trave_y']=$this->input->post('addmachine_travearea_y');
            $data['memory']=$this->input->post('addmachine_memory');
            $data['programline']=$this->input->post('addmachine_program_lines');
            $data['created_on']=date("Y-m-d H:i:s");
            $data['status']=1;
            $addmachine=$this->dashboard_model->insert_machine($data);
            if($addmachine){
                echo json_encode(array('result' =>'success','message'=>'New Machine Creation Successfully','machine_id'=>$addmachine,'machine_name'=>$data['machine'],'task'=>'insert'));
            }else{
                echo json_encode(array('result' =>'failure','message'=>'New Machine Creation Failed'));
            }
        }else{
            $data['machine']=$this->input->post('addmachine_machine');
            $data['trave_x']=$this->input->post('addmachine_travearea_x');
            $data['trave_y']=$this->input->post('addmachine_travearea_y');
            $data['memory']=$this->input->post('addmachine_memory');
            $data['programline']=$this->input->post('addmachine_program_lines');
            $data['updated_on']=date("Y-m-d H:i:s");
            $data['status']=1;
            $updatemachine=$this->dashboard_model->update_machine($data,$addmachine_id);
            if($updatemachine){
                echo json_encode(array('result' =>'success','message'=>'Machine Details Successfully Updated','task'=>'update'));
            }else{
                echo json_encode(array('result' =>'failure','message'=>'Machine Details Update Failed'));
            }
        }
    }
    public function get_machinelist(){
        header('Access-Control-Allow-Origin: *');
        $machinelists=$this->dashboard_model->get_machine();
        $data = array();
        foreach ($machinelists as $key => $value) {
            $data[$value['machine']]=$value['id'];
        }
        //print_r($data);exit;
        echo json_encode($data);
    }
    public function get_machinelist_low(){
        header('Access-Control-Allow-Origin: *');
        //  $shift=$this->dashboard_model->check_shift();
        $shift = $this->input->post('shift');
        $date = date('Y-m-d',strtotime($this->input->post('date')));
        if($shift != ""){
            $shift = $shift;
        }else{
            $shift = 1;
        }
        $machinelists=$this->dashboard_model->get_machine_low($shift,$date);
        $shiftreturn=$this->dashboard_model->get_shifts($date);
        $shiftlists="";
        foreach($shiftreturn as $key => $shiftres){
            if($key==0){
                $shiftlists.="<option selected value='".$shiftres."'>SHIFT ".$shiftres."</option>";
            }else{
                $shiftlists.="<option value='".$shiftres."'>SHIFT ".$shiftres."</option>";
            }
        }
        //print_r($machinelists['machine'][0]);exit;
        $machine = $machinelists['machine'][0];
        $cur_time = date('Y-m-d H:i:s');
        $job_start_time = date('Y-m-d').' 07:00:00';
        $job_end_time = date('Y-m-d').' 20:00:00';
        //echo "<pre>";print_r($machine);exit;
        if($machine['position'] == 0){
            if($cur_time < $job_start_time ){
                $job_start_time = $job_start_time;
            }elseif(date('Y-m-d') < $date ){
                $job_start_time = $date.' 07:00:00';
            }else{
                $job_start_time = $cur_time;
            }
        }else{
            //print_r($machine);
            $machine['shift']=$shift;
            $machine['date']=$date;
            $end_timing=$this->dashboard_model->get_lastjob_endtiming($machine);
            if($end_timing){
                $end_timing= $date.' '.$end_timing;
                if($cur_time < $end_timing ){
                    $job_start_time = $end_timing;
                }else{
                    $job_start_time = $cur_time;
                }
                //print_r($end_timing);exit;
            }
        }
        echo json_encode(array('machine'=>$machinelists['option'],'shift'=>$shiftlists,'job_start_time'=>date('h:i A',strtotime($job_start_time))));
    }
    public function delete_machinelist(){
        header('Access-Control-Allow-Origin: *');
        $machine_id=$this->input->post('machine_id');
        $delete_machine=$this->dashboard_model->delete_machine($machine_id);
        if($delete_machine){
            echo json_encode(array('result' =>'success','message'=>'Machine Deleted Successfully','machine_id'=>$machine_id));
        }else{
            echo json_encode(array('result' =>'failure','message'=>'Machine Deletion Failed','machine_id'=>$machine_id));
        }
    }
    public function get_machine_details(){
        header('Access-Control-Allow-Origin: *');
        $machine_id=$this->input->post('machine_id');
        $machine_details=$this->dashboard_model->get_machine_details($machine_id);
        if(!empty($machine_details)){
            echo json_encode(array('result' =>'success','id'=>$machine_details['id'],'addmachine_machine'=>$machine_details['machine'],'addmachine_travearea_x'=>$machine_details['trave_x'],'addmachine_travearea_y'=>$machine_details['trave_y'],'addmachine_memory'=>$machine_details['memory'],'addmachine_program_lines'=>$machine_details['programline']));
        }else{
            echo json_encode(array('result' =>'failure','message'=>'Machine Details Reterival Failed','machine_id'=>$machine_id));
        }
    }
    public function get_bossjob_details(){
        header('Access-Control-Allow-Origin: *');
        $job_code=$this->input->post('job_code');
        $time_from=$this->input->post('time_from');
        if(!empty($job_code)){
            $boss_details=$this->dashboard_model->get_bossjob_details($job_code);
            //echo "<pre>";print_r($boss_details);exit;
            $job_time=explode('.',$boss_details['total_time']);
            //echo "<pre>";print_r($job_time);exit;
            $EndTime = new DateTime($time_from);
            $EndTime->modify('+'.$job_time[0].' hours');
            $EndTime->modify('+'.$job_time[1].' minutes');
            $time_to = $EndTime->format('H:i:s');
            if(!empty($boss_details)){
                echo json_encode(array('result' =>'success','message'=>'Job Details Found','addjob_qty'=>$boss_details['quantity'],'addjob_running_time'=>$boss_details['total_time'],'time_to'=>date('h:i A',strtotime($time_to))));
            }else{
                echo json_encode(array('result' =>'failure','message'=>'Job Details Not Found'));
            }
        }else{
            echo json_encode(array('result' =>'failure','message'=>'Please Enter Ref#'));
        }
    }
    /*public function addjob(){
        header('Access-Control-Allow-Origin: *');
        //echo "<pre>";print_r($_POST);exit;
        $data['job_code']=$this->input->post('addjob_job_code');
        $overwrite = $this->input->post('addjob_overwrite');
        $data['qty']=$this->input->post('addjob_qty');
        $data['down_time']=$this->input->post('addjob_running_time');
        $data['date_from']=date("Y-m-d");
        $data['date_to']=date("Y-m-d");
        $time_from= new DateTime($this->input->post('addjob_slot_from'));
        $data['time_from']=$time_from->format('H:i:00');
        $time_to= new DateTime($this->input->post('addjob_slot_to'));
        $data['time_to']=$time_to->format('H:i:00');
        $data['machine']=$this->input->post('addjob_machine');
        $data['shift']=$this->input->post('addjob_shift');
        $data['notes']=$this->input->post('addjob_notes');
        $data['created_on']=date("Y-m-d H:i:s");
                $data['status']=1;
                $data['position']=$this->dashboard_model->check_position($data,$overwrite);
                $newaddjob=$this->dashboard_model->addjob_insert($data);
                if($newaddjob){
            echo json_encode(array('result' =>'success','message'=>'New Job Added Successfully','job_id'=>$newaddjob));
        }else{
            echo json_encode(array('result' =>'failure','message'=>'New Job Adding Failed'));
        }
    }*/
    public function addjob(){
        header('Access-Control-Allow-Origin: *');
       
        $data['job_code']=$this->input->post('addjob_job_code');
        $overwrite = $this->input->post('addjob_overwrite');
        $data['qty']=$this->input->post('addjob_qty');
        $data['down_time']=$this->input->post('addjob_running_time');
        $data['date_from']=date('Y-m-d',strtotime($this->input->post('addjob_date')));
        $data['date_to']=date('Y-m-d',strtotime($this->input->post('addjob_date')));
        $date = date('Y-m-d',strtotime($this->input->post('addjob_date')));
        $time_from= new DateTime($this->input->post('addjob_slot_from'));
        $data['time_from']=$time_from->format('H:i:00');
        $time_to= new DateTime($this->input->post('addjob_slot_to'));
        $data['time_to']=$time_to->format('H:i:00');
        $data['machine']=$this->input->post('addjob_machine');
        $data['shift']=$this->input->post('addjob_shift');
        $data['notes']=$this->input->post('addjob_notes');
        if($this->input->post('addjob_side') < 3 ){
        	$data['side'] = $this->input->post('addjob_side');
        }else{
        	$data['side'] = $this->input->post('multiple_side');
        }
        $data['created_on']=date("Y-m-d H:i:00");
        $data['status']=1;
	//echo "<pre>";print_r($data);exit;
        $shifts_details = $this->shift_and_timings($data['date_from']); 
        foreach ($shifts_details as $key => $shift_details) {
            if($data['shift'] ==$shift_details['shift']){
                $shift_start_time = $shift_details['shift_start'];
                $shift_end_time = $shift_details['shift_end'];
            } 
        }
        if( ($shift_end_time < DEFAULT_SHIFT_START_TIME ) ){
            $shift_end_time = date('Y-m-d', strtotime($date.' +1 day')).' '.$shift_end_time;
        }else{
            $shift_end_time = $date.' '.$shift_end_time;
        }
        if(($shift_start_time < DEFAULT_SHIFT_START_TIME )){
            $shift_start_time = date('Y-m-d', strtotime($date.' +1 day')).' '.$shift_start_time;
        }else{
            $shift_start_time = $date.' '.$shift_start_time;
        }
        
        $job_start = $data['date_from'].' '.$data['time_from'];
        $job_end = $data['date_from'].' '.$data['time_to'];
        if((($job_start < $shift_start_time) || ($job_start > $shift_end_time))||(($job_end < $shift_start_time) || ($job_end >$shift_end_time )) ){
                echo json_encode(array('result' =>'failure','message'=>'Check Job Timing with Shift timing'));
        }else{
            //$data['position']=$this->dashboard_model->check_position($data,$overwrite);
            $newaddjob=$this->dashboard_model->check_position($data,$overwrite);
            //$newaddjob=$this->dashboard_model->addjob_insert($data);
            if($newaddjob){ 
                $mcdown_updates['job_id'] = $newaddjob;
                $mcdown_updates['updated_for'] = 2;
                if($data['notes']=='Wims'){
                    $mcdown_updates['updated_to'] = 'Initialized JO - wims';
                    $mcdown_updates['updated_by'] =  'wims user';
                }else{
                    $mcdown_updates['updated_to'] = 'Initialized JO - Spcs';
                    $mcdown_updates['updated_by'] =  $this->session->userdata('user_name');
                } 
                $mcdown_updates['updated_status'] = 1;
                $mcdown_updates['updated_remark'] = $data['notes'];
                mcdown_updates($mcdown_updates);
                $this->load->library('notification');
                $this->notification->cad_complete_notification( $newaddjob , $data['job_code']);
                                
                echo json_encode(array('result' =>'success','message'=>'New Job Added Successfully','job_id'=>$newaddjob));
            }else{
                echo json_encode(array('result' =>'failure','message'=>'New Job Adding Failed'));
            }
        }
    }
    public function add_mcdown(){
        header('Access-Control-Allow-Origin: *');
        $data['machine']=$this->input->post('mcdown_machine');
        $data['date_from']=date('Y-m-d');
        $data['date_to']=date('Y-m-d');
        $time_from= new DateTime($this->input->post('mcdown_from'));
        $data['time_from']=$time_from->format('H:i:s');
        $time_to= new DateTime($this->input->post('mcdown_to'));
        $data['time_to']=$time_to->format('H:i:s');
        $data['notes']=$this->input->post('mcdown_notes');
        //$data['down_time']=$this->input->post('mcdown_downtime');
        $data['down_time']=1;
        $data['mc_down']=1;
        $data['shift']=$this->input->post('mcdown_shift');
        $data['position']=0;
        $data['created_on']=date("Y-m-d H:i:s");
        $data['status']=1;

        $shifts_details = $this->shift_and_timings($data['date_from']); 
        foreach ($shifts_details as $key => $shift_details) {
            if($data['shift'] == $shift_details['shift']){
                $shift_start_time = $shift_details['shift_start'];
                $shift_end_time = $shift_details['shift_end'];
            } 
        }
        if( ($shift_end_time < DEFAULT_SHIFT_START_TIME ) ){
            $shift_end_time = date('Y-m-d', strtotime($data['date_from'].' +1 day')).' '.$shift_end_time ;
        }else{
            $shift_end_time = $data['date_from'].' '.$shift_end_time ;
        }
        if(($shift_start_time < DEFAULT_SHIFT_START_TIME )){
            $shift_start_time = date('Y-m-d', strtotime($data['date_from'].' +1 day')).' '.$shift_start_time ;
        }else{
            $shift_start_time = $data['date_from'].' '.$shift_start_time ;
        }

        if((new DateTime($shift_start_time) <= new DateTime($data['date_from'].' '.$data['time_from']))&&(new DateTime($shift_end_time) >= new DateTime($data['date_to'].' '.$data['time_to']))){ 
            $newdown=$this->dashboard_model->insert_machine_down($data);
            if($newdown){
                echo json_encode(array('result' =>'success','message'=>'Machine Down Inserted Successfully','mcdown_id'=>$newdown));
            }else{
                echo json_encode(array('result' =>'failure','message'=>'Machine Down Insertion Failed'));
            }
        }else{ 
            echo json_encode(array('result' =>'failure','message'=>'Machine Down Time crossed shift time'));
        }         
    }
    public function add_otherdown(){
        header('Access-Control-Allow-Origin: *');
        $data['machine']=$this->input->post('otherdown_machine');
        $data['reason']=$this->input->post('otherdown_reason');
        $data['date_from']=date('Y-m-d');
        $data['date_to']=date('Y-m-d');
        $time_from= new DateTime($this->input->post('otherdown_from'));
        $data['time_from']=$time_from->format('H:i:s');
        $time_to= new DateTime($this->input->post('otherdown_to'));
        $data['time_to']=$time_to->format('H:i:s'); 
        $data['notes']=$this->input->post('otherdown_notes'); 
        $data['down_time']=1;
        $data['other_down']=1;
        $data['shift']=$this->input->post('otherdown_shift');
        $data['created_on']=date("Y-m-d H:i:s");
        $data['status']=1;

        $shifts_details = $this->shift_and_timings($data['date_from']); 
        foreach ($shifts_details as $key => $shift_details) {
            if($data['shift'] == $shift_details['shift']){
                $shift_start_time = $shift_details['shift_start'];
                $shift_end_time = $shift_details['shift_end'];
            } 
        }
        if( ($shift_end_time < DEFAULT_SHIFT_START_TIME ) ){
            $shift_end_time = date('Y-m-d', strtotime($data['date_from'].' +1 day')).' '.$shift_end_time ;
        }else{
            $shift_end_time = $data['date_from'].' '.$shift_end_time ;
        }
        if(($shift_start_time < DEFAULT_SHIFT_START_TIME )){
            $shift_start_time = date('Y-m-d', strtotime($data['date_from'].' +1 day')).' '.$shift_start_time ;
        }else{
            $shift_start_time = $data['date_from'].' '.$shift_start_time ;
        }

        if((new DateTime($shift_start_time) <= new DateTime($data['date_from'].' '.$data['time_from']))&&(new DateTime($shift_end_time) >= new DateTime($data['date_to'].' '.$data['time_to']))){ 

            //$newdown=$this->dashboard_model->insert_down($data);
            $newdown=$this->dashboard_model->insert_machine_down($data);
            if($newdown){
                echo json_encode(array('result' =>'success','message'=>'Machine Down Inserted Successfully','mcdown_id'=>$newdown));
            }else{
                echo json_encode(array('result' =>'failure','message'=>'Machine Down Insertion Failed'));
            }
        }else{ 
            echo json_encode(array('result' =>'failure','message'=>'Other Down Time crossed shift time'));
        }  
    }
    public function add_setup(){
        header('Access-Control-Allow-Origin: *');
        $data['machine']=$this->input->post('setup_machine');
        $data['date_from']=date('Y-m-d');
        $data['date_to']=date('Y-m-d');
        $data['time_from']=$this->input->post('setup_from');
        $data['time_to']=$this->input->post('setup_to');
        $data['notes']=$this->input->post('setup_notes');
        //$data['down_time']=$this->input->post('setup_downtime');
        $data['down_time']=1;
        $data['setup']=1;
        $data['created_on']=date("Y-m-d H:i:s");
        $data['status']=1;
        $newdown=$this->dashboard_model->insert_down($data);
        if($newdown){
            echo json_encode(array('result' =>'success','message'=>'Machine Down Inserted Successfully','mcdown_id'=>$newdown));
        }else{
            echo json_encode(array('result' =>'failure','message'=>'Machine Down Insertion Failed'));
        }
    }
    public function shift(){
        header('Access-Control-Allow-Origin: *');
        $shift_id=$this->input->post('shift_id');
        if($shift_id==0){
            $data['date_from']=date('Y-m-d',strtotime($this->input->post('shift_from')));
            $data['date_to']=date('Y-m-d',strtotime($this->input->post('shift_to')));
            $data['shift1']=isset($_POST["shift_shift1"]) ? 1 : 0 ;
            $data['shift2']=isset($_POST["shift_shift2"]) ? 1 : 0 ;
            $data['shift3']=isset($_POST["shift_shift3"]) ? 1 : 0 ;
                $shift1_from= new DateTime($this->input->post('shift_shift1_from'));
                $data['shift1_from']=$shift1_from->format('H:i:s');
                $shift1_to= new DateTime($this->input->post('shift_shift1_to'));
                $data['shift1_to']=$shift1_to->format('H:i:s');
                $shift2_from= new DateTime($this->input->post('shift_shift2_from'));
                $data['shift2_from']=$shift2_from->format('H:i:s');
                $shift2_to= new DateTime($this->input->post('shift_shift2_to'));
                $data['shift2_to']=$shift2_to->format('H:i:s');
                $shift3_from= new DateTime($this->input->post('shift_shift3_from'));
                $data['shift3_from']=$shift3_from->format('H:i:s');
                $shift3_to= new DateTime($this->input->post('shift_shift3_to'));
                $data['shift3_to']=$shift3_to->format('H:i:s');
            $data['created_on']=date("Y-m-d H:i:s");
                    $data['status']=1;
                    $newshift=$this->dashboard_model->insert_shift($data);
                    if($newshift){
                echo json_encode(array('result' =>'success','message'=>'Shift Inserted Successfully','shift_id'=>$newshift));
            }else{
                echo json_encode(array('result' =>'failure','message'=>'Shift Insertion Failed'));
            }
        }else{
            $data['date_from']=date('Y-m-d',strtotime($this->input->post('shift_from')));
            $data['date_to']=date('Y-m-d',strtotime($this->input->post('shift_to')));
            
            $data['shift1']=isset($_POST["shift_shift1"]) ? 1 : 0 ;
            $data['shift2']=isset($_POST["shift_shift2"]) ? 1 : 0 ;
            $data['shift3']=isset($_POST["shift_shift3"]) ? 1 : 0 ;
            
            $data['shift1_to']=$this->input->post('shift_shift1_to');
            $data['shift1_from']=$this->input->post('shift_shift1_from');
            $data['shift2_to']=$this->input->post('shift_shift2_to');
            $data['shift2_from']=$this->input->post('shift_shift2_from');
            $data['shift3_to']=$this->input->post('shift_shift3_to');
            $data['shift3_from']=$this->input->post('shift_shift3_from');
            $data['count']=$this->input->post('shift_count');
            $data['updated_on']=date("Y-m-d H:i:s");
            $data['status']=1;
            $newshift=$this->dashboard_model->update_shift($data,$shift_id);
            if($newshift){
                echo json_encode(array('result' =>'success','message'=>'Shift Updated Successfully','shift_id'=>$newshift));
            }else{
                echo json_encode(array('result' =>'failure','message'=>'Shift Update Failed'));
            }
        }
    }
    public function get_shift_details(){
        header('Access-Control-Allow-Origin: *');
        $data['date_from'] = date('Y-m-d',strtotime($this->input->post('shift_from')));
        //$shiftdetails=$this->dashboard_model->get_shift_details($date_from);
        
        $shiftdetails=$this->dashboard_model->shift_timings($data);
        //echo "<pre>";print_r($shiftdetails);exit;
        
        if(!empty($shiftdetails)){
        	$shiftdetails['id']	=	(isset($shiftdetails['id']))? $shiftdetails['id'] : 0 ;
            echo json_encode(
            	array(
	            	'result'	=>	'success',
            		'message'	=>	'Shift details Reterieved',
            		'shift_from'	=>	date('m/d/Y',strtotime($data['date_from'])),
            		'shift_to'	=>	date('m/d/Y',strtotime($data['date_from'])),
            		'shift1_from'	=>	date('h:i A',strtotime($shiftdetails['shift1_from'])),
            		'shift1_to'	=>	date('h:i A',strtotime($shiftdetails['shift1_to'])),
            		'shift2_from'	=>	date('h:i A',strtotime($shiftdetails['shift2_from'])),
            		'shift2_to'	=>	date('h:i A',strtotime($shiftdetails['shift2_to'])),
            		'shift3_from'	=>	date('h:i A',strtotime($shiftdetails['shift3_from'])),
            		'shift3_to'	=>	date('h:i A',strtotime($shiftdetails['shift3_to'])),
            		'shift_shift1'	=>	$shiftdetails['shift1'],
            		'shift_shift2'	=>	$shiftdetails['shift2'],
            		'shift_shift3'	=>	$shiftdetails['shift3'],
            		'shift_id'	=>	$shiftdetails['id']
            	)
            );
        }else{
            echo json_encode(array('result' =>'failure','message'=>'No Shift Details Found','shift_from'=>$date_from ));
        }
    }

    public function downtime(){
        header('Access-Control-Allow-Origin: *');
        $this->load->model('mcdown_model','mcdown');
        $data=$_POST;
        for ($i=0; $i < count($data['downtime_fromdate']) ; $i++) {
            $dates = createDateRangeArray($data['downtime_fromdate'][$i],$data['downtime_todate'][$i]);
            foreach ($dates as $key => $date) { 
                $data['shifts'] = $this->shift_and_timings(date('Y-m-d',strtotime($date))); 
                foreach($data['shifts'] as $shift_id => $shift){
                
                    $check['machine'] 	= $data['downtime_machine'][$i];
                    $check['date_from'] = $date;
                    $check['shift'] 	= $shift['shift'];
                    $mcdown = $this->mcdown->check_fullshift_mcdown($check);
                    //echo "<pre>";print_r($mcdown);exit;
                    if(($mcdown['mc_down']!=1)&&($mcdown['full_shift_mcdown']!=1)){
	                    if( ($shift['shift_end'] < DEFAULT_SHIFT_START_TIME ) ){
	                        $shift['shift_end'] = date('Y-m-d', strtotime(date('Y-m-d',strtotime($date)).' +1 day')).' '.$shift['shift_end'];
	                    }else{
	                        $shift['shift_end'] = date('Y-m-d',strtotime($date)).' '.$shift['shift_end'];
	                    }
	                    if(($shift['shift_start'] < DEFAULT_SHIFT_START_TIME )){
	                        $shift['shift_start'] = date('Y-m-d', strtotime(date('Y-m-d',strtotime($date)).' +1 day')).' '.$shift['shift_start'];
	                    }else{
	                        $shift['shift_start'] = date('Y-m-d',strtotime($date)).' '.$shift['shift_start'];
	                    } 
	                    $downtime['date_from']  = date('Y-m-d',strtotime($shift['shift_start']));
	                    $downtime['date_to']    = date('Y-m-d',strtotime($shift['shift_end']));
	                    $downtime['time_from']  = date('H:i:s',strtotime($shift['shift_start']));
	                    $downtime['time_to']    = date('H:i:s',strtotime($shift['shift_end']));
	                    $downtime['shift']      = $shift['shift'];
	                    $downtime['machine']    = $data['downtime_machine'][$i];
	                    $downtime['reason']     = $data['downtime_reason'][$i];
	                    $downtime['mc_down']    = 1;
	                    $downtime['created_on'] = date("Y-m-d H:i:s");
	                    $downtime['status']     = 1; 
	                    $newdown=$this->dashboard_model->insert_down($downtime);
                    }
                }
            }
        }
        if(isset($newdown)){
	        if($newdown){
	            echo json_encode(array('result' =>'success','message'=>'Machine Down Inserted Successfully','mcdown_id'=>$newdown));
	        }else{
	            echo json_encode(array('result' =>'failure','message'=>'Machine Down Insertion Failed'));
	        }
	}else{
		echo json_encode(array('result' =>'failure','message'=>'please verify machine down Insertion.'));
	}
    }
    public function maintain(){
       
        header('Access-Control-Allow-Origin: *');
        $data=$_POST;

        for ($i=0; $i < count($data['maintain_fromdate']) ; $i++) {
            $dates = createDateRangeArray($data['maintain_fromdate'][$i],$data['maintain_todate'][$i]);
            foreach ($dates as $key => $date) {
                $data['shifts'] = $this->shift_and_timings(date('Y-m-d',strtotime($date))); 
                foreach($data['shifts'] as $shift_id => $shift){
                    if( ($shift['shift_end'] < DEFAULT_SHIFT_START_TIME ) ){
                        $shift['shift_end'] = date('Y-m-d', strtotime(date('Y-m-d',strtotime($date)).' +1 day')).' '.$shift['shift_end'];
                    }else{
                        $shift['shift_end'] = date('Y-m-d',strtotime($date)).' '.$shift['shift_end'];
                    }
                    if(($shift['shift_start'] < DEFAULT_SHIFT_START_TIME )){
                        $shift['shift_start'] = date('Y-m-d', strtotime(date('Y-m-d',strtotime($date)).' +1 day')).' '.$shift['shift_start'];
                    }else{
                        $shift['shift_start'] = date('Y-m-d',strtotime($date)).' '.$shift['shift_start'];
                    }

                    $downtime['date_from']   = date('Y-m-d',strtotime($shift['shift_start']));
                    $downtime['date_to']     = date('Y-m-d',strtotime($shift['shift_end']));
                    $downtime['time_from']   = date('H:i:00');
                    $downtime['time_to']     = date('H:i:00',strtotime($data['maintain_timeto'][$i].':00'));
                    $downtime['shift']       = $shift['shift'];
                    $downtime['machine']     = $data['maintain_machine'][$i];
                    $downtime['reason']      = $data['maintain_reason'][$i];
                    $downtime['maintenance'] = 1;
                    $downtime['created_on']  = date("Y-m-d H:i:s");
                    $downtime['status']      = 1;
                    
                    
                    $newdown=$this->dashboard_model->insert_down($downtime);
                }
            }
        }
        if($newdown){
            echo json_encode(array('result' =>'success','message'=>'New Maintenance Inserted Successfully','mcdown_id'=>$newdown));
        }else{
            echo json_encode(array('result' =>'failure','message'=>'New Maintenance Insertion Failed'));
        }
    }
    public function downreport(){
        header('Access-Control-Allow-Origin: *');
        $data=$_POST;
        $downreport['date_from']=date('Y-m-d',strtotime($data['downreport_from']));
        $downreport['date_to']=date('Y-m-d',strtotime($data['downreport_to']));
        $downreport['machine']=$data['downreport_machine'];
        $downreports=$this->dashboard_model->downreport($downreport);
        $report = "";
        foreach ($downreports as $key => $downreport) {
            $time_from = date("g:i a",strtotime($downreport['time_from']));
            $time_to = date("g:i a",strtotime($downreport['time_to']));
            if($downreport['task']==1){
            	$ready = "";
            }else{
            	$ready = "<a href='".base_url('dashboard/machine_ready/'.$downreport['id'])."' class='btn btn-primary btn_machine_ready'>Ready</a>";
            }
            
            if($downreport['notes']!=''){
                
                 $reason =$downreport['notes'];
                 
            }elseif($downreport['reason']!=''){
                
                $reason =$downreport['reason'];
            }else{
                $reason = '';
            }            
            
            $report .= "<tr><td>".$downreport['date_from']."</td><td>".$downreport['date_to']."</td><td>".$time_from."</td><td>".$time_to."</td><td>".$downreport['machine']."</td><td>".$downreport['shift']."</td><td>".$reason."</td><td>".$ready."</td></tr>";
        }
        if(!empty($downreports)){
            echo json_encode(array('result' =>'success','message'=>'Report LIsted successfully','data'=>$report));
        }else{
            $report .= "<tr><td colspan='8'>No Details Found</td></tr>";
            echo json_encode(array('result' =>'failure','message'=>'No Details Found','data'=>$report));
        }
    }
    
    public function idlereport(){
        header('Access-Control-Allow-Origin: *');
        $data=$_POST;
        $idlereport['date_from'] = date('Y-m-d',strtotime($data['idle_fromdate']));
        $idlereport['date_to'] = date('Y-m-d',strtotime($data['idle_todate']));
        $idlereport['machine'] = $data['idle_machine'];
        $idlereports = $this->dashboard_model->idlereport($idlereport);
        $nextday = date('Y-m-d',strtotime($idlereport['date_from'].' +1 day'));
        $dates = createDateRangeArray($idlereport['date_from'],$idlereport['date_to']);
        foreach ($dates as $key => $date) {
                    $data['days'][]=array('day'=>$date);
                }
                //echo "<pre>";print_r($data['days']);exit;
                //$data['days']= array(array('day'=>$idlereport['date_from']),array('day'=>$nextday));
                // $data['shifts']= array(array('shift'=>1),array('shift'=>2),array('shift'=>3));
                //$data['shifts']= array(array('shift'=>1));
        foreach ($data['days'] as $daykey => $day) {
            $data['shifts'] = $this->shift_and_timings(date('Y-m-d',strtotime($day['day'])));
            //echo "<pre>";print_r($data['shifts']);exit;
            foreach ($data['shifts'] as $shiftkey => $shift) {
                $dashboard['machine'][]= $this->dashboard_model->get_machine_details($idlereport['machine']);
                foreach ($dashboard['machine'] as $id => $machine) {
                    //$data['jobs'] = $this->dashboard_model->get_jobs($day['day'],$machine['id']);
                    //$jobs = $this->dashboard_model->get_jobs($day['day'],$machine['id'],$shift['shift']);
                    $down = $this->dashboard_model->get_downtime($day['day'],$machine['id'],$shift['shift']);
                    $data['jobs'] = $down;
                    //$data['jobs'] = array_merge($jobs, $down);
                    if(count($data['jobs']) > 0){
                        foreach ($data['jobs'] as $jobkey => $job) {
                            $datetime1 = new DateTime($job['date_from'].' '.$job['time_from']);
                            $datetime2 = new DateTime($job['date_to'].' '.$job['time_to']);
                            $interval = $datetime1->diff($datetime2);
                            //print_r($interval);exit;
                            $to_time = $job['date_to'].' '.$job['time_to'];
                            $job_end = $job['date_from'].' 20:00:00';
                            if( $to_time > $job_end){
                                $to_time = $job_end;
                            }
                            $to_time = strtotime($to_time);
                            $from_time = strtotime($job['date_from'].' '.$job['time_from']);
                            $interval=round(abs($to_time - $from_time) / 60,2);
                            //$data['jobs'][$jobkey]['time_taken']=($interval->format('%h.%i')*60 > 720) ? 720 : $interval->format('%h.%i')*60;
                            $data['jobs'][$jobkey]['time_taken']=$interval;
                            $data['jobs'][$jobkey]['percent']=(0.1*$data['jobs'][$jobkey]['time_taken']);
                            $data['jobs'][$jobkey]['time_from'] = $job['time_from'];
                            $data['jobs'][$jobkey]['time_to'] = $job['time_to'];
                            //$data['jobs'][$jobkey]['class']=$class;
                        }
                        usort($data['jobs'], 'sortBytime_from');
                        //usort($data['jobs'], 'sortByposition');
                        //echo "<pre>";print_r($data['jobs']);exit;
                        $job_count=count($data['jobs']);
                        foreach ($data['jobs'] as $jobkey => $job) {
                            if($jobkey==0){
                                if($job['time_from'] != '07:00:00'){
                                    $keyval=count($data['jobs'])+1;
                                    $to_time = strtotime($job['date_to'].' '.$job['time_from']);
                                    $from_time = strtotime($job['date_from'].' 07:00:00');
                                    $interval=round(abs($to_time - $from_time) / 60,2);
                                    $data['jobs'][$keyval]['id']= 0;
                                    $data['jobs'][$keyval]['time_from']="07:00:00";
                                    $data['jobs'][$keyval]['time_to']=$job['time_from'];
                                    $data['jobs'][$keyval]['class']="darkyellow disabled ";
                                    $data['jobs'][$keyval]['time_taken']=$interval;
                                    $data['jobs'][$keyval]['percent']=(0.1*$data['jobs'][$keyval]['time_taken']);
                                    $data['jobs'][$keyval]['job_code']='idle';
                                                                        $data['jobs'][$keyval]['date']=$job['date_from'];
                                                                        $data['jobs'][$keyval]['machine']=$machine['machine'];
                                }
                            }if($jobkey == $job_count-1){
                                //if(($day['day'].' '.$job['time_to'] < date('Y-m-d H:i:s'))&&(date('Y-m-d H:i:s') <= $day['day'].' 20:00:00')){
                                if(($day['day'].' '.$job['time_to'] < date('Y-m-d H:i:s'))&&($day['day'].' '.$job['time_to'] < $day['day'].' 20:00:00')){
                                    $keyval=count($data['jobs'])+1;
                                    //print_r($job);exit;
                                    if($day['day'] < date('Y-m-d')){
                                        $to_time = strtotime($job['date_to'].' 20:00:00');
                                    }else{
                                                                            if(date('H:i:s') > '20:00:00'){
                                                                                $to_time = strtotime($job['date_to'].' 20:00:00');
                                                                            }else{
                                                                                $to_time = strtotime($job['date_to'].' '.date('H:i:s'));
                                                                            }
                                    }
                                    //$to_time = strtotime($job['date_to'].' 20:00:00');
                                    $from_time = strtotime($job['date_from'].' '.$job['time_to']);
                                    $interval=round(abs($to_time - $from_time) / 60,2);
                                    $data['jobs'][$keyval]['id']= 0;
                                    $data['jobs'][$keyval]['time_from']=$job['time_to'];
                                    $data['jobs'][$keyval]['time_to']='20:00:00';
                                    $data['jobs'][$keyval]['class']="darkyellow disabled ";
                                    $data['jobs'][$keyval]['time_taken']=$interval;
                                    $data['jobs'][$keyval]['percent']=(0.1*$data['jobs'][$keyval]['time_taken']);
                                    $data['jobs'][$keyval]['job_code']='idle';
                                                                        $data['jobs'][$keyval]['date']=$job['date_from'];
                                                                        $data['jobs'][$keyval]['machine']=$machine['machine'];
                                }else{
                                }
                            }
                            if(((count($data['jobs'])-1) != $jobkey) && ($jobkey != 0) ){
                                $keyval=count($data['jobs'])+1;
                                $oldjob=$jobkey-1;
                                $to_time = strtotime($job['date_to'].' '.$data['jobs'][$jobkey]['time_from']);
                                $from_time = strtotime($job['date_from'].' '.$data['jobs'][$oldjob]['time_to']);
                                $interval=round(abs($to_time - $from_time) / 60,2);
//print_r($to_time); print_r(' '.$from_time);
//exit;
                                                            //if($to_time == $from_time){
                                $data['jobs'][$keyval]['id']= 0;
                                $data['jobs'][$keyval]['time_from']=$data['jobs'][$jobkey-1]['time_to'];
                                $data['jobs'][$keyval]['time_to']=$data['jobs'][$jobkey]['time_from'];
                                $data['jobs'][$keyval]['class']="darkyellow disabled ";
                                $data['jobs'][$keyval]['time_taken']=$interval;
                                $data['jobs'][$keyval]['percent']=(0.138*$data['jobs'][$keyval]['time_taken']);
                                $data['jobs'][$keyval]['job_code']='idle';
                                                                $data['jobs'][$keyval]['date']=$job['date_from'];
                                                                $data['jobs'][$keyval]['machine']=$machine['machine'];
                                                            //}
                            }
                        }
                        usort($data['jobs'], 'sortBytime_from');
                    }else{
                        if($day['day'] == date('Y-m-d')){
                            $to_time = strtotime(date('Y-m-d').' 07:00:00');
                            //$from_time = strtotime(date('Y-m-d').' 20:00:00');
                            if(date('Y-m-d H:i:s') > date('Y-m-d').' 20:00:00'){
                                $from_time = strtotime(date('Y-m-d').' 20:00:00');
                            }else{
                                $from_time = strtotime(date('Y-m-d H:i:s'));
                            }
                            $interval=round(abs($to_time - $from_time) / 60,2);
                            $data['jobs'][0]['id']= 0;
                            $data['jobs'][0]['time_taken']=$interval;
                            $data['jobs'][0]['percent']=(0.138*$interval);
                            $data['jobs'][0]['time_from'] = '07:00:00';
                            $data['jobs'][0]['time_to'] = '20:00:00';
                            $data['jobs'][0]['job_code'] = 'idle';
                                                        $data['jobs'][0]['date'] =  $day['day'];
                                                        $data['jobs'][0]['machine']=$machine['machine'];
                        }elseif ($day['day'] < date('Y-m-d')) {
                            $to_time = strtotime(date('Y-m-d').' 07:00:00');
                            //$from_time = strtotime(date('Y-m-d').' 20:00:00');
                            if(date('Y-m-d H:i:s') > $day['day'].' 20:00:00'){
                                $from_time = strtotime(date('Y-m-d').' 20:00:00');
                            }else{
                                $from_time = strtotime(date('Y-m-d H:i:s'));
                            }
                            $interval=round(abs($to_time - $from_time) / 60,2);
                            $data['jobs'][0]['id']= 0;
                            $data['jobs'][0]['time_taken']=$interval;
                            $data['jobs'][0]['percent']=(0.138*$interval);
                            $data['jobs'][0]['time_from'] = '07:00:00';
                            $data['jobs'][0]['time_to'] = '20:00:00';
                            $data['jobs'][0]['job_code'] = 'idle';
                            $data['jobs'][0]['date'] =  $day['day'];
                                                        $data['jobs'][0]['machine']=$machine['machine'];
                        }
                    }
                }
            }
                         foreach ($data['jobs'] as $jobkey => $job) {
                                             if($job['job_code']=="idle"){
                                                 $jobs['jobs'][]=$job;
                                             }
                                        }
        }
        $report="";
        foreach ($jobs['jobs'] as $key => $idlereport) {
            $report.="<tr><td>".$idlereport['date']."</td><td>".$idlereport['time_from']."</td><td>".$idlereport['time_to']."</td><td>".$idlereport['machine']."</td><td>".$idlereport['job_code']."</td></tr>";
        }
        if(!empty($jobs['jobs'])){
            echo json_encode(array('result' =>'success','message'=>'Report Listed successfully','data'=>$report));
        }else{
            $report.="<tr><td colspan='5'>No Details Found</td></tr>";
            echo json_encode(array('result' =>'failure','message'=>'No Details Found','data'=>$report));
        }
    }
    public function setupreport(){
        header('Access-Control-Allow-Origin: *');
        $data=$_POST;
        $setupreport['date_from']=date('Y-m-d',strtotime($data['setup_fromdate']));
        $setupreport['date_to']=date('Y-m-d',strtotime($data['setup_todate']));;
        $setupreport['machine']=$data['setup_machine'];
        $setupreports=$this->dashboard_model->setupreport($setupreport);
        $report="";
        foreach ($setupreports as $key => $setupreport) {
                        $time_from = date("g:i a",strtotime($setupreport['setup_start']));
                        $time_to = date("g:i a",strtotime($setupreport['setup_end']));
            $report.="<tr><td>".$setupreport['date_from']."</td><td>".$setupreport['date_to']."</td><td>".$time_from."</td><td>".$time_to."</td><td>".$setupreport['machine']."</td><td>".$setupreport['job_code']."</td></tr>";
        }
        if(!empty($setupreports)){
            echo json_encode(array('result' =>'success','message'=>'Report LIsted successfully','data'=>$report));
        }else{
            $report.="<tr><td colspan='6'>No Details Found</td></tr>";
            echo json_encode(array('result' =>'failure','message'=>'No Details Found','data'=>$report));
        }
    }
    public function maintainreport(){
        header('Access-Control-Allow-Origin: *');
        $data=$_POST;
        $maintainreport['date_from']=date('Y-m-d',strtotime($data['maintainreport_fromdate']));
        $maintainreport['date_to']=date('Y-m-d',strtotime($data['maintainreport_todate']));
        $maintainreport['machine']=$data['maintainreport_machine'];
        $maintainreports=$this->dashboard_model->maintainreport($maintainreport);
        
        $report="";
        foreach ($maintainreports as $key => $maintainreport) {
            $report.="<tr><td>".$maintainreport['date_from']."</td><td>".$maintainreport['date_to']."</td><td>".date('h:i A',strtotime($maintainreport['time_from']))."</td><td>".date('h:i A',strtotime($maintainreport['time_to']))."</td><td>".$maintainreport['shift']."</td><td>".$maintainreport['machine']."</td><td>".$maintainreport['reason']."</td></tr>";
        }
        if(!empty($maintainreports)){
            echo json_encode(array('result' =>'success','message'=>'Report LIsted successfully','data'=>$report));
        }else{
            $report.="<tr><td colspan='7'>No Details Found</td></tr>";
            echo json_encode(array('result' =>'failure','message'=>'No Details Found','data'=>$report));
        }
    }
    public function check_job_availability(){
        header('Access-Control-Allow-Origin: *'); 
        $time_from = new DateTime($this->input->post('addjob_slot_from'));
        $time_to = new DateTime($this->input->post('addjob_slot_to'));
        $data['date'] = date('Y-m-d',strtotime($this->input->post('addjob_date')));
        $data['machine'] = $this->input->post('addjob_machine');
        $data['id'] = $this->input->post('addjob_machine');
        $data['time_from'] = $time_from->format('H:i:s');
        $data['time_to'] = $time_to->format('H:i:s');
        $data['shift'] = $this->input->post('addjob_shift');
        $data['addjob_running_time'] = $this->input->post('addjob_running_time');
        $cur_time = date('Y-m-d H:i:s'); 
        $shifts_details = $this->shift_and_timings($data['date']); 
        foreach ($shifts_details as $key => $shift_details) {
            if($data['shift'] ==$shift_details['shift']){
                $shift_start_time = $shift_details['shift_start'];
                $shift_end_time = $shift_details['shift_end'];
            } 
        }
        
        if( ($shift_end_time < DEFAULT_SHIFT_START_TIME ) ){
            $shift_end_time = date('Y-m-d', strtotime($data['date'].' +1 day')).' '.$shift_end_time;
        }else{
            $shift_end_time = $data['date'].' '.$shift_end_time;
        }
        //echo $shift_end_time; exit;
        
        if(($shift_start_time < DEFAULT_SHIFT_START_TIME )){
            $shift_start_time = date('Y-m-d', strtotime($data['date'].' +1 day')).' '.$shift_start_time;
        }else{
            $shift_start_time = $data['date'].' '.$shift_start_time;
        }
        
        
        //echo "<pre>";print_r($shift_start_time.' - '.$shift_end_time);exit;

        $job_start_from = $data['date'].' '.$data['time_from'];
        $job_end_to = $data['date'].' '.$data['time_to'];
        $end_timing=$this->dashboard_model->get_lastjob_endtiming($data);
        if($end_timing){
            //$end_timing = $data['date'].' '.$end_timing;
            if(new DateTime($cur_time) < new DateTime($end_timing) ){
                $end_timing = $end_timing;
            }else{
                $end_timing = $cur_time;
            }
        }else{ 
            if(new DateTime($cur_time) < new DateTime($shift_start_time) && new DateTime($cur_time) < new DateTime($shift_end_time)){
                $end_timing = $shift_start_time;
            }elseif(new DateTime($cur_time) > new DateTime($shift_start_time) && new DateTime($cur_time) < new DateTime($shift_end_time)){
                $end_timing = $cur_time;
            }else{
                $end_timing = $cur_time;
            }
        }
        //print_r($end_timing);//exit;
        $job_time = explode('.', trim($data['addjob_running_time']));
        $job_end = new DateTime($end_timing);
        $job_end->modify('+'.$job_time[0].' hours');
        if(count($job_time)==2){
            $job_end->modify('+'.$job_time[1].' minutes');
        }
        //$job_end_time = $job_end->format('H:i:s');
        //print_r($job_end->format('Y-m-d'));exit;
        $check_availability['date_from'] = date('Y-m-d',strtotime($end_timing));
        $check_availability['date_to'] = $job_end->format('Y-m-d');
        $check_availability['machine'] = $data['machine'];
        $check_availability['shift'] = $data['shift'];
        $check_availability['time_from'] = date('H:i:s',strtotime($end_timing));
        $check_availability['time_to'] = $job_end->format('H:i:s');
        //print_r($check_availability);
        $job_on_time = $this->dashboard_model->check_job_availability($check_availability);
        
        
        if(new DateTime($job_end->format('Y-m-d').' '.$job_end->format('H:i:s')) <= new DateTime($shift_end_time) ){
            $job_start=date('h:i A',strtotime($end_timing));
            $job_end = $job_end->format('h:i A'); 
            if($job_on_time['job']==0){
                echo json_encode(array('result' =>'success','message'=>'No job on this time','machinedown'=>0,'job_start'=>$job_start,'job_end'=>$job_end));
            }else{
                if($job_on_time['mcdown']==1){
                    echo json_encode(array('result' =>'failure','message'=>'Machine Down on this time','machinedown'=>1,'machine'=>$data['machine'],'job_start'=>$job_start,'job_end'=>$job_end));
                }else{
                    echo json_encode(array('result' =>'failure','message'=>'Job on this time','machinedown'=>0,'machine'=>$data['machine'],'job_start'=>$job_start,'job_end'=>$job_end));
                }
            }
        }else{
            $job_start=date('h:i A',strtotime($end_timing));
            $job_end = $job_end->format('h:i A'); 
            if($job_on_time['mcdown']==1){
                echo json_encode(array('result' =>'failure','message'=>'machine down please select another machine','machinedown'=>1,'same'=>1,'job_start'=>$job_start,'job_end'=>$job_end));
            }else{
                echo json_encode(array('result' =>'failure','message'=>'Job time more than shift time, please assign to another shift or day','machinedown'=>0,'same'=>1,'job_start'=>$job_start,'job_end'=>$job_end));
            }
        }
    }
    
    public function check_job_availability_update(){
        header('Access-Control-Allow-Origin: *'); 
        $time_from = new DateTime($this->input->post('addjob_slot_from'));
        $time_to = new DateTime($this->input->post('addjob_slot_to'));
        $data['date'] = date('Y-m-d',strtotime($this->input->post('addjob_date')));
        $data['machine'] = $this->input->post('addjob_machine');
        $data['id'] = $this->input->post('addjob_machine');
        $data['time_from'] = $time_from->format('H:i:s');
        $data['time_to'] = $time_to->format('H:i:s');
        $data['shift'] = $this->input->post('addjob_shift');
        $data['addjob_running_time'] = $this->input->post('addjob_running_time');
        
        $current_down = $this->input->post('addjob_running_time');
    	$previous_down = $this->input->post('hid_down');
        
        $data['job_code'] = $this->input->post('addjob_job_code');
        $cur_time = date('Y-m-d H:i:s'); 
        $shifts_details = $this->shift_and_timings($data['date']); 
        foreach ($shifts_details as $key => $shift_details) {
            if($data['shift'] ==$shift_details['shift']){
                $shift_start_time = $shift_details['shift_start'];
                $shift_end_time = $shift_details['shift_end'];
            } 
        }
        
        if( ($shift_end_time < DEFAULT_SHIFT_START_TIME ) ){
            $shift_end_time = date('Y-m-d', strtotime($data['date'].' +1 day')).' '.$shift_end_time;
        }else{
            $shift_end_time = $data['date'].' '.$shift_end_time;
        }
        //echo $shift_end_time; exit;
        
        if(($shift_start_time < DEFAULT_SHIFT_START_TIME )){
            $shift_start_time = date('Y-m-d', strtotime($data['date'].' +1 day')).' '.$shift_start_time;
        }else{
            $shift_start_time = $data['date'].' '.$shift_start_time;
        }
        $job_start_from = $data['date'].' '.$data['time_from'];
        $job_end_to = $data['date'].' '.$data['time_to'];
        $end_timing=$this->dashboard_model->get_current_job_starttiming($data);
        if($end_timing){
            if(new DateTime($cur_time) < new DateTime($end_timing) ){
                $end_timing = $end_timing;
            }else{
                $end_timing = $cur_time;
            }
        }else{ 
            if(new DateTime($cur_time) < new DateTime($shift_start_time) && new DateTime($cur_time) < new DateTime($shift_end_time)){
                $end_timing = $shift_start_time;
            }elseif(new DateTime($cur_time) > new DateTime($shift_start_time) && new DateTime($cur_time) < new DateTime($shift_end_time)){
                $end_timing = $cur_time;
            }else{
                $end_timing = $cur_time;
            }
        }        
        
        //print_r($end_timing);exit;
        if(strtotime($current_down) > strtotime($previous_down)){
            $job_time = explode('.', trim($data['addjob_running_time']));
            $job_end = new DateTime($end_timing);
            $job_end->modify('+'.$job_time[0].' hours');
            if(count($job_time)==2){
                $job_end->modify('+'.$job_time[1].' minutes');
            }
        }else{
            $from_timing = $this->dashboard_model->get_current_job_totiming($data);
           
            $job_time = explode('.', trim($data['addjob_running_time']));
            $job_end = new DateTime($from_timing);
            $job_end->modify('+'.$job_time[0].' hours');
            if(count($job_time)==2){
                $job_end->modify('+'.$job_time[1].' minutes');
            }            
        }

         if(new DateTime($job_end->format('Y-m-d').' '.$job_end->format('H:i:s')) <= new DateTime($shift_end_time) ){
            $job_start=date('h:i A',strtotime($end_timing));
            $job_end = $job_end->format('h:i A');  
            
            echo json_encode(array('result' =>'success','message'=>'No job on this time','machinedown'=>0,'job_start'=>$job_start,'job_end'=>$job_end));
         }else{
            $job_start=date('h:i A',strtotime($end_timing));
            $job_end = $job_end->format('h:i A');                
             echo json_encode(array('result' =>'failure','message'=>'Job time more than shift time, please assign to another shift or day','machinedown'=>0,'same'=>1,'job_start'=>$job_start,'job_end'=>$job_end));
         }
        
    }  
    public function reposition(){
            header('Access-Control-Allow-Origin: *');
        //echo "<pre>";print_r($_POST);exit;
        $data=$_POST;
        $day1_shift1_row1=explode('&',$data['day1_shift1_row1']);
        $machine1=$data['day1_shift1_row1_machine'];
        $day1_shift1_row1 =array_filter(preg_replace("/[^0-9]+/", "", $day1_shift1_row1 ));
        //echo "<pre>";print_r($day1_shift1_row1);
        if(count($day1_shift1_row1)>0){
            foreach ($day1_shift1_row1 as $key => $value) {
                $pos['position']=$key+1;
                $pos['machine']=$machine1;
                $possition = $this->dashboard_model->change_job_position($value,$pos);
            }
        }
        $day1_shift1_row2=explode('&',$data['day1_shift1_row2']);
        $machine2=$data['day1_shift1_row2_machine'];
        $day1_shift1_row2 =array_filter(preg_replace("/[^0-9]+/", "", $day1_shift1_row2 ));
        //echo "<pre>";print_r($day1_shift1_row2);
        if(count($day1_shift1_row2)>0){
            foreach ($day1_shift1_row2 as $key => $value) {
                $pos['position']=$key+1;
                $pos['machine']=$machine2;
                $possition = $this->dashboard_model->change_job_position($value,$pos);
            }
        }
        $day1_shift1_row3=explode('&',$data['day1_shift1_row3']);
        $machine3=$data['day1_shift1_row3_machine'];
        $day1_shift1_row3 =array_filter(preg_replace("/[^0-9]+/", "", $day1_shift1_row3 ));
        //echo "<pre>";print_r($day1_shift1_row3);
        if(count($day1_shift1_row3)>0){
            foreach ($day1_shift1_row3 as $key => $value) {
                $pos['position']=$key+1;
                $pos['machine']=$machine3;
                $possition = $this->dashboard_model->change_job_position($value,$pos);
            }
        }
        exit;
    }
    public function reposition_new(){
        header('Access-Control-Allow-Origin: *');
        $data=$_POST;
        $no_machines = $data['no_machine'];
        $machines = array_filter(explode(',',$data['machines']));
        $update="allowed";
        $todaydate=date('Y-m-d');
        $tomorrowdate=date('Y-m-d', strtotime(' +1 day'));
        $dayaftertomorrow=date('Y-m-d', strtotime(' +2 day'));
        for ($i=1; $i <= count($machines); $i++) {
            // day 1 1st shift job possition update
            $row = explode('&',$data['vars']['day1_shift1_row'.$i]);
            $machine = $machines[$i];
            $row = array_filter(preg_replace("/[^0-9]+/", "", $row ));
            //print_r($row);exit;
            if(count($row) > 0){
                $checking_timing = $this->dashboard_model->checking_timing($row);
                if($checking_timing){
                    $update="denied";
                }
            }
            print_r('day 1 1st shift-'.$update.'<br>');
            // day 1 2nd shift job possition update
            $row=explode('&',$data['vars']['day1_shift2_row'.$i]);
            $machine=$machines[$i];
            $row =array_filter(preg_replace("/[^0-9]+/", "", $row ));
            if(count($row)>0){
                $checking_timing=$this->dashboard_model->checking_timing($row);
                if($checking_timing){
                    $update="denied";
                }
            }
            print_r('day 1 2nd shift-'.$update.'<br>');
            // day 1 3rd shift job possition update
            $row=explode('&',$data['vars']['day1_shift3_row'.$i]);
            $machine=$machines[$i];
            $row =array_filter(preg_replace("/[^0-9]+/", "", $row ));
            if(count($row)>0){
                $checking_timing=$this->dashboard_model->checking_timing($row);
                if($checking_timing){
                    $update="denied";
                }
            }
            print_r('day 1 3rd shift-'.$update.'<br>');
            // day 2 job possition update
            $row=explode('&',$data['vars']['day2_shift1_row'.$i]);
            $machine=$machines[$i];
            $row =array_filter(preg_replace("/[^0-9]+/", "", $row ));
            if(count($row)>0){
                $checking_timing=$this->dashboard_model->checking_timing($row);
                if($checking_timing){
                    $update="denied";
                }
            }
            print_r('day 2 job -'.$update.'<br>');
            // day 3 job possition update
            $row=explode('&',$data['vars']['day3_shift1_row'.$i]);
            $machine=$machines[$i];
            $row =array_filter(preg_replace("/[^0-9]+/", "", $row ));
            if(count($row)>0){
                $checking_timing=$this->dashboard_model->checking_timing($row);
                if($checking_timing){
                    $update="denied";
                }
            }
        }
        print_r('day 3 job-'.$update.'<br>');
        if($update=="allowed"){
        for ($i=1; $i <= count($machines); $i++) {
            // day 1 1st shift job possition update
            $row=explode('&',$data['vars']['day1_shift1_row'.$i]);
            $machine=$machines[$i];
            //$row =array_filter(preg_replace("/[^0-9]+/", "", $row ));
            $row = preg_replace("/[^0-9]+/", "", $row );
            if(count($row) > 0){
                if(count($row) > 2){
                foreach ($row as $key => $value) {
                $cur_key =$key ;
                    if($value != 0){
                       if($key != 0){
                        $old_key=$cur_key-1;
                        $old_pos=$row[$old_key];
                        if($old_pos!=0){
                            $cur_pos=$row[$cur_key];//print_r($old_pos);exit;
                            $oldjob_details = $this->dashboard_model->get_job_details($old_pos);
                            $curjob_details = $this->dashboard_model->get_job_details($cur_pos);
                            if(!empty($oldjob_details)){
                                 $datetime1 = new DateTime($curjob_details['date_from'].' '.$curjob_details['time_from']);
                                 $datetime2 = new DateTime($curjob_details['date_to'].' '.$curjob_details['time_to']);
                                 $interval = $datetime1->diff($datetime2);
                                 $diffhour = $interval->format('%h');
                                 $diffmin = $interval->format('%i');
                                 $pos['time_from'] = $oldjob_details['time_to'];
                                 $startTime = new DateTime($oldjob_details['time_to']);
                                 $startTime->modify('+'.$diffhour.' hours');
                                 $startTime->modify('+'.$diffmin.' minutes');
                                 $pos['time_to'] = $startTime->format('H:i:s');
                                 $pos['machine']=$machines[$i];
                                 $possition = $this->dashboard_model->change_job_position($value,$pos);
                            }
                        }
                       }else{
                           if(count(array_filter($row))==1){
                               //print_r($value);
                               $job_details = $this->dashboard_model->get_job_details($value);
                               $datetime1 = new DateTime($job_details ['date_from'].' '.$job_details ['time_from']);
                           $datetime2 = new DateTime($job_details ['date_to'].' '.$job_details ['time_to']);
                           $interval = $datetime1->diff($datetime2);
                           $diffhour = $interval->format('%h');
                           $diffmin = $interval->format('%i');
                           $cur_time = date('Y-m-d H:i:s');
                               $check_time_from = date('Y-m-d').' 07:00:00';
                               $check_time_to = date('Y-m-d').' 20:00:00';
                               if($cur_time < $check_time_from || $cur_time > $check_time_to ){
                                    $first['time_from'] = '07:00:00';
                                    $startTime = new DateTime($first['time_from']);
                                $startTime->modify('+'.$diffhour.' hours');
                                $startTime->modify('+'.$diffmin.' minutes');
                                $first['time_to'] = $startTime->format('H:i:s');
                               }else{
                                    $first['time_from'] = date('H:i:s');
                                    $startTime = new DateTime($first['time_from']);
                                $startTime->modify('+'.$diffhour.' hours');
                                $startTime->modify('+'.$diffmin.' minutes');
                             $first['time_to'] = $startTime->format('H:i:s');
                               }
                               $first['machine']=$machines[$i];
                               $possition = $this->dashboard_model->change_job_position($value,$first);
                           }else{
                               print_r($value);
                               $job_details = $this->dashboard_model->get_job_details($value);
                               $datetime1 = new DateTime($job_details ['date_from'].' '.$job_details ['time_from']);
                           $datetime2 = new DateTime($job_details ['date_to'].' '.$job_details ['time_to']);
                           $interval = $datetime1->diff($datetime2);
                           $diffhour = $interval->format('%h');
                           $diffmin = $interval->format('%i');
                           $cur_time = date('Y-m-d H:i:s');
                               $check_time_from = date('Y-m-d').' 07:00:00';
                               $check_time_to = date('Y-m-d').' 20:00:00';
                               if($cur_time < $check_time_from || $cur_time > $check_time_to ){
                                    $first['time_from'] = '07:00:00';
                                    $startTime = new DateTime($first['time_from']);
                                $startTime->modify('+'.$diffhour.' hours');
                                $startTime->modify('+'.$diffmin.' minutes');
                                $first['time_to'] = $startTime->format('H:i:s');
                               }else{
                                    $first['time_from'] = date('H:i:s');
                                    $startTime = new DateTime($first['time_from']);
                                $startTime->modify('+'.$diffhour.' hours');
                                $startTime->modify('+'.$diffmin.' minutes');
                             $first['time_to'] = $startTime->format('H:i:s');
                               }
                               $first['machine']=$machines[$i];
                               $possition = $this->dashboard_model->change_job_position($value,$first);
                           }
                       }
                    }
                }
                }elseif(count($row) == 2){
                    //print_r($row);
                    $job = array_filter($row);
                    $cur_time = date('Y-m-d H:i:s');
                    $oldjob_details = $this->dashboard_model->get_job_details($job[0]);
                    $datetime1 = new DateTime($oldjob_details['date_from'].' '.$oldjob_details['time_from']);
                $datetime2 = new DateTime($oldjob_details['date_to'].' '.$oldjob_details['time_to']);
                $interval = $datetime1->diff($datetime2);
                $diffhour = $interval->format('%h');
                $diffmin = $interval->format('%i');
                    $check_time_from = date('Y-m-d').' 07:00:00';
                    $check_time_to = date('Y-m-d').' 20:00:00';
                    if($cur_time < $check_time_from || $cur_time > $check_time_to){
                        $first['time_from'] = '07:00:00';
                        $startTime = new DateTime($first['time_from']);
                        $startTime->modify('+'.$diffhour.' hours');
                        $startTime->modify('+'.$diffmin.' minutes');
                        $first['time_to'] = $startTime->format('H:i:s');
                    }else{
                        $first['time_from'] = date('H:i:s');
                        $startTime = new DateTime($first['time_from']);
                    $startTime->modify('+'.$diffhour.' hours');
                    $startTime->modify('+'.$diffmin.' minutes');
                    $first['time_to'] = $startTime->format('H:i:s');
                    }
                    $first['machine']=$machines[$i];
                    $possition = $this->dashboard_model->change_job_position($job[0],$first);
                    //print_r($first);print_r($job);print_r($oldjob_details );exit;
                }
            }
            // day 1 2nd shift job possition update
            $row=explode('&',$data['vars']['day1_shift2_row'.$i]);
            $machine=$machines[$i];
            $row = preg_replace("/[^0-9]+/", "", $row );
            if(count($row)>0){
                foreach ($row as $key => $value) {
                    $cur_key =$key ;
                    if($value != 0){
                       if($key != 0){
                        $old_key=$cur_key-1;
                        $old_pos=$row[$old_key];
                        $cur_pos=$row[$cur_key];//print_r($old_pos);exit;
                         $oldjob_details = $this->dashboard_model->get_job_details($old_pos);
                         $curjob_details = $this->dashboard_model->get_job_details($cur_pos);
                        if(!empty($oldjob_details)){
                             $datetime1 = new DateTime($curjob_details['date_from'].' '.$curjob_details['time_from']);
                             $datetime2 = new DateTime($curjob_details['date_to'].' '.$curjob_details['time_to']);
                             $interval = $datetime1->diff($datetime2);
                             $diffhour = $interval->format('%h');
                             $diffmin = $interval->format('%i');
                             $pos['time_from'] = $oldjob_details['time_to'];
                             $startTime = new DateTime($oldjob_details['time_to']);
                             $startTime->modify('+'.$diffhour.' hours');
                             $startTime->modify('+'.$diffmin.' minutes');
                             $pos['time_to'] = $startTime->format('H:i:s');
                             $pos['machine']=$machines[$i];
                             $possition = $this->dashboard_model->change_job_position($value,$pos);
                        }
                       }
                    }
                }
            }
            // day 1 3rd shift job possition update
            $row=explode('&',$data['vars']['day1_shift3_row'.$i]);
            $machine=$machines[$i];
            $row = preg_replace("/[^0-9]+/", "", $row );
            if(count($row)>0){
                foreach ($row as $key => $value) {
                    $cur_key =$key ;
                    if($value != 0){
                       if($key != 0){
                        $old_key=$cur_key-1;
                        $old_pos=$row[$old_key];
                        $cur_pos=$row[$cur_key];//print_r($old_pos);exit;
                         $oldjob_details = $this->dashboard_model->get_job_details($old_pos);
                         $curjob_details = $this->dashboard_model->get_job_details($cur_pos);
                        if(!empty($oldjob_details)){
                             $datetime1 = new DateTime($curjob_details['date_from'].' '.$curjob_details['time_from']);
                             $datetime2 = new DateTime($curjob_details['date_to'].' '.$curjob_details['time_to']);
                             $interval = $datetime1->diff($datetime2);
                             $diffhour = $interval->format('%h');
                             $diffmin = $interval->format('%i');
                             $pos['time_from'] = $oldjob_details['time_to'];
                             $startTime = new DateTime($oldjob_details['time_to']);
                             $startTime->modify('+'.$diffhour.' hours');
                             $startTime->modify('+'.$diffmin.' minutes');
                             $pos['time_to'] = $startTime->format('H:i:s');
                             $pos['machine']=$machines[$i];
                             $possition = $this->dashboard_model->change_job_position($value,$pos);
                        }
                       }
                    }
                }
            }
            // day 2 job possition update
            $row=explode('&',$data['vars']['day2_shift1_row'.$i]);
            $machine=$machines[$i];
            $row = preg_replace("/[^0-9]+/", "", $row );
            if(count($row)>0){
                foreach ($row as $key => $value) {
                    $cur_key =$key ;
                    if($value != 0){
                       if($key != 0){
                        $old_key=$cur_key-1;
                        $old_pos=$row[$old_key];
                        $cur_pos=$row[$cur_key];//print_r($old_pos);exit;
                         $oldjob_details = $this->dashboard_model->get_job_details($old_pos);
                         $curjob_details = $this->dashboard_model->get_job_details($cur_pos);
                        if(!empty($oldjob_details)){
                             $datetime1 = new DateTime($curjob_details['date_from'].' '.$curjob_details['time_from']);
                             $datetime2 = new DateTime($curjob_details['date_to'].' '.$curjob_details['time_to']);
                             $interval = $datetime1->diff($datetime2);
                             $diffhour = $interval->format('%h');
                             $diffmin = $interval->format('%i');
                             $pos['time_from'] = $oldjob_details['time_to'];
                             $startTime = new DateTime($oldjob_details['time_to']);
                             $startTime->modify('+'.$diffhour.' hours');
                             $startTime->modify('+'.$diffmin.' minutes');
                             $pos['time_to'] = $startTime->format('H:i:s');
                             $pos['machine']=$machines[$i];
                             $possition = $this->dashboard_model->change_job_position($value,$pos);
                        }
                       }
                    }
                }
            }
            // day 3 job possition update
            $row=explode('&',$data['vars']['day3_shift1_row'.$i]);
            $machine=$machines[$i];
            $row = preg_replace("/[^0-9]+/", "", $row );
            if(count($row)>0){
                foreach ($row as $key => $value) {
                     $cur_key =$key ;
                    if($value != 0){
                       if($key != 0){
                        $old_key=$cur_key-1;
                        $old_pos=$row[$old_key];
                        $cur_pos=$row[$cur_key];//print_r($old_pos);exit;
                         $oldjob_details = $this->dashboard_model->get_job_details($old_pos);
                         $curjob_details = $this->dashboard_model->get_job_details($cur_pos);
                        if(!empty($oldjob_details)){
                             $datetime1 = new DateTime($curjob_details['date_from'].' '.$curjob_details['time_from']);
                             $datetime2 = new DateTime($curjob_details['date_to'].' '.$curjob_details['time_to']);
                             $interval = $datetime1->diff($datetime2);
                             $diffhour = $interval->format('%h');
                             $diffmin = $interval->format('%i');
                             $pos['time_from'] = $oldjob_details['time_to'];
                             $startTime = new DateTime($oldjob_details['time_to']);
                             $startTime->modify('+'.$diffhour.' hours');
                             $startTime->modify('+'.$diffmin.' minutes');
                             $pos['time_to'] = $startTime->format('H:i:s');
                             $pos['machine']=$machines[$i];
                             $possition = $this->dashboard_model->change_job_position($value,$pos);
                        }
                       }
                    }
                }
            }
        }
        }
    }
    /*public function reposition_new(){
        header('Access-Control-Allow-Origin: *');
        echo "<pre>";
        $data=$_POST;
        $no_machines = $data['no_machine'];
        $machines = array_filter(explode(',',$data['machines']));
        $update="allowed";
        $todaydate=date('Y-m-d');
        $tomorrowdate=date('Y-m-d', strtotime(' +1 day'));
        $dayaftertomorrow=date('Y-m-d', strtotime(' +2 day'));
        for ($i=1; $i <= count($machines); $i++) {
            // day 1 1st shift job possition update
            $row=explode('&',$data['vars']['day1_shift1_row'.$i]);
            $machine=$machines[$i];
            $row =array_filter(preg_replace("/[^0-9]+/", "", $row ));
            if(count($row)>0){
                $checking_timing=$this->dashboard_model->checking_timing($row);
                if($checking_timing){
                    $update="denied";
                }
            }
            print_r('day 1 1st shift-'.$update.'<br>');
            // day 1 2nd shift job possition update
            $row=explode('&',$data['vars']['day1_shift2_row'.$i]);
            $machine=$machines[$i];
            $row =array_filter(preg_replace("/[^0-9]+/", "", $row ));
            if(count($row)>0){
                $checking_timing=$this->dashboard_model->checking_timing($row);
                if($checking_timing){
                    $update="denied";
                }
            }
            print_r('day 1 2nd shift-'.$update.'<br>');
            // day 1 3rd shift job possition update
            $row=explode('&',$data['vars']['day1_shift3_row'.$i]);
            $machine=$machines[$i];
            $row =array_filter(preg_replace("/[^0-9]+/", "", $row ));
            if(count($row)>0){
                $checking_timing=$this->dashboard_model->checking_timing($row);
                if($checking_timing){
                    $update="denied";
                }
            }
            print_r('day 1 3rd shift-'.$update.'<br>');
            // day 2 job possition update
            $row=explode('&',$data['vars']['day2_shift1_row'.$i]);
            $machine=$machines[$i];
            $row =array_filter(preg_replace("/[^0-9]+/", "", $row ));
            if(count($row)>0){
                $checking_timing=$this->dashboard_model->checking_timing($row);
                if($checking_timing){
                    $update="denied";
                }
            }
            print_r('day 2 job -'.$update.'<br>');
            // day 3 job possition update
            $row=explode('&',$data['vars']['day3_shift1_row'.$i]);
            $machine=$machines[$i];
            $row =array_filter(preg_replace("/[^0-9]+/", "", $row ));
            if(count($row)>0){
                $checking_timing=$this->dashboard_model->checking_timing($row);
                if($checking_timing){
                    $update="denied";
                }
            }
        }
        print_r('day 3 job-'.$update.'<br>');
        if($update=="allowed"){
        for ($i=1; $i <= count($machines); $i++) {
            // day 1 1st shift job possition update
            $row=explode('&',$data['vars']['day1_shift1_row'.$i]);
            $machine=$machines[$i];
            $row =array_filter(preg_replace("/[^0-9]+/", "", $row ));
            if(count($row)>0){
                foreach ($row as $key => $value) {
                    $pos['position']=$key+1;
                    $pos['machine']=$machines[$i];
                    $possition = $this->dashboard_model->change_job_position($value,$pos);
                }
            }
            // day 1 2nd shift job possition update
            $row=explode('&',$data['vars']['day1_shift2_row'.$i]);
            $machine=$machines[$i];
            $row =array_filter(preg_replace("/[^0-9]+/", "", $row ));
            if(count($row)>0){
                foreach ($row as $key => $value) {
                    $pos['position']=$key+1;
                    $pos['machine']=$machines[$i];
                    $possition = $this->dashboard_model->change_job_position($value,$pos);
                }
            }
            // day 1 3rd shift job possition update
            $row=explode('&',$data['vars']['day1_shift3_row'.$i]);
            $machine=$machines[$i];
            $row =array_filter(preg_replace("/[^0-9]+/", "", $row ));
            if(count($row)>0){
                foreach ($row as $key => $value) {
                    $pos['position']=$key+1;
                    $pos['machine']=$machines[$i];
                    $possition = $this->dashboard_model->change_job_position($value,$pos);
                }
            }
            // day 2 job possition update
            $row=explode('&',$data['vars']['day2_shift1_row'.$i]);
            $machine=$machines[$i];
            $row =array_filter(preg_replace("/[^0-9]+/", "", $row ));
            if(count($row)>0){
                foreach ($row as $key => $value) {
                    $pos['position']=$key+1;
                    $pos['machine']=$machines[$i];
                    $possition = $this->dashboard_model->change_job_position($value,$pos);
                }
            }
            // day 3 job possition update
            $row=explode('&',$data['vars']['day3_shift1_row'.$i]);
            $machine=$machines[$i];
            $row =array_filter(preg_replace("/[^0-9]+/", "", $row ));
            if(count($row)>0){
                foreach ($row as $key => $value) {
                    $pos['position']=$key+1;
                    $pos['machine']=$machines[$i];
                    $possition = $this->dashboard_model->change_job_position($value,$pos);
                }
            }
        }
        }
    }*/
    public function get_time_difference(){
        header('Access-Control-Allow-Origin: *');
        $time_from = date('Y-m-d H:i:s',strtotime($this->input->post('time_from')));
        $time_to = date('Y-m-d H:i:s',strtotime($this->input->post('time_to')));
        $job_from = date('Y-m-d').' 07:00:00';
        $job_to = date('Y-m-d').' 20:00:00';
        if(($time_from < $job_from)||($job_to < $time_to)){
            echo json_encode(array('result' =>'failure' ,'message'=>'Please check time with shift time' ));
        }elseif($time_from > $time_to ){
            echo json_encode(array('result' =>'failure' ,'message'=>'From time greater than to time' ));
        }elseif($time_from == $time_to ){
            echo json_encode(array('result' =>'failure' ,'message'=>'From time and to time same' ));
        }else{
            $datetime1 = new DateTime($time_from);
            $datetime2 = new DateTime($time_to);
            $interval = $datetime1->diff($datetime2);
            $diffhour = $interval->format('%h:%i');
            echo json_encode(array('result' =>'success' ,'timediff'=>$diffhour ));
        }
    }
    public function get_jobs(){
        header('Access-Control-Allow-Origin: *');
        $data['date'] = date('Y-m-d',strtotime($this->input->post('editjob_date')));
        $data['shift'] = $this->input->post('editjob_shift');
        $data['machine'] = $this->input->post('editjob_machine');
        $get_jobs = $this->dashboard_model->get_jobs($data['date'],$data['machine'],$data['shift']);
        $jobs = array();
        foreach ($get_jobs as $key => $job) {
            //date('Y-m-d H:i:s');
            if( ($job['job_complete_status'] < 1) && ($job['mc_down'] != 1) && ($job['other_down'] != 1) && ($job['setup'] == 0) && ($job['maintenance'] != 1) && ($job['idle'] != 1) ){
                $job['datetimefrom'] = $job['date_from'].' '.$job['time_from'];
                $jobs[]=$job;
            }
        }
        usort($jobs, 'sortBydatetimefrom');  
        $edit_job = "";
        if(count($jobs) > 0){
            $dateids = "";
            foreach ($jobs as $key => $job) {
                $dateids.=',#editjob_sort_date'.$key;
                $edit_job.='<li class="dd-item dd3-item" data-id="'.$job['id'].'" data-code = "'.$job['job_code'].'">
                    <div class="dd-handle  dd3-handle">Drag</div>
                    <div class=" code_job dd3-content">
                            <div class="col-sm-8 col-lg-3 col-xs-7 color_code">
                               <label class="green">'.$job['job_code'].'</label>
                            </div>
                            <form  class="editjob_sort">
                            <input type="hidden" name="editjob_sort_jobcode'.$key.'" id="editjob_sort_jobcode'.$key.'" value="'.$job['job_code'].'" >
                            <input type="hidden" name="editjob_sort_jobid'.$key.'" id="editjob_sort_jobid'.$key.'" value="'.$job['id'].'" >
                            <div class="col-sm-8 col-lg-2 col-xs-7 ">
                                <input readonly type="text" class="editjob_jobshiftdate editjob_sort_date'.$key.'" name="editjob_sort_date'.$key.'" data-id="'.$key.'" id="editjob_sort_date'.$key.'" value="'.date("m/d/Y",strtotime($job['date_from'])).'">
                            </div>
                            <div class="col-sm-8 col-lg-2 col-xs-7">
                                <select name="editjob_jobshift editjob_sort_shift'.$key.'" data-id="'.$key.'" class="shiftdate"  id="editjob_sort_shift'.$key.'">'.get_shifts($job['date_from'],$job['shift']).'</select>
                            </div>
                           
                            <div class="col-sm-8 col-lg-2 col-xs-7">
                                <select name="editjob_sort_machine'.$key.'" data-code="'.$job['job_code'].'" data-id="'.$key.'" class="editjob_jobmachine shiftdate" id="editjob_sort_machine'.$key.'" data-mc = "'.$job['machine'].'">'.get_machine($job['machine']).'</select>
                            </div>
                             <div class="col-sm-8 col-lg-1 col-xs-7">
                                     <label>Qty</label>
                            </div>

                             <div class="col-sm-8 col-lg-2 col-xs-7">
                                <input readonly name="running_qty" id="editjob_sort_qty'.$key.'" type="text" data-id="'.$key.'" class="editjob_jobqty time_control addjob_timefrom quantity" name="addjob_slot_from" value="'.$job['qty'].'">
                            </div>
                            
                            <div class="time_all row">
                                <div class="date add_job">
                                    <label class="col-lg-2 form_date">TIME<span style="float: right; text-align: right; margin-right:5px">:</span></label>
                                    <div class="col-lg-3 clock_input_filed">
                                        <div class="input-group bootstrap-timepicker timepicker">
                                            <input readonly name="editjob_timefrom'.$key.'" id="editjob_timefrom'.$key.'" type="text" class="time_control editjob_timefrom'.$key.'" name="addjob_slot_from" value="'.date("h:i A",strtotime($job['time_from'])).'" >
                                            <span class="input-group-addon">
                                                <i class="fa fa-clock-o" aria-hidden="true"></i>
                                            </span>
                                        </div>
                                    </div>
                                    <label class="col-lg-2 to_date">TO<span style="float: right; text-align: right; margin-right:5px">:</span></label>
                                    <div class="col-sm-8 col-lg-3 col-xs-7 clock_input_filed">
                                        <div class="input-group bootstrap-timepicker timepicker">
                                            <input readonly name="editjob_timeto'.$key.'" id="editjob_timeto'.$key.'" type="text" class="time_control editjob_timeto'.$key.'"  value="'.date("h:i A",strtotime($job['time_to'])).'">
                                            <span class="input-group-addon">
                                                <i class="fa fa-clock-o" aria-hidden="true"></i>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-sm-8 col-lg-2 col-xs-7">
                                        <input readonly name="running_time" id="editjob_sort_running_time'.$key.'" type="text" data-id="'.$key.'" class="editjob_jobrunningtime time_control addjob_timefrom running_time" name="addjob_slot_from" value="'.gettimediff($job['time_from'] , $job['time_to']).'">
                                    </div>
                                    <!--<div class="col-lg-2 shift_add">
                                        <button type="submit" data-id="'.$key.'" class="button_submit editjob_update'.$key.' editjob_update" style="display:block">Save</button>
                                    </div>-->
                                </div>
                            </div>
                        </form>
                    </div>
                </li>';
            }
            $dateids = implode(',',array_filter(explode(',',$dateids)));
        $result = array('result' => 'success', 'message' => 'Jobs found ', 'data' => $edit_job , 'dateids' => $dateids );
        }else{
            $result = array('result' => 'failed', 'message' => 'No jobs Found', 'data' => $edit_job );
        }
        echo json_encode($result);
    }
    /*function rearrange(){
        $data['id'] = $_POST['data'];
        $data['date'] = $_POST['date'];
        $data['shift'] = $_POST['shift'];
        $data['machine'] = $_POST['machine'];
        $ids = array_column($data['id'], 'id');
        unset($data['id']);
        if(count($ids) > 1){
            $jobs = array();
            foreach ($ids as $key => $value) {
                $jobs[] = $this->dashboard_model->get_job_details($value);
            }
            $jobsbeforesort = $jobs;
            usort($jobs, 'sortBytime_from');
            $startTime = $jobs[0]['time_from'];
            foreach ($jobsbeforesort as $key => $job) {
                $jobId = $job['id'];
                unset($job['id']);
                $datetime1 = new DateTime($job ['date_from'].' '.$job ['time_from']);
                $datetime2 = new DateTime($job ['date_to'].' '.$job ['time_to']);
                $interval = $datetime1->diff($datetime2);
                $diffhour = $interval->format('%h');
                $diffmin = $interval->format('%i');
                $job['time_from'] = $startTime;
                $jobBegin = new DateTime($job['time_from']);
                $jobBegin->modify('+'.$diffhour.' hours');
                $jobBegin->modify('+'.$diffmin.' minutes');
                $job['time_to'] = $jobBegin->format('H:i:s');
                $startTime = $job['time_to'];
                $this->dashboard_model->update_jobs($jobId,$job);
            }
            $result = array('result' =>'success' , 'message' => 'Successfully Updated' );
        }else{
            $result = array('result' =>'failed' , 'message' => 'only one job available unable to arrange' );
        }
        echo json_encode($result);
    }*/
    
     function rearrange(){
        $today_shift_end_time = date('Y-m-d 22:00:00'); 
        $today_current_time = date('Y-m-d H:i:s');
        $today = date('Y-m-d');
        if(strtotime($today_shift_end_time)>strtotime($today_current_time)){
            $first_job_from_date = date('Y-m-d');
        }else{
            $first_job_from_date = date('Y-m-d', strtotime($today.' +1 day'));
        }
        
    	
    	$machine_id          = $_POST['machine'];
    	$shift 		         = $_POST['shift'];
        $data['id'] = $_POST['data'];
    	$data['shift'] = $_POST['shift'];
    	$data['machine'] = $_POST['machine'];
        $ids = array_column($data['id'], 'id');
    	
    	$push_array = array();
    	$out_array = array();
    
    	unset($data['id']);
            if(count($ids) > 1){
                $jobs = array();
                $dublicate = array();
                foreach ($ids as $key => $value) {
                        $jobs[] = $this->dashboard_model->get_job_details($value);
                }
    			$start_diffhours = 0;
    			$start_diffmins 	= 0;                
    			foreach ($jobs as $key => $job) {
                    if (!in_array($job['job_code'], $push_array)){
                        array_push($push_array,$job['job_code']);
                        $jobss[$key] = $job;
    				    $jobss[$key]['datetimefrom'] = $job['date_from'].' '.$job['time_from'];
                        $dublicate[$key]['dublicate_jobcode'] = $job['job_code'];
                        $dublicate[$key]['dublicate'] = 0;
                        $dublicate[$key]['dublicatetimefrom']   = $job['time_from'];
                        $dublicate[$key]['dublicatetimeto']     = $job['time_to'];
                        $dublicate[$key]['dublicatedate_from']  = $job['date_from'];    				    
                    }else{
                        $dublicate[$job['job_code']]['dublicate_jobcode'] = $job['job_code'];
                        $dublicate[$job['job_code']]['dublicate'] = 1;
                        $dublicate[$job['job_code']]['dublicatetimefrom']   = $job['time_from'];
                        $dublicate[$job['job_code']]['dublicatetimeto']     = $job['time_to'];
                        $dublicate[$job['job_code']]['dublicatedate_from']  = $job['date_from'];
                        
    					$this->db->where('id',$job['id']);
    					$this->db->delete(TBL_MCDOWN);                    
                    }				    
    			}            
            }
            $jobsbeforesort = $jobss;
            usort($jobss, 'sortBydatetimefrom');
            $first_job_from_time = $jobss[0]['time_from'];
           
            
    		foreach ($jobsbeforesort as $key => $job) {
    			$start_diffhour = 0;
    			$start_diffmin 	= 0;			
    			 $shift_end_time = '22:00:00';
        			 if(is_array($dublicate)){
        			     foreach($dublicate as $key=>$dublicate_val){
        			         if($job['job_code']==$key){
        			             
        			                if($dublicate_val['dublicate']==1){
                         				$datetime1 = new DateTime($dublicate_val['dublicatedate_from'].' '.$dublicate_val['dublicatetimefrom']);
                        				$datetime2 = new DateTime($dublicate_val['dublicatedate_from'].' '.$dublicate_val['dublicatetimeto']);
                        				$interval1 = $datetime1->diff($datetime2);
                        				$start_diffhour += $interval1->format('%h');
                        				$start_diffmin += $interval1->format('%i');          			                    
        			                }
        			            }
        			         
        			     }
        			 }
    				$datetime1 = new DateTime($job['date_from'].' '.$job['time_from']);
    				$datetime2 = new DateTime($job['date_from'].' '.$job['time_to']);
    				$interval1 = $datetime1->diff($datetime2);
    				$start_diffhour += $interval1->format('%h');
    				$start_diffmin += $interval1->format('%i'); 				 
    				 
    				$DiffTime = new DateTime($first_job_from_date.' '.$first_job_from_time);
    				$DiffTime->modify('+'.$start_diffhour.' hours');
    				$DiffTime->modify('+'.$start_diffmin.' minutes');
    				$job['time_from'] = $first_job_from_time;
    				$job['time_to'] = $DiffTime->format('H:i:00');
                    $job['date_from'] = $DiffTime->format('Y-m-d');
                    $job['date_to'] = $DiffTime->format('Y-m-d');;  				
    				$job['add_status'] = 0;
    				if(new DateTime($first_job_from_date.' '.$shift_end_time) < new DateTime($DiffTime->format('Y-m-d').' '.$job['time_to']) ){			
    				    
    				    $start_tothour = 0;
    				    $start_totmin = 0;
    				    $start_tothourminus =0;
    				    $start_totminminus =0;
    				    /* GET TOTAL TIMING */
    				    
            				$datetime1 = new DateTime($first_job_from_date.' '.$shift_end_time);
            				$datetime2 = new DateTime($DiffTime->format('Y-m-d').' '.$job['time_to']);
            				$intervaltot = $datetime1->diff($datetime2);
            				$start_tothour += $intervaltot->format('%h');
            				$start_totmin += $intervaltot->format('%i');     				    

    				     /* GET TOTAL TIMING */
    				    
    				    
    				    
                        $job['date_from'] = $first_job_from_date;
                        $job['date_to'] = $first_job_from_date;                 
                        $job['time_to'] = $shift_end_time;
    					$upjob[] = $job;
    					$first_job_from_date = date('Y-m-d', strtotime($first_job_from_date.' +1 day'));
                        $job['date_from'] = $first_job_from_date;
                        $job['date_to'] = $first_job_from_date; 	

    					$DiffTime = new DateTime($first_job_from_date.' 07:00:00');
        				$DiffTime->modify('+'.$start_tothour.' hours');
        				$DiffTime->modify('+'.$start_totmin.' minutes'); 
                        $job['time_from'] = '07:00:00';
                        $job['time_to'] = $DiffTime->format('H:i:00');
    					$job['add_status'] = 1;
    					$first_job_from_time = $job['time_to'];
    				}
    				$first_job_from_time = $job['time_to'];
    			    $upjob[] = $job;
    		    }
    		    $result = '';
    		    //echo "<pre>"; print_r($upjob); exit;
    		    $result = $this->dashboard_model->update_arrang_jobs($upjob);
    		    if($result){
        		    $result = array('result' =>'success' , 'message' => 'Successfully Updated' );
        		    echo json_encode($result);		        
    		    }else{
        		    $result = array('result' =>'failure' , 'message' => 'Successfully Updated' );
        		    echo json_encode($result);		        
    		    }
		    
        }    
    public function editjob_check(){
        header('Access-Control-Allow-Origin: *');
        //echo "<pre>";
        $jobId = $this->input->post('jobid');
        $data['date'] = date('Y-m-d',strtotime($this->input->post('job_date')));
        $data['id'] = $this->input->post('machine');
        $data['machine'] = $this->input->post('machine');
        $data['shift'] = $this->input->post('shift');
        $data['qty'] = $this->input->post('qty');
        $data['down_time'] = $this->input->post('down_time');
        $data['from_time'] = $this->input->post('from_time');
        $data['to_time'] = $this->input->post('to_time');
        
        $jobDetails=$this->dashboard_model->get_job_details($jobId);
        
        
	$editjob_update['date_from'] = $data['date'];
        $editjob_update['date_to'] = $data['date'];
        $editjob_update['shift'] = $data['shift'];
        $editjob_update['qty'] = $data['qty'];
        $editjob_update['time_from'] = date("H:i:s",strtotime($data['from_time']));
        $editjob_update['time_to'] = date("H:i:s",strtotime($data['to_time']));
        $editjob_update['machine'] = $data['id'];
        $editjob_update_status=$this->dashboard_model->update_jobs($jobId,$editjob_update);
        if($editjob_update_status){
        	echo json_encode(array('result' =>'success','message'=>'Job Moved.','machinedown'=>0,'job_start'=>$data['from_time'],'job_end'=>$data['to_time']));
        }else{
        	echo json_encode(array('result' =>'failed','message'=>'Job Edit Failed.','machinedown'=>0,'job_start'=>$data['from_time'],'job_end'=>$data['to_time']));
        }
                
                
       /* //print_r($data);
        $end_timing=$this->dashboard_model->get_lastjob_endtiming($data);
        $cur_time = date('Y-m-d H:i:s');
        //$shift_start_time = $data['date'].' 08:00:00';
        //$shift_end_time = $data['date'].' 20:00:00';
        
         $shifts_details = $this->shift_and_timings($data['date']);
        //echo "<pre>";print_r($shift_details);exit;
        foreach ($shifts_details as $key => $shift_details) {
            if($data['shift'] ==$shift_details['shift']){
                $shift_start_time = $shift_details['shift_start'];
                $shift_end_time = $shift_details['shift_end'];
            } 
        }
        if( ($shift_end_time < DEFAULT_SHIFT_START_TIME ) ){
            $shift_end_time = date('Y-m-d', strtotime($data['date'].' +1 day')).' '.$shift_end_time;
        }else{
            $shift_end_time = $data['date'].' '.$shift_end_time;
        }
        if(($shift_start_time < DEFAULT_SHIFT_START_TIME )){
            $shift_start_time = date('Y-m-d', strtotime($data['date'].' +1 day')).' '.$shift_start_time;
        }else{
            $shift_start_time = $data['date'].' '.$shift_start_time;
        }

       // echo "<pre>";print_r($shift_start_time.' '.$shift_end_time);exit;

        if($end_timing){ 
           if(new DateTime($cur_time) < new DateTime($end_timing) ){
                $end_timing = $end_timing;
            }else{
                $end_timing = $cur_time;
            }
        }else{
            if(new DateTime($cur_time) < new DateTime($shift_start_time) && new DateTime($cur_time) < new DateTime($shift_end_time)){
                $end_timing = $shift_start_time;
            }elseif(new DateTime($cur_time) > new DateTime($shift_start_time) && new DateTime($cur_time) < new DateTime($shift_end_time)){
                $end_timing = $cur_time;
            }else{
                $end_timing = $cur_time;
            }
        }
        $start_time = new DateTime($end_timing);
        $start_time->modify('+1 seconds');
        $end_timing = $start_time->format('Y-m-d H:i:s');
        //print_r($end_timing);exit;
        $jobDetails=$this->dashboard_model->get_job_details($jobId);
        //print_r($jobDetails);
        $datetime1 = new DateTime($jobDetails ['date_from'].' '.$jobDetails ['time_from']);
        $datetime2 = new DateTime($jobDetails ['date_to'].' '.$jobDetails ['time_to']);
        $interval = $datetime1->diff($datetime2);
        $diffhour = $interval->format('%h');
        $diffmin = $interval->format('%i');
        
        
        $explode_array = explode('.',$data['down_time']);
        //echo "<pre>";print_r($explode_array);exit;
        $job_end = new DateTime($end_timing);
        if(count($explode_array)==2){
        	$job_end->modify('+'.$explode_array[0].' hours');
        	$job_end->modify('+'.$explode_array[1].' minutes');
        }else{
        	$job_end->modify('+'.$explode_array[0].' minutes');
        }
        
        
        //$job_end = $job_end->format('H:i:s'); 

        $check_availability['date_from'] = date('Y-m-d',strtotime($end_timing));
        $check_availability['date_to'] = $job_end->format('Y-m-d');
        $check_availability['machine'] = $data['id'];
        $check_availability['shift'] = $data['shift'];
        $check_availability['time_from'] = date('H:i:s',strtotime($end_timing));
        $check_availability['time_to'] = $job_end->format('H:i:s');
        //print_r($check_availability);
        $job_on_time = $this->dashboard_model->check_job_availability($check_availability);
        //print_r($job_on_time);exit;
        if(new DateTime($job_end->format('Y-m-d').' '.$job_end->format('H:i:s')) <= new DateTime($shift_end_time) ){

           $job_start=date('h:i A',strtotime($end_timing));
           $job_end = $job_end->format('h:i A'); 
            if($job_on_time['job']==0){
                $editjob_update['date_from'] = $data['date'];
                $editjob_update['date_to'] = $data['date'];
                $editjob_update['shift'] = $data['shift'];
                $editjob_update['qty'] = $data['qty'];
                $editjob_update['time_from'] = $check_availability['time_from'];
                $editjob_update['time_to'] = $check_availability['time_to'];
                $editjob_update['machine'] = $data['id'];
                $editjob_update_status=$this->dashboard_model->update_jobs($jobId,$editjob_update);
                echo json_encode(array('result' =>'success','message'=>'Job Moved.','machinedown'=>0,'job_start'=>$job_start,'job_end'=>$job_end));
            }else{
                if($job_on_time['mcdown']==1){
                    echo json_encode(array('result' =>'failure','message'=>'Machine Down on this time','machinedown'=>1,'machine'=>$data['machine'],'job_start'=>$job_start,'job_end'=>$job_end));
                }else{
                    echo json_encode(array('result' =>'failure','message'=>'Job on this time','machinedown'=>0,'machine'=>$data['machine'],'job_start'=>$job_start,'job_end'=>$job_end));
                }
            }
        }else{
            $job_start=date('h:i A',strtotime($end_timing));
           $job_end = $job_end->format('h:i A');
            if($job_on_time['mcdown']==1){
                echo json_encode(array('result' =>'failure','message'=>'machine down please select another machine','machinedown'=>1,'same'=>1,'job_start'=>$job_start,'job_end'=>$job_end));
            }else{
                echo json_encode(array('result' =>'failure','message'=>'Job time more than shift time, please assign to another shift or day','machinedown'=>0,'same'=>1,'job_start'=>$job_start,'job_end'=>$job_end));
            }
        }*/
    }
    public function machine_rearrange(){
        header('Access-Control-Allow-Origin: *');
        $data['id'] = $_POST['data'];
        $ids = array_column($data['id'], 'id');
        if(count($ids) > 1){
            foreach ($ids as $key => $value) {
                $pos = $key+1;
                $pos_status= $this->dashboard_model->update_machine_pos($value,$pos);
            }
            $result = array('result' =>'success' , 'message' => 'Successfully Updated' );
        }else{
            $result = array('result' =>'failed' , 'message' => 'only one job available unable to arrange' );
        }
        echo json_encode($result);
    }
    public function user_management(){
        header('Access-Control-Allow-Origin: *');
        $requestData= $_REQUEST;
        $users=$this->dashboard_model->get_users($requestData);
        echo json_encode($users);
    }
/**
*
*
*
*/
    public function get_reasons(){
        header('Access-Control-Allow-Origin: *');
        $reasons = $this->dashboard_model->get_reasons();
        $data = array();
                $data['M/C DOWN'] = 0;
        foreach ($reasons as $key => $value) {
            $data[$value['reason']]=$value['id'];
        }
        echo json_encode($data);
    }
    public function addreason(){
        header('Access-Control-Allow-Origin: *');
        $addreason_id=$this->input->post('addreason_id');
        if($addreason_id==0){
            $data['reason']=$this->input->post('addreason_reason');
            $data['created_on']=date("Y-m-d H:i:s");
            $data['status']=1;
            $addreason=$this->dashboard_model->insert_reason($data);
            if($addreason){
                echo json_encode(array('result' =>'success','message'=>'New Reason Creation Successfully','reason_id'=>$addreason,'reason_name'=>$data['reason'],'task'=>'insert'));
            }else{
                echo json_encode(array('result' =>'failure','message'=>'New Reason Creation Failed'));
            }
        }else{
            $data['reason']=$this->input->post('addreason_reason');
            $data['updated_on']=date("Y-m-d H:i:s");
            $data['status']=1;
            $updatereason=$this->dashboard_model->update_reason($data,$addreason_id);
            if($updatereason){
                echo json_encode(array('result' =>'success','message'=>'Reason Details Successfully Updated','task'=>'update'));
            }else{
                echo json_encode(array('result' =>'failure','message'=>'Reason Details Update Failed'));
            }
        }
    }
    public function get_reason_details(){
        header('Access-Control-Allow-Origin: *');
        $reason_id=$this->input->post('reason_id');
        $reason_details=$this->dashboard_model->get_reason_details($reason_id);
        if(!empty($reason_details)){
            echo json_encode(array('result' =>'success','id'=>$reason_details['id'],'addreason_reason'=>$reason_details['reason']));
        }else{
            echo json_encode(array('result' =>'failure','message'=>'Reason Details Reterival Failed','reason_id'=>$reason_id));
        }
    }
    public function delete_reason(){
        header('Access-Control-Allow-Origin: *');
        $reason_id=$this->input->post('reason_id');
        $data['status'] = 0;
        $reason_details=$this->dashboard_model->update_reason($data,$reason_id);
        if(!empty($reason_details)){
            echo json_encode(array('result' =>'success','message' =>'Reason deleted Successfully','reason_id'=>$reason_id));
        }else{
            echo json_encode(array('result' =>'failure','message'=>'Reason Deletion Failed','reason_id'=>$reason_id));
        }
    }
    public function reason_rearrange(){
        header('Access-Control-Allow-Origin: *');
        $data['id'] = $_POST['data'];
        $ids = array_column($data['id'], 'id');
        if(count($ids) > 1){
            foreach ($ids as $key => $value) {
                $pos = $key+1;
                $pos_status= $this->dashboard_model->update_reason_pos($value,$pos);
            }
            $result = array('result' =>'success' , 'message' => 'Successfully Updated' );
        }else{
            $result = array('result' =>'failed' , 'message' => 'only one reason available unable to arrange' );
        }
        echo json_encode($result);
    }
    public function get_spcs_jobdetails(){
        header('Access-Control-Allow-Origin: *');
        $job_code=$this->input->post('job_code');
        $job_details = $this->dashboard_model->get_jobdetails_jobcode($job_code);
        if($job_details){
            
             $duration['time_from'] = date('h:i A',strtotime($job_details['time_from']));
             $duration['time_to'] = date('h:i A',strtotime($job_details['time_to']));
             
             $duration['date_from'] = date('m/d/Y',strtotime($job_details['date_from']));
             
			 $datetime1 = new DateTime($duration['date_from'].' '.$duration['time_from']);
			 $datetime2 = new DateTime($duration['date_from'].' '.$duration['time_to']);
			 $interval1 = $datetime1->diff($datetime2);
			 $down = $interval1->format('%h').'.'.$interval1->format('%i');
					 
            $result = array('result' =>'success' , 'message' => 'Job Details Found' ,'data'=>array('date' => date('m/d/Y',strtotime($job_details['date_from'])),'time_from'=>date('h:i A',strtotime($job_details['time_from'])),'time_to'=>date('h:i A',strtotime($job_details['time_to'])),'machine'=>$job_details['machine'],'duration'=>$job_details['down_time'],'shift'=>$job_details['shift'],'qty'=>$job_details['qty'],'side'=>$job_details['side'],'down_time'=>$down,'need_cutter'=>$job_details['need_cutter']));
        }else{
            $result = array('result' =>'failed' , 'message' => 'Job Details Not Found' );
        }
        echo json_encode($result);
    }
    
    public function add_cftmember(){
        $data = $this->input->post();
        if($data['cftmemberid'] == 0){
            unset($data['cftmemberid']);
            $data['status'] = 1;
            $cft_operation = $this->dashboard_model->insert_cft_members($data);
            $operation = "INSERT";
        }else{
            $cft_operation = $this->dashboard_model->update_cft_members($data);
            $operation = "UPDATE";
        }
        
        if($cft_operation){
            $result = array('result' =>'success' , 'message' => 'CTF MEMBER '.$operation.' SUCCESS');
        }else{
            $result = array('result' =>'failed' , 'message' => 'CTF MEMBER '.$operation.' FAILED');
        }
        echo json_encode($result);

    }
    public function get_ctfmembers(){
        $ctfmembers = $this->dashboard_model->get_cft_members();
        foreach($ctfmembers as $key => $ctfmember){
            $ctfmembers[$key]['phone'] = formatPhoneNumber($ctfmember['phone']);
        }
        if($ctfmembers){
            $result = array('result' =>'success' , 'members' => $ctfmembers );
        }else{
            $result = array('result' =>'failed' , 'message' => ' Active CFT Members Not Found');
        }
        echo json_encode($result);
    }
    public function insert_cft_report(){
        $data = $this->input->post();
        
        $data['machine'] = implode(',',$data['machine']);
        $data['reason'] = implode(',',$data['reason']);
        $data['user'] = implode(',',$data['user']);
        $data['created_on'] = date('Y-m-d H:i:s');
        $data['status'] = 1;
        //echo "<pre>";print_r($data);exit;
        $insert = $this->dashboard_model->insert_cft_report($data);
        if($insert){
            $result = array('result' =>'success' , 'message' =>'New Report Added Successfully');
        }else{
            $result = array('result' =>'failed' , 'message' => 'New Report Adding Failed');

        }
        echo json_encode($result);
    }

    public function get_cft_report_list(){
        $cft_reports = $this->dashboard_model->get_cft_reports();
        $report = "";
        if($cft_reports){
            foreach($cft_reports as $key => $cft_report ){

                $machine_array = explode(',',$cft_report['machine']);
                $machines = "";
                foreach($machine_array as $key => $machine){
                    $machines .= $this->dashboard_model->get_machine_name($machine)."<br/>";
                }

                $user_array = explode(',',$cft_report['user']);
                $users= "";
                $numbers= "";
                foreach($user_array as $key => $user){
                    $users .= $this->dashboard_model->get_user_name($user)."<br/>";
                    $numbers .= formatPhoneNumber($this->dashboard_model->get_user_number($user))."<br/>";
                }
                $reason_array = explode(',',$cft_report['reason']);
                $resons = "";
                foreach($reason_array as $key => $reason){
                    $resons .= $reason."<br/>";
                }
                $url = base_url('dashboard/delete_sms_report/'.$cft_report['id']);

                $report .= '<tr class="delete_sms_report_'.$cft_report['id'].'">
                                 <td>'.$resons.'</td>
                                 <td>'.$cft_report['timing'].'</td>
                                 <td class="cnc_number">'.$machines.'</td>
                                 <td>'.$users.'</span> </td>
                                 <td>'.$numbers.'</td>
                                 <td>'.$cft_report['issue'].'</td>
                                 <td style="color: #ff0000;"><a style="color: #ff0000;" href="'.$url.'" id="delete_sms_report">x</a></td> 
                           </tr>';
            }
        }else{
            $report .= '<tr>
                             <td colspan="7">No Report Found</td> 
                        </tr>';
        }
        echo $report;
    }
    
    public function delete_sms_report(){

         $data = $this->uri->segment(3);
         $remove_report = $this->dashboard_model->remove_cft_report($data);
         if($remove_report){
             $result = array('result'=>'success','message'=>"Report Has been removed sucessfully",'id'=>$data);
         }else{
             $result = array('result'=>'failed','message'=>"Report Removel Failed");
         }       
         echo json_encode($result);
    }
 
    public function delete_cft_members(){
        $cft_id = $this->input->post('cft_id');
        $remove_cft_member = $this->dashboard_model->remove_cft_member($cft_id);
         if($remove_cft_member ){
             $result = array('result'=>'success','message'=>"CFT User removed sucessfully",'id'=>$remove_cft_member );
         }else{
             $result = array('result'=>'failed','message'=>"CFT User removal Failed");
         }       
         echo json_encode($result);
        
    }

    public function reports(){
    	$data['machine'] = get_machine();
        $this->load->view('reports',$data);
    }
/*    public function shift_and_timings($date){
            $data['date_from'] = $date;
            $data['date_to']   = $date;
            $shift = $this->dashboard_model->shift_timings($data);
            //echo "<pre>";print_r($shift );exit;
            $shift_data = array();
            if($shift['shift1']==1){
                $data_shift['shift'] = 1;
                $data_shift['shift_start'] = date('H:i:s',strtotime($shift['shift1_from']));
                $data_shift['shift_end'] = date('H:i:s',strtotime($shift['shift1_to']));
                $data_shift['timings'] = $this->dashboard_model->shift_timing_list($shift['shift1_from'],$shift['shift1_to']); 
                $shift_data[] = $data_shift;
                //echo "<pre>";print_r($shift_data );
            }
            if($shift['shift2']==1){
                $data_shift['shift'] = 2;
                $data_shift['shift_start'] = date('H:i:s',strtotime($shift['shift2_from']));
                $data_shift['shift_end'] = date('H:i:s',strtotime($shift['shift2_to']));
                $data_shift['timings'] = $this->dashboard_model->shift_timing_list($shift['shift2_from'],$shift['shift2_to']); 
                $shift_data[] = $data_shift;
            }
            if($shift['shift3']==1){
                $data_shift['shift'] = 3;
                $data_shift['shift_start'] = date('H:i:s',strtotime($shift['shift3_from']));
                $data_shift['shift_end'] = date('H:i:s',strtotime($shift['shift3_to']));
                $data_shift['timings'] = $this->dashboard_model->shift_timing_list($shift['shift3_from'],$shift['shift3_to']); 
                $shift_data[] = $data_shift;
            }            
            if(count($shift_data)==0){
                $data_shift['shift'] = 1;
                $data_shift['shift_start'] = date('H:i:s',strtotime(DEFAULT_SHIFT1_START_TIME));
                if (defined('DEFAULT_SHIFT_AFTER_EIGHT_END_TIME')) {
                    $data_shift['shift_end'] = date('H:i:s',strtotime(DEFAULT_SHIFT_AFTER_EIGHT_END_TIME));
                }else{
                    $data_shift['shift_end'] = date('H:i:s',strtotime(DEFAULT_SHIFT1_END_TIME));
                }
                $data_shift['timings'] = $this->dashboard_model->shift_timing_list(DEFAULT_SHIFT1_START_TIME,DEFAULT_SHIFT1_END_TIME); 
                $shift_data[] = $data_shift;
            }
            return  $shift_data;
    }*/
        public function MechineChange(){
            header('Access-Control-Allow-Origin: *'); 
            $job_details_spcs = $this->mobile->get_job_details($this->input->post('code'));
            $time_from = new DateTime($this->input->post('addjob_slot_from'));
            $time_to = new DateTime($this->input->post('addjob_slot_to'));
            $data['date'] = date('Y-m-d',strtotime($this->input->post('addjob_date')));
            $data['machine'] = $this->input->post('addjob_machine');
            $machine_id = $this->input->post('addjob_machine');
            $data['id'] = $this->input->post('addjob_machine');
            $data['time_from'] = $time_from->format('H:i:s');
            $data['time_to'] = $time_to->format('H:i:s');
            $data['shift'] = $this->input->post('addjob_shift');
            $data['addjob_running_time'] = $this->input->post('addjob_running_time');
            $cur_time = date('Y-m-d H:i:s'); 
            $shifts_details = $this->shift_and_timings($data['date']); 
            
            /**********************DIFF ********************************/
                $datetime1 = new DateTime($data['date'].' '.$data['time_from']);
                $datetime2 = new DateTime($data['date'].' '.$data['time_to']);
                $interval = $datetime1->diff($datetime2);
                $diffhour = $interval->format('%h');
                $diffmin = $interval->format('%i');  
            /**********************DIFF ********************************/
            
            foreach ($shifts_details as $key => $shift_details) {
                if($data['shift'] ==$shift_details['shift']){
                    $shift_start_time = $shift_details['shift_start'];
                    $shift_end_time = $shift_details['shift_end'];
                } 
            }
            if( ($shift_end_time < DEFAULT_SHIFT_START_TIME ) ){
                $shift_end_time = date('Y-m-d', strtotime($data['date'].' +1 day')).' '.$shift_end_time;
            }else{
                $shift_end_time = $data['date'].' '.$shift_end_time;
            }
            //echo $shift_end_time; exit;
            
            if(($shift_start_time < DEFAULT_SHIFT_START_TIME )){
                $shift_start_time = date('Y-m-d', strtotime($data['date'].' +1 day')).' '.$shift_start_time;
            }else{
                $shift_start_time = $data['date'].' '.$shift_start_time;
            }
            $job_start_from = $data['date'].' '.$data['time_from'];
            $job_end_to = $data['date'].' '.$data['time_to'];
            $end_timing=$this->dashboard_model->get_lastjob_endtiming($data);
            if($end_timing){
                //$end_timing = $data['date'].' '.$end_timing;
                if(new DateTime($cur_time) < new DateTime($end_timing) ){
                    $end_timing = $end_timing;
                }else{
                    $end_timing = $cur_time;
                }
            }else{ 
                if(new DateTime($cur_time) < new DateTime($shift_start_time) && new DateTime($cur_time) < new DateTime($shift_end_time)){
                    $end_timing = $shift_start_time;
                }elseif(new DateTime($cur_time) > new DateTime($shift_start_time) && new DateTime($cur_time) < new DateTime($shift_end_time)){
                    $end_timing = $cur_time;
                }else{
                    $end_timing = $cur_time;
                }
            }
            $job_time = explode('.', trim($data['addjob_running_time']));
            $job_end = new DateTime($end_timing);
            $job_end->modify('+'.$job_time[0].' hours');
            if(count($job_time)==2){
                $job_end->modify('+'.$job_time[1].' minutes');
            }
            $check_availability['date_from'] = date('Y-m-d',strtotime($end_timing));
            $check_availability['date_to'] = $job_end->format('Y-m-d');
            $check_availability['machine'] = $data['machine'];
            $check_availability['shift'] = $data['shift'];
            $check_availability['time_from'] = date('H:i:s',strtotime($end_timing));
            $check_availability['time_to'] = $job_end->format('H:i:s');
            $job_on_time = $this->dashboard_model->check_job_availability($check_availability);
/*            if(new DateTime($job_end->format('Y-m-d').' '.$job_end->format('H:i:s')) <= new DateTime($shift_end_time) ){
                
                
            }else{
                
                
            }*/
                $job_start=date('h:i A',strtotime($end_timing));
                $job_end = $job_end->format('h:i A'); 
                if($job_on_time['job']==0){
                    $get_machine_last_job = $this->mobile->get_machine_last_job($machine_id,$data['date']); 
                if(!is_array($get_machine_last_job)){
                    $get_machine_last_job['time_to'] = date('H:i:s');
                    $get_machine_last_job['date_from']  =  $data['date'];
                    $get_machine_last_job['date_from']  =  $data['date'];
                }
                if($job_details_spcs['machine'] != $data['machine']){
                    $hrs = $min =0;
                    $time_explode = explode('.',$data['addjob_running_time']);
                    $DiffTime = new DateTime($get_machine_last_job['date_from'].' '.$get_machine_last_job['time_to']);
                    $hrs = $DiffTime->modify('+'.$time_explode[0].' hours');
                    
                    if(count($time_explode)==2){
                        $min = $DiffTime->modify('+'.$time_explode[1].' minutes');
                    }
                    $update = $job_details_spcs;
                    $update['date_from'] = $get_machine_last_job['date_from'];
                    $update['date_to'] = $get_machine_last_job['date_from'];
                    $update['time_from'] = $get_machine_last_job['time_to'];
                    $update['time_to'] = $DiffTime->format('H:i:s');
                    
                    if(new DateTime($update['date_from'].' '.$update['time_to']) >= new DateTime($shift_end_time) ){
                        
                        $update['time_to'] = '22:00:00';
                    }
                    
                    $update['machine'] = $data['machine'];
                    $update['job_code'] = $this->input->post('code');
                    unset($update['id']);
                    $insert = $this->db->insert(TBL_MCDOWN,$update);
                    $insert_id = $this->db->insert_id();
                    if($insert_id){
                        $this->db->where('id !=', $insert_id);
                        $this->db->where('job_code', $update['job_code']);
                        $this->db->where('setup', 0);
                        $this->db->delete(TBL_MCDOWN);                         
                    }
                }
                    echo json_encode(array('result' =>'success','message'=>'No job on this time','machinedown'=>0,'job_start'=>$job_start,'job_end'=>$job_end));
                }else{
                    if($job_on_time['mcdown']==1){
                        echo json_encode(array('result' =>'failure','message'=>'Machine Down on this time','machinedown'=>1,'machine'=>$data['machine'],'job_start'=>$job_start,'job_end'=>$job_end));
                    }else{
                        echo json_encode(array('result' =>'failure','message'=>'Job on this time','machinedown'=>0,'machine'=>$data['machine'],'job_start'=>$job_start,'job_end'=>$job_end));
                    }
                }
            /*}else{
                $job_start=date('h:i A',strtotime($end_timing));
                $job_end = $job_end->format('h:i A'); 
                if($job_on_time['mcdown']==1){
                    echo json_encode(array('result' =>'failure','message'=>'machine down please select another machine','machinedown'=>1,'same'=>1,'job_start'=>$job_start,'job_end'=>$job_end));
                }else{
                    echo json_encode(array('result' =>'failure','message'=>'Job time more than shift time, please assign to another shift or day','machinedown'=>0,'same'=>1,'job_start'=>$job_start,'job_end'=>$job_end));
                }
            }*/
    }    
      public function shift_and_timings($date){
            $data['date_from'] = $date;
            $data['date_to']   = $date;
            $shift = $this->dashboard_model->shift_timings($data);
            $shift_data = array();
            if($shift['shift1']==1){
                $data_shift['shift'] = 1;
                $data_shift['shift_start'] = date('H:i:s',strtotime($shift['shift1_from']));
                $data_shift['shift_end'] = date('H:i:s',strtotime($shift['shift1_to']));
                $data_shift['timings'] = $this->dashboard_model->shift_timing_list($shift['shift1_from'],$shift['shift1_to']); 
                $shift_data[] = $data_shift;
            }
            if($shift['shift2']==1){
                $data_shift['shift'] = 2;
                $data_shift['shift_start'] = date('H:i:s',strtotime($shift['shift2_from']));
                $data_shift['shift_end'] = date('H:i:s',strtotime($shift['shift2_to']));
                $data_shift['timings'] = $this->dashboard_model->shift_timing_list($shift['shift2_from'],$shift['shift2_to']); 
                $shift_data[] = $data_shift;
            }
            if($shift['shift3']==1){
                $data_shift['shift'] = 3;
                $data_shift['shift_start'] = date('H:i:s',strtotime($shift['shift3_from']));
                $data_shift['shift_end'] = date('H:i:s',strtotime($shift['shift3_to']));
                $data_shift['timings'] = $this->dashboard_model->shift_timing_list($shift['shift3_from'],$shift['shift3_to']); 
                $shift_data[] = $data_shift;
            }            
            if(count($shift_data)==0){
                $data_shift['shift'] = 1;
                $data_shift['shift_start'] = date('H:i:s',strtotime(DEFAULT_SHIFT1_START_TIME));
                $data_shift['shift_end'] = date('H:i:s',strtotime(DEFAULT_SHIFT1_END_TIME));
                $data_shift['timings'] = $this->dashboard_model->shift_timing_list(DEFAULT_SHIFT1_START_TIME,DEFAULT_SHIFT1_END_TIME); 
                $shift_data[] = $data_shift;
            }
            return  $shift_data;
    }  
    public function location(){
        $data['user']['name'] = $this->dashboard_model->get_username($this->uri->segment(3));
        $data['user']['message'] = "<p>Last <b>GPS</b> updated Location";
        $data['locations'] = $this->dashboard_model->get_user_locations($this->uri->segment(3));
        $this->load->view('location',$data);
    }
    
    public function user_location(){
        $data['users'] = $this->dashboard_model->get_all_users();
        //echo "<pre>";print_r($data['users']);exit;
        $this->load->view('user_location',$data);
    }
    
    public function order_location(){
        if($this->input->post()){
            if($this->input->post('ref')!=""){
	            $job_status = $this->dashboard_model->get_job_status($this->input->post('ref'));
	            if($job_status['status']==8){
	                $data['user']['name'] = $job_status['job_code'];
	                $data['locations'] = $this->dashboard_model->check_order_location($this->input->post('ref'));
	                
	                $data['user']['message'] = "<b>Delivered</b><br/><b>".$job_status['job_code']."</b> Delivered Here.";
	                $this->load->view('location',$data);
	            }elseif($job_status['status']==7){
	                $user_id = $this->dashboard_model->get_shipping_user($this->input->post('ref'));
	                //$user_id = 28;   // find user who shipped package
	                $data['user']['name'] = $job_status['job_code'];
	                $data['user']['message'] = "<b>Under Shipping</b><br/><p>Last <b>GPS</b> updated Location";
	                $data['locations'] = $this->dashboard_model->get_user_locations($user_id);
	        	$this->load->view('location',$data);
	            }else{
	                if($job_status['status']!=0){
	                    $message = '<h3><b>'. $job_status['job_code']."</b>  Under ".$job_status['status_word']." State .</h3>";
	                    $data['message'] = array('result'=>'success','message'=>$message);
	                    $this->load->view('track_order',$data);
	                }else{
	                    $message = '<h3><b>'. $job_status['job_code']."</b> ".$job_status['status_word']."</h3>";
	                    $data['message'] = array('result'=>'success','message'=>$message);
	                    $this->load->view('track_order',$data);
	                }
	            }
             }else{
             	$message = '<h3>Please enter <b>Ref#</b> to track</h3>';
	                $data['message'] = array('result'=>'success','message'=>$message);
	                $this->load->view('track_order',$data);
             }
            
        }else{
            $this->load->view('track_order');
        }
    }
    
    public function convert_editjob_availability(){
    	$time_from = new DateTime($this->input->post('addjob_slot_from'));
        $time_to = new DateTime($this->input->post('addjob_slot_to'));
        $data['date'] = date('Y-m-d',strtotime($this->input->post('addjob_date')));
        $data['machine'] = $this->input->post('addjob_machine');
        $data['id'] = $this->input->post('addjob_machine');
        $data['time_from'] = $time_from->format('H:i:s');
        $data['time_to'] = $time_to->format('H:i:s');
        $data['shift'] = $this->input->post('addjob_shift');
        $data['addjob_running_time'] = $this->input->post('addjob_running_time');
    }
    
    public function machine_ready(){
    	$down_id = $this->uri->segment(3);
    	$spcs_job_details = $this->dashboard_model->get_job_details($down_id);
    	if(date('Y-m-d') < $spcs_job_details ['date_to']){
    	        $update['task'] = 1;
    		$update['status'] = 0;
    	}elseif(date('Y-m-d') == $spcs_job_details ['date_to']){
    	    if( new DateTime() < new DateTime($spcs_job_details['time_to']) ){
	    	    //echo "test";
	    	     $update['time_to'] = date('H:i:s');
	    	     $update['task'] = 1;
	    	      
	    }else{ 
	    	     $update['task'] = 1;
	    }
    	}else{
    		$update['task'] = 1;
    	}
    	
    	$update_result = $this->dashboard_model->update_jobs($down_id,$update);
    	$this->upcomingmcdown_ready($spcs_job_details['machine'],$spcs_job_details['date_from'],$spcs_job_details['shift']);
    	if($update_result){
    	    $result = array('result'=>'success','message'=>'Machine Ready Updated Successfully');
    	}else{
    	    $result = array('result'=>'failure','message'=>'Machine Ready Update Failed');
    	}
    	echo json_encode($result);
    	
    }
    
    public function check_job_or_mcdown(){
        $data = $this->input->post();
    	if(!empty($data)){
		$check['date_from']	=	date('Y-m-d',strtotime($this->input->post('mcdown_datefrom')));
		$check['date_to']	=	date('Y-m-d',strtotime($this->input->post('mcdown_dateto')));
		$check['machine']	=	$this->input->post('mcdown_machine');
		$check['shift']		=	$this->input->post('mcdown_shift');
		$check['time_from']	=	date('H:i:s',strtotime($this->input->post('mcdown_timefrom')));
		$check['time_to']	=	date('H:i:s',strtotime($this->input->post('mcdown_timeto')));
		$check['notes']		=	$this->input->post('mcdown_notes');
		if(isset($_POST['move_jobs'])){
			$check['move_jobs']	=	$this->input->post('move_jobs');
		}else{
			$check['move_jobs']	= 0;
		} 
		$job_details = $this->dashboard_model->check_job_or_mcdown($check);
 
		$this->split_job($job_details,$check);
		
        }else{
        	$return = array('result' =>'failure','message'=>'machine down data missing.');
        	echo json_encode($return);
        } 
    }
    
    private function split_job($data,$machinedown){
        //echo "<pre>";print_r($machinedown);exit;
    	$move_jobs = $machinedown['move_jobs'];
    	unset($machinedown['move_jobs']);
    	$shifts_details = $this->shift_and_timings($machinedown['date_from']); 
        foreach ($shifts_details as $key => $shift_details) {
            if($machinedown['shift'] == $shift_details['shift']){
                $shift_start_time = $shift_details['shift_start'];
                $shift_end_time = $shift_details['shift_end'];
            } 
        }
        if( ($shift_end_time < DEFAULT_SHIFT_START_TIME ) ){
            $shift_end_time = date('Y-m-d', strtotime($data['date_from'].' +1 day')).' '.$shift_end_time;
        }else{
            $shift_end_time = $machinedown['date_from'].' '.$shift_end_time ;
        }
        if(($shift_start_time < DEFAULT_SHIFT_START_TIME )){
            $shift_start_time = date('Y-m-d', strtotime($data['date_from'].' +1 day')).' '.$shift_start_time ;
        }else{
            $shift_start_time = $machinedown['date_from'].' '.$shift_start_time ;
        }
    	
    	//if((new DateTime($shift_start_time) <= new DateTime($machinedown['date_from'].' '.$machinedown['time_from']))&&(new DateTime($shift_end_time) >= new DateTime($machinedown['date_to'].' '.$machinedown['time_to']))){ 
    		$datetime1 = new DateTime($machinedown['date_from'].' '.$machinedown['time_from']);
		$datetime2 = new DateTime($machinedown['date_to'].' '.$machinedown['time_to']);
		$interval1 = $datetime1->diff($datetime2);
		$mcdown_hour = $interval1->format('%h');
		$mcdown_min = $interval1->format('%i');
		//echo "<pre>";print_r($data);exit;
	    	if( $data['job']== 1 ){  
			$mcdown_time = (($mcdown_hour*60)+$mcdown_min); 
	    		if( ($mcdown_time <= MAXIMUM_MACHINE_DOWN_ALLOW)){
	    			if( ( $data['mcdown']!= 0 ) && ( $data['task']!=1 ) ){
	    				$return = array( 'result' => 'failed' , 'message' => 'machine down on this time.' );
		    		}else{
		    			 if($data['running'] == 1){
		    			 	$job_details = $this->dashboard_model->get_job_details($data['job_id']);
		    			 	// calculate starting time
		    			 	if($job_details){
		    			 		
		    			 		$datetime1 = new DateTime($job_details['date_from'].' '.$job_details['time_from']);
							$datetime2 = new DateTime($machinedown['date_from'].' '.$machinedown['time_from']);
							$interval1 = $datetime1->diff($datetime2);
							$start_diffhour = $interval1->format('%h');
							$start_diffmin = $interval1->format('%i');
							
							$DiffTime = new DateTime($job_details['date_from'].' '.$job_details['time_from']);
							$DiffTime->modify('+'.$start_diffhour.' hours');
							$DiffTime->modify('+'.$start_diffmin.' minutes');
							
			    			 	// calculating ending time
			    			 	
			    			 	$datetime1 = new DateTime($machinedown['date_from'].' '.$machinedown['time_from']);
							$datetime2 = new DateTime($job_details['date_to'].' '.$job_details['time_to']);
							$interval1 = $datetime1->diff($datetime2);
							$end_diffhour = $interval1->format('%h');
							$end_diffmin = $interval1->format('%i');
							
							$EndDiffTime = new DateTime($machinedown['date_to'].' '.$machinedown['time_to']);
							$EndDiffTime->modify('+'.$end_diffhour.' hours');
							$EndDiffTime->modify('+'.$end_diffmin.' minutes');
			    			 	
			    			 	//update old job 
			    			 	
			    			 	$update['date_from']	= $job_details['date_from'];
			    			 	$update['time_from']	= $job_details['time_from'];
			    			 	$update['date_to']	= $machinedown['date_from'];
			    			 	$update['time_to']	= $machinedown['time_from'];
			    			 	$update['task']		= 1;
			    			 	$update['down_time']	= $start_diffhour.'.'.$start_diffmin;
			    			 	
			    			 	$newdown=$this->dashboard_model->update_jobs($job_details['id'],$update);
			    			 	
			    			 	//insert new job
			    			 	
			    			 	$insert_job['date_from'] 	   = $EndDiffTime->format('Y-m-d');
			    			 	$insert_job['time_from'] 	   = $machinedown['time_to'];
			    			 	$insert_job['date_to']    	   = $EndDiffTime->format('Y-m-d');
			    			 	$insert_job['time_to']   	   = $EndDiffTime->format('H:i:00');
			    			 	$insert_job['job_code']  	   = $job_details['job_code'];
			    			 	$insert_job['qty']		   = $job_details['qty'];
			    			 	$insert_job['side']		   = $job_details['side'];
			    			 	$insert_job['machine']    	   = $job_details['machine'];
			    			 	$insert_job['down_time']	   = $end_diffhour.'.'.$end_diffmin;
			    			 	$insert_job['task']       	   = $job_details['task'];
			    			 	$insert_job['reason']    	   = $job_details['reason'];
			    			 	$insert_job['notes']      	   = $job_details['notes'];
			    			 	$insert_job['setup']      	   = 0; 
			    			 	$insert_job['position']      	   = $job_details['position'];
			    			 	$insert_job['assy_start']      	   = $job_details['notes'];
			    			 	$insert_job['assy_end']      	   = $job_details['assy_start'];
			    			 	$insert_job['setup_start']         = $job_details['setup_start'];
			    			 	$insert_job['setup_end']     	   = $job_details['setup_end'];
			    			 	$insert_job['tooling_start']       = $job_details['tooling_start'];
			    			 	$insert_job['tooling_end']     	   = $job_details['tooling_end'];
			    			 	$insert_job['qc_start']     	   = $job_details['qc_start'];
			    			 	$insert_job['qc_end']      	   = $job_details['qc_end'];
			    			 	$insert_job['job_complete_status'] = 0;
			    			 	$insert_job['status']		   = 1;
			    			 	
			    			 	 
			    			 		
			    			 	$newaddjob=$this->dashboard_model->check_position($insert_job,0);
							
			    			 	//insert machine down
			    			 	
			    			 	$insert_mcdown['date_from']	= $machinedown['date_from'];
			    			 	$insert_mcdown['time_from']	= $machinedown['time_from'];
				    			$insert_mcdown['date_to']	= $machinedown['date_to'];
			    			 	$insert_mcdown['time_to']	= $machinedown['time_to'];
			    			 	$insert_mcdown['machine']    	= $job_details['machine'];
			    			 	$insert_mcdown['notes']    	= $machinedown['notes'];
			    			 	$insert_mcdown['down_time']	= $mcdown_hour.'.'.$mcdown_min;
							$insert_mcdown['mc_down']	= 1;
							$insert_mcdown['shift']		= $job_details['shift'];
							$insert_mcdown['position']	= 0;
							$insert_mcdown['created_on']	= date("Y-m-d H:i:s");
							$insert_mcdown['status']	= 1;
			    			 	//
			    			 	//echo "<pre>";print_r($insert_mcdown);exit;
			    			 	//$newdown=$this->dashboard_model->insert_machine_down($insert_mcdown);
			    			 	$this->check_insert_mcdown($insert_mcdown);
			    			 	
			    			 	$return = array( 'result' => 'success' , 'message' => 'job split / machine down inserted successfully.' );
			    			 	
		    			 	}else{
		    			 		$return = array( 'result' => 'failed' , 'message' => 'job details not found.' );
		    			 	}
		    			 }else{
		    			 	
		    			 	//insert machine down
		    			 	
					 	$insert_mcdown['date_from']	= $machinedown['date_from'];
					 	$insert_mcdown['time_from']	= $machinedown['time_from'];
						$insert_mcdown['date_to']	= $machinedown['date_to'];
					 	$insert_mcdown['time_to']	= $machinedown['time_to'];
					 	$insert_mcdown['machine']    	= $machinedown['machine'];
					 	$insert_mcdown['notes']    	= $machinedown['notes'];
					 	$insert_mcdown['down_time']	= $mcdown_hour.'.'.$mcdown_min;
						$insert_mcdown['mc_down']	= 1;
						$insert_mcdown['shift']		= $machinedown['shift'];
						$insert_mcdown['position']	= 0;
						$insert_mcdown['created_on']	= date("Y-m-d H:i:s");
						$insert_mcdown['status']	= 1;
					 	
					 	//$newdown=$this->dashboard_model->insert_machine_down($insert_mcdown);
					 	$this->check_insert_mcdown($insert_mcdown);
						
						$return = array( 'result' => 'success' , 'message' => 'machine down inserted successfully.' );
		    			 }
		    		}
	    		}else{
	    			if($move_jobs != 1){
	    				$return = array( 'result' => 'failed' , 'message' => 'Please Move jobs machine down more than '.round((MAXIMUM_MACHINE_DOWN_ALLOW/60), 1).' Hours' );
	    			}else{
	    				//insert machine down
			    		 	
				 	$insert_mcdown['date_from']	= $machinedown['date_from'];
				 	$insert_mcdown['time_from']	= $machinedown['time_from'];
					$insert_mcdown['date_to']	= $machinedown['date_to'];
				 	$insert_mcdown['time_to']	= $machinedown['time_to'];
				 	$insert_mcdown['machine']    	= $machinedown['machine'];
				 	$insert_mcdown['notes']    	= $machinedown['notes'];
				 	$insert_mcdown['down_time']	= $mcdown_hour.'.'.$mcdown_min;
					$insert_mcdown['mc_down']	= 1;
					$insert_mcdown['shift']		= $machinedown['shift'];
					$insert_mcdown['position']	= 0;
					$insert_mcdown['created_on']	= date("Y-m-d H:i:s");
					$insert_mcdown['status']	= 1;
					
				 	$this->check_insert_mcdown($insert_mcdown);
				 	
	    				$return = array( 'result' => 'success' , 'message' => 'machine down inserted successfully.' );
	    			}
	    			
	    		}
	    	}else{
			//insert machine down
			    			 	
		 	$insert_mcdown['date_from']	= $machinedown['date_from'];
		 	$insert_mcdown['time_from']	= $machinedown['time_from'];
			$insert_mcdown['date_to']	= $machinedown['date_to'];
		 	$insert_mcdown['time_to']	= $machinedown['time_to'];
		 	$insert_mcdown['machine']    	= $machinedown['machine'];
		 	$insert_mcdown['notes']    	= $machinedown['notes'];
		 	$insert_mcdown['down_time']	= $mcdown_hour.'.'.$mcdown_min;
			$insert_mcdown['mc_down']	= 1;
			$insert_mcdown['shift']		= $machinedown['shift'];
			$insert_mcdown['position']	= 0;
			$insert_mcdown['created_on']	= date("Y-m-d H:i:s");
			$insert_mcdown['status']	= 1;
			
		 	$this->check_insert_mcdown($insert_mcdown);
			
			$return = array( 'result' => 'success' , 'message' => 'machine down inserted successfully.' );
			
		}    
       /* }else{ 
            $return = array('result' =>'failure','message'=>'Machine Down Time crossed shift time');
        }*/
    	echo json_encode($return);
    }
    
    private function check_insert_mcdown($data){
    	header('Access-Control-Allow-Origin: *');
        $this->load->model('mcdown_model','mcdown'); 
        if($data['date_from'] == $data['date_to']){
        	
		$downtime['date_from']  = date('Y-m-d',strtotime($data['date_from']));
		$downtime['date_to']    = date('Y-m-d',strtotime($data['date_to']));	
		$downtime['time_from']  = date('H:i:s',strtotime($data['time_from']));
		$downtime['time_to']    = date('H:i:s',strtotime($data['time_to']));
		
		$shiftdetails = $this->shift_and_timings($downtime['date_from']);
		foreach($shiftdetails as $key => $shiftdetail){
			if(check_time($shiftdetail['shift_start'],$shiftdetail['shift_end'],$downtime['time_from'])){
				$downtime['shift'] = $shiftdetail['shift'];
			}
		}
		$downtime['machine']    =	$data['machine'];
		$downtime['notes']    	=	$data['notes'];
		$downtime['down_time']	=	$data['down_time'];
		$downtime['mc_down']	=	1;
		$downtime['position']	=	0;
		$downtime['created_on']	=	date("Y-m-d H:i:s");
		$downtime['status']	=	1;
		
		$newdown=$this->dashboard_model->insert_machine_down($downtime);
		
	}else{ 
		//echo "<pre>";print_r($data);exit;
	    	$dates = createDateRangeArray($data['date_from'],$data['date_to']);
	    	//echo "<pre>";print_r($dates);exit;
		foreach ($dates as $key => $date) { 
			$data['shifts'] = $this->shift_and_timings(date('Y-m-d',strtotime($date))); 
			// echo "<pre>";print_r($data['shifts']);exit;
			foreach($data['shifts'] as $shift_id => $shift){
				$from_insert = 0; 
				$to_insert = 0; 
				$check['machine'] 	= $data['machine'];
				$check['date_from'] 	= $date;
				$check['shift'] 	= $shift['shift'];
				$mcdown = $this->mcdown->check_fullshift_mcdown($check);
				// echo "<pre>";print_r($mcdown);exit;
				if( ($mcdown['full_shift_mcdown']!=1)){
					if( ($shift['shift_end'] < DEFAULT_SHIFT_START_TIME ) ){
						$shift['shift_end'] = date('Y-m-d', strtotime(date('Y-m-d',strtotime($date)).' +1 day')).' '.$shift['shift_end'];
					}else{
						$shift['shift_end'] = date('Y-m-d',strtotime($date)).' '.$shift['shift_end'];
					}
					if(($shift['shift_start'] < DEFAULT_SHIFT_START_TIME )){
						$shift['shift_start'] = date('Y-m-d', strtotime(date('Y-m-d',strtotime($date)).' +1 day')).' '.$shift['shift_start'];
					}else{
						$shift['shift_start'] = date('Y-m-d',strtotime($date)).' '.$shift['shift_start'];
					}
					
					$downtime['date_from']  = date('Y-m-d',strtotime($shift['shift_start']));
					$downtime['date_to']    = date('Y-m-d',strtotime($shift['shift_end']));
					if($key == 0){ 
						// echo "<br/>first day<br/>";
						if(new DateTime($data['date_from'].' '.$data['time_from']) <= new DateTime($shift['shift_end']) ){
	if(check_time(date('H:i:s',strtotime($shift['shift_start'])),date('H:i:s',strtotime($shift['shift_end'])),date('H:i:s',strtotime($data['time_from'])))){
								$from_insert = 1; 
								$downtime['time_from']  = date('H:i:s',strtotime($data['time_from']));
							}else{ 
								$from_insert = 1; 
								$downtime['time_from']  = date('H:i:s',strtotime($shift['shift_start']));
							}
						} 
					}else{
						$from_insert = 1;
						$downtime['time_from']  = date('H:i:s',strtotime($shift['shift_start']));
						
					}
					
					
					if($key == (count($dates)-1)){  
					// echo "<br/>last day<br/> "; 
						if(new DateTime($data['date_to'].' '.$data['time_to']) >= new DateTime($shift['shift_start']) ){ 
								if(check_time(date('H:i:s',strtotime($shift['shift_start'])),date('H:i:s',strtotime($shift['shift_end'])),date('H:i:s',strtotime($data['time_to'])))){
								$to_insert = 1;
								$downtime['time_to']    = date('H:i:s',strtotime($data['time_to']));
							}else{
								$to_insert = 1;
								$downtime['time_to']    = date('H:i:s',strtotime($shift['shift_end']));
							}
						
						}
					}else{ 
						$to_insert = 1;
						$downtime['time_to']    = date('H:i:s',strtotime($shift['shift_end']));
	
					}
					//  echo "<pre>";print_r($downtime['time_to']); 
					$downtime['shift']      =	$shift['shift'];
					$downtime['machine']    =	$data['machine'];
					$downtime['notes']    	=	$data['notes'];
					$downtime['down_time']	=	$data['down_time'];
					$downtime['mc_down']	=	1;
					$downtime['position']	=	0;
					$downtime['created_on']	=	date("Y-m-d H:i:s");
					$downtime['status']	=	1;
					//  echo "<pre>";print_r($from_insert.'-'.$to_insert);
					// echo "<pre>";print_r($downtime);
					if( ($from_insert == 1)&&($to_insert == 1) ){
						$newdown=$this->dashboard_model->insert_machine_down($downtime);
						 
					}
					
					
				}
			}
		} 
	}
    	
    }
    
    public function upcomingmcdown_ready($machine,$curdate,$curshift){
    
    	$todaydate = date('Y-m-d',strtotime($curdate));
        $nextday = date('Y-m-d',strtotime($todaydate.' +1 day'));
        $nextnextday = date('Y-m-d',strtotime($todaydate.' +2 day'));
        
        $data['days']= array(array('day'=>$todaydate),array('day'=>$nextday));
        
    	foreach ($data['days'] as $daykey => $day) {
            $data['shifts'] = $this->shift_and_timings($day['day']); 
            foreach ($data['shifts'] as $shiftkey => $shift) {
                if( ($shift['shift_end'] <= DEFAULT_SHIFT_START_TIME ) ){
                    $shift['shift_end'] = date('Y-m-d', strtotime($day['day'].' +1 day')).' '.$shift['shift_end'];
                }else{
                    $shift['shift_end'] = $day['day'].' '.$shift['shift_end'];
                }
                if(($shift['shift_start'] < DEFAULT_SHIFT_START_TIME )){
                    $shift['shift_start'] = date('Y-m-d', strtotime($day['day'].' +1 day')).' '.$shift['shift_start'];
                }else{
                    $shift['shift_start'] = $day['day'].' '.$shift['shift_start'];
                }
		$check['date_from'] = date('Y-m-d',strtotime($shift['shift_start']));
		$check['date_to'] = date('Y-m-d',strtotime($shift['shift_end']));
		$check['shift'] = $shift['shift'];
		$check['machine'] = $machine; 
		
		$newdown=$this->dashboard_model->check_andready_mcdown($check); 
    	    }
    	    
    	    
    	}
    }
    
    public function schedule(){
    	//echo "<pre>";print_r($this->input->post());exit;
    	$post_data = $this->input->post();
    	$data['machine'] 	= $post_data['schedule_machine'];
    	$data['type'] 		= $post_data['schedule_for'];
    	$data['day'] 		= $post_data['schedule_week_day'];
    	$data['start_time'] 	= $post_data['schedule_start'];
    	$data['end_time'] 	= $post_data['schedule_end'];
    	$data['reason'] 	= $post_data['schedule_reason'];
    	$data['created_on'] 	= date('Y-m-d H:i:s');
    	$data['updated_on'] 	= '0000-00-00 00:00;00';
    	$data['status'] 	= 1;
    	$schedule = $this->dashboard_model->insert_schedule($data); 
    	if($schedule){
    		$result = array('result'=>'success','message'=>'Schedule insertion successfully');
    	}else{
    		$result = array('result'=>'failed','message'=>'Schedule insertion failed');
    	}
    	echo json_encode($result);
    }
    
    public function schedule_report(){
    	$schedules = $this->dashboard_model->get_schedules();
    	$data = "";
    	if($schedules){
    		foreach( $schedules as $key => $schedule ){
    			if($schedule['type']==1){
    				$type ="Daily";
    			}else{
    				$type ="Weekly";
    				if($schedule['day']!=""){
    					$type .= " - ".getday($schedule['day']);
    				}
    			}
    			if($schedule['status']==1){
    				$status = "active";
    			}else{
    				$status = "deactive";
    			}
    			$data .= "<tr class='remove_schedule".$schedule['id']."'><td>".$type."</td><td>".$schedule['start_time']."</td><td>".$schedule['end_time']."</td><td>".$this->dashboard_model->get_mechine_name($schedule['machine'])."</td><td>".$schedule['reason']."</td><td>".$status."</td><td><a href='".base_url('dashboard/removeschedule/').$schedule['id']."' class='btn btn-danger remove_schedule' data-id='".$schedule['id']."'>Remove<a></td></tr>";
    		}
    	}else{
    		$data .="<tr><td colspan='7'>No Schedules Found</td></tr>";
    	}
    	echo $data;
    }
    
    public function removeschedule(){
    	$id = $this->uri->segment(3);
    	if($this->dashboard_model->remove_schedule($id)){
    		$result = array('result'=>'success' , 'message' => 'schedule removed successfully' , 'id' => $id);
    	}else{
    		$result = array('result'=>'failed' , 'message' => 'schedule remove failed' , 'id' => $id);
    	}
    	echo json_encode($result);
    }
    public function adddownschedule(){
        header('Access-Control-Allow-Origin: *');
        $dateTimeString = date('Y-m-d H:i:s',strtotime($this->input->post('mcdown_date')));
        $datetime = new DateTime($dateTimeString);
        
        $schedule_mechine = $this->check_advanced_schedule_mechine($this->input->post('mcdown_machine'));
        $data['adv_machine'] = $this->input->post('mcdown_machine');
        $data['adv_date'] = date('Y-m-d',strtotime($this->input->post('mcdown_date'))); 
        $data['adv_time'] = $this->input->post('mcdown_timeto'); 
        $data['adv_notes'] = $this->input->post('mcdown_notes');
        $data['adv_day']  = $datetime->format('D');
        $data['created_on'] = date("Y-m-d H:i:s");
        $data['updated_on']=date("Y-m-d H:i:s");
        $data['status']=1;         
        if($schedule_mechine==''){
            $status = $this->db->insert('tbl_advanced_schedule',$data);
        }else{
            $this->db->where('id',$schedule_mechine);
            $status = $this->db->update('tbl_advanced_schedule',$data);
        }
        
        
        if($status){
            $result = array('result'=>'success' , 'message' => 'schedule added successfully');
        }else{
            $result = array('result'=>'failed' , 'message' => 'schedule added failed');
        }
        echo json_encode($result);
    }
    public function check_advanced_schedule_mechine($mcdown_machine){
    	$this->db->where('adv_machine',$mcdown_machine);
    	$result = $this->db->get('tbl_advanced_schedule');
    	if($result->num_rows()>0){
    	    return $result->row()->id;
    	}else{
    	    return 0;
    	}          
    }
    public function chart(){
      error_reporting(E_ERROR | E_PARSE);
      header('Access-Control-Allow-Origin: *');      
      $today_chart = date('Y-m-d');
	  $week_chart = date('W');	  	  
	  $month_chart = date('m');
	  
      /*** Get all mechine for get the job ***/
      $machinelists=$this->dashboard_model->get_machine();
	  $chart = 'week';
	  if($chart=='today'){		  
		  $datas['today'] = $today_chart;		  
	  }elseif($chart=='week'){		  
		$week_first = date('Y-m-d',strtotime("last monday"));
		$week_last = date('Y-m-d',strtotime("next sunday"));
		$datas['week'][0] =	$week_first;
		$datas['week'][1] =	$week_last;	  
	  }else{		  
		$datas['month'] 	 =	$month_chart; 
	  }      
      foreach($machinelists as $machinelists_val){		  
		  /************** Today Percentage Calculation Start **************/		  
		  $data['production'][] 	= $this->get_production_jobs('pr',$datas,$machinelists_val['id'],$machinelists_val['machine']);		  
		  $data['setup'][]		= $this->get_production_jobs('st',$datas,$machinelists_val['id'],$machinelists_val['machine']);		  
		  $data['planed'][]	= $this->get_production_jobs('pl',$datas,$machinelists_val['id'],$machinelists_val['machine']);		  		  
		  $data['unplaned'][]	= $this->get_production_jobs('up',$datas,$machinelists_val['id'],$machinelists_val['machine']);
		  /************** Today Percentage Calculation End **************/	
	  }
	  /************** Today Time Calculation Start **************/
      $chat_type = array('production','setup','planed','unplaned');  
    	 for($i=0;$i<count($chat_type);$i++){
    	  foreach($data[$chat_type[$i]] as $key=>$setup){
    	      foreach($setup as $key1=>$setup_val){
        	      $hour = 0;
        	      $min = 0;
        	      $min_hour = 0;
        	      $mc_time = 0;
        	      $min_remain = 0;
    	          foreach($setup_val as $key2=>$setup_last){
    	              $hour+=$setup_last['hour'];
    	              $min+=$setup_last['min'];
    	          }
    	          if($min>60){
    	              $min_hour = $min/60;
    	              $min = fmod($min,60);
    	          }
    	           $mc_time = $hour+$min_hour;
    	           $mechine[$key1][$chat_type[$i]]['hour'] = $mc_time.'.'.$min; 
    	      }
    	  }
        }
      /************** Today Time Calculation End **************/
      $data['mechine'] = $mechine;
      $this->load->view('chart',$data);          
    }
    function get_production_jobs($type,$date,$machine_id,$machine){
		$key = array_keys($date);
		$year_chart = date('Y');
		$this->db->select('*');
		$this->db->where('machine',$machine_id);
		if($type=='pr'){
			if($key[0]=='today'){     
				$this->db->where('DATE(tooling_start)',$date['today']);
			}elseif($key[0]=='week'){
				$this->db->where('tooling_start >=', $date['week'][0]);
				$this->db->where('tooling_start <=', $date['week'][1]);						
			}else{
				$this->db->where('MONTH(tooling_start)',$date['month']);
			}
			$this->db->where('YEAR(tooling_start)',$year_chart);
			$result = $this->db->get('tbl_tooling_timings');
		    if($result->num_rows()>0){
    			foreach($result->result_array() as $res){
    				$time_from = $res['tooling_start'];
    				$time_to   = $res['tooling_end'];
    				$data[$machine_id][] = $this->calcpercentage($time_from,$time_to);
    			}
		    }else{
		        $data[$machine_id][] = array('hour'=>0,'min'=>0);
		    }
		}
		
		if($type=='st'){
			if($key[0]=='today'){     
				$this->db->where('DATE(setup_start)',$date['today']);
			}elseif($key[0]=='week'){
				$this->db->where('setup_start >=', $date['week'][0]);
				$this->db->where('setup_start <=', $date['week'][1]);						
			}else{
				$this->db->where('MONTH(setup_start)',$date['month']);
			}
			$this->db->where('YEAR(setup_start)',$year_chart);
			$result = $this->db->get('tbl_setup_timing');
			if($result->num_rows()>0){
    			foreach($result->result_array() as $res){
    				$time_from = $res['setup_start'];
    				$time_to   = $res['setup_end'];
    				$data[$machine_id][] = $this->calcpercentage($time_from,$time_to);
    			}
			}else{
			      $data[$machine_id][] = array('hour'=>0,'min'=>0);
			}
		}
		
		if($type=='pl'){
			if($key[0]=='today'){     
				$this->db->where('DATE(date_from)',$date['today']);
			}elseif($key[0]=='week'){
				$this->db->where('date_from >=', $date['week'][0]);
				$this->db->where('date_from <=', $date['week'][1]);						
			}else{
				$this->db->where('MONTH(date_from)',$date['month']);
			}			
			$this->db->where('week_down',1);
			$this->db->where('YEAR(date_from)',$year_chart);
			$result = $this->db->get(TBL_MCDOWN);
			if($result->num_rows()>0){
    			foreach($result->result_array() as $res){
    				$time_from = $res['date_from'].' '.$res['time_from'];
    				$time_to   = $res['date_from'].' '.$res['time_to'];
    				$data[$machine_id][] = $this->calcpercentage($time_from,$time_to);
    			}
			}else{
			    $data[$machine_id][] = array('hour'=>0,'min'=>0);
			}
		}
		
		if($type=='up'){
			if($key[0]=='today'){     
				$this->db->where('DATE(date_from)',$date['today']);
			}elseif($key[0]=='week'){
				$this->db->where('date_from >=', $date['week'][0]);
				$this->db->where('date_from <=', $date['week'][1]);						
			}else{
				$this->db->where('MONTH(date_from)',$date['month']);
			}
			$this->db->where('YEAR(date_from)',$year_chart);
			$this->db->where('week_down',0);
            $where = '(mc_down ="1" OR other_down ="1" )';
            $this->db->where($where);
			$result = $this->db->get(TBL_MCDOWN);
			if($result->num_rows()>0){
    			foreach($result->result_array() as $res){
				$time_from = $res['date_from'].' '.$res['time_from'];
				$time_to   = $res['date_from'].' '.$res['time_to'];
				$data[$machine_id][] = $this->calcpercentage($time_from,$time_to);
    			}
			}else{
			    $data[$machine_id][] = array('hour'=>0,'min'=>0);
			}

		}
		return $data;
    }	
	function calcpercentage($setup_start,$setup_end){
		$datetime1 = new DateTime($setup_start);
		if($setup_start!='0000-00-00 00:00:00' && $setup_end=='0000-00-00 00:00:00'){
			$setup_end= date('Y-m-d',strtotime($setup_start));
			$setup_end = $setup_end.' '.date('H:i:00');
		}
		$datetime2 = new DateTime($setup_end);
		$interval = $datetime1->diff($datetime2);
		$hrs_with_min = $interval->format('%h').':'.$interval->format('%i');
		
		$setup_start_sec = $datetime1->format('s');
		$setup_end_sec = $datetime2->format('s');
		$seconds += $setup_start_sec + $setup_end_sec;
		$time +=$this->explode_time1($hrs_with_min);
		if($time>0){
			$minutes = $time + $seconds;
			return $this->second_to_hhmm1($minutes);             
		}else{
			return array('hour'=>0,'min'=>0);
		} 					
	}
    function explode_time1($time) { //explode time and convert into seconds
            $time = explode(':', $time);
            $time = $time[0] * 3600 + $time[1] * 60;
            return $time;
    }
    function second_to_hhmm1($time) { //convert seconds to hh:mm
            $hour = 0;
            $minute =0;
            $hour = floor($time / 3600);
            $minute = strval(floor(($time % 3600) / 60));
            if ($minute == 0) {
                $minute = "0";
            } else {
                $minute = $minute;
            }
            return array('hour'=>$hour,'min'=>$minute);
    }
    function priority_update(){
        
        
        $tjob_priority = $this->input->post('tjob_priority');
        
        $job_code = $this->input->post('job_code');
        
        $priority_arr = array('priority'=>$tjob_priority);
        
        
        $this->db->where('job_code',$job_code); 
        $this->db->where('setup', 0);
        $result = $this->db->get(TBL_MCDOWN);  
        if( $result->num_rows() > 0 ){
            $this->db->where('job_code', $job_code);
            $this->db->where('setup', 0);
            $this->db->update(TBL_MCDOWN,$priority_arr);
        }
         return true;
    }
	
	
	
	 /* Cancel Job Start */
   public function cancel_job(){
	   if($this->input->post('job_code') != ''){
		  $job_code = $this->input->post('job_code');
		  $where = array('job_code' =>$job_code,'status'=>'1','job_complete_status'=>'0');
		  $check_job_info = get_single_row(TBL_MCDOWN,$where);
		  //print_r($check_job_info); exit;
		  if($check_job_info['id'] != ''){
			$data['status'] = '0';
			$this->db->where('job_code',$job_code);
			$update = $this->db->update(TBL_MCDOWN,$data);
            if($update != ''){
				$action = 'JOB CANCELED'; 
				system_mcdown_updates($job_code,$action);
				//$machine_id = GetSingleValue(TBL_MCDOWN,array('job_code'=>$job_code),'machine');
		        //$machine_name = GetSingleValue(MST_MACHINE,array('id'=>$machine_id),'machine');
				//$update_to = $machine_name.' Job canceled';
				//system_mcdown_updates_boots($job_code,$update_to);
				
				$result = array('result' => 'success','message' => 'Job canceled successfully');
			}else{
				$result = array('result' => 'error','message' => 'Job cancel failed!');
			}
		  }else{
			$result = array('result' => 'error','message' => 'Enter active job code');  
		  }
		    
	   }else{
		  $result = array('result' => 'error','message' => 'Job cancel failed!');	  
	   }
	   echo json_encode($result);
   }
   /* Cancel Job End */
	
	
	
	
	
	
	
	
	
	
	
}