<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Message extends CI_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->library('notification');
        $this->load->helper('common_helper');
    }
    
    public function insert_message(){
    	if($this->input->post()){
    		$data = $this->input->post(); 
    			$notify_data['msg_from']	= $this->session->userdata('user_id');
    		if($data['msg_type'] == 1){
    			$notify_data['msg_group']	= 0;
    			$notify_data['msg_to']		= $data['msg_msg_to'];
    		}
    		if($data['msg_type'] == 2){
    			$notify_data['msg_group']	= 1;
			$notify_data['group_id']	= $data['msg_group_id'];
    		}
		$notify_data['message']		= $data['msg_message'];
		$notify_data['notes']		= $data['msg_notes'];
		$notify_data['identify']	= $data['msg_identify'];
		$notify_data['created_on']	= date('Y-m-d H:i:s');
		$notify_data['updated_on']	= '0000-00-00 00:00:00';
		$notify_data['status']		= 1;
		//echo '<pre>';print_r($notify_data);exit;
		$messages = $this->notification->message($notify_data);
		if($messages['result']=='success'){
			echo  json_encode(array('result' => 'success','message' => 'message inserted successfully'));
		}else{
			echo  json_encode(array('result' => 'failed','message' => 'insertion failed'));
		}
    		
    	}else{
    		echo  json_encode(array('result' => 'failed','message' => 'data not received'));
    	} 
    }
    
    public function get_user_list(){
    	
    	$option = '<option value="">SELECT USER</option>';
    	
    	$this->db->where('status',1);
    	$query = $this->db->get('tbl_users');
    	if($query->num_rows() > 0){
    		$results = $query->result_array();
    		foreach($results as $key => $result){
    			$option .= '<option value="'.$result['id'].'">'.$result['username'].'</option>';
    		}
    	}
    	
    	echo $option;
    }
    
    public function get_group_list(){
    
    	//$options = designation();
    	$options = '<option value="">SELECT GROUP</option><option value="5" >Assembly</option>'; 
    	echo $options;
    }
    
    public function get_all_notifies(){
    	$this->db->where('status',1);
    	$this->db->order_by('notify_id','desc'); 
    	$query = $this->db->get('tbl_notification');
    	$data = '';
    	if($query->num_rows() > 0){
    		$results = $query->result_array();
    		foreach($results as $key => $result){
    			$row['notify_id']   	= $result['notify_id']; 
    			$row['msg_from']	= get_username($result['msg_from']);
    			if($result['msg_group']==1){
    				$row['msg_to']	= get_designation($result['group_id']).' group';
    			}else{
    				$row['msg_to']	= get_username($result['msg_to']);
    			}	
    			if($result['ack_status'] == 1){
    				if($result['ack_user'] != ''){
	    				$row['ack_user']	= get_username($result['ack_user']);
	    			}else{
	    				$row['ack_user']		= '-';
	    			} 
    				
    				if($result['ack_message'] != ''){
	    				$row['ack_message']		= $result['ack_message'];
	    			}else{
	    				$row['ack_message']		= '-';
	    			} 
    			}else{
    				$row['ack_user']	= 'No Yet';
    				$row['ack_message']	= ' - ';
    			}
    			
    			if($result['message'] != ''){
    				$row['message']		= $result['message'];
    			}else{
    				$row['message']		= '-';
    			}
    			if($result['notes']!=''){
    				$row['notes']   	= $result['notes'];
    			}else{
    				$row['notes']   	= '-';
    			}
    			 
    			
    			$row['date']   	= date('Y-m-d h:i A',strtotime($result['created_on'])); 
    			$notifications[] =$row;
    		}
    		
    		foreach($notifications as $notify_key => $notification){
    			$data .='<tr>
    				<td>'.$notification['msg_from'].'</td>
				<td>'.$notification['msg_to'].'</td>
				<td>'.$notification['message'].'</td>
				<td>'.$notification['notes'].'</td>
				<td>'.$notification['ack_user'].'</td>
				<td>'.$notification['ack_message'].'</td>
				<td>'.$notification['date'].'</td>
				</tr>';
    		}
    		echo $data;
    	}else{
    		$data .='<td colspan ="7"> No Notifications Found </td>'; 
    		echo $data;
    	}
    	
    	
    }
    
}