<?php

class mobile_model extends CI_Model {


// Return All Records
    function update_shift($data,$shift_id){
        $this->db->where('id',$shift_id);
        $this->db->update(TBL_SHIFT,$data);
        if($this->db->affected_rows() >=0){
          return true; 
        }else{
          return false; 
        }
    }
    function get_shift_id($date){ 
        $this->db->where('date_from',$date); 
        $result = $this->db->get(TBL_SHIFT)->row_array();  
        return $result['id'];
    }    
    function get_reasons(){
        $this->db->where('status',1);
        $this->db->order_by('position','asc');
        $results = $this->db->get(MST_REASONS)->result_array();
        return $results;
    }
    function get_users(){
        $this->db->where('status',1);
        $this->db->order_by('id','asc');
        $results = $this->db->get(TBL_USERS)->result_array();
        return $results;
    }
    function get_machines(){
        $this->db->select('machine,id');
        $this->db->where('status',1);
        $this->db->order_by('position','asc');
        $result=$this->db->get(MST_MACHINE)->result_array();
        return $result;
    }

// Return Single Records

    function reason_view($id){
        $this->db->where('id',$id); 
        $result = $this->db->get(MST_REASONS)->row_array();
        return $result;
    }
    function machine_view($id){
        $this->db->where('id',$id); 
        $result = $this->db->get(MST_MACHINE)->row_array();
        return $result;
    }
    function user_view($id){
        $this->db->where('id',$id); 
        $result = $this->db->get(TBL_USERS)->row_array();
        return $result;
    }



// Delete Records by ID

    function reason_delete($id){
        $data['status'] = 0;
        $this->db->where('id',$id);
        $this->db->update(MST_REASONS,$data);
        if( $this->db->affected_rows() > 0 ){
            return $id;
        }else{
            return false;
        }
    }

    function machine_delete($id){
        $data['status'] = 0;
        $this->db->where('id',$id);
        $this->db->update(MST_MACHINE,$data);
        if( $this->db->affected_rows() > 0 ){
            return $id;
        }else{
            return false;
        }
    }

    function user_delete($id){
        $data['status'] = 0;
        $this->db->where('id',$id);
        $this->db->update(TBL_USERS,$data);
        if( $this->db->affected_rows() > 0 ){
            return $id;
        }else{
            return false;
        }
    }

// LOGIN CODE 

    function check_user_avail($data){ 
        $this->db->where('username',$data['login_username']);
        $this->db->where('status',1);
        $query = $this->db->get(TBL_USERS); 
        if( $query->num_rows() > 0 ){
            return $query->num_rows;
        }else{
            return FALSE;
        }
    }

    function auth_user($data){
        $this->db->where('username',$data['login_username']);
        $this->db->where('password',md5($data['login_password']));
        $query = $this->db->get(TBL_USERS);
        if( $query->num_rows() > 0 ){
            return TRUE;
        }else{
            return FALSE;
        }
    }
    function get_userinfo($username){
        $this->db->where('username',$username);
        $query = $this->db->get(TBL_USERS);
        if( $query->num_rows() > 0 ){
            return $query->row_array();
        }else{
            return FALSE;
        }
    }
    function insert_down($data){
        $this->db->insert(TBL_MCDOWN,$data);
        $insert_id = $this->db->insert_id();
        return  $insert_id;
    }
    function get_machine_id($name){ 
        $this->db->like('machine',$name);
        $this->db->where('status',1); 
        $this->db->limit(1);
        $result = $this->db->get(MST_MACHINE)->row_array();  
        return $result['id'];
    }
    function get_down_machine_id($name){ 
        $this->db->like('machine',$name);
        $this->db->where('status',1); 
        $this->db->limit(1);
        $result = $this->db->get(MST_MACHINE)->result_array();  
        return $result;
    }    
    function get_all_machine_id(){
        $this->db->where('status',1); 
        $result = $this->db->get(MST_MACHINE)->result_array();  
        return $result;
    }
    function last_machine_down(){
        $this->db->where('status',1);
        $this->db->order_by('id','desc'); 
        $this->db->limit(1);
        $result = $this->db->get(TBL_MCDOWN)->row_array();  
        if( $result['mc_down']==1 || $result['other_down']==1){
            return $result;
        }else{
            return 0;
        }
    }
//setup
    function get_job_details($job_code){ 
        $this->db->where('job_code',$job_code);
        $this->db->where('status',1);
        $this->db->order_by('id','desc'); 
        $result = $this->db->get(TBL_MCDOWN)->row_array();  
        return $result;
    }

    function update_jobstatus($data,$job_id){
        $this->db->where('id',$job_id);
        $this->db->update(TBL_MCDOWN,$data);
        if( $this->db->affected_rows() > 0 ){
            return $job_id;
        }else{
            return false;
        }
    }
 
  /*  function check_job_status($data){
        //print_r($data).'<br/>';
        $time_from = $data['time_from'];
        $time_to = $data['time_to'];
        $this->db->select('*');
        //$this->db->where('date_from',$data['date']);
        $this->db->where('date_to',$data['date']);
        $this->db->where('machine',$data['machine']);
        $this->db->where('shift',$data['shift']);
        $results = $this->db->get(TBL_MCDOWN)->result();
        $value = 0;
        $mcdown= 0;
        $mcdown_id=array(); 

        foreach ($results as $key => $result) {
            $test=(check_time($result->time_from,$result->time_to, $time_from) ? 1 : 0);
            if($test){
                $value = $value+1; 
                //print_r($result).'<br/>';
                if(($result->mc_down==1)||($result->other_down==1)){
                    $mcdown= $mcdown+1;
                    $mcdown_id[]=$result->id;;
                }
            }elseif((($result->mc_down == 1)||($result->other_down == 1))&&(($result->time_from == '08:00:00')&&($result->time_to == '20:00:00'))){
                $mcdown= $mcdown+1;
                $mcdown_id[]=$result->id;
            }
        } 
        if($value > 0){
            if($mcdown > 0){
                $return['job']=1;
                $return['mcdown']=1;
                $return['mcdown_id']=$mcdown_id;
                return $return;
            }else{
                $return['job']=1;
                $return['mcdown']=0;
                return $return;
            }
        }else{
            $return['job']=0;
            if($mcdown > 0){
                $return['mcdown']=1;
            }else{
                $return['mcdown']=0;
            }
            return $return;
        }
    } */

// tooling

    function check_job_status($data){
        //print_r($data).'<br/>';
        $time_from = date("H:i:00", strtotime("-5 minutes", strtotime($data['time_from'])));
        $time_to = $data['time_to'];
        $this->db->select('*');
        //$this->db->where('date_from',$data['date']);
        $this->db->where('date_to',$data['date']);
        $this->db->where('machine',$data['machine']);
        $this->db->where('shift',$data['shift']);
        $results = $this->db->get(TBL_MCDOWN)->result();
        $value = 0;
        $mcdown= 0;
        $mcdown_id=array(); 

        foreach ($results as $key => $result) {
            $test=(check_time($result->time_from,$result->time_to, $time_from) ? 1 : 0);
            if($test){
                $value = $value+1; 
                //print_r($result).'<br/>';
                if(($result->mc_down==1)||($result->other_down==1)){
                    $mcdown= $mcdown+1;
                    $mcdown_id[]=$result->id;;
                }
            }elseif((($result->mc_down == 1)||($result->other_down == 1))&&(($result->time_from == '07:00:00')&&($result->time_to == '20:00:00'))){
                $mcdown= $mcdown+1;
                $mcdown_id[]=$result->id;
            }
        } 
        if($value > 0){
            if($mcdown > 0){
                $return['job']=1;
                $return['mcdown']=1;
                $return['mcdown_id']=$mcdown_id;
                return $return;
            }else{
                $return['job']=1;
                $return['mcdown']=0;
                return $return;
            }
        }else{
            $return['job']=0;
            if($mcdown > 0){
                $return['mcdown']=1;
            }else{
                $return['mcdown']=0;
            }
            return $return;
        }
    }

    function get_job_details_boots($job_code){
        $CI =& get_instance();
        $this->db = $CI->load->database('default', TRUE);
        $this->boots = $CI->load->database('boots', TRUE);
        $this->boots->where('tjob_code',$job_code);
        $query = $this->boots->get('tbl_tooling_jobs');

        if($query->num_rows() > 0){
            return $query->row_array();
        }else{
            return false;
        }
    }
    function update_job_details_boots($update,$job_code){
        $CI =& get_instance();
        $this->db = $CI->load->database('default', TRUE);
        $this->boots = $CI->load->database('boots', TRUE);

        $this->boots->where('tjob_code',$job_code);
        $this->boots->update('tbl_tooling_jobs',$update);
        if( $this->boots->affected_rows() > 0 ){
            return $job_code;
        }else{
            return false;
        }
    }
    function update_job_details_setup_status($update,$job_code){
        $CI =& get_instance();
        $this->db = $CI->load->database('default', TRUE);
        $this->boots = $CI->load->database('boots', TRUE);

        $this->boots->where('tjob_code',$job_code);
        $this->boots->update('tbl_tooling_jobs',$update);
        if( $this->boots->affected_rows() > 0 ){
            return $job_code;
        }else{
            return false;
        }
    }
    function update_job_status_boots($status){

        $CI =& get_instance();
        $this->db = $CI->load->database('default', TRUE);
        $this->boots = $CI->load->database('boots', TRUE);

        $this->boots->insert('tbl_tooling_updates',$status);
        $insert_id = $this->boots->insert_id();
        return  $insert_id;
    }
    /*function insert_machine_down($data){
        $date = date('Y-m-d');
        $min_per_day = 780;
        $job_from_time = $date.' 07:00:00';
        $job_end_time = $date.' 20:00:00';

        $time_from = $data['time_from'];
        $time_to = $data['time_to'];
        
        $this->db->select('*');
        $this->db->where('date_from ',$data['date_from']); 
        $this->db->where('machine',$data['machine']);
        $this->db->where('shift',$data['shift']);
        $results = $this->db->get(TBL_MCDOWN)->result_array();
        
        usort($results , 'sortBytime_from'); 


        foreach ($results as $key => $result) {
            $test=(check_time($result['time_from'],$result['time_to'],$time_from) ? 1 : 0);
            if($test){
                $job_match = $key;
            } 
        }
        //echo "<pre>";print_r($results[$job_match]);exit;
        if(isset($job_match)){ 
            for($i=0;$i < $job_match-1;$i++){
               // unset($results[$i]);
            }
            $old_time =$data['time_to'];
            $from_date = $data['date_from']; 
            
            $job_from_time = $data['date_from'].' '.$data['time_to'];

        foreach ($results as $key => $result) {
        $datetime1 = new DateTime($from_date.' '.$result['time_from']);
		$datetime2 = new DateTime($from_date.' '.$result['time_to']);
		$interval = $datetime1->diff($datetime2);
		$diffhour = $interval->format('%h');
		$diffmin = $interval->format('%i');
                
        $new['date_from'] = $from_date; 
        $new['date_to'] = $from_date;
        $new['time_from'] = $old_time ;

		$startTime = new DateTime($new['time_from']);
		$startTime->modify('+'.$diffhour.' hours');
		$startTime->modify('+'.$diffmin.' minutes');

		$new['time_to'] = $startTime->format('H:i:s');

		if($from_date.' '.$new['time_to'] > $from_date.' 20:00:00'){ 
                    $from_date = date('Y-m-d', strtotime($from_date . " +1 days"));
                    $datetime1 = new DateTime($from_date.' '.$result['time_from']);
                    $datetime2 = new DateTime($from_date.' '.$result['time_to']);
                    $interval = $datetime1->diff($datetime2);
                    $diffhour = $interval->format('%h');
                    $diffmin = $interval->format('%i');

                    $new['date_from'] = $from_date; 
                    $new['date_to'] = $from_date;
                    $new['time_from'] = '07:00:00';

                    $EndTime = new DateTime($from_date.''.$new['time_from']);
                    $EndTime->modify('+'.$diffhour.' hours');
                    $EndTime->modify('+'.$diffmin.' minutes');

                    $new['time_to'] = $EndTime->format('H:i:s');
                    $new['updated_on'] = date('Y-m-d H:i:s');
                }
                $this->db->where('id',$result['id']);
                $this->db->update(TBL_MCDOWN,$new);
                $old_time =$new['time_to'];
            } 
        } 
        $this->db->insert(TBL_MCDOWN,$data);
        $insert_id = $this->db->insert_id();
        
        return  $insert_id;
         
    }*/
    
    
    function insert_machine_down($data){
       
        $date = date('Y-m-d');
        $min_per_day = 780;
        $job_from_time = $date.' 07:00:00';
        $job_end_time = $date.' 20:00:00';
        $time_from = $data['time_from'];
        $time_to = $data['time_to'];
        $this->db->select('*');
        $this->db->where('date_from ',$data['date_from']); 
        $this->db->where('machine',$data['machine']);
        $this->db->where('shift',$data['shift']);
        $results = $this->db->get(TBL_MCDOWN)->result_array();
        
        usort($results , 'sortBytime_from'); 


        foreach ($results as $key => $result) {
            $test=(check_time($result['time_from'],$result['time_to'],$time_from) ? 1 : 0);
            if($test){
                $job_match = $key;
            } 
        }

        if(isset($job_match)){ 
            for($i=0;$i < $job_match-1;$i++){
                //unset($results[$i]);
            }
            $old_time =$data['time_to'];
            $from_date = $data['date_from']; 
            
            $job_from_time = $data['date_from'].' '.$data['time_to'];

          foreach ($results as $key => $result) {
                
            	$datetime1 = new DateTime($from_date.' '.$result['time_from']);
        		$datetime2 = new DateTime($from_date.' '.$result['time_to']);
        		$interval = $datetime1->diff($datetime2);
        		$diffhour = $interval->format('%h');
        		$diffmin = $interval->format('%i');
                
                $new['date_from'] = $from_date; 
                $new['date_to'] = $from_date;
                $new['time_from'] = $old_time ;

        		$startTime = new DateTime($new['time_from']);
        		$startTime->modify('+'.$diffhour.' hours');
        		$startTime->modify('+'.$diffmin.' minutes');

		        $new['time_to'] = $startTime->format('H:i:s');

		    if($from_date.' '.$new['time_to'] > $from_date.' 20:00:00'){ 
                    $from_date = date('Y-m-d', strtotime($from_date . " +1 days"));
                    $datetime1 = new DateTime($from_date.' '.$result['time_from']);
                    $datetime2 = new DateTime($from_date.' '.$result['time_to']);
                    $interval = $datetime1->diff($datetime2);
                    $diffhour = $interval->format('%h');
                    $diffmin = $interval->format('%i');

                    $new['date_from'] = $from_date; 
                    $new['date_to'] = $from_date;
                    $new['time_from'] = '07:00:00';

                    $EndTime = new DateTime($from_date.''.$new['time_from']);
                    $EndTime->modify('+'.$diffhour.' hours');
                    $EndTime->modify('+'.$diffmin.' minutes');

                    $new['time_to'] = $EndTime->format('H:i:s');
                    $new['updated_on'] = date('Y-m-d H:i:s');

                }
		        $this->db->where('id',$result['id']);
        	    $this->db->update(TBL_MCDOWN,$new);
		        $old_time =$new['time_to'];
            }
        }
        if($data['override']==1){
            
            unset($data['override']);
            $this->db->where('id ',$data['id']); 
            $this->db->update(TBL_MCDOWN,$data);
            $insert_id = $data['id'];
        }else{
            unset($data['override']);
            $this->db->insert(TBL_MCDOWN,$data);
            $insert_id = $this->db->insert_id();           
        }
        return  $insert_id; 
        /*$this->db->insert(TBL_MCDOWN,$data);
        $insert_id = $this->db->insert_id(); 
        return  $insert_id; */
    } 
    function insert_machine_down1($data){
        $date = date('Y-m-d');
        $min_per_day = 780;
        $job_from_time = $date.' 07:00:00';
        $job_end_time = $date.' 20:00:00';
        $time_from = $data['time_from'];
        $time_to = $data['time_to'];
        $this->db->select('*');
        $this->db->where('date_from ',$data['date_from']); 
        $this->db->where('machine',$data['machine']);
        $this->db->where('shift',$data['shift']);
        $this->db->where('time_to >',$data['time_to']);
        $results = $this->db->get(TBL_MCDOWN)->result_array();
        
        usort($results , 'sortBytime_from'); 


        foreach ($results as $key => $result) {
            $test=(check_time($result['time_from'],$result['time_to'],$time_from) ? 1 : 0);
            if($test){
                $job_match = $key;
            } 
        }

        //if(isset($job_match)){ 
            //for($i=0;$i < $job_match-1;$i++){
                //unset($results[$i]);
            //}
            $old_time =$data['time_to'];
            $from_date = $data['date_from']; 
            
            $job_from_time = $data['date_from'].' '.$data['time_to'];
          $s = 0;
          $nxt = 0;
          
          foreach ($results as $key => $result) {
            	$datetime1 = new DateTime($from_date.' '.$result['time_from']);
        		$datetime2 = new DateTime($from_date.' '.$result['time_to']);
        		$interval = $datetime1->diff($datetime2);
        		$diffhour = $interval->format('%h');
        		$diffmin = $interval->format('%i');
                if($s == 0){
                    $new['date_from'] = $from_date; 
                    $new['date_to'] = $from_date;
                    $new['time_from'] = $old_time ;
            		$startTime = new DateTime($new['time_from']);
            		$startTime->modify('+'.$diffhour.' hours');
            		$startTime->modify('+'.$diffmin.' minutes');
    		        $new['time_to'] = $startTime->format('H:i:s');
                }else{
                    $new['date_from'] = $from_date; 
                    $new['date_to'] = $from_date;
                    $new['time_from'] = $last_from_time ;
            		$startTime = new DateTime($new['time_from']);
            		$startTime->modify('+'.$diffhour.' hours');
            		$startTime->modify('+'.$diffmin.' minutes');
    		        $new['time_to'] = $startTime->format('H:i:s');  
                }
		   if($from_date.' '.$new['time_to'] > $from_date.' 20:00:00'){

                    $from_date = date('Y-m-d', strtotime($from_date . " +1 days"));
                    $datetime1 = new DateTime($from_date.' '.$result['time_from']);
                    $datetime2 = new DateTime($from_date.' '.$result['time_to']);
                    $interval = $datetime1->diff($datetime2);
                    $diffhour = $interval->format('%h');
                    $diffmin = $interval->format('%i');
                    if($nxt==0){
                        $new['date_from'] = $from_date; 
                        $new['date_to'] = $from_date;
                        $new['time_from'] = '07:00:00';
                        $EndTime = new DateTime($from_date.''.$new['time_from']);
                        $EndTime->modify('+'.$diffhour.' hours');
                        $EndTime->modify('+'.$diffmin.' minutes');
                        $new['time_to'] = $EndTime->format('H:i:s');
                    }else{
                        $new['date_from'] = $from_date; 
                        $new['date_to'] = $from_date;
                        $new['time_from'] = $last_from_time ;
                        $EndTime = new DateTime($from_date.''.$new['time_from']);
                        $EndTime->modify('+'.$diffhour.' hours');
                        $EndTime->modify('+'.$diffmin.' minutes');
                        $new['time_to'] = $EndTime->format('H:i:s');                       
                    }
                    $new['updated_on'] = date('Y-m-d H:i:s');
                    $nxt++;
                }
		        $this->db->where('id',$result['id']);
        	    $this->db->update(TBL_MCDOWN,$new);
		        $old_time =$new['time_to'];
		        
                $this->db->select('*');
                $this->db->where('id ',$result['id']); 
                $get_last = $this->db->get(TBL_MCDOWN)->row_array();		        
		        $last_from_time =$get_last['time_to'];
		        $s++;
            }
        //}
        if($data['override']==1){
            
            unset($data['override']);
            $this->db->where('id ',$data['id']); 
            $this->db->update(TBL_MCDOWN,$data);
            $insert_id = $data['id'];
        }else{
            unset($data['override']);
            $this->db->insert(TBL_MCDOWN,$data);
            $insert_id = $this->db->insert_id();           
        }
        return  $insert_id; 
    } 
    
    function update_upcomingjobs_time($date,$shift,$machine,$time,$starttime,$job_id){
        $this->db->select('*');
        $this->db->where('date_from ',$date); 
        $this->db->where('machine',$machine);
        $this->db->where('id !=',$job_id);
        $this->db->where('shift',$shift);
        $this->db->where('time_from >',$time);
        $results = $this->db->get(TBL_MCDOWN)->result_array();
        //print_r($date);print_r($shift);print_r($machine);print_r($time);print_r($starttime);print_r($results);exit;
        usort($results , 'sortBytime_from');
        $start_time = $starttime;
        foreach ($results as $key => $result) {
            $data['time_from'] = $start_time;
            $datetime1 = new DateTime($result['date_from'].' '.$result['time_from']);
            $datetime2 = new DateTime($result['date_to'].' '.$result['time_to']);
            $interval = $datetime1->diff($datetime2);
            $diffhour = $interval->format('%h');
            $diffmin = $interval->format('%i');
            $EndTime = new DateTime($data['time_from']);
            $EndTime->modify('+'.$diffhour.' hours');
            $EndTime->modify('+'.$diffmin.' minutes');
            $data['time_to'] = $EndTime->format('H:i:s');
             
            $this->db->where('id',$result['id']);
            $this->db->update(TBL_MCDOWN,$data);
            $start_time = $data['time_to'];
        } 
    }
    function get_job_details_id($id){ 
        $this->db->where('id',$id); 
        $result = $this->db->get(TBL_MCDOWN)->row_array();  
        return $result;
    }
    function check_job_availability($data){
        $time_from = $data['time_from'];
        $time_to = $data['time_to'];
        $this->db->select('*');
        $this->db->where('date_from',$data['date']);
        $this->db->where('date_to',$data['date']);
        $this->db->where('machine',$data['machine']);
        $this->db->where('shift',$data['shift']);
        $this->db->where('status',1);
        $results = $this->db->get(TBL_MCDOWN)->result();
        $value = 0;
        $mcdown= 0;
        /*foreach ($results as $key => $result) {
            $test=(check_time($result->time_from,$result->time_to, $time_from) ? 1 : 0);
            if($test){
                $value = $value+1;
                if($result->mc_down==1){
                    $mcdown= $mcdown+1;
                }
            }elseif($result->mc_down == 1){
                $mcdown= $mcdown+1;
            }
        }*/

        foreach ($results as $key => $result) {
            $test=(check_time($result->time_from,$result->time_to,$time_from) ? 1 : 0);
            if($test){ 
                $value = $value+1;
                if($result->mc_down == 1){
                    $mcdown= $mcdown+1;
                }
            }
        } 
        if($value > 0){
            $return['job']=1;
            if($mcdown > 0){ 
            	$return['mcdown']=1;
            	return $return;
            }else{ 
            	$return['mcdown']=0;
               
            }
            return $return;
        }else{
            $return['job']=0;
            if($mcdown > 0){
                $return['mcdown']=1;
            }else{
                $return['mcdown']=0;
            }
            return $return;
        }
    }

    function get_machine_name($id){
        $this->db->select('machine');
        $this->db->where('id',$id); 
        $result=$this->db->get(MST_MACHINE)->row_array();
        return $result['machine'];
    }
    
    function check_machine_exist($machine_name){
        $this->db->where('machine',$machine_name);
        $this->db->where('status',1);
        $query = $this->db->get(MST_MACHINE);
        if( $query->num_rows() > 0 ){
             return TRUE;
        }else{
            return FALSE;
        }
    }

    function find_job_state($job_code){

        $job_details_spcs = $this->get_job_details($job_code);

        $job_details_boots = $this->get_job_details_boots($job_code);


        if($job_details_boots['tjob_tooling_status']==2){
            return 'Tooling Finished';
        }elseif($job_details_boots['tjob_tooling_status']==1){
            return 'Tooling Started';
        }elseif($job_details_spcs['setup']==2){
            return 'Setup Finished';
        }elseif($job_details_spcs['setup']==1){
            return 'Setup Started';
        }else{
            return 'Loaded';
        }
    }

    function get_cft_reports($machine,$reason){
         $sql_query = "SELECT * FROM  `tbl_cft_report` WHERE  `machine` LIKE  '%".$machine."%' AND  `reason` LIKE  '%".$reason."%' AND  `status` =1";
         $result = $this->db->query($sql_query);
         if($result->num_rows() > 0 ){
             return $result->result_array();
         }else{
             return FALSE;
         }
         
    }

    function get_cft_user($user_id){
        
        $this->db->where('id',$user_id);
        $result = $this->db->get('mst_cftmembers');
        return $result->row_array();
    }
    function check_tooling_qty_status($tooling){
        $this->db->where('machine',$tooling['machine']);
    	$this->db->where('side',$tooling['side']);
    	$this->db->where('order_id',$tooling['order_id']);
    	$this->db->where('current_qty',$tooling['current_qty']); 
    	$query = $this->db->get('tbl_tooling_timings');
         if($query->num_rows() > 0 ){
             return TRUE;
         }else{
             return FALSE;
         }
    }
    function check_tooling_first_qty($tooling){
        
        $this->db->where('machine',$tooling['machine']);
    	$this->db->where('side',$tooling['side']);
    	$this->db->where('order_id',$tooling['order_id']);
    	$this->db->where('current_qty',1); 
    	$query = $this->db->get('tbl_tooling_timings');
         if($query->num_rows() > 0 ){
             return TRUE;
         }else{
             return FALSE;
         }        
    }
    function get_total_qty($job_code){ 
        $this->db->where('job_code',$job_code);
        $this->db->where('status',1);
        $this->db->order_by('id','desc'); 
        $result = $this->db->get(TBL_MCDOWN)->row_array();  
        return $result;
    }    
    
    function get_job_status($job_code,$current_status){
    
	$job_details_boots = $this->get_job_details_boots($job_code);
	$job_details_spcs = $thi->get_job_details($job_code);
    	
    	if($job_details_boots['tjob_complet_status']){
    		$status = array('status'=>12,'status_word'=>'DELIVERED','job_code'=>$job_code);
    	}elseif($job_details_boots['tjob_shipped_status']){
    		$status = array('status'=>11,'status_word'=>'SHIPPING','job_code'=>$job_code);
    	}elseif($job_details_spcs['assy_end']){
    		$status = array('status'=>10,'status_word'=>'ASSY FINISH','job_code'=>$job_code);
    	}elseif($job_details_spcs['assy_end']){
    		$status = array('status'=>9,'status_word'=>'ASSY START','job_code'=>$job_code);
    	}elseif($job_details_spcs['qc_end']){
    		$status = array('status'=>8,'status_word'=>'QC FINISH','job_code'=>$job_code);
    	}elseif($job_details_spcs['qc_start']){
    		$status = array('status'=>7,'status_word'=>'QC START','job_code'=>$job_code);
    	}elseif($job_details_spcs['tooling_end']){
    		$status = array('status'=>6,'status_word'=>'TOOLING FINISH','job_code'=>$job_code);
    	}elseif($job_details_spcs['tooling_start']){
    		$status = array('status'=>5,'status_word'=>'TOOLING START','job_code'=>$job_code);
    	}elseif($job_details_spcs['setup_end']){
    		$status = array('status'=>4,'status_word'=>'SETUP FINISH','job_code'=>$job_code);
    	}elseif($job_details_spcs['setup_start']){
    		$status = array('status'=>3,'status_word'=>'SETUP START','job_code'=>$job_code);
    	}elseif($job_details_boots['tjob_cad_status']){
    		$status = array('status'=>2,'status_word'=>'CAD FINISHED','job_code'=>$job_code);
    	}elseif($job_details_boots['tjob_cad_status']){
    		$status = array('status'=>1,'status_word'=>'CAD START','job_code'=>$job_code);
    	}else{
    		$status = array('status'=>0,'status_word'=>'STATUS NOT FOUND','job_code'=>$job_code);
    	}
    	
    	if($current_status == $status['starts']){
    		echo json_encode(array('result' =>'failure','message'=> $status['status_word'].' Already Done.'));
    	}elseif(($current_status-1) > $status['starts']){
    	    echo json_encode(array('result' =>'failure','message'=> $status['status_word'].' State '));
    	}
 
    }
    
    function get_setup_state($setup){
    	$this->db->where('machine',$setup['machine']);
    	$this->db->where('order_id',$setup['order_id']);
    	$this->db->where('side',$setup['side']); 
    	$query = $this->db->get('tbl_setup_timing');
    	
    	if($query->num_rows() > 0){
    		$result = $query->row_array();
    		if($result['resetup2_end']!='0000-00-00 00:00:00'){
    			$result = array('state'=>6,'msg'=>'this order second resetup finished','setup_id'=>$result['setup_id']);
    		}elseif($result['resetup2_start']!='0000-00-00 00:00:00'){
    			$result = array('state'=>5,'msg'=>'this order second resetup started','setup_id'=>$result['setup_id']);
    		}elseif($result['resetup1_end']!='0000-00-00 00:00:00'){
    			$result = array('state'=>4,'msg'=>'this order resetup finished','setup_id'=>$result['setup_id']);
    		}elseif($result['resetup1_start']!='0000-00-00 00:00:00'){
    			$result = array('state'=>3,'msg'=>'this order resetup started','setup_id'=>$result['setup_id']);
    		}elseif($result['setup_end']!='0000-00-00 00:00:00'){
    			$result = array('state'=>2,'msg'=>'this order setup finished','setup_id'=>$result['setup_id']);
    		}elseif($result['setup_start']!='0000-00-00 00:00:00'){
    			$result = array('state'=>1,'msg'=>'this order setup started','setup_id'=>$result['setup_id']);
    		}
    	}else{
    		$result = array('state'=>0,'msg'=>'this order setup not yet started','setup_id'=>0);
    	}
    	
    	return $result;
    }
   
    function get_tooling_qty_state1($tooling){
        
        
        
        
    	$this->db->where('machine',$tooling['machine']);
    	$this->db->where('side',$tooling['side']);
    	$this->db->where('order_id',$tooling['order_id']);
    	$this->db->where('current_qty',$tooling['current_qty']); 
    	$query = $this->db->get('tbl_tooling_timings');
    	if($query->num_rows() > 0){
    		$result = $query->row_array();
    		if($result['tooling2_end']!='0000-00-00 00:00:00'){
    			$result = array('state'=>6,'msg'=>'this quantity second retooling finished','tooling_id'=>$result['tooling_id']);
    		}elseif($result['tooling2_start']!='0000-00-00 00:00:00'){
    			$result = array('state'=>5,'msg'=>'this quantity second retooling started','tooling_id'=>$result['tooling_id']);
    		}elseif($result['tooling1_end']!='0000-00-00 00:00:00'){
    			$result = array('state'=>4,'msg'=>'this quantity retooling finished','tooling_id'=>$result['tooling_id']);
    		}elseif($result['tooling1_start']!='0000-00-00 00:00:00'){
    			$result = array('state'=>3,'msg'=>'this quantity retooling started','tooling_id'=>$result['tooling_id']);
    		}elseif($result['tooling_end']!='0000-00-00 00:00:00'){
    			$result = array('state'=>2,'msg'=>'this quantity tooling finished','tooling_id'=>$result['tooling_id']);
    		}elseif($result['tooling_start']!='0000-00-00 00:00:00'){
    			$result = array('state'=>1,'msg'=>'this quantity tooling started','tooling_id'=>$result['tooling_id']);
    		}
    	}else{
    	     $result = array('state'=>0,'msg'=>'this quantity not yet started tooling','tooling_id'=>0);
    	}
    	return $result ; 
    }   
   
   
    
    function get_tooling_qty_state($tooling){

    	$this->db->where('machine',$tooling['machine']);
    	$this->db->where('side',$tooling['side']);
    	$this->db->where('order_id',$tooling['order_id']);
    	$this->db->where('current_qty',$tooling['current_qty']); 
    	$query = $this->db->get('tbl_tooling_timings');
    	if($query->num_rows() > 0){
    		$result = $query->row_array();
    		if($result['tooling2_end']!='0000-00-00 00:00:00'){
    			$result = array('state'=>6,'msg'=>'this quantity second retooling finished','tooling_id'=>$result['tooling_id']);
    		}elseif($result['tooling2_start']!='0000-00-00 00:00:00'){
    			$result = array('state'=>5,'msg'=>'this quantity second retooling started','tooling_id'=>$result['tooling_id']);
    		}elseif($result['tooling1_end']!='0000-00-00 00:00:00'){
    			$result = array('state'=>4,'msg'=>'this quantity retooling finished','tooling_id'=>$result['tooling_id']);
    		}elseif($result['tooling1_start']!='0000-00-00 00:00:00'){
    			$result = array('state'=>3,'msg'=>'this quantity retooling started','tooling_id'=>$result['tooling_id']);
    		}elseif($result['tooling_end']!='0000-00-00 00:00:00'){
    			$result = array('state'=>2,'msg'=>'this quantity tooling finished','tooling_id'=>$result['tooling_id']);
    		}elseif($result['tooling_start']!='0000-00-00 00:00:00'){
    			$result = array('state'=>1,'msg'=>'this quantity tooling started','tooling_id'=>$result['tooling_id']);
    		}
    	}else{
    	     $result = array('state'=>0,'msg'=>'this quantity not yet started tooling','tooling_id'=>0);
    	}
    	return $result ; 
    }
    
    
    
    
    function insert_setup_time($shift_timing){
    	$this->db->where('order_id',$shift_timing['order_id']);
    	$this->db->where('side',$shift_timing['side']);
    	$this->db->where('machine',$shift_timing['machine']);
    	$query = $this->db->get('tbl_setup_timing');
    	if( $query->num_rows() > 0 ){
    		$shift_timing['updated_on'] = date('Y-m-d H:i:s');
	        $this->db->where('machine',$shift_timing['machine']);
	        $this->db->where('side',$shift_timing['side']);
	    	$this->db->where('order_id',$shift_timing['order_id']);
	        $this->db->update('tbl_setup_timing',$shift_timing);
	        
	        return $shift_timing['order_id'];
    	}else{
    		$shift_timing['created_on'] = date('Y-m-d H:i:s');
	        $shift_timing['status'] = 1;
	        $this->db->insert('tbl_setup_timing',$shift_timing);
	        
	        return $this->db->insert_id();
    	}
    
        
    }
    
    function update_setup_time($shift_timing){
        $shift_timing['updated_on'] = date('Y-m-d H:i:s');
        $this->db->where('machine',$shift_timing['machine']);
        $this->db->where('side',$shift_timing['side']);
    	$this->db->where('order_id',$shift_timing['order_id']);
        $this->db->update('tbl_setup_timing',$shift_timing);
        
        return true;
    }
    
    
    function insert_tooling_time($tooling_timing){
        $tooling_timing['created_on'] = date('Y-m-d H:i:s');
        $tooling_timing['status'] = 1;
        $this->db->insert('tbl_tooling_timings',$tooling_timing);
        
        return $this->db->insert_id();
    }
    
    function update_tooling_time($tooling_timing){
        $tooling_timing['updated_on'] = date('Y-m-d H:i:s');
        $this->db->where('current_qty',$tooling_timing['current_qty']);
        $this->db->where('machine',$tooling_timing['machine']);
        $this->db->where('side',$tooling_timing['side']);
    	$this->db->where('order_id',$tooling_timing['order_id']);
        $this->db->update('tbl_tooling_timings',$tooling_timing);
        
        return true;
    }
    
    function get_setup_time($order_id,$setup = 'setup'){
        
        $this->db->where('order_id',$order_id); 
    	$query = $this->db->get('tbl_setup_timing');
    	if($query->num_rows() > 0 ){
    	    $result = $query->row_array();
    	    
    	    if($setup == 'resetup2'){
    	        $datetime1 = new DateTime($result['resetup2_start']);
        		$datetime2 = new DateTime($result['resetup2_end']);
        		$interval = $datetime1->diff($datetime2);
        		
        		return array('hour'=>$interval->format('%h'),'min'=>$interval->format('%i'));
    	    }elseif($setup == 'resetup1'){
    	        $datetime1 = new DateTime($result['resetup1_start']);
        		$datetime2 = new DateTime($result['resetup1_end']);
        		$interval = $datetime1->diff($datetime2);
        		
        		return array('hour'=>$interval->format('%h'),'min'=>$interval->format('%i'));
    	    }else{
    	        $datetime1 = new DateTime($result['setup_start']);
        		$datetime2 = new DateTime($result['setup_end']);
        		$interval = $datetime1->diff($datetime2);
        		
        		return array('hour'=>$interval->format('%h'),'min'=>$interval->format('%i'));
    	    }
    	    
    	}else{
    	    return array('hour'=>0,'min'=>0);
    	}
    	
    }
    
    function get_totalsetup_time($order_id,$machine_id){
        $this->db->where('order_id',$order_id);
        $this->db->where('machine',$machine_id); 
    	$query = $this->db->get('tbl_setup_timing');
    	if($query->num_rows() > 0 ){
    	    $results = $query->result_array();
    	    foreach($results as $key => $result){
    	    	if($key != 0){
    	    		$datetime1 = new DateTime($result['setup_start']);
			$datetime2 = new DateTime($result['setup_end']);
			$interval = $datetime1->diff($datetime2);
			
			$start_time = date('Y-m-d H:i:00');
			$DiffTime = new DateTime($start_time);
			$DiffTime->modify('+'.$interval->format('%h').' hours');
			$DiffTime->modify('+'.$interval->format('%i').' minutes');
			if(isset($setup)){
				$DiffTime->modify('+'.$setup['hour'].' hours');
				$DiffTime->modify('+'.$setup['min'].' minutes');
			}
			$DiffTimeFrom = new DateTime($start_time);
			$DiffTimeTo = new DateTime($DiffTime->format('Y-m-d H:i:s'));
			$DiffTimeDiff = $DiffTimeFrom->diff($DiffTimeTo);
			$diffhour = $DiffTimeDiff->format('%h');
			$diffmin = $DiffTimeDiff->format('%i');
			$setup = array('hour'=>$diffhour,'min'=>$diffmin);
    	    	}else{
			$datetime1 = new DateTime($result['setup_start']);
			$datetime2 = new DateTime($result['setup_end']);
			$interval = $datetime1->diff($datetime2);
			$setup = array('hour'=>$interval->format('%h'),'min'=>$interval->format('%i'));
    	    	}
    	    } 
            return $setup;
    	}else{
    	    return array('hour'=>0,'min'=>0);
    	}
        
    }

    function get_totaltooling_time($i,$s,$order_id,$machine_id){
        $this->db->select('tooling_start');
        $this->db->where('id',$order_id);
        $this->db->where('status',1);
        $query1 = $this->db->get(TBL_MCDOWN)->row_array();       
        
        $this->db->where('side',$s);
        $this->db->where('current_qty',$i);
        $this->db->where('order_id',$order_id);
        $this->db->where('machine',$machine_id); 
    	$query = $this->db->get('tbl_tooling_timings');
    
    	if($query->num_rows() > 0 ){
    	    $results = $query->result_array();
    	    foreach($results as $key => $result){
    	    /*	if($key != 0){
    	    $datetime1 = new DateTime($result['tooling_start']);
			$datetime2 = new DateTime($result['tooling_end']);
			$interval = $datetime1->diff($datetime2);
			
			$start_time = date('Y-m-d H:i:00');
			$DiffTime = new DateTime($start_time);
			$DiffTime->modify('+'.$interval->format('%h').' hours');
			$DiffTime->modify('+'.$interval->format('%i').' minutes');
			if(isset($tooling)){
				$DiffTime->modify('+'.$tooling['hour'].' hours');
				$DiffTime->modify('+'.$tooling['min'].' minutes');
			}
			$DiffTimeFrom = new DateTime($start_time);
			$DiffTimeTo = new DateTime($DiffTime->format('Y-m-d H:i:s'));
			$DiffTimeDiff = $DiffTimeFrom->diff($DiffTimeTo);
			$diffhour = $DiffTimeDiff->format('%h');
			$diffmin = $DiffTimeDiff->format('%i');
			$tooling = array('hour'=>$diffhour,'min'=>$diffmin);
    	    	}else{
			$datetime1 = new DateTime($result['tooling_start']);
			$datetime2 = new DateTime($result['tooling_end']);
			$interval = $datetime1->diff($datetime2);
			$tooling = array('hour'=>$interval->format('%h'),'min'=>$interval->format('%i'));
    	    	} */
        	    if($query1['tooling_start']!='0000-00-00 00:00:00' && $result['tooling_end']!='0000-00-00 00:00:00'){	
        			$datetime1 = new DateTime($query1['tooling_start']);
        			$datetime2 = new DateTime($result['tooling_end']);
        			$interval = $datetime1->diff($datetime2);
        			$tooling = array('hour'=>$interval->format('%h'),'min'=>$interval->format('%i'));
        	    }else{
        	        $tooling = array('hour'=>0,'min'=>0);
        	    }
    	    }
            return $tooling;
    	}else{
    	    return array('hour'=>0,'min'=>0);
    	}
        
    }
    
    public function get_setup_side_status($order_id,$setup_side,$machine){
    	$this->db->where('order_id',$order_id);
    	$this->db->where('machine',$machine);
    	$this->db->where('side',$setup_side);
    	$query = $this->db->get('tbl_setup_timing');
    	if($query->num_rows() > 0 ){
    		$result = $query->row_array();
    		if($result['setup_start'] == '0000-00-00 00:00:00'){
    			$start = 0;
    		}else{
    			$start = 1;
    		}
    		if($result['setup_end'] == '0000-00-00 00:00:00'){
    			$finish = 0;
    		}else{
    			$finish = 1;
    		}
    		return array('status'=> 1 , 'start'=> $start ,'finish'=> $finish);
    	}else{
    		return array('status'=> 0 , 'start'=> 0 ,'finish'=> 0 );
    	}
    }
    
    function update_job_shipping($order_id,$username){
        $this->db->where('username',$username); 
        $result = $this->db->get(TBL_USERS)->row_array();
        
        $data['order_id'] = $order_id;
        $data['user_id'] = $result['id'];
        $data['created_on'] = date('Y-m-d H:i:s');
        $data['status'] = 1;
        
        $this->db->insert(TBL_SHIPPINGS,$data);
        $insert_id = $this->db->insert_id();
        return  $insert_id;
        
    }
    
    function update_job_delivery_location($location,$username){
        
            
            $this->db->like('username',$username); 
            $result = $this->db->get(TBL_USERS)->row_array();
            
            $location['user_id'] = $result['id'];
            
            $this->db->insert('tbl_order_delivery_location',$location);
            $insert_id = $this->db->insert_id();
            return  $insert_id;
    }
    
    function check_andready_mcdown($data){  
        $this->db->select('*');
        $this->db->where('date_from',$data['date_from']);
        $this->db->where('date_to',$data['date_to']);
        $this->db->where('machine',$data['machine']);
        $this->db->where('shift',$data['shift']);
        $this->db->where('status !=',0);
        $results = $this->db->get(TBL_MCDOWN)->result_array();
 
        foreach ($results as $key => $result) {
        	if(($result['mc_down'] == 1)&&($result['task'] == 0)){
        		$update['status'] = 0;
        		$update['task'] = 1;
        		$this->db->where('id',$result['id']);
        		$this->db->update(TBL_MCDOWN,$update);
        	}
        }
    }
    
    function load_existing_details($job_code){
    	 
        $this->db->where('job_code',$job_code);
        $this->db->where('job_complete_status',1);
        $this->db->where('task',1);
        $this->db->where('status',1); 
        $query = $this->db->get(TBL_MCDOWN);
        if($query->num_rows() > 0){
        	$running_jobresult = $query->row_array();
        	$this->db->where('job_code',$job_code);
	        $this->db->where('job_complete_status',0);
	        $this->db->where('task',0);
	        $this->db->where('status',1); 
	        $new_jobquery = $this->db->get(TBL_MCDOWN);
	        if($new_jobquery ->num_rows() > 0){
	        	$new_jobresult = $new_jobquery->row_array();
	        	$update['setup']		= $running_jobresult['setup'];
	        	$update['setup_start']  	= $running_jobresult['setup_start'];
	        	$update['setup_end']		= $running_jobresult['setup_end'];
	        	$update['tooling_start']	= $running_jobresult['tooling_start'];
	        	$update['tooling_end']  	= $running_jobresult['tooling_end'];
	        	$update['job_complete_status']  = $running_jobresult['job_complete_status'];
	        	$this->db->where('id',$new_jobresult['id']);
	        	$this->db->update(TBL_MCDOWN,$update);
	        	
	        	// get setup timing rows and update
	        	$this->db->where('order_id',$running_jobresult['id']);
			$setup_query = $this->db->get('tbl_setup_timing');
			
			$this->db->where('order_id',$new_jobresult['id']);
			$setup_newjobquery = $this->db->get('tbl_setup_timing');
			
			if(($setup_query->num_rows() > 0)&&($setup_newjobquery ->num_rows() == 0) ){
				$setup_results = $setup_query->result_array();
				foreach( $setup_results as $key => $setup_result ){
					unset($setup_result['setup_id']);
					$setup_result['order_id']=$new_jobresult['id'];
					$this->db->insert('tbl_setup_timing',$setup_result);
				}
			}
	        	// get tooling timing and rows
	        	
	        	$this->db->where('order_id',$running_jobresult['id']);  
			$tooling_query = $this->db->get('tbl_tooling_timings');
			
			$this->db->where('order_id',$new_jobresult['id']);  
			$tooling_newjobquery = $this->db->get('tbl_tooling_timings');
			
			if(($tooling_query->num_rows() > 0)&&($tooling_newjobquery->num_rows() == 0) ){
				$tooling_results = $tooling_query->result_array();
				foreach( $tooling_results as $key => $tooling_result ){
					unset($tooling_result['tooling_id']);
					$tooling_result['order_id']=$new_jobresult['id'];
					$this->db->insert('tbl_tooling_timings',$tooling_result);
				}
			}
	        	
	        	return $new_jobresult['id'];
	        }else{
	        	return false;
	        }
        	
        }
         
    }
     function get_qty_details_multiple($job_id,$jqty,$side,$mc_status){ 
        $this->db->where('job_id',$job_id);
        $this->db->where('qty_no',$jqty);
        $this->db->where('qty_status',1);
		$this->db->where('mc_status',$mc_status);
		$this->db->where('side',$side);
        $result = $this->db->get(TBL_MCDOWN_UPDATES);
       //echo $this->db->last_query().'<br>';
        if( $result->num_rows() > 0 ){
             return 1;
        }else{
            return 0;
        }
    }

     function get_qty_details($job_id,$jqty,$mc_status){ 
        $this->db->where('job_id',$job_id);
        $this->db->where('qty_no',$jqty);
        $this->db->where('qty_status',1);
		$this->db->where('mc_status',$mc_status);
        $result = $this->db->get(TBL_MCDOWN_UPDATES); 
        if( $result->num_rows() > 0 ){
             return 1;
        }else{
            return 0;
        }
    }    
     function total_qty_check($job_id,$jqty,$setup_side,$mc_status){ 
        // echo $job_id.','.$jqty.','.$setup_side.','.$mc_status.'<br>';
        $this->db->where('job_id',$job_id);
        $this->db->where('qty_no',$jqty);
        $this->db->where('side',$setup_side);
		$this->db->where('mc_status',$mc_status);
        $result = $this->db->get(TBL_MCDOWN_UPDATES); 
        if( $result->num_rows() > 0 ){
             return 1;
        }else{
            return 0;
        }
    }
      function get_setup_qty($job_id,$side,$mc_status){ 
        $this->db->where('job_id',$job_id);
        $this->db->where('setup_side',$side);
        $this->db->where('mc_status',$mc_status);
        $result = $this->db->get(TBL_MCDOWN_UPDATES); 
        if( $result->num_rows() > 0 ){
             return 1;
        }else{
            return 0;
        }
    }   
    
    
     function get_side_details($job_id,$side,$mc_status){ 
        $this->db->where('job_id',$job_id);
        $this->db->where('setup_side',$side);
		$this->db->where('mc_status',$mc_status);
        $result = $this->db->get(TBL_MCDOWN_UPDATES);  
        if( $result->num_rows() > 0 ){
             return TRUE;
        }else{
            return FALSE;
        }
    }
   function check_tooling_exist_or_not($order_id,$side,$current_qty,$machine){
        $this->db->where('machine',$machine);
    	$this->db->where('side',$side);
    	$this->db->where('order_id',$order_id);
    	$this->db->where('current_qty',$current_qty); 
    	$query = $this->db->get('tbl_tooling_timings');
         if($query->num_rows() > 0 ){
             return TRUE;
         }else{
             return FALSE;
         }
    }
	function check_tooling_front_completed_or_not1($order_id,$s,$machine,$i){
        $this->db->where('machine',$machine);
    	$this->db->where('side',$s);
    	$this->db->where('order_id',$order_id);
    	$this->db->where('current_qty',$i);
    	$query = $this->db->get('tbl_tooling_timings');
         if($query->num_rows() > 0 ){
             return TRUE;
         }else{
             return FALSE;
         }	
	}
	function check_tooling_front_completed_or_not($mc_status,$order_id,$s,$i){
    	$this->db->where('side',$s);
    	$this->db->where('job_id',$order_id);
    	$this->db->where('qty_no',$i);
    	$this->db->where('mc_status',$mc_status);
    	$query = $this->db->get('tbl_mcdown_updates');
         if($query->num_rows() > 0 ){
             return TRUE;
         }else{
             return FALSE;
         }	
	}	
}
