<!DOCTYPE html>
<html>
  <head>
    <meta name="viewport" content="initial-scale=1.0, user-scalable=no">
    <meta charset="utf-8">
    <title>SFCS LOCATIONS</title>
    <style>
      /* Always set the map height explicitly to define the size of the div
       * element that contains the map. */
      #map {
        height: 100%;
      }
      /* Optional: Makes the sample page fill the window. */
      html, body {
        height: 100%;
        margin: 0;
        padding: 0;
      }
    </style>
  </head>
  <body>
    <div id="map"></div>
    <script>
      setTimeout(function () { 
      location.reload();
    }, 60000);


      function initMap() {
        var map = new google.maps.Map(document.getElementById('map'), {
          zoom: 14,
          center: {lat: <?php echo $locations['latitude'];?>, lng: <?php echo $locations['longitude'];?> },
          mapTypeId: 'terrain'
        });

       /* var flightPlanCoordinates = [
        <?php foreach($locations as $key =>$location){
            if($key < count($locations)-1){
                echo '{lat: '.$location['latitude'].', lng: '.$location['longitude'].'},';
            }else{
                echo '{lat: '.$location['latitude'].', lng: '.$location['longitude'].'}';
            }  
          } ?> 
        ];
        var flightPath = new google.maps.Polyline({
          path: flightPlanCoordinates,
          geodesic: true,
          strokeColor: '#FF0000',
          strokeOpacity: 1.0,
          strokeWeight: 2
        });
        
        flightPath.setMap(map);
        
        */
        var myLatLng = {lat: <?php echo $locations['latitude'];?>, lng: <?php echo $locations['longitude'];?>};
        
        var marker = new google.maps.Marker({
          position: myLatLng,
          map: map,
          title: 'Current Location'
        });
        
        var contentString = '<div id="content">'+
            '<div id="siteNotice">'+
            '</div>'+
            '<h1 id="firstHeading" class="firstHeading">'+'<?php echo $user['name']; ?>'+'</h1>'+
            '<div id="bodyContent">'+
            '<?php echo $user['message']; ?>' + 
            '</div>'+
            '</div>';
            
        var infowindow = new google.maps.InfoWindow({
          content: contentString
        });
        
        marker.addListener('click', function() {
          infowindow.open(map, marker);
        });

        
      }
    </script>
    <script async defer
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDDi-8L5TMCD6bphW75CbDtSnRrCa-i7x0&callback=initMap">
    </script>
  </body>
</html>