<?php

class wims_model extends CI_Model {

    function insert_machine($data){ 
        $this->db->insert(MST_MACHINE,$data);
        $insert_id = $this->db->insert_id();
        return  $insert_id;
    }
    function update_machine($data,$machine_id){
        $this->db->where('id',$machine_id);
        $this->db->update(MST_MACHINE,$data);
        if($this->db->affected_rows() >=0){
          return true; 
        }else{
          return false; 
        }
    }
    function get_machine(){
        $this->db->select('machine,id');
        $this->db->where('status',1);
        $this->db->order_by('position','asc');
        $result=$this->db->get(MST_MACHINE)->result_array();
        return $result;
    }
    function update_samejob($machine,$date_from){
    	$this->db->select('*');
    	$this->db->where('machine',$machine);
    	$this->db->where('date_from',$date_from); 
    	$this->db->where('split_status',0);
    	$this->db->order_by('id','asc');
    	$result = $this->db->get(TBL_MCDOWN)->result_array();
    	return $result;        
        
    }
     function after_edit_job_split($data){
    	$this->db->select('*');
    	$this->db->where('machine',$data['machine']);
    	$this->db->where('shift',$data['shift']);
    	$this->db->where('time >= ',date('Y-m-d H:i:s', strtotime($data['time_from'])));
    	$this->db->where('status !=',0);
    	$result = $this->db->get(TBL_MCDOWN)->result_array();
    	return $result;
    }
    function next_day_job_check($job_code,$machine,$shift,$next){
     	$this->db->select('*');
     	$this->db->where('job_code',$job_code);
    	$this->db->where('machine',$machine);
    	$this->db->where('shift',$shift);
    	$this->db->where('date_from',$next);
    	$result = $this->db->get(TBL_MCDOWN)->row_array();
    	return $result;       
    }
    function next_day_job($time_to,$machine,$shift,$tomorrowdate){
      	$this->db->select('*');       
    	$this->db->where('machine',$machine);
    	$this->db->where('shift',$shift);
    	$this->db->where('date_from',$tomorrowdate);
    	$this->db->where('time_to >',$time_to);
    	$result = $this->db->get(TBL_MCDOWN)->result_array();
    	return $result;         
    }
/*  function next_day_first_job($tomorrowdate,$machine,$shift){
    	$this->db->select('*');
    	$this->db->where('machine',$machine);
    	$this->db->where('shift',$shift);
    	$this->db->where('date_from',$tomorrowdate);
    	$this->db->where('status !=',0);
    	$result = $this->db->get(TBL_MCDOWN)->result_array();
    	return $result;        
    } */
    function get_machine_low($shift,$date){
        $this->db->select('machine,id');
        $this->db->where('status',1);
        $this->db->order_by('id','desc');
        $results=$this->db->get(MST_MACHINE)->result_array();
        foreach($results as $key => $result){
            $this->db->select('*');
            $this->db->where('machine',$result['id']);
            $this->db->where('shift',$shift);
            $this->db->where('date_from',$date);
            $query=$this->db->get(TBL_MCDOWN);
            $jobs=$query->result_array();
            $result['position'] = 0;
            foreach($jobs as $key => $job){
                $datetime1 = new DateTime($job['time_from']);
	        $datetime2 = new DateTime($job['time_to']);
	        $interval = $datetime1->diff($datetime2);
	        $result['position']=$result['position']+$interval->format('%h.%i');
            }
            //$result['position']=$query->num_rows();
            
            $rows[]=$result;
        }
        //echo "<pre>";print_r($rows);exit;
        usort($rows, 'sortByposition');
        $option="";
        //print_r($rows);exit;
        foreach($rows as $key => $row){
            if($key==0){
                $option.="<option selected value='".$row['id']."'>".$row['machine']."</option>";
                //$option.="<option value='".$row['id']."'>".$row['machine']."</option>";
            }else{
                $option.="<option value='".$row['id']."'>".$row['machine']."</option>";
            }
        }
        return array('option'=>$option,'machine'=>$rows);
    }
    function check_shift(){
    	$this->db->select('machine,id');
        $this->db->where('status',1);
        $this->db->order_by('id','desc');
        $results=$this->db->get(MST_MACHINE)->result_array();
        foreach($results as $key => $result){
            $this->db->select('*');
            $this->db->where('machine',$result['id']);
            $this->db->where('shift',1);
            $this->db->where('date_from',date('Y-m-d'));
            $query=$this->db->get(TBL_MCDOWN);
            $jobs=$query->result_array();
            $result['position'] = 0;
            foreach($jobs as $key => $job){
                $datetime1 = new DateTime($job['time_from']);
	        $datetime2 = new DateTime($job['time_to']);
	        $interval = $datetime1->diff($datetime2);
	        $result['position']=$result['position']+$interval->format('%h.%i');
            }
            //$result['position']=$query->num_rows();
            
            $rows[]=$result;
        }
    }
    function delete_machine($machine_id){
        $data['status']=0;
        $this->db->where('id',$machine_id);
        $this->db->update(MST_MACHINE,$data);
        if($this->db->affected_rows() >=0){
          return true; 
        }else{
          return false; 
        }
    }
    function get_machine_details($machine_id){
        $this->db->select('*');
        $this->db->where('id',$machine_id);
        $result=$this->db->get(MST_MACHINE)->row_array();
        return $result;
    }
    function get_bossjob_details($job_code){
        $CI =& get_instance();
        $this->db = $CI->load->database('default', TRUE);
        $this->db2 = $CI->load->database('boss', TRUE);

        $this->db2->select('*');
        $this->db2->from('boss_quotes');
        $this->db2->join('boss_tooling', 'boss_quotes.id = boss_tooling.quote_id');
        $this->db2->join('boss_tooling_time', 'boss_quotes.id=boss_tooling_time.quote_id');
        $this->db2->where('boss_quotes.ref_no',$job_code); 
        $result = $this->db2->get()->row_array();

        $total_minutes_boss_mac = (($result['std_mac_hr']*60) + $result['std_mac_min'] + $result['cpx_mac_min'] + ($result['cpx_mac_hr']*60));
        $total_minutes_boss_ass = (($result['std_ass_hr']*60) + $result['std_ass_min'] + $result['cpx_ass_min'] + ($result['cpx_ass_hr']*60));
        $total_minutes_boss_des = (($result['std_des_hr']*60) + $result['std_des_min'] + $result['cpx_des_min'] + ($result['cpx_des_hr']*60));
        $total = $total_minutes_boss_mac+$total_minutes_boss_ass+$total_minutes_boss_des;
        $total_min =  gmdate("H.i", ($total * 60)); 

        return array("total_time"=>$total_min,"quantity"=>$result['tooling_unit']);
    }
    function addjob_insert($data){
    	$this->db->select('id,position,shift,machine');
        $this->db->where('date_from',$data['date_from']);
        $this->db->where('date_to',$data['date_to']);
        $this->db->where('machine',$data['machine']);
        $this->db->where('shift',$data['shift']);
        $this->db->where('position >=',$data['position']);
        $this->db->where('status',1);
        $query=$this->db->get(TBL_MCDOWN);
        $results = $query->result_array();
        if($query->num_rows() > 0){
        	foreach($results as $key => $result){
    			$pos['position'] = $result['position']+1;
    			$this->db->where('id',$result['id']);
        		$this->db->update(TBL_MCDOWN,$pos);
    		}
        }
    	
        //code me
        if (array_key_exists("date",$data))
        {
           $data['down_time'] = $data['addjob_running_time'];
           //$data['date_from'] = $data['date'];
           unset($data['date']);
           unset($data['addjob_running_time']);
        }
        //end
        $this->db->insert(TBL_MCDOWN,$data);
        $insert_id = $this->db->insert_id();
        return  $insert_id;
    }
    function insert_down($data){
        $this->db->insert(TBL_MCDOWN,$data);
        $insert_id = $this->db->insert_id();
        return  $insert_id;
    }
    function update_jobs($jobId,$data){
        $this->db->where('id',$jobId);
        $this->db->update(TBL_MCDOWN,$data);
        if($this->db->affected_rows() >=0){
          return true; 
        }else{
          return false; 
        }
    }
    function insert_shift($data){
        $this->db->insert(TBL_SHIFT,$data);
        $insert_id = $this->db->insert_id();
        return  $insert_id;
    }
    function update_shift($data,$shift_id){
        $this->db->where('id',$shift_id);
        $this->db->update(TBL_SHIFT,$data);
        if($this->db->affected_rows() >=0){
          return true; 
        }else{
          return false; 
        }
    }
    function get_shift_details($date_from){
        $this->db->select('*');
        $this->db->where('date_from',$date_from);
        $this->db->where('status',1);
        $query=$this->db->get(TBL_SHIFT);
        if($query->num_rows() > 0){
            $result=$query->row_array();
        }else{
            $this->db->select('*');
            $this->db->where('status',1);
            $this->db->order_by("id", "desc");
            $result=$this->db->get(TBL_SHIFT)->row_array();
        }
        return $result;
    } 
    function downreport($downreport){
        $this->db->select('tbl_mcdown.*,mst_machine.machine');
        $this->db->from('tbl_mcdown');
        $this->db->join('mst_machine', 'tbl_mcdown.machine = mst_machine.id');
        $this->db->where('date_from >=',$downreport['date_from']);
        $this->db->where('date_from <=',$downreport['date_to']);
        $this->db->where('tbl_mcdown.mc_down',1);
        $this->db->where('tbl_mcdown.machine',$downreport['machine']);
        $result=$this->db->get()->result_array();
        return $result;

        // $this->db->select('*');
        // $this->db->from(TBL_MCDOWN);
        // $this->db->join(TBL_MCDOWN);
        // $this->db->where('date_from >=',$downreport['date_from']);
        // $this->db->where('date_from <=',$downreport['date_to']);
        // $this->db->where('machine',$downreport['machine']);
        // $this->db->where('mc_down',1);
        // $result=$this->db->get()->result_array();
        // return $result;
    }
    function idlereport($idlereport){
        $this->db->select('tbl_mcdown.*,mst_machine.machine');
        $this->db->from('tbl_mcdown');
        $this->db->join('mst_machine', 'tbl_mcdown.machine = mst_machine.id');
        $this->db->where('date_from >=',$idlereport['date_from']);
        $this->db->where('date_from <=',$idlereport['date_to']);
        $this->db->where('tbl_mcdown.idle',1);
        $this->db->where('tbl_mcdown.machine',$idlereport['machine']);
        $result=$this->db->get()->result_array();
        return $result;

        // $this->db->select('*');
        // $this->db->where('date_from >=',$idlereport['date_from']);
        // $this->db->where('date_to <=',$idlereport['date_to']);
        // $this->db->where('idle',1);
        // $result=$this->db->get(TBL_MCDOWN)->result_array();
        // return $result;
    }
    function setupreport($setupreport){
        $this->db->select('tbl_mcdown.*,mst_machine.machine');
        $this->db->from('tbl_mcdown');
        $this->db->join('mst_machine', 'tbl_mcdown.machine = mst_machine.id');
        $this->db->where('date_from >=',$setupreport['date_from']);
        $this->db->where('date_from <=',$setupreport['date_to']);
        $this->db->where('tbl_mcdown.setup',1);
        $this->db->where('tbl_mcdown.machine',$setupreport['machine']);
        $result=$this->db->get()->result_array();
        return $result;

        // $this->db->select('*');
        // $this->db->where('date_from >=',$setupreport['date_from']);
        // $this->db->where('date_to <=',$setupreport['date_to']);
        // $this->db->where('setup',1);
        // $result=$this->db->get(TBL_MCDOWN)->result_array();
        // return $result;
    }
    function maintainreport($maintainreport){
        $this->db->select('tbl_mcdown.*,mst_machine.machine');
        $this->db->from('tbl_mcdown');
        $this->db->join('mst_machine', 'tbl_mcdown.machine = mst_machine.id');
        $this->db->where('date_from >=',$maintainreport['date_from']);
        $this->db->where('date_from <=',$maintainreport['date_to']);
        $this->db->where('tbl_mcdown.maintenance',1);
        $this->db->where('tbl_mcdown.machine',$maintainreport['machine']);
        $result=$this->db->get()->result_array();
        return $result;
        // $this->db->select('*');
        // $this->db->where('date_from >=',$maintainreport['date_from']);
        // $this->db->where('date_to <=',$maintainreport['date_to']);
        // $this->db->where('maintenance',1);
        // $result=$this->db->get(TBL_MCDOWN)->result_array();
        // return $result;
    }
    function get_jobs($date,$machine_id,$shift){
        $this->db->select('*');
        $this->db->where('date_from',$date);
        $this->db->where('machine',$machine_id);
        $this->db->where('shift',$shift);
        $this->db->where('status',1);
        $this->db->where('mc_down !=',1);
        $this->db->where('other_down !=',1);
        $this->db->where('job_complete_status !=',2);
        $result = $this->db->get(TBL_MCDOWN);
        return $result->result_array();
    }
    function get_downtime($date,$machine_id,$shift){
        $this->db->select('*');
        //$this->db->where('date_from',$date);
        $this->db->where('machine',$machine_id);
        $this->db->where('shift',$shift);
        $this->db->where('status',1);
        $this->db->order_by('time_from','asc');
        //$this->db->where('job_complete_status !=',2);
        $result = $this->db->get(TBL_MCDOWN);
        $rets = $result->result_array();
        $results=array();
        foreach($rets as $key => $value){
        	if (($date >= $value['date_from']) && ($date <= $value['date_to'])){
        		$results[]=$value;
        	}
        }
        $rows=array();
        foreach ($results as $key => $result) {
            if($result['mc_down']==1){
                $result['job_code']="M/C Down";
                $result['class']="red_box disabled";
            }elseif ($result['other_down']==1) {
                $result['job_code']=$result['reason'];
                $result['class']="lightblue_box disabled";
            }elseif ($result['setup']==1) {
                //$result['job_code']="Setup";
                $result['class']="yellow_box disabled";
            }elseif ($result['idle']==1) {
                $result['job_code']="Idle";
                $result['class']="green disabled";
            }elseif ($result['maintenance']==1) {
                $result['job_code']="Maintenance";
                $result['class']="lightblue_box disabled";
            }elseif(($result['job_complete_status']==2)||($result['job_complete_status']==1)){
                $result['class']="lightgreen_box disabled";
            }else{
                $result['class']="green disabled";
            }
            if($result['job_complete_status']==1){
                $result['class']="lightgreen_box disabled";
            }
            $rows[]=$result;
        }
        return $rows;
    }
    function check_job_availability($data){
        $time_from = $data['time_from'];
        $time_to = $data['time_to'];
        $this->db->select('*');
        $this->db->where('date_from',$data['date']);
        $this->db->where('date_to',$data['date']);
        $this->db->where('machine',$data['machine']);
        $this->db->where('shift',$data['shift']);
        $this->db->where('status !=',0);
        $results = $this->db->get(TBL_MCDOWN)->result();
        $value = 0;
        $mcdown= 0;
        /*foreach ($results as $key => $result) {
            $test=(check_time($result->time_from,$result->time_to, $time_from) ? 1 : 0);
            if($test){
                $value = $value+1;
                if($result->mc_down==1){
                    $mcdown= $mcdown+1;
                }
            }elseif($result->mc_down == 1){
                $mcdown= $mcdown+1;
            }
        }*/
        foreach ($results as $key => $result) {
            $test=(check_time($result->time_from,$result->time_to,$time_to) ? 1 : 0);
            if($test){
                $value = $value+1;
                if($result->mc_down==1){
                    $mcdown= $mcdown+1;
                }
            }
        }
        if($value > 0){
            if($mcdown > 0){
            	$return['job']=1;
            	$return['mcdown']=1;
            	return $return;
            }else{
            	$return['job']=1;
            	$return['mcdown']=0;
                return $return;
            }
        }else{
            $return['job']=0;
            if($mcdown > 0){
                $return['mcdown']=1;
            }else{
                $return['mcdown']=0;
            }
            return $return;
        }
    }
    function change_job_position($id,$pos){
        $this->db->where('id',$id);
        $this->db->update(TBL_MCDOWN,$pos);
        if($this->db->affected_rows() >=0){
          return true; 
        }else{
          return false; 
        }
    }
    function checking_timing($data){
        //echo "<pre>";print_r($data);exit;
        $this->db->select("*");
        $this->db->where_in("id",$data);
        $results=$this->db->get(TBL_MCDOWN)->result_array();
        //echo "<pre>";//print_r($result);exit;
        foreach ($results as $key => $value) {
        
            $to_time = strtotime($value['date_to'].' '.$value['time_to']);
	    $from_time = strtotime($value['date_from'].' '.$value['time_from']);
	    $interval=round(abs($to_time - $from_time) / 60,2);
							
            $value['interval']=$interval;
            $rows[] = $value;
        }
        $time_return=get_array_sum($rows,'interval');

        if($time_return <= 780 ){
            return false;
        }else{
            return true;
        }
    }
    /*function check_position($data,$overwrite){
        $time_from=$data['time_from'];
        if($overwrite==0){
        	$this->db->select('*');
        	$this->db->where('machine',$data['machine']);
        	$this->db->where('date_from',date('Y-m-d'));
        	$this->db->where('shift',$data['shift']);
        	$this->db->order_by('position','desc');
        	$this->db->limit(1);
        	$query = $this->db->get(TBL_MCDOWN); 
        	if($query->num_rows() > 0){
            		$results=$query->row_array();
            		$pos=$results['position'];
             		return $pos+1;
        	}else{
            		return '0';
        	}
    	}else{
    		$this->db->select('*');
        	$this->db->where('machine',$data['machine']);
        	$this->db->where('shift',$data['shift']);
        	$this->db->where('date_from',date('Y-m-d'));
        	$this->db->order_by('position','asc');
        	$query = $this->db->get(TBL_MCDOWN); 
        	if($query->num_rows() > 0){
        		//echo "<pre>";print_r($query->result_array());exit;
        		$results=$query->result_array(); 
        		foreach($results as $key => $result){
        			$test=(check_time($result['time_from'],$result['time_to'], $time_from) ? 1 : 0); 
            			if($test){
                			$value = $key; 
            			}
            		}
            		if(isset($value)){
            			return $results[$value]['position'];
            		}else{
            			return '0';
            		} 
        		
        	}else{
            		return '0';
        	}
    	}
    }*/
    function check_position($data,$overwrite){
 
     unset($data['id']);
        $time_from=$data['time_from'];
        if($overwrite==0){
        
	       $data['position'] = 0;
	       return $this->addjob_insert($data);

    	}else{
    		$data['position'] = 0;
	        $insid=$this->addjob_insert($data);
    		$this->db->select('*');
        	$this->db->where('machine',$data['machine']);
        	$this->db->where('shift',$data['shift']);
        	$this->db->where('date_from',$data['date_from']);
        	$this->db->order_by('position','asc');
        	$query = $this->db->get(TBL_MCDOWN); 
        	if($query->num_rows() > 0){
        		//echo "<pre>";print_r($query->result_array());
        		$results=$query->result_array(); 
        		usort($results, 'sortBytime_from');
        		//print_r($results);exit;
        		foreach($results as $key => $result){
        			if($key != 0){
        				$old_job = $results[$key-1];
        				$cur_job =  $result;
        				
        			$datetime1 = new DateTime($cur_job['date_from'].' '.$cur_job['time_from']);
					$datetime2 = new DateTime($cur_job['date_to'].' '.$cur_job['time_to']);
					$interval = $datetime1->diff($datetime2);
					$diffhour = $interval->format('%h');
					$diffmin = $interval->format('%i');
					
					$startTime = new DateTime($old_job['time_to']);
					$startTime->modify('+'.$diffhour.' hours');
					$startTime->modify('+'.$diffmin.' minutes');
					$update['date_from'] = $cur_job['date_from'];
					$update['date_to'] = $cur_job['date_to'];
					$update['time_from'] = $old_job['time_to']; 
					$update['time_to'] = $startTime->format('H:i:s');
					
					$this->db->where('id',$cur_job['id']);
        			$this->db->update(TBL_MCDOWN,$update);	
        				
        			}
        		}
        	}
        	return $insid;
    	}
    }
    function get_shifts($date){
        $results=$this->db->get(TBL_SHIFT)->result();
        $id = array();
        $shift1 = 0;
        $shift2 = 0;
        $shift3 = 0;
        foreach($results as $key => $result){
    		if (($date >= $result->date_from) && ($date <= $result->date_to)){
    			if($result->shift1==1){
    				$shift1 = $shift1 +1;
    			}
      			if($result->shift2==1){
    				$shift2 = $shift2 +1;
    			}
    			if($result->shift3==1){
    				$shift3 = $shift3 +1;
    			}
    		}
        }
        $shift=array();
        if( $shift1 > 0 ){
        	$shift[]=1;

        }
        if( $shift2 > 0 ){
		$shift[]=2;
        }
        if( $shift3 > 0 ){
		$shift[]=3;
        }
        if(empty($shift)){
            $shift[]=1;
        }
        return $shift;
    }
    function get_job_details($id){
        $this->db->where('id',$id);
        $result = $this->db->get(TBL_MCDOWN)->row_array();
        return $result;
    
    }
    
    function get_lastjob_endtiming($data){
        
        $this->db->select('*');
        $this->db->where('machine',$data['id']);
        $this->db->where('shift',$data['shift']);
        $this->db->where('date_from',$data['date']);
        $this->db->where('status !=',0);
        $this->db->order_by('position','asc');
        $query = $this->db->get(TBL_MCDOWN); 
        //echo "<pre>";print_r($query->result_array());
        if($query->num_rows() > 0){
            //echo "<pre>";print_r($query->result_array());
            $results=$query->result_array(); 
            usort($results, 'sortBytime_from');
            //echo "<pre>";print_r(end($results));exit;
            $last_job = end($results);
            return $last_job['time_to'];
        }else{
            return false; 
        }
    }
    function update_machine_pos($id,$pos){
         $data['position'] = $pos;
         $data['updated_on'] = date('Y-m-d H:i:s');
         $this->db->where('id',$id);
         $this->db->update(MST_MACHINE,$data);
         if( $this->db->affected_rows() >=0 ){
             return true; 
         }else{
             return false; 
         }
    }
    function get_users($requestData){ 
        $columns = array( 
        // datatable column index  => database column name
            0 =>'firstname', 
            1 => 'lastname',
            2=> 'username',
            3=> 'designation'
        ); 
        $query = $this->db->get(TBL_USERS);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;


        $this->db->select('firstname,lastname,username,designation');
        if( !empty($requestData['search']['value']) ) { 
            $this->db->like('firstname',$requestData['search']['value']);
            $this->db->or_like('lastname',$requestData['search']['value']);
            $this->db->or_like('username',$requestData['search']['value']);
            $this->db->or_like('designation',$requestData['search']['value']);
        }
        $query = $this->db->get(TBL_USERS);
        $totalFiltered = $query->num_rows();
        $results = $query->result_array(); 

        $data = array();
        foreach ($results as $key => $row) {
            $nestedData=array(); 
            $nestedData[] = $row["firstname"];
            $nestedData[] = $row["lastname"];
            $nestedData[] = $row["username"];
            $nestedData[] = $row["designation"]; 
            
            $data[] = $nestedData;
        }
        $json_data = array(
            "draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
            "recordsTotal"    => intval( $totalData ),  // total number of records
            "recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
            "data"            => $data   // total data array
        );
        return $json_data;
    }

/**
*
*
*
**/

    function get_reasons(){
        $this->db->where('status',1);
        $this->db->order_by('position','asc');
        return $this->db->get(MST_REASONS)->result_array();
    }
    function insert_reason($data){ 
        $this->db->insert(MST_REASONS,$data);
        $insert_id = $this->db->insert_id();
        return  $insert_id;
    }
    function update_reason($data,$reason_id){
        $this->db->where('id',$reason_id);
        $this->db->update(MST_REASONS,$data);
        if($this->db->affected_rows() >=0){
          return true; 
        }else{
          return false; 
        }
    }

    function get_reason_details($reason_id){
        $this->db->select('*');
        $this->db->where('id',$reason_id);
        $result=$this->db->get(MST_REASONS)->row_array();
        return $result;
    }

    function update_reason_pos($id,$pos){
         $data['position'] = $pos;
         $data['updated_on'] = date('Y-m-d H:i:s');
         $this->db->where('id',$id);
         $this->db->update(MST_REASONS,$data);
         if( $this->db->affected_rows() >=0 ){
             return true; 
         }else{
             return false; 
         }
         
    }
    
    function insert_machine_down($data){
        $time_from = $data['time_from'];
        $time_to = $data['time_to'];
        $this->db->select('*');
        $this->db->where('date_from ',$data['date_from']); 
        $this->db->where('machine',$data['machine']);
        $this->db->where('shift',$data['shift']);
        $results = $this->db->get(TBL_MCDOWN)->result_array();
        
        usort($results , 'sortBytime_from'); 

        foreach ($results as $key => $result) {
            $test=(check_time($result['time_from'],$result['time_to'],$time_to) ? 1 : 0);
            if($test){
                $job_match = $key;
            } 
        }
        if(isset($job_match)){ 
            for($i=0;$i < $job_match;$i++){
                unset($results[$i]);
            }
            $old_time =$data['time_to'];
            foreach ($results as $key => $result) {
            	$datetime1 = new DateTime($result['date_from'].' '.$result['time_from']);
		$datetime2 = new DateTime($result['date_to'].' '.$result['time_to']);
		$interval = $datetime1->diff($datetime2);
		$diffhour = $interval->format('%h');
		$diffmin = $interval->format('%i');
		$new['time_from'] = $old_time ;
		$startTime = new DateTime($new['time_from']);
		$startTime->modify('+'.$diffhour.' hours');
		$startTime->modify('+'.$diffmin.' minutes');
		$new['time_to'] = $startTime->format('H:i:s');
		
		$this->db->where('id',$result['id']);
        	$this->db->update(TBL_MCDOWN,$new);
		$old_time =$new['time_to'];
            } 
        } 
        $this->db->insert(TBL_MCDOWN,$data);
        $insert_id = $this->db->insert_id();
        return  $insert_id;
         
    }
   
   function get_jobdetails_jobcode($jobcode){
        $this->db->where('job_code',$jobcode);
        $this->db->order_by('position','asc');
        $result = $this->db->get(TBL_MCDOWN);
        if($result->num_rows() > 0){
            return $result->row_array();
        }else{
            return false;
        }
    }
    function machine_master(){
       $this->db->where('status',1);
       $result = $this->db->get(MST_MACHINE);
       return $result->result_array();
    }
    function update_wims_job($data){
 		$this->db->where('job_code',$data['job_code']);
        $result = $this->db->update(TBL_MCDOWN,$data);

        if($result){
            return true;
        }else{
            return false;
        }
    }
    function get_spcs_job_id($job_code){
 		$this->db->where('job_code',$job_code);
        $result = $this->db->get(TBL_MCDOWN);
        if($result->num_rows() > 0){
            return $result->row_array();
        }else{
            return false;
        }
    }    
    function get_job_completed_status($job_id){
        $this->db->where('job_id',$job_id);
        $this->db->where('mc_status','ss');
        $query=$this->db->get(TBL_MCDOWN_UPDATES);
        $results = $query->result_array();
        if($query->num_rows() > 0){
            return $query->num_rows();
        }else{
            return 0;
        }
    }
    function next_day_job_all($date_from,$time_to,$machine,$shift){
      	$this->db->select('*');       
    	$this->db->where('machine',$machine);
    	$this->db->where('shift',$shift);
    	$this->db->where('date_from',$date_from);
    	$this->db->where('time_to >',$time_to);
    	$result = $this->db->get(TBL_MCDOWN)->result_array();
    	return $result; 
	}
	function jobcodeExistOrNot($job_code,$machine,$shift,$tomorrowdate){
      	$this->db->select('*');
		$this->db->where('job_code',$job_code);		
    	$this->db->where('machine',$machine);
    	$this->db->where('shift',$shift);
    	$this->db->where('date_from',$tomorrowdate);
    	$result = $this->db->get(TBL_MCDOWN)->row_array();
    	return $result; 		

	}    
}
