<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class report_model extends CI_Model {

	var $table = TBL_MCDOWN;
	var $column_order = array('date_from','job_code', 'down_time','machine',null); //set column field database for datatable orderable
	var $column_search = array('date_from','job_code','down_time','machine'); //set column field database for datatable searchable 
	var $order = array('id' => 'asc'); // default order 

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	private function _get_datatables_query()
	{
		
		$this->db->from($this->table);
		

		$i = 0;
	
		foreach ($this->column_search as $item) // loop column 
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{
				
				if($i===0) // first loop
				{
					$this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
					$this->db->like($item, $_POST['search']['value']);
				}
				else
				{
					$this->db->or_like($item, $_POST['search']['value']);
				}

				if(count($this->column_search) - 1 == $i) //last loop
					$this->db->group_end(); //close bracket
			}
			$i++;
		}
                if((isset($_POST['min']))&&(isset($_POST['max']))&&($_POST['min']!="")&&($_POST['max']!="")){
                      $where = '( date_from >= "'.$_POST['min'].'" AND date_from <= "'.$_POST['max'].'" )';
                      $this->db->where($where);
                } 
                if($_POST['machine']!=""){
                	$this->db->where('machine',$_POST['machine']);
                }
                if($_POST['status']!=5){
                    if($_POST['status']==0){
                        $this->db->where('setup',0);
                        $this->db->where('setup_start','0000-00-00 00:00:00');
                        $this->db->where('setup_end','0000-00-00 00:00:00');
                        $this->db->where('tooling_start','0000-00-00 00:00:00');
                        $this->db->where('tooling_end','0000-00-00 00:00:00');
                    }elseif($_POST['status']==1){
                        $this->db->where('setup',1);
                        $this->db->where('setup_start !=','0000-00-00 00:00:00');
                        $this->db->where('setup_end','0000-00-00 00:00:00');
                        $this->db->where('tooling_start','0000-00-00 00:00:00');
                        $this->db->where('tooling_end','0000-00-00 00:00:00');
                    }elseif($_POST['status']==2){
                        $this->db->where('setup',2);
                        $this->db->where('setup_start !=','0000-00-00 00:00:00');
                        $this->db->where('setup_end !=','0000-00-00 00:00:00');
                        $this->db->where('tooling_start','0000-00-00 00:00:00');
                        $this->db->where('tooling_end','0000-00-00 00:00:00');
                    }elseif($_POST['status']==3){
                        $this->db->where('setup',2);
                        $this->db->where('setup_start !=','0000-00-00 00:00:00');
                        $this->db->where('setup_end !=','0000-00-00 00:00:00');
                        $this->db->where('tooling_start !=','0000-00-00 00:00:00');
                        $this->db->where('tooling_end','0000-00-00 00:00:00');
                    }elseif($_POST['status']==4){
                        $this->db->where('setup',2);
                        $this->db->where('setup_start !=','0000-00-00 00:00:00');
                        $this->db->where('setup_end !=','0000-00-00 00:00:00');
                        $this->db->where('tooling_start !=','0000-00-00 00:00:00');
                        $this->db->where('tooling_end !=','0000-00-00 00:00:00');
                    }
                }
                
                //$where = '(mc_down != 1 or other_down != 1 or job_code!="" )';
                //$this->db->where($where);
                $this->db->where('mc_down !=',1);
                $this->db->where('other_down !=',1);
		
		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		} 
		else if(isset($this->order))
		{
			$order = $this->order;
			$this->db->order_by(key($order), $order[key($order)]);
		}
		
	}

	function get_datatables()
	{
		$this->_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
	        $this->db->where('status',1); 
		$query = $this->db->get();
		return $query->result();
	}

	function count_filtered() {
		$this->_get_datatables_query();
                $this->db->where('status',1);
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function count_all()
	{
		$this->db->from($this->table);
                $this->db->where('status',1);
		return $this->db->count_all_results();
	}

	function check_user_avail($data){
		//print_r($data);
		$this->db->where('username',$data['login_username']);
		$query = $this->db->get(TBL_USERS);
		//print_r($query);
		if( $query->num_rows() > 0 ){
			return $query->num_rows;
		}else{
			return FALSE;
		}
	}
	function auth_user($data){
		$this->db->where('username',$data['login_username']);
		$this->db->where('password',md5($data['login_password']));
		$query = $this->db->get(TBL_USERS);
		if( $query->num_rows() > 0 ){
			return TRUE;
		}else{
			return FALSE;
		}
	}
	function get_userinfo($username){
		$this->db->where('username',$username);
		$query = $this->db->get(TBL_USERS);
		if( $query->num_rows() > 0 ){
			return $query->row_array();
		}else{
			return FALSE;
		}
	}
	function find_job_state($job_code){

        $job_details_spcs = $this->get_job_details($job_code); 
        $job_details_boots = $this->get_job_details_boots($job_code); 
        if($job_details_boots['tjob_tooling_status']==2){
            return 'Tooling Finished';
        }elseif($job_details_boots['tjob_tooling_status']==1){
            return 'Tooling Started';
        }elseif($job_details_spcs['setup']==2){
            return 'Setup Finished';
        }elseif($job_details_spcs['setup']==1){
            return 'Setup Started';
        }else{
            return 'Loaded';
        }
    }
    
    function get_job_details($job_code){ 
        $this->db->where('job_code',$job_code);
        $this->db->where('status',1); 
        $result = $this->db->get(TBL_MCDOWN)->row_array();  
        return $result;
    }
    
    function get_job_details_boots($job_code){
        $CI =& get_instance();
        $this->db = $CI->load->database('default', TRUE);
        $this->boots = $CI->load->database('boots', TRUE);
        $this->boots->where('tjob_code',$job_code);
        $query = $this->boots->get('tbl_tooling_jobs');

        if($query->num_rows() > 0){
            return $query->row_array();
        }else{
            return false;
        }
    }
	function get_machinename($machine_id){
        $this->db->select('machine');
        $this->db->where('id',$machine_id);
        $result=$this->db->get(MST_MACHINE)->row_array();
        return $result['machine'];
    }

    function update_user($data,$userid){
    	 $this->db->where('id',$userid);
         $this->db->update(TBL_USERS,$data);
         if( $this->db->affected_rows() >=0 ){
             return true; 
         }else{
             return false; 
         }
    }
    function remove_user($userid){
    	$data['status'] = 0 ;
    	$this->db->where('id',$userid);
        $this->db->update(TBL_USERS,$data);
        if( $this->db->affected_rows() >=0 ){
            return true; 
        }else{
            return false; 
        }
    }
    
    function get_job_history($job_id){
        $this->db->where('job_id',$job_id);
        $this->db->order_by('id','desc');
        $query = $this->db->get(TBL_MCDOWN_UPDATES);
        if( $query->num_rows() > 0 ){
            return $query->result_array();
        }else{
            return false; 
        }
    }

}


/*
class report_model extends CI_Model {

    function get_jobs($date){
        $this->db->select('mst_machine.machine,tbl_mcdown.job_code,tbl_mcdown.down_time,tbl_mcdown.id,tbl_mcdown.notes,tbl_mcdown.setup,tbl_mcdown.mc_down,tbl_mcdown.shift,tbl_mcdown.assy_start,tbl_mcdown.assy_end,tbl_mcdown.setup_start,tbl_mcdown.setup_end,tbl_mcdown.tooling_start,tbl_mcdown.tooling_end,tbl_mcdown.qc_start,tbl_mcdown.qc_end,tbl_mcdown.job_complete_status');
        $this->db->join('mst_machine', 'tbl_mcdown.machine= mst_machine.id');
        $where = '(date_from = "'.$date.'" or date_to = "'.$date.'" )';
        $this->db->where($where);
        $this->db->where('tbl_mcdown.mc_down !=',1);
        $this->db->where('tbl_mcdown.other_down !=',1);
        $query = $this->db->get(TBL_MCDOWN);
        if($query->num_rows() > 0){
            return $query->result_array();
        }else{
            return false;
        }
    }
    
    
}*/