<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Users extends CI_Controller {

	public function __construct(){
		parent::__construct();
		$this->load->model('users_model','users');
		$this->load->helper('common_helper');
	}

	public function index(){
		$this->load->helper('url');
		$this->load->view('users_view');
	}

	public function ajax_list(){
            header('Access-Control-Allow-Origin: *');
		$list = $this->users->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $users) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = $users->firstname;
			$row[] = $users->lastname;
			$row[] = $users->username;
			$row[] = $users->designation;
			$row[] = '<button class="btn btn-primary user_delete" data-id="'.$users->id.'">DELETE </button>   <button class="btn btn-primary user_edit" data-id="'.$users->id.'">EDIT </button>';
			$data[] = $row;
		}

		$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->users->count_all(),
						"recordsFiltered" => $this->users->count_filtered(),
						"data" => $data,
				);
		//output to json format
		echo json_encode($output);
	}
	public function add_newuser(){
               header('Access-Control-Allow-Origin: *');
		$data               =    $this->input->post();
		$userid = $data['userid'];
		unset($data['userid']);
		if($userid == 0){ 
			$data['res']    = strrev($data['password']);
			$data['password']    = md5($data['password']);
			$data['designation']  =    get_designation($data['user_type']);
			$data['created_on'] =    date('Y-m-d H:i:s');
			$data['status']     =    1;
			$newuser_status     =    $this->users->insert_newuser($data);
			if($newuser_status){
				$result	=	array(
								'result'	=>    'success' ,
								'message'	=>    'New User Inserted Successfully',
								'user_id'	=>    $newuser_status
							);
			}else{
				$result	=	array(
								'result'	=>    'failure' ,
								'message'	=>    'New User Insertion Failed'
							);
			}
			echo json_encode($result);
		}else{
			$data['res']    = strrev($data['password']);
			$data['password']    = md5($data['password']);
			$data['designation']  =    get_designation($data['user_type']);
			$data['updated_on'] =    date('Y-m-d H:i:s');
			$data['status']     =    1;
			$newuser_status     =    $this->users->update_user($data,$userid);
			if($newuser_status){
				$result	=	array(
								'result'	=>    'success' ,
								'message'	=>    'User Updated Successfully',
								'user_id'	=>    $newuser_status
							);
			}else{
				$result	=	array(
								'result'	=>    'failure' ,
								'message'	=>    'User Updation Failed'
							);
			}
			echo json_encode($result);
		}
		
	}
	public function check_userexist(){
                header('Access-Control-Allow-Origin: *');
		if($this->input->get('email')){
			$email = $this->input->get('email'); 
			$availability     =    $this->users->check_userexist('email',$email);
			if($availability){
				echo "false";
			}else{
				echo "true";
			}
		}elseif($this->input->get('username')){
			$username     = $this->input->get('username'); 
			$availability =    $this->users->check_userexist('username',$username);
			if($availability){
				echo "false";
			}else{
				echo "true";
			}
		}
		
	}
	public function get_user_details(){
            header('Access-Control-Allow-Origin: *');
		$user_id=$this->input->post('user_id');
		$user_details=$this->users->get_user_details($user_id);
		if(!empty($user_details)){
			echo json_encode(array('result' =>'success','user_id'=>$user_details['id'],'username'=>$user_details['username'],'firstname'=>$user_details['firstname'],'lastname'=>$user_details['lastname'],'usertype'=>$user_details['user_type'],'password'=>strrev($user_details['res']),'email'=>$user_details['email']));
		}else{
			echo json_encode(array('result' =>'failure','message'=>'User Details Reterival Failed','user_id'=>$user_id));
		}
	}
	public function delete_user(){
		header('Access-Control-Allow-Origin: *');
		$user_id=$this->input->post('user_id');
		$user_remove=$this->users->remove_user($user_id);
		if(!empty($user_remove)){
			echo json_encode(array('result' =>'success','message'=>'User Deletion Success'));
		}else{
			echo json_encode(array('result' =>'failure','message'=>'User Deletion Failed'));
		}
	}

}
