<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width,initial-scale=1.0,maximum-scale=1" />
	<title>Beamon</title>
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
	<link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
	<link rel="stylesheet" type="text/css" href="<?php echo base_url("assets/css/bootstrap.css");?>">
	<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.16/css/dataTables.bootstrap.min.css">
	<link rel="stylesheet" type="text/css" href="<?php echo base_url("assets/css/jquery-ui.css");?>">
	<link rel="stylesheet" type="text/css" href="<?php echo base_url("assets/css/jquery.fancybox.min.css");?>">
	<link rel="stylesheet" type="text/css" href="<?php echo base_url("assets/css/test.css");?>">
	<link rel="stylesheet" type="text/css" href="<?php echo base_url("assets/css/style.css");?>">
<style type="text/css">
.container {
	width: 1200px;
	margin:0 auto;
}
.fancybox-close-small:after {
	content: "×";
	position: absolute;
	top: -1px;
	right: 5px;}
	body{    background: #e5e5e8;}
	/* Start state */
	.animated-modal {
		max-width: 550px;
		border-radius: 4px;
		overflow: hidden;
		transform: translateY(-50px);
		transition: all .7s;
	}
	.animated-modal h2,
	.animated-modal p {
		transform: translateY(-50px);
		opacity: 0;
		transition-property: transform, opacity;
		transition-duration: .4s;
	}
	/* Final state */
	.fancybox-slide--current .animated-modal,
	.fancybox-slide--current .animated-modal h2,
	.fancybox-slide--current .animated-modal p {
		transform: translateY(0);
		opacity: 1;
	}
	/* Reveal content with different delays */
	.fancybox-slide--current .animated-modal h2 {
		transition-delay: .1s;
	}
	.fancybox-slide--current .animated-modal p {
		transition-delay: .3s;
	}
	.fancybox-close-small:after {
		content: "×";
		position: absolute;
		top: 0px;
		right: 0;
		width: 30px;
		height: 30px;
		font: 30px/32px Arial,Helvetica Neue,Helvetica,sans-serif;
		color: #f00;
		font-weight: 300;
		text-align: center;
		border-radius: 50%;
		border-width: 0;
		background-color: transparent;
		transition: background-color .25s;
		box-sizing: border-box;
		z-index: 2;
	}
	.error{
		color :red;
	}
</style>
</head>
<body>
	<nav id="menu" class="menu">
		<ul>
			<li><a class="fadeandscale_open addjob_menu" href="<?php echo base_url("dashboard");?>"> DASH BOARD</a></li>
			<li><a class=" reasonmaster_menu" href="<?php echo base_url("dashboard/reports");?>"> REPORTS</a></li>
			<li><a class=" reasonmaster_menu" href="<?php echo base_url("dashboard/user_location");?>"> LOCATION</a></li>
			<li><a class=" reasonmaster_menu" href="<?php echo base_url("dashboard/order_location");?>">TRACK ORDER</a></li>
			<li><a class="messaging_open  messaging" href="#messaging">MESSAGING</a></li>
   <!--<li><a class="fadeandscale_open addjob_menu" href="<?php echo base_url("dashboard");?>"> ADD JOB</a></li>
   <li><a class="fadeandscale_edit_open editjob_menu" href="<?php echo base_url("dashboard");?>"> EDIT JOB</a></li>
   <li><a class="fadeandscaletwo_open machine_master" href="<?php echo base_url("dashboard");?>"> MACHINE MASTER</a></li>
   <li><a class="fadeandscalethree_open shift_time" href="<?php echo base_url("dashboard");?>"> SHIFT TIME</a></li>
   <li><a class="fadeandscalefour_open down_time_menu" href="<?php echo base_url("dashboard");?>"> DOWN TIME</a></li>
   <li><a class="fadeandscalefive_open idle_time_menu" href="<?php echo base_url("dashboard");?>"> IDLE TIME</a></li>
   <li><a class="fadeandscalesix_open setup_time_menu" href="<?php echo base_url("dashboard");?>"> SETUP TIME</a></li>
   <li><a class="fadeandscaleseven_open addmaintain" href="<?php echo base_url("dashboard");?>"> MAINTENANCE</a></li>
   <li><a class="fadeandscaleeight_open sms_report" href="<?php echo base_url("dashboard");?>"> SMS REPORTING</a></li>
   <li><a class="usermanagement_open user_management" href="<?php echo base_url("dashboard");?>"> USER MANAGEMENT</a></li>
   <li><a class="reasonmaster_open reasonmaster_menu" href="<?php echo base_url("dashboard");?>"> REASON MASTER</a></li>-->
   <!-- <li><a class="fadeandscalenine_open" href="#fadeandscalenine"> OEE</a></li> -->
</ul>
<div id="content">
</div>
</nav>
<main id="panel" class="panel">
	<header>
		<div class="container">
		    
		    
		    
		    

			   <div class="menu_button  col-sm-2">
        <button id="showmenu" class="btn-hamburger js-slideout-toggle"></button>
      </div>

  <!-- Modal -->

			<h1 class="col-sm-7">Beam On Shop Floor Control System</h1>
			<div class="date_andtime_now col-sm-3"><h4>Welcome, <span><?php echo $this->session->userdata('user_name');?></span></h4><a href="<?php echo base_url('logout'); ?>">Logout</a>
			</div>
		</div>
	</header>
	<div class="container_inner">
		<div class="container">
			<div class="table_data">
				<div class="col-md-6" style="padding: 0">
					<div class="input-group input-daterange">
						<div class="input-group-addon">From</div>
						<input type="text" id="min-date" class="form-control date-range-filter" data-date-format="yyyy-mm-dd"">
						<div class="input-group-addon">to</div>
						<input type="text" id="max-date" class="form-control date-range-filter" data-date-format="yyyy-mm-dd" >
						<a class="input-group-addon" id="date-clear" style="cursor: pointer;">Clear</a>
					</div>
				</div>
				<div class="col-md-4 " style="padding: 0">  
					<div class="input-group input-daterange">
						<div class="input-group-addon">Machine</div>
						<select class="form-control" id ="job_machine">
							<?php echo $machine; ?>
							<option selected value="">ALL MACHINE</option>
						</select>
					</div>
				</div>
				<div class="input-group input-daterange">
					<div class="input-group-addon">View</div>
					<select class="form-control" id ="job_status">
						<option value="0">Loaded Jobs</option>
						<option value="1">Setup Started Jobs</option>
						<option value="2">Setup Finished Jobs</option>
						<option value="3">Tooling Started Jobs</option>
						<option value="4">Tooling Finished Jobs</option>
						<option selected value="5">View All Jobs</option>
					</select>
				</div>
			</div>
			<table id="my-table" class="table table-striped table-bordered" cellspacing="0" width="100%">
				<thead>
					<tr>
						<th>Date</th>
						<th>Ref. No.</th>
						<th>Job Timing</th>
						<th>Machine</th>
						<th>Job Status</th>
					</tr>
				</thead>
				<tbody class="job_details">
				</tbody>
			</table>
		</div>
	</div>
</main>
<div class="well report_pop" id="report_pop" style="display: none;">
	<table cellpadding="0" cellspacing="0" border="0" width="800px" height="400px">
		<tbody>
			<tr valign="top">
				<td width="49%">
					<table width="100%" border="0" cellspacing="0" cellpadding="0" id="id-form">
						<tbody><tr class="heading">
							<td>
								<table width="100%">
									<tbody><tr>
										<td colspan="2" id="job_1" align="center">JOB History</td>
									</tr>
								</tbody></table>
							</td>
						</tr>
						<tr>
							<td>
								<div class="job_history" style="width:100%; height:400px; overflow:auto;">
									<table width="100%" border="0" cellspacing="3" cellpadding="5" align="left" id="id-table-list">
										<tbody class="job_history">
											<tr class="heading2">
												<td><strong>JO - Initiate</strong> by <strong>Administrator</strong> </td>
												<td align="right"><span class="font11">01-20-2018 03:23 AM</span></td>
											</tr>
											<tr class="heading2">
												<td><strong>JO - Initiate</strong> by <strong>Administrator</strong> </td>
												<td align="right"><span class="font11">01-10-2018 03:23 AM</span></td>
											</tr>
											<tr class="heading2">
												<td><strong>JO - Initiate</strong> by <strong>Administrator</strong> </td>
												<td align="right"><span class="font11">12-20-2018 03:23 AM</span></td>
											</tr>
											<tr class="heading2">
												<td><strong>JO - Initiate</strong> by <strong>Administrator</strong> </td>
												<td align="right"><span class="font11">11-20-2018 03:23 AM</span></td>
											</tr>
										</tbody></table>
									</div>
								</td>
							</tr>
						</tbody></table>
					</td>
				</tr>
			</tbody>
		</table>
	</div>
	<div id="messaging" class="well pupup_all">
		<ul class="tabs-menu_tow"> 
			<li class="current"><a href="#tab_tow-2">NOTIFICATIONS / MESSAGING</a></li>
			<li><a href="#tab_tow-3">REPORTS</a></li>
		</ul>
		<div class="tab">
			<div id="tab_tow-2" class="tab-content_tow" style="display: block;">
				<form name="msg_notification" id="msg_notification" method="post">
					<div class="popup_container">
						<div class="add_job">
							<div class="col-sm-12">
								<label class="col-sm-4 col-lg-3 col-xs-5">Notify Type<span style="float: right; text-align: right; margin-right:5px">:</span></label>
								<div class="col-sm-5 col-lg-3 col-xs-7 control_cnc">
									<select name="msg_identify" id="msg_identify" class="msg_identify">
										<option value="">Select</option>
										<option value="1">Notification</option>
										<option value="2">Messaging</option>
									</select>
								</div>
							</div>
							<div class="col-sm-12 error msg_identify_error_msg"></div>
						</div>
						<div class="add_job">
							<div class="col-sm-12">
								<label class="col-sm-4 col-lg-3 col-xs-5">Notify For<span style="float: right; text-align: right; margin-right:5px">:</span></label>
								<div class="col-sm-5 col-lg-3 col-xs-7 control_cnc">
									<select name="msg_type" class="cnc_shift msg_type" id="msg_type" >
										<option value="">SELECT USER/GROUP</option>
										<option value="1" >USER</option>
										<option value="2" >GROUP</option> 
									</select>
								</div>
							</div>
							<div class="col-sm-12 error msg_type_error_msg"></div>
						</div>
						<div class="add_job msg_user_list">
							<div class="col-sm-12">
								<label class="col-sm-4 col-lg-3 col-xs-5">User<span style="float: right; text-align: right; margin-right:5px">:</span></label>
								<div class="col-sm-5 col-lg-3 col-xs-7 control_cnc">
									<select name="msg_msg_to" class="cnc_shift msg_msg_to"  >
										<option value="">SELECT USER</option>
										<option value="27" >Assembly</option>
										<option value="28" >Assembly1</option> 
									</select>
								</div>
							</div>
							<div class="col-sm-12 error msg_msg_to_error_msg"></div>
						</div>
						<div class="add_job msg_group_list">
							<div class="col-sm-12">
								<label class="col-sm-4 col-lg-3 col-xs-5">Group<span style="float: right; text-align: right; margin-right:5px">:</span></label>
								<div class="col-sm-5 col-lg-3 col-xs-7 control_cnc">
									<select name="msg_group_id" class="cnc_shift msg_group_id"  >
										<option value="">SELECT GROUP</option>
										<option value="5" >Assembly</option> 
									</select>
								</div>
							</div>
							<div class="col-sm-12 error msg_group_error_msg"></div>
						</div>
						<div class="add_job">
							<div class="col-sm-12">
								<label class="col-sm-4 col-lg-3 col-xs-5">MESSAGE<span style="float: right; text-align: right; margin-right:5px">:</span></label>
								<div class="col-sm-8 col-lg-9 col-xs-7">
									<input type="text"  class="" name="msg_message" id="msg_message" value="">
								</div>
							</div>
							<div class="col-sm-12 error msg_message_error_msg"></div>
						</div>
						<div class="add_job">
							<div class="col-sm-12">
								<label class="col-sm-4 col-lg-3 col-xs-5">NOTES<span style="float: right; text-align: right; margin-right:5px">:</span></label>
								<div class="col-sm-8 col-lg-9 col-xs-7">
									<input type="text"  class="" name="msg_notes" id="msg_notes" value="">
								</div>
							</div>
						</div>
					</div>
					<div class="all_buttons col-sm-12">
						<input type="submit" class="col-sm-6 botton_bottom update btn btn-default" value="Submit" />
						<button class="col-lg-6 col-sm-6 botton_bottom cancel messaging_close scale_close btn btn-default">CANCEL</button>
					</div>
				</form>
			</div>
			<div class="tab-content_tow" id="tab_tow-3" style="display: none;">
				<div class="popup_container">
					<div class="add_job">
						<div class="drop_box time down_time col-lg-12">
							<h3 class="inner_tap_title">Notification / Message Reports</h3>
							<!-- <form name="downreport" id="downreport">
								<label class="col-lg-1">FROM <span style="float: right; text-align: right; margin-right:5px">:</span></label>
								<div class="col-sm-8 col-lg-3 col-xs-7"">
									<input style="color: red" type="text" name="downreport_from" id="downreport_from" class=" ">
								</div>
								<label  class="col-lg-1 to_date">TO <span style="float: right; text-align: right; margin-right:5px">:</span></label>
								<div class="col-sm-8 col-lg-3 col-xs-7">
									<input style="color: red" type="text"  name="downreport_to" id="downreport_to" class=""  >
								</div>
								<div class="col-lg-3">
									<select class="add_down_time downtime_addcnc" name="downreport_machine">
									</select>
								</div>
								<div class="col-lg-1 shift_add" >
									<button type="submit" class="button_submit">Submit</button>
								</div>
							</form>-->
								<div class="col-lg-12 table_report_box">
									<table class="table_report">
										<thead>
											<tr>
												<th>From</th>
												<th>TO</th>
												<th>Message</th>
												<th>notes</th>
												<th>Acknowlege</th>
												<th>reply</th>
												<th>date time</th>
												<!-- <th>Action</th>-->
											</tr>
										</thead>
										<tbody class="msg_report">
										</tbody>
									</table>
								</div>
							
						</div>
					</div>
				</div>
				<div class="all_buttons col-lg-12 col-sm-12">
					<button class="col-lg-12 col-sm-12 botton_bottom cancel messaging_close scale_close btn btn-default">CLOSE</button>
				</div>
			</div>
		</div>
	</div>
	<script type="text/javascript" src="<?php echo base_url("assets/js/jquery.js");?>"></script>
	<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url("assets/js/jquery.datepick.min.js");?>"></script>
	<script type="text/javascript" src="<?php echo base_url("assets/js/jquery.fancybox.min.js");?>"></script>
	<script src="https://cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js"></script>
	<script src="https://cdn.datatables.net/1.10.16/js/dataTables.bootstrap.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url("assets/js/jquery.popupoverlay.js");?>"></script>
	<script type="text/javascript" src="<?php echo base_url("assets/js/notify.min.js");?>"></script>
	<script>
	function show_notification_message(message, type) {
		$.notify(message, type);
	}
	</script>
	<script>
		var table;
		$(document).ready(function() {
			$('#showmenu').click(function() {
				$('.menu').toggle("fast");
			});
			$('#showmenu').click(function(){
				$('.menu,.btn-hamburger').toggleClass('active');
			});
			$('#panel').on('click', function(){
				$('.menu,.btn-hamburger').removeClass('active');
			});

			$( "#min-date,#max-date" ).datepicker({ dateFormat: 'yy-mm-dd' });
    		//datatables
			table = $('#my-table').DataTable({

				"processing": true,
				"serverSide": true,
				"order": [], 
				"ajax": {
					"url": "<?php echo site_url('report/ajax_list')?>",
					"type": "POST",
					"data": function ( d ) {
						d.min 	  = $('#min-date').val();
						d.max 	  = $('#max-date').val(); 
						d.status  = $('#job_status').val();
						d.machine = $('#job_machine').val(); 
					}
				},
				"columnDefs": [
				{
					"targets": [ 0 ],
					"orderable": false,
				},
				],
			});  
    
			$("#min-date,#max-date").change(function(){
				table.draw();
			});

			$( "#job_status" ).change(function(){
				table.draw();
			});
			$( "#job_machine" ).change(function(){
				table.draw();
			});
			$('#messaging').popup({
				pagecontainer: '.container',
				outline: false,
				escape:false,
				background:true,
				blur:false,
				focusdelay: 400,
				transition: 'all 0.3s'
			});
        });
		$('body').on('click','#date-clear',function(e){
			e.preventDefault();
			//$("#min-date,#max-date").clear();
			$("#min-date,#max-date").datepicker('setDate', null);
			table.draw();
		});
		$('body').on('click','.job_log',function(e){

			var job_id = $(this).attr('data-id');
			var jobcode = $(this).attr('data-jobcode');
			$('.job_history').empty();
			$.ajax({
				type : "POST",
				url : "<?php echo site_url('report/get_job_history'); ?>",
				data : {'job_id':job_id,'jobcode':jobcode},
				success : function(response) {
					var res = JSON.parse(response);
					if(res.result == "success"){
					    
						$('.job_history').append(res.data);
					}else{
						$('.job_history').append(res.data);
					}
				}
			});
		});
	</script>
	<script type="text/javascript">
	$(document).ready(function() {
		$(".tabs-menu_tow a").click(function(event) {
			event.preventDefault();
			$(this).parent().addClass("current");
			$(this).parent().siblings().removeClass("current");
			var tab = $(this).attr("href");
			$(".tab-content_tow").not(tab).css("display", "none");
			$(tab).fadeIn();
		});
		$(".tabs-menu_three a").click(function(event) {
			event.preventDefault();
			$(this).parent().addClass("current");
			$(this).parent().siblings().removeClass("current");
			var tab = $(this).attr("href");
			$(".tab-content_three").not(tab).css("display", "none");
			$(tab).fadeIn();
		});
		$(".tabs-menu a").click(function(event) {
			event.preventDefault();
			$(this).parent().addClass("current");
			$(this).parent().siblings().removeClass("current");
			var tab = $(this).attr("href");
			$(".tab-content").not(tab).css("display", "none");
			$(tab).fadeIn();
		});
		$('.menu li a').click(function() {
			$('.menu').toggle("fast");
		});
		
		
		$('body').on("click", ".messaging", function (e){
		$("#msg_notification")[0].reset();
			$('.msg_user_list').hide();
			$('.msg_group_list').hide();
			$('.msg_msg_to').empty();
			$('.msg_group_id').empty();
			$.ajax({
				url:"<?php echo site_url('message/get_user_list'); ?>"
			}).done(function (response) {
				$('.msg_msg_to').append(response);
			});
			
			$.ajax({
				url:"<?php echo site_url('message/get_group_list'); ?>"
			}).done(function (response) {
				$('.msg_group_id').append(response);
			});
			
			$.ajax({
				url:"<?php echo site_url('message/get_all_notifies'); ?>"
			}).done(function (response) {
				$('.msg_report').empty();
				$('.msg_report').append(response);
			});
			
		});
		$('body').on("change", "#msg_type", function (e){ 
			var msg_type = $(this).val();
			if(msg_type == 1){
				$('.msg_user_list').show();
				$('.msg_group_list').hide();
			}else if(msg_type == 2){
				$('.msg_group_list').show();
				$('.msg_user_list').hide();
			}
		});
		
		$('body').on("submit", "#msg_notification", function (e){ 
			e.preventDefault(); 
			var msg_type = $('#msg_type').val();
			var msg_identify = $('.msg_identify').val();
			var msg_msg_to = $('.msg_msg_to').val();
			var msg_group_id = $('.msg_group_id').val();
			var msg_message = $('#msg_message').val();
			var msg_notes = $('#msg_notes').val();
			
			$('.msg_identify_error_msg').html('');
			$('.msg_type_error_msg').html('');
			$('.msg_msg_to_error_msg').html('');
			$('.msg_group_error_msg').html('');
			$('.msg_message_error_msg').html('');
			
			 
			if(msg_identify == ''){
				$('.msg_identify_error_msg').html('Please Select Message Type');
				console.log('validate error - Please Select Message Type');
				return false;
			}
			
			if(msg_type == ''){
				$('.msg_type_error_msg').html('Please Select Message for');
				console.log('validate error - Please Select Message for');
				return false;
			}
			
			
			if(msg_type == 1){
				if(msg_msg_to == ''){
					$('.msg_msg_to_error_msg').html('Please Select User');
					console.log('validate error - Please Select User');
					return false;
				}
			}
			
			if(msg_type == 2){
				if(msg_group_id == ''){
					$('.msg_group_error_msg').html('Please Select Group');
					console.log('validate error - Please Select Group');
					return false;
				}
			}
			
			if(msg_message == ''){
				$('.msg_message_error_msg').html('Please Enter Message');
				console.log('validate error - Please Enter Message');
				return false;
			}
			//console.log('No validation Error occurs');
			var form_data = $("#msg_notification").serialize();
			$.ajax({
				url:"<?php echo site_url('message/insert_message'); ?>",
				data:form_data,
				type:"post"
			}).done(function (response) {
				//console.log(response);
				var res = $.parseJSON(response);
				if(res.result == 'success'){
					show_notification_message(res.message, "success");
	  				$("#msg_notification")[0].reset();
	  				$(".cancel").trigger('close');
				}else{
					show_notification_message(res.message, "error");
				}
			});
			
		});
		
		
		
	});
</script>
</body>
</html>