<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller {
	public function __construct() {
        parent::__construct();
        // if (!$this->session->userdata('logged_in')) {
        //     redirect('welcome');
        // }
        $this->load->model('dashboard_model');
        $this->load->helper('common_helper');
    }
	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	public function index(){
		$this->load->view('dashboard');
	}
	public function dashboard(){
              header('Access-Control-Allow-Origin: *');
		$todaydate=date('Y-m-d');
		$tomorrowdate=date('Y-m-d', strtotime(' +1 day'));
		$dayaftertomorrow=date('Y-m-d', strtotime(' +2 day'));
		$data['days']= array(array('day'=>$todaydate),array('day'=>$tomorrowdate),array('day'=>$dayaftertomorrow));
		$data['shifts']= array(array('shift'=>1),array('shift'=>2),array('shift'=>3));
		foreach ($data['days'] as $daykey => $day) {
			foreach ($data['shifts'] as $shiftkey => $shift) {
				$dashboard['machine'] = $this->dashboard_model->get_machine();
				foreach ($dashboard['machine'] as $id => $machine) {
					//$data['jobs'] = $this->dashboard_model->get_jobs($day['day'],$machine['id']);
					$jobs = $this->dashboard_model->get_jobs($day['day'],$machine['id'],$shift['shift']);
					$down = $this->dashboard_model->get_downtime($day['day'],$machine['id'],$shift['shift']);
					$data['jobs'] = array_merge($jobs, $down); 
					if(count($data) > 0){
						foreach ($data['jobs'] as $jobkey => $job) {
							$datetime1 = new DateTime($job['time_from']);
							$datetime2 = new DateTime($job['time_to']);
							$interval = $datetime1->diff($datetime2);
							$data['jobs'][$jobkey]['time_taken']=$interval->format('%h.%i');
							$data['jobs'][$jobkey]['percent']=(8*$data['jobs'][$jobkey]['time_taken']);
							if($job['job_complete_status']==1){
								$class="lightgreen_box disabled";
							}elseif($job['job_code']=="M/C Down"){
								$class="red_box";
							}elseif($job['job_code']=="Setup"){
								$class="yellow_box";
							}elseif($job['job_code']=="Idle"){
								$class="green";
							}elseif($job['job_code']=="Maintenance"){
								$class="green";
							}else{
								$class="green_box";
							}
							$time = new DateTime($job['time_from']);
							$data['jobs'][$jobkey]['datetime_from'] = $time->format('Y-m-d H:i:s');
							$data['jobs'][$jobkey]['class']=$class;
//echo "<pre>";print_r($data['jobs'][$jobkey]);
						}
						usort($data['jobs'], 'sortBydatetime_from');
					}
					$dashboard['machine'][$id]['jobs'] = $data['jobs'];
				}
				$dashboard['shifts'][$shiftkey]['machine']=$dashboard['machine'];
			}
			$dashboard['days'][$daykey]['shifts']=$dashboard['shifts'];
		}
		//echo "<pre>";print_r($dashboard['days']);exit;
		echo json_encode(array('days' => $dashboard['days']));exit;
	}
	public function addmachine(){
                header('Access-Control-Allow-Origin: *');
		$addmachine_id=$this->input->post('addmachine_id');
		if($addmachine_id==0){
			$data['machine']=$this->input->post('addmachine_machine');
			$data['trave_x']=$this->input->post('addmachine_travearea_x');
			$data['trave_y']=$this->input->post('addmachine_travearea_y');
			$data['memory']=$this->input->post('addmachine_memory');
			$data['programline']=$this->input->post('addmachine_program_lines');
			$data['created_on']=date("Y-m-d H:i:s");
			$data['status']=1;
			$addmachine=$this->dashboard_model->insert_machine($data);
			if($addmachine){
				echo json_encode(array('result' =>'success','message'=>'New Machine Creation Successfully','machine_id'=>$addmachine,'machine_name'=>$data['machine'],'task'=>'insert'));
			}else{
				echo json_encode(array('result' =>'failure','message'=>'New Machine Creation Failed'));
			}
		}else{
			$data['machine']=$this->input->post('addmachine_machine');
			$data['trave_x']=$this->input->post('addmachine_travearea_x');
			$data['trave_y']=$this->input->post('addmachine_travearea_y');
			$data['memory']=$this->input->post('addmachine_memory');
			$data['programline']=$this->input->post('addmachine_program_lines');
			$data['updated_on']=date("Y-m-d H:i:s");
			$data['status']=1;
			$updatemachine=$this->dashboard_model->update_machine($data,$addmachine_id);
			if($updatemachine){
				echo json_encode(array('result' =>'success','message'=>'Machine Details Successfully Updated','task'=>'update'));
			}else{
				echo json_encode(array('result' =>'failure','message'=>'Machine Details Update Failed'));
			}
		}
		
	}
	public function get_machinelist(){
                header('Access-Control-Allow-Origin: *');
		$machinelists=$this->dashboard_model->get_machine();
		$data = array();
		foreach ($machinelists as $key => $value) {
			$data[$value['machine']]=$value['id'];
		}
		//print_r($data);exit;
		echo json_encode($data);
	}
	public function delete_machinelist(){
                header('Access-Control-Allow-Origin: *');
		$machine_id=$this->input->post('machine_id');
		$delete_machine=$this->dashboard_model->delete_machine($machine_id);
		if($delete_machine){
			echo json_encode(array('result' =>'success','message'=>'Machine Deleted Successfully','machine_id'=>$machine_id));
		}else{
			echo json_encode(array('result' =>'failure','message'=>'Machine Deletion Failed','machine_id'=>$machine_id));
		}
	}
	public function get_machine_details(){
               header('Access-Control-Allow-Origin: *');
		$machine_id=$this->input->post('machine_id');
		$machine_details=$this->dashboard_model->get_machine_details($machine_id);
		if(!empty($machine_details)){
			echo json_encode(array('result' =>'success','id'=>$machine_details['id'],'addmachine_machine'=>$machine_details['machine'],'addmachine_travearea_x'=>$machine_details['trave_x'],'addmachine_travearea_y'=>$machine_details['trave_y'],'addmachine_memory'=>$machine_details['memory'],'addmachine_program_lines'=>$machine_details['programline']));
		}else{
			echo json_encode(array('result' =>'failure','message'=>'Machine Details Reterival Failed','machine_id'=>$machine_id));
		}
	}
	public function get_bossjob_details(){
                header('Access-Control-Allow-Origin: *');
		$job_code=$this->input->post('job_code');
		$boss_details=$this->dashboard_model->get_bossjob_details($job_code);
		//echo "<pre>";print_r($boss_details);exit;
		if(!empty($boss_details)){
			echo json_encode(array('result' =>'success','message'=>'Job Details Found','addjob_qty'=>$boss_details['quantity'],'addjob_running_time'=>$boss_details['total_time']));
		}else{
			echo json_encode(array('result' =>'failure','message'=>'Job Details Not Found'));
		}
	}
	public function addjob(){
                header('Access-Control-Allow-Origin: *');
		$data['job_code']=$this->input->post('addjob_job_code');
		$data['qty']=$this->input->post('addjob_qty');
		$data['running_time']=$this->input->post('addjob_running_time');
		$data['date']=date("Y-m-d");
		$data['time_from']=$this->input->post('addjob_slot_from');
		$data['time_to']=$this->input->post('addjob_slot_to');
		$data['machine']=$this->input->post('addjob_machine');
		$data['notes']=$this->input->post('addjob_notes');
		$data['created_on']=date("Y-m-d H:i:s");
        $data['status']=1;
        $newaddjob=$this->dashboard_model->addjob_insert($data);
        if($newaddjob){
			echo json_encode(array('result' =>'success','message'=>'New Job Added Successfully','job_id'=>$newaddjob));
		}else{
			echo json_encode(array('result' =>'failure','message'=>'New Job Adding Failed'));
		}
	}
	public function add_mcdown(){
		header('Access-Control-Allow-Origin: *');
		$data['machine']=$this->input->post('mcdown_machine');
		$data['date_from']=date('Y-m-d');
		$data['date_to']=date('Y-m-d');
		$data['time_from']=$this->input->post('mcdown_from');
		$data['time_to']=$this->input->post('mcdown_to');
		$data['notes']=$this->input->post('mcdown_notes');
		$data['down_time']=$this->input->post('mcdown_downtime');
		$data['mc_down']=1;
		$data['created_on']=date("Y-m-d H:i:s");
        $data['status']=1;
        $newdown=$this->dashboard_model->insert_down($data);
        if($newdown){
			echo json_encode(array('result' =>'success','message'=>'Machine Down Inserted Successfully','mcdown_id'=>$newdown));
		}else{
			echo json_encode(array('result' =>'failure','message'=>'Machine Down Insertion Failed'));
		}
	}
	public function add_otherdown(){
		header('Access-Control-Allow-Origin: *');
		$data['machine']=$this->input->post('otherdown_machine');
		$data['reason']=$this->input->post('otherdown_reason');
		$data['date_from']=date('Y-m-d');
		$data['date_to']=date('Y-m-d');
		$data['time_from']=$this->input->post('otherdown_from');
		$data['time_to']=$this->input->post('otherdown_to');
		$data['notes']=$this->input->post('otherdown_notes');
		$data['down_time']=$this->input->post('otherdown_downtime');
		$data['other_down']=1;
		$data['created_on']=date("Y-m-d H:i:s");
        $data['status']=1;
        $newdown=$this->dashboard_model->insert_down($data);
        if($newdown){
			echo json_encode(array('result' =>'success','message'=>'Machine Down Inserted Successfully','mcdown_id'=>$newdown));
		}else{
			echo json_encode(array('result' =>'failure','message'=>'Machine Down Insertion Failed'));
		}
	}
	public function add_setup(){
		header('Access-Control-Allow-Origin: *');
		$data['machine']=$this->input->post('setup_machine');
		$data['date_from']=date('Y-m-d');
		$data['date_to']=date('Y-m-d');
		$data['time_from']=$this->input->post('setup_from');
		$data['time_to']=$this->input->post('setup_to');
		$data['notes']=$this->input->post('setup_notes');
		$data['down_time']=$this->input->post('setup_downtime');
		$data['setup']=1;
		$data['created_on']=date("Y-m-d H:i:s");
        $data['status']=1;
        $newdown=$this->dashboard_model->insert_down($data);
        if($newdown){
			echo json_encode(array('result' =>'success','message'=>'Machine Down Inserted Successfully','mcdown_id'=>$newdown));
		}else{
			echo json_encode(array('result' =>'failure','message'=>'Machine Down Insertion Failed'));
		}
	}
	public function shift(){
                header('Access-Control-Allow-Origin: *');
		$shift_id=$this->input->post('shift_id');
		if($shift_id==0){
			$data['date_from']=date('Y-m-d',strtotime($this->input->post('shift_from')));
			$data['date_to']=date('Y-m-d',strtotime($this->input->post('shift_to')));
			$data['shift1']=isset($_POST["shift_shift1"]) ? 1 : 0 ;
			$data['shift2']=isset($_POST["shift_shift2"]) ? 1 : 0 ;
			$data['shift3']=isset($_POST["shift_shift3"]) ? 1 : 0 ;
			$data['shift1_to']=$this->input->post('shift_shift1_to');
			$data['shift1_from']=$this->input->post('shift_shift1_from');
			$data['shift2_to']=$this->input->post('shift_shift2_to');
			$data['shift2_from']=$this->input->post('shift_shift2_from');
			$data['shift3_to']=$this->input->post('shift_shift3_to');
			$data['shift3_from']=$this->input->post('shift_shift3_from');
			$data['count']=$this->input->post('shift_count');
			$data['created_on']=date("Y-m-d H:i:s");
	        $data['status']=1;
	        $newshift=$this->dashboard_model->insert_shift($data);
	        if($newshift){
				echo json_encode(array('result' =>'success','message'=>'Shift Inserted Successfully','shift_id'=>$newshift));
			}else{
				echo json_encode(array('result' =>'failure','message'=>'Shift Insertion Failed'));
			}
		}else{
			$data['date_from']=date('Y-m-d',strtotime($this->input->post('shift_from')));
			$data['date_to']=date('Y-m-d',strtotime($this->input->post('shift_to')));
			$data['shift1']=isset($_POST["shift_shift1"]) ? 1 : 0 ;
			$data['shift2']=isset($_POST["shift_shift2"]) ? 1 : 0 ;
			$data['shift3']=isset($_POST["shift_shift3"]) ? 1 : 0 ;
			$data['shift1_to']=$this->input->post('shift_shift1_to');
			$data['shift1_from']=$this->input->post('shift_shift1_from');
			$data['shift2_to']=$this->input->post('shift_shift2_to');
			$data['shift2_from']=$this->input->post('shift_shift2_from');
			$data['shift3_to']=$this->input->post('shift_shift3_to');
			$data['shift3_from']=$this->input->post('shift_shift3_from');
			$data['count']=$this->input->post('shift_count');
			$data['updated_on']=date("Y-m-d H:i:s");
	        $data['status']=1;
	        $newshift=$this->dashboard_model->update_shift($data,$shift_id);
	        if($newshift){
				echo json_encode(array('result' =>'success','message'=>'Shift Updated Successfully','shift_id'=>$newshift));
			}else{
				echo json_encode(array('result' =>'failure','message'=>'Shift Update Failed'));
			}
		}
		
	}
	public function get_shift_details(){
                header('Access-Control-Allow-Origin: *');
		$date_from=$this->input->post('shift_from');
		$shiftdetails=$this->dashboard_model->get_shift_details($date_from);
		//echo "<pre>";print_r($shiftdetails);exit;
		if(!empty($shiftdetails)){
			echo json_encode(array('result' =>'success','message'=>'Shift details Reterieved','shift_from'=>$date_from,'shift_to'=>$shiftdetails['date_to'],'shift1_from'=>$shiftdetails['shift1_from'],'shift1_to'=>$shiftdetails['shift1_to'],'shift2_from'=>$shiftdetails['shift2_from'],'shift2_to'=>$shiftdetails['shift2_to'],'shift3_from'=>$shiftdetails['shift3_from'],'shift3_to'=>$shiftdetails['shift3_to'],'shift_count'=>$shiftdetails['count'],'shift_shift1'=>$shiftdetails['shift1'],'shift_shift2'=>$shiftdetails['shift2'],'shift_shift3'=>$shiftdetails['shift3'],'shift_id'=>$shiftdetails['id']));
		}else{
			echo json_encode(array('result' =>'failure','message'=>'No Shift Details Found','shift_from'=>$date_from ));
		}
	}
	public function downtime(){
		$data=$_POST;
		for ($i=0; $i < count($data['downtime_fromdate']) ; $i++) { 
			$downtime['date_from']=date('Y-m-d',strtotime($data['downtime_fromdate'][$i]));
			$downtime['date_to']=date('Y-m-d',strtotime($data['downtime_todate'][$i]));
			$downtime['machine']=$data['downtime_machine'][$i];
			$downtime['reason']=$data['downtime_reason'][$i];
			$downtime['mc_down']=1;
			$downtime['created_on']=date("Y-m-d H:i:s");
			$downtime['status']=1;
			$newdown=$this->dashboard_model->insert_down($downtime);
		}
		if($newdown){
			echo json_encode(array('result' =>'success','message'=>'Machine Down Inserted Successfully','mcdown_id'=>$newdown));
		}else{
			echo json_encode(array('result' =>'failure','message'=>'Machine Down Insertion Failed'));
		}
	}
	public function maintain(){ 
                header('Access-Control-Allow-Origin: *');
		$data=$_POST;
		for ($i=0; $i < count($data['maintain_fromdate']) ; $i++) { 
			$downtime['date_from']=date('Y-m-d',strtotime($data['maintain_fromdate'][$i]));
			$downtime['date_to']=date('Y-m-d',strtotime($data['maintain_todate'][$i]));
			$downtime['machine']=$data['maintain_machine'][$i];
			$downtime['reason']=$data['maintain_reason'][$i];
			$downtime['maintenance']=1;
			$downtime['created_on']=date("Y-m-d H:i:s");
			$downtime['status']=1;
			$newdown=$this->dashboard_model->insert_down($downtime);
		}
		if($newdown){
			echo json_encode(array('result' =>'success','message'=>'New Maintenance Inserted Successfully','mcdown_id'=>$newdown));
		}else{
			echo json_encode(array('result' =>'failure','message'=>'New Maintenance Insertion Failed'));
		}
	}
	public function downreport(){
                header('Access-Control-Allow-Origin: *');
		$data=$_POST;
		$downreport['date_from']=date('Y-m-d',strtotime($data['downreport_from']));
		$downreport['date_to']=date('Y-m-d',strtotime($data['downreport_to']));
		$downreport['machine']=$data['downreport_machine'];
		$downreports=$this->dashboard_model->downreport($downreport);
		$report="";
		foreach ($downreports as $key => $downreport) {
			$report.="<tr><td>".$downreport['date_from']."</td><td>".$downreport['date_to']."</td><td>".$downreport['machine']."</td><td>".$downreport['reason']."</td></tr>";
		}
		if(!empty($downreports)){
			echo json_encode(array('result' =>'success','message'=>'Report LIsted successfully','data'=>$report));
		}else{
			$report.="<tr><td colspan='4'>No Details Found</td></tr>";
			echo json_encode(array('result' =>'failure','message'=>'No Details Found','data'=>$report));
		}
	}
	public function idlereport(){
                header('Access-Control-Allow-Origin: *');
		$data=$_POST;
		$idlereport['date_from']=date('Y-m-d',strtotime($data['idle_fromdate']));
		$idlereport['date_to']=date('Y-m-d',strtotime($data['idle_todate']));
		$idlereport['machine']=$data['idle_machine'];
		$idlereports=$this->dashboard_model->idlereport($idlereport);
		$report="";
		foreach ($idlereports as $key => $idlereport) {
			$report.="<tr><td>".$idlereport['date_from']."</td><td>".$idlereport['date_to']."</td><td>".$idlereport['machine']."</td><td>".$idlereport['reason']."</td></tr>";
		}
		if(!empty($idlereports)){
			echo json_encode(array('result' =>'success','message'=>'Report LIsted successfully','data'=>$report));
		}else{
			$report.="<tr><td colspan='4'>No Details Found</td></tr>";
			echo json_encode(array('result' =>'failure','message'=>'No Details Found','data'=>$report));
		}
	}
	public function setupreport(){
                header('Access-Control-Allow-Origin: *');
		$data=$_POST;
		$setupreport['date_from']=date('Y-m-d',strtotime($data['setup_fromdate']));
		$setupreport['date_to']=date('Y-m-d',strtotime($data['setup_todate']));;
		$setupreport['machine']=$data['setup_machine'];
		$setupreports=$this->dashboard_model->setupreport($setupreport);
		$report="";
		foreach ($setupreports as $key => $setupreport) {
			$report.="<tr><td>".$setupreport['date_from']."</td><td>".$setupreport['date_to']."</td><td>".$setupreport['machine']."</td><td>".$setupreport['reason']."</td></tr>";
		}
		if(!empty($setupreports)){
			echo json_encode(array('result' =>'success','message'=>'Report LIsted successfully','data'=>$report));
		}else{
			$report.="<tr><td colspan='4'>No Details Found</td></tr>";
			echo json_encode(array('result' =>'failure','message'=>'No Details Found','data'=>$report));
		}
	}
	public function maintainreport(){
                header('Access-Control-Allow-Origin: *');
		$data=$_POST;
		$maintainreport['date_from']=date('Y-m-d',strtotime($data['maintainreport_fromdate']));
		$maintainreport['date_to']=date('Y-m-d',strtotime($data['maintainreport_todate']));
		$maintainreport['machine']=$data['maintainreport_machine'];
		$maintainreports=$this->dashboard_model->maintainreport($maintainreport);
		$report="";
		foreach ($maintainreports as $key => $maintainreport) {
			$report.="<tr><td>".$maintainreport['date_from']."</td><td>".$maintainreport['date_to']."</td><td>".$maintainreport['machine']."</td><td>".$maintainreport['reason']."</td></tr>";
		}
		if(!empty($maintainreports)){
			echo json_encode(array('result' =>'success','message'=>'Report LIsted successfully','data'=>$report));
		}else{
			$report.="<tr><td colspan='4'>No Details Found</td></tr>";
			echo json_encode(array('result' =>'failure','message'=>'No Details Found','data'=>$report));
		}
	}
}
