<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Mobile extends CI_Controller {
    public $shift_up_time = array();
    public function __construct() {
        parent::__construct();

       date_default_timezone_set('Asia/Kolkata');
        header('Access-Control-Allow-Origin: *');
        $this->load->model('mobile_model','mobile');
        $this->load->model('cron_model');
        $this->load->model('dashboard_model');
        $this->load->helper('common_helper');
        
        /******* GET SHIFT TIME START *******/
        $date['date_from'] = date('Y-m-d');
        $shift_details = $this->dashboard_model->shift_timings($date);
        $this->shift_up_time =  $shift_details['shift1_to'];        
        
        /******* GET SHIFT TIME START *******/
    }
    public function index(){
        echo "Mobile service working fine. no php error.";
    }
    public function login($login_username,$login_password){
        $data['login_username'] = $login_username;
        $data['login_password'] = $login_password;
        if($this->mobile->check_user_avail($data)) {
            if($this->mobile->auth_user($data)){
                $userinfo = $this->mobile->get_userinfo($data['login_username']);
                $details['id'] = $userinfo['id'];
                $details['firstname'] = $userinfo['firstname'];
                $details['lastname'] = $userinfo['lastname'];
                $details['email'] = $userinfo['email'];
                $details['username'] = $userinfo['username'];
                $details['user_type'] = $userinfo['user_type'];
                $details['designation'] = $userinfo['designation'];
                $details['status'] = $userinfo['status'];
                $result = array('result'=>'success','message'=>'Login successfully completed.','data'=>$details);
            }else{
                $result = array('result'=>'failure','message'=>'invalid username /password.');
            }
        } else {
            $result = array('result'=>'failure','message'=>'invalid username /password.');
        }
        echo json_encode($result);
    }
    public function master($mastername='user'){
        switch ($mastername) {
            case 'reason':{
                $reasons = $this->mobile->get_reasons();
                if ($reasons) {
                    echo  json_encode(array('result' =>'success','message' => 'Result Retrieved Successfully','data' => $reasons));
                }else{
                    echo  json_encode(array('result' =>'failure','message' => 'Result Retrieve Failed'));
                }
                break;
            }
            case 'machine':{
                $machines = $this->mobile->get_machines();
                $all_machine = array_merge(array(array('machine'=>'All','id'=>'all')),$machines);
                if ($all_machine) {
                    echo  json_encode(array('result' =>'success','message' => 'Result Retrieved Successfully','data' => $all_machine));
                }else{
                    echo  json_encode(array('result' =>'failure','message' => 'Result Retrieve Failed'));
                }
                break;
            }
            case 'user':{
                $users = $this->mobile->get_users();
                if ($users) {
                    echo  json_encode(array('result' =>'success','message' => 'Result Retrieved Successfully','data' => $users));
                }else{
                    echo  json_encode(array('result' =>'failure','message' => 'Result Retrieve Failed'));
                }
                break;
            }
        }
    }
    public function operation($master,$operation,$id){
        switch ($master) {
            case 'reason':{
                switch ($operation) {
                    case 'delete':{
                        $delete = $this->mobile->reason_delete($id);
                        if ($delete) {
                            echo  json_encode(array('result' =>'success','message' => 'Reason Successfully Deleted','id' => $delete));
                        }else{
                            echo  json_encode(array('result' =>'failure','message' => 'Reason Delete Failed'));
                        }
                        break;
                    }
                    default:{
                        $view = $this->mobile->reason_view($id);
                        if ($view) {
                            echo  json_encode(array('result' =>'success','message' => 'Reason Retrieved Successfully','data' => $view));
                        }else{
                            echo  json_encode(array('result' =>'failure','message' => 'Reason Retrieve Failed'));
                        }
                        break;
                    }
                }
                break;
            }
            case 'machine':{
                switch ($operation) {
                    case 'delete':{
                        $delete = $this->mobile->machine_delete($id);
                        if ($delete) {
                            echo  json_encode(array('result' =>'success','message' => 'Reason Successfully Deleted','id' => $delete));
                        }else{
                            echo  json_encode(array('result' =>'failure','message' => 'Reason Delete Failed'));
                        }
                        break;
                    }
                    default:{
                        $view = $this->mobile->machine_view($id);
                        if ($view) {
                            echo  json_encode(array('result' =>'success','message' => 'Machine Retrieved Successfully','data' => $view));
                        }else{
                            echo  json_encode(array('result' =>'failure','message' => 'Machine Retrieve Failed'));
                        }
                        break;
                    }
                }
                break;
            }
            case 'user':{
                switch ($operation) {
                    case 'delete':{
                        $delete = $this->mobile->user_delete($id);
                        if ($delete) {
                            echo  json_encode(array('result' =>'success','message' => 'User Successfully Deleted','id' => $delete));
                        }else{
                            echo  json_encode(array('result' =>'failure','message' => 'User Delete Failed'));
                        }
                        break;
                    }
                    default:{
                        $view = $this->mobile->user_view($id);
                        if ($view) {
                            echo  json_encode(array('result' =>'success','message' => 'User Retrieved Successfully','data' => $view));
                        }else{
                            echo  json_encode(array('result' =>'failure','message' => 'User Retrieve Failed'));
                        }
                        break;
                    }
                }
                break;
            }
        }
    }
/* machinedown befor split
public function machinedown(){ 
    $data['machine']=$this->mobile->get_machine_id($this->input->get('machine_name'));
    $data['date_from']=date('Y-m-d');
    $data['date_to']=date('Y-m-d');
    $mcdown_from = $this->input->get('from_time');
    $mcdown_to = $this->input->get('to_time');
    $time_from= new DateTime($this->input->get('from_time'));
    $data['time_from']=$time_from->format('H:i:s');
    $time_to= new DateTime($this->input->get('to_time'));
    $data['time_to']=$time_to->format('H:i:s');
    $data['notes']=$this->input->get('notes');
    $data['down_time']=1;
    $data['mc_down']=1;
    $data['shift']=1;
    $data['position']=0;
    $data['created_on']=date("Y-m-d H:i:s");
    $data['status']=1;
    $job_shift_start = $data['date_from'].' 08:00:00';
    $job_shift_end = $data['date_from'].' 20:00:00';
    $job_start = $data['date_from'].' '.$data['time_from'];
    $job_end = $data['date_from'].' '.$data['time_to'];
    if((($job_start < $job_shift_start) || ($job_start > $job_shift_end))||(($job_end < $job_shift_start) || ($job_end >$job_shift_end )) ){
        echo json_encode(array('result' =>'failure','message'=>'Check Machine Down Timing with Shift timing'));
    }else{
        //$newdown=$this->mobile->insert_down($data);
        $newdown=$this->mobile->insert_machine_down($data);
        //$this->load->library('../controllers/cron');
        //$this->cron->moving_loaded_jobs_current_time();
        if($newdown){
            $mcdown_updates['job_id'] = $newdown;
            $mcdown_updates['updated_for'] = -1; 
            $mcdown_updates['updated_to'] = 'Machine Down Ini - '.$mcdown_from.' To '.$mcdown_to;
            $mcdown_updates['updated_by'] =  'mobile user'; 
            $mcdown_updates['updated_status'] = 0;
            $mcdown_updates['updated_remark'] = $data['notes'];
            mcdown_updates($mcdown_updates);

            $this->alertusers($data['machine'],'M/C DOWN',$data['time_from'],$data['time_to']);
            echo json_encode(array('result' =>'success','message'=>'Machine Down Inserted Successfully','mcdown_id'=>$newdown));
        }else{
            echo json_encode(array('result' =>'failure','message'=>'Machine Down Insertion Failed'));
        }
    }
}
*/

public function otherdown(){
    
    $current_time = date("H:i:s");
    $time_from= new DateTime($this->input->get('from_time'));
    $data['time_from']=$time_from->format('H:i:s');    
    if(strtotime($current_time) < strtotime($data['time_from'])){
       echo json_encode(array('result' =>'failure','message'=>'Machine start time will not accept future time')); 
       exit;
    }
    
    $cur_date_time = date('Y-m-d H:i:s');
    $time_from= new DateTime($cur_date_time);
    $data['time_from']=$time_from->format('H:i:00');     
    $noerror = 0;
    $newdown_arr ='';
    $newdown_arr_machine ='';
    $machine = $this->mobile->get_machine_id($this->input->get('machine_name'));
	$machine_status = $this->down_before_hold_machine($machine);
	
    if($machine_status=="mc_down"){
		echo  json_encode(array('result' =>'failure','message' => 'machine is down please give machine ready after that  you can setup down'));
		exit;
	}elseif($machine_status=="other_down"){
		echo  json_encode(array('result' =>'failure','message' => 'Machine is already down so plz give machine ready after that you can give down'));
		exit;
	}
	/*if($machine_status=="setup"){
		echo  json_encode(array('result' =>'failure','message' => 'job is setup on this machine please continue or hold the job after that you can setup down'));
		exit;
	}elseif($machine_status=="mc_down"){
		echo  json_encode(array('result' =>'failure','message' => 'machine is down please give machine ready after that  you can setup down'));
		exit;
	}elseif($machine_status=="other_down"){
		echo  json_encode(array('result' =>'failure','message' => 'machine is other down please give machine ready after that  you can setup down'));
		exit;
	}elseif($machine_status=="not_complete"){
		echo  json_encode(array('result' =>'failure','message' => 'job is running on this machine please continue or hold the job after that  you can setup down'));
		exit;
	}    */
    
    
    /*if($this->input->get('machine_name')=='All'){
        $data['machine']=$this->mobile->get_all_machine_id();
    }else{
        $data['machine']=$this->mobile->get_down_machine_id($this->input->get('machine_name'));
    }
    foreach($data['machine'] as $machine_list){
        
        $last_down = $this->mobile->last_machine_down();
        if($last_down!=0){
            $data['id'] = $last_down['id'];
            $from_date = $last_down['date_from'];
            $time_from= new DateTime($last_down['time_from']);
            $data['time_from']=$time_from->format('H:i:s');            
            $datetime1 = new DateTime($from_date.' '.$last_down['time_from']);
            $datetime2 = new DateTime($from_date.' '.$this->input->get('to_time'));
            $interval = $datetime1->diff($datetime2);
            $diffhour = $interval->format('%h');
            $diffmin = $interval->format('%i');
            
            $EndTime = new DateTime($from_date.''.$last_down['time_from']);
            $EndTime->modify('+'.$diffhour.' hours');
            $EndTime->modify('+'.$diffmin.' minutes');
            $data['time_to'] = $EndTime->format('H:i:s');
            $data['override'] = 1;
            $other_from = $last_down['time_from'];
            $other_to   = $this->input->get('to_time');
        }else{
            $data['override'] = 0;
            $time_from= new DateTime($this->input->get('from_time'));
            $data['time_from']=$time_from->format('H:i:s');
            $time_to= new DateTime($this->input->get('to_time'));
            $data['time_to']=$time_to->format('H:i:s');  
            $other_from = $last_down['time_from'];
            $other_to   = $this->input->get('to_time');            
        } 
        $data['machine'] = $machine_list['id'];
        $data['date_from']=date('Y-m-d');
        $data['date_to']=date('Y-m-d');
        $data['reason']=$this->input->get('reason');
        $data['notes']=$this->input->get('notes');
        $data['down_time']=1;
        $data['other_down']=1;
        $data['shift']=1;
        $data['position']=0;
        $data['created_on']=date("Y-m-d H:i:s");
        $data['status']=1; 
        $data['other']=1;*/
        
        
        $data['machine']=$this->mobile->get_machine_id($this->input->get('machine_name'));
		$other_from = $this->input->get('from_time');
		$other_to = $this->input->get('to_time');
		$time_to= new DateTime($this->input->get('to_time'));
		$data['time_to']=$time_to->format('H:i:s');		
        $data['date_from']=date('Y-m-d');
        $data['date_to']=date('Y-m-d');
        $data['reason']=$this->input->get('reason');
        $data['notes']=$this->input->get('notes');
        $data['down_time']=1;
        $data['other_down']=1;
        $data['shift']=1;
        $data['position']=0;
        $data['created_on']=date("Y-m-d H:i:s");
        $data['status']=1; 
        $data['other']=1;     

        $newdown=$this->check_job_or_mcdown($data);
        if($newdown['result'] = 'success'){
            $mcdown_updates['job_id'] = 0;
            $mcdown_updates['updated_for'] = 0; 
            $mcdown_updates['updated_to'] = 'Other Down Ini - '.$other_from.' To '.$other_to;
            $mcdown_updates['updated_by'] =  'mobile user'; 
            $mcdown_updates['updated_status'] = 0;
            $mcdown_updates['updated_remark'] = $data['notes'];
            mcdown_updates($mcdown_updates);
            $this->alertusers($data['machine'],$data['reason'],$data['time_from'],$data['time_to']);
        }else{
            $noerror++;
        }
        if($noerror==0){
            $this->cron_run();
             echo json_encode(array('result' =>'success','message'=>'Other Down Inserted Successfully'));
            }else{
                echo json_encode(array('result' =>'failure','message'=>'Other Down Insertion Failed'));
            }         
    }


public function check_job_or_otherdown($data){
    $this->load->model('dashboard_model');

	$check['date_from']	=	date('Y-m-d',strtotime($data['date_from']));
	$check['date_to']	=	date('Y-m-d',strtotime($data['date_to']));
	$check['machine']	=	$data['machine'];
	$check['shift']		=	$data['shift'];
	$check['time_from']	=	date('H:i:s',strtotime($data['time_from']));
	$check['time_to']	=	date('H:i:s',strtotime($data['time_to']));
	$check['notes']		=	$data['notes'];
	if(isset($_POST['move_jobs'])){
		$check['move_jobs']	=	$this->input->post('move_jobs');
	}else{
		$check['move_jobs']	= 0;
	}
	$job_details = $this->dashboard_model->check_job_or_otherdown($check);

	return $this->split_job_other($job_details,$check);
		
    }
    
    private function split_job_other($data,$machinedown){
        $this->load->model('dashboard_model');
        //echo "<pre>";print_r($machinedown);exit;
    	$move_jobs = $machinedown['move_jobs'];
    	unset($machinedown['move_jobs']);
    	$shifts_details = $this->shift_and_timings($machinedown['date_from']); 
        foreach ($shifts_details as $key => $shift_details) {
            if($machinedown['shift'] == $shift_details['shift']){
                $shift_start_time = $shift_details['shift_start'];
                $shift_end_time = $shift_details['shift_end'];
            } 
        }
        if( ($shift_end_time < DEFAULT_SHIFT_START_TIME ) ){
            $shift_end_time = date('Y-m-d', strtotime($data['date_from'].' +1 day')).' '.$shift_end_time ;
        }else{
            $shift_end_time = $machinedown['date_from'].' '.$shift_end_time ;
        }
        if(($shift_start_time < DEFAULT_SHIFT_START_TIME )){
            $shift_start_time = date('Y-m-d', strtotime($data['date_from'].' +1 day')).' '.$shift_start_time ;
        }else{
            $shift_start_time = $machinedown['date_from'].' '.$shift_start_time ;
        }
    	
    	//if((new DateTime($shift_start_time) <= new DateTime($machinedown['date_from'].' '.$machinedown['time_from']))&&(new DateTime($shift_end_time) >= new DateTime($machinedown['date_to'].' '.$machinedown['time_to']))){ 
    	$datetime1 = new DateTime($machinedown['date_from'].' '.$machinedown['time_from']);
		$datetime2 = new DateTime($machinedown['date_to'].' '.$machinedown['time_to']);
		$interval1 = $datetime1->diff($datetime2);
		$mcdown_hour = $interval1->format('%h');
		$mcdown_min = $interval1->format('%i');
		//echo "<pre>";print_r($data);exit;
	    	if( $data['job']== 1 ){  
			$mcdown_time = (($mcdown_hour*60)+$mcdown_min); 
	    		if( ($mcdown_time <= MAXIMUM_MACHINE_DOWN_ALLOW)){
	    			if( ( $data['other_down']!= 0 ) && ( $data['task']!=1 ) ){
	    				$return = array( 'result' => 'failed' , 'message' => 'machine down on this time.' );
		    		}else{
		    			 if($data['running'] == 1){
		    			 	$job_details = $this->dashboard_model->get_job_details($data['job_id']);
		    			 	// calculate starting time
		    			 	if($job_details){
		    			 		
		    			 	$datetime1 = new DateTime($job_details['date_from'].' '.$job_details['time_from']);
							$datetime2 = new DateTime($machinedown['date_from'].' '.$machinedown['time_from']);
							$interval1 = $datetime1->diff($datetime2);
							$start_diffhour = $interval1->format('%h');
							$start_diffmin = $interval1->format('%i');
							
							$DiffTime = new DateTime($job_details['date_from'].' '.$job_details['time_from']);
							$DiffTime->modify('+'.$start_diffhour.' hours');
							$DiffTime->modify('+'.$start_diffmin.' minutes');
							
			    			 	// calculating ending time
			    			 	
			    			$datetime1 = new DateTime($machinedown['date_from'].' '.$machinedown['time_from']);
							$datetime2 = new DateTime($job_details['date_to'].' '.$job_details['time_to']);
							$interval1 = $datetime1->diff($datetime2);
							$end_diffhour = $interval1->format('%h');
							$end_diffmin = $interval1->format('%i');
							
							$EndDiffTime = new DateTime($machinedown['date_to'].' '.$machinedown['time_to']);
							$EndDiffTime->modify('+'.$end_diffhour.' hours');
							$EndDiffTime->modify('+'.$end_diffmin.' minutes');
			    			 	
			    			 	//update old job 
			    			 	
		    			 	$update['date_from']	= $job_details['date_from'];
		    			 	$update['time_from']	= $job_details['time_from'];
		    			 	$update['date_to']	= $machinedown['date_from'];
		    			 	$update['time_to']	= $machinedown['time_from'];
		    			 	$update['task']		= 1;
		    			 	$update['down_time']	= $start_diffhour.'.'.$start_diffmin;
		    			 	
		    			 	$newdown=$this->dashboard_model->update_jobs($job_details['id'],$update);
			    			 	
			    			 	//insert new job
			    			 	
		    			 	$insert_job['date_from'] 	   = $EndDiffTime->format('Y-m-d');
		    			 	$insert_job['time_from'] 	   = $machinedown['time_to'];
		    			 	$insert_job['date_to']    	   = $EndDiffTime->format('Y-m-d');
		    			 	$insert_job['time_to']   	   = $EndDiffTime->format('H:i:00');
		    			 	$insert_job['job_code']  	   = $job_details['job_code'];
		    			 	$insert_job['qty']		       = $job_details['qty'];
		    			 	$insert_job['machine']    	   = $job_details['machine'];
		    			 	$insert_job['down_time']	   = $end_diffhour.'.'.$end_diffmin;
		    			 	$insert_job['task']       	   = $job_details['task'];
		    			 	$insert_job['reason']    	   = $job_details['reason'];
		    			 	$insert_job['notes']      	   = $job_details['notes'];
		    			 	$insert_job['setup']      	   = 0;
		    			 	$insert_job['side']      	   = $job_details['side'];
		    			 	$insert_job['shift']      	   = $job_details['shift'];
		    			 	$insert_job['position']        = $job_details['position'];
		    			 	$insert_job['assy_start']      = $job_details['notes'];
		    			 	$insert_job['assy_end']        = $job_details['assy_start'];
		    			 	$insert_job['setup_start']     = $job_details['setup_start'];
		    			 	$insert_job['setup_end']       	   = $job_details['setup_end'];
		    			 	$insert_job['tooling_start']       = $job_details['tooling_start'];
		    			 	$insert_job['tooling_end']     	   = $job_details['tooling_end'];
		    			 	$insert_job['qc_start']     	   = $job_details['qc_start'];
		    			 	$insert_job['qc_end']      	   = $job_details['qc_end'];
		    			 	$insert_job['job_complete_status'] = 0;
		    			 	$insert_job['status']		   = 1;
		    			 	$insert_job['split_status']	= 1;
		    			 	$insert_job['hold_status']	= 1;
			    			 	
			    			 	 
			    			 		
			    			$newaddjob=$this->dashboard_model->check_position($insert_job,0);
	
			    			 	//insert machine down
			    			 	
			    			 	$insert_mcdown['date_from']	= $machinedown['date_from'];
			    			 	$insert_mcdown['time_from']	= $machinedown['time_from'];
				    			$insert_mcdown['date_to']	= $machinedown['date_to'];
			    			 	$insert_mcdown['time_to']	= $machinedown['time_to'];
			    			 	$insert_mcdown['machine']    	= $job_details['machine'];
			    			 	$insert_mcdown['notes']    	= $machinedown['notes'];
			    			 	$insert_mcdown['down_time']	= $mcdown_hour.'.'.$mcdown_min;
			    			 	$insert_mcdown['other_down']	= 1;
    							$insert_mcdown['shift']		= $job_details['shift'];
    							$insert_mcdown['position']	= 0;
    							$insert_mcdown['created_on']	= date("Y-m-d H:i:s");
    							$insert_mcdown['status']	= 1;
			    			 	//
			    			 	//echo "<pre>";print_r($insert_mcdown);exit;
			    			 	//$newdown=$this->dashboard_model->insert_machine_down($insert_mcdown);
			    			 	$this->check_insert_otherdown($insert_mcdown);
			    			 	
			    			 	$return = array( 'result' => 'success' , 'message' => 'job split / machine down inserted successfully.' );
			    			 	
		    			 	}else{
		    			 		$return = array( 'result' => 'failed' , 'message' => 'job details not found.' );
		    			 	}
		    			 }else{
		    			 	
		    			 	//insert machine down
		    			 	
					 	$insert_mcdown['date_from']	= $machinedown['date_from'];
					 	$insert_mcdown['time_from']	= $machinedown['time_from'];
						$insert_mcdown['date_to']	= $machinedown['date_to'];
					 	$insert_mcdown['time_to']	= $machinedown['time_to'];
					 	$insert_mcdown['machine']    	= $machinedown['machine'];
					 	$insert_mcdown['notes']    	= $machinedown['notes'];
					 	$insert_mcdown['down_time']	= $mcdown_hour.'.'.$mcdown_min;
						$insert_mcdown['other_down']	= 1;
						$insert_mcdown['shift']		= $machinedown['shift'];
						$insert_mcdown['position']	= 0;
						$insert_mcdown['created_on']	= date("Y-m-d H:i:s");
						$insert_mcdown['status']	= 1;
					 	
					 	//$newdown=$this->dashboard_model->insert_machine_down($insert_mcdown);
					 	$this->check_insert_otherdown($insert_mcdown);
						$return = array( 'result' => 'success' , 'message' => 'machine down inserted successfully.' );
		    			 }
		    		}
	    		}else{
	    			if($move_jobs != 1){
	    				$return = array( 'result' => 'failed' , 'message' => 'Please Move jobs machine down more than '.round((MAXIMUM_MACHINE_DOWN_ALLOW/60), 1).' Hours' );
	    			}else{
	    				//insert machine down
			    		 	
				 	$insert_mcdown['date_from']	= $machinedown['date_from'];
				 	$insert_mcdown['time_from']	= $machinedown['time_from'];
					$insert_mcdown['date_to']	= $machinedown['date_to'];
				 	$insert_mcdown['time_to']	= $machinedown['time_to'];
				 	$insert_mcdown['machine']    	= $machinedown['machine'];
				 	$insert_mcdown['notes']    	= $machinedown['notes'];
				 	$insert_mcdown['down_time']	= $mcdown_hour.'.'.$mcdown_min;
					$insert_mcdown['other_down']	= 1;
					$insert_mcdown['shift']		= $machinedown['shift'];
					$insert_mcdown['position']	= 0;
					$insert_mcdown['created_on']	= date("Y-m-d H:i:s");
					$insert_mcdown['status']	= 1;
					
				 	$this->check_insert_otherdown($insert_mcdown);
	    				$return = array( 'result' => 'success' , 'message' => 'machine down inserted successfully.' );
	    			}
	    			
	    		}
	    	}else{
			//insert machine down
			    			 	
		 	$insert_mcdown['date_from']	= $machinedown['date_from'];
		 	$insert_mcdown['time_from']	= $machinedown['time_from'];
			$insert_mcdown['date_to']	= $machinedown['date_to'];
		 	$insert_mcdown['time_to']	= $machinedown['time_to'];
		 	$insert_mcdown['machine']    	= $machinedown['machine'];
		 	$insert_mcdown['notes']    	= $machinedown['notes'];
		 	$insert_mcdown['down_time']	= $mcdown_hour.'.'.$mcdown_min;
			$insert_mcdown['other_down']	= 1;
			$insert_mcdown['shift']		= $machinedown['shift'];
			$insert_mcdown['position']	= 0;
			$insert_mcdown['created_on']	= date("Y-m-d H:i:s");
			$insert_mcdown['status']	= 1;
			
		 	$this->check_insert_otherdown($insert_mcdown);
			$return = array( 'result' => 'success' , 'message' => 'machine down inserted successfully.' );
			
		}    
       /* }else{ 
            $return = array('result' =>'failure','message'=>'Machine Down Time crossed shift time');
        }*/
    	return $return;
    }
    
    private function check_insert_otherdown($data){
    	header('Access-Control-Allow-Origin: *');
        $this->load->model('mcdown_model','mcdown'); 
        
    	//echo "<pre>";print_r($data);exit;
    	$dates = createDateRangeArray($data['date_from'],$data['date_to']);
    	//echo "<pre>";print_r($dates);exit;
	foreach ($dates as $key => $date) { 
		$data['shifts'] = $this->shift_and_timings(date('Y-m-d',strtotime($date))); 
		// echo "<pre>";print_r($data['shifts']);exit;
		foreach($data['shifts'] as $shift_id => $shift){
			$from_insert = 0; 
			$to_insert = 0; 
			$check['machine'] 	= $data['machine'];
			$check['date_from'] 	= $date;
			$check['shift'] 	= $shift['shift'];
			$mcdown = $this->mcdown->check_fullshift_otherdown($check);
			 //echo "<pre>";print_r($mcdown);exit;
			if(($mcdown['full_shift_mcdown']!=1)){
				if( ($shift['shift_end'] < DEFAULT_SHIFT_START_TIME ) ){
					$shift['shift_end'] = date('Y-m-d', strtotime(date('Y-m-d',strtotime($date)).' +1 day')).' '.$shift['shift_end'];
				}else{
					$shift['shift_end'] = date('Y-m-d',strtotime($date)).' '.$shift['shift_end'];
				}
				if(($shift['shift_start'] < DEFAULT_SHIFT_START_TIME )){
					$shift['shift_start'] = date('Y-m-d', strtotime(date('Y-m-d',strtotime($date)).' +1 day')).' '.$shift['shift_start'];
				}else{
					$shift['shift_start'] = date('Y-m-d',strtotime($date)).' '.$shift['shift_start'];
				}
				// echo "<pre>";print_r($shift);exit;
				$downtime['date_from']  = date('Y-m-d',strtotime($shift['shift_start']));
				$downtime['date_to']    = date('Y-m-d',strtotime($shift['shift_end']));
				if($key == 0){ 
					// echo "<br/>first day<br/>";
					if(new DateTime($data['date_from'].' '.$data['time_from']) <= new DateTime($shift['shift_end']) ){
                        if(check_time(date('H:i:s',strtotime($shift['shift_start'])),date('H:i:s',strtotime($shift['shift_end'])),date('H:i:s',strtotime($data['time_from'])))){
							$from_insert = 1; 
							$downtime['time_from']  = date('H:i:s',strtotime($data['time_from']));
						}else{ 
							$from_insert = 1; 
							$downtime['time_from']  = date('H:i:s',strtotime($shift['shift_start']));
						}
					} 
				}else{
					$from_insert = 1;
					$downtime['time_from']  = date('H:i:s',strtotime($shift['shift_start']));
					
				}
				if($key == (count($dates)-1)){  
				// echo "<br/>last day<br/> "; 
					if(new DateTime($data['date_to'].' '.$data['time_to']) >= new DateTime($shift['shift_start']) ){ 
							if(check_time(date('H:i:s',strtotime($shift['shift_start'])),date('H:i:s',strtotime($shift['shift_end'])),date('H:i:s',strtotime($data['time_to'])))){
							$to_insert = 1;
							$downtime['time_to']    = date('H:i:s',strtotime($data['time_to']));
						}else{
							$to_insert = 1;
							$downtime['time_to']    = date('H:i:s',strtotime($shift['shift_end']));
						}
					}
				}else{ 
					$to_insert = 1;
					$downtime['time_to']    = date('H:i:s',strtotime($shift['shift_end']));

				}
				//  echo "<pre>";print_r($downtime['time_to']); 
				$downtime['shift']      =	$shift['shift'];
				$downtime['machine']    =	$data['machine'];
				$downtime['notes']    	=	$data['notes'];
				$downtime['down_time']	=	$data['down_time'];
				$downtime['other_down']	=	1;
				$downtime['position']	=	0;
				$downtime['created_on']	=	date("Y-m-d H:i:s");
				$downtime['status']	=	1;
				//echo "<pre>";print_r($from_insert.'-'.$to_insert);
				//echo "<pre>";print_r($downtime);
				if( ($from_insert == 1)&&($to_insert == 1) ){
					$newdown=$this->dashboard_model->insert_machine_down($downtime);
					 
				}
				
				
			}
		}
	} 
    }
/**
*
* This Function Used to Update Jobs Setup status.
* If Setup status 1 then job starting time updated.
* Setup status 2 then setup finished and job loaded status will be upadated.
*
**/
/** 
// befor adding sides
public function setup(){
    //$data['job_code'] = $this->input->get('job_code');
    $username = $this->input->get('username');
    $machine_name = $this->input->get('machine_name');
    $machine = $this->mobile->get_machine_id($this->input->get('machine_name'));
    $job_details_boots = $this->mobile->get_job_details_boots($this->input->get('job_code'));
    $job_details_spcs = $this->mobile->get_job_details($this->input->get('job_code'));
    
    if($job_details_spcs){
        if(($job_details_spcs['setup'] > 0)&&($job_details_spcs['machine']!=$machine)){
            if($this->input->get('status') == 1){
                $check_availability['date'] = $job_details_spcs['date_from'];
                $check_availability['machine'] = $machine;
                $check_availability['shift'] = $job_details_spcs['shift'];
                $check_availability['time_from'] = date('H:i:s');
                $check_availability['time_to'] = $job_details_spcs['time_to'];
                $job_on_time = $this->mobile->check_job_availability($check_availability);
                 
                if($job_on_time['mcdown']==0){
                    $data['date_from']=date('Y-m-d');
                    $data['time_from']=date('H:i:00');
                    $datetime1 = new DateTime($job_details_spcs['date_from'].' '.$job_details_spcs['time_from']);
                    $datetime2 = new DateTime($job_details_spcs['date_to'].' '.$job_details_spcs['time_to']);
                    $interval = $datetime1->diff($datetime2);
                    $diffhour = $interval->format('%h');
                    $diffmin = $interval->format('%i');
                    $EndTime = new DateTime($data['time_from']);
                    $EndTime->modify('+'.$diffhour.' hours');
                    $EndTime->modify('+'.$diffmin.' minutes');
                    $data['date_to']=date('Y-m-d');
                    $data['time_to']= $EndTime->format('H:i:00');
                    $data['machine']=$this->mobile->get_machine_id($this->input->get('machine_name'));
                    $data['setup']=1;
                    $data['setup_start'] = date('Y-m-d H:i:00');
                    $job_status=$this->mobile->update_jobstatus($data,$job_details_spcs['id']);
                    
                    $shift_timing['setup_start'] = date('Y-m-d H:i:00'); 
                    $shift_timing['machine'] = $machine;
                    $shift_timing['user_id'] = get_user_id($username);
                    $shift_timing['order_id'] = $job_details_spcs['id'];
                    $update_setup_timing =$this->mobile->insert_setup_time($shift_timing);
                    
//insert update status for spcs report
                    $mcdown_updates['job_id'] = $job_details_spcs['id'];
                    $mcdown_updates['updated_for'] = 3; 
                    $mcdown_updates['updated_to'] = 'Setup Started - '.$machine_name;
                    $mcdown_updates['updated_by'] =   $username; 
                    $mcdown_updates['updated_status'] = 1;
                    $mcdown_updates['updated_remark'] = '';
                    mcdown_updates($mcdown_updates);

                    $this->mobile->update_upcomingjobs_time($job_details_spcs['date_from'],$job_details_spcs['shift'],$job_details_spcs['machine'],$job_details_spcs['time_from'],$data['time_to'],$job_details_spcs['id']);
// Update Tooling Complete Status
                    $status_update['tjob_id'] = $job_details_boots['tjob_id'];
                    $status_update['update_date'] = date('Y-m-d');
                    $status_update['update_time'] = date('Y-m-d H:i:00');
                    $status_update['update_for']    = 3 ;
                    $status_update['update_status'] = 1 ;
                    $status_update['update_to'] = 'SETUP- Started By '.$username;
                    $status_update['update_by'] = MOBILE_APP_USER_ID;
                    $job_status_update = $this->mobile->update_job_status_boots($status_update);
                    if($job_status){
                        echo json_encode(array('result' =>'success','message'=>'Setup Status Updated Successfully','mcdown_id'=>$job_status));
                    }else{
                        echo json_encode(array('result' =>'failure','message'=>'Setup Status Update Failed'));
                    }
                }else{
                    echo json_encode(array('result' =>'failure','message'=>'Machine down on this time'));
                }
            }else{
                 echo json_encode(array('result' =>'failure','message'=>'Setup Not Started'));
            }
        }else{
            if($this->input->get('status') == 1){
                if($job_details_spcs['setup']==0){
                    $check_availability['date'] = $job_details_spcs['date_from']; 
                    $check_availability['machine'] = $machine;
                    $check_availability['shift'] = $job_details_spcs['shift'];
                    $check_availability['time_from'] = date('H:i:s');
                    $check_availability['time_to'] = $job_details_spcs['time_to'];
                    $job_on_time = $this->mobile->check_job_availability($check_availability);
                    
                    if($job_on_time['mcdown']==0){
                        $data['date_from']=date('Y-m-d');
                        $data['time_from']=date('H:i:00');
                        $datetime1 = new DateTime($job_details_spcs['date_from'].' '.$job_details_spcs['time_from']);
                        $datetime2 = new DateTime($job_details_spcs['date_to'].' '.$job_details_spcs['time_to']);
                        $interval = $datetime1->diff($datetime2);
                        $diffhour = $interval->format('%h');
                        $diffmin = $interval->format('%i');
                        $EndTime = new DateTime($data['time_from']);
                        $EndTime->modify('+'.$diffhour.' hours');
                        $EndTime->modify('+'.$diffmin.' minutes');
                        $data['date_to']=date('Y-m-d');
                        $data['time_to']= $EndTime->format('H:i:00');
                        $data['machine']=$this->mobile->get_machine_id($this->input->get('machine_name'));
                        $data['setup']=1;
                        $data['setup_start'] = date('Y-m-d H:i:00');
                        $job_status=$this->mobile->update_jobstatus($data,$job_details_spcs['id']);
                        
                        // insert setup time into setup timings
                        $shift_timing['setup_start'] = date('Y-m-d H:i:00'); 
                        $shift_timing['machine'] = $machine;
                        $shift_timing['user_id'] = get_user_id($username);
                        $shift_timing['order_id'] = $job_details_spcs['id'];
                        $update_setup_timing =$this->mobile->insert_setup_time($shift_timing);
                        
//insert update status for spcs report
                        $mcdown_updates['job_id'] = $job_details_spcs['id'];
                        $mcdown_updates['updated_for'] = 3; 
                        $mcdown_updates['updated_to'] = 'Setup Started - '.$machine_name;
                        $mcdown_updates['updated_by'] =   $username; 
                        $mcdown_updates['updated_status'] = 1;
                        $mcdown_updates['updated_remark'] = '';
                        mcdown_updates($mcdown_updates);

                        $this->mobile->update_upcomingjobs_time($job_details_spcs['date_from'],$job_details_spcs['shift'],$job_details_spcs['machine'],$job_details_spcs['time_from'],$data['time_to'],$job_details_spcs['id']);
// Update Tooling Complete Status
                        $status_update['tjob_id'] = $job_details_boots['tjob_id'];
                        $status_update['update_date'] = date('Y-m-d');
                        $status_update['update_time'] = date('Y-m-d H:i:00');
                        $status_update['update_for']    = 3 ;
                        $status_update['update_status'] = 1 ;
                        $status_update['update_to'] = 'SETUP- Started By '.$username;
                        $status_update['update_by'] = MOBILE_APP_USER_ID;
                        $job_status_update = $this->mobile->update_job_status_boots($status_update);
                        if($job_status){
                            echo json_encode(array('result' =>'success','message'=>'Setup Status Updated Successfully','mcdown_id'=>$job_status));
                        }else{
                            echo json_encode(array('result' =>'failure','message'=>'Setup Status Update Failed'));
                        }
                    }else{
                        echo json_encode(array('result' =>'failure','message'=>'Machine down on this time'));
                    }
                }else{ 
                        //setup state 
                        $shift_timing['machine'] = $machine;
                        $shift_timing['user_id'] = get_user_id($username);
                        $shift_timing['order_id'] = $job_details_spcs['id'];
    
			$get_setup_state = $this->mobile->get_setup_state($shift_timing);
			//echo "<pre>";print_r($get_setup_state);exit;
			
			if(($get_setup_state['state']==2)||($get_setup_state['state']==4)||($get_setup_state['state']==6)){
				if($get_setup_state['state']==2){
                        		$shift_timing['resetup1_start'] = date('Y-m-d H:i:00');
                        	}elseif(($get_setup_state['state']==4)&&($get_setup_state['state']==6)){
                        		$shift_timing['resetup2_start'] = date('Y-m-d H:i:00');
                        	} 
				$shift_timing['machine'] = $machine;
				$shift_timing['user_id'] = get_user_id($username);
				$shift_timing['order_id'] = $job_details_spcs['id'];
				$update_setup_timing =$this->mobile->update_setup_time($shift_timing);
				if($update_setup_timing){
					echo json_encode(array('result' =>'success','message'=>'ReSetup Status Updated Successfully','mcdown_id'=>$job_details_spcs['id']));
				}
                        
			}else{
				if($get_setup_state['state']==5){
                         		echo json_encode(array('result' =>'failure','message'=>'this order Second Resetup already started'));
				}elseif($get_setup_state['state']==3){
					echo json_encode(array('result' =>'failure','message'=>'this order Resetup already started'));
				}else{
					echo json_encode(array('result' =>'failure','message'=>'this order Setup already started'));
				}
                         
			}
                }
            }elseif($this->input->get('status') == 2){
                if($job_details_spcs['setup']==1){
                    $datetime1 = new DateTime($job_details_spcs['setup_start']);
                    $datetime2 = new DateTime(date('Y-m-d H:i:00'));
                    $interval = $datetime1->diff($datetime2);

                    $data['setup']=2;
                    $data['setup_end'] = date('Y-m-d H:i:00');
                    $job_status=$this->mobile->update_jobstatus($data,$job_details_spcs['id']);
                    //update setup time in setup_timings
                    
			$shift_timing['setup_end'] = date('Y-m-d H:i:00');
			$shift_timing['machine'] = $machine;
			$shift_timing['user_id'] = get_user_id($username);
			$shift_timing['order_id'] = $job_details_spcs['id'];
			$update_setup_timing =$this->mobile->update_setup_time($shift_timing);
			
// insert update status for spcs report
		$mcdown_updates['job_id'] = $job_details_spcs['id'];
		$mcdown_updates['updated_for'] = 4; 
		$mcdown_updates['updated_to'] = 'Setup Finished- '.$machine_name;
		$mcdown_updates['updated_by'] =   $username; 
		$mcdown_updates['updated_status'] = 1;
		$mcdown_updates['updated_remark'] = '';
		mcdown_updates($mcdown_updates);
                        
// update setup time in boots

		$datetime1 = new DateTime($job_details_spcs['setup_start']);
		$datetime2 = new DateTime(date('Y-m-d H:i:00'));
		$interval = $datetime1->diff($datetime2);
		$update['setup_time_hr']  = $interval->format('%h');
		$update['setup_time_min'] = $interval->format('%i');

		$job_update = $this->mobile->update_job_details_boots($update,$job_details_spcs['job_code']);

// Update Tooling Complete Status
                    $status_update['tjob_id'] = $job_details_boots['tjob_id'];
                    $status_update['update_date'] = date('Y-m-d');
                    $status_update['update_time'] = date('Y-m-d H:i:00');
                    $status_update['update_for']    = 3 ;
                    $status_update['update_status'] = 1 ;
                    $status_update['update_to'] = 'SETUP - Ended By '.$username;
                    $status_update['update_by'] = MOBILE_APP_USER_ID;
                    $job_status_update = $this->mobile->update_job_status_boots($status_update);
// SetupTime Update Status
                    $status_update['tjob_id'] = $job_details_boots['tjob_id'];
                    $status_update['update_date'] = date('Y-m-d');
                    $status_update['update_time'] = date('Y-m-d H:i:00');
                    $status_update['update_for']    = 3 ;
                    $status_update['update_status'] = 1 ;
                    $status_update['update_to'] = 'Setup time Updated - '.$interval->format('%h').':'.$interval->format('%i');
                    $status_update['update_by'] = MOBILE_APP_USER_ID;
                    $job_status_update = $this->mobile->update_job_status_boots($status_update);
                    if($job_status){
                        echo json_encode(array('result' =>'success','message'=>'Setup Status Updated Successfully','mcdown_id'=>$job_status));
                    }else{
                        echo json_encode(array('result' =>'failure','message'=>'Setup Status Update Failed'));
                    }
                }else{
                    //setup state 
                        $shift_timing['machine'] = $machine;
                        $shift_timing['user_id'] = get_user_id($username);
                        $shift_timing['order_id'] = $job_details_spcs['id'];
    
			$get_setup_state = $this->mobile->get_setup_state($shift_timing);
			//echo "<pre>";print_r($get_setup_state);exit;
			
			if(($get_setup_state['state']==1)||($get_setup_state['state']==3)||($get_setup_state['state']==5)){
				if($get_setup_state['state']==3){
                        		$shift_timing['resetup1_end'] = date('Y-m-d H:i:00');
                        		$current_setup = 'resetup1';
                        	}elseif(($get_setup_state['state']==5)){
                        		$shift_timing['resetup2_end'] = date('Y-m-d H:i:00');
                        		$current_setup = 'resetup2';
                        	} 
				$shift_timing['machine'] = $machine;
				$shift_timing['user_id'] = get_user_id($username);
				$shift_timing['order_id'] = $job_details_spcs['id'];
				$update_setup_timing = $this->mobile->update_setup_time($shift_timing);
				
				// setup time update for resetup
				
				$resetup_time = $this->mobile->get_setup_time($job_details_spcs['id'],$current_setup );
				
				
				$status_update['tjob_id'] = $job_details_boots['tjob_id'];
				$status_update['update_date'] = date('Y-m-d');
				$status_update['update_time'] = date('Y-m-d H:i:00');
				$status_update['update_for']    = 3 ;
				$status_update['update_status'] = 1 ;
				$status_update['update_to'] = 'Resetup time Updated - '.$resetup_time['hour'].':'.$resetup_time['min'];
				$status_update['update_by'] = MOBILE_APP_USER_ID;
				$job_status_update = $this->mobile->update_job_status_boots($status_update);
				
				// setup time update for total setup and resetup
				
				$setup_totaltime = $this->mobile->get_totalsetup_time($job_details_spcs['id']);
				
				$update['setup_time_hr']  = $setup_totaltime['hour'];
				$update['setup_time_min'] = $setup_totaltime['min'];
				
				$job_update = $this->mobile->update_job_details_boots($update,$job_details_spcs['job_code']);
				
				if($update_setup_timing){
					echo json_encode(array('result' =>'success','message'=>'ReSetup Status Updated Successfully','mcdown_id'=>$job_details_spcs['id']));
				}
                        
			}else{
				if($get_setup_state['state']==6){
                         		echo json_encode(array('result' =>'failure','message'=>'this order Second Resetup already Finished'));
				}elseif($get_setup_state['state']==4){
					echo json_encode(array('result' =>'failure','message'=>'this order Resetup already Finished'));
				}else{
					echo json_encode(array('result' =>'failure','message'=>'this order Setup already Finished'));
				} 
			}
                }
            }
        }
    }else{
        echo json_encode(array('result' =>'failure','message'=>'Job not found in beamon shop.'));
    } 
}
/** **/
public function setup(){
	$set_pop = 0;
    $machine = $this->mobile->get_machine_id($this->input->get('machine_name'));
	$machine_status = $this->running_job_same_machine($machine,$this->input->get('job_code'));
    $wims_hold_jobs = 0;
	$wims_hold_jobs = $this->wims_hold_jobs($this->input->get('job_code'));
	if($wims_hold_jobs==1){
	    echo  json_encode(array('result' =>'failure','message' => 'job is HOLD in wims so UNHOLD the job after that you can continue..'));
		exit;
	}
	
/*	$check_hold_mcdown_id = $this->check_hold_status_mcdown($this->input->get('job_code'),$machine);
	if($check_hold_mcdown_id!=0){
	   
	    echo json_encode(array('result' =>'success','message'=>'ReSetup1111 Status Updated Successfully','popup'=>1));
	    exit;
	}
	if(isset($_GET['popup'])){
	    if($this->input->get('popup')==1){
    	    $this->unhold('setup',$check_hold_mcdown_id,$this->input->get('machine_name'),$this->input->get('job_code'));
    	    exit;
	    }
	}*/
	
	if($machine_status=="setup"){
		echo  json_encode(array('result' =>'failure','message' => 'job is setup on this machine please continue or hold the job after that you can start new job'));
		exit;
	}elseif($machine_status=="mc_down"){
		echo  json_encode(array('result' =>'failure','message' => 'machine is down please give machine ready after that you can start new job'));
		exit;
	}elseif($machine_status=="other_down"){
		echo  json_encode(array('result' =>'failure','message' => 'machine is other down please give machine ready after that you can start new job'));
		exit;
	}elseif($machine_status=="not_complete"){
		echo  json_encode(array('result' =>'failure','message' => 'job is running on this machine please continue or hold the job after that you can start new job'));
		exit;
	}
	
	$setup_unique_job = 0;
	if($this->input->get('setupstatus')=='ss' && $this->input->get('side')==1){
	    
	    $setup_unique_job = 1;
	    $current_shift_end = $this->getSameJobCode($this->input->get('job_code'));
	}
	
    /************* SHIFT END ****************
	$job_count = '';
    
    if(is_array ($current_shift_end)){
        
        $job_count = 1;
    }else{
        
         $job_count = 0;
    }

    if($job_count > 0){
		$shift_end_time = $this->mobile->getShiftEnd1($current_shift_end->date_from);
		$data = array('time_to'=>$shift_end_time);
		$this->db->where('id',$current_shift_end->id);
		$this->db->update('tbl_mcdown',$data);        
    }
    /************* SHIFT END *****************/
  
    $username = $this->input->get('username');
    $machine_name = $this->input->get('machine_name');

    $mc_status = $this->input->get('setupstatus');
    $get_split_jobcode = explode("[",$this->input->get('job_code'));
    $job_details_boots = $this->mobile->get_job_details_boots($get_split_jobcode[0]);    
    $job_details_spcs = $this->mobile->get_job_details($this->input->get('job_code'));
    // for spit jobs load existing job details to it.
    $new_job_details = $this->mobile->load_existing_details($this->input->get('job_code'));
    
    if($new_job_details){
    	$job_details_spcs = $this->mobile->get_job_details_id($new_job_details);
    }
    
    $job_code = $this->input->get('job_code');
    $setup_side = $this->input->get('side');
    $setup_status['setup_status'] = 1;
    $last_setup = 0;
    $this->mobile->update_job_details_setup_status($setup_status,$job_code);
    //$last_setup = $this->get_last_setupid($job_code,$machine);
    $setup_side_status = $this->mobile->get_setup_side_status($job_details_spcs['id'],$setup_side,$machine,$this->input->get('status'));
    if($job_details_spcs){
        
        if( ( $job_details_spcs['setup'] > 0 ) && ( $job_details_spcs['machine'] != $machine ) ){
		//echo "<pre>";print_r('not same machine');exit;
            if( $this->input->get('status') == 1 ){ 
            	//insert setup time for new machine or if already exist then update with new time
            	$check_availability['date'] = $job_details_spcs['date_from'];
                $check_availability['machine'] = $machine;
                $check_availability['shift'] = $job_details_spcs['shift'];
                $check_availability['time_from'] = date('H:i:s');
                $check_availability['time_to'] = $job_details_spcs['time_to'];
                $job_on_time = $this->mobile->check_job_availability($check_availability);
                if($job_on_time['mcdown']==0){
                    	
                $data['date_from']=date('Y-m-d');
    			if($setup_side==1){
    			    $data['setup_start'] = date('Y-m-d H:i:00');
    			    $data['time_from']=date('H:i:00');
    			}else{
    			    $data['time_from']=$job_details_spcs['time_from'];
    			}				
    			$datetime1 = new DateTime($job_details_spcs['date_from'].' '.$job_details_spcs['time_from']);
    			$datetime2 = new DateTime($job_details_spcs['date_to'].' '.$job_details_spcs['time_to']);
    			$interval = $datetime1->diff($datetime2);
    			$diffhour = $interval->format('%h');
    			$diffmin = $interval->format('%i');
    			$EndTime = new DateTime($data['time_from']);
    			$EndTime->modify('+'.$diffhour.' hours');
    			$EndTime->modify('+'.$diffmin.' minutes');
    			$data['date_to']=date('Y-m-d');
    			$data['time_to']= $EndTime->format('H:i:00');
    			$data['machine']=$this->mobile->get_machine_id($this->input->get('machine_name'));
    			$data['setup']=1;
    			$data['job_complete_status']=1;
    			$data['setup_status']=1;
    			
    			$job_status=$this->mobile->update_jobstatus($data,$job_details_spcs['id']);
			
			// insert update status for spcs report
    			$mcdown_updates['job_id']	  = $job_details_spcs['id'];
    			$mcdown_updates['updated_for']	  = 3; 
    			$mcdown_updates['updated_to']	  = 'Setup start - '.$setup_side.'/'.$job_details_spcs['side'].' in '.$machine_name;
    			$mcdown_updates['updated_by']	  =   $username; 
    			$mcdown_updates['updated_status'] = 1;
    			$mcdown_updates['updated_remark'] = '';
    			$mcdown_updates['mechine_status'] = 's1';
			
			    mcdown_updates($mcdown_updates);
			
                // Update Tooling Complete Status
                $status_update['tjob_id'] = $job_details_boots['tjob_id'];
                $status_update['update_date'] = date('Y-m-d');
                $status_update['update_time'] = date('Y-m-d H:i:s');
                $status_update['update_for']    = 3 ;
                $status_update['update_status'] = 1 ;
                $status_update['update_to'] = 'SETUP Side-'.$setup_side.' - Started By '.$username;
                $status_update['update_by'] = get_user_id($username); //MOBILE_APP_USER_ID;
                $status_update['update_from'] = 'mobile';
                $job_status_update = $this->mobile->update_job_status_boots($status_update);
            
			    $update['job_color_status'] = 3;
			    $job_update = $this->mobile->update_job_details_boots($update,$job_details_spcs['job_code']);            
                	 //  insert timing 
            	 $setup_start['order_id']	= $job_details_spcs['id'];
            	 $setup_start['side']		= $setup_side;
            	 $setup_start['machine']	= $machine;
            	 $setup_start['user_id']	= get_user_id($username);
            	 $setup_start['setup_start']	= $status_update['update_time'];
		         $setup_start['setup_end']	= '0000-00-00 00:00:00';
		         
            	 $update_setup_timing = $this->mobile->insert_setup_time($setup_start);
            	 
            /************* setup start after  08:00:00 *************************/
            /*$current_date_with_time = new DateTime(date('Y-m-d H:i:s'));
            $current_date = new DateTime(date('Y-m-d'));
            if(new DateTime($current_date_with_time->format('Y-m-d').' '.DEFAULT_SHIFT1_END_TIME) > '20:00:00' ){
                if(new DateTime($current_date_with_time->format('Y-m-d').' '.$current_date_with_time->format('H:i:s')) <= '23:59:00' ){
                    define('DEFAULT_SHIFT_AFTER_EIGHT_END_TIME','23:59:00');
                    $shift_arr = $this->mobile->get_shift($current_date);
                    $shift_update_arr['shift1_to'] = '23:59:00';
                    $this->mobile->update_shift($shift_update_arr['shift1_to'],$shift_arr);
                }else{
                    echo json_encode(array('result' =>'failure','message'=>'Job time more than shift time, please assign to another shift or day'));
                }
            } */
            /*******************************************************************/    
            	 if($update_setup_timing){
            	     if($setup_unique_job==1){
            	        $this->same_job_remove_when_setup($this->input->get('job_code'));
            	     }
            	     //$this->cron_run();
            	 	echo json_encode(array('result' =>'success','message'=>'Setup start updated successfully'));
            	 }else{
            	 	echo json_encode(array('result' =>'failure','message'=>'Setup start update failed'));
            	 }
		}else{
			echo json_encode(array('result' =>'failure','message'=>'Machine down on this time'));
		}
            }else{
                 echo json_encode(array('result' =>'failure','message'=>'Setup Not Started'));
            }
        }else{
        //echo "<pre>";print_r('same machine');exit;
            if( $this->input->get('status') == 1 ){
            	// get setup status of jobcode based on setupside 
            	//echo "<pre>";print_r($setup_side_status['status']);exit;
                if( $setup_side_status['status'] == 0 ){
                	$check_availability['date'] = $job_details_spcs['date_from'];
	                $check_availability['machine'] = $machine;
	                $check_availability['shift'] = $job_details_spcs['shift'];
	                $check_availability['time_from'] = date('H:i:s');
	                $check_availability['time_to'] = $job_details_spcs['time_to'];
	                $job_on_time = $this->mobile->check_job_availability($check_availability);
	                //echo "<pre>";print_r($job_on_time);exit;
	                if($job_on_time['mcdown']==0){
	                
				$data['date_from']=date('Y-m-d');
    			if($setup_side==1){
    			    $data['setup_start'] = date('Y-m-d H:i:00');
    			    $data['time_from']=date('H:i:00');
    			}else{
    			    $data['time_from']=$job_details_spcs['time_from'];
    			} 				
				
				$datetime1 = new DateTime($job_details_spcs['date_from'].' '.$job_details_spcs['time_from']);
				$datetime2 = new DateTime($job_details_spcs['date_to'].' '.$job_details_spcs['time_to']);
				$interval = $datetime1->diff($datetime2);
				$diffhour = $interval->format('%h');
				$diffmin = $interval->format('%i');
				$EndTime = new DateTime($data['time_from']);
				$EndTime->modify('+'.$diffhour.' hours');
				$EndTime->modify('+'.$diffmin.' minutes');
				$data['time_to']= $EndTime->format('H:i:00');
				$data['date_to']=date('Y-m-d');
				$data['machine']=$this->mobile->get_machine_id($this->input->get('machine_name'));
				$data['setup']=1;
				$data['job_complete_status']=1;
				$data['setup_status']=1;
				$job_status=$this->mobile->update_jobstatus($data,$job_details_spcs['id']);
				
				// insert update status for spcs report
				$mcdown_updates['job_id']	  = $job_details_spcs['id'];
				$mcdown_updates['updated_for']	  = 3; 
				$mcdown_updates['updated_to']	  = 'Setup start - '.$setup_side.'/'.$job_details_spcs['side'].' in '.$machine_name;
				$mcdown_updates['updated_by']	  =   $username; 
				$mcdown_updates['updated_status'] = 1;
				$mcdown_updates['updated_remark'] = '';
				$mcdown_updates['setup_side'] = $setup_side;
				$mcdown_updates['mechine_status'] = 's1';
				$mcdown_updates['mc_status'] = $mc_status;
    			$mcdown_updates['tot_side'] = $job_details_spcs['side'];				
				mcdown_updates($mcdown_updates);
				
				
            // Update Tooling Complete Status
            $status_update['tjob_id'] = $job_details_boots['tjob_id'];
            $status_update['update_date'] = date('Y-m-d');
            $status_update['update_time'] = date('Y-m-d H:i:s');
            $status_update['update_for']    = 3 ;
            $status_update['update_status'] = 1 ;
            $status_update['update_to'] = 'SETUP Side -'.$setup_side.'- Started '.$username;
             $status_update['update_from'] = 'mobile';
            $status_update['update_by'] = get_user_id($username); //MOBILE_APP_USER_ID;
            $job_status_update = $this->mobile->update_job_status_boots($status_update);

            
			$update['job_color_status'] = 3;
			$job_update = $this->mobile->update_job_details_boots($update,$job_details_spcs['job_code']);            
            
	                	 //  insert timing 
        	 $setup_start['order_id']	= $job_details_spcs['id'];
        	 $setup_start['side']		= $setup_side;
        	 $setup_start['machine']	= $machine;
        	 $setup_start['user_id']	= get_user_id($username);
        	 $setup_start['setup_start']	= $status_update['update_time'];
	         $setup_start['setup_end']	= '0000-00-00 00:00:00';
	         
        	 $update_setup_timing = $this->mobile->insert_setup_time($setup_start);
        	 if($update_setup_timing){
        	         if($setup_unique_job==1){
            	        $this->same_job_remove_when_setup($this->input->get('job_code'));
            	     }
        	     //$this->cron_run();
        	 	echo json_encode(array('result' =>'success','message'=>'Setup start updated successfully'));
        	 }else{
        	 	echo json_encode(array('result' =>'failure','message'=>'Setup start update failed'));
        	 }
			}else{
				echo json_encode(array('result' =>'failure','message'=>'Machine down on this time'));
			}
                }else{
                	// already started
                	$this->cron_run();
                	echo json_encode(array('result' =>'failure','message'=>'Setup Already Started'));
                }
            }elseif( $this->input->get('status') == 2 ){
            	// get setup status of jobcode based on setupside 
            if( ( $this->input->get('status') == 2 ) && ( $setup_side_status['finish'] != 1 ) ){
                	//  update timing

            $shift_update['setup_end']	= date('Y-m-d H:i:s');
			$shift_update['machine']	= $machine;
			$shift_update['user_id']	= get_user_id($username);
			$shift_update['side']		= $setup_side;
			$shift_update['order_id']	= $job_details_spcs['id'];
			//echo "<pre>";print_r($shift_update);exit;
			$explode_down = explode("[",$job_details_spcs['job_code']);
		
            $shift_update['job_code']   = $explode_down[0];			
			$update_setup_timing = $this->mobile->update_setup_time($shift_update);
                	if($job_details_spcs['side'] == $setup_side ){
				// setup time update for total setup and resetup
				
				$setup_totaltime = $this->mobile->get_totalsetup_time($job_details_spcs['id'],$machine,$job_details_spcs['side']);
				$update['setup_time_hr']  = $setup_totaltime['hour'];
				$update['setup_time_min'] = $setup_totaltime['min'];
                $update['job_color_status'] = 3;
				$job_update = $this->mobile->update_job_details_boots($update,$job_details_spcs['job_code']); 
				
				// SetupTime Update Status
				$status_update['tjob_id']	= $job_details_boots['tjob_id'];
				$status_update['update_date']	= date('Y-m-d');
				$status_update['update_time']	= $shift_update['setup_end'];
				$status_update['update_for']    = 3 ;
				$status_update['update_status'] = 2 ;
				$status_update['update_to']	= 'Setup Side- '.$setup_side. ' Finished time Updated - '.$update['setup_time_hr'].':'.$update['setup_time_min'];
				 $status_update['update_from'] = 'mobile';
				$status_update['update_by']	= get_user_id($username); //MOBILE_APP_USER_ID;
			
				$job_status_update = $this->mobile->update_job_status_boots($status_update);
                }else{
				$setup_totaltime = $this->mobile->get_totalsetup_time($job_details_spcs['id'],$machine,$job_details_spcs['side']);
				$update['setup_time_hr']  = $setup_totaltime['hour'];
				$update['setup_time_min'] = $setup_totaltime['min'];                    
 				// SetupTime Update Status
				$status_update['tjob_id']	= $job_details_boots['tjob_id'];
				$status_update['update_date']	= date('Y-m-d');
				$status_update['update_time']	= $shift_update['setup_end'];
				$status_update['update_for']    = 3 ;
				$status_update['update_status'] = 2 ;
				$status_update['update_to']	= 'Setup Side - '.$setup_side.'- Finished time Updated - '.$update['setup_time_hr'].':'.$update['setup_time_min'];
				 $status_update['update_from'] = 'mobile';
				$status_update['update_by']	= get_user_id($username); //MOBILE_APP_USER_ID;
			
				$job_status_update = $this->mobile->update_job_status_boots($status_update);                   
                    
                }
                	// insert update status for spcs report
    			$mcdown_updates['job_id']	  = $job_details_spcs['id'];
    			$mcdown_updates['updated_for']	  = 4; 
    			$mcdown_updates['updated_to']	  = 'Setup Finished - '.$setup_side.'/'.$job_details_spcs['side'].' in '.$machine_name;
    			$mcdown_updates['updated_by']	  =   $username; 
    			$mcdown_updates['updated_status'] = 1;
    			$mcdown_updates['updated_remark'] = '';
    			$mcdown_updates['setup_side'] = $setup_side;
    			$mcdown_updates['mechine_status'] = 's2';
    			$mcdown_updates['mc_status'] = $mc_status;
    			$mcdown_updates['tot_side'] = $job_details_spcs['side'];
    			mcdown_updates($mcdown_updates);
                	// update setup time in boots
            	$data['setup']=2;
            	$data['job_complete_status']=1;
            	$data['setup_status']=1;
            	
            	$this->autoprevjob_setup_finish($this->input->get('job_code'));
            	
    			$data['setup_end'] = $shift_update['setup_end'];
    			$job_status=$this->mobile->update_jobstatus($data,$job_details_spcs['id']);
			
                	if($update_setup_timing ){
                	    
                  		$setup_totaltime = $this->mobile->get_totalsetup_time($job_details_spcs['id'],$machine,$job_details_spcs['side']);
                		$update['setup_time_hr']  = $setup_totaltime['hour'];
                		$update['setup_time_min'] = $setup_totaltime['min'];
                		$update['job_color_status'] = 3;
                		$update['job_setup_color_status'] = 1 ;
                		$job_update = $this->mobile->update_job_details_boots($update,$job_details_spcs['job_code']);
                		//$this->cron_run();
                	 	echo json_encode(array('result' =>'success','message'=>'Setup Finish updated successfully'));
                	}else{
                	 	echo json_encode(array('result' =>'failure','message'=>'Setup Finish update failed'));
                	}
                }else{
                	// already finished
                	echo json_encode(array('result' =>'failure','message'=>'Setup Already Finished'));
                }
            }
        }
    }else{
        echo json_encode(array('result' =>'failure','message'=>'Job not found in beamon shop.'));
    }
}
    public function job_share(){
        
        $machine_name = $this->input->get('machine_name');
        $user_name = $this->input->get('username');
        $job_code = $this->input->get('job_code');
        $machine=$this->mobile->get_machine_id($machine_name);
        $job_details_spcs = $this->mobile->get_job_details($job_code);
        $priority = $job_details_spcs['priority'];
    	
    	if($job_details_spcs['job_complete_status']!=0){
    		echo json_encode(array('result' =>'failure','message'=>'you can share Loaded only'));
    		exit;
    	}
    	$new_job = $job_details_spcs;
    	$datetime1 = new DateTime($job_details_spcs['date_from'].' '.$job_details_spcs['time_from']);
    	$datetime2 = new DateTime($job_details_spcs['date_to'].' '.$job_details_spcs['time_to']);
    	$interval = $datetime1->diff($datetime2);

    	$totmin= $this->minutes($interval->format('%h').':'.$interval->format('%h').':00')/2;

    	$hours = floor($totmin / 60).':'.($totmin -   floor($totmin / 60) * 60);
    	
    	$explode_down = explode(":",$hours);

    	if($explode_down[0]){
    		$divide_hrs_time = $explode_down[0];
    	}else{
    	    $divide_hrs_time = '00';
    	}
    	
    	if($explode_down[1]){
    		$divide_min_time = $explode_down[1];
    		$explode_dot = explode(".",$divide_min_time);
    		$divide_min_time = $explode_dot[0];
    	}else{
    	    $divide_min_time = '00';
    	}    	
    	/************************** UPDATE PREVIOUS JOB **************************/

    	$EndTime = new DateTime($job_details_spcs['date_from'].' '.$job_details_spcs['time_from']);
    	$EndTime->modify('+'.$divide_hrs_time.' hours');
    	$EndTime->modify('+'.$divide_min_time.' minutes');
    	$data['time_to']= $EndTime->format('H:i:00');
    	$data['share_status']   = 1;
    	$data['side']   = 1;
    	$data['qty']   = 1;
    	
    	$this->db->where('id',$job_details_spcs['id']);
    	$this->db->update('tbl_mcdown',$data);
    	
    	$new_job['time_from'] = $this->cron_model->get_last_job_time($job_details_spcs['date_from'],$machine,$job_details_spcs['shift']);
    
    	$EndTime = new DateTime($job_details_spcs['date_from'].' '.$new_job['time_from']);
    	$EndTime->modify('+'.$divide_hrs_time.' hours');
    	$EndTime->modify('+30 minutes');
    	$new_job['time_to'] = $EndTime->format('H:i:00');
    	$new_job['machine'] = $machine;
    	$explode_down = explode("[",$job_details_spcs['job_code']);
    	$share_job = $this->share_job($explode_down[0]);
    	if(is_array($share_job)){
    	    $explode_down = explode("[",$share_job['job_code']);
    	}else{
    	    $explode_down = explode("[",$job_details_spcs['job_code']);
    	}

    	if($explode_down[0]){
    		$start_first = $explode_down[0];
    	}
    	/********* UPDATE **********/
    	$data['job_share_code']   = $explode_down[0];
    	$this->db->where('id',$job_details_spcs['id']);
    	$this->db->update('tbl_mcdown',$data);
    		/********* UPDATE **********/
    	
    	if(isset($explode_down[1])){
    	    $remove_special_char = str_replace(' ', ']', $explode_down[1]);
    		$incr = $remove_special_char;
    		$job_code = $start_first.'['.($incr+1).']';
    	}else{
    		$job_code = $start_first.'[1]';
    	}
    	$new_job['job_code']        = $job_code;
    	$new_job['job_share_code']  = $start_first;
    	$new_job['share_status']    = 1;
    	$new_job['side']            = 1;
    	$new_job['qty']             = 1;
    	$new_job['priority']        = $priority;
        unset($new_job['id']);
    	$insert_status = $this->db->insert(TBL_MCDOWN,$new_job);
    	
    	if($insert_status){
    	    $this->cron_run();
    	    $result = array('result' =>'success' , 'message' => 'job share successfully updated','job_code'=>$job_code);
    	}else{
    	    $result = array('result' =>'failure' , 'message' => 'job sharing failed' );
    	}
    	echo json_encode($result);
    	/************************** UPDATE PREVIOUS JOB **************************/
    }
    
    public function share_job($job_share_code){
        
     	$this->db->where('job_share_code',$job_share_code);
        $this->db->order_by('id','desc');
        $query = $this->db->get('tbl_mcdown');
    	if($query->num_rows() > 0){
    		$result = $query->row_array();
    		return $result;
    	}else{
    		return 0;
    	}        
    }  
    public function minutes($time){
        
        $time = explode(':', $time);
        return ($time[0]*60) + ($time[1]) + ($time[2]/60);
        
    }    
/*
public function setup(){
  $username = $this->input->get('username');
  $allow    = $this->input->get('allow');
  $machine  = $this->mobile->get_machine_id($this->input->get('machine_name'));
  $job_details_boots = $this->mobile->get_job_details_boots($this->input->get('job_code'));
  $job_details_spcs = $this->mobile->get_job_details($this->input->get('job_code'));
  if( $job_details_spcs){
    if(($job_details_spcs['machine'] != $machine)&&($allow!=1)){
      echo json_encode(
        array(
          'result' =>'warning',
          'message'=>'Wrong Machine Selected',
          'username'=>$username,
          'machine_name'=>$this->input->get('machine_name'),
          'job_code'=>$this->input->get('job_code'),
          'status'=>$this->input->get('status')
        )
      );
    }else{
      if($this->input->get('status') == 1){
        if($job_details_spcs['setup']==0){
          $check_availability['date'] = $job_details_spcs['date_from'];
          $check_availability['machine'] = $job_details_spcs['machine'];
          $check_availability['shift'] = $job_details_spcs['shift'];
          $check_availability['time_from'] = date('H:i:s');
          $check_availability['time_to'] = $job_details_spcs['time_to'];
          $job_on_time = $this->mobile->check_job_availability($check_availability);
// print_r($job_on_time);exit;
          if($job_on_time['mcdown']==0){
            $data['date_from']=date('Y-m-d');
            $data['time_from']=date('H:i:00');
            $datetime1 = new DateTime($job_details_spcs['date_from'].' '.$job_details_spcs['time_from']);
            $datetime2 = new DateTime($job_details_spcs['date_to'].' '.$job_details_spcs['time_to']);
            $interval = $datetime1->diff($datetime2);
            $diffhour = $interval->format('%h');
            $diffmin = $interval->format('%i');
            $EndTime = new DateTime($data['time_from']);
            $EndTime->modify('+'.$diffhour.' hours');
            $EndTime->modify('+'.$diffmin.' minutes');
            $data['date_to']=date('Y-m-d');
            $data['time_to']= $EndTime->format('H:i:00');
//$data['machine']=$this->mobile->get_machine_id($this->input->get('machine_name'));
            $data['setup']=1;
            $data['setup_start'] = date('Y-m-d H:i:00');
//print_r($data);exit;
            $job_status=$this->mobile->update_jobstatus($data,$job_details_spcs['id']);
            $this->mobile->update_upcomingjobs_time($job_details_spcs['date_from'],$job_details_spcs['shift'],$job_details_spcs['machine'],$job_details_spcs['time_from'],$data['time_to'],$job_details_spcs['id']);
// Update Tooling Complete Status
            $status_update['tjob_id'] = $job_details_boots['tjob_id'];
            $status_update['update_date'] = date('Y-m-d');
            $status_update['update_time'] = date('Y-m-d H:i:00');
            $status_update['update_for']    = 3 ;
            $status_update['update_status'] = 1 ;
            $status_update['update_to'] = 'SETUP- Started By '.$username;
            $status_update['update_by'] = MOBILE_APP_USER_ID;
            $job_status_update = $this->mobile->update_job_status_boots($status_update);
            if($job_status){
              echo json_encode(array('result' =>'success','message'=>'Setup Status Updated Successfully','mcdown_id'=>$job_status));
            }else{
              echo json_encode(array('result' =>'failure','message'=>'Setup Status Update Failed'));
            }
          }else{
            echo json_encode(array('result' =>'failure','message'=>'Machine down on this time'));
          }
        }else{
          if($job_details_spcs['setup']==2){
            echo json_encode(array('result' =>'failure','message'=>'Setup Already Finished '));
          }else{
            echo json_encode(array('result' =>'failure','message'=>'Setup Already started '));
          }
        }
      }elseif($this->input->get('status') == 2){
        if($job_details_spcs['setup']==1){
          $datetime1 = new DateTime($job_details_spcs['setup_start']);
          $datetime2 = new DateTime(date('Y-m-d H:i:00'));
          $interval = $datetime1->diff($datetime2);
//$data['machine']=$this->mobile->get_machine_id($this->input->get('machine_name'));
          $data['setup']=2;
          $data['setup_end'] = date('Y-m-d H:i:00');
          $job_status=$this->mobile->update_jobstatus($data,$job_details_spcs['id']);
// Update Tooling Complete Status
          $status_update['tjob_id'] = $job_details_boots['tjob_id'];
          $status_update['update_date'] = date('Y-m-d');
          $status_update['update_time'] = date('Y-m-d H:i:00');
          $status_update['update_for']    = 3 ;
          $status_update['update_status'] = 1 ;
          $status_update['update_to'] = 'SETUP - Ended By '.$username;
          $status_update['update_by'] = MOBILE_APP_USER_ID;
          $job_status_update = $this->mobile->update_job_status_boots($status_update);
// SetupTime Update Status
          $status_update['tjob_id'] = $job_details_boots['tjob_id'];
          $status_update['update_date'] = date('Y-m-d');
          $status_update['update_time'] = date('Y-m-d H:i:00');
          $status_update['update_for']    = 3 ;
          $status_update['update_status'] = 1 ;
          $status_update['update_to'] = 'Setup time Updated - '.$interval->format('%h').':'.$interval->format('%i');
          $status_update['update_by'] = MOBILE_APP_USER_ID;
          $job_status_update = $this->mobile->update_job_status_boots($status_update);
          if($job_status){
            echo json_encode(array('result' =>'success','message'=>'Setup Status Updated Successfully','mcdown_id'=>$job_status));
          }else{
            echo json_encode(array('result' =>'failure','message'=>'Setup Status Update Failed'));
          }
        }else{
          if($job_details_spcs['setup']==0){
            echo json_encode(array('result' =>'failure','message'=>'Setup Not Started '));
          }else{
            echo json_encode(array('result' =>'failure','message'=>'Setup Already Finished '));
          }
        }
      }
    }
  }else{
    echo json_encode(array('result' =>'failure','message'=>'Job not found in beamon shop.'));
  }
}
*/

public function machine_ready(){
    
    
    $machine = $this->mobile->get_machine_id($this->input->get('machine_name'));
    
	$machine_status = $this->downCheck_beforeReady($machine);
	
	if($machine_status==1){
		echo  json_encode(array('result' =>'failure','message' => 'No down on this time..'));
		exit;
	}

    $machine_name = $this->input->get('machine_name');
    $data['machine']=$this->mobile->get_machine_id($this->input->get('machine_name'));
    if($data['machine']){
        $check['date']   = date('Y-m-d');
        $check['machine']   = $data['machine'];
        $check['date_from'] = date('Y-m-d');
        $check['date_to']   = date('Y-m-d');
        $check['machine']   = $data['machine'];
        $check['shift']     = 1;
        $check['time_from']  = date('H:i:s');
        $check['time_to']    = date('H:i:s',strtotime("+2 minutes"));
        $machine_status = $this->mobile->check_job_status($check);
        //echo "<pre>"; print_r($machine_status);exit;
        if(($machine_status['mcdown']==1 || $machine_status['other_down']==1)&&($machine_status['job']==1)){
            foreach ($machine_status['mcdown_id'] as $key => $mcdown_id) {
                $update['time_to'] = date('H:i:00');
                $update['task'] = 1;
                $update['prev_down_job_status'] = 0;                
                $machineready_update = $this->mobile->update_jobstatus($update,$mcdown_id);
                
                $get_prev_job = $this->mobile->machine_continue_after_ready($mcdown_id);
                if($get_prev_job!=0){
                    $prev_down_job = $get_prev_job['prev_down_job'];   
                    $new_job_details = $this->mobile->load_existing_details($prev_down_job);                    
                }                 
                if($machineready_update){
                    $mcdown_updates['job_id'] = $mcdown_id;
                    $mcdown_updates['updated_for'] = 1; 
                    $mcdown_updates['updated_to'] = 'Machine Ready -'.$machine_name;
                    $mcdown_updates['updated_by'] =  'mobile user'; 
                    $mcdown_updates['updated_status'] = 1;
                    $mcdown_updates['updated_remark'] = '';
                    mcdown_updates($mcdown_updates);
                    $job_details_spcs = $this->mobile->get_job_details_id($mcdown_id);
                    if($job_details_spcs['mc_down']==1){
                        $down = 'm';
                    }elseif($job_details_spcs['other_down']==1){
                        $down = 'o';
                    }
                    $this->upcomingmcdown_ready($job_details_spcs['machine'],$job_details_spcs['date_from'],$job_details_spcs['shift'],$down);
                    // change updated times to upcoming jobs
                    $this->mobile->update_upcomingjobs_time($job_details_spcs['date_from'],$job_details_spcs['shift'],$job_details_spcs['machine'],$job_details_spcs['time_from'],$update['time_to'],$mcdown_id);
                    $this->cron_run();
                    echo json_encode(array('result' =>'success','message'=>'Machine Ready Updated.','machine_id'=>$machineready_update));
                }else{
                    echo json_encode(array('result' =>'failure','message'=>'Machine Ready Update failed.'));
                }
            }
        }else{
            echo json_encode(array('result' =>'failure','message'=>'No Machine down not on this time.'));
        }
    }else{
        echo json_encode(array('result' =>'failure','message'=>'Machine Not Found.'));
    }
}
/*public function machine_ready(){
    $machine_name = $this->input->get('machine_name');
    $data['machine']=$this->mobile->get_machine_id($this->input->get('machine_name'));
    if($data['machine']){
        $check['date']   = date('Y-m-d');
        $check['machine']   = $data['machine'];
        $check['date_from'] = date('Y-m-d');
        $check['date_to']   = date('Y-m-d');
        $check['machine']   = $data['machine'];
        $check['shift']     = 1;
        $check['time_from']  = date('H:i:s');
        $check['time_to']    = date('H:i:s',strtotime("+5 minutes"));
        $machine_status = $this->mobile->check_job_status($check);
        //print_r($machine_status);exit;
        if(($machine_status['mcdown']==1 || $machine_status['other_down']==1)&&($machine_status['job']==1)){
            foreach ($machine_status['mcdown_id'] as $key => $mcdown_id) {
                $update['time_to'] = date('H:i:00');
                $update['task'] = 1;
                $machineready_update = $this->mobile->update_jobstatus($update,$mcdown_id);
                if($machineready_update){
                    $mcdown_updates['job_id'] = $mcdown_id;
                    $mcdown_updates['updated_for'] = 1; 
                    $mcdown_updates['updated_to'] = 'Machine Ready -'.$machine_name;
                    $mcdown_updates['updated_by'] =  'mobile user'; 
                    $mcdown_updates['updated_status'] = 1;
                    $mcdown_updates['updated_remark'] = '';
                    mcdown_updates($mcdown_updates);
                    $job_details_spcs = $this->mobile->get_job_details_id($mcdown_id);
                    
                    /*if($job_details_spcs['mcdown']==1){
                        $down = 'm';
                    }elseif($job_details_spcs['other_down']==1){
                        $down = 'o';
                    }
                    $this->upcomingmcdown_ready($job_details_spcs['machine'],$job_details_spcs['date_from'],$job_details_spcs['shift']); //,$down
                    // change updated times to upcoming jobs
                    $this->mobile->update_upcomingjobs_time($job_details_spcs['date_from'],$job_details_spcs['shift'],$job_details_spcs['machine'],$job_details_spcs['time_from'],$update['time_to'],$mcdown_id);
                    echo json_encode(array('result' =>'success','message'=>'Machine Ready Updated.','machine_id'=>$machineready_update));
                }else{
                    echo json_encode(array('result' =>'failure','message'=>'Machine Ready Update failed.'));
                }
            }
        }else{
            echo json_encode(array('result' =>'failure','message'=>'No Machine down not on this time.'));
        }
    }else{
        echo json_encode(array('result' =>'failure','message'=>'Machine Not Found.'));
    }
}*/

/*public function other_ready(){
    $machine_name = $this->input->get('machine_name');
    $data['machine']=$this->mobile->get_machine_id($this->input->get('machine_name'));
    if($data['machine']){
        $check['date']   = date('Y-m-d');
        $check['machine']   = $data['machine'];
        $check['date_from'] = date('Y-m-d');
        $check['date_to']   = date('Y-m-d');
        $check['machine']   = $data['machine'];
        $check['shift']     = 1;
        $check['time_from']  = date('H:i:s');
        $check['time_to']    = date('H:i:s',strtotime("+5 minutes"));
        $machine_status = $this->mobile->check_job_status_otherdown($check);
        //print_r($machine_status);exit;
        if(($machine_status['other_down']==1)&&($machine_status['job']==1)){
            foreach ($machine_status['mcdown_id'] as $key => $mcdown_id) {
                $update['time_to'] = date('H:i:00');
                $update['task'] = 1;
                $machineready_update = $this->mobile->update_jobstatus($update,$mcdown_id);
                if($machineready_update){
                    $mcdown_updates['job_id'] = $mcdown_id;
                    $mcdown_updates['updated_for'] = 1; 
                    $mcdown_updates['updated_to'] = 'Machine Ready -'.$machine_name;
                    $mcdown_updates['updated_by'] =  'mobile user'; 
                    $mcdown_updates['updated_status'] = 1;
                    $mcdown_updates['updated_remark'] = '';
                    mcdown_updates($mcdown_updates);
                    $job_details_spcs = $this->mobile->get_job_details_id($mcdown_id);
                    $this->upcomingmcdown_ready($job_details_spcs['machine'],$job_details_spcs['date_from'],$job_details_spcs['shift']);
                    // change updated times to upcoming jobs
                    $this->mobile->update_upcomingjobs_time($job_details_spcs['date_from'],$job_details_spcs['shift'],$job_details_spcs['machine'],$job_details_spcs['time_from'],$update['time_to'],$mcdown_id);
                    echo json_encode(array('result' =>'success','message'=>'Machine Ready Updated.','machine_id'=>$machineready_update));
                }else{
                    echo json_encode(array('result' =>'failure','message'=>'Machine Ready Update failed.'));
                }
            }
        }else{
            echo json_encode(array('result' =>'failure','message'=>'No Machine down not on this time.'));
        }
    }else{
        echo json_encode(array('result' =>'failure','message'=>'Machine Not Found.'));
    }
}
/*tooling befor adding side operations  
 
public function tooling(){
    $data['job_code']      = $this->input->get('job_code');
    $data['status']        = $this->input->get('status');
    $data['username']      = $this->input->get('username');
    $data['qty']           = $this->input->get('qty');
    $data['machine_name']  = $this->input->get('machine_name');
    $data['machine']       = $this->mobile->get_machine_id($this->input->get('machine_name'));
    
    $job_details_boots     = $this->mobile->get_job_details_boots($data['job_code']);
    $job_details_spcs      = $this->mobile->get_job_details($data['job_code']);
    
    $tooling['current_qty'] = $data['qty'];
    $tooling['machine']     = $data['machine'];
    $tooling['order_id']    = $job_details_spcs['id'];
    //echo "<pre>";print_r($tooling);exit;
    $get_setup_state = $this->mobile->get_setup_state($tooling);
   // echo "<pre>";print_r($get_setup_state);
    if($get_setup_state['state'] >= 2){
    	$get_tooling_qty_state  = $this->mobile->get_tooling_qty_state($tooling);
    	//echo "<pre>";print_r($get_tooling_qty_state);
    	if($data['status'] ==2){
    	    if(($get_tooling_qty_state['state']==1)||($get_tooling_qty_state['state']==3)||($get_tooling_qty_state['state']==5)){
    	        if($data['qty']==$job_details_spcs['qty']){
    	            // update tooling complete status in wims and spcs
    	                
    	               if(($get_tooling_qty_state['state']==1)){
				//update setup time in setup_timings
				if($get_tooling_qty_state['state']==5){
				    $tooling_timing['tooling2_end'] = date('Y-m-d H:i:00');
				}elseif($get_tooling_qty_state['state']==3){
				    $tooling_timing['tooling1_end'] = date('Y-m-d H:i:00');
				}else{
				    $tooling_timing['tooling_end'] = date('Y-m-d H:i:00');
				}  
				$tooling_timing['machine'] = $data['machine'];
				$tooling_timing['current_qty'] = $data['qty'];
				$tooling_timing['user_id'] = get_user_id($data['username']);
				$tooling_timing['order_id'] = $job_details_spcs['id'];
				$update_tooling_timing =$this->mobile->update_tooling_time($tooling_timing);
				
				$datetime1 = new DateTime($job_details_spcs['tooling_start']);
				$datetime2 = new DateTime(date('Y-m-d H:i:00'));
				$interval = $datetime1->diff($datetime2);
				$update['machine_time_hr']  = $interval->format('%h') ;
				$update['machine_time_min'] = $interval->format('%i') ;
				$update['tjob_tooling_status'] = 2 ;
				$update['tjob_tooling_lupdate'] = date('Y-m-d H:i:00');
				$job_update = $this->mobile->update_job_details_boots($update,$data['job_code']);
				if($job_update){
					$spcs_update['tooling_end'] = date('Y-m-d H:i:00');
					$spcs_update['time_to']=date('H:i:00');
					$spcs_update['job_complete_status'] = 2;
					$job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']);
					$mcdown_updates['job_id'] = $job_details_spcs['id'];
					$mcdown_updates['updated_for'] = 6; 
					$mcdown_updates['updated_to'] = 'Tooling Finished - '.$data['machine_name'];
					$mcdown_updates['updated_by'] =   $data['username']; 
					$mcdown_updates['updated_status'] = 2;
					$mcdown_updates['updated_remark'] = '';
					mcdown_updates($mcdown_updates);
					// Update Tooling Complete Status
					$status_update['tjob_id'] = $job_details_boots['tjob_id'];
					$status_update['update_date'] = date('Y-m-d');
					$status_update['update_time'] = date('Y-m-d H:i:00');
					$status_update['update_for']    = 3 ;
					$status_update['update_status'] = 1 ;
					$status_update['update_to'] = 'TOOLING - Completed By '.$data['username'];
					$status_update['update_by'] = MOBILE_APP_USER_ID;
					$job_status_update = $this->mobile->update_job_status_boots($status_update);
					// Machine Time Update Status
					$status_update['tjob_id'] = $job_details_boots['tjob_id'];
					$status_update['update_date'] = date('Y-m-d');
					$status_update['update_time'] = date('Y-m-d H:i:00');
					$status_update['update_for']    = 3 ;
					$status_update['update_status'] = 1 ;
					$status_update['update_to'] = 'Machine time Updated - '.$interval->format('%h').':'.$interval->format('%i');
					$status_update['update_by'] = MOBILE_APP_USER_ID;
					$job_status_update = $this->mobile->update_job_status_boots($status_update);
					// change updated times to upcoming jobs
					$this->mobile->update_upcomingjobs_time($job_details_spcs['date_from'],$job_details_spcs['shift'],$job_details_spcs['machine'],$job_details_spcs['time_from'],$spcs_update['time_to'],$job_details_spcs['id']);
					echo json_encode(array('result' =>'success','message'=>'Tooling Finish Successfully updated.','job_code'=>$job_update));
				}else{
					echo json_encode(array('result' =>'failure','message'=>'Something went to wrong .'));
				}
    	               }else{
				//update setup time in setup_timings
				if($get_tooling_qty_state['state']==5){
				    $tooling_timing['tooling2_end'] = date('Y-m-d H:i:00');
				    $message="This order second Retooling Finish updated";
				}elseif($get_tooling_qty_state['state']==3){
				    $tooling_timing['tooling1_end'] = date('Y-m-d H:i:00');
				    $message="This order Retooling Finish updated";
				}else{
				    $tooling_timing['tooling_end'] = date('Y-m-d H:i:00');
				    $message="This order tooling Finish updated";
				}  
				$tooling_timing['machine'] = $data['machine'];
				$tooling_timing['current_qty'] = $data['qty'];
				$tooling_timing['user_id'] = get_user_id($data['username']);
				$tooling_timing['order_id'] = $job_details_spcs['id'];
				$update_tooling_timing =$this->mobile->update_tooling_time($tooling_timing);
				
				echo json_encode(array('result' =>'success','message'=>$message,'job_code'=>$data['job_code']));
				
    	               }      	                
	    	        			
			
    	            
    	        }else{
			// update tooling timings in spcs
			if($get_tooling_qty_state['state']==5){
			    $tooling_timing['tooling2_end'] = date('Y-m-d H:i:00');
			    $message="This order second Retooling Finish updated";
			}elseif($get_tooling_qty_state['state']==3){
			    $tooling_timing['tooling1_end'] = date('Y-m-d H:i:00');
			    $message="This order Retooling Finish updated";
			}else{
			    $tooling_timing['tooling_end'] = date('Y-m-d H:i:00');
			    $message="This order tooling Finish updated";
			}  
			$tooling_timing['machine'] = $data['machine'];
			$tooling_timing['current_qty'] = $data['qty'];
			$tooling_timing['user_id'] = get_user_id($data['username']);
			$tooling_timing['order_id'] = $job_details_spcs['id'];
			$update_tooling_timing =$this->mobile->update_tooling_time($tooling_timing);
			
			echo json_encode(array('result' =>'success','message'=>$message,'job_code'=>$data['job_code']));
    	            
    	        }
    	    }elseif(($get_tooling_qty_state['state']==2)||($get_tooling_qty_state['state']==4)||($get_tooling_qty_state['state']==6)){
    	        // tooling already completed 
    	        if($get_tooling_qty_state['state']==6){
         		echo json_encode(array('result' =>'failure','message'=>'this order Second Retooling already Finished'));
		}elseif($get_tooling_qty_state['state']==4){
			echo json_encode(array('result' =>'failure','message'=>'this order Retooling already Finished'));
		}else{
			echo json_encode(array('result' =>'failure','message'=>'this order Tooling already Finished'));
		} 
    	    }else{
    	        // tooling not yet initialized
    	        echo json_encode(array('result' =>'failure','message'=>'this order Tooling Not Yet Started.'));
    	    }
    	}else{
    	    if(($get_tooling_qty_state['state']==0)||($get_tooling_qty_state['state']==2)||($get_tooling_qty_state['state']==4)){
    	            if(($get_tooling_qty_state['state']==0)){
    	            	if($data['qty']==1){
    	            		// update tooling timings and other timings in boots
    	            	
	    	            	//update setup time in setup_timings
				if($get_tooling_qty_state['state']==4){
				    $tooling_timing['tooling2_start'] = date('Y-m-d H:i:00');
				}elseif($get_tooling_qty_state['state']==2){
				    $tooling_timing['tooling1_start'] = date('Y-m-d H:i:00');
				}else{
				    $tooling_timing['tooling_start'] = date('Y-m-d H:i:00');
				}  
				$tooling_timing['machine'] = $data['machine'];
				$tooling_timing['current_qty'] = $data['qty'];
				$tooling_timing['user_id'] = get_user_id($data['username']);
				$tooling_timing['order_id'] = $job_details_spcs['id'];
				$insert_tooling_timing =$this->mobile->insert_tooling_time($tooling_timing);
			
				//boots and spcs
				$update['tjob_tooling_status'] = 1 ;
				$update['tjob_tooling_lupdate'] = date('Y-m-d H:i:00');
				$job_update = $this->mobile->update_job_details_boots($update,$data['job_code']);
				if($job_update){
					$spcs_update['job_complete_status'] = 1;
					$spcs_update['tooling_start'] = date('Y-m-d H:i:00');
					$job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']);
					$mcdown_updates['job_id'] = $job_details_spcs['id'];
					$mcdown_updates['updated_for'] = 5; 
					$mcdown_updates['updated_to'] = 'Tooling Started - '.$data['machine_name'];
					$mcdown_updates['updated_by'] =   $data['username']; 
					$mcdown_updates['updated_status'] = 1;
					$mcdown_updates['updated_remark'] = '';
					mcdown_updates($mcdown_updates);
					// Update Tooling Complete Status
					$status_update['tjob_id'] = $job_details_boots['tjob_id'];
					$status_update['update_date'] = date('Y-m-d');
					$status_update['update_time'] = date('Y-m-d H:i:00');
					$status_update['update_for']    = 3 ;
					$status_update['update_status'] = 1 ;
					$status_update['update_to'] = 'TOOLING - Working By '.$data['username'];
					$status_update['update_by'] = MOBILE_APP_USER_ID;
					$status_update['update_remarks'] = '';
					$job_status_update = $this->mobile->update_job_status_boots($status_update);
					echo json_encode(array('result' =>'success','message'=>'Successfully updated.','job_code'=>$job_update));
				}else{
					echo json_encode(array('result' =>'failure','message'=>'Something went to wrong .'));
				}
			}else{
				//update setup time in setup_timings
				if($get_tooling_qty_state['state']==4){
				    $tooling_timing['tooling2_start'] = date('Y-m-d H:i:00');
				}elseif($get_tooling_qty_state['state']==2){
				    $tooling_timing['tooling1_start'] = date('Y-m-d H:i:00');
				}else{
				    $tooling_timing['tooling_start'] = date('Y-m-d H:i:00');
				}  
				$tooling_timing['machine'] = $data['machine'];
				$tooling_timing['current_qty'] = $data['qty'];
				$tooling_timing['user_id'] = get_user_id($data['username']);
				$tooling_timing['order_id'] = $job_details_spcs['id'];
				$insert_tooling_timing =$this->mobile->insert_tooling_time($tooling_timing);
				
				echo json_encode(array('result' =>'success','message'=>'This order tooling start updated.','job_code'=>$data['job_code']));
			}
    	            }else{
    	            	// update tooling timings and other timings 
    	            	
			if($get_tooling_qty_state['state']==4){
			    $tooling_timing['tooling2_start'] = date('Y-m-d H:i:00');
			    $message="This order second Retooling Start updated";
			}elseif($get_tooling_qty_state['state']==2){
			    $tooling_timing['tooling1_start'] = date('Y-m-d H:i:00');
			    $message="This order Retooling Start updated";
			}else{
			    $tooling_timing['tooling_start'] = date('Y-m-d H:i:00');
			    $message="This order tooling Start updated";
			}  
			$tooling_timing['machine'] = $data['machine'];
			$tooling_timing['current_qty'] = $data['qty'];
			$tooling_timing['user_id'] = get_user_id($data['username']);
			$tooling_timing['order_id'] = $job_details_spcs['id'];
			$update_tooling_timing =$this->mobile->update_tooling_time($tooling_timing);
			
			echo json_encode(array('result' =>'success','message'=>$message,'job_code'=>$data['job_code']));
    	            }
    	    }elseif(($get_tooling_qty_state['state']==1)||($get_tooling_qty_state['state']==3)||($get_tooling_qty_state['state']==5)){
    	        // tooling start already initialized 
		if($get_tooling_qty_state['state']==5){
         		echo json_encode(array('result' =>'failure','message'=>'this order Second Retooling already Started'));
		}elseif($get_tooling_qty_state['state']==3){
			echo json_encode(array('result' =>'failure','message'=>'this order Retooling already Started'));
		}else{
			echo json_encode(array('result' =>'failure','message'=>'this order Tooling already Started'));
		}
    	    }else{
    	        // tooling finish already updated
    	        if($get_tooling_qty_state['state']==6){
         		echo json_encode(array('result' =>'failure','message'=>'this order Second Retooling already Finished'));
		}elseif($get_tooling_qty_state['state']==4){
			echo json_encode(array('result' =>'failure','message'=>'this order Retooling already Finished'));
		}else{
			echo json_encode(array('result' =>'failure','message'=>'this order Tooling already Finished'));
		} 
    	    }
    	}
    }elseif($get_setup_state['state'] == 1){
    	echo json_encode(array('result' =>'failure','message'=>'Job Setup not finished.'));
    
    }else{
    	echo json_encode(array('result' =>'failure','message'=>'Job Setup not started.'));
    }
}
/* tooling new */

/* public function tooling(){
	 
    $machine = $this->mobile->get_machine_id($this->input->get('machine_name'));	
	//$hold_job = $this->check_hold($machine,$this->input->get('job_code'));
	//if($hold_job>0){		
	//	echo json_encode(array('result' =>'failure','message'=>'job is holded so you must unhold the job'));		
	//}	 
	 
    if($this->input->get('toolingstatus')=='ts'){
        $this->autoprevjob_tooling_finish($this->input->get('job_code'));
    }
    
    if($this->input->get('toolingstatus')=='ts' || $this->input->get('toolingstatus')=='tf'){
        $this->same_job_tooling_finish($this->input->get('job_code')); 
    }    
    
    $data['job_code']      = $this->input->get('job_code');
    $data['status']        = $this->input->get('status');
    $data['username']      = $this->input->get('username');
    $data['qty']           = $this->input->get('qty');
    $data['machine_name']  = $this->input->get('machine_name');
    $data['mc_status']     = $this->input->get('toolingstatus');
    $data['machine']       = $this->mobile->get_machine_id($this->input->get('machine_name'));
    $data['side']          = $this->input->get('side');
    $explode_down           = explode("[",$data['job_code']);
    $job_details_boots     = $this->mobile->get_job_details_boots($explode_down[0]);
    $job_details_spcs      = $this->mobile->get_job_details($data['job_code']);
    $tooling['machine']     = $data['machine'];
    $tooling['order_id']    = $job_details_spcs['id'];
    $tooling['side']	    = $data['side'];
    $tooling['current_qty'] = $data['qty'];
    $get_setup_state = $this->mobile->get_setup_state($tooling);
    if($get_setup_state['state'] >= 2){
    	$get_tooling_qty_state  = $this->mobile->get_tooling_qty_state($tooling);
 
    	if($data['status'] ==2){
    		if( ( $get_tooling_qty_state['state'] >= 2 ) || ( $get_tooling_qty_state['state'] == 0 ) ){
    			if( $get_tooling_qty_state['state'] >= 2 ){
    				echo json_encode(array('result' =>'success','message'=>'Tooling already finished','job_code'=>$data['job_code']));
    			}else{

                /*************** CHECK TOOLING FIRST SIDE FIRST QTY **************
                
                $side_with_first_qty = $this->mobile->tooling_side_with_qty($job_details_spcs['id'],$data['side'],1);
                
                if($side_with_first_qty==0){
    				echo json_encode(array('result' =>'failure','message'=>'First Tooling Not yet started','job_code'=>$data['job_code']));
    				exit;                    
                }
                
                /*************** CHECK TOOLING FIRST SIDE FIRST QTY **************
                
                
            	 for($i=1;$i<=$data['qty'];$i++){
            		
            		$tooling_start_and_end_time = $this->mobile->tooling_start_and_end_time($job_details_spcs['id'],$data['side'],$i);
            		if($tooling_start_and_end_time=='not_tooling_end'){
            		    
            			$tooling_timing['tooling_end'] = date('Y-m-d H:i:s');
            			$tooling_timing['machine']	= $data['machine'];
            			$tooling_timing['side']		= $data['side'];
            			$tooling_timing['current_qty']	= $i;
            			$tooling_timing['user_id']	= get_user_id($data['username']);
            			$tooling_timing['order_id']	= $job_details_spcs['id'];
            			$tooling_timing['mc_status'] = $data['mc_status'];
            			
            			$modify_tooling_timing = $this->mobile->update_tooling_time($tooling_timing);
            			$this->mcdown_updates_basedon_qty($job_details_spcs,$data['side'],$i,$data,'t2',$data['mc_status']);
            			
                  		// update tooling finish in boots
                		$qty_check = $this->mobile->check_job_status_boots_qty_side($job_details_boots['tjob_id'],$data['side'],$i);
                        if($qty_check==1 || $qty_check==0){    		
                    		$status_update['tjob_id'] = $job_details_boots['tjob_id'];
                    		$status_update['update_date'] = date('Y-m-d');
                    		$status_update['update_time'] = date('Y-m-d H:i:s');
                    		$status_update['update_for']    = 3 ;
                    		$status_update['update_status'] = 1 ;
                    		$status_update['update_to'] = 'Tooling Finished  Side - '.$data['side'].' Qty -'.$i. ' - Completed By '.$data['username'];
                    		$status_update['update_by'] = get_user_id($data['username']);
							$status_update['update_remarks'] = '';
    						$status_update['side'] = $data['side'];
    						$status_update['qty'] = $i;                      		
                    		 $status_update['update_from'] = 'mobile';
                    		$job_status_update = $this->mobile->update_job_status_boots($status_update);			
                        }            			
            		}elseif($tooling_start_and_end_time=='not_tooling_start_and_end'){
            			/************ INSERT DATA FOR TOOLING START **********
            			$tooling_timing['tooling_start'] = date('Y-m-d H:i:s');
            			$tooling_timing['machine']	= $data['machine'];
            			$tooling_timing['side']		= $data['side'];
            			$tooling_timing['current_qty']	= $i;
            			$tooling_timing['user_id']	= get_user_id($data['username']);
            			$tooling_timing['order_id']	= $job_details_spcs['id'];
            			$tooling_timing['mc_status'] = 'ts';
            			$modify_tooling_timing = $this->mobile->insert_tooling_time($tooling_timing);
            			$this->mcdown_updates_basedon_qty($job_details_spcs,$data['side'],$i,$data,'t1','ts');
            			
            			
									$status_update['tjob_id'] = $job_details_boots['tjob_id'];
									$status_update['update_date'] = date('Y-m-d');
									$status_update['update_time'] = date('Y-m-d H:i:s');
									$status_update['update_for']    = 3 ;
									$status_update['update_status'] = 1 ;
									$status_update['update_to'] = 'TOOLING Started Side  - '.$data['side'].' Qty -'.$i.' Working By '.$data['username'];
									$status_update['update_by'] = get_user_id($data['username']); //MOBILE_APP_USER_ID;
									$status_update['update_remarks'] = '';
            						$status_update['side'] = $data['side'];
            						$status_update['qty'] = $i;  
            						$status_update['update_from'] = 'mobile';
									$job_status_update = $this->mobile->update_job_status_boots($status_update);
									
									
            			/************ INSERT DATA FOR TOOLING END **********
            			$tooling_timing['tooling_end'] = date('Y-m-d H:i:s');
            			$tooling_timing['machine']	= $data['machine'];
            			$tooling_timing['side']		= $data['side'];
            			$tooling_timing['current_qty']	= $i;
            			$tooling_timing['user_id']	= get_user_id($data['username']);
            			$tooling_timing['order_id']	= $job_details_spcs['id'];
            			$tooling_timing['mc_status'] = 'tf';
            			$modify_tooling_timing = $this->mobile->update_tooling_time($tooling_timing);
            			$this->mcdown_updates_basedon_qty($job_details_spcs,$data['side'],$i,$data,'t2','tf');
                 		// update tooling finish in boots
                		$qty_check = $this->mobile->check_job_status_boots_qty_side($job_details_boots['tjob_id'],$data['side'],$i);
                        if($qty_check==1 || $qty_check==0){    		
                    		$status_update['tjob_id'] = $job_details_boots['tjob_id'];
                    		$status_update['update_date'] = date('Y-m-d');
                    		$status_update['update_time'] = date('Y-m-d H:i:s');
                    		$status_update['update_for']    = 3 ;
                    		$status_update['update_status'] = 1 ;
                    		$status_update['update_to'] = 'Tooling Finished  Side - '.$data['side'].' Qty -'.$i. ' - Completed By '.$data['username'];
                    		$status_update['update_by'] = get_user_id($data['username']);
							$status_update['update_remarks'] = '';
    						$status_update['side'] = $data['side'];
    						$status_update['qty'] = $i;                      		
                    		$status_update['update_from'] = 'mobile';
                    		$job_status_update = $this->mobile->update_job_status_boots($status_update);			
                        }             			
            			
            		}

                    $spcs_update['setup_status']=2;
     				$job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']); 
            		if($job_details_spcs['side']==$data['side'] && $job_details_spcs['qty'] == $i){

    					$spcs_update['tooling_end'] = date('Y-m-d H:i:s');
    					$spcs_update['time_to']=date('H:i:00');
    					$spcs_update['job_complete_status'] = 2;
    					$spcs_update['task'] = 1;

    					$job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']);
    					$samejob_update['job_complete_status'] = 2;
    					$samejob_job_status_update = $this->mobile->update_jobstatus_samejob($samejob_update,$data['job_code']);
    					
                        $tooling_totaltime = $this->mobile->get_totaltooling_time($job_details_spcs['id'],$data['machine'],$job_details_spcs['side'],$job_details_spcs['qty']);	
						$update['machine_time_hr']  = $tooling_totaltime['hour'];
						$update['machine_time_min'] = $tooling_totaltime['min'];

						$update['tjob_tooling_lupdate'] = $tooling_timing['tooling_end'];
						$job_update = $this->mobile->update_job_details_boots($update,$data['job_code']);
            		}
            		
            	}
        		if($modify_tooling_timing){
        			echo json_encode(array('result' =>'success','message'=>'Tooling Finish Successfully updated.','job_code'=>$data['job_code']));
        		}
        		exit;
					//echo json_encode(array('result' =>'success','message'=>'First Tooling Not yet started111','job_code'=>$data['job_code']));
    	        }
			}else{
    	        if( ( $data['qty'] == $job_details_spcs['qty'] ) && ( $data['side'] == $job_details_spcs['side'] ) ){
				if($job_details_spcs['side']>2){
					for($s=1;$s<=$job_details_spcs['side'];$s++){
						if($s!=$job_details_spcs['side']){  /*without last side
							for($i=1;$i<=$job_details_spcs['qty'];$i++){
								$check_multiple_side_completed_or_not  = $this->mobile->check_tooling_front_completed_or_not($data['mc_status'],$data['mc_status'],$tooling['order_id'],$s,$i);	
									if($check_multiple_side_completed_or_not==0){
										$ret_value = $this->before_last_side_with_timing_update($i,$s,$data,$job_details_spcs,$job_details_boots);										
									}										
								}
							}else{  /*with last side						
								for($i=1;$i<=$job_details_spcs['qty'];$i++){
								   
									if($job_details_spcs['qty'] == $i){	
										$ret_value = $this->multiple_last_side_qty_timing_update($i,$s,$job_details_spcs,$data,$job_details_boots);																			
									}else{	
										$ret_value = $this->multiple_side_qty_timing_update($i,$s,$data,$job_details_spcs,$job_details_boots);																				
									}																		
								}								
							}
						}
					}elseif($job_details_spcs['side']==2){			
						for($s=1;$s<=$job_details_spcs['side'];$s++){
							if($s!=$job_details_spcs['side']){  /*without last side						
								for($i=1;$i<=$job_details_spcs['qty'];$i++){																			
									$check_tooling_exist_or_not  = $this->mobile->check_tooling_front_completed_or_not($data['mc_status'],$tooling['order_id'],$s,$i);								
									if($check_tooling_exist_or_not==0){																
										if($i != $job_details_spcs['qty']){									
											
											$tool_time = $this->mobile->update_end_time_check($job_details_spcs['id'],$s,$i);
											if($tool_time==0){
    											$tooling_timing['tooling_end']	= date('Y-m-d H:i:s');
    											$tooling_timing['machine']	= $data['machine'];
    											$tooling_timing['current_qty']	= $i;
    											$tooling_timing['side']		= $s;
    											$tooling_timing['user_id']	= get_user_id($data['username']);
    											$tooling_timing['order_id']	= $job_details_spcs['id'];
    											$tooling_timing['mc_status'] = $data['mc_status'];
    											$tooling_timing['shift_time'] = $this->shift_up_time;
    											$update_tooling_timing = $this->mobile->update_tooling_time($tooling_timing);
                                    			}else{
                                    			    
                                    			    $update_tooling_timing = $this->mobile->update_tooling_update_at($job_details_spcs['id'],$s,$i,$this->shift_up_time);
                                    			}
												
											$qty_check = $this->mobile->check_job_status_boots_qty_side($job_details_boots['tjob_id'],$s,$i);
				                            if($qty_check==1 || $qty_check==0){	
            									// Update Tooling Complete Status
            									$status_update['tjob_id'] = $job_details_boots['tjob_id'];
            									$status_update['update_date'] = date('Y-m-d');
            									$status_update['update_time'] = date('Y-m-d H:i:s');
            									$status_update['update_for']    = 3 ;
            									$status_update['update_status'] = 1 ;
            									$status_update['update_to'] = 'TOOLING Finished Side- '.$s.' Qty -'.$i.' Working By '.$data['username'];
            									$status_update['update_by'] = get_user_id($data['username']); //MOBILE_APP_USER_ID;
            									$status_update['side'] = $s;
            									$status_update['qty'] = $i;
            									$status_update['update_remarks'] = '';
            									 $status_update['update_from'] = 'mobile';
            									$job_status_update = $this->mobile->update_job_status_boots($status_update);												
				                            }	
												
												$mcdown_updates['job_id'] = $job_details_spcs['id'];
												$mcdown_updates['updated_for'] = 6; 
												$mcdown_updates['updated_to'] = 'Tooling Finished - Side('.$s.'/'.$job_details_spcs['side'].') - Qty('.$i.'/'.$job_details_spcs['qty'].') - '.$data['machine_name'];
												$mcdown_updates['updated_by'] =   $data['username']; 
												$mcdown_updates['updated_status'] = 2;
												$mcdown_updates['updated_remark'] = '';
												$mcdown_updates['qty_no']	= $i;
												$mcdown_updates['qty_status']	= 1;
												$mcdown_updates['mechine_status'] = 't2';
												$mcdown_updates['mc_status'] = $data['mc_status'];
												$mcdown_updates['side']	= $s;
												$mcdown_updates['tot_side'] = $job_details_spcs['side'];			
												mcdown_updates($mcdown_updates);
												$ret_value = $update_tooling_timing;
										}									
									}																		
								}
							}else{
								for($i=1;$i<=$job_details_spcs['qty'];$i++){																		
									if($job_details_spcs['qty'] == $i){	
										$ret_value = $this->multiple_last_side_qty_timing_update($i,$s,$job_details_spcs,$data,$job_details_boots);	
									}else{										
										$ret_value = $this->multiple_side_qty_timing_update($i,$s,$data,$job_details_spcs,$job_details_boots);																				
									}																		
								}
									
							}
						}
				}else{
					for($i=1;$i<=$job_details_spcs['qty'];$i++){																		
						$check_tooling_exist_or_not  = $this->mobile->check_tooling_front_completed_or_not($data['mc_status'],$tooling['order_id'],1,$i);	
						if($i != $job_details_spcs['qty']){	
    						if($check_tooling_exist_or_not==0){
    								$tool_time = $this->mobile->update_end_time_check($job_details_spcs['id'],1,$i);
									if($tool_time==0){
        								$tooling_timing['tooling_end']	= date('Y-m-d H:i:s');
        								$tooling_timing['machine']	= $data['machine'];
        								$tooling_timing['current_qty']	= $i;
        								$tooling_timing['side']		= 1;
        								$tooling_timing['user_id']	= get_user_id($data['username']);
        								$tooling_timing['order_id']	= $job_details_spcs['id'];
        								$tooling_timing['mc_status'] = $data['mc_status'];
        								$tooling_timing['shift_time'] = $this->shift_up_time;
        								$update_tooling_timing = $this->mobile->update_tooling_time($tooling_timing);
                            			}else{
                            			    $update_tooling_timing = $this->mobile->update_tooling_update_at($job_details_spcs['id'],1,$i,$this->shift_up_time);
                            			}
    									// Update Tooling Complete Status
    									$qty_check = $this->mobile->check_job_status_boots_qty_side($job_details_boots['tjob_id'],1,$i);
				                        if($qty_check==1 || $qty_check==0){	
        									$status_update['tjob_id'] = $job_details_boots['tjob_id'];
        									$status_update['update_date'] = date('Y-m-d');
        									$status_update['update_time'] = date('Y-m-d H:i:s');
        									$status_update['update_for']    = 3 ;
        									$status_update['update_status'] = 1 ;
        									$status_update['update_to'] = 'TOOLING Finished Side- 1 Qty -'.$i.' Working By '.$data['username'];
        									$status_update['update_by'] = get_user_id($data['username']); //MOBILE_APP_USER_ID;
        									$status_update['update_remarks'] = '';
        									$status_update['side'] = 1;
        									$status_update['qty'] = $i; 
        									 $status_update['update_from'] = 'mobile';
        									$job_status_update = $this->mobile->update_job_status_boots($status_update);  
				                        }
    									$mcdown_updates['job_id'] = $job_details_spcs['id'];
    									$mcdown_updates['updated_for'] = 6; 
    									$mcdown_updates['updated_to'] = 'Tooling Finished - Side(1/'.$job_details_spcs['side'].') - Qty('.$i.'/'.$job_details_spcs['qty'].') - '.$data['machine_name'];
    									$mcdown_updates['updated_by'] =   $data['username']; 
    									$mcdown_updates['updated_status'] = 2;
    									$mcdown_updates['updated_remark'] = '';
    									$mcdown_updates['qty_no']	= $i;
    									$mcdown_updates['qty_status']	= 1;
    									$mcdown_updates['mechine_status'] = 't2';
    									$mcdown_updates['mc_status'] = $data['mc_status'];
    									$mcdown_updates['side']	= 1;
    									$mcdown_updates['tot_side'] = $job_details_spcs['side'];			
    									mcdown_updates($mcdown_updates);
    									$ret_value = $update_tooling_timing;
    								}																					
							}else{
								    $ret_value = $this->multiple_last_side_qty_timing_update($i,1,$job_details_spcs,$data,$job_details_boots);
								}							
						}
					}
	    	    }else{
	    	        $q = 0;
					for($i=1;$i<=$data['qty'];$i++){
					$tool_time = $this->mobile->update_end_time_check($job_details_spcs['id'],$data['side'],$i);
					if($tool_time==0){   
    					$tooling_timing['tooling_end']	= date('Y-m-d H:i:s');
    					$tooling_timing['machine']	= $data['machine'];
    					$tooling_timing['current_qty']	= $i;
    					$tooling_timing['side']		= $data['side'];
    					$tooling_timing['user_id']	= get_user_id($data['username']);
    					$tooling_timing['order_id']	= $job_details_spcs['id'];
    					$tooling_timing['mc_status'] = $data['mc_status'];
    					$tooling_timing['shift_time'] = $this->shift_up_time;
    					$update_tooling_timing = $this->mobile->update_tooling_time($tooling_timing);
            			}else{
            			    $update_tooling_timing = $this->mobile->update_tooling_update_at($job_details_spcs['id'],$data['side'],$i,$this->shift_up_time);
            			}
						
				       $qty_check = $this->mobile->check_job_status_boots_qty_side($job_details_boots['tjob_id'],$data['side'],$i);
				       if($qty_check==1 || $qty_check==0){						
						// Update Tooling Complete Status
						$status_update['tjob_id'] = $job_details_boots['tjob_id'];
						$status_update['update_date'] = date('Y-m-d');
						$status_update['update_time'] = date('Y-m-d H:i:s');
						$status_update['update_for']    = 3 ;
						$status_update['update_status'] = 1 ;
						$status_update['update_to'] = 'TOOLING Finished Side- '.$data['side']. ' Qty -'.$i.' Working By '.$data['username'];
						$status_update['update_by'] =  get_user_id($data['username']); //MOBILE_APP_USER_ID;
						$status_update['side'] = $data['side'];
						$status_update['qty'] = $i;    						
						$status_update['update_remarks'] = '';
						 $status_update['update_from'] = 'mobile';
						$job_status_update = $this->mobile->update_job_status_boots($status_update);
				       }
						
						$mcdown_updates['job_id'] = $job_details_spcs['id'];
						$mcdown_updates['updated_for'] = 6; 
						$mcdown_updates['updated_to'] = 'Tooling Finished - Side('.$data['side'].'/'.$job_details_spcs['side'].') - Qty('.$i.'/'.$job_details_spcs['qty'].') - '.$data['machine_name'];
						$mcdown_updates['updated_by'] =   $data['username']; 
						$mcdown_updates['updated_status'] = 2;
						$mcdown_updates['updated_remark'] = '';
						$mcdown_updates['qty_no']	= $i;
						$mcdown_updates['qty_status']	= 1;
						$mcdown_updates['mechine_status'] = 't2';
						$mcdown_updates['mc_status'] = $data['mc_status'];
						$mcdown_updates['side']	= $data['side'];
						$mcdown_updates['tot_side'] = $job_details_spcs['side'];			
						mcdown_updates($mcdown_updates);
						$ret_value = $update_tooling_timing;
					}													
				}
				// Update Tooling Complete Status			    	        
				if($ret_value){
				    //$this->cron_run();
					echo json_encode(array('result' =>'success','message'=>'Tooling Finish Successfully updated.','job_code'=>$data['job_code']));
				}else{
					echo json_encode(array('result' =>'failure','message'=>'something went wrong.','job_code'=>$data['job_code']));
				}	    	        
    	    }
		}else{
    		if( ( $get_tooling_qty_state['state'] >= 1 ) ){
        			if( $get_tooling_qty_state['state'] >= 2 ){
        				echo json_encode(array('result' =>'failure','message'=>'Tooling already Finished','job_code'=>$data['job_code']));
        			}else{
        				echo json_encode(array('result' =>'failure','message'=>'Tooling Already started','job_code'=>$data['job_code']));
        			}
    	        } else {
				   if($data['qty'] == 1){     	
						$tooling_timing['tooling_start'] = date('Y-m-d H:i:s');
						$tooling_timing['machine']	= $data['machine'];
						$tooling_timing['side']		= $data['side'];
						$tooling_timing['current_qty']	= $data['qty'];
						$tooling_timing['user_id']	= get_user_id($data['username']);
						$tooling_timing['order_id']	= $job_details_spcs['id'];
						$tooling_timing['mc_status'] = $data['mc_status'];
						$insert_tooling_timing = $this->mobile->insert_tooling_time($tooling_timing);
						if($insert_tooling_timing){
							if( ( $data['side'] == 1 ) && ( $data['qty'] == 1 ) ){
								$update['tjob_tooling_status'] = 1 ;
								$update['tjob_tooling_lupdate'] = date('Y-m-d H:i:00');
								$job_update = $this->mobile->update_job_details_boots($update,$data['job_code']);
								if($job_update){
									$spcs_update['job_complete_status'] = 1;
									$spcs_update['setup_status']=2;
									$spcs_update['tooling_start'] = date('Y-m-d H:i:s');
									$job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']);
									// Update Tooling Complete Status
									$status_update['tjob_id'] = $job_details_boots['tjob_id'];
									$status_update['update_date'] = date('Y-m-d');
									$status_update['update_time'] = date('Y-m-d H:i:s');
									$status_update['update_for']    = 3 ;
									$status_update['update_status'] = 1 ;
									$status_update['update_to'] = 'TOOLING Side  - '.$data['side'].' Qty -'.$data['qty'].'Started  Working By '.$data['username'];
									$status_update['update_by'] = get_user_id($data['username']); //MOBILE_APP_USER_ID;
									 $status_update['update_from'] = 'mobile';
									$status_update['update_remarks'] = '';
            						$status_update['side'] = $data['side'];
            						$status_update['qty'] = $data['qty'];   									
									$job_status_update = $this->mobile->update_job_status_boots($status_update);
									
            						$update['job_color_status'] = 3;
            						$job_update = $this->mobile->update_job_details_boots($update,$data['job_code']);									
								}
							}else{
									$status_update['tjob_id'] = $job_details_boots['tjob_id'];
									$status_update['update_date'] = date('Y-m-d');
									$status_update['update_time'] = date('Y-m-d H:i:s');
									$status_update['update_for']    = 3 ;
									$status_update['update_status'] = 1 ;
									$status_update['update_to'] = 'TOOLING Started Side  - '.$data['side'].' Qty -'.$data['qty'].' Working By '.$data['username'];
									$status_update['update_by'] = get_user_id($data['username']); //MOBILE_APP_USER_ID;
									$status_update['update_remarks'] = '';
            						$status_update['side'] = $data['side'];
            						$status_update['qty'] = $data['qty'];  
            						 $status_update['update_from'] = 'mobile';
									$job_status_update = $this->mobile->update_job_status_boots($status_update);							    
							}
							$mcdown_updates['job_id'] = $job_details_spcs['id'];
							$mcdown_updates['updated_for'] = 5; 
							$mcdown_updates['updated_to'] = 'Tooling Started - Side('.$data['side'].'/'.$job_details_spcs['side'].') - Qty('.$data['qty'].'/'.$job_details_spcs['qty'].') - '.$data['machine_name'];
							$mcdown_updates['updated_by'] =   $data['username']; 
							$mcdown_updates['updated_status'] = 1;
							$mcdown_updates['updated_remark'] = '';
							$mcdown_updates['qty_no']	= $tooling['current_qty'];
							$mcdown_updates['qty_status']	= 1;
							$mcdown_updates['side']	= $data['side'];
							$mcdown_updates['mechine_status'] = 't1';
							$mcdown_updates['mc_status'] = $data['mc_status'];
							$mcdown_updates['tot_side'] = $job_details_spcs['side'];
							mcdown_updates($mcdown_updates);
							//$this->cron_run();
							echo json_encode(array('result' =>'success','message'=>'Tooling start updated','job_code'=>$data['job_code']));
						}else{
							echo json_encode(array('result' =>'failure','message'=>'something went wrong','job_code'=>$data['job_code']));
						}
					   }else{
						   if($data['side']==1){
							   $side_val = 1;
						   }elseif($data['side']==2){
							   $side_val = 2;
						   }else{
						       $side_val = $data['side'];
						   }
						$check_tooling_exist_or_not  = $this->mobile->check_tooling_front_completed_or_not($data['mc_status'],$tooling['order_id'],$side_val,1);
						if($check_tooling_exist_or_not!=0){
						   for($i=2;$i<=$data['qty'];$i++){
						       $qty_check = $this->mobile->qty_check($tooling['order_id'],$side_val,$i);
						       if($qty_check==0){
								$tooling_timing['tooling_start'] = date('Y-m-d H:i:s');
								$tooling_timing['machine']	= $data['machine'];
								$tooling_timing['side']		= $data['side'];
								$tooling_timing['current_qty']	= $i;
								$tooling_timing['user_id']	= get_user_id($data['username']);
								$tooling_timing['order_id']	= $job_details_spcs['id'];
								$tooling_timing['mc_status'] = $data['mc_status'];
								$insert_tooling_timing = $this->mobile->insert_tooling_time($tooling_timing);
								if($insert_tooling_timing){
									$mcdown_updates['job_id'] = $job_details_spcs['id'];
									$mcdown_updates['updated_for'] = 5; 
									$mcdown_updates['updated_to'] = 'Tooling Started - Side('.$data['side'].'/'.$job_details_spcs['side'].') - Qty('.$i.'/'.$job_details_spcs['qty'].') - '.$data['machine_name'];
									$mcdown_updates['updated_by'] =   $data['username']; 
									$mcdown_updates['updated_status'] = 1;
									$mcdown_updates['updated_remark'] = '';
									$mcdown_updates['qty_no']	= $i;
									$mcdown_updates['qty_status']	= 1;
									$mcdown_updates['side']	= $data['side'];
									$mcdown_updates['mechine_status'] = 't1';
									$mcdown_updates['mc_status'] = $data['mc_status'];
									$mcdown_updates['tot_side'] = $job_details_spcs['side'];
									mcdown_updates($mcdown_updates);
    								$status_update['tjob_id'] = $job_details_boots['tjob_id'];
    								$status_update['update_date'] = date('Y-m-d');
    								$status_update['update_time'] = date('Y-m-d H:i:s');
    								$status_update['update_for']    = 3 ;
    								$status_update['update_status'] = 1 ;
    								$status_update['update_to'] = 'TOOLING Started Side- '.$data['side'].' Qty -'.$i.' Working By '.$data['username'];
    								$status_update['update_by'] = get_user_id($data['username']); //MOBILE_APP_USER_ID;
    								$status_update['update_remarks'] = '';
            						$status_update['side'] = $data['side'];
            						$status_update['qty'] = $i; 
            						$status_update['update_from'] = 'mobile';
    								$job_status_update = $this->mobile->update_job_status_boots($status_update);									
								    }
						         }
							  }
        						if($insert_tooling_timing){
        						    //$this->cron_run();
        							echo json_encode(array('result' =>'success','message'=>'Tooling start updated','job_code'=>$data['job_code']));
        						}else{
        							echo json_encode(array('result' =>'failure','message'=>'something went wrong','job_code'=>$data['job_code']));
        						} 							  
							}else{
								echo json_encode(array('result' =>'failure','message'=>'First qty is Not yet started','job_code'=>$data['job_code']));
							}						
						}
					}
				}
			}elseif($get_setup_state['state'] == 1){
				echo json_encode(array('result' =>'failure','message'=>'Job Setup not finished.'));            
			}else{
				echo json_encode(array('result' =>'failure','message'=>'Job Setup not started.'));
			}         
		}*/
		
 public function tooling(){
	 
	 
    $machine = $this->mobile->get_machine_id($this->input->get('machine_name'));	
	$wims_hold_jobs = 0;
	$wims_hold_jobs = $this->wims_hold_jobs($this->input->get('job_code'));
	if($wims_hold_jobs==1){
	    echo  json_encode(array('result' =>'failure','message' => 'job is HOLD in wims so UNHOLD the job after that you can continue..'));
		exit;
	}	
    if($this->input->get('toolingstatus')=='ts'){
        $this->autoprevjob_tooling_finish($this->input->get('job_code'));
    }
    
    if($this->input->get('toolingstatus')=='ts' || $this->input->get('toolingstatus')=='tf'){
        $this->same_job_tooling_finish($this->input->get('job_code')); 
    }    
    
    $data['job_code']      = $this->input->get('job_code');
    $data['status']        = $this->input->get('status');
    $data['username']      = $this->input->get('username');
    $data['qty']           = $this->input->get('qty');
    $data['machine_name']  = $this->input->get('machine_name');
    $data['mc_status']     = $this->input->get('toolingstatus');
    $data['machine']       = $this->mobile->get_machine_id($this->input->get('machine_name'));
    $data['side']          = $this->input->get('side');
    $explode_down           = explode("[",$data['job_code']);
    $job_details_boots     = $this->mobile->get_job_details_boots($explode_down[0]);
    $job_details_spcs      = $this->mobile->get_job_details($data['job_code']);
    $tooling['machine']     = $data['machine'];
    $tooling['order_id']    = $job_details_spcs['id'];
    $tooling['side']	    = $data['side'];
    $tooling['current_qty'] = $data['qty'];
    //echo "<pre>"; print_r($tooling);
    $get_setup_state = $this->mobile->get_setup_state($tooling);
    if($get_setup_state['state'] >= 2){
    	$get_tooling_qty_state  = $this->mobile->get_tooling_qty_state($tooling);
    	//echo "<pre>"; print_r($get_tooling_qty_state);
    	if($data['status'] ==2){
    		if( ( $get_tooling_qty_state['state'] >= 2 ) || ( $get_tooling_qty_state['state'] == 0 ) ){
    		     
    			if( $get_tooling_qty_state['state'] >= 2 ){
    				echo json_encode(array('result' =>'failure','message'=>'Tooling already finished11','job_code'=>$data['job_code']));
    			}else{
                /*************** CHECK TOOLING FIRST SIDE FIRST QTY ***************/
                $side_with_first_qty = $this->mobile->tooling_side_with_qty($job_details_spcs['id'],$data['side'],1);
                if($side_with_first_qty==0){
    				echo json_encode(array('result' =>'failure','message'=>'First Tooling Not yet started','job_code'=>$data['job_code']));
    				exit;                    
                }
                /*************** CHECK TOOLING FIRST SIDE FIRST QTY ***************/
            	 for($i=1;$i<=$data['qty'];$i++){
            		$tooling_start_and_end_time = $this->mobile->tooling_start_and_end_time($job_details_spcs['id'],$data['side'],$i);


            		
            		if($tooling_start_and_end_time=='not_tooling_end'){
            		    
            			$tooling_timing['tooling_end'] = date('Y-m-d H:i:s');
            			$tooling_timing['machine']	= $data['machine'];
            			$tooling_timing['side']		= $data['side'];
            			$tooling_timing['current_qty']	= $i;
            			$tooling_timing['user_id']	= get_user_id($data['username']);
            			$tooling_timing['order_id']	= $job_details_spcs['id'];
            			$tooling_timing['mc_status'] = $data['mc_status'];
            			$tooling_timing['job_code'] = $explode_down[0];
            			$modify_tooling_timing = $this->mobile->update_tooling_time($tooling_timing);
            			$this->mcdown_updates_basedon_qty($job_details_spcs,$data['side'],$i,$data,'t2',$data['mc_status']);
            			
                  		// update tooling finish in boots
                		$qty_check = $this->mobile->check_job_status_boots_qty_side($job_details_boots['tjob_id'],$data['side'],$i);
                		
                        if($qty_check==1 || $qty_check==0){    		
                    		$status_update['tjob_id'] = $job_details_boots['tjob_id'];
                    		$status_update['update_date'] = date('Y-m-d');
                    		$status_update['update_time'] = date('Y-m-d H:i:s');
                    		$status_update['update_for']    = 3 ;
                    		$status_update['update_status'] = 1 ;
                    		$status_update['update_to'] = 'Tooling Finished  Side - '.$data['side'].' Qty -'.$i. ' - Completed By '.$data['username'];
                    		$status_update['update_by'] = get_user_id($data['username']);
							$status_update['update_remarks'] = '';
    						$status_update['side'] = $data['side'];
    						$status_update['qty'] = $i;                      		
                    		 $status_update['update_from'] = 'mobile';
                    		$job_status_update = $this->mobile->update_job_status_boots($status_update);			
                        }            			
            		}elseif($tooling_start_and_end_time=='not_tooling_start_and_end'){
            			/************ INSERT DATA FOR TOOLING START ************/
            			$tooling_timing['tooling_start'] = date('Y-m-d H:i:s');
            			$tooling_timing['machine']	= $data['machine'];
            			$tooling_timing['side']		= $data['side'];
            			$tooling_timing['current_qty']	= $i;
            			$tooling_timing['user_id']	= get_user_id($data['username']);
            			$tooling_timing['order_id']	= $job_details_spcs['id'];
            			$tooling_timing['mc_status'] = 'ts';
            			$modify_tooling_timing = $this->mobile->insert_tooling_time($tooling_timing);
            			$this->mcdown_updates_basedon_qty($job_details_spcs,$data['side'],$i,$data,'t1','ts');
            			
            			
							$status_update['tjob_id'] = $job_details_boots['tjob_id'];
							$status_update['update_date'] = date('Y-m-d');
							$status_update['update_time'] = date('Y-m-d H:i:s');
							$status_update['update_for']    = 3 ;
							$status_update['update_status'] = 1 ;
							$status_update['update_to'] = 'TOOLING Started Side  - '.$data['side'].' Qty -'.$i.' Working By '.$data['username'];
							$status_update['update_by'] = get_user_id($data['username']); //MOBILE_APP_USER_ID;
							$status_update['update_remarks'] = '';
    						$status_update['side'] = $data['side'];
    						$status_update['qty'] = $i;  
    						$status_update['update_from'] = 'mobile';
							$job_status_update = $this->mobile->update_job_status_boots($status_update);
									
									
            			/************ INSERT DATA FOR TOOLING END ************/
            			$tooling_timing['tooling_end'] = date('Y-m-d H:i:s');
            			$tooling_timing['machine']	= $data['machine'];
            			$tooling_timing['side']		= $data['side'];
            			$tooling_timing['current_qty']	= $i;
            			$tooling_timing['user_id']	= get_user_id($data['username']);
            			$tooling_timing['order_id']	= $job_details_spcs['id'];
            			$tooling_timing['mc_status'] = 'tf';
            			$tooling_timing['job_code'] = $explode_down[0];
            			$modify_tooling_timing = $this->mobile->update_tooling_time($tooling_timing);
            			$this->mcdown_updates_basedon_qty($job_details_spcs,$data['side'],$i,$data,'t2','tf');
                 		// update tooling finish in boots
                		$qty_check = $this->mobile->check_job_status_boots_qty_side($job_details_boots['tjob_id'],$data['side'],$i);
                        if($qty_check==1 || $qty_check==0){    		
                    		$status_update['tjob_id'] = $job_details_boots['tjob_id'];
                    		$status_update['update_date'] = date('Y-m-d');
                    		$status_update['update_time'] = date('Y-m-d H:i:s');
                    		$status_update['update_for']    = 3 ;
                    		$status_update['update_status'] = 1 ;
                    		$status_update['update_to'] = 'Tooling Finished  Side - '.$data['side'].' Qty -'.$i. ' - Completed By '.$data['username'];
                    		$status_update['update_by'] = get_user_id($data['username']);
							$status_update['update_remarks'] = '';
    						$status_update['side'] = $data['side'];
    						$status_update['qty'] = $i;                      		
                    		$status_update['update_from'] = 'mobile';
                    		$job_status_update = $this->mobile->update_job_status_boots($status_update);			
                        }             			
            		}
                    $spcs_update['setup_status']=2;
     				$job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']); 
            		if($job_details_spcs['side']==$data['side'] && $job_details_spcs['qty'] == $i){

    					$spcs_update['tooling_end'] = date('Y-m-d H:i:s');
    					$spcs_update['time_to']=date('H:i:00');
    					$spcs_update['job_complete_status'] = 2;
    					$spcs_update['task'] = 1;

    					$job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']);
    					$samejob_update['job_complete_status'] = 2;
    					$samejob_update['task'] = 1;
    					$samejob_job_status_update = $this->mobile->update_jobstatus_samejob($samejob_update,$data['job_code']);
    					
                        $tooling_totaltime = $this->mobile->get_totaltooling_time($explode_down[0],$data['machine'],$job_details_spcs['side'],$job_details_spcs['qty']);
						$update['machine_time_hr']  = $tooling_totaltime['hour'];
						$update['machine_time_min'] = $tooling_totaltime['min'];

						$update['tjob_tooling_lupdate'] = $tooling_timing['tooling_end'];
						$job_update = $this->mobile->update_job_details_boots($update,$explode_down[0]);
            		}
            		
            	}
        		if($modify_tooling_timing){
        			echo json_encode(array('result' =>'success','message'=>'Tooling Finish Successfully updated.','job_code'=>$data['job_code']));
        		}
        		exit;
					//echo json_encode(array('result' =>'success','message'=>'First Tooling Not yet started111','job_code'=>$data['job_code']));
    	        }
			}else{
    	        if( ( $data['qty'] == $job_details_spcs['qty'] ) && ( $data['side'] == $job_details_spcs['side'] ) ){
				if($job_details_spcs['side']>2){
					for($s=1;$s<=$job_details_spcs['side'];$s++){
						if($s!=$job_details_spcs['side']){  /*without last side*/
							for($i=1;$i<=$job_details_spcs['qty'];$i++){
								$check_multiple_side_completed_or_not  = $this->mobile->check_tooling_front_completed_or_not($data['mc_status'],$data['mc_status'],$tooling['order_id'],$s,$i);	
									if($check_multiple_side_completed_or_not==0){
										$ret_value = $this->before_last_side_with_timing_update($i,$s,$data,$job_details_spcs,$job_details_boots,$explode_down[0]);										
									}										
								}
							}else{  /*with last side*/								
								for($i=1;$i<=$job_details_spcs['qty'];$i++){
								   
									if($job_details_spcs['qty'] == $i){	
										$ret_value = $this->multiple_last_side_qty_timing_update($i,$s,$job_details_spcs,$data,$job_details_boots,$explode_down[0]);																			
									}else{	
										$ret_value = $this->multiple_side_qty_timing_update($i,$s,$data,$job_details_spcs,$job_details_boots,$explode_down[0]);																				
									}																		
								}								
							}
						}
					}elseif($job_details_spcs['side']==2){			
						for($s=1;$s<=$job_details_spcs['side'];$s++){
							if($s!=$job_details_spcs['side']){  /*without last side*/							
								for($i=1;$i<=$job_details_spcs['qty'];$i++){																			
									$check_tooling_exist_or_not  = $this->mobile->check_tooling_front_completed_or_not($data['mc_status'],$tooling['order_id'],$s,$i);								
									if($check_tooling_exist_or_not==0){																
										if($i != $job_details_spcs['qty']){									
											
											$tool_time = $this->mobile->update_end_time_check($job_details_spcs['id'],$s,$i);
											if($tool_time==0){
    											$tooling_timing['tooling_end']	= date('Y-m-d H:i:s');
    											$tooling_timing['machine']	= $data['machine'];
    											$tooling_timing['current_qty']	= $i;
    											$tooling_timing['side']		= $s;
    											$tooling_timing['user_id']	= get_user_id($data['username']);
    											$tooling_timing['order_id']	= $job_details_spcs['id'];
    											$tooling_timing['mc_status'] = $data['mc_status'];
    											$tooling_timing['shift_time'] = $this->shift_up_time;
    											$tooling_timing['job_code'] = $explode_down[0];
    											$update_tooling_timing = $this->mobile->update_tooling_time($tooling_timing);
                                    			}else{
                                    			    
                                    			    $update_tooling_timing = $this->mobile->update_tooling_update_at($job_details_spcs['id'],$s,$i,$this->shift_up_time);
                                    			}
												
											$qty_check = $this->mobile->check_job_status_boots_qty_side($job_details_boots['tjob_id'],$s,$i);
				                            if($qty_check==1 || $qty_check==0){	
            									// Update Tooling Complete Status
            									$status_update['tjob_id'] = $job_details_boots['tjob_id'];
            									$status_update['update_date'] = date('Y-m-d');
            									$status_update['update_time'] = date('Y-m-d H:i:s');
            									$status_update['update_for']    = 3 ;
            									$status_update['update_status'] = 1 ;
            									$status_update['update_to'] = 'TOOLING Finished Side- '.$s.' Qty -'.$i.' Working By '.$data['username'];
            									$status_update['update_by'] = get_user_id($data['username']); //MOBILE_APP_USER_ID;
            									$status_update['side'] = $s;
            									$status_update['qty'] = $i;
            									$status_update['update_remarks'] = '';
            									 $status_update['update_from'] = 'mobile';
            									$job_status_update = $this->mobile->update_job_status_boots($status_update);												
				                            }	
												
												$mcdown_updates['job_id'] = $job_details_spcs['id'];
												$mcdown_updates['updated_for'] = 6; 
												$mcdown_updates['updated_to'] = 'Tooling Finished - Side('.$s.'/'.$job_details_spcs['side'].') - Qty('.$i.'/'.$job_details_spcs['qty'].') - '.$data['machine_name'];
												$mcdown_updates['updated_by'] =   $data['username']; 
												$mcdown_updates['updated_status'] = 2;
												$mcdown_updates['updated_remark'] = '';
												$mcdown_updates['qty_no']	= $i;
												$mcdown_updates['qty_status']	= 1;
												$mcdown_updates['mechine_status'] = 't2';
												$mcdown_updates['mc_status'] = $data['mc_status'];
												$mcdown_updates['side']	= $s;
												$mcdown_updates['tot_side'] = $job_details_spcs['side'];			
												mcdown_updates($mcdown_updates);
												$ret_value = $update_tooling_timing;
										}									
									}																		
								}
							}else{
								for($i=1;$i<=$job_details_spcs['qty'];$i++){																		
									if($job_details_spcs['qty'] == $i){	
										$ret_value = $this->multiple_last_side_qty_timing_update($i,$s,$job_details_spcs,$data,$job_details_boots,$explode_down[0]);	
									}else{										
										$ret_value = $this->multiple_side_qty_timing_update($i,$s,$data,$job_details_spcs,$job_details_boots,$explode_down[0]);																				
									}																		
								}
									
							}
						}
				}else{
					for($i=1;$i<=$job_details_spcs['qty'];$i++){																		
						$check_tooling_exist_or_not  = $this->mobile->check_tooling_front_completed_or_not($data['mc_status'],$tooling['order_id'],1,$i);	
						if($i != $job_details_spcs['qty']){	
    						if($check_tooling_exist_or_not==0){
    								$tool_time = $this->mobile->update_end_time_check($job_details_spcs['id'],1,$i);
									if($tool_time==0){
        								$tooling_timing['tooling_end']	= date('Y-m-d H:i:s');
        								$tooling_timing['machine']	= $data['machine'];
        								$tooling_timing['current_qty']	= $i;
        								$tooling_timing['side']		= 1;
        								$tooling_timing['user_id']	= get_user_id($data['username']);
        								$tooling_timing['order_id']	= $job_details_spcs['id'];
        								$tooling_timing['mc_status'] = $data['mc_status'];
        								$tooling_timing['shift_time'] = $this->shift_up_time;
        								$tooling_timing['job_code'] = $explode_down[0];
        								$update_tooling_timing = $this->mobile->update_tooling_time($tooling_timing);
                            			}else{
                            			    $update_tooling_timing = $this->mobile->update_tooling_update_at($job_details_spcs['id'],1,$i,$this->shift_up_time);
                            			}
    									// Update Tooling Complete Status
    									$qty_check = $this->mobile->check_job_status_boots_qty_side($job_details_boots['tjob_id'],1,$i);
				                        if($qty_check==1 || $qty_check==0){	
        									$status_update['tjob_id'] = $job_details_boots['tjob_id'];
        									$status_update['update_date'] = date('Y-m-d');
        									$status_update['update_time'] = date('Y-m-d H:i:s');
        									$status_update['update_for']    = 3 ;
        									$status_update['update_status'] = 1 ;
        									$status_update['update_to'] = 'TOOLING Finished Side- 1 Qty -'.$i.' Working By '.$data['username'];
        									$status_update['update_by'] = get_user_id($data['username']); //MOBILE_APP_USER_ID;
        									$status_update['update_remarks'] = '';
        									$status_update['side'] = 1;
        									$status_update['qty'] = $i; 
        									$status_update['update_from'] = 'mobile';
        									$job_status_update = $this->mobile->update_job_status_boots($status_update);  
				                        }
    									$mcdown_updates['job_id'] = $job_details_spcs['id'];
    									$mcdown_updates['updated_for'] = 6; 
    									$mcdown_updates['updated_to'] = 'Tooling Finished - Side(1/'.$job_details_spcs['side'].') - Qty('.$i.'/'.$job_details_spcs['qty'].') - '.$data['machine_name'];
    									$mcdown_updates['updated_by'] =   $data['username']; 
    									$mcdown_updates['updated_status'] = 2;
    									$mcdown_updates['updated_remark'] = '';
    									$mcdown_updates['qty_no']	= $i;
    									$mcdown_updates['qty_status']	= 1;
    									$mcdown_updates['mechine_status'] = 't2';
    									$mcdown_updates['mc_status'] = $data['mc_status'];
    									$mcdown_updates['side']	= 1;
    									$mcdown_updates['tot_side'] = $job_details_spcs['side'];			
    									mcdown_updates($mcdown_updates);
    									$ret_value = $update_tooling_timing;
    								}																					
							}else{
								    $ret_value = $this->multiple_last_side_qty_timing_update($i,1,$job_details_spcs,$data,$job_details_boots,$explode_down[0]);
								}							
						}
					}
	    	    }else{
	    	        $q = 0;
					for($i=1;$i<=$data['qty'];$i++){
					$tool_time = $this->mobile->update_end_time_check($job_details_spcs['id'],$data['side'],$i);
					if($tool_time==0){   
    					$tooling_timing['tooling_end']	= date('Y-m-d H:i:s');
    					$tooling_timing['machine']	= $data['machine'];
    					$tooling_timing['current_qty']	= $i;
    					$tooling_timing['side']		= $data['side'];
    					$tooling_timing['user_id']	= get_user_id($data['username']);
    					$tooling_timing['order_id']	= $job_details_spcs['id'];
    					$tooling_timing['mc_status'] = $data['mc_status'];
    					$tooling_timing['shift_time'] = $this->shift_up_time;
    					$tooling_timing['job_code'] = $explode_down[0];
    					$update_tooling_timing = $this->mobile->update_tooling_time($tooling_timing);
            			}else{
            			    $update_tooling_timing = $this->mobile->update_tooling_update_at($job_details_spcs['id'],$data['side'],$i,$this->shift_up_time);
            			}
						
				       $qty_check = $this->mobile->check_job_status_boots_qty_side($job_details_boots['tjob_id'],$data['side'],$i);
				       if($qty_check==1 || $qty_check==0){						
						// Update Tooling Complete Status
						$status_update['tjob_id'] = $job_details_boots['tjob_id'];
						$status_update['update_date'] = date('Y-m-d');
						$status_update['update_time'] = date('Y-m-d H:i:s');
						$status_update['update_for']    = 3 ;
						$status_update['update_status'] = 1 ;
						$status_update['update_to'] = 'TOOLING Finished Side- '.$data['side']. ' Qty -'.$i.' Working By '.$data['username'];
						$status_update['update_by'] =  get_user_id($data['username']); //MOBILE_APP_USER_ID;
						$status_update['side'] = $data['side'];
						$status_update['qty'] = $i;    						
						$status_update['update_remarks'] = '';
						 $status_update['update_from'] = 'mobile';
						$job_status_update = $this->mobile->update_job_status_boots($status_update);
				       }
						
						$mcdown_updates['job_id'] = $job_details_spcs['id'];
						$mcdown_updates['updated_for'] = 6; 
						$mcdown_updates['updated_to'] = 'Tooling Finished - Side('.$data['side'].'/'.$job_details_spcs['side'].') - Qty('.$i.'/'.$job_details_spcs['qty'].') - '.$data['machine_name'];
						$mcdown_updates['updated_by'] =   $data['username']; 
						$mcdown_updates['updated_status'] = 2;
						$mcdown_updates['updated_remark'] = '';
						$mcdown_updates['qty_no']	= $i;
						$mcdown_updates['qty_status']	= 1;
						$mcdown_updates['mechine_status'] = 't2';
						$mcdown_updates['mc_status'] = $data['mc_status'];
						$mcdown_updates['side']	= $data['side'];
						$mcdown_updates['tot_side'] = $job_details_spcs['side'];			
						mcdown_updates($mcdown_updates);
						$ret_value = $update_tooling_timing;
					}													
				}
				// Update Tooling Complete Status			    	        
				if($ret_value){
				    //$this->cron_run();
					echo json_encode(array('result' =>'success','message'=>'Tooling Finish Successfully Updated.','job_code'=>$data['job_code']));
				}else{
					echo json_encode(array('result' =>'failure','message'=>'something went wrong.','job_code'=>$data['job_code']));
				}	    	        
    	    }
		}else{
		    
		    if($job_details_spcs['share_status']==1){
		        $data['qty'] = 1;
		        $data['side'] = 1;
		    }
    		if( ( $get_tooling_qty_state['state'] >= 1 ) ){
        			if( $get_tooling_qty_state['state'] >= 2 ){
        				echo json_encode(array('result' =>'failure','message'=>'Tooling already Finished22','job_code'=>$data['job_code']));
        			}else{
        				echo json_encode(array('result' =>'failure','message'=>'Tooling Already started','job_code'=>$data['job_code']));
        			}
    	        } else {
				   if($data['qty'] == 1){     	
						$tooling_timing['tooling_start'] = date('Y-m-d H:i:s');
						$tooling_timing['machine']	= $data['machine'];
						$tooling_timing['side']		= $data['side'];
						$tooling_timing['current_qty']	= $data['qty'];
						$tooling_timing['user_id']	= get_user_id($data['username']);
						$tooling_timing['order_id']	= $job_details_spcs['id'];
						$tooling_timing['mc_status'] = $data['mc_status'];
						$insert_tooling_timing = $this->mobile->insert_tooling_time($tooling_timing);
						if($insert_tooling_timing){
							if( ( $data['side'] == 1 ) && ( $data['qty'] == 1 ) ){
								$update['tjob_tooling_status'] = 1 ;
								$update['tjob_tooling_lupdate'] = date('Y-m-d H:i:00');
								$job_update = $this->mobile->update_job_details_boots($update,$explode_down[0]);
								if($job_update){
									$spcs_update['job_complete_status'] = 1;
									$spcs_update['setup_status']=2;
									$spcs_update['tooling_start'] = date('Y-m-d H:i:s');
									$job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']);
									// Update Tooling Complete Status
									$status_update['tjob_id'] = $job_details_boots['tjob_id'];
									$status_update['update_date'] = date('Y-m-d');
									$status_update['update_time'] = date('Y-m-d H:i:s');
									$status_update['update_for']    = 3 ;
									$status_update['update_status'] = 1 ;
									$status_update['update_to'] = 'TOOLING Side  - '.$data['side'].' Qty -'.$data['qty'].'Started  Working By '.$data['username'];
									$status_update['update_by'] = get_user_id($data['username']); //MOBILE_APP_USER_ID;
									 $status_update['update_from'] = 'mobile';
									$status_update['update_remarks'] = '';
            						$status_update['side'] = $data['side'];
            						$status_update['qty'] = $data['qty'];   									
									$job_status_update = $this->mobile->update_job_status_boots($status_update);
									
            						$update['job_color_status'] = 3;
            						$job_update = $this->mobile->update_job_details_boots($update,$explode_down[0]);									
								}
							}else{
									$status_update['tjob_id'] = $job_details_boots['tjob_id'];
									$status_update['update_date'] = date('Y-m-d');
									$status_update['update_time'] = date('Y-m-d H:i:s');
									$status_update['update_for']    = 3 ;
									$status_update['update_status'] = 1 ;
									$status_update['update_to'] = 'TOOLING Started Side  - '.$data['side'].' Qty -'.$data['qty'].' Working By '.$data['username'];
									$status_update['update_by'] = get_user_id($data['username']); //MOBILE_APP_USER_ID;
									$status_update['update_remarks'] = '';
            						$status_update['side'] = $data['side'];
            						$status_update['qty'] = $data['qty'];  
            						$status_update['update_from'] = 'mobile';
									$job_status_update = $this->mobile->update_job_status_boots($status_update);							    
							}
							$mcdown_updates['job_id'] = $job_details_spcs['id'];
							$mcdown_updates['updated_for'] = 5; 
							$mcdown_updates['updated_to'] = 'Tooling Started - Side('.$data['side'].'/'.$job_details_spcs['side'].') - Qty('.$data['qty'].'/'.$job_details_spcs['qty'].') - '.$data['machine_name'];
							$mcdown_updates['updated_by'] =   $data['username']; 
							$mcdown_updates['updated_status'] = 1;
							$mcdown_updates['updated_remark'] = '';
							$mcdown_updates['qty_no']	= $tooling['current_qty'];
							$mcdown_updates['qty_status']	= 1;
							$mcdown_updates['side']	= $data['side'];
							$mcdown_updates['mechine_status'] = 't1';
							$mcdown_updates['mc_status'] = $data['mc_status'];
							$mcdown_updates['tot_side'] = $job_details_spcs['side'];
							mcdown_updates($mcdown_updates);
							//$this->cron_run();
							echo json_encode(array('result' =>'success','message'=>'This order tooling Start updated successfully','job_code'=>$data['job_code']));
						}else{
							echo json_encode(array('result' =>'failure','message'=>'something went wrong','job_code'=>$data['job_code']));
						}
					   }else{
						   if($data['side']==1){
							   $side_val = 1;
						   }elseif($data['side']==2){
							   $side_val = 2;
						   }else{
						       $side_val = $data['side'];
						   }
						$check_tooling_exist_or_not  = $this->mobile->check_tooling_front_completed_or_not($data['mc_status'],$tooling['order_id'],$side_val,1);
						if($check_tooling_exist_or_not!=0){
						   for($i=2;$i<=$data['qty'];$i++){
						       $qty_check = $this->mobile->qty_check($tooling['order_id'],$side_val,$i);
						       if($qty_check==0){
								$tooling_timing['tooling_start'] = date('Y-m-d H:i:s');
								$tooling_timing['machine']	= $data['machine'];
								$tooling_timing['side']		= $data['side'];
								$tooling_timing['current_qty']	= $i;
								$tooling_timing['user_id']	= get_user_id($data['username']);
								$tooling_timing['order_id']	= $job_details_spcs['id'];
								$tooling_timing['mc_status'] = $data['mc_status'];
								$insert_tooling_timing = $this->mobile->insert_tooling_time($tooling_timing);
								if($insert_tooling_timing){
									$mcdown_updates['job_id'] = $job_details_spcs['id'];
									$mcdown_updates['updated_for'] = 5; 
									$mcdown_updates['updated_to'] = 'Tooling Started - Side('.$data['side'].'/'.$job_details_spcs['side'].') - Qty('.$i.'/'.$job_details_spcs['qty'].') - '.$data['machine_name'];
									$mcdown_updates['updated_by'] =   $data['username']; 
									$mcdown_updates['updated_status'] = 1;
									$mcdown_updates['updated_remark'] = '';
									$mcdown_updates['qty_no']	= $i;
									$mcdown_updates['qty_status']	= 1;
									$mcdown_updates['side']	= $data['side'];
									$mcdown_updates['mechine_status'] = 't1';
									$mcdown_updates['mc_status'] = $data['mc_status'];
									$mcdown_updates['tot_side'] = $job_details_spcs['side'];
									mcdown_updates($mcdown_updates);
    								$status_update['tjob_id'] = $job_details_boots['tjob_id'];
    								$status_update['update_date'] = date('Y-m-d');
    								$status_update['update_time'] = date('Y-m-d H:i:s');
    								$status_update['update_for']    = 3 ;
    								$status_update['update_status'] = 1 ;
    								$status_update['update_to'] = 'TOOLING Started Side- '.$data['side'].' Qty -'.$i.' Working By '.$data['username'];
    								$status_update['update_by'] = get_user_id($data['username']); //MOBILE_APP_USER_ID;
    								$status_update['update_remarks'] = '';
            						$status_update['side'] = $data['side'];
            						$status_update['qty'] = $i; 
            						$status_update['update_from'] = 'mobile';
    								$job_status_update = $this->mobile->update_job_status_boots($status_update);									
								    }
						         }
							  }
        						if($insert_tooling_timing){
        						    //$this->cron_run();
        							echo json_encode(array('result' =>'success','message'=>'Tooling start updated','job_code'=>$data['job_code']));
        						}else{
        							echo json_encode(array('result' =>'failure','message'=>'something went wrong','job_code'=>$data['job_code']));
        						} 							  
							}else{
								echo json_encode(array('result' =>'failure','message'=>'First qty is Not yet started','job_code'=>$data['job_code']));
							}						
						}
					}
				}
			}elseif($get_setup_state['state'] == 1){
				echo json_encode(array('result' =>'failure','message'=>'Job Setup not finished.'));            
			}else{
				echo json_encode(array('result' =>'failure','message'=>'Job Setup not started.'));
			}         
		}		
/* public function tooling1(){
    $data['job_code']      = $this->input->get('job_code');
    $data['status']        = $this->input->get('status');
    $data['username']      = $this->input->get('username');
    $data['qty']           = $this->input->get('qty');
    $data['machine_name']  = $this->input->get('machine_name');
    $data['mc_status']      = $this->input->get('toolingstatus');
    $data['machine']       = $this->mobile->get_machine_id($this->input->get('machine_name'));
    $data['side']          = $this->input->get('side');
    $job_details_boots     = $this->mobile->get_job_details_boots($data['job_code']);
    $job_details_spcs      = $this->mobile->get_job_details($data['job_code']);
    
    $tooling['machine']     = $data['machine'];
    $tooling['order_id']    = $job_details_spcs['id'];
    $tooling['side']	    = $data['side'];
    $tooling['current_qty'] = $data['qty'];
    $get_setup_state = $this->mobile->get_setup_state($tooling);
    if($get_setup_state['state'] >= 2){
    	$get_tooling_qty_state  = $this->mobile->get_tooling_qty_state($tooling);
    	if($data['status'] ==2){
    		if( ( $get_tooling_qty_state['state'] >= 2 ) || ( $get_tooling_qty_state['state'] == 0 ) ){
    			if( $get_tooling_qty_state['state'] >= 2 ){
    				echo json_encode(array('result' =>'success','message'=>'Tooling already finished','job_code'=>$data['job_code']));
    			}else{
    				echo json_encode(array('result' =>'success','message'=>'Tooling Not yet started','job_code'=>$data['job_code']));
    			} 
    	        }else{
    	        	//  update tooling finish in sfcs tooling times
				$tool_time = $this->mobile->update_end_time_check($job_details_spcs['id'],$data['side'],$data['qty']);
				if($tool_time==0){    	        	
            	    $tooling_timing['tooling_end']	= date('Y-m-d H:i:00');
        			$tooling_timing['machine']	= $data['machine'];
        			$tooling_timing['current_qty']	= $data['qty'];
        			$tooling_timing['side']		= $data['side'];
        			$tooling_timing['user_id']	= get_user_id($data['username']);
        			$tooling_timing['order_id']	= $job_details_spcs['id'];
        			$tooling_timing['shift_time'] = $this->shift_up_time;
        			$update_tooling_timing = $this->mobile->update_tooling_time($tooling_timing);
        			}else{
        			    $update_tooling_timing = $this->mobile->update_tooling_update_at($job_details_spcs['id'],$data['side'],$data['qty'],$this->shift_up_time);
        			}
        			
    	        if( ( $data['qty'] == $job_details_spcs['qty'] ) && ( $data['side'] == $job_details_spcs['side'] ) ){
    	        // update tooling finish in sfcs
    	        $spcs_update['tooling_end'] = date('Y-m-d H:i:00');
				$spcs_update['time_to']=date('H:i:00');
				$spcs_update['job_complete_status'] = 2;
				$spcs_update['setup_status']=2;
				$job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']);
    	        		// update tooling finish in boots
				$status_update['tjob_id'] = $job_details_boots['tjob_id'];
				$status_update['update_date'] = date('Y-m-d');
				$status_update['update_time'] = date('Y-m-d H:i:00');
				$status_update['update_for']    = 3 ;
				$status_update['update_status'] = 1 ;
				$status_update['update_to'] = 'TOOLING - Completed By '.$data['username'];
				$status_update['update_by'] = get_user_id($data['username']); //MOBILE_APP_USER_ID; 
				 $status_update['update_from'] = 'mobile';
				$job_status_update = $this->mobile->update_job_status_boots($status_update);
				
				// Machine Time Update Status
				$tooling_totaltime = $this->mobile->get_totaltooling_time($job_details_spcs['id'],$data['machine'],$job_details_spcs['side'],$job_details_spcs['qty']);
				
				$update['machine_time_hr']  = $tooling_totaltime['hour'];
				$update['machine_time_min'] = $tooling_totaltime['min'];
				//$update['tjob_tooling_status'] = 2 ;
				$update['tjob_tooling_lupdate'] = date('Y-m-d H:i:00');
				$update['job_color_status'] = 2;
				$job_update = $this->mobile->update_job_details_boots($update,$data['job_code']);
				
				
				$status_update['tjob_id'] = $job_details_boots['tjob_id'];
				$status_update['update_date'] = date('Y-m-d');
				$status_update['update_time'] = date('Y-m-d H:i:00');
				$status_update['update_for']    = 3 ;
				$status_update['update_status'] = 1 ;
				$status_update['update_to'] = 'Machine time Updated - '.$tooling_totaltime['hour'].':'.$tooling_totaltime['min'];
				$status_update['update_by'] = get_user_id($data['username']); //MOBILE_APP_USER_ID;
				 $status_update['update_from'] = 'mobile';
				$job_status_update = $this->mobile->update_job_status_boots($status_update); 
	    	  }
	    	        // Update Tooling Complete Status
	    	        
	    	$mcdown_updates['job_id'] = $job_details_spcs['id'];
			$mcdown_updates['updated_for'] = 6; 
			$mcdown_updates['updated_to'] = 'Tooling Finished - Side('.$data['side'].'/'.$job_details_spcs['side'].') - Qty('.$data['qty'].'/'.$job_details_spcs['qty'].') - '.$data['machine_name'];
			$mcdown_updates['updated_by'] =   $data['username']; 
			$mcdown_updates['updated_status'] = 2;
			$mcdown_updates['updated_remark'] = '';
			$mcdown_updates['qty_no']	= $tooling['current_qty'];
			$mcdown_updates['qty_status']	= 1;
			$mcdown_updates['mechine_status'] = 't2';
			$mcdown_updates['mc_status'] = $data['mc_status'];
			$mcdown_updates['side']	= $data['side'];
			$mcdown_updates['tot_side'] = $job_details_spcs['side'];
			
			mcdown_updates($mcdown_updates);
			
	    	        
			if($update_tooling_timing){
				echo json_encode(array('result' =>'success','message'=>'Tooling Finish Successfully updated.','job_code'=>$data['job_code']));
			}else{
				echo json_encode(array('result' =>'failure','message'=>'something went wrong.','job_code'=>$data['job_code']));
			}
	    	        
    	        }
    	}else{
    		if( ( $get_tooling_qty_state['state'] >= 1 ) ){
        			if( $get_tooling_qty_state['state'] >= 2 ){
        				echo json_encode(array('result' =>'failure','message'=>'Tooling already Finished','job_code'=>$data['job_code']));
        			}else{
        				echo json_encode(array('result' =>'failure','message'=>'Tooling Already started','job_code'=>$data['job_code']));
        			}
    	        } else {
    	        	//echo "<pre>";print_r('insert tooling start');exit;
    	    $tooling_timing['tooling_start'] = date('Y-m-d H:i:00');
			$tooling_timing['machine']	= $data['machine'];
			$tooling_timing['side']		= $data['side'];
			$tooling_timing['current_qty']	= $data['qty'];
			$tooling_timing['user_id']	= get_user_id($data['username']);
			$tooling_timing['order_id']	= $job_details_spcs['id'];
			
			$insert_tooling_timing = $this->mobile->insert_tooling_time($tooling_timing);
			
			if($insert_tooling_timing){
				if( ( $data['side'] == 1 ) && ( $data['qty'] == 1 ) ){
					$update['tjob_tooling_status'] = 1 ;
					$update['tjob_tooling_lupdate'] = date('Y-m-d H:i:00');
					$job_update = $this->mobile->update_job_details_boots($update,$data['job_code']);
					if($job_update){
						$spcs_update['job_complete_status'] = 1;
						$spcs_update['setup_status']=2;
						$spcs_update['tooling_start'] = date('Y-m-d H:i:00');
						$job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']);
						
						// Update Tooling Complete Status
						$status_update['tjob_id'] = $job_details_boots['tjob_id'];
						$status_update['update_date'] = date('Y-m-d');
						$status_update['update_time'] = date('Y-m-d H:i:00');
						$status_update['update_for']    = 3 ;
						$status_update['update_status'] = 1 ;
						$status_update['update_to'] = 'TOOLING - Working By '.$data['username'];
						$status_update['update_by'] = get_user_id($data['username']); //MOBILE_APP_USER_ID;
						$status_update['update_remarks'] = '';
						 $status_update['update_from'] = 'mobile';
						$job_status_update = $this->mobile->update_job_status_boots($status_update);
					}
				}
				
				$mcdown_updates['job_id'] = $job_details_spcs['id'];
				$mcdown_updates['updated_for'] = 5; 
				$mcdown_updates['updated_to'] = 'Tooling Started - Side('.$data['side'].'/'.$job_details_spcs['side'].') - Qty('.$data['qty'].'/'.$job_details_spcs['qty'].') - '.$data['machine_name'];
				$mcdown_updates['updated_by'] =   $data['username']; 
				$mcdown_updates['updated_status'] = 1;
				$mcdown_updates['updated_remark'] = '';
				$mcdown_updates['qty_no']	= $tooling['current_qty'];
				$mcdown_updates['qty_status']	= 1;
				$mcdown_updates['side']	= $data['side'];
				$mcdown_updates['mechine_status'] = 't1';
				$mcdown_updates['mc_status'] = $data['mc_status'];
				$mcdown_updates['tot_side'] = $job_details_spcs['side'];
				mcdown_updates($mcdown_updates);
						
				echo json_encode(array('result' =>'success','message'=>'This order tooling Start updated successfully','job_code'=>$data['job_code']));
			}else{
				echo json_encode(array('result' =>'failure','message'=>'something went wrong','job_code'=>$data['job_code']));
			}
    	        }
    	}
    
    }elseif($get_setup_state['state'] == 1){
    	echo json_encode(array('result' =>'failure','message'=>'Job Setup not finished.'));
    
    }else{
    	echo json_encode(array('result' =>'failure','message'=>'Job Setup not started.'));
    }
} */

/* //tooling old 
public function tooling(){
    $job_code = $this->input->get('job_code');
    $status = $this->input->get('status');
    $username = $this->input->get('username'); 
    $machine_name = $this->input->get('machine_name');
    $machine  = $this->mobile->get_machine_id($this->input->get('machine_name'));
    $job_details_boots = $this->mobile->get_job_details_boots($job_code);
    $job_details_spcs = $this->mobile->get_job_details($job_code);
    if($job_details_spcs){
        if(($machine != $job_details_spcs['machine'])||($job_details_spcs['setup'] != 2)){
            echo json_encode(array('result' =>'failure','message'=>'Setup Not finished.'));
        }else{
            if($status==2){
                if($job_details_boots['tjob_tooling_status']==2){
                    echo json_encode(array('result' =>'failure','message'=>'Tooling Finished already updated.'));
                }elseif($job_details_boots['tjob_tooling_status']==0){
                    echo json_encode(array('result' =>'failure','message'=>'Tooling Not Started.'));
                }else{
                    $datetime1 = new DateTime($job_details_spcs['tooling_start']);
                    $datetime2 = new DateTime(date('Y-m-d H:i:00'));
                    $interval = $datetime1->diff($datetime2);
                    $update['machine_time_hr']  = $interval->format('%h') ;
                    $update['machine_time_min'] = $interval->format('%i') ;
                    $update['tjob_tooling_status'] = 2 ;
                    $update['tjob_tooling_lupdate'] = date('Y-m-d H:i:00');
                    $job_update = $this->mobile->update_job_details_boots($update,$job_code);
                    if($job_update){
                        $spcs_update['tooling_end'] = date('Y-m-d H:i:00');
                        $spcs_update['time_to']=date('H:i:00');
                        $spcs_update['job_complete_status'] = 2;
                        $job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']);
                        $mcdown_updates['job_id'] = $job_details_spcs['id'];
                        $mcdown_updates['updated_for'] = 6; 
                        $mcdown_updates['updated_to'] = 'Tooling Finished - '.$machine_name;
                        $mcdown_updates['updated_by'] =   $username; 
                        $mcdown_updates['updated_status'] = 2;
                        $mcdown_updates['updated_remark'] = '';
                        mcdown_updates($mcdown_updates);
// Update Tooling Complete Status
                        $status_update['tjob_id'] = $job_details_boots['tjob_id'];
                        $status_update['update_date'] = date('Y-m-d');
                        $status_update['update_time'] = date('Y-m-d H:i:00');
                        $status_update['update_for']    = 3 ;
                        $status_update['update_status'] = 1 ;
                        $status_update['update_to'] = 'TOOLING - Completed By '.$username;
                        $status_update['update_by'] = MOBILE_APP_USER_ID;
                        $job_status_update = $this->mobile->update_job_status_boots($status_update);
// Machine Time Update Status
                        $status_update['tjob_id'] = $job_details_boots['tjob_id'];
                        $status_update['update_date'] = date('Y-m-d');
                        $status_update['update_time'] = date('Y-m-d H:i:00');
                        $status_update['update_for']    = 3 ;
                        $status_update['update_status'] = 1 ;
                        $status_update['update_to'] = 'Machine time Updated - '.$interval->format('%h').':'.$interval->format('%i');
                        $status_update['update_by'] = MOBILE_APP_USER_ID;
                        $job_status_update = $this->mobile->update_job_status_boots($status_update);
// change updated times to upcoming jobs
                        $this->mobile->update_upcomingjobs_time($job_details_spcs['date_from'],$job_details_spcs['shift'],$job_details_spcs['machine'],$job_details_spcs['time_from'],$spcs_update['time_to'],$job_details_spcs['id']);
                        echo json_encode(array('result' =>'success','message'=>'Successfully updated.','job_code'=>$job_update));
                    }else{
                        echo json_encode(array('result' =>'failure','message'=>'Something went to wrong .'));
                    }
                }
            }else{
                if($job_details_boots['tjob_tooling_status']==2){
                    echo json_encode(array('result' =>'failure','message'=>'Tooling Finished already updated.'));
                }elseif($job_details_boots['tjob_tooling_status']==1){
                    echo json_encode(array('result' =>'failure','message'=>'Tooling already started.'));
                }else{
                    $update['tjob_tooling_status'] = 1 ;
                    $update['tjob_tooling_lupdate'] = date('Y-m-d H:i:00');
                    $job_update = $this->mobile->update_job_details_boots($update,$job_code);
                    if($job_update){
                        $spcs_update['job_complete_status'] = 1;
                        $spcs_update['tooling_start'] = date('Y-m-d H:i:00');
                        $job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']);
                        $mcdown_updates['job_id'] = $job_details_spcs['id'];
                        $mcdown_updates['updated_for'] = 5; 
                        $mcdown_updates['updated_to'] = 'Tooling Started - '.$machine_name;
                        $mcdown_updates['updated_by'] =   $username; 
                        $mcdown_updates['updated_status'] = 1;
                        $mcdown_updates['updated_remark'] = '';
                        mcdown_updates($mcdown_updates);
// Update Tooling Complete Status
                        $status_update['tjob_id'] = $job_details_boots['tjob_id'];
                        $status_update['update_date'] = date('Y-m-d');
                        $status_update['update_time'] = date('Y-m-d H:i:00');
                        $status_update['update_for']    = 3 ;
                        $status_update['update_status'] = 1 ;
                        $status_update['update_to'] = 'TOOLING - Working By '.$username;
                        $status_update['update_by'] = MOBILE_APP_USER_ID;
                        $status_update['update_remarks'] = '';
                        $job_status_update = $this->mobile->update_job_status_boots($status_update);
                        echo json_encode(array('result' =>'success','message'=>'Successfully updated.','job_code'=>$job_update));
                    }else{
                        echo json_encode(array('result' =>'failure','message'=>'Something went to wrong .'));
                    }
                }
            }
        } 
    }else{
        echo json_encode(array('result' =>'failure','message'=>'Job details not found.'));
    }
}
/* tooling old */
/*public function assymbly(){
    $job_code = $this->input->get('job_code');
    $status = $this->input->get('status');
    $username = $this->input->get('username');

    $job_details_boots = $this->mobile->get_job_details_boots($job_code);
    $job_details_spcs = $this->mobile->get_job_details($job_code);
    if($job_details_spcs){
        if($status==2){
            
            if($job_details_spcs['assy_end'] != '0000-00-00 00:00:00'){
                echo json_encode(array('result' =>'failure','message'=>'Assembly Finished already updated.'));
            }elseif($job_details_spcs['assy_start'] == '0000-00-00 00:00:00'){
                echo json_encode(array('result' =>'failure','message'=>'Assembly Not Started.'));
            }else{
                $datetime1 = new DateTime($job_details_spcs['assy_start']);
                $datetime2 = new DateTime(date('Y-m-d H:i:s'));
                $interval = $datetime1->diff($datetime2);
                $update['assy_time_hr']  = $interval->format('%h') ;
                $update['assy_time_min'] = $interval->format('%i') ;
                $update['job_color_status'] = 4;
                $update['tjob_tooling_status'] = 2;
                $job_update = $this->mobile->update_job_details_boots($update,$job_code);
                if($job_update){
                    $spcs_update['assy_end'] = date('Y-m-d H:i:s');
                    $job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']);
                    $mcdown_updates['job_id'] = $job_details_spcs['id'];
                    $mcdown_updates['updated_for'] = 8; 
                    $mcdown_updates['updated_to'] = 'Assembly Finished ';
                    
                    $mcdown_updates['updated_by'] =   $username; 
                    $mcdown_updates['updated_status'] = 2;
                    $mcdown_updates['updated_remark'] = '';
                    mcdown_updates($mcdown_updates);
// Update Tooling Complete Status
                    $status_update['tjob_id'] = $job_details_boots['tjob_id'];
                    $status_update['update_date'] = date('Y-m-d');
                    $status_update['update_time'] = date('Y-m-d H:i:s');
                    $status_update['update_for']    = 3 ;
                    $status_update['update_status'] = 1 ;
                    //$status_update['receiver_name'] = 'Receiver - Completed By '.$receiver_name;
                    $status_update['update_to'] = 'Assembly - Completed By '.$username;
                    $status_update['update_by'] = get_user_id($username); //MOBILE_APP_USER_ID;
                     $status_update['update_from'] = 'mobile';
                    $job_status_update = $this->mobile->update_job_status_boots($status_update);
// Machine Time Update Status
                    $status_update['tjob_id'] = $job_details_boots['tjob_id'];
                    $status_update['update_date'] = date('Y-m-d');
                    $status_update['update_time'] = date('Y-m-d H:i:s');
                    $status_update['update_for']    = 3 ;
                    $status_update['update_status'] = 1 ;
                    $status_update['update_to'] = 'Assembly time Updated - '.$interval->format('%h').':'.$interval->format('%i');
                    $status_update['update_by'] = get_user_id($username); //MOBILE_APP_USER_ID;
                     $status_update['update_from'] = 'mobile';
                    $job_status_update = $this->mobile->update_job_status_boots($status_update);
                    echo json_encode(array('result' =>'success','message'=>'Successfully updated.','job_code'=>$job_update));
                }else{
                    echo json_encode(array('result' =>'failure','message'=>'Something went to wrong .'));
                }
            }
        }else{
            if($job_details_spcs['assy_end'] != '0000-00-00 00:00:00'){
                echo json_encode(array('result' =>'failure','message'=>'Assembly Finished already updated.'));
            }elseif($job_details_spcs['assy_start'] != '0000-00-00 00:00:00'){
                echo json_encode(array('result' =>'failure','message'=>'Assembly already started.'));
            }else{

                $spcs_update['assy_start'] = date('Y-m-d H:i:s');
                
                $job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']);

                $mcdown_updates['job_id'] = $job_details_spcs['id'];
                $mcdown_updates['updated_for'] = 7; 
                $mcdown_updates['updated_to'] = 'Assembly Started';
                $mcdown_updates['updated_by'] =   $username; 
                $mcdown_updates['updated_status'] = 1;
                $mcdown_updates['updated_remark'] = '';
                mcdown_updates($mcdown_updates);
                
                $update['job_color_status'] = 3;
                $job_update = $this->mobile->update_job_details_boots($update,$job_code);
// Update Tooling Complete Status
                $status_update['tjob_id'] = $job_details_boots['tjob_id'];
                $status_update['update_date'] = date('Y-m-d');
                $status_update['update_time'] = date('Y-m-d H:i:s');
                $status_update['update_for']    = 3 ;
                $status_update['update_status'] = 1 ;
                $status_update['update_to'] = 'Assembly - Working By '.$username;
                $status_update['update_by'] = get_user_id($username); //MOBILE_APP_USER_ID;
                $status_update['update_remarks'] = '';
                 $status_update['update_from'] = 'mobile';
                $job_status_update = $this->mobile->update_job_status_boots($status_update);
                echo json_encode(array('result' =>'success','message'=>'Successfully updated.','job_code'=>$job_code));

            }
        }
    }else{
        echo json_encode(array('result' =>'failure','message'=>'Job details not found.'));
    }
}*/

public function assymbly(){
    $job_code = $this->input->get('job_code');
    $wims_hold_jobs = 0;
    $explode_down   = explode("[",$job_code);

    $status = $this->input->get('status');
    $username = $this->input->get('username');
	$wims_hold_jobs = $this->wims_hold_jobs($job_code);
	if($wims_hold_jobs==1){
	    echo  json_encode(array('result' =>'failure','message' => 'job is HOLD in wims so UNHOLD the job after that you can continue..'));
		exit;
	} 

    $job_details_boots = $this->mobile->get_job_details_boots($explode_down[0]);
    $job_details_spcs = $this->mobile->get_job_details($job_code);
    if($job_details_spcs){
        if($status==2){
            if($job_details_spcs['assy_hold'] == '1'){
                echo json_encode(array('result' =>'failure','message'=>'Assembly is holded so you need to start the assembly.'));
            }elseif($job_details_spcs['assy_end'] != '0000-00-00 00:00:00'){
                echo json_encode(array('result' =>'failure','message'=>'Assembly Finished already updated.'));
            }elseif($job_details_spcs['assy_start'] == '0000-00-00 00:00:00'){
                echo json_encode(array('result' =>'failure','message'=>'Assembly Not Started.'));
            }else{
                $datetime1 = new DateTime($job_details_spcs['assy_start']);
                $datetime2 = new DateTime(date('Y-m-d H:i:s'));
                $interval = $datetime1->diff($datetime2);
                $update['assy_time_hr']  = $interval->format('%h');
                $update['assy_time_min'] = $interval->format('%i');
                //$spcs_update['assy_time'] = $update['assy_time_hr'].'.'.$update['assy_time_min'];
                $assytotal_time = $this->mobile->update_assytotal_time_boots($job_details_spcs['id']);
                if($job_details_spcs['assy_time']!='00.00'){
                    
                    $job_time = explode('.', trim($job_details_spcs['assy_time']));
                    $assy_curtime = strtotime($interval->format('%h').':'.$interval->format('%i'));
                    $assy_time_hr = date("H", strtotime('+'.$job_time[0].' hours', $assy_curtime));
                    if(count($job_time)==2){
                      $assy_time_min = date("i", strtotime('+'.$job_time[1].' minutes', $assy_curtime));  
                    }else{
                        $assy_time_min = '00';
                    }
                    $update['assy_time_hr']  = $assytotal_time['h'];
                    $update['assy_time_min'] = $assytotal_time['m'];                    
                    //$spcs_update['assy_time'] = $assy_time_hr.'.'.$assy_time_min;
                }
                    $spcs_update['assy_end'] = date('Y-m-d H:i:s');
                    $job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']);
                    
                if($job_details_spcs['share_status']==1){
                    $tottime_arr = $this->hour_min($explode_down[0]);
                    $update['assy_time_hr']  = $tottime_arr['hour'];
                    $update['assy_time_min'] = $tottime_arr['min'];                  
                }
                $update['job_color_status'] = 4;
                $update['tjob_tooling_status'] = 2;
                $update['n'] = date('Y-m-d H:i:s');
                $job_update = $this->mobile->update_job_details_boots($update,$explode_down[0]);
                if($job_update){
                    
                    $mcdown_updates['job_id'] = $job_details_spcs['id'];
                    $mcdown_updates['updated_for'] = 8; 
                    $mcdown_updates['assembly'] = 1;
                    $mcdown_updates['updated_to'] = 'Assembly Finished';
                    
                    $mcdown_updates['updated_by'] =   $username; 
                    $mcdown_updates['updated_status'] = 2;
                    $mcdown_updates['updated_remark'] = '';
                    mcdown_updates($mcdown_updates);
// Update Tooling Complete Status
                    $status_update['tjob_id'] = $job_details_boots['tjob_id'];
                    $status_update['update_date'] = date('Y-m-d');
                    $status_update['update_time'] = date('Y-m-d H:i:s');
                    $status_update['update_for']    = 3 ;
                    $status_update['update_status'] = 1 ;
                    //$status_update['receiver_name'] = 'Receiver - Completed By '.$receiver_name;
                    $status_update['update_to'] = 'Assembly - Completed By '.$username;
                    $status_update['update_by'] = get_user_id($username); //MOBILE_APP_USER_ID;
                     $status_update['update_from'] = 'mobile';
                    $job_status_update = $this->mobile->update_job_status_boots($status_update);
// Machine Time Update Status
                    $status_update['tjob_id'] = $job_details_boots['tjob_id'];
                    $status_update['update_date'] = date('Y-m-d');
                    $status_update['update_time'] = date('Y-m-d H:i:s');
                    $status_update['update_for']    = 3 ;
                    $status_update['update_status'] = 1 ;
                    $status_update['update_to'] = $status_update['update_to'] = 'Assembly time Updated - '.$assytotal_time['h'].':'.$assytotal_time['m'];
                    $status_update['update_by'] = get_user_id($username); //MOBILE_APP_USER_ID;
                     $status_update['update_from'] = 'mobile';
                    $job_status_update = $this->mobile->update_job_status_boots($status_update);
                    
                    $assytotal_time = $this->mobile->update_assytotal_time_boots($job_details_spcs['id']);
                    $update['assy_time_hr']  = $assytotal_time['h'];
                    $update['assy_time_min'] = $assytotal_time['m'];
                    $job_update = $this->mobile->update_job_details_boots($update,$explode_down[0]);
                    
                    $spcs_update['assy_time'] = $update['assy_time_hr'].'.'.$update['assy_time_min'];
                    $job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']);
                    
                    echo json_encode(array('result' =>'success','message'=>'Assy Finished.','job_code'=>$job_update));
                }else{
                    echo json_encode(array('result' =>'failure','message'=>'Something went to wrong .'));
                }
            }
        }else{
            if($job_details_spcs['assy_end'] != '0000-00-00 00:00:00'){
                echo json_encode(array('result' =>'failure','message'=>'Assy working updated".'));
            }elseif($job_details_spcs['assy_start'] != '0000-00-00 00:00:00'){
                echo json_encode(array('result' =>'failure','message'=>'Assembly already started.'));
            }else{
                $spcs_update['assy_start'] = date('Y-m-d H:i:s');
                $spcs_update['assy_hold'] = 0;
                
                $job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']);

                $mcdown_updates['job_id'] = $job_details_spcs['id'];
                $mcdown_updates['updated_for'] = 7;
                $mcdown_updates['assembly'] = 1;
                $mcdown_updates['updated_to'] = 'Assembly Started';
                $mcdown_updates['updated_by'] =   $username; 
                $mcdown_updates['updated_status'] = 1;
                $mcdown_updates['updated_remark'] = '';
                mcdown_updates($mcdown_updates);
                
                $update['job_color_status'] = 3;
                $job_update = $this->mobile->update_job_details_boots($update,$explode_down[0]);
// Update Tooling Complete Status
                $status_update['tjob_id'] = $job_details_boots['tjob_id'];
                $status_update['update_date'] = date('Y-m-d');
                $status_update['update_time'] = date('Y-m-d H:i:s');
                $status_update['update_for']    = 3 ;
                $status_update['update_status'] = 1 ;
                $status_update['update_to'] = 'Assembly - Working By '.$username;
                $status_update['update_by'] = get_user_id($username); //MOBILE_APP_USER_ID;
                $status_update['update_remarks'] = '';
                 $status_update['update_from'] = 'mobile';
                $job_status_update = $this->mobile->update_job_status_boots($status_update);
                echo json_encode(array('result' =>'success','message'=>'Assy working updated.','job_code'=>$job_code));
//}else{
//    echo json_encode(array('result' =>'failure','message'=>'Something went to wrong .'));
//}
            }
        }
    }else{
        echo json_encode(array('result' =>'failure','message'=>'Job details not found.'));
    }
}
public function assyhold(){
    $job_code = $this->input->get('job_code');
    $status = $this->input->get('status');
    $username = $this->input->get('username');
    $job_details_spcs = $this->mobile->get_job_details_assy_hold($job_code);

    if($job_details_spcs['assy_start'] == '0000-00-00 00:00:00'){
        echo json_encode(array('result' =>'failure','message'=>'Assembly Not Started.'));
        exit;
    }

    $spcs_update['assy_hold'] = 1;
    $spcs_update['assy_end'] = date('Y-m-d H:i:s');
    
    $datetime1 = new DateTime($job_details_spcs['assy_start']);
    $datetime2 = new DateTime(date('Y-m-d H:i:s'));
    $interval = $datetime1->diff($datetime2);
    $spcs_update['assy_time'] = $interval->format('%h').'.'.$interval->format('%i');
    if($job_details_spcs['assy_time']!='00.00'){
        
        $job_time = explode('.', trim($job_details_spcs['assy_time']));
        $assy_curtime = strtotime($interval->format('%h').':'.$interval->format('%i'));
        $assy_time_hr = date("H", strtotime('+'.$job_time[0].' hours', $assy_curtime));
        if(count($job_time)==2){
          $assy_time_min = date("i", strtotime('+'.$job_time[1].' minutes', $assy_curtime));  
        }else{
            $assy_time_min = '00';
        }
        $spcs_update['assy_time']  = $assy_time_hr.'.'.$assy_time_min;
    }    
    $spcs_update['assy_start'] = '0000-00-00 00:00:00';
    $spcs_update['assy_end'] = '0000-00-00 00:00:00';
    $job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']);
    $mcdown_updates['job_id'] = $job_details_spcs['id'];
    $mcdown_updates['updated_for'] = 8; 
    $mcdown_updates['assembly'] = 1;
    $mcdown_updates['updated_to'] = 'Assembly HOLDED';
    $mcdown_updates['updated_by'] =   $username; 
    $mcdown_updates['updated_status'] = 1;
    $mcdown_updates['updated_remark'] = '';
    mcdown_updates($mcdown_updates);    
    
    $job_details_boots = $this->mobile->get_job_details_boots($this->input->get('job_code'));					
	$status_update['tjob_id'] = $job_details_boots['tjob_id'];
	$status_update['update_date'] = date('Y-m-d');
	$status_update['update_time'] = date('Y-m-d H:i:s');
	$status_update['update_for']    = 3 ;
	$status_update['update_status'] = 1 ;
	$status_update['update_to'] = 'Assembly HOLDED by SFCS - '.$this->input->get('username');
	$status_update['update_by'] = 0; 
	$status_update['update_from'] = 'mobile';
	$job_status_update = $this->mobile->update_job_status_boots($status_update);    
    
    if($job_status_update){
        echo json_encode(array('result' =>'success','message'=>'Assembly Hold Successfully updated.','job_code'=>$this->input->get('job_code')));
    }else{
        echo json_encode(array('result' =>'failure','message'=>'Assembly updated is failed.'));
    }
}


public function qc(){
    $job_code = $this->input->get('job_code');
    $wims_hold_jobs = 0;
	$wims_hold_jobs = $this->wims_hold_jobs($this->input->get('job_code'));
	if($wims_hold_jobs==1){
	    echo  json_encode(array('result' =>'failure','message' => 'job is HOLD in wims so UNHOLD the job after that you can continue..'));
		exit;
	}     
    $explode_down   = explode("[",$job_code);
    $status = $this->input->get('status');
    $username = $this->input->get('username');
    $job_details_boots = $this->mobile->get_job_details_boots($explode_down[0]);
    $job_details_spcs = $this->mobile->get_job_details($job_code);
    if($job_details_spcs){
        if($status==2){
            if($job_details_spcs['share_status']==1){
                
                $job_details_boots['tjob_production_status'] = 1;
            }
            if($job_details_boots['tjob_production_status']==2){
                echo json_encode(array('result' =>'failure','message'=>'QC Finished Successfully updated.'));
            }elseif($job_details_boots['tjob_production_status']==0){
                echo json_encode(array('result' =>'failure','message'=>'QC Not Started.'));
            }else{
                $datetime1 = new DateTime($job_details_spcs['qc_start']);
                $datetime2 = new DateTime(date('Y-m-d H:i:s'));
                $interval = $datetime1->diff($datetime2);
                //$update['machine_time_hr']  = $interval->format('%h') ;
                //$update['machine_time_min'] = $interval->format('%i') ;
                $update['tjob_production_status'] = 2 ;
                $update['tjob_production_lupdate'] = date('Y-m-d H:i:s');
                $update['job_color_qc_status'] = 4;
                $job_update = $this->mobile->update_job_details_boots($update,$explode_down[0]);
                if($job_update){
                    $spcs_update['qc_end'] = date('Y-m-d H:i:s');
                    $job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']);
                    $mcdown_updates['job_id'] = $job_details_spcs['id'];
                    $mcdown_updates['updated_for'] = 10; 
                    $mcdown_updates['updated_to'] = 'QC Finished';
                    $mcdown_updates['updated_by'] =   $username; 
                    $mcdown_updates['updated_status'] = 2;
                    $mcdown_updates['updated_remark'] = '';
                    mcdown_updates($mcdown_updates);
// Update Tooling Complete Status
                    $status_update['tjob_id'] = $job_details_boots['tjob_id'];
                    $status_update['update_date'] = date('Y-m-d');
                    $status_update['update_time'] = date('Y-m-d H:i:s');
                    $status_update['update_for']    = 3 ;
                    $status_update['update_status'] = 1 ;
                    $status_update['update_to'] = 'QC - Completed By '.$username;
                    $status_update['update_by'] = get_user_id($username); //MOBILE_APP_USER_ID;
                     $status_update['update_from'] = 'mobile';
                    $job_status_update = $this->mobile->update_job_status_boots($status_update);
                    echo json_encode(array('result' =>'success','message'=>'Successfully updated.','job_code'=>$job_update));
                }else{
                    echo json_encode(array('result' =>'failure','message'=>'Something went to wrong .'));
                }
            }
        }else{
            if($job_details_spcs['share_status']==1){
                
                $job_details_boots['tjob_production_status'] = 0;
            }            
            if($job_details_boots['tjob_production_status']==2){
                echo json_encode(array('result' =>'success','message'=>'QC Finished Successfully updated.'));
            }elseif($job_details_boots['tjob_production_status']==1){
                echo json_encode(array('result' =>'success','message'=>'Successfully updated.'));
            }else{
                $update['tjob_production_status'] = 1 ;
                $update['tjob_production_lupdate'] = date('Y-m-d H:i:s');
                $update['job_color_qc_status'] = 3;
                $job_update = $this->mobile->update_job_details_boots($update,$explode_down[0]);
                if($job_update){
                    $spcs_update['qc_start'] = date('Y-m-d H:i:s');
                    $job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']);
                    
                    $mcdown_updates['job_id'] = $job_details_spcs['id'];
                    $mcdown_updates['updated_for'] = 9; 
                    $mcdown_updates['updated_to'] = 'QC Started';
                    $mcdown_updates['updated_by'] =   $username; 
                    $mcdown_updates['updated_status'] = 1;
                    $mcdown_updates['updated_remark'] = '';
                    mcdown_updates($mcdown_updates);

// Update Tooling Complete Status
                    $status_update['tjob_id'] = $job_details_boots['tjob_id'];
                    $status_update['update_date'] = date('Y-m-d');
                    $status_update['update_time'] = date('Y-m-d H:i:s');
                    $status_update['update_for']    = 3 ;
                    $status_update['update_status'] = 1 ;
                    $status_update['update_to'] = 'QC - Working By '.$username;
                    $status_update['update_by'] = get_user_id($username); //MOBILE_APP_USER_ID;
                    $status_update['update_remarks'] = '';
                     $status_update['update_from'] = 'mobile';
                    $job_status_update = $this->mobile->update_job_status_boots($status_update);
                    echo json_encode(array('result' =>'success','message'=>'Successfully updated.','job_code'=>$job_update));
                }else{
                    echo json_encode(array('result' =>'failure','message'=>'Something went to wrong .'));
                }
            }
        }
    }else{
        echo json_encode(array('result' =>'failure','message'=>'Job details not found.'));
    }
}
public function shipping(){
    $wims_hold_jobs = 0;
	$wims_hold_jobs = $this->wims_hold_jobs($this->input->get('job_code'));
	if($wims_hold_jobs==1){
	    echo  json_encode(array('result' =>'failure','message' => 'job is HOLD in wims so UNHOLD the job after that you can continue..'));
		exit;
	}     
    $job_code = $this->input->get('job_code');
    $status = $this->input->get('status');
    $username = $this->input->get('username');
    $job_details_boots = $this->mobile->get_job_details_boots($job_code);
    $tjob_production_status = $job_details_boots['tjob_production_status'];
    $job_details_spcs = $this->mobile->get_job_details($job_code);
    if($job_details_spcs){
        if($status==2){
          if($tjob_production_status!=2){
                echo json_encode(array('result' =>'failure','message'=>'QC is not completed.please complete QC'));
            }            
            else if($job_details_boots['tjob_shipped_status']==2){
                if($job_details_boots['t_tracking_no']!=''){
                    echo json_encode(array('result' =>'success','message'=>'Shipping Finished Successfully updated'));
                }else{
                    echo json_encode(array('result' =>'failure','message'=>'Please update Tracking no'));
                }
            }else{
                $update['tjob_shipped_status'] = 2 ;
                $update['tjob_shipped_lupdate'] = date('Y-m-d H:i:s');
                $job_update = $this->mobile->update_job_details_boots($update,$job_code);
                $mcdown_updates['job_id'] = $job_details_spcs['id'];
                $mcdown_updates['updated_for'] = 11; 
                $mcdown_updates['updated_to'] = 'Shipped';
                $mcdown_updates['updated_by'] =   $username; 
                $mcdown_updates['updated_status'] = 2;
                $mcdown_updates['updated_remark'] = '';
                mcdown_updates($mcdown_updates);
                if($job_update){
// Update Tooling Complete Status
                    $status_update['tjob_id'] = $job_details_boots['tjob_id'];
                    $status_update['update_date'] = date('Y-m-d');
                    $status_update['update_time'] = date('Y-m-d H:i:s');
                    $status_update['update_for']    = 3 ;
                    $status_update['update_status'] = 1 ;
                    $status_update['update_to'] = 'SHIPPING - Completed By '.$username;
                    $status_update['update_by'] = get_user_id($username); //MOBILE_APP_USER_ID;
                     $status_update['update_from'] = 'mobile';
                    $job_status_update = $this->mobile->update_job_status_boots($status_update);
                    $job_shipping_update = $this->mobile->update_job_shipping($job_details_spcs['id'],$username);
                    echo json_encode(array('result' =>'success','message'=>'Successfully updated.Please Update Tracking no','job_code'=>$job_update));
                }else{
                    echo json_encode(array('result' =>'failure','message'=>'Something went to wrong .'));
                }
            }
        }
    }else{
        echo json_encode(array('result' =>'failure','message'=>'Job details not found.'));
    }
}
/*
public function shipping(){
    $job_code = $this->input->get('job_code');
    $status = $this->input->get('status');
    $username = $this->input->get('username');
    $job_details_boots = $this->mobile->get_job_details_boots($job_code);
    $job_details_spcs = $this->mobile->get_job_details($job_code);
    if($job_details_spcs){
        if($status==2){
            if($job_details_boots['tjob_shipped_status']==2){
                if($job_details_boots['t_tracking_no']!=''){
                    echo json_encode(array('result' =>'failure','message'=>'Shipping Finished already updated.'));
                }else{
                    echo json_encode(array('result' =>'success','message'=>'Please update Tracking no'));
                }
            }else{
                $update['tjob_shipped_status'] = 2 ;
                $update['tjob_shipped_lupdate'] = date('Y-m-d H:i:s');
                $job_update = $this->mobile->update_job_details_boots($update,$job_code);
                $mcdown_updates['job_id'] = $job_details_spcs['id'];
                $mcdown_updates['updated_for'] = 11; 
                $mcdown_updates['updated_to'] = 'Shipped';
                $mcdown_updates['updated_by'] =   $username; 
                $mcdown_updates['updated_status'] = 2;
                $mcdown_updates['updated_remark'] = '';
                mcdown_updates($mcdown_updates);
                if($job_update){
// Update Tooling Complete Status
                    $status_update['tjob_id'] = $job_details_boots['tjob_id'];
                    $status_update['update_date'] = date('Y-m-d');
                    $status_update['update_time'] = date('Y-m-d H:i:s');
                    $status_update['update_for']    = 3 ;
                    $status_update['update_status'] = 1 ;
                    $status_update['update_to'] = 'SHIPPING - Completed By '.$username;
                    $status_update['update_by'] = MOBILE_APP_USER_ID;
                    $job_status_update = $this->mobile->update_job_status_boots($status_update);
                    echo json_encode(array('result' =>'success','message'=>'Successfully updated.Please Update Tracking no','job_code'=>$job_update));
                }else{
                    echo json_encode(array('result' =>'failure','message'=>'Something went to wrong .'));
                }
            }
        }
    }else{
        echo json_encode(array('result' =>'failure','message'=>'Job details not found.'));
    }
}*/
public function tracking(){
    $job_code = $this->input->get('job_code');
    $tracking_no= $this->input->get('tracking_no');
    $username = $this->input->get('username');
    $job_details_boots = $this->mobile->get_job_details_boots($job_code);
    $job_details_spcs = $this->mobile->get_job_details($job_code);
    if($job_details_spcs){
        if($tracking_no!=''){
            $update['t_tracking_no'] =$tracking_no;
            $job_update = $this->mobile->update_job_details_boots($update,$job_code);

            $mcdown_updates['job_id'] = $job_details_spcs['id'];
            $mcdown_updates['updated_for'] = 12; 
            $mcdown_updates['updated_to'] = 'Tracking code updated - '.$tracking_no;
            $mcdown_updates['updated_by'] =   $username; 
            $mcdown_updates['updated_status'] = 2;
            $mcdown_updates['updated_remark'] = '';
            mcdown_updates($mcdown_updates);

            if($job_update){
// Update Tracking Complete Status
                $status_update['tjob_id'] = $job_details_boots['tjob_id'];
                $status_update['update_date'] = date('Y-m-d');
                $status_update['update_time'] = date('Y-m-d H:i:s');
                $status_update['update_for']    = 3 ;
                $status_update['update_status'] = 1 ;
                $status_update['update_to'] = 'TRACKING NO - Added By '.$username;
                $status_update['update_remarks'] = $tracking_no;
                $status_update['update_by'] = get_user_id($username); //MOBILE_APP_USER_ID;
                 $status_update['update_from'] = 'mobile';
                $job_status_update = $this->mobile->update_job_status_boots($status_update);
                echo json_encode(array('result' =>'success','message'=>'Tracking No Successfully updated.','job_code'=>$job_update));
            }else{
                echo json_encode(array('result' =>'failure','message'=>'Tracking No Already updated.'));
            }
        }else{
            echo json_encode(array('result' =>'failure','message'=>'Invalid Tracking No.','job_code'=>$job_code));
        }
    }else{
        echo json_encode(array('result' =>'failure','message'=>'Job details not found in SPCS.'));
    }
}
public function delivery(){

    $data=json_decode(file_get_contents('php://input'),true);
    $job_code = $data['job_code'];
    $wims_hold_jobs = 0;
	$wims_hold_jobs = $this->wims_hold_jobs($job_code);
	if($wims_hold_jobs==1){
	    echo  json_encode(array('result' =>'failure','message' => 'job is HOLD in wims so UNHOLD the job after that you can continue..'));
		exit;
	}    
    $status   = $data['status'];
    $username = $data['username'];
    $signature = $data['signature'];
    $delivery_name = $data['delivery_name'];
    
    $job_details_boots = $this->mobile->get_job_details_boots($job_code);
    $job_details_spcs  = $this->mobile->get_job_details($job_code);
    $tjob_production_status = $job_details_boots['tjob_production_status'];
    $location['order_id']   = $job_details_spcs['id'];
    $location['order_code']   = $job_code;
    $location['latitude']   = $data['latitude'];
    $location['longitude']  = $data['longitude'];
    $location['created_on'] = date('Y-m-d H:i:s');
    $location['status']     = 1;
    if($job_details_spcs){
        
        if($tjob_production_status!=2){
            echo json_encode(array('result' =>'failure','message'=>'QC is not completed.please complete QC'));
        }
        elseif($status==2){
            if($job_details_boots['tjob_complet_status']==2){
                echo json_encode(array('result' =>'success','message'=>'Delivery Finished Successfully updated.'));
            }else{
                $update['tjob_complet_status'] = 2 ;
//$update['tjob_shipped_lupdate'] = date('Y-m-d H:i:s');
                $job_update = $this->mobile->update_job_details_boots($update,$job_code);
                $mcdown_updates['job_id'] = $job_details_spcs['id'];
                $mcdown_updates['updated_for'] = 13; 
                $mcdown_updates['updated_to'] = 'Delivered';
                $mcdown_updates['updated_by'] =   $username; 
                $mcdown_updates['updated_status'] = 2;
                $mcdown_updates['updated_remark'] = '';
                $mcdown_updates['receiver_name'] = 'Receiver -  By '.$delivery_name;
                mcdown_updates($mcdown_updates);
                if($job_update){
                    
// Update Tooling Complete Status
                    $status_update['tjob_id'] = $job_details_boots['tjob_id'];
                    $status_update['update_date'] = date('Y-m-d');
                    $status_update['update_time'] = date('Y-m-d H:i:s');
                    $status_update['update_for']    = 3 ;
                    $status_update['update_status'] = 1 ;
                    $status_update['update_to'] = 'DELIVERY - Completed By '.$username;
                    $status_update['update_by'] = get_user_id($username); //MOBILE_APP_USER_ID;
                    $status_update['receiver_name'] = 'Receiver -  By '.$delivery_name;
                     $status_update['update_from'] = 'mobile';
                    $this->base64_string($signature,$job_code);
                    
                    $job_status_update = $this->mobile->update_job_status_boots($status_update);
                    $job_delivery_location_update = $this->mobile->update_job_delivery_location($location,$username);
                    echo json_encode(array('result' =>'success','message'=>'Successfully updated.','job_code'=>$job_update));
                }else{
                    echo json_encode(array('result' =>'failure','message'=>'Something went to wrong .'));
                }
            }
        }
    }else{
        echo json_encode(array('result' =>'failure','message'=>'Job details not found.'));
    }
}
/**
*
* This Function Used to check machine and assigned jobs
* If job available return success
* Else send warning and orininal machine details
*
**/

/*public function mechine_change(){
    $machine_name = $this->input->get('machine_name');
    $job_code = $this->input->get('job_code');
    $machine=$this->mobile->get_machine_id($machine_name);
    $job_details_spcs = $this->mobile->get_job_details($job_code);
    
    if($this->mobile->check_machine_exist($machine_name)){
        $job_current_status = $this->mobile->find_job_state($job_code);
        $job_details_boots = $this->mobile->get_job_details_boots($job_code);
        $status_update['tjob_id'] = $job_details_boots['tjob_id'];
        $status_update['update_date'] = date('Y-m-d');
        $status_update['update_time'] = date('Y-m-d H:i:s');
        $status_update['update_for']    = 0 ;
        $status_update['update_status'] = 0 ;
        $status_update['update_to'] = 'Ref '.$job_code.' Moved to '.$machine_name.' from '.$this->mobile->get_machine_name($job_details_spcs['machine']);
        $status_update['update_by'] = MOBILE_APP_USER_ID;
        $job_status_update = $this->mobile->update_job_status_boots($status_update);                   

        $mcdown_updates['job_id'] = $job_details_spcs['id'];
        $mcdown_updates['updated_for'] = -1; 
        $mcdown_updates['updated_to'] = 'Ref '.$job_code.' Moved to '.$machine_name.' from '.$this->mobile->get_machine_name($job_details_spcs['machine']);
        $mcdown_updates['updated_by'] =  'mobile user'; 
        $mcdown_updates['updated_status'] = 0;
        $mcdown_updates['updated_remark'] = '';
        mcdown_updates($mcdown_updates);
        
        if($job_status_update){
            echo json_encode(
                array(
                    'result' =>'success',
                    'message'=> 'Mechine is updated',
                    'job_code'=>$this->input->get('job_code')
                )
            );            
            
        }else{
         echo json_encode(
            array(
                'result' =>'failure',
                'message'=>'Mechine updation failed',
                'job_code'=>$this->input->get('job_code')
            )
        );           
            
        }
    }
}*/

public function mechine_change(){
    
    $machine_name = $this->input->get('machine_name');
    $user_name = $this->input->get('username');
    $job_code = $this->input->get('job_code');
    $machine=$this->mobile->get_machine_id($machine_name);
    $job_details_spcs = $this->mobile->get_job_details($job_code);
    $mechine_last_job = $this->mechine_last_job($machine,$job_code);
    
    
    if($job_details_spcs['setup'] > 0){
        
         echo json_encode(
            array(
                'result' =>'failure',
                'message'=>'Job is running so you cant move running job you can move only loading job.'
            )
        );       
    }
    
    if($this->mobile->check_machine_exist($machine_name)){
        $job_current_status = $this->mobile->find_job_state($job_code);
        $job_details_boots = $this->mobile->get_job_details_boots($job_code);
        $status_update['tjob_id'] = $job_details_boots['tjob_id'];
        $status_update['update_date'] = date('Y-m-d');
        $status_update['update_time'] = date('Y-m-d H:i:s');
        $status_update['update_for']    = 0 ;
        $status_update['update_status'] = 0 ;
        $status_update['update_to'] = 'Ref '.$job_code.' Moved to '.$machine_name.' from '.$this->mobile->get_machine_name($job_details_spcs['machine']).' by '.$user_name;
        $status_update['update_by'] = get_user_id($user_name); 
        $status_update['update_from'] = 'mobile';
        $job_status_update = $this->mobile->update_job_status_boots($status_update);                   

        $mcdown_updates['job_id'] = $job_details_spcs['id'];
        $mcdown_updates['updated_for'] = -1; 
        $mcdown_updates['updated_to'] = 'Ref '.$job_code.' Moved to '.$machine_name.' from '.$this->mobile->get_machine_name($job_details_spcs['machine']);
        $mcdown_updates['updated_by'] =  'mobile user'; 
        $mcdown_updates['updated_status'] = 0;
        $mcdown_updates['updated_remark'] = '';
        mcdown_updates($mcdown_updates);
        
        if($job_status_update){
            echo json_encode(
                array(
                    'result' =>'success',
                    'message'=> 'Machine is updated',
                    'job_code'=>$this->input->get('job_code')
                )
            );            
            
        }else{
         echo json_encode(
            array(
                'result' =>'failure',
                'message'=>'Machine updation failed',
                'job_code'=>$this->input->get('job_code')
            )
        );           
            
        }
    }
}

public function mechine_last_job($machine,$job_code){
        $less_five_min = date('H:i:s', strtotime('-5 hour'));
		$hour = $min = '00';
		$date = date('Y-m-d');
		$current_time = date('H:i:00');
		$this->db->where('job_code',$job_code);
		$this->db->where('setup',0);
		$query = $this->db->get('tbl_mcdown');		
		$data = $query->row_array();
		$explode_down = explode(",",$data['down_time']);
		if($explode_down[0]){
			
			$hour = $explode_down[0];
			$hour_length = strlen($hour);
			if($hour_length==1){
				$hour = '0'.$hour;
			}else{
			    $explode_down = explode(".",$explode_down[0]);
			    $hour = $explode_down[0];
			}
		}
		
		if(count($explode_down)>1){
    		if($explode_down[1]){
    			
    			$min = $explode_down[1];
    			$min_length = strlen($min);
    			if($min_length==1){
    				$min = '0'.$min;
    			}else{
    			    $explode_down = explode(".",$explode_down[1]);
    			    $min = $explode_down[0];
			    }
    		}
		}

		$this->db->where('machine',$machine);
		$this->db->where('date_from',$data['date_from']);
		$this->db->where('time_to >=', $less_five_min);
		$this->db->order_by('id','desc');
		$query = $this->db->get('tbl_mcdown');
		$result1 = $query->row_array();

        if($query->num_rows()>0){
		    $EndTime = new DateTime($data['date_from'].' '.$result1['time_to']);
    		$EndTime->modify('+'.$hour.' hours');
    		$EndTime->modify('+'.$min.' minutes');
    		unset($data['id']);
    		$data['time_from'] = date("H:i:s", strtotime($data['date_from'].' '.$result1['time_to']));
    		$data['time_to'] = date("H:i:s", strtotime($EndTime->format('H:i:s')));
    		$data['machine'] = $machine;
        }else{
            $EndTime = new DateTime($data['date_from'].' '.$current_time);
    		$EndTime->modify('+'.$hour.' hours');
    		$EndTime->modify('+'.$min.' minutes');
    		unset($data['id']);
    		$data['time_from'] = date("H:i:s", strtotime($data['date_from'].' '.$current_time));
    		$data['time_to'] = date("H:i:s", strtotime($EndTime->format('H:i:s')));
    		$data['machine'] = $machine;
        }
        $this->db->insert('tbl_mcdown',$data);
        $this->db->where('machine!=',$machine);
        $this->db->where('job_code',$job_code);
        $this->db->where('setup',0);
        $this->db->delete('tbl_mcdown');
        $url = base_url().'cron/moving_loaded_jobs_current_time';
        file_get_contents($url);       
        return 1;
	}
public function validate(){
    $machine_name = $this->input->get('machine_name');
    $job_code = $this->input->get('job_code');
    if($this->mobile->check_machine_exist($machine_name)){
        if(($machine_name!="")&&($job_code!="")){
            $machine=$this->mobile->get_machine_id($machine_name);
            $job_details_spcs = $this->mobile->get_job_details($job_code);
        if($job_details_spcs){
            $total_qty = $job_details_spcs['qty'];
            if($total_qty == 0){
            	$total_qty = 1;
            }
            	for($i=1;$i <= $total_qty;$i++ ){
			$qty[] = array(
						'id' => $i,
						'value'=>$i,
						'selected' => 0
					);
		        }
                if(($job_details_spcs['machine'] != $machine)){
                    $job_current_status = $this->mobile->find_job_state($job_code);
                    $job_details_boots = $this->mobile->get_job_details_boots($job_code);
                    echo json_encode(
                        array(
                            'result' =>'warning',
                            'message'=> 'Ref '.$job_code.' '.$job_current_status.' in '.$this->mobile->get_machine_name($job_details_spcs['machine'].'to '.$machine_name).'. Do You want to continue ?',
                            'machine_name'=>$machine_name,
                            'total_qty'=>$job_details_spcs['qty'],
                            'qty'=>$qty,
                            'job_code'=>$this->input->get('job_code')
                        )
                    );
                }else{
                    echo json_encode(
                        array(
                            'result' =>'success',
                            'message'=>'Correct Machine',
                            'total_qty'=>$job_details_spcs['qty'],
                            'qty'=>$qty,
                            'machine_name'=>$this->input->get('machine_name'),
                            'job_code'=>$this->input->get('job_code')
                        )
                    );
                }
        }else{
            /*echo json_encode(array('result' =>'failure','message'=>'Ref '.$job_code.' in '.$this->mobile->get_machine_name($job_details_spcs['machine'].'to '.$machine_name).'. Failed'));*/
        echo json_encode(
            array(
                'result' =>'failure',
                'message'=>'The jobcode entered does not exist.'
            )
        );            
        }
     }else{
            echo json_encode(
                array(
                    'result' =>'failure',
                    'message'=>'machine name or jobcode empty'
                )
            );
        }
    }else{
        echo json_encode(
            array(
                'result' =>'failure',
                'message'=>'The machine # you have entered does not exist.'
            )
        );
    }
} 

public function testsms(){
    $machine    = 19;
    $reason     = 'M/C DOWN';
    $start_time = '10:00:00';
    $end_time   = '10:35:00';
    $this->alertusers($machine,$reason,$start_time,$end_time);
}
public function alertusers($machine,$reason,$start_time,$end_time){
    $this->load->library('clickatell');
    $this->clickatell->authenticate();
    $machine_down_time = $this->calc_time_difference($start_time,$end_time);
    $machine_down_mins = $this->time_to_minutes($machine_down_time);
    
    $machine_downs = $this->mobile->get_cft_reports($machine,$reason);
    //echo "<pre>";
    if($machine_downs){
      foreach($machine_downs as $key => $machine_down){
        $alert_after = $this->time_to_minutes($machine_down['timing']);
        if($machine_down_mins >= $alert_after ){
            $user_array = explode(',',$machine_down['user']);
            foreach($user_array as $key => $user){
                $user_details = $this->mobile->get_cft_user($user);
//print_r($user_details);echo "<br>";
                $message ="test";
                if($this->clickatell->send_message($user_details['phone'], $message)){
                    //echo "message success";
                }else{
                    //echo "message failed";
                }
            }
        }else{
            //echo "not reached alert time";
        }
      }
    }else{
        //echo "not matched alerts";
    }
    
}

private function calc_time_difference($start_time,$end_time){
    $datetime1 = new DateTime( $start_time);
    $datetime2 = new DateTime( $end_time);
    $interval1 = $datetime1->diff($datetime2);
    $diffhour = $interval1->format('%h');
    $diffmin = $interval1->format('%i');

    $total_time_diff = $diffhour.':'.$diffmin;

    return $total_time_diff;
}

private function time_to_minutes($time){
    $time_array = explode(':',$time);
    if(count($time_array) == 2){ 

        $total_minutes = ($time_array[0]*60)+$time_array[1];

    }else{

        $total_minutes = $time;

    }
    
    return $total_minutes;
}

/*public function notifications($userid,usergroup){
	$this->load->library('notification');
	$this->notification->cad_complete_notification(1341,'333X2163');
	
	$this->notification->message(1,22,'test');
	
	$this->notification->acknowledgement(13,22,'received');
	
	
	if($username != 0){
		$user_details = $this->mobile->get_userinfo($username);
		if($user_details){
		
		}else{
			$return = array( 'result' => 'failed', 'message' => 'User details Missing' );
		}
	}else{
		
	}

}*/

public function notifications(){
	$userId		=	$this->input->get('user_id');
	$userType	=	$this->input->get('user_type');
	$notifyId	=	$this->input->get('notify');
	
	if( ($userId != 0 ) || ( $userType != 0 ) ){
		$this->load->library('notification');
		if($notifyId == 0){ 
			$notifications = $this->notification->get_notifications( $userId , $userType );
			if(!empty($notifications)){
				echo json_encode(
			            array(
			                'result' =>'success',
			                'message'=>'New Notifications Found.',
			                'data' => $notifications
			            )
			        );
			}else{
				echo json_encode(
			            array(
			                'result' =>'failure',
			                'message'=>'No New Notifications.'
			            )
			        );
			}
		}else{
			$notifications = $this->notification->read_notifications( $userId , $notifyId );
			echo json_encode(
		            array(
		                'result' =>'success',
		                'message'=>'successfully updated.'
		            )
		        );
		}
	}else{
		echo json_encode(
	            array(
	                'result' =>'failure',
	                'message'=>'parameter cannnot be empty.'
	            )
	        );
	}
}
public function message(){

	$userId		=	$this->input->get('user_id');
	$userType	=	$this->input->get('user_type');
	$notifyId	=	$this->input->get('msg_id');
	$ackMsg		=	$this->input->get('reply');

	if( ($userId != 0 ) || ( $userType != 0 ) ){
		$this->load->library('notification');
		if($notifyId == 0){
			$messages = $this->notification->get_messages( $userId , $userType );
			if(!empty($messages)){
				echo json_encode(
			            array(
			                'result' =>'success',
			                'message'=>'New Messages Found.',
			                'data' => $messages
			            )
			        );
			}else{
				echo json_encode(
			            array(
			                'result' =>'failure',
			                'message'=>'No New Messages.'
			            )
			        );
			}
		}else{
			$messages = $this->notification->acknowledge_message( $userId , $notifyId , $ackMsg );
			echo json_encode(
		            array(
		                'result' =>'success',
		                'message'=>'successfully updated.'
		            )
		        );
		}
		
	}else{
		echo json_encode(
	            array(
	                'result' =>'failure',
	                'message'=>'parameter cannnot be empty.'
	            )
	        );
	}
	
}
public function machinedown(){
    
    $current_time = date("H:i:s");
    $time_from= new DateTime($this->input->get('from_time'));
    $data['time_from']=$time_from->format('H:i:s');
    if($current_time<$data['time_from']){
       echo json_encode(array('result' =>'failure','message'=>'Machine start time will not accept future time')); 
       exit;
    }
    
    
    $machine = $this->mobile->get_machine_id($this->input->get('machine_name'));
	$machine_status = $this->down_before_hold_machine($machine);
    if($machine_status=="other_down"){
		echo  json_encode(array('result' =>'failure','message' => 'machine is other down please give machine ready after that  you can setup down'));
		exit;
	}elseif($machine_status=="mc_down"){
		echo  json_encode(array('result' =>'failure','message' => 'Machine is already down so plz give machine ready after that you can give down'));
		exit;
	}	
	
    $cur_date_time = date('Y-m-d H:i:s');
    $time_from= new DateTime($cur_date_time);
    $data['time_from']=$time_from->format('H:i:00'); 	
	
/*	if($machine_status=="setup"){
		echo  json_encode(array('result' =>'failure','message' => 'job is setup on this machine please continue or hold the job after that you can setup down'));
		exit;
	}elseif($machine_status=="mc_down"){
		echo  json_encode(array('result' =>'failure','message' => 'machine is down please give machine ready after that  you can setup down'));
		exit;
	}elseif($machine_status=="other_down"){
		echo  json_encode(array('result' =>'failure','message' => 'machine is other down please give machine ready after that  you can setup down'));
		exit;
	}elseif($machine_status=="not_complete"){
		echo  json_encode(array('result' =>'failure','message' => 'job is running on this machine please continue or hold the job after that  you can setup down'));
		exit;
	} */     
    
    
    $data['machine']=$this->mobile->get_machine_id($this->input->get('machine_name'));
    $data['date_from']=date('Y-m-d');
    $data['date_to']=date('Y-m-d');
    $mcdown_from = $this->input->get('from_time');
    $mcdown_to = $this->input->get('to_time');
    $time_to= new DateTime($this->input->get('to_time'));
    $data['time_to']=$time_to->format('H:i:s');
    $data['notes']=$this->input->get('notes');
    $data['down_time']=1;
    $data['mc_down']=1;
    $data['other']=0;    
    $data['shift']=1;
    $data['position']=0;
    $data['created_on']=date("Y-m-d H:i:s");
    $data['status']=1;
    /*$job_shift_start = $data['date_from'].' 08:00:00';
    $job_shift_end = $data['date_from'].' 20:00:00';
    $job_start = $data['date_from'].' '.$data['time_from'];
    $job_end = $data['date_from'].' '.$data['time_to'];
    if((($job_start < $job_shift_start) || ($job_start > $job_shift_end))||(($job_end < $job_shift_start) || ($job_end >$job_shift_end )) ){
        echo json_encode(array('result' =>'failure','message'=>'Check Machine Down Timing with Shift timing'));
    }else{ 
 
        $newdown=$this->mobile->insert_machine_down($data);*/
	$newdown=$this->check_job_or_mcdown($data);
        if($newdown['result']=='success'){
            $mcdown_updates['job_id'] = 0;
            $mcdown_updates['updated_for'] = -1; 
            $mcdown_updates['updated_to'] = 'Machine Down Ini - '.$mcdown_from.' To '.$mcdown_to;
            $mcdown_updates['updated_by'] =  'mobile user'; 
            $mcdown_updates['updated_status'] = 0;
            $mcdown_updates['updated_remark'] = $data['notes'];
            mcdown_updates($mcdown_updates);
            
            $this->alertusers($data['machine'],'M/C DOWN',$data['time_from'],$data['time_to']);
            
            $this->cron_run();
            echo json_encode(array('result' =>'success','message'=>'Machine Down Inserted Successfully','mcdown_id'=>0));
        }else{
            echo json_encode(array('result' =>'failure','message'=>'Machine Down Insertion Failed'));
        }
    /* } */
}
public function check_job_or_mcdown($data){
      $this->load->model('dashboard_model');

	$check['date_from']	=	date('Y-m-d',strtotime($data['date_from']));
	$check['date_to']	=	date('Y-m-d',strtotime($data['date_to']));
	$check['machine']	=	$data['machine'];
	$check['shift']		=	$data['shift'];
	$check['time_from']	=	date('H:i:s',strtotime($data['time_from']));
	$check['time_to']	=	date('H:i:s',strtotime($data['time_to']));
	$check['notes']		=	$data['notes'];
	if(isset($_POST['move_jobs'])){
		$check['move_jobs']	=	$this->input->post('move_jobs');
	}else{
		$check['move_jobs']	= 0;
	}
	
	if($data['other']==1){
		$check['other']	=	1;
	}else{
		$check['other']	= 0;
	}	

	$job_details = $this->dashboard_model->check_job_or_mcdown($check);

	
	return $this->split_job($job_details,$check);
		

    }
    
    private function split_job($data,$machinedown){
        $this->load->model('dashboard_model');
        //echo "<pre>";print_r($machinedown);exit;
    	$move_jobs = $machinedown['move_jobs'];
    	unset($machinedown['move_jobs']);
    	$shifts_details = $this->shift_and_timings($machinedown['date_from']); 
        foreach ($shifts_details as $key => $shift_details) {
            if($machinedown['shift'] == $shift_details['shift']){
                $shift_start_time = $shift_details['shift_start'];
                $shift_end_time = $shift_details['shift_end'];
            } 
        }
        if( ($shift_end_time < DEFAULT_SHIFT_START_TIME ) ){
            $shift_end_time = date('Y-m-d', strtotime($data['date_from'].' +1 day')).' '.$shift_end_time ;
        }else{
            $shift_end_time = $machinedown['date_from'].' '.$shift_end_time ;
        }
        if(($shift_start_time < DEFAULT_SHIFT_START_TIME )){
            $shift_start_time = date('Y-m-d', strtotime($data['date_from'].' +1 day')).' '.$shift_start_time ;
        }else{
            $shift_start_time = $machinedown['date_from'].' '.$shift_start_time ;
        }
    	
    	//if((new DateTime($shift_start_time) <= new DateTime($machinedown['date_from'].' '.$machinedown['time_from']))&&(new DateTime($shift_end_time) >= new DateTime($machinedown['date_to'].' '.$machinedown['time_to']))){ 
    	$datetime1 = new DateTime($machinedown['date_from'].' '.$machinedown['time_from']);
		$datetime2 = new DateTime($machinedown['date_to'].' '.$machinedown['time_to']);
		$interval1 = $datetime1->diff($datetime2);
		$mcdown_hour = $interval1->format('%h');
		$mcdown_min = $interval1->format('%i');
		//echo "<pre>";print_r($data);exit;
	    	if( $data['job']== 1 ){  
			$mcdown_time = (($mcdown_hour*60)+$mcdown_min); 
	    		if( ($mcdown_time <= MAXIMUM_MACHINE_DOWN_ALLOW)){
	    			if( ( $data['mcdown']!= 0 ) && ( $data['task']!=1 ) ){
	    				$return = array( 'result' => 'failed' , 'message' => 'machine down on this time.' );
		    		}else{
		    			 if($data['running'] == 1){
		    			 	$job_details = $this->dashboard_model->get_job_details($data['job_id']);
		    			 	// calculate starting time
		    			 	if($job_details){
		    			 		
		    			 	$datetime1 = new DateTime($job_details['date_from'].' '.$job_details['time_from']);
							$datetime2 = new DateTime($machinedown['date_from'].' '.$machinedown['time_from']);
							$interval1 = $datetime1->diff($datetime2);
							$start_diffhour = $interval1->format('%h');
							$start_diffmin = $interval1->format('%i');
							
							$DiffTime = new DateTime($job_details['date_from'].' '.$job_details['time_from']);
							$DiffTime->modify('+'.$start_diffhour.' hours');
							$DiffTime->modify('+'.$start_diffmin.' minutes');
							
			    			 	// calculating ending time
			    			 	
			    			$datetime1 = new DateTime($machinedown['date_from'].' '.$machinedown['time_from']);
							$datetime2 = new DateTime($job_details['date_to'].' '.$job_details['time_to']);
							$interval1 = $datetime1->diff($datetime2);
							$end_diffhour = $interval1->format('%h');
							$end_diffmin = $interval1->format('%i');
							
							$EndDiffTime = new DateTime($machinedown['date_to'].' '.$machinedown['time_to']);
							$EndDiffTime->modify('+30 minutes');
			    			 	//update old job 
			    			 	
			    			 	$update['date_from']	= $job_details['date_from'];
			    			 	$update['time_from']	= $job_details['time_from'];
			    			 	$update['date_to']	= $machinedown['date_from'];
			    			 	$update['time_to']	= $machinedown['time_from'];
			    			 	$update['task']		= 1;
			    			 	$update['down_time']	= $start_diffhour.'.'.$start_diffmin;
			    			 	$update['hold_status']	= 1;
			    			 	
			    			 	$insert_split_status = $job_details['split_exist'];
			    			 	
			    			 	
			    			 	$newdown=$this->dashboard_model->update_jobs($job_details['id'],$update);
			    			 	
			    			 	//insert new job
			    			 	
			    			 	$insert_job['date_from'] 	   = $EndDiffTime->format('Y-m-d');
			    			 	$insert_job['time_from'] 	   = $machinedown['time_to'];
			    			 	$insert_job['date_to']    	   = $EndDiffTime->format('Y-m-d');
			    			 	$insert_job['time_to']   	   = $EndDiffTime->format('H:i:00');
			    			 	$insert_job['job_code']  	   = $job_details['job_code'];
			    			 	$insert_job['qty']		       = $job_details['qty'];
			    			 	$insert_job['machine']    	   = $job_details['machine'];
			    			 	$insert_job['down_time']	   = $end_diffhour.'.'.$end_diffmin;
			    			 	$insert_job['task']       	   = $job_details['task'];
			    			 	$insert_job['reason']    	   = $job_details['reason'];
			    			 	$insert_job['notes']      	   = $job_details['notes'];
			    			 	$insert_job['setup']      	   = 0;
			    			 	$insert_job['side']      	   = $job_details['side'];
			    			 	$insert_job['shift']      	   = $job_details['shift'];
			    			 	$insert_job['position']      	   = 1; //$job_details['position']
			    			 	$insert_job['assy_start']      	   = $job_details['notes'];
			    			 	$insert_job['assy_end']      	   = $job_details['assy_start'];
			    			 	$insert_job['setup_start']         = $job_details['setup_start'];
			    			 	$insert_job['setup_end']     	   = $job_details['setup_end'];
			    			 	$insert_job['tooling_start']       = $job_details['tooling_start'];
			    			 	$insert_job['tooling_end']     	   = $job_details['tooling_end'];
			    			 	$insert_job['qc_start']     	   = $job_details['qc_start'];
			    			 	$insert_job['qc_end']      	   = $job_details['qc_end'];
			    			 	$insert_job['job_complete_status'] = 0;
			    			 	$insert_job['status']		   = 1;
			    			 	$insert_job['split_status']	= 1;
			    			 	$insert_job['split_exist']	= 1;
			    			 	
			    			 	$insert_row = 0;
			    			 	$date = date('Y-m-d');
    		                    $ndate = date('Y-m-d', strtotime($date));
			    			 	$this->db->where('job_code',$insert_job['job_code']);
			    			 	$this->db->where('split_exist',1);
			    			 	$this->db->where('task',0);			    			 	
    		                    $this->db->where('date_from',$ndate);
    		                    $rows = $this->db->get('tbl_mcdown');
    		                    
    		                    
			    			 	 if($rows->num_rows()>0){
			    			 	     $insert_row = 1;
			    			 	 }

			    			 	if($insert_row==0){
			    			 	    $newaddjob=$this->dashboard_model->check_position($insert_job,0);
			    			 	}
			    			 	
			    			 

                           /**************************** GET NEXT ROW TIME INCREASE **************************
                 				$this->db->select('*');
                 				$this->db->where('machine',$job_details['machine']);
                 				$this->db->where('date_from',$insert_job['date_from']);
                 				$this->db->where('time_from',$data['time_to']);
                 				$nextrow_result=$this->db->get(TBL_MCDOWN);


                            /**************************** GET NEXT ROW TIME INCREASE ***************************

			    			 	
			    			 	$date = date('Y-m-d');
    		                    $next_date = date('Y-m-d', strtotime("+1 day", strtotime($date)));
			    			 	$this->db->where('job_code',$insert_job['job_code']);
    		                    $this->db->where('date_from',$next_date);
    		                    $row = $this->db->get('tbl_mcdown');

                        		if($row->num_rows()>0){
                        		    $row = $row->result_array();
                        		    $this->db->where('id',$row[0]['id']);
                        		    $this->db->delete('tbl_mcdown'); 
                        		}
                        		if($nextrow_result->num_rows()>0){
                                    $nextrow_result=$nextrow_result->result_array();
                            		$nextrow_result_id =$nextrow_result[0]['id']; 
                                    $next_row_array = array('time_from'=>$insert_job['time_to']);
                                    $this->db->where('id',$nextrow_result_id);
    					            $this->db->update(TBL_MCDOWN,$next_row_array);
                        		} */	
			    			 	//insert machine down
			    			 	$insert_mcdown['other_down'] = 0;
			    			 	$insert_mcdown['date_from']	= $machinedown['date_from'];
			    			 	$insert_mcdown['time_from']	= $machinedown['time_from'];
				    			$insert_mcdown['date_to']	= $machinedown['date_to'];
			    			 	$insert_mcdown['time_to']	= $machinedown['time_to'];
			    			 	$insert_mcdown['machine']    	= $job_details['machine'];
			    			 	$insert_mcdown['notes']    	= $machinedown['notes'];
			    			 	$insert_mcdown['down_time']	= $mcdown_hour.'.'.$mcdown_min;
			    			 	
			    			 	if($machinedown['other']==1){
			    			 	    
			    			 	   $insert_mcdown['other_down']	= 1; 
			    			 	}else{
			    			 	    $insert_mcdown['mc_down']	= 1;
			    			 	}
			    			 
    							$insert_mcdown['shift']		= $job_details['shift'];
    							$insert_mcdown['position']	= 0;
    							$insert_mcdown['created_on']	= date("Y-m-d H:i:s");
    							$insert_mcdown['status']	= 1;
    							$insert_mcdown['prev_down_job']	= $job_details['job_code'];
    							$insert_mcdown['prev_down_job_status']	= 1;    							
			    			 	//
			    			 	//echo "<pre>";print_r($insert_mcdown);exit;
			    			 	//$newdown=$this->dashboard_model->insert_machine_down($insert_mcdown);
			    			 	$this->check_insert_mcdown($insert_mcdown);
			    			 	
			    			 	$return = array( 'result' => 'success' , 'message' => 'job split / machine down inserted successfully.' );
			    			 	
		    			 	}else{
		    			 		$return = array( 'result' => 'failed' , 'message' => 'job details not found.' );
		    			 	}
		    			 }else{
		    			 	
		    			 	//insert machine down
		    			 	
					 	$insert_mcdown['date_from']	= $machinedown['date_from'];
					 	$insert_mcdown['time_from']	= $machinedown['time_from'];
						$insert_mcdown['date_to']	= $machinedown['date_to'];
					 	$insert_mcdown['time_to']	= $machinedown['time_to'];
					 	$insert_mcdown['machine']    	= $machinedown['machine'];
					 	$insert_mcdown['notes']    	= $machinedown['notes'];
					 	$insert_mcdown['down_time']	= $mcdown_hour.'.'.$mcdown_min;
			    			 	if($machinedown['other']==1){
			    			 	    
			    			 	   $insert_mcdown['other_down']	= 1; 
			    			 	}else{
			    			 	    $insert_mcdown['mc_down']	= 1;
			    			 	}
						$insert_mcdown['shift']		= $machinedown['shift'];
						$insert_mcdown['position']	= 0;
						$insert_mcdown['created_on']	= date("Y-m-d H:i:s");
						$insert_mcdown['status']	= 1;
					 	
					 	//$newdown=$this->dashboard_model->insert_machine_down($insert_mcdown);
					 	$this->check_insert_mcdown($insert_mcdown);
						$return = array( 'result' => 'success' , 'message' => 'machine down inserted successfully.' );
		    			 }
		    		}
	    		}else{
	    			if($move_jobs != 1){
	    				$return = array( 'result' => 'failed' , 'message' => 'Please Move jobs machine down more than '.round((MAXIMUM_MACHINE_DOWN_ALLOW/60), 1).' Hours' );
	    			}else{
	    				//insert machine down
			    		 	
				 	$insert_mcdown['date_from']	= $machinedown['date_from'];
				 	$insert_mcdown['time_from']	= $machinedown['time_from'];
					$insert_mcdown['date_to']	= $machinedown['date_to'];
				 	$insert_mcdown['time_to']	= $machinedown['time_to'];
				 	$insert_mcdown['machine']    	= $machinedown['machine'];
				 	$insert_mcdown['notes']    	= $machinedown['notes'];
				 	$insert_mcdown['down_time']	= $mcdown_hour.'.'.$mcdown_min;
			    			 	if($machinedown['other']==1){
			    			 	    
			    			 	   $insert_mcdown['other_down']	= 1; 
			    			 	}else{
			    			 	    $insert_mcdown['mc_down']	= 1;
			    			 	}
					$insert_mcdown['shift']		= $machinedown['shift'];
					$insert_mcdown['position']	= 0;
					$insert_mcdown['created_on']	= date("Y-m-d H:i:s");
					$insert_mcdown['status']	= 1;
					
				 	$this->check_insert_mcdown($insert_mcdown);
	    			$return = array( 'result' => 'success' , 'message' => 'machine down inserted successfully.' );
	    			}
	    			
	    		}
	    	}else{
			//insert machine down
			    			 	
		 	$insert_mcdown['date_from']	= $machinedown['date_from'];
		 	$insert_mcdown['time_from']	= $machinedown['time_from'];
			$insert_mcdown['date_to']	= $machinedown['date_to'];
		 	$insert_mcdown['time_to']	= $machinedown['time_to'];
		 	$insert_mcdown['machine']    	= $machinedown['machine'];
		 	$insert_mcdown['notes']    	= $machinedown['notes'];
		 	$insert_mcdown['down_time']	= $mcdown_hour.'.'.$mcdown_min;
		 	if($machinedown['other']==1){
		 	    
		 	   $insert_mcdown['other_down']	= 1; 
		 	}else{
		 	    $insert_mcdown['mc_down']	= 1;
		 	}
			$insert_mcdown['shift']		= $machinedown['shift'];
			$insert_mcdown['position']	= 0;
			$insert_mcdown['created_on']	= date("Y-m-d H:i:s");
			$insert_mcdown['status']	= 1;
			
		 	$this->check_insert_mcdown($insert_mcdown);
			$return = array( 'result' => 'success' , 'message' => 'machine down inserted successfully.' );
			
		}    
       /* }else{ 
            $return = array('result' =>'failure','message'=>'Machine Down Time crossed shift time');
        }*/
    	return $return;
    }
    
    private function check_insert_mcdown($data){
    	//header('Access-Control-Allow-Origin: *');
        $this->load->model('mcdown_model','mcdown'); 
        
    	//echo "<pre>";print_r($data);exit;
    	$dates = createDateRangeArray($data['date_from'],$data['date_to']);
    	//echo "<pre>";print_r($dates);exit;
	foreach ($dates as $key => $date) { 
		$data['shifts'] = $this->shift_and_timings(date('Y-m-d',strtotime($date))); 
		// echo "<pre>";print_r($data['shifts']);exit;
		foreach($data['shifts'] as $shift_id => $shift){
			$from_insert = 0; 
			$to_insert = 0; 
			$check['machine'] 	= $data['machine'];
			$check['date_from'] 	= $date;
			$check['shift'] 	= $shift['shift'];
			$mcdown = $this->mcdown->check_fullshift_mcdown($check);
			 //echo "<pre>";print_r($mcdown);exit;
			if(($mcdown['full_shift_mcdown']!=1)){
				if( ($shift['shift_end'] < DEFAULT_SHIFT_START_TIME ) ){
					$shift['shift_end'] = date('Y-m-d', strtotime(date('Y-m-d',strtotime($date)).' +1 day')).' '.$shift['shift_end'];
				}else{
					$shift['shift_end'] = date('Y-m-d',strtotime($date)).' '.$shift['shift_end'];
				}
				if(($shift['shift_start'] < DEFAULT_SHIFT_START_TIME )){
					$shift['shift_start'] = date('Y-m-d', strtotime(date('Y-m-d',strtotime($date)).' +1 day')).' '.$shift['shift_start'];
				}else{
					$shift['shift_start'] = date('Y-m-d',strtotime($date)).' '.$shift['shift_start'];
				}
				// echo "<pre>";print_r($shift);exit;
				$downtime['date_from']  = date('Y-m-d',strtotime($shift['shift_start']));
				$downtime['date_to']    = date('Y-m-d',strtotime($shift['shift_end']));
				if($key == 0){ 
					// echo "<br/>first day<br/>";
					if(new DateTime($data['date_from'].' '.$data['time_from']) <= new DateTime($shift['shift_end']) ){
if(check_time(date('H:i:s',strtotime($shift['shift_start'])),date('H:i:s',strtotime($shift['shift_end'])),date('H:i:s',strtotime($data['time_from'])))){
							$from_insert = 1; 
							$downtime['time_from']  = date('H:i:s',strtotime($data['time_from']));
						}else{ 
							$from_insert = 1; 
							$downtime['time_from']  = date('H:i:s',strtotime($shift['shift_start']));
						}
					} 
				}else{
					$from_insert = 1;
					$downtime['time_from']  = date('H:i:s',strtotime($shift['shift_start']));
					
				}
				
				
				if($key == (count($dates)-1)){  
				// echo "<br/>last day<br/> "; 
					if(new DateTime($data['date_to'].' '.$data['time_to']) >= new DateTime($shift['shift_start']) ){ 
							if(check_time(date('H:i:s',strtotime($shift['shift_start'])),date('H:i:s',strtotime($shift['shift_end'])),date('H:i:s',strtotime($data['time_to'])))){
							$to_insert = 1;
							$downtime['time_to']    = date('H:i:s',strtotime($data['time_to']));
						}else{
							$to_insert = 1;
							$downtime['time_to']    = date('H:i:s',strtotime($shift['shift_end']));
						}
					
					}
				}else{ 
					$to_insert = 1;
					$downtime['time_to']    = date('H:i:s',strtotime($shift['shift_end']));

				}
				//  echo "<pre>";print_r($downtime['time_to']); 
				$downtime['shift']      =	$shift['shift'];
				$downtime['machine']    =	$data['machine'];
				$downtime['notes']    	=	$data['notes'];
				$downtime['down_time']	=	$data['down_time'];
				
				if(isset($data['other_down'])){
    			 	if($data['other_down']==1){
    			 	    
    			 	   $downtime['other_down']	= 1; 
    			 	}else{
    			 	    $downtime['mc_down']	= 1;
    			 	}
				}else{
				    $downtime['mc_down']	= 1;
				}
				$downtime['position']	=	0;
				$downtime['created_on']	=	date("Y-m-d H:i:s");
				$downtime['status']	=	1;
				//echo "<pre>";print_r($from_insert.'-'.$to_insert);
				//echo "<pre>";print_r($downtime);
				if( ($from_insert == 1)&&($to_insert == 1) ){
					$newdown=$this->dashboard_model->insert_machine_down($downtime);
					 
				}
				
				
			}
		}
	} 
    }
    
    public function shift_and_timings($date){
    $this->load->model('dashboard_model');
            $data['date_from'] = $date;
            $data['date_to']   = $date;
            $shift = $this->dashboard_model->shift_timings($data);
            //echo "<pre>";print_r($shift );exit;
            $shift_data = array();
            if($shift['shift1']==1){
                $data_shift['shift'] = 1;
                $data_shift['shift_start'] = date('H:i:s',strtotime($shift['shift1_from']));
                $data_shift['shift_end'] = date('H:i:s',strtotime($shift['shift1_to']));
                $data_shift['timings'] = $this->dashboard_model->shift_timing_list($shift['shift1_from'],$shift['shift1_to']); 
                $shift_data[] = $data_shift;
            }
            if($shift['shift2']==1){
                $data_shift['shift'] = 2;
                $data_shift['shift_start'] = date('H:i:s',strtotime($shift['shift2_from']));
                $data_shift['shift_end'] = date('H:i:s',strtotime($shift['shift2_to']));
                $data_shift['timings'] = $this->dashboard_model->shift_timing_list($shift['shift2_from'],$shift['shift2_to']); 
                $shift_data[] = $data_shift;
            }
            if($shift['shift3']==1){
                $data_shift['shift'] = 3;
                $data_shift['shift_start'] = date('H:i:s',strtotime($shift['shift3_from']));
                $data_shift['shift_end'] = date('H:i:s',strtotime($shift['shift3_to']));
                $data_shift['timings'] = $this->dashboard_model->shift_timing_list($shift['shift3_from'],$shift['shift3_to']); 
                $shift_data[] = $data_shift;
            }            
            if(count($shift_data)==0){
                $data_shift['shift'] = 1;
                $data_shift['shift_start'] = date('H:i:s',strtotime(DEFAULT_SHIFT1_START_TIME));
                
                if (defined('DEFAULT_SHIFT_AFTER_EIGHT_END_TIME')) {
                    $data_shift['shift_end'] = date('H:i:s',strtotime(DEFAULT_SHIFT_AFTER_EIGHT_END_TIME));
                }else{
                    $data_shift['shift_end'] = date('H:i:s',strtotime(DEFAULT_SHIFT1_END_TIME));
                }                 
                $data_shift['timings'] = $this->dashboard_model->shift_timing_list(DEFAULT_SHIFT1_START_TIME,DEFAULT_SHIFT1_END_TIME); 
                $shift_data[] = $data_shift;
            }
            //echo "<pre>";print_r($shift_data);exit;
            return  $shift_data;
    }
    
/*    public function setup_check(){
	$machine_name = $this->input->get('machine_name');
    $mc_status = $this->input->get('setupstatus');
	$machine = $this->mobile->get_machine_id($this->input->get('machine_name'));
	$job_details_boots = $this->mobile->get_job_details_boots($this->input->get('job_code'));
	$job_details_spcs = $this->mobile->get_job_details($this->input->get('job_code'));
	$job_code = $this->input->get('job_code');
	$job_id = $job_details_spcs['id'];
	//$status = $this->input->get('status');
	
	$s=0;		
	if($job_details_spcs){
		for($i=1;$i <= $job_details_spcs['side'];$i++ ){
		    if($job_details_spcs['side'] >=2){
		    $job_details_spcs_qty = $this->mobile->get_setup_qty($job_id,$i,$mc_status);
		    if($job_details_spcs_qty=='0'){
		         
		        if($s==0){
        			$multiple[] = array(
        						'id' => $i,
        						'value'=>$i,
        						'selected' => 1
        					);		            
		        }else{
		            
    			$multiple[] = array(
    						'id' => $i,
    						'value'=>$i,
    						'selected' => 0
    					);		   
		        }
		        $s++;
		    }else{
    			$multiple[] = array(
    						'id' => $i,
    						'value'=>$i,
    						'selected' => 0
    					);		        
		    }
		    }else{
        		for($i=1;$i <= 6;$i++ ){
        			$multiple[] = array(
        						'id' => $i,
        						'value'=>$i,
        						'selected' => 0
        					);
        		}		        
		        
		    }
		}
		if($job_details_spcs['side'] >= 2){
			// multiple handling
			$result['result']	   = 'success';
			$result['message']	   = 'order status details retrieved successfully';
			$result['data']		   = array(
							array(
								'id'=>1,
								'value' =>'Front',
								'selected'=>0,
								'side'=>null
							),
						/*array(
								'id'=>2,
								'value' =>'Front and Back',
								'selected'=>0, 
								'side' => array(
										array(
											'id' =>1,
											'value' =>'Front',
											'selected' =>0,
									  	),
									  	array(
											'id' =>2,
											'value' =>'Back',
											'selected' =>0,
									  	)
									  )
							),*/
						/*	array(
								'id'=>3,
								'value' =>'Multiple',
								'selected'=>1, 
								'side'=>$multiple
							)
						     );
			echo json_encode($result);
			
		}elseif($job_details_spcs['side']=='2'){

		   $job_details_spcs1 = $this->mobile->get_side_details($job_details_spcs['id'],1,$mc_status);
		    $job_details_spcs2 = $this->mobile->get_side_details($job_details_spcs['id'],2,$mc_status);
		    if($job_details_spcs1>0){
		        $selected = 0;
        		    if($job_details_spcs2>0){
        		        $selected1 = 0;
        		    }else{
        		        
        		        $selected1= 1;
        		    }		        
		    }else{
		        $selected =1;
		        $selected1 =0;
		    }
		    if($job_details_spcs1>0 && $job_details_spcs>0){
		        
		       	$selected =0;
		        $selected1 =1; 
		        
		    }
			// front and back handling
			$result['result']	   = 'success';
			$result['message']	   = 'order status details retrieved successfully';
			$result['data']		   = array(
							array(
								'id'=>1,
								'value' =>'Front',
								'selected'=>0,
								'side'=>null
							),
							/*array(
								'id'=>2,
								'value' =>'Front and Back',
								'selected'=>1, 
								'side' => array(
										array(
											'id' =>1,
											'value' =>'Front',
											'selected' =>$selected,
									  	),
									  	array(
											'id' =>2,
											'value' =>'Back',
											'selected' =>$selected1,
									  	)
									  )
							),*/
						/*	array(
								'id'=>3,
								'value' =>'Multiple',
								'selected'=>1,
								'side'=>$multiple
							)
						     );
						    
			echo json_encode($result);
		
		}else{
			// single side handling
			$result['result']	   = 'success';
			$result['message']	   = 'order status details retrieved successfully';
			$result['data']		   = array(
							array(
								'id'=>1,
								'value' =>'Front',
								'selected'=>1,
								'side'=>null
							),
							/*array(
								'id'=>2,
								'value' =>'Front and Back',
								'selected'=>0,
								'side' => array(
										array(
											'id' =>1,
											'value' =>'Front',
											'selected' =>0,
									  	),
									  	array(
											'id' =>2,
											'value' =>'Back',
											'selected' =>0,
									  	)
									  )
							),*/
							/*array(
								'id'=>3,
								'value' =>'Multiple',
								'selected'=>0,
								'side'=>$multiple
							)
						     );
			echo json_encode($result);
		}
	}else{
	    echo json_encode(array('result' =>'failure','message'=>'Job not found in beamon shop.'));
	}
    }
    
    public function tooling_check(){
    $mc_status = $this->input->get('toolingstatus');
	$machine_name = $this->input->get('machine_name');
	$machine = $this->mobile->get_machine_id($this->input->get('machine_name'));
	$job_details_boots = $this->mobile->get_job_details_boots($this->input->get('job_code'));
	$job_details_spcs = $this->mobile->get_job_details($this->input->get('job_code'));
	$job_code = $this->input->get('job_code');
	// $status = $this->input->get('status');
	if($job_details_spcs){
		$total_qty	= $job_details_spcs['qty'];
	    $s= 0;
	    $k = 0;
		for($i=1;$i <= $total_qty;$i++ ){
		    $job_details_spcs_qty = $this->mobile->get_qty_details($job_details_spcs['id'],$i,$mc_status);
		   
		    
		    if($job_details_spcs_qty==0){
		        if($s==0){
        			$qty[] = array(
        						'id' => $i,
        						'value'=>$i,
        						'selected' => 1
        					);		            
		        }else{
        			$qty[] = array(
        						'id' => $i,
        						'value'=>$i,
        						'selected' => 0
        					);		            
		        }
		        $s++;
		    }else{
    			$qty[] = array(
    						'id' => $i,
    						'value'=>$i,
    						'selected' => 0
    					);		        
		    }
		}
		
		$qty_data	   =  $qty;
	
		$m = 0;
		for($i=1;$i <= $job_details_spcs['qty'];$i++ ){
		    if($job_details_spcs['side'] >= 2){
		    $job_details_spcs_qty = $this->mobile->get_qty_details($job_details_spcs['id'],$i,$mc_status);
		    if($job_details_spcs_qty==0){
		        if($m==0){
		            
        			$multiple[] = array(
        						'id' => $i,
        						'value'=>$i,
        						'selected' => 1
        					);		            
		        }else{
		            
    			$multiple[] = array(
    						'id' => $i,
    						'value'=>$i,
    						'selected' => 0
    					);		   
		        }
		        $m++;
		    }else{
    			$multiple[] = array(
    						'id' => $i,
    						'value'=>$i,
    						'selected' => 0
    					);		        
		    }
		    }else{
        		for($k=1;$k<= 6;$k++ ){
        		    
        			$multiple[] = array(
        						'id' => $k,
        						'value'=>$k,
        						'selected' => 0
        					);
        		}
        		
		    }
		    
		}
		if($job_details_spcs['side'] >= 2){
            $aq= 0;
            $multiple = '';
		    $side_f = 0;
		    $side_b = 0;
		    $s_front = 0;
		    $s_back = 0;
		    $side_val = 1;
		    $m=0;
		    $s=0;
		    $side_m = 0;
		    $multi_selected_chek = 0;
		    $completed_side=array();
		    $qty_completed_array = array();
		    $db_qty = 0;
		    $selected_qty = 1;
		   
                if($mc_status=='ts'){
                    for($s=1;$s<=$job_details_spcs['side'];$s++ ){
                        for($i=1;$i <= $job_details_spcs['qty'];$i++ ){
                            
                        $side_multiple =   $this->mobile->total_qty_check($job_details_spcs['id'],$i,$s,$mc_status);

                         if($side_multiple==1){
                             $side_m++;
                             $m++;
                         }
                         if($side_m==$job_details_spcs['qty']){
                             
                             array_push($completed_side,$s);
                             $side_m = 0;
                         }
                         	$job_details_spcs_qty = $this->mobile->get_qty_details_multiple($job_details_spcs['id'],$i,$s,$mc_status);
                             if($db_qty==0){	
                             	if($job_details_spcs_qty==0){
                             	    $selected_qty = $i;
                             	    $db_qty++;
                             	}
                             }
                         
                        }
                        

                        
                        
                        if(!empty($completed_side)){
                            if (in_array($s, $completed_side)){
                                
                         			$multiple[] = array(
                        						'id' => $s,
                        						'value'=>$s,
                        						'selected' => 0
                        					);	                           
                            }else{
                                if($multi_selected_chek==0){
                           			$multiple[] = array(
                        						'id' => $s,
                        						'value'=>$s,
                        						'selected' => 1
                        					);
                        					$multi_selected_chek++;
                                }else{
                                    
                            			$multiple[] = array(
                        						'id' => $s,
                        						'value'=>$s,
                        						'selected' => 0
                        					);                                   
                                }
                            }
                    }else{
                        if($s==1){
                			$multiple[] = array(
            						'id' => $s,
            						'value'=>$s,
            						'selected' => 1
            					);
                        }else{
                			$multiple[] = array(
            						'id' => $s,
            						'value'=>$s,
            						'selected' => 0
            					);                            
                        }
                        
                    }

                }
                unset($qty);
                unset($qty_data);
                for($i=1;$i <= $job_details_spcs['qty'];$i++ ){
    		        if($selected_qty==$i){
            			
            			$qty[] = array(
            						'id' => $i,
            						'value'=>$i,
            						'selected' => 1
            					);		            
    		        }else{
            			$qty[] = array(
            						'id' => $i,
            						'value'=>$i,
            						'selected' => 0
            					);		            
    		        } 
                }
                $qty_data	   =  $qty;
                
                }else{
                    for($s=1;$s <= $job_details_spcs['side'];$s++ ){
                        for($i=1;$i <= $job_details_spcs['qty'];$i++ ){
                            
                         $side_multiple =   $this->mobile->total_qty_check($job_details_spcs['id'],$i,$s,$mc_status);
                         if($side_multiple==1){
                             $side_m++;
                         }
                         if($side_m==$job_details_spcs['qty']){
                             
                             array_push($completed_side,$s);
                             $side_m = 0;
                         }
                     	$job_details_spcs_qty = $this->mobile->get_qty_details_multiple($job_details_spcs['id'],$i,$s,$mc_status);
                         if($db_qty==0){	
                         	if($job_details_spcs_qty==0){
                         	    $selected_qty = $i;
                         	    $db_qty++;
                         	}
                         }                         
                        }
                        if(!empty($completed_side)){
                            if (in_array($s, $completed_side)){
                         			$multiple[] = array(
                        						'id' => $s,
                        						'value'=>$s,
                        						'selected' => 0
                        					);	                           
                            }else{
                                if($multi_selected_chek==0){
                           			$multiple[] = array(
                        						'id' => $s,
                        						'value'=>$s,
                        						'selected' => 1
                        					);
                        					$multi_selected_chek++;
                                }else{
                                    
                            			$multiple[] = array(
                        						'id' => $s,
                        						'value'=>$s,
                        						'selected' => 0
                        					);                                   
                                }
                            }
                    }else{
                        if($s==1){
                			$multiple[] = array(
            						'id' => $s,
            						'value'=>$s,
            						'selected' => 1
            					);
                        }else{
                			$multiple[] = array(
            						'id' => $s,
            						'value'=>$s,
            						'selected' => 0
            					);                            
                        }
                        
                    }
                } 
                unset($qty);
                unset($qty_data);
                for($i=1;$i <= $job_details_spcs['qty'];$i++ ){
    		        if($selected_qty==$i){
            			
            			$qty[] = array(
            						'id' => $i,
            						'value'=>$i,
            						'selected' => 1
            					);		            
    		        }else{
            			$qty[] = array(
            						'id' => $i,
            						'value'=>$i,
            						'selected' => 0
            					);		            
    		        }
    		        
                }
                $qty_data	   =  $qty;            
            }
			// multiple handling
			$result['result']	   = 'success';
			$result['message']	   = 'order status details retrieved successfully';
			$result['data']		   = array(
							'total_qty' =>$total_qty,
							'qtylist' =>$qty_data,
							'side' => array(
								array(
									'id'=>1,
									'value' =>'Front',
									'selected'=>0,
									'side'=>null
								),
								/*array(
									'id'=>2,
									'value' =>'Front and Back',
									'selected'=>0,
									'side' => array(
											array(
												'id' =>1,
												'value' =>'Front',
												'selected' =>0,
										  	),
										  	array(
												'id' =>2,
												'value' =>'Back',
												'selected' =>0,
										  	)
										  )
								),*/
								/*array(
									'id'=>3,
									'value' =>'Multiple',
									'selected'=>1,
									'side'=>$multiple
								)
						     	)
						     );
                
				echo json_encode($result);
			
		}elseif($job_details_spcs['side'] == 2){
		    
		    $side_f = 0;
		    $side_b = 0;
		    $s_front = 0;
		    $s_back = 0;
		    $side_val = 1;
                if($mc_status=='ts'){
                    for($i=1;$i <= $job_details_spcs['qty'];$i++ ){
                        $total_side_front = $this->mobile->total_qty_check($job_details_spcs['id'],$i,1,$mc_status);
                        
                        if($total_side_front==1){
                            $side_f++;
                        }
                        if($side_f==$job_details_spcs['qty']){
                            $side_val = 2;
                            $s_front = 0;
                            $total_side_back = $this->mobile->total_qty_check($job_details_spcs['id'],$i,2,$mc_status);   
                                if($total_side_back==1){
                                    $side_b++;
                                }
                                if($side_b==$job_details_spcs['qty']){
                                    $s_back = 1;
                                }else{
                                    $s_back = 1;
                                }
                        }else{
                            $s_front = 1;
                            $side_val = 1;
                        }
                        $qty_data = $this->multipleside($job_details_spcs['id'],$i,$side_val,$mc_status);
                    }
                    
                    
                }else{
                    
                    for($i=1;$i <= $job_details_spcs['qty'];$i++ ){
                        $total_side_front = $this->mobile->total_qty_check($job_details_spcs['id'],$i,1,$mc_status);
                        
                        if($total_side_front==1){
                            $side_f++;
                        }
                        if($side_f==$job_details_spcs['qty']){
                            $side_val = 2;
                            $s_front = 0;
                            $total_side_back = $this->mobile->total_qty_check($job_details_spcs['id'],$i,2,$mc_status);   
                                if($total_side_back==1){
                                    $side_b++;
                                }
                                if($side_b==$job_details_spcs['qty']){
                                    $s_back = 1;
                                }else{
                                    $s_back = 1;
                                }
                        }else{
                            $s_front = 1;
                            $side_val = 1;
                        }
                        $qty_data = $this->multipleside($job_details_spcs['id'],$i,$side_val,$mc_status);
                    }
                }
			// front and back handling
			$result['result']	   = 'success';
			$result['message']	   = 'order status details retrieved successfully';
			$result['data']		   = array(
							'total_qty' =>$total_qty,
							'qtylist' =>$qty_data,
							'side' => array(
								array(
									'id'=>1,
									'value' =>'Front',
									'selected'=>0,
									'side'=>null
								),
								/*array(
									'id'=>2,
									'value' =>'Front and Back',
									'selected'=>1,
									'side' => array(
											array(
												'id' =>1,
												'value' =>'Front',
												'selected' =>$s_front,
										  	),
										  	array(
												'id' =>2,
												'value' =>'Back',
												'selected' =>$s_back,
										  	)
										  )
								),*/
							/*	array(
									'id'=>3,
									'value' =>'Multiple',
									'selected'=>1,
									'side'=>$multiple
								)
							)
						     );

			echo json_encode($result);
		
		}else{
			// single side handling
			$result['result']	   = 'success';
			$result['message']	   = 'order status details retrieved successfully';
			$result['data']		   = array(
							'total_qty' =>$total_qty,
							'qtylist' =>$qty_data,
							'side' => array(
								array(
									'id'=>1,
									'value' =>'Front',
									'selected'=>1,
									'side'=>null
								),
								/*array(
									'id'=>2,
									'value' =>'Front and Back',
									'selected'=>0,
									'side' => array(
											array(
												'id' =>1,
												'value' =>'Front',
												'selected' =>0,
										  	),
										  	array(
												'id' =>2,
												'value' =>'Back',
												'selected' =>0,
										  	)
										  )
								),*/
							/*	array(
									'id'=>3,
									'value' =>'Multiple',
									'selected'=>0,
									'side'=>$multiple
								)
						     	)
						     );
			echo json_encode($result);
		}
	}else{
	    echo json_encode(array('result' =>'failure','message'=>'Job not found in beamon shop.'));
	}
    } */
    
     public function setup_check(){
	$machine_name = $this->input->get('machine_name');
    $mc_status = $this->input->get('setupstatus');
	$machine = $this->mobile->get_machine_id($this->input->get('machine_name'));
	$job_details_boots = $this->mobile->get_job_details_boots($this->input->get('job_code'));
	$job_details_spcs = $this->mobile->get_job_details($this->input->get('job_code'));
	$job_code = $this->input->get('job_code');
	$job_id = $job_details_spcs['id'];
	//$status = $this->input->get('status');
	$s=0;		
	if($job_details_spcs){
	    
    	    if($job_details_spcs['share_status']==1){
    	        
    	        $result['result']	   = 'success';
    			$result['message']	   = 'order status details retrieved successfully';
    			$result['data']		   = array(
    							array(
    								'id'=>1,
    								'value' =>'Share',
    								'selected'=>1,
    								'side'=>null
    							),
    						     );
    		    echo json_encode($result);
    	        
    	    }else{
    	    
    		for($i=1;$i <= $job_details_spcs['side'];$i++ ){
        		    if($job_details_spcs['side'] >= 2){
            		    $job_details_spcs_qty = $this->mobile->get_setup_qty($job_id,$i,$mc_status);
            		    if($job_details_spcs_qty=='0'){
            		         
            		        if($s==0){
                    			$multiple[] = array(
                    						'id' => $i,
                    						'value'=>$i,
                    						'selected' => 1
                    					);		            
            		        }else{
            		            
                			$multiple[] = array(
                						'id' => $i,
                						'value'=>$i,
                						'selected' => 0
                					);		   
            		        }
            		        $s++;
            		    }else{
                			$multiple[] = array(
                						'id' => $i,
                						'value'=>$i,
                						'selected' => 0
                					);		        
            		    }
            		    }else{
                    		for($i=1;$i <= 6;$i++ ){
                    			$multiple[] = array(
                    						'id' => $i,
                    						'value'=>$i,
                    						'selected' => 0
                    					);
                    		}		        
        		        
        		    }
    		}
    		
    		
    		if($job_details_spcs['side'] >= 2){
    			// multiple handling
    			$result['result']	   = 'success';
    			$result['message']	   = 'order status details retrieved successfully';
    			$result['data']		   = array(
    							array(
    								'id'=>1,
    								'value' =>'Front',
    								'selected'=>0,
    								'side'=>null
    							),
    							/*array(
    								'id'=>2,
    								'value' =>'Front and Back',
    								'selected'=>0, 
    								'side' => array(
    										array(
    											'id' =>1,
    											'value' =>'Front',
    											'selected' =>0,
    									  	),
    									  	array(
    											'id' =>2,
    											'value' =>'Back',
    											'selected' =>0,
    									  	)
    									  )
    							),*/
    							array(
    								'id'=>3,
    								'value' =>'Multiple',
    								'selected'=>1, 
    								'side'=>$multiple
    							)
    						     );
    			echo json_encode($result);
    			
    		}elseif($job_details_spcs['side']=='2'){
    
    		   $job_details_spcs1 = $this->mobile->get_side_details($job_details_spcs['id'],1,$mc_status);
    		    $job_details_spcs2 = $this->mobile->get_side_details($job_details_spcs['id'],2,$mc_status);
    		    if($job_details_spcs1>0){
    		        $selected = 0;
            		    if($job_details_spcs2>0){
            		        $selected1 = 0;
            		    }else{
            		        
            		        $selected1= 1;
            		    }		        
    		    }else{
    		        $selected =1;
    		        $selected1 =0;
    		    }
    		    if($job_details_spcs1>0 && $job_details_spcs>0){
    		        
    		       	$selected =0;
    		        $selected1 =1; 
    		        
    		    }
    			// front and back handling
    			$result['result']	   = 'success';
    			$result['message']	   = 'order status details retrieved successfully';
    			$result['data']		   = array(
    							array(
    								'id'=>1,
    								'value' =>'Front',
    								'selected'=>0,
    								'side'=>null
    							),
    							/*array(
    								'id'=>2,
    								'value' =>'Front and Back',
    								'selected'=>1, 
    								'side' => array(
    										array(
    											'id' =>1,
    											'value' =>'Front',
    											'selected' =>$selected,
    									  	),
    									  	array(
    											'id' =>2,
    											'value' =>'Back',
    											'selected' =>$selected1,
    									  	)
    									  )
    							),*/
    							array(
    								'id'=>3,
    								'value' =>'Multiple',
    								'selected'=>1,
    								'side'=>$multiple
    							)
    						     );
    						    
    			echo json_encode($result);
    		
    		}else{
    			// single side handling
    			$result['result']	   = 'success';
    			$result['message']	   = 'order status details retrieved successfully';
    			$result['data']		   = array(
    							array(
    								'id'=>1,
    								'value' =>'Front',
    								'selected'=>1,
    								'side'=>null
    							),
    							/*array(
    								'id'=>2,
    								'value' =>'Front and Back',
    								'selected'=>0,
    								'side' => array(
    										array(
    											'id' =>1,
    											'value' =>'Front',
    											'selected' =>0,
    									  	),
    									  	array(
    											'id' =>2,
    											'value' =>'Back',
    											'selected' =>0,
    									  	)
    									  )
    							),*/
    							array(
    								'id'=>3,
    								'value' =>'Multiple',
    								'selected'=>0,
    								'side'=>$multiple
    							)
    						     );
    			echo json_encode($result);
    		}
    	}
	}else{
	    echo json_encode(array('result' =>'failure','message'=>'Job not found in beamon shop.'));
	}
    }
    
    public function tooling_check(){
        $mc_status = $this->input->get('toolingstatus');
    	$machine_name = $this->input->get('machine_name');
    	$machine = $this->mobile->get_machine_id($this->input->get('machine_name'));
    	$job_details_boots = $this->mobile->get_job_details_boots($this->input->get('job_code'));
    	$job_details_spcs = $this->mobile->get_job_details($this->input->get('job_code'));
    	$job_code = $this->input->get('job_code');
    	// $status = $this->input->get('status');
    	if($job_details_spcs){
    	    if($job_details_spcs['share_status']==1){
    			$result['result']	   = 'success';
    			$result['message']	   = 'order status details retrieved successfully';
    			
    			$qty[] = array(
    						'id' => 1,
    						'value'=>1,
    						'selected' => 1
    					);
    			$qty_data =  $qty;		
    					
			    $result['data']		   = array(
							'total_qty' =>1,
							'qtylist' =>$qty_data,
							'side' => array(
    								array(
    									'id'=>1,
    									'value' =>'share',
    									'selected'=>1,
    									'side'=>null
    								),
						     	)
						     );
				echo json_encode($result);	        
	        
	    }else{
		$total_qty	= $job_details_spcs['qty'];
	    $s= 0;
	    $k = 0;
		for($i=1;$i <= $total_qty;$i++ ){
		    $job_details_spcs_qty = $this->mobile->get_qty_details($job_details_spcs['id'],$i,$mc_status);
		   
		    
		    if($job_details_spcs_qty==0){
		        if($s==0){
        			$qty[] = array(
        						'id' => $i,
        						'value'=>$i,
        						'selected' => 1
        					);		            
		        }else{
        			$qty[] = array(
        						'id' => $i,
        						'value'=>$i,
        						'selected' => 0
        					);		            
		        }
		        $s++;
		    }else{
    			$qty[] = array(
    						'id' => $i,
    						'value'=>$i,
    						'selected' => 0
    					);		        
		    }
		}
		
		$qty_data	   =  $qty;
	
		$m = 0;
		for($i=1;$i <= $job_details_spcs['qty'];$i++ ){
		    if($job_details_spcs['side'] >= 2){
		    $job_details_spcs_qty = $this->mobile->get_qty_details($job_details_spcs['id'],$i,$mc_status);
		    if($job_details_spcs_qty==0){
		        if($m==0){
		            
        			$multiple[] = array(
        						'id' => $i,
        						'value'=>$i,
        						'selected' => 1
        					);		            
		        }else{
		            
    			$multiple[] = array(
    						'id' => $i,
    						'value'=>$i,
    						'selected' => 0
    					);		   
		        }
		        $m++;
		    }else{
    			$multiple[] = array(
    						'id' => $i,
    						'value'=>$i,
    						'selected' => 0
    					);		        
		    }
		    }else{
        		for($k=1;$k<= 6;$k++ ){
        		    
        			$multiple[] = array(
        						'id' => $k,
        						'value'=>$k,
        						'selected' => 0
        					);
        		}
        		
		    }
		    
		}
		if($job_details_spcs['side'] >=2){
            $aq= 0;
            $multiple = '';
		    $side_f = 0;
		    $side_b = 0;
		    $s_front = 0;
		    $s_back = 0;
		    $side_val = 1;
		    $m=0;
		    $s=0;
		    $side_m = 0;
		    $multi_selected_chek = 0;
		    $completed_side=array();
		    $qty_completed_array = array();
		    $db_qty = 0;
		    $selected_qty = 1;
		   
                if($mc_status=='ts'){
                    for($s=1;$s<=$job_details_spcs['side'];$s++ ){
                        for($i=1;$i <= $job_details_spcs['qty'];$i++ ){
                            
                        $side_multiple =   $this->mobile->total_qty_check($job_details_spcs['id'],$i,$s,$mc_status);

                         if($side_multiple==1){
                             $side_m++;
                             $m++;
                         }
                         if($side_m==$job_details_spcs['qty']){
                             
                             array_push($completed_side,$s);
                             $side_m = 0;
                         }
                         	$job_details_spcs_qty = $this->mobile->get_qty_details_multiple($job_details_spcs['id'],$i,$s,$mc_status);
                             if($db_qty==0){	
                             	if($job_details_spcs_qty==0){
                             	    $selected_qty = $i;
                             	    $db_qty++;
                             	}
                             }
                         
                        }
                        

                        
                        
                        if(!empty($completed_side)){
                            if (in_array($s, $completed_side)){
                                
                         			$multiple[] = array(
                        						'id' => $s,
                        						'value'=>$s,
                        						'selected' => 0
                        					);	                           
                            }else{
                                if($multi_selected_chek==0){
                           			$multiple[] = array(
                        						'id' => $s,
                        						'value'=>$s,
                        						'selected' => 1
                        					);
                        					$multi_selected_chek++;
                                }else{
                                    
                            			$multiple[] = array(
                        						'id' => $s,
                        						'value'=>$s,
                        						'selected' => 0
                        					);                                   
                                }
                            }
                    }else{
                        if($s==1){
                			$multiple[] = array(
            						'id' => $s,
            						'value'=>$s,
            						'selected' => 1
            					);
                        }else{
                			$multiple[] = array(
            						'id' => $s,
            						'value'=>$s,
            						'selected' => 0
            					);                            
                        }
                        
                    }

                }
                unset($qty);
                unset($qty_data);
                for($i=1;$i <= $job_details_spcs['qty'];$i++ ){
    		        if($selected_qty==$i){
            			
            			$qty[] = array(
            						'id' => $i,
            						'value'=>$i,
            						'selected' => 1
            					);		            
    		        }else{
            			$qty[] = array(
            						'id' => $i,
            						'value'=>$i,
            						'selected' => 0
            					);		            
    		        } 
                }
                $qty_data	   =  $qty;
                
                }else{
                    for($s=1;$s <= $job_details_spcs['side'];$s++ ){
                        for($i=1;$i <= $job_details_spcs['qty'];$i++ ){
                            
                         $side_multiple =   $this->mobile->total_qty_check($job_details_spcs['id'],$i,$s,$mc_status);
                         if($side_multiple==1){
                             $side_m++;
                         }
                         if($side_m==$job_details_spcs['qty']){
                             
                             array_push($completed_side,$s);
                             $side_m = 0;
                         }
                     	$job_details_spcs_qty = $this->mobile->get_qty_details_multiple($job_details_spcs['id'],$i,$s,$mc_status);
                         if($db_qty==0){	
                         	if($job_details_spcs_qty==0){
                         	    $selected_qty = $i;
                         	    $db_qty++;
                         	}
                         }                         
                        }
                        if(!empty($completed_side)){
                            if (in_array($s, $completed_side)){
                         			$multiple[] = array(
                        						'id' => $s,
                        						'value'=>$s,
                        						'selected' => 0
                        					);	                           
                            }else{
                                if($multi_selected_chek==0){
                           			$multiple[] = array(
                        						'id' => $s,
                        						'value'=>$s,
                        						'selected' => 1
                        					);
                        					$multi_selected_chek++;
                                }else{
                                    
                            			$multiple[] = array(
                        						'id' => $s,
                        						'value'=>$s,
                        						'selected' => 0
                        					);                                   
                                }
                            }
                    }else{
                        if($s==1){
                			$multiple[] = array(
            						'id' => $s,
            						'value'=>$s,
            						'selected' => 1
            					);
                        }else{
                			$multiple[] = array(
            						'id' => $s,
            						'value'=>$s,
            						'selected' => 0
            					);                            
                        }
                        
                    }
                } 
                unset($qty);
                unset($qty_data);
                for($i=1;$i <= $job_details_spcs['qty'];$i++ ){
    		        if($selected_qty==$i){
            			
            			$qty[] = array(
            						'id' => $i,
            						'value'=>$i,
            						'selected' => 1
            					);		            
    		        }else{
            			$qty[] = array(
            						'id' => $i,
            						'value'=>$i,
            						'selected' => 0
            					);		            
    		        }
    		        
                }
                $qty_data	   =  $qty;            
            }
			// multiple handling
			$result['result']	   = 'success';
			$result['message']	   = 'order status details retrieved successfully';
			$result['data']		   = array(
							'total_qty' =>$total_qty,
							'qtylist' =>$qty_data,
							'side' => array(
								array(
									'id'=>1,
									'value' =>'Front',
									'selected'=>0,
									'side'=>null
								),
								/*array(
									'id'=>2,
									'value' =>'Front and Back',
									'selected'=>0,
									'side' => array(
											array(
												'id' =>1,
												'value' =>'Front',
												'selected' =>0,
										  	),
										  	array(
												'id' =>2,
												'value' =>'Back',
												'selected' =>0,
										  	)
										  )
								),*/
								array(
									'id'=>3,
									'value' =>'Multiple',
									'selected'=>1,
									'side'=>$multiple
								)
						     	)
						     );
                
				echo json_encode($result);
			
		}elseif($job_details_spcs['side'] == 2){
		    
		    $side_f = 0;
		    $side_b = 0;
		    $s_front = 0;
		    $s_back = 0;
		    $side_val = 1;
                if($mc_status=='ts'){
                    for($i=1;$i <= $job_details_spcs['qty'];$i++ ){
                        $total_side_front = $this->mobile->total_qty_check($job_details_spcs['id'],$i,1,$mc_status);
                        
                        if($total_side_front==1){
                            $side_f++;
                        }
                        if($side_f==$job_details_spcs['qty']){
                            $side_val = 2;
                            $s_front = 0;
                            $total_side_back = $this->mobile->total_qty_check($job_details_spcs['id'],$i,2,$mc_status);   
                                if($total_side_back==1){
                                    $side_b++;
                                }
                                if($side_b==$job_details_spcs['qty']){
                                    $s_back = 1;
                                }else{
                                    $s_back = 1;
                                }
                        }else{
                            $s_front = 1;
                            $side_val = 1;
                        }
                        $qty_data = $this->multipleside($job_details_spcs['id'],$i,$side_val,$mc_status);
                    }
                    
                    
                }else{
                    
                    for($i=1;$i <= $job_details_spcs['qty'];$i++ ){
                        $total_side_front = $this->mobile->total_qty_check($job_details_spcs['id'],$i,1,$mc_status);
                        
                        if($total_side_front==1){
                            $side_f++;
                        }
                        if($side_f==$job_details_spcs['qty']){
                            $side_val = 2;
                            $s_front = 0;
                            $total_side_back = $this->mobile->total_qty_check($job_details_spcs['id'],$i,2,$mc_status);   
                                if($total_side_back==1){
                                    $side_b++;
                                }
                                if($side_b==$job_details_spcs['qty']){
                                    $s_back = 1;
                                }else{
                                    $s_back = 1;
                                }
                        }else{
                            $s_front = 1;
                            $side_val = 1;
                        }
                        $qty_data = $this->multipleside($job_details_spcs['id'],$i,$side_val,$mc_status);
                    }
                }
			// front and back handling
			$result['result']	   = 'success';
			$result['message']	   = 'order status details retrieved successfully';
			$result['data']		   = array(
							'total_qty' =>$total_qty,
							'qtylist' =>$qty_data,
							'side' => array(
								array(
									'id'=>1,
									'value' =>'Front',
									'selected'=>0,
									'side'=>null
								),
								/*array(
									'id'=>2,
									'value' =>'Front and Back',
									'selected'=>1,
									'side' => array(
											array(
												'id' =>1,
												'value' =>'Front',
												'selected' =>$s_front,
										  	),
										  	array(
												'id' =>2,
												'value' =>'Back',
												'selected' =>$s_back,
										  	)
										  )
								),*/
								array(
									'id'=>3,
									'value' =>'Multiple',
									'selected'=>1,
									'side'=>$multiple
								)
							)
						     );

			echo json_encode($result);
		
		}else{
			// single side handling
			$result['result']	   = 'success';
			$result['message']	   = 'order status details retrieved successfully';
			$result['data']		   = array(
							'total_qty' =>$total_qty,
							'qtylist' =>$qty_data,
							'side' => array(
								array(
									'id'=>1,
									'value' =>'Front',
									'selected'=>1,
									'side'=>null
								),
								/*array(
									'id'=>2,
									'value' =>'Front and Back',
									'selected'=>0,
									'side' => array(
											array(
												'id' =>1,
												'value' =>'Front',
												'selected' =>0,
										  	),
										  	array(
												'id' =>2,
												'value' =>'Back',
												'selected' =>0,
										  	)
										  )
								),*/
								array(
									'id'=>3,
									'value' =>'Multiple',
									'selected'=>0,
									'side'=>$multiple
								)
						     	)
						     );
			echo json_encode($result);
		}
	}
	
	}else{
	    echo json_encode(array('result' =>'failure','message'=>'Job not found in beamon shop.'));
	}
    }   
    
    public function setuppopup_master(){ 
    	for($i=1;$i <= 7;$i++ ){
		$multiple[] = array(
					'id' => $i,
					'value'=>$i,
					'selected' => 0
				);
	} 
	$result['result']	   = 'success';
	$result['message']	   = 'master retrieved successfully';
	$result['data']		   = array(
						'type'=>array(
								array(
									'id'=>1,
									'value' =>'Front',
									'selected'=>0,
									'side'=>null
								),
								/*array(
									'id'=>2,
									'value' =>'Front and Back',
									'selected'=>0,
									'side'=>array(
											array(
												'id' =>1,
												'value' =>'Front',
												'selected' =>0,
										  	),
										  	array(
												'id' =>2,
												'value' =>'Back',
												'selected' =>0,
										  	)
										  )
									 
								),*/
								array(
									'id'=>3,
									'value' =>'Multiple',
									'selected'=>0,
									'side'=>$multiple
								)
							)
					);
	echo json_encode($result);
 /*
		
		
			$result['result']	   = 'success';
			$result['message']	   = 'master retrieved successfully';
			$result['data']		   = array(
							array(
								'id'=>1,
								'value' =>'Front',
								'selected'=>0
							),
							array(
								'id'=>2,
								'value' =>'Front and Back',
								'selected'=>0,
								'side'=>0,
								'sidedata' => array(
										array(
											'id' =>1,
											'value' =>'Front',
											'selected' =>0,
									  	),
									  	array(
											'id' =>2,
											'value' =>'Back',
											'selected' =>0,
									  	)
									  )
							),
							array(
								'id'=>3,
								'value' =>'Multiple',
								'selected'=>0,
								'multiple'=>0,
								'multipledata'=>$multiple
							)
						     );
	*/		
    }
    
    
    public function upcomingmcdown_ready($machine,$curdate,$curshift,$down_status){ //,$down_status
    
    	$todaydate = date('Y-m-d',strtotime($curdate));
        $nextday = date('Y-m-d',strtotime($todaydate.' +1 day'));
        $nextnextday = date('Y-m-d',strtotime($todaydate.' +2 day'));
        
        $data['days']= array(array('day'=>$todaydate),array('day'=>$nextday));
        
    	foreach ($data['days'] as $daykey => $day) {
            $data['shifts'] = $this->shift_and_timings($day['day']); 
            foreach ($data['shifts'] as $shiftkey => $shift) {
                    if( ($shift['shift_end'] <= DEFAULT_SHIFT_START_TIME ) ){
                        $shift['shift_end'] = date('Y-m-d', strtotime($day['day'].' +1 day')).' '.$shift['shift_end'];
                    }else{
                        $shift['shift_end'] = $day['day'].' '.$shift['shift_end'];
                    }
                    if(($shift['shift_start'] < DEFAULT_SHIFT_START_TIME )){
                        $shift['shift_start'] = date('Y-m-d', strtotime($day['day'].' +1 day')).' '.$shift['shift_start'];
                    }else{
                        $shift['shift_start'] = $day['day'].' '.$shift['shift_start'];
                    }
    		$check['date_from'] = date('Y-m-d',strtotime($shift['shift_start']));
    		$check['date_to'] = date('Y-m-d',strtotime($shift['shift_end']));
    		$check['shift'] = $shift['shift'];
    		$check['machine'] = $machine; 
    		//$newdown=$this->mobile->check_andready_mcdown($check); 
        		if($down_status=='m'){
        		    $newdown=$this->mobile->check_andready_mcdown($check); 
        		}else{
        		    $newdown=$this->mobile->check_andready_otherdown($check); 
        		}
    	    }
    	}
    }
	function multipleside($job_code,$total_qty,$toolingside,$toolingstatus){
    $m = 0;
		for($i=1;$i <= $total_qty;$i++ ){
			
			$job_details_spcs_qty = $this->mobile->get_qty_details_multiple($job_code,$i,$toolingside,$toolingstatus);
		    if($job_details_spcs_qty==0){
		        if($m==0){
        			$qty[] = array(
							'id' => $i,
							'value'=>$i,
							'selected' => 1
        					);		            
		        }else{
        			$qty[] = array(
							'id' => $i,
							'value'=>$i,
							'selected' => 0
        					);		            
		        }
		        $m++;
		    }else{
    			$qty[] = array(
						'id' => $i,
						'value'=>$i,
						'selected' => 0
    					);		        
		    }
		}	
		return $qty;
		
	}
	function before_last_side_with_timing_update($i,$s,$data,$job_details_spcs,$job_details_boots){		
		
		$tool_time = $this->mobile->update_end_time_check($job_details_spcs['id'],$s,$i);
		if($tool_time==0){   
    		$tooling_timing['tooling_end']	= date('Y-m-d H:i:s');
    		$tooling_timing['machine']	= $data['machine'];
    		$tooling_timing['current_qty']	= $i;
    		$tooling_timing['side']		= $s;
    		$tooling_timing['user_id']	= get_user_id($data['username']);
    		$tooling_timing['order_id']	= $job_details_spcs['id'];
    		$tooling_timing['mc_status'] = $data['mc_status'];
    		$tooling_timing['shift_time'] = $this->shift_up_time;
    		$tooling_timing['job_code'] = $job_code;
    		$update_tooling_timing = $this->mobile->update_tooling_time($tooling_timing);
			}else{
			    $update_tooling_timing = $this->mobile->update_tooling_update_at($job_details_spcs['id'],$s,$i,$this->shift_up_time);
			}
			
			
		// update tooling finish in boots
		$qty_check = $this->mobile->check_job_status_boots_qty_side($job_details_boots['tjob_id'],$s,$i);
       if($qty_check==1 || $qty_check==0){
    		$status_update['tjob_id'] = $job_details_boots['tjob_id'];
    		$status_update['update_date'] = date('Y-m-d');
    		$status_update['update_time'] = date('Y-m-d H:i:s');
    		$status_update['update_for']    = 3 ;
    		$status_update['update_status'] = 1 ;
    		$status_update['update_to'] = 'Tooling Finished Side - '.$s.' Qty -'.$i. ' - Completed By '.$data['username'];
    		$status_update['update_by'] = get_user_id($data['username']); 
    		 $status_update['update_from'] = 'mobile';
    		$job_status_update = $this->mobile->update_job_status_boots($status_update);			
       }
		
		$mcdown_updates['job_id'] = $job_details_spcs['id'];
		$mcdown_updates['updated_for'] = 6; 
		$mcdown_updates['updated_to'] = 'Tooling Finished - Side('.$s.'/'.$job_details_spcs['side'].') - Qty('.$i.'/'.$job_details_spcs['qty'].') - '.$data['machine_name'];
		$mcdown_updates['updated_by'] =   $data['username']; 
		$mcdown_updates['updated_status'] = 2;
		$mcdown_updates['updated_remark'] = '';
		$mcdown_updates['qty_no']	= $i;
		$mcdown_updates['qty_status']	= 1;
		$mcdown_updates['mechine_status'] = 't2';
		$mcdown_updates['mc_status'] = $data['mc_status'];
		$mcdown_updates['side']	= $s;
		$mcdown_updates['tot_side'] = $job_details_spcs['side'];			
		mcdown_updates($mcdown_updates);
		return $update_tooling_timing;							
	}
	function multiple_side_qty_timing_update($i,$s,$data,$job_details_spcs,$job_details_boots){
	
		$tool_time = $this->mobile->update_end_time_check($job_details_spcs['id'],$s,$i);
		if($tool_time==0){ 		
    		$tooling_timing['tooling_end']	= date('Y-m-d H:i:s');
    		$tooling_timing['machine']	= $data['machine'];
    		$tooling_timing['current_qty']	= $i;
    		$tooling_timing['side']		= $s;
    		$tooling_timing['user_id']	= get_user_id($data['username']);
    		$tooling_timing['order_id']	= $job_details_spcs['id'];
    		$tooling_timing['shift_time'] = $this->shift_up_time;
    		$tooling_timing['job_code'] = $job_code;
    		
    		$update_tooling_timing = $this->mobile->update_tooling_time($tooling_timing);
			}else{
			    $update_tooling_timing = $this->mobile->update_tooling_update_at($job_details_spcs['id'],$s,$i,$this->shift_up_time);
			}
			
		// update tooling finish in boots
		$qty_check = $this->mobile->check_job_status_boots_qty_side($job_details_boots['tjob_id'],$s,$i);
        if($qty_check==1 || $qty_check==0){    		
    		$status_update['tjob_id'] = $job_details_boots['tjob_id'];
    		$status_update['update_date'] = date('Y-m-d');
    		$status_update['update_time'] = date('Y-m-d H:i:s');
    		$status_update['update_for']    = 3 ;
    		$status_update['update_status'] = 1 ;
    		$status_update['update_to'] = 'Tooling Finished  Side - '.$s.' Qty -'.$i. ' - Completed By '.$data['username'];
    		$status_update['update_by'] = get_user_id($data['username']); 
    		$status_update['update_from'] = 'mobile';
    		$job_status_update = $this->mobile->update_job_status_boots($status_update);			
        }
			
			$mcdown_updates['job_id'] = $job_details_spcs['id'];
			$mcdown_updates['updated_for'] = 6; 
			$mcdown_updates['updated_to'] = 'Tooling Finished - Side('.$s.'/'.$job_details_spcs['side'].') - Qty('.$i.'/'.$job_details_spcs['qty'].') - '.$data['machine_name'];
			$mcdown_updates['updated_by'] =   $data['username']; 
			$mcdown_updates['updated_status'] = 2;
			$mcdown_updates['updated_remark'] = '';
			$mcdown_updates['qty_no']	= $i;
			$mcdown_updates['qty_status']	= 1;
			$mcdown_updates['mechine_status'] = 't2';
			$mcdown_updates['mc_status'] = $data['mc_status'];
			$mcdown_updates['side']	= $s;
			$mcdown_updates['tot_side'] = $job_details_spcs['side'];			
			mcdown_updates($mcdown_updates);
			return $update_tooling_timing;								
	}
	function multiple_last_side_qty_timing_update($i,$s,$job_details_spcs,$data,$job_details_boots,$job_code){
	    
				// update tooling finish in sfcs
					$spcs_update['tooling_end'] = date('Y-m-d H:i:s');
					$spcs_update['time_to']=date('H:i:00');
					$spcs_update['job_complete_status'] = 2;
					$spcs_update['task'] = 1;
					
					//$spcs_update['shift_time'] = 2;
					$job_status_update = $this->mobile->update_jobstatus($spcs_update,$job_details_spcs['id']);
					$samejob_update['job_complete_status'] = 2;
					$samejob_job_status_update = $this->mobile->update_jobstatus_samejob($samejob_update,$data['job_code']);
					
				//update tooling finish in sfcs tooling times
            		$tool_time = $this->mobile->update_end_time_check($job_details_spcs['id'],$s,$i);
            		if($tool_time==0){ 				
    					$tooling_timing['tooling_end']	= $spcs_update['tooling_end'];
    					$tooling_timing['machine']	= $data['machine'];
    					$tooling_timing['current_qty']	= $i;
    					$tooling_timing['side']		= $s;
    					$tooling_timing['user_id']	= get_user_id($data['username']);
    					$tooling_timing['order_id']	= $job_details_spcs['id'];
    					$tooling_timing['mc_status']	= $data['mc_status'];
    					$tooling_timing['shift_time'] = $this->shift_up_time;
    					$tooling_timing['job_code'] = $job_code;
    					
    					$update_tooling_timing = $this->mobile->update_tooling_time($tooling_timing);
            			}else{
            			    $update_tooling_timing = $this->mobile->update_tooling_update_at($job_details_spcs['id'],$s,$i,$this->shift_up_time);
            			}
				// Machine Time Update Status
				$tooling_totaltime = $this->mobile->get_totaltooling_time($job_code,$data['machine'],$job_details_spcs['side'],$job_details_spcs['qty']);	
        		// update tooling finish in boots
        		if($job_details_spcs['share_status']==1){
        		    $qty_check = 1;
        		}else{
        		    $qty_check = $this->mobile->check_job_status_boots_qty_side($job_details_boots['tjob_id'],$s,$i);
        		}
        		
                if($qty_check==1 || $qty_check==0){  
					$status_update['tjob_id'] = $job_details_boots['tjob_id'];
					$status_update['update_date'] = date('Y-m-d');
					$status_update['update_time'] = date('Y-m-d H:i:s');
					$status_update['update_for']    = 3 ;
					$status_update['update_status'] = 1 ;  //- time Updated - '.$tooling_totaltime['hour'].':'.$tooling_totaltime['min'];
					$status_update['update_to'] = 'Tooling Finished  Side -'.$s.' Qty -'.$i. ' Working By '.$data['username'];
					$status_update['update_by'] = get_user_id($data['username']); 
					 $status_update['update_from'] = 'mobile';
					$job_status_update = $this->mobile->update_job_status_boots($status_update);
                    }
						$update['machine_time_hr']  = $tooling_totaltime['hour'];
						$update['machine_time_min'] = $tooling_totaltime['min'];
						
						//$update['tjob_tooling_status'] = 2 ;
						$update['tjob_tooling_lupdate'] = $tooling_timing['tooling_end'];
						$job_update = $this->mobile->update_job_details_boots($update,$job_code);
    	        
						$mcdown_updates['job_id'] = $job_details_spcs['id'];
						$mcdown_updates['updated_for'] = 6; 
						$mcdown_updates['updated_to'] = 'Tooling Finished - Side('.$s.'/'.$job_details_spcs['side'].') - Qty('.$i.'/'.$job_details_spcs['qty'].') - '.$data['machine_name'];
						$mcdown_updates['updated_by'] =   $data['username']; 
						$mcdown_updates['updated_status'] = 2;
						$mcdown_updates['updated_remark'] = '';
						$mcdown_updates['qty_no']	= $i;
						$mcdown_updates['qty_status']	= 1;
						$mcdown_updates['mechine_status'] = 't2';
						$mcdown_updates['mc_status'] = $data['mc_status'];
						$mcdown_updates['side']	= $s;
						$mcdown_updates['tot_side'] = $job_details_spcs['side'];			
						mcdown_updates($mcdown_updates);
						
						$this->last_job_tooling_finish($data['job_code']);
						
						
						return $update_tooling_timing;							
			}
			
        public function base64_string($base64_string,$job_code){

                $data = str_replace('data:image/png;base64,', '', $base64_string);
                
                $data = str_replace(' ', '+', $data);
                
                $data = base64_decode($data);
                
                $file = 'images/'.$job_code . '.png';
                
                $success = file_put_contents($file, $data);
                
                $data1 = str_replace('data:image/png;base64,', '', $base64_string);
                
                $data1 = str_replace(' ', '+', $data1);
                
               // $data1 = base64_decode($data1);
                
                //$file1 = '/home/indias9/public_html/wims/images/sign/'.$job_code . '.png';
                
               // $success1 = file_put_contents($file1, $data1);                
                
                return $success;

            }
            
        	function getSameJobCode($job_code){
        		$date = date('Y-m-d');
        		$next_date = date('Y-m-d', strtotime("+1 day", strtotime($date)));
        		$this->db->where('job_code',$job_code);
        		$this->db->where('date_from',$next_date);
        		$this->db->where('setup',0);
        		$query = $this->db->get('tbl_mcdown');

        		if($query->num_rows()>0){
        			
             		$this->db->where('job_code',$job_code);
            		$this->db->where('date_from',$date);
            		$this->db->where('setup',0);       			
        			$result = $this->db->get('tbl_mcdown');
        				if($result->num_rows()>0){
                			$id = $query->row();
                			$this->db->where('id',$id->id);
                			$this->db->delete('tbl_mcdown');   
                			
                          		$this->db->where('job_code',$job_code);
                        		$this->db->where('date_from',$date);
                        		$this->db->where('setup',0);       			
                    			$res = $this->db->get('tbl_mcdown');  
                    			$shift_end = $res->row();
                    			
                          		$shift_end_time = $this->mobile->getShiftEnd1($shift_end->date_from);
                        		$data = array('time_to'=>$shift_end_time);
                        		$this->db->where('id',$shift_end->id);
                        		$this->db->update('tbl_mcdown',$data); 
        				}
        				return 1;
        		}else{
        			return 0;
        		}
        	}
        	
        	function same_job_tooling_finish($job_code){
        	    
        		$data = array(
        		    'job_complete_status'=>1,
        		    'setup_status'=>2
        		);
        		$this->db->where('job_complete_status!=',2);
        		$this->db->where('setup!=',0);
        		$this->db->where('job_code',$job_code);
        		if($this->db->update('tbl_mcdown',$data)){
        		    
     				$this->db->where('job_code',$job_code);
    				$this->db->order_by("id","desc");
    				$result=$this->db->get(TBL_MCDOWN)->result_array();
    	
                    $this->db->select('tooling_id');
                    $this->db->where('order_id',$result[0]['id']);
                    $tooling_result=$this->db->get('tbl_tooling_timings')->result_array();
                    if(count($tooling_result)>0){
                        $this->db->where('tooling_id',$tooling_result[0]['tooling_id']);
                        $this->db->update('tbl_tooling_timings', array('tooling_start'=>date('Y-m-d H:i:s')));
                    }         		    
        		}
        		return $job_code;
        	} 
        	
        	function last_job_tooling_finish($job_code){
        	    
        		$data = array(
        		    'job_complete_status'=>2,
        		    'setup'=>2
        		);
        		$this->db->where('setup!=',0);
        		$this->db->where('job_code',$job_code);
        		$this->db->update('tbl_mcdown',$data);
        		return $job_code;
        	}         	
        	function autoprevjob_tooling_finish($job_code){
        		$date = date('Y-m-d');
        		$prev_date = date('Y-m-d', strtotime("-1 day", strtotime($date)));
        		$data = array(
        		    'job_complete_status'=>1,
        		    'time_to' =>$this->mobile->getShiftEnd1($prev_date)
        		);
        		$this->db->where('job_complete_status',0);
        		$this->db->where('date_from',$prev_date);
        		$this->db->where('job_code',$job_code);
        		$this->db->update('tbl_mcdown',$data);
        		return $job_code;
        	}
        	
         	function autoprevjob_setup_finish($job_code){
        		$date = date('Y-m-d');
        		$prev_date = date('Y-m-d', strtotime("-1 day", strtotime($date)));
        		$data = array(
        		    'setup'=>2
        		);
        		//$this->db->where('date_from',$prev_date);
        		$this->db->where('job_code',$job_code);
        		$this->db->update('tbl_mcdown',$data);
        		return $job_code;
        	}
        	function cron_run(){
	            $url = base_url().'cron/moving_loaded_jobs_current_time';
                file_get_contents($url);
                return 1;
        	}
			function check_hold($machine,$job_code,$date){
				$this->db->where('machine',$machine);
				$this->db->where('job_code',$job_code);
				$this->db->where('date_from',$date);
				//$this->db->where('hold_status',1);
				$this->db->order_by("id","desc");
				//$this->db->limit(1);
				$count = $this->db->get(TBL_MCDOWN);
				//echo $this->db->last_query();
				if($count->num_rows()>0){
				    $result = $count->result_array();
				    if($result[0]['hold_status']==1){
				        return 1; 
				    }else{
				        return 0;
				    }
				}else{
					return 0;
				}								
			}
			
			
			function hold(){
				$machine=$this->mobile->get_down_machine_id($this->input->get('machine_name'));
				$machine = $machine[0]['id'];
				$hold_status = $this->check_hold($machine,$this->input->get('job_code'),date('Y-m-d'));
				if($hold_status>0){
				    echo json_encode(array('result' =>'failure','message'=>'Job is already hold.')); 
				    exit;
				}
				$this->db->select('*');
				$this->db->where('job_code',$this->input->get('job_code'));
				$this->db->where('machine',$machine);
				$this->db->where('setup!=',0);
				$this->db->where('date_from',date('Y-m-d'));				
				$this->db->order_by("id","desc");
				$result=$this->db->get(TBL_MCDOWN)->result_array();
				if(count($result)>0){
                /**************************** GET NEXT ROW TIME INCREASE ***************************
     				$this->db->select('*');
     				$this->db->where('machine',$machine);
     				$this->db->where('date_from',date('Y-m-d'));
     				$this->db->where('time_from',$result[0]['time_to']);
    				$nextrow_result=$this->db->get(TBL_MCDOWN);

                /**************************** GET NEXT ROW TIME INCREASE ****************************/				    
					$hold_status = array('hold_status'=>1,'task'=>1,'job_complete_status'=>1,'time_to'=>date('H:i:00'),'setup_end'=>date('Y-m-d H:i:00'));
					$this->db->where('job_code',$this->input->get('job_code'));
					$this->db->where('id',$result[0]['id']);
					$this->db->update(TBL_MCDOWN,$hold_status);
                    $data = $result[0];



                    /*** Update tooling time ***/
                    
                    $this->db->select('tooling_id');
					$this->db->where('order_id',$result[0]['id']);
    				$this->db->order_by("tooling_id","desc");
    				$tooling_result=$this->db->get('tbl_tooling_timings')->result_array();
                    if(count($tooling_result)>0){
        				$this->db->where('tooling_id',$tooling_result[0]['tooling_id']);
                        $this->db->update('tbl_tooling_timings', array('tooling_end'=>date('Y-m-d H:i:s')));
                    }
                    
                    /*** Update tooling time ***/

                    /*** Update tooling time ***/
                    
                    $this->db->select('setup_id,setup_end');
					$this->db->where('order_id',$result[0]['id']);
    				$this->db->order_by("setup_id","desc");
    				$setup_result=$this->db->get('tbl_setup_timing')->result_array();
                    if(count($setup_result)>0){
                        if($setup_result[0]['setup_end']=='0000-00-00 00:00:00'){
            				$this->db->where('setup_id',$setup_result[0]['setup_id']);
                            $this->db->update('tbl_setup_timing', array('setup_end'=>date('Y-m-d H:i:s')));
                        }
                    }
                    
                    /*** Update tooling time ***/





				    $data['time_from'] = $hold_status['time_to'];
					$time_to = $hold_status['time_to'];
					$EndTime = new DateTime($data['date_from'].' '.$time_to);
					$EndTime->modify('+20 minutes');				    
				    $data['time_to'] = $EndTime->format('H:i:s');
				    $data['task'] = 0;
				    $data['setup'] = 0;
				    $data['hold_status'] = 0;
				    $data['job_complete_status'] = 0;
				    $data['date_from']  = date('Y-m-d');
				    $data['date_to']    = date('Y-m-d');
				    $data['position']   = 0;
				    
				    unset($data['id']);					
					$this->db->insert(TBL_MCDOWN,$data);
					$last_insert_id = $this->db->insert_id();
					
					/**************************** GET NEXT ROW TIME UPDATE **************************
					
                    if($nextrow_result->num_rows()>0){
                        $nextrow_result=$nextrow_result->result_array();  					
                        $nextrow_result_id =$nextrow_result[0]['id'];                    
                        $next_row_array = array('time_from'=>$EndTime->format('H:i:s'));
    					$this->db->where('id',$nextrow_result_id);
    					$this->db->update(TBL_MCDOWN,$next_row_array);
                    }
					/**************************** GET NEXT ROW TIME UPDATE ****************************/
					
					$new_job_details = $this->mobile->load_existing_details($this->input->get('job_code'));
					$update = array('setup'=>0,'job_complete_status'=>0);
					$this->db->where('id',$last_insert_id);
					$this->db->update(TBL_MCDOWN,$update);
					
					
					
	                $job_details_boots = $this->mobile->get_job_details_boots($this->input->get('job_code'));					
            		$status_update['tjob_id'] = $job_details_boots['tjob_id'];
            		$status_update['update_date'] = date('Y-m-d');
            		$status_update['update_time'] = date('Y-m-d H:i:s');
            		$status_update['update_for']    = 3 ;
            		$status_update['update_status'] = 1 ;
            		$status_update['update_to'] = 'Job HOLDED by SFCS - '.$this->input->get('username');
            		$status_update['update_by'] = 0; 
            		$status_update['update_from'] = 'mobile';
            		$job_status_update = $this->mobile->update_job_status_boots($status_update);


					echo json_encode(array('result' =>'success','message'=>'Job Hold Successfully updated11.','job_code'=>$this->input->get('job_code')));
				}else{			
					echo json_encode(array('result' =>'failure','message'=>'Job is not started.'));			
				}
			}
			
    	function down_before_hold_machine($machine_id){
    		$date = date('Y-m-d');
    		$this->db->where('task',0);
    		$this->db->where('date_from',$date);	
    		$this->db->where('machine',$machine_id);
    		$this->db->where('hold_status',0);
    		$where = '((setup = 1 or mc_down = 1 or other_down = 1 or setup = 2 ) AND (job_complete_status != 2))';
    		$this->db->where($where);
    		$row = $this->db->get('tbl_mcdown');

    		if($row->num_rows()>0){
    		    $row = $row->result_array();
    			if($row[0]['setup']==1){
    				$run_status = 'setup';
    			}elseif($row[0]['mc_down']==1){
    				$run_status = 'mc_down';
    			}elseif($row[0]['other_down']==1){
    				$run_status = 'other_down';
    			}elseif($row[0]['job_complete_status']==1){
    				$run_status = 'not_complete';
    			}
    			return $run_status;
    		}else{
    			return FALSE;
    		}			
    	}			
			
    	function downCheck_beforeReady($machine_id){
    		$date = date('Y-m-d');
    		$prev_date = date('Y-m-d', strtotime("-1 day", strtotime($date)));
    		$this->db->where('task',0);
            $this->db->where('date_from >=', $prev_date);
            $this->db->where('date_from <=', $date);
    		$this->db->where('machine',$machine_id);
    		$where = '(mc_down = 1 or other_down = 1 )';
    		$this->db->where($where);
    		$row = $this->db->get('tbl_mcdown');
    		if($row->num_rows()==0){
                return 1;
    		}			
    	}			
    	function running_job_same_machine($machine_id,$job_code){
    		$date = date('Y-m-d');
    		$this->db->where('job_code!=',$job_code);
    		$this->db->where('task',0);
    		$this->db->where('date_from',$date);	
    		$this->db->where('machine',$machine_id);
    		$this->db->where('hold_status',0);
    		$where = '((setup = 1 or mc_down = 1 or other_down = 1 or setup = 2) AND (job_complete_status != 2))';
    		$this->db->where($where);
    		$row = $this->db->get('tbl_mcdown');

    		if($row->num_rows()>0){
    		    $row = $row->result_array();
    			if($row[0]['setup']==1){
    				$run_status = 'setup';
    			}elseif($row[0]['mc_down']==1){
    				$run_status = 'mc_down';
    			}elseif($row[0]['other_down']==1){
    				$run_status = 'other_down';
    			}elseif($row[0]['job_complete_status']==1){
    				$run_status = 'not_complete';
    			}
    			return $run_status;
    		}else{
    			return FALSE;
    		}			
    	}
    	
    	function same_job_remove_when_setup($job_code){
    	    
     		$this->db->where('job_code',$job_code);
    		$this->db->where('setup',0);
    		$this->db->delete('tbl_mcdown'); 
    	    return true;
    	}
    	
    	function mcdown_updates_basedon_qty($job_details_spcs,$s,$i,$data,$mc,$mc_status){
    		$mcdown_updates['job_id'] = $job_details_spcs['id'];
    		if($mc=='t1'){
    		    $mcdown_updates['updated_for'] = 5;
    		    $mcdown_updates['updated_status'] = 1;
    		    $mcdown_updates['updated_to'] = 'Tooling Started - Side('.$s.'/'.$job_details_spcs['side'].') - Qty('.$i.'/'.$job_details_spcs['qty'].') - '.$data['machine_name'];
    		}else{
    		    $mcdown_updates['updated_for'] = 6;
    		    $mcdown_updates['updated_status'] = 2;
    		    $mcdown_updates['updated_to'] = 'Tooling Finished - Side('.$s.'/'.$job_details_spcs['side'].') - Qty('.$i.'/'.$job_details_spcs['qty'].') - '.$data['machine_name'];
    		}
    		$mcdown_updates['updated_by'] =   $data['username']; 
    		$mcdown_updates['updated_remark'] = '';
    		$mcdown_updates['qty_no']	= $i;
    		$mcdown_updates['qty_status']	= 1;
    		$mcdown_updates['mechine_status'] = $mc;
    		$mcdown_updates['mc_status'] = $mc_status;
    		$mcdown_updates['side']	= $s;
    		$mcdown_updates['tot_side'] = $job_details_spcs['side'];			
    		mcdown_updates($mcdown_updates);  
    	}    	
    	
    public function cutter_cump(){
        $get_split_jobcode = explode("[",$this->input->get('job_code'));
        $job_details_boots = $this->mobile->get_job_details_boots($get_split_jobcode[0]);
        $job_details_spcs = $this->mobile->get_job_details($this->input->get('job_code'));     
        $cutter_cump_arr = $this->input->get('cuttercump');

        $cutter_replace = $text = str_replace('array(','',$this->input->get('cuttercump'));
        $cutter_replace1 = $text = str_replace(')','',$cutter_replace);
        $cutter_cump_arr = explode(',',$cutter_replace1); 

        for($i=0;$i<count($cutter_cump_arr);$i++){
            
    		$status_update['tjob_id']	= $job_details_boots['tjob_id'];
    		$status_update['update_date']	= date('Y-m-d');
    		$status_update['update_time']	= date('Y-m-d H:i:s');
    		$status_update['update_for']    = 3 ;
    		$status_update['update_status'] = 2 ;
    		if($cutter_cump_arr[$i]!=''){
    		    $status_update['update_to']	= 'Cutter Comp Updated -'.$cutter_cump_arr[$i].' by - '.$this->input->get('username');
        		$status_update['update_from'] = 'mobile';
        		$status_update['update_by']	= get_user_id($this->input->get('username')); //MOBILE_APP_USER_ID;
        		$job_status_update = $this->mobile->update_job_status_boots($status_update);     		    
    		}
        }
       
        if(is_array($cutter_cump_arr)){

                    if($cutter_cump_arr[0]!=''){
                        
                        $update['cutter_time_hr1'] = $cutter_cump_arr[0];
                    }else{
                        $update['cutter_time_hr1']  = '';
                    }
                    
                    if($cutter_cump_arr[1]!=''){
                        
                        $update['cutter_time_hr2'] = $cutter_cump_arr[1];
                    }else{
                        $update['cutter_time_hr2']  = '';
                    }
                    
                    if($cutter_cump_arr[2]!=''){
                        
                        $update['cutter_time_hr3'] = $cutter_cump_arr[2];
                    }else{
                         $update['cutter_time_hr3']  = '';
                    }
                    
                    if($cutter_cump_arr[3]!=''){
                        
                        $update['cutter_time_hr4'] = $cutter_cump_arr[3];
                    }else{
                        $update['cutter_time_hr4']  = '';
                    }
                }
                $update['cutter_time_min1'] = $cutter_replace1;
               
		        $job_update = $this->mobile->update_job_details_boots($update,$get_split_jobcode[0]);  
  		        $update = array(
  		                'cutter_cump1'=>$update['cutter_time_hr1'],
  		                'cutter_cump2'=>$update['cutter_time_hr2'],
  		                'cutter_cump3'=>$update['cutter_time_hr3'],
  		                'cutter_cump4'=>$update['cutter_time_hr4']
  		                );
		$this->db->where('id',$job_details_spcs['id']);
		$this->db->update(TBL_MCDOWN,$update);
		if($job_update){
		    $result = array('result' =>'success' , 'message' => 'Cutter comp Successfully updated');
		}else{
		    $result = array('result' =>'failure' , 'message' => 'Cutter comp updated failed');
		}
         echo json_encode($result);       
    }    	
    public function hour_min($job_code){// Total
        $hrs_with_hrs = 0;
        $hrs_with_min = 0;
        $hrs = 0;
        $mins = 0;
        $job_details_spcs = $this->mobile->get_job_details_assy($job_code);
        foreach($job_details_spcs as $job_details_spcs_value){
            if($job_details_spcs_value['assy_end']!='0000-00-00 00:00:00'){
                $assy_time = explode(".",$job_details_spcs_value['assy_time']); 
    			$hrs_with_hrs += $assy_time[0];    
    			$hrs_with_min +=  $assy_time[1];
            }
        }
        $hrs = $hrs_with_hrs * 60;
        $mins = $hrs + $hrs_with_min;
        
       if($mins <= 0) return array('hour'=>00,'min'=>00);
    else    
	    $hours = floor($mins / 60);
        $min = str_pad(($mins % 60), 2, "0", STR_PAD_LEFT);
		return array('hour'=>$hours,'min'=>$min);
    } 			
	function wims_hold_jobs($job_code){
    	$this->db->where('job_code',$job_code);
    	$this->db->where('wims_job_hold',1);
        $query = $this->db->get('tbl_mcdown');
    	if($query->num_rows() > 0){
            return true;
    	}
    }
    public function wimsjob_hold(){
		$this->db->where('job_code',$_POST['job_code']);
        $query = $this->db->get('tbl_mcdown');
    	if($query->num_rows() > 0){
    	    $data = $query->row_array();
    	    $this->db->where('job_code',$_POST['job_code']);
    	    $update_job['wims_job_hold'] = $_POST['status'];
    	    $updated = $this->db->update(TBL_MCDOWN,$update_job);
    	    if($_POST['status']==1){
    	        if($data['tooling_end'] == '0000-00-00 00:00:00'){
    	            $this->wimshold($_POST['job_code'],$data['machine']);
    	        }
    	    }
		}
    }
	function unhold($type,$id,$machine_name,$job_code){
		$machine=$this->mobile->get_down_machine_id($machine_name);
		$machine = $machine[0]['id'];
		$this->db->select('*');
		$this->db->where('id',$id);
		$this->db->where('machine',$machine);
		//$this->db->where('date_from',date('Y-m-d'));				
		$this->db->order_by("id","desc");
		$result=$this->db->get(TBL_MCDOWN)->result_array();
		if(count($result)>0){					
			$hold_status = array('time_from'=>date('H:i:00'));
			$this->db->where('id',$id);
			$this->db->update(TBL_MCDOWN,$hold_status);	
			
			
			$this->db->where('job_code',$job_code);
			$this->db->update(TBL_MCDOWN,array('hold_status'=>0));
            /*** Update tooling time ***/
			if($type == 'tooling'){
				$this->db->select('tooling_id');
				$this->db->where('order_id',$id);
				$this->db->order_by("tooling_id","desc");
				$tooling_result=$this->db->get('tbl_tooling_timings')->result_array();
				$this->db->where('tooling_id',$tooling_result[0]['tooling_id']);
				$this->db->update('tbl_tooling_timings', array('tooling_start'=>date('Y-m-d H:i:s')));
				//echo $this->db->last_query().'<br>';
			}elseif($type == 'setup'){
				$this->db->select('setup_id');
				$this->db->where('order_id',$id);
				$this->db->order_by("setup_id","desc");
				$setup_result=$this->db->get('tbl_setup_timing')->result_array();
				$this->db->where('setup_id',$setup_result[0]['setup_id']);
				$this->db->update('tbl_setup_timing', array('setup_start'=>date('Y-m-d H:i:s')));
                //echo $this->db->last_query().'<br>';
			}						
			return 1;
		}else{
		    return 0;
		}
	}
    function check_hold_status_mcdown($job_code,$machine_id){
        
        $this->db->where('job_code',$job_code);
        $this->db->where('machine',$machine_id);
        $this->db->where('hold_status',1);
		$this->db->order_by("id","desc");
		$row = $this->db->get('tbl_mcdown');
		//echo $this->db->last_query();
		if($row->num_rows()==0){
            return 0;
		}else{
		    $row = $row->result_array();
		    $order_id = $row[0]['id'];
		    return $order_id;
		}
    }
    function get_last_setupid($job_code,$machine_id){
        
        $this->db->where('job_code',$job_code);
        $this->db->where('machine',$machine_id);
		$this->db->order_by("setup_id","desc");
		$row = $this->db->get('tbl_setup_timing');
		//echo $this->db->last_query();
		if($row->num_rows()==0){
            return 0;
		}else{
		    $row = $row->result_array();
		    $setup_id = $row[0]['setup_id'];
		    return $setup_id;
		}
    } 
    function testforsetup(){
        
    }
}