<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
|--------------------------------------------------------------------------
| Display Debug backtrace
|--------------------------------------------------------------------------
|
| If set to TRUE, a backtrace will be displayed along with php errors. If
| error_reporting is disabled, the backtrace will not display, regardless
| of this setting
|
*/
defined('SHOW_DEBUG_BACKTRACE') OR define('SHOW_DEBUG_BACKTRACE', TRUE);

/*
|--------------------------------------------------------------------------
| File and Directory Modes
|--------------------------------------------------------------------------
|
| These prefs are used when checking and setting modes when working
| with the file system.  The defaults are fine on servers with proper
| security, but you may wish (or even need) to change the values in
| certain environments (Apache running a separate process for each
| user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
| always be used to set the mode correctly.
|
*/
defined('FILE_READ_MODE')  OR define('FILE_READ_MODE', 0644);
defined('FILE_WRITE_MODE') OR define('FILE_WRITE_MODE', 0666);
defined('DIR_READ_MODE')   OR define('DIR_READ_MODE', 0755);
defined('DIR_WRITE_MODE')  OR define('DIR_WRITE_MODE', 0755);

/*
|--------------------------------------------------------------------------
| File Stream Modes
|--------------------------------------------------------------------------
|
| These modes are used when working with fopen()/popen()
|
*/
defined('FOPEN_READ')                           OR define('FOPEN_READ', 'rb');
defined('FOPEN_READ_WRITE')                     OR define('FOPEN_READ_WRITE', 'r+b');
defined('FOPEN_WRITE_CREATE_DESTRUCTIVE')       OR define('FOPEN_WRITE_CREATE_DESTRUCTIVE', 'wb'); // truncates existing file data, use with care
defined('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE')  OR define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE', 'w+b'); // truncates existing file data, use with care
defined('FOPEN_WRITE_CREATE')                   OR define('FOPEN_WRITE_CREATE', 'ab');
defined('FOPEN_READ_WRITE_CREATE')              OR define('FOPEN_READ_WRITE_CREATE', 'a+b');
defined('FOPEN_WRITE_CREATE_STRICT')            OR define('FOPEN_WRITE_CREATE_STRICT', 'xb');
defined('FOPEN_READ_WRITE_CREATE_STRICT')       OR define('FOPEN_READ_WRITE_CREATE_STRICT', 'x+b');

/*
|--------------------------------------------------------------------------
| Exit Status Codes
|--------------------------------------------------------------------------
|
| Used to indicate the conditions under which the script is exit()ing.
| While there is no universal standard for error codes, there are some
| broad conventions.  Three such conventions are mentioned below, for
| those who wish to make use of them.  The CodeIgniter defaults were
| chosen for the least overlap with these conventions, while still
| leaving room for others to be defined in future versions and user
| applications.
|
| The three main conventions used for determining exit status codes
| are as follows:
|
|    Standard C/C++ Library (stdlibc):
|       http://www.gnu.org/software/libc/manual/html_node/Exit-Status.html
|       (This link also contains other GNU-specific conventions)
|    BSD sysexits.h:
|       http://www.gsp.com/cgi-bin/man.cgi?section=3&topic=sysexits
|    Bash scripting:
|       http://tldp.org/LDP/abs/html/exitcodes.html
|
*/
defined('EXIT_SUCCESS')        OR define('EXIT_SUCCESS', 0); // no errors
defined('EXIT_ERROR')          OR define('EXIT_ERROR', 1); // generic error
defined('EXIT_CONFIG')         OR define('EXIT_CONFIG', 3); // configuration error
defined('EXIT_UNKNOWN_FILE')   OR define('EXIT_UNKNOWN_FILE', 4); // file not found
defined('EXIT_UNKNOWN_CLASS')  OR define('EXIT_UNKNOWN_CLASS', 5); // unknown class
defined('EXIT_UNKNOWN_METHOD') OR define('EXIT_UNKNOWN_METHOD', 6); // unknown class member
defined('EXIT_USER_INPUT')     OR define('EXIT_USER_INPUT', 7); // invalid user input
defined('EXIT_DATABASE')       OR define('EXIT_DATABASE', 8); // database error
defined('EXIT__AUTO_MIN')      OR define('EXIT__AUTO_MIN', 9); // lowest automatically-assigned error code
defined('EXIT__AUTO_MAX')      OR define('EXIT__AUTO_MAX', 125); // highest automatically-assigned error code



// SPEC DATABASE TABLES
defined('MST_MACHINE')      OR define('MST_MACHINE', 'mst_machine'); // MACHINE TABLE
defined('MST_REASONS')      OR define('MST_REASONS', 'mst_reason'); // REASON TABLE
defined('TBL_JOBS')      OR define('TBL_JOBS', 'tbl_jobs'); // JOBS TABLE
defined('TBL_MCDOWN')      OR define('TBL_MCDOWN', 'tbl_mcdown'); // MACHINE DOWN TABLE

defined('TBL_MCDOWN_UPDATES')  OR define('TBL_MCDOWN_UPDATES', 'tbl_mcdown_updates'); // MACHINE DOWN UPDATES

defined('TBL_SHIFT')      OR define('TBL_SHIFT', 'tbl_shifts'); // SHIFT TABLE
defined('TBL_USERS')      OR define('TBL_USERS', 'tbl_users'); // USER TABLE

defined('MST_CFT_MEMBERS')      OR define('MST_CFT_MEMBERS', 'mst_cftmembers'); // CFT MASTER

defined('TBL_CFT_REPORTS')      OR define('TBL_CFT_REPORTS', 'tbl_cft_report'); // TBL CFT REPORTS

defined('TBL_LOCATIONS')      OR define('TBL_LOCATIONS', 'tbl_locations'); // TBL LOCATIONS

defined('TBL_DELIVERY_LOCATIONS')      OR define('TBL_DELIVERY_LOCATIONS', 'tbl_order_delivery_location'); // TBL DELIVERY LOCATIONS


defined('TBL_SHIPPINGS')      OR define('TBL_SHIPPINGS', 'tbl_shipping'); // TBL SHIPPING 

// BOSS DATABASE TABLES

defined('BOSS_QUOTES')      OR define('BOSS_QUOTES', 'boss_quotes'); // QUOTES TABLE


defined('MOBILE_APP_USER_ID')	OR define('MOBILE_APP_USER_ID', 53); // User id from wims for app

//BOOTS DATABASE TABLES
defined('TBL_USER')      OR define('TBL_USER', 'tbl_user'); 
defined('TBL_JOBS')      OR define('TBL_JOBS', 'tbl_jobs'); 
defined('TBL_JOBS_UPDATES')      OR define('TBL_JOBS_UPDATES', 'tbl_jobs_updates'); 



// Shift Default timeing

 // SHIFT1_START_TIME OLD : 08:00:00
defined('DEFAULT_SHIFT1_START_TIME')	OR define('DEFAULT_SHIFT1_START_TIME','07:00:00'); 
defined('DEFAULT_SHIFT1_END_TIME')	OR define('DEFAULT_SHIFT1_END_TIME','22:00:00'); // SHIFT1_END_TIME OLD : 16:00:00
defined('DEFAULT_SHIFT2_START_TIME')	OR define('DEFAULT_SHIFT2_START_TIME','22:00:00'); // SHIFT2_START_TIME
defined('DEFAULT_SHIFT2_END_TIME')	OR define('DEFAULT_SHIFT2_END_TIME','00:01:00'); // SHIFT2_END_TIME
defined('DEFAULT_SHIFT3_START_TIME')	OR define('DEFAULT_SHIFT3_START_TIME','00:01:00'); // SHIFT3_START_TIME
defined('DEFAULT_SHIFT3_END_TIME')	OR define('DEFAULT_SHIFT3_END_TIME','07:00:00'); // SHIFT3_END_TIME

//  START_TIME AND END TIME

defined('DEFAULT_SHIFT_START_TIME')	OR define('DEFAULT_SHIFT_START_TIME','07:00:00');  //DEFAULT_SHIFT_START_TIME OLD:08:00:00
//defined('DEFAULT_SHIFT_END_TIME')	OR define('DEFAULT_SHIFT_END_TIME','20:00:00');

defined('MAXIMUM_MACHINE_DOWN_ALLOW')	OR define('MAXIMUM_MACHINE_DOWN_ALLOW',240); // MAXIMUM MACHINE DOWN TIME USED TO SPLIT JOBS


