<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 *  Notification class
 * 
 *  @package SFCS 
 * 
 *  @author KRISHNAKUMAR M
 * 
**/

class Notification {

	const NOTIFICATION_TABLE 	= 'tbl_notification';
	const NOTIFICATION_JOIN_TABLE 	= 'tbl_users';
	const WHERE_VARIABLE_ONE	= 'notify_id';
	const WHERE_VARIABLE_TWO	= 'id';
	const ACK_READ			= 1;
	const ACK_NOT_READ		= 0;
	const NOTIFICATION_VARIABLE	= 'identify';
	const NOTIFICATION		= 1;
	const MESSAGE			= 2;
	const ASSEMBLY_MSG_GROUP	= 1;
	const NOT_ASSEMBLY_MSG_GROUP	= 0;
	const ASSEMBLY_GROUP_ID		= 5;
	const ACKNOWLEDGEMENT		= 1;
	const NOT_ACKNOWLEDGEMENT	= 0;
	const ASSEMBLY_MESSAGE		= '{{ref#}} CAD FINISHED';
	const ASSEMBLY_NOTES		= 'Please start material Preparation';
	const NO_ASSEMBLY_NOTES		= '';
	const EMPTY_DATE		= '0000-00-00 00:00:00'; 
     
	public function cad_complete_notification( $job_id = 0 , $job_code = 0 ){
		if( ($job_id !=0) && ($job_code !=0) ){
			
			$replace = array(
				"{{ref#}}" => "Ref# ".$job_code
			);
			
			$notify_data['job_id']		= $job_id;
			$notify_data['job_code']	= $job_code;
			$notify_data['message']		= $this->content_replace(self::ASSEMBLY_MESSAGE,$replace);
			$notify_data['msg_group']	= self::ASSEMBLY_MSG_GROUP;
			$notify_data['group_id']	= self::ASSEMBLY_GROUP_ID ;
			$notify_data['notes']		= self::ASSEMBLY_NOTES;
			$notify_data['identify']	= self::NOTIFICATION;
			$notify_data['created_on']	= date('Y-m-d H:i:s');
			$notify_data['updated_on']	= self::EMPTY_DATE;
			$notify_data['status']		= 1; 
			
			if($this->insert_notification($notify_data)){
				return array( 'result' => 'success' , 'message' => 'notification insertion successfully' );
			}else{
				return array( 'result' => 'failed' , 'message' => 'notification insertion failed' );
			}
			
			
		}else{
			return array( 'result' => 'failed' , 'message' => 'JobId and JobCode missing' );
		}
	}
	
	public function message($notify_data){
		if( !empty($notify_data)){
			
			$this->insert_notification($notify_data);
			
			return array( 'result' => 'success' , 'message' => 'notification insertion successfully' );
			
		}else{
			return array( 'result' => 'failed' , 'message' => 'JobId and JobCode missing' );
		}
	}
	
	public function acknowledgement( $msgId = 0 , $ackUser = 0 , $ackMessage = '' ){
		if( ($msgId != 0) && ($ackUser != 0) && ($ackMessage != '') ){
			$notify_update['ack_status']	= self::ACKNOWLEDGEMENT;
			$notify_update['ack_user']	= $ackUser;
			$notify_update['ack_message']	= $ackMessage;
			$notify_update['updated_on']	= date('Y-m-d H:i:s'); 
			
			$this->update_notification($notify_update,$msgId);
			
			return array( 'result' => 'failed' , 'message' => 'Acknowledgement successfully updated' );
			
		}else{
			return array( 'result' => 'failed' , 'message' => 'JobId and JobCode missing' );
		}
	}
	
	public function get_notifications( $userId = 0 , $userType = 0 ){
		if( ($userId != 0) || ($userType != 0)){
			$where = " WHERE ";
			if( ($userId != 0) && ($userType != 0)){
				$where .= "((nt.msg_group = 1 AND nt.group_id = '".$userType."') OR nt.msg_to = '".$userId."' ) AND nt.identify = 1 AND nt.ack_status= 0 ";
			}
			
			if( ($userId != 0) && ($userType == 0) ){
				$where .= " nt.msg_to = '".$userId."' AND nt.identify = 1  AND nt.identify = 1 AND nt.ack_status= 0 ";
			}
			
			if(($userType != 0) &&($userId == 0) ){
				$where .= " nt.msg_group = 1 AND nt.group_id = '".$userType."' AND nt.identify = 1 AND nt.ack_status= 0 ";
			}
		
			$CI =& get_instance();
			$query = $CI->db->query("SELECT * FROM ".self::NOTIFICATION_TABLE." nt ".$where);
			if( $query->num_rows() >0 ){
				$results = $query->result_array();
				$notifications = array();
				foreach( $results as $key => $result ){
					$row['notify_id'] = $result['notify_id'];
					$row['message'] = $result['message'];
					$row['notes'] = $result['notes'];
					$row['notify_id'] = $result['notify_id'];
					if($result['msg_from'] != ''){
						$row['from'] = $this->getUsername($result['msg_from']);
					}
					$notifications[] = $row;
				}
				return $notifications;
			}else{
				return false;
			} 
			
		}else{
			return array( 'result' => 'failed' , 'message' => 'JobId and JobCode missing' );
		}
	}
	
	public function get_messages( $userId = 0 , $userType = 0 ){
		if( ($userId != 0) || ($userType != 0)){
			$where = " WHERE ";
			if( ($userId != 0) && ($userType != 0)){
				$where .= "((nt.msg_group = 1 AND nt.group_id = '".$userType."') OR nt.msg_to = '".$userId."' ) AND nt.identify = 2 AND nt.ack_status= 0 ";
			}
			
			if( ($userId != 0) && ($userType == 0) ){
				$where .= " nt.msg_to = '".$userId."' AND nt.identify = 1  AND nt.identify = 2 AND nt.ack_status= 0 ";
			}
			
			if(($userType != 0) &&($userId == 0) ){
				$where .= " nt.msg_group = 1 AND nt.group_id = '".$userType."' AND nt.identify = 2 AND nt.ack_status= 0 ";
			}
		
			$CI =& get_instance();
			$query = $CI->db->query("SELECT * FROM ".self::NOTIFICATION_TABLE." nt ".$where.'LIMIT 1');
			if( $query->num_rows() >0 ){
				$results = $query->result_array();
				$messages = array();
				foreach( $results as $key => $result ){
					$row['notify_id'] = $result['notify_id'];
					$row['message'] = $result['message'];
					$row['notes'] = $result['notes'];
					$row['notify_id'] = $result['notify_id'];
					if($result['msg_from'] != ''){
						$row['from'] = $this->getUsername($result['msg_from']);
					}
					$messages[] = $row;
				}
				return $messages;
			}else{
				return false;
			} 
			
		}else{
			return array( 'result' => 'failed' , 'message' => 'JobId and JobCode missing' );
		}
	}
	
	public function read_notifications( $userId = 0 , $notifyId = 0 ){
		$notify_read['ack_user']	= $userId;
		$notify_read['ack_status']	= self::ACK_READ;
		$notify_read['updated_on']	= date('Y-m-d H:i:s');
		
		$this->update_notification($notify_read,$notifyId );
			
		return true;
	}
	
	public function acknowledge_message( $userId , $notifyId , $ackMsg ){
		$msg_read['ack_user']	= $userId;
		$msg_read['ack_status']	= self::ACK_READ;
		$msg_read['ack_message']	= $ackMsg;
		$msg_read['updated_on']	= date('Y-m-d H:i:s');
		
		$this->update_notification($msg_read,$notifyId );
			
		return true;
	}
	
	private function insert_notification($notify_data){
		$CI =& get_instance();
		$CI->db->insert(self::NOTIFICATION_TABLE,$notify_data);
		return $CI->db->insert_id();
	}
	
	private function update_notification($notify_update,$msgId){
		$CI =& get_instance();
		$CI->db->where(self::WHERE_VARIABLE_ONE,$msgId);
		$CI->db->update(self::NOTIFICATION_TABLE,$notify_update);
	}
	
	private function content_replace($message,$replace = array()){
        	return strtr($message,$replace);
	}
	
	private function getUsername($userId){
        	$CI =& get_instance();
        	$CI->db->select('username');
		$CI->db->where(self::WHERE_VARIABLE_TWO,$userId);
		$result = $CI->db->get(self::NOTIFICATION_JOIN_TABLE)->row_array();
		
		return $result['username'];
		
	}
}