<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Report extends CI_Controller {
  public function __construct() {
    parent::__construct();
    //date_default_timezone_set('Asia/Kolkata');
    date_default_timezone_set('America/Los_Angeles');
    $this->load->model('report_model');
    $this->load->helper('common_helper');
    $this->load->library('session');
  }
  public function index(){
    if(! $this->session->userdata('user_id')){
      redirect('welcome');
    }else{
      header('Access-Control-Allow-Origin: *');
      $this->load->view('dashboard');
    }
  }
  public function current(){
    $current_date = date('Y-m-d');
    $jobs = $this->report_model->get_jobs($current_date);
    if($jobs){
      $table_rows = "";
      foreach($jobs as $key => $job){
        $jobs[$key]['job_state'] = $this->report_model->find_job_state($job['job_code']);
        $table_rows .='<tr class="normal_list" bgcolor="#F8F8F8">
        <td align="center"><a  data-fancybox data-src="#report_pop" href="javascript:;">'.$job['job_code'].'</a></td>
        <td align="center">'.$job['down_time'].'</td>
        <td align="center">'.$job['machine'].'</td>
        <td align="left">'.$jobs[$key]['job_state'].'</td>
        </tr>';
      }
      $result = array('result'=>'success','data'=>$table_rows);
    }else{
      $result = array('result'=>'failed','data'=>'No result Found');
    }
    echo json_encode($result);
  }
  public function ajax_list(){
    header('Access-Control-Allow-Origin: *');
    $lists = $this->report_model->get_datatables();
    $data = array();
    $no = $_POST['start'];
    foreach ($lists as $list) {
      $no++;
      $row = array();
      $row[] = $list->date_from;
      $row[] = '<a  data-fancybox class="job_log" data-src="#report_pop" data-jobcode="'.$list->job_code.'" data-id ="'.$list->id.'" href="javascript:;">'.$list->job_code.'</a>';
      $row[] = $list->down_time;
      $row[] = $this->report_model->get_machinename($list->machine);
      $row[] = $this->report_model->find_job_state($list->job_code);
      $data[] = $row;
    }
    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->report_model->count_all(),
      "recordsFiltered" => $this->report_model->count_filtered(),
      "data" => $data,
    );
//output to json format
    echo json_encode($output);
  }
  public function get_job_history(){
    $job_id = $this->input->post('job_id');
    $jobcode = $this->input->post('jobcode');
    $job_histories = $this->report_model->get_job_history($job_id);
    if($job_histories){
      $datas ="";
      $result = glob('/home/beamon9/public_html/sfcs/images/' . $jobcode . '.*');
      if($result){
        $datas .= '<tr class="heading2"><td><strong>Signature</td><td align="right"><span class="font11"><img src="'.base_url().'images/'.$jobcode.'.png" style="width:32%;"></span></td></tr>';
      }
      foreach($job_histories as $key => $job_history ){
        if($job_history['updated_remark']!=""){
          $remarks ="<br><span><b>Remarks :</b> ".$job_history['updated_remark']."</span>";
        }else{
          $remarks ="";
        }
		if($job_history['update_action'] == 'JOB CANCELED'){
			$updated_by = Boots_GetSingleValue(TBL_USER,array('usr_id'=>'1'),'usr_name');
            $datas .= '<tr class="heading2"><td><strong>'.$job_history['updated_to'].'</strong> by <strong>'.$updated_by.'</strong>'.$remarks.'</td><td align="right"><span class="font11">'.date('Y-m-d h:i A',strtotime($job_history['created_on'])).'</span></td></tr>';
		}else{
			$datas .= '<tr class="heading2"><td><strong>'.$job_history['updated_to'].'</strong> by <strong>'.$job_history['updated_by'].'</strong>'.$remarks.'</td><td align="right"><span class="font11">'.date('Y-m-d h:i A',strtotime($job_history['created_on'])).'</span></td></tr>';
		}
        if($job_history['receiver_name']!=''){
         $datas .= '<tr class="heading2"><td><strong>'.$job_history['receiver_name'].'</td><td align="right"><span class="font11">'.date('Y-m-d h:i A',strtotime($job_history['created_on'])).'</span></td></tr>';
      
            }
            
            
            
            
        }
        
      $result=array('result'=>'success','data'=>$datas);
    }else{
      $result=array('result'=>'failed','data'=>'Job History Not Found');
    }
    echo json_encode($result);
  }
}