<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Users_model extends CI_Model {

	var $table = TBL_USERS;
	var $column_order = array(null, 'firstname','lastname','username','designation'); //set column field database for datatable orderable
	var $column_search = array('firstname','lastname','username','designation'); //set column field database for datatable searchable 
	var $order = array('id' => 'asc'); // default order 

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	private function _get_datatables_query()
	{
		
		$this->db->from($this->table);

		$i = 0;
	
		foreach ($this->column_search as $item) // loop column 
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{
				
				if($i===0) // first loop
				{
					$this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
					$this->db->like($item, $_POST['search']['value']);
				}
				else
				{
					$this->db->or_like($item, $_POST['search']['value']);
				}

				if(count($this->column_search) - 1 == $i) //last loop
					$this->db->group_end(); //close bracket
			}
			$i++;
		}
		
		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		} 
		else if(isset($this->order))
		{
			$order = $this->order;
			$this->db->order_by(key($order), $order[key($order)]);
		}
	}

	function get_datatables()
	{
		$this->_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
	        $this->db->where('status',1);
		$query = $this->db->get();
		return $query->result();
	}

	function count_filtered() {
		$this->_get_datatables_query();
                $this->db->where('status',1);
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function count_all()
	{
		$this->db->from($this->table);
                $this->db->where('status',1);
		return $this->db->count_all_results();
	}

	function check_user_avail($data){
		//print_r($data);
		$this->db->where('username',$data['login_username']);
		$query = $this->db->get(TBL_USERS);
		//print_r($query);
		if( $query->num_rows() > 0 ){
			return $query->num_rows;
		}else{
			return FALSE;
		}
	}
	function auth_user($data){
		$this->db->where('username',$data['login_username']);
		$this->db->where('password',md5($data['login_password']));
		$query = $this->db->get(TBL_USERS);
		if( $query->num_rows() > 0 ){
			return TRUE;
		}else{
			return FALSE;
		}
	}
	function get_userinfo($username){
		$this->db->where('username',$username);
		$query = $this->db->get(TBL_USERS);
		if( $query->num_rows() > 0 ){
			return $query->row_array();
		}else{
			return FALSE;
		}
	}
	function insert_newuser($data){
		$this->db->insert(TBL_USERS,$data);
		$insert_id = $this->db->insert_id();
		return $insert_id;
	}
	function check_userexist($field,$check){
		$this->db->where($field,$check);
		$query = $this->db->get(TBL_USERS);
		//print_r($query);
		if( $query->num_rows() > 0 ){
			return $query->num_rows;
		}else{
			return FALSE;
		}
	}
	function get_user_details($user_id){
        $this->db->select('*');
        $this->db->where('id',$user_id);
        $result=$this->db->get(TBL_USERS)->row_array();
        return $result;
    }

    function update_user($data,$userid){
    	 $this->db->where('id',$userid);
         $this->db->update(TBL_USERS,$data);
         if( $this->db->affected_rows() >=0 ){
             return true; 
         }else{
             return false; 
         }
    }
    function remove_user($userid){
    	$data['status'] = 0 ;
    	$this->db->where('id',$userid);
        $this->db->update(TBL_USERS,$data);
        if( $this->db->affected_rows() >=0 ){
            return true; 
        }else{
            return false; 
        }
    }

}
