<?php

class dashboard_model extends CI_Model {

    function insert_machine($data){ 
        $this->db->insert(MST_MACHINE,$data);
        $insert_id = $this->db->insert_id();
        return  $insert_id;
    }
    function update_machine($data,$machine_id){
        $this->db->where('id',$machine_id);
        $this->db->update(MST_MACHINE,$data);
        if($this->db->affected_rows() >=0){
          return true; 
        }else{
          return false; 
        }
    }
    function get_machine(){
        $this->db->select('machine,id');
        $this->db->where('status',1);
        $this->db->order_by('id','desc');
        $result=$this->db->get(MST_MACHINE)->result_array();
        return $result;
    }
    function delete_machine($machine_id){
        $data['status']=0;
        $this->db->where('id',$machine_id);
        $this->db->update(MST_MACHINE,$data);
        if($this->db->affected_rows() >=0){
          return true; 
        }else{
          return false; 
        }
    }
    function get_machine_details($machine_id){
        $this->db->select('*');
        $this->db->where('id',$machine_id);
        $result=$this->db->get(MST_MACHINE)->row_array();
        return $result;
    }
    function get_bossjob_details($job_code){
        $CI =& get_instance();
        $this->db = $CI->load->database('default', TRUE);
        $this->db2 = $CI->load->database('boss', TRUE);

        $this->db2->select('*');
        $this->db2->from('boss_quotes');
        $this->db2->join('boss_tooling', 'boss_quotes.id = boss_tooling.quote_id');
        $this->db2->join('boss_tooling_time', 'boss_quotes.id=boss_tooling_time.quote_id');
        $this->db2->where('boss_quotes.ref_no',$job_code); 
        $result = $this->db2->get()->row_array();

        $total_minutes_boss_mac = (($result['std_mac_hr']*60) + $result['std_mac_min'] + $result['cpx_mac_min'] + ($result['cpx_mac_hr']*60));
        $total_minutes_boss_ass = (($result['std_ass_hr']*60) + $result['std_ass_min'] + $result['cpx_ass_min'] + ($result['cpx_ass_hr']*60));
        $total_minutes_boss_des = (($result['std_des_hr']*60) + $result['std_des_min'] + $result['cpx_des_min'] + ($result['cpx_des_hr']*60));
        $total = $total_minutes_boss_mac+$total_minutes_boss_ass+$total_minutes_boss_des;
        $total_min =  gmdate("H.i", ($total * 60)); 

        return array("total_time"=>$total_min,"quantity"=>$result['tooling_unit']);
    }
    function addjob_insert($data){
        $this->db->insert(TBL_JOBS,$data);
        $insert_id = $this->db->insert_id();
        return  $insert_id;
    }
    function insert_down($data){
        $this->db->insert(TBL_MCDOWN,$data);
        $insert_id = $this->db->insert_id();
        return  $insert_id;
    }
    function insert_shift($data){
        $this->db->insert(TBL_SHIFT,$data);
        $insert_id = $this->db->insert_id();
        return  $insert_id;
    }
    function update_shift($data,$shift_id){
        $this->db->where('id',$shift_id);
        $this->db->update(TBL_SHIFT,$data);
        if($this->db->affected_rows() >=0){
          return true; 
        }else{
          return false; 
        }
    }
    function get_shift_details($date_from){
        $this->db->select('*');
        $this->db->where('date_from',$date_from);
        $this->db->where('status',1);
        $result=$this->db->get(TBL_SHIFT)->row_array();
        return $result;
    }
    function downreport($downreport){
        $this->db->select('tbl_mcdown.*,mst_machine.machine');
        $this->db->from('tbl_mcdown');
        $this->db->join('mst_machine', 'tbl_mcdown.machine = mst_machine.id');
        $this->db->where('date_from >=',$downreport['date_from']);
        $this->db->where('date_from <=',$downreport['date_to']);
        $this->db->where('tbl_mcdown.mc_down',1);
        $this->db->where('tbl_mcdown.machine',$downreport['machine']);
        $result=$this->db->get()->result_array();
        return $result;

        // $this->db->select('*');
        // $this->db->from(TBL_MCDOWN);
        // $this->db->join(TBL_MCDOWN);
        // $this->db->where('date_from >=',$downreport['date_from']);
        // $this->db->where('date_from <=',$downreport['date_to']);
        // $this->db->where('machine',$downreport['machine']);
        // $this->db->where('mc_down',1);
        // $result=$this->db->get()->result_array();
        // return $result;
    }
    function idlereport($idlereport){
        $this->db->select('tbl_mcdown.*,mst_machine.machine');
        $this->db->from('tbl_mcdown');
        $this->db->join('mst_machine', 'tbl_mcdown.machine = mst_machine.id');
        $this->db->where('date_from >=',$idlereport['date_from']);
        $this->db->where('date_from <=',$idlereport['date_to']);
        $this->db->where('tbl_mcdown.idle',1);
        $this->db->where('tbl_mcdown.machine',$idlereport['machine']);
        $result=$this->db->get()->result_array();
        return $result;

        // $this->db->select('*');
        // $this->db->where('date_from >=',$idlereport['date_from']);
        // $this->db->where('date_to <=',$idlereport['date_to']);
        // $this->db->where('idle',1);
        // $result=$this->db->get(TBL_MCDOWN)->result_array();
        // return $result;
    }
    function setupreport($setupreport){
        $this->db->select('tbl_mcdown.*,mst_machine.machine');
        $this->db->from('tbl_mcdown');
        $this->db->join('mst_machine', 'tbl_mcdown.machine = mst_machine.id');
        $this->db->where('date_from >=',$setupreport['date_from']);
        $this->db->where('date_from <=',$setupreport['date_to']);
        $this->db->where('tbl_mcdown.setup',1);
        $this->db->where('tbl_mcdown.machine',$setupreport['machine']);
        $result=$this->db->get()->result_array();
        return $result;

        // $this->db->select('*');
        // $this->db->where('date_from >=',$setupreport['date_from']);
        // $this->db->where('date_to <=',$setupreport['date_to']);
        // $this->db->where('setup',1);
        // $result=$this->db->get(TBL_MCDOWN)->result_array();
        // return $result;
    }
    function maintainreport($maintainreport){
        $this->db->select('tbl_mcdown.*,mst_machine.machine');
        $this->db->from('tbl_mcdown');
        $this->db->join('mst_machine', 'tbl_mcdown.machine = mst_machine.id');
        $this->db->where('date_from >=',$maintainreport['date_from']);
        $this->db->where('date_from <=',$maintainreport['date_to']);
        $this->db->where('tbl_mcdown.maintenance',1);
        $this->db->where('tbl_mcdown.machine',$maintainreport['machine']);
        $result=$this->db->get()->result_array();
        return $result;
        // $this->db->select('*');
        // $this->db->where('date_from >=',$maintainreport['date_from']);
        // $this->db->where('date_to <=',$maintainreport['date_to']);
        // $this->db->where('maintenance',1);
        // $result=$this->db->get(TBL_MCDOWN)->result_array();
        // return $result;
    }
    function get_jobs($date,$machine_id,$shift){
        $this->db->select('*');
        $this->db->where('date',$date);
        $this->db->where('machine',$machine_id);
        $this->db->where('shift',$shift);
        $this->db->where('status',1);
        $this->db->where('job_complete_status !=',2);
        $result = $this->db->get(TBL_JOBS);
        return $result->result_array();
    }
    function get_downtime($date,$machine_id,$shift){
        $this->db->select('*');
        $this->db->where('date_from',$date);
        $this->db->where('machine',$machine_id);
        $this->db->where('shift',$shift);
        $this->db->where('status',1);
        $this->db->order_by('time_from','asc');
        $result = $this->db->get(TBL_MCDOWN);
        $results = $result->result_array();
        $rows=array();
        foreach ($results as $key => $result) {
            if($result['mc_down']==1){
                $result['job_code']="M/C Down";
            }elseif ($result['other_down']==1) {
                $result['job_code']=$result['reason'];
            }elseif ($result['setup']==1) {
                $result['job_code']="Setup";
            }elseif ($result['idle']==1) {
                $result['job_code']="Idle";
            }elseif ($result['maintenance']==1) {
                $result['job_code']="Maintenance";
            }
            
            $result['job_complete_status']=0;
            $rows[]=$result;
        }
        return $rows;
    }
}
