<?php

class dashboard_model extends CI_Model {

    function insert_machine($data){ 
        $this->db->insert(MST_MACHINE,$data);
        $insert_id = $this->db->insert_id();
        return  $insert_id;
    }
    function update_machine($data,$machine_id){
        $this->db->where('id',$machine_id);
        $this->db->update(MST_MACHINE,$data);
        if($this->db->affected_rows() >=0){
          return true; 
        }else{
          return false; 
        }
    }
    function get_machine(){
        $this->db->select('machine,id');
        $this->db->where('status',1);
        $this->db->order_by('position','asc');
        $result=$this->db->get(MST_MACHINE)->result_array();
        return $result;
    }
    function get_machine_low($shift,$date){
        $this->db->select('machine,id');
        $this->db->where('status',1);
        $this->db->order_by('id','desc');
        $results=$this->db->get(MST_MACHINE)->result_array();
        foreach($results as $key => $result){
            $this->db->select('*');
            $this->db->where('machine',$result['id']);
            $this->db->where('shift',$shift);
            $this->db->where('date_from',$date);
            $query=$this->db->get(TBL_MCDOWN);
            $jobs=$query->result_array();
            $result['position'] = 0;
            foreach($jobs as $key => $job){
                $datetime1 = new DateTime($job['time_from']);
            $datetime2 = new DateTime($job['time_to']);
            $interval = $datetime1->diff($datetime2);
            $result['position']=$result['position']+$interval->format('%h.%i');
            }
            //$result['position']=$query->num_rows();
            
            $rows[]=$result;
        }
        //echo "<pre>";print_r($rows);exit;
        usort($rows, 'sortByposition');
        $option="";
        //print_r($rows);exit;
        foreach($rows as $key => $row){
            if($key==0){
                $option.="<option selected value='".$row['id']."'>".$row['machine']."</option>";
                //$option.="<option value='".$row['id']."'>".$row['machine']."</option>";
            }else{
                $option.="<option value='".$row['id']."'>".$row['machine']."</option>";
            }
        }
        return array('option'=>$option,'machine'=>$rows);
    }
    function check_shift(){
        $this->db->select('machine,id');
        $this->db->where('status',1);
        $this->db->order_by('id','desc');
        $results=$this->db->get(MST_MACHINE)->result_array();
        foreach($results as $key => $result){
            $this->db->select('*');
            $this->db->where('machine',$result['id']);
            $this->db->where('shift',1);
            $this->db->where('date_from',date('Y-m-d'));
            $query=$this->db->get(TBL_MCDOWN);
            $jobs=$query->result_array();
            $result['position'] = 0;
            foreach($jobs as $key => $job){
                $datetime1 = new DateTime($job['time_from']);
            $datetime2 = new DateTime($job['time_to']);
            $interval = $datetime1->diff($datetime2);
            $result['position']=$result['position']+$interval->format('%h.%i');
            }
            //$result['position']=$query->num_rows();
            
            $rows[]=$result;
        }
    }
    function delete_machine($machine_id){
        $data['status']=0;
        $this->db->where('id',$machine_id);
        $this->db->update(MST_MACHINE,$data);
        if($this->db->affected_rows() >=0){
          return true; 
        }else{
          return false; 
        }
    }
    function get_machine_details($machine_id){
        $this->db->select('*');
        $this->db->where('id',$machine_id);
        $result=$this->db->get(MST_MACHINE)->row_array();
        return $result;
    }
    function get_bossjob_details($job_code){
        $CI =& get_instance();
        $this->db = $CI->load->database('default', TRUE);
        $this->db2 = $CI->load->database('boss', TRUE);

        $this->db2->select('*');
        $this->db2->from('boss_quotes');
        $this->db2->join('boss_tooling', 'boss_quotes.id = boss_tooling.quote_id');
        $this->db2->join('boss_tooling_time', 'boss_quotes.id=boss_tooling_time.quote_id');
        $this->db2->where('boss_quotes.ref_no',$job_code); 
        $result = $this->db2->get()->row_array();

        $total_minutes_boss_mac = (($result['std_mac_hr']*60) + $result['std_mac_min'] + $result['cpx_mac_min'] + ($result['cpx_mac_hr']*60));
        $total_minutes_boss_ass = (($result['std_ass_hr']*60) + $result['std_ass_min'] + $result['cpx_ass_min'] + ($result['cpx_ass_hr']*60));
        $total_minutes_boss_des = (($result['std_des_hr']*60) + $result['std_des_min'] + $result['cpx_des_min'] + ($result['cpx_des_hr']*60));
        $total = $total_minutes_boss_mac+$total_minutes_boss_ass+$total_minutes_boss_des;
        $total_min =  gmdate("H.i", ($total * 60)); 

        return array("total_time"=>$total_min,"quantity"=>$result['tooling_unit']);
    }
    function addjob_insert($data){
        $this->db->select('id,position,shift,machine');
        $this->db->where('date_from',$data['date_from']);
        $this->db->where('date_to',$data['date_to']);
        $this->db->where('machine',$data['machine']);
        $this->db->where('shift',$data['shift']);
        $this->db->where('position >=',$data['position']);
        $this->db->where('status',1);
        $query=$this->db->get(TBL_MCDOWN);
        $results = $query->result_array();
        if($query->num_rows() > 0){
            foreach($results as $key => $result){
                $pos['position'] = $result['position']+1;
                $this->db->where('id',$result['id']);
                $this->db->update(TBL_MCDOWN,$pos);
            }
        }
        $this->db->insert(TBL_MCDOWN,$data);
        $insert_id = $this->db->insert_id();
        return  $insert_id;
    }
    function insert_down($data){
        $this->db->insert(TBL_MCDOWN,$data);
        $insert_id = $this->db->insert_id();
        return  $insert_id;
    }
    function update_jobs($jobId,$data){
        $this->db->where('id',$jobId);
        $this->db->update(TBL_MCDOWN,$data);
        if($this->db->affected_rows() >=0){
          return true; 
        }else{
          return false; 
        }
    }
    function insert_shift($data){
        
        $this->db->where('date_from',$data['date_from']);
        $this->db->where('date_to',$data['date_to']);
        $query = $this->db->get(TBL_SHIFT);
        if($query->num_rows() > 0){
          $result = $query->row_array();
          $this->db->where('id',$result['id']);
          $this->db->update(TBL_SHIFT,$data);
          return $result['id'];
        }else{
          $this->db->insert(TBL_SHIFT,$data);
          $insert_id = $this->db->insert_id();
          return  $insert_id;
        }        
    }
    function update_shift($data,$shift_id){
        $this->db->where('id',$shift_id);
        $this->db->update(TBL_SHIFT,$data);
        if($this->db->affected_rows() >=0){
          return true; 
        }else{
          return false; 
        }
    }
    function get_shift_details($date_from){
        $this->db->select('*');
        $this->db->where('date_from',$date_from);
        $this->db->where('status',1);
        $result=$this->db->get(TBL_SHIFT)->row_array();
        return $result;
    }
    function downreport($downreport){

        $shifts = array(1,2,3);
        $this->db->select('tbl_mcdown.*,mst_machine.machine');
        $this->db->from('tbl_mcdown');
        $this->db->join('mst_machine', 'tbl_mcdown.machine = mst_machine.id');
       
        $where = '(tbl_mcdown.date_from >="'.$downreport['date_from'].'" AND tbl_mcdown.date_to <="'.$downreport['date_to'].'" )';
        $this->db->where_in('shift',$shifts);
         
 
        $this->db->where($where);         

        $this->db->where('tbl_mcdown.mc_down',1);
        $this->db->where('tbl_mcdown.machine',$downreport['machine']);
        $this->db->where('tbl_mcdown.status',1);
        $result=$this->db->get()->result_array();
         

        return $result; 
    }
    function idlereport($idlereport){
        $this->db->select('tbl_mcdown.*,mst_machine.machine');
        $this->db->from('tbl_mcdown');
        $this->db->join('mst_machine', 'tbl_mcdown.machine = mst_machine.id');
        $this->db->where('date_from >=',$idlereport['date_from']);
        $this->db->where('date_from <=',$idlereport['date_to']);
        $this->db->where('tbl_mcdown.idle',1);
        $this->db->where('tbl_mcdown.machine',$idlereport['machine']);
        $result=$this->db->get()->result_array();
        return $result; 
    }
    function setupreport($setupreport){
        $this->db->select('tbl_mcdown.*,mst_machine.machine');
        $this->db->from('tbl_mcdown');
        $this->db->join('mst_machine', 'tbl_mcdown.machine = mst_machine.id');
        $this->db->where('date_from >=',$setupreport['date_from']);
        $this->db->where('date_from <=',$setupreport['date_to']);
        $this->db->where('tbl_mcdown.setup',2);
        $this->db->where('tbl_mcdown.machine',$setupreport['machine']);
        $result=$this->db->get()->result_array();
        return $result;
    }
    function maintainreport($maintainreport){
        $this->db->select('tbl_mcdown.*,mst_machine.machine');
        $this->db->from('tbl_mcdown');
        $this->db->join('mst_machine', 'tbl_mcdown.machine = mst_machine.id');
        $this->db->where('date_from >=',$maintainreport['date_from']);
        $this->db->where('date_from <=',$maintainreport['date_to']);
        $this->db->where('tbl_mcdown.maintenance',1);
        $this->db->where('tbl_mcdown.machine',$maintainreport['machine']);
        $result=$this->db->get()->result_array();
        return $result;
    }
    function get_jobs($date,$machine_id,$shift){
        $this->db->select('*');
        $this->db->where('date_from',$date);
        $this->db->where('machine',$machine_id);
        $this->db->where('shift',$shift);
        $this->db->where('status',1);
        $this->db->where('mc_down !=',1);
        $this->db->where('other_down !=',1);
        $this->db->where('job_complete_status !=',2);
        $result = $this->db->get(TBL_MCDOWN);
        return $result->result_array();
    }
    function get_downtime($date,$machine_id,$shift){
        $this->db->select('*');
        //$this->db->where('date_from',$date);
        $this->db->where('machine',$machine_id);
        $this->db->where('shift',$shift);
        $this->db->where('status',1);
        $this->db->order_by('time_from','asc');
        //$this->db->where('job_complete_status !=',2);
        $result = $this->db->get(TBL_MCDOWN);
        $rets = $result->result_array();
        $results=array();
        foreach($rets as $key => $value){
            if (($date >= $value['date_from']) && ($date <= $value['date_to'])){
                $results[]=$value;
            }
        }
        $rows=array();
        foreach ($results as $key => $result) {
            if($result['mc_down']==1){
                $result['job_code']="M/C Down";
                $result['class']="red_box disabled";
            }elseif ($result['other_down']==1) {
                $result['job_code']=$result['reason'];
                $result['class']="lightblue_box disabled";
            }elseif (($result['setup']==1) ) {
                //$result['job_code']="Setup";
                $result['class']="yellow_box disabled";
            }elseif ($result['idle']==1) {
                $result['job_code']="Idle";
                $result['class']="green disabled";
            }elseif ($result['maintenance']==1) {
                $result['job_code']="Maintenance";
                $result['class']="lightblue_box disabled";
            }elseif($result['job_complete_status']==2){
                $result['class']="job_done disabled";
            }elseif($result['job_complete_status']==1){
                $result['class']="job_running disabled";
            }elseif (($result['setup']==2) ) {
                //$result['job_code']="Setup";
                $result['class']="yellow_box disabled";
            }else{
                $result['class']="job_loaded disabled";
            }
             
            $rows[]=$result;
        }
        return $rows;
    }
    function check_job_availability($data){
        $time_from = $data['time_from'];
        $time_to = $data['time_to'];
        $this->db->select('*');
        $this->db->where('date_from',$data['date_from']);
        $this->db->where('date_to',$data['date_to']);
        $this->db->where('machine',$data['machine']);
        $this->db->where('shift',$data['shift']);
        $this->db->where('status !=',0);
        $results = $this->db->get(TBL_MCDOWN)->result();
        $value = 0;
        $mcdown= 0;
        
        foreach ($results as $key => $result) {
            $test=(check_time($result->time_from,$result->time_to,$time_to) ? 1 : 0);
            if($test){
                $value = $value+1;
                if($result->mc_down==1){
                    $mcdown= $mcdown+1;
                }
            }
        }
        if($value > 0){
            if($mcdown > 0){
                $return['job']=1;
                $return['mcdown']=1;
                return $return;
            }else{
                $return['job']=1;
                $return['mcdown']=0;
                return $return;
            }
        }else{
            $return['job']=0;
            if($mcdown > 0){
                $return['mcdown']=1;
            }else{
                $return['mcdown']=0;
            }
            return $return;
        }
    }
    function change_job_position($id,$pos){
        $this->db->where('id',$id);
        $this->db->update(TBL_MCDOWN,$pos);
        if($this->db->affected_rows() >=0){
          return true; 
        }else{
          return false; 
        }
    }
    function checking_timing($data){
        //echo "<pre>";print_r($data);exit;
        $this->db->select("*");
        $this->db->where_in("id",$data);
        $results=$this->db->get(TBL_MCDOWN)->result_array();
        //echo "<pre>";//print_r($result);exit;
        foreach ($results as $key => $value) {
        
            $to_time = strtotime($value['date_to'].' '.$value['time_to']);
        $from_time = strtotime($value['date_from'].' '.$value['time_from']);
        $interval=round(abs($to_time - $from_time) / 60,2);
                            
            $value['interval']=$interval;
            $rows[] = $value;
        }
        $time_return=get_array_sum($rows,'interval');

        if($time_return <= 780 ){
            return false;
        }else{
            return true;
        }
    }
    /*function check_position($data,$overwrite){
        $time_from=$data['time_from'];
        if($overwrite==0){
            $this->db->select('*');
            $this->db->where('machine',$data['machine']);
            $this->db->where('date_from',date('Y-m-d'));
            $this->db->where('shift',$data['shift']);
            $this->db->order_by('position','desc');
            $this->db->limit(1);
            $query = $this->db->get(TBL_MCDOWN); 
            if($query->num_rows() > 0){
                    $results=$query->row_array();
                    $pos=$results['position'];
                    return $pos+1;
            }else{
                    return '0';
            }
        }else{
            $this->db->select('*');
            $this->db->where('machine',$data['machine']);
            $this->db->where('shift',$data['shift']);
            $this->db->where('date_from',date('Y-m-d'));
            $this->db->order_by('position','asc');
            $query = $this->db->get(TBL_MCDOWN); 
            if($query->num_rows() > 0){
                //echo "<pre>";print_r($query->result_array());exit;
                $results=$query->result_array(); 
                foreach($results as $key => $result){
                    $test=(check_time($result['time_from'],$result['time_to'], $time_from) ? 1 : 0); 
                        if($test){
                            $value = $key; 
                        }
                    }
                    if(isset($value)){
                        return $results[$value]['position'];
                    }else{
                        return '0';
                    } 
                
            }else{
                    return '0';
            }
        }
    }*/
    function check_position($data,$overwrite){
        $time_from=$data['time_from'];
        if($overwrite==0){
        
           if(!isset($data['position'])){
           	$data['position'] = 0;
           }
           return $this->addjob_insert($data);

        }else{
            $data['position'] = 0;
            $insid=$this->addjob_insert($data);
            $this->db->select('*');
            $this->db->where('machine',$data['machine']);
            $this->db->where('shift',$data['shift']);
            $this->db->where('date_from',$data['date_from']);
            $this->db->order_by('position','asc');
            $query = $this->db->get(TBL_MCDOWN); 
            if($query->num_rows() > 0){
                //echo "<pre>";print_r($query->result_array());
                $results=$query->result_array(); 
                usort($results, 'sortBytime_from');
                //print_r($results);exit;
                foreach($results as $key => $result){
                    if($key != 0){
                        $old_job = $results[$key-1];
                        $cur_job =  $result;
                        
                        $datetime1 = new DateTime($cur_job['date_from'].' '.$cur_job['time_from']);
                        $datetime2 = new DateTime($cur_job['date_to'].' '.$cur_job['time_to']);
                        $interval = $datetime1->diff($datetime2);
                        $diffhour = $interval->format('%h');
                        $diffmin = $interval->format('%i');
                    
                        $startTime = new DateTime($old_job['time_to']);
                        $startTime->modify('+'.$diffhour.' hours');
                        $startTime->modify('+'.$diffmin.' minutes');
                        $update['date_from'] = $cur_job['date_from'];
                        $update['date_to'] = $cur_job['date_to'];
                        $update['time_from'] = $old_job['time_to']; 
                        $update['time_to'] = $startTime->format('H:i:s');
                    
                        $this->db->where('id',$cur_job['id']);
                        $this->db->update(TBL_MCDOWN,$update);  
                        
                    }
                }
            }
            return $insid;
        }
    }
    function get_shifts($date){
        $results=$this->db->get(TBL_SHIFT)->result();
        $id = array();
        $shift1 = 0;
        $shift2 = 0;
        $shift3 = 0;
        foreach($results as $key => $result){
            if (($date >= $result->date_from) && ($date <= $result->date_to)){
                if($result->shift1==1){
                    $shift1 = $shift1 +1;
                }
                if($result->shift2==1){
                    $shift2 = $shift2 +1;
                }
                if($result->shift3==1){
                    $shift3 = $shift3 +1;
                }
            }
        }
        $shift=array();
        if( $shift1 > 0 ){
            $shift[]=1;

        }
        if( $shift2 > 0 ){
        $shift[]=2;
        }
        if( $shift3 > 0 ){
        $shift[]=3;
        }
        if(empty($shift)){
            $shift[]=1;
        }
        return $shift;
    }
    function get_job_details($id){
        $this->db->where('id',$id);
        $query = $this->db->get(TBL_MCDOWN);
        if($query->num_rows() > 0 ){
            return $query->row_array();
        }else{
            return false;
        }
    
    }

    function get_lastjob_endtiming($data){ 
        $this->db->select('*');
        $this->db->where('machine',$data['id']);
        $this->db->where('shift',$data['shift']);
        $this->db->where('date_from',$data['date']);
        $this->db->where('status !=',0);
        $this->db->order_by('position','asc');
        $query = $this->db->get(TBL_MCDOWN);  
        if($query->num_rows() > 0){ 
            $results=$query->result_array(); 
            usort($results, 'sortBytime_from'); 
            $last_job = end($results);
            return $last_job['date_to'].' '.$last_job['time_to'];
        }else{
            return false; 
        }

    }
    function get_current_job_starttiming($data){ 
        $this->db->select('*');
        $this->db->where('job_code',$data['job_code']);
        $this->db->where('machine',$data['id']);
        $this->db->where('shift',$data['shift']);
        $this->db->where('date_from',$data['date']);
        $this->db->where('status !=',0);
        $this->db->order_by('position','asc');
        $query = $this->db->get(TBL_MCDOWN); 
        if($query->num_rows() > 0){ 
            $results=$query->result_array(); 
            $last_job = end($results);
            return $last_job['date_from'].' '.$last_job['time_from'];
        }else{
            return false; 
        }

    }
    function update_machine_pos($id,$pos){
         $data['position'] = $pos;
         $data['updated_on'] = date('Y-m-d H:i:s');
         $this->db->where('id',$id);
         $this->db->update(MST_MACHINE,$data);
         if( $this->db->affected_rows() >=0 ){
             return true; 
         }else{
             return false; 
         }
         
    }

    function get_users($requestData){ 
        $columns = array( 
        // datatable column index  => database column name
            0 =>'firstname', 
            1 => 'lastname',
            2=> 'username',
            3=> 'designation'
        ); 
        $query = $this->db->get(TBL_USERS);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;


        $this->db->select('firstname,lastname,username,designation');
        if( !empty($requestData['search']['value']) ) { 
            $this->db->like('firstname',$requestData['search']['value']);
            $this->db->or_like('lastname',$requestData['search']['value']);
            $this->db->or_like('username',$requestData['search']['value']);
            $this->db->or_like('designation',$requestData['search']['value']);
        }
        $query = $this->db->get(TBL_USERS);
        $totalFiltered = $query->num_rows();
        $results = $query->result_array(); 

        $data = array();
        foreach ($results as $key => $row) {
            $nestedData=array(); 
            $nestedData[] = $row["firstname"];
            $nestedData[] = $row["lastname"];
            $nestedData[] = $row["username"];
            $nestedData[] = $row["designation"]; 
            
            $data[] = $nestedData;
        }
        $json_data = array(
            "draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
            "recordsTotal"    => intval( $totalData ),  // total number of records
            "recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
            "data"            => $data   // total data array
        );
        return $json_data;
    }

/**
*
*
*
**/

    function get_reasons(){
        $this->db->where('status',1);
        $this->db->order_by('position','asc');
        return $this->db->get(MST_REASONS)->result_array();
    }
    function insert_reason($data){ 
        $this->db->insert(MST_REASONS,$data);
        $insert_id = $this->db->insert_id();
        return  $insert_id;
    }
    function update_reason($data,$reason_id){
        $this->db->where('id',$reason_id);
        $this->db->update(MST_REASONS,$data);
        if($this->db->affected_rows() >=0){
          return true; 
        }else{
          return false; 
        }
    }

    function get_reason_details($reason_id){
        $this->db->select('*');
        $this->db->where('id',$reason_id);
        $result=$this->db->get(MST_REASONS)->row_array();
        return $result;
    }

    function update_reason_pos($id,$pos){
         $data['position'] = $pos;
         $data['updated_on'] = date('Y-m-d H:i:s');
         $this->db->where('id',$id);
         $this->db->update(MST_REASONS,$data);
         if( $this->db->affected_rows() >=0 ){
             return true; 
         }else{
             return false; 
         }
         
    }
    
    function insert_machine_down($data){
        $time_from = $data['time_from'];
        $time_to = $data['time_to'];
        $this->db->select('*');
        $this->db->where('date_from ',$data['date_from']); 
        $this->db->where('machine',$data['machine']);
        $this->db->where('shift',$data['shift']);
        $results = $this->db->get(TBL_MCDOWN)->result_array();
        
        usort($results , 'sortBytime_from'); 

        foreach ($results as $key => $result) {
            $test=(check_time($result['time_from'],$result['time_to'],$time_to) ? 1 : 0);
            if($test){
                $job_match = $key;
            } 
        }
        if(isset($job_match)){ 
            for($i=0;$i < $job_match;$i++){
                unset($results[$i]);
            }
            $old_time =$data['time_to'];
            foreach ($results as $key => $result) {
                $datetime1 = new DateTime($result['date_from'].' '.$result['time_from']);
        $datetime2 = new DateTime($result['date_to'].' '.$result['time_to']);
        $interval = $datetime1->diff($datetime2);
        $diffhour = $interval->format('%h');
        $diffmin = $interval->format('%i');
        $new['time_from'] = $old_time ;
        $startTime = new DateTime($new['time_from']);
        $startTime->modify('+'.$diffhour.' hours');
        $startTime->modify('+'.$diffmin.' minutes');
        $new['time_to'] = $startTime->format('H:i:s');
        
        $this->db->where('id',$result['id']);
            $this->db->update(TBL_MCDOWN,$new);
        $old_time =$new['time_to'];
            } 
        } 
        $this->db->insert(TBL_MCDOWN,$data);
        $insert_id = $this->db->insert_id();
        return  $insert_id;
         
    }
   
   function get_jobdetails_jobcode($jobcode){
        $this->db->where('job_code',$jobcode);
        $this->db->where('status',1);
        $result = $this->db->get(TBL_MCDOWN);
        if($result->num_rows() > 0){
            return $result->row_array();
        }else{
            return false;
        }
    }

   function insert_cft_members($data){
        $this->db->insert(MST_CFT_MEMBERS,$data);
        $insert_id = $this->db->insert_id();
        return  $insert_id;
   }

   function get_cft_members(){ 
       $this->db->select('id,name,phone');
       $this->db->where('status',1);
       $result = $this->db->get(MST_CFT_MEMBERS);
       if($result->num_rows() > 0){
           return $result->result_array();
       }else{
           return FALSE;
       }
   }

   function insert_cft_report($data){
        $this->db->insert(TBL_CFT_REPORTS,$data);
        $insert_id = $this->db->insert_id();
        return  $insert_id;
   }

   function get_cft_reports(){
       $this->db->where('status',1);
       $result = $this->db->get(TBL_CFT_REPORTS);
       if($result->num_rows() > 0){
           return $result->result_array();
       }else{
           return FALSE;
       }
   }

   function get_machine_name($id){
        $this->db->select('machine');
        $this->db->where('id',$id); 
        $result=$this->db->get(MST_MACHINE)->row_array();
        return $result['machine'];
    }

   function get_user_name($user){
       $this->db->where('id',$user);
       $result = $this->db->get(MST_CFT_MEMBERS)->row_array();
       return $result['name'];
   }
   function get_user_number($user){
       $this->db->where('id',$user);
       $result = $this->db->get(MST_CFT_MEMBERS)->row_array();
       return $result['phone'];
   }
   function remove_cft_report($id){
       $data['status'] = 0;
       $this->db->where('id',$id);
       $result = $this->db->update(TBL_CFT_REPORTS,$data);
       return $id;
   }

   function remove_cft_member($id){
       $data['status'] = 0;
       $this->db->where('id',$id);
       $result = $this->db->update(MST_CFT_MEMBERS,$data);
       return $id;
   }
   
   function shift_timings($data){
        
        $this->db->where('date_from',$data['date_from']);
        if(isset($data['date_to'])){
            $this->db->where('date_to',$data['date_to']);   
        }
        $query = $this->db->get(TBL_SHIFT);
        
        if($query->num_rows() > 0){ 
          $result = $query->row_array();
          $this->db->where('id',$result['id']);
          $this->db->update(TBL_SHIFT,$data);
          return $result;
        }else{
            $query = $this->db->get(TBL_SHIFT);
            $results = $query->result_array(); 
            foreach($results as $key => $result){
                //if(($result['date_from'] >= $data['date_from'])&&($result['date_to'] <= $data['date_to'])){
                if (($data['date_from'] >= date('Y-m-d', strtotime($result['date_from']))) && ($data['date_from'] <= date('Y-m-d', strtotime($result['date_to'])))){
                    return $result;
                }
            }
            $shift['shift1_from'] = DEFAULT_SHIFT1_START_TIME;
            if (defined('DEFAULT_SHIFT_AFTER_EIGHT_END_TIME')) {
                $shift['shift1_to']   = DEFAULT_SHIFT_AFTER_EIGHT_END_TIME;
            }else{
                $shift['shift1_to']   = DEFAULT_SHIFT1_END_TIME;
            }
            $shift['shift2_from'] = DEFAULT_SHIFT2_START_TIME;
            $shift['shift2_to']   = DEFAULT_SHIFT2_END_TIME;
            $shift['shift3_from'] = DEFAULT_SHIFT3_START_TIME;
            $shift['shift3_to']   = DEFAULT_SHIFT3_END_TIME;
            $shift['shift1']      = 1;
            $shift['shift2']      = 0;
            $shift['shift3']      = 0;
            return $shift;
        }
   }
   function shift_timing_list($from_time,$to_time){

       if(date('H:i:s',strtotime($to_time)) > date('H:i:s',strtotime($from_time)) ){
           $date_from = date("Y-m-d");
           $date_to = date("Y-m-d"); 
       }else{
           $date_from = date("Y-m-d");
           $date_to = date('Y-m-d', strtotime(" +1 days",strtotime($date_from)));
       }
       
       
       $datetime1 = new DateTime($date_from.' '.date('H:i:s',strtotime($from_time)));
       $datetime2 = new DateTime($date_to.' '.date('H:i:s',strtotime($to_time)));
       $interval1 = $datetime1->diff($datetime2);
       $diffhour = $interval1->format('%h');
       $diffmin = $interval1->format('%i'); 

       $pre_time = date('H:i:s', strtotime($from_time));
       $list = "<li>".date('h A', strtotime($pre_time))."</li>";
       for($i=1;$i<=$diffhour;$i++){
           $current_time = date('H:i:s', strtotime($pre_time. " +1 hours"));
           $list .="<li >".date('h A', strtotime($pre_time. " +1 hours"))."</li>";
           $pre_time =$current_time;
       }
       return $list;
   }
   
   
   function check_order_location($order_code){
       $this->db->select('tbl_mcdown.*,tbl_order_delivery_location.*');
       $this->db->from('tbl_mcdown');
       $this->db->join('tbl_order_delivery_location','tbl_order_delivery_location.order_code = tbl_mcdown.job_code');
       $this->db->where('tbl_mcdown.job_code',$order_code);
       $query = $this->db->get();
 
       if( $query->num_rows() > 0 ){
       	return $query->row_array();
       }else{
       	return false;
       }
       
   }

    function get_wims_hrs($job_code){
        $CI =& get_instance();
        $this->db = $CI->load->database('default', TRUE);
        $this->boots = $CI->load->database('boots', TRUE);
        $this->boots->where('tjob_code',$job_code);
        $query = $this->boots->get('tbl_tooling_jobs');

        if($query->num_rows() > 0){
            return $query->row_array();
        }else{
            return false;
        }
    }


   
    function get_job_details_boots($job_code){
        $CI =& get_instance();
        $this->db = $CI->load->database('default', TRUE);
        $this->boots = $CI->load->database('boots', TRUE);
        $this->boots->where('tjob_code',$job_code);
        $query = $this->boots->get('tbl_tooling_jobs');

        if($query->num_rows() > 0){
            return $query->row_array();
        }else{
            return false;
        }
    }
    
    function get_all_users(){
        $this->db->select('tbl_users.*');
        $this->db->from('tbl_users');
        $this->db->join('tbl_locations', 'tbl_users.id = tbl_locations.user_id','outter');
        $this->db->group_by('tbl_users.id');
    	$query = $this->db->get();
    	if($query->num_rows() > 0){
    		return $query->result_array();
    	}else{
    		return false;
    	}
    }
    
    function get_job_status($job_code){
    
        $job_details = $this->get_job_details_boots($job_code);
        
        if($job_details['tjob_complet_status']==2){
        	$status = array('status'=>8,'status_word'=>'COMPLETED','job_code'=>$job_code);
        }elseif($job_details['tjob_shipped_status']==2){
        	$status = array('status'=>7,'status_word'=>'SHIPPING','job_code'=>$job_code);
        }elseif($job_details['tjob_production_status']==2){
        	$status = array('status'=>6,'status_word'=>'PRODUCTION COMPLETED','job_code'=>$job_code);
        }elseif($job_details['tjob_production_status']==1){
        	$status = array('status'=>5,'status_word'=>'PRODUCTION STARTED','job_code'=>$job_code);
        }elseif($job_details['tjob_tooling_status']==2){
        	$status = array('status'=>4,'status_word'=>'TOOLING COMPLETED','job_code'=>$job_code);
        }elseif($job_details['tjob_tooling_status']==1){
        	$status = array('status'=>3,'status_word'=>'TOOLING STARTED','job_code'=>$job_code);
        }elseif($job_details['tjob_cad_status']==2){
        	$status = array('status'=>2,'status_word'=>'CAD COMPLETED','job_code'=>$job_code);
        }elseif($job_details['tjob_cad_status']==1){
        	$status = array('status'=>1,'status_word'=>'CAD STARTED','job_code'=>$job_code);
        }else{
            $status = array('status'=>0,'status_word'=>'STATUS NOT FOUND','job_code'=>$job_code);
        } 
        
        return $status;
    }
    
    function get_shipping_user($job_code){
       $this->db->select('tbl_mcdown.*,tbl_shipping.*');
       $this->db->from('tbl_mcdown');
       $this->db->join('tbl_shipping','tbl_shipping.order_id = tbl_mcdown.id');
       $this->db->where('tbl_mcdown.job_code',$job_code);
       $query = $this->db->get();
 
       if( $query->num_rows() > 0 ){
       		$result = $query->row_array();
       		return $result['user_id'];
       }else{
       	return false;
       }
    }
    
    function get_username($user_id){
    	$this->db->where('id',$user_id); 
    	$query = $this->db->get(TBL_USERS);
    	$result = $query->row_array();
    	return $result['firstname'].' '.$result['lastname'];
    }
    
    function get_user_locations($user_id){
    	$this->db->where('user_id',$user_id);
    	$this->db->order_by('id','desc');
    	$this->db->limit(1);
    	$query = $this->db->get(TBL_LOCATIONS);
    	if($query->num_rows() > 0){
    		return $query->row_array();
    	}else{
    		return false;
    	}
    }
    
    function check_job_or_mcdown($data){
    //echo "<pre>";print_r($data);exit;
    	$time_from = $data['time_to'];
        $time_to = $data['time_from'];
        $this->db->select('*');
        $this->db->where('date_from',$data['date_from']);
        $this->db->where('date_to',$data['date_from']);
        $this->db->where('machine',$data['machine']);
        $this->db->where('shift',$data['shift']);
        $this->db->where('status !=',0);
        $results = $this->db->get(TBL_MCDOWN)->result();
        //echo "<pre>";print_r($results);exit;
        $value = 0;
        $mcdown= 0;
        $task= 0;
        $running = 0;
        $job_id = 0;
        foreach ($results as $key => $result) {
            $test=(check_time($result->time_from,$result->time_to,$time_to) ? 1 : 0);
            if($test){
                $value = $value+1;
                if($result->mc_down==1){
                    $mcdown= $mcdown+1;
                }
                if($result->task == 1){
                	$task = $task+1;
                }
                if($result->job_complete_status == 1){
                	$running= $running+1;
                }
                $job_id= $result->id;
            }
        }
        if($value > 0){
            if($mcdown > 0){
                $return['job']=1;
                $return['mcdown']=1;
                if($task > 0){
			$return['task']=1;
		}else{
			$return['task']=0;
		}
		if($running > 0){
			$return['running']=1;
		}else{
			$return['running']=0;
		}
		$return['job_id'] = $job_id;
                return $return;
            }else{
                $return['job']=1;
                $return['mcdown']=0;
                if($task > 0){
			$return['task']=1;
		}else{
			$return['task']=0;
		}
		if($running > 0){
			$return['running']=1;
		}else{
			$return['running']=0;
		}
		$return['job_id'] = $job_id;
                return $return;
            }
        }else{
        	$time_to = date('H:i:00', strtotime('-5 minutes',strtotime($time_to)));
        	foreach ($results as $key => $result) {
	            $test=(check_time($result->time_from,$result->time_to,$time_to) ? 1 : 0);
	            if($test){
	                $value = $value+1;
	                if($result->mc_down==1){
	                    $mcdown= $mcdown+1;
	                }
	                if($result->task == 1){
	                	$task = $task+1;
	                }
	                if($result->job_complete_status == 1){
				$running= $running+1;
			}
			$job_id= $result->id;
	            }
	        }
        	if($value > 0){
			if($mcdown > 0){
				$return['job']=1;
				$return['mcdown']=1;
				if($task > 0){
					$return['task']=1;
				}else{
					$return['task']=0;
				}
				if($running > 0){
					$return['running']=1;
				}else{
					$return['running']=0;
				}
				$return['job_id'] = $job_id;
				return $return;
			}else{
				$return['job']=1;
				$return['mcdown']=0;
				if($task > 0){
					$return['task']=1;
				}else{
					$return['task']=0;
				}
				if($running > 0){
					$return['running']=1;
				}else{
					$return['running']=0;
				}
				$return['job_id'] = $job_id;
				return $return;
			}
        	}else{ 
			$time_to = date('H:i:00', strtotime('+5 minutes',strtotime($time_to)));
	        	foreach ($results as $key => $result) {
		            $test=(check_time($result->time_from,$result->time_to,$time_to) ? 1 : 0);
		            if($test){
		                $value = $value+1;
		                if($result->mc_down==1){
		                    $mcdown= $mcdown+1;
		                }
		                if($result->task == 1){
		                	$task = $task+1;
		                }
		                if($result->job_complete_status == 1){
					$running= $running+1;
				}
				$job_id= $result->id;
		            }
		        }
	        	if($value > 0){
				if($mcdown > 0){
					$return['job']=1;
					$return['mcdown']=1;
					if($task > 0){
						$return['task']=1;
					}else{
						$return['task']=0;
					}
					if($running > 0){
						$return['running']=1;
					}else{
						$return['running']=0;
					}
					$return['job_id'] = $job_id;
					return $return;
				}else{
					$return['job']=1;
					$return['mcdown']=0;
					if($task > 0){
						$return['task']=1;
					}else{
						$return['task']=0;
					}
					if($running > 0){
						$return['running']=1;
					}else{
						$return['running']=0;
					}
					$return['job_id'] = $job_id;
					return $return;
				}
	        	}else{ 
				$return['job']=0;
				if($mcdown > 0){
					$return['mcdown']=1;
				}else{
					$return['mcdown']=0;
				}
				if($task > 0){
					$return['task']=1;
				}else{
					$return['task']=0;
				}
				if($running > 0){
					$return['running']=1;
				}else{
					$return['running']=0;
				}
				$return['job_id'] = $job_id;
	            		return $return;
			}
		}
        }
    }
    
    function check_andready_mcdown($data){  
        $this->db->select('*');
        $this->db->where('date_from',$data['date_from']);
        $this->db->where('date_to',$data['date_to']);
        $this->db->where('machine',$data['machine']);
        $this->db->where('shift',$data['shift']);
        $this->db->where('status !=',0);
        $results = $this->db->get(TBL_MCDOWN)->result_array();
 
        foreach ($results as $key => $result) {
        	if(($result['mc_down'] == 1)&&($result['task'] == 0)){
        		$update['status'] = 0;
        		$update['task'] = 1;
        		$this->db->where('id',$result['id']);
        		$this->db->update(TBL_MCDOWN,$update);
        	}
        }
    }
    
    function insert_schedule($data){
        $this->db->insert('tbl_schedule',$data);
        $insert_id = $this->db->insert_id();
        return  $insert_id;
    }
    
    function get_schedules(){
        $query = $this->db->get('tbl_schedule');
        if( $query->num_rows() > 0 ){
            return $query->result_array();
        }else{
            return false;
        }
    }
    
    function remove_schedule($id){
        $this->db->where('id', $id);
        $this->db->delete('tbl_schedule');
        return true;
    }
  
}
