'use strict';
//  Author: ThemeREX.com
//  forms-elements.html scripts
//

(function($) {

    $(document).ready(function() {

        "use strict";

        // Init Demo JS
        Demo.init();


        // Init Theme Core
        Core.init();

        // Form Switcher
        $('#form-switcher > button').on('click', function() {
            var btnData = $(this).data('form-layout');
            var btnActive = $('#form-elements-pane .allcp-form.active');

            // Remove existing animations and add fade out to the form
            btnActive.removeClass('slideInUp').addClass('animated fadeOutRight animated-shorter');
            // When exit animation ends and we remove unneeded classes and animating new form
            btnActive.one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function() {
                btnActive.removeClass('active fadeOutRight animated-shorter');
                $('#' + btnData).addClass('active animated slideInUp animated-shorter')
            });
        });

        // Cache DOM
        var pageHeader = $('.content-header').find('b');
        var allcpForm = $('.allcp-form');
        var options = allcpForm.find('.option');
        var switches = allcpForm.find('.switch');
        var buttons = allcpForm.find('.button');
        var Panel = allcpForm.find('.panel');

        // Skin Switcher
        $('#skin-switcher a').on('click', function() {
            var btnData = $(this).data('form-skin');

            $('#skin-switcher a').removeClass('item-active');
            $(this).addClass('item-active');

            allcpForm.each(function(i, e) {
                var skins = 'theme-primary theme-info theme-success theme-warning theme-danger theme-alert theme-system theme-dark';
                var panelSkins = 'panel-primary panel-info panel-success panel-warning panel-danger panel-alert panel-system panel-dark';
                $(e).removeClass(skins).addClass('theme-' + btnData);
                Panel.removeClass(panelSkins).addClass('panel-' + btnData);
                pageHeader.removeClass().addClass('text-' + btnData);
            });

            $(options).each(function(i, e) {
                if ($(e).hasClass('block')) {
                    $(e).removeClass().addClass('block mt15 option option-' + btnData);
                } else {
                    $(e).removeClass().addClass('option option-' + btnData);
                }
            });
            $(switches).each(function(i, ele) {
                if ($(ele).hasClass('switch-round')) {
                    if ($(ele).hasClass('block')) {
                        $(ele).removeClass().addClass('block mt15 switch switch-round switch-' + btnData);
                    } else {
                        $(ele).removeClass().addClass('switch switch-round switch-' + btnData);
                    }
                } else {
                    if ($(ele).hasClass('block')) {
                        $(ele).removeClass().addClass('block mt15 switch switch-' + btnData);
                    } else {
                        $(ele).removeClass().addClass('switch switch-' + btnData);
                    }
                }

            });
            buttons.removeClass().addClass('button btn-' + btnData);
        });

        setTimeout(function() {
            allcpForm.addClass('theme-info');
            pageHeader.addClass('text-info');

            $(options).each(function(i, e) {
                if ($(e).hasClass('block')) {
                    $(e).removeClass().addClass('block mt15 option option-info');
                } else {
                    $(e).removeClass().addClass('option option-info');
                }
            });
            $(switches).each(function(i, ele) {

                if ($(ele).hasClass('switch-round')) {
                    if ($(ele).hasClass('block')) {
                        $(ele).removeClass().addClass('block mt15 switch switch-round switch-info');
                    } else {
                        $(ele).removeClass().addClass('switch switch-round switch-info');
                    }
                } else {
                    if ($(ele).hasClass('block')) {
                        $(ele).removeClass().addClass('block mt15 switch switch-info');
                    } else {
                        $(ele).removeClass().addClass('switch switch-info');
                    }
                }
            });
            buttons.removeClass().addClass('button btn-info');
        }, 800);
    });

})(jQuery);
