<?php
defined('BASEPATH') OR exit('No direct script access allowed');
 
class Customers_model extends CI_Model {
 
    var $table = 'boss_tooling';
    
    var $column_order = array('boss_quotes.date_created','boss_quotes.company_id','boss_quotes.customer_id','boss_quotes.engineer_id','boss_quotes.assy_no','boss_quotes.quote_ref','boss_tooling.tooling_ref','boss_tooling.wims_ref','boss_tooling.quote_status','boss_tooling.tooling_unit','boss_tooling.tooling_cost_adp'); //set column field database for datatable orderable

    var $column_search = array('boss_quotes.date_created','boss_quotes.company_id','boss_quotes.customer_id','boss_quotes.engineer_id','boss_quotes.assy_no','boss_quotes.quote_ref','boss_tooling.tooling_ref','boss_tooling.wims_ref','boss_tooling.quote_status','boss_tooling.tooling_unit','boss_tooling.tooling_cost_adp');//set column field database for datatable searchable 

    var $order = array('date_created' => 'desc'); // default order 
 
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
 
    private function _get_datatables_query($stat = 0)
    {

        $this->db->select('boss_quotes.quote_user,boss_quotes.id,boss_quotes.quote_ref_sub,boss_quotes.quote_ref,boss_quotes.date_created,boss_quotes.company_id,boss_quotes.engineer_id,boss_tooling.wims_ref,
            boss_quotes.customer_id,boss_quotes.assy_no,boss_tooling.quote_status,boss_tooling.tooling_ref,boss_tooling.tooling_unit,boss_tooling.tooling_cost_adp,boss_tooling.multiple_quote_cost');

        $this->db->from('boss_tooling');

        $this->db->where('boss_tooling.status','1');

        $this->db->join('boss_quotes','boss_quotes.id=boss_tooling.quote_id');

        $this->db->where('boss_quotes.status','1');


        if($stat == "3")
        {
            $this->db->where('boss_tooling.status','1')->where('boss_tooling.quote_status',$stat);
        }

        //$this->db->order_by("boss_tooling.tooling_id", "desc");

        
 
        $i = 0;
     
        foreach ($this->column_search as $item) // loop column 
        {
            if($_POST['search']['value']) // if datatable send POST for search
            {
                 
                if($i===0) // first loop
                {
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $_POST['search']['value']);
                }
                else
                {
                    $this->db->or_like($item, $_POST['search']['value']);
                }
 
                if(count($this->column_search) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }
         


        if(isset($_POST['order'])) // here order processing
        {

            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } 
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables($status = 0)
    {
        $this->_get_datatables_query($status);
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
 
    function count_filtered($status = 0)
    {

        $this->_get_datatables_query($status);
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all()
    {
        $this->db->from($this->table);
        return $this->db->count_all_results();
    }
 
}