<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Quotes extends CI_Controller {

	public function __construct() {
        parent::__construct();
        if($this->session->userdata('usertype') != "user")
	{
	      redirect("Home");
	}
        //$this->load->view('layouts/header');
        $this->load->library('beamon_email');
        $this->load->library('m_pdf');
    }
	public function index()
	{
		//$this->load->view('dashboard/dashboard');
	}
	
	/*
	|
	|function to add new quotes
	|
	*/
	public function add_new_quotes()
	{
		
		if($this->input->post())
		{
			/*form validation here*/
			$this->form_validation->set_rules('company', 'Company Name', 'required');
			$this->form_validation->set_rules('company', 'Company Name', 'required');
			$this->form_validation->set_rules('assy_no', 'Assy No', 'required');

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata('response',error_message(validation_errors()),':old:');
				redirect('quotes/add_new_quotes');
			}
			else
			{
				/*
					generate quote reference number
					//get the count of engineer id
				*/
				//$eng_id = $this->input->post('engineer_id');
			 	//company id code here get from db2
				//get the customer ref number
				$get_customer_id = $this->crud_model_db2->get_one('cust_id','tbl_engineer',array('eng_id'=> $this->input->post('engineer_id')));

				$eng_id = $this->crud_model_db2->get_one('cust_ref','tbl_customer',array('cust_id' => $get_customer_id));
				
				//$eng_id = str_pad($this->input->post('engineer_id'), 3, '0', STR_PAD_LEFT);
				$sql = "SELECT * FROM `boss_quotes` WHERE `quote_ref` LIKE '$eng_id%' AND `quote_ref_sub` = '' AND `status` = '1'";
				$quote_count = $this->crud_model->get_count_by_sql($sql);
				$quote_count = $quote_count + 1;
				$quote_count_id = str_pad($quote_count, 3, '0', STR_PAD_LEFT);

				$quote_ref = str_pad($eng_id, 3, '0', STR_PAD_LEFT)."tq".$quote_count_id;
				
				//count the secondary email
				$email_cc_count = count($_POST['secondary_email']);
				$email_cc = "";
				if($email_cc_count > 0)
				{

					for($i = 0;$i < $email_cc_count; $i++)
					{
						if(!empty($this->input->post('secondary_email')[$i]))
						{
							$email_cc .= $this->input->post('secondary_email')[$i].",";
						}
					}
				}

				$quote_data = array(
							'quote_ref' => $quote_ref,
							'engineer_id' => $this->input->post('engineer_id'),
							'email_id' => $this->input->post('primary_email'),
							'email_id_cc' => $email_cc,
							'company_id' => $this->input->post('company'),
							'customer_id' => $this->input->post('customer'),
							'assy_no' => $this->input->post('assy_no'),
							'fab_ref' => $this->input->post('fab_no'),
							//'tooling_ref' => $this->input->post('tooling_ref_no'),
							'ref_no' => $this->input->post('ref_no'),
							'date_created' => Date('Y-m-d'),
							'tooling_exist' => "1",
							'quote_status' 	=>"1",
							'quote_type'	=> "0",
							'status'	=> "0"
						  );

				$id = $this->crud_model->insert('boss_quotes',$quote_data);
				redirect('tooling/index/'.$id);
				}
			}

		$breadcrumb['data'] = "Add New Quote";
		$data['engineer_data'] = $this->crud_model_db2->get('tbl_engineer');
             
          
		$this->load->view('layouts/header',$breadcrumb);
		$this->load->view('quotes/quotes_add',$data);
		$this->load->view('layouts/footer');
	}
	/*Function to view the status*/
	public function quote_status()
	{
		//get list of quotes from quotes table
		$data['records'] = $this->crud_model->get('boss_quotes',array('status' => '1'));
		$i=0;
		$data_result = array();
		if(!empty($data['records'])){
			foreach($data['records'] as $key => $value)
			{
				$data['records_tooling'] = $this->crud_model->get('boss_tooling',array('quote_id' => $value['id']));
				if(!empty($data['records_tooling']))
				{
					foreach ($data['records_tooling'] as $key1 => $value1) 
					{
						$data_result['records'][$i]['id'] = $value['id'];
						$data_result['records'][$i]['quote_status'] = $value1['quote_status'];
						$data_result['records'][$i]['quote_ref'] = $value['quote_ref'];
						$data_result['records'][$i]['quote_ref_sub'] = $value['quote_ref_sub'];
						$data_result['records'][$i]['assy_no'] = $value['assy_no'];
						$data_result['records'][$i]['customer_id'] = $value['customer_id'];
						$data_result['records'][$i]['date_created'] = $value['date_created'];
						$data_result['records'][$i]['tooling_id'] = $value1['tooling_id'];
						$data_result['records'][$i]['qty'] = $value1['multiple_quote'];
						$data_result['records'][$i]['cost'] = $value1['multiple_quote_cost'];
						$data_result['records'][$i]['units'] = $value1['tooling_unit'];
       						$data_result['records'][$i]['company_id'] = $value['company_id'];
                                                $data_result['records'][$i]['tooling_ref'] = $value1['tooling_ref'];


						$i++;
					}
				}
			}
		}

		if(!empty($data['records'])){
			foreach($data['records'] as $key => $value)
			{
				$data['records'][$key]['qty'] = $this->crud_model->get_one('multiple_quote','boss_tooling',array('quote_id' =>$data['records'][$key]['id']));
				$data['records'][$key]['cost'] = $this->crud_model->get_one('multiple_quote_cost','boss_tooling',array('quote_id' =>$data['records'][$key]['id']));
			}
		}
		$breadcrumb['data'] = "Quote List";
		$this->load->view('layouts/header',$breadcrumb);
		$this->load->view('quotes/quote_list',$data_result);
		$this->load->view('layouts/footer');

	}
	/*
		function is to view quotes
	*/
	public function view_quotes($quote_id=0)
	{
		/*using quote id get the data from the db*/
		$data['quote_details'] = $this->crud_model->get_row('boss_quotes',array('id' => $quote_id));
		$data['tooling_details'] = $this->crud_model->get('boss_tooling',array('quote_id' => $quote_id));
		//get the fixture name

		if(!empty($data['tooling_details']))
		{
			foreach ($data['tooling_details'] as $key => $value) {
				$fixture_name = $this->crud_model->get_row('boss_master_fixture_list',array('id' => $value['fixture_type']));
				$data['tooling_details'][$key]['tooling_name'] = $fixture_name['fixture_name'];
			}
		}

		$breadcrumb['data'] = "View Quote";
		$data['engineer_data'] = $this->crud_model_db2->get('tbl_engineer');
             

		$this->load->view('layouts/header',$breadcrumb);
		$this->load->view('quotes/quote_edit',$data);
		$this->load->view('layouts/footer');
	}

	public function tooling_cont($quote_id=0)
	{
		//update the quote status
		$this->crud_model->update('boss_quotes',array('tooling_cont'=>"1"),array('id' => $quote_id));
		redirect('quotes/quote_status');
	}

	public function tooling_cont_quote($quote_id=0)
	{
		$this->crud_model->update('boss_quotes',array('tooling_cont'=>"1"),array('id' => $quote_id));
		redirect('quotes/view_quotes/'.$quote_id);
	}

	public function chart()
	{
		//split the post
		$mnt_yr = $_POST['month'];
		$month_year = explode(" ",$mnt_yr);

		$month = $this->config->item('month')[$month_year[0]];

		$SQL = "select * from  boss_quotes where month(date_created) ='".$month."' ";
		$records = $this->crud_model->get_by_sql($SQL);

		if(!empty($records))
		{
			$resultant = array();

			//calculate the total days of month
			$total_days = cal_days_in_month(CAL_GREGORIAN,$month,$month_year[1]);

			//count the date
			for($i=1; $i<=$total_days;$i++)
			{
				$temp=0;
				foreach ($records as $key => $value) {
					//explode function to split date
					$sep_dat_mon = explode("-",$value['date_created']);

					if($sep_dat_mon[2] == $i)
					{
						$temp=$temp + $value['tooling_cost'];
						$resultant[$i] = $temp;
						//$resultant[$i] = 0;
					}
				}
			}

			//assign zero to unexisting date
			$resultant_final = array();
			for($u_i=1;$u_i<=$total_days;$u_i++)
			{
				if (!array_key_exists($u_i, $resultant)) {
	   					$resultant[$u_i] = 0;
					}
			}

			$resultant['length'] = count($resultant);
			echo json_encode($resultant);
		}
		else
		{
			$resultant = array();
			$total_days = cal_days_in_month(CAL_GREGORIAN,$month,$month_year[1]);
			for($u_i=1;$u_i<=$total_days;$u_i++)
			{
				$resultant[$u_i] = 0;
			}
			$resultant['length'] = count($resultant);
			echo json_encode($resultant);
		}
	}


	/*code to update the quote information*/
	public function update_quote($id="")
	{
		/*update code here*/
		$update_where = array('id' => $id);
		//count the secondary email
				$email_cc_count = count($_POST['secondary_email']);
				$email_cc = "";
				if($email_cc_count > 0)
				{

					for($i = 0;$i < $email_cc_count; $i++)
					{
						if(!empty($this->input->post('secondary_email')[$i]))
						{
							$email_cc .= $this->input->post('secondary_email')[$i].",";
						}
					}
				}
		$quote_data = array(
							'engineer_id' => $this->input->post('engineer_id'),
							'email_id' => $this->input->post('primary_email'),
							'email_id_cc' => $email_cc
						  );

		$this->crud_model->update('boss_quotes',$quote_data,$update_where);
		redirect('quotes/view_quotes/'.$id);
	}

	/**/
	function ajax_get_engineer_detail($id=0)
	{

		$data['eng_detail'] = $this->crud_model_db2->get_row('tbl_engineer',array('eng_id' => $id));

		$data['cust_detail'] = $this->crud_model_db2->get_row('tbl_customer',array('cust_id' => $data['eng_detail']['cust_id']));
		

		echo json_encode($data);
	}

	/*
    |
	|      Approval based on the email change the quote status in the  tooling table
	|
	*/

	function change_status_email($id,$value)
	{
		if($value =="1")
		{
			$data = array('quote_status' => "3" );
		}
		if($value == "0")
		{
			$data  = array('quote_status' => "2");
		}

		$this->crud_model->update('boss_tooling',$data,array('tooling_id' => $id));

		//load view thank you

		/*
		|    use beamon header here and footer for thank you page
		| 
		*/

        /*$data = get_tooling_email_data_csm($id);
        echo "<pre>";
        print_r($data);
        exit;*/
        $this->load->view('email_template/thankyou');

	}

        function send_email($quote_id="")
	{

                /*update the tooling to evaluation*/
                $where_tooling = array('quote_id' => $quote_id);
                $data_tooling = array('quote_status' => "2");
                $this->crud_model->update('boss_tooling',$data_tooling,$where_tooling);
                $this->crud_model->update('boss_quotes',$data_tooling,$where_tooling);


		$data = quote_email_data($quote_id);

		$message = $this->load->view('email_template/quote_email', $data, TRUE);
      
                $data['show_approval'] = "1";
		$message_pdf = $this->load->view('pdf_templates/quote_pdf', $data, TRUE);

	        //generate the PDF from the given html
		$this->m_pdf->pdf->WriteHTML($message_pdf);
				
	        //download it.
				
		$quote_name = $this->crud_model->get_one('quote_ref','boss_quotes',array('id'=> $quote_id));
		$file_name = "/".$quote_name.$this->config->item('quote_ref_alp')[$data['quote_detail']['quote_ref_sub']];


                $quote_subject = "Beam On Quote ".$data['quote_detail']['quote_ref'].$this->config->item('quote_ref_alp')[$data['quote_detail']['quote_ref_sub']]." - Evaluation";

		$path =APPPATH."quote_pdf".$file_name.".pdf";

	        //download it.
		$this->m_pdf->pdf->Output($path,'F');
		$this->beamon_email->send_mail($this->config->item('from_email'),$this->config->item('to_email'),$quote_subject,$message,'',$path);

                redirect('quotes/quote_status');

	}
}

