<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Tooling extends CI_Controller {

	public function __construct() {
        parent::__construct();
        if($this->session->userdata('usertype') != "user")
	{
	   redirect("Home");
	}
        $this->load->library('beamon_email');
        $this->load->library('m_pdf');
    }
	public function index($id=0)
	{
		/*
			Insert here in quote table
		*/
		
		//End of inserting in quote table

		$data['fixture_list'] = $this->crud_model->get('boss_master_fixture_list',array('fixture_type' => "0"));
                $data['fixture_list_std'] = $this->crud_model->get('boss_master_fixture_list',array('fixture_type' => "1"));
		$data['material_list'] = $this->crud_model->get('boss_master_tooling_material');
		$data['standard_timing'] = $this->crud_model->get('boss_master_tooling_timing',array('design_complex' => 'Standard'));
		$data['complex_timing'] = $this->crud_model->get('boss_master_tooling_timing',array('design_complex' => 'Complex'));
		$data['accessories_list'] = $this->crud_model->get('boss_master_accssories');
		$data['mark_up'] = $this->crud_model->get('boss_master_markup');
		$data['tooling_extra_material_inch'] = $this->crud_model->get('boss_master_extra_material');
		$data['quote_id'] = $id;
		$data['quote_detail_tooling'] = $this->crud_model->get('boss_quotes',array('id' => $id));
		$data['engineer_data'] = $this->crud_model_db2->get('tbl_engineer');

              

		$breadcrumb['data'] = "Create Tooling";
		$this->load->view('layouts/header',$breadcrumb);
		$this->load->view('tooling/add_tooling',$data);
		$this->load->view('layouts/footer');
	}

	public function add_tooling_std()
	{
		
		//update the quote details
		$quote_update_data = array(
								'engineer_id' => $this->input->post('engineer_id'),
								'email_id' => $this->input->post('primary_email'),
								'company_id' => $this->input->post('company'),
								'customer_id' => $this->input->post('customer'),
								'assy_no' => $this->input->post('assy_no'),
								'fab_ref' => $this->input->post('fab_no'),
								'tooling_ref' => $this->input->post('tooling_ref_no'),
								'ref_no' => $this->input->post('ref_no'),
								'email_id_cc' =>  $this->input->post('secondary_email')
								);
		$this->crud_model->update('boss_quotes',$quote_update_data,array('id' => $this->input->post('quote_id')));

		$get_std_quote = get_quote_std($_POST);
		$q_id = $this->input->post('quote_id');

		if($get_std_quote['std_total_after_pd'] < 0)
		{
			$this->session->set_flashdata('response',error_message('Total should not be negative'));
			redirect('tooling/index/'.$q_id);

		}
		// insert into tooling table
		$data_tooling = array(
							'quote_id' => $this->input->post('quote_id'),
							'premium_percentage' => $this->input->post('std_tooling_premium'),
							'discount_percentage' => $this->input->post('std_tooling_discount'),				
							'premium_cost' => $get_std_quote['std_tooling_premium'],
							'discount_cost' => $get_std_quote['std_tooling_discount'], 
							'tooling_cost_wop' => $get_std_quote['std_fixture_total'],
							'single_unit_cost' => $get_std_quote['single_unit_cost'],
							'tooling_cost_adp' => $get_std_quote['std_total_after_pd'],
							'tooling_unit' => $this->input->post('std_total_unit'),
							'status'	=> "1",
							'date_created' => Date('Y-m-d')
						);
		/*if($this->input->post('std_multiple_quote') != "")
		{
			if($this->input->post('std_multiple_quote') == "other")
			{
				$data_tooling['multiple_quote'] = $this->input->post('std_custom_quote_std');
			}
			else
			{
				$data_tooling['multiple_quote'] = $this->input->post('std_multiple_quote');
			}
			$data_tooling['multiple_quote_cost'] =  $get_std_quote['std_multiple_quote'];
		}
		else
		{
			$data_tooling['multiple_quote'] = "1";
			$data_tooling['multiple_quote_cost'] =  $get_std_quote['std_fixture_total'];
		}*/

        $multiple_quotes_value_post = 0;
        if(!empty($_POST['std_multiple_quote']))
        {
			foreach ($_POST['std_multiple_quote'] as $key => $value) {
				$multiple_quotes_value_post = $multiple_quotes_value_post + $value ;
			}
		}
		else
		{
			 $multiple_quotes_value_post = 1;
		}

		$data_tooling['multiple_quote_cost'] =  $get_std_quote['std_total_after_pd'];
		$data_tooling['multiple_quote'] = $multiple_quotes_value_post;

		$tooling_id = $this->crud_model->insert('boss_tooling',$data_tooling);

		/*insert into fixture table*/
		$data = $this->input->post('std_tooling_material_select');
		foreach($data as $key => $value)
		{
			$data_fixture = array(
								'quote_id' => $this->input->post('quote_id'),
								'tooling_id' => $tooling_id,
								'fixture_select_id' => $value,
								'fixture_select_amount' => $this->input->post('std_material_total_cost')[$key],
								'status' => "1",
								'date_created' => Date('Y-m-d')
							);
			$this->crud_model->insert('boss_fixture',$data_fixture);
		}
		//insert into fixture table
		//update quote status
		$this->crud_model->update('boss_quotes',array('status' => "1"),array('id' => $this->input->post('quote_id')));


		/*prepare email content here*/
				
                 //updte in the multiple quote table
		$multiple_quote_data = $get_std_quote['multiple_quote_ind_cost'];
                if(!empty($multiple_quote_data)){
		foreach($multiple_quote_data as $key => $value)
		{
			$data_multiple_quote = array(
								'quote_id' => $this->input->post('quote_id'),
								'tooling_id' => $tooling_id,
								'quote_value' => $key,
								'quote_cost' => $value,
								'date_created' => Date('Y-m-d')
							);
			if($key=="other")
			{
				$multiple_qty = explode('*',$value);

				$data_multiple_quote['other_quote'] = $multiple_qty[1]; 
			}
			$this->crud_model->insert('boss_multiple_quotes',$data_multiple_quote);
		}
                }

                /*update total tooling cost*/
		/*
			check tooling exist if exist calculate the cost and update
		*/
		$total_tooling_cost = 0;
		$get_tooling_cost = $this->crud_model->get('boss_tooling',array('quote_id' => $q_id));

		if(!empty($get_tooling_cost))
		{
			foreach ($get_tooling_cost as $key => $value) {
				$total_tooling_cost = $total_tooling_cost + $value['tooling_cost_wop'];
			}
			//update in quote table
			$this->crud_model->update('boss_quotes',array('tooling_cost' => $total_tooling_cost),array('id' => $this->input->post('quote_id')));
		}

		/*send email and update quote status*/
		if($this->input->post('tooling_status') == "tooling_update")
		{
			$update_quote_status = "1";
  		        $this->crud_model->update('boss_tooling',array('quote_status' => $update_quote_status),array('tooling_id' => $tooling_id));

		}
		if($this->input->post('tooling_status') == "tooling_send_evaluation")
		{
			$update_quote_status = "2";
		        $this->crud_model->update('boss_tooling',array('quote_status' => $update_quote_status),array('tooling_id' => $tooling_id));

			//email code here
                       //get email data
			$data = get_tooling_email_data($tooling_id);
			$message = $this->load->view('email_template/email_quote', $data, TRUE);
			
                        $data['show_approval'] = "1";
                        $message_pdf = $this->load->view('pdf_templates/pdf_quote', $data, TRUE);
	               //generate the PDF from the given html
	                 $this->m_pdf->pdf->WriteHTML($message_pdf);
	 
	               //download it.
	               
                        $quote_name = $this->crud_model->get_one('quote_ref','boss_quotes',array('id'=> $q_id));
                        $file_name = "/".$quote_name;


	 		$path =APPPATH."quote_pdf".$file_name.".pdf";

	               //download it.
	                $this->m_pdf->pdf->Output($path,'F');


			//email code
			$this->beamon_email->send_mail($this->config->item('from_email'),$this->config->item('to_email'),'New Quote',$message,'',$path);
		}
		if($this->input->post('tooling_status') == "tooling_send_final")
		{
			$update_quote_status = "3";
                        $this->crud_model->update('boss_tooling',array('quote_status' => $update_quote_status),array('tooling_id' => $tooling_id));

			//email code here
                       //get email data
			$data = get_tooling_email_data($tooling_id);
			$message = $this->load->view('email_template/email_quote', $data, TRUE);
			
                        $data['show_approval'] = "1";
                        $message_pdf = $this->load->view('pdf_templates/pdf_quote', $data, TRUE);
 //generate the PDF from the given html
	                 $this->m_pdf->pdf->WriteHTML($message_pdf);
	 
	               //download it.
	               
                       $quote_name = $this->crud_model->get_one('quote_ref','boss_quotes',array('id'=> $q_id));
                        $file_name = "/".$quote_name;
	 		$path =APPPATH."quote_pdf".$file_name.".pdf";

	               //download it.
	                $this->m_pdf->pdf->Output($path,'F');
			//email code
			$this->beamon_email->send_mail($this->config->item('from_email'),$this->config->item('to_email'),'New Quote',$message,'',$path);
		}

		
		//$this->beamon_email->send_mail('karthik.hbk24@gmail.com','karthik.hbk24@gmail.com','test','test');
		redirect('quotes/view_quotes/'.$q_id);


	}


	public function view_tooling_std_action($id)
	{
/*validation here*/
		  $this->form_validation->set_rules('company', 'Company Name ', 'required');
          $this->form_validation->set_rules('customer', 'Customer Name ', 'required');
          $this->form_validation->set_rules('assy_no', 'Assembly number  ', 'required');
          $this->form_validation->set_rules('primary_email', 'Email', 'required');

          $this->form_validation->set_message('company', 'The {field} is Required');
          $this->form_validation->set_message('customer', 'The {field} is Required');
          $this->form_validation->set_message('assy_no', 'The {field} is Required');
          $this->form_validation->set_message('primary_email', 'The {field} is Required');

         if ($this->form_validation->run() == FALSE)
	 {
		$this->view_tooling($id);
	}
	else
	{

		$quote_update_data = array(
								'engineer_id' => $this->input->post('engineer_id'),
								'email_id' => $this->input->post('primary_email'),
								'company_id' => $this->input->post('company'),
								'customer_id' => $this->input->post('customer'),
								'assy_no' => $this->input->post('assy_no'),
								'fab_ref' => $this->input->post('fab_no'),
								'tooling_ref' => $this->input->post('tooling_ref_no'),
								'ref_no' => $this->input->post('ref_no'),
								'email_id_cc' =>  $this->input->post('secondary_email')
								);

		
		$this->crud_model->update('boss_quotes',$quote_update_data,array('id' => $this->input->post('quote_id')));

		$get_std_quote = get_quote_std($_POST);
		//fetch from tooling table 
		$where = array('tooling_id' => $id);
		$total_tooling_value_existing = $this->crud_model->get_row('boss_tooling',$where);
             
                $multiple_quotes_value_post=0;

        if(!empty($_POST['std_multiple_quote']))
        {
			foreach ($_POST['std_multiple_quote'] as $key => $value) {
				$multiple_quotes_value_post = $multiple_quotes_value_post + $value ;
			}
		}
		else
		{
			 $multiple_quotes_value_post=1;
		}


		if($total_tooling_value_existing['tooling_cost_wop'] != $get_std_quote['std_fixture_total'] || $total_tooling_value_existing['tooling_cost_adp'] != $get_std_quote['std_total_after_pd'] ||  $total_tooling_value_existing['multiple_quote'] != $multiple_quotes_value_post )
		{
				$quote_detail1 = $this->crud_model->get_row('boss_quotes',array('id' => $this->input->post('quote_id') ));
				/*Insert into quote table*/
				/*get the quote reference order by date created*/
				$quote_detail = $this->crud_model->get('boss_quotes',array('quote_ref'=>$quote_detail1['quote_ref'],'status' => "1"),'1','','id','DESC');


				/*need to update*/
				if($quote_detail[0]['quote_ref_sub'] == "")
				{
					$key = 0;
				}
				else
				{
					$key = $quote_detail[0]['quote_ref_sub'] + 1;
				}
				$quote_ref = $this->config->item('quote_ref_alp')[$key]; 
				 

					$quote_data = array(
						'quote_ref' => $quote_detail[0]['quote_ref'],
						'engineer_id' => $quote_detail[0]['engineer_id'],
						'email_id' => $quote_detail[0]['email_id'],
						'email_id_cc' => $quote_detail[0]['email_id_cc'],
						'company_id' => $quote_detail[0]['company_id'],
						'customer_id' => $quote_detail[0]['customer_id'],
						'assy_no' => $quote_detail[0]['assy_no'],
						'fab_ref' => $quote_detail[0]['fab_ref'],
						'tooling_ref' => $quote_detail[0]['tooling_ref'],
						'ref_no' => $quote_detail[0]['ref_no'],
						'date_created' => Date('Y-m-d'),
						'tooling_exist' => $quote_detail[0]['tooling_exist'],
						'quote_status' 	=>$quote_detail[0]['quote_status'],
						'quote_type'	=> $quote_detail[0]['quote_type'],
						'quote_ref_sub' => $key,
						'tooling_cont'	=> "1",
						'status'	=> "1"
					  );

				$quote_id = $this->crud_model->insert('boss_quotes',$quote_data);


				/*check whether multiple tooling exist*/

				//todo
				/*
					get the tooling based on the quote id
					insert it in the tooling table

				*/
				$pre_quote_id = $quote_detail1['id'];
				$pre_tooling_data = $this->crud_model->get('boss_tooling',array('quote_id' => $pre_quote_id));
				$pre_fixture_data = $this->crud_model->get('boss_fixture',array('tooling_id'=> $id));


				foreach($pre_tooling_data as $key => $value)
				{
					
					if($value['tooling_id'] != $id)
					{
						

						//insert into tooling table
						//insert into fixture table with same data
						$pre_data = array(
						    'quote_id' => $quote_id,
						    'tooling_type' => $value['tooling_type'],
						    'fixture_type' => $value['fixture_type'],
						    'tooling_description' => $value['tooling_description'],
						    'tooling_unit'	=> $value['tooling_unit'],
						    'tooling_cost_wop' => $value['tooling_cost_wop'],
						    'premium_percentage' => $value['premium_percentage'],
						    'discount_percentage' => $value['discount_percentage'],
						    'premium_cost' => $value['premium_cost'],
						    'discount_cost' => $value['discount_cost'],
						    'tooling_cost_adp' => $value['tooling_cost_adp'],
						    'multiple_quote' => $value['multiple_quote'],
						    'multiple_quote_cost' => $value['multiple_quote_cost'],
						    'quote_status' => $value['quote_status'],
						    'date_created' => date('Y-m-d'),
						    'status' => $value['status']
						    );

						$tooling_id_f = $this->crud_model->insert('boss_tooling',$pre_data);

						//get the fixture details and update here
						foreach($pre_fixture_data as $key_f => $value_f)
						{
							//insert into fixture table
							$pre_data_f = array(
								    'quote_id' => $quote_id,
								    'tooling_id' => $tooling_id_f,
								    'fixture_select_id' => $value_f['fixture_select_id'],
								    'fixture_select_amount' => $value_f['fixture_select_amount'],
								    'status' => $value_f['status'],
								    'date_created' => date('Y-m-d')
								);

							$this->crud_model->insert('boss_fixture',$pre_data_f);
						}
					}
				}				
				// insert into tooling table
				$data_tooling = array(
									'quote_id' => $quote_id,
									'premium_percentage' => $this->input->post('std_tooling_premium'),
									'discount_percentage' => $this->input->post('std_tooling_discount'),
									'tooling_unit' => $this->input->post('std_total_unit'),
									'premium_cost' => $get_std_quote['std_tooling_premium'],
									'discount_cost' => $get_std_quote['std_tooling_discount'],
									'single_unit_cost' => $get_std_quote['single_unit_cost'], 
									'tooling_cost_wop' => $get_std_quote['std_fixture_total'],
									'tooling_cost_adp' => $get_std_quote['std_total_after_pd'],
									'multiple_quote_cost' =>  $get_std_quote['std_multiple_quote'],
									'date_created' => Date('Y-m-d')
								);
				/*if($this->input->post('std_multiple_quote') != "")
				{
					if($this->input->post('std_multiple_quote') == "other")
					{
						$data_tooling['multiple_quote'] = $this->input->post('std_custom_quote_std');
					}
					else
					{
						$data_tooling['multiple_quote'] = $this->input->post('std_multiple_quote');
					}
					$data_tooling['multiple_quote_cost'] =  $get_std_quote['std_multiple_quote'];
				}
				else
				{
					$data_tooling['multiple_quote'] = "1";
					$data_tooling['multiple_quote_cost'] =  $get_std_quote['std_fixture_total'];
				}*/
               
             	$data_tooling['multiple_quote_cost'] =  $get_std_quote['std_total_after_pd'];
				$data_tooling['multiple_quote'] = $multiple_quotes_value_post;


				$tooling_id = $this->crud_model->insert('boss_tooling',$data_tooling);

				/*insert into fixture table*/
				$data = $this->input->post('std_tooling_material_select');
				foreach($data as $key => $value)
				{
					$data_fixture = array(
										'quote_id' => $quote_id,
										'tooling_id' => $tooling_id,
										'fixture_select_id' => $value,
										'fixture_select_amount' => $this->input->post('std_material_total_cost')[$key],
										'status' => "1",
										'date_created' => Date('Y-m-d')
									);
					$this->crud_model->insert('boss_fixture',$data_fixture);
				}
				//insert into fixture table
                                

                                //updte in the multiple quote table
				$multiple_quote_data = $get_std_quote['multiple_quote_ind_cost'];
                if(!empty($multiple_quote_data)){
				foreach($multiple_quote_data as $key => $value)
				{
					$data_multiple_quote = array(
										'quote_id' => $this->input->post('quote_id'),
										'tooling_id' => $tooling_id,
										'quote_value' => $key,
										'quote_cost' => $value,
										'date_created' => Date('Y-m-d')
									);
					if($key=="other")
					{
						$multiple_qty = explode('*',$value);

						$data_multiple_quote['other_quote'] = $multiple_qty[1]; 
					}
					$this->crud_model->insert('boss_multiple_quotes',$data_multiple_quote);
				}
                }

                                        /*update total tooling cost*/
					/*
						check tooling exist if exist calculate the cost and update
					*/
					$total_tooling_cost = 0;
					$get_tooling_cost = $this->crud_model->get('boss_tooling',array('quote_id' =>  $quote_id));

					if(!empty($get_tooling_cost))
					{
						foreach ($get_tooling_cost as $key => $value) {
							$total_tooling_cost = $total_tooling_cost + $value['tooling_cost_wop'];
						}
						//update in quote table
						$this->crud_model->update('boss_quotes',array('tooling_cost' => $total_tooling_cost),array('id' =>  $quote_id));
					}
				/*update quote status*/
				if($this->input->post('tooling_status') == "tooling_update")
				{
					$update_quote_status = "1";
                                        $this->crud_model->update('boss_tooling',array('quote_status' => $update_quote_status),array('tooling_id' => $tooling_id));

				}
				if($this->input->post('tooling_status') == "tooling_send_evaluation")
				{
					$update_quote_status = "2";
                                        $this->crud_model->update('boss_tooling',array('quote_status' => $update_quote_status),array('tooling_id' => $tooling_id));

					//email code here
                                        $data = get_tooling_email_data($tooling_id);
					$message = $this->load->view('email_template/email_quote', $data, TRUE);
					
                                        $data['show_approval'] = "1";
                                        $message_pdf = $this->load->view('pdf_templates/pdf_quote', $data, TRUE);
                                         //generate the PDF from the given html
	                                    $this->m_pdf->pdf->WriteHTML($message_pdf);
	 
	                                 //download it.
	                               
	 		                $file_name  = "/".$quote_detail[0]['quote_ref'].$quote_ref;
	 		                $path =APPPATH."quote_pdf".$file_name.".pdf";

	                                
	                                $this->m_pdf->pdf->Output($path,'F');
					//email code
					$this->beamon_email->send_mail($this->config->item('from_email'),$this->config->item('to_email'),'New Quote',$message,'',$path);
				}
				if($this->input->post('tooling_status') == "tooling_send_final")
				{
					$update_quote_status = "3";
                                        $this->crud_model->update('boss_tooling',array('quote_status' => $update_quote_status),array('tooling_id' => $tooling_id));

					//email code here
                                        $data = get_tooling_email_data($tooling_id);
					$message = $this->load->view('email_template/email_quote', $data, TRUE);

                                        $data['show_approval'] = "1";
                                        $message_pdf = $this->load->view('pdf_templates/pdf_quote', $data, TRUE);
					//generate the PDF from the given html
	                                    $this->m_pdf->pdf->WriteHTML($message_pdf);
	 
	                                 //download it.
	               
	 		                $file_name  = "/".$quote_detail[0]['quote_ref'].$quote_ref;
	 		                $path =APPPATH."quote_pdf".$file_name.".pdf";

	                                
	                                $this->m_pdf->pdf->Output($path,'F');
					//email code
					$this->beamon_email->send_mail($this->config->item('from_email'),$this->config->item('to_email'),'New Quote',$message,'');
				}
				
				redirect('quotes/quote_status');
		}
		else
		{
			if($this->input->post('tooling_status') == "tooling_update")
			{
				$update_quote_status = "1";
                                $this->crud_model->update('boss_tooling',array('quote_status' => $update_quote_status),array('tooling_id' => $id));
			}
			if($this->input->post('tooling_status') == "tooling_send_evaluation")
			{
				$update_quote_status = "2";
                                $this->crud_model->update('boss_tooling',array('quote_status' => $update_quote_status),array('tooling_id' => $id));
				//email code here
                                //get email data
				$data = get_tooling_email_data($id);
				$message = $this->load->view('email_template/email_quote', $data, TRUE);
				
                                $data['show_approval'] = "1";
                                $message_pdf = $this->load->view('pdf_templates/pdf_quote', $data, TRUE);
                               //generate the PDF from the given html
	                        $this->m_pdf->pdf->WriteHTML($message_pdf);
	 
	                       //download it.
	                       $quote_name = $this->crud_model->get_one('quote_ref','boss_quotes',array('id' => $this->input->post('quote_id')));
                               $quote_sub_ref = $this->crud_model->get_one('quote_ref_sub','boss_quotes',array('id' => $this->input->post('quote_id')));
	 		       $file_name  = "/".$quote_name.$this->config->item('quote_ref_alp')[$quote_sub_ref];
	 		       $path =APPPATH."quote_pdf".$file_name.".pdf";

	                     
	                       $this->m_pdf->pdf->Output($path,'F');
				//email code
				$this->beamon_email->send_mail($this->config->item('from_email'),$this->config->item('to_email'),'New Quote',$message,'',$path);
			}
			if($this->input->post('tooling_status') == "tooling_send_final")
			{
				$update_quote_status = "3";
                                $this->crud_model->update('boss_tooling',array('quote_status' => $update_quote_status),array('tooling_id' => $id));
				//email code here

                                //get email data
				$data = get_tooling_email_data($id);
				$message = $this->load->view('email_template/email_quote', $data, TRUE);
				
                               $data['show_approval'] = "1";
                               $message_pdf = $this->load->view('pdf_templates/pdf_quote', $data, TRUE);
                               //generate the PDF from the given html
 	                       $this->m_pdf->pdf->WriteHTML($message_pdf);
	 
	                       //download it.
	                       $quote_name = $this->crud_model->get_one('quote_ref','boss_quotes',array('id' => $this->input->post('quote_id')));
                               $quote_sub_ref = $this->crud_model->get_one('quote_ref_sub','boss_quotes',array('id' => $this->input->post('quote_id')));

	 		       $file_name  = "/".$quote_name.$this->config->item('quote_ref_alp')[$quote_sub_ref];
	 		       $path =APPPATH."quote_pdf".$file_name.".pdf";

	              
	                       $this->m_pdf->pdf->Output($path,'F');
				//email code
				$this->beamon_email->send_mail($this->config->item('from_email'),$this->config->item('to_email'),'New Quote',$message,'',$path);
			}
			
				
			redirect('quotes/quote_status');
		}
            }
	}

		
	public function add_tooling()
	{
   
		$quote_update_data = array(
								'engineer_id' => $this->input->post('engineer_id'),
								'email_id' => $this->input->post('primary_email'),
								'company_id' => $this->input->post('company'),
								'customer_id' => $this->input->post('customer'),
								'assy_no' => $this->input->post('assy_no'),
								'fab_ref' => $this->input->post('fab_no'),
								'tooling_ref' => $this->input->post('tooling_ref_no'),
								'ref_no' => $this->input->post('ref_no'),
								'email_id_cc' =>  $this->input->post('secondary_email')
								);
		$this->crud_model->update('boss_quotes',$quote_update_data,array('id' => $this->input->post('quote_id')));

		$get_total_cost = material_calculation($_POST);

		$q_id = $this->input->post('quote_id');

		//insert into tooling table
		//check multiple quote exist
		$tooling_data = array(
							'tooling_type' => $this->input->post('tooling_type'),
							'quote_id'	=> $this->input->post('quote_id'),
							'tooling_description' => $this->input->post('tooling_description'),
							'tooling_type' => $this->input->post('tooling_type'),
							'fixture_type' => $this->input->post('fixtue_type'),
							'tooling_unit' => $this->input->post('total_unit'),
							'tooling_cost_wop' => $get_total_cost['total_calculation_wop'],
							'single_unit_cost' => $get_total_cost['single_unit_cost'],
							'premium_percentage' => $this->input->post('tooling_premium'),
							'discount_percentage' => $this->input->post('tooling_discount'),
							'premium_cost'	=> $get_total_cost['tooling_premium'],
							'discount_cost'	=> $get_total_cost['tooling_discount'],
							'tooling_cost_adp' => $get_total_cost['total_calculation_after_pd'],
							'date_created'	=> Date('Y-m-d'),
							'status'	=> "1"
						);

/*OLD CHANGED ON 26/09*/
		/*if(isset($_POST['multiple_quote']))
		{
			$tooling_data['multiple_quote'] =  $this->input->post('multiple_quote');
			$tooling_data['multiple_quote_cost'] =  $get_total_cost['round_off_mq'];
			$tooling_data['tooling_cost_wop'] = $get_total_cost['total_calculation_wop'];
		}
		else
		{
			$tooling_data['multiple_quote'] = "1";
			$tooling_data['tooling_cost_wop'] = $get_total_cost['total_calculation_wop'];
			$tooling_data['multiple_quote_cost'] =  $get_total_cost['round_off_mq'];

							
		}*/ /*END OF OLD*/
		/*if($this->input->post('multiple_quote') != "")
		{
			if($this->input->post('multiple_quote') == "other")
			{
				$tooling_data['multiple_quote'] = $this->input->post('custom_quote_std');
			}
			else
			{
				$tooling_data['multiple_quote'] = $this->input->post('multiple_quote');
			}
			$tooling_data['tooling_cost_wop'] = $get_total_cost['total_calculation_wop'];
			$tooling_data['multiple_quote_cost'] =  $get_total_cost['round_off_mq'];
		}
		else
		{
			$tooling_data['multiple_quote'] = "1";
			$tooling_data['tooling_cost_wop'] = $get_total_cost['total_calculation_wop'];
			$tooling_data['multiple_quote_cost'] =  $get_total_cost['round_off_mq'];
		}*/

		$multiple_quotes_value_post=0;

                if(!empty($_POST['multiple_quote']))
                {
		foreach ($_POST['multiple_quote'] as $key => $value) {
			$multiple_quotes_value_post = $multiple_quotes_value_post + $value ;
		}
                }
                else
                {
                        $multiple_quotes_value_post=1;
                }


		$tooling_data['multiple_quote_cost'] =  $get_total_cost['round_off_mq'];
		$tooling_data['multiple_quote'] = $multiple_quotes_value_post;
		$tooling_id = $this->crud_model->insert('boss_tooling',$tooling_data);

		//insert in tooling material
		$count = count($_POST['material_xvalue']);
		
		
		foreach($_POST['material_xvalue'] as $key => $value)
		{
			$tooling_material_data = array(
										'quote_id' => $this->input->post('quote_id'),
										'tooling_id' => $tooling_id,
										'material_id' => $this->input->post('tooling_material_select')[$key],
										'size_x'	=>  $this->input->post('material_xvalue')[$key],
										'size_y'	=>  $this->input->post('material_yvalue')[$key],
										'markup'	=> $this->input->post('markup'),
										'extra_material' => $this->input->post('extra_material'),
										'cost'	=> $get_total_cost['material_cost'][$key],
										'date_created'	=> Date('Y-m-d'),
										'status'		=> "1"
									 );
			$this->crud_model->insert('boss_tooling_material',$tooling_material_data);
		}


		//insert into time
		$tooling_time_data = array(
								'quote_id'=> $this->input->post('quote_id'),
								'tooling_id' => $tooling_id,
								'std_des_hr' => $this->input->post('std_design_hr'),
								'std_des_min' =>$this->input->post('std_design_min'),
								'cpx_des_hr' =>$this->input->post('cpx_design_hr'),
								'cpx_des_min' =>$this->input->post('cpx_design_min'),
								'std_mac_hr' =>$this->input->post('std_machine_hr'),
								'std_mac_min' =>$this->input->post('std_machine_min'),
								'cpx_mac_hr' =>$this->input->post('cpx_machine_hr'),
								'cpx_mac_min' =>$this->input->post('cpx_machine_min'),
								'std_ass_hr' =>$this->input->post('std_assembly_hr'),
								'std_ass_min' =>$this->input->post('std_assembly_min'),
								'cpx_ass_hr' =>$this->input->post('cpx_assembly_hr'),
								'cpx_ass_min' =>$this->input->post('cpx_assembly_min'),
								'total_design_cost' => $get_total_cost['total_design_cost'], 
								'total_machine_cost' => $get_total_cost['total_machine_cost'],
								'total_assembly_cost' => $get_total_cost['total_assembly_cost'],
								'date_created' => Date('Y-m-d'),
								'status' 	=> "1"
							);
		$this->crud_model->insert('boss_tooling_time',$tooling_time_data);

		/**/
		$tooling_time_extra = array(
								'quote_id'=> $this->input->post('quote_id'),
								'tooling_id' => $tooling_id,
								'other_time_cost' => $this->input->post('time_other_name'),
								'other_std_hr' => $this->input->post('std_other_hr'),
								'other_std_min' => $this->input->post('std_other_min'),
								'other_cpx_hr' => $this->input->post('cpx_other_hr'),
								'other_cpx_min' => $this->input->post('cpx_other_min'),
								'other_total_cost' => $get_total_cost['total_other_time_cost'],
								'status' => 1,
								'date_created' => Date('Y-m-d')
							  );
		$this->crud_model->insert('boss_timing_time_other',$tooling_time_extra);
		//End of extra time

		//insert extra material
		if(isset($_POST['tooling_material_other']))
		{
			$extra_material_count = count($_POST['tooling_material_other']);

			foreach ($_POST['tooling_material_other'] as $key => $value) 
			{
				$extra_material_data = array(
											'quote_id' => $this->input->post('quote_id'),
											'tooling_id' => $tooling_id,
											'material_name' => $this->input->post('tooling_material_other')[$key],
											'material_cost' => $this->input->post('tooling_material_other_value')[$key],
											'status' => "1",
											'date_created' => Date('Y-m-d')
										);
				$this->crud_model->insert('boss_tooling_extra',$extra_material_data);
			}
		}
		/*
			Insert into tooling accessories

			unit/hour want to check

			need to think
		*/
		$tooling_accessory_count = count($_POST['tooling_accessory_name']);
		for($ta=0 ; $ta < $tooling_accessory_count ; $ta++)
		{
			
				$tooling_accessories = array(
											'quote_id' => $this->input->post('quote_id'),
											'tooling_id' => $tooling_id,
											'accessory_id' => $this->input->post('tooling_accessory_name')[$ta],
											'acc_cost' => $this->input->post('extra_cost')[$ta],
											'acc_qty' => $this->input->post('extra_qty')[$ta],
											'acc_total_cost' => $get_total_cost['accessory_cost'][$ta],
											'status' => "1",
											'date_created' => Date('Y-m-d')
										);
				//insert query here
				$this->crud_model->insert('boss_tooling_accessory',$tooling_accessories);
		}

		/*Insert into accessory extra*/
		if(isset($_POST['tooling_accessory_extra_name']))
		{
			$tooling_extra_accessory_count = count($this->input->post('tooling_accessory_extra_name'));
		        foreach($_POST['tooling_accessory_extra_name'] as $key => $value)
			{
				$tooling_accessory_extra = array(
											'quote_id' => $this->input->post('quote_id'),
											'tooling_id' => $tooling_id,
											'extra_acc_name' => $this->input->post('tooling_accessory_extra_name')[$key],
											'extra_acc_price' => $this->input->post('extra_accessory_cost')[$key],
											'extra_acc_qty' => $this->input->post('extra_accessory_qty')[$key],
											'extra_acc_total' => $get_total_cost['accessory_extra_cost'][$key]

											);
					$this->crud_model->insert('boss_tooling_accessory_extra',$tooling_accessory_extra);

			}
		}
		/*Update quote table here**/
                 //updte in the multiple quote table
		$multiple_quote_data = $get_total_cost['multiple_quote_ind_cost'];
                if(!empty($multiple_quote_data)){
		foreach($multiple_quote_data as $key => $value)
		{
			$data_multiple_quote = array(
								'quote_id' => $this->input->post('quote_id'),
								'tooling_id' => $tooling_id,
								'quote_value' => $key,
								'quote_cost' => $value,
								'date_created' => Date('Y-m-d')
							);

			if($key=="other")
			{
				$multiple_qty = explode('*',$value);

				$data_multiple_quote['other_quote'] = $multiple_qty[1]; 
			}

			$this->crud_model->insert('boss_multiple_quotes',$data_multiple_quote);
		}
                }

		if($this->input->post('tooling_status') == "tooling_update")
		{
			$update_quote_status = "1";
		}
		if($this->input->post('tooling_status') == "tooling_send_evaluation")
		{
			$update_quote_status = "2";
                        $data = get_tooling_email_data_csm($tooling_id);
			$message = $this->load->view('email_template/email_quote_cstm', $data, TRUE);

                        $data['show_approval'] = "1";
                        $message_pdf = $this->load->view('pdf_templates/pdf_quote_cstm', $data, TRUE);
                         //generate the PDF from the given html
	                 $this->m_pdf->pdf->WriteHTML($message_pdf);
	 
	               //download it.
	                $quote_name = $this->crud_model->get_one('quote_ref','boss_quotes',array('id' => $q_id));
	 		$file_name  = "/".$quote_name;
	 		$path =APPPATH."quote_pdf".$file_name.".pdf";

	               //download it.
	                $this->m_pdf->pdf->Output($path,'F');
                       	$this->beamon_email->send_mail($this->config->item('from_email'),$this->config->item('to_email'),'New Quote',$message,'',$path);

		}
		if($this->input->post('tooling_status') == "tooling_send_final")
		{
			$update_quote_status = "3";
                        $data = get_tooling_email_data_csm($tooling_id);
			$message = $this->load->view('email_template/email_quote_cstm', $data, TRUE);
                     
                        $data['show_approval'] = "1";
                        $message_pdf = $this->load->view('pdf_templates/pdf_quote_cstm', $data, TRUE);

                        //generate the PDF from the given html
	                 $this->m_pdf->pdf->WriteHTML($message_pdf);
	 
	               //download it.
	                $quote_name = $this->crud_model->get_one('quote_ref','boss_quotes',array('id' => $q_id));

	 		$file_name  = "/".$quote_name;
	 		$path =APPPATH."quote_pdf".$file_name.".pdf";

	               //download it.
	                $this->m_pdf->pdf->Output($path,'F');
                	$this->beamon_email->send_mail($this->config->item('from_email'),$this->config->item('to_email'),'New Quote',$message,'',$path);

		}

		/*UPDATE IN TOOLING TABLE*/
		$this->crud_model->update('boss_tooling',array('quote_status'=>$update_quote_status),array('tooling_id' => $tooling_id));

		$this->crud_model->update('boss_quotes',array('quote_status'=>$update_quote_status,'tooling_cost'=>$get_total_cost['total_calculation_after_pd'],'status' => '1'),array('id'=>$this->input->post('quote_id')));
		//redirect('quotes/quote_status');
		redirect('quotes/view_quotes/'.$q_id);
	}

	/* function is used to view tooling**/

	public function view_tooling($tooling_id=0)
	{
		$where = array('tooling_id' => $tooling_id);
		/*get the all the record based on the tooling id*/
		$data['boss_tooling'] = $this->crud_model->get('boss_tooling',$where);
		$data['boss_tooling_accessory'] = $this->crud_model->get('boss_tooling_accessory',$where);
		$data['boss_tooling_accessory_extra'] = $this->crud_model->get('boss_tooling_accessory_extra',$where);
		$data['boss_tooling_extra'] = $this->crud_model->get('boss_tooling_extra',$where);
		$data['boss_tooling_material'] = $this->crud_model->get('boss_tooling_material',$where);
		$data['boss_tooling_time'] = $this->crud_model->get('boss_tooling_time',$where);
		$data['boss_timing_time_other'] = $this->crud_model->get('boss_timing_time_other',$where);
		$data['boss_tooling_material'] = $this->crud_model->get('boss_tooling_material',$where);
		/*Count the size of the dynamic selectors*/
		$data['material_count'] = $this->crud_model->get_count('boss_tooling_material',$where);
		$data['fixture_count'] = $this->crud_model->get_count('boss_fixture',$where);
		$data['extra_material_count'] = $this->crud_model->get_count('boss_tooling_extra',$where);
		$data['tooling_accessory_extra'] = $this->crud_model->get_count('boss_tooling_accessory_extra',$where);

		$data['boss_fixture'] = $this->crud_model->get('boss_fixture',$where);

		if(!empty($data['boss_fixture']))
		{
			foreach ($data['boss_fixture'] as $key => $value) {

				$data['boss_fixture'][$key]['fix_cost'] = $this->crud_model->get_one('fixture_cost','boss_master_fixture_list',array('id'=>$value['fixture_select_id']));
			}
		}


		/*Display db values*/
		$data['fixture_list'] = $this->crud_model->get('boss_master_fixture_list',array('fixture_type'=>0));
		$data['fixture_list_std'] = $this->crud_model->get('boss_master_fixture_list',array('fixture_type'=>1));
		$data['material_list'] = $this->crud_model->get('boss_master_tooling_material');
		$data['standard_timing'] = $this->crud_model->get('boss_master_tooling_timing',array('design_complex' => 'Standard'));
		$data['complex_timing'] = $this->crud_model->get('boss_master_tooling_timing',array('design_complex' => 'Complex'));
		$data['accessories_list'] = $this->crud_model->get('boss_master_accssories');
		$data['mark_up'] = $this->crud_model->get('boss_master_markup');
		$data['tooling_extra_material_inch'] = $this->crud_model->get('boss_master_extra_material');
		$data['quote_id'] = $data['boss_tooling'][0]['quote_id'];

		/*Quote details*/
		$data['quote_type'] = $this->crud_model->get_one('quote_type','boss_quotes',array('id'=>$data['quote_id']));
		/**/
		$data['quote_detail_tooling'] = $this->crud_model->get('boss_quotes',array('id' => $data['quote_id'] ));
		$data['engineer_data'] = $this->crud_model_db2->get('tbl_engineer');

              /*  $customer = array();
                foreach($data['engineer_details'] as $key => $value)
                {
                     $cust_ref = $this->crud_model->get_one('cust_ref','tbl_customer',array('cust_id' => $value['cust_id']));
                     $customer[$key] = $value;
                     $customer[$key]['cust_ref'] = $cust_ref;
                }
                $data['engineer_data'] = $customer;*/

                /*Display multiple quote value*/
		$data['multiple_quote_data'] = $this->crud_model->get('boss_multiple_quotes',$where);

		$data['multiple_quote_value'] = array();
		if(!empty($data['multiple_quote_data'])){
		foreach ($data['multiple_quote_data'] as $key => $value) {
			if($value['quote_value'] == "other")
			{
			 	$data['multiple_quote_value'][$value['quote_value']] = $value['quote_cost']."*".$value['other_quote'];
			}
			else
			{
				$data['multiple_quote_value'][$value['quote_value']] = $value['quote_cost'];
			}
		}
		}


		/*echo "<pre>";
		print_r($data);
		exit;*/
		$breadcrumb['data'] = "Edit Tooling";
		$this->load->view('layouts/header',$breadcrumb);
		$this->load->view('tooling/edit_tooling',$data);
		$this->load->view('layouts/footer');

	}

	public function view_tooling_action($id=0)
	{
/*validation here*/
		  $this->form_validation->set_rules('company', 'Company Name ', 'required');
          $this->form_validation->set_rules('customer', 'Customer Name ', 'required');
          $this->form_validation->set_rules('assy_no', 'Assembly number  ', 'required');
          $this->form_validation->set_rules('primary_email', 'Email', 'required');

          $this->form_validation->set_message('company', 'The {field} is Required');
          $this->form_validation->set_message('customer', 'The {field} is Required');
          $this->form_validation->set_message('assy_no', 'The {field} is Required');
          $this->form_validation->set_message('primary_email', 'The {field} is Required');

        if ($this->form_validation->run() == FALSE)
	{
		$this->view_tooling($id);
	}
	else
	{
		$get_total_cost = material_calculation($_POST);

		$quote_update_data = array(
								'engineer_id' => $this->input->post('engineer_id'),
								'email_id' => $this->input->post('primary_email'),
								'company_id' => $this->input->post('company'),
								'customer_id' => $this->input->post('customer'),
								'assy_no' => $this->input->post('assy_no'),
								'fab_ref' => $this->input->post('fab_no'),
								'tooling_ref' => $this->input->post('tooling_ref_no'),
								'ref_no' => $this->input->post('ref_no'),
								'email_id_cc' =>  $this->input->post('secondary_email')
								);
		$this->crud_model->update('boss_quotes',$quote_update_data,array('id' => $this->input->post('quote_id')));

		$get_total_cost = material_calculation($_POST);
		$where = array('tooling_id' => $id);
		$total_tooling_value_existing = $this->crud_model->get_row('boss_tooling',$where);

		
   		$multiple_quotes_value_post=0;

                if(!empty($_POST['multiple_quote']))
                {
		foreach ($_POST['multiple_quote'] as $key => $value) {
			$multiple_quotes_value_post = $multiple_quotes_value_post + $value ;
		}
                }
                else
                {
                     $multiple_quotes_value_post=1;
                }


		/*check the values are same or different*/
		if($total_tooling_value_existing['tooling_cost_wop'] != $get_total_cost['total_calculation_wop'] || $total_tooling_value_existing['tooling_cost_adp'] != $get_total_cost['total_calculation_after_pd'] || $total_tooling_value_existing['multiple_quote_cost'] != $get_total_cost['round_off_mq'] || $total_tooling_value_existing['multiple_quote'] != $multiple_quotes_value_post)
		{
				/*create a new quotes based on the parent quote reference*/
				$quote_detail1 = $this->crud_model->get_row('boss_quotes',array('id' => $this->input->post('quote_id') ));
				/*Insert into quote table*/
				/*get the quote reference order by date created*/
				$quote_detail = $this->crud_model->get('boss_quotes',array('quote_ref'=>$quote_detail1['quote_ref'],'status' => "1"),'1','','id','DESC');

				/*need to update*/
				if($quote_detail[0]['quote_ref_sub'] == "")
				{
					$key = 0;
				}
				else
				{
					$key = $quote_detail[0]['quote_ref_sub'] + 1;
				}
				$quote_ref = $this->config->item('quote_ref_alp')[$key]; 



				$quote_data = array(
						'quote_ref' => $quote_detail[0]['quote_ref'],
						'engineer_id' =>$quote_detail[0]['engineer_id'],
						'email_id' =>$quote_detail[0]['email_id'],
						'email_id_cc' =>$quote_detail[0]['email_id_cc'] ,
						'assy_no' => $quote_detail[0]['assy_no'],
						'fab_ref' => $quote_detail[0]['fab_ref'],
						'tooling_ref' => $quote_detail[0]['tooling_ref'],
						'ref_no' => $quote_detail[0]['ref_no'],
						'company_id' =>$quote_detail[0]['company_id'],
						'customer_id' =>$quote_detail[0]['customer_id'],
						'date_created' =>date('Y-m-d'),
						'tooling_exist' =>$quote_detail[0]['tooling_exist'],
						'quote_status' 	=>$quote_detail[0]['quote_status'],
						'quote_type'	=> $quote_detail[0]['quote_type'],
						'quote_ref_sub' => $key,
						'tooling_cont'	=> "1",
						'status'	=> "1"
					  );

				$quote_id = $this->crud_model->insert('boss_quotes',$quote_data);

				/*Code for existing data*/

				$pre_quote_id = $quote_detail1['id'];
				$pre_tooling_data = $this->crud_model->get('boss_tooling',array('quote_id' => $pre_quote_id));
				$pre_tooling_accessory = $this->crud_model->get('boss_tooling_accessory',array('quote_id' => $pre_quote_id));
				$pre_tooling_accessory_extra = $this->crud_model->get('boss_tooling_accessory_extra',array('quote_id' => $pre_quote_id));
				$pre_tooling_extra = $this->crud_model->get('boss_tooling_extra',array('quote_id' => $pre_quote_id));
				$pre_tooling_material = $this->crud_model->get('boss_tooling_material',array('quote_id' => $pre_quote_id));
				$pre_tooling_time = $this->crud_model->get('boss_tooling_time',array('quote_id' => $pre_quote_id));


	/*			echo "<pre>";
				echo "tooling main";
				print_r($pre_tooling_data);
				echo "tooling accessory";
				print_r($pre_tooling_accessory);
				echo "tooling acc extra";
				print_r($pre_tooling_accessory_extra);
				echo "tooling extra";
				print_r($pre_tooling_extra);
				echo "tooling material";
				print_r($pre_tooling_material);
				echo "tooling time";
				print_r($pre_tooling_time);
				exit;*/

				foreach($pre_tooling_data as $key => $value)
				{
					
					if($value['tooling_id'] != $id)
					{
						//insert into tooling table
						$data_tooling = array(

									'quote_id' => $quote_id,
									'tooling_type' => $value['tooling_type'],
									'fixture_type' => $value['fixture_type'],
									'tooling_description' => $value['tooling_description'],
									'tooling_unit'	=> $value['tooling_unit'],
									'tooling_cost_wop' => $value['tooling_cost_wop'],
									'premium_percentage' => $value['premium_percentage'],
									'discount_percentage' => $value['discount_percentage'],
									'premium_cost' => $value['premium_cost'],
									'discount_cost' => $value['discount_cost'],
									'tooling_cost_adp' => $value['tooling_cost_adp'],
									'multiple_quote' => $value['multiple_quote'],
									'multiple_quote_cost' => $value['multiple_quote_cost'],
									'quote_status' => $value['quote_status'],
									'date_created' => date('Y-m-d'),
									'status' => $value['status'],
								);

						//insert into tooling 
						$exist_tooling_id = $this->crud_model->insert('boss_tooling',$data_tooling);

						if(!empty($pre_tooling_accessory))
						{
							foreach ($pre_tooling_accessory as $key => $exist_tooling_accessory) 
							{
								if($exist_tooling_accessory['tooling_id'] != $id)
								{
									$data_tooling_accessory = array(
												'quote_id' => $quote_id,
												'tooling_id' => $exist_tooling_id,
												'accessory_id' => $exist_tooling_accessory['accessory_id'],
												'acc_cost' => $exist_tooling_accessory['acc_cost'],
												'acc_qty' => $exist_tooling_accessory['acc_qty'],
												'acc_total_cost' => $exist_tooling_accessory['acc_total_cost'],
												'status' => $exist_tooling_accessory['status'],
												'date_created' => date('Y-m-d')
											);
									//insert into tooling accessory
									$this->crud_model->insert('boss_tooling_accessory',$data_tooling_accessory);

								}
							}
						}

						//insert into  boss_tooling_material
						if(!empty($pre_tooling_material))
						{
							foreach ($pre_tooling_material as $key => $exist_tooling_material)
							{
								if($exist_tooling_material['tooling_id'] != $id)
								{
									$data_tooling_material = array(
										'quote_id' => $quote_id,
										'tooling_id' => $exist_tooling_id,
										'material_id' => $exist_tooling_material['material_id'],
										'size_x' => $exist_tooling_material['size_x'],
										'size_y' => $exist_tooling_material['size_y'],
										'markup' => $exist_tooling_material['markup'],
										'extra_material' => $exist_tooling_material['extra_material'],
										'cost' => $exist_tooling_material['cost'],
										'date_created' => date('Y-m-d'),
										'status' => $exist_tooling_material['status'],
									);
									//insert into tooling material
									$this->crud_model->insert('boss_tooling_material',$data_tooling_material);

								}
							}
						}

						//insert into  boss_tooling_accessory_extra
						if(!empty($pre_tooling_accessory_extra))
						{
							foreach ($pre_tooling_accessory_extra as $key => $exist_tooling_accessory_extra)
							{
								if($exist_tooling_accessory_extra['tooling_id'] != $id)
								{
									$data_tooling_accessory_extra = array(
										'quote_id' => $quote_id,
										'tooling_id' => $exist_tooling_id,
										'extra_acc_name' => $exist_tooling_accessory_extra['extra_acc_name'],
										'extra_acc_price' => $exist_tooling_accessory_extra['extra_acc_price'],
										'extra_acc_qty' => $exist_tooling_accessory_extra['extra_acc_qty'],
										'extra_acc_total' => $exist_tooling_accessory_extra['extra_acc_total']
										);
									//insert into  boss_tooling_accessory_extra
									$this->crud_model->insert('boss_tooling_accessory_extra',$data_tooling_accessory_extra);
								}
							}
						}
						//insert into tooling extra
						if(!empty($pre_tooling_extra))
						{
							foreach ($pre_tooling_extra as $key => $exist_tooling_extra) 
							{
								if($exist_tooling_extra['tooling_id'] != $id)
								{
									$data_tooling_extra = array(
										'quote_id' => $quote_id,
										'tooling_id' => $exist_tooling_id,
										'material_name' => $exist_tooling_extra['material_name'],
										'material_cost' => $exist_tooling_extra['material_cost'],
										'status' => $exist_tooling_extra['status'],
										'date_created' => date('Y-m-d')
									);
									//insert into tooling extra
									$this->crud_model->insert('boss_tooling_extra',$data_tooling_extra);
								}
							}
						}

						//insert into tooling time
						if(!empty($pre_tooling_time))
						{
							foreach ($pre_tooling_time as $key => $exist_tooling_time)
							{
								if($exist_tooling_time['tooling_id'] != $id)
								{
									$data_time = array(
										'tooling_id' => $exist_tooling_id,
										'quote_id' => $quote_id,
										'std_des_hr' => $exist_tooling_time['std_des_hr'],
										'std_des_min' => $exist_tooling_time['std_des_min'],
										'cpx_des_hr' => $exist_tooling_time['cpx_des_hr'],
										'cpx_des_min' => $exist_tooling_time['cpx_des_min'],
										'std_ass_hr' => $exist_tooling_time['std_ass_hr'],
										'std_ass_min' => $exist_tooling_time['std_ass_min'],
										'cpx_ass_hr' => $exist_tooling_time['cpx_ass_hr'],
										'cpx_ass_min' => $exist_tooling_time['cpx_ass_min'],
										'std_mac_hr' => $exist_tooling_time['std_mac_hr'],
										'std_mac_min' => $exist_tooling_time['std_mac_min'],
										'cpx_mac_hr' => $exist_tooling_time['cpx_mac_hr'],
										'cpx_mac_min' => $exist_tooling_time['cpx_mac_min'],
										'total_design_cost' => $exist_tooling_time['total_design_cost'],
										'total_machine_cost' => $exist_tooling_time['total_machine_cost'],
										'total_assembly_cost' => $exist_tooling_time['total_assembly_cost'],
										'date_created' => date('Y-m-d'),
										'status' => $exist_tooling_time['status']

									);
									//insert into time
									$this->crud_model->insert('boss_tooling_time',$data_time);
								}
							}
						}
					}
				}



				/*End of code*/

				/*End of quote insertion*/

				$tooling_data = array(
							'tooling_type' => $this->input->post('tooling_type'),
							'quote_id'	=> $quote_id,
							'tooling_description' => $this->input->post('tooling_description'),
							'tooling_type' => $this->input->post('tooling_type'),
							'fixture_type' => $this->input->post('fixture_type'),
							'tooling_unit' => $this->input->post('total_unit'),
                            'tooling_cost_wop' => $get_total_cost['total_calculation_wop'],
							//'multiple_quote' => $multiple_quote,
							'single_unit_cost' => $get_total_cost['single_unit_cost'],
							'premium_percentage' => $this->input->post('tooling_premium'),
							'discount_percentage' => $this->input->post('tooling_discount'),
							'premium_cost'	=> $get_total_cost['tooling_premium'],
							'discount_cost'	=> $get_total_cost['tooling_discount'],
							'tooling_cost_adp' => $get_total_cost['total_calculation_after_pd'],
							'date_created'	=> Date('Y-m-d'),
							'status'	=> "1"
						);
				/*	if(isset($_POST['multiple_quote']))
					{
						$tooling_data['multiple_quote'] =  $this->input->post('multiple_quote');
						$tooling_data['multiple_quote_cost'] =  $get_total_cost['round_off_mq'];
						$tooling_data['tooling_cost_wop'] = $get_total_cost['total_calculation_wop'];
					}
					else
					{
						$tooling_data['multiple_quote'] = "1";
						$tooling_data['tooling_cost_wop'] = $get_total_cost['total_calculation_wop'];
						$tooling_data['multiple_quote_cost'] =  $get_total_cost['round_off_mq'];

										
					}*/
                    $tooling_data['multiple_quote_cost'] =  $get_total_cost['round_off_mq'];
                    $tooling_data['multiple_quote'] = $multiple_quotes_value_post;

					$tooling_id = $this->crud_model->insert('boss_tooling',$tooling_data);

					//insert in tooling material
					$count = count($_POST['material_xvalue']);				
					foreach($_POST['material_xvalue'] as $key => $value)
					{
						$tooling_material_data = array(
													'quote_id' => $quote_id,
													'tooling_id' => $tooling_id,
													'material_id' => $this->input->post('tooling_material_select')[$key],
													'size_x'	=>  $this->input->post('material_xvalue')[$key],
													'size_y'	=>  $this->input->post('material_yvalue')[$key],
													'markup'	=> $this->input->post('markup'),
													'extra_material' => $this->input->post('extra_material'),
													'cost'	=> $get_total_cost['material_cost'][$key],
													'date_created'	=> Date('Y-m-d'),
													'status'		=> "1"
												 );
						$this->crud_model->insert('boss_tooling_material',$tooling_material_data);
					}
					//insert into time
					$tooling_time_data = array(
											'quote_id'=> $quote_id,
											'tooling_id' => $tooling_id,
											'std_des_hr' => $this->input->post('std_design_hr'),
											'std_des_min' =>$this->input->post('std_design_min'),
											'cpx_des_hr' =>$this->input->post('cpx_design_hr'),
											'cpx_des_min' =>$this->input->post('cpx_design_min'),
											'std_mac_hr' =>$this->input->post('std_machine_hr'),
											'std_mac_min' =>$this->input->post('std_machine_min'),
											'cpx_mac_hr' =>$this->input->post('cpx_machine_hr'),
											'cpx_mac_min' =>$this->input->post('cpx_machine_min'),
											'std_ass_hr' =>$this->input->post('std_assembly_hr'),
											'std_ass_min' =>$this->input->post('std_assembly_min'),
											'cpx_ass_hr' =>$this->input->post('cpx_assembly_hr'),
											'cpx_ass_min' =>$this->input->post('cpx_assembly_min'),
											'total_design_cost' => $get_total_cost['total_design_cost'], 
											'total_machine_cost' => $get_total_cost['total_machine_cost'],
											'total_assembly_cost' => $get_total_cost['total_assembly_cost'],
											'date_created' => Date('Y-m-d'),
											'status' 	=> "1"
										);
					$this->crud_model->insert('boss_tooling_time',$tooling_time_data);

					/**/
					$tooling_time_extra = array(
											'quote_id'=> $quote_id,
											'tooling_id' => $tooling_id,
											'other_time_cost' => $this->input->post('time_other_name'),
											'other_std_hr' => $this->input->post('std_other_hr'),
											'other_std_min' => $this->input->post('std_other_min'),
											'other_cpx_hr' => $this->input->post('cpx_other_hr'),
											'other_cpx_min' => $this->input->post('cpx_other_min'),
											'other_total_cost' => $get_total_cost['total_other_time_cost'],
											'status' => 1,
											'date_created' => Date('Y-m-d')
										  );
					$this->crud_model->insert('boss_timing_time_other',$tooling_time_extra);
					//End of extra time

					//insert extra material
					if(isset($_POST['tooling_material_other']))
					{
						$extra_material_count = count($_POST['tooling_material_other']);

						foreach($_POST['tooling_material_other'] as $key => $value)
						{
							$extra_material_data = array(
														'quote_id' => $quote_id,
														'tooling_id' => $tooling_id,
														'material_name' => $this->input->post('tooling_material_other')[$key],
														'material_cost' => $this->input->post('tooling_material_other_value')[$key],
														'status' => "1",
														'date_created' => Date('Y-m-d')
													);
							$this->crud_model->insert('boss_tooling_extra',$extra_material_data);
						}
					}
					/*
						Insert into tooling accessories

						unit/hour want to check

						need to think
					*/
					$tooling_accessory_count = count($_POST['tooling_accessory_name']);
					for($ta=0 ; $ta < $tooling_accessory_count ; $ta++)
					{
						
							$tooling_accessories = array(
														'quote_id' => $quote_id,
														'tooling_id' => $tooling_id,
														'accessory_id' => $this->input->post('tooling_accessory_name')[$ta],
														'acc_cost' => $this->input->post('extra_cost')[$ta],
														'acc_qty' => $this->input->post('extra_qty')[$ta],
														'acc_total_cost' => $get_total_cost['accessory_cost'][$ta],
														'status' => "1",
														'date_created' => Date('Y-m-d')
													);
							//insert query here
							$this->crud_model->insert('boss_tooling_accessory',$tooling_accessories);
					}

					/*Insert into accessory extra*/
					if(isset($_POST['tooling_accessory_extra_name']))
					{
						$tooling_extra_accessory_count = count($this->input->post('tooling_accessory_extra_name'));
						foreach($_POST['tooling_accessory_extra_name'] as $key => $value)
						{
							$tooling_accessory_extra = array(
														'quote_id' => $quote_id,
														'tooling_id' => $tooling_id,
														'extra_acc_name' => $this->input->post('tooling_accessory_extra_name')[$key],
														'extra_acc_price' => $this->input->post('extra_accessory_cost')[$key],
														'extra_acc_qty' => $this->input->post('extra_accessory_qty')[$key],
														'extra_acc_total' => $get_total_cost['accessory_extra_cost'][$key]

														);
								$this->crud_model->insert('boss_tooling_accessory_extra',$tooling_accessory_extra);

						}
					}
					/*Update quote table here**/
					$multiple_quote_data = $get_total_cost['multiple_quote_ind_cost'];
                    if(!empty($multiple_quote_data)){
						foreach($multiple_quote_data as $key => $value)
						{
							$data_multiple_quote = array(
												'quote_id' => $this->input->post('quote_id'),
												'tooling_id' => $tooling_id,
												'quote_value' => $key,
												'quote_cost' => $value,
												'date_created' => Date('Y-m-d')
											);
							if($key=="other")
							{
								$multiple_qty = explode('*',$value);

								$data_multiple_quote['other_quote'] = $multiple_qty[1]; 
							}
							$this->crud_model->insert('boss_multiple_quotes',$data_multiple_quote);
						}
                    }
						/*Update quote table here**/
					if($this->input->post('tooling_status') == "tooling_update")
					{
						$update_quote_status = "1";
					}
					if($this->input->post('tooling_status') == "tooling_send_evaluation")
					{
						$update_quote_status = "2";
                                                 $data = get_tooling_email_data_csm($tooling_id);
			$message = $this->load->view('email_template/email_quote_cstm', $data, TRUE);

                        $data['show_approval'] = "1";
                        $message_pdf = $this->load->view('pdf_templates/pdf_quote_cstm', $data, TRUE);
                      //generate the PDF from the given html
	                 $this->m_pdf->pdf->WriteHTML($message_pdf);
	 
	               //download it.
	               
	 		$file_name  = "/".$quote_detail[0]['quote_ref'].$quote_ref;
	 		$path =APPPATH."quote_pdf".$file_name.".pdf";

	               //download it.
	                $this->m_pdf->pdf->Output($path,'F');
                       	$this->beamon_email->send_mail($this->config->item('from_email'),$this->config->item('to_email'),'New Quote',$message,'',$path);
					}
					if($this->input->post('tooling_status') == "tooling_send_final")
					{
						$update_quote_status = "3";
                                                $data = get_tooling_email_data_csm($tooling_id);
			                        $message = $this->load->view('email_template/email_quote_cstm', $data, TRUE); 

                                                $data['show_approval'] = "1";
                                                $message_pdf = $this->load->view('pdf_templates/pdf_quote_cstm', $data, TRUE);
                                                //generate the PDF from the given html
	                                        $this->m_pdf->pdf->WriteHTML($message_pdf);
	 
	                                       //download it.
	               
	 	                         	$file_name  = "/".$quote_detail[0]['quote_ref'].$quote_ref;
	 		                        $path =APPPATH."quote_pdf".$file_name.".pdf";

	                                       //download it.
	                                        $this->m_pdf->pdf->Output($path,'F');
                	                        $this->beamon_email->send_mail($this->config->item('from_email'),$this->config->item('to_email'),'New Quote',$message,'',$path);
					}

					/*UPDATE IN TOOLING TABLE*/
					$this->crud_model->update('boss_tooling',array('quote_status'=>$update_quote_status),array('tooling_id' => $tooling_id));

					$this->crud_model->update('boss_quotes',array('quote_status'=>$update_quote_status,'tooling_cost'=>$get_total_cost['total_calculation_after_pd']),array('id'=>$quote_id));
					/*Redirect from here*/
					redirect('quotes/quote_status');
		}
		else
		{
				if($this->input->post('tooling_status') == "tooling_update")
				{
					$update_quote_status = "1";
				}
				if($this->input->post('tooling_status') == "tooling_send_evaluation")
				{
					$update_quote_status = "2";
                                         $data = get_tooling_email_data_csm($id);
			$message = $this->load->view('email_template/email_quote_cstm', $data, TRUE);
                       
                        $data['show_approval'] = "1";
                        $message_pdf = $this->load->view('pdf_templates/pdf_quote_cstm', $data, TRUE);
                        //generate the PDF from the given html
	                 $this->m_pdf->pdf->WriteHTML($message_pdf);
	 
	               //download it.
	               
                        $quote_name = $this->crud_model->get_one('quote_ref','boss_quotes',array('id' => $this->input->post('quote_id')));
                       $quote_sub_ref = $this->crud_model->get_one('quote_ref_sub','boss_quotes',array('id' => $this->input->post('quote_id')));
	 		$file_name  = "/".$quote_name.$this->config->item('quote_ref_alp')[$quote_sub_ref];
	 		$path =APPPATH."quote_pdf".$file_name.".pdf";

	               //download it.
	                $this->m_pdf->pdf->Output($path,'F');
                       	$this->beamon_email->send_mail($this->config->item('from_email'),$this->config->item('to_email'),'New Quote',$message,'',$path);

				}
				if($this->input->post('tooling_status') == "tooling_send_final")
				{
					$update_quote_status = "3";
  $data = get_tooling_email_data_csm($id);
			$message = $this->load->view('email_template/email_quote_cstm', $data, TRUE);
                        $data['show_approval'] = "1";
                        $message_pdf = $this->load->view('pdf_templates/pdf_quote_cstm', $data, TRUE);

                         //generate the PDF from the given html
	                 $this->m_pdf->pdf->WriteHTML($message_pdf);
	 
	               //download it.
	               $quote_name = $this->crud_model->get_one('quote_ref','boss_quotes',array('id' => $this->input->post('quote_id')));
                       $quote_sub_ref = $this->crud_model->get_one('quote_ref_sub','boss_quotes',array('id' => $this->input->post('quote_id')));
	 		$file_name  = "/".$quote_name.$this->config->item('quote_ref_alp')[$quote_sub_ref];
	 		$path =APPPATH."quote_pdf".$file_name.".pdf";

	               //download it.
	                $this->m_pdf->pdf->Output($path,'F');
                       	$this->beamon_email->send_mail($this->config->item('from_email'),$this->config->item('to_email'),'New Quote',$message,'',$path);
				}

				/*UPDATE IN TOOLING TABLE*/
				$this->crud_model->update('boss_tooling',array('quote_status'=>$update_quote_status),array('tooling_id' => $id));

				$this->crud_model->update('boss_quotes',array('quote_status'=>$update_quote_status),array('id'=>$this->input->post('quote_id')));
				redirect('quotes/quote_status');	
		}
	}
}
	



}
