<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */

	public function __construct() {
        parent::__construct();
        $this->load->model('user_model');
    }

	public function index()
	{
		if($this->input->post())
		{	
		     $this->form_validation->set_rules('usr_logname', 'Username', 'trim|required');
                     $this->form_validation->set_rules('usr_logpwd', 'Password', 'trim|required');


                     if ($this->form_validation->run() == FALSE)
                     {
            	          $this->session->set_flashdata('response', error_msg('User Name and Password Field are required'));
            	          redirect('home');
                     }
                     else
                     {

                         	/*$data = $this->crud_model->get_row('boss_users',array('username' => $this->input->post('usr_logname'),'password' => md5($this->input->post('usr_logpwd')),'status' => "1",'usertype' => "user"));*/

                       $data = $this->crud_model_db2->get_row('tbl_user',array('usr_logname' => $this->input->post('usr_logname'),'usr_logpwd' => md5($this->input->post('usr_logpwd').":KabiCis4"),'usr_status' => "1"));


            	       if(!empty($data))
            	       {
	            	       $session_data = array(
							//'usertype'  => $data['usertype'],
                                                        'usertype'  => "user",
							'logged_in' => TRUE,
                                                        'user_name' => $data['usr_name']
					);

					$this->session->set_userdata($session_data);
	                      	redirect('dashboard');
                        }
                        else
                        {
                	   $this->session->set_flashdata('response', error_msg('Invalid User Name or Password.'));
            		   redirect('home');
                        }
                     }
		}

		$this->load->view('layouts/header_login.php');
		$this->load->view('login');
		$this->load->view('layouts/footer_login.php');
	}

	public function check_database($password) {
        //Field validation succeeded.  Validate against database
        $username = $this->input->post('usr_logname');

        //query the database
        $result = $this->user_model->login($username, $password);

        if ($result) {
            $sess_array = array();
            foreach ($result as $row) {
                $sess_array = array(
                    'id' => $row->usr_id,
                    'user_logname' => $row->usr_logname
                );

                $this->session->set_userdata('logged_in', $sess_array);
                $this->session->set_userdata('user_id', $row->usr_id);
                $this->session->set_userdata('userlogname', $row->usr_logname);
                $this->session->set_userdata('user_name', $row->usr_name);
                $this->session->set_userdata('user_mobile', $row->usr_mobile);
                $this->session->set_userdata('user_email', $row->usr_email);
                $this->session->set_userdata('user_designation', $row->usr_designation);
                $this->session->set_userdata('user_city', $row->usr_city);
                $this->session->set_userdata('profile_image', $row->usr_photo);
                $this->session->set_userdata('user_type', $row->usr_type);
            }
            return TRUE;
        } else {
            $this->form_validation->set_message('check_database', 'Invalid username or password');
            return false;
        }
    }


	public function logout()
	{
                $this->session->sess_destroy();
		redirect(base_url());
	}

    public function wims_login()
    {
        /*Set session user here*/
        $this->session->set_userdata('user_name', $this->input->post('username'));

        /*process the data and return quote id*/

        /*
            1.insert into quote table
            2. create table for stencil and insert into it
            3. check the tooling exist if exist enter into it
        */

        //check order id already exist
        $check_quote_exist = $this->crud_model->get('boss_quotes',array('wims_order_id' => $this->input->post('order_id')));

        if(empty($check_quote_exist))
        {
	        /*get the detail from the order table*/
	        $data_where = array('ord_id' => $this->input->post('order_id'));
	        $data_order = $this->crud_model->get('tbl_order',$data_where);

	        /*get the engineer and customer details from the order table*/
	        $data_engineer = $this->crud_model_db2->get('tbl_engineer',array('eng_id'=>$data_order[0]['eng_id']));

	        //insert into quote table

	        /*generate reference number*/
	        	$eng_id = $data_order[0]['eng_id'];
				$sql = "SELECT * FROM `boss_quotes` WHERE `quote_ref` LIKE '$eng_id%' AND `quote_ref_sub` = ''";
				$quote_count = $this->crud_model->get_count_by_sql($sql);
				$quote_count = $quote_count + 1;
				$quote_count_id = str_pad($quote_count, 3, '0', STR_PAD_LEFT);

				$quote_ref = $eng_id."tq".$quote_count_id;

	        $quote_data = array(
	        	            'quote_ref' => $quote_ref,
	                        'email_id' => $data_engineer[0]['eng_email'],
	                        'engineer_id' => $data_engineer[0]['eng_id'],
	                        'customer_id' =>  $data_order[0]['cust_id'],
	                        'assy_no' => "12345",
	                        'tooling_cont' => "1",
	                        'wims_order_id' => $this->input->post('order_id'),
	                        'date_created' => date('Y-m-d H:i:s')
	                     );
	        $quote_id = $this->crud_model->insert('boss_quotes',$quote_data);

	        /*check the stencil here*/
	        if($data_order[0]['spin_plate'] == "1")
	        {
	        	$spin_plate = $this->crud_model->get_one('id','boss_master_stencil_option',array('stencil-wims_name' =>"spin_plate"));
	        }

	        if($data_order[0]['epo_coat'] == "1")
	        {
	        	$epo_coat = $this->crud_model->get_one('id','boss_master_stencil_option',array('stencil-wims_name' =>"epo_coat"));
	        }


	        if($data_order[0]['film_plots'] == "1")
	        {
	        	$film_plots = $this->crud_model->get_one('id','boss_master_stencil_option',array('stencil-wims_name' =>"film_plots"));
	        }


	        /*fetch the detaials of coating and insert into the table*/
	        $stencil_data = array(
	        					'quote_id' => $quote_id,
	        					'stencil_type' => $data_order[0]['frm_size'],
	                            'lead_free_mark'  => $data_order[0]['lead_free_mark'],
								'design_for_no_clean' => $data_order[0]['design_for_no_clean'],
								'epo_coat'   => isset($epo_coat) ? $epo_coat : $data_order[0]['epo_coat'],
								'film_plots'  => isset($film_plots) ? $film_plots : $data_order[0]['film_plots'],
								'data_for_appr'  => $data_order[0]['data_for_appr'],
								'order_code' => $data_order[0]['order_code'],
								'p3_rpt' => $data_order[0]['p3_rpt'],
								'spin_plate' => isset($spin_plate) ? $spin_plate : $data_order[0]['spin_plate'],
								'inspect_template' => $data_order[0]['inspect_template'], 
								'fg_material'=> $data_order[0]['fg_material'],
								'tension' => $data_order[0]['tension'],
								'fixture_stencil'=> $data_order[0]['fixture_stencil'],
								'pickup_sample' => $data_order[0]['fixture_stencil'],
								'date_created' => date('Y-m-d')
	                        );
	        $stencil_id = $this->crud_model->insert('boss_stencil',$stencil_data);
	        echo $quote_id; 
	    }
	    else
	    {
	    	echo $check_quote_exist[0]['id'];
	    }
	}



	public function tooling_wims()
	{

		  $session_data = array(
							//'usertype'  => $data['usertype'],
                                                        'usertype'  => "user",
							'logged_in' => TRUE,
                                                        'user_name' => $this->input->post('username')
					);

					$this->session->set_userdata($session_data);
		  /*get the detail from the order table*/
	        $data_where = array('tjob_id' => $this->input->post('tooling_id'));
	        $data_order = $this->crud_model_db2->get('tbl_tooling_jobs',$data_where);

		// get engineer id
  
           $engineer_id_odr = $this->crud_model_db2->get_one('eng_id','tbl_order',array('ord_id' => $this->input->post('order_id')));

	        /*get the engineer and customer details from the order table*/
	        $data_engineer = $this->crud_model_db2->get('tbl_engineer',array('cust_id'=>$data_order[0]['cust_id'],'eng_id' => $engineer_id_odr));


             $cust_detail = $this->crud_model_db2->get_row('tbl_customer',array('cust_id' => $data_order[0]['cust_id']));
	        //insert into quote table

	        /*generate reference number*/
	        	$eng_id = $engineer_id_odr;
				$sql = "SELECT * FROM `boss_quotes` WHERE `quote_ref` LIKE '$eng_id%' AND `quote_ref_sub` = ''";
				$quote_count = $this->crud_model->get_count_by_sql($sql);
				$quote_count = $quote_count + 1;
				$quote_count_id = str_pad($quote_count, 3, '0', STR_PAD_LEFT);

				$quote_ref = $eng_id."tq".$quote_count_id;

	        $quote_data = array(          
	                        'wims_order_id' => $this->input->post('order_id'),
	                        'wims_tooling_id' => $this->input->post('tooling_id'),
	                        'quote_ref' => $quote_ref,
							'engineer_id' => $data_engineer[0]['eng_id'],
							'email_id' =>  $data_engineer[0]['eng_email'],
							'email_id_cc' => $data_engineer[0]['eng_email2'],
							'company_id' => $cust_detail['cust_name'],	
							'date_created' => Date('Y-m-d H:i:s'),
							'tooling_exist' => "1",
							'quote_status' 	=>"1",
							'quote_type'	=> "0",
							'status'	=> "0"
	                     );
	        $quote_id = $this->crud_model->insert('boss_quotes',$quote_data);

 			$return_data = array('quote_id' => $quote_id,'tooling_ref' => $data_order[0]['tjob_code']);
 

            echo json_encode($return_data);


	}

        public function update_quote_ref()
	{

		$data = $this->crud_model->get('boss_quotes');

		foreach ($data as $key => $value) {
			
			if($value['quote_ref_sub'] == "")
			{
				$this->crud_model->update('boss_quotes',array('quote_ref_wsub' => $value['quote_ref']),array('id' => $value['id']));
			}
			else
			{
				$quote_ref_value =  $value['quote_ref'].$this->config->item('quote_ref_alp')[$value['quote_ref_sub']];


				$this->crud_model->update('boss_quotes',array('quote_ref_wsub' => $quote_ref_value),array('id' => $value['id']));
			}

		}




	}

}