<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Stencil extends CI_Controller {
	public function __construct() {
        parent::__construct();
        if($this->session->userdata('user_type') != "admin")
	{
	    redirect("Welcome");
	}
        $this->load->helper('boss_helper');
        $this->load->dbforge();

    }
	public function index()
	{
		$where = array('status' => '1');
		$data['result'] = $this->crud_model->get('boss_master_stencil',$where);

		foreach ($data['result'] as $key => $value) {
			
			$data['result'][$key]['stencil_name']	= $this->crud_model_db2->get_one('sf_name','mst_stencil_format',array('sf_id' => $value['stencil_name'] ));

		}
		$breadcrumb['path_url'] = "List Stencil";
		$this->load->view('layout/header',$breadcrumb);
		$this->load->view('stencil/list_stencil',$data);
		$this->load->view('layout/footer');
	}

	/*function add stencil*/
	public function add_stencil()
	{
		if($this->input->post())
		{
			/*Validation*/
			$this->form_validation->set_rules('stencil_name','Stencil Name','required');
			$this->form_validation->set_rules('stencil_cost','Stencil Cost','required');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata('response',error_message(validation_errors()),':old:');
				redirect('tooling/add_material');
			}
			else
			{
				//check already assigned cost for stencil

				$stencil_exist_data = $this->crud_model->get('boss_master_stencil');
				foreach($stencil_exist_data as $value)
				{
					if($value['stencil_name'] == $this->input->post('stencil_name'))
					{
						$this->session->set_flashdata('response',error_message('Cost already added for this stencil'),':old:');
						redirect('stencil/add_stencil');
					}
				}
				$data = array(
							'stencil_name' => $this->input->post('stencil_name'),
							'stencil_description' => $this->input->post('stencil_description'),
							'stencil_cost' => $this->input->post('stencil_cost'),
							'date_created' => date('Y-m-d'),
							'status'	=> '1'
						);
				$this->crud_model->insert('boss_master_stencil',$data);
				$this->session->set_flashdata('response',success_message('Stencil Added succesfully'));
				redirect('stencil/index');
			}
		}
		$breadcrumb['path_url'] = "Add Stencil";
		$data['stencil_option'] = $this->crud_model_db2->get('mst_stencil_format');
		$this->load->view('layout/header',$breadcrumb);
		$this->load->view('stencil/add_stencil',$data);
		$this->load->view('layout/footer');
	}
	/*Edit Stencil*/
	public function edit_stencil($id=0)
	{
		if($this->input->post())
		{
			/*validation here*/
			$this->form_validation->set_rules('stencil_name','Stencil Name','required');
			$this->form_validation->set_rules('stencil_cost','Stencil Cost','required');

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata('response',error_message(validation_errors()),':old:');
				redirect('stencil/edit_stencil');
			}	
			else
			{
				$where = array('id' => $id);
				$data = array(
								'stencil_name' => $this->input->post('stencil_name'),
								'stencil_description' => $this->input->post('stencil_description'),
								'stencil_cost'	=> $this->input->post('stencil_cost')
							);

				$this->crud_model->update('boss_master_stencil',$data,$where);
				$this->session->set_flashdata('response',success_message('Stencil Updated succesfully'));
				redirect('stencil/index');
			}
		}

		//get the necessary record for the id and pass to edit view
		$data['get_record'] = $this->crud_model->get('boss_master_stencil',array('id' => $id));
		$data['stencil_option'] = $this->crud_model_db2->get('mst_stencil_format');
		$breadcrumb['path_url'] = "Edit Stencil";
		$this->load->view('layout/header',$breadcrumb);
		$this->load->view('stencil/edit_stencil',$data);
		$this->load->view('layout/footer');
	}
	/*Deleting Stencil*/
	public function delete_stencil($id=0)
	{
		$this->crud_model->delete('boss_master_stencil',array('id' => $id));
		$this->session->set_flashdata('response',error_message('Stencil Deleted succesfully'));
		redirect('stencil/index');
	}


	public function stencil_option()
	{
		$where = array('status' => '1');
		$data['result'] = $this->crud_model->get('boss_master_stencil_option',$where);

		$breadcrumb['path_url'] = "List Stencil Options";
		$this->load->view('layout/header',$breadcrumb);
		$this->load->view('stencil_option/list_stencil',$data);
		$this->load->view('layout/footer');
	}

	public function add_stencil_option()
	{
		$breadcrumb['path_url'] = "Add Stencil Option";
		$data['stencil_option'] = $this->crud_model->get('boss_master_stencil_option');
		$this->load->view('layout/header',$breadcrumb);
		$this->load->view('stencil_option/add_stencil',$data);
		$this->load->view('layout/footer');
	}
	public function edit_stencil_option($id=0)
	{
		if($this->input->post())
		{
			/*validation here*/
			$this->form_validation->set_rules('stencil_name','Stencil Name','required');
			$this->form_validation->set_rules('stencil_cost','Stencil Cost','required');

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata('response',error_message(validation_errors()),':old:');
				redirect('stencil/edit_stencil');
			}	
			else
			{
				$where = array('id' => $id);
				$data = array(
								'stencil_name' => $this->input->post('stencil_name'),
								'stencil_description' => $this->input->post('stencil_description'),
								'stencil_cost'	=> $this->input->post('stencil_cost')
							);

				$this->crud_model->update('boss_master_stencil',$data,$where);
				$this->session->set_flashdata('response',success_message('Stencil Updated succesfully'));
				redirect('stencil/index');
			}
		}

		//get the necessary record for the id and pass to edit view
		$data['stencil_option'] = $this->crud_model->get('boss_master_stencil_option');
		$breadcrumb['path_url'] = "Edit Stencil Option";
		$this->load->view('layout/header',$breadcrumb);
		$this->load->view('stencil_option/edit_stencil',$data);
		$this->load->view('layout/footer');
	}
	public function delete_stencil_option($id=0)
	{

	}

	public function cost_settings()
	{

		$data['records'] = $this->crud_model_db2->get('tbl_customer');

		$check_exist = $this->crud_model->get('boss_stencil_option_v2');




		$data['check_user'] = array();

		foreach ($check_exist as $key => $value) 
		{
			array_push($data['check_user'], $value['customer_id']);
		}

		//get the dynamic field list
		$get_fields = $this->crud_model->get('boss_master_dynamic_menu');

		$data['fetch_records'] = array();

		foreach ($get_fields as $key => $value) 
		{

			$get_options = $this->crud_model->get('boss_dynamic_option',array('menu_id' => $value['id']));

			$data['fetch_records'][$value['menu_name']] = $get_options;
			
		}


		$breadcrumb['path_url'] = "Add Stencil Option";
		$this->load->view('layout/header',$breadcrumb);
		$this->load->view('stencil/add_cost',$data);
		$this->load->view('layout/footer');
	}


	public function customer_stencil_list()
	{

		$this->db->select('*');
		$this->db->from('boss_stencil_option_v2');
		
		$query = $this->db->get();

        $data['result'] =  $query->result_array();
	
		$data['menu'] = $this->crud_model->get('boss_dynamic_option');
        

/*echo "<pre>"; print_r($data); exit;
*/		
                $breadcrumb['path_url'] = "List Stencil Customer";
		$this->load->view('layout/header',$breadcrumb);
		$this->load->view('stencil/list_stencil_customer',$data);
		$this->load->view('layout/footer');

	}


	public function customer_stencil_edit($id=0)
	{
	
		$data['value_exist'] =  $this->crud_model->get_row('boss_stencil_option_v2',array('customer_id' => $id));


		//get the dynamic field list
		$get_fields = $this->crud_model->get('boss_master_dynamic_menu');

		$data['fetch_records'] = array();

		foreach ($get_fields as $key => $value) {

			$get_options = $this->crud_model->get('boss_dynamic_option',array('menu_id' => $value['id']));

			$data['fetch_records'][$value['menu_name']] = $get_options;
			
		}



        $breadcrumb['path_url'] = "Edit Stencil Cost";
		$this->load->view('layout/header',$breadcrumb);
		$this->load->view('stencil/edit_cost',$data);
		$this->load->view('layout/footer');

	}


	public function update_stencil_customer_cost($id=0)
	{

		/*$insert_first = array(
					'20*20_laser_cut' => $this->input->post('frame_20_20'),
					'29*29_laser_cut' => $this->input->post('frame_29_29'),
					'737*850_laser_cut' => $this->input->post('737*850_laser_cut'),
					'737*980_laser_cut' => $this->input->post('737*980_laser_cut'),
					'850*980_laser_cut' => $this->input->post('850*980_laser_cut'),
					'29*40_laser_cut' => $this->input->post('29*40_laser_cut'),
					'fuji_4000' => $this->input->post('fuji_4000'),
					'fuji_5000' => $this->input->post('fuji_5000'),
					'31*32*15_laser_cut' => $this->input->post('frame_31_32'),
					'custom_frame' => $this->input->post('custom_frame'),
                   );

		$this->crud_model->update('boss_master_cost_frame',$insert_first,array('customer_id' => $id));



		$insert_second =  array(
								'step_down' =>  $this->input->post('step_down'),
								'step_down_db' => $this->input->post('step_down_db'),
								'back_etch' => $this->input->post('back_etch'),
								'wizard_foil' => $this->input->post('wizard_foil'),
								'zelflex_foil' => $this->input->post('zelflex_foil'),
								'airframe_foil' => $this->input->post('airframe_foil'),
								'universal_foil' => $this->input->post('universal_foil'),
								'foil_other' => $this->input->post('foil_other'),
								'epocoat' => $this->input->post('epocoat'),
								'electro_polish' => $this->input->post('electro_polish'),
								'nano_coat' => $this->input->post('nano_coat'),
								'fg_material' => $this->input->post('fg_material'),
								'film_plots' => $this->input->post('film_plots'),
								'spin_plate' => $this->input->post('spin_plate'),
								'inspection_template' => $this->input->post('inspection_template'),
								'fix_it' => $this->input->post('fix_it'),
								'hot_jobs' => $this->input->post('hot_jobs'),
								'2_mil_foil' => $this->input->post('2_mil_foil'),
								'step_repeat_sample' => $this->input->post('step_repeat_sample'),
								'high_cut' => $this->input->post('high_cut'),
								'ec_1_hour' => $this->input->post('ec_1_hour'),
								'scaling' => $this->input->post('scaling'),
								'remount' => $this->input->post('remount'),
								'type_1' => $this->input->post('type_1'),
								'type_2' => $this->input->post('type_2'),
								'type_3' => $this->input->post('type_3'),
								'type_3_above_3' => $this->input->post('type_3_above_3'),
								'reball_full_set' => $this->input->post('reball_full_set'),
								'reball_full_set_popup_insert' => $this->input->post('reball_full_set_popup_insert'),
								'reball_replacement_set' => $this->input->post('reball_replacement_set'),
								'reball_replacement_with_backetch' => $this->input->post('reball_replacement_with_backetch'),
								'reball_replacement_popup_insert' => $this->input->post('reball_replacement_popup_insert'),
								'reball_replacement_with_extra_pin' => $this->input->post('reball_replacement_with_extra_pin'),
								'reball_replacement_set_additional_set' => $this->input->post('reball_replacement_set_additional_set'),
								'reball_print_foil' => $this->input->post('reball_print_foil'),
								'reball_print_foil_backetch' => $this->input->post('reball_print_foil_backetch'),
								'reball_ball_foil' => $this->input->post('reball_ball_foil'),
								'reball_ball_foil_with_spacer' => $this->input->post('reball_ball_foil_with_spacer'),
								'reball_insert_only' =>$this->input->post('reball_insert_only'),
								'reball_insert_popup' => $this->input->post('reball_insert_popup'),
								'reball_insert_4up' => $this->input->post('reball_insert_4up'),
								'reball_insert_duro' => $this->input->post('reball_insert_4up'),
								'reball_frame' => $this->input->post('reball_frame'),
								'reball_base_only' => $this->input->post('reball_base_only'),
								'printpart_full_set' => $this->input->post('printpart_full_set'),
								'printpart_replacement_set' => $this->input->post('printpart_replacement_set'),
								'printpart_additional_frame' => $this->input->post('printpart_additional_frame'),
								'printpart_additional_base' => $this->input->post('printpart_additional_base'),
								'printpart_print_foil' => $this->input->post('printpart_print_foil'),
								'nozzle_straight' => $this->input->post('nozzle_straight'),
								'nozzle_small_tapered' => $this->input->post('nozzle_small_tapered'),
								'nozzle_step' => $this->input->post('nozzle_step'),
						);
*/

	    $insert_data  = $this->input->post();


		//$insert_data_last = array_pop($insert_data);	


		$this->db->update('boss_stencil_option_v2',$insert_data,array('customer_id' => $id));


		$this->session->set_flashdata('response',success_message("Customer Cost Updated Successfully"));
		redirect('Stencil/customer_stencil_list');
	}




	public function stencil_cost()
	{

		$insert_data  = $this->input->post();


		$insert_data_last = array_pop($insert_data);

		$id = $this->db->insert('boss_stencil_option_v2',$insert_data);
		$this->session->set_flashdata('response',success_message("Customer Cost Inserted Successfully"));
		redirect('Stencil/customer_stencil_list');
	}



	/* Add Stencil **/

	public function add_menu()
	{

		if($this->input->post())
	 	{

	 		//check whether manu name is already exist in the DB

	 		$check_exist = $this->crud_model->get_row('boss_master_dynamic_menu',array('menu_name' => $this->input->post('stencil_name')));

	 		if(empty($check_exist))
	 		{
		 		$data_insert = array(
		 							'menu_name' => $this->input->post('stencil_name'),
		 							'status' => "1",
		 							'sort_order' => $this->input->post('sort_order'),
		 							'date_created' => date('Y-m-d'),
		 						);

		 		$this->crud_model->insert('boss_master_dynamic_menu',$data_insert);
		 		redirect('Stencil/list_menu');
		 	}
		 	else
		 	{
		 		$this->session->set_flashdata('response',error_message("Name Already Exist"));
				redirect('Stencil/add_menu');
		 	}

	 	}


	 	$breadcrumb['path_url'] = "Add Stencil Menu";
		$this->load->view('layout/header',$breadcrumb);
		$this->load->view('stencil/add_menu_stencil',$data);
		$this->load->view('layout/footer');

	}

	public function list_menu()
	{

		$data['result'] = $this->crud_model->get('boss_master_dynamic_menu',array('status' => "1"));

		$breadcrumb['path_url'] = "List Menu";
		$this->load->view('layout/header',$breadcrumb);
		$this->load->view('stencil/list_menu_stencil',$data);
		$this->load->view('layout/footer');
	}

	public function edit_menu($id)
	{

		if($this->input->post())
		{
			$data_update = array(
	 							'menu_name' => $this->input->post('stencil_name'),
	 							'status' => "1",
	 							'sort_order' => $this->input->post('sort_order'),
	 						);

	 		$this->crud_model->update('boss_master_dynamic_menu',$data_update,array('id' => $id));
	 		redirect('Stencil/list_menu');

		}


		$data['record'] = $this->crud_model->get_row('boss_master_dynamic_menu',array('id' => $id));

		$breadcrumb['path_url'] = "Edit Menu";
		$this->load->view('layout/header',$breadcrumb);
		$this->load->view('stencil/edit_menu_stencil',$data);
		$this->load->view('layout/footer');

	}

	public function delete_menu($id)
	{
		$this->crud_model->delete('boss_master_dynamic_menu',array('id' => $id));
		redirect('Stencil/list_menu');

	}



	/* Dynamic options*/


	public function add_dynamic_option()
	{
		if($this->input->post())
	 	{

	 		//check option name and menu already exist

	 		$check_option_name = $this->crud_model->get_row('boss_dynamic_option',array('option_name' => $this->input->post('option_name')));

	 		$check_field_name =  $this->crud_model->get_row('boss_dynamic_option',array('field_name' => $this->input->post('option_field_name')));

	 		if(empty($check_option_name) && empty($check_field_name))
	 		{
		 		$data_insert = array(
		 							'option_name' => $this->input->post('option_name'),
		 							'menu_id' => $this->input->post('menu_id'),
		 							'field_name' =>str_replace(' ', '_', $this->input->post('option_field_name')),
		 							'status' => "1",
		 							'date_created' => date('Y-m-d'),
		 						);


                                if($this->input->post('menu_id') == "2" || $this->input->post('menu_id') == "4" || $this->input->post('menu_id') == "5" || $this->input->post('menu_id') == "6" || $this->input->post('menu_id') == "7")
                                {
                                    $data_insert['stencil_type'] = "1";
                                }

		 		$this->crud_model->insert('boss_dynamic_option',$data_insert);

		 		

		 		$fields = array(
	                    $data_insert['field_name'] => array('type' => 'FLOAT','default' => '0',)
	             );


				$this->dbforge->add_column('boss_stencil_option_v2', $fields);

		 		redirect('Stencil/list_dynamic_option');
		 	}
		 	else
		 	{
		 		$this->session->set_flashdata('response',error_message("Field Name or Option Name already Exist"));
				redirect('Stencil/add_dynamic_option');
		 	}

	 	}

	 	$data['record'] = $this->crud_model->get('boss_master_dynamic_menu');


	 	$breadcrumb['path_url'] = "Add Stencil Menu";
		$this->load->view('layout/header',$breadcrumb);
		$this->load->view('stencil/add_dynamic_option',$data);
		$this->load->view('layout/footer');
	}


	public function list_dynamic_option()
	{

		$data['result'] = $this->crud_model->get('boss_dynamic_option',array('status' => "1"));


		$breadcrumb['path_url'] = "List Dynamic Option";
		$this->load->view('layout/header',$breadcrumb);
		$this->load->view('stencil/list_dynamic_option',$data);
		$this->load->view('layout/footer');
	}


	public function edit_dynamic_option($id=0)
	{

     	if($this->input->post())
		{
			$data_update = array(
	 							'option_name' => $this->input->post('option_name'),
	 							'menu_id' => $this->input->post('menu_id'),
	 							'status' => "1",
	 						);
                         if($this->input->post('menu_id') == "2" || $this->input->post('menu_id') == "4" || $this->input->post('menu_id') == "5" || $this->input->post('menu_id') == "6" || $this->input->post('menu_id') == "7")
                         {
                                    $data_update['stencil_type'] = "1";
                         }


	 		$this->crud_model->update('boss_dynamic_option',$data_update,array('id' => $id));
	 		redirect('Stencil/list_dynamic_option');

		}


		$data['record'] = $this->crud_model->get_row('boss_dynamic_option',array('id' => $id));
	 	$data['record_menu'] = $this->crud_model->get('boss_master_dynamic_menu');


		$breadcrumb['path_url'] = "Edit Menu";
		$this->load->view('layout/header',$breadcrumb);
		$this->load->view('stencil/edit_dynamic_option',$data);
		$this->load->view('layout/footer');
	}


	public function delete_dynamic_option($id=0)
	{

		$get_name = $this->crud_model->get_row('boss_dynamic_option',array('id' => $id));
		$this->crud_model->delete('boss_dynamic_option',array('id' => $id));

		$this->dbforge->drop_column('boss_stencil_option_v2', $get_name['field_name']);

		redirect('Stencil/list_dynamic_option');

	}
}