<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Hardware extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	public function index()
	{
		if($this->session->userdata('user_type') != "admin")
		{
			redirect("Welcome");
		}

		$data['result'] = $this->crud_model->get('boss_master_hardware_cost');
 		$breadcrumb['path_url'] = "List Hardware";
		$this->load->view('layout/header',$breadcrumb);
		$this->load->view('hardware/list_hardware',$data);
		$this->load->view('layout/footer');
	}


	public function add_hardware()
	{
		$data['result'] = $this->crud_model->get('boss_master_hardware_cost');
 		$breadcrumb['path_url'] = "Edit Hardware";
		$this->load->view('layout/header',$breadcrumb);
		$this->load->view('hardware/add_hardware',$data);
		$this->load->view('layout/footer');

	}

	public function add_hardware_action()
	{
		$data = array(
						'hardware_name' => $this->input->post('hardware_name'),
						'cost_per_unit' => $this->input->post('hardware_cost'),
						'description' => $this->input->post('hardware_description'),
						'comment' => $this->input->post('hardware_comment'),
						'status' => "1",
						'date_created' => date('Y-m-d')

					);

		$this->crud_model->insert('boss_master_hardware_cost',$data);

		redirect('hardware/index');

	}


	public function edit_hardware($id=0)
	{
		$data['result'] = $this->crud_model->get_row('boss_master_hardware_cost',array('id'=>$id));
 		$breadcrumb['path_url'] = "Edit Hardware";
		$this->load->view('layout/header',$breadcrumb);
		$this->load->view('hardware/edit_hardware',$data);
		$this->load->view('layout/footer');

	}


	public function edit_hardware_action($id=0)
	{
		$data = array(
						'hardware_name' => $this->input->post('hardware_name'),
						'cost_per_unit' => $this->input->post('hardware_cost'),
						'description' => $this->input->post('hardware_description'),
						'comment' => $this->input->post('hardware_comment'),
						'status' => "1",
						'date_created' => date('Y-m-d')

					);
		$this->crud_model->update('boss_master_hardware_cost',$data,array('id' => $id));

		redirect('hardware/index');
	}


	public function delete_hardware($id=0)
	{

			$this->crud_model->delete('boss_master_hardware_cost',array('id'=>$id));
			redirect('hardware/index');

	}

	
}
